/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.model.SpaceAccessModel;
import de.viadee.confluence.enterprisecore.rest.SpaceAccessResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/spaces")
@AnonymousAllowed
@AnonymousSiteAccess
public class SpaceAccessController {
    public static final String PATH = "/spaces";
    private final SpaceAccessResource spaceAccessResource;
    private final AuthValidator authValidator;

    @Inject
    public SpaceAccessController(SpaceAccessResource spaceAccessResource, AuthValidator authValidator) {
        this.spaceAccessResource = spaceAccessResource;
        this.authValidator = authValidator;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAllWhitelistedSpaces(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.spaceAccessResource.getAllWhitelistedSpaces();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{key}")
    public Response isSpaceInWhitelistedSpaces(@Context HttpServletRequest request, @PathParam(value="key") String spaceKey) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        return this.spaceAccessResource.isSpaceInWhitelistedSpaces(spaceKey);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addSpaceToWhiteList(@Context HttpServletRequest request, SpaceAccessModel space) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.spaceAccessResource.addSpaceToWhitelist(space);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{key}")
    public Response removeSpaceFromWhitelistByKey(@Context HttpServletRequest request, @PathParam(value="key") String spaceKey) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.spaceAccessResource.removeSpaceFromWhitelistByKey(spaceKey);
    }
}

