/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import de.viadee.confluence.enterprisecore.model.ProcessNetNodeModel;
import de.viadee.confluence.enterprisecore.rest.ProcessNetPositionResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Path(value="/processNetPositions")
@AnonymousSiteAccess
public class ProcessNetPositionController {
    private static final int PAGINATION_LIMIT = 200;
    private final ProcessNetPositionResource processNetPositionResource;
    private final AuthValidator authValidator;

    @Inject
    public ProcessNetPositionController(ProcessNetPositionResource processNetPositionResource, AuthValidator authValidator) {
        this.processNetPositionResource = processNetPositionResource;
        this.authValidator = authValidator;
    }

    @PUT
    @Path(value="/{pageId}/{processNetId}")
    @Consumes(value={"application/json; charset=utf-8"})
    public Response addOrUpdatePositions(@Context HttpServletRequest request, @PathParam(value="pageId") Long pageId, @PathParam(value="processNetId") String processNetId, List<ProcessNetNodeModel> processNetNodeModels) {
        this.authValidator.createContext(request).checkAuthentication().checkPagePermission(pageId.longValue(), Permission.EDIT);
        return this.processNetPositionResource.addOrUpdatePositions(processNetId, processNetNodeModels);
    }

    @GET
    @Path(value="/{pageId}/{processNetId}")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getPositions(@Context HttpServletRequest request, @PathParam(value="pageId") Long pageId, @PathParam(value="processNetId") String processNetId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        this.authValidator.createContext(request).checkAuthentication().checkPagePermission(pageId.longValue(), Permission.VIEW);
        if (start == null) {
            start = 0;
        }
        if (limit == null || limit > 200) {
            limit = 200;
        }
        return this.processNetPositionResource.getPositions(processNetId, start.intValue(), limit.intValue());
    }
}

