/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.BpmnElementsGlobalConfigService;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Map;

@Path(value="/bpmnElementsGlobalConfig")
@AnonymousSiteAccess
public class BpmnElementsGlobalConfigController {
    private final AuthValidator authValidator;
    private final BpmnElementsGlobalConfigService bpmnElementsConfigService;

    @Inject
    public BpmnElementsGlobalConfigController(AuthValidator authValidator, BpmnElementsGlobalConfigService bpmnElementsConfigService) {
        this.authValidator = authValidator;
        this.bpmnElementsConfigService = bpmnElementsConfigService;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response saveBpmnElementsConfig(@Context HttpServletRequest request, Map<String, Boolean> config) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        this.bpmnElementsConfigService.saveBpmnElementsConfig(config);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response deleteBpmnElementsConfig(@Context HttpServletRequest request, @QueryParam(value="bpmnElementsGroup") String bpmnElementsGroup) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        this.bpmnElementsConfigService.deleteBpmnElementsConfig(bpmnElementsGroup);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getBpmnElementsConfig(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkAuthentication();
        return Response.ok((Object)this.bpmnElementsConfigService.getBpmnElementsConfig()).build();
    }
}

