/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.rest.ViewAppConfigResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="/viewConfig")
@AnonymousSiteAccess
public class ViewAppConfigController {
    private final ViewAppConfigResource viewAppConfigResource;
    private final AuthValidator authValidator;

    @Inject
    public ViewAppConfigController(ViewAppConfigResource viewAppConfigResource, AuthValidator authValidator) {
        this.viewAppConfigResource = viewAppConfigResource;
        this.authValidator = authValidator;
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(@Context HttpServletRequest request, AppConfigResource.ViewConfig config) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.viewAppConfigResource.putConfig(config);
    }
}

