/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import de.viadee.confluence.enterprisecore.model.SettingsModel;
import de.viadee.confluence.enterprisecore.rest.SettingsResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="/settings")
@AnonymousSiteAccess
public class SettingsController {
    public static final String PATH = "/settings";
    private final SettingsResource settingsResource;
    private final AuthValidator authValidator;

    @Inject
    public SettingsController(SettingsResource settingsResource, AuthValidator authValidator) {
        this.settingsResource = settingsResource;
        this.authValidator = authValidator;
    }

    @GET
    @Produces(value={"application/json"})
    public Response isRestricted(@Context HttpServletRequest request) {
        return this.settingsResource.isRestricted();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response update(@Context HttpServletRequest request, SettingsModel settings) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.settingsResource.update(settings);
    }

    @GET
    @Path(value="/canEdit/{pageId}")
    @Produces(value={"application/json"})
    public Response canEdit(@PathParam(value="pageId") String pageId) {
        return this.settingsResource.canEdit(pageId);
    }
}

