/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.actions;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceAdminAction;
import de.viadee.confluence.enterprisecore.action.SpaceAdminPageActionService;
import de.viadee.confluence.enterprisecore.model.Nonce;
import de.viadee.confluence.enterprisecore.service.SpaceConfigurationService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;

public class SpaceAdminPageAction
extends SpaceAdminAction {
    private static final String webResourceKey = "de.viadee.confluence.bpmn-plugin-enterprise.space-admin-page";
    private static final String pluginShorthand = "BPMN";
    private static final String pluginKey = "de.viadee.confluence.bpmn-plugin-enterprise";
    private final SpaceConfigurationService spaceConfigurationService;
    private String cspNonce;
    private Map<String, String> validationValues;
    private Map<String, String> bpmnElementsOptions;
    private Map<String, String[]> bpmnElementsOptionsGroups;
    private Map<String, String> bpmnElementsToIcons;
    private Map<String, Boolean> camundaPanelVersionValues;

    public SpaceAdminPageAction(SpaceConfigurationService spaceConfigurationService) {
        this.spaceConfigurationService = spaceConfigurationService;
    }

    public String execute() {
        HttpServletRequest request = this.getCurrentRequest();
        if (request == null) {
            return "error";
        }
        this.cspNonce = new Nonce(request).getValue();
        Space space = this.getSpace();
        if (space == null) {
            return "error";
        }
        SpaceAdminPageActionService spaceAdminPageActionService = new SpaceAdminPageActionService(this.spaceConfigurationService, space.getKey());
        String action = spaceAdminPageActionService.execute();
        this.validationValues = spaceAdminPageActionService.getValidationValues();
        this.bpmnElementsOptions = spaceAdminPageActionService.getBpmnElementsConfigChecked();
        this.bpmnElementsOptionsGroups = spaceAdminPageActionService.getBpmnElementsConfigGroups();
        this.bpmnElementsToIcons = spaceAdminPageActionService.getBpmnElementsToIcons();
        this.camundaPanelVersionValues = spaceAdminPageActionService.getCamundaPanelVersionValues();
        return action;
    }

    public static String getPluginShorthand() {
        return pluginShorthand;
    }

    public static String getPluginKey() {
        return pluginKey;
    }

    public String getWebResourceKey() {
        return webResourceKey;
    }

    @Generated
    public SpaceConfigurationService getSpaceConfigurationService() {
        return this.spaceConfigurationService;
    }

    @Generated
    public String getCspNonce() {
        return this.cspNonce;
    }

    @Generated
    public Map<String, String> getValidationValues() {
        return this.validationValues;
    }

    @Generated
    public Map<String, String> getBpmnElementsOptions() {
        return this.bpmnElementsOptions;
    }

    @Generated
    public Map<String, String[]> getBpmnElementsOptionsGroups() {
        return this.bpmnElementsOptionsGroups;
    }

    @Generated
    public Map<String, String> getBpmnElementsToIcons() {
        return this.bpmnElementsToIcons;
    }

    @Generated
    public Map<String, Boolean> getCamundaPanelVersionValues() {
        return this.camundaPanelVersionValues;
    }
}

