/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.rest.vcs.GithubResource;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="/github")
@AnonymousSiteAccess
public class GithubController {
    private final GithubResource githubResource;

    @Inject
    public GithubController(GithubResource githubResource) {
        this.githubResource = githubResource;
    }

    @GET
    @Path(value="/isConfigured")
    @Produces(value={"application/json"})
    public Response isGitHubConfigured() {
        return this.githubResource.isGitHubConfigured();
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig(@Context HttpServletRequest request) {
        return this.githubResource.getConfig(request);
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(@Context HttpServletRequest request, AppConfigResource.Config config) {
        return this.githubResource.putConfig(request, config);
    }

    @DELETE
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response deleteConfig(@Context HttpServletRequest request) {
        return this.githubResource.deleteConfig(request);
    }

    @GET
    @Path(value="/oauth/test")
    @Produces(value={"text/plain"})
    public Response testOAuthLoginUrl() {
        return this.githubResource.getOAuthUserLoginUrl(Boolean.valueOf(true));
    }

    @GET
    @Path(value="/oauth")
    @Produces(value={"text/plain"})
    public Response getOAuthLoginUrl() {
        return this.githubResource.getOAuthUserLoginUrl(Boolean.valueOf(false));
    }

    @GET
    @Path(value="/oauth/redirect")
    @Produces(value={"text/plain; charset=UTF-8"})
    public Response endOAuthLogin(@QueryParam(value="code") String code, @QueryParam(value="state") String state) {
        return this.githubResource.endOAuthLogin(code, state);
    }

    @GET
    @Path(value="/projects/search")
    @Produces(value={"application/json"})
    public Response getGitHubProjectsWithUrl(@QueryParam(value="containedString") String containedString) {
        return this.githubResource.getGitHubProjectsWithUrl(containedString);
    }

    @GET
    @Path(value="/branches")
    @Produces(value={"application/json"})
    public Response getGitHubBranches(@QueryParam(value="repoPath") String repoPath) {
        return this.githubResource.getGitHubBranches(repoPath);
    }

    @GET
    @Path(value="/branch/files")
    @Produces(value={"application/json"})
    public Response getGitHubFilesInBranch(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="ref") String ref, @QueryParam(value="fileEnding") String fileEnding) {
        return this.githubResource.getFilesInBranchOrTag(repoPath, ref, fileEnding);
    }

    @GET
    @Path(value="/tags")
    @Produces(value={"application/json"})
    public Response getGitHubTags(@QueryParam(value="repoPath") String repoPath) {
        return this.githubResource.getGitHubTags(repoPath);
    }

    @GET
    @Path(value="/tag/files")
    @Produces(value={"application/json"})
    public Response getGitHubFilesInTag(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="ref") String ref, @QueryParam(value="fileEnding") String fileEnding) {
        return this.githubResource.getFilesInBranchOrTag(repoPath, ref, fileEnding);
    }

    @GET
    @Path(value="/commit")
    @Produces(value={"application/json"})
    public Response getLatestCommitForFile(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="ref") String ref, @QueryParam(value="filePath") String filePath) {
        return this.githubResource.getLatestCommitForFile(repoPath, ref, filePath);
    }

    @GET
    @Path(value="/fileContent")
    @Produces(value={"application/xml"})
    public Response getGitHubFileContent(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="filePath") String filePath, @QueryParam(value="ref") String ref) {
        return this.githubResource.getGitHubFileContent(repoPath, filePath, ref);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/branch/create")
    public Response createNewGitHubBranch(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="newBranch") String newBranchName, @QueryParam(value="sha") String shaToBranchFrom) {
        return this.githubResource.createNewGitHubBranch(repoPath, newBranchName, shaToBranchFrom);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/branch")
    public Response deleteRef(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="branch") String branchName) {
        return this.githubResource.deleteRef(repoPath, branchName);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/file")
    public Response updateOrCreateFile(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="filePath") String filePath, String encodedFileWithParamsAsJsonBody) {
        return this.githubResource.updateOrCreateFile(repoPath, filePath, encodedFileWithParamsAsJsonBody);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/mergerequest/new")
    public Response createNewMRinGitHub(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="base") String baseBranchName, @QueryParam(value="head") String headBranchName, @QueryParam(value="title") String title, @QueryParam(value="modeler") String modeler) {
        return this.githubResource.createNewMRinGitHub(repoPath, baseBranchName, headBranchName, title, modeler);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/mergerequest/accept")
    public Response acceptMergeRequestById(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="pullNumber") int pullNumber) {
        return this.githubResource.acceptMergeRequestById(repoPath, pullNumber);
    }
}

