/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.BpmnElementsGlobalConfigService;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/bpmnElementsGlobalConfig")
@AnonymousAllowed
@AnonymousSiteAccess
public class BpmnElementsGlobalConfigController {
    private final AuthValidator authValidator;
    private final BpmnElementsGlobalConfigService bpmnElementsConfigService;

    @Inject
    public BpmnElementsGlobalConfigController(AuthValidator authValidator, BpmnElementsGlobalConfigService bpmnElementsConfigService) {
        this.authValidator = authValidator;
        this.bpmnElementsConfigService = bpmnElementsConfigService;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response saveBpmnElementsConfig(@Context HttpServletRequest request, Map<String, Boolean> config) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        this.bpmnElementsConfigService.saveBpmnElementsConfig(config);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response deleteBpmnElementsConfig(@Context HttpServletRequest request, @QueryParam(value="bpmnElementsGroup") String bpmnElementsGroup) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        this.bpmnElementsConfigService.deleteBpmnElementsConfig(bpmnElementsGroup);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getBpmnElementsConfig(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkAuthentication();
        return Response.ok((Object)this.bpmnElementsConfigService.getBpmnElementsConfig()).build();
    }
}

