/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import de.viadee.confluence.enterprisecore.model.DiagramTypeEnum;
import de.viadee.confluence.enterprisecore.rest.DiagramsResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="/diagrams")
@AnonymousSiteAccess
public class DiagramsController {
    private static final int PAGINATION_LIMIT = 20;
    private final AuthValidator authValidator;
    private final DiagramsResource diagramsResource;

    @Inject
    public DiagramsController(AuthValidator authValidator, DiagramsResource diagramsResource) {
        this.authValidator = authValidator;
        this.diagramsResource = diagramsResource;
    }

    @GET
    @Path(value="/search/space/{spaceKey}")
    @Produces(value={"application/json"})
    public Response getDiagramsForSpace(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey, @QueryParam(value="start") int start) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        DiagramTypeEnum[] diagramTypes = DiagramTypeEnum.getEnterprise();
        return this.diagramsResource.findDiagramsInSpace(request, spaceKey, start, 20, diagramTypes);
    }

    @GET
    @Path(value="/search/page/{pageId}")
    @Produces(value={"application/json"})
    public Response getDiagramsForPageTree(@Context HttpServletRequest request, @PathParam(value="pageId") Long pageId, @QueryParam(value="start") int start) {
        this.authValidator.createContext(request).checkAuthentication().checkPagePermission(pageId.longValue(), Permission.VIEW);
        DiagramTypeEnum[] diagramTypes = DiagramTypeEnum.getEnterprise();
        return this.diagramsResource.findDiagramsByRootPage(request, pageId, start, 20, diagramTypes);
    }
}

