/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.exceptions.AccessDeniedException;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.rest.CloudMigrationResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.util.HttpMessageEntity;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/cloud-migration")
@AnonymousAllowed
@AnonymousSiteAccess
public class CloudMigrationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudMigrationController.class);
    private final AuthValidator authValidator;
    private final CloudMigrationResource cloudMigrationResource;

    @Inject
    public CloudMigrationController(CloudMigrationResource cloudMigrationResource, AuthValidator authValidator, IPluginService pluginService) {
        this.cloudMigrationResource = cloudMigrationResource;
        this.authValidator = authValidator;
    }

    @GET
    @Path(value="/page-info/export")
    @Produces(value={"application/json"})
    public Response exportPageInfo(@Context HttpServletRequest request, @QueryParam(value="nextStart") String nextStart, @QueryParam(value="workerCount") String workerCount) {
        try {
            this.authValidator.createContext(request).checkConfluenceAdminStatus();
            int nextStartInt = Integer.parseInt(nextStart);
            int workerCountInt = Integer.parseInt(workerCount);
            if (nextStartInt < 0 || workerCountInt <= 0) {
                String msg = String.format("Invalid parameters: nextStart=%s, workerCount=%s", nextStart, workerCount);
                HttpMessageEntity errorMsg = new HttpMessageEntity(msg);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMsg.toJson()).build();
            }
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            return this.cloudMigrationResource.pageInfoPartExport(confluenceUser, nextStartInt, workerCountInt);
        }
        catch (NumberFormatException e) {
            String msg = String.format("Invalid number format for nextStart or workerCount: %s, %s", nextStart, workerCount);
            log.error(msg, (Throwable)e);
            HttpMessageEntity errorMsg = new HttpMessageEntity(msg);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMsg.toJson()).build();
        }
        catch (AccessDeniedException e) {
            log.warn("Access denied for resource /cloud-migration/page-info/export", (Throwable)e);
            HttpMessageEntity errorMsg = new HttpMessageEntity(e.getMessage());
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errorMsg.toJson()).build();
        }
        catch (Exception e) {
            String msg = "Unexpected error exporting page info for cloud migration";
            log.error(msg, (Throwable)e);
            HttpMessageEntity errorMsg = new HttpMessageEntity(msg);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errorMsg.toJson()).build();
        }
    }
}

