/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.model.DiagramLinkModel;
import de.viadee.confluence.enterprisecore.rest.DiagramLinksResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/diagramLinks")
@AnonymousAllowed
@AnonymousSiteAccess
public class DiagramLinksController {
    private static final int PAGINATION_LIMIT = 200;
    private final AuthValidator authValidator;
    private final DiagramLinksResource diagramLinksResource;

    @Inject
    public DiagramLinksController(AuthValidator authValidator, DiagramLinksResource diagramLinksResource) {
        this.authValidator = authValidator;
        this.diagramLinksResource = diagramLinksResource;
    }

    @GET
    @Path(value="/sync")
    @Produces(value={"application/json"})
    public Response syncAllLinks(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.diagramLinksResource.syncAllLinks();
    }

    @DELETE
    @Path(value="/all")
    public Response deleteAllLinks(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.diagramLinksResource.deleteAllLinks();
    }

    @GET
    @Path(value="/in/{pageId}/{vbcpEntId}")
    @Produces(value={"application/json"})
    public Response getIncomingLinksWithNameForModel(@Context HttpServletRequest request, @PathParam(value="pageId") Long pageId, @PathParam(value="vbcpEntId") String vbcpEntId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        this.authValidator.createContext(request).checkAuthentication().checkPagePermission(pageId.longValue(), Permission.VIEW);
        if (start == null) {
            start = 0;
        }
        if (limit == null || limit > 200) {
            limit = 200;
        }
        return this.diagramLinksResource.getIncomingLinksWithNameForModel(request, pageId, vbcpEntId, start.intValue(), limit.intValue());
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addLink(@Context HttpServletRequest request, DiagramLinkModel link) {
        this.authValidator.createContext(request).checkAuthentication().checkPagePermission(link.getSourcePageId().longValue(), Permission.EDIT).checkPagePermission(link.getTargetPageId().longValue(), Permission.VIEW);
        return this.diagramLinksResource.addLink(link);
    }

    @DELETE
    @Consumes(value={"application/json"})
    public Response deleteLink(@Context HttpServletRequest request, DiagramLinkModel link) {
        this.authValidator.createContext(request).checkAuthentication().checkPagePermission(link.getSourcePageId().longValue(), Permission.EDIT).checkPagePermission(link.getTargetPageId().longValue(), Permission.VIEW);
        return this.diagramLinksResource.deleteLink(link);
    }

    @GET
    @Path(value="/space/{spaceKey}/names")
    @Produces(value={"application/json"})
    public Response getAllLinksWithNamesForSpace(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        if (start == null) {
            start = 0;
        }
        if (limit == null || limit > 200) {
            limit = 200;
        }
        return this.diagramLinksResource.getAllLinksWithNamesForSpace(request, spaceKey, start.intValue(), limit.intValue());
    }

    @GET
    @Path(value="/page/{pageId}/names")
    @Produces(value={"application/json"})
    public Response getAllLinksWithNamesForPage(@Context HttpServletRequest request, @PathParam(value="pageId") Long pageId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        this.authValidator.createContext(request).checkAuthentication().checkPagePermission(pageId.longValue(), Permission.VIEW);
        if (start == null) {
            start = 0;
        }
        if (limit == null || limit > 200) {
            limit = 200;
        }
        return this.diagramLinksResource.getAllLinksWithNamesForPage(request, pageId, start.intValue(), limit.intValue());
    }

    @POST
    @Path(value="/space/{spaceKey}/sync")
    @Produces(value={"application/json"})
    public Response syncLinksForSpace(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.EDIT);
        return this.diagramLinksResource.syncLinksForSpace(spaceKey);
    }

    @POST
    @Path(value="/page/{pageId}/sync")
    @Produces(value={"application/json"})
    public Response syncLinksForPage(@Context HttpServletRequest request, @PathParam(value="pageId") Long pageId) {
        this.authValidator.createContext(request).checkAuthentication().checkPagePermission(pageId.longValue(), Permission.EDIT);
        return this.diagramLinksResource.syncLinksForPage(pageId);
    }
}

