/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.user.UserManager;
import de.viadee.confluence.enterprisecore.model.BpmnElementAttributeEnum;
import de.viadee.confluence.enterprisecore.model.BpmnMdfMappedTypesEnum;
import de.viadee.confluence.enterprisecore.model.GenericKeyValueModel;
import de.viadee.confluence.enterprisecore.model.LinterConfigModel;
import de.viadee.confluence.enterprisecore.model.MdfMapSpaceConfigModel;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.SerializationService;
import de.viadee.confluence.enterprisecore.service.SpaceConfigurationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/spaceConfig")
@AnonymousAllowed
@AnonymousSiteAccess
public class SpaceAdminConfigController {
    private final SpaceConfigurationService spaceConfigurationService;
    private final AuthValidator authValidator;
    private final SerializationService serializationService;

    @Inject
    public SpaceAdminConfigController(UserAccessor userAccessor, UserManager userManager, SpacePermissionManager spacePermissionManager, SpaceConfigurationService spaceConfigurationService, PermissionManager permissionManager, SpaceManager spaceManager, SerializationService serializationService) {
        this.spaceConfigurationService = spaceConfigurationService;
        this.authValidator = new AuthValidator(userAccessor, userManager, spacePermissionManager, permissionManager, spaceManager);
        this.serializationService = serializationService;
    }

    @GET
    @Path(value="/{spaceKey}/bpmnElementsConfig")
    @Produces(value={"application/json"})
    public Response getBpmnElementsConfig(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        Map bpmnElementsConfigForSpace = this.spaceConfigurationService.getBpmnElementsConfig(spaceKey);
        return this.serializationService.serialize((Object)bpmnElementsConfigForSpace);
    }

    @POST
    @Path(value="/{spaceKey}/bpmnElementsConfig")
    @Consumes(value={"application/json"})
    public Response saveBpmnElementsConfig(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey, Map<String, Boolean> config) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        this.spaceConfigurationService.saveBpmnElementsConfig(spaceKey, config);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/{spaceKey}/bpmnElementsConfig")
    @Produces(value={"application/json"})
    public Response deleteBpmnElementsConfig(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey, @QueryParam(value="bpmnElementsGroup") String bpmnElementsGroup) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        this.spaceConfigurationService.deleteBpmnElementsConfig(spaceKey, bpmnElementsGroup);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/{spaceKey}/linter")
    @Produces(value={"application/json"})
    public Response getLinterConfig(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        Map linterConfigForSpace = this.spaceConfigurationService.getLinterConfig(spaceKey);
        return this.serializationService.serialize((Object)linterConfigForSpace);
    }

    @POST
    @Path(value="/{spaceKey}/linter")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response saveLinterConfig(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey, Map<String, String> config) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        try {
            Map savedConfig = this.spaceConfigurationService.saveLinterConfig(spaceKey, config);
            return this.serializationService.serialize((Object)savedConfig);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{spaceKey}/linter")
    @Produces(value={"application/json"})
    public Response deleteLinterConfig(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        try {
            this.spaceConfigurationService.deleteLinterConfig(spaceKey);
            Map defaulLinterConfig = LinterConfigModel.getDefaultConfig();
            return this.serializationService.serialize((Object)defaulLinterConfig);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{spaceKey}/mdfMap")
    @Produces(value={"application/json"})
    public Response getAllMdfMaps(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        List mdfMappingsForSpace = this.spaceConfigurationService.getAllBpmnMdfMapForSpace(spaceKey);
        return this.serializationService.serialize((Object)mdfMappingsForSpace);
    }

    @POST
    @Path(value="/{spaceKey}/mdfMap")
    @Produces(value={"application/json"})
    public Response putMdfMap(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey, @QueryParam(value="bpmnElementType") String bpmnElementType, @QueryParam(value="fieldDefId") String fieldDefId, GenericKeyValueModel<BpmnElementAttributeEnum>[] config) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        ArrayList<String> enumNames = new ArrayList<String>();
        for (BpmnMdfMappedTypesEnum keyValue : BpmnMdfMappedTypesEnum.values()) {
            enumNames.add(keyValue.bpmnElementKey());
        }
        if (!enumNames.contains(bpmnElementType)) {
            return Response.status((int)422).build();
        }
        MdfMapSpaceConfigModel newMdfMapping = this.spaceConfigurationService.setBpmnMdfMap(spaceKey, bpmnElementType, fieldDefId, config);
        return this.serializationService.serialize((Object)newMdfMapping);
    }

    @GET
    @Path(value="/{spaceKey}/mdfMap/{bpmnElementType}")
    @Produces(value={"application/json"})
    public Response getAllMdfMapsForElementType(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey, @PathParam(value="bpmnElementType") String bpmnElementType) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        List mdfMappingsForElementType = this.spaceConfigurationService.getAllMdfMapsForElementType(spaceKey, bpmnElementType);
        return this.serializationService.serialize((Object)mdfMappingsForElementType);
    }

    @DELETE
    @Path(value="/{spaceKey}/mdfMap/{bpmnElementType}/{fieldDefId}")
    @Produces(value={"application/json"})
    public Response deleteMdfMap(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey, @PathParam(value="bpmnElementType") String bpmnElementType, @PathParam(value="fieldDefId") String fieldDefId) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        this.spaceConfigurationService.deleteBpmnMdfMap(spaceKey, bpmnElementType, fieldDefId);
        return Response.ok().build();
    }

    @GET
    @Path(value="/{spaceKey}/camundaPanelVersionConfig")
    public Response getCamundaPanelVersionConfig(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        String camundaPanelVersionForSpace = this.spaceConfigurationService.getCamundaPanelVersionConfig(spaceKey);
        return this.serializationService.serialize((Object)camundaPanelVersionForSpace);
    }

    @POST
    @Path(value="/{spaceKey}/camundaPanelVersionConfig")
    @Consumes(value={"application/json"})
    public Response setCamundaPanelVersionConfig(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey, String camundaPanelVersionConfig) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.EDIT);
        try {
            this.spaceConfigurationService.setCamundaPanelVersionConfig(spaceKey, camundaPanelVersionConfig);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @DELETE
    @Path(value="/{spaceKey}/camundaPanelVersionConfig")
    public Response resetCamundaPanelVersionConfig(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.EDIT);
        try {
            String camundaPanelVersionForSpace = this.spaceConfigurationService.resetCamundaPanelVersionConfig(spaceKey);
            return this.serializationService.serialize((Object)camundaPanelVersionForSpace);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }
}

