/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserManager;
import de.viadee.confluence.enterprisecore.model.SpaceAccessModel;
import de.viadee.confluence.enterprisecore.rest.SpaceAccessResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.EnabledSpaceService;
import de.viadee.confluence.enterprisecore.service.SerializationService;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/spaces")
public class SpaceAccessController {
    public static final String PATH = "/spaces";
    private final SpaceAccessResource spaceAccessResource;
    private final AuthValidator authValidator;

    @Inject
    public SpaceAccessController(UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, EnabledSpaceService enabledSpaceService, SpaceManager spaceManager, SerializationService serializationService) {
        this.spaceAccessResource = new SpaceAccessResource(enabledSpaceService, spaceManager, serializationService);
        this.authValidator = new AuthValidator(userAccessor, userManager, spacePermissionManager, permissionManager, spaceManager);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAllWhitelistedSpaces(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.spaceAccessResource.getAllWhitelistedSpaces();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{key}")
    public Response isSpaceInWhitelistedSpaces(@Context HttpServletRequest request, @PathParam(value="key") String spaceKey) {
        this.authValidator.createContext(request).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        return this.spaceAccessResource.isSpaceInWhitelistedSpaces(spaceKey);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addSpaceToWhiteList(@Context HttpServletRequest request, SpaceAccessModel space) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.spaceAccessResource.addSpaceToWhitelist(space);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{key}")
    public Response removeSpaceFromWhitelistByKey(@Context HttpServletRequest request, @PathParam(value="key") String spaceKey) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.spaceAccessResource.removeSpaceFromWhitelistByKey(spaceKey);
    }
}

