/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.rest.GithubResource;
import de.viadee.confluence.enterprisecore.security.AdminAesKeysManager;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.EnterpriseAppConfigurationService;
import de.viadee.confluence.enterprisecore.service.UserPropertiesService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="/github")
public class GithubController
extends AbstractResource {
    private final GithubResource githubResource;
    private final AuthValidator authValidator;

    public GithubController(I18nResolver i18nResolver, UserAccessor userAccessor, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, EnterpriseAppConfigurationService appConfigurationService, IPluginService pluginService, UserPropertiesService userPropertiesService, AdminAesKeysManager adminAesKeysManager) {
        super(userAccessor, spacePermissionManager);
        this.githubResource = new GithubResource(i18nResolver, appConfigurationService, pluginService, userPropertiesService, adminAesKeysManager);
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager);
    }

    @GET
    @Path(value="/isConfigured")
    @Produces(value={"application/json"})
    public Response isGitHubConfigured() {
        this.createRequestContext();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.githubResource.isGitHubConfigured()).build();
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig() {
        this.createRequestContext();
        this.authValidator.createContext(this.authContext).checkAuthentication();
        return this.githubResource.getAdminGitHubConfig();
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(AppConfigResource.Config config) {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        return this.githubResource.putAdminGitHubConfig(config);
    }

    @DELETE
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response deleteConfig() {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        return this.githubResource.deleteAdminGitHubConfig();
    }

    @GET
    @Path(value="/oauth/test")
    @Produces(value={"text/plain"})
    public Response testOAuthLoginUrl() {
        this.createRequestContext();
        return this.githubResource.getOAuthUserLoginUrl(Boolean.valueOf(true));
    }

    @GET
    @Path(value="/oauth")
    @Produces(value={"text/plain"})
    public Response getOAuthLoginUrl() {
        this.createRequestContext();
        return this.githubResource.getOAuthUserLoginUrl(Boolean.valueOf(false));
    }

    @GET
    @Path(value="/oauth/redirect")
    @Produces(value={"text/plain; charset=UTF-8"})
    public Response endOAuthLogin(@QueryParam(value="code") String code, @QueryParam(value="state") String state) {
        this.createRequestContext();
        return this.githubResource.endOAuthLogin(code, state);
    }

    @GET
    @Path(value="/projects/search")
    @Produces(value={"application/json"})
    public Response getGitHubProjectsWithSearchString(@QueryParam(value="containedString") String containedString) {
        this.createRequestContext();
        return this.githubResource.getGitHubProjectsBySearchString(containedString);
    }

    @GET
    @Path(value="/branches")
    @Produces(value={"application/json"})
    public Response getGitHubBranches(@QueryParam(value="repoPath") String repoPath) {
        this.createRequestContext();
        return this.githubResource.getGitHubBranches(repoPath);
    }

    @GET
    @Path(value="/branch/files")
    @Produces(value={"application/json"})
    public Response getGitHubFilesInBranch(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="ref") String ref, @QueryParam(value="fileEnding") String fileEnding) {
        this.createRequestContext();
        return this.githubResource.getFilesInBranchOrTag(repoPath, ref, fileEnding);
    }

    @GET
    @Path(value="/tags")
    @Produces(value={"application/json"})
    public Response getGitHubTags(@QueryParam(value="repoPath") String repoPath) {
        this.createRequestContext();
        return this.githubResource.getGitHubTags(repoPath);
    }

    @GET
    @Path(value="/tag/files")
    @Produces(value={"application/json"})
    public Response getGitHubFilesInTag(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="ref") String ref, @QueryParam(value="fileEnding") String fileEnding) {
        this.createRequestContext();
        return this.githubResource.getFilesInBranchOrTag(repoPath, ref, fileEnding);
    }

    @GET
    @Path(value="/commit")
    @Produces(value={"application/json"})
    public Response getLatestCommitForFile(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="ref") String ref, @QueryParam(value="filePath") String filePath) {
        this.createRequestContext();
        return this.githubResource.getLatestCommitForFile(repoPath, ref, filePath);
    }

    @GET
    @Path(value="/fileContent")
    @Produces(value={"application/json"})
    public Response getGitHubFileContent(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="filePath") String filePath, @QueryParam(value="ref") String ref) {
        this.createRequestContext();
        return this.githubResource.getFileContent(repoPath, filePath, ref);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/branch/create")
    public Response createNewGitHubBranch(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="newBranch") String newBranchName, @QueryParam(value="sha") String shaToBranchFrom) {
        this.createRequestContext();
        return this.githubResource.createNewBranch(repoPath, newBranchName, shaToBranchFrom);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/branch")
    public Response deleteRef(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="branch") String branchName) {
        this.createRequestContext();
        return this.githubResource.deleteBranch(repoPath, branchName);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/file")
    public Response updateOrCreateFile(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="filePath") String filePath, String encodedFileWithParamsAsJsonBody) {
        this.createRequestContext();
        return this.githubResource.updateOrCreateFile(repoPath, filePath, encodedFileWithParamsAsJsonBody);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/mergerequest/new")
    public Response createNewMRinGitHub(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="base") String baseBranchName, @QueryParam(value="head") String headBranchName, @QueryParam(value="title") String title, @QueryParam(value="modeler") String modeler) {
        this.createRequestContext();
        return this.githubResource.createMergeRequest(repoPath, baseBranchName, headBranchName, title, modeler);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/mergerequest/accept")
    public Response acceptMergeRequestById(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="pullNumber") int pullNumber) {
        this.createRequestContext();
        return this.githubResource.acceptMergeRequestById(repoPath, pullNumber);
    }
}

