/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.rest.BitbucketResource;
import de.viadee.confluence.enterprisecore.security.AdminAesKeysManager;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.EnterpriseAppConfigurationService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="/bitbucket")
public class BitbucketController
extends AbstractResource {
    private final BitbucketResource bitbucketResource;
    private final AuthValidator authValidator;

    public BitbucketController(UserAccessor userAccessor, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, EnterpriseAppConfigurationService appConfigurationService, AdminAesKeysManager adminAesKeysManager) {
        super(userAccessor, spacePermissionManager);
        this.bitbucketResource = new BitbucketResource(appConfigurationService, adminAesKeysManager);
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager);
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig() {
        this.createRequestContext();
        this.authValidator.createContext(this.authContext).checkAuthentication();
        return this.bitbucketResource.getConfig();
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(AppConfigResource.Config config) {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        return this.bitbucketResource.putConfig(config);
    }
}

