/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.service;

import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.model.MacroNameEnum;
import org.springframework.stereotype.Component;

@Component
public class BpmnPluginService
implements IPluginService {
    private static final String APP_FLAG = "BPMN";
    private static final String OTHER_APP_FLAG = "DMN";
    private static final String PLUGIN_KEY = "de.viadee.confluence.bpmn-plugin-enterprise";
    private static final String REST_PATH_COMPONENT = "/rest/bpmn-modeler-enterprise/1.0";
    private static final MacroNameEnum macroName = MacroNameEnum.VBCP_MACRO_ENTERPRISE;
    private static final MacroNameEnum otherMacroName = MacroNameEnum.VDCP_MACRO_ENTERPRISE;
    private static final MacroNameEnum freeMacroName = MacroNameEnum.VBCP_MACRO_FREE;
    private static final String SPACE_RESTRICTION_KEY = "de.viadee.confluence.bpmn-modeler-enterprise.settings.restricted";
    private static final String WELCOME_SCREEN_PROPERTY_KEY = "key.welcome-screen";
    private static final String MINIMAP_OPEN_PROPERTY_KEY = "key.minimap-open";
    private static final String ATTRIBUTE_PANEL_OPEN_PROPERTY_KEY = "key.attributepanel-open";
    private static final String LAST_NEWS_SEEN_DATE_PROPERTY_KEY = "key.last-news-seen-date";
    private static final String FILE_EXTENSION = ".bpmn";
    private static final String OTHER_FILE_EXTENSION = ".dmn";
    private static final String PLACE_HOLDER_IMAGE_BASE_64_ENCODED = "iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAACoklEQVRoge1ZbY6iQBB9JwBOIBzBC+AJ4AZNlgNAxhvsHARvAMkcoMl6AeJcwOgJ0LgiGWdi7w+rx153JyvKh2Z5SSXGD3jPftVVXQA9evToQbAAPAH4QTEDIChmyvtP9N27gAHgO4AFTmQvjQX91midNeEbgJUkpGnagTG2j6Ko5JwXWZZthRAbIcQmy7It57yIoqhkjO01TTsoQlZ0rdZgQbGHbdsfnPNCkr00OOeFbdsf+N1mVtPkh6B/fTAYHOI43lUlfh5xHO8Gg4FckRXdoxH4dBPhOM57nuc3EVcjz/ON4zjvOK2GXzf5obx4EARvdRE/jyAI3hQRta2EBbJNk+T/ImKFmnJiBrJN0+RlKHaa3UreByVsnZ6/JCeUxPavJW+ArFPHblM14jje4WSlq4rdM2ifb5u8DKVOPF8jYAFAXFOkGliFRVXyFgCh67roirwMXdfltmpVETAGIBhj+64FMMb2JGBcRcAUgIiiqOxaQBRFJQl4qSygS//L4JwXJGBaRcAMgJjP5z+7FpBl2RZXFDUBQHRNXgZO/dH/I2CJ+7PQaxUBUzx4Ek/x4NvowxcyC4AwDEN0LUDXddlWW1UEAJTId9LMLauSB6idHo1GnbXTo9HopnbaALBG9weaNW6Y3vkAhGmarR8pTdO8+Ugp8QpAuK7b2qHedV15qK9UvL6CBbJSy2OVNWocNX4OtsIwbExEGIaNDLYkfHlx13VrHy0qtmlktCgxBNnJNM3ahrtKwq7R4HBXwgIlNqhOJElSWUiSJDtln5cJazVNXoUPWg1Q2+F53n4ymZRpmv7xgCNN02IymZSe5+0Nw1Cf1KzRoGX+BQPHKrlUCF0aS/ptZ4+YzmHh2DG+4NiOf9qMXk/pszHu6CFfjx49OsYvj2zGle6PuGIAAAAASUVORK5CYII=";
    private static final String GITHUB_ACCESS_TOKEN_PROPERTY_KEY = "key.vbcp-gitHub-accessToken";
    private static final String GITHUB_CLIENT_ID_PROPERTY_KEY = "key.vbcp-gitHub-clientId";
    private static final String GITLAB_ACCESS_TOKEN_PROPERTY_KEY = "key.vbcp-gitLab-accessToken";
    private static final String GITLAB_CLIENT_ID_PROPERTY_KEY = "key.vbcp-gitLab-clientId";
    private static final String GITLAB_REFRESH_TOKEN_PROPERTY_KEY = "key.vbcp-gitLab-refreshToken";
    private static final String I18N_KEY_PREFIX = "de.viadee.confluence.bpmn-plugin-enterprise";

    public MacroNameEnum getMacroName() {
        return macroName;
    }

    public MacroNameEnum getMacroName(String diagramType) {
        return diagramType.equals(this.getAppFlag()) ? macroName : otherMacroName;
    }

    public String getRestPathComponent() {
        return REST_PATH_COMPONENT;
    }

    public String getSpaceRestrictionKey() {
        return SPACE_RESTRICTION_KEY;
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String getFileExtension(MacroNameEnum macroName) {
        if (macroName == BpmnPluginService.macroName) {
            return FILE_EXTENSION;
        }
        return OTHER_FILE_EXTENSION;
    }

    public MacroNameEnum getFreeMacroName() {
        return freeMacroName;
    }

    public String getShowWelcomeScreenPropertyKey() {
        return WELCOME_SCREEN_PROPERTY_KEY;
    }

    public String getMinimapOpenPropertyKey() {
        return MINIMAP_OPEN_PROPERTY_KEY;
    }

    public String getAttributePanelOpenPropertyKey() {
        return ATTRIBUTE_PANEL_OPEN_PROPERTY_KEY;
    }

    public String getLastNewsSeenDatePropertyKey() {
        return LAST_NEWS_SEEN_DATE_PROPERTY_KEY;
    }

    public String getAppFlag() {
        return APP_FLAG;
    }

    public String getAppFlag(String fileExtension) {
        if (fileExtension.equals(OTHER_FILE_EXTENSION)) {
            return OTHER_APP_FLAG;
        }
        if (fileExtension.equals(FILE_EXTENSION)) {
            return APP_FLAG;
        }
        return "";
    }

    public String getOtherAppFlag() {
        return OTHER_APP_FLAG;
    }

    public MacroNameEnum getOtherMacroName() {
        return otherMacroName;
    }

    public String getPlaceHolderImageBase64Encoded() {
        return PLACE_HOLDER_IMAGE_BASE_64_ENCODED;
    }

    public String getGithubAccessTokenPropertyKey() {
        return GITHUB_ACCESS_TOKEN_PROPERTY_KEY;
    }

    public String getGithubClientIdPropertyKey() {
        return GITHUB_CLIENT_ID_PROPERTY_KEY;
    }

    public String getGitlabAccessTokenPropertyKey() {
        return GITLAB_ACCESS_TOKEN_PROPERTY_KEY;
    }

    public String getGitlabClientIdPropertyKey() {
        return GITLAB_CLIENT_ID_PROPERTY_KEY;
    }

    public String getGitlabRefreshTokenPropertyKey() {
        return GITLAB_REFRESH_TOKEN_PROPERTY_KEY;
    }

    public String getPluginKey() {
        return "de.viadee.confluence.bpmn-plugin-enterprise";
    }

    public String getI18nKeyPrefix() {
        return "de.viadee.confluence.bpmn-plugin-enterprise";
    }
}

