/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.user.UserManager;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.rest.ViewAppConfigResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.EnterpriseAppConfigurationService;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AnonymousSiteAccess
@Path(value="/viewConfig")
public class ViewAppConfigController {
    private final ViewAppConfigResource viewAppConfigResource;
    private final AuthValidator authValidator;

    @Inject
    public ViewAppConfigController(UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, EnterpriseAppConfigurationService appConfigurationService) {
        this.viewAppConfigResource = new ViewAppConfigResource(appConfigurationService);
        this.authValidator = new AuthValidator(userAccessor, userManager, spacePermissionManager, permissionManager);
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(@Context HttpServletRequest request, AppConfigResource.ViewConfig config) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.viewAppConfigResource.putConfig(config);
    }
}

