/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import de.viadee.confluence.enterprisecore.model.DateAndTimeModel;
import de.viadee.confluence.enterprisecore.model.UserPropertyDto;
import de.viadee.confluence.enterprisecore.model.UserPropertyEnum;
import de.viadee.confluence.enterprisecore.rest.UserPropertiesResource;
import de.viadee.confluence.enterprisecore.service.UserPropertiesService;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@AnonymousSiteAccess
@Path(value="/user")
public class UserPropertiesController {
    private UserPropertiesResource userPropertiesResource;

    @Inject
    public UserPropertiesController(UserPropertiesService userPropertiesService) {
        this.userPropertiesResource = new UserPropertiesResource(userPropertiesService);
    }

    @PUT
    @Path(value="/setShowWelcomeScreen")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateHideWelcome(UserPropertyDto<Boolean> showWelcomeScreen) {
        return this.userPropertiesResource.updateShowWelcomeScreen(((Boolean)showWelcomeScreen.getValue()).booleanValue());
    }

    @PUT
    @Path(value="/lastNewsSeenDate")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateLastNewsSeenDate(UserPropertyDto<DateAndTimeModel> lastNewsSeenDate) {
        return this.userPropertiesResource.updateLastNewsSeenDate((DateAndTimeModel)lastNewsSeenDate.getValue());
    }

    @PUT
    @Path(value="/isMinimapOpen")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateIsMinimapOpenValue(UserPropertyDto<Boolean> isMinimapOpen) {
        return this.userPropertiesResource.updateIsMinimapOpen(((Boolean)isMinimapOpen.getValue()).booleanValue());
    }

    @PUT
    @Path(value="/isAttributePanelOpen")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateIsAttributePanelOpenValue(UserPropertyDto<Boolean> isAttributePanelOpen) {
        return this.userPropertiesResource.updateIsAttributePanelOpen(((Boolean)isAttributePanelOpen.getValue()).booleanValue());
    }

    @DELETE
    @Path(value="/{userId}/{propertyKey}")
    @Produces(value={"application/json"})
    public Response deletePropertyForUser(@PathParam(value="userId") String userId, @PathParam(value="propertyKey") UserPropertyEnum propertyKey) {
        return this.userPropertiesResource.deleteAnyProperty(String.valueOf(propertyKey));
    }

    @DELETE
    @Path(value="/github")
    @Produces(value={"application/json"})
    public Response deleteAllGithubPropertyForUser() {
        return this.userPropertiesResource.deleteAllGithubPropertyForUser();
    }

    @DELETE
    @Path(value="/gitlab")
    @Produces(value={"application/json"})
    public Response deleteAllGitlabPropertyForUser() {
        return this.userPropertiesResource.deleteAllGitlabPropertyForUser();
    }

    @GET
    @Path(value="/{userId}/{propertyKey}")
    @Produces(value={"application/json"})
    public Response getPropertyForUser(@PathParam(value="userId") String userId, @PathParam(value="propertyKey") UserPropertyEnum propertyKey) {
        return this.userPropertiesResource.getAnyProperty(String.valueOf(propertyKey));
    }
}

