/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.user.UserManager;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.rest.BitbucketResource;
import de.viadee.confluence.enterprisecore.security.AdminAesKeysManager;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.EnterpriseAppConfigurationService;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AnonymousSiteAccess
@Path(value="/bitbucket")
public class BitbucketController {
    private final BitbucketResource bitbucketResource;
    private final AuthValidator authValidator;

    @Inject
    public BitbucketController(UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, EnterpriseAppConfigurationService appConfigurationService, AdminAesKeysManager adminAesKeysManager) {
        this.bitbucketResource = new BitbucketResource(appConfigurationService, adminAesKeysManager);
        this.authValidator = new AuthValidator(userAccessor, userManager, spacePermissionManager, permissionManager);
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkAuthentication();
        return this.bitbucketResource.getConfig();
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(@Context HttpServletRequest request, AppConfigResource.Config config) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.bitbucketResource.putConfig(config);
    }
}

