/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.rest.ViewAppConfigResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.EnterpriseAppConfigurationService;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="/viewConfig")
public class ViewAppConfigController
extends AbstractResource {
    private final ViewAppConfigResource viewAppConfigResource;
    private final AuthValidator authValidator;

    public ViewAppConfigController(UserAccessor userAccessor, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, EnterpriseAppConfigurationService appConfigurationService) {
        super(userAccessor, spacePermissionManager);
        this.viewAppConfigResource = new ViewAppConfigResource(appConfigurationService);
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager);
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(AppConfigResource.ViewConfig config) {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        return this.viewAppConfigResource.putConfig(config);
    }
}

