/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.rest.PagePropertyResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="/pageproperty")
public class PagePropertyController
extends AbstractResource {
    private final PagePropertyResource pagePropertyResource;
    private final AuthValidator authValidator;

    public PagePropertyController(UserAccessor userAccessor, SpacePermissionManager spacePermissionManager, SettingsManager settingsManager, PermissionManager permissionManager, PageManager pageManager) {
        super(userAccessor, spacePermissionManager);
        this.pagePropertyResource = new PagePropertyResource(pageManager, settingsManager);
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager, pageManager);
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getPageProperty(@QueryParam(value="pageId") long pageId) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkPagePermission(pageId, Permission.VIEW);
        this.createRequestContext();
        return this.pagePropertyResource.getPageProperty(pageId);
    }

    @GET
    @Path(value="/breadcrumb")
    @Produces(value={"application/json"})
    public Response getBreadcrumb(@QueryParam(value="pageId") long pageId) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkPagePermission(pageId, Permission.VIEW);
        this.createRequestContext();
        return this.pagePropertyResource.getBreadcrumb(pageId);
    }
}

