/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.model.DiagramLinkModel;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.rest.DiagramLinksResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.ConfigurationService;
import de.viadee.confluence.enterprisecore.service.MacroDiscoveryService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="/diagramLinks")
public class DiagramLinksController
extends AbstractResource {
    private final DiagramLinksResource diagramLinksResource;
    private final AuthValidator authValidator;
    private final int PAGINATION_LIMIT = 200;

    public DiagramLinksController(UserAccessor userAccessor, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, ConfigurationService configurationService, ActiveObjects ao, SpaceManager spaceManager, PageManager pageManager, AttachmentManager attachmentManager, XhtmlContent xhtmlContent, IPluginService pluginService, MacroDiscoveryService macroDiscoveryService) {
        super(userAccessor, spacePermissionManager);
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager, spaceManager, pageManager, attachmentManager, pluginService, configurationService);
        this.diagramLinksResource = new DiagramLinksResource(pluginService, macroDiscoveryService, spaceManager, pageManager, attachmentManager, xhtmlContent, ao, configurationService, this.authValidator);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAllLinks() {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        return this.diagramLinksResource.getAllLinks();
    }

    @GET
    @Path(value="/sync")
    @Produces(value={"application/json"})
    public Response syncAllLinks() {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        return this.diagramLinksResource.syncAllLinks();
    }

    @DELETE
    public Response deleteAllLinks() {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        return this.diagramLinksResource.deleteAllLinks();
    }

    @GET
    @Path(value="/out/{pageId}")
    @Produces(value={"application/json"})
    public Response getOutgoingLinksForPage(@PathParam(value="pageId") String pageId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkPagePermission(Long.parseLong(pageId), Permission.VIEW);
        this.createRequestContext();
        if (start == null) {
            start = 0;
        }
        if (limit == null || limit > 200) {
            limit = 200;
        }
        return this.diagramLinksResource.getOutgoingLinksForPage(pageId, start.intValue(), limit.intValue());
    }

    @GET
    @Path(value="/out/{pageId}/{vbcpEntId}")
    @Produces(value={"application/json"})
    public Response getOutgoingLinksForPage(@PathParam(value="pageId") String pageId, @PathParam(value="vbcpEntId") String vbcpEntId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkPagePermission(Long.parseLong(pageId), Permission.VIEW);
        this.createRequestContext();
        if (start == null) {
            start = 0;
        }
        if (limit == null || limit > 200) {
            limit = 200;
        }
        return this.diagramLinksResource.getOutgoingLinksForDiagram(pageId, vbcpEntId, start.intValue(), limit.intValue());
    }

    @GET
    @Path(value="/in/{pageId}")
    @Produces(value={"application/json"})
    public Response getIncomingLinksForPage(@PathParam(value="pageId") String pageId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkPagePermission(Long.parseLong(pageId), Permission.VIEW);
        this.createRequestContext();
        if (start == null) {
            start = 0;
        }
        if (limit == null || limit > 200) {
            limit = 200;
        }
        return this.diagramLinksResource.getIncomingLinksForPage(pageId, start.intValue(), limit.intValue());
    }

    @GET
    @Path(value="/in/{pageId}/{vbcpEntId}")
    @Produces(value={"application/json"})
    public Response getIncomingLinksForModel(@PathParam(value="pageId") String pageId, @PathParam(value="vbcpEntId") String vbcpEntId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkPagePermission(Long.parseLong(pageId), Permission.VIEW);
        this.createRequestContext();
        if (start == null) {
            start = 0;
        }
        if (limit == null || limit > 200) {
            limit = 200;
        }
        return this.diagramLinksResource.getIncomingLinksForDiagram(this.authContext, pageId, vbcpEntId, start.intValue(), limit.intValue());
    }

    @POST
    @Consumes(value={"application/json"})
    public Response putLink(DiagramLinkModel link) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkPagePermission(link.getSourcePageId().longValue(), Permission.EDIT).checkPagePermission(link.getTargetPageId().longValue(), Permission.VIEW);
        this.createRequestContext();
        return this.diagramLinksResource.putLink(link);
    }

    @DELETE
    @Consumes(value={"application/json"})
    public Response deleteLink(DiagramLinkModel link) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkPagePermission(link.getSourcePageId().longValue(), Permission.EDIT).checkPagePermission(link.getTargetPageId().longValue(), Permission.VIEW);
        this.createRequestContext();
        return this.diagramLinksResource.deleteLink(link);
    }

    @GET
    @Path(value="/space/{spaceKey}/names")
    @Produces(value={"application/json"})
    public Response getAllLinksWithNamesForSpace(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        this.createRequestContext();
        if (start == null) {
            start = 0;
        }
        if (limit == null || limit > 200) {
            limit = 200;
        }
        return this.diagramLinksResource.getAllLinksWithNamesForSpace(this.authContext, spaceKey, start.intValue(), limit.intValue());
    }

    @GET
    @Path(value="/page/{pageId}/names")
    @Produces(value={"application/json"})
    public Response getAllLinksWithNamesForPage(@PathParam(value="pageId") String pageId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkPagePermission(Long.parseLong(pageId), Permission.VIEW);
        this.createRequestContext();
        if (start == null) {
            start = 0;
        }
        if (limit == null || limit > 200) {
            limit = 200;
        }
        return this.diagramLinksResource.getAllLinksWithNamesForPage(this.authContext, pageId, start.intValue(), limit.intValue());
    }
}

