/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.model.ConfigurationModel;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.model.MacroNameEnum;
import de.viadee.confluence.enterprisecore.rest.ConfigurationResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.ConfigurationService;
import de.viadee.confluence.enterprisecore.service.EnterpriseAppConfigurationService;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="/configuration/{pageId}")
public class ConfigurationController
extends AbstractResource {
    private final ConfigurationResource configurationResource;
    private final IPluginService pluginService;
    private final AuthValidator authValidator;

    public ConfigurationController(ConfigurationService configService, UserAccessor userAccessor, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, IPluginService pluginService, EnterpriseAppConfigurationService appConfigurationService, PageManager pageManager, SpaceManager spaceManager, AttachmentManager attachmentManager, ConfigurationService configurationService) {
        super(userAccessor, spacePermissionManager);
        this.configurationResource = new ConfigurationResource(configService, appConfigurationService);
        this.pluginService = pluginService;
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager, spaceManager, pageManager, attachmentManager, pluginService, configurationService);
    }

    @GET
    @Path(value="/defaultConfigs/")
    @Produces(value={"application/json"})
    public Response getNewDiagramDefaultConfigs(@PathParam(value="pageId") String pageId) {
        this.authValidator.createContext(this.authContext).checkAuthentication();
        this.createRequestContext();
        return this.configurationResource.getNewDiagramDefaultConfiguration();
    }

    @GET
    @Path(value="/getConfig/{vbcpEntId}/{macroKeyForConfigs}")
    @Produces(value={"application/json"})
    public Response getAllConfigs(@PathParam(value="pageId") String pageId, @PathParam(value="vbcpEntId") String vbcpEntId, @PathParam(value="macroKeyForConfigs") String macroKeyForConfigs) {
        this.authValidator.createContext(this.authContext).checkPagePermission(Long.parseLong(pageId), Permission.VIEW);
        this.createRequestContext();
        return this.configurationResource.getAllConfigs(pageId, vbcpEntId, macroKeyForConfigs);
    }

    @GET
    @Path(value="/getConfig/macroId/{macroId}/{macroKeyForConfigs}")
    @Produces(value={"application/json"})
    public Response getAllConfigsByMacroId(@PathParam(value="pageId") String pageId, @PathParam(value="macroId") String macroId, @PathParam(value="macroKeyForConfigs") String macroKeyForConfigs) {
        this.authValidator.createContext(this.authContext).checkPagePermission(Long.parseLong(pageId), Permission.VIEW);
        this.createRequestContext();
        return this.configurationResource.getAllConfigsByMacroId(pageId, macroId, macroKeyForConfigs);
    }

    @GET
    @Path(value="/getSingleConfig/{vbcpEntId}/{parameterKey}")
    @Produces(value={"application/json"})
    public Response getSingleConfig(@PathParam(value="parameterKey") String parameterKey, @PathParam(value="pageId") String pageId, @PathParam(value="vbcpEntId") String vbcpEntId) {
        this.authValidator.createContext(this.authContext).checkPagePermission(Long.parseLong(pageId), Permission.VIEW);
        this.createRequestContext();
        MacroNameEnum macroName = this.pluginService.getMacroName();
        return this.configurationResource.getSingleConfig(parameterKey, pageId, vbcpEntId, macroName);
    }

    @POST
    @Path(value="/updateConfig/{vbcpEntId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateAllConfigs(@PathParam(value="pageId") String pageId, @PathParam(value="vbcpEntId") String vbcpEntId, ConfigurationModel newConfigs) {
        this.authValidator.createContext(this.authContext).checkPagePermission(Long.parseLong(pageId), Permission.EDIT);
        this.createRequestContext();
        MacroNameEnum macroName = this.pluginService.getMacroName();
        return this.configurationResource.updateAllConfigs(pageId, vbcpEntId, macroName, newConfigs);
    }

    @POST
    @Path(value="/updateConfig/{vbcpEntId}/{parameterKey}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateSingleConfig(@PathParam(value="parameterKey") String parameterKey, @PathParam(value="pageId") String pageId, @PathParam(value="vbcpEntId") String vbcpEntId, Map<String, String> newConfigValue) {
        this.authValidator.createContext(this.authContext).checkPagePermission(Long.parseLong(pageId), Permission.EDIT);
        this.createRequestContext();
        MacroNameEnum macroName = this.pluginService.getMacroName();
        return this.configurationResource.updateSingleConfig(parameterKey, pageId, vbcpEntId, macroName, newConfigValue);
    }

    @POST
    @Path(value="/createVbcpEntId/{macroId}/{macroKeyForConfigs}")
    @Produces(value={"application/json"})
    public Response createVbcpEntId(@PathParam(value="pageId") String pageId, @PathParam(value="macroId") String macroId, @PathParam(value="macroKeyForConfigs") String macroKeyForConfigs) {
        this.authValidator.createContext(this.authContext).checkPagePermission(Long.parseLong(pageId), Permission.VIEW);
        this.createRequestContext();
        return this.configurationResource.createVbcpEntId(pageId, macroId, macroKeyForConfigs);
    }
}

