/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.model.ProcessNetNodeModel;
import de.viadee.confluence.enterprisecore.rest.ProcessNetPositionResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.ConfigurationService;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="/processNetPositions")
public class ProcessNetPositionController
extends AbstractResource {
    private final ProcessNetPositionResource processNetPositionResource;
    private final AuthValidator authValidator;
    private final int PAGINATION_LIMIT = 200;

    public ProcessNetPositionController(UserAccessor userAccessor, SpacePermissionManager spacePermissionManager, ActiveObjects ao, PermissionManager permissionManager, SpaceManager spaceManager, PageManager pageManager, AttachmentManager attachmentManager, IPluginService pluginService, ConfigurationService configurationService) {
        super(userAccessor, spacePermissionManager);
        this.processNetPositionResource = new ProcessNetPositionResource(ao);
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager, spaceManager, pageManager, attachmentManager, pluginService, configurationService);
    }

    @PUT
    @Path(value="/updatePositions/{pageId}/{processNetId}")
    @Consumes(value={"application/json; charset=utf-8"})
    public Response addOrUpdatePositions(@PathParam(value="pageId") Long pageId, @PathParam(value="processNetId") String processNetId, List<ProcessNetNodeModel> processNetNodeModels) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkPagePermission(pageId.longValue(), Permission.EDIT);
        return this.processNetPositionResource.addOrUpdatePositions(processNetId, processNetNodeModels);
    }

    @GET
    @Path(value="/getPositions/{pageId}/{processNetId}")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getPositions(@PathParam(value="pageId") Long pageId, @PathParam(value="processNetId") String processNetId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkPagePermission(pageId.longValue(), Permission.VIEW);
        if (start == null) {
            start = 0;
        }
        if (limit == null || limit > 200) {
            limit = 200;
        }
        return this.processNetPositionResource.getPositions(processNetId, start.intValue(), limit.intValue());
    }
}

