/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.BpmnElementsGlobalConfigService;
import de.viadee.confluence.enterprisecore.service.ConfigurationService;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="/bpmnElementsGlobalConfig")
public class BpmnElementsGlobalConfigController
extends AbstractResource {
    private final AuthValidator authValidator;
    private final BpmnElementsGlobalConfigService bpmnElementsConfigService;

    public BpmnElementsGlobalConfigController(UserAccessor userAccessor, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, ConfigurationService configurationService, SpaceManager spaceManager, PageManager pageManager, AttachmentManager attachmentManager, IPluginService pluginService, BpmnElementsGlobalConfigService bpmnElementsConfigService) {
        super(userAccessor, spacePermissionManager);
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager, spaceManager, pageManager, attachmentManager, pluginService, configurationService);
        this.bpmnElementsConfigService = bpmnElementsConfigService;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response saveBpmnElementsConfig(Map<String, Boolean> config) {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        this.bpmnElementsConfigService.saveBpmnElementsConfig(config);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response deleteBpmnElementsConfig(@QueryParam(value="bpmnElementsGroup") String bpmnElementsGroup) {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        this.bpmnElementsConfigService.deleteBpmnElementsConfig(bpmnElementsGroup);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getBpmnElementsConfig() {
        this.authValidator.createContext(this.authContext).checkAuthentication();
        this.createRequestContext();
        return Response.ok((Object)this.bpmnElementsConfigService.getBpmnElementsConfig()).build();
    }
}

