/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import de.viadee.confluence.enterprisecore.rest.UpgradeResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.UpgradeService;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/upgrade")
public class UpgradeController
extends AbstractResource {
    private static final String FREE_MACRO_KEY = "vbcp-macro";
    private static final String ENT_MACRO_KEY = "vbcp-macro-enterprise";
    private final UpgradeResource upgradeResource;
    private final AuthValidator authValidator;

    public UpgradeController(UserAccessor userAccessor, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, UpgradeService upgradeService, XhtmlContent xhtmlContent) {
        super(userAccessor, spacePermissionManager);
        this.upgradeResource = new UpgradeResource(upgradeService, FREE_MACRO_KEY, ENT_MACRO_KEY, xhtmlContent);
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager);
    }

    @GET
    @Path(value="/upgradeMacrosOnPage/{pageId}/{toMacro}")
    @Produces(value={"application/json"})
    public Response upgradeMacros(@PathParam(value="pageId") String pageTitle, @PathParam(value="toMacro") String toMacro) {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        return this.upgradeResource.upgradeMacros(pageTitle, toMacro);
    }

    @GET
    @Path(value="/start-analysis")
    @Produces(value={"application/json"})
    public Response startAnalysis() {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        return this.upgradeResource.startAnalysis();
    }
}

