/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.gson.Gson;
import de.viadee.confluence.enterprisecore.model.BpmnElementAttributeEnum;
import de.viadee.confluence.enterprisecore.model.BpmnMdfMappedTypesEnum;
import de.viadee.confluence.enterprisecore.model.GenericKeyValueModel;
import de.viadee.confluence.enterprisecore.model.LinterConfigModel;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.SpaceConfigurationService;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="/spaceConfig")
public class SpaceAdminConfigController
extends AbstractResource {
    private final SpaceConfigurationService spaceConfigurationService;
    private final AuthValidator authValidator;
    private final Gson GSON = new Gson();

    public SpaceAdminConfigController(UserAccessor userAccessor, SpacePermissionManager spacePermissionManager, SpaceConfigurationService spaceConfigurationService, PermissionManager permissionManager, SpaceManager spaceManager) {
        super(userAccessor, spacePermissionManager);
        this.spaceConfigurationService = spaceConfigurationService;
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager, spaceManager);
    }

    @POST
    @Path(value="/{spaceKey}/linter")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response saveLinterConfig(@PathParam(value="spaceKey") String spaceKey, Map<String, String> config) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        this.createRequestContext();
        try {
            Map savedConfig = this.spaceConfigurationService.saveLinterConfig(spaceKey, config);
            return Response.ok().entity((Object)savedConfig).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Path(value="/{spaceKey}/linter")
    @Produces(value={"application/json"})
    public Response getLinterConfig(@PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        this.createRequestContext();
        return Response.ok((Object)this.spaceConfigurationService.getLinterConfig(spaceKey)).build();
    }

    @DELETE
    @Path(value="/{spaceKey}/linter")
    @Produces(value={"application/json"})
    public Response deleteLinterConfig(@PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        this.createRequestContext();
        try {
            this.spaceConfigurationService.deleteLinterConfig(spaceKey);
            return Response.ok().entity((Object)LinterConfigModel.getDefaultConfig()).build();
        }
        catch (Exception e) {
            return Response.status((int)500).build();
        }
    }

    @POST
    @Path(value="/{spaceKey}/bpmnElementsConfig")
    @Consumes(value={"application/json"})
    public Response saveBpmnElementsConfig(@PathParam(value="spaceKey") String spaceKey, Map<String, Boolean> config) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        this.createRequestContext();
        this.spaceConfigurationService.saveBpmnElementsConfig(spaceKey, config);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/{spaceKey}/bpmnElementsConfig")
    @Produces(value={"application/json"})
    public Response deleteBpmnElementsConfig(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="bpmnElementsGroup") String bpmnElementsGroup) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        this.createRequestContext();
        this.spaceConfigurationService.deleteBpmnElementsConfig(spaceKey, bpmnElementsGroup);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/{spaceKey}/bpmnElementsConfig")
    @Produces(value={"application/json"})
    public Response getBpmnElementsConfig(@PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        this.createRequestContext();
        return Response.ok((Object)this.spaceConfigurationService.getBpmnElementsConfig(spaceKey)).build();
    }

    @GET
    @Path(value="/{spaceKey}/camundaPanelVersionConfig")
    public Response getCamundaPanelVersionConfig(@PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        this.createRequestContext();
        return Response.ok((Object)this.spaceConfigurationService.getCamundaPanelVersionConfig(spaceKey)).build();
    }

    @POST
    @Path(value="/{spaceKey}/camundaPanelVersionConfig")
    @Consumes(value={"application/json"})
    public Response setCamundaPanelVersionConfig(@PathParam(value="spaceKey") String spaceKey, String camundaPanelVersionConfig) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.EDIT);
        this.createRequestContext();
        try {
            this.spaceConfigurationService.setCamundaPanelVersionConfig(spaceKey, camundaPanelVersionConfig);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @DELETE
    @Path(value="/{spaceKey}/camundaPanelVersionConfig")
    public Response resetCamundaPanelVersionConfig(@PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.EDIT);
        this.createRequestContext();
        try {
            return Response.ok((Object)this.spaceConfigurationService.resetCamundaPanelVersionConfig(spaceKey)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @POST
    @Path(value="/{spaceKey}/mdfMap")
    @Produces(value={"application/json"})
    public Response putMdfMap(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="bpmnElementType") String bpmnElementType, @QueryParam(value="fieldDefId") String fieldDefId, GenericKeyValueModel<BpmnElementAttributeEnum>[] config) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        this.createRequestContext();
        ArrayList<String> enumNames = new ArrayList<String>();
        for (BpmnMdfMappedTypesEnum keyValue : BpmnMdfMappedTypesEnum.values()) {
            enumNames.add(keyValue.bpmnElementKey());
        }
        if (!enumNames.contains(bpmnElementType)) {
            return Response.status((int)422).build();
        }
        String json = this.GSON.toJson((Object)this.spaceConfigurationService.setBpmnMdfMap(spaceKey, bpmnElementType, fieldDefId, config));
        return Response.ok((Object)json).build();
    }

    @GET
    @Path(value="/{spaceKey}/mdfMap")
    @Produces(value={"application/json"})
    public Response getAllMdfMaps(@PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        this.createRequestContext();
        String json = this.GSON.toJson((Object)this.spaceConfigurationService.getAllBpmnMdfMapForSpace(spaceKey));
        return Response.ok((Object)json).build();
    }

    @GET
    @Path(value="/{spaceKey}/mdfMap/{bpmnElementType}")
    @Produces(value={"application/json"})
    public Response getAllMdfMapsForElementType(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="bpmnElementType") String bpmnElementType) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        this.createRequestContext();
        String json = this.GSON.toJson((Object)this.spaceConfigurationService.getAllMdfMapsForElementType(spaceKey, bpmnElementType));
        return Response.ok((Object)json).build();
    }

    @DELETE
    @Path(value="/{spaceKey}/mdfMap/{bpmnElementType}/{fieldDefId}")
    @Produces(value={"application/json"})
    public Response deleteMdfMap(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="bpmnElementType") String bpmnElementType, @PathParam(value="fieldDefId") String fieldDefId) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        this.createRequestContext();
        this.spaceConfigurationService.deleteBpmnMdfMap(spaceKey, bpmnElementType, fieldDefId);
        return Response.ok().build();
    }
}

