/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.rest.AttachmentsResource;
import de.viadee.confluence.enterprisecore.rest.AttachmentsUpdateCommentModel;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.ConfigurationService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/attachments")
@AnonymousAllowed
public class AttachmentsController
extends AbstractResource {
    private final AttachmentsResource attachmentsResource;
    private final AuthValidator authValidator;

    public AttachmentsController(UserAccessor userAccessor, SpacePermissionManager spacePermissionManager, PermissionManager permissionManager, IPluginService pluginService, ConfigurationService configurationService, BandanaManager bandanaManager, I18nResolver i18nResolver, FileUploadManager fileUploadManager, SpaceManager spaceManager, AttachmentManager attachmentManager, PageManager pageManager) {
        super(userAccessor, spacePermissionManager);
        this.attachmentsResource = new AttachmentsResource(pluginService, bandanaManager, i18nResolver, fileUploadManager, attachmentManager, pageManager);
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager, spaceManager, pageManager, attachmentManager, pluginService, configurationService);
    }

    @GET
    @Path(value="/versionData/{pageId}/{diagramNameWithType}/{version}/{attachmentId}")
    @Produces(value={"application/json"})
    public Response getAttachmentVersionData(@PathParam(value="diagramNameWithType") String diagramNameWithType, @PathParam(value="pageId") Long pageId, @PathParam(value="version") int version, @PathParam(value="attachmentId") String attachmentId) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkAttachmentPermission(pageId.longValue(), diagramNameWithType, version, Permission.VIEW);
        this.createRequestContext();
        return this.attachmentsResource.getAttachmentVersionData(diagramNameWithType, pageId, version, attachmentId);
    }

    @POST
    @Path(value="/comment/update/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateAttachmentComment(AttachmentsUpdateCommentModel attachmentsUpdateCommentModel) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkAttachmentPermission(attachmentsUpdateCommentModel.getPageId().longValue(), attachmentsUpdateCommentModel.getAttachmentName(), Permission.EDIT);
        this.createRequestContext();
        return this.attachmentsResource.updateAttachmentComment(attachmentsUpdateCommentModel);
    }

    @POST
    @Consumes(value={"image/svg+xml"})
    @Path(value="/uploadImageAsBase64/{vbcpEntId}/{pageId}")
    public Response uploadImageWithMacroId(@PathParam(value="vbcpEntId") String vbcpEntId, @PathParam(value="pageId") Long pageId, String svgXML) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkDiagramPermissionByVbcpEntId(pageId.longValue(), vbcpEntId, Permission.EDIT);
        this.createRequestContext();
        return this.attachmentsResource.uploadImageWithVbcpEntId(vbcpEntId, svgXML);
    }

    @GET
    @Produces(value={"image/png"})
    @Path(value="/getImageAsBase64/{vbcpEntId}/{pageId}/{diagramName}")
    public Response getImageByVbcpEntId(@PathParam(value="vbcpEntId") String vbcpEntId, @PathParam(value="pageId") Long pageId, @PathParam(value="diagramName") String diagramName) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkDiagramPermissionByVbcpEntId(pageId.longValue(), vbcpEntId, Permission.VIEW);
        this.createRequestContext();
        return this.attachmentsResource.getImageByVbcpEntId(vbcpEntId, pageId, diagramName);
    }
}

