(()=>{"use strict";var __webpack_modules__={"../../../../../../core/services/web.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Q": () => (/* binding */ WebService)\n/* harmony export */ });\nclass WebService {\n}\nWebService.decodeUrlSearchParams = (url) => {\n    const decodedUrl = new URL(decodeURI(url));\n    decodedUrl.searchParams.forEach((value, key, params) => params.set(key, decodeURIComponent(value)));\n    return decodedUrl;\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../core/services/web.service.ts?')},"../../../../../../core/utils/core-function-utils.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "debounce": () => (/* binding */ debounce)\n/* harmony export */ });\n/* unused harmony export defer */\nconst debounce = (func, wait) => {\n    const outerThis = undefined;\n    let lastArgs;\n    let lastThis;\n    let result;\n    let timerId;\n    let lastCallTime = 0;\n    function invokeFunc() {\n        const args = lastArgs;\n        const thisArg = lastThis;\n        lastArgs = lastThis = undefined;\n        result = args ? func.apply(thisArg, args) : func.apply(thisArg);\n        return result;\n    }\n    function leadingEdge() {\n        timerId = setTimeout(timerExpired, wait);\n        return result;\n    }\n    function remainingWait(time) {\n        const timeSinceLastCall = time - lastCallTime;\n        return wait - timeSinceLastCall;\n    }\n    function shouldInvoke(time) {\n        const timeSinceLastCall = time - lastCallTime;\n        return lastCallTime === 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0;\n    }\n    function timerExpired() {\n        const time = Date.now();\n        if (shouldInvoke(time)) {\n            return trailingEdge();\n        }\n        timerId = setTimeout(timerExpired, remainingWait(time));\n    }\n    function trailingEdge() {\n        timerId = undefined;\n        if (lastArgs) {\n            return invokeFunc();\n        }\n        lastArgs = lastThis = undefined;\n        return result;\n    }\n    function debounced(...args) {\n        const time = Date.now();\n        const isInvoking = shouldInvoke(time);\n        lastArgs = args;\n        lastThis = outerThis;\n        lastCallTime = time;\n        if (isInvoking) {\n            if (timerId === undefined) {\n                return leadingEdge();\n            }\n        }\n        if (timerId === undefined) {\n            timerId = setTimeout(timerExpired, wait);\n        }\n        return result;\n    }\n    return debounced;\n};\nconst defer = (func) => {\n    return setTimeout(func, 1);\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../core/utils/core-function-utils.ts?')},"../../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ VxcpLogger)\n/* harmony export */ });\nclass VxcpLogger {\n    constructor(pluginName, serviceName, isEnabled = true) {\n        this.pluginName = pluginName;\n        this.serviceName = serviceName;\n        this.isEnabled = isEnabled;\n    }\n    logFatal(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`FATAL@${logHeader}: ${description}`);\n        }\n    }\n    logError(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`ERROR@${logHeader}: ${description}`);\n        }\n    }\n    logWarning(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.warn(`WARNING@${logHeader}: ${description}`);\n        }\n    }\n    logInfo(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.info(`INFO@${logHeader}: ${description}`);\n        }\n    }\n    enableLogging(isEnabled = true) {\n        this.isEnabled = isEnabled;\n    }\n    getLogHeader(methodName) {\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/components/process-net-macro-dialog.component.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/license.service.ts\nvar license_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/license.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts\nvar plugin_specific_factory = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/id-generator.service.ts\nvar id_generator_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/id-generator.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/components/search/page-search-input.component.ts\nvar page_search_input_component = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/components/search/page-search-input.component.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/utils/time.service.ts\nvar time_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/time.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/search/suggestions/search-suggestions.service.ts\nvar search_suggestions_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/search/suggestions/search-suggestions.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/utils/enum-converter.service.ts\nvar enum_converter_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/enum-converter.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/macro.service.ts\nvar macro_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/macro.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/search/search-page.service.ts\nvar search_page_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/search/search-page.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts\nvar language_rest_factory = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/utils/tabbed-dialog.service.ts\nvar tabbed_dialog_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/tabbed-dialog.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/utils/dialog.service.ts\nvar dialog_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/dialog.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/space-permissions.service.ts\nvar space_permissions_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/space-permissions.service.ts");\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/process-net/process-net-macro-type.enum.ts\nvar ProcessNetMacroTypeEnum;\n(function (ProcessNetMacroTypeEnum) {\n    ProcessNetMacroTypeEnum["SPACE"] = "space";\n    ProcessNetMacroTypeEnum["PAGE"] = "page";\n})(ProcessNetMacroTypeEnum || (ProcessNetMacroTypeEnum = {}));\n\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/components/search/search-input.component.ts\nvar search_input_component = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/components/search/search-input.component.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts\nvar sanitizer_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/components/search/search-space-input.component.ts\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\nclass SpaceSearchInputComponent extends search_input_component/* SearchInputComponent */.JD {\n    constructor(platformUtils, timeService) {\n        super(platformUtils, timeService);\n    }\n    createResultListItemDefault(item) {\n        var _a, _b;\n        return __awaiter(this, void 0, void 0, function* () {\n            const relativeUrl = sanitizer_service/* SanitizerService.getSanitizedString */.Y.getSanitizedString((_b = (_a = item.space._links) === null || _a === void 0 ? void 0 : _a.self) !== null && _b !== void 0 ? _b : "");\n            const itemTitle = sanitizer_service/* SanitizerService.getSanitizedString */.Y.getSanitizedString(item.space.name);\n            const itemAttributes = {\n                url: this.platformUtils.buildRestUrl(relativeUrl, true),\n                label: `${itemTitle}`,\n            };\n            const $item = $(`<li><a href="${itemAttributes.url}"><span>${itemAttributes.label}</span></a></li>`);\n            return $item;\n        });\n    }\n}\n\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/search/search-space.service.ts\nvar search_space_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/search/search-space.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dialog/template-names.enum.ts\nvar template_names_enum = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dialog/template-names.enum.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dialog/warning-dialog-type.enum.ts\nvar warning_dialog_type_enum = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dialog/warning-dialog-type.enum.ts");\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/components/process-net-macro-dialog.component.ts\nvar process_net_macro_dialog_component_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nconst PlatformMacroDialog = (0,plugin_specific_factory/* getPlatformService */.km)().getPlatformMacroDialog() || {};\nconst PlatformUtils = (0,plugin_specific_factory/* getPlatformService */.km)().getPlatformUtils() || {};\nconst PluginService = (0,plugin_specific_factory/* getPluginService */.j)();\nconst licenseService = new license_service/* LicenseService */.E();\nconst dialogService = new dialog_service/* DialogService */.x();\nconst languageRestService = language_rest_factory/* getLanguageRestService */.GU();\nconst spacePermissionsService = new space_permissions_service/* SpacePermissionsService */.E(languageRestService);\nconst macroName = PluginService.getProcessNetMacroName();\nconst pluginShorthand = PluginService.getPluginShorthand();\nconst dialogId = `#vxcp-ent-dialog-process-net-macro-${pluginShorthand}`;\nconst errorClass = `.vxcp-ent-dialog-process-net-macro-${pluginShorthand}-error`;\nlet currentMacroType;\n(($) => process_net_macro_dialog_component_awaiter(void 0, void 0, void 0, function* () {\n    yield PlatformMacroDialog.bindCodeToRte();\n    yield initMacroDialog($);\n}))($);\nfunction initMacroDialog($) {\n    return process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n        const pageSearchInputComponent = new page_search_input_component/* PageSearchInputComponent */.c(PlatformUtils, new time_service/* TimeService */.O());\n        const spaceSearchInputComponent = new SpaceSearchInputComponent(PlatformUtils, new time_service/* TimeService */.O());\n        const tabbedDialogService = new tabbed_dialog_service/* TabbedDialogService */.t();\n        const searchPageService = new search_page_service/* SearchPageService */.Q();\n        const searchSpaceService = new search_space_service/* SearchSpaceService */.G();\n        const searchSuggestionsService = new search_suggestions_service/* SearchSuggestionsService */.N(new enum_converter_service/* EnumConverterService */.A(), new macro_service/* MacroService */.f(new enum_converter_service/* EnumConverterService */.A()));\n        const customDialog = yield PlatformUtils.getTemplate(template_names_enum/* TemplateNamesEnum.MACRO_DIALOG_PROCESS_NET */.X.MACRO_DIALOG_PROCESS_NET, { pluginShorthand });\n        $("body").append(customDialog);\n        currentMacroType = ProcessNetMacroTypeEnum.SPACE;\n        const $pageInput = $(dialogId + "-page-name-input");\n        const $cancel = $(dialogId + "-close");\n        const $submit = $(dialogId + "-submit");\n        const $spaceInput = $(dialogId + "-space-name-input");\n        let selectedSpaceKey = "";\n        let selectedPageId = "";\n        const errorId = $(dialogId + "-error");\n        tabbedDialogService.initDialogEventListeners();\n        $(dialogId + "-space-menu").on("click", () => {\n            currentMacroType = ProcessNetMacroTypeEnum.SPACE;\n        });\n        $(dialogId + "-page-menu").on("click", () => {\n            currentMacroType = ProcessNetMacroTypeEnum.PAGE;\n        });\n        yield pageSearchInputComponent.init({\n            $input: $("#vxcp-ent-dialog-process-net-macro-BPMN-page-name-input"),\n            $resultsWrapper: $("#vxcp-ent-process-net-confluence-page-results"),\n            search: (value, startFrom, cursor) => process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n                return searchPage(searchPageService, pageSearchInputComponent, value, startFrom, cursor);\n            }),\n            onReset: (value, bEmpty) => {\n                $submit.prop("disabled", true);\n            },\n            onResultListItemClick: (e, item) => process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n                yield onPageResultListItemClick(pageSearchInputComponent, e, item);\n            }),\n            spinnerType: "new",\n            suggest: () => process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () { return searchSuggestionsService.fetchSuggestions([yield searchSuggestionsService.createLastUpdatedPagesProvider(), yield searchSuggestionsService.createLastViewedPagesProvider()]); }),\n        });\n        yield pageSearchInputComponent.bind();\n        yield pageSearchInputComponent.suggest();\n        yield spaceSearchInputComponent.init({\n            $input: $("#vxcp-ent-dialog-process-net-macro-BPMN-space-name-input"),\n            $resultsWrapper: $("#vxcp-ent-process-net-confluence-space-results"),\n            search: (value, startFrom, cursor) => process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n                return searchSpace(searchSpaceService, spaceSearchInputComponent, value, startFrom, cursor);\n            }),\n            onReset: (value, bEmpty) => {\n                $submit.prop("disabled", true);\n            },\n            onResultListItemClick: (e, item) => process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n                yield onSpaceResultListItemClick(spaceSearchInputComponent, e, item);\n            }),\n            spinnerType: "new",\n        });\n        yield spaceSearchInputComponent.bind();\n        yield spaceSearchInputComponent.suggest();\n        $cancel.off();\n        $cancel.on("click", (e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            PlatformMacroDialog.hideProcessNetMacroDialog();\n        });\n        dialog_service/* DialogService.initEscKey */.x.initEscKey($spaceInput, $cancel);\n        dialog_service/* DialogService.initEnterKey */.x.initEnterKey($spaceInput, $submit);\n        $spaceInput.on("keydown", () => {\n            selectedSpaceKey = "";\n            $submit.prop("disabled", true);\n        });\n        $pageInput.on("keydown", () => {\n            selectedPageId = "";\n            $submit.prop("disabled", true);\n        });\n        $submit.on("click", (e) => process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n            e.stopPropagation();\n            e.preventDefault();\n            if (!checkInputNotEmpty(selectedSpaceKey, selectedPageId)) {\n                const errorText = yield PlatformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.process-net.macro-dialog.no-empty-input");\n                $(`${errorId}-${currentMacroType}`).text(errorText);\n                return;\n            }\n            yield submitMacro(selectedSpaceKey, selectedPageId);\n        }));\n        PlatformMacroDialog.registerOpenerFunctionProcessNet(insertEditMacro);\n        function onPageResultListItemClick(searchInput, e, item) {\n            return process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n                yield searchInput.onResultListItemClickDefault(e, item);\n                if (item.id) {\n                    selectedPageId = item.id;\n                    $submit.prop("disabled", false);\n                }\n            });\n        }\n        function onSpaceResultListItemClick(searchInput, e, item) {\n            return process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n                yield searchInput.reset(item.space.name, false);\n                if (item.space.key) {\n                    selectedSpaceKey = item.space.key;\n                    $submit.prop("disabled", false);\n                }\n            });\n        }\n        function searchPage(searchPageServ, searchInput, value, startFrom, cursor) {\n            return process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n                return searchPageServ.searchPageWithCql(value, (results, start) => process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n                    return searchInput.progress(value, results, start);\n                }), (results, maxTotalSize, nextStart, _cursor) => process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n                    return searchInput.done(value, results, maxTotalSize, nextStart, _cursor);\n                }), undefined, startFrom, cursor);\n            });\n        }\n        function searchSpace(searchSpaceServ, searchInput, value, startFrom, cursor) {\n            return process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n                return searchSpaceServ.searchSpaceWithCql(value, (results, start) => process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n                    return searchInput.progress(value, results, start);\n                }), (results, maxTotalSize, nextStart, _cursor) => process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n                    return searchInput.done(value, results, maxTotalSize, nextStart, _cursor);\n                }), undefined, startFrom, cursor);\n            });\n        }\n    });\n}\nfunction checkInputNotEmpty(selectedSpaceKey, selectedPageId) {\n    if (currentMacroType === ProcessNetMacroTypeEnum.SPACE) {\n        return !!selectedSpaceKey;\n    }\n    else if (currentMacroType === ProcessNetMacroTypeEnum.PAGE) {\n        return !!selectedPageId;\n    }\n    return false;\n}\nfunction clearFields() {\n    const $spaceInput = $(dialogId + "-space-name-input");\n    const $pageInput = $(dialogId + "-page-name-input");\n    const $error = $(errorClass);\n    $spaceInput.val("");\n    $pageInput.val("");\n    $error.text("");\n}\nfunction submitMacro(spaceKey, pageId) {\n    return process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n        let currentParams = {};\n        const processNetId = (0,id_generator_service/* generateVbcpProcessNetId */.l)();\n        switch (currentMacroType) {\n            case ProcessNetMacroTypeEnum.SPACE:\n                currentParams = { "vxcp-process-net-id": processNetId, spaceKey, pageId: "" };\n                break;\n            case ProcessNetMacroTypeEnum.PAGE:\n                currentParams = { "vxcp-process-net-id": processNetId, pageId, spaceKey: "" };\n                break;\n        }\n        const macro = {\n            name: macroName.trim(),\n            params: currentParams,\n            body: "",\n        };\n        PlatformUtils.addMacroToPage(macro, dialogId);\n    });\n}\nfunction resetMacroDialog($submit, $loadingDiv, $form, $dialog) {\n    clearFields();\n    $(dialogId + "-restricted-warning").hide();\n    $submit.hide();\n    $loadingDiv.show();\n    $form.hide();\n    $dialog.removeClass("aui-dialog2-warning");\n}\nfunction insertEditMacro(macro) {\n    return process_net_macro_dialog_component_awaiter(this, void 0, void 0, function* () {\n        yield PlatformMacroDialog.lazyLoadI18nTexts();\n        const $dialog = $(dialogId);\n        const $submit = $(dialogId + "-submit");\n        const $input = $(dialogId + "-name-input");\n        const licenseType = yield licenseService.getLicenseType();\n        const licenseFlag = yield licenseService.licenseHandlingForMacroDialogBefore(licenseType);\n        if (!licenseFlag) {\n            return;\n        }\n        const envParams = yield PlatformUtils.getParams();\n        if (envParams.cloudContentType === "comment") {\n            yield dialogService.confirmWarningDialog(warning_dialog_type_enum/* WarningDialogTypeEnum.MACRO_NOT_ALLOWED_HERE */.K.MACRO_NOT_ALLOWED_HERE);\n            return;\n        }\n        if (macro.params) {\n            const spaceKey = macro.params.spaceKey;\n            const $form = $(dialogId + " form");\n            const $loadingDiv = $(dialogId + "-loading-space-permissions");\n            resetMacroDialog($submit, $loadingDiv, $form, $dialog);\n            const spaceInput = $(`${dialogId}-space-name-input`);\n            spaceInput.val(spaceKey);\n            PlatformUtils.showDialog(dialogId);\n            $(".aui-blanket.vxcp-ent-blanket").remove();\n            const spaceKeyForPermission = envParams.spaceKey;\n            const hasPermissions = yield spacePermissionsService.checkSpacePermissions(dialogId, spaceKeyForPermission, $loadingDiv, $dialog, $form, $submit, $input);\n            if (!hasPermissions) {\n                return;\n            }\n        }\n        else {\n            const $form = $(dialogId + " form");\n            const $loadingDiv = $(dialogId + "-loading-space-permissions");\n            resetMacroDialog($submit, $loadingDiv, $form, $dialog);\n            PlatformUtils.showDialog(dialogId);\n            $(".aui-blanket.vxcp-ent-blanket").remove();\n            const spaceKey = envParams.spaceKey;\n            yield spacePermissionsService.checkSpacePermissions(dialogId, spaceKey, $loadingDiv, $dialog, $form, $submit, $input);\n            const spaceKeyForPermission = envParams.spaceKey;\n            const hasPermissions = yield spacePermissionsService.checkSpacePermissions(dialogId, spaceKeyForPermission, $loadingDiv, $dialog, $form, $submit, $input);\n            if (!hasPermissions) {\n                return;\n            }\n        }\n        yield licenseService.licenseHandlingForMacroDialogAfter(licenseType);\n    });\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/components/process-net-macro-dialog.component.ts_+_2_modules?')},"../../../../../../vXCP-enterprise-core/core-js/app/components/search/page-search-input.component.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "c": () => (/* binding */ PageSearchInputComponent)\n/* harmony export */ });\n/* harmony import */ var _search_input_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/components/search/search-input.component.ts");\n/* harmony import */ var _services_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\nclass PageSearchInputComponent extends _search_input_component__WEBPACK_IMPORTED_MODULE_0__/* .SearchInputComponent */ .JD {\n    constructor(platformUtils, timeService) {\n        super(platformUtils, timeService);\n    }\n    createResultListItemDefault(item) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const relativeUrl = _services_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(item._links.webui);\n            const pageSpace = _services_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(item.space.name);\n            const itemTitle = _services_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(item.title);\n            const itemAttributes = {\n                url: this.platformUtils.buildRestUrl(relativeUrl, true),\n                label: `${itemTitle} (${pageSpace})`,\n            };\n            const $item = $(`<li><a href="${itemAttributes.url}"><span>${itemAttributes.label}</span></a></li>`);\n            return $item;\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/components/search/page-search-input.component.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/components/search/search-input.component.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "JD": () => (/* binding */ SearchInputComponent)\n/* harmony export */ });\n/* unused harmony exports DEFAULT_VALUE_MIN_LENGTH, DEFAULT_VALUE_NARROW_LENGTH, SEARCH_SUGGESTIONS_CATEGORY_ICONS */\n/* harmony import */ var _model_enum_app_app_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/app-type.enum.ts");\n/* harmony import */ var _model_enum_browser_key_name_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/browser/key-name.enum.ts");\n/* harmony import */ var _model_enum_search_search_suggestions_category_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/search/search-suggestions-category.enum.ts");\n/* harmony import */ var _core_utils_core_function_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../core/utils/core-function-utils.ts");\n/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _services_search_suggestions_search_suggestions_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/search/suggestions/search-suggestions.service.ts");\n/* harmony import */ var _services_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\nconst DEFAULT_VALUE_MIN_LENGTH = 1;\nconst DEFAULT_VALUE_NARROW_LENGTH = 4;\nconst SEARCH_SUGGESTIONS_CATEGORY_ICONS = {\n    [_model_enum_search_search_suggestions_category_enum__WEBPACK_IMPORTED_MODULE_2__/* .SearchSuggestionsCategoryEnum.LastUpdated */ .x.LastUpdated]: "aui-iconfont-edit",\n    [_model_enum_search_search_suggestions_category_enum__WEBPACK_IMPORTED_MODULE_2__/* .SearchSuggestionsCategoryEnum.LastViewed */ .x.LastViewed]: "aui-iconfont-view",\n};\nclass SearchInputComponent {\n    constructor(platformUtils, timeService) {\n        this.platformUtils = platformUtils;\n        this.timeService = timeService;\n        this.options = {\n            $input: $(),\n            $resultsWrapper: $(),\n            search: () => __awaiter(this, void 0, void 0, function* () {\n                return ({\n                    results: [],\n                });\n            }),\n            createResultListItem: (item) => __awaiter(this, void 0, void 0, function* () { return this.createResultListItemDefault(item); }),\n            onResultListItemClick: (e, item) => __awaiter(this, void 0, void 0, function* () { return this.onResultListItemClickDefault(e, item); }),\n            createSuggestionListItem: (item) => __awaiter(this, void 0, void 0, function* () { return this.createSuggestionListItemDefault(item); }),\n            onSuggestionListItemClick: (e, item) => __awaiter(this, void 0, void 0, function* () { return this.onSuggestionListItemClickDefault(e, item); }),\n        };\n        this.searchInputDelay = 600;\n        this.dropdownScrollDelay = 400;\n        this.valueMinLength = DEFAULT_VALUE_MIN_LENGTH;\n        this.valueNarrowLength = DEFAULT_VALUE_NARROW_LENGTH;\n        this.$inputSuffix = $();\n        this.$inputLoading = $();\n        this.$resultsDropdown = $();\n        this.$resultsList = $();\n        this.$resultsHint = $();\n        this.$resultsLoading = $();\n        this.$resultsNoResults = $();\n        this.$resultsLoadMore = $();\n        this.$suggestionsWrapper = $();\n        this.$suggestionsDropdown = $();\n        this.$suggestionsList = $();\n    }\n    init(options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.options = Object.assign(Object.assign({}, this.options), options);\n            const $inputParent = this.$input.parent();\n            if (!$inputParent.hasClass("vxcp-ent-input-with-suffix")) {\n                $inputParent.addClass("vxcp-ent-input-with-suffix");\n            }\n            this.$inputSuffix = this.$input.siblings(".vxcp-ent-input-suffix");\n            if (!this.$inputSuffix.length) {\n                this.$inputSuffix = $(`<div class="vxcp-ent-input-suffix"></div>`);\n                this.$input.after(this.$inputSuffix);\n            }\n            this.$inputLoading = this.$inputSuffix.find(".vxcp-ent-input-loading");\n            if (!this.$inputLoading.length) {\n                this.$inputLoading = this.createLoadingSpinner(this.options.spinnerType, "small");\n                this.$inputLoading.addClass("vxcp-ent-input-loading vxcp-ent-hidden");\n                this.$inputSuffix.prepend(this.$inputLoading);\n            }\n            this.$resultsDropdown = this.$resultsWrapper.find(".aui-dropdown");\n            this.$resultsList = this.$resultsDropdown.children("ul");\n            this.$resultsHint = this.$resultsDropdown.children(".vxcp-ent-autocomplete-dropdown-hint");\n            if (!this.$resultsHint.length) {\n                this.$resultsHint = $(`<div class="vxcp-ent-autocomplete-dropdown-hint"></div>`);\n                this.$resultsDropdown.prepend(this.$resultsHint);\n            }\n            this.$resultsLoading = this.$resultsDropdown.children(".vxcp-ent-autocomplete-dropdown-loading");\n            if (!this.$resultsLoading.length) {\n                const loadingText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.search.searching");\n                this.$resultsLoading = $(`<div class="vxcp-ent-autocomplete-dropdown-loading vxcp-ent-hidden"><span>${loadingText}</span></div>`);\n                this.$resultsLoading.prepend(this.createLoadingSpinner(this.options.spinnerType, "small"));\n                this.$resultsDropdown.prepend(this.$resultsLoading);\n            }\n            this.$resultsNoResults = this.$resultsDropdown.children(".vxcp-ent-autocomplete-dropdown-no-results");\n            if (!this.$resultsNoResults.length) {\n                const noResultsText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.search.no-results");\n                this.$resultsNoResults = $(`<div class="vxcp-ent-autocomplete-dropdown-no-results vxcp-ent-hidden"><span class="aui-icon aui-icon-small aui-iconfont-warning"></span><span>${noResultsText}</span></div>`);\n                this.$resultsDropdown.prepend(this.$resultsNoResults);\n            }\n            this.$suggestionsWrapper = this.$resultsWrapper.next(".vxcp-ent-autocomplete-suggestions");\n            if (!this.$suggestionsWrapper.length) {\n                const suggestionsHintText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.search-suggestions.hint");\n                this.$suggestionsWrapper = $(`<div class="aui-dd-parent vxcp-ent-autocomplete-suggestions vxcp-ent-hidden">\n                    <div class="aui-dropdown aui-dropdown-left">\n                        <div class="vxcp-ent-autocomplete-dropdown-hint">\n                            <span class="aui-icon aui-icon-small aui-iconfont-space-personal"></span>\n                            ${suggestionsHintText}:\n                        </div>\n                        <ul></ul>\n                    </div>\n                </div>`);\n                this.$resultsWrapper.after(this.$suggestionsWrapper);\n            }\n            this.$suggestionsDropdown = this.$suggestionsWrapper.find(".aui-dropdown");\n            this.$suggestionsList = this.$suggestionsDropdown.children("ul");\n            this.$suggestionsList.empty();\n        });\n    }\n    bind() {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.$input.off();\n            this.$input\n                .on("input", _core_utils_core_function_utils__WEBPACK_IMPORTED_MODULE_6__.debounce(() => __awaiter(this, void 0, void 0, function* () {\n                var _a;\n                this.$input.removeClass("invalid");\n                const value = (_a = this.$input.val()) === null || _a === void 0 ? void 0 : _a.toString().trim();\n                if (!value) {\n                    this.reset("");\n                    if (this.hasSuggestions) {\n                        this.$suggestionsWrapper.removeClass("vxcp-ent-hidden");\n                    }\n                    return;\n                }\n                if (value.length < this.valueMinLength) {\n                    this.reset(value);\n                    if (this.hasSuggestions) {\n                        this.$suggestionsWrapper.removeClass("vxcp-ent-hidden");\n                    }\n                    return;\n                }\n                return this.search(value);\n            }), this.searchInputDelay))\n                .on("focus", (e) => {\n                if (this.isDropdownFilled) {\n                    this.$resultsWrapper.removeClass("vxcp-ent-hidden");\n                }\n                else if (this.hasSuggestions) {\n                    this.$suggestionsWrapper.removeClass("vxcp-ent-hidden");\n                }\n            })\n                .on("blur", (e) => {\n                this.$resultsWrapper.addClass("vxcp-ent-hidden");\n                this.$suggestionsWrapper.addClass("vxcp-ent-hidden");\n                const $children = this.$resultsList.children();\n                if ($children.length > 0) {\n                    $children.get(0).scrollIntoView();\n                }\n            })\n                .on("keydown", _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__.keyListener(_model_enum_browser_key_name_enum__WEBPACK_IMPORTED_MODULE_1__/* .KeyNameEnum.ArrowDown */ .i.ArrowDown, (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                if (!this.$visibleList.length) {\n                    return;\n                }\n                const $activeItem = this.$visibleList.find("li.active");\n                $activeItem.removeClass("active");\n                const $nextItem = $activeItem.next("li");\n                const $itemToSelect = $nextItem.length ? $nextItem : this.$visibleList.find("li:first-of-type");\n                if ($itemToSelect.length) {\n                    $itemToSelect.addClass("active");\n                    $itemToSelect.get(0).scrollIntoView({ block: "end" });\n                }\n            })))\n                .on("keydown", _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__.keyListener(_model_enum_browser_key_name_enum__WEBPACK_IMPORTED_MODULE_1__/* .KeyNameEnum.ArrowUp */ .i.ArrowUp, (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                if (!this.$visibleList.length) {\n                    return;\n                }\n                const $activeItem = this.$visibleList.find("li.active");\n                $activeItem.removeClass("active");\n                const $previousItem = $activeItem.prev("li");\n                const $itemToSelect = $previousItem.length ? $previousItem : this.$visibleList.find("li:last-of-type");\n                if ($itemToSelect.length) {\n                    $itemToSelect.addClass("active");\n                    $itemToSelect.get(0).scrollIntoView({ block: "nearest" });\n                }\n            })))\n                .on("keydown", _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__.keyListener(_model_enum_browser_key_name_enum__WEBPACK_IMPORTED_MODULE_1__/* .KeyNameEnum.PageDown */ .i.PageDown, (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                if (!this.$visibleList.length) {\n                    return;\n                }\n                const $activeItem = this.$visibleList.find("li.active");\n                $activeItem.removeClass("active");\n                const $lastItem = this.$visibleList.find("li:last-of-type");\n                const $itemToSelect = $lastItem;\n                if ($itemToSelect.length) {\n                    $lastItem.addClass("active");\n                    $lastItem.get(0).scrollIntoView({ block: "end" });\n                }\n            })))\n                .on("keydown", _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__.keyListener(_model_enum_browser_key_name_enum__WEBPACK_IMPORTED_MODULE_1__/* .KeyNameEnum.PageUp */ .i.PageUp, (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                if (!this.$visibleList.length) {\n                    return;\n                }\n                const $activeItem = this.$visibleList.find("li.active");\n                $activeItem.removeClass("active");\n                const $firstItem = this.$visibleList.find("li:first-of-type");\n                const $itemToSelect = $firstItem;\n                if ($itemToSelect.length) {\n                    $firstItem.addClass("active");\n                    $firstItem.get(0).scrollIntoView({ block: "start" });\n                }\n            })))\n                .on("keydown", _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__.keyListener(_model_enum_browser_key_name_enum__WEBPACK_IMPORTED_MODULE_1__/* .KeyNameEnum.Enter */ .i.Enter, (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                if (!this.$visibleList.length) {\n                    return;\n                }\n                const $activeItem = this.$visibleList.find("li.active");\n                $activeItem.trigger("mousedown");\n                this.$input.blur();\n            })))\n                .on("keydown", _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__.keyListener(_model_enum_browser_key_name_enum__WEBPACK_IMPORTED_MODULE_1__/* .KeyNameEnum.Escape */ .i.Escape, (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                this.$resultsWrapper.addClass("vxcp-ent-hidden");\n                this.$suggestionsWrapper.addClass("vxcp-ent-hidden");\n            })));\n            this.$resultsDropdown.off();\n            this.$resultsDropdown.on("scroll", _core_utils_core_function_utils__WEBPACK_IMPORTED_MODULE_6__.debounce((e) => __awaiter(this, void 0, void 0, function* () {\n                if (!this.lastValue || !this.lastNextStart) {\n                    return;\n                }\n                const dropdownHeight = this.$resultsDropdown.height() || 0;\n                const dropdownScroll = this.$resultsDropdown.scrollTop() || 0;\n                const resultsListHeight = this.$resultsList.height() || 0;\n                const delta = resultsListHeight - dropdownScroll;\n                if (delta <= dropdownHeight) {\n                    return this.search(this.lastValue, this.lastNextStart, this.lastCursor);\n                }\n            }), this.dropdownScrollDelay));\n        });\n    }\n    reset(value = "", bEmpty = true) {\n        this.$input.val(value);\n        this.$input.removeClass("invalid");\n        this.$inputLoading.addClass("vxcp-ent-hidden");\n        this.$resultsWrapper.addClass("vxcp-ent-hidden");\n        this.$resultsLoading.addClass("vxcp-ent-hidden");\n        this.$resultsNoResults.addClass("vxcp-ent-hidden");\n        if (bEmpty) {\n            this.$resultsList.empty();\n            this.$resultsHint.empty();\n        }\n        if (this.options.onReset) {\n            this.options.onReset(value);\n        }\n    }\n    resetSuggestions() {\n        this.$suggestionsList.empty();\n    }\n    focus() {\n        this.$input.focus();\n    }\n    suggest() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!this.options.suggest) {\n                return;\n            }\n            this.resetSuggestions();\n            this.$suggestionsList.off();\n            this.$suggestionsList.on("click", (e) => {\n                e.preventDefault();\n                e.stopPropagation();\n                this.$input.blur();\n            });\n            const searchSuggestionsItems = yield this.options.suggest();\n            yield _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__.asyncForEach(searchSuggestionsItems, (item) => __awaiter(this, void 0, void 0, function* () {\n                const $item = yield this.options.createSuggestionListItem(item);\n                this.$suggestionsList.append($item);\n                $item.off();\n                $item.on("mouseover", (e) => __awaiter(this, void 0, void 0, function* () {\n                    const $activeItem = this.$suggestionsList.find("li.active");\n                    $activeItem.removeClass("active");\n                    $item.addClass("active");\n                }));\n                $item.on("mousedown", (e) => __awaiter(this, void 0, void 0, function* () {\n                    e.preventDefault();\n                    const $activeItem = this.$suggestionsList.find("li.active");\n                    $activeItem.removeClass("active");\n                    $item.addClass("active");\n                    return this.options.onSuggestionListItemClick(e, item);\n                }));\n            }));\n            if (this.hasSuggestions && this.isInputFocused) {\n                this.$suggestionsWrapper.removeClass("vxcp-ent-hidden");\n            }\n        });\n    }\n    search(value, startFrom = 0, cursor) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (startFrom === 0) {\n                this.$resultsList.empty();\n                this.$resultsHint.empty();\n                this.$resultsNoResults.addClass("vxcp-ent-hidden");\n                this.$resultsDropdown.scrollTop(0);\n            }\n            if (this.options.validate && !(yield this.options.validate(value))) {\n                return false;\n            }\n            this.$suggestionsWrapper.addClass("vxcp-ent-hidden");\n            this.$resultsWrapper.removeClass("vxcp-ent-hidden");\n            this.$inputLoading.removeClass("vxcp-ent-hidden");\n            this.$resultsLoading.removeClass("vxcp-ent-hidden");\n            this.$resultsLoadMore.remove();\n            this.$resultsList.off();\n            this.$resultsList.on("click", (e) => {\n                e.preventDefault();\n                e.stopPropagation();\n                this.$input.blur();\n            });\n            return this.options.search(value, startFrom, cursor);\n        });\n    }\n    progress(value, results, start) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.$resultsNoResults.addClass("vxcp-ent-hidden");\n            this.$resultsLoadMore.remove();\n            if (!results) {\n                return [];\n            }\n            yield _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__.asyncForEach(results, (item) => __awaiter(this, void 0, void 0, function* () {\n                const $item = yield this.options.createResultListItem(item);\n                this.$resultsList.append($item);\n                $item.off();\n                $item.on("mouseover", (e) => __awaiter(this, void 0, void 0, function* () {\n                    const $activeItem = this.$resultsList.find("li.active");\n                    $activeItem.removeClass("active");\n                    $item.addClass("active");\n                }));\n                $item.on("mousedown", (e) => __awaiter(this, void 0, void 0, function* () {\n                    e.preventDefault();\n                    const $activeItem = this.$resultsList.find("li.active");\n                    $activeItem.removeClass("active");\n                    $item.addClass("active");\n                    return this.options.onResultListItemClick(e, item);\n                }));\n            }));\n            return results;\n        });\n    }\n    done(value, results, maxTotalSize, nextStart, cursor, filteredResultsCount) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.lastValue = value;\n            this.lastNextStart = nextStart;\n            this.lastCursor = cursor;\n            const itemsAmount = this.$resultsList.children("li").length;\n            if (nextStart) {\n                if (maxTotalSize - itemsAmount > 0) {\n                    return this.search(value, nextStart, cursor);\n                }\n            }\n            this.$inputLoading.addClass("vxcp-ent-hidden");\n            this.$resultsLoading.addClass("vxcp-ent-hidden");\n            if (itemsAmount === 0) {\n                this.$resultsNoResults.removeClass("vxcp-ent-hidden");\n                return;\n            }\n            if (nextStart) {\n                const hintText = value.length <= this.valueNarrowLength\n                    ? yield this.platformUtils.getText(`de.viadee.confluence.viadee-plugin-enterprise.search.more-results-found-narrow-search`)\n                    : yield this.platformUtils.getText(`de.viadee.confluence.viadee-plugin-enterprise.search.more-results-found`);\n                this.$resultsHint.html(`<span class="aui-icon aui-icon-small aui-iconfont-info"></span>${hintText}`);\n                this.$resultsLoadMore = $(`<li class="vxcp-ent-autocomplete-load-more"><button class="aui-button aui-button-link"></button></li>`);\n                this.$resultsList.append(this.$resultsLoadMore);\n                const loadMoreText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.message.load-more");\n                this.$resultsLoadMore.children("button").text(loadMoreText);\n                this.$resultsLoadMore.off();\n                this.$resultsLoadMore.on("mousedown", (e) => __awaiter(this, void 0, void 0, function* () {\n                    e.stopPropagation();\n                    e.preventDefault();\n                    this.$resultsLoadMore.children("button").html("&nbsp;");\n                    this.$resultsLoadMore.off();\n                    this.$input.focus();\n                    return this.search(value, nextStart, cursor);\n                }));\n            }\n        });\n    }\n    onResultListItemClickDefault(e, item) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.reset(item.title, false);\n        });\n    }\n    onSuggestionListItemClickDefault(e, item) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return this.options.onResultListItemClick(e, item);\n        });\n    }\n    createResultListItemDefault(item) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const sanitizedItemTitle = _services_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(item.title);\n            const sanitizedItemLinksSelf = _services_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(item._links.self);\n            const $item = $(`<li><a href="${sanitizedItemTitle}"><span>${sanitizedItemLinksSelf}</span></a></li>`);\n            return $item;\n        });\n    }\n    createSuggestionListItemDefault(item) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $item = yield this.createResultListItemDefault(item);\n            const $categoryLabel = yield this.createSuggestionListItemCategoryLabel(item);\n            if (!($categoryLabel === null || $categoryLabel === void 0 ? void 0 : $categoryLabel.length)) {\n                return $item;\n            }\n            $item.children("a").append($categoryLabel);\n            return $item;\n        });\n    }\n    createSuggestionListItemCategoryLabel(item) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const categoryLabelValue = yield this.getSuggestionCategoryLabelValue(item);\n            if (!categoryLabelValue) {\n                return;\n            }\n            const categoryIcon = SEARCH_SUGGESTIONS_CATEGORY_ICONS[item.category];\n            const categoryLabelText = yield this.platformUtils.getText(`de.viadee.confluence.viadee-plugin-enterprise.search-suggestions.${item.category}`);\n            return $(`<div><span class="aui-icon aui-icon-small ${categoryIcon}"></span><span>${categoryLabelText}: ${categoryLabelValue}</span></div>`);\n        });\n    }\n    createLoadingSpinner(type, size) {\n        const useLegacy = type === "legacy" || (type !== "new" && this.platformUtils.getAppType() !== _model_enum_app_app_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AppTypeEnum.CLOUD_ENTERPRISE */ .K.CLOUD_ENTERPRISE);\n        if (useLegacy) {\n            const $legacySpinner = $(`<span class="aui-icon aui-icon-wait"></span>`);\n            if (size) {\n                $legacySpinner.addClass("aui-icon-" + size);\n            }\n            return $legacySpinner;\n        }\n        const $spinner = $(`<aui-spinner></aui-spinner>`);\n        if (size) {\n            $spinner.attr("size", size);\n        }\n        return $spinner;\n    }\n    getSuggestionCategoryLabelValue(item) {\n        return __awaiter(this, void 0, void 0, function* () {\n            switch (item.category) {\n                case _model_enum_search_search_suggestions_category_enum__WEBPACK_IMPORTED_MODULE_2__/* .SearchSuggestionsCategoryEnum.LastUpdated */ .x.LastUpdated:\n                case _model_enum_search_search_suggestions_category_enum__WEBPACK_IMPORTED_MODULE_2__/* .SearchSuggestionsCategoryEnum.LastViewed */ .x.LastViewed:\n                    const itemDate = _services_search_suggestions_search_suggestions_service__WEBPACK_IMPORTED_MODULE_4__/* .SearchSuggestionsService.getSuggestionItemDate */ .N.getSuggestionItemDate(item);\n                    return itemDate && this.timeService.fromNow(itemDate);\n            }\n        });\n    }\n    get $input() {\n        return this.options.$input;\n    }\n    get $resultsWrapper() {\n        return this.options.$resultsWrapper;\n    }\n    get isInputFocused() {\n        return this.$input.is(":focus");\n    }\n    get isDropdownFilled() {\n        return !this.$resultsLoading.hasClass("vxcp-ent-hidden") || !this.$resultsList.is(":empty") || !this.$resultsHint.is(":empty") || !this.$resultsNoResults.hasClass("vxcp-ent-hidden");\n    }\n    get hasResults() {\n        return this.$resultsList.children().length > 0;\n    }\n    get hasSuggestions() {\n        return this.$suggestionsList.children().length > 0;\n    }\n    get $visibleList() {\n        if (this.hasResults) {\n            return this.$resultsList;\n        }\n        if (this.hasSuggestions) {\n            return this.$suggestionsList;\n        }\n        return $();\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/components/search/search-input.component.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "GU": () => (/* binding */ getLanguageRestService)\n/* harmony export */ });\n/* unused harmony exports getLanguageRestServiceForPluginType, getEmptyLanguageService */\n/* harmony import */ var _model_enum_app_plugin_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/plugin-type.enum.ts");\n\n\nconst getLanguageRestService = () => {\n    if (false) {}\n    else {\n        return getBpmnRestService();\n    }\n};\nconst getLanguageRestServiceForPluginType = (pluginType) => {\n    if (pluginType === PluginTypeEnum.DMN_ENTERPRISE) {\n        return getDmnRestService();\n    }\n    else {\n        return getBpmnRestService();\n    }\n};\nconst getEmptyLanguageService = () => {\n    return new EmptyLanguageRestService();\n};\nconst getBpmnRestService = () => {\n    return window.VBCP.bpmnEntLanguageService.getLanguageRestService();\n};\nconst getDmnRestService = () => {\n    return window.VDCPENT.dmnEntLanguageService.getLanguageRestService();\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "j": () => (/* binding */ getPluginService),\n/* harmony export */   "km": () => (/* binding */ getPlatformService)\n/* harmony export */ });\n/* unused harmony export getPlatformMDFService */\nconst getPluginService = () => {\n    if (false) {}\n    else {\n        return getBpmnPluginService();\n    }\n};\nconst getDmnPluginService = () => {\n    return window.VDCPENT.dmnEntPlugin;\n};\nconst getBpmnPluginService = () => {\n    return window.VBCP.bpmnEntPlugin;\n};\nconst getPlatformService = () => {\n    if (false) {}\n    else {\n        return getBpmnPlatformService();\n    }\n};\nconst getPlatformMDFService = () => {\n    if (false) {}\n    else {\n        return getBpmnPlatformMDFService();\n    }\n};\nconst getDmnPlatformService = () => {\n    return window.VDCPENT.dmnEntPlatformJS;\n};\nconst getBpmnPlatformService = () => {\n    return window.VBCP.bpmnEntPlatformJS;\n};\nconst getDmnPlatformMDFService = () => {\n    return window.VDCPENT.dmnEntPlatformMDF;\n};\nconst getBpmnPlatformMDFService = () => {\n    return window.VBCP.bpmnEntPlatformMDF;\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/app-mode.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "v": () => (/* binding */ AppModeEnum)\n/* harmony export */ });\n/* unused harmony export APP_MODE_CLASSES */\nvar AppModeEnum;\n(function (AppModeEnum) {\n    AppModeEnum["EDITOR"] = "EDITOR";\n    AppModeEnum["PRESENTATION"] = "PRESENTATION";\n    AppModeEnum["DIFFER"] = "DIFFER";\n    AppModeEnum["DIFFER_WITH_MINIMAP"] = "DIFFER_WITH_MINIMAP";\n    AppModeEnum["XMLEDITOR"] = "XMLEDITOR";\n    AppModeEnum["TABLE"] = "TABLE";\n    AppModeEnum["VIEWER"] = "VIEWER";\n    AppModeEnum["VIEWER_DIALOG"] = "VIEWER_DIALOG";\n})(AppModeEnum || (AppModeEnum = {}));\nconst APP_MODE_CLASSES = {\n    [AppModeEnum.EDITOR]: "vxcp-ent-app-mode-editor",\n    [AppModeEnum.PRESENTATION]: "vxcp-ent-app-mode-presentation",\n    [AppModeEnum.XMLEDITOR]: "vxcp-ent-app-mode-xml-editor",\n    [AppModeEnum.DIFFER]: "vxcp-ent-app-mode-differ",\n    [AppModeEnum.DIFFER_WITH_MINIMAP]: "vxcp-ent-app-mode-differ",\n    [AppModeEnum.TABLE]: "vxcp-ent-app-mode-table",\n    [AppModeEnum.VIEWER_DIALOG]: "vxcp-ent-app-mode-viewer-dialog",\n    [AppModeEnum.VIEWER]: "vxcp-ent-app-mode-viewer",\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/app-mode.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/app-rest-path.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* unused harmony exports EnterpriseRestPathEnum, EnterpriseActionPathEnum, FreeRestPathEnum */\nvar EnterpriseRestPathEnum;\n(function (EnterpriseRestPathEnum) {\n    EnterpriseRestPathEnum["BPMN"] = "bpmn-modeler-enterprise";\n    EnterpriseRestPathEnum["DMN"] = "dmn-plugin-enterprise";\n})(EnterpriseRestPathEnum || (EnterpriseRestPathEnum = {}));\nvar EnterpriseActionPathEnum;\n(function (EnterpriseActionPathEnum) {\n    EnterpriseActionPathEnum["BPMN"] = "bpmn-plugin-enterprise";\n    EnterpriseActionPathEnum["DMN"] = "dmn-plugin-enterprise";\n})(EnterpriseActionPathEnum || (EnterpriseActionPathEnum = {}));\nvar FreeRestPathEnum;\n(function (FreeRestPathEnum) {\n    FreeRestPathEnum["BPMN"] = "bpmn-modeler";\n    FreeRestPathEnum["DMN"] = "dmn-modeler";\n})(FreeRestPathEnum || (FreeRestPathEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/app-rest-path.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/app-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "K": () => (/* binding */ AppTypeEnum)\n/* harmony export */ });\nvar AppTypeEnum;\n(function (AppTypeEnum) {\n    AppTypeEnum["CLOUD_ENTERPRISE"] = "cloud-enterprise";\n    AppTypeEnum["SERVER_ENTERPRISE"] = "server-enterprise";\n    AppTypeEnum["SERVER_FREE"] = "server-free";\n})(AppTypeEnum || (AppTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/app-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/dmn-table-mode.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "J": () => (/* binding */ DmnTableModeEnum)\n/* harmony export */ });\nvar DmnTableModeEnum;\n(function (DmnTableModeEnum) {\n    DmnTableModeEnum["VIEWER"] = "view";\n    DmnTableModeEnum["EDITOR"] = "edit";\n})(DmnTableModeEnum || (DmnTableModeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/dmn-table-mode.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/file-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "W": () => (/* binding */ FileTypeEnum)\n/* harmony export */ });\nvar FileTypeEnum;\n(function (FileTypeEnum) {\n    FileTypeEnum["BPMN"] = ".bpmn";\n    FileTypeEnum["SVG"] = ".svg";\n    FileTypeEnum["PNG"] = ".png";\n    FileTypeEnum["DMN"] = ".dmn";\n    FileTypeEnum["PDF"] = ".pdf";\n    FileTypeEnum["DOC"] = ".doc;.docx";\n    FileTypeEnum["PPT"] = ".ppt;.pptx";\n    FileTypeEnum["IMAGE"] = ".jpg;.jpeg;.png";\n    FileTypeEnum["CSV"] = ".csv";\n    FileTypeEnum["JSON"] = ".json";\n    FileTypeEnum["XML"] = ".xml";\n    FileTypeEnum["ANY"] = "";\n})(FileTypeEnum || (FileTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/file-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/from-mode.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "p": () => (/* binding */ FromModeEnum)\n/* harmony export */ });\nvar FromModeEnum;\n(function (FromModeEnum) {\n    FromModeEnum["URL"] = "URL";\n    FromModeEnum["CONFLUENCE_VIEWER"] = "CONFLUENCE_VIEWER";\n    FromModeEnum["CONFLUENCE_EDITOR"] = "CONFLUENCE_EDITOR";\n})(FromModeEnum || (FromModeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/from-mode.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/plugin-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "ib": () => (/* binding */ MacroEnterpriseNameEnum),\n/* harmony export */   "pi": () => (/* binding */ MacroFreeNameEnum)\n/* harmony export */ });\n/* unused harmony export PluginTypeEnum */\nvar PluginTypeEnum;\n(function (PluginTypeEnum) {\n    PluginTypeEnum["DMN"] = "DMN";\n    PluginTypeEnum["DMN_ENTERPRISE"] = "DMN";\n    PluginTypeEnum["BPMN"] = "BPMN";\n})(PluginTypeEnum || (PluginTypeEnum = {}));\nvar MacroEnterpriseNameEnum;\n(function (MacroEnterpriseNameEnum) {\n    MacroEnterpriseNameEnum["DMN"] = "vdcp-macro-enterprise";\n    MacroEnterpriseNameEnum["BPMN"] = "vbcp-macro-enterprise";\n    MacroEnterpriseNameEnum["BPMN_PROCESS_NET"] = "vbcp-enterprise-process-net-macro";\n    MacroEnterpriseNameEnum["DMN_PROCESS_NET"] = "vdcp-enterprise-process-net-macro";\n})(MacroEnterpriseNameEnum || (MacroEnterpriseNameEnum = {}));\nvar MacroFreeNameEnum;\n(function (MacroFreeNameEnum) {\n    MacroFreeNameEnum["DMN"] = "vdcp-macro";\n    MacroFreeNameEnum["BPMN"] = "vbcp-macro";\n})(MacroFreeNameEnum || (MacroFreeNameEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/plugin-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/atlassian/confluence-content-type-enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "L": () => (/* binding */ ConfluenceContentTypeEnum)\n/* harmony export */ });\nvar ConfluenceContentTypeEnum;\n(function (ConfluenceContentTypeEnum) {\n    ConfluenceContentTypeEnum[ConfluenceContentTypeEnum["PAGE"] = 0] = "PAGE";\n    ConfluenceContentTypeEnum[ConfluenceContentTypeEnum["SPACE"] = 1] = "SPACE";\n    ConfluenceContentTypeEnum[ConfluenceContentTypeEnum["ATTACHMENT"] = 2] = "ATTACHMENT";\n})(ConfluenceContentTypeEnum || (ConfluenceContentTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/atlassian/confluence-content-type-enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/browser/key-name.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "i": () => (/* binding */ KeyNameEnum)\n/* harmony export */ });\nvar KeyNameEnum;\n(function (KeyNameEnum) {\n    KeyNameEnum["Tab"] = "Tab";\n    KeyNameEnum["Enter"] = "Enter";\n    KeyNameEnum["Shift"] = "Shift";\n    KeyNameEnum["Control"] = "Control";\n    KeyNameEnum["Alt"] = "Alt";\n    KeyNameEnum["CapsLock"] = "CapsLock";\n    KeyNameEnum["Escape"] = "Escape";\n    KeyNameEnum["Space"] = "Space";\n    KeyNameEnum["PageUp"] = "PageUp";\n    KeyNameEnum["PageDown"] = "PageDown";\n    KeyNameEnum["ArrowLeft"] = "ArrowLeft";\n    KeyNameEnum["ArrowUp"] = "ArrowUp";\n    KeyNameEnum["ArrowRight"] = "ArrowRight";\n    KeyNameEnum["ArrowDown"] = "ArrowDown";\n})(KeyNameEnum || (KeyNameEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/browser/key-name.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dialog/template-names.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "X": () => (/* binding */ TemplateNamesEnum)\n/* harmony export */ });\nvar TemplateNamesEnum;\n(function (TemplateNamesEnum) {\n    TemplateNamesEnum["EXPORT_PNG_DIALOG"] = "exportPngDialog";\n    TemplateNamesEnum["USER_MENTION_DISPLAY"] = "userMentionDisplay";\n    TemplateNamesEnum["CONFLUENCE_LABEL"] = "confluenceLabel";\n    TemplateNamesEnum["CREATE_WIZARD"] = "createWizard";\n    TemplateNamesEnum["CREATE_WIZARD_DIALOG"] = "createWizardDialog";\n    TemplateNamesEnum["EXPORT_CSV_DIALOG"] = "exportCsvDialog";\n    TemplateNamesEnum["EXPORT_TABLE_TO_CONFLUENCE"] = "exportTableToConfluence";\n    TemplateNamesEnum["DIFFER"] = "differ";\n    TemplateNamesEnum["DIFFER_TABLE"] = "differTable";\n    TemplateNamesEnum["DIFFER_DIALOG"] = "differDialog";\n    TemplateNamesEnum["DIFFER_PREVIEW_DIALOG"] = "differPreviewDialog";\n    TemplateNamesEnum["DIAGRAM_AS_TABLE"] = "diagramAsTable";\n    TemplateNamesEnum["XML_EDITOR"] = "xmlEditor";\n    TemplateNamesEnum["SHORTCUT_TABLE"] = "shortcutTable";\n    TemplateNamesEnum["WELCOME_SCREEN_DIALOG"] = "welcomeScreenDialog";\n    TemplateNamesEnum["USER_SURVEY_2022_DIALOG"] = "userSurvey2022Dialog";\n    TemplateNamesEnum["MACRO_DIALOG_ENTERPRISE"] = "macroDialogEnterprise";\n    TemplateNamesEnum["MACRO_DIALOG_PROCESS_NET"] = "macroDialogProcessNet";\n    TemplateNamesEnum["PLUGIN_ANALYSIS_DIALOG"] = "pluginAnalysisDialog";\n    TemplateNamesEnum["ATTRIBUTE_PANEL"] = "attributePanel";\n    TemplateNamesEnum["MACRO_CONFIGURATION_DIALOG"] = "macroConfigurationDialog";\n    TemplateNamesEnum["MDF_EDIT_FIELD_INSTANCE"] = "mdfEditFieldInstance";\n    TemplateNamesEnum["LINTER_TABLE"] = "linterTable";\n    TemplateNamesEnum["LINTER"] = "linter";\n    TemplateNamesEnum["INCOMING_DIAGRAM_LINKS"] = "incomingDiagramLinks";\n    TemplateNamesEnum["SHOW_DIAGRAM_DIALOG"] = "showDiagramDialog";\n    TemplateNamesEnum["IMAGE_PREVIEW_DIALOG"] = "imagePreviewDialog";\n    TemplateNamesEnum["PDF_PREVIEW_DIALOG"] = "pdfPreviewDialog";\n    TemplateNamesEnum["JIRA_ISSUE_PREVIEW_DIALOG"] = "jiraIssuePreviewTemplate";\n    TemplateNamesEnum["ADD_ELEMENT_LINK_DIAOLG"] = "addElementLinkDialog";\n    TemplateNamesEnum["VERSION_HISTORY_DIALOG"] = "versionHistoryDialog";\n    TemplateNamesEnum["COMMENT_DIALOG"] = "commentDialog";\n    TemplateNamesEnum["NAVBAR"] = "navbar";\n    TemplateNamesEnum["VIADEE_INFO_DIALOG"] = "viadeeInfoDialog";\n    TemplateNamesEnum["DOWNLOAD_DIAGRAM_DIALOG"] = "downloadDiagramDialog";\n    TemplateNamesEnum["IMPORT_EXISTING_DIAGRAM_DIALOG"] = "importExistingDiagramDialog";\n    TemplateNamesEnum["NEWS_MESSAGE_BOX"] = "newsMessageBox";\n    TemplateNamesEnum["NEWS_MESSAGE_ENTRIES"] = "newsMessageEntries";\n    TemplateNamesEnum["VERSION_NAME_DIALOG"] = "versionNameDialog";\n    TemplateNamesEnum["TUTORIAL_DIALOG"] = "tutorialDialog";\n    TemplateNamesEnum["VERSION_DROPDOWN_ITEMS"] = "versionDropdownItems";\n    TemplateNamesEnum["WARNING_DIALOG"] = "warningDialog";\n    TemplateNamesEnum["IMPORT_VCS_DIAGRAM_DIALOG"] = "importVCSDiagramDialog";\n    TemplateNamesEnum["PUSH_TO_VCS_DIALOG"] = "pushToVCSDialog";\n    TemplateNamesEnum["MARKDOWN_EDITOR_DIALOG"] = "markdownEditorDialog";\n})(TemplateNamesEnum || (TemplateNamesEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dialog/template-names.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dialog/warning-dialog-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "K": () => (/* binding */ WarningDialogTypeEnum)\n/* harmony export */ });\nvar WarningDialogTypeEnum;\n(function (WarningDialogTypeEnum) {\n    WarningDialogTypeEnum["PAGE_NOT_SAVED"] = "page-not-saved";\n    WarningDialogTypeEnum["SAVE_BEFORE_IMPORT"] = "save-before-import";\n    WarningDialogTypeEnum["SAVE_BEFORE_VCS_PUSH"] = "save-before-vcs-push";\n    WarningDialogTypeEnum["SAVE_BEFORE_EXIT"] = "save-before-exit";\n    WarningDialogTypeEnum["SAVE_BEFORE_OPEN_CONFIGS"] = "save-before-open-configs";\n    WarningDialogTypeEnum["LOADING_BROKEN_XML"] = "loading-broken-xml";\n    WarningDialogTypeEnum["SAVING_INVALID_XML"] = "saving-invalid-xml";\n    WarningDialogTypeEnum["SAVING_XML_WITH_WARNINGS"] = "saving-xml-with-warnings";\n    WarningDialogTypeEnum["WRONG_FILE_FORMAT"] = "wrong-file-format";\n    WarningDialogTypeEnum["RESET_DIAGRAM"] = "reset-diagram";\n    WarningDialogTypeEnum["RESET_DIAGRAM_AND_SAVED_IN_BETWEEN"] = "reset-diagram-and-saved-in-between";\n    WarningDialogTypeEnum["DIAGRAM_SAVED_IN_BETWEEN"] = "saved-in-between";\n    WarningDialogTypeEnum["DIFFER_DIAGRAM_TOO_BIG"] = "differ-diagram-too-big";\n    WarningDialogTypeEnum["DIFFER_FILE_DOES_NOT_EXIST"] = "differ-file-does-not-exist";\n    WarningDialogTypeEnum["NO_VERSIONS_TO_COMPARE"] = "no-versions-to-compare";\n    WarningDialogTypeEnum["START_MIGRATION"] = "start-migration";\n    WarningDialogTypeEnum["BROWSER_NOT_SUPPORTED"] = "browser-not-supported";\n    WarningDialogTypeEnum["NO_PNG_UPLOAD"] = "no-png-upload";\n    WarningDialogTypeEnum["SESSION_EXPIRED"] = "session-expired";\n    WarningDialogTypeEnum["NO_CONNECTION"] = "no-connection";\n    WarningDialogTypeEnum["LICENSE_NOT_VALID"] = "license-not-valid";\n    WarningDialogTypeEnum["SOME_ERROR_APPEARED"] = "some-error-appeared";\n    WarningDialogTypeEnum["ATTACHMENTS_NOT_UPLOADED"] = "attachments-not-uploaded";\n    WarningDialogTypeEnum["EDITOR_MACRO_NOT_EXIST"] = "editor-macro-not-exist";\n    WarningDialogTypeEnum["LEGACY_WIKILINKS"] = "legacy-links";\n    WarningDialogTypeEnum["MACRO_NOT_ALLOWED_HERE"] = "macro-not-allowed-here";\n    WarningDialogTypeEnum["DUPLICATE_RENAME_ERROR"] = "duplicate-rename-error";\n    WarningDialogTypeEnum["PNG_RENAME_ERROR"] = "png-rename-error";\n    WarningDialogTypeEnum["PNG_COPY_ERROR"] = "png-copy-error";\n    WarningDialogTypeEnum["XML_RENAME_ERROR"] = "xml-rename-error";\n    WarningDialogTypeEnum["TABLE_NOT_EXPORTED"] = "table-not-exported";\n    WarningDialogTypeEnum["VERSION_NOT_AVAILABLE_EDITOR"] = "version-not-available";\n    WarningDialogTypeEnum["AUTHENTICATION_TOKEN_REQUIRED"] = "jira-authentication-token-required";\n    WarningDialogTypeEnum["DELETE_RESOLVED_COMMENTS"] = "delete-resolved-comments";\n    WarningDialogTypeEnum["RESET_ADMIN_PAGE_CONFIGS"] = "reset-admin-page-configs";\n    WarningDialogTypeEnum["DIAGRAM_ALREADY_EXISTS_ON_PAGE"] = "diagram-already-exists-on-page";\n    WarningDialogTypeEnum["DELETE_ALL_LINKS"] = "delete-all-diagram-links";\n    WarningDialogTypeEnum["SYNC_ALL_LINKS"] = "sync-all-diagram-links";\n    WarningDialogTypeEnum["NEW_DIAGRAM_NOT_SAVED"] = "new-diagram-not-saved";\n    WarningDialogTypeEnum["NEW_DIAGRAM_NOT_SAVED_YET"] = "new-diagram-not-saved-yet";\n    WarningDialogTypeEnum["COPY_DIAGRAM_AND_CREATE_MACRO_ERROR"] = "copy-diagram-and-create-macro-error";\n    WarningDialogTypeEnum["UPLOAD_DIAGRAM_AND_CREATE_MACRO_ERROR"] = "upload-diagram-and-create-macro-error";\n    WarningDialogTypeEnum["FETCH_DIAGRAM_AND_CREATE_MACRO_ERROR"] = "fetch-diagram-and-create-macro-error";\n    WarningDialogTypeEnum["FETCH_DIAGRAM_FROM_VCS_ERROR"] = "fetch-diagram-from-vcs-error";\n})(WarningDialogTypeEnum || (WarningDialogTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dialog/warning-dialog-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/element-links/overlay-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Iu": () => (/* binding */ OverlayTypeLabelEnum)\n/* harmony export */ });\n/* unused harmony exports OverlayTypeXmlEnum, OverlayTypeIconClassEnum, OverlayTypeConfigKeyEnum, DistinctOverlayType, OverlayDefaultAction */\nvar OverlayTypeXmlEnum;\n(function (OverlayTypeXmlEnum) {\n    OverlayTypeXmlEnum["EMBEDDED_COMMENTS"] = "viadee:Comment";\n    OverlayTypeXmlEnum["DOCUMENTATION"] = "bpmn:documentation";\n    OverlayTypeXmlEnum["MARKDOWN_DOCUMENTATION"] = "viadee:MarkdownDocumentation";\n    OverlayTypeXmlEnum["LEGACY_WIKILINK"] = "viadee:WikiLinks";\n    OverlayTypeXmlEnum["BPMN"] = "viadee:BpmnLinks";\n    OverlayTypeXmlEnum["DMN_ENTERPRISE"] = "viadee:DmnEnterpriseLinks";\n    OverlayTypeXmlEnum["DMN"] = "viadee:DmnLinks";\n    OverlayTypeXmlEnum["CONFLUENCE_PAGE"] = "viadee:PageLinks";\n    OverlayTypeXmlEnum["CONFLUENCE_ATTACHMENT"] = "viadee:ConfluenceAttachmentLink";\n    OverlayTypeXmlEnum["EXTERNAL_CONTENT"] = "viadee:ExternalLinks";\n    OverlayTypeXmlEnum["JIRA_ISSUE"] = "viadee:JiraIssueLink";\n    OverlayTypeXmlEnum["MDF_INSTANCE"] = "viadee:MdfInstance";\n    OverlayTypeXmlEnum["ANY"] = "viadee:AnyLinks";\n})(OverlayTypeXmlEnum || (OverlayTypeXmlEnum = {}));\nvar OverlayTypeLabelEnum;\n(function (OverlayTypeLabelEnum) {\n    OverlayTypeLabelEnum["EMBEDDED_COMMENTS"] = "embedded-comments";\n    OverlayTypeLabelEnum["DOCUMENTATION"] = "documentation";\n    OverlayTypeLabelEnum["MARKDOWN_DOCUMENTATION"] = "viadee:MarkdownDocumentation";\n    OverlayTypeLabelEnum["BPMN"] = "bpmn";\n    OverlayTypeLabelEnum["BPMN_NEW_TARGET_PAGE"] = "bpmn-new-target-page";\n    OverlayTypeLabelEnum["LEGACY_BPMN"] = "attachment";\n    OverlayTypeLabelEnum["DMN_ENTERPRISE"] = "dmn-enterprise";\n    OverlayTypeLabelEnum["DMN"] = "dmn";\n    OverlayTypeLabelEnum["DMN_NEW_TARGET_PAGE"] = "dmn-new-target-page";\n    OverlayTypeLabelEnum["CONFLUENCE_PAGE"] = "confluence-page";\n    OverlayTypeLabelEnum["LEGACY_CONFLUENCE_PAGE"] = "search-page";\n    OverlayTypeLabelEnum["CONFLUENCE_ATTACHMENT"] = "confluence-attachment";\n    OverlayTypeLabelEnum["EXTERNAL_CONTENT"] = "external-content";\n    OverlayTypeLabelEnum["LEGACY_EXTERNAL_CONTENT"] = "external";\n    OverlayTypeLabelEnum["JIRA_ISSUE"] = "jira-issue";\n    OverlayTypeLabelEnum["MDF_INSTANCE"] = "mdf-instance";\n})(OverlayTypeLabelEnum || (OverlayTypeLabelEnum = {}));\nvar OverlayTypeIconClassEnum;\n(function (OverlayTypeIconClassEnum) {\n    OverlayTypeIconClassEnum["EMBEDDED_COMMENTS"] = "";\n    OverlayTypeIconClassEnum["DOCUMENTATION"] = "vxcp-ent-icon-documentation";\n    OverlayTypeIconClassEnum["BPMN"] = "vxcp-ent-icon-bpmn";\n    OverlayTypeIconClassEnum["DMN_ENTERPRISE"] = "vxcp-ent-icon-dmn";\n    OverlayTypeIconClassEnum["DMN"] = "vxcp-ent-icon-dmn";\n    OverlayTypeIconClassEnum["CONFLUENCE_PAGE"] = "vxcp-ent-icon-confluence-page";\n    OverlayTypeIconClassEnum["CONFLUENCE_ATTACHMENT"] = "vxcp-ent-icon-attachment";\n    OverlayTypeIconClassEnum["EXTERNAL_CONTENT"] = "vxcp-ent-icon-external";\n    OverlayTypeIconClassEnum["JIRA_ISSUE"] = "vxcp-ent-icon-jira-issue";\n    OverlayTypeIconClassEnum["MDF_INSTANCE"] = "vxcp-ent-icon-mdf-instance";\n})(OverlayTypeIconClassEnum || (OverlayTypeIconClassEnum = {}));\nvar OverlayTypeConfigKeyEnum;\n(function (OverlayTypeConfigKeyEnum) {\n    OverlayTypeConfigKeyEnum["EMBEDDED_COMMENTS"] = "showEmbeddedComments";\n    OverlayTypeConfigKeyEnum["DOCUMENTATION"] = "showDocumentation";\n    OverlayTypeConfigKeyEnum["BPMN"] = "showBpmnLinks";\n    OverlayTypeConfigKeyEnum["DMN_ENTERPRISE"] = "showDmnLinks";\n    OverlayTypeConfigKeyEnum["DMN"] = "showDmnLinks";\n    OverlayTypeConfigKeyEnum["CONFLUENCE_PAGE"] = "showConfluencePageLinks";\n    OverlayTypeConfigKeyEnum["CONFLUENCE_ATTACHMENT"] = "showConfluenceAttachmentLinks";\n    OverlayTypeConfigKeyEnum["EXTERNAL_CONTENT"] = "showExternalContentLinks";\n    OverlayTypeConfigKeyEnum["JIRA_ISSUE"] = "showJiraIssueLinks";\n    OverlayTypeConfigKeyEnum["MDF_INSTANCE"] = "showMdfInstanceLinks";\n})(OverlayTypeConfigKeyEnum || (OverlayTypeConfigKeyEnum = {}));\nvar DistinctOverlayType;\n(function (DistinctOverlayType) {\n    DistinctOverlayType["DOCUMENTATION"] = "documentation";\n    DistinctOverlayType["BPMN"] = "bpmn";\n    DistinctOverlayType["DMN"] = "dmn";\n    DistinctOverlayType["CONFLUENCE_PAGE"] = "confluence-page";\n    DistinctOverlayType["EXTERNAL_CONTENT"] = "external-content";\n    DistinctOverlayType["CONFLUENCE_ATTACHMENT"] = "confluence-attachment";\n    DistinctOverlayType["JIRA_ISSUE"] = "jira";\n    DistinctOverlayType["MDF_INSTANCE"] = "mdf";\n})(DistinctOverlayType || (DistinctOverlayType = {}));\nvar OverlayDefaultAction;\n(function (OverlayDefaultAction) {\n    OverlayDefaultAction["OPEN_PANEL"] = "openPanel";\n    OverlayDefaultAction["WONT_DRAW"] = "wontDraw";\n})(OverlayDefaultAction || (OverlayDefaultAction = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/element-links/overlay-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/extensions/resize-direction.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* unused harmony export ResizeDirectionEnum */\nvar ResizeDirectionEnum;\n(function (ResizeDirectionEnum) {\n    ResizeDirectionEnum["TOP_TO_BOTTOM"] = "TOP_TO_BOTTOM";\n    ResizeDirectionEnum["BOTTOM_TO_TOP"] = "BOTTOM_TO_TOP";\n    ResizeDirectionEnum["LEFT_TO_RIGHT"] = "LEFT_TO_RIGHT";\n    ResizeDirectionEnum["RIGHT_TO_LEFT"] = "RIGHT_TO_LEFT";\n})(ResizeDirectionEnum || (ResizeDirectionEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/extensions/resize-direction.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/rest/license-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "y": () => (/* binding */ LicenseTypeEnum)\n/* harmony export */ });\nvar LicenseTypeEnum;\n(function (LicenseTypeEnum) {\n    LicenseTypeEnum["VALID"] = "VALID";\n    LicenseTypeEnum["MAINTENANCE_EXPIRED"] = "MAINTENANCE_EXPIRED";\n    LicenseTypeEnum["EVAL"] = "EVAL";\n    LicenseTypeEnum["INVALID"] = "INVALID";\n})(LicenseTypeEnum || (LicenseTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/rest/license-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/search/search-suggestions-category.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "x": () => (/* binding */ SearchSuggestionsCategoryEnum)\n/* harmony export */ });\nvar SearchSuggestionsCategoryEnum;\n(function (SearchSuggestionsCategoryEnum) {\n    SearchSuggestionsCategoryEnum["LastUpdated"] = "last-updated";\n    SearchSuggestionsCategoryEnum["LastViewed"] = "last-viewed";\n})(SearchSuggestionsCategoryEnum || (SearchSuggestionsCategoryEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/search/search-suggestions-category.enum.ts?')}},__webpack_module_cache__={},deferred;function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var t=__webpack_module_cache__[e]={id:e,loaded:!1,exports:{}};return __webpack_modules__[e].call(t.exports,t,t.exports,__webpack_require__),t.loaded=!0,t.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(e,n,t,r)=>{if(!n){var i=1/0;for(c=0;c<deferred.length;c++){for(var[n,t,r]=deferred[c],s=!0,a=0;a<n.length;a++)(!1&r||i>=r)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](n[a])))?n.splice(a--,1):(s=!1,r<i&&(i=r));if(s){deferred.splice(c--,1);var o=t();void 0!==o&&(e=o)}}return e}r=r||0;for(var c=deferred.length;c>0&&deferred[c-1][2]>r;c--)deferred[c]=deferred[c-1];deferred[c]=[n,t,r]},__webpack_require__.n=e=>{var n=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(n,{a:n}),n},__webpack_require__.d=(e,n)=>{for(var t in n)__webpack_require__.o(n,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:n[t]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},__webpack_require__.nmd=e=>(e.paths=[],e.children||(e.children=[]),e),__webpack_require__.j="bpmnEntProcessNetMacroDialog",(()=>{var e={bpmnEntProcessNetMacroDialog:0};__webpack_require__.O.j=n=>0===e[n];var n=(n,t)=>{var r,i,[s,a,o]=t,c=0;if(s.some((n=>0!==e[n]))){for(r in a)__webpack_require__.o(a,r)&&(__webpack_require__.m[r]=a[r]);if(o)var p=o(__webpack_require__)}for(n&&n(t);c<s.length;c++)i=s[c],__webpack_require__.o(e,i)&&e[i]&&e[i][0](),e[i]=0;return __webpack_require__.O(p)},t=self.webpackChunkVBCP=self.webpackChunkVBCP||[];t.forEach(n.bind(null,0)),t.push=n.bind(null,t.push.bind(t))})();var __webpack_exports__=__webpack_require__.O(void 0,["bpmnEntVendors","bpmnEntServices"],(()=>__webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/components/process-net-macro-dialog.component.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VBCP=window.VBCP||{}).bpmnEntProcessNetMacroDialog=__webpack_exports__})();