"use strict";(self.webpackChunkVBCP=self.webpackChunkVBCP||[]).push([["bpmnEntDiagramJs"],{"./node_modules/diagram-js/lib/Diagram.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ Diagram)\n});\n\n// EXTERNAL MODULE: ./node_modules/didi/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/didi/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/inherits-browser/dist/index.es.js\nvar index_es = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/draw/BaseRenderer.js\nvar BaseRenderer = __webpack_require__(\"./node_modules/diagram-js/lib/draw/BaseRenderer.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/RenderUtil.js\nvar RenderUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/RenderUtil.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar min_dash_dist_index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/draw/DefaultRenderer.js\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../core/EventBus').default} EventBus\n * @typedef {import('./Styles').default} Styles\n */\n\n// apply default renderer with lowest possible priority\n// so that it only kicks in if noone else could render\nvar DEFAULT_RENDER_PRIORITY = 1;\n\n/**\n * The default renderer used for shapes and connections.\n *\n * @param {EventBus} eventBus\n * @param {Styles} styles\n */\nfunction DefaultRenderer(eventBus, styles) {\n\n  BaseRenderer/* default.call */.Z.call(this, eventBus, DEFAULT_RENDER_PRIORITY);\n\n  this.CONNECTION_STYLE = styles.style([ 'no-fill' ], { strokeWidth: 5, stroke: 'fuchsia' });\n  this.SHAPE_STYLE = styles.style({ fill: 'white', stroke: 'fuchsia', strokeWidth: 2 });\n  this.FRAME_STYLE = styles.style([ 'no-fill' ], { stroke: 'fuchsia', strokeDasharray: 4, strokeWidth: 2 });\n}\n\n(0,index_es/* default */.Z)(DefaultRenderer, BaseRenderer/* default */.Z);\n\n\n/**\n * @private\n */\nDefaultRenderer.prototype.canRender = function() {\n  return true;\n};\n\n/**\n * @private\n */\nDefaultRenderer.prototype.drawShape = function drawShape(visuals, element, attrs) {\n  var rect = (0,dist_index_esm/* create */.Ue)('rect');\n\n  (0,dist_index_esm/* attr */.Lj)(rect, {\n    x: 0,\n    y: 0,\n    width: element.width || 0,\n    height: element.height || 0\n  });\n\n  if ((0,Elements/* isFrameElement */.He)(element)) {\n    (0,dist_index_esm/* attr */.Lj)(rect, (0,min_dash_dist_index_esm/* assign */.f0)({}, this.FRAME_STYLE, attrs || {}));\n  } else {\n    (0,dist_index_esm/* attr */.Lj)(rect, (0,min_dash_dist_index_esm/* assign */.f0)({}, this.SHAPE_STYLE, attrs || {}));\n  }\n\n  (0,dist_index_esm/* append */.R3)(visuals, rect);\n\n  return rect;\n};\n\n/**\n * @private\n */\nDefaultRenderer.prototype.drawConnection = function drawConnection(visuals, connection, attrs) {\n\n  var line = (0,RenderUtil/* createLine */.W5)(connection.waypoints, (0,min_dash_dist_index_esm/* assign */.f0)({}, this.CONNECTION_STYLE, attrs || {}));\n  (0,dist_index_esm/* append */.R3)(visuals, line);\n\n  return line;\n};\n\n/**\n * @private\n */\nDefaultRenderer.prototype.getShapePath = function getShapePath(shape) {\n\n  var x = shape.x,\n      y = shape.y,\n      width = shape.width,\n      height = shape.height;\n\n  var shapePath = [\n    [ 'M', x, y ],\n    [ 'l', width, 0 ],\n    [ 'l', 0, height ],\n    [ 'l', -width, 0 ],\n    [ 'z' ]\n  ];\n\n  return (0,RenderUtil/* componentsToPath */.KO)(shapePath);\n};\n\n/**\n * @private\n */\nDefaultRenderer.prototype.getConnectionPath = function getConnectionPath(connection) {\n  var waypoints = connection.waypoints;\n\n  var idx, point, connectionPath = [];\n\n  for (idx = 0; (point = waypoints[idx]); idx++) {\n\n    // take invisible docking into account\n    // when creating the path\n    point = point.original || point;\n\n    connectionPath.push([ idx === 0 ? 'M' : 'L', point.x, point.y ]);\n  }\n\n  return (0,RenderUtil/* componentsToPath */.KO)(connectionPath);\n};\n\nDefaultRenderer.$inject = [ 'eventBus', 'styles' ];\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/draw/Styles.js\n\n\n\n/**\n * A component that manages shape styles\n */\nfunction Styles() {\n\n  var defaultTraits = {\n\n    'no-fill': {\n      fill: 'none'\n    },\n    'no-border': {\n      strokeOpacity: 0.0\n    },\n    'no-events': {\n      pointerEvents: 'none'\n    }\n  };\n\n  var self = this;\n\n  /**\n   * Builds a style definition from a className, a list of traits and an object\n   * of additional attributes.\n   *\n   * @param {string} className\n   * @param {string[]} [traits]\n   * @param {Object} [additionalAttrs]\n   *\n   * @return {Object} the style definition\n   */\n  this.cls = function(className, traits, additionalAttrs) {\n    var attrs = this.style(traits, additionalAttrs);\n\n    return (0,min_dash_dist_index_esm/* assign */.f0)(attrs, { 'class': className });\n  };\n\n  /**\n   * Builds a style definition from a list of traits and an object of additional\n   * attributes.\n   *\n   * @param {string[]} [traits]\n   * @param {Object} additionalAttrs\n   *\n   * @return {Object} the style definition\n   */\n  this.style = function(traits, additionalAttrs) {\n\n    if (!(0,min_dash_dist_index_esm/* isArray */.kJ)(traits) && !additionalAttrs) {\n      additionalAttrs = traits;\n      traits = [];\n    }\n\n    var attrs = (0,min_dash_dist_index_esm/* reduce */.u4)(traits, function(attrs, t) {\n      return (0,min_dash_dist_index_esm/* assign */.f0)(attrs, defaultTraits[t] || {});\n    }, {});\n\n    return additionalAttrs ? (0,min_dash_dist_index_esm/* assign */.f0)(attrs, additionalAttrs) : attrs;\n  };\n\n\n  /**\n   * Computes a style definition from a list of traits and an object of\n   * additional attributes, with custom style definition object.\n   *\n   * @param {Object} custom\n   * @param {string[]} [traits]\n   * @param {Object} defaultStyles\n   *\n   * @return {Object} the style definition\n   */\n  this.computeStyle = function(custom, traits, defaultStyles) {\n    if (!(0,min_dash_dist_index_esm/* isArray */.kJ)(traits)) {\n      defaultStyles = traits;\n      traits = [];\n    }\n\n    return self.style(traits || [], (0,min_dash_dist_index_esm/* assign */.f0)({}, defaultStyles, custom || {}));\n  };\n}\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/draw/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const draw = ({\n  __init__: [ 'defaultRenderer' ],\n  defaultRenderer: [ 'type', DefaultRenderer ],\n  styles: [ 'type', Styles ]\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar min_dom_dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Collections.js\nvar Collections = __webpack_require__(\"./node_modules/diagram-js/lib/util/Collections.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/core/Canvas.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('./Types').ConnectionLike} ConnectionLike\n * @typedef {import('./Types').RootLike} RootLike\n * @typedef {import('./Types').ParentLike } ParentLike\n * @typedef {import('./Types').ShapeLike} ShapeLike\n *\n * @typedef { {\n *   container?: HTMLElement;\n *   deferUpdate?: boolean;\n *   width?: number;\n *   height?: number;\n * } } CanvasConfig\n * @typedef { {\n *   group: SVGElement;\n *   index: number;\n *   visible: boolean;\n * } } CanvasLayer\n * @typedef { {\n *   [key: string]: CanvasLayer;\n * } } CanvasLayers\n * @typedef { {\n *   rootElement: ShapeLike;\n *   layer: CanvasLayer;\n * } } CanvasPlane\n * @typedef { {\n *   scale: number;\n *   inner: Rect;\n *   outer: Dimensions;\n * } & Rect } CanvasViewbox\n *\n * @typedef {import('./ElementRegistry').default} ElementRegistry\n * @typedef {import('./EventBus').default} EventBus\n * @typedef {import('./GraphicsFactory').default} GraphicsFactory\n *\n * @typedef {import('../util/Types').Dimensions} Dimensions\n * @typedef {import('../util/Types').Point} Point\n * @typedef {import('../util/Types').Rect} Rect\n * @typedef {import('../util/Types').RectTRBL} RectTRBL\n */\n\nfunction round(number, resolution) {\n  return Math.round(number * resolution) / resolution;\n}\n\nfunction ensurePx(number) {\n  return (0,min_dash_dist_index_esm/* isNumber */.hj)(number) ? number + 'px' : number;\n}\n\nfunction findRoot(element) {\n  while (element.parent) {\n    element = element.parent;\n  }\n\n  return element;\n}\n\n/**\n * Creates a HTML container element for a SVG element with\n * the given configuration\n *\n * @param {CanvasConfig} options\n *\n * @return {HTMLElement} the container element\n */\nfunction createContainer(options) {\n\n  options = (0,min_dash_dist_index_esm/* assign */.f0)({}, { width: '100%', height: '100%' }, options);\n\n  const container = options.container || document.body;\n\n  // create a <div> around the svg element with the respective size\n  // this way we can always get the correct container size\n  // (this is impossible for <svg> elements at the moment)\n  const parent = document.createElement('div');\n  parent.setAttribute('class', 'djs-container djs-parent');\n\n  (0,min_dom_dist_index_esm/* assignStyle */.i5)(parent, {\n    position: 'relative',\n    overflow: 'hidden',\n    width: ensurePx(options.width),\n    height: ensurePx(options.height)\n  });\n\n  container.appendChild(parent);\n\n  return parent;\n}\n\nfunction createGroup(parent, cls, childIndex) {\n  const group = (0,dist_index_esm/* create */.Ue)('g');\n  (0,dist_index_esm/* classes */.Sh)(group).add(cls);\n\n  const index = childIndex !== undefined ? childIndex : parent.childNodes.length - 1;\n\n  // must ensure second argument is node or _null_\n  // cf. https://developer.mozilla.org/en-US/docs/Web/API/Node/insertBefore\n  parent.insertBefore(group, parent.childNodes[index] || null);\n\n  return group;\n}\n\nconst BASE_LAYER = 'base';\n\n// render plane contents behind utility layers\nconst PLANE_LAYER_INDEX = 0;\nconst UTILITY_LAYER_INDEX = 1;\n\n\nconst REQUIRED_MODEL_ATTRS = {\n  shape: [ 'x', 'y', 'width', 'height' ],\n  connection: [ 'waypoints' ]\n};\n\n/**\n * The main drawing canvas.\n *\n * @class\n * @constructor\n *\n * @emits Canvas#canvas.init\n *\n * @param {CanvasConfig|null} config\n * @param {EventBus} eventBus\n * @param {GraphicsFactory} graphicsFactory\n * @param {ElementRegistry} elementRegistry\n */\nfunction Canvas(config, eventBus, graphicsFactory, elementRegistry) {\n  this._eventBus = eventBus;\n  this._elementRegistry = elementRegistry;\n  this._graphicsFactory = graphicsFactory;\n\n  /**\n   * @type {number}\n   */\n  this._rootsIdx = 0;\n\n  /**\n   * @type {CanvasLayers}\n   */\n  this._layers = {};\n\n  /**\n   * @type {CanvasPlane[]}\n   */\n  this._planes = [];\n\n  /**\n   * @type {RootLike|null}\n   */\n  this._rootElement = null;\n\n  this._init(config || {});\n}\n\nCanvas.$inject = [\n  'config.canvas',\n  'eventBus',\n  'graphicsFactory',\n  'elementRegistry'\n];\n\n/**\n * Creates a <svg> element that is wrapped into a <div>.\n * This way we are always able to correctly figure out the size of the svg element\n * by querying the parent node.\n\n * (It is not possible to get the size of a svg element cross browser @ 2014-04-01)\n\n * <div class=\"djs-container\" style=\"width: {desired-width}, height: {desired-height}\">\n *   <svg width=\"100%\" height=\"100%\">\n *    ...\n *   </svg>\n * </div>\n *\n * @param {CanvasConfig} config\n */\nCanvas.prototype._init = function(config) {\n\n  const eventBus = this._eventBus;\n\n  // html container\n  const container = this._container = createContainer(config);\n\n  const svg = this._svg = (0,dist_index_esm/* create */.Ue)('svg');\n  (0,dist_index_esm/* attr */.Lj)(svg, { width: '100%', height: '100%' });\n\n  (0,dist_index_esm/* append */.R3)(container, svg);\n\n  const viewport = this._viewport = createGroup(svg, 'viewport');\n\n  // debounce canvas.viewbox.changed events\n  // for smoother diagram interaction\n  if (config.deferUpdate !== false) {\n    this._viewboxChanged = (0,min_dash_dist_index_esm/* debounce */.Ds)((0,min_dash_dist_index_esm/* bind */.ak)(this._viewboxChanged, this), 300);\n  }\n\n  eventBus.on('diagram.init', () => {\n\n    /**\n     * An event indicating that the canvas is ready to be drawn on.\n     *\n     * @memberOf Canvas\n     *\n     * @event canvas.init\n     *\n     * @type {Object}\n     * @property {SVGElement} svg the created svg element\n     * @property {SVGElement} viewport the direct parent of diagram elements and shapes\n     */\n    eventBus.fire('canvas.init', {\n      svg: svg,\n      viewport: viewport\n    });\n\n  });\n\n  // reset viewbox on shape changes to\n  // recompute the viewbox\n  eventBus.on([\n    'shape.added',\n    'connection.added',\n    'shape.removed',\n    'connection.removed',\n    'elements.changed',\n    'root.set'\n  ], () => {\n    delete this._cachedViewbox;\n  });\n\n  eventBus.on('diagram.destroy', 500, this._destroy, this);\n  eventBus.on('diagram.clear', 500, this._clear, this);\n};\n\nCanvas.prototype._destroy = function() {\n  this._eventBus.fire('canvas.destroy', {\n    svg: this._svg,\n    viewport: this._viewport\n  });\n\n  const parent = this._container.parentNode;\n\n  if (parent) {\n    parent.removeChild(this._container);\n  }\n\n  delete this._svg;\n  delete this._container;\n  delete this._layers;\n  delete this._planes;\n  delete this._rootElement;\n  delete this._viewport;\n};\n\nCanvas.prototype._clear = function() {\n\n  const allElements = this._elementRegistry.getAll();\n\n  // remove all elements\n  allElements.forEach(element => {\n    const type = (0,Elements/* getType */.oL)(element);\n\n    if (type === 'root') {\n      this.removeRootElement(element);\n    } else {\n      this._removeElement(element, type);\n    }\n  });\n\n  // remove all planes\n  this._planes = [];\n  this._rootElement = null;\n\n  // force recomputation of view box\n  delete this._cachedViewbox;\n};\n\n/**\n * Returns the default layer on which\n * all elements are drawn.\n *\n * @return {SVGElement}  The SVG element of the layer.\n */\nCanvas.prototype.getDefaultLayer = function() {\n  return this.getLayer(BASE_LAYER, PLANE_LAYER_INDEX);\n};\n\n/**\n * Returns a layer that is used to draw elements\n * or annotations on it.\n *\n * Non-existing layers retrieved through this method\n * will be created. During creation, the optional index\n * may be used to create layers below or above existing layers.\n * A layer with a certain index is always created above all\n * existing layers with the same index.\n *\n * @param {string} name The name of the layer.\n * @param {number} [index] The index of the layer.\n *\n * @return {SVGElement} The SVG element of the layer.\n */\nCanvas.prototype.getLayer = function(name, index) {\n\n  if (!name) {\n    throw new Error('must specify a name');\n  }\n\n  let layer = this._layers[name];\n\n  if (!layer) {\n    layer = this._layers[name] = this._createLayer(name, index);\n  }\n\n  // throw an error if layer creation / retrival is\n  // requested on different index\n  if (typeof index !== 'undefined' && layer.index !== index) {\n    throw new Error('layer <' + name + '> already created at index <' + index + '>');\n  }\n\n  return layer.group;\n};\n\n/**\n * For a given index, return the number of layers that have a higher index and\n * are visible.\n *\n * This is used to determine the node a layer should be inserted at.\n *\n * @param {number} index\n *\n * @return {number}\n */\nCanvas.prototype._getChildIndex = function(index) {\n  return (0,min_dash_dist_index_esm/* reduce */.u4)(this._layers, function(childIndex, layer) {\n    if (layer.visible && index >= layer.index) {\n      childIndex++;\n    }\n\n    return childIndex;\n  }, 0);\n};\n\n/**\n * Creates a given layer and returns it.\n *\n * @param {string} name\n * @param {number} [index=0]\n *\n * @return {CanvasLayer}\n */\nCanvas.prototype._createLayer = function(name, index) {\n\n  if (typeof index === 'undefined') {\n    index = UTILITY_LAYER_INDEX;\n  }\n\n  const childIndex = this._getChildIndex(index);\n\n  return {\n    group: createGroup(this._viewport, 'layer-' + name, childIndex),\n    index: index,\n    visible: true\n  };\n};\n\n\n/**\n * Shows a given layer.\n *\n * @param {string} name The name of the layer.\n *\n * @return {SVGElement} The SVG element of the layer.\n */\nCanvas.prototype.showLayer = function(name) {\n\n  if (!name) {\n    throw new Error('must specify a name');\n  }\n\n  const layer = this._layers[name];\n\n  if (!layer) {\n    throw new Error('layer <' + name + '> does not exist');\n  }\n\n  const viewport = this._viewport;\n  const group = layer.group;\n  const index = layer.index;\n\n  if (layer.visible) {\n    return group;\n  }\n\n  const childIndex = this._getChildIndex(index);\n\n  viewport.insertBefore(group, viewport.childNodes[childIndex] || null);\n\n  layer.visible = true;\n\n  return group;\n};\n\n/**\n * Hides a given layer.\n *\n * @param {string} name The name of the layer.\n *\n * @return {SVGElement} The SVG element of the layer.\n */\nCanvas.prototype.hideLayer = function(name) {\n\n  if (!name) {\n    throw new Error('must specify a name');\n  }\n\n  const layer = this._layers[name];\n\n  if (!layer) {\n    throw new Error('layer <' + name + '> does not exist');\n  }\n\n  const group = layer.group;\n\n  if (!layer.visible) {\n    return group;\n  }\n\n  (0,dist_index_esm/* remove */.Od)(group);\n\n  layer.visible = false;\n\n  return group;\n};\n\n\nCanvas.prototype._removeLayer = function(name) {\n\n  const layer = this._layers[name];\n\n  if (layer) {\n    delete this._layers[name];\n\n    (0,dist_index_esm/* remove */.Od)(layer.group);\n  }\n};\n\n/**\n * Returns the currently active layer. Can be null.\n *\n * @return {CanvasLayer|null} The active layer of `null`.\n */\nCanvas.prototype.getActiveLayer = function() {\n  const plane = this._findPlaneForRoot(this.getRootElement());\n\n  if (!plane) {\n    return null;\n  }\n\n  return plane.layer;\n};\n\n\n/**\n * Returns the plane which contains the given element.\n *\n * @param {ShapeLike|ConnectionLike|string} element The element or its ID.\n *\n * @return {RootLike|undefined} The root of the element.\n */\nCanvas.prototype.findRoot = function(element) {\n  if (typeof element === 'string') {\n    element = this._elementRegistry.get(element);\n  }\n\n  if (!element) {\n    return;\n  }\n\n  const plane = this._findPlaneForRoot(\n    findRoot(element)\n  ) || {};\n\n  return plane.rootElement;\n};\n\n/**\n * Return a list of all root elements on the diagram.\n *\n * @return {(RootLike)[]} The list of root elements.\n */\nCanvas.prototype.getRootElements = function() {\n  return this._planes.map(function(plane) {\n    return plane.rootElement;\n  });\n};\n\nCanvas.prototype._findPlaneForRoot = function(rootElement) {\n  return (0,min_dash_dist_index_esm/* find */.sE)(this._planes, function(plane) {\n    return plane.rootElement === rootElement;\n  });\n};\n\n\n/**\n * Returns the html element that encloses the\n * drawing canvas.\n *\n * @return {HTMLElement} The HTML element of the container.\n */\nCanvas.prototype.getContainer = function() {\n  return this._container;\n};\n\n\n// markers //////////////////////\n\nCanvas.prototype._updateMarker = function(element, marker, add) {\n  let container;\n\n  if (!element.id) {\n    element = this._elementRegistry.get(element);\n  }\n\n  // we need to access all\n  container = this._elementRegistry._elements[element.id];\n\n  if (!container) {\n    return;\n  }\n\n  (0,min_dash_dist_index_esm/* forEach */.Ed)([ container.gfx, container.secondaryGfx ], function(gfx) {\n    if (gfx) {\n\n      // invoke either addClass or removeClass based on mode\n      if (add) {\n        (0,dist_index_esm/* classes */.Sh)(gfx).add(marker);\n      } else {\n        (0,dist_index_esm/* classes */.Sh)(gfx).remove(marker);\n      }\n    }\n  });\n\n  /**\n   * An event indicating that a marker has been updated for an element\n   *\n   * @event element.marker.update\n   * @type {Object}\n   * @property {Element} element the shape\n   * @property {SVGElement} gfx the graphical representation of the shape\n   * @property {string} marker\n   * @property {boolean} add true if the marker was added, false if it got removed\n   */\n  this._eventBus.fire('element.marker.update', { element: element, gfx: container.gfx, marker: marker, add: !!add });\n};\n\n\n/**\n * Adds a marker to an element (basically a css class).\n *\n * Fires the element.marker.update event, making it possible to\n * integrate extension into the marker life-cycle, too.\n *\n * @example\n *\n * ```javascript\n * canvas.addMarker('foo', 'some-marker');\n *\n * const fooGfx = canvas.getGraphics('foo');\n *\n * fooGfx; // <g class=\"... some-marker\"> ... </g>\n * ```\n *\n * @param {ShapeLike|ConnectionLike|string} element The element or its ID.\n * @param {string} marker The marker.\n */\nCanvas.prototype.addMarker = function(element, marker) {\n  this._updateMarker(element, marker, true);\n};\n\n\n/**\n * Remove a marker from an element.\n *\n * Fires the element.marker.update event, making it possible to\n * integrate extension into the marker life-cycle, too.\n *\n * @param {ShapeLike|ConnectionLike|string} element The element or its ID.\n * @param {string} marker The marker.\n */\nCanvas.prototype.removeMarker = function(element, marker) {\n  this._updateMarker(element, marker, false);\n};\n\n/**\n * Check whether an element has a given marker.\n *\n * @param {ShapeLike|ConnectionLike|string} element The element or its ID.\n * @param {string} marker The marker.\n */\nCanvas.prototype.hasMarker = function(element, marker) {\n  if (!element.id) {\n    element = this._elementRegistry.get(element);\n  }\n\n  const gfx = this.getGraphics(element);\n\n  return (0,dist_index_esm/* classes */.Sh)(gfx).has(marker);\n};\n\n/**\n * Toggles a marker on an element.\n *\n * Fires the element.marker.update event, making it possible to\n * integrate extension into the marker life-cycle, too.\n *\n * @param {ShapeLike|ConnectionLike|string} element The element or its ID.\n * @param {string} marker The marker.\n */\nCanvas.prototype.toggleMarker = function(element, marker) {\n  if (this.hasMarker(element, marker)) {\n    this.removeMarker(element, marker);\n  } else {\n    this.addMarker(element, marker);\n  }\n};\n\n/**\n * Returns the current root element.\n *\n * Supports two different modes for handling root elements:\n *\n * 1. if no root element has been added before, an implicit root will be added\n * and returned. This is used in applications that don't require explicit\n * root elements.\n *\n * 2. when root elements have been added before calling `getRootElement`,\n * root elements can be null. This is used for applications that want to manage\n * root elements themselves.\n *\n * @return {RootLike} The current root element.\n */\nCanvas.prototype.getRootElement = function() {\n  const rootElement = this._rootElement;\n\n  // can return null if root elements are present but none was set yet\n  if (rootElement || this._planes.length) {\n    return rootElement;\n  }\n\n  return this.setRootElement(this.addRootElement(null));\n};\n\n/**\n * Adds a given root element and returns it.\n *\n * @param {RootLike} [rootElement] The root element to be added.\n *\n * @return {RootLike} The added root element or an implicit root element.\n */\nCanvas.prototype.addRootElement = function(rootElement) {\n  const idx = this._rootsIdx++;\n\n  if (!rootElement) {\n    rootElement = {\n      id: '__implicitroot_' + idx,\n      children: [],\n      isImplicit: true\n    };\n  }\n\n  const layerName = rootElement.layer = 'root-' + idx;\n\n  this._ensureValid('root', rootElement);\n\n  const layer = this.getLayer(layerName, PLANE_LAYER_INDEX);\n\n  this.hideLayer(layerName);\n\n  this._addRoot(rootElement, layer);\n\n  this._planes.push({\n    rootElement: rootElement,\n    layer: layer\n  });\n\n  return rootElement;\n};\n\n/**\n * Removes a given root element and returns it.\n *\n * @param {RootLike|string} rootElement element or element ID\n *\n * @return {RootLike|undefined} removed element\n */\nCanvas.prototype.removeRootElement = function(rootElement) {\n\n  if (typeof rootElement === 'string') {\n    rootElement = this._elementRegistry.get(rootElement);\n  }\n\n  const plane = this._findPlaneForRoot(rootElement);\n\n  if (!plane) {\n    return;\n  }\n\n  // hook up life-cycle events\n  this._removeRoot(rootElement);\n\n  // clean up layer\n  this._removeLayer(rootElement.layer);\n\n  // clean up plane\n  this._planes = this._planes.filter(function(plane) {\n    return plane.rootElement !== rootElement;\n  });\n\n  // clean up active root\n  if (this._rootElement === rootElement) {\n    this._rootElement = null;\n  }\n\n  return rootElement;\n};\n\n\n/**\n * Sets a given element as the new root element for the canvas\n * and returns the new root element.\n *\n * @param {RootLike} rootElement The root element to be set.\n *\n * @return {RootLike} The set root element.\n */\nCanvas.prototype.setRootElement = function(rootElement) {\n\n  if (rootElement === this._rootElement) {\n    return;\n  }\n\n  let plane;\n\n  if (!rootElement) {\n    throw new Error('rootElement required');\n  }\n\n  plane = this._findPlaneForRoot(rootElement);\n\n  // give set add semantics for backwards compatibility\n  if (!plane) {\n    rootElement = this.addRootElement(rootElement);\n  }\n\n  this._setRoot(rootElement);\n\n  return rootElement;\n};\n\n\nCanvas.prototype._removeRoot = function(element) {\n  const elementRegistry = this._elementRegistry,\n        eventBus = this._eventBus;\n\n  // simulate element remove event sequence\n  eventBus.fire('root.remove', { element: element });\n  eventBus.fire('root.removed', { element: element });\n\n  elementRegistry.remove(element);\n};\n\n\nCanvas.prototype._addRoot = function(element, gfx) {\n  const elementRegistry = this._elementRegistry,\n        eventBus = this._eventBus;\n\n  // resemble element add event sequence\n  eventBus.fire('root.add', { element: element });\n\n  elementRegistry.add(element, gfx);\n\n  eventBus.fire('root.added', { element: element, gfx: gfx });\n};\n\n\nCanvas.prototype._setRoot = function(rootElement, layer) {\n\n  const currentRoot = this._rootElement;\n\n  if (currentRoot) {\n\n    // un-associate previous root element <svg>\n    this._elementRegistry.updateGraphics(currentRoot, null, true);\n\n    // hide previous layer\n    this.hideLayer(currentRoot.layer);\n  }\n\n  if (rootElement) {\n\n    if (!layer) {\n      layer = this._findPlaneForRoot(rootElement).layer;\n    }\n\n    // associate element with <svg>\n    this._elementRegistry.updateGraphics(rootElement, this._svg, true);\n\n    // show root layer\n    this.showLayer(rootElement.layer);\n  }\n\n  this._rootElement = rootElement;\n\n  this._eventBus.fire('root.set', { element: rootElement });\n};\n\nCanvas.prototype._ensureValid = function(type, element) {\n  if (!element.id) {\n    throw new Error('element must have an id');\n  }\n\n  if (this._elementRegistry.get(element.id)) {\n    throw new Error('element <' + element.id + '> already exists');\n  }\n\n  const requiredAttrs = REQUIRED_MODEL_ATTRS[type];\n\n  const valid = (0,min_dash_dist_index_esm/* every */.yW)(requiredAttrs, function(attr) {\n    return typeof element[attr] !== 'undefined';\n  });\n\n  if (!valid) {\n    throw new Error(\n      'must supply { ' + requiredAttrs.join(', ') + ' } with ' + type);\n  }\n};\n\nCanvas.prototype._setParent = function(element, parent, parentIndex) {\n  (0,Collections/* add */.IH)(parent.children, element, parentIndex);\n  element.parent = parent;\n};\n\n/**\n * Adds an element to the canvas.\n *\n * This wires the parent <-> child relationship between the element and\n * a explicitly specified parent or an implicit root element.\n *\n * During add it emits the events\n *\n *  * <{type}.add> (element, parent)\n *  * <{type}.added> (element, gfx)\n *\n * Extensions may hook into these events to perform their magic.\n *\n * @param {string} type\n * @param {ConnectionLike|ShapeLike} element\n * @param {ShapeLike} [parent]\n * @param {number} [parentIndex]\n *\n * @return {ConnectionLike|ShapeLike} The added element.\n */\nCanvas.prototype._addElement = function(type, element, parent, parentIndex) {\n\n  parent = parent || this.getRootElement();\n\n  const eventBus = this._eventBus,\n        graphicsFactory = this._graphicsFactory;\n\n  this._ensureValid(type, element);\n\n  eventBus.fire(type + '.add', { element: element, parent: parent });\n\n  this._setParent(element, parent, parentIndex);\n\n  // create graphics\n  const gfx = graphicsFactory.create(type, element, parentIndex);\n\n  this._elementRegistry.add(element, gfx);\n\n  // update its visual\n  graphicsFactory.update(type, element, gfx);\n\n  eventBus.fire(type + '.added', { element: element, gfx: gfx });\n\n  return element;\n};\n\n/**\n * Adds a shape to the canvas.\n *\n * @param {ShapeLike} shape The shape to be added\n * @param {ParentLike} [parent] The shape's parent.\n * @param {number} [parentIndex] The index at which to add the shape to the parent's children.\n *\n * @return {ShapeLike} The added shape.\n */\nCanvas.prototype.addShape = function(shape, parent, parentIndex) {\n  return this._addElement('shape', shape, parent, parentIndex);\n};\n\n/**\n * Adds a connection to the canvas.\n *\n * @param {ConnectionLike} connection The connection to be added.\n * @param {ParentLike} [parent] The connection's parent.\n * @param {number} [parentIndex] The index at which to add the connection to the parent's children.\n *\n * @return {ConnectionLike} The added connection.\n */\nCanvas.prototype.addConnection = function(connection, parent, parentIndex) {\n  return this._addElement('connection', connection, parent, parentIndex);\n};\n\n\n/**\n * Internal remove element\n */\nCanvas.prototype._removeElement = function(element, type) {\n\n  const elementRegistry = this._elementRegistry,\n        graphicsFactory = this._graphicsFactory,\n        eventBus = this._eventBus;\n\n  element = elementRegistry.get(element.id || element);\n\n  if (!element) {\n\n    // element was removed already\n    return;\n  }\n\n  eventBus.fire(type + '.remove', { element: element });\n\n  graphicsFactory.remove(element);\n\n  // unset parent <-> child relationship\n  (0,Collections/* remove */.Od)(element.parent && element.parent.children, element);\n  element.parent = null;\n\n  eventBus.fire(type + '.removed', { element: element });\n\n  elementRegistry.remove(element);\n\n  return element;\n};\n\n\n/**\n * Removes a shape from the canvas.\n *\n * @fires ShapeRemoveEvent\n * @fires ShapeRemovedEvent\n *\n * @param {ShapeLike|string} shape The shape or its ID.\n *\n * @return {ShapeLike} The removed shape.\n */\nCanvas.prototype.removeShape = function(shape) {\n\n  /**\n   * An event indicating that a shape is about to be removed from the canvas.\n   *\n   * @memberOf Canvas\n   *\n   * @event ShapeRemoveEvent\n   * @type {Object}\n   * @property {ShapeLike} element The shape.\n   * @property {SVGElement} gfx The graphical element.\n   */\n\n  /**\n   * An event indicating that a shape has been removed from the canvas.\n   *\n   * @memberOf Canvas\n   *\n   * @event ShapeRemovedEvent\n   * @type {Object}\n   * @property {ShapeLike} element The shape.\n   * @property {SVGElement} gfx The graphical element.\n   */\n  return this._removeElement(shape, 'shape');\n};\n\n\n/**\n * Removes a connection from the canvas.\n *\n * @fires ConnectionRemoveEvent\n * @fires ConnectionRemovedEvent\n *\n * @param {ConnectionLike|string} connection The connection or its ID.\n *\n * @return {ConnectionLike} The removed connection.\n */\nCanvas.prototype.removeConnection = function(connection) {\n\n  /**\n   * An event indicating that a connection is about to be removed from the canvas.\n   *\n   * @memberOf Canvas\n   *\n   * @event ConnectionRemoveEvent\n   * @type {Object}\n   * @property {ConnectionLike} element The connection.\n   * @property {SVGElement} gfx The graphical element.\n   */\n\n  /**\n   * An event indicating that a connection has been removed from the canvas.\n   *\n   * @memberOf Canvas\n   *\n   * @event ConnectionRemovedEvent\n   * @type {Object}\n   * @property {ConnectionLike} element The connection.\n   * @property {SVGElement} gfx The graphical element.\n   */\n  return this._removeElement(connection, 'connection');\n};\n\n\n/**\n * Returns the graphical element of an element.\n *\n * @param {ShapeLike|ConnectionLike|string} element The element or its ID.\n * @param {boolean} [secondary=false] Whether to return the secondary graphical element.\n *\n * @return {SVGElement} The graphical element.\n */\nCanvas.prototype.getGraphics = function(element, secondary) {\n  return this._elementRegistry.getGraphics(element, secondary);\n};\n\n\n/**\n * Perform a viewbox update via a given change function.\n *\n * @param {Function} changeFn\n */\nCanvas.prototype._changeViewbox = function(changeFn) {\n\n  // notify others of the upcoming viewbox change\n  this._eventBus.fire('canvas.viewbox.changing');\n\n  // perform actual change\n  changeFn.apply(this);\n\n  // reset the cached viewbox so that\n  // a new get operation on viewbox or zoom\n  // triggers a viewbox re-computation\n  this._cachedViewbox = null;\n\n  // notify others of the change; this step\n  // may or may not be debounced\n  this._viewboxChanged();\n};\n\nCanvas.prototype._viewboxChanged = function() {\n  this._eventBus.fire('canvas.viewbox.changed', { viewbox: this.viewbox() });\n};\n\n\n/**\n * Gets or sets the view box of the canvas, i.e. the\n * area that is currently displayed.\n *\n * The getter may return a cached viewbox (if it is currently\n * changing). To force a recomputation, pass `false` as the first argument.\n *\n * @example\n *\n * ```javascript\n * canvas.viewbox({ x: 100, y: 100, width: 500, height: 500 })\n *\n * // sets the visible area of the diagram to (100|100) -> (600|100)\n * // and and scales it according to the diagram width\n *\n * const viewbox = canvas.viewbox(); // pass `false` to force recomputing the box.\n *\n * console.log(viewbox);\n * // {\n * //   inner: Dimensions,\n * //   outer: Dimensions,\n * //   scale,\n * //   x, y,\n * //   width, height\n * // }\n *\n * // if the current diagram is zoomed and scrolled, you may reset it to the\n * // default zoom via this method, too:\n *\n * const zoomedAndScrolledViewbox = canvas.viewbox();\n *\n * canvas.viewbox({\n *   x: 0,\n *   y: 0,\n *   width: zoomedAndScrolledViewbox.outer.width,\n *   height: zoomedAndScrolledViewbox.outer.height\n * });\n * ```\n *\n * @param {Rect} [box] The viewbox to be set.\n *\n * @return {CanvasViewbox} The set viewbox.\n */\nCanvas.prototype.viewbox = function(box) {\n\n  if (box === undefined && this._cachedViewbox) {\n    return this._cachedViewbox;\n  }\n\n  const viewport = this._viewport,\n        outerBox = this.getSize();\n  let innerBox,\n      matrix,\n      activeLayer,\n      transform,\n      scale,\n      x, y;\n\n  if (!box) {\n\n    // compute the inner box based on the\n    // diagrams active layer. This allows us to exclude\n    // external components, such as overlays\n\n    activeLayer = this._rootElement ? this.getActiveLayer() : null;\n    innerBox = activeLayer && activeLayer.getBBox() || {};\n\n    transform = (0,dist_index_esm/* transform */.vs)(viewport);\n    matrix = transform ? transform.matrix : (0,dist_index_esm/* createMatrix */.wz)();\n    scale = round(matrix.a, 1000);\n\n    x = round(-matrix.e || 0, 1000);\n    y = round(-matrix.f || 0, 1000);\n\n    box = this._cachedViewbox = {\n      x: x ? x / scale : 0,\n      y: y ? y / scale : 0,\n      width: outerBox.width / scale,\n      height: outerBox.height / scale,\n      scale: scale,\n      inner: {\n        width: innerBox.width || 0,\n        height: innerBox.height || 0,\n        x: innerBox.x || 0,\n        y: innerBox.y || 0\n      },\n      outer: outerBox\n    };\n\n    return box;\n  } else {\n\n    this._changeViewbox(function() {\n      scale = Math.min(outerBox.width / box.width, outerBox.height / box.height);\n\n      const matrix = this._svg.createSVGMatrix()\n        .scale(scale)\n        .translate(-box.x, -box.y);\n\n      (0,dist_index_esm/* transform */.vs)(viewport, matrix);\n    });\n  }\n\n  return box;\n};\n\n\n/**\n * Gets or sets the scroll of the canvas.\n *\n * @param {Point} [delta] The scroll to be set.\n *\n * @return {Point}\n */\nCanvas.prototype.scroll = function(delta) {\n\n  const node = this._viewport;\n  let matrix = node.getCTM();\n\n  if (delta) {\n    this._changeViewbox(function() {\n      delta = (0,min_dash_dist_index_esm/* assign */.f0)({ dx: 0, dy: 0 }, delta || {});\n\n      matrix = this._svg.createSVGMatrix().translate(delta.dx, delta.dy).multiply(matrix);\n\n      setCTM(node, matrix);\n    });\n  }\n\n  return { x: matrix.e, y: matrix.f };\n};\n\n/**\n * Scrolls the viewbox to contain the given element.\n * Optionally specify a padding to be applied to the edges.\n *\n * @param {ShapeLike|ConnectionLike|string} element The element to scroll to or its ID.\n * @param {RectTRBL|number} [padding=100] The padding to be applied. Can also specify top, bottom, left and right.\n */\nCanvas.prototype.scrollToElement = function(element, padding) {\n  let defaultPadding = 100;\n\n  if (typeof element === 'string') {\n    element = this._elementRegistry.get(element);\n  }\n\n  // set to correct rootElement\n  const rootElement = this.findRoot(element);\n\n  if (rootElement !== this.getRootElement()) {\n    this.setRootElement(rootElement);\n  }\n\n  if (!padding) {\n    padding = {};\n  }\n  if (typeof padding === 'number') {\n    defaultPadding = padding;\n  }\n\n  padding = {\n    top: padding.top || defaultPadding,\n    right: padding.right || defaultPadding,\n    bottom: padding.bottom || defaultPadding,\n    left: padding.left || defaultPadding\n  };\n\n  const elementBounds = (0,Elements/* getBBox */.jY)(element),\n        elementTrbl = (0,LayoutUtil/* asTRBL */.JA)(elementBounds),\n        viewboxBounds = this.viewbox(),\n        zoom = this.zoom();\n  let dx, dy;\n\n  // shrink viewboxBounds with padding\n  viewboxBounds.y += padding.top / zoom;\n  viewboxBounds.x += padding.left / zoom;\n  viewboxBounds.width -= (padding.right + padding.left) / zoom;\n  viewboxBounds.height -= (padding.bottom + padding.top) / zoom;\n\n  const viewboxTrbl = (0,LayoutUtil/* asTRBL */.JA)(viewboxBounds);\n\n  const canFit = elementBounds.width < viewboxBounds.width && elementBounds.height < viewboxBounds.height;\n\n  if (!canFit) {\n\n    // top-left when element can't fit\n    dx = elementBounds.x - viewboxBounds.x;\n    dy = elementBounds.y - viewboxBounds.y;\n\n  } else {\n\n    const dRight = Math.max(0, elementTrbl.right - viewboxTrbl.right),\n          dLeft = Math.min(0, elementTrbl.left - viewboxTrbl.left),\n          dBottom = Math.max(0, elementTrbl.bottom - viewboxTrbl.bottom),\n          dTop = Math.min(0, elementTrbl.top - viewboxTrbl.top);\n\n    dx = dRight || dLeft;\n    dy = dBottom || dTop;\n\n  }\n\n  this.scroll({ dx: -dx * zoom, dy: -dy * zoom });\n};\n\n/**\n * Gets or sets the current zoom of the canvas, optionally zooming to the\n * specified position.\n *\n * The getter may return a cached zoom level. Call it with `false` as the first\n * argument to force recomputation of the current level.\n *\n * @param {number|'fit-viewport'} [newScale] The new zoom level, either a number,\n * i.e. 0.9, or `fit-viewport` to adjust the size to fit the current viewport.\n * @param {Point} [center] The reference point { x: ..., y: ...} to zoom to.\n *\n * @return {number} The set zoom level.\n */\nCanvas.prototype.zoom = function(newScale, center) {\n\n  if (!newScale) {\n    return this.viewbox(newScale).scale;\n  }\n\n  if (newScale === 'fit-viewport') {\n    return this._fitViewport(center);\n  }\n\n  let outer,\n      matrix;\n\n  this._changeViewbox(function() {\n\n    if (typeof center !== 'object') {\n      outer = this.viewbox().outer;\n\n      center = {\n        x: outer.width / 2,\n        y: outer.height / 2\n      };\n    }\n\n    matrix = this._setZoom(newScale, center);\n  });\n\n  return round(matrix.a, 1000);\n};\n\nfunction setCTM(node, m) {\n  const mstr = 'matrix(' + m.a + ',' + m.b + ',' + m.c + ',' + m.d + ',' + m.e + ',' + m.f + ')';\n  node.setAttribute('transform', mstr);\n}\n\nCanvas.prototype._fitViewport = function(center) {\n\n  const vbox = this.viewbox(),\n        outer = vbox.outer,\n        inner = vbox.inner;\n  let newScale,\n      newViewbox;\n\n  // display the complete diagram without zooming in.\n  // instead of relying on internal zoom, we perform a\n  // hard reset on the canvas viewbox to realize this\n  //\n  // if diagram does not need to be zoomed in, we focus it around\n  // the diagram origin instead\n\n  if (inner.x >= 0 &&\n      inner.y >= 0 &&\n      inner.x + inner.width <= outer.width &&\n      inner.y + inner.height <= outer.height &&\n      !center) {\n\n    newViewbox = {\n      x: 0,\n      y: 0,\n      width: Math.max(inner.width + inner.x, outer.width),\n      height: Math.max(inner.height + inner.y, outer.height)\n    };\n  } else {\n\n    newScale = Math.min(1, outer.width / inner.width, outer.height / inner.height);\n    newViewbox = {\n      x: inner.x + (center ? inner.width / 2 - outer.width / newScale / 2 : 0),\n      y: inner.y + (center ? inner.height / 2 - outer.height / newScale / 2 : 0),\n      width: outer.width / newScale,\n      height: outer.height / newScale\n    };\n  }\n\n  this.viewbox(newViewbox);\n\n  return this.viewbox(false).scale;\n};\n\n\nCanvas.prototype._setZoom = function(scale, center) {\n\n  const svg = this._svg,\n        viewport = this._viewport;\n\n  const matrix = svg.createSVGMatrix();\n  const point = svg.createSVGPoint();\n\n  let centerPoint,\n      originalPoint,\n      currentMatrix,\n      scaleMatrix,\n      newMatrix;\n\n  currentMatrix = viewport.getCTM();\n\n  const currentScale = currentMatrix.a;\n\n  if (center) {\n    centerPoint = (0,min_dash_dist_index_esm/* assign */.f0)(point, center);\n\n    // revert applied viewport transformations\n    originalPoint = centerPoint.matrixTransform(currentMatrix.inverse());\n\n    // create scale matrix\n    scaleMatrix = matrix\n      .translate(originalPoint.x, originalPoint.y)\n      .scale(1 / currentScale * scale)\n      .translate(-originalPoint.x, -originalPoint.y);\n\n    newMatrix = currentMatrix.multiply(scaleMatrix);\n  } else {\n    newMatrix = matrix.scale(scale);\n  }\n\n  setCTM(this._viewport, newMatrix);\n\n  return newMatrix;\n};\n\n\n/**\n * Returns the size of the canvas.\n *\n * @return {Dimensions} The size of the canvas.\n */\nCanvas.prototype.getSize = function() {\n  return {\n    width: this._container.clientWidth,\n    height: this._container.clientHeight\n  };\n};\n\n\n/**\n * Returns the absolute bounding box of an element.\n *\n * The absolute bounding box may be used to display overlays in the callers\n * (browser) coordinate system rather than the zoomed in/out canvas coordinates.\n *\n * @param {ShapeLike|ConnectionLike} element The element.\n *\n * @return {Rect} The element's absolute bounding box.\n */\nCanvas.prototype.getAbsoluteBBox = function(element) {\n  const vbox = this.viewbox();\n  let bbox;\n\n  // connection\n  // use svg bbox\n  if (element.waypoints) {\n    const gfx = this.getGraphics(element);\n\n    bbox = gfx.getBBox();\n  }\n\n  // shapes\n  // use data\n  else {\n    bbox = element;\n  }\n\n  const x = bbox.x * vbox.scale - vbox.x * vbox.scale;\n  const y = bbox.y * vbox.scale - vbox.y * vbox.scale;\n\n  const width = bbox.width * vbox.scale;\n  const height = bbox.height * vbox.scale;\n\n  return {\n    x: x,\n    y: y,\n    width: width,\n    height: height\n  };\n};\n\n/**\n * Fires an event so other modules can react to the canvas resizing.\n */\nCanvas.prototype.resized = function() {\n\n  // force recomputation of view box\n  delete this._cachedViewbox;\n\n  this._eventBus.fire('canvas.resized');\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/core/ElementRegistry.js\nvar ELEMENT_ID = 'data-element-id';\n\n\n\n/**\n * @typedef {import('./Types').ElementLike} ElementLike\n *\n * @typedef {import('./EventBus').default} EventBus\n *\n * @typedef { (element: ElementLike, gfx: SVGElement) => boolean|any } ElementRegistryFilterCallback\n * @typedef { (element: ElementLike, gfx: SVGElement) => any } ElementRegistryForEachCallback\n */\n\n/**\n * A registry that keeps track of all shapes in the diagram.\n *\n * @class\n * @constructor\n *\n * @param {EventBus} eventBus\n */\nfunction ElementRegistry(eventBus) {\n\n  /**\n   * @type { {\n   *   [id: string]: {\n   *     element: ElementLike;\n   *     gfx?: SVGElement;\n   *     secondaryGfx?: SVGElement;\n   *   }\n   * } }\n   */\n  this._elements = {};\n\n  this._eventBus = eventBus;\n}\n\nElementRegistry.$inject = [ 'eventBus' ];\n\n/**\n * Add an element and its graphical representation(s) to the registry.\n *\n * @param {ElementLike} element The element to be added.\n * @param {SVGElement} gfx The primary graphical representation.\n * @param {SVGElement} [secondaryGfx] The secondary graphical representation.\n */\nElementRegistry.prototype.add = function(element, gfx, secondaryGfx) {\n\n  var id = element.id;\n\n  this._validateId(id);\n\n  // associate dom node with element\n  (0,dist_index_esm/* attr */.Lj)(gfx, ELEMENT_ID, id);\n\n  if (secondaryGfx) {\n    (0,dist_index_esm/* attr */.Lj)(secondaryGfx, ELEMENT_ID, id);\n  }\n\n  this._elements[id] = { element: element, gfx: gfx, secondaryGfx: secondaryGfx };\n};\n\n/**\n * Remove an element from the registry.\n *\n * @param {ElementLike|string} element\n */\nElementRegistry.prototype.remove = function(element) {\n  var elements = this._elements,\n      id = element.id || element,\n      container = id && elements[id];\n\n  if (container) {\n\n    // unset element id on gfx\n    (0,dist_index_esm/* attr */.Lj)(container.gfx, ELEMENT_ID, '');\n\n    if (container.secondaryGfx) {\n      (0,dist_index_esm/* attr */.Lj)(container.secondaryGfx, ELEMENT_ID, '');\n    }\n\n    delete elements[id];\n  }\n};\n\n/**\n * Update an elements ID.\n *\n * @param {ElementLike|string} element The element or its ID.\n * @param {string} newId The new ID.\n */\nElementRegistry.prototype.updateId = function(element, newId) {\n\n  this._validateId(newId);\n\n  if (typeof element === 'string') {\n    element = this.get(element);\n  }\n\n  this._eventBus.fire('element.updateId', {\n    element: element,\n    newId: newId\n  });\n\n  var gfx = this.getGraphics(element),\n      secondaryGfx = this.getGraphics(element, true);\n\n  this.remove(element);\n\n  element.id = newId;\n\n  this.add(element, gfx, secondaryGfx);\n};\n\n/**\n * Update the graphical representation of an element.\n *\n * @param {ElementLike|string} filter The element or its ID.\n * @param {SVGElement} gfx The new graphical representation.\n * @param {boolean} [secondary=false] Whether to update the secondary graphical representation.\n */\nElementRegistry.prototype.updateGraphics = function(filter, gfx, secondary) {\n  var id = filter.id || filter;\n\n  var container = this._elements[id];\n\n  if (secondary) {\n    container.secondaryGfx = gfx;\n  } else {\n    container.gfx = gfx;\n  }\n\n  if (gfx) {\n    (0,dist_index_esm/* attr */.Lj)(gfx, ELEMENT_ID, id);\n  }\n\n  return gfx;\n};\n\n/**\n * Get the element with the given ID or graphical representation.\n *\n * @example\n *\n * ```javascript\n * elementRegistry.get('SomeElementId_1');\n *\n * elementRegistry.get(gfx);\n * ```\n *\n * @param {string|SVGElement} filter The elements ID or graphical representation.\n *\n * @return {ElementLike|undefined} The element.\n */\nElementRegistry.prototype.get = function(filter) {\n  var id;\n\n  if (typeof filter === 'string') {\n    id = filter;\n  } else {\n    id = filter && (0,dist_index_esm/* attr */.Lj)(filter, ELEMENT_ID);\n  }\n\n  var container = this._elements[id];\n  return container && container.element;\n};\n\n/**\n * Return all elements that match a given filter function.\n *\n * @param {ElementRegistryFilterCallback} fn The filter function.\n *\n * @return {ElementLike[]} The matching elements.\n */\nElementRegistry.prototype.filter = function(fn) {\n\n  var filtered = [];\n\n  this.forEach(function(element, gfx) {\n    if (fn(element, gfx)) {\n      filtered.push(element);\n    }\n  });\n\n  return filtered;\n};\n\n/**\n * Return the first element that matches the given filter function.\n *\n * @param {ElementRegistryFilterCallback} fn The filter function.\n *\n * @return {ElementLike|undefined} The matching element.\n */\nElementRegistry.prototype.find = function(fn) {\n  var map = this._elements,\n      keys = Object.keys(map);\n\n  for (var i = 0; i < keys.length; i++) {\n    var id = keys[i],\n        container = map[id],\n        element = container.element,\n        gfx = container.gfx;\n\n    if (fn(element, gfx)) {\n      return element;\n    }\n  }\n};\n\n/**\n * Get all elements.\n *\n * @return {ElementLike[]} All elements.\n */\nElementRegistry.prototype.getAll = function() {\n  return this.filter(function(e) { return e; });\n};\n\n/**\n * Execute a given function for each element.\n *\n * @param {ElementRegistryForEachCallback} fn The function to execute.\n */\nElementRegistry.prototype.forEach = function(fn) {\n\n  var map = this._elements;\n\n  Object.keys(map).forEach(function(id) {\n    var container = map[id],\n        element = container.element,\n        gfx = container.gfx;\n\n    return fn(element, gfx);\n  });\n};\n\n/**\n * Return the graphical representation of an element.\n *\n * @example\n *\n * ```javascript\n * elementRegistry.getGraphics('SomeElementId_1');\n *\n * elementRegistry.getGraphics(rootElement); // <g ...>\n *\n * elementRegistry.getGraphics(rootElement, true); // <svg ...>\n * ```\n *\n * @param {ElementLike|string} filter The element or its ID.\n * @param {boolean} [secondary=false] Whether to return the secondary graphical representation.\n *\n * @return {SVGElement} The graphical representation.\n */\nElementRegistry.prototype.getGraphics = function(filter, secondary) {\n  var id = filter.id || filter;\n\n  var container = this._elements[id];\n  return container && (secondary ? container.secondaryGfx : container.gfx);\n};\n\n/**\n * Validate an ID and throw an error if invalid.\n *\n * @param {string} id\n *\n * @throws {Error} Error indicating that the ID is invalid or already assigned.\n */\nElementRegistry.prototype._validateId = function(id) {\n  if (!id) {\n    throw new Error('element must have an id');\n  }\n\n  if (this._elements[id]) {\n    throw new Error('element with id ' + id + ' already added');\n  }\n};\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/core/ElementFactory.js\nvar ElementFactory = __webpack_require__(\"./node_modules/diagram-js/lib/core/ElementFactory.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/core/EventBus.js\n\n\nvar FN_REF = '__fn';\n\nvar DEFAULT_PRIORITY = 1000;\n\nvar slice = Array.prototype.slice;\n\n/**\n * @typedef { {\n *   stopPropagation(): void;\n *   preventDefault(): void;\n *   cancelBubble: boolean;\n *   defaultPrevented: boolean;\n *   returnValue: any;\n * } } Event\n */\n\n/**\n * @template E\n *\n * @typedef { (event: E & Event, ...any) => any } EventBusEventCallback\n */\n\n/**\n * @typedef { {\n *  priority: number;\n *  next: EventBusListener | null;\n *  callback: EventBusEventCallback<any>;\n * } } EventBusListener\n */\n\n/**\n * A general purpose event bus.\n *\n * This component is used to communicate across a diagram instance.\n * Other parts of a diagram can use it to listen to and broadcast events.\n *\n *\n * ## Registering for Events\n *\n * The event bus provides the {@link EventBus#on} and {@link EventBus#once}\n * methods to register for events. {@link EventBus#off} can be used to\n * remove event registrations. Listeners receive an instance of {@link Event}\n * as the first argument. It allows them to hook into the event execution.\n *\n * ```javascript\n *\n * // listen for event\n * eventBus.on('foo', function(event) {\n *\n *   // access event type\n *   event.type; // 'foo'\n *\n *   // stop propagation to other listeners\n *   event.stopPropagation();\n *\n *   // prevent event default\n *   event.preventDefault();\n * });\n *\n * // listen for event with custom payload\n * eventBus.on('bar', function(event, payload) {\n *   console.log(payload);\n * });\n *\n * // listen for event returning value\n * eventBus.on('foobar', function(event) {\n *\n *   // stop event propagation + prevent default\n *   return false;\n *\n *   // stop event propagation + return custom result\n *   return {\n *     complex: 'listening result'\n *   };\n * });\n *\n *\n * // listen with custom priority (default=1000, higher is better)\n * eventBus.on('priorityfoo', 1500, function(event) {\n *   console.log('invoked first!');\n * });\n *\n *\n * // listen for event and pass the context (`this`)\n * eventBus.on('foobar', function(event) {\n *   this.foo();\n * }, this);\n * ```\n *\n *\n * ## Emitting Events\n *\n * Events can be emitted via the event bus using {@link EventBus#fire}.\n *\n * ```javascript\n *\n * // false indicates that the default action\n * // was prevented by listeners\n * if (eventBus.fire('foo') === false) {\n *   console.log('default has been prevented!');\n * };\n *\n *\n * // custom args + return value listener\n * eventBus.on('sum', function(event, a, b) {\n *   return a + b;\n * });\n *\n * // you can pass custom arguments + retrieve result values.\n * var sum = eventBus.fire('sum', 1, 2);\n * console.log(sum); // 3\n * ```\n */\nfunction EventBus() {\n\n  /**\n   * @type { Record<string, EventBusListener> }\n   */\n  this._listeners = {};\n\n  // cleanup on destroy on lowest priority to allow\n  // message passing until the bitter end\n  this.on('diagram.destroy', 1, this._destroy, this);\n}\n\n\n/**\n * Register an event listener for events with the given name.\n *\n * The callback will be invoked with `event, ...additionalArguments`\n * that have been passed to {@link EventBus#fire}.\n *\n * Returning false from a listener will prevent the events default action\n * (if any is specified). To stop an event from being processed further in\n * other listeners execute {@link Event#stopPropagation}.\n *\n * Returning anything but `undefined` from a listener will stop the listener propagation.\n *\n * @template T\n *\n * @param {string|string[]} events to subscribe to\n * @param {number} [priority=1000] listen priority\n * @param {EventBusEventCallback<T>} callback\n * @param {any} [that] callback context\n */\nEventBus.prototype.on = function(events, priority, callback, that) {\n\n  events = (0,min_dash_dist_index_esm/* isArray */.kJ)(events) ? events : [ events ];\n\n  if ((0,min_dash_dist_index_esm/* isFunction */.mf)(priority)) {\n    that = callback;\n    callback = priority;\n    priority = DEFAULT_PRIORITY;\n  }\n\n  if (!(0,min_dash_dist_index_esm/* isNumber */.hj)(priority)) {\n    throw new Error('priority must be a number');\n  }\n\n  var actualCallback = callback;\n\n  if (that) {\n    actualCallback = (0,min_dash_dist_index_esm/* bind */.ak)(callback, that);\n\n    // make sure we remember and are able to remove\n    // bound callbacks via {@link #off} using the original\n    // callback\n    actualCallback[FN_REF] = callback[FN_REF] || callback;\n  }\n\n  var self = this;\n\n  events.forEach(function(e) {\n    self._addListener(e, {\n      priority: priority,\n      callback: actualCallback,\n      next: null\n    });\n  });\n};\n\n/**\n * Register an event listener that is called only once.\n *\n * @template T\n *\n * @param {string|string[]} events to subscribe to\n * @param {number} [priority=1000] the listen priority\n * @param {EventBusEventCallback<T>} callback\n * @param {any} [that] callback context\n */\nEventBus.prototype.once = function(events, priority, callback, that) {\n  var self = this;\n\n  if ((0,min_dash_dist_index_esm/* isFunction */.mf)(priority)) {\n    that = callback;\n    callback = priority;\n    priority = DEFAULT_PRIORITY;\n  }\n\n  if (!(0,min_dash_dist_index_esm/* isNumber */.hj)(priority)) {\n    throw new Error('priority must be a number');\n  }\n\n  function wrappedCallback() {\n    wrappedCallback.__isTomb = true;\n\n    var result = callback.apply(that, arguments);\n\n    self.off(events, wrappedCallback);\n\n    return result;\n  }\n\n  // make sure we remember and are able to remove\n  // bound callbacks via {@link #off} using the original\n  // callback\n  wrappedCallback[FN_REF] = callback;\n\n  this.on(events, priority, wrappedCallback);\n};\n\n\n/**\n * Removes event listeners by event and callback.\n *\n * If no callback is given, all listeners for a given event name are being removed.\n *\n * @param {string|string[]} events\n * @param {EventBusEventCallback} [callback]\n */\nEventBus.prototype.off = function(events, callback) {\n\n  events = (0,min_dash_dist_index_esm/* isArray */.kJ)(events) ? events : [ events ];\n\n  var self = this;\n\n  events.forEach(function(event) {\n    self._removeListener(event, callback);\n  });\n\n};\n\n\n/**\n * Create an event recognized be the event bus.\n *\n * @param {Object} data Event data.\n *\n * @return {Event} An event that will be recognized by the event bus.\n */\nEventBus.prototype.createEvent = function(data) {\n  var event = new InternalEvent();\n\n  event.init(data);\n\n  return event;\n};\n\n\n/**\n * Fires an event.\n *\n * @example\n *\n * ```javascript\n * // fire event by name\n * events.fire('foo');\n *\n * // fire event object with nested type\n * var event = { type: 'foo' };\n * events.fire(event);\n *\n * // fire event with explicit type\n * var event = { x: 10, y: 20 };\n * events.fire('element.moved', event);\n *\n * // pass additional arguments to the event\n * events.on('foo', function(event, bar) {\n *   alert(bar);\n * });\n *\n * events.fire({ type: 'foo' }, 'I am bar!');\n * ```\n *\n * @param {string} [type] event type\n * @param {Object} [data] event or event data\n * @param {...any} [args] additional arguments the callback will be called with.\n *\n * @return {any} The return value. Will be set to `false` if the default was prevented.\n */\nEventBus.prototype.fire = function(type, data) {\n  var event,\n      firstListener,\n      returnValue,\n      args;\n\n  args = slice.call(arguments);\n\n  if (typeof type === 'object') {\n    data = type;\n    type = data.type;\n  }\n\n  if (!type) {\n    throw new Error('no event type specified');\n  }\n\n  firstListener = this._listeners[type];\n\n  if (!firstListener) {\n    return;\n  }\n\n  // we make sure we fire instances of our home made\n  // events here. We wrap them only once, though\n  if (data instanceof InternalEvent) {\n\n    // we are fine, we alread have an event\n    event = data;\n  } else {\n    event = this.createEvent(data);\n  }\n\n  // ensure we pass the event as the first parameter\n  args[0] = event;\n\n  // original event type (in case we delegate)\n  var originalType = event.type;\n\n  // update event type before delegation\n  if (type !== originalType) {\n    event.type = type;\n  }\n\n  try {\n    returnValue = this._invokeListeners(event, args, firstListener);\n  } finally {\n\n    // reset event type after delegation\n    if (type !== originalType) {\n      event.type = originalType;\n    }\n  }\n\n  // set the return value to false if the event default\n  // got prevented and no other return value exists\n  if (returnValue === undefined && event.defaultPrevented) {\n    returnValue = false;\n  }\n\n  return returnValue;\n};\n\n/**\n * Handle an error by firing an event.\n *\n * @param {Error} error The error to be handled.\n *\n * @return {boolean} Whether the error was handled.\n */\nEventBus.prototype.handleError = function(error) {\n  return this.fire('error', { error: error }) === false;\n};\n\n\nEventBus.prototype._destroy = function() {\n  this._listeners = {};\n};\n\n/**\n * @param {Event} event\n * @param {any[]} args\n * @param {EventBusListener} listener\n *\n * @return {any}\n */\nEventBus.prototype._invokeListeners = function(event, args, listener) {\n\n  var returnValue;\n\n  while (listener) {\n\n    // handle stopped propagation\n    if (event.cancelBubble) {\n      break;\n    }\n\n    returnValue = this._invokeListener(event, args, listener);\n\n    listener = listener.next;\n  }\n\n  return returnValue;\n};\n\n/**\n * @param {Event} event\n * @param {any[]} args\n * @param {EventBusListener} listener\n *\n * @return {any}\n */\nEventBus.prototype._invokeListener = function(event, args, listener) {\n\n  var returnValue;\n\n  if (listener.callback.__isTomb) {\n    return returnValue;\n  }\n\n  try {\n\n    // returning false prevents the default action\n    returnValue = invokeFunction(listener.callback, args);\n\n    // stop propagation on return value\n    if (returnValue !== undefined) {\n      event.returnValue = returnValue;\n      event.stopPropagation();\n    }\n\n    // prevent default on return false\n    if (returnValue === false) {\n      event.preventDefault();\n    }\n  } catch (error) {\n    if (!this.handleError(error)) {\n      console.error('unhandled error in event listener', error);\n\n      throw error;\n    }\n  }\n\n  return returnValue;\n};\n\n/**\n * Add new listener with a certain priority to the list\n * of listeners (for the given event).\n *\n * The semantics of listener registration / listener execution are\n * first register, first serve: New listeners will always be inserted\n * after existing listeners with the same priority.\n *\n * Example: Inserting two listeners with priority 1000 and 1300\n *\n *    * before: [ 1500, 1500, 1000, 1000 ]\n *    * after: [ 1500, 1500, (new=1300), 1000, 1000, (new=1000) ]\n *\n * @param {string} event\n * @param {EventBusListener} newListener\n */\nEventBus.prototype._addListener = function(event, newListener) {\n\n  var listener = this._getListeners(event),\n      previousListener;\n\n  // no prior listeners\n  if (!listener) {\n    this._setListeners(event, newListener);\n\n    return;\n  }\n\n  // ensure we order listeners by priority from\n  // 0 (high) to n > 0 (low)\n  while (listener) {\n\n    if (listener.priority < newListener.priority) {\n\n      newListener.next = listener;\n\n      if (previousListener) {\n        previousListener.next = newListener;\n      } else {\n        this._setListeners(event, newListener);\n      }\n\n      return;\n    }\n\n    previousListener = listener;\n    listener = listener.next;\n  }\n\n  // add new listener to back\n  previousListener.next = newListener;\n};\n\n\n/**\n * @param {string} name\n *\n * @return {EventBusListener}\n */\nEventBus.prototype._getListeners = function(name) {\n  return this._listeners[name];\n};\n\n/**\n * @param {string} name\n * @param {EventBusListener} listener\n */\nEventBus.prototype._setListeners = function(name, listener) {\n  this._listeners[name] = listener;\n};\n\nEventBus.prototype._removeListener = function(event, callback) {\n\n  var listener = this._getListeners(event),\n      nextListener,\n      previousListener,\n      listenerCallback;\n\n  if (!callback) {\n\n    // clear listeners\n    this._setListeners(event, null);\n\n    return;\n  }\n\n  while (listener) {\n\n    nextListener = listener.next;\n\n    listenerCallback = listener.callback;\n\n    if (listenerCallback === callback || listenerCallback[FN_REF] === callback) {\n      if (previousListener) {\n        previousListener.next = nextListener;\n      } else {\n\n        // new first listener\n        this._setListeners(event, nextListener);\n      }\n    }\n\n    previousListener = listener;\n    listener = nextListener;\n  }\n};\n\n/**\n * A event that is emitted via the event bus.\n */\nfunction InternalEvent() { }\n\nInternalEvent.prototype.stopPropagation = function() {\n  this.cancelBubble = true;\n};\n\nInternalEvent.prototype.preventDefault = function() {\n  this.defaultPrevented = true;\n};\n\nInternalEvent.prototype.init = function(data) {\n  (0,min_dash_dist_index_esm/* assign */.f0)(this, data || {});\n};\n\n\n/**\n * Invoke function. Be fast...\n *\n * @param {Function} fn\n * @param {any[]} args\n *\n * @return {any}\n */\nfunction invokeFunction(fn, args) {\n  return fn.apply(null, args);\n}\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/GraphicsUtil.js\nvar GraphicsUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/GraphicsUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/SvgTransformUtil.js\nvar SvgTransformUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/SvgTransformUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/core/GraphicsFactory.js\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('./Types').ConnectionLike} ConnectionLike\n * @typedef {import('./Types').ElementLike} ElementLike\n * @typedef {import('./Types').ShapeLike} ShapeLike\n *\n * @typedef {import('./ElementRegistry').default} ElementRegistry\n * @typedef {import('./EventBus').default} EventBus\n */\n\n/**\n * A factory that creates graphical elements.\n *\n * @param {EventBus} eventBus\n * @param {ElementRegistry} elementRegistry\n */\nfunction GraphicsFactory(eventBus, elementRegistry) {\n  this._eventBus = eventBus;\n  this._elementRegistry = elementRegistry;\n}\n\nGraphicsFactory.$inject = [ 'eventBus' , 'elementRegistry' ];\n\n/**\n * @param { { parent?: any } } element\n * @return {SVGElement}\n */\nGraphicsFactory.prototype._getChildrenContainer = function(element) {\n\n  var gfx = this._elementRegistry.getGraphics(element);\n\n  var childrenGfx;\n\n  // root element\n  if (!element.parent) {\n    childrenGfx = gfx;\n  } else {\n    childrenGfx = (0,GraphicsUtil/* getChildren */.G)(gfx);\n    if (!childrenGfx) {\n      childrenGfx = (0,dist_index_esm/* create */.Ue)('g');\n      (0,dist_index_esm/* classes */.Sh)(childrenGfx).add('djs-children');\n\n      (0,dist_index_esm/* append */.R3)(gfx.parentNode, childrenGfx);\n    }\n  }\n\n  return childrenGfx;\n};\n\n/**\n * Clears the graphical representation of the element and returns the\n * cleared visual (the <g class=\"djs-visual\" /> element).\n */\nGraphicsFactory.prototype._clear = function(gfx) {\n  var visual = (0,GraphicsUtil/* getVisual */.s)(gfx);\n\n  (0,min_dom_dist_index_esm/* clear */.ZH)(visual);\n\n  return visual;\n};\n\n/**\n * Creates a gfx container for shapes and connections\n *\n * The layout is as follows:\n *\n * <g class=\"djs-group\">\n *\n *   \x3c!-- the gfx --\x3e\n *   <g class=\"djs-element djs-(shape|connection|frame)\">\n *     <g class=\"djs-visual\">\n *       \x3c!-- the renderer draws in here --\x3e\n *     </g>\n *\n *     \x3c!-- extensions (overlays, click box, ...) goes here\n *   </g>\n *\n *   \x3c!-- the gfx child nodes --\x3e\n *   <g class=\"djs-children\"></g>\n * </g>\n *\n * @param {string} type the type of the element, i.e. shape | connection\n * @param {SVGElement} childrenGfx\n * @param {number} [parentIndex] position to create container in parent\n * @param {boolean} [isFrame] is frame element\n *\n * @return {SVGElement}\n */\nGraphicsFactory.prototype._createContainer = function(\n    type, childrenGfx, parentIndex, isFrame\n) {\n  var outerGfx = (0,dist_index_esm/* create */.Ue)('g');\n  (0,dist_index_esm/* classes */.Sh)(outerGfx).add('djs-group');\n\n  // insert node at position\n  if (typeof parentIndex !== 'undefined') {\n    prependTo(outerGfx, childrenGfx, childrenGfx.childNodes[parentIndex]);\n  } else {\n    (0,dist_index_esm/* append */.R3)(childrenGfx, outerGfx);\n  }\n\n  var gfx = (0,dist_index_esm/* create */.Ue)('g');\n  (0,dist_index_esm/* classes */.Sh)(gfx).add('djs-element');\n  (0,dist_index_esm/* classes */.Sh)(gfx).add('djs-' + type);\n\n  if (isFrame) {\n    (0,dist_index_esm/* classes */.Sh)(gfx).add('djs-frame');\n  }\n\n  (0,dist_index_esm/* append */.R3)(outerGfx, gfx);\n\n  // create visual\n  var visual = (0,dist_index_esm/* create */.Ue)('g');\n  (0,dist_index_esm/* classes */.Sh)(visual).add('djs-visual');\n\n  (0,dist_index_esm/* append */.R3)(gfx, visual);\n\n  return gfx;\n};\n\n/**\n * Create a graphical element.\n *\n * @param { 'shape' | 'connection' | 'label' | 'root' } type The type of the element.\n * @param {ElementLike} element The element.\n * @param {number} [parentIndex] The index at which to add the graphical element to its parent's children.\n *\n * @return {SVGElement} The graphical element.\n */\nGraphicsFactory.prototype.create = function(type, element, parentIndex) {\n  var childrenGfx = this._getChildrenContainer(element.parent);\n  return this._createContainer(type, childrenGfx, parentIndex, (0,Elements/* isFrameElement */.He)(element));\n};\n\n/**\n * Update the containments of the given elements.\n *\n * @param {ElementLike[]} elements The elements.\n */\nGraphicsFactory.prototype.updateContainments = function(elements) {\n\n  var self = this,\n      elementRegistry = this._elementRegistry,\n      parents;\n\n  parents = (0,min_dash_dist_index_esm/* reduce */.u4)(elements, function(map, e) {\n\n    if (e.parent) {\n      map[e.parent.id] = e.parent;\n    }\n\n    return map;\n  }, {});\n\n  // update all parents of changed and reorganized their children\n  // in the correct order (as indicated in our model)\n  (0,min_dash_dist_index_esm/* forEach */.Ed)(parents, function(parent) {\n\n    var children = parent.children;\n\n    if (!children) {\n      return;\n    }\n\n    var childrenGfx = self._getChildrenContainer(parent);\n\n    (0,min_dash_dist_index_esm/* forEach */.Ed)(children.slice().reverse(), function(child) {\n      var childGfx = elementRegistry.getGraphics(child);\n\n      prependTo(childGfx.parentNode, childrenGfx);\n    });\n  });\n};\n\n/**\n * Draw a shape.\n *\n * @param {SVGElement} visual The graphical element.\n * @param {ShapeLike} element The shape.\n *\n * @return {SVGElement}\n */\nGraphicsFactory.prototype.drawShape = function(visual, element) {\n  var eventBus = this._eventBus;\n\n  return eventBus.fire('render.shape', { gfx: visual, element: element });\n};\n\n/**\n * Get the path of a shape.\n *\n * @param {ShapeLike} element The shape.\n *\n * @return {string} The path of the shape.\n */\nGraphicsFactory.prototype.getShapePath = function(element) {\n  var eventBus = this._eventBus;\n\n  return eventBus.fire('render.getShapePath', element);\n};\n\n/**\n * Draw a connection.\n *\n * @param {SVGElement} visual The graphical element.\n * @param {ConnectionLike} element The connection.\n *\n * @return {SVGElement}\n */\nGraphicsFactory.prototype.drawConnection = function(visual, element) {\n  var eventBus = this._eventBus;\n\n  return eventBus.fire('render.connection', { gfx: visual, element: element });\n};\n\n/**\n * Get the path of a connection.\n *\n * @param {ConnectionLike} connection The connection.\n *\n * @return {string} The path of the connection.\n */\nGraphicsFactory.prototype.getConnectionPath = function(connection) {\n  var eventBus = this._eventBus;\n\n  return eventBus.fire('render.getConnectionPath', connection);\n};\n\n/**\n * Update an elements graphical representation.\n *\n * @param {'shape'|'connection'} type\n * @param {ElementLike} element\n * @param {SVGElement} gfx\n */\nGraphicsFactory.prototype.update = function(type, element, gfx) {\n\n  // do NOT update root element\n  if (!element.parent) {\n    return;\n  }\n\n  var visual = this._clear(gfx);\n\n  // redraw\n  if (type === 'shape') {\n    this.drawShape(visual, element);\n\n    // update positioning\n    (0,SvgTransformUtil/* translate */.Iu)(gfx, element.x, element.y);\n  } else\n  if (type === 'connection') {\n    this.drawConnection(visual, element);\n  } else {\n    throw new Error('unknown type: ' + type);\n  }\n\n  if (element.hidden) {\n    (0,dist_index_esm/* attr */.Lj)(gfx, 'display', 'none');\n  } else {\n    (0,dist_index_esm/* attr */.Lj)(gfx, 'display', 'block');\n  }\n};\n\n/**\n * Remove a graphical element.\n *\n * @param {ElementLike} element The element.\n */\nGraphicsFactory.prototype.remove = function(element) {\n  var gfx = this._elementRegistry.getGraphics(element);\n\n  // remove\n  (0,dist_index_esm/* remove */.Od)(gfx.parentNode);\n};\n\n\n// helpers //////////\n\nfunction prependTo(newNode, parentNode, siblingNode) {\n  var node = siblingNode || parentNode.firstChild;\n\n  // do not prepend node to itself to prevent IE from crashing\n  // https://github.com/bpmn-io/bpmn-js/issues/746\n  if (newNode === node) {\n    return;\n  }\n\n  parentNode.insertBefore(newNode, node);\n}\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/core/index.js\n\n\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const core = ({\n  __depends__: [ draw ],\n  __init__: [ 'canvas' ],\n  canvas: [ 'type', Canvas ],\n  elementRegistry: [ 'type', ElementRegistry ],\n  elementFactory: [ 'type', ElementFactory/* default */.Z ],\n  eventBus: [ 'type', EventBus ],\n  graphicsFactory: [ 'type', GraphicsFactory ]\n});\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/Diagram.js\n\n\n\n\n/**\n * @typedef {import('didi').InjectionContext} InjectionContext\n * @typedef {import('didi').LocalsMap} LocalsMap\n * @typedef {import('didi').ModuleDeclaration} ModuleDeclaration\n *\n * @typedef { {\n *   modules?: ModuleDeclaration[];\n * } & Record<string, any> } DiagramOptions\n */\n\n/**\n * Bootstrap an injector from a list of modules, instantiating a number of default components\n *\n * @param {ModuleDeclaration[]} modules\n *\n * @return {Injector} a injector to use to access the components\n */\nfunction bootstrap(modules) {\n  var injector = new index_esm/* Injector */.zs(modules);\n\n  injector.init();\n\n  return injector;\n}\n\n/**\n * Creates an injector from passed options.\n *\n * @param {DiagramOptions} [options]\n *\n * @return {Injector}\n */\nfunction createInjector(options) {\n\n  options = options || {};\n\n  /**\n   * @type { ModuleDeclaration }\n   */\n  var configModule = {\n    'config': [ 'value', options ]\n  };\n\n  var modules = [ configModule, core ].concat(options.modules || []);\n\n  return bootstrap(modules);\n}\n\n\n/**\n * The main diagram-js entry point that bootstraps the diagram with the given\n * configuration.\n *\n * To register extensions with the diagram, pass them as Array<Module> to the constructor.\n *\n * @class\n * @constructor\n *\n * @example Creating a plug-in that logs whenever a shape is added to the canvas.\n *\n * ```javascript\n * // plug-in implementation\n * function MyLoggingPlugin(eventBus) {\n *   eventBus.on('shape.added', function(event) {\n *     console.log('shape ', event.shape, ' was added to the diagram');\n *   });\n * }\n *\n * // export as module\n * export default {\n *   __init__: [ 'myLoggingPlugin' ],\n *     myLoggingPlugin: [ 'type', MyLoggingPlugin ]\n * };\n * ```\n *\n * Use the plug-in in a Diagram instance:\n *\n * ```javascript\n * import MyLoggingModule from 'path-to-my-logging-plugin';\n *\n * var diagram = new Diagram({\n *   modules: [\n *     MyLoggingModule\n *   ]\n * });\n *\n * diagram.invoke([ 'canvas', function(canvas) {\n *   // add shape to drawing canvas\n *   canvas.addShape({ x: 10, y: 10 });\n * });\n *\n * // 'shape ... was added to the diagram' logged to console\n * ```\n *\n * @param {DiagramOptions} [options]\n * @param {Injector} [injector] An (optional) injector to bootstrap the diagram with.\n */\nfunction Diagram(options, injector) {\n\n  this._injector = injector = injector || createInjector(options);\n\n  // API\n\n  /**\n   * Resolves a diagram service.\n   *\n   * @template T\n   *\n   * @param {string} name The name of the service to get.\n   * @param {boolean} [strict=true] If false, resolve missing services to null.\n   *\n   * @return {T|null}\n   */\n  this.get = injector.get;\n\n  /**\n   * Executes a function with its dependencies injected.\n   *\n   * @template T\n   *\n   * @param {Function} func function to be invoked\n   * @param {InjectionContext} [context] context of the invocation\n   * @param {LocalsMap} [locals] locals provided\n   *\n   * @return {T|null}\n   */\n  this.invoke = injector.invoke;\n\n  // init\n\n  // indicate via event\n\n\n  /**\n   * An event indicating that all plug-ins are loaded.\n   *\n   * Use this event to fire other events to interested plug-ins\n   *\n   * @memberOf Diagram\n   *\n   * @event diagram.init\n   *\n   * @example\n   *\n   * ```javascript\n   * eventBus.on('diagram.init', function() {\n   *   eventBus.fire('my-custom-event', { foo: 'BAR' });\n   * });\n   * ```\n   *\n   * @type {Object}\n   */\n  this.get('eventBus').fire('diagram.init');\n}\n\n\n/**\n * Destroys the diagram\n */\nDiagram.prototype.destroy = function() {\n  this.get('eventBus').fire('diagram.destroy');\n};\n\n/**\n * Clear the diagram, removing all contents.\n */\nDiagram.prototype.clear = function() {\n  this.get('eventBus').fire('diagram.clear');\n};\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/Diagram.js_+_8_modules?")},"./node_modules/diagram-js/lib/command/CommandInterceptor.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ CommandInterceptor)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n\n\n/**\n * @typedef {import('../core/Types').ElementLike} ElementLike\n * @typedef {import('../core/EventBus').default} EventBus\n * @typedef {import('./CommandStack').CommandContext} CommandContext\n *\n * @typedef {string|string[]} Events\n * @typedef { (context: CommandContext) => ElementLike[] | void } HandlerFunction\n * @typedef { (context: CommandContext) => void } ComposeHandlerFunction\n */\n\nvar DEFAULT_PRIORITY = 1000;\n\n/**\n * A utility that can be used to plug into the command execution for\n * extension and/or validation.\n *\n * @class\n * @constructor\n *\n * @example\n *\n * ```javascript\n * import CommandInterceptor from 'diagram-js/lib/command/CommandInterceptor';\n *\n * class CommandLogger extends CommandInterceptor {\n *   constructor(eventBus) {\n *     super(eventBus);\n *\n *   this.preExecute('shape.create', (event) => {\n *     console.log('commandStack.shape-create.preExecute', event);\n *   });\n * }\n * ```\n *\n * @param {EventBus} eventBus\n */\nfunction CommandInterceptor(eventBus) {\n\n  /**\n   * @type {EventBus}\n   */\n  this._eventBus = eventBus;\n}\n\nCommandInterceptor.$inject = [ 'eventBus' ];\n\nfunction unwrapEvent(fn, that) {\n  return function(event) {\n    return fn.call(that || null, event.context, event.command, event);\n  };\n}\n\n\n/**\n * Intercept a command during one of the phases.\n *\n * @param {Events} [events] command(s) to intercept\n * @param {string} [hook] phase to intercept\n * @param {number} [priority]\n * @param {ComposeHandlerFunction|HandlerFunction} handlerFn\n * @param {boolean} [unwrap] whether the event should be unwrapped\n * @param {any} [that]\n */\nCommandInterceptor.prototype.on = function(events, hook, priority, handlerFn, unwrap, that) {\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .mf)(hook) || (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(hook)) {\n    that = unwrap;\n    unwrap = handlerFn;\n    handlerFn = priority;\n    priority = hook;\n    hook = null;\n  }\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .mf)(priority)) {\n    that = unwrap;\n    unwrap = handlerFn;\n    handlerFn = priority;\n    priority = DEFAULT_PRIORITY;\n  }\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isObject */ .Kn)(unwrap)) {\n    that = unwrap;\n    unwrap = false;\n  }\n\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .mf)(handlerFn)) {\n    throw new Error('handlerFn must be a function');\n  }\n\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .kJ)(events)) {\n    events = [ events ];\n  }\n\n  var eventBus = this._eventBus;\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(events, function(event) {\n\n    // concat commandStack(.event)?(.hook)?\n    var fullEvent = [ 'commandStack', event, hook ].filter(function(e) { return e; }).join('.');\n\n    eventBus.on(fullEvent, priority, unwrap ? unwrapEvent(handlerFn, that) : handlerFn, that);\n  });\n};\n\n/**\n * Add a <canExecute> phase of command interceptor.\n *\n * @param {Events} [events] command(s) to intercept\n * @param {number} [priority]\n * @param {ComposeHandlerFunction|HandlerFunction} handlerFn\n * @param {boolean} [unwrap] whether the event should be unwrapped\n * @param {any} [that]\n */\nCommandInterceptor.prototype.canExecute = createHook('canExecute');\n\n/**\n * Add a <preExecute> phase of command interceptor.\n *\n * @param {Events} [events] command(s) to intercept\n * @param {number} [priority]\n * @param {ComposeHandlerFunction|HandlerFunction} handlerFn\n * @param {boolean} [unwrap] whether the event should be unwrapped\n * @param {any} [that]\n */\nCommandInterceptor.prototype.preExecute = createHook('preExecute');\n\n/**\n * Add a <preExecuted> phase of command interceptor.\n *\n * @param {Events} [events] command(s) to intercept\n * @param {number} [priority]\n * @param {ComposeHandlerFunction|HandlerFunction} handlerFn\n * @param {boolean} [unwrap] whether the event should be unwrapped\n * @param {any} [that]\n */\nCommandInterceptor.prototype.preExecuted = createHook('preExecuted');\n\n/**\n * Add a <execute> phase of command interceptor.\n *\n * @param {Events} [events] command(s) to intercept\n * @param {number} [priority]\n * @param {ComposeHandlerFunction|HandlerFunction} handlerFn\n * @param {boolean} [unwrap] whether the event should be unwrapped\n * @param {any} [that]\n */\nCommandInterceptor.prototype.execute = createHook('execute');\n\n/**\n * Add a <executed> phase of command interceptor.\n *\n * @param {Events} [events] command(s) to intercept\n * @param {number} [priority]\n * @param {ComposeHandlerFunction|HandlerFunction} handlerFn\n * @param {boolean} [unwrap] whether the event should be unwrapped\n * @param {any} [that]\n */\nCommandInterceptor.prototype.executed = createHook('executed');\n\n/**\n * Add a <postExecute> phase of command interceptor.\n *\n * @param {Events} [events] command(s) to intercept\n * @param {number} [priority]\n * @param {ComposeHandlerFunction|HandlerFunction} handlerFn\n * @param {boolean} [unwrap] whether the event should be unwrapped\n * @param {any} [that]\n */\nCommandInterceptor.prototype.postExecute = createHook('postExecute');\n\n/**\n * Add a <postExecuted> phase of command interceptor.\n *\n * @param {Events} [events] command(s) to intercept\n * @param {number} [priority]\n * @param {ComposeHandlerFunction|HandlerFunction} handlerFn\n * @param {boolean} [unwrap] whether the event should be unwrapped\n * @param {any} [that]\n */\nCommandInterceptor.prototype.postExecuted = createHook('postExecuted');\n\n/**\n * Add a <revert> phase of command interceptor.\n *\n * @param {Events} [events] command(s) to intercept\n * @param {number} [priority]\n * @param {ComposeHandlerFunction|HandlerFunction} handlerFn\n * @param {boolean} [unwrap] whether the event should be unwrapped\n * @param {any} [that]\n */\nCommandInterceptor.prototype.revert = createHook('revert');\n\n/**\n * Add a <reverted> phase of command interceptor.\n *\n * @param {Events} [events] command(s) to intercept\n * @param {number} [priority]\n * @param {ComposeHandlerFunction|HandlerFunction} handlerFn\n * @param {boolean} [unwrap] whether the event should be unwrapped\n * @param {any} [that]\n */\nCommandInterceptor.prototype.reverted = createHook('reverted');\n\n/*\n * Add prototype methods for each phase of command execution (e.g. execute,\n * revert).\n *\n * @param {string} hook\n *\n * @return { (\n *   events?: Events,\n *   priority?: number,\n *   handlerFn: ComposeHandlerFunction|HandlerFunction,\n *   unwrap?: boolean\n * ) => any }\n */\nfunction createHook(hook) {\n\n  /**\n   * @this {CommandInterceptor}\n   *\n   * @param {Events} [events]\n   * @param {number} [priority]\n   * @param {ComposeHandlerFunction|HandlerFunction} handlerFn\n   * @param {boolean} [unwrap]\n   * @param {any} [that]\n   */\n  const hookFn = function(events, priority, handlerFn, unwrap, that) {\n\n    if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .mf)(events) || (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(events)) {\n      that = unwrap;\n      unwrap = handlerFn;\n      handlerFn = priority;\n      priority = events;\n      events = null;\n    }\n\n    this.on(events, hook, priority, handlerFn, unwrap, that);\n  };\n\n  return hookFn;\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/command/CommandInterceptor.js?")},"./node_modules/diagram-js/lib/command/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ command)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/command/CommandStack.js\n\n\n/**\n * @typedef {import('didi').Injector} Injector\n *\n * @typedef {import('../core/Types').ElementLike} ElementLike\n *\n * @typedef {import('../core/EventBus').default} EventBus\n * @typedef {import('./CommandHandler').default} CommandHandler\n *\n * @typedef { any } CommandContext\n * @typedef { {\n *   new (...args: any[]) : CommandHandler\n * } } CommandHandlerConstructor\n * @typedef { {\n *   [key: string]: CommandHandler;\n * } } CommandHandlerMap\n * @typedef { {\n *   command: string;\n *   context: any;\n *   id?: any;\n * } } CommandStackAction\n * @typedef { {\n *   actions: CommandStackAction[];\n *   dirty: ElementLike[];\n *   trigger: 'execute' | 'undo' | 'redo' | 'clear' | null;\n *   atomic?: boolean;\n * } } CurrentExecution\n */\n\n/**\n * A service that offers un- and redoable execution of commands.\n *\n * The command stack is responsible for executing modeling actions\n * in a un- and redoable manner. To do this it delegates the actual\n * command execution to {@link CommandHandler}s.\n *\n * Command handlers provide {@link CommandHandler#execute(ctx)} and\n * {@link CommandHandler#revert(ctx)} methods to un- and redo a command\n * identified by a command context.\n *\n *\n * ## Life-Cycle events\n *\n * In the process the command stack fires a number of life-cycle events\n * that other components to participate in the command execution.\n *\n *    * preExecute\n *    * preExecuted\n *    * execute\n *    * executed\n *    * postExecute\n *    * postExecuted\n *    * revert\n *    * reverted\n *\n * A special event is used for validating, whether a command can be\n * performed prior to its execution.\n *\n *    * canExecute\n *\n * Each of the events is fired as `commandStack.{eventName}` and\n * `commandStack.{commandName}.{eventName}`, respectively. This gives\n * components fine grained control on where to hook into.\n *\n * The event object fired transports `command`, the name of the\n * command and `context`, the command context.\n *\n *\n * ## Creating Command Handlers\n *\n * Command handlers should provide the {@link CommandHandler#execute(ctx)}\n * and {@link CommandHandler#revert(ctx)} methods to implement\n * redoing and undoing of a command.\n *\n * A command handler _must_ ensure undo is performed properly in order\n * not to break the undo chain. It must also return the shapes that\n * got changed during the `execute` and `revert` operations.\n *\n * Command handlers may execute other modeling operations (and thus\n * commands) in their `preExecute(d)` and `postExecute(d)` phases. The command\n * stack will properly group all commands together into a logical unit\n * that may be re- and undone atomically.\n *\n * Command handlers must not execute other commands from within their\n * core implementation (`execute`, `revert`).\n *\n *\n * ## Change Tracking\n *\n * During the execution of the CommandStack it will keep track of all\n * elements that have been touched during the command's execution.\n *\n * At the end of the CommandStack execution it will notify interested\n * components via an 'elements.changed' event with all the dirty\n * elements.\n *\n * The event can be picked up by components that are interested in the fact\n * that elements have been changed. One use case for this is updating\n * their graphical representation after moving / resizing or deletion.\n *\n * @see CommandHandler\n *\n * @param {EventBus} eventBus\n * @param {Injector} injector\n */\nfunction CommandStack(eventBus, injector) {\n\n  /**\n   * A map of all registered command handlers.\n   *\n   * @type {CommandHandlerMap}\n   */\n  this._handlerMap = {};\n\n  /**\n   * A stack containing all re/undoable actions on the diagram\n   *\n   * @type {CommandStackAction[]}\n   */\n  this._stack = [];\n\n  /**\n   * The current index on the stack\n   *\n   * @type {number}\n   */\n  this._stackIdx = -1;\n\n  /**\n   * Current active commandStack execution\n   *\n   * @type {CurrentExecution}\n   */\n  this._currentExecution = {\n    actions: [],\n    dirty: [],\n    trigger: null\n  };\n\n  /**\n   * @type {Injector}\n   */\n  this._injector = injector;\n\n  /**\n   * @type EventBus\n   */\n  this._eventBus = eventBus;\n\n  /**\n   * @type { number }\n   */\n  this._uid = 1;\n\n  eventBus.on([\n    'diagram.destroy',\n    'diagram.clear'\n  ], function() {\n    this.clear(false);\n  }, this);\n}\n\nCommandStack.$inject = [ 'eventBus', 'injector' ];\n\n\n/**\n * Execute a command.\n *\n * @param {string} command The command to execute.\n * @param {CommandContext} context The context with which to execute the command.\n */\nCommandStack.prototype.execute = function(command, context) {\n  if (!command) {\n    throw new Error('command required');\n  }\n\n  this._currentExecution.trigger = 'execute';\n\n  const action = { command: command, context: context };\n\n  this._pushAction(action);\n  this._internalExecute(action);\n  this._popAction();\n};\n\n\n/**\n * Check whether a command can be executed.\n *\n * Implementors may hook into the mechanism on two ways:\n *\n *   * in event listeners:\n *\n *     Users may prevent the execution via an event listener.\n *     It must prevent the default action for `commandStack.(<command>.)canExecute` events.\n *\n *   * in command handlers:\n *\n *     If the method {@link CommandHandler#canExecute} is implemented in a handler\n *     it will be called to figure out whether the execution is allowed.\n *\n * @param {string} command The command to execute.\n * @param {CommandContext} context The context with which to execute the command.\n *\n * @return {boolean} Whether the command can be executed with the given context.\n */\nCommandStack.prototype.canExecute = function(command, context) {\n\n  const action = { command: command, context: context };\n\n  const handler = this._getHandler(command);\n\n  let result = this._fire(command, 'canExecute', action);\n\n  // handler#canExecute will only be called if no listener\n  // decided on a result already\n  if (result === undefined) {\n    if (!handler) {\n      return false;\n    }\n\n    if (handler.canExecute) {\n      result = handler.canExecute(context);\n    }\n  }\n\n  return result;\n};\n\n\n/**\n * Clear the command stack, erasing all undo / redo history.\n *\n * @param {boolean} [emit=true] Whether to fire an event. Defaults to `true`.\n */\nCommandStack.prototype.clear = function(emit) {\n  this._stack.length = 0;\n  this._stackIdx = -1;\n\n  if (emit !== false) {\n    this._fire('changed', { trigger: 'clear' });\n  }\n};\n\n\n/**\n * Undo last command(s)\n */\nCommandStack.prototype.undo = function() {\n  let action = this._getUndoAction(),\n      next;\n\n  if (action) {\n    this._currentExecution.trigger = 'undo';\n\n    this._pushAction(action);\n\n    while (action) {\n      this._internalUndo(action);\n      next = this._getUndoAction();\n\n      if (!next || next.id !== action.id) {\n        break;\n      }\n\n      action = next;\n    }\n\n    this._popAction();\n  }\n};\n\n\n/**\n * Redo last command(s)\n */\nCommandStack.prototype.redo = function() {\n  let action = this._getRedoAction(),\n      next;\n\n  if (action) {\n    this._currentExecution.trigger = 'redo';\n\n    this._pushAction(action);\n\n    while (action) {\n      this._internalExecute(action, true);\n      next = this._getRedoAction();\n\n      if (!next || next.id !== action.id) {\n        break;\n      }\n\n      action = next;\n    }\n\n    this._popAction();\n  }\n};\n\n\n/**\n * Register a handler instance with the command stack.\n *\n * @param {string} command Command to be executed.\n * @param {CommandHandler} handler Handler to execute the command.\n */\nCommandStack.prototype.register = function(command, handler) {\n  this._setHandler(command, handler);\n};\n\n\n/**\n * Register a handler type with the command stack  by instantiating it and\n * injecting its dependencies.\n *\n * @param {string} command Command to be executed.\n * @param {CommandHandlerConstructor} handlerCls Constructor to instantiate a {@link CommandHandler}.\n */\nCommandStack.prototype.registerHandler = function(command, handlerCls) {\n\n  if (!command || !handlerCls) {\n    throw new Error('command and handlerCls must be defined');\n  }\n\n  const handler = this._injector.instantiate(handlerCls);\n  this.register(command, handler);\n};\n\n/**\n * @return {boolean}\n */\nCommandStack.prototype.canUndo = function() {\n  return !!this._getUndoAction();\n};\n\n/**\n * @return {boolean}\n */\nCommandStack.prototype.canRedo = function() {\n  return !!this._getRedoAction();\n};\n\n// stack access  //////////////////////\n\nCommandStack.prototype._getRedoAction = function() {\n  return this._stack[this._stackIdx + 1];\n};\n\n\nCommandStack.prototype._getUndoAction = function() {\n  return this._stack[this._stackIdx];\n};\n\n\n// internal functionality //////////////////////\n\nCommandStack.prototype._internalUndo = function(action) {\n  const command = action.command,\n        context = action.context;\n\n  const handler = this._getHandler(command);\n\n  // guard against illegal nested command stack invocations\n  this._atomicDo(() => {\n    this._fire(command, 'revert', action);\n\n    if (handler.revert) {\n      this._markDirty(handler.revert(context));\n    }\n\n    this._revertedAction(action);\n\n    this._fire(command, 'reverted', action);\n  });\n};\n\n\nCommandStack.prototype._fire = function(command, qualifier, event) {\n  if (arguments.length < 3) {\n    event = qualifier;\n    qualifier = null;\n  }\n\n  const names = qualifier ? [ command + '.' + qualifier, qualifier ] : [ command ];\n  let result;\n\n  event = this._eventBus.createEvent(event);\n\n  for (const name of names) {\n    result = this._eventBus.fire('commandStack.' + name, event);\n\n    if (event.cancelBubble) {\n      break;\n    }\n  }\n\n  return result;\n};\n\nCommandStack.prototype._createId = function() {\n  return this._uid++;\n};\n\nCommandStack.prototype._atomicDo = function(fn) {\n\n  const execution = this._currentExecution;\n\n  execution.atomic = true;\n\n  try {\n    fn();\n  } finally {\n    execution.atomic = false;\n  }\n};\n\nCommandStack.prototype._internalExecute = function(action, redo) {\n  const command = action.command,\n        context = action.context;\n\n  const handler = this._getHandler(command);\n\n  if (!handler) {\n    throw new Error('no command handler registered for <' + command + '>');\n  }\n\n  this._pushAction(action);\n\n  if (!redo) {\n    this._fire(command, 'preExecute', action);\n\n    if (handler.preExecute) {\n      handler.preExecute(context);\n    }\n\n    this._fire(command, 'preExecuted', action);\n  }\n\n  // guard against illegal nested command stack invocations\n  this._atomicDo(() => {\n\n    this._fire(command, 'execute', action);\n\n    if (handler.execute) {\n\n      // actual execute + mark return results as dirty\n      this._markDirty(handler.execute(context));\n    }\n\n    // log to stack\n    this._executedAction(action, redo);\n\n    this._fire(command, 'executed', action);\n  });\n\n  if (!redo) {\n    this._fire(command, 'postExecute', action);\n\n    if (handler.postExecute) {\n      handler.postExecute(context);\n    }\n\n    this._fire(command, 'postExecuted', action);\n  }\n\n  this._popAction();\n};\n\n\nCommandStack.prototype._pushAction = function(action) {\n\n  const execution = this._currentExecution,\n        actions = execution.actions;\n\n  const baseAction = actions[0];\n\n  if (execution.atomic) {\n    throw new Error('illegal invocation in <execute> or <revert> phase (action: ' + action.command + ')');\n  }\n\n  if (!action.id) {\n    action.id = (baseAction && baseAction.id) || this._createId();\n  }\n\n  actions.push(action);\n};\n\n\nCommandStack.prototype._popAction = function() {\n  const execution = this._currentExecution,\n        trigger = execution.trigger,\n        actions = execution.actions,\n        dirty = execution.dirty;\n\n  actions.pop();\n\n  if (!actions.length) {\n    this._eventBus.fire('elements.changed', { elements: (0,index_esm/* uniqueBy */.uw)('id', dirty.reverse()) });\n\n    dirty.length = 0;\n\n    this._fire('changed', { trigger: trigger });\n\n    execution.trigger = null;\n  }\n};\n\n\nCommandStack.prototype._markDirty = function(elements) {\n  const execution = this._currentExecution;\n\n  if (!elements) {\n    return;\n  }\n\n  elements = (0,index_esm/* isArray */.kJ)(elements) ? elements : [ elements ];\n\n  execution.dirty = execution.dirty.concat(elements);\n};\n\n\nCommandStack.prototype._executedAction = function(action, redo) {\n  const stackIdx = ++this._stackIdx;\n\n  if (!redo) {\n    this._stack.splice(stackIdx, this._stack.length, action);\n  }\n};\n\n\nCommandStack.prototype._revertedAction = function(action) {\n  this._stackIdx--;\n};\n\n\nCommandStack.prototype._getHandler = function(command) {\n  return this._handlerMap[command];\n};\n\nCommandStack.prototype._setHandler = function(command, handler) {\n  if (!command || !handler) {\n    throw new Error('command and handler required');\n  }\n\n  if (this._handlerMap[command]) {\n    throw new Error('overriding handler for command <' + command + '>');\n  }\n\n  this._handlerMap[command] = handler;\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/command/index.js\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const command = ({\n  commandStack: [ 'type', CommandStack ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/command/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/core/ElementFactory.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ ElementFactory)\n/* harmony export */ });\n/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/diagram-js/lib/model/index.js\");\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n\n\n\n\n/**\n * @typedef {import('../model/Types').Element} Element\n * @typedef {import('../model/Types').Connection} Connection\n * @typedef {import('../model/Types').Label} Label\n * @typedef {import('../model/Types').Root} Root\n * @typedef {import('../model/Types').Shape} Shape\n */\n\n/**\n * A factory for model elements.\n *\n * @template {Connection} [T=Connection]\n * @template {Label} [U=Label]\n * @template {Root} [V=Root]\n * @template {Shape} [W=Shape]\n */\nfunction ElementFactory() {\n  this._uid = 12;\n}\n\n/**\n * Create a root element.\n *\n * @param {Partial<Root>} [attrs]\n *\n * @return {V} The created root element.\n */\nElementFactory.prototype.createRoot = function(attrs) {\n  return this.create('root', attrs);\n};\n\n/**\n * Create a label.\n *\n * @param {Partial<Label>} [attrs]\n *\n * @return {U} The created label.\n */\nElementFactory.prototype.createLabel = function(attrs) {\n  return this.create('label', attrs);\n};\n\n/**\n * Create a shape.\n *\n * @param {Partial<Shape>} [attrs]\n *\n * @return {W} The created shape.\n */\nElementFactory.prototype.createShape = function(attrs) {\n  return this.create('shape', attrs);\n};\n\n/**\n * Create a connection.\n *\n * @param {Partial<Connection>} [attrs]\n *\n * @return {T} The created connection.\n */\nElementFactory.prototype.createConnection = function(attrs) {\n  return this.create('connection', attrs);\n};\n\n/**\n * Create a root element.\n *\n * @overlord\n * @param {'root'} type\n * @param {Partial<Root>} [attrs]\n * @return {V}\n */\n/**\n * Create a shape.\n *\n * @overlord\n * @param {'shape'} type\n * @param {Partial<Shape>} [attrs]\n * @return {W}\n */\n/**\n * Create a connection.\n *\n * @overlord\n * @param {'connection'} type\n * @param {Partial<Connection>} [attrs]\n * @return {T}\n */\n/**\n * Create a label.\n *\n * @param {'label'} type\n * @param {Partial<Label>} [attrs]\n * @return {U}\n */\nElementFactory.prototype.create = function(type, attrs) {\n\n  attrs = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .assign */ .f0)({}, attrs || {});\n\n  if (!attrs.id) {\n    attrs.id = type + '_' + (this._uid++);\n  }\n\n  return (0,_model__WEBPACK_IMPORTED_MODULE_1__/* .create */ .U)(type, attrs);\n};\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/core/ElementFactory.js?")},"./node_modules/diagram-js/lib/draw/BaseRenderer.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ BaseRenderer)\n/* harmony export */ });\nvar DEFAULT_RENDER_PRIORITY = 1000;\n\n/**\n * @typedef {import('../core/Types').ElementLike} Element\n * @typedef {import('../core/Types').ConnectionLike} Connection\n * @typedef {import('../core/Types').ShapeLike} Shape\n *\n * @typedef {import('../core/EventBus').default} EventBus\n */\n\n/**\n * The base implementation of shape and connection renderers.\n *\n * @param {EventBus} eventBus\n * @param {number} [renderPriority=1000]\n */\nfunction BaseRenderer(eventBus, renderPriority) {\n  var self = this;\n\n  renderPriority = renderPriority || DEFAULT_RENDER_PRIORITY;\n\n  eventBus.on([ 'render.shape', 'render.connection' ], renderPriority, function(evt, context) {\n    var type = evt.type,\n        element = context.element,\n        visuals = context.gfx,\n        attrs = context.attrs;\n\n    if (self.canRender(element)) {\n      if (type === 'render.shape') {\n        return self.drawShape(visuals, element, attrs);\n      } else {\n        return self.drawConnection(visuals, element, attrs);\n      }\n    }\n  });\n\n  eventBus.on([ 'render.getShapePath', 'render.getConnectionPath' ], renderPriority, function(evt, element) {\n    if (self.canRender(element)) {\n      if (evt.type === 'render.getShapePath') {\n        return self.getShapePath(element);\n      } else {\n        return self.getConnectionPath(element);\n      }\n    }\n  });\n}\n\n/**\n * Checks whether an element can be rendered.\n *\n * @param {Element} element The element to be rendered.\n *\n * @return {boolean} Whether the element can be rendered.\n */\nBaseRenderer.prototype.canRender = function(element) {};\n\n/**\n * Draws a shape.\n *\n * @param {SVGElement} visuals The SVG element to draw the shape into.\n * @param {Shape} shape The shape to be drawn.\n *\n * @return {SVGElement} The SVG element of the shape drawn.\n */\nBaseRenderer.prototype.drawShape = function(visuals, shape) {};\n\n/**\n * Draws a connection.\n *\n * @param {SVGElement} visuals The SVG element to draw the connection into.\n * @param {Connection} connection The connection to be drawn.\n *\n * @return {SVGElement} The SVG element of the connection drawn.\n */\nBaseRenderer.prototype.drawConnection = function(visuals, connection) {};\n\n/**\n * Gets the SVG path of the graphical representation of a shape.\n *\n * @param {Shape} shape The shape.\n *\n * @return {string} The SVG path of the shape.\n */\nBaseRenderer.prototype.getShapePath = function(shape) {};\n\n/**\n * Gets the SVG path of the graphical representation of a connection.\n *\n * @param {Connection} connection The connection.\n *\n * @return {string} The SVG path of the connection.\n */\nBaseRenderer.prototype.getConnectionPath = function(connection) {};\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/draw/BaseRenderer.js?")},"./node_modules/diagram-js/lib/features/align-elements/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ align_elements)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/align-elements/AlignElements.js\n\n\n/**\n * @typedef {import('../../model/Types').Element} Element\n *\n * @typedef {import('../modeling/Modeling').default} Modeling\n * @typedef {import('../rules/Rules').default} Rules\n *\n * @typedef {import('../../util/Types').Axis} Axis\n * @typedef {import('../../util/Types').Dimension} Dimension\n *\n * @typedef { 'top' | 'right' | 'bottom' | 'left' | 'center' | 'middle' } Alignment\n */\n\nfunction last(arr) {\n  return arr && arr[arr.length - 1];\n}\n\nfunction sortTopOrMiddle(element) {\n  return element.y;\n}\n\nfunction sortLeftOrCenter(element) {\n  return element.x;\n}\n\n/**\n * Sorting functions for different alignments.\n *\n * @type {Record<string, Function>}\n */\nvar ALIGNMENT_SORTING = {\n  left: sortLeftOrCenter,\n  center: sortLeftOrCenter,\n  right: function(element) {\n    return element.x + element.width;\n  },\n  top: sortTopOrMiddle,\n  middle: sortTopOrMiddle,\n  bottom: function(element) {\n    return element.y + element.height;\n  }\n};\n\n/**\n * @param {Modeling} modeling\n * @param {Rules} rules\n */\nfunction AlignElements(modeling, rules) {\n  this._modeling = modeling;\n  this._rules = rules;\n}\n\nAlignElements.$inject = [ 'modeling', 'rules' ];\n\n\n/**\n * Get relevant axis and dimension for given alignment.\n *\n * @param {Alignment} type\n *\n * @return { {\n *   axis: Axis;\n *   dimension: Dimension;\n * } }\n */\nAlignElements.prototype._getOrientationDetails = function(type) {\n  var vertical = [ 'top', 'bottom', 'middle' ],\n      axis = 'x',\n      dimension = 'width';\n\n  if (vertical.indexOf(type) !== -1) {\n    axis = 'y';\n    dimension = 'height';\n  }\n\n  return {\n    axis: axis,\n    dimension: dimension\n  };\n};\n\nAlignElements.prototype._isType = function(type, types) {\n  return types.indexOf(type) !== -1;\n};\n\n/**\n * Get point on relevant axis for given alignment.\n *\n * @param {Alignment} type\n * @param {Element[]} sortedElements\n *\n * @return {Partial<Record<Alignment, number>>}\n */\nAlignElements.prototype._alignmentPosition = function(type, sortedElements) {\n  var orientation = this._getOrientationDetails(type),\n      axis = orientation.axis,\n      dimension = orientation.dimension,\n      alignment = {},\n      centers = {},\n      hasSharedCenters = false,\n      centeredElements,\n      firstElement,\n      lastElement;\n\n  function getMiddleOrTop(first, last) {\n    return Math.round((first[axis] + last[axis] + last[dimension]) / 2);\n  }\n\n  if (this._isType(type, [ 'left', 'top' ])) {\n    alignment[type] = sortedElements[0][axis];\n\n  } else if (this._isType(type, [ 'right', 'bottom' ])) {\n    lastElement = last(sortedElements);\n\n    alignment[type] = lastElement[axis] + lastElement[dimension];\n\n  } else if (this._isType(type, [ 'center', 'middle' ])) {\n\n    // check if there is a center shared by more than one shape\n    // if not, just take the middle of the range\n    (0,index_esm/* forEach */.Ed)(sortedElements, function(element) {\n      var center = element[axis] + Math.round(element[dimension] / 2);\n\n      if (centers[center]) {\n        centers[center].elements.push(element);\n      } else {\n        centers[center] = {\n          elements: [ element ],\n          center: center\n        };\n      }\n    });\n\n    centeredElements = (0,index_esm/* sortBy */.MR)(centers, function(center) {\n      if (center.elements.length > 1) {\n        hasSharedCenters = true;\n      }\n\n      return center.elements.length;\n    });\n\n    if (hasSharedCenters) {\n      alignment[type] = last(centeredElements).center;\n\n      return alignment;\n    }\n\n    firstElement = sortedElements[0];\n\n    sortedElements = (0,index_esm/* sortBy */.MR)(sortedElements, function(element) {\n      return element[axis] + element[dimension];\n    });\n\n    lastElement = last(sortedElements);\n\n    alignment[type] = getMiddleOrTop(firstElement, lastElement);\n  }\n\n  return alignment;\n};\n\n/**\n * Align elements on relevant axis for given alignment.\n *\n * @param {Element[]} elements\n * @param {Alignment} type\n */\nAlignElements.prototype.trigger = function(elements, type) {\n  var modeling = this._modeling,\n      allowed;\n\n  // filter out elements which cannot be aligned\n  var filteredElements = (0,index_esm/* filter */.hX)(elements, function(element) {\n    return !(element.waypoints || element.host || element.labelTarget);\n  });\n\n  // filter out elements via rules\n  allowed = this._rules.allowed('elements.align', { elements: filteredElements });\n  if ((0,index_esm/* isArray */.kJ)(allowed)) {\n    filteredElements = allowed;\n  }\n\n  if (filteredElements.length < 2 || !allowed) {\n    return;\n  }\n\n  var sortFn = ALIGNMENT_SORTING[type];\n\n  var sortedElements = (0,index_esm/* sortBy */.MR)(filteredElements, sortFn);\n\n  var alignment = this._alignmentPosition(type, sortedElements);\n\n  modeling.alignElements(sortedElements, alignment);\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/align-elements/index.js\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const align_elements = ({\n  __init__: [ 'alignElements' ],\n  alignElements: [ 'type', AlignElements ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/align-elements/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/attach-support/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ attach_support)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Removal.js\nvar Removal = __webpack_require__(\"./node_modules/diagram-js/lib/util/Removal.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/AttachUtil.js\nvar AttachUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/AttachUtil.js\");\n// EXTERNAL MODULE: ./node_modules/inherits-browser/dist/index.es.js\nvar index_es = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/command/CommandInterceptor.js\nvar CommandInterceptor = __webpack_require__(\"./node_modules/diagram-js/lib/command/CommandInterceptor.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/attach-support/AttachSupport.js\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('didi').Injector} Injector\n *\n * @typedef {import('../../model/Types').Element} Element\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../rules/Rules').default} Rules\n * @typedef {import('../modeling/Modeling').default} Modeling\n */\n\nvar LOW_PRIORITY = 251,\n    HIGH_PRIORITY = 1401;\n\nvar MARKER_ATTACH = 'attach-ok';\n\n\n/**\n * Adds the notion of attached elements to the modeler.\n *\n * Optionally depends on `diagram-js/lib/features/move` to render\n * the attached elements during move preview.\n *\n * Optionally depends on `diagram-js/lib/features/label-support`\n * to render attached labels during move preview.\n *\n * @param {Injector} injector\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {Rules} rules\n * @param {Modeling} modeling\n */\nfunction AttachSupport(injector, eventBus, canvas, rules, modeling) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  var movePreview = injector.get('movePreview', false);\n\n\n  // remove all the attached elements from the shapes to be validated\n  // add all the attached shapes to the overall list of moved shapes\n  eventBus.on('shape.move.start', HIGH_PRIORITY, function(e) {\n\n    var context = e.context,\n        shapes = context.shapes,\n        validatedShapes = context.validatedShapes;\n\n    context.shapes = addAttached(shapes);\n\n    context.validatedShapes = removeAttached(validatedShapes);\n  });\n\n  // add attachers to the visual's group\n  movePreview && eventBus.on('shape.move.start', LOW_PRIORITY, function(e) {\n\n    var context = e.context,\n        shapes = context.shapes,\n        attachers = getAttachers(shapes);\n\n    (0,index_esm/* forEach */.Ed)(attachers, function(attacher) {\n      movePreview.makeDraggable(context, attacher, true);\n\n      (0,index_esm/* forEach */.Ed)(attacher.labels, function(label) {\n        movePreview.makeDraggable(context, label, true);\n      });\n    });\n  });\n\n  // add attach-ok marker to current host\n  movePreview && eventBus.on('shape.move.start', function(event) {\n    var context = event.context,\n        shapes = context.shapes;\n\n    if (shapes.length !== 1) {\n      return;\n    }\n\n    var shape = shapes[0];\n\n    var host = shape.host;\n\n    if (host) {\n      canvas.addMarker(host, MARKER_ATTACH);\n\n      eventBus.once([\n        'shape.move.out',\n        'shape.move.cleanup'\n      ], function() {\n        canvas.removeMarker(host, MARKER_ATTACH);\n      });\n    }\n  });\n\n  // add all attachers to move closure\n  this.preExecuted('elements.move', HIGH_PRIORITY, function(e) {\n    var context = e.context,\n        closure = context.closure,\n        shapes = context.shapes,\n        attachers = getAttachers(shapes);\n\n    (0,index_esm/* forEach */.Ed)(attachers, function(attacher) {\n      closure.add(attacher, closure.topLevel[attacher.host.id]);\n    });\n  });\n\n  // perform the attaching after shapes are done moving\n  this.postExecuted('elements.move', function(e) {\n\n    var context = e.context,\n        shapes = context.shapes,\n        newHost = context.newHost,\n        attachers;\n\n    // only single elements can be attached\n    // multiply elements can be detached\n    if (newHost && shapes.length !== 1) {\n      return;\n    }\n\n    if (newHost) {\n      attachers = shapes;\n    } else {\n\n      // find attachers moved without host\n      attachers = (0,index_esm/* filter */.hX)(shapes, function(shape) {\n        var host = shape.host;\n\n        return isAttacher(shape) && !includes(shapes, host);\n      });\n    }\n\n    (0,index_esm/* forEach */.Ed)(attachers, function(attacher) {\n      modeling.updateAttachment(attacher, newHost);\n    });\n  });\n\n  // ensure invalid attachment connections are removed\n  this.postExecuted('elements.move', function(e) {\n\n    var shapes = e.context.shapes;\n\n    (0,index_esm/* forEach */.Ed)(shapes, function(shape) {\n\n      (0,index_esm/* forEach */.Ed)(shape.attachers, function(attacher) {\n\n        // remove invalid outgoing connections\n        (0,index_esm/* forEach */.Ed)(attacher.outgoing.slice(), function(connection) {\n          var allowed = rules.allowed('connection.reconnect', {\n            connection: connection,\n            source: connection.source,\n            target: connection.target\n          });\n\n          if (!allowed) {\n            modeling.removeConnection(connection);\n          }\n        });\n\n        // remove invalid incoming connections\n        (0,index_esm/* forEach */.Ed)(attacher.incoming.slice(), function(connection) {\n          var allowed = rules.allowed('connection.reconnect', {\n            connection: connection,\n            source: connection.source,\n            target: connection.target\n          });\n\n          if (!allowed) {\n            modeling.removeConnection(connection);\n          }\n        });\n      });\n    });\n  });\n\n  this.postExecute('shape.create', function(e) {\n    var context = e.context,\n        shape = context.shape,\n        host = context.host;\n\n    if (host) {\n      modeling.updateAttachment(shape, host);\n    }\n  });\n\n  // update attachments if the host is replaced\n  this.postExecute('shape.replace', function(e) {\n\n    var context = e.context,\n        oldShape = context.oldShape,\n        newShape = context.newShape;\n\n    // move the attachers to the new host\n    (0,Removal/* saveClear */.r)(oldShape.attachers, function(attacher) {\n      var allowed = rules.allowed('elements.move', {\n        target: newShape,\n        shapes: [ attacher ]\n      });\n\n      if (allowed === 'attach') {\n        modeling.updateAttachment(attacher, newShape);\n      } else {\n        modeling.removeShape(attacher);\n      }\n    });\n\n    // move attachers if new host has different size\n    if (newShape.attachers.length) {\n\n      (0,index_esm/* forEach */.Ed)(newShape.attachers, function(attacher) {\n        var delta = (0,AttachUtil/* getNewAttachShapeDelta */.s)(attacher, oldShape, newShape);\n        modeling.moveShape(attacher, delta, attacher.parent);\n      });\n    }\n\n  });\n\n  // move shape on host resize\n  this.postExecute('shape.resize', function(event) {\n    var context = event.context,\n        shape = context.shape,\n        oldBounds = context.oldBounds,\n        newBounds = context.newBounds,\n        attachers = shape.attachers,\n        hints = context.hints || {};\n\n    if (hints.attachSupport === false) {\n      return;\n    }\n\n    (0,index_esm/* forEach */.Ed)(attachers, function(attacher) {\n      var delta = (0,AttachUtil/* getNewAttachShapeDelta */.s)(attacher, oldBounds, newBounds);\n\n      modeling.moveShape(attacher, delta, attacher.parent);\n\n      (0,index_esm/* forEach */.Ed)(attacher.labels, function(label) {\n        modeling.moveShape(label, delta, label.parent);\n      });\n    });\n  });\n\n  // remove attachments\n  this.preExecute('shape.delete', function(event) {\n\n    var shape = event.context.shape;\n\n    (0,Removal/* saveClear */.r)(shape.attachers, function(attacher) {\n      modeling.removeShape(attacher);\n    });\n\n    if (shape.host) {\n      modeling.updateAttachment(shape, null);\n    }\n  });\n}\n\n(0,index_es/* default */.Z)(AttachSupport, CommandInterceptor/* default */.Z);\n\nAttachSupport.$inject = [\n  'injector',\n  'eventBus',\n  'canvas',\n  'rules',\n  'modeling'\n];\n\n\n/**\n * Return attachers of the given shapes\n *\n * @param {Element[]} shapes\n * @return {Element[]}\n */\nfunction getAttachers(shapes) {\n  return (0,index_esm/* flatten */.xH)((0,index_esm/* map */.UI)(shapes, function(s) {\n    return s.attachers || [];\n  }));\n}\n\n/**\n * Return a combined list of elements and\n * attachers.\n *\n * @param {Element[]} elements\n * @return {Element[]} filtered\n */\nfunction addAttached(elements) {\n  var attachers = getAttachers(elements);\n\n  return (0,index_esm/* unionBy */.qZ)('id', elements, attachers);\n}\n\n/**\n * Return a filtered list of elements that do not\n * contain attached elements with hosts being part\n * of the selection.\n *\n * @param {Element[]} elements\n *\n * @return {Element[]} filtered\n */\nfunction removeAttached(elements) {\n\n  var ids = (0,index_esm/* groupBy */.vM)(elements, 'id');\n\n  return (0,index_esm/* filter */.hX)(elements, function(element) {\n    while (element) {\n\n      // host in selection\n      if (element.host && ids[element.host.id]) {\n        return false;\n      }\n\n      element = element.parent;\n    }\n\n    return true;\n  });\n}\n\nfunction isAttacher(shape) {\n  return !!shape.host;\n}\n\nfunction includes(array, item) {\n  return array.indexOf(item) !== -1;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/attach-support/index.js\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const attach_support = ({\n  __depends__: [\n    rules/* default */.Z\n  ],\n  __init__: [ 'attachSupport' ],\n  attachSupport: [ 'type', AttachSupport ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/attach-support/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/auto-place/AutoPlaceUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"KW\": () => (/* binding */ getConnectedDistance),\n/* harmony export */   \"QA\": () => (/* binding */ findFreePosition),\n/* harmony export */   \"_Q\": () => (/* binding */ DEFAULT_DISTANCE),\n/* harmony export */   \"n5\": () => (/* binding */ generateGetNextPosition)\n/* harmony export */ });\n/* unused harmony export getConnectedAtPosition */\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var _layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n}\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n}\n\n\n\n\n/**\n * @typedef {import('../../model/Types').Connection} Connection\n * @typedef {import('../../model/Types').Element} Element\n * @typedef {import('../../model/Types').Shape} Shape\n *\n * @typedef {import('../../util/Types').Point} Point\n */\n\n// padding to detect element placement\nvar PLACEMENT_DETECTION_PAD = 10;\n\nvar DEFAULT_DISTANCE = 50;\n\nvar DEFAULT_MAX_DISTANCE = 250;\n\n\n/**\n * Get free position starting from given position.\n *\n * @param {Shape} source\n * @param {Shape} element\n * @param {Point} position\n * @param {(element: Element, position: Point, connectedAtPosition: Element) => Element} getNextPosition\n *\n * @return {Point}\n */\nfunction findFreePosition(source, element, position, getNextPosition) {\n  var connectedAtPosition;\n\n  while ((connectedAtPosition = getConnectedAtPosition(source, position, element))) {\n    position = getNextPosition(element, position, connectedAtPosition);\n  }\n\n  return position;\n}\n\n/**\n * Returns function that returns next position.\n *\n * @param {Object} nextPositionDirection\n * @param {Object} [nextPositionDirection.x]\n * @param {Object} [nextPositionDirection.y]\n *\n * @return {(element: Element, previousPosition: Point, connectedAtPosition: Element) => Point}\n */\nfunction generateGetNextPosition(nextPositionDirection) {\n  return function(element, previousPosition, connectedAtPosition) {\n    var nextPosition = {\n      x: previousPosition.x,\n      y: previousPosition.y\n    };\n\n    [ 'x', 'y' ].forEach(function(axis) {\n\n      var nextPositionDirectionForAxis = nextPositionDirection[ axis ];\n\n      if (!nextPositionDirectionForAxis) {\n        return;\n      }\n\n      var dimension = axis === 'x' ? 'width' : 'height';\n\n      var margin = nextPositionDirectionForAxis.margin,\n          minDistance = nextPositionDirectionForAxis.minDistance;\n\n      if (margin < 0) {\n        nextPosition[ axis ] = Math.min(\n          connectedAtPosition[ axis ] + margin - element[ dimension ] / 2,\n          previousPosition[ axis ] - minDistance + margin\n        );\n      } else {\n        nextPosition[ axis ] = Math.max(\n          connectedAtPosition[ axis ] + connectedAtPosition[ dimension ] + margin + element[ dimension ] / 2,\n          previousPosition[ axis ] + minDistance + margin\n        );\n      }\n    });\n\n    return nextPosition;\n  };\n}\n\n/**\n * Return target at given position, if defined.\n *\n * This takes connected elements from host and attachers\n * into account, too.\n */\nfunction getConnectedAtPosition(source, position, element) {\n\n  var bounds = {\n    x: position.x - (element.width / 2),\n    y: position.y - (element.height / 2),\n    width: element.width,\n    height: element.height\n  };\n\n  var closure = getAutoPlaceClosure(source, element);\n\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .find */ .sE)(closure, function(target) {\n\n    if (target === element) {\n      return false;\n    }\n\n    var orientation = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .getOrientation */ .T8)(target, bounds, PLACEMENT_DETECTION_PAD);\n\n    return orientation === 'intersect';\n  });\n}\n\n/**\n* Compute optimal distance between source and target based on existing connections to and from source.\n* Assumes left-to-right and top-to-down modeling.\n*\n* @param {Shape} source\n* @param {Object} [hints]\n* @param {number} [hints.defaultDistance]\n* @param {string} [hints.direction]\n* @param {(connection: Connection) => boolean} [hints.filter]\n* @param {(connection: Connection) => number} [hints.getWeight]\n* @param {number} [hints.maxDistance]\n* @param {string} [hints.reference]\n*\n* @return {number}\n*/\nfunction getConnectedDistance(source, hints) {\n  if (!hints) {\n    hints = {};\n  }\n\n  // targets > sources by default\n  function getDefaultWeight(connection) {\n    return connection.source === source ? 1 : -1;\n  }\n\n  var defaultDistance = hints.defaultDistance || DEFAULT_DISTANCE,\n      direction = hints.direction || 'e',\n      filter = hints.filter,\n      getWeight = hints.getWeight || getDefaultWeight,\n      maxDistance = hints.maxDistance || DEFAULT_MAX_DISTANCE,\n      reference = hints.reference || 'start';\n\n  if (!filter) {\n    filter = noneFilter;\n  }\n\n  function getDistance(a, b) {\n    if (direction === 'n') {\n      if (reference === 'start') {\n        return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(a).top - (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(b).bottom;\n      } else if (reference === 'center') {\n        return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(a).top - (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .getMid */ .wS)(b).y;\n      } else {\n        return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(a).top - (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(b).top;\n      }\n    } else if (direction === 'w') {\n      if (reference === 'start') {\n        return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(a).left - (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(b).right;\n      } else if (reference === 'center') {\n        return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(a).left - (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .getMid */ .wS)(b).x;\n      } else {\n        return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(a).left - (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(b).left;\n      }\n    } else if (direction === 's') {\n      if (reference === 'start') {\n        return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(b).top - (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(a).bottom;\n      } else if (reference === 'center') {\n        return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .getMid */ .wS)(b).y - (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(a).bottom;\n      } else {\n        return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(b).bottom - (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(a).bottom;\n      }\n    } else {\n      if (reference === 'start') {\n        return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(b).left - (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(a).right;\n      } else if (reference === 'center') {\n        return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .getMid */ .wS)(b).x - (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(a).right;\n      } else {\n        return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(b).right - (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(a).right;\n      }\n    }\n  }\n\n  var sourcesDistances = source.incoming\n    .filter(filter)\n    .map(function(connection) {\n      var weight = getWeight(connection);\n\n      var distance = weight < 0\n        ? getDistance(connection.source, source)\n        : getDistance(source, connection.source);\n\n      return {\n        id: connection.source.id,\n        distance: distance,\n        weight: weight\n      };\n    });\n\n  var targetsDistances = source.outgoing\n    .filter(filter)\n    .map(function(connection) {\n      var weight = getWeight(connection);\n\n      var distance = weight > 0\n        ? getDistance(source, connection.target)\n        : getDistance(connection.target, source);\n\n      return {\n        id: connection.target.id,\n        distance: distance,\n        weight: weight\n      };\n    });\n\n  var distances = sourcesDistances.concat(targetsDistances).reduce(function(accumulator, currentValue) {\n    accumulator[ currentValue.id + '__weight_' + currentValue.weight ] = currentValue;\n\n    return accumulator;\n  }, {});\n\n  var distancesGrouped = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .reduce */ .u4)(distances, function(accumulator, currentValue) {\n    var distance = currentValue.distance,\n        weight = currentValue.weight;\n\n    if (distance < 0 || distance > maxDistance) {\n      return accumulator;\n    }\n\n    if (!accumulator[ String(distance) ]) {\n      accumulator[ String(distance) ] = 0;\n    }\n\n    accumulator[ String(distance) ] += 1 * weight;\n\n    if (!accumulator.distance || accumulator[ accumulator.distance ] < accumulator[ String(distance) ]) {\n      accumulator.distance = distance;\n    }\n\n    return accumulator;\n  }, {});\n\n  return distancesGrouped.distance || defaultDistance;\n}\n\n/**\n * Returns all connected elements around the given source.\n *\n * This includes:\n *\n *   - connected elements\n *   - host connected elements\n *   - attachers connected elements\n *\n * @param {Shape} source\n *\n * @return {Shape[]}\n */\nfunction getAutoPlaceClosure(source) {\n\n  var allConnected = getConnected(source);\n\n  if (source.host) {\n    allConnected = allConnected.concat(getConnected(source.host));\n  }\n\n  if (source.attachers) {\n    allConnected = allConnected.concat(source.attachers.reduce(function(shapes, attacher) {\n      return shapes.concat(getConnected(attacher));\n    }, []));\n  }\n\n  return allConnected;\n}\n\nfunction getConnected(element) {\n  return getTargets(element).concat(getSources(element));\n}\n\nfunction getSources(shape) {\n  return shape.incoming.map(function(connection) {\n    return connection.source;\n  });\n}\n\nfunction getTargets(shape) {\n  return shape.outgoing.map(function(connection) {\n    return connection.target;\n  });\n}\n\nfunction noneFilter() {\n  return true;\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/auto-place/AutoPlaceUtil.js?")},"./node_modules/diagram-js/lib/features/auto-place/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ auto_place)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/auto-place/AutoPlaceUtil.js\nvar AutoPlaceUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/auto-place/AutoPlaceUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/auto-place/AutoPlace.js\n\n\n\n\n/**\n * @typedef {import('../../core/Types').ShapeLike} Shape\n *\n * @typedef {import('../../util/Types').Point} Point\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../modeling/Modeling').default} Modeling\n */\n\nvar LOW_PRIORITY = 100;\n\n\n/**\n * A service that places elements connected to existing ones\n * to an appropriate position in an _automated_ fashion.\n *\n * @param {EventBus} eventBus\n * @param {Modeling} modeling\n * @param {Canvas} canvas\n */\nfunction AutoPlace(eventBus, modeling, canvas) {\n\n  eventBus.on('autoPlace', LOW_PRIORITY, function(context) {\n    var shape = context.shape,\n        source = context.source;\n\n    return getNewShapePosition(source, shape);\n  });\n\n  eventBus.on('autoPlace.end', function(event) {\n    canvas.scrollToElement(event.shape);\n  });\n\n  /**\n   * Append shape to source at appropriate position.\n   *\n   * @param {Shape} source\n   * @param {Shape} shape\n   *\n   * @return {Shape} appended shape\n   */\n  this.append = function(source, shape, hints) {\n\n    eventBus.fire('autoPlace.start', {\n      source: source,\n      shape: shape\n    });\n\n    // allow others to provide the position\n    var position = eventBus.fire('autoPlace', {\n      source: source,\n      shape: shape\n    });\n\n    var newShape = modeling.appendShape(source, shape, position, source.parent, hints);\n\n    eventBus.fire('autoPlace.end', {\n      source: source,\n      shape: newShape\n    });\n\n    return newShape;\n  };\n\n}\n\nAutoPlace.$inject = [\n  'eventBus',\n  'modeling',\n  'canvas'\n];\n\n// helpers //////////\n\n/**\n * Find the new position for the target element to\n * connect to source.\n *\n * @param {Shape} source\n * @param {Shape} element\n * @param {Object} [hints]\n * @param {Object} [hints.defaultDistance]\n *\n * @return {Point}\n */\nfunction getNewShapePosition(source, element, hints) {\n  if (!hints) {\n    hints = {};\n  }\n\n  var distance = hints.defaultDistance || AutoPlaceUtil/* DEFAULT_DISTANCE */._Q;\n\n  var sourceMid = (0,LayoutUtil/* getMid */.wS)(source),\n      sourceTrbl = (0,LayoutUtil/* asTRBL */.JA)(source);\n\n  // simply put element right next to source\n  return {\n    x: sourceTrbl.right + distance + element.width / 2,\n    y: sourceMid.y\n  };\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/auto-place/AutoPlaceSelectionBehavior.js\n/**\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../selection/Selection').default} Selection\n */\n\n/**\n * Select element after auto placement.\n *\n * @param {EventBus} eventBus\n * @param {Selection} selection\n */\nfunction AutoPlaceSelectionBehavior(eventBus, selection) {\n\n  eventBus.on('autoPlace.end', 500, function(e) {\n    selection.select(e.shape);\n  });\n\n}\n\nAutoPlaceSelectionBehavior.$inject = [\n  'eventBus',\n  'selection'\n];\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/auto-place/index.js\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const auto_place = ({\n  __init__: [ 'autoPlaceSelectionBehavior' ],\n  autoPlace: [ 'type', AutoPlace ],\n  autoPlaceSelectionBehavior: [ 'type', AutoPlaceSelectionBehavior ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/auto-place/index.js_+_2_modules?")},"./node_modules/diagram-js/lib/features/auto-resize/AutoResize.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ AutoResize)\n/* harmony export */ });\n/* harmony import */ var inherits_browser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n/* harmony import */ var _util_Elements__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n/* harmony import */ var _layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n/* harmony import */ var _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/lib/command/CommandInterceptor.js\");\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../model/Types').Element} Element\n * @typedef {import('../../model/Types').Shape} Shape\n *\n * @typedef {import('../../util/Types').Direction} Direction\n * @typedef {import('../../util/Types').Rect} Rect\n * @typedef {import('../../util/Types').RectTRBL} RectTRBL\n *\n * @typedef {import('../../core/ElementRegistry').default} ElementRegistry\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../modeling/Modeling').default} Modeling\n * @typedef {import('../rules/Rules').default} Rules\n */\n\n/**\n * An auto resize component that takes care of expanding a parent element\n * if child elements are created or moved close the parents edge.\n *\n * @param {EventBus} eventBus\n * @param {ElementRegistry} elementRegistry\n * @param {Modeling} modeling\n * @param {Rules} rules\n */\nfunction AutoResize(eventBus, elementRegistry, modeling, rules) {\n\n  _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_0__/* [\"default\"].call */ .Z.call(this, eventBus);\n\n  this._elementRegistry = elementRegistry;\n  this._modeling = modeling;\n  this._rules = rules;\n\n  var self = this;\n\n  this.postExecuted([ 'shape.create' ], function(event) {\n    var context = event.context,\n        hints = context.hints || {},\n        shape = context.shape,\n        parent = context.parent || context.newParent;\n\n    if (hints.autoResize === false) {\n      return;\n    }\n\n    self._expand([ shape ], parent);\n  });\n\n  this.postExecuted([ 'elements.move' ], function(event) {\n    var context = event.context,\n        elements = (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .flatten */ .xH)((0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .values */ .VO)(context.closure.topLevel)),\n        hints = context.hints;\n\n    var autoResize = hints ? hints.autoResize : true;\n\n    if (autoResize === false) {\n      return;\n    }\n\n    var expandings = (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .groupBy */ .vM)(elements, function(element) {\n      return element.parent.id;\n    });\n\n    (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .forEach */ .Ed)(expandings, function(elements, parentId) {\n\n      // optionally filter elements to be considered when resizing\n      if ((0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .kJ)(autoResize)) {\n        elements = elements.filter(function(element) {\n          return (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .find */ .sE)(autoResize, (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .matchPattern */ .KQ)({ id: element.id }));\n        });\n      }\n\n      self._expand(elements, parentId);\n    });\n  });\n\n  this.postExecuted([ 'shape.toggleCollapse' ], function(event) {\n    var context = event.context,\n        hints = context.hints,\n        shape = context.shape;\n\n    if (hints && hints.autoResize === false) {\n      return;\n    }\n\n    if (shape.collapsed) {\n      return;\n    }\n\n    self._expand(shape.children || [], shape);\n  });\n\n  this.postExecuted([ 'shape.resize' ], function(event) {\n    var context = event.context,\n        hints = context.hints,\n        shape = context.shape,\n        parent = shape.parent;\n\n    if (hints && hints.autoResize === false) {\n      return;\n    }\n\n    if (parent) {\n      self._expand([ shape ], parent);\n    }\n  });\n\n}\n\nAutoResize.$inject = [\n  'eventBus',\n  'elementRegistry',\n  'modeling',\n  'rules'\n];\n\n(0,inherits_browser__WEBPACK_IMPORTED_MODULE_2__/* [\"default\"] */ .Z)(AutoResize, _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_0__/* [\"default\"] */ .Z);\n\n\n/**\n * Calculate the new bounds of the target shape, given\n * a number of elements have been moved or added into the parent.\n *\n * This method considers the current size, the added elements as well as\n * the provided padding for the new bounds.\n *\n * @param {Shape[]} elements\n * @param {Shape} target\n */\nAutoResize.prototype._getOptimalBounds = function(elements, target) {\n\n  var offset = this.getOffset(target),\n      padding = this.getPadding(target);\n\n  var elementsTrbl = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_3__/* .asTRBL */ .JA)((0,_util_Elements__WEBPACK_IMPORTED_MODULE_4__/* .getBBox */ .jY)(elements)),\n      targetTrbl = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_3__/* .asTRBL */ .JA)(target);\n\n  var newTrbl = {};\n\n  if (elementsTrbl.top - targetTrbl.top < padding.top) {\n    newTrbl.top = elementsTrbl.top - offset.top;\n  }\n\n  if (elementsTrbl.left - targetTrbl.left < padding.left) {\n    newTrbl.left = elementsTrbl.left - offset.left;\n  }\n\n  if (targetTrbl.right - elementsTrbl.right < padding.right) {\n    newTrbl.right = elementsTrbl.right + offset.right;\n  }\n\n  if (targetTrbl.bottom - elementsTrbl.bottom < padding.bottom) {\n    newTrbl.bottom = elementsTrbl.bottom + offset.bottom;\n  }\n\n  return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_3__/* .asBounds */ .z_)((0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .assign */ .f0)({}, targetTrbl, newTrbl));\n};\n\n\n/**\n * Expand the target shape respecting rules, offset and padding\n *\n * @param {Shape[]} elements\n * @param {Shape|string} target The target or its ID.\n */\nAutoResize.prototype._expand = function(elements, target) {\n\n  if (typeof target === 'string') {\n    target = this._elementRegistry.get(target);\n  }\n\n  var allowed = this._rules.allowed('element.autoResize', {\n    elements: elements,\n    target: target\n  });\n\n  if (!allowed) {\n    return;\n  }\n\n  // calculate the new bounds\n  var newBounds = this._getOptimalBounds(elements, target);\n\n  if (!boundsChanged(newBounds, target)) {\n    return;\n  }\n\n  var resizeDirections = getResizeDirections((0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .pick */ .ei)(target, [ 'x', 'y', 'width', 'height' ]), newBounds);\n\n  // resize the parent shape\n  this.resize(target, newBounds, {\n    autoResize: resizeDirections\n  });\n\n  var parent = target.parent;\n\n  // recursively expand parent elements\n  if (parent) {\n    this._expand([ target ], parent);\n  }\n};\n\n\n/**\n * Get the amount to expand the given shape in each direction.\n *\n * @param {Shape} shape\n *\n * @return {RectTRBL}\n */\nAutoResize.prototype.getOffset = function(shape) {\n  return { top: 60, bottom: 60, left: 100, right: 100 };\n};\n\n\n/**\n * Get the activation threshold for each side for which\n * resize triggers.\n *\n * @param {Shape} shape\n *\n * @return {RectTRBL}\n */\nAutoResize.prototype.getPadding = function(shape) {\n  return { top: 2, bottom: 2, left: 15, right: 15 };\n};\n\n\n/**\n * Perform the actual resize operation.\n *\n * @param {Shape} shape\n * @param {Rect} newBounds\n * @param {Object} [hints]\n * @param {string} [hints.autoResize]\n */\nAutoResize.prototype.resize = function(shape, newBounds, hints) {\n  this._modeling.resizeShape(shape, newBounds, null, hints);\n};\n\n\nfunction boundsChanged(newBounds, oldBounds) {\n  return (\n    newBounds.x !== oldBounds.x ||\n    newBounds.y !== oldBounds.y ||\n    newBounds.width !== oldBounds.width ||\n    newBounds.height !== oldBounds.height\n  );\n}\n\n/**\n * Get directions of resize as {n|w|s|e} e.g. \"nw\".\n *\n * @param {Rect} oldBounds\n * @param {Rect} newBounds\n *\n * @return {Direction} Resize directions as {n|w|s|e}.\n */\nfunction getResizeDirections(oldBounds, newBounds) {\n  var directions = '';\n\n  oldBounds = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_3__/* .asTRBL */ .JA)(oldBounds);\n  newBounds = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_3__/* .asTRBL */ .JA)(newBounds);\n\n  if (oldBounds.top > newBounds.top) {\n    directions = directions.concat('n');\n  }\n\n  if (oldBounds.right < newBounds.right) {\n    directions = directions.concat('w');\n  }\n\n  if (oldBounds.bottom < newBounds.bottom) {\n    directions = directions.concat('s');\n  }\n\n  if (oldBounds.left > newBounds.left) {\n    directions = directions.concat('e');\n  }\n\n  return directions;\n}\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/auto-resize/AutoResize.js?")},"./node_modules/diagram-js/lib/features/auto-resize/AutoResizeProvider.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ AutoResizeProvider)\n/* harmony export */ });\n/* harmony import */ var _rules_RuleProvider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/diagram-js/lib/features/rules/RuleProvider.js");\n/* harmony import */ var inherits_browser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/inherits-browser/dist/index.es.js");\n\n\n\n\n/**\n * @typedef {import(\'../../model/Types\').Shape} Shape\n *\n * @typedef {import(\'../../core/EventBus\').default} EventBus\n */\n\n/**\n * This is a base rule provider for the element.autoResize rule.\n *\n * @param {EventBus} eventBus\n */\nfunction AutoResizeProvider(eventBus) {\n\n  _rules_RuleProvider__WEBPACK_IMPORTED_MODULE_0__/* ["default"].call */ .Z.call(this, eventBus);\n\n  var self = this;\n\n  this.addRule(\'element.autoResize\', function(context) {\n    return self.canResize(context.elements, context.target);\n  });\n}\n\nAutoResizeProvider.$inject = [ \'eventBus\' ];\n\n(0,inherits_browser__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(AutoResizeProvider, _rules_RuleProvider__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z);\n\n/**\n * Needs to be implemented by sub classes to allow actual auto resize\n *\n * @param {Shape[]} elements\n * @param {Shape} target\n *\n * @return {boolean}\n */\nAutoResizeProvider.prototype.canResize = function(elements, target) {\n  return false;\n};\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/auto-resize/AutoResizeProvider.js?')},"./node_modules/diagram-js/lib/features/auto-scroll/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ auto_scroll)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/dragging/index.js + 3 modules\nvar dragging = __webpack_require__(\"./node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Event.js\nvar Event = __webpack_require__(\"./node_modules/diagram-js/lib/util/Event.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/auto-scroll/AutoScroll.js\n\n\n\n\n/**\n * @typedef {import('../../util/Types').Point} Point\n *\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../../core/Canvas').default} Canvas\n */\n\n/**\n * Initiates canvas scrolling if current cursor point is close to a border.\n * Cancelled when current point moves back inside the scrolling borders\n * or cancelled manually.\n *\n * Default options :\n *   scrollThresholdIn: [ 20, 20, 20, 20 ],\n *   scrollThresholdOut: [ 0, 0, 0, 0 ],\n *   scrollRepeatTimeout: 15,\n *   scrollStep: 10\n *\n * Threshold order:\n *   [ left, top, right, bottom ]\n *\n * @param {Object} config\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n */\nfunction AutoScroll(config, eventBus, canvas) {\n\n  this._canvas = canvas;\n\n  this._opts = (0,index_esm/* assign */.f0)({\n    scrollThresholdIn: [ 20, 20, 20, 20 ],\n    scrollThresholdOut: [ 0, 0, 0, 0 ],\n    scrollRepeatTimeout: 15,\n    scrollStep: 10\n  }, config);\n\n  var self = this;\n\n  eventBus.on('drag.move', function(e) {\n    var point = self._toBorderPoint(e);\n\n    self.startScroll(point);\n  });\n\n  eventBus.on([ 'drag.cleanup' ], function() {\n    self.stopScroll();\n  });\n}\n\nAutoScroll.$inject = [\n  'config.autoScroll',\n  'eventBus',\n  'canvas'\n];\n\n\n/**\n * Starts scrolling loop.\n * Point is given in global scale in canvas container box plane.\n *\n * @param {Point} point\n */\nAutoScroll.prototype.startScroll = function(point) {\n\n  var canvas = this._canvas;\n  var opts = this._opts;\n  var self = this;\n\n  var clientRect = canvas.getContainer().getBoundingClientRect();\n\n  var diff = [\n    point.x,\n    point.y,\n    clientRect.width - point.x,\n    clientRect.height - point.y\n  ];\n\n  this.stopScroll();\n\n  var dx = 0,\n      dy = 0;\n\n  for (var i = 0; i < 4; i++) {\n    if (between(diff[i], opts.scrollThresholdOut[i], opts.scrollThresholdIn[i])) {\n      if (i === 0) {\n        dx = opts.scrollStep;\n      } else if (i == 1) {\n        dy = opts.scrollStep;\n      } else if (i == 2) {\n        dx = -opts.scrollStep;\n      } else if (i == 3) {\n        dy = -opts.scrollStep;\n      }\n    }\n  }\n\n  if (dx !== 0 || dy !== 0) {\n    canvas.scroll({ dx: dx, dy: dy });\n\n    this._scrolling = setTimeout(function() {\n      self.startScroll(point);\n    }, opts.scrollRepeatTimeout);\n  }\n};\n\nfunction between(val, start, end) {\n  if (start < val && val < end) {\n    return true;\n  }\n\n  return false;\n}\n\n\n/**\n * Stops scrolling loop.\n */\nAutoScroll.prototype.stopScroll = function() {\n  clearTimeout(this._scrolling);\n};\n\n\n/**\n * Overrides defaults options.\n *\n * @param {Object} options\n */\nAutoScroll.prototype.setOptions = function(options) {\n  this._opts = (0,index_esm/* assign */.f0)({}, this._opts, options);\n};\n\n\n/**\n * Converts event to a point in canvas container plane in global scale.\n *\n * @param {Event} event\n * @return {Point}\n */\nAutoScroll.prototype._toBorderPoint = function(event) {\n  var clientRect = this._canvas._container.getBoundingClientRect();\n\n  var globalPosition = (0,Event/* toPoint */.jt)(event.originalEvent);\n\n  return {\n    x: globalPosition.x - clientRect.left,\n    y: globalPosition.y - clientRect.top\n  };\n};\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/auto-scroll/index.js\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const auto_scroll = ({\n  __depends__: [\n    dragging/* default */.Z,\n  ],\n  __init__: [ 'autoScroll' ],\n  autoScroll: [ 'type', AutoScroll ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/auto-scroll/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/bendpoints/GeometricUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "FY": () => (/* binding */ perpendicularFoot),\n/* harmony export */   "IA": () => (/* binding */ getDistancePointPoint),\n/* harmony export */   "ON": () => (/* binding */ getDistancePointLine),\n/* harmony export */   "_O": () => (/* binding */ getAngle),\n/* harmony export */   "cG": () => (/* binding */ rotateVector)\n/* harmony export */ });\n/* unused harmony export vectorLength */\n/**\n * @typedef {import(\'../../util/Types\').Point} Point\n * @typedef {import(\'../../util/Types\').Vector} Vector\n */\n\n/**\n * Returns the length of a vector.\n *\n * @param {Vector} vector\n *\n * @return {number}\n */\nfunction vectorLength(vector) {\n  return Math.sqrt(Math.pow(vector.x, 2) + Math.pow(vector.y, 2));\n}\n\n\n/**\n * Calculates the angle between a line a the Y axis.\n *\n * @param {Point[]} line\n *\n * @return {number}\n */\nfunction getAngle(line) {\n\n  // return value is between 0, 180 and -180, -0\n  // @janstuemmel: maybe replace return a/b with b/a\n  return Math.atan((line[1].y - line[0].y) / (line[1].x - line[0].x));\n}\n\n\n/**\n * Rotates a vector by a given angle.\n *\n * @param {Vector} vector\n * @param {number} angle The angle in radians.\n *\n * @return {Vector}\n */\nfunction rotateVector(vector, angle) {\n  return (!angle) ? vector : {\n    x: Math.cos(angle) * vector.x - Math.sin(angle) * vector.y,\n    y: Math.sin(angle) * vector.x + Math.cos(angle) * vector.y\n  };\n}\n\n\n/**\n * Solves a 2D equation system\n * a + r*b = c, where a,b,c are 2D vectors\n *\n * @param {Vector} a\n * @param {Vector} b\n * @param {Vector} c\n *\n * @return {number}\n */\nfunction solveLambaSystem(a, b, c) {\n\n  // the 2d system\n  var system = [\n    { n: a[0] - c[0], lambda: b[0] },\n    { n: a[1] - c[1], lambda: b[1] }\n  ];\n\n  // solve\n  var n = system[0].n * b[0] + system[1].n * b[1],\n      l = system[0].lambda * b[0] + system[1].lambda * b[1];\n\n  return -n / l;\n}\n\n\n/**\n * Calculates the position of the perpendicular foot.\n *\n * @param {Point} point\n * @param {Point[]} line\n *\n * @return {Point}\n */\nfunction perpendicularFoot(point, line) {\n\n  var a = line[0], b = line[1];\n\n  // relative position of b from a\n  var bd = { x: b.x - a.x, y: b.y - a.y };\n\n  // solve equation system to the parametrized vectors param real value\n  var r = solveLambaSystem([ a.x, a.y ], [ bd.x, bd.y ], [ point.x, point.y ]);\n\n  return { x: a.x + r * bd.x, y: a.y + r * bd.y };\n}\n\n\n/**\n * Calculates the distance between a point and a line.\n *\n * @param {Point} point\n * @param {Point[]} line\n *\n * @return {number}\n */\nfunction getDistancePointLine(point, line) {\n\n  var pfPoint = perpendicularFoot(point, line);\n\n  // distance vector\n  var connectionVector = {\n    x: pfPoint.x - point.x,\n    y: pfPoint.y - point.y\n  };\n\n  return vectorLength(connectionVector);\n}\n\n\n/**\n * Calculates the distance between two points.\n *\n * @param {Point} point1\n * @param {Point} point2\n *\n * @return {number}\n */\nfunction getDistancePointPoint(point1, point2) {\n\n  return vectorLength({\n    x: point1.x - point2.x,\n    y: point1.y - point2.y\n  });\n}\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/bendpoints/GeometricUtil.js?')},"./node_modules/diagram-js/lib/features/bendpoints/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ bendpoints)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/dragging/index.js + 3 modules\nvar dragging = __webpack_require__(\"./node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Event.js\nvar Event = __webpack_require__(\"./node_modules/diagram-js/lib/util/Event.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Geometry.js\nvar Geometry = __webpack_require__(\"./node_modules/diagram-js/lib/util/Geometry.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar tiny_svg_dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/SvgTransformUtil.js\nvar SvgTransformUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/SvgTransformUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/LineIntersection.js\nvar LineIntersection = __webpack_require__(\"./node_modules/diagram-js/lib/util/LineIntersection.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/bendpoints/GeometricUtil.js\nvar GeometricUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/bendpoints/GeometricUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/bendpoints/BendpointUtil.js\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Types').ConnectionLike} Connection\n *\n * @typedef {import('../../util/Types').Point} Point\n */\n\nvar BENDPOINT_CLS = 'djs-bendpoint';\nvar SEGMENT_DRAGGER_CLS = 'djs-segment-dragger';\n\nfunction toCanvasCoordinates(canvas, event) {\n\n  var position = (0,Event/* toPoint */.jt)(event),\n      clientRect = canvas._container.getBoundingClientRect(),\n      offset;\n\n  // canvas relative position\n\n  offset = {\n    x: clientRect.left,\n    y: clientRect.top\n  };\n\n  // update actual event payload with canvas relative measures\n\n  var viewbox = canvas.viewbox();\n\n  return {\n    x: viewbox.x + (position.x - offset.x) / viewbox.scale,\n    y: viewbox.y + (position.y - offset.y) / viewbox.scale\n  };\n}\n\nfunction getConnectionIntersection(canvas, waypoints, event) {\n  var localPosition = toCanvasCoordinates(canvas, event),\n      intersection = (0,LineIntersection/* getApproxIntersection */.t)(waypoints, localPosition);\n\n  return intersection;\n}\n\nfunction addBendpoint(parentGfx, cls) {\n  var groupGfx = (0,tiny_svg_dist_index_esm/* create */.Ue)('g');\n  (0,tiny_svg_dist_index_esm/* classes */.Sh)(groupGfx).add(BENDPOINT_CLS);\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(parentGfx, groupGfx);\n\n  var visual = (0,tiny_svg_dist_index_esm/* create */.Ue)('circle');\n  (0,tiny_svg_dist_index_esm/* attr */.Lj)(visual, {\n    cx: 0,\n    cy: 0,\n    r: 4\n  });\n  (0,tiny_svg_dist_index_esm/* classes */.Sh)(visual).add('djs-visual');\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(groupGfx, visual);\n\n  var hit = (0,tiny_svg_dist_index_esm/* create */.Ue)('circle');\n  (0,tiny_svg_dist_index_esm/* attr */.Lj)(hit, {\n    cx: 0,\n    cy: 0,\n    r: 10\n  });\n  (0,tiny_svg_dist_index_esm/* classes */.Sh)(hit).add('djs-hit');\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(groupGfx, hit);\n\n  if (cls) {\n    (0,tiny_svg_dist_index_esm/* classes */.Sh)(groupGfx).add(cls);\n  }\n\n  return groupGfx;\n}\n\nfunction createParallelDragger(parentGfx, segmentStart, segmentEnd, alignment) {\n  var draggerGfx = (0,tiny_svg_dist_index_esm/* create */.Ue)('g');\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(parentGfx, draggerGfx);\n\n  var width = 18,\n      height = 6,\n      padding = 11,\n      hitWidth = calculateHitWidth(segmentStart, segmentEnd, alignment),\n      hitHeight = height + padding;\n\n  var visual = (0,tiny_svg_dist_index_esm/* create */.Ue)('rect');\n  (0,tiny_svg_dist_index_esm/* attr */.Lj)(visual, {\n    x: -width / 2,\n    y: -height / 2,\n    width: width,\n    height: height\n  });\n  (0,tiny_svg_dist_index_esm/* classes */.Sh)(visual).add('djs-visual');\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(draggerGfx, visual);\n\n  var hit = (0,tiny_svg_dist_index_esm/* create */.Ue)('rect');\n  (0,tiny_svg_dist_index_esm/* attr */.Lj)(hit, {\n    x: -hitWidth / 2,\n    y: -hitHeight / 2,\n    width: hitWidth,\n    height: hitHeight\n  });\n  (0,tiny_svg_dist_index_esm/* classes */.Sh)(hit).add('djs-hit');\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(draggerGfx, hit);\n\n  (0,SvgTransformUtil/* rotate */.U1)(draggerGfx, alignment === 'v' ? 90 : 0, 0, 0);\n\n  return draggerGfx;\n}\n\n\nfunction addSegmentDragger(parentGfx, segmentStart, segmentEnd) {\n\n  var groupGfx = (0,tiny_svg_dist_index_esm/* create */.Ue)('g'),\n      mid = (0,Geometry/* getMidPoint */.SO)(segmentStart, segmentEnd),\n      alignment = (0,Geometry/* pointsAligned */.Or)(segmentStart, segmentEnd);\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(parentGfx, groupGfx);\n\n  createParallelDragger(groupGfx, segmentStart, segmentEnd, alignment);\n\n  (0,tiny_svg_dist_index_esm/* classes */.Sh)(groupGfx).add(SEGMENT_DRAGGER_CLS);\n  (0,tiny_svg_dist_index_esm/* classes */.Sh)(groupGfx).add(alignment === 'h' ? 'horizontal' : 'vertical');\n\n  (0,SvgTransformUtil/* translate */.Iu)(groupGfx, mid.x, mid.y);\n\n  return groupGfx;\n}\n\n/**\n * Calculates region for segment move which is 2/3 of the full segment length\n * @param {number} segmentLength\n *\n * @return {number}\n */\nfunction calculateSegmentMoveRegion(segmentLength) {\n  return Math.abs(Math.round(segmentLength * 2 / 3));\n}\n\n/**\n * Returns the point with the closest distance that is on the connection path.\n *\n * @param {Point} position\n * @param {Connection} connection\n * @return {Point}\n */\nfunction getClosestPointOnConnection(position, connection) {\n  var segment = getClosestSegment(position, connection);\n\n  return (0,GeometricUtil/* perpendicularFoot */.FY)(position, segment);\n}\n\n\n// helper //////////\n\nfunction calculateHitWidth(segmentStart, segmentEnd, alignment) {\n  var segmentLengthXAxis = segmentEnd.x - segmentStart.x,\n      segmentLengthYAxis = segmentEnd.y - segmentStart.y;\n\n  return alignment === 'h' ?\n    calculateSegmentMoveRegion(segmentLengthXAxis) :\n    calculateSegmentMoveRegion(segmentLengthYAxis);\n}\n\nfunction getClosestSegment(position, connection) {\n  var waypoints = connection.waypoints;\n\n  var minDistance = Infinity,\n      segmentIndex;\n\n  for (var i = 0; i < waypoints.length - 1; i++) {\n    var start = waypoints[i],\n        end = waypoints[i + 1],\n        distance = (0,GeometricUtil/* getDistancePointLine */.ON)(position, [ start, end ]);\n\n    if (distance < minDistance) {\n      minDistance = distance;\n      segmentIndex = i;\n    }\n  }\n\n  return [ waypoints[segmentIndex], waypoints[segmentIndex + 1] ];\n}\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/EscapeUtil.js\nvar EscapeUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/EscapeUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Mouse.js\nvar Mouse = __webpack_require__(\"./node_modules/diagram-js/lib/util/Mouse.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/bendpoints/Bendpoints.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../bendpoints/BendpointMove').default} BendpointMove\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../bendpoints/ConnectionSegmentMove').default} ConnectionSegmentMove\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../interaction-events/InteractionEvents').default} InteractionEvents\n */\n\n/**\n * A service that adds editable bendpoints to connections.\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {InteractionEvents} interactionEvents\n * @param {BendpointMove} bendpointMove\n * @param {ConnectionSegmentMove} connectionSegmentMove\n */\nfunction Bendpoints(\n    eventBus, canvas, interactionEvents,\n    bendpointMove, connectionSegmentMove) {\n\n  /**\n   * Returns true if intersection point is inside middle region of segment, adjusted by\n   * optional threshold\n   */\n  function isIntersectionMiddle(intersection, waypoints, treshold) {\n    var idx = intersection.index,\n        p = intersection.point,\n        p0, p1, mid, aligned, xDelta, yDelta;\n\n    if (idx <= 0 || intersection.bendpoint) {\n      return false;\n    }\n\n    p0 = waypoints[idx - 1];\n    p1 = waypoints[idx];\n    mid = (0,Geometry/* getMidPoint */.SO)(p0, p1),\n    aligned = (0,Geometry/* pointsAligned */.Or)(p0, p1);\n    xDelta = Math.abs(p.x - mid.x);\n    yDelta = Math.abs(p.y - mid.y);\n\n    return aligned && xDelta <= treshold && yDelta <= treshold;\n  }\n\n  /**\n   * Calculates the threshold from a connection's middle which fits the two-third-region\n   */\n  function calculateIntersectionThreshold(connection, intersection) {\n    var waypoints = connection.waypoints,\n        relevantSegment, alignment, segmentLength, threshold;\n\n    if (intersection.index <= 0 || intersection.bendpoint) {\n      return null;\n    }\n\n    // segment relative to connection intersection\n    relevantSegment = {\n      start: waypoints[intersection.index - 1],\n      end: waypoints[intersection.index]\n    };\n\n    alignment = (0,Geometry/* pointsAligned */.Or)(relevantSegment.start, relevantSegment.end);\n\n    if (!alignment) {\n      return null;\n    }\n\n    if (alignment === 'h') {\n      segmentLength = relevantSegment.end.x - relevantSegment.start.x;\n    } else {\n      segmentLength = relevantSegment.end.y - relevantSegment.start.y;\n    }\n\n    // calculate threshold relative to 2/3 of segment length\n    threshold = calculateSegmentMoveRegion(segmentLength) / 2;\n\n    return threshold;\n  }\n\n  function activateBendpointMove(event, connection) {\n    var waypoints = connection.waypoints,\n        intersection = getConnectionIntersection(canvas, waypoints, event),\n        threshold;\n\n    if (!intersection) {\n      return;\n    }\n\n    threshold = calculateIntersectionThreshold(connection, intersection);\n\n    if (isIntersectionMiddle(intersection, waypoints, threshold)) {\n      connectionSegmentMove.start(event, connection, intersection.index);\n    } else {\n      bendpointMove.start(event, connection, intersection.index, !intersection.bendpoint);\n    }\n\n    // we've handled the event\n    return true;\n  }\n\n  function bindInteractionEvents(node, eventName, element) {\n\n    dist_index_esm/* event.bind */.B.bind(node, eventName, function(event) {\n      interactionEvents.triggerMouseEvent(eventName, event, element);\n      event.stopPropagation();\n    });\n  }\n\n  function getBendpointsContainer(element, create) {\n\n    var layer = canvas.getLayer('overlays'),\n        gfx = (0,dist_index_esm/* query */.IO)('.djs-bendpoints[data-element-id=\"' + (0,EscapeUtil/* escapeCSS */.D)(element.id) + '\"]', layer);\n\n    if (!gfx && create) {\n      gfx = (0,tiny_svg_dist_index_esm/* create */.Ue)('g');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(gfx, { 'data-element-id': element.id });\n      (0,tiny_svg_dist_index_esm/* classes */.Sh)(gfx).add('djs-bendpoints');\n\n      (0,tiny_svg_dist_index_esm/* append */.R3)(layer, gfx);\n\n      bindInteractionEvents(gfx, 'mousedown', element);\n      bindInteractionEvents(gfx, 'click', element);\n      bindInteractionEvents(gfx, 'dblclick', element);\n    }\n\n    return gfx;\n  }\n\n  function getSegmentDragger(idx, parentGfx) {\n    return (0,dist_index_esm/* query */.IO)(\n      '.djs-segment-dragger[data-segment-idx=\"' + idx + '\"]',\n      parentGfx\n    );\n  }\n\n  function createBendpoints(gfx, connection) {\n    connection.waypoints.forEach(function(p, idx) {\n      var bendpoint = addBendpoint(gfx);\n\n      (0,tiny_svg_dist_index_esm/* append */.R3)(gfx, bendpoint);\n\n      (0,SvgTransformUtil/* translate */.Iu)(bendpoint, p.x, p.y);\n    });\n\n    // add floating bendpoint\n    addBendpoint(gfx, 'floating');\n  }\n\n  function createSegmentDraggers(gfx, connection) {\n\n    var waypoints = connection.waypoints;\n\n    var segmentStart,\n        segmentEnd,\n        segmentDraggerGfx;\n\n    for (var i = 1; i < waypoints.length; i++) {\n\n      segmentStart = waypoints[i - 1];\n      segmentEnd = waypoints[i];\n\n      if ((0,Geometry/* pointsAligned */.Or)(segmentStart, segmentEnd)) {\n        segmentDraggerGfx = addSegmentDragger(gfx, segmentStart, segmentEnd);\n\n        (0,tiny_svg_dist_index_esm/* attr */.Lj)(segmentDraggerGfx, { 'data-segment-idx': i });\n\n        bindInteractionEvents(segmentDraggerGfx, 'mousemove', connection);\n      }\n    }\n  }\n\n  function clearBendpoints(gfx) {\n    (0,index_esm/* forEach */.Ed)((0,dist_index_esm/* queryAll */.Kt)('.' + BENDPOINT_CLS, gfx), function(node) {\n      (0,tiny_svg_dist_index_esm/* remove */.Od)(node);\n    });\n  }\n\n  function clearSegmentDraggers(gfx) {\n    (0,index_esm/* forEach */.Ed)((0,dist_index_esm/* queryAll */.Kt)('.' + SEGMENT_DRAGGER_CLS, gfx), function(node) {\n      (0,tiny_svg_dist_index_esm/* remove */.Od)(node);\n    });\n  }\n\n  function addHandles(connection) {\n\n    var gfx = getBendpointsContainer(connection);\n\n    if (!gfx) {\n      gfx = getBendpointsContainer(connection, true);\n\n      createBendpoints(gfx, connection);\n      createSegmentDraggers(gfx, connection);\n    }\n\n    return gfx;\n  }\n\n  function updateHandles(connection) {\n\n    var gfx = getBendpointsContainer(connection);\n\n    if (gfx) {\n      clearSegmentDraggers(gfx);\n      clearBendpoints(gfx);\n      createSegmentDraggers(gfx, connection);\n      createBendpoints(gfx, connection);\n    }\n  }\n\n  function updateFloatingBendpointPosition(parentGfx, intersection) {\n    var floating = (0,dist_index_esm/* query */.IO)('.floating', parentGfx),\n        point = intersection.point;\n\n    if (!floating) {\n      return;\n    }\n\n    (0,SvgTransformUtil/* translate */.Iu)(floating, point.x, point.y);\n\n  }\n\n  function updateSegmentDraggerPosition(parentGfx, intersection, waypoints) {\n\n    var draggerGfx = getSegmentDragger(intersection.index, parentGfx),\n        segmentStart = waypoints[intersection.index - 1],\n        segmentEnd = waypoints[intersection.index],\n        point = intersection.point,\n        mid = (0,Geometry/* getMidPoint */.SO)(segmentStart, segmentEnd),\n        alignment = (0,Geometry/* pointsAligned */.Or)(segmentStart, segmentEnd),\n        draggerVisual, relativePosition;\n\n    if (!draggerGfx) {\n      return;\n    }\n\n    draggerVisual = getDraggerVisual(draggerGfx);\n\n    relativePosition = {\n      x: point.x - mid.x,\n      y: point.y - mid.y\n    };\n\n    if (alignment === 'v') {\n\n      // rotate position\n      relativePosition = {\n        x: relativePosition.y,\n        y: relativePosition.x\n      };\n    }\n\n    (0,SvgTransformUtil/* translate */.Iu)(draggerVisual, relativePosition.x, relativePosition.y);\n  }\n\n  eventBus.on('connection.changed', function(event) {\n    updateHandles(event.element);\n  });\n\n  eventBus.on('connection.remove', function(event) {\n    var gfx = getBendpointsContainer(event.element);\n\n    if (gfx) {\n      (0,tiny_svg_dist_index_esm/* remove */.Od)(gfx);\n    }\n  });\n\n  eventBus.on('element.marker.update', function(event) {\n\n    var element = event.element,\n        bendpointsGfx;\n\n    if (!element.waypoints) {\n      return;\n    }\n\n    bendpointsGfx = addHandles(element);\n\n    if (event.add) {\n      (0,tiny_svg_dist_index_esm/* classes */.Sh)(bendpointsGfx).add(event.marker);\n    } else {\n      (0,tiny_svg_dist_index_esm/* classes */.Sh)(bendpointsGfx).remove(event.marker);\n    }\n  });\n\n  eventBus.on('element.mousemove', function(event) {\n\n    var element = event.element,\n        waypoints = element.waypoints,\n        bendpointsGfx,\n        intersection;\n\n    if (waypoints) {\n      bendpointsGfx = getBendpointsContainer(element, true);\n\n      intersection = getConnectionIntersection(canvas, waypoints, event.originalEvent);\n\n      if (!intersection) {\n        return;\n      }\n\n      updateFloatingBendpointPosition(bendpointsGfx, intersection);\n\n      if (!intersection.bendpoint) {\n        updateSegmentDraggerPosition(bendpointsGfx, intersection, waypoints);\n      }\n\n    }\n  });\n\n  eventBus.on('element.mousedown', function(event) {\n\n    if (!(0,Mouse/* isPrimaryButton */.Id)(event)) {\n      return;\n    }\n\n    var originalEvent = event.originalEvent,\n        element = event.element;\n\n    if (!element.waypoints) {\n      return;\n    }\n\n    return activateBendpointMove(originalEvent, element);\n  });\n\n  eventBus.on('selection.changed', function(event) {\n    var newSelection = event.newSelection,\n        primary = newSelection[0];\n\n    if (primary && primary.waypoints) {\n      addHandles(primary);\n    }\n  });\n\n  eventBus.on('element.hover', function(event) {\n    var element = event.element;\n\n    if (element.waypoints) {\n      addHandles(element);\n      interactionEvents.registerEvent(event.gfx, 'mousemove', 'element.mousemove');\n    }\n  });\n\n  eventBus.on('element.out', function(event) {\n    interactionEvents.unregisterEvent(event.gfx, 'mousemove', 'element.mousemove');\n  });\n\n  // update bendpoint container data attribute on element ID change\n  eventBus.on('element.updateId', function(context) {\n    var element = context.element,\n        newId = context.newId;\n\n    if (element.waypoints) {\n      var bendpointContainer = getBendpointsContainer(element);\n\n      if (bendpointContainer) {\n        (0,tiny_svg_dist_index_esm/* attr */.Lj)(bendpointContainer, { 'data-element-id': newId });\n      }\n    }\n  });\n\n  // API\n\n  this.addHandles = addHandles;\n  this.updateHandles = updateHandles;\n  this.getBendpointsContainer = getBendpointsContainer;\n  this.getSegmentDragger = getSegmentDragger;\n}\n\nBendpoints.$inject = [\n  'eventBus',\n  'canvas',\n  'interactionEvents',\n  'bendpointMove',\n  'connectionSegmentMove'\n];\n\n\n\n// helper /////////////\n\nfunction getDraggerVisual(draggerGfx) {\n  return (0,dist_index_esm/* query */.IO)('.djs-visual', draggerGfx);\n}\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/bendpoints/BendpointMove.js\n\n\n/**\n * @typedef {import('didi').Injector} Injector\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../dragging/Dragging').default} Dragging\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../modeling/Modeling').default} Modeling\n * @typedef {import('../rules/Rules').default} Rules\n */\n\nvar round = Math.round;\n\nvar RECONNECT_START = 'reconnectStart',\n    RECONNECT_END = 'reconnectEnd',\n    UPDATE_WAYPOINTS = 'updateWaypoints';\n\n\n/**\n * Move bendpoints through drag and drop to add/remove bendpoints or reconnect connection.\n *\n * @param {Injector} injector\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {Dragging} dragging\n * @param {Rules} rules\n * @param {Modeling} modeling\n */\nfunction BendpointMove(injector, eventBus, canvas, dragging, rules, modeling) {\n  this._injector = injector;\n\n  this.start = function(event, connection, bendpointIndex, insert) {\n    var gfx = canvas.getGraphics(connection),\n        source = connection.source,\n        target = connection.target,\n        waypoints = connection.waypoints,\n        type;\n\n    if (!insert && bendpointIndex === 0) {\n      type = RECONNECT_START;\n    } else\n    if (!insert && bendpointIndex === waypoints.length - 1) {\n      type = RECONNECT_END;\n    } else {\n      type = UPDATE_WAYPOINTS;\n    }\n\n    var command = type === UPDATE_WAYPOINTS ? 'connection.updateWaypoints' : 'connection.reconnect';\n\n    var allowed = rules.allowed(command, {\n      connection: connection,\n      source: source,\n      target: target\n    });\n\n    if (allowed === false) {\n      allowed = rules.allowed(command, {\n        connection: connection,\n        source: target,\n        target: source\n      });\n    }\n\n    if (allowed === false) {\n      return;\n    }\n\n    dragging.init(event, 'bendpoint.move', {\n      data: {\n        connection: connection,\n        connectionGfx: gfx,\n        context: {\n          allowed: allowed,\n          bendpointIndex: bendpointIndex,\n          connection: connection,\n          source: source,\n          target: target,\n          insert: insert,\n          type: type\n        }\n      }\n    });\n  };\n\n  eventBus.on('bendpoint.move.hover', function(event) {\n    var context = event.context,\n        connection = context.connection,\n        source = connection.source,\n        target = connection.target,\n        hover = event.hover,\n        type = context.type;\n\n    // cache hover state\n    context.hover = hover;\n\n    var allowed;\n\n    if (!hover) {\n      return;\n    }\n\n    var command = type === UPDATE_WAYPOINTS ? 'connection.updateWaypoints' : 'connection.reconnect';\n\n    allowed = context.allowed = rules.allowed(command, {\n      connection: connection,\n      source: type === RECONNECT_START ? hover : source,\n      target: type === RECONNECT_END ? hover : target\n    });\n\n    if (allowed) {\n      context.source = type === RECONNECT_START ? hover : source;\n      context.target = type === RECONNECT_END ? hover : target;\n\n      return;\n    }\n\n    if (allowed === false) {\n      allowed = context.allowed = rules.allowed(command, {\n        connection: connection,\n        source: type === RECONNECT_END ? hover : target,\n        target: type === RECONNECT_START ? hover : source\n      });\n    }\n\n    if (allowed) {\n      context.source = type === RECONNECT_END ? hover : target;\n      context.target = type === RECONNECT_START ? hover : source;\n    }\n  });\n\n  eventBus.on([ 'bendpoint.move.out', 'bendpoint.move.cleanup' ], function(event) {\n    var context = event.context,\n        type = context.type;\n\n    context.hover = null;\n    context.source = null;\n    context.target = null;\n\n    if (type !== UPDATE_WAYPOINTS) {\n      context.allowed = false;\n    }\n  });\n\n  eventBus.on('bendpoint.move.end', function(event) {\n    var context = event.context,\n        allowed = context.allowed,\n        bendpointIndex = context.bendpointIndex,\n        connection = context.connection,\n        insert = context.insert,\n        newWaypoints = connection.waypoints.slice(),\n        source = context.source,\n        target = context.target,\n        type = context.type,\n        hints = context.hints || {};\n\n    // ensure integer values (important if zoom level was > 1 during move)\n    var docking = {\n      x: round(event.x),\n      y: round(event.y)\n    };\n\n    if (!allowed) {\n      return false;\n    }\n\n    if (type === UPDATE_WAYPOINTS) {\n      if (insert) {\n\n        // insert new bendpoint\n        newWaypoints.splice(bendpointIndex, 0, docking);\n      } else {\n\n        // swap previous waypoint with moved one\n        newWaypoints[bendpointIndex] = docking;\n      }\n\n      // pass hints about actual moved bendpoint\n      // useful for connection/label layout\n      hints.bendpointMove = {\n        insert: insert,\n        bendpointIndex: bendpointIndex\n      };\n\n      newWaypoints = this.cropWaypoints(connection, newWaypoints);\n\n      modeling.updateWaypoints(connection, (0,LayoutUtil/* filterRedundantWaypoints */.Re)(newWaypoints), hints);\n    } else {\n      if (type === RECONNECT_START) {\n        hints.docking = 'source';\n\n        if (isReverse(context)) {\n          hints.docking = 'target';\n\n          hints.newWaypoints = newWaypoints.reverse();\n        }\n      } else if (type === RECONNECT_END) {\n        hints.docking = 'target';\n\n        if (isReverse(context)) {\n          hints.docking = 'source';\n\n          hints.newWaypoints = newWaypoints.reverse();\n        }\n      }\n\n      modeling.reconnect(connection, source, target, docking, hints);\n    }\n  }, this);\n}\n\nBendpointMove.$inject = [\n  'injector',\n  'eventBus',\n  'canvas',\n  'dragging',\n  'rules',\n  'modeling'\n];\n\nBendpointMove.prototype.cropWaypoints = function(connection, newWaypoints) {\n  var connectionDocking = this._injector.get('connectionDocking', false);\n\n  if (!connectionDocking) {\n    return newWaypoints;\n  }\n\n  var waypoints = connection.waypoints;\n\n  connection.waypoints = newWaypoints;\n\n  connection.waypoints = connectionDocking.getCroppedWaypoints(connection);\n\n  newWaypoints = connection.waypoints;\n\n  connection.waypoints = waypoints;\n\n  return newWaypoints;\n};\n\n\n// helpers //////////\n\nfunction isReverse(context) {\n  var hover = context.hover,\n      source = context.source,\n      target = context.target,\n      type = context.type;\n\n  if (type === RECONNECT_START) {\n    return hover && target && hover === target && source !== target;\n  }\n\n  if (type === RECONNECT_END) {\n    return hover && source && hover === source && source !== target;\n  }\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/bendpoints/BendpointMovePreview.js\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('didi').Injector} Injector\n *\n * @typedef {import('../bendpoints/BendpointMove').default} BendpointMove\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n */\n\nvar BendpointMovePreview_RECONNECT_START = 'reconnectStart',\n    BendpointMovePreview_RECONNECT_END = 'reconnectEnd',\n    BendpointMovePreview_UPDATE_WAYPOINTS = 'updateWaypoints';\n\nvar MARKER_OK = 'connect-ok',\n    MARKER_NOT_OK = 'connect-not-ok',\n    MARKER_CONNECT_HOVER = 'connect-hover',\n    MARKER_CONNECT_UPDATING = 'djs-updating',\n    MARKER_ELEMENT_HIDDEN = 'djs-element-hidden';\n\nvar HIGH_PRIORITY = 1100;\n\n/**\n * Preview connection while moving bendpoints.\n *\n * @param {BendpointMove} bendpointMove\n * @param {Injector} injector\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n */\nfunction BendpointMovePreview(bendpointMove, injector, eventBus, canvas) {\n  this._injector = injector;\n\n  var connectionPreview = injector.get('connectionPreview', false);\n\n  eventBus.on('bendpoint.move.start', function(event) {\n    var context = event.context,\n        bendpointIndex = context.bendpointIndex,\n        connection = context.connection,\n        insert = context.insert,\n        waypoints = connection.waypoints,\n        newWaypoints = waypoints.slice();\n\n    context.waypoints = waypoints;\n\n    if (insert) {\n\n      // insert placeholder for new bendpoint\n      newWaypoints.splice(bendpointIndex, 0, { x: event.x, y: event.y });\n    }\n\n    connection.waypoints = newWaypoints;\n\n    // add dragger gfx\n    var draggerGfx = context.draggerGfx = addBendpoint(canvas.getLayer('overlays'));\n\n    (0,tiny_svg_dist_index_esm/* classes */.Sh)(draggerGfx).add('djs-dragging');\n\n    canvas.addMarker(connection, MARKER_ELEMENT_HIDDEN);\n    canvas.addMarker(connection, MARKER_CONNECT_UPDATING);\n  });\n\n  eventBus.on('bendpoint.move.hover', function(event) {\n    var context = event.context,\n        allowed = context.allowed,\n        hover = context.hover,\n        type = context.type;\n\n    if (hover) {\n      canvas.addMarker(hover, MARKER_CONNECT_HOVER);\n\n      if (type === BendpointMovePreview_UPDATE_WAYPOINTS) {\n        return;\n      }\n\n      if (allowed) {\n        canvas.removeMarker(hover, MARKER_NOT_OK);\n        canvas.addMarker(hover, MARKER_OK);\n      } else if (allowed === false) {\n        canvas.removeMarker(hover, MARKER_OK);\n        canvas.addMarker(hover, MARKER_NOT_OK);\n      }\n    }\n  });\n\n  eventBus.on([\n    'bendpoint.move.out',\n    'bendpoint.move.cleanup'\n  ], HIGH_PRIORITY, function(event) {\n    var context = event.context,\n        hover = context.hover,\n        target = context.target;\n\n    if (hover) {\n      canvas.removeMarker(hover, MARKER_CONNECT_HOVER);\n      canvas.removeMarker(hover, target ? MARKER_OK : MARKER_NOT_OK);\n    }\n  });\n\n  eventBus.on('bendpoint.move.move', function(event) {\n    var context = event.context,\n        allowed = context.allowed,\n        bendpointIndex = context.bendpointIndex,\n        draggerGfx = context.draggerGfx,\n        hover = context.hover,\n        type = context.type,\n        connection = context.connection,\n        source = connection.source,\n        target = connection.target,\n        newWaypoints = connection.waypoints.slice(),\n        bendpoint = { x: event.x, y: event.y },\n        hints = context.hints || {},\n        drawPreviewHints = {};\n\n    if (connectionPreview) {\n      if (hints.connectionStart) {\n        drawPreviewHints.connectionStart = hints.connectionStart;\n      }\n\n      if (hints.connectionEnd) {\n        drawPreviewHints.connectionEnd = hints.connectionEnd;\n      }\n\n\n      if (type === BendpointMovePreview_RECONNECT_START) {\n        if (isReverse(context)) {\n          drawPreviewHints.connectionEnd = drawPreviewHints.connectionEnd || bendpoint;\n\n          drawPreviewHints.source = target;\n          drawPreviewHints.target = hover || source;\n\n          newWaypoints = newWaypoints.reverse();\n        } else {\n          drawPreviewHints.connectionStart = drawPreviewHints.connectionStart || bendpoint;\n\n          drawPreviewHints.source = hover || source;\n          drawPreviewHints.target = target;\n        }\n      } else if (type === BendpointMovePreview_RECONNECT_END) {\n        if (isReverse(context)) {\n          drawPreviewHints.connectionStart = drawPreviewHints.connectionStart || bendpoint;\n\n          drawPreviewHints.source = hover || target;\n          drawPreviewHints.target = source;\n\n          newWaypoints = newWaypoints.reverse();\n        } else {\n          drawPreviewHints.connectionEnd = drawPreviewHints.connectionEnd || bendpoint;\n\n          drawPreviewHints.source = source;\n          drawPreviewHints.target = hover || target;\n        }\n\n      } else {\n        drawPreviewHints.noCropping = true;\n        drawPreviewHints.noLayout = true;\n        newWaypoints[ bendpointIndex ] = bendpoint;\n      }\n\n      if (type === BendpointMovePreview_UPDATE_WAYPOINTS) {\n        newWaypoints = bendpointMove.cropWaypoints(connection, newWaypoints);\n      }\n\n      drawPreviewHints.waypoints = newWaypoints;\n\n      connectionPreview.drawPreview(context, allowed, drawPreviewHints);\n    }\n\n    (0,SvgTransformUtil/* translate */.Iu)(draggerGfx, event.x, event.y);\n  }, this);\n\n  eventBus.on([\n    'bendpoint.move.end',\n    'bendpoint.move.cancel'\n  ], HIGH_PRIORITY, function(event) {\n    var context = event.context,\n        connection = context.connection,\n        draggerGfx = context.draggerGfx,\n        hover = context.hover,\n        target = context.target,\n        waypoints = context.waypoints;\n\n    connection.waypoints = waypoints;\n\n    // remove dragger gfx\n    (0,tiny_svg_dist_index_esm/* remove */.Od)(draggerGfx);\n\n    canvas.removeMarker(connection, MARKER_CONNECT_UPDATING);\n    canvas.removeMarker(connection, MARKER_ELEMENT_HIDDEN);\n\n    if (hover) {\n      canvas.removeMarker(hover, MARKER_OK);\n      canvas.removeMarker(hover, target ? MARKER_OK : MARKER_NOT_OK);\n    }\n\n    if (connectionPreview) {\n      connectionPreview.cleanUp(context);\n    }\n  });\n}\n\nBendpointMovePreview.$inject = [\n  'bendpointMove',\n  'injector',\n  'eventBus',\n  'canvas'\n];\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/bendpoints/ConnectionSegmentMove.js\n\n\n\n\n\n\nvar ConnectionSegmentMove_MARKER_CONNECT_HOVER = 'connect-hover',\n    ConnectionSegmentMove_MARKER_CONNECT_UPDATING = 'djs-updating';\n\n\n\n\n\n/**\n * @typedef {import('../../model/Types').Shape} Shape\n *\n * @typedef {import('../../util/Types').Axis} Axis\n * @typedef {import('../../util/Types').Point} Point\n *\n * @typedef {import('didi').Injector} Injector\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../dragging/Dragging').default} Dragging\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../../core/GraphicsFactory').default} GraphicsFactory\n * @typedef {import('../modeling/Modeling').default} Modeling\n */\n\nfunction axisAdd(point, axis, delta) {\n  return axisSet(point, axis, point[axis] + delta);\n}\n\nfunction axisSet(point, axis, value) {\n  return {\n    x: (axis === 'x' ? value : point.x),\n    y: (axis === 'y' ? value : point.y)\n  };\n}\n\nfunction axisFenced(position, segmentStart, segmentEnd, axis) {\n\n  var maxValue = Math.max(segmentStart[axis], segmentEnd[axis]),\n      minValue = Math.min(segmentStart[axis], segmentEnd[axis]);\n\n  var padding = 20;\n\n  var fencedValue = Math.min(Math.max(minValue + padding, position[axis]), maxValue - padding);\n\n  return axisSet(segmentStart, axis, fencedValue);\n}\n\nfunction flipAxis(axis) {\n  return axis === 'x' ? 'y' : 'x';\n}\n\n/**\n * Get the docking point on the given element.\n *\n * Compute a reasonable docking, if non exists.\n *\n * @param {Point} point\n * @param {Shape} referenceElement\n * @param {Axis} moveAxis\n *\n * @return {Point}\n */\nfunction getDocking(point, referenceElement, moveAxis) {\n\n  var referenceMid,\n      inverseAxis;\n\n  if (point.original) {\n    return point.original;\n  } else {\n    referenceMid = (0,LayoutUtil/* getMid */.wS)(referenceElement);\n    inverseAxis = flipAxis(moveAxis);\n\n    return axisSet(point, inverseAxis, referenceMid[inverseAxis]);\n  }\n}\n\n/**\n * A component that implements moving of bendpoints.\n *\n * @param {Injector} injector\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {Canvas} dragging\n * @param {GraphicsFactory} graphicsFactory\n * @param {Modeling} modeling\n */\nfunction ConnectionSegmentMove(\n    injector, eventBus, canvas,\n    dragging, graphicsFactory, modeling) {\n\n  // optional connection docking integration\n  var connectionDocking = injector.get('connectionDocking', false);\n\n\n  // API\n\n  this.start = function(event, connection, idx) {\n\n    var context,\n        gfx = canvas.getGraphics(connection),\n        segmentStartIndex = idx - 1,\n        segmentEndIndex = idx,\n        waypoints = connection.waypoints,\n        segmentStart = waypoints[segmentStartIndex],\n        segmentEnd = waypoints[segmentEndIndex],\n        intersection = getConnectionIntersection(canvas, waypoints, event),\n        direction, axis, dragPosition;\n\n    direction = (0,Geometry/* pointsAligned */.Or)(segmentStart, segmentEnd);\n\n    // do not move diagonal connection\n    if (!direction) {\n      return;\n    }\n\n    // the axis where we are going to move things\n    axis = direction === 'v' ? 'x' : 'y';\n\n    if (segmentStartIndex === 0) {\n      segmentStart = getDocking(segmentStart, connection.source, axis);\n    }\n\n    if (segmentEndIndex === waypoints.length - 1) {\n      segmentEnd = getDocking(segmentEnd, connection.target, axis);\n    }\n\n    if (intersection) {\n      dragPosition = intersection.point;\n    } else {\n\n      // set to segment center as default\n      dragPosition = {\n        x: (segmentStart.x + segmentEnd.x) / 2,\n        y: (segmentStart.y + segmentEnd.y) / 2\n      };\n    }\n\n    context = {\n      connection: connection,\n      segmentStartIndex: segmentStartIndex,\n      segmentEndIndex: segmentEndIndex,\n      segmentStart: segmentStart,\n      segmentEnd: segmentEnd,\n      axis: axis,\n      dragPosition: dragPosition\n    };\n\n    dragging.init(event, dragPosition, 'connectionSegment.move', {\n      cursor: axis === 'x' ? 'resize-ew' : 'resize-ns',\n      data: {\n        connection: connection,\n        connectionGfx: gfx,\n        context: context\n      }\n    });\n  };\n\n  /**\n   * Crop connection if connection cropping is provided.\n   *\n   * @param {Connection} connection\n   * @param {Point[]} newWaypoints\n   *\n   * @return {Point[]} cropped connection waypoints\n   */\n  function cropConnection(connection, newWaypoints) {\n\n    // crop connection, if docking service is provided only\n    if (!connectionDocking) {\n      return newWaypoints;\n    }\n\n    var oldWaypoints = connection.waypoints,\n        croppedWaypoints;\n\n    // temporary set new waypoints\n    connection.waypoints = newWaypoints;\n\n    croppedWaypoints = connectionDocking.getCroppedWaypoints(connection);\n\n    // restore old waypoints\n    connection.waypoints = oldWaypoints;\n\n    return croppedWaypoints;\n  }\n\n  // DRAGGING IMPLEMENTATION\n\n  function redrawConnection(data) {\n    graphicsFactory.update('connection', data.connection, data.connectionGfx);\n  }\n\n  function updateDragger(context, segmentOffset, event) {\n\n    var newWaypoints = context.newWaypoints,\n        segmentStartIndex = context.segmentStartIndex + segmentOffset,\n        segmentStart = newWaypoints[segmentStartIndex],\n        segmentEndIndex = context.segmentEndIndex + segmentOffset,\n        segmentEnd = newWaypoints[segmentEndIndex],\n        axis = flipAxis(context.axis);\n\n    // make sure the dragger does not move\n    // outside the connection\n    var draggerPosition = axisFenced(event, segmentStart, segmentEnd, axis);\n\n    // update dragger\n    (0,SvgTransformUtil/* translate */.Iu)(context.draggerGfx, draggerPosition.x, draggerPosition.y);\n  }\n\n  /**\n   * Filter waypoints for redundant ones (i.e. on the same axis).\n   * Returns the filtered waypoints and the offset related to the segment move.\n   *\n   * @param {Point[]} waypoints\n   * @param {Integer} segmentStartIndex of moved segment start\n   *\n   * @return {Object} { filteredWaypoints, segmentOffset }\n   */\n  function filterRedundantWaypoints(waypoints, segmentStartIndex) {\n\n    var segmentOffset = 0;\n\n    var filteredWaypoints = waypoints.filter(function(r, idx) {\n      if ((0,Geometry/* pointsOnLine */.ZS)(waypoints[idx - 1], waypoints[idx + 1], r)) {\n\n        // remove point and increment offset\n        segmentOffset = idx <= segmentStartIndex ? segmentOffset - 1 : segmentOffset;\n        return false;\n      }\n\n      // dont remove point\n      return true;\n    });\n\n    return {\n      waypoints: filteredWaypoints,\n      segmentOffset: segmentOffset\n    };\n  }\n\n  eventBus.on('connectionSegment.move.start', function(event) {\n\n    var context = event.context,\n        connection = event.connection,\n        layer = canvas.getLayer('overlays');\n\n    context.originalWaypoints = connection.waypoints.slice();\n\n    // add dragger gfx\n    context.draggerGfx = addSegmentDragger(layer, context.segmentStart, context.segmentEnd);\n    (0,tiny_svg_dist_index_esm/* classes */.Sh)(context.draggerGfx).add('djs-dragging');\n\n    canvas.addMarker(connection, ConnectionSegmentMove_MARKER_CONNECT_UPDATING);\n  });\n\n  eventBus.on('connectionSegment.move.move', function(event) {\n\n    var context = event.context,\n        connection = context.connection,\n        segmentStartIndex = context.segmentStartIndex,\n        segmentEndIndex = context.segmentEndIndex,\n        segmentStart = context.segmentStart,\n        segmentEnd = context.segmentEnd,\n        axis = context.axis;\n\n    var newWaypoints = context.originalWaypoints.slice(),\n        newSegmentStart = axisAdd(segmentStart, axis, event['d' + axis]),\n        newSegmentEnd = axisAdd(segmentEnd, axis, event['d' + axis]);\n\n    // original waypoint count and added / removed\n    // from start waypoint delta. We use the later\n    // to retrieve the updated segmentStartIndex / segmentEndIndex\n    var waypointCount = newWaypoints.length,\n        segmentOffset = 0;\n\n    // move segment start / end by axis delta\n    newWaypoints[segmentStartIndex] = newSegmentStart;\n    newWaypoints[segmentEndIndex] = newSegmentEnd;\n\n    var sourceToSegmentOrientation,\n        targetToSegmentOrientation;\n\n    // handle first segment\n    if (segmentStartIndex < 2) {\n      sourceToSegmentOrientation = (0,LayoutUtil/* getOrientation */.T8)(connection.source, newSegmentStart);\n\n      // first bendpoint, remove first segment if intersecting\n      if (segmentStartIndex === 1) {\n\n        if (sourceToSegmentOrientation === 'intersect') {\n          newWaypoints.shift();\n          newWaypoints[0] = newSegmentStart;\n          segmentOffset--;\n        }\n      }\n\n      // docking point, add segment if not intersecting anymore\n      else {\n        if (sourceToSegmentOrientation !== 'intersect') {\n          newWaypoints.unshift(segmentStart);\n          segmentOffset++;\n        }\n      }\n    }\n\n    // handle last segment\n    if (segmentEndIndex > waypointCount - 3) {\n      targetToSegmentOrientation = (0,LayoutUtil/* getOrientation */.T8)(connection.target, newSegmentEnd);\n\n      // last bendpoint, remove last segment if intersecting\n      if (segmentEndIndex === waypointCount - 2) {\n\n        if (targetToSegmentOrientation === 'intersect') {\n          newWaypoints.pop();\n          newWaypoints[newWaypoints.length - 1] = newSegmentEnd;\n        }\n      }\n\n      // last bendpoint, remove last segment if intersecting\n      else {\n        if (targetToSegmentOrientation !== 'intersect') {\n          newWaypoints.push(segmentEnd);\n        }\n      }\n    }\n\n    // update connection waypoints\n    context.newWaypoints = connection.waypoints = cropConnection(connection, newWaypoints);\n\n    // update dragger position\n    updateDragger(context, segmentOffset, event);\n\n    // save segmentOffset in context\n    context.newSegmentStartIndex = segmentStartIndex + segmentOffset;\n\n    // redraw connection\n    redrawConnection(event);\n  });\n\n  eventBus.on('connectionSegment.move.hover', function(event) {\n\n    event.context.hover = event.hover;\n    canvas.addMarker(event.hover, ConnectionSegmentMove_MARKER_CONNECT_HOVER);\n  });\n\n  eventBus.on([\n    'connectionSegment.move.out',\n    'connectionSegment.move.cleanup'\n  ], function(event) {\n\n    // remove connect marker\n    // if it was added\n    var hover = event.context.hover;\n\n    if (hover) {\n      canvas.removeMarker(hover, ConnectionSegmentMove_MARKER_CONNECT_HOVER);\n    }\n  });\n\n  eventBus.on('connectionSegment.move.cleanup', function(event) {\n\n    var context = event.context,\n        connection = context.connection;\n\n    // remove dragger gfx\n    if (context.draggerGfx) {\n      (0,tiny_svg_dist_index_esm/* remove */.Od)(context.draggerGfx);\n    }\n\n    canvas.removeMarker(connection, ConnectionSegmentMove_MARKER_CONNECT_UPDATING);\n  });\n\n  eventBus.on([\n    'connectionSegment.move.cancel',\n    'connectionSegment.move.end'\n  ], function(event) {\n    var context = event.context,\n        connection = context.connection;\n\n    connection.waypoints = context.originalWaypoints;\n\n    redrawConnection(event);\n  });\n\n  eventBus.on('connectionSegment.move.end', function(event) {\n\n    var context = event.context,\n        connection = context.connection,\n        newWaypoints = context.newWaypoints,\n        newSegmentStartIndex = context.newSegmentStartIndex;\n\n    // ensure we have actual pixel values bendpoint\n    // coordinates (important when zoom level was > 1 during move)\n    newWaypoints = newWaypoints.map(function(p) {\n      return {\n        original: p.original,\n        x: Math.round(p.x),\n        y: Math.round(p.y)\n      };\n    });\n\n    // apply filter redunant waypoints\n    var filtered = filterRedundantWaypoints(newWaypoints, newSegmentStartIndex);\n\n    // get filtered waypoints\n    var filteredWaypoints = filtered.waypoints,\n        croppedWaypoints = cropConnection(connection, filteredWaypoints),\n        segmentOffset = filtered.segmentOffset;\n\n    var hints = {\n      segmentMove: {\n        segmentStartIndex: context.segmentStartIndex,\n        newSegmentStartIndex: newSegmentStartIndex + segmentOffset\n      }\n    };\n\n    modeling.updateWaypoints(connection, croppedWaypoints, hints);\n  });\n}\n\nConnectionSegmentMove.$inject = [\n  'injector',\n  'eventBus',\n  'canvas',\n  'dragging',\n  'graphicsFactory',\n  'modeling'\n];\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/snapping/SnapUtil.js\nvar SnapUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/snapping/SnapUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/ModelUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/bendpoints/BendpointSnapping.js\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/EventBus').default} EventBus\n */\nvar abs = Math.abs,\n    BendpointSnapping_round = Math.round;\n\nvar TOLERANCE = 10;\n\n/**\n * @param {EventBus} eventBus\n */\nfunction BendpointSnapping(eventBus) {\n\n  function snapTo(values, value) {\n\n    if ((0,index_esm/* isArray */.kJ)(values)) {\n      var i = values.length;\n\n      while (i--) if (abs(values[i] - value) <= TOLERANCE) {\n        return values[i];\n      }\n    } else {\n      values = +values;\n      var rem = value % values;\n\n      if (rem < TOLERANCE) {\n        return value - rem;\n      }\n\n      if (rem > values - TOLERANCE) {\n        return value - rem + values;\n      }\n    }\n\n    return value;\n  }\n\n  function getSnapPoint(element, event) {\n\n    if (element.waypoints) {\n      return getClosestPointOnConnection(event, element);\n    }\n\n    if (element.width) {\n      return {\n        x: BendpointSnapping_round(element.width / 2 + element.x),\n        y: BendpointSnapping_round(element.height / 2 + element.y)\n      };\n    }\n  }\n\n  // connection segment snapping //////////////////////\n\n  function getConnectionSegmentSnaps(event) {\n\n    var context = event.context,\n        snapPoints = context.snapPoints,\n        connection = context.connection,\n        waypoints = connection.waypoints,\n        segmentStart = context.segmentStart,\n        segmentStartIndex = context.segmentStartIndex,\n        segmentEnd = context.segmentEnd,\n        segmentEndIndex = context.segmentEndIndex,\n        axis = context.axis;\n\n    if (snapPoints) {\n      return snapPoints;\n    }\n\n    var referenceWaypoints = [\n      waypoints[segmentStartIndex - 1],\n      segmentStart,\n      segmentEnd,\n      waypoints[segmentEndIndex + 1]\n    ];\n\n    if (segmentStartIndex < 2) {\n      referenceWaypoints.unshift(getSnapPoint(connection.source, event));\n    }\n\n    if (segmentEndIndex > waypoints.length - 3) {\n      referenceWaypoints.unshift(getSnapPoint(connection.target, event));\n    }\n\n    context.snapPoints = snapPoints = { horizontal: [] , vertical: [] };\n\n    (0,index_esm/* forEach */.Ed)(referenceWaypoints, function(p) {\n\n      // we snap on existing bendpoints only,\n      // not placeholders that are inserted during add\n      if (p) {\n        p = p.original || p;\n\n        if (axis === 'y') {\n          snapPoints.horizontal.push(p.y);\n        }\n\n        if (axis === 'x') {\n          snapPoints.vertical.push(p.x);\n        }\n      }\n    });\n\n    return snapPoints;\n  }\n\n  eventBus.on('connectionSegment.move.move', 1500, function(event) {\n    var snapPoints = getConnectionSegmentSnaps(event),\n        x = event.x,\n        y = event.y,\n        sx, sy;\n\n    if (!snapPoints) {\n      return;\n    }\n\n    // snap\n    sx = snapTo(snapPoints.vertical, x);\n    sy = snapTo(snapPoints.horizontal, y);\n\n\n    // correction x/y\n    var cx = (x - sx),\n        cy = (y - sy);\n\n    // update delta\n    (0,index_esm/* assign */.f0)(event, {\n      dx: event.dx - cx,\n      dy: event.dy - cy,\n      x: sx,\n      y: sy\n    });\n\n    // only set snapped if actually snapped\n    if (cx || snapPoints.vertical.indexOf(x) !== -1) {\n      (0,SnapUtil/* setSnapped */.U)(event, 'x', sx);\n    }\n\n    if (cy || snapPoints.horizontal.indexOf(y) !== -1) {\n      (0,SnapUtil/* setSnapped */.U)(event, 'y', sy);\n    }\n  });\n\n\n  // bendpoint snapping //////////////////////\n\n  function getBendpointSnaps(context) {\n\n    var snapPoints = context.snapPoints,\n        waypoints = context.connection.waypoints,\n        bendpointIndex = context.bendpointIndex;\n\n    if (snapPoints) {\n      return snapPoints;\n    }\n\n    var referenceWaypoints = [ waypoints[bendpointIndex - 1], waypoints[bendpointIndex + 1] ];\n\n    context.snapPoints = snapPoints = { horizontal: [] , vertical: [] };\n\n    (0,index_esm/* forEach */.Ed)(referenceWaypoints, function(p) {\n\n      // we snap on existing bendpoints only,\n      // not placeholders that are inserted during add\n      if (p) {\n        p = p.original || p;\n\n        snapPoints.horizontal.push(p.y);\n        snapPoints.vertical.push(p.x);\n      }\n    });\n\n    return snapPoints;\n  }\n\n  // Snap Endpoint of new connection\n  eventBus.on([\n    'connect.hover',\n    'connect.move',\n    'connect.end'\n  ], 1500, function(event) {\n    var context = event.context,\n        hover = context.hover,\n        hoverMid = hover && getSnapPoint(hover, event);\n\n    // only snap on connections, elements can have multiple connect endpoints\n    if (!(0,ModelUtil/* isConnection */.Ho)(hover) || !hoverMid || !hoverMid.x || !hoverMid.y) {\n      return;\n    }\n\n    (0,SnapUtil/* setSnapped */.U)(event, 'x', hoverMid.x);\n    (0,SnapUtil/* setSnapped */.U)(event, 'y', hoverMid.y);\n  });\n\n  eventBus.on([ 'bendpoint.move.move', 'bendpoint.move.end' ], 1500, function(event) {\n\n    var context = event.context,\n        snapPoints = getBendpointSnaps(context),\n        hover = context.hover,\n        hoverMid = hover && getSnapPoint(hover, event),\n        x = event.x,\n        y = event.y,\n        sx, sy;\n\n    if (!snapPoints) {\n      return;\n    }\n\n    // snap to hover mid\n    sx = snapTo(hoverMid ? snapPoints.vertical.concat([ hoverMid.x ]) : snapPoints.vertical, x);\n    sy = snapTo(hoverMid ? snapPoints.horizontal.concat([ hoverMid.y ]) : snapPoints.horizontal, y);\n\n    // correction x/y\n    var cx = (x - sx),\n        cy = (y - sy);\n\n    // update delta\n    (0,index_esm/* assign */.f0)(event, {\n      dx: event.dx - cx,\n      dy: event.dy - cy,\n      x: event.x - cx,\n      y: event.y - cy\n    });\n\n    // only set snapped if actually snapped\n    if (cx || snapPoints.vertical.indexOf(x) !== -1) {\n      (0,SnapUtil/* setSnapped */.U)(event, 'x', sx);\n    }\n\n    if (cy || snapPoints.horizontal.indexOf(y) !== -1) {\n      (0,SnapUtil/* setSnapped */.U)(event, 'y', sy);\n    }\n  });\n}\n\n\nBendpointSnapping.$inject = [ 'eventBus' ];\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/bendpoints/index.js\n\n\n\n\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const bendpoints = ({\n  __depends__: [\n    dragging/* default */.Z,\n    rules/* default */.Z\n  ],\n  __init__: [ 'bendpoints', 'bendpointSnapping', 'bendpointMovePreview' ],\n  bendpoints: [ 'type', Bendpoints ],\n  bendpointMove: [ 'type', BendpointMove ],\n  bendpointMovePreview: [ 'type', BendpointMovePreview ],\n  connectionSegmentMove: [ 'type', ConnectionSegmentMove ],\n  bendpointSnapping: [ 'type', BendpointSnapping ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/bendpoints/index.js_+_6_modules?")},"./node_modules/diagram-js/lib/features/change-support/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ change_support)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/change-support/ChangeSupport.js\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/ElementRegistry').default} ElementRegistry\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../../core/GraphicsFactory').default} GraphicsFactory\n */\n\n/**\n * Adds change support to the diagram, including\n *\n * <ul>\n *   <li>redrawing shapes and connections on change</li>\n * </ul>\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {ElementRegistry} elementRegistry\n * @param {GraphicsFactory} graphicsFactory\n */\nfunction ChangeSupport(\n    eventBus, canvas, elementRegistry,\n    graphicsFactory) {\n\n\n  // redraw shapes / connections on change\n\n  eventBus.on('element.changed', function(event) {\n\n    var element = event.element;\n\n    // element might have been deleted and replaced by new element with same ID\n    // thus check for parent of element except for root element\n    if (element.parent || element === canvas.getRootElement()) {\n      event.gfx = elementRegistry.getGraphics(element);\n    }\n\n    // shape + gfx may have been deleted\n    if (!event.gfx) {\n      return;\n    }\n\n    eventBus.fire((0,Elements/* getType */.oL)(element) + '.changed', event);\n  });\n\n  eventBus.on('elements.changed', function(event) {\n\n    var elements = event.elements;\n\n    elements.forEach(function(e) {\n      eventBus.fire('element.changed', { element: e });\n    });\n\n    graphicsFactory.updateContainments(elements);\n  });\n\n  eventBus.on('shape.changed', function(event) {\n    graphicsFactory.update('shape', event.element, event.gfx);\n  });\n\n  eventBus.on('connection.changed', function(event) {\n    graphicsFactory.update('connection', event.element, event.gfx);\n  });\n}\n\nChangeSupport.$inject = [\n  'eventBus',\n  'canvas',\n  'elementRegistry',\n  'graphicsFactory'\n];\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/change-support/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const change_support = ({\n  __init__: [ 'changeSupport' ],\n  changeSupport: [ 'type', ChangeSupport ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/change-support/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/connect/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ connect)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/dragging/index.js + 3 modules\nvar dragging = __webpack_require__(\"./node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/connect/Connect.js\n\n\n\n\n/**\n * @typedef {import('../../model/Types').Element} Element\n *\n * @typedef {import('../../util/Types').Point} Point\n *\n * @typedef {import('../dragging/Dragging').default} Dragging\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../modeling/Modeling').default} Modeling\n * @typedef {import('../rules/Rules').default} Rules\n */\n\n/**\n * @param {EventBus} eventBus\n * @param {Dragging} dragging\n * @param {Modeling} modeling\n * @param {Rules} rules\n */\nfunction Connect(eventBus, dragging, modeling, rules) {\n\n  // rules\n\n  function canConnect(source, target) {\n    return rules.allowed('connection.create', {\n      source: source,\n      target: target\n    });\n  }\n\n  function canConnectReverse(source, target) {\n    return canConnect(target, source);\n  }\n\n\n  // event handlers\n\n  eventBus.on('connect.hover', function(event) {\n    var context = event.context,\n        start = context.start,\n        hover = event.hover,\n        canExecute;\n\n    // cache hover state\n    context.hover = hover;\n\n    canExecute = context.canExecute = canConnect(start, hover);\n\n    // ignore hover\n    if ((0,index_esm/* isNil */.kK)(canExecute)) {\n      return;\n    }\n\n    if (canExecute !== false) {\n      context.source = start;\n      context.target = hover;\n\n      return;\n    }\n\n    canExecute = context.canExecute = canConnectReverse(start, hover);\n\n    // ignore hover\n    if ((0,index_esm/* isNil */.kK)(canExecute)) {\n      return;\n    }\n\n    if (canExecute !== false) {\n      context.source = hover;\n      context.target = start;\n    }\n  });\n\n  eventBus.on([ 'connect.out', 'connect.cleanup' ], function(event) {\n    var context = event.context;\n\n    context.hover = null;\n    context.source = null;\n    context.target = null;\n\n    context.canExecute = false;\n  });\n\n  eventBus.on('connect.end', function(event) {\n    var context = event.context,\n        canExecute = context.canExecute,\n        connectionStart = context.connectionStart,\n        connectionEnd = {\n          x: event.x,\n          y: event.y\n        },\n        source = context.source,\n        target = context.target;\n\n    if (!canExecute) {\n      return false;\n    }\n\n    var attrs = null,\n        hints = {\n          connectionStart: isReverse(context) ? connectionEnd : connectionStart,\n          connectionEnd: isReverse(context) ? connectionStart : connectionEnd\n        };\n\n    if ((0,index_esm/* isObject */.Kn)(canExecute)) {\n      attrs = canExecute;\n    }\n\n    context.connection = modeling.connect(source, target, attrs, hints);\n  });\n\n\n  // API\n\n  /**\n   * Start connect operation.\n   *\n   * @param {MouseEvent|TouchEvent} event\n   * @param {Element} start\n   * @param {Point} [connectionStart]\n   * @param {boolean} [autoActivate=false]\n   */\n  this.start = function(event, start, connectionStart, autoActivate) {\n    if (!(0,index_esm/* isObject */.Kn)(connectionStart)) {\n      autoActivate = connectionStart;\n      connectionStart = (0,LayoutUtil/* getMid */.wS)(start);\n    }\n\n    dragging.init(event, 'connect', {\n      autoActivate: autoActivate,\n      data: {\n        shape: start,\n        context: {\n          start: start,\n          connectionStart: connectionStart\n        }\n      }\n    });\n  };\n}\n\nConnect.$inject = [\n  'eventBus',\n  'dragging',\n  'modeling',\n  'rules'\n];\n\n\n// helpers //////////\n\nfunction isReverse(context) {\n  var hover = context.hover,\n      source = context.source,\n      target = context.target;\n\n  return hover && source && hover === source && source !== target;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/connect/ConnectPreview.js\n\n\n/**\n * @typedef {import('didi').Injector} Injector\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n */\n\nvar HIGH_PRIORITY = 1100,\n    LOW_PRIORITY = 900;\n\nvar MARKER_OK = 'connect-ok',\n    MARKER_NOT_OK = 'connect-not-ok';\n\n/**\n * Shows connection preview during connect.\n *\n * @param {Injector} injector\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n */\nfunction ConnectPreview(injector, eventBus, canvas) {\n  var connectionPreview = injector.get('connectionPreview', false);\n\n  connectionPreview && eventBus.on('connect.move', function(event) {\n    var context = event.context,\n        canConnect = context.canExecute,\n        hover = context.hover,\n        source = context.source,\n        start = context.start,\n        startPosition = context.startPosition,\n        target = context.target,\n        connectionStart = context.connectionStart || startPosition,\n        connectionEnd = context.connectionEnd || {\n          x: event.x,\n          y: event.y\n        },\n        previewStart = connectionStart,\n        previewEnd = connectionEnd;\n\n    if (isReverse(context)) {\n      previewStart = connectionEnd;\n      previewEnd = connectionStart;\n    }\n\n    connectionPreview.drawPreview(context, canConnect, {\n      source: source || start,\n      target: target || hover,\n      connectionStart: previewStart,\n      connectionEnd: previewEnd\n    });\n  });\n\n  eventBus.on('connect.hover', LOW_PRIORITY, function(event) {\n    var context = event.context,\n        hover = event.hover,\n        canExecute = context.canExecute;\n\n    // ignore hover\n    if (canExecute === null) {\n      return;\n    }\n\n    canvas.addMarker(hover, canExecute ? MARKER_OK : MARKER_NOT_OK);\n  });\n\n  eventBus.on([\n    'connect.out',\n    'connect.cleanup'\n  ], HIGH_PRIORITY, function(event) {\n    var hover = event.hover;\n\n    if (hover) {\n      canvas.removeMarker(hover, MARKER_OK);\n      canvas.removeMarker(hover, MARKER_NOT_OK);\n    }\n  });\n\n  connectionPreview && eventBus.on('connect.cleanup', function(event) {\n    connectionPreview.cleanUp(event.context);\n  });\n}\n\nConnectPreview.$inject = [\n  'injector',\n  'eventBus',\n  'canvas'\n];\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/connect/index.js\n\n\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const connect = ({\n  __depends__: [\n    selection/* default */.Z,\n    rules/* default */.Z,\n    dragging/* default */.Z\n  ],\n  __init__: [\n    'connectPreview'\n  ],\n  connect: [ 'type', Connect ],\n  connectPreview: [ 'type', ConnectPreview ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/connect/index.js_+_2_modules?")},"./node_modules/diagram-js/lib/features/connection-preview/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ connection_preview)\n});\n\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/RenderUtil.js\nvar RenderUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/RenderUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/connection-preview/ConnectionPreview.js\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../model/Types').Element} Element\n * @typedef {import('../../model/Types').Connection} Connection\n * @typedef {import('../../model/Types').Shape} Shape\n *\n * @typedef {import('../../util/Types').Point} Point\n *\n * @typedef {import('didi').Injector} Injector\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/ElementFactory').default} ElementFactory\n * @typedef {import('../../core/GraphicsFactory').default} GraphicsFactory\n */\n\nvar MARKER_CONNECTION_PREVIEW = 'djs-connection-preview';\n\n/**\n * Draws connection preview. Optionally, this can use layouter and connection docking to draw\n * better looking previews.\n *\n * @param {Injector} injector\n * @param {Canvas} canvas\n * @param {GraphicsFactory} graphicsFactory\n * @param {ElementFactory} elementFactory\n */\nfunction ConnectionPreview(\n    injector,\n    canvas,\n    graphicsFactory,\n    elementFactory\n) {\n  this._canvas = canvas;\n  this._graphicsFactory = graphicsFactory;\n  this._elementFactory = elementFactory;\n\n  // optional components\n  this._connectionDocking = injector.get('connectionDocking', false);\n  this._layouter = injector.get('layouter', false);\n}\n\nConnectionPreview.$inject = [\n  'injector',\n  'canvas',\n  'graphicsFactory',\n  'elementFactory'\n];\n\n/**\n * Draw connection preview.\n *\n * Provide at least one of <source, connectionStart> and <target, connectionEnd> to create a preview.\n * In the clean up stage, call `connectionPreview#cleanUp` with the context to remove preview.\n *\n * @param {Object} context\n * @param {Object|boolean} canConnect\n * @param {Object} hints\n * @param {Element} [hints.source] source element\n * @param {Element} [hints.target] target element\n * @param {Point} [hints.connectionStart] connection preview start\n * @param {Point} [hints.connectionEnd] connection preview end\n * @param {Point[]} [hints.waypoints] provided waypoints for preview\n * @param {boolean} [hints.noLayout] true if preview should not be laid out\n * @param {boolean} [hints.noCropping] true if preview should not be cropped\n * @param {boolean} [hints.noNoop] true if simple connection should not be drawn\n */\nConnectionPreview.prototype.drawPreview = function(context, canConnect, hints) {\n\n  hints = hints || {};\n\n  var connectionPreviewGfx = context.connectionPreviewGfx,\n      getConnection = context.getConnection,\n      source = hints.source,\n      target = hints.target,\n      waypoints = hints.waypoints,\n      connectionStart = hints.connectionStart,\n      connectionEnd = hints.connectionEnd,\n      noLayout = hints.noLayout,\n      noCropping = hints.noCropping,\n      noNoop = hints.noNoop,\n      connection;\n\n  var self = this;\n\n  if (!connectionPreviewGfx) {\n    connectionPreviewGfx = context.connectionPreviewGfx = this.createConnectionPreviewGfx();\n  }\n\n  (0,index_esm/* clear */.ZH)(connectionPreviewGfx);\n\n  if (!getConnection) {\n    getConnection = context.getConnection = cacheReturnValues(function(canConnect, source, target) {\n      return self.getConnection(canConnect, source, target);\n    });\n  }\n\n  if (canConnect) {\n    connection = getConnection(canConnect, source, target);\n  }\n\n  if (!connection) {\n    !noNoop && this.drawNoopPreview(connectionPreviewGfx, hints);\n    return;\n  }\n\n  connection.waypoints = waypoints || [];\n\n  // optional layout\n  if (this._layouter && !noLayout) {\n    connection.waypoints = this._layouter.layoutConnection(connection, {\n      source: source,\n      target: target,\n      connectionStart: connectionStart,\n      connectionEnd: connectionEnd,\n      waypoints: hints.waypoints || connection.waypoints\n    });\n  }\n\n  // fallback if no waypoints were provided nor created with layouter\n  if (!connection.waypoints || !connection.waypoints.length) {\n    connection.waypoints = [\n      source ? (0,LayoutUtil/* getMid */.wS)(source) : connectionStart,\n      target ? (0,LayoutUtil/* getMid */.wS)(target) : connectionEnd\n    ];\n  }\n\n  // optional cropping\n  if (this._connectionDocking && (source || target) && !noCropping) {\n    connection.waypoints = this._connectionDocking.getCroppedWaypoints(connection, source, target);\n  }\n\n  this._graphicsFactory.drawConnection(connectionPreviewGfx, connection);\n};\n\n/**\n * Draw simple connection between source and target or provided points.\n *\n * @param {SVGElement} connectionPreviewGfx container for the connection\n * @param {Object} hints\n * @param {Element} [hints.source] source element\n * @param {Element} [hints.target] target element\n * @param {Point} [hints.connectionStart] required if source is not provided\n * @param {Point} [hints.connectionEnd] required if target is not provided\n */\nConnectionPreview.prototype.drawNoopPreview = function(connectionPreviewGfx, hints) {\n  var source = hints.source,\n      target = hints.target,\n      start = hints.connectionStart || (0,LayoutUtil/* getMid */.wS)(source),\n      end = hints.connectionEnd || (0,LayoutUtil/* getMid */.wS)(target);\n\n  var waypoints = this.cropWaypoints(start, end, source, target);\n\n  var connection = this.createNoopConnection(waypoints[0], waypoints[1]);\n\n  (0,index_esm/* append */.R3)(connectionPreviewGfx, connection);\n};\n\n/**\n * Return cropped waypoints.\n *\n * @param {Point} start\n * @param {Point} end\n * @param {Element} source\n * @param {Element} target\n *\n * @return {Point[]}\n */\nConnectionPreview.prototype.cropWaypoints = function(start, end, source, target) {\n  var graphicsFactory = this._graphicsFactory,\n      sourcePath = source && graphicsFactory.getShapePath(source),\n      targetPath = target && graphicsFactory.getShapePath(target),\n      connectionPath = graphicsFactory.getConnectionPath({ waypoints: [ start, end ] });\n\n  start = (source && (0,LayoutUtil/* getElementLineIntersection */.Hz)(sourcePath, connectionPath, true)) || start;\n  end = (target && (0,LayoutUtil/* getElementLineIntersection */.Hz)(targetPath, connectionPath, false)) || end;\n\n  return [ start, end ];\n};\n\n/**\n * Remove connection preview container if it exists.\n *\n * @param {Object} [context]\n * @param {SVGElement} [context.connectionPreviewGfx] preview container\n */\nConnectionPreview.prototype.cleanUp = function(context) {\n  if (context && context.connectionPreviewGfx) {\n    (0,index_esm/* remove */.Od)(context.connectionPreviewGfx);\n  }\n};\n\n/**\n * Get connection that connects source and target.\n *\n * @param {Object|boolean} canConnect\n *\n * @return {Connection}\n */\nConnectionPreview.prototype.getConnection = function(canConnect) {\n  var attrs = ensureConnectionAttrs(canConnect);\n\n  return this._elementFactory.createConnection(attrs);\n};\n\n\n/**\n * Add and return preview graphics.\n *\n * @return {SVGElement}\n */\nConnectionPreview.prototype.createConnectionPreviewGfx = function() {\n  var gfx = (0,index_esm/* create */.Ue)('g');\n\n  (0,index_esm/* attr */.Lj)(gfx, {\n    pointerEvents: 'none'\n  });\n\n  (0,index_esm/* classes */.Sh)(gfx).add(MARKER_CONNECTION_PREVIEW);\n\n  (0,index_esm/* append */.R3)(this._canvas.getActiveLayer(), gfx);\n\n  return gfx;\n};\n\n/**\n * Create and return simple connection.\n *\n * @param {Point} start\n * @param {Point} end\n *\n * @return {SVGElement}\n */\nConnectionPreview.prototype.createNoopConnection = function(start, end) {\n  return (0,RenderUtil/* createLine */.W5)([ start, end ], {\n    'stroke': '#333',\n    'strokeDasharray': [ 1 ],\n    'strokeWidth': 2,\n    'pointer-events': 'none'\n  });\n};\n\n// helpers //////////\n\n/**\n * Returns function that returns cached return values referenced by stringified first argument.\n *\n * @param {Function} fn\n *\n * @return {Function}\n */\nfunction cacheReturnValues(fn) {\n  var returnValues = {};\n\n  /**\n   * Return cached return value referenced by stringified first argument.\n   *\n   * @return {*}\n   */\n  return function(firstArgument) {\n    var key = JSON.stringify(firstArgument);\n\n    var returnValue = returnValues[key];\n\n    if (!returnValue) {\n      returnValue = returnValues[key] = fn.apply(null, arguments);\n    }\n\n    return returnValue;\n  };\n}\n\n/**\n * Ensure connection attributes is object.\n *\n * @param {Object|boolean} canConnect\n *\n * @return {Object}\n */\nfunction ensureConnectionAttrs(canConnect) {\n  if ((0,dist_index_esm/* isObject */.Kn)(canConnect)) {\n    return canConnect;\n  } else {\n    return {};\n  }\n}\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/connection-preview/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const connection_preview = ({\n  __init__: [ 'connectionPreview' ],\n  connectionPreview: [ 'type', ConnectionPreview ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/connection-preview/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/context-pad/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ context_pad)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/interaction-events/index.js + 1 modules\nvar interaction_events = __webpack_require__(\"./node_modules/diagram-js/lib/features/interaction-events/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/overlays/index.js + 1 modules\nvar overlays = __webpack_require__(\"./node_modules/diagram-js/lib/features/overlays/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/EscapeUtil.js\nvar EscapeUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/EscapeUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/context-pad/ContextPad.js\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../model/Types').Element} Element\n *\n * @typedef {import('../../util/Types').Rect} Rect\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../overlays/Overlays').default} Overlays\n *\n * @typedef {import('../overlays/Overlays').Overlay} Overlay\n *\n * @typedef {import('./ContextPadProvider').default} ContextPadProvider\n * @typedef {import('./ContextPadProvider').ContextPadEntries} ContextPadEntries\n *\n * @typedef { {\n *   scale?: {\n *     min?: number;\n *     max?: number;\n *   };\n * } } ContextPadConfig\n */\n\n/**\n * @template {Element} [ElementType=Element]\n *\n * @typedef {ElementType|ElementType[]} ContextPadTarget\n */\n\nvar entrySelector = '.entry';\n\nvar DEFAULT_PRIORITY = 1000;\nvar CONTEXT_PAD_PADDING = 12;\n\n/**\n * A context pad that displays element specific, contextual actions next\n * to a diagram element.\n *\n * @param {Canvas} canvas\n * @param {ContextPadConfig} config\n * @param {EventBus} eventBus\n * @param {Overlays} overlays\n */\nfunction ContextPad(canvas, config, eventBus, overlays) {\n\n  this._canvas = canvas;\n  this._eventBus = eventBus;\n  this._overlays = overlays;\n\n  var scale = (0,index_esm/* isDefined */.$K)(config && config.scale) ? config.scale : {\n    min: 1,\n    max: 1.5\n  };\n\n  this._overlaysConfig = {\n    scale: scale\n  };\n\n  this._current = null;\n\n  this._init();\n}\n\nContextPad.$inject = [\n  'canvas',\n  'config.contextPad',\n  'eventBus',\n  'overlays'\n];\n\n\n/**\n * Registers events needed for interaction with other components.\n */\nContextPad.prototype._init = function() {\n  var self = this;\n\n  this._eventBus.on('selection.changed', function(event) {\n\n    var selection = event.newSelection;\n\n    var target = selection.length\n      ? selection.length === 1\n        ? selection[0]\n        : selection\n      : null;\n\n    if (target) {\n      self.open(target, true);\n    } else {\n      self.close();\n    }\n  });\n\n  this._eventBus.on('elements.changed', function(event) {\n    var elements = event.elements,\n        current = self._current;\n\n    if (!current) {\n      return;\n    }\n\n    var currentTarget = current.target;\n\n    var currentChanged = (0,index_esm/* some */.G)(\n      (0,index_esm/* isArray */.kJ)(currentTarget) ? currentTarget : [ currentTarget ],\n      function(element) {\n        return includes(elements, element);\n      }\n    );\n\n    // re-open if elements in current selection changed\n    if (currentChanged) {\n      self.open(currentTarget, true);\n    }\n  });\n};\n\n/**\n * @overlord\n *\n * Register a context pad provider with the default priority. See\n * {@link ContextPadProvider} for examples.\n *\n * @param {ContextPadProvider} provider\n */\n\n/**\n * Register a context pad provider with the given priority. See\n * {@link ContextPadProvider} for examples.\n *\n * @param {number} priority\n * @param {ContextPadProvider} provider\n */\nContextPad.prototype.registerProvider = function(priority, provider) {\n  if (!provider) {\n    provider = priority;\n    priority = DEFAULT_PRIORITY;\n  }\n\n  this._eventBus.on('contextPad.getProviders', priority, function(event) {\n    event.providers.push(provider);\n  });\n};\n\n\n/**\n * Get context pad entries for given elements.\n *\n * @param {ContextPadTarget} target\n *\n * @return {ContextPadEntries} list of entries\n */\nContextPad.prototype.getEntries = function(target) {\n  var providers = this._getProviders();\n\n  var provideFn = (0,index_esm/* isArray */.kJ)(target)\n    ? 'getMultiElementContextPadEntries'\n    : 'getContextPadEntries';\n\n  var entries = {};\n\n  // loop through all providers and their entries.\n  // group entries by id so that overriding an entry is possible\n  (0,index_esm/* forEach */.Ed)(providers, function(provider) {\n\n    if (!(0,index_esm/* isFunction */.mf)(provider[provideFn])) {\n      return;\n    }\n\n    var entriesOrUpdater = provider[provideFn](target);\n\n    if ((0,index_esm/* isFunction */.mf)(entriesOrUpdater)) {\n      entries = entriesOrUpdater(entries);\n    } else {\n      (0,index_esm/* forEach */.Ed)(entriesOrUpdater, function(entry, id) {\n        entries[id] = entry;\n      });\n    }\n  });\n\n  return entries;\n};\n\n\n/**\n * Trigger context pad via DOM event.\n *\n * The entry to trigger is determined by the target element.\n *\n * @param {string} action\n * @param {Event} event\n * @param {boolean} [autoActivate=false]\n */\nContextPad.prototype.trigger = function(action, event, autoActivate) {\n\n  var entry,\n      originalEvent,\n      button = event.delegateTarget || event.target;\n\n  if (!button) {\n    return event.preventDefault();\n  }\n\n  entry = (0,dist_index_esm/* attr */.Lj)(button, 'data-action');\n  originalEvent = event.originalEvent || event;\n\n  return this.triggerEntry(entry, action, originalEvent, autoActivate);\n};\n\n/**\n * Trigger context pad entry entry.\n *\n * @param {string} entryId\n * @param {string} action\n * @param {Event} event\n * @param {boolean} [autoActivate=false]\n */\nContextPad.prototype.triggerEntry = function(entryId, action, event, autoActivate) {\n\n  if (!this.isShown()) {\n    return;\n  }\n\n  var target = this._current.target,\n      entries = this._current.entries;\n\n  var entry = entries[entryId];\n\n  if (!entry) {\n    return;\n  }\n\n  var handler = entry.action;\n\n  if (this._eventBus.fire('contextPad.trigger', { entry, event }) === false) {\n    return;\n  }\n\n  // simple action (via callback function)\n  if ((0,index_esm/* isFunction */.mf)(handler)) {\n    if (action === 'click') {\n      return handler(event, target, autoActivate);\n    }\n  } else {\n    if (handler[action]) {\n      return handler[action](event, target, autoActivate);\n    }\n  }\n\n  // silence other actions\n  event.preventDefault();\n};\n\n\n/**\n * Open the context pad for given elements.\n *\n * @param {ContextPadTarget} target\n * @param {boolean} [force=false] - Force re-opening context pad.\n */\nContextPad.prototype.open = function(target, force) {\n  if (!force && this.isOpen(target)) {\n    return;\n  }\n\n  this.close();\n\n  this._updateAndOpen(target);\n};\n\nContextPad.prototype._getProviders = function() {\n\n  var event = this._eventBus.createEvent({\n    type: 'contextPad.getProviders',\n    providers: []\n  });\n\n  this._eventBus.fire(event);\n\n  return event.providers;\n};\n\n\n/**\n * @param {ContextPadTarget} target\n */\nContextPad.prototype._updateAndOpen = function(target) {\n  var entries = this.getEntries(target),\n      pad = this.getPad(target),\n      html = pad.html,\n      image;\n\n  (0,index_esm/* forEach */.Ed)(entries, function(entry, id) {\n    var grouping = entry.group || 'default',\n        control = (0,dist_index_esm/* domify */.H6)(entry.html || '<div class=\"entry\" draggable=\"true\"></div>'),\n        container;\n\n    (0,dist_index_esm/* attr */.Lj)(control, 'data-action', id);\n\n    container = (0,dist_index_esm/* query */.IO)('[data-group=' + (0,EscapeUtil/* escapeCSS */.D)(grouping) + ']', html);\n    if (!container) {\n      container = (0,dist_index_esm/* domify */.H6)('<div class=\"group\"></div>');\n      (0,dist_index_esm/* attr */.Lj)(container, 'data-group', grouping);\n\n      html.appendChild(container);\n    }\n\n    container.appendChild(control);\n\n    if (entry.className) {\n      addClasses(control, entry.className);\n    }\n\n    if (entry.title) {\n      (0,dist_index_esm/* attr */.Lj)(control, 'title', entry.title);\n    }\n\n    if (entry.imageUrl) {\n      image = (0,dist_index_esm/* domify */.H6)('<img>');\n      (0,dist_index_esm/* attr */.Lj)(image, 'src', entry.imageUrl);\n      image.style.width = '100%';\n      image.style.height = '100%';\n\n      control.appendChild(image);\n    }\n  });\n\n  (0,dist_index_esm/* classes */.Sh)(html).add('open');\n\n  this._current = {\n    target: target,\n    entries: entries,\n    pad: pad\n  };\n\n  this._eventBus.fire('contextPad.open', { current: this._current });\n};\n\n/**\n * @param {ContextPadTarget} target\n *\n * @return {Overlay}\n */\nContextPad.prototype.getPad = function(target) {\n  if (this.isOpen()) {\n    return this._current.pad;\n  }\n\n  var self = this;\n\n  var overlays = this._overlays;\n\n  var html = (0,dist_index_esm/* domify */.H6)('<div class=\"djs-context-pad\"></div>');\n\n  var position = this._getPosition(target);\n\n  var overlaysConfig = (0,index_esm/* assign */.f0)({\n    html: html\n  }, this._overlaysConfig, position);\n\n  dist_index_esm/* delegate.bind */.cl.bind(html, entrySelector, 'click', function(event) {\n    self.trigger('click', event);\n  });\n\n  dist_index_esm/* delegate.bind */.cl.bind(html, entrySelector, 'dragstart', function(event) {\n    self.trigger('dragstart', event);\n  });\n\n  // stop propagation of mouse events\n  dist_index_esm/* event.bind */.B.bind(html, 'mousedown', function(event) {\n    event.stopPropagation();\n  });\n\n  var activeRootElement = this._canvas.getRootElement();\n\n  this._overlayId = overlays.add(activeRootElement, 'context-pad', overlaysConfig);\n\n  var pad = overlays.get(this._overlayId);\n\n  this._eventBus.fire('contextPad.create', {\n    target: target,\n    pad: pad\n  });\n\n  return pad;\n};\n\n\n/**\n * Close the context pad\n */\nContextPad.prototype.close = function() {\n  if (!this.isOpen()) {\n    return;\n  }\n\n  this._overlays.remove(this._overlayId);\n\n  this._overlayId = null;\n\n  this._eventBus.fire('contextPad.close', { current: this._current });\n\n  this._current = null;\n};\n\n/**\n * Check if pad is open.\n *\n * If target is provided, check if it is opened\n * for the given target (single or multiple elements).\n *\n * @param {ContextPadTarget} [target]\n * @return {boolean}\n */\nContextPad.prototype.isOpen = function(target) {\n  var current = this._current;\n\n  if (!current) {\n    return false;\n  }\n\n  // basic no-args is open check\n  if (!target) {\n    return true;\n  }\n\n  var currentTarget = current.target;\n\n  // strict handling of single vs. multi-selection\n  if ((0,index_esm/* isArray */.kJ)(target) !== (0,index_esm/* isArray */.kJ)(currentTarget)) {\n    return false;\n  }\n\n  if ((0,index_esm/* isArray */.kJ)(target)) {\n    return (\n      target.length === currentTarget.length &&\n      (0,index_esm/* every */.yW)(target, function(element) {\n        return includes(currentTarget, element);\n      })\n    );\n  } else {\n    return currentTarget === target;\n  }\n};\n\n\n/**\n * Check if pad is open and not hidden.\n *\n * @return {boolean}\n */\nContextPad.prototype.isShown = function() {\n  return this.isOpen() && this._overlays.isShown();\n};\n\n\n/**\n * Get contex pad position.\n *\n * @param {ContextPadTarget} target\n *\n * @return {Rect}\n */\nContextPad.prototype._getPosition = function(target) {\n\n  var elements = (0,index_esm/* isArray */.kJ)(target) ? target : [ target ];\n  var bBox = (0,Elements/* getBBox */.jY)(elements);\n\n  return {\n    position: {\n      left: bBox.x + bBox.width + CONTEXT_PAD_PADDING,\n      top: bBox.y - CONTEXT_PAD_PADDING / 2\n    }\n  };\n};\n\n\n// helpers //////////\n\nfunction addClasses(element, classNames) {\n  var classes = (0,dist_index_esm/* classes */.Sh)(element);\n\n  classNames = (0,index_esm/* isArray */.kJ)(classNames) ? classNames : classNames.split(/\\s+/g);\n\n  classNames.forEach(function(cls) {\n    classes.add(cls);\n  });\n}\n\n/**\n * @param {any[]} array\n * @param {any} item\n *\n * @return {boolean}\n */\nfunction includes(array, item) {\n  return array.indexOf(item) !== -1;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/context-pad/index.js\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const context_pad = ({\n  __depends__: [\n    interaction_events/* default */.Z,\n    overlays/* default */.Z\n  ],\n  contextPad: [ 'type', ContextPad ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/context-pad/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/copy-paste/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ copy_paste)\n});\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/clipboard/Clipboard.js\n/**\n * A clip board stub\n */\nfunction Clipboard() {}\n\n\nClipboard.prototype.get = function() {\n  return this._data;\n};\n\nClipboard.prototype.set = function(data) {\n  this._data = data;\n};\n\nClipboard.prototype.clear = function() {\n  var data = this._data;\n\n  delete this._data;\n\n  return data;\n};\n\nClipboard.prototype.isEmpty = function() {\n  return !this._data;\n};\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/clipboard/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const clipboard = ({\n  clipboard: [ 'type', Clipboard ]\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/create/index.js + 2 modules\nvar create = __webpack_require__(\"./node_modules/diagram-js/lib/features/create/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/mouse/index.js + 1 modules\nvar mouse = __webpack_require__(\"./node_modules/diagram-js/lib/features/mouse/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/ModelUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/copy-paste/CopyPaste.js\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Types').ElementLike} Element\n * @typedef {import('../../core/Types').ShapeLike} Shape\n *\n * @typedef {import('../../util/Types').Point} Point\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../clipboard/Clipboard').default} Clipboard\n * @typedef {import('../create/Create').default} Create\n * @typedef {import('../../core/ElementFactory').default} ElementFactory\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../modeling/Modeling').default} Modeling\n * @typedef {import('../mouse/Mouse').default} Mouse\n * @typedef {import('../rules/Rules').default} Rules\n */\n\n/**\n * @typedef { (event: { elements: Element[] }) => Element[]|boolean } CopyPasteCanCopyElementsListener\n */\n\n/**\n * @typedef { (event: { descriptor: any, element: Element, elements: Element[] }) => void } CopyPasteCopyElementListener\n */\n\n/**\n * @typedef { (event: { element: Element, children: Element[] }) => void } CopyPasteCreateTreeListener\n */\n\n/**\n * @typedef { (event: { elements: any, tree: any }) => void } CopyPasteElementsCopiedListener\n */\n\n/**\n * @typedef { (event: { cache: any, descriptor: any }) => void } CopyPastePasteElementListener\n */\n\n/**\n * @typedef { (event: { hints: any }) => void } CopyPastePasteElementsListener\n */\n\n/**\n * Copy and paste elements.\n *\n * @param {Canvas} canvas\n * @param {Create} create\n * @param {Clipboard} clipboard\n * @param {ElementFactory} elementFactory\n * @param {EventBus} eventBus\n * @param {Modeling} modeling\n * @param {Mouse} mouse\n * @param {Rules} rules\n */\nfunction CopyPaste(\n    canvas,\n    create,\n    clipboard,\n    elementFactory,\n    eventBus,\n    modeling,\n    mouse,\n    rules\n) {\n\n  this._canvas = canvas;\n  this._create = create;\n  this._clipboard = clipboard;\n  this._elementFactory = elementFactory;\n  this._eventBus = eventBus;\n  this._modeling = modeling;\n  this._mouse = mouse;\n  this._rules = rules;\n\n  eventBus.on('copyPaste.copyElement', function(context) {\n    var descriptor = context.descriptor,\n        element = context.element,\n        elements = context.elements;\n\n    // default priority (priority = 1)\n    descriptor.priority = 1;\n\n    descriptor.id = element.id;\n\n    var parentCopied = (0,index_esm/* find */.sE)(elements, function(e) {\n      return e === element.parent;\n    });\n\n    // do NOT reference parent if parent wasn't copied\n    if (parentCopied) {\n      descriptor.parent = element.parent.id;\n    }\n\n    // attachers (priority = 2)\n    if (isAttacher(element)) {\n      descriptor.priority = 2;\n\n      descriptor.host = element.host.id;\n    }\n\n    // connections (priority = 3)\n    if ((0,ModelUtil/* isConnection */.Ho)(element)) {\n      descriptor.priority = 3;\n\n      descriptor.source = element.source.id;\n      descriptor.target = element.target.id;\n\n      descriptor.waypoints = copyWaypoints(element);\n    }\n\n    // labels (priority = 4)\n    if ((0,ModelUtil/* isLabel */.j_)(element)) {\n      descriptor.priority = 4;\n\n      descriptor.labelTarget = element.labelTarget.id;\n    }\n\n    (0,index_esm/* forEach */.Ed)([ 'x', 'y', 'width', 'height' ], function(property) {\n      if ((0,index_esm/* isNumber */.hj)(element[ property ])) {\n        descriptor[ property ] = element[ property ];\n      }\n    });\n\n    descriptor.hidden = element.hidden;\n    descriptor.collapsed = element.collapsed;\n\n  });\n\n  eventBus.on('copyPaste.pasteElements', function(context) {\n    var hints = context.hints;\n\n    (0,index_esm/* assign */.f0)(hints, {\n      createElementsBehavior: false\n    });\n  });\n}\n\nCopyPaste.$inject = [\n  'canvas',\n  'create',\n  'clipboard',\n  'elementFactory',\n  'eventBus',\n  'modeling',\n  'mouse',\n  'rules'\n];\n\n\n/**\n * Copy elements.\n *\n * @param {Element[]} elements\n *\n * @return {Object}\n */\nCopyPaste.prototype.copy = function(elements) {\n  var allowed,\n      tree;\n\n  if (!(0,index_esm/* isArray */.kJ)(elements)) {\n    elements = elements ? [ elements ] : [];\n  }\n\n  allowed = this._eventBus.fire('copyPaste.canCopyElements', {\n    elements: elements\n  });\n\n  if (allowed === false) {\n    tree = {};\n  } else {\n    tree = this.createTree((0,index_esm/* isArray */.kJ)(allowed) ? allowed : elements);\n  }\n\n  // we set an empty tree, selection of elements\n  // to copy was empty.\n  this._clipboard.set(tree);\n\n  this._eventBus.fire('copyPaste.elementsCopied', {\n    elements: elements,\n    tree: tree\n  });\n\n  return tree;\n};\n\n/**\n * Paste elements.\n *\n * @param {Object} [context]\n * @param {Shape} [context.element] The optional parent.\n * @param {Point} [context.point] The optional osition.\n * @param {Object} [context.hints] The optional hints.\n */\nCopyPaste.prototype.paste = function(context) {\n  var tree = this._clipboard.get();\n\n  if (this._clipboard.isEmpty()) {\n    return;\n  }\n\n  var hints = context && context.hints || {};\n\n  this._eventBus.fire('copyPaste.pasteElements', {\n    hints: hints\n  });\n\n  var elements = this._createElements(tree);\n\n  // paste directly\n  if (context && context.element && context.point) {\n    return this._paste(elements, context.element, context.point, hints);\n  }\n\n  this._create.start(this._mouse.getLastMoveEvent(), elements, {\n    hints: hints || {}\n  });\n};\n\n/**\n * Paste elements directly.\n *\n * @param {Element[]} elements\n * @param {Shape} target\n * @param {Point} position\n * @param {Object} [hints]\n */\nCopyPaste.prototype._paste = function(elements, target, position, hints) {\n\n  // make sure each element has x and y\n  (0,index_esm/* forEach */.Ed)(elements, function(element) {\n    if (!(0,index_esm/* isNumber */.hj)(element.x)) {\n      element.x = 0;\n    }\n\n    if (!(0,index_esm/* isNumber */.hj)(element.y)) {\n      element.y = 0;\n    }\n  });\n\n  var bbox = (0,Elements/* getBBox */.jY)(elements);\n\n  // center elements around cursor\n  (0,index_esm/* forEach */.Ed)(elements, function(element) {\n    if ((0,ModelUtil/* isConnection */.Ho)(element)) {\n      element.waypoints = (0,index_esm/* map */.UI)(element.waypoints, function(waypoint) {\n        return {\n          x: waypoint.x - bbox.x - bbox.width / 2,\n          y: waypoint.y - bbox.y - bbox.height / 2\n        };\n      });\n    }\n\n    (0,index_esm/* assign */.f0)(element, {\n      x: element.x - bbox.x - bbox.width / 2,\n      y: element.y - bbox.y - bbox.height / 2\n    });\n  });\n\n  return this._modeling.createElements(elements, position, target, (0,index_esm/* assign */.f0)({}, hints));\n};\n\n/**\n * Create elements from tree.\n */\nCopyPaste.prototype._createElements = function(tree) {\n  var self = this;\n\n  var eventBus = this._eventBus;\n\n  var cache = {};\n\n  var elements = [];\n\n  (0,index_esm/* forEach */.Ed)(tree, function(branch, depth) {\n\n    depth = parseInt(depth, 10);\n\n    // sort by priority\n    branch = (0,index_esm/* sortBy */.MR)(branch, 'priority');\n\n    (0,index_esm/* forEach */.Ed)(branch, function(descriptor) {\n\n      // remove priority\n      var attrs = (0,index_esm/* assign */.f0)({}, (0,index_esm/* omit */.CE)(descriptor, [ 'priority' ]));\n\n      if (cache[ descriptor.parent ]) {\n        attrs.parent = cache[ descriptor.parent ];\n      } else {\n        delete attrs.parent;\n      }\n\n      eventBus.fire('copyPaste.pasteElement', {\n        cache: cache,\n        descriptor: attrs\n      });\n\n      var element;\n\n      if ((0,ModelUtil/* isConnection */.Ho)(attrs)) {\n        attrs.source = cache[ descriptor.source ];\n        attrs.target = cache[ descriptor.target ];\n\n        element = cache[ descriptor.id ] = self.createConnection(attrs);\n\n        elements.push(element);\n\n        return;\n      }\n\n      if ((0,ModelUtil/* isLabel */.j_)(attrs)) {\n        attrs.labelTarget = cache[ attrs.labelTarget ];\n\n        element = cache[ descriptor.id ] = self.createLabel(attrs);\n\n        elements.push(element);\n\n        return;\n      }\n\n      if (attrs.host) {\n        attrs.host = cache[ attrs.host ];\n      }\n\n      element = cache[ descriptor.id ] = self.createShape(attrs);\n\n      elements.push(element);\n    });\n\n  });\n\n  return elements;\n};\n\nCopyPaste.prototype.createConnection = function(attrs) {\n  var connection = this._elementFactory.createConnection((0,index_esm/* omit */.CE)(attrs, [ 'id' ]));\n\n  return connection;\n};\n\nCopyPaste.prototype.createLabel = function(attrs) {\n  var label = this._elementFactory.createLabel((0,index_esm/* omit */.CE)(attrs, [ 'id' ]));\n\n  return label;\n};\n\nCopyPaste.prototype.createShape = function(attrs) {\n  var shape = this._elementFactory.createShape((0,index_esm/* omit */.CE)(attrs, [ 'id' ]));\n\n  return shape;\n};\n\n/**\n * Check wether element has relations to other elements e.g. attachers, labels and connections.\n *\n * @param {Object} element\n * @param {Element[]} elements\n *\n * @return {boolean}\n */\nCopyPaste.prototype.hasRelations = function(element, elements) {\n  var labelTarget,\n      source,\n      target;\n\n  if ((0,ModelUtil/* isConnection */.Ho)(element)) {\n    source = (0,index_esm/* find */.sE)(elements, (0,index_esm/* matchPattern */.KQ)({ id: element.source.id }));\n    target = (0,index_esm/* find */.sE)(elements, (0,index_esm/* matchPattern */.KQ)({ id: element.target.id }));\n\n    if (!source || !target) {\n      return false;\n    }\n  }\n\n  if ((0,ModelUtil/* isLabel */.j_)(element)) {\n    labelTarget = (0,index_esm/* find */.sE)(elements, (0,index_esm/* matchPattern */.KQ)({ id: element.labelTarget.id }));\n\n    if (!labelTarget) {\n      return false;\n    }\n  }\n\n  return true;\n};\n\n/**\n * Create a tree-like structure from elements.\n *\n * @example\n *\n * ```javascript\n * tree: {\n *  0: [\n *    { id: 'Shape_1', priority: 1, ... },\n *    { id: 'Shape_2', priority: 1, ... },\n *    { id: 'Connection_1', source: 'Shape_1', target: 'Shape_2', priority: 3, ... },\n *    ...\n *  ],\n *  1: [\n *    { id: 'Shape_3', parent: 'Shape1', priority: 1, ... },\n *    ...\n *  ]\n * };\n * ```\n *\n * @param {Element[]} elements\n *\n * @return {Object}\n */\nCopyPaste.prototype.createTree = function(elements) {\n  var rules = this._rules,\n      self = this;\n\n  var tree = {},\n      elementsData = [];\n\n  var parents = (0,Elements/* getParents */.cd)(elements);\n\n  function canCopy(element, elements) {\n    return rules.allowed('element.copy', {\n      element: element,\n      elements: elements\n    });\n  }\n\n  function addElementData(element, depth) {\n\n    // (1) check wether element has already been added\n    var foundElementData = (0,index_esm/* find */.sE)(elementsData, function(elementsData) {\n      return element === elementsData.element;\n    });\n\n    // (2) add element if not already added\n    if (!foundElementData) {\n      elementsData.push({\n        element: element,\n        depth: depth\n      });\n\n      return;\n    }\n\n    // (3) update depth\n    if (foundElementData.depth < depth) {\n      elementsData = removeElementData(foundElementData, elementsData);\n\n      elementsData.push({\n        element: foundElementData.element,\n        depth: depth\n      });\n    }\n  }\n\n  function removeElementData(elementData, elementsData) {\n    var index = elementsData.indexOf(elementData);\n\n    if (index !== -1) {\n      elementsData.splice(index, 1);\n    }\n\n    return elementsData;\n  }\n\n  // (1) add elements\n  (0,Elements/* eachElement */.om)(parents, function(element, _index, depth) {\n\n    // do NOT add external labels directly\n    if ((0,ModelUtil/* isLabel */.j_)(element)) {\n      return;\n    }\n\n    // always copy external labels\n    (0,index_esm/* forEach */.Ed)(element.labels, function(label) {\n      addElementData(label, depth);\n    });\n\n    function addRelatedElements(elements) {\n      elements && elements.length && (0,index_esm/* forEach */.Ed)(elements, function(element) {\n\n        // add external labels\n        (0,index_esm/* forEach */.Ed)(element.labels, function(label) {\n          addElementData(label, depth);\n        });\n\n        addElementData(element, depth);\n      });\n    }\n\n    (0,index_esm/* forEach */.Ed)([ element.attachers, element.incoming, element.outgoing ], addRelatedElements);\n\n    addElementData(element, depth);\n\n    var children = [];\n\n    if (element.children) {\n      children = element.children.slice();\n    }\n\n    // allow others to add children to tree\n    self._eventBus.fire('copyPaste.createTree', {\n      element: element,\n      children: children\n    });\n\n    return children;\n  });\n\n  elements = (0,index_esm/* map */.UI)(elementsData, function(elementData) {\n    return elementData.element;\n  });\n\n  // (2) copy elements\n  elementsData = (0,index_esm/* map */.UI)(elementsData, function(elementData) {\n    elementData.descriptor = {};\n\n    self._eventBus.fire('copyPaste.copyElement', {\n      descriptor: elementData.descriptor,\n      element: elementData.element,\n      elements: elements\n    });\n\n    return elementData;\n  });\n\n  // (3) sort elements by priority\n  elementsData = (0,index_esm/* sortBy */.MR)(elementsData, function(elementData) {\n    return elementData.descriptor.priority;\n  });\n\n  elements = (0,index_esm/* map */.UI)(elementsData, function(elementData) {\n    return elementData.element;\n  });\n\n  // (4) create tree\n  (0,index_esm/* forEach */.Ed)(elementsData, function(elementData) {\n    var depth = elementData.depth;\n\n    if (!self.hasRelations(elementData.element, elements)) {\n      removeElement(elementData.element, elements);\n\n      return;\n    }\n\n    if (!canCopy(elementData.element, elements)) {\n      removeElement(elementData.element, elements);\n\n      return;\n    }\n\n    if (!tree[depth]) {\n      tree[depth] = [];\n    }\n\n    tree[depth].push(elementData.descriptor);\n  });\n\n  return tree;\n};\n\n// helpers //////////\n\nfunction isAttacher(element) {\n  return !!element.host;\n}\n\nfunction copyWaypoints(element) {\n  return (0,index_esm/* map */.UI)(element.waypoints, function(waypoint) {\n\n    waypoint = copyWaypoint(waypoint);\n\n    if (waypoint.original) {\n      waypoint.original = copyWaypoint(waypoint.original);\n    }\n\n    return waypoint;\n  });\n}\n\nfunction copyWaypoint(waypoint) {\n  return (0,index_esm/* assign */.f0)({}, waypoint);\n}\n\nfunction removeElement(element, elements) {\n  var index = elements.indexOf(element);\n\n  if (index === -1) {\n    return elements;\n  }\n\n  return elements.splice(index, 1);\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/copy-paste/index.js\n\n\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const copy_paste = ({\n  __depends__: [\n    clipboard,\n    create/* default */.Z,\n    mouse/* default */.Z,\n    rules/* default */.Z\n  ],\n  __init__: [ 'copyPaste' ],\n  copyPaste: [ 'type', CopyPaste ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/copy-paste/index.js_+_3_modules?")},"./node_modules/diagram-js/lib/features/create/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ create)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/dragging/index.js + 3 modules\nvar dragging = __webpack_require__(\"./node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/preview-support/index.js + 1 modules\nvar preview_support = __webpack_require__(\"./node_modules/diagram-js/lib/features/preview-support/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/ModelUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/create/Create.js\nvar MARKER_OK = 'drop-ok',\n    MARKER_NOT_OK = 'drop-not-ok',\n    MARKER_ATTACH = 'attach-ok',\n    MARKER_NEW_PARENT = 'new-parent';\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Types').ElementLike} Element\n * @typedef {import('../../core/Types').ShapeLike} Shape\n *\n * @typedef {import('../../util/Types').Point} Point\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../dragging/Dragging').default} Dragging\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../modeling/Modeling').default} Modeling\n * @typedef {import('../rules/Rules').default} Rules\n */\n\nvar PREFIX = 'create';\n\nvar HIGH_PRIORITY = 2000;\n\n\n/**\n * Create new elements through drag and drop.\n *\n * @param {Canvas} canvas\n * @param {Dragging} dragging\n * @param {EventBus} eventBus\n * @param {Modeling} modeling\n * @param {Rules} rules\n */\nfunction Create(\n    canvas,\n    dragging,\n    eventBus,\n    modeling,\n    rules\n) {\n\n  // rules //////////\n\n  /**\n   * Check wether elements can be created.\n   *\n   * @param {Element[]} elements\n   * @param {Shape} target\n   * @param {Point} position\n   * @param {Element} [source]\n   *\n   * @return {boolean|null|Object}\n   */\n  function canCreate(elements, target, position, source, hints) {\n    if (!target) {\n      return false;\n    }\n\n    // ignore child elements and external labels\n    elements = (0,index_esm/* filter */.hX)(elements, function(element) {\n      var labelTarget = element.labelTarget;\n\n      return !element.parent && !((0,ModelUtil/* isLabel */.j_)(element) && elements.indexOf(labelTarget) !== -1);\n    });\n\n    var shape = (0,index_esm/* find */.sE)(elements, function(element) {\n      return !(0,ModelUtil/* isConnection */.Ho)(element);\n    });\n\n    var attach = false,\n        connect = false,\n        create = false;\n\n    // (1) attaching single shapes\n    if (isSingleShape(elements)) {\n      attach = rules.allowed('shape.attach', {\n        position: position,\n        shape: shape,\n        target: target\n      });\n    }\n\n    if (!attach) {\n\n      // (2) creating elements\n      if (isSingleShape(elements)) {\n        create = rules.allowed('shape.create', {\n          position: position,\n          shape: shape,\n          source: source,\n          target: target\n        });\n      } else {\n        create = rules.allowed('elements.create', {\n          elements: elements,\n          position: position,\n          target: target\n        });\n      }\n\n    }\n\n    var connectionTarget = hints.connectionTarget;\n\n    // (3) appending single shapes\n    if (create || attach) {\n      if (shape && source) {\n        connect = rules.allowed('connection.create', {\n          source: connectionTarget === source ? shape : source,\n          target: connectionTarget === source ? source : shape,\n          hints: {\n            targetParent: target,\n            targetAttach: attach\n          }\n        });\n      }\n\n      return {\n        attach: attach,\n        connect: connect\n      };\n    }\n\n    // ignore wether or not elements can be created\n    if (create === null || attach === null) {\n      return null;\n    }\n\n    return false;\n  }\n\n  function setMarker(element, marker) {\n    [ MARKER_ATTACH, MARKER_OK, MARKER_NOT_OK, MARKER_NEW_PARENT ].forEach(function(m) {\n\n      if (m === marker) {\n        canvas.addMarker(element, m);\n      } else {\n        canvas.removeMarker(element, m);\n      }\n    });\n  }\n\n  // event handling //////////\n\n  eventBus.on([ 'create.move', 'create.hover' ], function(event) {\n    var context = event.context,\n        elements = context.elements,\n        hover = event.hover,\n        source = context.source,\n        hints = context.hints || {};\n\n    if (!hover) {\n      context.canExecute = false;\n      context.target = null;\n\n      return;\n    }\n\n    ensureConstraints(event);\n\n    var position = {\n      x: event.x,\n      y: event.y\n    };\n\n    var canExecute = context.canExecute = hover && canCreate(elements, hover, position, source, hints);\n\n    if (hover && canExecute !== null) {\n      context.target = hover;\n\n      if (canExecute && canExecute.attach) {\n        setMarker(hover, MARKER_ATTACH);\n      } else {\n        setMarker(hover, canExecute ? MARKER_NEW_PARENT : MARKER_NOT_OK);\n      }\n    }\n  });\n\n  eventBus.on([ 'create.end', 'create.out', 'create.cleanup' ], function(event) {\n    var hover = event.hover;\n\n    if (hover) {\n      setMarker(hover, null);\n    }\n  });\n\n  eventBus.on('create.end', function(event) {\n    var context = event.context,\n        source = context.source,\n        shape = context.shape,\n        elements = context.elements,\n        target = context.target,\n        canExecute = context.canExecute,\n        attach = canExecute && canExecute.attach,\n        connect = canExecute && canExecute.connect,\n        hints = context.hints || {};\n\n    if (canExecute === false || !target) {\n      return false;\n    }\n\n    ensureConstraints(event);\n\n    var position = {\n      x: event.x,\n      y: event.y\n    };\n\n    if (connect) {\n      shape = modeling.appendShape(source, shape, position, target, {\n        attach: attach,\n        connection: connect === true ? {} : connect,\n        connectionTarget: hints.connectionTarget\n      });\n    } else {\n      elements = modeling.createElements(elements, position, target, (0,index_esm/* assign */.f0)({}, hints, {\n        attach: attach\n      }));\n\n      // update shape\n      shape = (0,index_esm/* find */.sE)(elements, function(element) {\n        return !(0,ModelUtil/* isConnection */.Ho)(element);\n      });\n    }\n\n    // update elements and shape\n    (0,index_esm/* assign */.f0)(context, {\n      elements: elements,\n      shape: shape\n    });\n\n    (0,index_esm/* assign */.f0)(event, {\n      elements: elements,\n      shape: shape\n    });\n  });\n\n  function cancel() {\n    var context = dragging.context();\n\n    if (context && context.prefix === PREFIX) {\n      dragging.cancel();\n    }\n  }\n\n  // cancel on <elements.changed> that is not result of <drag.end>\n  eventBus.on('create.init', function() {\n    eventBus.on('elements.changed', cancel);\n\n    eventBus.once([ 'create.cancel', 'create.end' ], HIGH_PRIORITY, function() {\n      eventBus.off('elements.changed', cancel);\n    });\n  });\n\n  // API //////////\n\n  this.start = function(event, elements, context) {\n    if (!(0,index_esm/* isArray */.kJ)(elements)) {\n      elements = [ elements ];\n    }\n\n    var shape = (0,index_esm/* find */.sE)(elements, function(element) {\n      return !(0,ModelUtil/* isConnection */.Ho)(element);\n    });\n\n    if (!shape) {\n\n      // at least one shape is required\n      return;\n    }\n\n    context = (0,index_esm/* assign */.f0)({\n      elements: elements,\n      hints: {},\n      shape: shape\n    }, context || {});\n\n    // make sure each element has x and y\n    (0,index_esm/* forEach */.Ed)(elements, function(element) {\n      if (!(0,index_esm/* isNumber */.hj)(element.x)) {\n        element.x = 0;\n      }\n\n      if (!(0,index_esm/* isNumber */.hj)(element.y)) {\n        element.y = 0;\n      }\n    });\n\n    var visibleElements = (0,index_esm/* filter */.hX)(elements, function(element) {\n      return !element.hidden;\n    });\n\n    var bbox = (0,Elements/* getBBox */.jY)(visibleElements);\n\n    // center elements around cursor\n    (0,index_esm/* forEach */.Ed)(elements, function(element) {\n      if ((0,ModelUtil/* isConnection */.Ho)(element)) {\n        element.waypoints = (0,index_esm/* map */.UI)(element.waypoints, function(waypoint) {\n          return {\n            x: waypoint.x - bbox.x - bbox.width / 2,\n            y: waypoint.y - bbox.y - bbox.height / 2\n          };\n        });\n      }\n\n      (0,index_esm/* assign */.f0)(element, {\n        x: element.x - bbox.x - bbox.width / 2,\n        y: element.y - bbox.y - bbox.height / 2\n      });\n    });\n\n    dragging.init(event, PREFIX, {\n      cursor: 'grabbing',\n      autoActivate: true,\n      data: {\n        shape: shape,\n        elements: elements,\n        context: context\n      }\n    });\n  };\n}\n\nCreate.$inject = [\n  'canvas',\n  'dragging',\n  'eventBus',\n  'modeling',\n  'rules'\n];\n\n// helpers //////////\n\nfunction ensureConstraints(event) {\n  var context = event.context,\n      createConstraints = context.createConstraints;\n\n  if (!createConstraints) {\n    return;\n  }\n\n  if (createConstraints.left) {\n    event.x = Math.max(event.x, createConstraints.left);\n  }\n\n  if (createConstraints.right) {\n    event.x = Math.min(event.x, createConstraints.right);\n  }\n\n  if (createConstraints.top) {\n    event.y = Math.max(event.y, createConstraints.top);\n  }\n\n  if (createConstraints.bottom) {\n    event.y = Math.min(event.y, createConstraints.bottom);\n  }\n}\n\nfunction isSingleShape(elements) {\n  return elements && elements.length === 1 && !(0,ModelUtil/* isConnection */.Ho)(elements[ 0 ]);\n}\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/SvgTransformUtil.js\nvar SvgTransformUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/SvgTransformUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/GraphicsUtil.js\nvar GraphicsUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/GraphicsUtil.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/create/CreatePreview.js\n\r\n\r\n\r\n\r\n\r\n\r\n/**\r\n * @typedef {import('../../core/Canvas').default} Canvas\r\n * @typedef {import('../../core/EventBus').default} EventBus\r\n * @typedef {import('../../core/GraphicsFactory').default} GraphicsFactory\r\n * @typedef {import('../preview-support/PreviewSupport').default} PreviewSupport\r\n * @typedef {import('../../draw/Styles').default} Styles\r\n */\r\n\r\nvar LOW_PRIORITY = 750;\r\n\r\n/**\r\n * @param {Canvas} canvas\r\n * @param {EventBus} eventBus\r\n * @param {GraphicsFactory} graphicsFactory\r\n * @param {PreviewSupport} previewSupport\r\n * @param {Styles} styles\r\n */\r\nfunction CreatePreview(\r\n    canvas,\r\n    eventBus,\r\n    graphicsFactory,\r\n    previewSupport,\r\n    styles\r\n) {\r\n  function createDragGroup(elements) {\r\n    var dragGroup = (0,dist_index_esm/* create */.Ue)('g');\r\n\r\n    (0,dist_index_esm/* attr */.Lj)(dragGroup, styles.cls('djs-drag-group', [ 'no-events' ]));\r\n\r\n    var childrenGfx = (0,dist_index_esm/* create */.Ue)('g');\r\n\r\n    elements.forEach(function(element) {\r\n\r\n      // create graphics\r\n      var gfx;\r\n\r\n      if (element.hidden) {\r\n        return;\r\n      }\r\n\r\n      if (element.waypoints) {\r\n        gfx = graphicsFactory._createContainer('connection', childrenGfx);\r\n\r\n        graphicsFactory.drawConnection((0,GraphicsUtil/* getVisual */.s)(gfx), element);\r\n      } else {\r\n        gfx = graphicsFactory._createContainer('shape', childrenGfx);\r\n\r\n        graphicsFactory.drawShape((0,GraphicsUtil/* getVisual */.s)(gfx), element);\r\n\r\n        (0,SvgTransformUtil/* translate */.Iu)(gfx, element.x, element.y);\r\n      }\r\n\r\n      // add preview\r\n      previewSupport.addDragger(element, dragGroup, gfx);\r\n    });\r\n\r\n    return dragGroup;\r\n  }\r\n\r\n  eventBus.on('create.move', LOW_PRIORITY, function(event) {\r\n\r\n    var hover = event.hover,\r\n        context = event.context,\r\n        elements = context.elements,\r\n        dragGroup = context.dragGroup;\r\n\r\n    // lazily create previews\r\n    if (!dragGroup) {\r\n      dragGroup = context.dragGroup = createDragGroup(elements);\r\n    }\r\n\r\n    var activeLayer;\r\n\r\n    if (hover) {\r\n      if (!dragGroup.parentNode) {\r\n        activeLayer = canvas.getActiveLayer();\r\n\r\n        (0,dist_index_esm/* append */.R3)(activeLayer, dragGroup);\r\n      }\r\n\r\n      (0,SvgTransformUtil/* translate */.Iu)(dragGroup, event.x, event.y);\r\n    } else {\r\n      (0,dist_index_esm/* remove */.Od)(dragGroup);\r\n    }\r\n  });\r\n\r\n  eventBus.on('create.cleanup', function(event) {\r\n    var context = event.context,\r\n        dragGroup = context.dragGroup;\r\n\r\n    if (dragGroup) {\r\n      (0,dist_index_esm/* remove */.Od)(dragGroup);\r\n    }\r\n  });\r\n}\r\n\r\nCreatePreview.$inject = [\r\n  'canvas',\r\n  'eventBus',\r\n  'graphicsFactory',\r\n  'previewSupport',\r\n  'styles'\r\n];\r\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/create/index.js\n\n\n\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const create = ({\n  __depends__: [\n    dragging/* default */.Z,\n    preview_support/* default */.Z,\n    rules/* default */.Z,\n    selection/* default */.Z\n  ],\n  __init__: [\n    'create',\n    'createPreview'\n  ],\n  create: [ 'type', Create ],\n  createPreview: [ 'type', CreatePreview ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/create/index.js_+_2_modules?")},"./node_modules/diagram-js/lib/features/distribute-elements/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ distribute_elements)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/distribute-elements/DistributeElements.js\n\n\n/**\n * @typedef {import('../../model/Types').Element} Element\n *\n * @typedef {import('../../util/Types').Axis} Axis\n * @typedef {import('../../util/Types').Dimension} Dimension\n * @typedef {import('../../util/Types').Rect} Rect\n *\n * @typedef {import('../modeling/Modeling').default} Modeling\n * @typedef {import('../rules/Rules').default} Rules\n *\n * @typedef { {\n *   min: number;\n *   max: number;\n * } } Range\n *\n * @typedef { {\n *   elements: Element[];\n *   range: Range;\n * } } Group\n */\n\nvar AXIS_DIMENSIONS = {\n  horizontal: [ 'x', 'width' ],\n  vertical: [ 'y', 'height' ]\n};\n\nvar THRESHOLD = 5;\n\n\n/**\n * Groups and filters elements and then trigger even distribution.\n *\n * @param {Modeling} modeling\n * @param {Rules} rules\n */\nfunction DistributeElements(modeling, rules) {\n  this._modeling = modeling;\n\n  this._filters = [];\n\n  this.registerFilter(function(elements) {\n    var allowed = rules.allowed('elements.distribute', { elements: elements });\n\n    if ((0,index_esm/* isArray */.kJ)(allowed)) {\n      return allowed;\n    }\n\n    return allowed ? elements : [];\n  });\n}\n\nDistributeElements.$inject = [ 'modeling', 'rules' ];\n\n\n/**\n * Registers filter functions that allow external parties to filter\n * out certain elements.\n *\n * @param {(distributableElements: Element[], axis: Axis, dimension: Dimension) => Element[]} filterFn\n */\nDistributeElements.prototype.registerFilter = function(filterFn) {\n  if (typeof filterFn !== 'function') {\n    throw new Error('the filter has to be a function');\n  }\n\n  this._filters.push(filterFn);\n};\n\n/**\n * Distributes the elements with a given orientation\n *\n * @param {Element[]} elements\n * @param {string} orientation\n */\nDistributeElements.prototype.trigger = function(elements, orientation) {\n  var modeling = this._modeling;\n\n  var groups,\n      distributableElements;\n\n  if (elements.length < 3) {\n    return;\n  }\n\n  this._setOrientation(orientation);\n\n  distributableElements = this._filterElements(elements);\n\n  groups = this._createGroups(distributableElements);\n\n  // nothing to distribute\n  if (groups.length <= 2) {\n    return;\n  }\n\n  modeling.distributeElements(groups, this._axis, this._dimension);\n\n  return groups;\n};\n\n/**\n * Filters the elements with provided filters by external parties\n *\n * @param {Element[]} elements\n *\n * @return {Element[]}\n */\nDistributeElements.prototype._filterElements = function(elements) {\n  var filters = this._filters,\n      axis = this._axis,\n      dimension = this._dimension,\n      distributableElements = [].concat(elements);\n\n  if (!filters.length) {\n    return elements;\n  }\n\n  (0,index_esm/* forEach */.Ed)(filters, function(filterFn) {\n    distributableElements = filterFn(distributableElements, axis, dimension);\n  });\n\n  return distributableElements;\n};\n\n\n/**\n * Create range (min, max) groups. Also tries to group elements\n * together that share the same range.\n *\n * @example\n *\n * ```javascript\n *   const groups = [\n *     {\n *       range: { min: 100, max: 200 },\n *       elements: [ { id: 'shape1', ... } ]\n *     }\n *   ]\n * ```\n *\n * @param {Element[]} elements\n *\n * @return {Group[]}\n */\nDistributeElements.prototype._createGroups = function(elements) {\n  var rangeGroups = [],\n      self = this,\n      axis = this._axis,\n      dimension = this._dimension;\n\n  if (!axis) {\n    throw new Error('must have a defined \"axis\" and \"dimension\"');\n  }\n\n  // sort by 'left->right' or 'top->bottom'\n  var sortedElements = (0,index_esm/* sortBy */.MR)(elements, axis);\n\n  (0,index_esm/* forEach */.Ed)(sortedElements, function(element, idx) {\n    var elementRange = self._findRange(element, axis, dimension),\n        range;\n\n    var previous = rangeGroups[rangeGroups.length - 1];\n\n    if (previous && self._hasIntersection(previous.range, elementRange)) {\n      rangeGroups[rangeGroups.length - 1].elements.push(element);\n    } else {\n      range = { range: elementRange, elements: [ element ] };\n\n      rangeGroups.push(range);\n    }\n  });\n\n  return rangeGroups;\n};\n\n\n/**\n * Maps a direction to the according axis and dimension.\n *\n * @param {'horizontal' | 'vertical'} direction 'horizontal' or 'vertical'\n */\nDistributeElements.prototype._setOrientation = function(direction) {\n  var orientation = AXIS_DIMENSIONS[direction];\n\n  this._axis = orientation[0];\n  this._dimension = orientation[1];\n};\n\n\n/**\n * Checks if the two ranges intercept each other.\n *\n * @param {Range} rangeA\n * @param {Range} rangeB\n *\n * @return {boolean}\n */\nDistributeElements.prototype._hasIntersection = function(rangeA, rangeB) {\n  return Math.max(rangeA.min, rangeA.max) >= Math.min(rangeB.min, rangeB.max) &&\n         Math.min(rangeA.min, rangeA.max) <= Math.max(rangeB.min, rangeB.max);\n};\n\n\n/**\n * Returns the min and max values for an element\n *\n * @param {Element} element\n *\n * @return {Range}\n */\nDistributeElements.prototype._findRange = function(element) {\n  var axis = element[this._axis],\n      dimension = element[this._dimension];\n\n  return {\n    min: axis + THRESHOLD,\n    max: axis + dimension - THRESHOLD\n  };\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/distribute-elements/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const distribute_elements = ({\n  __init__: [ 'distributeElements' ],\n  distributeElements: [ 'type', DistributeElements ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/distribute-elements/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/dragging/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ dragging)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Event.js\nvar Event = __webpack_require__(\"./node_modules/diagram-js/lib/util/Event.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/hover-fix/HoverFix.js\n\n\n\n\n/**\n * @typedef {import('didi').Injector} Injector\n *\n * @typedef {import('../../core/ElementRegistry').default} ElementRegistry\n * @typedef {import('../../core/EventBus').default} EventBus\n */\n\nvar HIGH_PRIORITY = 1500;\n\n\n/**\n * Browsers may swallow certain events (hover, out ...) if users are to\n * fast with the mouse.\n *\n * @see http://stackoverflow.com/questions/7448468/why-cant-i-reliably-capture-a-mouseout-event\n *\n * The fix implemented in this component ensure that we\n *\n * 1) have a hover state after a successful drag.move event\n * 2) have an out event when dragging leaves an element\n *\n * @param {ElementRegistry} elementRegistry\n * @param {EventBus} eventBus\n * @param {Injector} injector\n */\nfunction HoverFix(elementRegistry, eventBus, injector) {\n\n  var self = this;\n\n  var dragging = injector.get('dragging', false);\n\n  /**\n   * Make sure we are god damn hovering!\n   *\n   * @param {Event} dragging event\n   */\n  function ensureHover(event) {\n\n    if (event.hover) {\n      return;\n    }\n\n    var originalEvent = event.originalEvent;\n\n    var gfx = self._findTargetGfx(originalEvent);\n\n    var element = gfx && elementRegistry.get(gfx);\n\n    if (gfx && element) {\n\n      // 1) cancel current mousemove\n      event.stopPropagation();\n\n      // 2) emit fake hover for new target\n      dragging.hover({ element: element, gfx: gfx });\n\n      // 3) re-trigger move event\n      dragging.move(originalEvent);\n    }\n  }\n\n\n  if (dragging) {\n\n    /**\n     * We wait for a specific sequence of events before\n     * emitting a fake drag.hover event.\n     *\n     * Event Sequence:\n     *\n     * drag.start\n     * drag.move >> ensure we are hovering\n     */\n    eventBus.on('drag.start', function(event) {\n\n      eventBus.once('drag.move', HIGH_PRIORITY, function(event) {\n\n        ensureHover(event);\n\n      });\n\n    });\n  }\n\n\n  /**\n   * We make sure that element.out is always fired, even if the\n   * browser swallows an element.out event.\n   *\n   * Event sequence:\n   *\n   * element.hover\n   * (element.out >> sometimes swallowed)\n   * element.hover >> ensure we fired element.out\n   */\n  (function() {\n    var hoverGfx;\n    var hover;\n\n    eventBus.on('element.hover', function(event) {\n\n      // (1) remember current hover element\n      hoverGfx = event.gfx;\n      hover = event.element;\n    });\n\n    eventBus.on('element.hover', HIGH_PRIORITY, function(event) {\n\n      // (3) am I on an element still?\n      if (hover) {\n\n        // (4) that is a problem, gotta \"simulate the out\"\n        eventBus.fire('element.out', {\n          element: hover,\n          gfx: hoverGfx\n        });\n      }\n\n    });\n\n    eventBus.on('element.out', function() {\n\n      // (2) unset hover state if we correctly outed us *GG*\n      hoverGfx = null;\n      hover = null;\n    });\n\n  })();\n\n  this._findTargetGfx = function(event) {\n    var position,\n        target;\n\n    if (!(event instanceof MouseEvent)) {\n      return;\n    }\n\n    position = (0,Event/* toPoint */.jt)(event);\n\n    // damn expensive operation, ouch!\n    target = document.elementFromPoint(position.x, position.y);\n\n    return getGfx(target);\n  };\n\n}\n\nHoverFix.$inject = [\n  'elementRegistry',\n  'eventBus',\n  'injector'\n];\n\n\n// helpers /////////////////////\n\nfunction getGfx(target) {\n  return (0,index_esm/* closest */.oq)(target, 'svg, .djs-element', true);\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/hover-fix/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const hover_fix = ({\n  __init__: [\n    'hoverFix'\n  ],\n  hoverFix: [ 'type', HoverFix ],\n});\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Cursor.js\nvar Cursor = __webpack_require__(\"./node_modules/diagram-js/lib/util/Cursor.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/ClickTrap.js\nvar ClickTrap = __webpack_require__(\"./node_modules/diagram-js/lib/util/ClickTrap.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/PositionUtil.js\nvar PositionUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/PositionUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\nvar KeyboardUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/dragging/Dragging.js\nvar round = Math.round;\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../util/Types').Point} Point\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/ElementRegistry').default} ElementRegistry\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../selection/Selection').default} Selection\n */\n\nvar DRAG_ACTIVE_CLS = 'djs-drag-active';\n\n\nfunction preventDefault(event) {\n  event.preventDefault();\n}\n\nfunction isTouchEvent(event) {\n\n  // check for TouchEvent being available first\n  // (i.e. not available on desktop Firefox)\n  return typeof TouchEvent !== 'undefined' && event instanceof TouchEvent;\n}\n\nfunction getLength(point) {\n  return Math.sqrt(Math.pow(point.x, 2) + Math.pow(point.y, 2));\n}\n\n/**\n * A helper that fires canvas localized drag events and realizes\n * the general \"drag-and-drop\" look and feel.\n *\n * Calling {@link Dragging#activate} activates dragging on a canvas.\n *\n * It provides the following:\n *\n *   * emits life cycle events, namespaced with a prefix assigned\n *     during dragging activation\n *   * sets and restores the cursor\n *   * sets and restores the selection if elements still exist\n *   * ensures there can be only one drag operation active at a time\n *\n * Dragging may be canceled manually by calling {@link Dragging#cancel}\n * or by pressing ESC.\n *\n *\n * ## Life-cycle events\n *\n * Dragging can be in three different states, off, initialized\n * and active.\n *\n * (1) off: no dragging operation is in progress\n * (2) initialized: a new drag operation got initialized but not yet\n *                  started (i.e. because of no initial move)\n * (3) started: dragging is in progress\n *\n * Eventually dragging will be off again after a drag operation has\n * been ended or canceled via user click or ESC key press.\n *\n * To indicate transitions between these states dragging emits generic\n * life-cycle events with the `drag.` prefix _and_ events namespaced\n * to a prefix choosen by a user during drag initialization.\n *\n * The following events are emitted (appropriately prefixed) via\n * the {@link EventBus}.\n *\n * * `init`\n * * `start`\n * * `move`\n * * `end`\n * * `ended` (dragging already in off state)\n * * `cancel` (only if previously started)\n * * `canceled` (dragging already in off state, only if previously started)\n * * `cleanup`\n *\n *\n * @example\n *\n * ```javascript\n * function MyDragComponent(eventBus, dragging) {\n *\n *   eventBus.on('mydrag.start', function(event) {\n *     console.log('yes, we start dragging');\n *   });\n *\n *   eventBus.on('mydrag.move', function(event) {\n *     console.log('canvas local coordinates', event.x, event.y, event.dx, event.dy);\n *\n *     // local drag data is passed with the event\n *     event.context.foo; // \"BAR\"\n *\n *     // the original mouse event, too\n *     event.originalEvent; // MouseEvent(...)\n *   });\n *\n *   eventBus.on('element.click', function(event) {\n *     dragging.init(event, 'mydrag', {\n *       cursor: 'grabbing',\n *       data: {\n *         context: {\n *           foo: \"BAR\"\n *         }\n *       }\n *     });\n *   });\n * }\n * ```\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {Selection} selection\n * @param {ElementRegistry} elementRegistry\n */\nfunction Dragging(eventBus, canvas, selection, elementRegistry) {\n\n  var defaultOptions = {\n    threshold: 5,\n    trapClick: true\n  };\n\n  // the currently active drag operation\n  // dragging is active as soon as this context exists.\n  //\n  // it is visually _active_ only when a context.active flag is set to true.\n  var context;\n\n  /* convert a global event into local coordinates */\n  function toLocalPoint(globalPosition) {\n\n    var viewbox = canvas.viewbox();\n\n    var clientRect = canvas._container.getBoundingClientRect();\n\n    return {\n      x: viewbox.x + (globalPosition.x - clientRect.left) / viewbox.scale,\n      y: viewbox.y + (globalPosition.y - clientRect.top) / viewbox.scale\n    };\n  }\n\n  // helpers\n\n  function fire(type, dragContext) {\n    dragContext = dragContext || context;\n\n    var event = eventBus.createEvent(\n      (0,dist_index_esm/* assign */.f0)(\n        {},\n        dragContext.payload,\n        dragContext.data,\n        { isTouch: dragContext.isTouch }\n      )\n    );\n\n    // default integration\n    if (eventBus.fire('drag.' + type, event) === false) {\n      return false;\n    }\n\n    return eventBus.fire(dragContext.prefix + '.' + type, event);\n  }\n\n  function restoreSelection(previousSelection) {\n    var existingSelection = previousSelection.filter(function(element) {\n      return elementRegistry.get(element.id);\n    });\n\n    existingSelection.length && selection.select(existingSelection);\n  }\n\n  // event listeners\n\n  function move(event, activate) {\n    var payload = context.payload,\n        displacement = context.displacement;\n\n    var globalStart = context.globalStart,\n        globalCurrent = (0,Event/* toPoint */.jt)(event),\n        globalDelta = (0,PositionUtil/* delta */.p)(globalCurrent, globalStart);\n\n    var localStart = context.localStart,\n        localCurrent = toLocalPoint(globalCurrent),\n        localDelta = (0,PositionUtil/* delta */.p)(localCurrent, localStart);\n\n\n    // activate context explicitly or once threshold is reached\n    if (!context.active && (activate || getLength(globalDelta) > context.threshold)) {\n\n      // fire start event with original\n      // starting coordinates\n\n      (0,dist_index_esm/* assign */.f0)(payload, {\n        x: round(localStart.x + displacement.x),\n        y: round(localStart.y + displacement.y),\n        dx: 0,\n        dy: 0\n      }, { originalEvent: event });\n\n      if (false === fire('start')) {\n        return cancel();\n      }\n\n      context.active = true;\n\n      // unset selection and remember old selection\n      // the previous (old) selection will always passed\n      // with the event via the event.previousSelection property\n      if (!context.keepSelection) {\n        payload.previousSelection = selection.get();\n        selection.select(null);\n      }\n\n      // allow custom cursor\n      if (context.cursor) {\n        (0,Cursor/* set */.t8)(context.cursor);\n      }\n\n      // indicate dragging via marker on root element\n      canvas.addMarker(canvas.getRootElement(), DRAG_ACTIVE_CLS);\n    }\n\n    (0,Event/* stopPropagation */.UW)(event);\n\n    if (context.active) {\n\n      // update payload with actual coordinates\n      (0,dist_index_esm/* assign */.f0)(payload, {\n        x: round(localCurrent.x + displacement.x),\n        y: round(localCurrent.y + displacement.y),\n        dx: round(localDelta.x),\n        dy: round(localDelta.y)\n      }, { originalEvent: event });\n\n      // emit move event\n      fire('move');\n    }\n  }\n\n  function end(event) {\n    var previousContext,\n        returnValue = true;\n\n    if (context.active) {\n\n      if (event) {\n        context.payload.originalEvent = event;\n\n        // suppress original event (click, ...)\n        // because we just ended a drag operation\n        (0,Event/* stopPropagation */.UW)(event);\n      }\n\n      // implementations may stop restoring the\n      // original state (selections, ...) by preventing the\n      // end events default action\n      returnValue = fire('end');\n    }\n\n    if (returnValue === false) {\n      fire('rejected');\n    }\n\n    previousContext = cleanup(returnValue !== true);\n\n    // last event to be fired when all drag operations are done\n    // at this point in time no drag operation is in progress anymore\n    fire('ended', previousContext);\n  }\n\n\n  // cancel active drag operation if the user presses\n  // the ESC key on the keyboard\n\n  function checkCancel(event) {\n\n    if ((0,KeyboardUtil/* isKey */.ot)('Escape', event)) {\n      preventDefault(event);\n\n      cancel();\n    }\n  }\n\n\n  // prevent ghost click that might occur after a finished\n  // drag and drop session\n\n  function trapClickAndEnd(event) {\n\n    var untrap;\n\n    // trap the click in case we are part of an active\n    // drag operation. This will effectively prevent\n    // the ghost click that cannot be canceled otherwise.\n    if (context.active) {\n\n      untrap = (0,ClickTrap/* install */.N)(eventBus);\n\n      // remove trap after minimal delay\n      setTimeout(untrap, 400);\n\n      // prevent default action (click)\n      preventDefault(event);\n    }\n\n    end(event);\n  }\n\n  function trapTouch(event) {\n    move(event);\n  }\n\n  // update the drag events model element (`hover`) and graphical element (`hoverGfx`)\n  // properties during hover and out and fire {prefix}.hover and {prefix}.out properties\n  // respectively\n\n  function hover(event) {\n    var payload = context.payload;\n\n    payload.hoverGfx = event.gfx;\n    payload.hover = event.element;\n\n    fire('hover');\n  }\n\n  function out(event) {\n    fire('out');\n\n    var payload = context.payload;\n\n    payload.hoverGfx = null;\n    payload.hover = null;\n  }\n\n\n  // life-cycle methods\n\n  function cancel(restore) {\n    var previousContext;\n\n    if (!context) {\n      return;\n    }\n\n    var wasActive = context.active;\n\n    if (wasActive) {\n      fire('cancel');\n    }\n\n    previousContext = cleanup(restore);\n\n    if (wasActive) {\n\n      // last event to be fired when all drag operations are done\n      // at this point in time no drag operation is in progress anymore\n      fire('canceled', previousContext);\n    }\n  }\n\n  function cleanup(restore) {\n    var previousContext,\n        endDrag;\n\n    fire('cleanup');\n\n    // reset cursor\n    (0,Cursor/* unset */.zN)();\n\n    if (context.trapClick) {\n      endDrag = trapClickAndEnd;\n    } else {\n      endDrag = end;\n    }\n\n    // reset dom listeners\n    index_esm/* event.unbind */.B.unbind(document, 'mousemove', move);\n\n    index_esm/* event.unbind */.B.unbind(document, 'dragstart', preventDefault);\n    index_esm/* event.unbind */.B.unbind(document, 'selectstart', preventDefault);\n\n    index_esm/* event.unbind */.B.unbind(document, 'mousedown', endDrag, true);\n    index_esm/* event.unbind */.B.unbind(document, 'mouseup', endDrag, true);\n\n    index_esm/* event.unbind */.B.unbind(document, 'keyup', checkCancel);\n\n    index_esm/* event.unbind */.B.unbind(document, 'touchstart', trapTouch, true);\n    index_esm/* event.unbind */.B.unbind(document, 'touchcancel', cancel, true);\n    index_esm/* event.unbind */.B.unbind(document, 'touchmove', move, true);\n    index_esm/* event.unbind */.B.unbind(document, 'touchend', end, true);\n\n    eventBus.off('element.hover', hover);\n    eventBus.off('element.out', out);\n\n    // remove drag marker on root element\n    canvas.removeMarker(canvas.getRootElement(), DRAG_ACTIVE_CLS);\n\n    // restore selection, unless it has changed\n    var previousSelection = context.payload.previousSelection;\n\n    if (restore !== false && previousSelection && !selection.get().length) {\n      restoreSelection(previousSelection);\n    }\n\n    previousContext = context;\n\n    context = null;\n\n    return previousContext;\n  }\n\n  /**\n   * Initialize a drag operation.\n   *\n   * If `localPosition` is given, drag events will be emitted\n   * relative to it.\n   *\n   * @param {MouseEvent|TouchEvent} [event]\n   * @param {Point} [relativeTo] actual diagram local position this drag operation should start at\n   * @param {string} prefix\n   * @param {Object} [options]\n   */\n  function init(event, relativeTo, prefix, options) {\n\n    // only one drag operation may be active, at a time\n    if (context) {\n      cancel(false);\n    }\n\n    if (typeof relativeTo === 'string') {\n      options = prefix;\n      prefix = relativeTo;\n      relativeTo = null;\n    }\n\n    options = (0,dist_index_esm/* assign */.f0)({}, defaultOptions, options || {});\n\n    var data = options.data || {},\n        originalEvent,\n        globalStart,\n        localStart,\n        endDrag,\n        isTouch;\n\n    if (options.trapClick) {\n      endDrag = trapClickAndEnd;\n    } else {\n      endDrag = end;\n    }\n\n    if (event) {\n      originalEvent = (0,Event/* getOriginal */.Ku)(event) || event;\n      globalStart = (0,Event/* toPoint */.jt)(event);\n\n      (0,Event/* stopPropagation */.UW)(event);\n\n      // prevent default browser dragging behavior\n      if (originalEvent.type === 'dragstart') {\n        preventDefault(originalEvent);\n      }\n    } else {\n      originalEvent = null;\n      globalStart = { x: 0, y: 0 };\n    }\n\n    localStart = toLocalPoint(globalStart);\n\n    if (!relativeTo) {\n      relativeTo = localStart;\n    }\n\n    isTouch = isTouchEvent(originalEvent);\n\n    context = (0,dist_index_esm/* assign */.f0)({\n      prefix: prefix,\n      data: data,\n      payload: {},\n      globalStart: globalStart,\n      displacement: (0,PositionUtil/* delta */.p)(relativeTo, localStart),\n      localStart: localStart,\n      isTouch: isTouch\n    }, options);\n\n    // skip dom registration if trigger\n    // is set to manual (during testing)\n    if (!options.manual) {\n\n      // add dom listeners\n\n      if (isTouch) {\n        index_esm/* event.bind */.B.bind(document, 'touchstart', trapTouch, true);\n        index_esm/* event.bind */.B.bind(document, 'touchcancel', cancel, true);\n        index_esm/* event.bind */.B.bind(document, 'touchmove', move, true);\n        index_esm/* event.bind */.B.bind(document, 'touchend', end, true);\n      } else {\n\n        // assume we use the mouse to interact per default\n        index_esm/* event.bind */.B.bind(document, 'mousemove', move);\n\n        // prevent default browser drag and text selection behavior\n        index_esm/* event.bind */.B.bind(document, 'dragstart', preventDefault);\n        index_esm/* event.bind */.B.bind(document, 'selectstart', preventDefault);\n\n        index_esm/* event.bind */.B.bind(document, 'mousedown', endDrag, true);\n        index_esm/* event.bind */.B.bind(document, 'mouseup', endDrag, true);\n      }\n\n      index_esm/* event.bind */.B.bind(document, 'keyup', checkCancel);\n\n      eventBus.on('element.hover', hover);\n      eventBus.on('element.out', out);\n    }\n\n    fire('init');\n\n    if (options.autoActivate) {\n      move(event, true);\n    }\n  }\n\n  // cancel on diagram destruction\n  eventBus.on('diagram.destroy', cancel);\n\n\n  // API\n\n  this.init = init;\n  this.move = move;\n  this.hover = hover;\n  this.out = out;\n  this.end = end;\n\n  this.cancel = cancel;\n\n  // for introspection\n\n  this.context = function() {\n    return context;\n  };\n\n  this.setOptions = function(options) {\n    (0,dist_index_esm/* assign */.f0)(defaultOptions, options);\n  };\n}\n\nDragging.$inject = [\n  'eventBus',\n  'canvas',\n  'selection',\n  'elementRegistry'\n];\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/dragging/index.js\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const dragging = ({\n  __depends__: [\n    hover_fix,\n    selection/* default */.Z,\n  ],\n  dragging: [ 'type', Dragging ],\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/dragging/index.js_+_3_modules?")},"./node_modules/diagram-js/lib/features/editor-actions/EditorActions.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ EditorActions)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n\n\n/**\n * @typedef {import('didi').Injector} Injector\n *\n * @typedef {import('../../core/EventBus').default} EventBus\n */\n\nvar NOT_REGISTERED_ERROR = 'is not a registered action',\n    IS_REGISTERED_ERROR = 'is already registered';\n\n\n/**\n * An interface that provides access to modeling actions by decoupling\n * the one who requests the action to be triggered and the trigger itself.\n *\n * It's possible to add new actions by registering them with ´registerAction´\n * and likewise unregister existing ones with ´unregisterAction´.\n *\n *\n * ## Life-Cycle and configuration\n *\n * The editor actions will wait for diagram initialization before\n * registering default actions _and_ firing an `editorActions.init` event.\n *\n * Interested parties may listen to the `editorActions.init` event with\n * low priority to check, which actions got registered. Other components\n * may use the event to register their own actions via `registerAction`.\n *\n * @param {EventBus} eventBus\n * @param {Injector} injector\n */\nfunction EditorActions(eventBus, injector) {\n\n  // initialize actions\n  this._actions = {};\n\n  var self = this;\n\n  eventBus.on('diagram.init', function() {\n\n    // all diagram modules got loaded; check which ones\n    // are available and register the respective default actions\n    self._registerDefaultActions(injector);\n\n    // ask interested parties to register available editor\n    // actions on diagram initialization\n    eventBus.fire('editorActions.init', {\n      editorActions: self\n    });\n  });\n\n}\n\nEditorActions.$inject = [\n  'eventBus',\n  'injector'\n];\n\n/**\n * Register default actions.\n *\n * @param {Injector} injector\n */\nEditorActions.prototype._registerDefaultActions = function(injector) {\n\n  // (1) retrieve optional components to integrate with\n\n  var commandStack = injector.get('commandStack', false);\n  var modeling = injector.get('modeling', false);\n  var selection = injector.get('selection', false);\n  var zoomScroll = injector.get('zoomScroll', false);\n  var copyPaste = injector.get('copyPaste', false);\n  var canvas = injector.get('canvas', false);\n  var rules = injector.get('rules', false);\n  var keyboardMove = injector.get('keyboardMove', false);\n  var keyboardMoveSelection = injector.get('keyboardMoveSelection', false);\n\n  // (2) check components and register actions\n\n  if (commandStack) {\n    this.register('undo', function() {\n      commandStack.undo();\n    });\n\n    this.register('redo', function() {\n      commandStack.redo();\n    });\n  }\n\n  if (copyPaste && selection) {\n    this.register('copy', function() {\n      var selectedElements = selection.get();\n\n      if (selectedElements.length) {\n        return copyPaste.copy(selectedElements);\n      }\n    });\n  }\n\n  if (copyPaste) {\n    this.register('paste', function() {\n      copyPaste.paste();\n    });\n  }\n\n  if (zoomScroll) {\n    this.register('stepZoom', function(opts) {\n      zoomScroll.stepZoom(opts.value);\n    });\n  }\n\n  if (canvas) {\n    this.register('zoom', function(opts) {\n      canvas.zoom(opts.value);\n    });\n  }\n\n  if (modeling && selection && rules) {\n    this.register('removeSelection', function() {\n\n      var selectedElements = selection.get();\n\n      if (!selectedElements.length) {\n        return;\n      }\n\n      var allowed = rules.allowed('elements.delete', { elements: selectedElements }),\n          removableElements;\n\n      if (allowed === false) {\n        return;\n      }\n      else if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .kJ)(allowed)) {\n        removableElements = allowed;\n      }\n      else {\n        removableElements = selectedElements;\n      }\n\n      if (removableElements.length) {\n        modeling.removeElements(removableElements.slice());\n      }\n    });\n  }\n\n  if (keyboardMove) {\n    this.register('moveCanvas', function(opts) {\n      keyboardMove.moveCanvas(opts);\n    });\n  }\n\n  if (keyboardMoveSelection) {\n    this.register('moveSelection', function(opts) {\n      keyboardMoveSelection.moveSelection(opts.direction, opts.accelerated);\n    });\n  }\n\n};\n\n\n/**\n * Triggers a registered action\n *\n * @param {string} action\n * @param {Object} opts\n *\n * @return {unknown} Returns what the registered listener returns\n */\nEditorActions.prototype.trigger = function(action, opts) {\n  if (!this._actions[action]) {\n    throw error(action, NOT_REGISTERED_ERROR);\n  }\n\n  return this._actions[action](opts);\n};\n\n\n/**\n * Registers a collections of actions.\n * The key of the object will be the name of the action.\n *\n * @example\n *\n * ```javascript\n * var actions = {\n *   spaceTool: function() {\n *     spaceTool.activateSelection();\n *   },\n *   lassoTool: function() {\n *     lassoTool.activateSelection();\n *   }\n * ];\n *\n * editorActions.register(actions);\n *\n * editorActions.isRegistered('spaceTool'); // true\n * ```\n *\n * @param {Object} actions\n */\nEditorActions.prototype.register = function(actions, listener) {\n  var self = this;\n\n  if (typeof actions === 'string') {\n    return this._registerAction(actions, listener);\n  }\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(actions, function(listener, action) {\n    self._registerAction(action, listener);\n  });\n};\n\n/**\n * Registers a listener to an action key\n *\n * @param {string} action\n * @param {Function} listener\n */\nEditorActions.prototype._registerAction = function(action, listener) {\n  if (this.isRegistered(action)) {\n    throw error(action, IS_REGISTERED_ERROR);\n  }\n\n  this._actions[action] = listener;\n};\n\n/**\n * Unregister an existing action\n *\n * @param {string} action\n */\nEditorActions.prototype.unregister = function(action) {\n  if (!this.isRegistered(action)) {\n    throw error(action, NOT_REGISTERED_ERROR);\n  }\n\n  this._actions[action] = undefined;\n};\n\n/**\n * Returns the number of actions that are currently registered\n *\n * @return {number}\n */\nEditorActions.prototype.getActions = function() {\n  return Object.keys(this._actions);\n};\n\n/**\n * Checks wether the given action is registered\n *\n * @param {string} action\n *\n * @return {boolean}\n */\nEditorActions.prototype.isRegistered = function(action) {\n  return !!this._actions[action];\n};\n\n\nfunction error(action, message) {\n  return new Error(action + ' ' + message);\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/editor-actions/EditorActions.js?")},"./node_modules/diagram-js/lib/features/editor-actions/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _EditorActions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/lib/features/editor-actions/EditorActions.js\");\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  __init__: [ 'editorActions' ],\n  editorActions: [ 'type', _EditorActions__WEBPACK_IMPORTED_MODULE_0__/* [\"default\"] */ .Z ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/editor-actions/index.js?")},"./node_modules/diagram-js/lib/features/global-connect/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ global_connect)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/connect/index.js + 2 modules\nvar connect = __webpack_require__(\"./node_modules/diagram-js/lib/features/connect/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/dragging/index.js + 3 modules\nvar dragging = __webpack_require__(\"./node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/tool-manager/index.js + 1 modules\nvar tool_manager = __webpack_require__(\"./node_modules/diagram-js/lib/features/tool-manager/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/mouse/index.js + 1 modules\nvar mouse = __webpack_require__(\"./node_modules/diagram-js/lib/features/mouse/index.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/global-connect/GlobalConnect.js\nvar MARKER_OK = 'connect-ok',\n    MARKER_NOT_OK = 'connect-not-ok';\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../connect/Connect').default} Connect\n * @typedef {import('../dragging/Dragging').default} Dragging\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../mouse/Mouse').default} Mouse\n * @typedef {import('../rules/Rules').default} Rules\n * @typedef {import('../tool-manager/ToolManager').default} ToolManager\n *\n * @typedef {import('../../model/Types').Element} Element\n */\n\n/**\n * @class\n * @constructor\n *\n * @param {EventBus} eventBus\n * @param {Dragging} dragging\n * @param {Connect} connect\n * @param {Canvas} canvas\n * @param {ToolManager} toolManager\n * @param {Rules} rules\n * @param {Mouse} mouse\n */\nfunction GlobalConnect(\n    eventBus, dragging, connect,\n    canvas, toolManager, rules,\n    mouse) {\n\n  var self = this;\n\n  this._dragging = dragging;\n  this._rules = rules;\n  this._mouse = mouse;\n\n  toolManager.registerTool('global-connect', {\n    tool: 'global-connect',\n    dragging: 'global-connect.drag'\n  });\n\n  eventBus.on('global-connect.hover', function(event) {\n    var context = event.context,\n        startTarget = event.hover;\n\n    var canStartConnect = context.canStartConnect = self.canStartConnect(startTarget);\n\n    // simply ignore hover\n    if (canStartConnect === null) {\n      return;\n    }\n\n    context.startTarget = startTarget;\n\n    canvas.addMarker(startTarget, canStartConnect ? MARKER_OK : MARKER_NOT_OK);\n  });\n\n\n  eventBus.on([ 'global-connect.out', 'global-connect.cleanup' ], function(event) {\n    var startTarget = event.context.startTarget,\n        canStartConnect = event.context.canStartConnect;\n\n    if (startTarget) {\n      canvas.removeMarker(startTarget, canStartConnect ? MARKER_OK : MARKER_NOT_OK);\n    }\n  });\n\n\n  eventBus.on([ 'global-connect.ended' ], function(event) {\n    var context = event.context,\n        startTarget = context.startTarget,\n        startPosition = {\n          x: event.x,\n          y: event.y\n        };\n\n    var canStartConnect = self.canStartConnect(startTarget);\n\n    if (!canStartConnect) {\n      return;\n    }\n\n    eventBus.once('element.out', function() {\n      eventBus.once([ 'connect.ended', 'connect.canceled' ], function() {\n        eventBus.fire('global-connect.drag.ended');\n      });\n\n      connect.start(null, startTarget, startPosition);\n    });\n\n    return false;\n  });\n}\n\nGlobalConnect.$inject = [\n  'eventBus',\n  'dragging',\n  'connect',\n  'canvas',\n  'toolManager',\n  'rules',\n  'mouse'\n];\n\n/**\n * Initiates tool activity.\n */\nGlobalConnect.prototype.start = function(event, autoActivate) {\n  this._dragging.init(event, 'global-connect', {\n    autoActivate: autoActivate,\n    trapClick: false,\n    data: {\n      context: {}\n    }\n  });\n};\n\nGlobalConnect.prototype.toggle = function() {\n\n  if (this.isActive()) {\n    return this._dragging.cancel();\n  }\n\n  var mouseEvent = this._mouse.getLastMoveEvent();\n\n  return this.start(mouseEvent, !!mouseEvent);\n};\n\nGlobalConnect.prototype.isActive = function() {\n  var context = this._dragging.context();\n\n  return context && /^global-connect/.test(context.prefix);\n};\n\n/**\n * Check if source element can initiate connection.\n *\n * @param {Element} startTarget\n * @return {boolean}\n */\nGlobalConnect.prototype.canStartConnect = function(startTarget) {\n  return this._rules.allowed('connection.start', { source: startTarget });\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/global-connect/index.js\n\n\n\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const global_connect = ({\n  __depends__: [\n    connect/* default */.Z,\n    rules/* default */.Z,\n    dragging/* default */.Z,\n    tool_manager/* default */.Z,\n    mouse/* default */.Z\n  ],\n  globalConnect: [ 'type', GlobalConnect ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/global-connect/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/grid-snapping/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ grid_snapping)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/snapping/SnapUtil.js\nvar SnapUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/snapping/SnapUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\nvar KeyboardUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/grid-snapping/GridUtil.js\nvar SPACING = 10;\n\nfunction quantize(value, quantum, fn) {\n  if (!fn) {\n    fn = 'round';\n  }\n\n  return Math[ fn ](value / quantum) * quantum;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/grid-snapping/GridSnapping.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n/**\r\n * @typedef {import('../../core/ElementRegistry').default} ElementRegistry\r\n * @typedef {import('../../core/EventBus').default} EventBus\r\n */\r\n\r\nvar LOWER_PRIORITY = 1200;\r\nvar LOW_PRIORITY = 800;\r\n\r\n/**\r\n * Basic grid snapping that covers connecting, creating, moving, resizing shapes, moving bendpoints\r\n * and connection segments.\r\n *\r\n * @param {ElementRegistry} elementRegistry\r\n * @param {EventBus} eventBus\r\n * @param {Object} config\r\n */\r\nfunction GridSnapping(elementRegistry, eventBus, config) {\r\n\r\n  var active = !config || config.active !== false;\r\n\r\n  this._eventBus = eventBus;\r\n\r\n  var self = this;\r\n\r\n  eventBus.on('diagram.init', LOW_PRIORITY, function() {\r\n    self.setActive(active);\r\n  });\r\n\r\n  eventBus.on([\r\n    'create.move',\r\n    'create.end',\r\n    'bendpoint.move.move',\r\n    'bendpoint.move.end',\r\n    'connect.move',\r\n    'connect.end',\r\n    'connectionSegment.move.move',\r\n    'connectionSegment.move.end',\r\n    'resize.move',\r\n    'resize.end',\r\n    'shape.move.move',\r\n    'shape.move.end'\r\n  ], LOWER_PRIORITY, function(event) {\r\n    var originalEvent = event.originalEvent;\r\n\r\n    if (!self.active || (originalEvent && (0,KeyboardUtil/* isCmd */.JS)(originalEvent))) {\r\n      return;\r\n    }\r\n\r\n    var context = event.context,\r\n        gridSnappingContext = context.gridSnappingContext;\r\n\r\n    if (!gridSnappingContext) {\r\n      gridSnappingContext = context.gridSnappingContext = {};\r\n    }\r\n\r\n    [ 'x', 'y' ].forEach(function(axis) {\r\n      var options = {};\r\n\r\n      // allow snapping with offset\r\n      var snapOffset = getSnapOffset(event, axis, elementRegistry);\r\n\r\n      if (snapOffset) {\r\n        options.offset = snapOffset;\r\n      }\r\n\r\n      // allow snapping with min and max\r\n      var snapConstraints = getSnapConstraints(event, axis);\r\n\r\n      if (snapConstraints) {\r\n        (0,index_esm/* assign */.f0)(options, snapConstraints);\r\n      }\r\n\r\n      if (!(0,SnapUtil/* isSnapped */.Wn)(event, axis)) {\r\n        self.snapEvent(event, axis, options);\r\n      }\r\n    });\r\n  });\r\n}\r\n\r\n/**\r\n * Snap an events x or y with optional min, max and offset.\r\n *\r\n * @param {Object} event\r\n * @param {string} axis\r\n * @param {number} [options.min]\r\n * @param {number} [options.max]\r\n * @param {number} [options.offset]\r\n */\r\nGridSnapping.prototype.snapEvent = function(event, axis, options) {\r\n  var snappedValue = this.snapValue(event[ axis ], options);\r\n\r\n  (0,SnapUtil/* setSnapped */.U)(event, axis, snappedValue);\r\n};\r\n\r\n/**\r\n * Expose grid spacing for third parties (i.e. extensions).\r\n *\r\n * @return {number} spacing of grid dots\r\n */\r\nGridSnapping.prototype.getGridSpacing = function() {\r\n  return SPACING;\r\n};\r\n\r\n/**\r\n * Snap value with optional min, max and offset.\r\n *\r\n * @param {number} value\r\n * @param {Object} options\r\n * @param {number} [options.min]\r\n * @param {number} [options.max]\r\n * @param {number} [options.offset]\r\n */\r\nGridSnapping.prototype.snapValue = function(value, options) {\r\n  var offset = 0;\r\n\r\n  if (options && options.offset) {\r\n    offset = options.offset;\r\n  }\r\n\r\n  value += offset;\r\n\r\n  value = quantize(value, SPACING);\r\n\r\n  var min, max;\r\n\r\n  if (options && options.min) {\r\n    min = options.min;\r\n\r\n    if ((0,index_esm/* isNumber */.hj)(min)) {\r\n      min = quantize(min + offset, SPACING, 'ceil');\r\n\r\n      value = Math.max(value, min);\r\n    }\r\n  }\r\n\r\n  if (options && options.max) {\r\n    max = options.max;\r\n\r\n    if ((0,index_esm/* isNumber */.hj)(max)) {\r\n      max = quantize(max + offset, SPACING, 'floor');\r\n\r\n      value = Math.min(value, max);\r\n    }\r\n  }\r\n\r\n  value -= offset;\r\n\r\n  return value;\r\n};\r\n\r\nGridSnapping.prototype.isActive = function() {\r\n  return this.active;\r\n};\r\n\r\nGridSnapping.prototype.setActive = function(active) {\r\n  this.active = active;\r\n\r\n  this._eventBus.fire('gridSnapping.toggle', { active: active });\r\n};\r\n\r\nGridSnapping.prototype.toggleActive = function() {\r\n  this.setActive(!this.active);\r\n};\r\n\r\nGridSnapping.$inject = [\r\n  'elementRegistry',\r\n  'eventBus',\r\n  'config.gridSnapping'\r\n];\r\n\r\n// helpers //////////\r\n\r\n/**\r\n * Get minimum and maximum snap constraints.\r\n * Constraints are cached.\r\n *\r\n * @param {Object} event\r\n * @param {Object} event.context\r\n * @param {string} axis\r\n *\r\n * @return {boolean|Object}\r\n */\r\nfunction getSnapConstraints(event, axis) {\r\n  var context = event.context,\r\n      createConstraints = context.createConstraints,\r\n      resizeConstraints = context.resizeConstraints || {},\r\n      gridSnappingContext = context.gridSnappingContext,\r\n      snapConstraints = gridSnappingContext.snapConstraints;\r\n\r\n  // cache snap constraints\r\n  if (snapConstraints && snapConstraints[ axis ]) {\r\n    return snapConstraints[ axis ];\r\n  }\r\n\r\n  if (!snapConstraints) {\r\n    snapConstraints = gridSnappingContext.snapConstraints = {};\r\n  }\r\n\r\n  if (!snapConstraints[ axis ]) {\r\n    snapConstraints[ axis ] = {};\r\n  }\r\n\r\n  var direction = context.direction;\r\n\r\n  // create\r\n  if (createConstraints) {\r\n    if (isHorizontal(axis)) {\r\n      snapConstraints.x.min = createConstraints.left;\r\n      snapConstraints.x.max = createConstraints.right;\r\n    } else {\r\n      snapConstraints.y.min = createConstraints.top;\r\n      snapConstraints.y.max = createConstraints.bottom;\r\n    }\r\n  }\r\n\r\n  // resize\r\n  var minResizeConstraints = resizeConstraints.min,\r\n      maxResizeConstraints = resizeConstraints.max;\r\n\r\n  if (minResizeConstraints) {\r\n    if (isHorizontal(axis)) {\r\n\r\n      if (isWest(direction)) {\r\n        snapConstraints.x.max = minResizeConstraints.left;\r\n      } else {\r\n        snapConstraints.x.min = minResizeConstraints.right;\r\n      }\r\n\r\n    } else {\r\n\r\n      if (isNorth(direction)) {\r\n        snapConstraints.y.max = minResizeConstraints.top;\r\n      } else {\r\n        snapConstraints.y.min = minResizeConstraints.bottom;\r\n      }\r\n\r\n    }\r\n  }\r\n\r\n  if (maxResizeConstraints) {\r\n    if (isHorizontal(axis)) {\r\n\r\n      if (isWest(direction)) {\r\n        snapConstraints.x.min = maxResizeConstraints.left;\r\n      } else {\r\n        snapConstraints.x.max = maxResizeConstraints.right;\r\n      }\r\n\r\n    } else {\r\n\r\n      if (isNorth(direction)) {\r\n        snapConstraints.y.min = maxResizeConstraints.top;\r\n      } else {\r\n        snapConstraints.y.max = maxResizeConstraints.bottom;\r\n      }\r\n\r\n    }\r\n  }\r\n\r\n  return snapConstraints[ axis ];\r\n}\r\n\r\n/**\r\n * Get snap offset.\r\n * Offset is cached.\r\n *\r\n * @param {Object} event\r\n * @param {string} axis\r\n * @param {ElementRegistry} elementRegistry\r\n *\r\n * @return {number}\r\n */\r\nfunction getSnapOffset(event, axis, elementRegistry) {\r\n  var context = event.context,\r\n      shape = event.shape,\r\n      gridSnappingContext = context.gridSnappingContext,\r\n      snapLocation = gridSnappingContext.snapLocation,\r\n      snapOffset = gridSnappingContext.snapOffset;\r\n\r\n  // cache snap offset\r\n  if (snapOffset && (0,index_esm/* isNumber */.hj)(snapOffset[ axis ])) {\r\n    return snapOffset[ axis ];\r\n  }\r\n\r\n  if (!snapOffset) {\r\n    snapOffset = gridSnappingContext.snapOffset = {};\r\n  }\r\n\r\n  if (!(0,index_esm/* isNumber */.hj)(snapOffset[ axis ])) {\r\n    snapOffset[ axis ] = 0;\r\n  }\r\n\r\n  if (!shape) {\r\n    return snapOffset[ axis ];\r\n  }\r\n\r\n  if (!elementRegistry.get(shape.id)) {\r\n\r\n    if (isHorizontal(axis)) {\r\n      snapOffset[ axis ] += shape[ axis ] + shape.width / 2;\r\n    } else {\r\n      snapOffset[ axis ] += shape[ axis ] + shape.height / 2;\r\n    }\r\n  }\r\n\r\n  if (!snapLocation) {\r\n    return snapOffset[ axis ];\r\n  }\r\n\r\n  if (axis === 'x') {\r\n    if (/left/.test(snapLocation)) {\r\n      snapOffset[ axis ] -= shape.width / 2;\r\n    } else if (/right/.test(snapLocation)) {\r\n      snapOffset[ axis ] += shape.width / 2;\r\n    }\r\n  } else {\r\n    if (/top/.test(snapLocation)) {\r\n      snapOffset[ axis ] -= shape.height / 2;\r\n    } else if (/bottom/.test(snapLocation)) {\r\n      snapOffset[ axis ] += shape.height / 2;\r\n    }\r\n  }\r\n\r\n  return snapOffset[ axis ];\r\n}\r\n\r\nfunction isHorizontal(axis) {\r\n  return axis === 'x';\r\n}\r\n\r\nfunction isNorth(direction) {\r\n  return direction.indexOf('n') !== -1;\r\n}\r\n\r\nfunction isWest(direction) {\r\n  return direction.indexOf('w') !== -1;\r\n}\n// EXTERNAL MODULE: ./node_modules/inherits-browser/dist/index.es.js\nvar index_es = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/command/CommandInterceptor.js\nvar CommandInterceptor = __webpack_require__(\"./node_modules/diagram-js/lib/command/CommandInterceptor.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/grid-snapping/behavior/ResizeBehavior.js\n\r\n\r\n\r\n\r\n\r\n\r\n/**\r\n * @typedef {import('../../../model/Types').Shape} Shape\r\n *\r\n * @typedef {import('../../../util/Types').Rect} Rect\r\n *\r\n * @typedef {import('../../../core/EventBus').default} EventBus\r\n * @typedef {import('../../grid-snapping/GridSnapping').default} GridSnapping\r\n */\r\n\r\n/**\r\n * Integrates resizing with grid snapping.\r\n *\r\n * @param {EventBus} eventBus\r\n * @param {GridSnapping} gridSnapping\r\n */\r\nfunction ResizeBehavior(eventBus, gridSnapping) {\r\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\r\n\r\n  this._gridSnapping = gridSnapping;\r\n\r\n  var self = this;\r\n\r\n  this.preExecute('shape.resize', function(event) {\r\n    var context = event.context,\r\n        hints = context.hints || {},\r\n        autoResize = hints.autoResize;\r\n\r\n    if (!autoResize) {\r\n      return;\r\n    }\r\n\r\n    var shape = context.shape,\r\n        newBounds = context.newBounds;\r\n\r\n    if ((0,index_esm/* isString */.HD)(autoResize)) {\r\n      context.newBounds = self.snapComplex(newBounds, autoResize);\r\n    } else {\r\n      context.newBounds = self.snapSimple(shape, newBounds);\r\n    }\r\n  });\r\n}\r\n\r\nResizeBehavior.$inject = [\r\n  'eventBus',\r\n  'gridSnapping',\r\n  'modeling'\r\n];\r\n\r\n(0,index_es/* default */.Z)(ResizeBehavior, CommandInterceptor/* default */.Z);\r\n\r\n/**\r\n * Snap width and height in relation to center.\r\n *\r\n * @param {Shape} shape\r\n * @param {Rect} newBounds\r\n *\r\n * @return {Rect} Snapped bounds.\r\n */\r\nResizeBehavior.prototype.snapSimple = function(shape, newBounds) {\r\n  var gridSnapping = this._gridSnapping;\r\n\r\n  newBounds.width = gridSnapping.snapValue(newBounds.width, {\r\n    min: newBounds.width\r\n  });\r\n\r\n  newBounds.height = gridSnapping.snapValue(newBounds.height, {\r\n    min: newBounds.height\r\n  });\r\n\r\n  newBounds.x = shape.x + (shape.width / 2) - (newBounds.width / 2);\r\n  newBounds.y = shape.y + (shape.height / 2) - (newBounds.height / 2);\r\n\r\n  return newBounds;\r\n};\r\n\r\n/**\r\n * Snap x, y, width and height according to given directions.\r\n *\r\n * @param {Rect} newBounds\r\n * @param {string} directions - Directions as {n|w|s|e}.\r\n *\r\n * @return {Rect} Snapped bounds.\r\n */\r\nResizeBehavior.prototype.snapComplex = function(newBounds, directions) {\r\n  if (/w|e/.test(directions)) {\r\n    newBounds = this.snapHorizontally(newBounds, directions);\r\n  }\r\n\r\n  if (/n|s/.test(directions)) {\r\n    newBounds = this.snapVertically(newBounds, directions);\r\n  }\r\n\r\n  return newBounds;\r\n};\r\n\r\n/**\r\n * Snap in one or both directions horizontally.\r\n *\r\n * @param {Rect} newBounds\r\n * @param {string} directions - Directions as {n|w|s|e}.\r\n *\r\n * @return {Rect} Snapped bounds.\r\n */\r\nResizeBehavior.prototype.snapHorizontally = function(newBounds, directions) {\r\n  var gridSnapping = this._gridSnapping,\r\n      west = /w/.test(directions),\r\n      east = /e/.test(directions);\r\n\r\n  var snappedNewBounds = {};\r\n\r\n  snappedNewBounds.width = gridSnapping.snapValue(newBounds.width, {\r\n    min: newBounds.width\r\n  });\r\n\r\n  if (east) {\r\n\r\n    // handle <we>\r\n    if (west) {\r\n      snappedNewBounds.x = gridSnapping.snapValue(newBounds.x, {\r\n        max: newBounds.x\r\n      });\r\n\r\n      snappedNewBounds.width += gridSnapping.snapValue(newBounds.x - snappedNewBounds.x, {\r\n        min: newBounds.x - snappedNewBounds.x\r\n      });\r\n    }\r\n\r\n    // handle <e>\r\n    else {\r\n      newBounds.x = newBounds.x + newBounds.width - snappedNewBounds.width;\r\n    }\r\n  }\r\n\r\n  // assign snapped x and width\r\n  (0,index_esm/* assign */.f0)(newBounds, snappedNewBounds);\r\n\r\n  return newBounds;\r\n};\r\n\r\n/**\r\n * Snap in one or both directions vertically.\r\n *\r\n * @param {Rect} newBounds\r\n * @param {string} directions - Directions as {n|w|s|e}.\r\n *\r\n * @return {Rect} Snapped bounds.\r\n */\r\nResizeBehavior.prototype.snapVertically = function(newBounds, directions) {\r\n  var gridSnapping = this._gridSnapping,\r\n      north = /n/.test(directions),\r\n      south = /s/.test(directions);\r\n\r\n  var snappedNewBounds = {};\r\n\r\n  snappedNewBounds.height = gridSnapping.snapValue(newBounds.height, {\r\n    min: newBounds.height\r\n  });\r\n\r\n  if (north) {\r\n\r\n    // handle <ns>\r\n    if (south) {\r\n      snappedNewBounds.y = gridSnapping.snapValue(newBounds.y, {\r\n        max: newBounds.y\r\n      });\r\n\r\n      snappedNewBounds.height += gridSnapping.snapValue(newBounds.y - snappedNewBounds.y, {\r\n        min: newBounds.y - snappedNewBounds.y\r\n      });\r\n    }\r\n\r\n    // handle <n>\r\n    else {\r\n      newBounds.y = newBounds.y + newBounds.height - snappedNewBounds.height;\r\n    }\r\n  }\r\n\r\n  // assign snapped y and height\r\n  (0,index_esm/* assign */.f0)(newBounds, snappedNewBounds);\r\n\r\n  return newBounds;\r\n};\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/grid-snapping/behavior/SpaceToolBehavior.js\n/**\r\n * @typedef {import('../../../core/EventBus').default} EventBus\r\n * @typedef {import('../../grid-snapping/GridSnapping').default} GridSnapping\r\n */\r\n\r\nvar HIGH_PRIORITY = 2000;\r\n\r\n/**\r\n * Integrates space tool with grid snapping.\r\n *\r\n * @param {EventBus} eventBus\r\n * @param {GridSnapping} gridSnapping\r\n */\r\nfunction SpaceToolBehavior(eventBus, gridSnapping) {\r\n  eventBus.on([\r\n    'spaceTool.move',\r\n    'spaceTool.end'\r\n  ], HIGH_PRIORITY, function(event) {\r\n    var context = event.context;\r\n\r\n    if (!context.initialized) {\r\n      return;\r\n    }\r\n\r\n    var axis = context.axis;\r\n\r\n    var snapped;\r\n\r\n    if (axis === 'x') {\r\n\r\n      // snap delta x to multiple of 10\r\n      snapped = gridSnapping.snapValue(event.dx);\r\n\r\n      event.x = event.x + snapped - event.dx;\r\n      event.dx = snapped;\r\n    } else {\r\n\r\n      // snap delta y to multiple of 10\r\n      snapped = gridSnapping.snapValue(event.dy);\r\n\r\n      event.y = event.y + snapped - event.dy;\r\n      event.dy = snapped;\r\n    }\r\n  });\r\n}\r\n\r\nSpaceToolBehavior.$inject = [\r\n  'eventBus',\r\n  'gridSnapping'\r\n];\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/grid-snapping/behavior/index.js\n\r\n\r\n\r\n/* harmony default export */ const behavior = ({\r\n  __init__: [\r\n    'gridSnappingResizeBehavior',\r\n    'gridSnappingSpaceToolBehavior'\r\n  ],\r\n  gridSnappingResizeBehavior: [ 'type', ResizeBehavior ],\r\n  gridSnappingSpaceToolBehavior: [ 'type', SpaceToolBehavior ]\r\n});\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/grid-snapping/index.js\n\r\n\r\n\r\n\r\n\r\n/**\r\n * @type { import('didi').ModuleDeclaration }\r\n */\r\n/* harmony default export */ const grid_snapping = ({\r\n  __depends__: [ behavior ],\r\n  __init__: [ 'gridSnapping' ],\r\n  gridSnapping: [ 'type', GridSnapping ]\r\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/grid-snapping/index.js_+_5_modules?")},"./node_modules/diagram-js/lib/features/hand-tool/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ hand_tool)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/tool-manager/index.js + 1 modules\nvar tool_manager = __webpack_require__(\"./node_modules/diagram-js/lib/features/tool-manager/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/mouse/index.js + 1 modules\nvar mouse = __webpack_require__(\"./node_modules/diagram-js/lib/features/mouse/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Mouse.js\nvar Mouse = __webpack_require__(\"./node_modules/diagram-js/lib/util/Mouse.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\nvar KeyboardUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/hand-tool/HandTool.js\n\n\n\n\n/**\n * @typedef {import('didi').Injector} Injector\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../dragging/Dragging').default} Dragging\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../mouse/Mouse').default} Mouse\n * @typedef {import('../tool-manager/ToolManager').default} ToolManager\n */\n\nvar HIGH_PRIORITY = 1500;\nvar HAND_CURSOR = 'grab';\n\n/**\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {Dragging} dragging\n * @param {Injector} injector\n * @param {ToolManager} toolManager\n * @param {Mouse} mouse\n */\nfunction HandTool(\n    eventBus, canvas, dragging,\n    injector, toolManager, mouse) {\n\n  this._dragging = dragging;\n  this._mouse = mouse;\n\n  var self = this,\n      keyboard = injector.get('keyboard', false);\n\n  toolManager.registerTool('hand', {\n    tool: 'hand',\n    dragging: 'hand.move'\n  });\n\n  eventBus.on('element.mousedown', HIGH_PRIORITY, function(event) {\n\n    if (!(0,Mouse/* hasPrimaryModifier */.RJ)(event)) {\n      return;\n    }\n\n    self.activateMove(event.originalEvent, true);\n\n    return false;\n  });\n\n  keyboard && keyboard.addListener(HIGH_PRIORITY, function(e) {\n    if (!isSpace(e.keyEvent) || self.isActive()) {\n      return;\n    }\n\n    var mouseEvent = self._mouse.getLastMoveEvent();\n\n    self.activateMove(mouseEvent, !!mouseEvent);\n  }, 'keyboard.keydown');\n\n  keyboard && keyboard.addListener(HIGH_PRIORITY, function(e) {\n    if (!isSpace(e.keyEvent) || !self.isActive()) {\n      return;\n    }\n\n    self.toggle();\n  }, 'keyboard.keyup');\n\n  eventBus.on('hand.end', function(event) {\n    var target = event.originalEvent.target;\n\n    // only reactive on diagram click\n    // on some occasions, event.hover is not set and we have to check if the target is an svg\n    if (!event.hover && !(target instanceof SVGElement)) {\n      return false;\n    }\n\n    eventBus.once('hand.ended', function() {\n      self.activateMove(event.originalEvent, { reactivate: true });\n    });\n\n  });\n\n  eventBus.on('hand.move.move', function(event) {\n    var scale = canvas.viewbox().scale;\n\n    canvas.scroll({\n      dx: event.dx * scale,\n      dy: event.dy * scale\n    });\n  });\n\n  eventBus.on('hand.move.end', function(event) {\n    var context = event.context,\n        reactivate = context.reactivate;\n\n    // Don't reactivate if the user is using the keyboard keybinding\n    if (!(0,Mouse/* hasPrimaryModifier */.RJ)(event) && reactivate) {\n\n      eventBus.once('hand.move.ended', function(event) {\n        self.activateHand(event.originalEvent, true, true);\n      });\n\n    }\n\n    return false;\n  });\n\n}\n\nHandTool.$inject = [\n  'eventBus',\n  'canvas',\n  'dragging',\n  'injector',\n  'toolManager',\n  'mouse'\n];\n\n\nHandTool.prototype.activateMove = function(event, autoActivate, context) {\n  if (typeof autoActivate === 'object') {\n    context = autoActivate;\n    autoActivate = false;\n  }\n\n  this._dragging.init(event, 'hand.move', {\n    autoActivate: autoActivate,\n    cursor: HAND_CURSOR,\n    data: {\n      context: context || {}\n    }\n  });\n};\n\nHandTool.prototype.activateHand = function(event, autoActivate, reactivate) {\n  this._dragging.init(event, 'hand', {\n    trapClick: false,\n    autoActivate: autoActivate,\n    cursor: HAND_CURSOR,\n    data: {\n      context: {\n        reactivate: reactivate\n      }\n    }\n  });\n};\n\nHandTool.prototype.toggle = function() {\n  if (this.isActive()) {\n    return this._dragging.cancel();\n  }\n\n  var mouseEvent = this._mouse.getLastMoveEvent();\n\n  this.activateHand(mouseEvent, !!mouseEvent);\n};\n\nHandTool.prototype.isActive = function() {\n  var context = this._dragging.context();\n\n  if (context) {\n    return /^(hand|hand\\.move)$/.test(context.prefix);\n  }\n\n  return false;\n};\n\n// helpers //////////\n\nfunction isSpace(keyEvent) {\n  return (0,KeyboardUtil/* isKey */.ot)('Space', keyEvent);\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/hand-tool/index.js\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const hand_tool = ({\n  __depends__: [\n    tool_manager/* default */.Z,\n    mouse/* default */.Z\n  ],\n  __init__: [ 'handTool' ],\n  handTool: [ 'type', HandTool ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/hand-tool/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/interaction-events/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ interaction_events)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Mouse.js\nvar Mouse = __webpack_require__(\"./node_modules/diagram-js/lib/util/Mouse.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar tiny_svg_dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/RenderUtil.js\nvar RenderUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/RenderUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/interaction-events/InteractionEvents.js\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../model/Types').Element} Element\n *\n * @typedef {import('../../core/ElementRegistry').default} ElementRegistry\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../../draw/Styles').default} Styles\n *\n * @typedef {import('../../util/Types').Point} Point\n */\n\nfunction allowAll(event) { return true; }\n\nfunction allowPrimaryAndAuxiliary(event) {\n  return (0,Mouse/* isPrimaryButton */.Id)(event) || (0,Mouse/* isAuxiliaryButton */.L7)(event);\n}\n\nvar LOW_PRIORITY = 500;\n\n\n/**\n * A plugin that provides interaction events for diagram elements.\n *\n * It emits the following events:\n *\n *   * element.click\n *   * element.contextmenu\n *   * element.dblclick\n *   * element.hover\n *   * element.mousedown\n *   * element.mousemove\n *   * element.mouseup\n *   * element.out\n *\n * Each event is a tuple { element, gfx, originalEvent }.\n *\n * Canceling the event via Event#preventDefault()\n * prevents the original DOM operation.\n *\n * @param {EventBus} eventBus\n * @param {ElementRegistry} elementRegistry\n * @param {Styles} styles\n */\nfunction InteractionEvents(eventBus, elementRegistry, styles) {\n\n  var self = this;\n\n  /**\n   * Fire an interaction event.\n   *\n   * @param {string} type local event name, e.g. element.click.\n   * @param {MouseEvent|TouchEvent} event native event\n   * @param {Element} [element] the diagram element to emit the event on;\n   *                                   defaults to the event target\n   */\n  function fire(type, event, element) {\n\n    if (isIgnored(type, event)) {\n      return;\n    }\n\n    var target, gfx, returnValue;\n\n    if (!element) {\n      target = event.delegateTarget || event.target;\n\n      if (target) {\n        gfx = target;\n        element = elementRegistry.get(gfx);\n      }\n    } else {\n      gfx = elementRegistry.getGraphics(element);\n    }\n\n    if (!gfx || !element) {\n      return;\n    }\n\n    returnValue = eventBus.fire(type, {\n      element: element,\n      gfx: gfx,\n      originalEvent: event\n    });\n\n    if (returnValue === false) {\n      event.stopPropagation();\n      event.preventDefault();\n    }\n  }\n\n  // TODO(nikku): document this\n  var handlers = {};\n\n  function mouseHandler(localEventName) {\n    return handlers[localEventName];\n  }\n\n  function isIgnored(localEventName, event) {\n\n    var filter = ignoredFilters[localEventName] || Mouse/* isPrimaryButton */.Id;\n\n    // only react on left mouse button interactions\n    // except for interaction events that are enabled\n    // for secundary mouse button\n    return !filter(event);\n  }\n\n  var bindings = {\n    click: 'element.click',\n    contextmenu: 'element.contextmenu',\n    dblclick: 'element.dblclick',\n    mousedown: 'element.mousedown',\n    mousemove: 'element.mousemove',\n    mouseover: 'element.hover',\n    mouseout: 'element.out',\n    mouseup: 'element.mouseup',\n  };\n\n  var ignoredFilters = {\n    'element.contextmenu': allowAll,\n    'element.mousedown': allowPrimaryAndAuxiliary,\n    'element.mouseup': allowPrimaryAndAuxiliary,\n    'element.click': allowPrimaryAndAuxiliary,\n    'element.dblclick': allowPrimaryAndAuxiliary\n  };\n\n\n  // manual event trigger //////////\n\n  /**\n   * Trigger an interaction event (based on a native dom event)\n   * on the target shape or connection.\n   *\n   * @param {string} eventName the name of the triggered DOM event\n   * @param {MouseEvent|TouchEvent} event\n   * @param {Element} targetElement\n   */\n  function triggerMouseEvent(eventName, event, targetElement) {\n\n    // i.e. element.mousedown...\n    var localEventName = bindings[eventName];\n\n    if (!localEventName) {\n      throw new Error('unmapped DOM event name <' + eventName + '>');\n    }\n\n    return fire(localEventName, event, targetElement);\n  }\n\n\n  var ELEMENT_SELECTOR = 'svg, .djs-element';\n\n  // event handling ///////\n\n  function registerEvent(node, event, localEvent, ignoredFilter) {\n\n    var handler = handlers[localEvent] = function(event) {\n      fire(localEvent, event);\n    };\n\n    if (ignoredFilter) {\n      ignoredFilters[localEvent] = ignoredFilter;\n    }\n\n    handler.$delegate = dist_index_esm/* delegate.bind */.cl.bind(node, ELEMENT_SELECTOR, event, handler);\n  }\n\n  function unregisterEvent(node, event, localEvent) {\n\n    var handler = mouseHandler(localEvent);\n\n    if (!handler) {\n      return;\n    }\n\n    dist_index_esm/* delegate.unbind */.cl.unbind(node, event, handler.$delegate);\n  }\n\n  function registerEvents(svg) {\n    (0,index_esm/* forEach */.Ed)(bindings, function(val, key) {\n      registerEvent(svg, key, val);\n    });\n  }\n\n  function unregisterEvents(svg) {\n    (0,index_esm/* forEach */.Ed)(bindings, function(val, key) {\n      unregisterEvent(svg, key, val);\n    });\n  }\n\n  eventBus.on('canvas.destroy', function(event) {\n    unregisterEvents(event.svg);\n  });\n\n  eventBus.on('canvas.init', function(event) {\n    registerEvents(event.svg);\n  });\n\n\n  // hit box updating ////////////////\n\n  eventBus.on([ 'shape.added', 'connection.added' ], function(event) {\n    var element = event.element,\n        gfx = event.gfx;\n\n    eventBus.fire('interactionEvents.createHit', { element: element, gfx: gfx });\n  });\n\n  // Update djs-hit on change.\n  // A low priortity is necessary, because djs-hit of labels has to be updated\n  // after the label bounds have been updated in the renderer.\n  eventBus.on([\n    'shape.changed',\n    'connection.changed'\n  ], LOW_PRIORITY, function(event) {\n\n    var element = event.element,\n        gfx = event.gfx;\n\n    eventBus.fire('interactionEvents.updateHit', { element: element, gfx: gfx });\n  });\n\n  eventBus.on('interactionEvents.createHit', LOW_PRIORITY, function(event) {\n    var element = event.element,\n        gfx = event.gfx;\n\n    self.createDefaultHit(element, gfx);\n  });\n\n  eventBus.on('interactionEvents.updateHit', function(event) {\n    var element = event.element,\n        gfx = event.gfx;\n\n    self.updateDefaultHit(element, gfx);\n  });\n\n\n  // hit styles ////////////\n\n  var STROKE_HIT_STYLE = createHitStyle('djs-hit djs-hit-stroke');\n\n  var CLICK_STROKE_HIT_STYLE = createHitStyle('djs-hit djs-hit-click-stroke');\n\n  var ALL_HIT_STYLE = createHitStyle('djs-hit djs-hit-all');\n\n  var NO_MOVE_HIT_STYLE = createHitStyle('djs-hit djs-hit-no-move');\n\n  var HIT_TYPES = {\n    'all': ALL_HIT_STYLE,\n    'click-stroke': CLICK_STROKE_HIT_STYLE,\n    'stroke': STROKE_HIT_STYLE,\n    'no-move': NO_MOVE_HIT_STYLE\n  };\n\n  function createHitStyle(classNames, attrs) {\n\n    attrs = (0,index_esm/* assign */.f0)({\n      stroke: 'white',\n      strokeWidth: 15\n    }, attrs || {});\n\n    return styles.cls(classNames, [ 'no-fill', 'no-border' ], attrs);\n  }\n\n\n  // style helpers ///////////////\n\n  function applyStyle(hit, type) {\n\n    var attrs = HIT_TYPES[type];\n\n    if (!attrs) {\n      throw new Error('invalid hit type <' + type + '>');\n    }\n\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(hit, attrs);\n\n    return hit;\n  }\n\n  function appendHit(gfx, hit) {\n    (0,tiny_svg_dist_index_esm/* append */.R3)(gfx, hit);\n  }\n\n\n  // API\n\n  /**\n   * Remove hints on the given graphics.\n   *\n   * @param {SVGElement} gfx\n   */\n  this.removeHits = function(gfx) {\n    var hits = (0,dist_index_esm/* queryAll */.Kt)('.djs-hit', gfx);\n\n    (0,index_esm/* forEach */.Ed)(hits, tiny_svg_dist_index_esm/* remove */.Od);\n  };\n\n  /**\n   * Create default hit for the given element.\n   *\n   * @param {Element} element\n   * @param {SVGElement} gfx\n   *\n   * @return {SVGElement} created hit\n   */\n  this.createDefaultHit = function(element, gfx) {\n    var waypoints = element.waypoints,\n        isFrame = element.isFrame,\n        boxType;\n\n    if (waypoints) {\n      return this.createWaypointsHit(gfx, waypoints);\n    } else {\n\n      boxType = isFrame ? 'stroke' : 'all';\n\n      return this.createBoxHit(gfx, boxType, {\n        width: element.width,\n        height: element.height\n      });\n    }\n  };\n\n  /**\n   * Create hits for the given waypoints.\n   *\n   * @param {SVGElement} gfx\n   * @param {Point[]} waypoints\n   *\n   * @return {SVGElement}\n   */\n  this.createWaypointsHit = function(gfx, waypoints) {\n\n    var hit = (0,RenderUtil/* createLine */.W5)(waypoints);\n\n    applyStyle(hit, 'stroke');\n\n    appendHit(gfx, hit);\n\n    return hit;\n  };\n\n  /**\n   * Create hits for a box.\n   *\n   * @param {SVGElement} gfx\n   * @param {string} type\n   * @param {Object} attrs\n   *\n   * @return {SVGElement}\n   */\n  this.createBoxHit = function(gfx, type, attrs) {\n\n    attrs = (0,index_esm/* assign */.f0)({\n      x: 0,\n      y: 0\n    }, attrs);\n\n    var hit = (0,tiny_svg_dist_index_esm/* create */.Ue)('rect');\n\n    applyStyle(hit, type);\n\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(hit, attrs);\n\n    appendHit(gfx, hit);\n\n    return hit;\n  };\n\n  /**\n   * Update default hit of the element.\n   *\n   * @param {Element} element\n   * @param {SVGElement} gfx\n   *\n   * @return {SVGElement} updated hit\n   */\n  this.updateDefaultHit = function(element, gfx) {\n\n    var hit = (0,dist_index_esm/* query */.IO)('.djs-hit', gfx);\n\n    if (!hit) {\n      return;\n    }\n\n    if (element.waypoints) {\n      (0,RenderUtil/* updateLine */.cq)(hit, element.waypoints);\n    } else {\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(hit, {\n        width: element.width,\n        height: element.height\n      });\n    }\n\n    return hit;\n  };\n\n  this.fire = fire;\n\n  this.triggerMouseEvent = triggerMouseEvent;\n\n  this.mouseHandler = mouseHandler;\n\n  this.registerEvent = registerEvent;\n  this.unregisterEvent = unregisterEvent;\n}\n\n\nInteractionEvents.$inject = [\n  'eventBus',\n  'elementRegistry',\n  'styles'\n];\n\n\n/**\n * An event indicating that the mouse hovered over an element\n *\n * @event element.hover\n *\n * @type {Object}\n * @property {Element} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has left an element\n *\n * @event element.out\n *\n * @type {Object}\n * @property {Element} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has clicked an element\n *\n * @event element.click\n *\n * @type {Object}\n * @property {Element} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has double clicked an element\n *\n * @event element.dblclick\n *\n * @type {Object}\n * @property {Element} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has gone down on an element.\n *\n * @event element.mousedown\n *\n * @type {Object}\n * @property {Element} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has gone up on an element.\n *\n * @event element.mouseup\n *\n * @type {Object}\n * @property {Element} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the context menu action is triggered\n * via mouse or touch controls.\n *\n * @event element.contextmenu\n *\n * @type {Object}\n * @property {Element} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/interaction-events/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const interaction_events = ({\n  __init__: [ 'interactionEvents' ],\n  interactionEvents: [ 'type', InteractionEvents ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/interaction-events/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/keyboard-move-selection/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ keyboard_move_selection)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/index.js + 1 modules\nvar keyboard = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/keyboard-move-selection/KeyboardMoveSelection.js\n\n\n/**\n * @typedef {import('../keyboard/Keyboard').default} Keyboard\n * @typedef {import('../modeling/Modeling').default} Modeling\n * @typedef {import('../rules/Rules').default} Rules\n * @typedef {import('../selection/Selection').default} Selection\n */\n\nvar DEFAULT_CONFIG = {\n  moveSpeed: 1,\n  moveSpeedAccelerated: 10\n};\n\nvar HIGHER_PRIORITY = 1500;\n\nvar LEFT = 'left';\nvar UP = 'up';\nvar RIGHT = 'right';\nvar DOWN = 'down';\n\nvar KEY_TO_DIRECTION = {\n  ArrowLeft: LEFT,\n  Left: LEFT,\n  ArrowUp: UP,\n  Up: UP,\n  ArrowRight: RIGHT,\n  Right: RIGHT,\n  ArrowDown: DOWN,\n  Down: DOWN\n};\n\nvar DIRECTIONS_DELTA = {\n  left: function(speed) {\n    return {\n      x: -speed,\n      y: 0\n    };\n  },\n  up: function(speed) {\n    return {\n      x: 0,\n      y: -speed\n    };\n  },\n  right: function(speed) {\n    return {\n      x: speed,\n      y: 0\n    };\n  },\n  down: function(speed) {\n    return {\n      x: 0,\n      y: speed\n    };\n  }\n};\n\n\n/**\n * Enables to move selection with keyboard arrows.\n * Use with Shift for modified speed (default=1, with Shift=10).\n * Pressed Cmd/Ctrl turns the feature off.\n *\n * @param {Object} config\n * @param {number} [config.moveSpeed=1]\n * @param {number} [config.moveSpeedAccelerated=10]\n * @param {Keyboard} keyboard\n * @param {Modeling} modeling\n * @param {Rules} rules\n * @param {Selection} selection\n */\nfunction KeyboardMoveSelection(\n    config,\n    keyboard,\n    modeling,\n    rules,\n    selection\n) {\n\n  var self = this;\n\n  this._config = (0,index_esm/* assign */.f0)({}, DEFAULT_CONFIG, config || {});\n\n  keyboard.addListener(HIGHER_PRIORITY, function(event) {\n\n    var keyEvent = event.keyEvent;\n\n    var direction = KEY_TO_DIRECTION[keyEvent.key];\n\n    if (!direction) {\n      return;\n    }\n\n    if (keyboard.isCmd(keyEvent)) {\n      return;\n    }\n\n    var accelerated = keyboard.isShift(keyEvent);\n\n    self.moveSelection(direction, accelerated);\n\n    return true;\n  });\n\n\n  /**\n   * Move selected elements in the given direction,\n   * optionally specifying accelerated movement.\n   *\n   * @param {string} direction\n   * @param {boolean} [accelerated=false]\n   */\n  this.moveSelection = function(direction, accelerated) {\n\n    var selectedElements = selection.get();\n\n    if (!selectedElements.length) {\n      return;\n    }\n\n    var speed = this._config[\n      accelerated ?\n        'moveSpeedAccelerated' :\n        'moveSpeed'\n    ];\n\n    var delta = DIRECTIONS_DELTA[direction](speed);\n\n    var canMove = rules.allowed('elements.move', {\n      shapes: selectedElements\n    });\n\n    if (canMove) {\n      modeling.moveElements(selectedElements, delta);\n    }\n  };\n\n}\n\nKeyboardMoveSelection.$inject = [\n  'config.keyboardMoveSelection',\n  'keyboard',\n  'modeling',\n  'rules',\n  'selection'\n];\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/keyboard-move-selection/index.js\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const keyboard_move_selection = ({\n  __depends__: [\n    keyboard/* default */.Z,\n    selection/* default */.Z\n  ],\n  __init__: [\n    'keyboardMoveSelection'\n  ],\n  keyboardMoveSelection: [ 'type', KeyboardMoveSelection ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/keyboard-move-selection/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/keyboard/KeyboardBindings.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ZP\": () => (/* binding */ KeyboardBindings)\n/* harmony export */ });\n/* harmony import */ var _KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n\n\n/**\n * @typedef {import('../editor-actions/EditorActions').default} EditorActions\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('./Keyboard').default} Keyboard\n */\n\n\n\n\nvar LOW_PRIORITY = 500;\n\n\n/**\n * Adds default keyboard bindings.\n *\n * This does not pull in any features will bind only actions that\n * have previously been registered against the editorActions component.\n *\n * @param {EventBus} eventBus\n * @param {Keyboard} keyboard\n */\nfunction KeyboardBindings(eventBus, keyboard) {\n\n  var self = this;\n\n  eventBus.on('editorActions.init', LOW_PRIORITY, function(event) {\n\n    var editorActions = event.editorActions;\n\n    self.registerBindings(keyboard, editorActions);\n  });\n}\n\nKeyboardBindings.$inject = [\n  'eventBus',\n  'keyboard'\n];\n\n\n/**\n * Register available keyboard bindings.\n *\n * @param {Keyboard} keyboard\n * @param {EditorActions} editorActions\n */\nKeyboardBindings.prototype.registerBindings = function(keyboard, editorActions) {\n\n  /**\n   * Add keyboard binding if respective editor action\n   * is registered.\n   *\n   * @param {string} action name\n   * @param {Function} fn that implements the key binding\n   */\n  function addListener(action, fn) {\n\n    if (editorActions.isRegistered(action)) {\n      keyboard.addListener(fn);\n    }\n  }\n\n\n  // undo\n  // (CTRL|CMD) + Z\n  addListener('undo', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isUndo */ .YW)(event)) {\n      editorActions.trigger('undo');\n\n      return true;\n    }\n  });\n\n  // redo\n  // CTRL + Y\n  // CMD + SHIFT + Z\n  addListener('redo', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isRedo */ .LO)(event)) {\n      editorActions.trigger('redo');\n\n      return true;\n    }\n  });\n\n  // copy\n  // CTRL/CMD + C\n  addListener('copy', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isCopy */ .wL)(event)) {\n      editorActions.trigger('copy');\n\n      return true;\n    }\n  });\n\n  // paste\n  // CTRL/CMD + V\n  addListener('paste', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isPaste */ .fZ)(event)) {\n      editorActions.trigger('paste');\n\n      return true;\n    }\n  });\n\n  // zoom in one step\n  // CTRL/CMD + +\n  addListener('stepZoom', function(context) {\n\n    var event = context.keyEvent;\n\n    // quirk: it has to be triggered by `=` as well to work on international keyboard layout\n    // cf: https://github.com/bpmn-io/bpmn-js/issues/1362#issuecomment-722989754\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isKey */ .ot)([ '+', 'Add', '=' ], event) && (0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isCmd */ .JS)(event)) {\n      editorActions.trigger('stepZoom', { value: 1 });\n\n      return true;\n    }\n  });\n\n  // zoom out one step\n  // CTRL + -\n  addListener('stepZoom', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isKey */ .ot)([ '-', 'Subtract' ], event) && (0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isCmd */ .JS)(event)) {\n      editorActions.trigger('stepZoom', { value: -1 });\n\n      return true;\n    }\n  });\n\n  // zoom to the default level\n  // CTRL + 0\n  addListener('zoom', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isKey */ .ot)('0', event) && (0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isCmd */ .JS)(event)) {\n      editorActions.trigger('zoom', { value: 1 });\n\n      return true;\n    }\n  });\n\n  // delete selected element\n  // DEL\n  addListener('removeSelection', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isKey */ .ot)([ 'Backspace', 'Delete', 'Del' ], event)) {\n      editorActions.trigger('removeSelection');\n\n      return true;\n    }\n  });\n};\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/keyboard/KeyboardBindings.js?")},"./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "JS": () => (/* binding */ isCmd),\n/* harmony export */   "LO": () => (/* binding */ isRedo),\n/* harmony export */   "YW": () => (/* binding */ isUndo),\n/* harmony export */   "aw": () => (/* binding */ hasModifier),\n/* harmony export */   "cY": () => (/* binding */ isShift),\n/* harmony export */   "fZ": () => (/* binding */ isPaste),\n/* harmony export */   "ot": () => (/* binding */ isKey),\n/* harmony export */   "wL": () => (/* binding */ isCopy)\n/* harmony export */ });\n/* unused harmony exports KEYS_COPY, KEYS_PASTE, KEYS_REDO, KEYS_UNDO */\nif ("bpmnEntTaskResizeModule" != __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js");\n}\n\r\n\r\nvar KEYS_COPY = (/* runtime-dependent pure expression or super */ "bpmnEntTaskResizeModule" != __webpack_require__.j ? ([ \'c\', \'C\' ]) : null);\r\nvar KEYS_PASTE = (/* runtime-dependent pure expression or super */ "bpmnEntTaskResizeModule" != __webpack_require__.j ? ([ \'v\', \'V\' ]) : null);\r\nvar KEYS_REDO = (/* runtime-dependent pure expression or super */ "bpmnEntTaskResizeModule" != __webpack_require__.j ? ([ \'y\', \'Y\' ]) : null);\r\nvar KEYS_UNDO = (/* runtime-dependent pure expression or super */ "bpmnEntTaskResizeModule" != __webpack_require__.j ? ([ \'z\', \'Z\' ]) : null);\r\n\r\n/**\r\n * Returns true if event was triggered with any modifier\r\n * @param {KeyboardEvent} event\r\n */\r\nfunction hasModifier(event) {\r\n  return (event.ctrlKey || event.metaKey || event.shiftKey || event.altKey);\r\n}\r\n\r\n/**\r\n * @param {KeyboardEvent} event\r\n * @return {boolean}\r\n */\r\nfunction isCmd(event) {\r\n\r\n  // ensure we don\'t react to AltGr\r\n  // (mapped to CTRL + ALT)\r\n  if (event.altKey) {\r\n    return false;\r\n  }\r\n\r\n  return event.ctrlKey || event.metaKey;\r\n}\r\n\r\n/**\r\n * Checks if key pressed is one of provided keys.\r\n *\r\n * @param {string|string[]} keys\r\n * @param {KeyboardEvent} event\r\n * @return {boolean}\r\n */\r\nfunction isKey(keys, event) {\r\n  keys = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .kJ)(keys) ? keys : [ keys ];\r\n\r\n  return keys.indexOf(event.key) !== -1 || keys.indexOf(event.code) !== -1;\r\n}\r\n\r\n/**\r\n * @param {KeyboardEvent} event\r\n */\r\nfunction isShift(event) {\r\n  return event.shiftKey;\r\n}\r\n\r\n/**\r\n * @param {KeyboardEvent} event\r\n */\r\nfunction isCopy(event) {\r\n  return isCmd(event) && isKey(KEYS_COPY, event);\r\n}\r\n\r\n/**\r\n * @param {KeyboardEvent} event\r\n */\r\nfunction isPaste(event) {\r\n  return isCmd(event) && isKey(KEYS_PASTE, event);\r\n}\r\n\r\n/**\r\n * @param {KeyboardEvent} event\r\n */\r\nfunction isUndo(event) {\r\n  return isCmd(event) && !isShift(event) && isKey(KEYS_UNDO, event);\r\n}\r\n\r\n/**\r\n * @param {KeyboardEvent} event\r\n */\r\nfunction isRedo(event) {\r\n  return isCmd(event) && (\r\n    isKey(KEYS_REDO, event) || (\r\n      isKey(KEYS_UNDO, event) && isShift(event)\r\n    )\r\n  );\r\n}\r\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js?')},"./node_modules/diagram-js/lib/features/keyboard/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ keyboard)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\nvar KeyboardUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/keyboard/Keyboard.js\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/EventBus').default} EventBus\n *\n * @typedef {({ keyEvent: KeyboardEvent }) => any} Listener\n */\n\nvar KEYDOWN_EVENT = 'keyboard.keydown',\n    KEYUP_EVENT = 'keyboard.keyup';\n\nvar HANDLE_MODIFIER_ATTRIBUTE = 'input-handle-modified-keys';\n\nvar DEFAULT_PRIORITY = 1000;\n\n/**\n * A keyboard abstraction that may be activated and\n * deactivated by users at will, consuming global key events\n * and triggering diagram actions.\n *\n * For keys pressed down, keyboard fires `keyboard.keydown` event.\n * The event context contains one field which is `KeyboardEvent` event.\n *\n * The implementation fires the following key events that allow\n * other components to hook into key handling:\n *\n *  - keyboard.bind\n *  - keyboard.unbind\n *  - keyboard.init\n *  - keyboard.destroy\n *\n * All events contain one field which is node.\n *\n * A default binding for the keyboard may be specified via the\n * `keyboard.bindTo` configuration option.\n *\n * @param {Object} config\n * @param {EventTarget} [config.bindTo]\n * @param {EventBus} eventBus\n */\nfunction Keyboard(config, eventBus) {\n  var self = this;\n\n  this._config = config || {};\n  this._eventBus = eventBus;\n\n  this._keydownHandler = this._keydownHandler.bind(this);\n  this._keyupHandler = this._keyupHandler.bind(this);\n\n  // properly clean dom registrations\n  eventBus.on('diagram.destroy', function() {\n    self._fire('destroy');\n\n    self.unbind();\n  });\n\n  eventBus.on('diagram.init', function() {\n    self._fire('init');\n  });\n\n  eventBus.on('attach', function() {\n    if (config && config.bindTo) {\n      self.bind(config.bindTo);\n    }\n  });\n\n  eventBus.on('detach', function() {\n    self.unbind();\n  });\n}\n\nKeyboard.$inject = [\n  'config.keyboard',\n  'eventBus'\n];\n\nKeyboard.prototype._keydownHandler = function(event) {\n  this._keyHandler(event, KEYDOWN_EVENT);\n};\n\nKeyboard.prototype._keyupHandler = function(event) {\n  this._keyHandler(event, KEYUP_EVENT);\n};\n\nKeyboard.prototype._keyHandler = function(event, type) {\n  var eventBusResult;\n\n  if (this._isEventIgnored(event)) {\n    return;\n  }\n\n  var context = {\n    keyEvent: event\n  };\n\n  eventBusResult = this._eventBus.fire(type || KEYDOWN_EVENT, context);\n\n  if (eventBusResult) {\n    event.preventDefault();\n  }\n};\n\nKeyboard.prototype._isEventIgnored = function(event) {\n  if (event.defaultPrevented) {\n    return true;\n  }\n\n  return isInput(event.target) && this._isModifiedKeyIgnored(event);\n};\n\nKeyboard.prototype._isModifiedKeyIgnored = function(event) {\n  if (!(0,KeyboardUtil/* isCmd */.JS)(event)) {\n    return true;\n  }\n\n  var allowedModifiers = this._getAllowedModifiers(event.target);\n  return allowedModifiers.indexOf(event.key) === -1;\n};\n\nKeyboard.prototype._getAllowedModifiers = function(element) {\n  var modifierContainer = (0,dist_index_esm/* closest */.oq)(element, '[' + HANDLE_MODIFIER_ATTRIBUTE + ']', true);\n\n  if (!modifierContainer || (this._node && !this._node.contains(modifierContainer))) {\n    return [];\n  }\n\n  return modifierContainer.getAttribute(HANDLE_MODIFIER_ATTRIBUTE).split(',');\n};\n\n/**\n * Bind keyboard events to the given DOM node.\n *\n * @param {EventTarget} node\n */\nKeyboard.prototype.bind = function(node) {\n\n  // make sure that the keyboard is only bound once to the DOM\n  this.unbind();\n\n  this._node = node;\n\n  // bind key events\n  dist_index_esm/* event.bind */.B.bind(node, 'keydown', this._keydownHandler);\n  dist_index_esm/* event.bind */.B.bind(node, 'keyup', this._keyupHandler);\n\n  this._fire('bind');\n};\n\n/**\n * @return {EventTarget}\n */\nKeyboard.prototype.getBinding = function() {\n  return this._node;\n};\n\nKeyboard.prototype.unbind = function() {\n  var node = this._node;\n\n  if (node) {\n    this._fire('unbind');\n\n    // unbind key events\n    dist_index_esm/* event.unbind */.B.unbind(node, 'keydown', this._keydownHandler);\n    dist_index_esm/* event.unbind */.B.unbind(node, 'keyup', this._keyupHandler);\n  }\n\n  this._node = null;\n};\n\n/**\n * @param {string} event\n */\nKeyboard.prototype._fire = function(event) {\n  this._eventBus.fire('keyboard.' + event, { node: this._node });\n};\n\n/**\n * Add a listener function that is notified with `KeyboardEvent` whenever\n * the keyboard is bound and the user presses a key. If no priority is\n * provided, the default value of 1000 is used.\n *\n * @param {number} [priority]\n * @param {Listener} listener\n * @param {string} [type='keyboard.keydown']\n */\nKeyboard.prototype.addListener = function(priority, listener, type) {\n  if ((0,index_esm/* isFunction */.mf)(priority)) {\n    type = listener;\n    listener = priority;\n    priority = DEFAULT_PRIORITY;\n  }\n\n  this._eventBus.on(type || KEYDOWN_EVENT, priority, listener);\n};\n\n/**\n * Remove a listener function.\n *\n * @param {Listener} listener\n * @param {string} [type='keyboard.keydown']\n */\nKeyboard.prototype.removeListener = function(listener, type) {\n  this._eventBus.off(type || KEYDOWN_EVENT, listener);\n};\n\nKeyboard.prototype.hasModifier = KeyboardUtil/* hasModifier */.aw;\nKeyboard.prototype.isCmd = KeyboardUtil/* isCmd */.JS;\nKeyboard.prototype.isShift = KeyboardUtil/* isShift */.cY;\nKeyboard.prototype.isKey = KeyboardUtil/* isKey */.ot;\n\n\n\n// helpers ///////\n\nfunction isInput(target) {\n  return target && ((0,dist_index_esm/* matches */.wB)(target, 'input, textarea') || target.contentEditable === 'true');\n}\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/KeyboardBindings.js\nvar KeyboardBindings = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/KeyboardBindings.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/keyboard/index.js\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const keyboard = ({\n  __init__: [ 'keyboard', 'keyboardBindings' ],\n  keyboard: [ 'type', Keyboard ],\n  keyboardBindings: [ 'type', KeyboardBindings/* default */.ZP ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/keyboard/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/label-support/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ label_support)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/inherits-browser/dist/index.es.js\nvar index_es = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Collections.js\nvar Collections = __webpack_require__(\"./node_modules/diagram-js/lib/util/Collections.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Removal.js\nvar Removal = __webpack_require__(\"./node_modules/diagram-js/lib/util/Removal.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/command/CommandInterceptor.js\nvar CommandInterceptor = __webpack_require__(\"./node_modules/diagram-js/lib/command/CommandInterceptor.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/label-support/LabelSupport.js\n\n\n\n\nvar LOW_PRIORITY = 250,\n    HIGH_PRIORITY = 1400;\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../model/Types').Element} Element\n *\n * @typedef {import('didi').Injector} Injector\n *\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../modeling/Modeling').default} Modeling\n */\n\n/**\n * A handler that makes sure labels are properly moved with\n * their label targets.\n *\n * @param {Injector} injector\n * @param {EventBus} eventBus\n * @param {Modeling} modeling\n */\nfunction LabelSupport(injector, eventBus, modeling) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  var movePreview = injector.get('movePreview', false);\n\n  // remove labels from the collection that are being\n  // moved with other elements anyway\n  eventBus.on('shape.move.start', HIGH_PRIORITY, function(e) {\n\n    var context = e.context,\n        shapes = context.shapes,\n        validatedShapes = context.validatedShapes;\n\n    context.shapes = removeLabels(shapes);\n    context.validatedShapes = removeLabels(validatedShapes);\n  });\n\n  // add labels to visual's group\n  movePreview && eventBus.on('shape.move.start', LOW_PRIORITY, function(e) {\n\n    var context = e.context,\n        shapes = context.shapes;\n\n    var labels = [];\n\n    (0,index_esm/* forEach */.Ed)(shapes, function(element) {\n\n      (0,index_esm/* forEach */.Ed)(element.labels, function(label) {\n\n        if (!label.hidden && context.shapes.indexOf(label) === -1) {\n          labels.push(label);\n        }\n\n        if (element.labelTarget) {\n          labels.push(element);\n        }\n      });\n    });\n\n    (0,index_esm/* forEach */.Ed)(labels, function(label) {\n      movePreview.makeDraggable(context, label, true);\n    });\n\n  });\n\n  // add all labels to move closure\n  this.preExecuted('elements.move', HIGH_PRIORITY, function(e) {\n    var context = e.context,\n        closure = context.closure,\n        enclosedElements = closure.enclosedElements;\n\n    var enclosedLabels = [];\n\n    // find labels that are not part of\n    // move closure yet and add them\n    (0,index_esm/* forEach */.Ed)(enclosedElements, function(element) {\n      (0,index_esm/* forEach */.Ed)(element.labels, function(label) {\n\n        if (!enclosedElements[label.id]) {\n          enclosedLabels.push(label);\n        }\n      });\n    });\n\n    closure.addAll(enclosedLabels);\n  });\n\n\n  this.preExecute([\n    'connection.delete',\n    'shape.delete'\n  ], function(e) {\n\n    var context = e.context,\n        element = context.connection || context.shape;\n\n    (0,Removal/* saveClear */.r)(element.labels, function(label) {\n      modeling.removeShape(label, { nested: true });\n    });\n  });\n\n\n  this.execute('shape.delete', function(e) {\n\n    var context = e.context,\n        shape = context.shape,\n        labelTarget = shape.labelTarget;\n\n    // unset labelTarget\n    if (labelTarget) {\n      context.labelTargetIndex = (0,Collections/* indexOf */.cq)(labelTarget.labels, shape);\n      context.labelTarget = labelTarget;\n\n      shape.labelTarget = null;\n    }\n  });\n\n  this.revert('shape.delete', function(e) {\n\n    var context = e.context,\n        shape = context.shape,\n        labelTarget = context.labelTarget,\n        labelTargetIndex = context.labelTargetIndex;\n\n    // restore labelTarget\n    if (labelTarget) {\n      (0,Collections/* add */.IH)(labelTarget.labels, shape, labelTargetIndex);\n\n      shape.labelTarget = labelTarget;\n    }\n  });\n\n}\n\n(0,index_es/* default */.Z)(LabelSupport, CommandInterceptor/* default */.Z);\n\nLabelSupport.$inject = [\n  'injector',\n  'eventBus',\n  'modeling'\n];\n\n\n/**\n * Return a filtered list of elements that do not\n * contain attached elements with hosts being part\n * of the selection.\n *\n * @param {Element[]} elements\n *\n * @return {Element[]} filtered\n */\nfunction removeLabels(elements) {\n\n  return (0,index_esm/* filter */.hX)(elements, function(element) {\n\n    // filter out labels that are move together\n    // with their label targets\n    return elements.indexOf(element.labelTarget) === -1;\n  });\n}\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/label-support/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const label_support = ({\n  __init__: [ 'labelSupport' ],\n  labelSupport: [ 'type', LabelSupport ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/label-support/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/lasso-tool/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ lasso_tool)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/tool-manager/index.js + 1 modules\nvar tool_manager = __webpack_require__(\"./node_modules/diagram-js/lib/features/tool-manager/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/mouse/index.js + 1 modules\nvar mouse = __webpack_require__(\"./node_modules/diagram-js/lib/features/mouse/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Mouse.js\nvar Mouse = __webpack_require__(\"./node_modules/diagram-js/lib/util/Mouse.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/lasso-tool/LassoTool.js\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../dragging/Dragging').default} Dragging\n * @typedef {import('../../core/ElementRegistry').default} ElementRegistry\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../mouse/Mouse').default} Mouse\n * @typedef {import('../selection/Selection').default} Selection\n * @typedef {import('../tool-manager/ToolManager').default} ToolManager\n */\n\nvar LASSO_TOOL_CURSOR = 'crosshair';\n\n/**\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {Dragging} dragging\n * @param {ElementRegistry} elementRegistry\n * @param {Selection} selection\n * @param {ToolManager} toolManager\n * @param {Mouse} mouse\n */\nfunction LassoTool(\n    eventBus, canvas, dragging,\n    elementRegistry, selection, toolManager,\n    mouse) {\n\n  this._selection = selection;\n  this._dragging = dragging;\n  this._mouse = mouse;\n\n  var self = this;\n\n  // lasso visuals implementation\n\n  /**\n  * A helper that realizes the selection box visual\n  */\n  var visuals = {\n\n    create: function(context) {\n      var container = canvas.getActiveLayer(),\n          frame;\n\n      frame = context.frame = (0,dist_index_esm/* create */.Ue)('rect');\n      (0,dist_index_esm/* attr */.Lj)(frame, {\n        class: 'djs-lasso-overlay',\n        width:  1,\n        height: 1,\n        x: 0,\n        y: 0\n      });\n\n      (0,dist_index_esm/* append */.R3)(container, frame);\n    },\n\n    update: function(context) {\n      var frame = context.frame,\n          bbox = context.bbox;\n\n      (0,dist_index_esm/* attr */.Lj)(frame, {\n        x: bbox.x,\n        y: bbox.y,\n        width: bbox.width,\n        height: bbox.height\n      });\n    },\n\n    remove: function(context) {\n\n      if (context.frame) {\n        (0,dist_index_esm/* remove */.Od)(context.frame);\n      }\n    }\n  };\n\n  toolManager.registerTool('lasso', {\n    tool: 'lasso.selection',\n    dragging: 'lasso'\n  });\n\n  eventBus.on('lasso.selection.end', function(event) {\n    var target = event.originalEvent.target;\n\n    // only reactive on diagram click\n    // on some occasions, event.hover is not set and we have to check if the target is an svg\n    if (!event.hover && !(target instanceof SVGElement)) {\n      return;\n    }\n\n    eventBus.once('lasso.selection.ended', function() {\n      self.activateLasso(event.originalEvent, true);\n    });\n  });\n\n  // lasso interaction implementation\n\n  eventBus.on('lasso.end', function(event) {\n\n    var bbox = toBBox(event);\n\n    var elements = elementRegistry.filter(function(element) {\n      return element;\n    });\n\n    self.select(elements, bbox);\n  });\n\n  eventBus.on('lasso.start', function(event) {\n\n    var context = event.context;\n\n    context.bbox = toBBox(event);\n    visuals.create(context);\n  });\n\n  eventBus.on('lasso.move', function(event) {\n\n    var context = event.context;\n\n    context.bbox = toBBox(event);\n    visuals.update(context);\n  });\n\n  eventBus.on('lasso.cleanup', function(event) {\n\n    var context = event.context;\n\n    visuals.remove(context);\n  });\n\n\n  // event integration\n\n  eventBus.on('element.mousedown', 1500, function(event) {\n\n    if (!(0,Mouse/* hasSecondaryModifier */.Dw)(event)) {\n      return;\n    }\n\n    self.activateLasso(event.originalEvent);\n\n    // we've handled the event\n    return true;\n  });\n}\n\nLassoTool.$inject = [\n  'eventBus',\n  'canvas',\n  'dragging',\n  'elementRegistry',\n  'selection',\n  'toolManager',\n  'mouse'\n];\n\n\nLassoTool.prototype.activateLasso = function(event, autoActivate) {\n\n  this._dragging.init(event, 'lasso', {\n    autoActivate: autoActivate,\n    cursor: LASSO_TOOL_CURSOR,\n    data: {\n      context: {}\n    }\n  });\n};\n\nLassoTool.prototype.activateSelection = function(event, autoActivate) {\n\n  this._dragging.init(event, 'lasso.selection', {\n    trapClick: false,\n    autoActivate: autoActivate,\n    cursor: LASSO_TOOL_CURSOR,\n    data: {\n      context: {}\n    }\n  });\n};\n\nLassoTool.prototype.select = function(elements, bbox) {\n  var selectedElements = (0,Elements/* getEnclosedElements */.RH)(elements, bbox);\n\n  this._selection.select((0,index_esm/* values */.VO)(selectedElements));\n};\n\nLassoTool.prototype.toggle = function() {\n  if (this.isActive()) {\n    return this._dragging.cancel();\n  }\n\n  var mouseEvent = this._mouse.getLastMoveEvent();\n\n  this.activateSelection(mouseEvent, !!mouseEvent);\n};\n\nLassoTool.prototype.isActive = function() {\n  var context = this._dragging.context();\n\n  return context && /^lasso/.test(context.prefix);\n};\n\n\n\nfunction toBBox(event) {\n\n  var start = {\n\n    x: event.x - event.dx,\n    y: event.y - event.dy\n  };\n\n  var end = {\n    x: event.x,\n    y: event.y\n  };\n\n  var bbox;\n\n  if ((start.x <= end.x && start.y < end.y) ||\n      (start.x < end.x && start.y <= end.y)) {\n\n    bbox = {\n      x: start.x,\n      y: start.y,\n      width:  end.x - start.x,\n      height: end.y - start.y\n    };\n  } else if ((start.x >= end.x && start.y < end.y) ||\n             (start.x > end.x && start.y <= end.y)) {\n\n    bbox = {\n      x: end.x,\n      y: start.y,\n      width:  start.x - end.x,\n      height: end.y - start.y\n    };\n  } else if ((start.x <= end.x && start.y > end.y) ||\n             (start.x < end.x && start.y >= end.y)) {\n\n    bbox = {\n      x: start.x,\n      y: end.y,\n      width:  end.x - start.x,\n      height: start.y - end.y\n    };\n  } else if ((start.x >= end.x && start.y > end.y) ||\n             (start.x > end.x && start.y >= end.y)) {\n\n    bbox = {\n      x: end.x,\n      y: end.y,\n      width:  start.x - end.x,\n      height: start.y - end.y\n    };\n  } else {\n\n    bbox = {\n      x: end.x,\n      y: end.y,\n      width:  0,\n      height: 0\n    };\n  }\n  return bbox;\n}\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/lasso-tool/index.js\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const lasso_tool = ({\n  __depends__: [\n    tool_manager/* default */.Z,\n    mouse/* default */.Z\n  ],\n  __init__: [ 'lassoTool' ],\n  lassoTool: [ 'type', LassoTool ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/lasso-tool/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/modeling/Modeling.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ Modeling)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/AlignElementsHandler.js\n\n\n/**\n * @typedef {import('../../../core/Canvas').default} Canvas\n * @typedef {import('../Modeling').default} Modeling\n */\n\n/**\n * A handler that align elements in a certain way.\n *\n * @param {Modeling} modeling\n * @param {Canvas} canvas\n */\nfunction AlignElements(modeling, canvas) {\n  this._modeling = modeling;\n  this._canvas = canvas;\n}\n\nAlignElements.$inject = [ 'modeling', 'canvas' ];\n\n\nAlignElements.prototype.preExecute = function(context) {\n  var modeling = this._modeling;\n\n  var elements = context.elements,\n      alignment = context.alignment;\n\n\n  (0,index_esm/* forEach */.Ed)(elements, function(element) {\n    var delta = {\n      x: 0,\n      y: 0\n    };\n\n    if ((0,index_esm/* isDefined */.$K)(alignment.left)) {\n      delta.x = alignment.left - element.x;\n\n    } else if ((0,index_esm/* isDefined */.$K)(alignment.right)) {\n      delta.x = (alignment.right - element.width) - element.x;\n\n    } else if ((0,index_esm/* isDefined */.$K)(alignment.center)) {\n      delta.x = (alignment.center - Math.round(element.width / 2)) - element.x;\n\n    } else if ((0,index_esm/* isDefined */.$K)(alignment.top)) {\n      delta.y = alignment.top - element.y;\n\n    } else if ((0,index_esm/* isDefined */.$K)(alignment.bottom)) {\n      delta.y = (alignment.bottom - element.height) - element.y;\n\n    } else if ((0,index_esm/* isDefined */.$K)(alignment.middle)) {\n      delta.y = (alignment.middle - Math.round(element.height / 2)) - element.y;\n    }\n\n    modeling.moveElements([ element ], delta, element.parent);\n  });\n};\n\nAlignElements.prototype.postExecute = function(context) {\n\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/AppendShapeHandler.js\n\n\n/**\n * @typedef {import('../../../model/Types').Element} Element\n * @typedef {import('../../../model/Types').Parent} Parent\n * @typedef {import('../../../model/Types').Shape} Shape\n *\n * @typedef {import('../../../util/Types').Point} Point\n *\n * @typedef {import('../Modeling').default} Modeling\n */\n\n/**\n * A handler that implements reversible appending of shapes\n * to a source shape.\n *\n * @param {Modeling} modeling\n */\nfunction AppendShapeHandler(modeling) {\n  this._modeling = modeling;\n}\n\nAppendShapeHandler.$inject = [ 'modeling' ];\n\n\n// api //////////////////////\n\n\n/**\n * Creates a new shape.\n *\n * @param {Object} context\n * @param {Partial<Shape>} context.shape The new shape.\n * @param {Element} context.source The element to which to append the new shape to.\n * @param {Parent} context.parent The parent.\n * @param {Point} context.position The position at which to create the new shape.\n */\nAppendShapeHandler.prototype.preExecute = function(context) {\n\n  var source = context.source;\n\n  if (!source) {\n    throw new Error('source required');\n  }\n\n  var target = context.target || source.parent,\n      shape = context.shape,\n      hints = context.hints || {};\n\n  shape = context.shape =\n    this._modeling.createShape(\n      shape,\n      context.position,\n      target, { attach: hints.attach });\n\n  context.shape = shape;\n};\n\nAppendShapeHandler.prototype.postExecute = function(context) {\n  var hints = context.hints || {};\n\n  if (!existsConnection(context.source, context.shape)) {\n\n    // create connection\n    if (hints.connectionTarget === context.source) {\n      this._modeling.connect(context.shape, context.source, context.connection);\n    } else {\n      this._modeling.connect(context.source, context.shape, context.connection);\n    }\n  }\n};\n\n\nfunction existsConnection(source, target) {\n  return (0,index_esm/* some */.G)(source.outgoing, function(c) {\n    return c.target === target;\n  });\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/CreateConnectionHandler.js\n/**\n * @typedef {import('../../../model/Types').Element} Element\n * @typedef {import('../../../model/Types').Shape} Shape\n *\n * @typedef {import('../../../util/Types').Point} Point\n *\n * @typedef {import('../Modeling').ModelingHints} ModelingHints\n *\n * @typedef {import('../../../core/Canvas').default} Canvas\n * @typedef {import('../../../layout/BaseLayouter').default} Layouter\n */\n\n/**\n * @param {Canvas} canvas\n * @param {Layouter} layouter\n */\nfunction CreateConnectionHandler(canvas, layouter) {\n  this._canvas = canvas;\n  this._layouter = layouter;\n}\n\nCreateConnectionHandler.$inject = [ 'canvas', 'layouter' ];\n\n\n// api //////////////////////\n\n\n/**\n * Creates a new connection between two elements.\n *\n * @param {Object} context\n * @param {Element} context.source The source.\n * @param {Element} context.target The target.\n * @param {Shape} context.parent The parent.\n * @param {number} [context.parentIndex] The optional index at which to add the\n * connection to the parent's children.\n * @param {ModelingHints} [context.hints] The optional hints.\n */\nCreateConnectionHandler.prototype.execute = function(context) {\n\n  var connection = context.connection,\n      source = context.source,\n      target = context.target,\n      parent = context.parent,\n      parentIndex = context.parentIndex,\n      hints = context.hints;\n\n  if (!source || !target) {\n    throw new Error('source and target required');\n  }\n\n  if (!parent) {\n    throw new Error('parent required');\n  }\n\n  connection.source = source;\n  connection.target = target;\n\n  if (!connection.waypoints) {\n    connection.waypoints = this._layouter.layoutConnection(connection, hints);\n  }\n\n  // add connection\n  this._canvas.addConnection(connection, parent, parentIndex);\n\n  return connection;\n};\n\nCreateConnectionHandler.prototype.revert = function(context) {\n  var connection = context.connection;\n\n  this._canvas.removeConnection(connection);\n\n  connection.source = null;\n  connection.target = null;\n\n  return connection;\n};\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/ModelUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/CreateElementsHandler.js\n\r\n\r\n\r\n\r\n\r\n\r\n/**\r\n * @typedef {import('../Modeling').default} Modeling\r\n */\r\n\r\nvar round = Math.round;\r\n\r\n/**\r\n * @param {Modeling} modeling\r\n */\r\nfunction CreateElementsHandler(modeling) {\r\n  this._modeling = modeling;\r\n}\r\n\r\nCreateElementsHandler.$inject = [\r\n  'modeling'\r\n];\r\n\r\nCreateElementsHandler.prototype.preExecute = function(context) {\r\n  var elements = context.elements,\r\n      parent = context.parent,\r\n      parentIndex = context.parentIndex,\r\n      position = context.position,\r\n      hints = context.hints;\r\n\r\n  var modeling = this._modeling;\r\n\r\n  // make sure each element has x and y\r\n  (0,index_esm/* forEach */.Ed)(elements, function(element) {\r\n    if (!(0,index_esm/* isNumber */.hj)(element.x)) {\r\n      element.x = 0;\r\n    }\r\n\r\n    if (!(0,index_esm/* isNumber */.hj)(element.y)) {\r\n      element.y = 0;\r\n    }\r\n  });\r\n\r\n  var visibleElements = (0,index_esm/* filter */.hX)(elements, function(element) {\r\n    return !element.hidden;\r\n  });\r\n\r\n  var bbox = (0,Elements/* getBBox */.jY)(visibleElements);\r\n\r\n  // center elements around position\r\n  (0,index_esm/* forEach */.Ed)(elements, function(element) {\r\n    if ((0,ModelUtil/* isConnection */.Ho)(element)) {\r\n      element.waypoints = (0,index_esm/* map */.UI)(element.waypoints, function(waypoint) {\r\n        return {\r\n          x: round(waypoint.x - bbox.x - bbox.width / 2 + position.x),\r\n          y: round(waypoint.y - bbox.y - bbox.height / 2 + position.y)\r\n        };\r\n      });\r\n    }\r\n\r\n    (0,index_esm/* assign */.f0)(element, {\r\n      x: round(element.x - bbox.x - bbox.width / 2 + position.x),\r\n      y: round(element.y - bbox.y - bbox.height / 2 + position.y)\r\n    });\r\n  });\r\n\r\n  var parents = (0,Elements/* getParents */.cd)(elements);\r\n\r\n  var cache = {};\r\n\r\n  (0,index_esm/* forEach */.Ed)(elements, function(element) {\r\n    if ((0,ModelUtil/* isConnection */.Ho)(element)) {\r\n      cache[ element.id ] = (0,index_esm/* isNumber */.hj)(parentIndex) ?\r\n        modeling.createConnection(\r\n          cache[ element.source.id ],\r\n          cache[ element.target.id ],\r\n          parentIndex,\r\n          element,\r\n          element.parent || parent,\r\n          hints\r\n        ) :\r\n        modeling.createConnection(\r\n          cache[ element.source.id ],\r\n          cache[ element.target.id ],\r\n          element,\r\n          element.parent || parent,\r\n          hints\r\n        );\r\n\r\n      return;\r\n    }\r\n\r\n    var createShapeHints = (0,index_esm/* assign */.f0)({}, hints);\r\n\r\n    if (parents.indexOf(element) === -1) {\r\n      createShapeHints.autoResize = false;\r\n    }\r\n\r\n    if ((0,ModelUtil/* isLabel */.j_)(element)) {\r\n      createShapeHints = (0,index_esm/* omit */.CE)(createShapeHints, [ 'attach' ]);\r\n    }\r\n\r\n    cache[ element.id ] = (0,index_esm/* isNumber */.hj)(parentIndex) ?\r\n      modeling.createShape(\r\n        element,\r\n        (0,index_esm/* pick */.ei)(element, [ 'x', 'y', 'width', 'height' ]),\r\n        element.parent || parent,\r\n        parentIndex,\r\n        createShapeHints\r\n      ) :\r\n      modeling.createShape(\r\n        element,\r\n        (0,index_esm/* pick */.ei)(element, [ 'x', 'y', 'width', 'height' ]),\r\n        element.parent || parent,\r\n        createShapeHints\r\n      );\r\n  });\r\n\r\n  context.elements = (0,index_esm/* values */.VO)(cache);\r\n};\n// EXTERNAL MODULE: ./node_modules/inherits-browser/dist/index.es.js\nvar index_es = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/CreateShapeHandler.js\n\n\n/**\n * @typedef {import('../../../model/Types').Element} Element\n * @typedef {import('../../../util/Types').Point} Point\n *\n * @typedef {import('../../../core/Canvas').default} Canvas\n */\n\nvar CreateShapeHandler_round = Math.round;\n\n\n/**\n * A handler that implements reversible addition of shapes.\n *\n * @param {Canvas} canvas\n */\nfunction CreateShapeHandler(canvas) {\n  this._canvas = canvas;\n}\n\nCreateShapeHandler.$inject = [ 'canvas' ];\n\n\n// api //////////////////////\n\n\n/**\n * Appends a shape to a target shape\n *\n * @param {Object} context\n * @param {Element} context.parent The parent.\n * @param {Point} context.position The position at which to create the new shape.\n * @param {number} [context.parentIndex] The optional index at which to add the\n * shape to the parent's children.\n */\nCreateShapeHandler.prototype.execute = function(context) {\n\n  var shape = context.shape,\n      positionOrBounds = context.position,\n      parent = context.parent,\n      parentIndex = context.parentIndex;\n\n  if (!parent) {\n    throw new Error('parent required');\n  }\n\n  if (!positionOrBounds) {\n    throw new Error('position required');\n  }\n\n  // (1) add at event center position _or_ at given bounds\n  if (positionOrBounds.width !== undefined) {\n    (0,index_esm/* assign */.f0)(shape, positionOrBounds);\n  } else {\n    (0,index_esm/* assign */.f0)(shape, {\n      x: positionOrBounds.x - CreateShapeHandler_round(shape.width / 2),\n      y: positionOrBounds.y - CreateShapeHandler_round(shape.height / 2)\n    });\n  }\n\n  // (2) add to canvas\n  this._canvas.addShape(shape, parent, parentIndex);\n\n  return shape;\n};\n\n\n/**\n * Undo append by removing the shape\n */\nCreateShapeHandler.prototype.revert = function(context) {\n\n  var shape = context.shape;\n\n  // (3) remove form canvas\n  this._canvas.removeShape(shape);\n\n  return shape;\n};\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/CreateLabelHandler.js\n\n\n\n\n/**\n * @typedef {import('../../../core/Canvas').default} Canvas\n *\n * @typedef {import('../../../model/Types').Element} Element\n * @typedef {import('../../../model/Types').Parent} Parent\n * @typedef {import('../../../model/Types').Shape} Shape\n * @typedef {import('../../../util/Types').Point} Point\n */\n\n/**\n * A handler that attaches a label to a given target shape.\n *\n * @param {Canvas} canvas\n */\nfunction CreateLabelHandler(canvas) {\n  CreateShapeHandler.call(this, canvas);\n}\n\n(0,index_es/* default */.Z)(CreateLabelHandler, CreateShapeHandler);\n\nCreateLabelHandler.$inject = [ 'canvas' ];\n\n\n// api //////////////////////\n\n\nvar originalExecute = CreateShapeHandler.prototype.execute;\n\n/**\n * Append label to element.\n *\n * @param { {\n *   parent: Parent;\n *   position: Point;\n *   shape: Shape;\n *   target: Element;\n * } } context\n */\nCreateLabelHandler.prototype.execute = function(context) {\n\n  var label = context.shape;\n\n  ensureValidDimensions(label);\n\n  label.labelTarget = context.labelTarget;\n\n  return originalExecute.call(this, context);\n};\n\nvar originalRevert = CreateShapeHandler.prototype.revert;\n\n/**\n * Revert appending by removing label.\n */\nCreateLabelHandler.prototype.revert = function(context) {\n  context.shape.labelTarget = null;\n\n  return originalRevert.call(this, context);\n};\n\n\n// helpers //////////////////////\n\nfunction ensureValidDimensions(label) {\n\n  // make sure a label has valid { width, height } dimensions\n  [ 'width', 'height' ].forEach(function(prop) {\n    if (typeof label[prop] === 'undefined') {\n      label[prop] = 0;\n    }\n  });\n}\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Collections.js\nvar Collections = __webpack_require__(\"./node_modules/diagram-js/lib/util/Collections.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Removal.js\nvar Removal = __webpack_require__(\"./node_modules/diagram-js/lib/util/Removal.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/DeleteConnectionHandler.js\n\n\n\n\n/**\n * @typedef {import('../../../core/Canvas').default} Canvas\n * @typedef {import('../Modeling').default} Modeling\n */\n\n/**\n * A handler that implements reversible deletion of Connections.\n */\nfunction DeleteConnectionHandler(canvas, modeling) {\n  this._canvas = canvas;\n  this._modeling = modeling;\n}\n\nDeleteConnectionHandler.$inject = [\n  'canvas',\n  'modeling'\n];\n\n\n/**\n * - Remove connections\n */\nDeleteConnectionHandler.prototype.preExecute = function(context) {\n\n  var modeling = this._modeling;\n\n  var connection = context.connection;\n\n  // remove connections\n  (0,Removal/* saveClear */.r)(connection.incoming, function(connection) {\n\n    // To make sure that the connection isn't removed twice\n    // For example if a container is removed\n    modeling.removeConnection(connection, { nested: true });\n  });\n\n  (0,Removal/* saveClear */.r)(connection.outgoing, function(connection) {\n    modeling.removeConnection(connection, { nested: true });\n  });\n\n};\n\n\nDeleteConnectionHandler.prototype.execute = function(context) {\n\n  var connection = context.connection,\n      parent = connection.parent;\n\n  context.parent = parent;\n\n  // remember containment\n  context.parentIndex = (0,Collections/* indexOf */.cq)(parent.children, connection);\n\n  context.source = connection.source;\n  context.target = connection.target;\n\n  this._canvas.removeConnection(connection);\n\n  connection.source = null;\n  connection.target = null;\n\n  return connection;\n};\n\n/**\n * Command revert implementation.\n */\nDeleteConnectionHandler.prototype.revert = function(context) {\n\n  var connection = context.connection,\n      parent = context.parent,\n      parentIndex = context.parentIndex;\n\n  connection.source = context.source;\n  connection.target = context.target;\n\n  // restore containment\n  (0,Collections/* add */.IH)(parent.children, connection, parentIndex);\n\n  this._canvas.addConnection(connection, parent);\n\n  return connection;\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/DeleteElementsHandler.js\n\n\n/**\n * @typedef {import('../../../core/ElementRegistry').default} ElementRegistry\n * @typedef {import('../Modeling').default} Modeling\n */\n\n/**\n * @param {Modeling} modeling\n * @param {ElementRegistry} elementRegistry\n */\nfunction DeleteElementsHandler(modeling, elementRegistry) {\n  this._modeling = modeling;\n  this._elementRegistry = elementRegistry;\n}\n\nDeleteElementsHandler.$inject = [\n  'modeling',\n  'elementRegistry'\n];\n\n\nDeleteElementsHandler.prototype.postExecute = function(context) {\n\n  var modeling = this._modeling,\n      elementRegistry = this._elementRegistry,\n      elements = context.elements;\n\n  (0,index_esm/* forEach */.Ed)(elements, function(element) {\n\n    // element may have been removed with previous\n    // remove operations already (e.g. in case of nesting)\n    if (!elementRegistry.get(element.id)) {\n      return;\n    }\n\n    if (element.waypoints) {\n      modeling.removeConnection(element);\n    } else {\n      modeling.removeShape(element);\n    }\n  });\n};\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/DeleteShapeHandler.js\n\n\n\n\n\n\n/**\n * @typedef {import('../../../core/Canvas').default} Canvas\n * @typedef {import('../Modeling').default} Modeling\n */\n\n/**\n * A handler that implements reversible deletion of shapes.\n *\n * @param {Canvas} canvas\n * @param {Modeling} modeling\n */\nfunction DeleteShapeHandler(canvas, modeling) {\n  this._canvas = canvas;\n  this._modeling = modeling;\n}\n\nDeleteShapeHandler.$inject = [ 'canvas', 'modeling' ];\n\n\n/**\n * - Remove connections\n * - Remove all direct children\n */\nDeleteShapeHandler.prototype.preExecute = function(context) {\n\n  var modeling = this._modeling;\n\n  var shape = context.shape;\n\n  // remove connections\n  (0,Removal/* saveClear */.r)(shape.incoming, function(connection) {\n\n    // To make sure that the connection isn't removed twice\n    // For example if a container is removed\n    modeling.removeConnection(connection, { nested: true });\n  });\n\n  (0,Removal/* saveClear */.r)(shape.outgoing, function(connection) {\n    modeling.removeConnection(connection, { nested: true });\n  });\n\n  // remove child shapes and connections\n  (0,Removal/* saveClear */.r)(shape.children, function(child) {\n    if ((0,ModelUtil/* isConnection */.Ho)(child)) {\n      modeling.removeConnection(child, { nested: true });\n    } else {\n      modeling.removeShape(child, { nested: true });\n    }\n  });\n};\n\n/**\n * Remove shape and remember the parent\n */\nDeleteShapeHandler.prototype.execute = function(context) {\n  var canvas = this._canvas;\n\n  var shape = context.shape,\n      oldParent = shape.parent;\n\n  context.oldParent = oldParent;\n\n  // remove containment\n  context.oldParentIndex = (0,Collections/* indexOf */.cq)(oldParent.children, shape);\n\n  // remove shape\n  canvas.removeShape(shape);\n\n  return shape;\n};\n\n\n/**\n * Command revert implementation\n */\nDeleteShapeHandler.prototype.revert = function(context) {\n\n  var canvas = this._canvas;\n\n  var shape = context.shape,\n      oldParent = context.oldParent,\n      oldParentIndex = context.oldParentIndex;\n\n  // restore containment\n  (0,Collections/* add */.IH)(oldParent.children, shape, oldParentIndex);\n\n  canvas.addShape(shape, oldParent);\n\n  return shape;\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/DistributeElementsHandler.js\n\n\n/**\n * @typedef {import('../Modeling').default} Modeling\n */\n\n/**\n * A handler that distributes elements evenly.\n *\n * @param {Modeling} modeling\n */\nfunction DistributeElements(modeling) {\n  this._modeling = modeling;\n}\n\nDistributeElements.$inject = [ 'modeling' ];\n\nvar OFF_AXIS = {\n  x: 'y',\n  y: 'x'\n};\n\nDistributeElements.prototype.preExecute = function(context) {\n  var modeling = this._modeling;\n\n  var groups = context.groups,\n      axis = context.axis,\n      dimension = context.dimension;\n\n  function updateRange(group, element) {\n    group.range.min = Math.min(element[axis], group.range.min);\n    group.range.max = Math.max(element[axis] + element[dimension], group.range.max);\n  }\n\n  function center(element) {\n    return element[axis] + element[dimension] / 2;\n  }\n\n  function lastIdx(arr) {\n    return arr.length - 1;\n  }\n\n  function rangeDiff(range) {\n    return range.max - range.min;\n  }\n\n  function centerElement(refCenter, element) {\n    var delta = { y: 0 };\n\n    delta[axis] = refCenter - center(element);\n\n    if (delta[axis]) {\n\n      delta[OFF_AXIS[axis]] = 0;\n\n      modeling.moveElements([ element ], delta, element.parent);\n    }\n  }\n\n  var firstGroup = groups[0],\n      lastGroupIdx = lastIdx(groups),\n      lastGroup = groups[ lastGroupIdx ];\n\n  var margin,\n      spaceInBetween,\n      groupsSize = 0; // the size of each range\n\n  (0,index_esm/* forEach */.Ed)(groups, function(group, idx) {\n    var sortedElements,\n        refElem,\n        refCenter;\n\n    if (group.elements.length < 2) {\n      if (idx && idx !== groups.length - 1) {\n        updateRange(group, group.elements[0]);\n\n        groupsSize += rangeDiff(group.range);\n      }\n      return;\n    }\n\n    sortedElements = (0,index_esm/* sortBy */.MR)(group.elements, axis);\n\n    refElem = sortedElements[0];\n\n    if (idx === lastGroupIdx) {\n      refElem = sortedElements[lastIdx(sortedElements)];\n    }\n\n    refCenter = center(refElem);\n\n    // wanna update the ranges after the shapes have been centered\n    group.range = null;\n\n    (0,index_esm/* forEach */.Ed)(sortedElements, function(element) {\n\n      centerElement(refCenter, element);\n\n      if (group.range === null) {\n        group.range = {\n          min: element[axis],\n          max: element[axis] + element[dimension]\n        };\n\n        return;\n      }\n\n      // update group's range after centering the range elements\n      updateRange(group, element);\n    });\n\n    if (idx && idx !== groups.length - 1) {\n      groupsSize += rangeDiff(group.range);\n    }\n  });\n\n  spaceInBetween = Math.abs(lastGroup.range.min - firstGroup.range.max);\n\n  margin = Math.round((spaceInBetween - groupsSize) / (groups.length - 1));\n\n  if (margin < groups.length - 1) {\n    return;\n  }\n\n  (0,index_esm/* forEach */.Ed)(groups, function(group, groupIdx) {\n    var delta = {},\n        prevGroup;\n\n    if (group === firstGroup || group === lastGroup) {\n      return;\n    }\n\n    prevGroup = groups[groupIdx - 1];\n\n    group.range.max = 0;\n\n    (0,index_esm/* forEach */.Ed)(group.elements, function(element, idx) {\n      delta[OFF_AXIS[axis]] = 0;\n      delta[axis] = (prevGroup.range.max - element[axis]) + margin;\n\n      if (group.range.min !== element[axis]) {\n        delta[axis] += element[axis] - group.range.min;\n      }\n\n      if (delta[axis]) {\n        modeling.moveElements([ element ], delta, element.parent);\n      }\n\n      group.range.max = Math.max(element[axis] + element[dimension], idx ? group.range.max : 0);\n    });\n  });\n};\n\nDistributeElements.prototype.postExecute = function(context) {\n\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/LayoutConnectionHandler.js\n\n\n/**\n * @typedef {import('../../../core/Canvas').default} Canvas\n * @typedef {import('../../../layout/BaseLayouter').default} Layouter\n */\n\n/**\n * A handler that implements reversible moving of shapes.\n *\n * @param {Layouter} layouter\n * @param {Canvas} canvas\n */\nfunction LayoutConnectionHandler(layouter, canvas) {\n  this._layouter = layouter;\n  this._canvas = canvas;\n}\n\nLayoutConnectionHandler.$inject = [ 'layouter', 'canvas' ];\n\nLayoutConnectionHandler.prototype.execute = function(context) {\n\n  var connection = context.connection;\n\n  var oldWaypoints = connection.waypoints;\n\n  (0,index_esm/* assign */.f0)(context, {\n    oldWaypoints: oldWaypoints\n  });\n\n  connection.waypoints = this._layouter.layoutConnection(connection, context.hints);\n\n  return connection;\n};\n\nLayoutConnectionHandler.prototype.revert = function(context) {\n\n  var connection = context.connection;\n\n  connection.waypoints = context.oldWaypoints;\n\n  return connection;\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/MoveConnectionHandler.js\n\n\n\n\n\n\n/**\n * A handler that implements reversible moving of connections.\n *\n * The handler differs from the layout connection handler in a sense\n * that it preserves the connection layout.\n */\nfunction MoveConnectionHandler() { }\n\n\nMoveConnectionHandler.prototype.execute = function(context) {\n\n  var connection = context.connection,\n      delta = context.delta;\n\n  var newParent = context.newParent || connection.parent,\n      newParentIndex = context.newParentIndex,\n      oldParent = connection.parent;\n\n  // save old parent in context\n  context.oldParent = oldParent;\n  context.oldParentIndex = (0,Collections/* remove */.Od)(oldParent.children, connection);\n\n  // add to new parent at position\n  (0,Collections/* add */.IH)(newParent.children, connection, newParentIndex);\n\n  // update parent\n  connection.parent = newParent;\n\n  // update waypoint positions\n  (0,index_esm/* forEach */.Ed)(connection.waypoints, function(p) {\n    p.x += delta.x;\n    p.y += delta.y;\n\n    if (p.original) {\n      p.original.x += delta.x;\n      p.original.y += delta.y;\n    }\n  });\n\n  return connection;\n};\n\nMoveConnectionHandler.prototype.revert = function(context) {\n\n  var connection = context.connection,\n      newParent = connection.parent,\n      oldParent = context.oldParent,\n      oldParentIndex = context.oldParentIndex,\n      delta = context.delta;\n\n  // remove from newParent\n  (0,Collections/* remove */.Od)(newParent.children, connection);\n\n  // restore previous location in old parent\n  (0,Collections/* add */.IH)(oldParent.children, connection, oldParentIndex);\n\n  // restore parent\n  connection.parent = oldParent;\n\n  // revert to old waypoint positions\n  (0,index_esm/* forEach */.Ed)(connection.waypoints, function(p) {\n    p.x -= delta.x;\n    p.y -= delta.y;\n\n    if (p.original) {\n      p.original.x -= delta.x;\n      p.original.y -= delta.y;\n    }\n  });\n\n  return connection;\n};\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/helper/AnchorsHelper.js\nvar AnchorsHelper = __webpack_require__(\"./node_modules/diagram-js/lib/features/modeling/cmd/helper/AnchorsHelper.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/helper/MoveClosure.js\n\n\n\n\n/**\n * @typedef {import('../../../../model/Types').Connection} Connection\n * @typedef {import('../../../../model/Types').Element} Element\n * @typedef {import('../../../../model/Types').Shape} Shape\n */\n\nfunction MoveClosure() {\n\n  /**\n   * @type {Record<string, Shape>}\n   */\n  this.allShapes = {};\n\n  /**\n   * @type {Record<string, Connection>}\n   */\n  this.allConnections = {};\n\n  /**\n   * @type {Record<string, Element>}\n   */\n  this.enclosedElements = {};\n\n  /**\n   * @type {Record<string, Connection>}\n   */\n  this.enclosedConnections = {};\n\n  /**\n   * @type {Record<string, Element>}\n   */\n  this.topLevel = {};\n}\n\n/**\n * @param {Element} element\n * @param {boolean} [isTopLevel]\n *\n * @return {MoveClosure}\n */\nMoveClosure.prototype.add = function(element, isTopLevel) {\n  return this.addAll([ element ], isTopLevel);\n};\n\n/**\n * @param {Element[]} elements\n * @param {boolean} [isTopLevel]\n *\n * @return {MoveClosure}\n */\nMoveClosure.prototype.addAll = function(elements, isTopLevel) {\n\n  var newClosure = (0,Elements/* getClosure */.vA)(elements, !!isTopLevel, this);\n\n  (0,index_esm/* assign */.f0)(this, newClosure);\n\n  return this;\n};\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/helper/MoveHelper.js\n\n\n\n\n\n\n/**\n * @typedef {import('../../../../core/Types').ElementLike} Element\n * @typedef {import('../../../../core/Types').ShapeLike} Shape\n *\n * @typedef {import('../../../../util/Types').Point} Point\n *\n * @typedef {import('../../Modeling').default} Modeling\n */\n\n/**\n * A helper that is able to carry out serialized move\n * operations on multiple elements.\n *\n * @param {Modeling} modeling\n */\nfunction MoveHelper(modeling) {\n  this._modeling = modeling;\n}\n\n/**\n * Move the specified elements and all children by the given delta.\n *\n * This moves all enclosed connections, too and layouts all affected\n * external connections.\n *\n * @template {Element} T\n *\n * @param {T[]} elements\n * @param {Point} delta\n * @param {Shape} newParent The new parent of all elements that are not nested.\n *\n * @return {T[]}\n */\nMoveHelper.prototype.moveRecursive = function(elements, delta, newParent) {\n  if (!elements) {\n    return [];\n  } else {\n    return this.moveClosure(this.getClosure(elements), delta, newParent);\n  }\n};\n\n/**\n * Move the given closure of elmements.\n *\n * @param {Object} closure\n * @param {Point} delta\n * @param {Shape} [newParent]\n * @param {Shape} [newHost]\n */\nMoveHelper.prototype.moveClosure = function(closure, delta, newParent, newHost, primaryShape) {\n  var modeling = this._modeling;\n\n  var allShapes = closure.allShapes,\n      allConnections = closure.allConnections,\n      enclosedConnections = closure.enclosedConnections,\n      topLevel = closure.topLevel,\n      keepParent = false;\n\n  if (primaryShape && primaryShape.parent === newParent) {\n    keepParent = true;\n  }\n\n  // move all shapes\n  (0,index_esm/* forEach */.Ed)(allShapes, function(shape) {\n\n    // move the element according to the given delta\n    modeling.moveShape(shape, delta, topLevel[shape.id] && !keepParent && newParent, {\n      recurse: false,\n      layout: false\n    });\n  });\n\n  // move all child connections / layout external connections\n  (0,index_esm/* forEach */.Ed)(allConnections, function(c) {\n\n    var sourceMoved = !!allShapes[c.source.id],\n        targetMoved = !!allShapes[c.target.id];\n\n    if (enclosedConnections[c.id] && sourceMoved && targetMoved) {\n      modeling.moveConnection(c, delta, topLevel[c.id] && !keepParent && newParent);\n    } else {\n      modeling.layoutConnection(c, {\n        connectionStart: sourceMoved && (0,AnchorsHelper/* getMovedSourceAnchor */.H9)(c, c.source, delta),\n        connectionEnd: targetMoved && (0,AnchorsHelper/* getMovedTargetAnchor */.h4)(c, c.target, delta)\n      });\n    }\n  });\n};\n\n/**\n * Returns the closure for the selected elements\n *\n * @param {Element[]} elements\n *\n * @return {MoveClosure}\n */\nMoveHelper.prototype.getClosure = function(elements) {\n  return new MoveClosure().addAll(elements, true);\n};\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/MoveElementsHandler.js\n\n\n/**\n * @typedef {import('../Modeling').default} Modeling\n */\n\n/**\n * A handler that implements reversible moving of shapes.\n *\n * @param {Modeling} modeling\n */\nfunction MoveElementsHandler(modeling) {\n  this._helper = new MoveHelper(modeling);\n}\n\nMoveElementsHandler.$inject = [ 'modeling' ];\n\nMoveElementsHandler.prototype.preExecute = function(context) {\n  context.closure = this._helper.getClosure(context.shapes);\n};\n\nMoveElementsHandler.prototype.postExecute = function(context) {\n\n  var hints = context.hints,\n      primaryShape;\n\n  if (hints && hints.primaryShape) {\n    primaryShape = hints.primaryShape;\n    hints.oldParent = primaryShape.parent;\n  }\n\n  this._helper.moveClosure(\n    context.closure,\n    context.delta,\n    context.newParent,\n    context.newHost,\n    primaryShape\n  );\n};\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/MoveShapeHandler.js\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../Modeling').default} Modeling\n */\n\n/**\n * A handler that implements reversible moving of shapes.\n *\n * @param {Modeling} modeling\n */\nfunction MoveShapeHandler(modeling) {\n  this._modeling = modeling;\n\n  this._helper = new MoveHelper(modeling);\n}\n\nMoveShapeHandler.$inject = [ 'modeling' ];\n\n\nMoveShapeHandler.prototype.execute = function(context) {\n\n  var shape = context.shape,\n      delta = context.delta,\n      newParent = context.newParent || shape.parent,\n      newParentIndex = context.newParentIndex,\n      oldParent = shape.parent;\n\n  context.oldBounds = (0,index_esm/* pick */.ei)(shape, [ 'x', 'y', 'width', 'height' ]);\n\n  // save old parent in context\n  context.oldParent = oldParent;\n  context.oldParentIndex = (0,Collections/* remove */.Od)(oldParent.children, shape);\n\n  // add to new parent at position\n  (0,Collections/* add */.IH)(newParent.children, shape, newParentIndex);\n\n  // update shape parent + position\n  (0,index_esm/* assign */.f0)(shape, {\n    parent: newParent,\n    x: shape.x + delta.x,\n    y: shape.y + delta.y\n  });\n\n  return shape;\n};\n\nMoveShapeHandler.prototype.postExecute = function(context) {\n\n  var shape = context.shape,\n      delta = context.delta,\n      hints = context.hints;\n\n  var modeling = this._modeling;\n\n  if (hints.layout !== false) {\n\n    (0,index_esm/* forEach */.Ed)(shape.incoming, function(c) {\n      modeling.layoutConnection(c, {\n        connectionEnd: (0,AnchorsHelper/* getMovedTargetAnchor */.h4)(c, shape, delta)\n      });\n    });\n\n    (0,index_esm/* forEach */.Ed)(shape.outgoing, function(c) {\n      modeling.layoutConnection(c, {\n        connectionStart: (0,AnchorsHelper/* getMovedSourceAnchor */.H9)(c, shape, delta)\n      });\n    });\n  }\n\n  if (hints.recurse !== false) {\n    this.moveChildren(context);\n  }\n};\n\nMoveShapeHandler.prototype.revert = function(context) {\n\n  var shape = context.shape,\n      oldParent = context.oldParent,\n      oldParentIndex = context.oldParentIndex,\n      delta = context.delta;\n\n  // restore previous location in old parent\n  (0,Collections/* add */.IH)(oldParent.children, shape, oldParentIndex);\n\n  // revert to old position and parent\n  (0,index_esm/* assign */.f0)(shape, {\n    parent: oldParent,\n    x: shape.x - delta.x,\n    y: shape.y - delta.y\n  });\n\n  return shape;\n};\n\nMoveShapeHandler.prototype.moveChildren = function(context) {\n\n  var delta = context.delta,\n      shape = context.shape;\n\n  this._helper.moveRecursive(shape.children, delta, null);\n};\n\nMoveShapeHandler.prototype.getNewParent = function(context) {\n  return context.newParent || context.shape.parent;\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/ReconnectConnectionHandler.js\n\n\n/**\n * @typedef {import('../Modeling').default} Modeling\n */\n\n/**\n * Reconnect connection handler.\n *\n * @param {Modeling} modeling\n */\nfunction ReconnectConnectionHandler(modeling) {\n  this._modeling = modeling;\n}\n\nReconnectConnectionHandler.$inject = [ 'modeling' ];\n\nReconnectConnectionHandler.prototype.execute = function(context) {\n  var newSource = context.newSource,\n      newTarget = context.newTarget,\n      connection = context.connection,\n      dockingOrPoints = context.dockingOrPoints;\n\n  if (!newSource && !newTarget) {\n    throw new Error('newSource or newTarget required');\n  }\n\n  if ((0,index_esm/* isArray */.kJ)(dockingOrPoints)) {\n    context.oldWaypoints = connection.waypoints;\n    connection.waypoints = dockingOrPoints;\n  }\n\n  if (newSource) {\n    context.oldSource = connection.source;\n    connection.source = newSource;\n  }\n\n  if (newTarget) {\n    context.oldTarget = connection.target;\n    connection.target = newTarget;\n  }\n\n  return connection;\n};\n\nReconnectConnectionHandler.prototype.postExecute = function(context) {\n  var connection = context.connection,\n      newSource = context.newSource,\n      newTarget = context.newTarget,\n      dockingOrPoints = context.dockingOrPoints,\n      hints = context.hints || {};\n\n  var layoutConnectionHints = {};\n\n  if (hints.connectionStart) {\n    layoutConnectionHints.connectionStart = hints.connectionStart;\n  }\n\n  if (hints.connectionEnd) {\n    layoutConnectionHints.connectionEnd = hints.connectionEnd;\n  }\n\n  if (hints.layoutConnection === false) {\n    return;\n  }\n\n  if (newSource && (!newTarget || hints.docking === 'source')) {\n    layoutConnectionHints.connectionStart = layoutConnectionHints.connectionStart\n      || getDocking((0,index_esm/* isArray */.kJ)(dockingOrPoints) ? dockingOrPoints[ 0 ] : dockingOrPoints);\n  }\n\n  if (newTarget && (!newSource || hints.docking === 'target')) {\n    layoutConnectionHints.connectionEnd = layoutConnectionHints.connectionEnd\n      || getDocking((0,index_esm/* isArray */.kJ)(dockingOrPoints) ? dockingOrPoints[ dockingOrPoints.length - 1 ] : dockingOrPoints);\n  }\n\n  if (hints.newWaypoints) {\n    layoutConnectionHints.waypoints = hints.newWaypoints;\n  }\n\n  this._modeling.layoutConnection(connection, layoutConnectionHints);\n};\n\nReconnectConnectionHandler.prototype.revert = function(context) {\n  var oldSource = context.oldSource,\n      oldTarget = context.oldTarget,\n      oldWaypoints = context.oldWaypoints,\n      connection = context.connection;\n\n  if (oldSource) {\n    connection.source = oldSource;\n  }\n\n  if (oldTarget) {\n    connection.target = oldTarget;\n  }\n\n  if (oldWaypoints) {\n    connection.waypoints = oldWaypoints;\n  }\n\n  return connection;\n};\n\n\n\n// helpers //////////\n\nfunction getDocking(point) {\n  return point.original || point;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/ReplaceShapeHandler.js\n\n\n\n\n/**\n * @typedef {import('../../model/Types').Shape} Shape\n *\n * @typedef {import('../Modeling').default} Modeling\n * @typedef {import('../../rules/Rules').default} Rules\n */\n\n/**\n * Replace shape by adding new shape and removing old shape. Incoming and outgoing connections will\n * be kept if possible.\n *\n * @class\n * @constructor\n *\n * @param {Modeling} modeling\n * @param {Rules} rules\n */\nfunction ReplaceShapeHandler(modeling, rules) {\n  this._modeling = modeling;\n  this._rules = rules;\n}\n\nReplaceShapeHandler.$inject = [ 'modeling', 'rules' ];\n\n\n/**\n * Add new shape.\n *\n * @param {Object} context\n * @param {Shape} context.oldShape\n * @param {Object} context.newData\n * @param {string} context.newData.type\n * @param {number} context.newData.x\n * @param {number} context.newData.y\n * @param {Object} [context.hints]\n */\nReplaceShapeHandler.prototype.preExecute = function(context) {\n  var self = this,\n      modeling = this._modeling,\n      rules = this._rules;\n\n  var oldShape = context.oldShape,\n      newData = context.newData,\n      hints = context.hints || {},\n      newShape;\n\n  function canReconnect(source, target, connection) {\n    return rules.allowed('connection.reconnect', {\n      connection: connection,\n      source: source,\n      target: target\n    });\n  }\n\n  // (1) add new shape at given position\n  var position = {\n    x: newData.x,\n    y: newData.y\n  };\n\n  var oldBounds = {\n    x: oldShape.x,\n    y: oldShape.y,\n    width: oldShape.width,\n    height: oldShape.height\n  };\n\n  newShape = context.newShape =\n    context.newShape ||\n    self.createShape(newData, position, oldShape.parent, hints);\n\n  // (2) update host\n  if (oldShape.host) {\n    modeling.updateAttachment(newShape, oldShape.host);\n  }\n\n  // (3) adopt all children from old shape\n  var children;\n\n  if (hints.moveChildren !== false) {\n    children = oldShape.children.slice();\n\n    modeling.moveElements(children, { x: 0, y: 0 }, newShape, hints);\n  }\n\n  // (4) reconnect connections to new shape if possible\n  var incoming = oldShape.incoming.slice(),\n      outgoing = oldShape.outgoing.slice();\n\n  (0,index_esm/* forEach */.Ed)(incoming, function(connection) {\n    var source = connection.source,\n        allowed = canReconnect(source, newShape, connection);\n\n    if (allowed) {\n      self.reconnectEnd(\n        connection, newShape,\n        (0,AnchorsHelper/* getResizedTargetAnchor */.Qd)(connection, newShape, oldBounds),\n        hints\n      );\n    }\n  });\n\n  (0,index_esm/* forEach */.Ed)(outgoing, function(connection) {\n    var target = connection.target,\n        allowed = canReconnect(newShape, target, connection);\n\n    if (allowed) {\n      self.reconnectStart(\n        connection, newShape,\n        (0,AnchorsHelper/* getResizedSourceAnchor */.SL)(connection, newShape, oldBounds),\n        hints\n      );\n    }\n  });\n};\n\n\n/**\n * Remove old shape.\n */\nReplaceShapeHandler.prototype.postExecute = function(context) {\n  var oldShape = context.oldShape;\n\n  this._modeling.removeShape(oldShape);\n};\n\n\nReplaceShapeHandler.prototype.execute = function(context) {};\n\n\nReplaceShapeHandler.prototype.revert = function(context) {};\n\n\nReplaceShapeHandler.prototype.createShape = function(shape, position, target, hints) {\n  return this._modeling.createShape(shape, position, target, hints);\n};\n\n\nReplaceShapeHandler.prototype.reconnectStart = function(connection, newSource, dockingPoint, hints) {\n  this._modeling.reconnectStart(connection, newSource, dockingPoint, hints);\n};\n\n\nReplaceShapeHandler.prototype.reconnectEnd = function(connection, newTarget, dockingPoint, hints) {\n  this._modeling.reconnectEnd(connection, newTarget, dockingPoint, hints);\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/ResizeShapeHandler.js\n\n\n\n\n/**\n * @typedef {import('../Modeling').default} Modeling\n */\n\n/**\n * A handler that implements reversible resizing of shapes.\n *\n * @param {Modeling} modeling\n */\nfunction ResizeShapeHandler(modeling) {\n  this._modeling = modeling;\n}\n\nResizeShapeHandler.$inject = [ 'modeling' ];\n\n/**\n * {\n *   shape: {....}\n *   newBounds: {\n *     width:  20,\n *     height: 40,\n *     x:       5,\n *     y:      10\n *   }\n *\n * }\n */\nResizeShapeHandler.prototype.execute = function(context) {\n  var shape = context.shape,\n      newBounds = context.newBounds,\n      minBounds = context.minBounds;\n\n  if (newBounds.x === undefined || newBounds.y === undefined ||\n      newBounds.width === undefined || newBounds.height === undefined) {\n    throw new Error('newBounds must have {x, y, width, height} properties');\n  }\n\n  if (minBounds && (newBounds.width < minBounds.width\n    || newBounds.height < minBounds.height)) {\n    throw new Error('width and height cannot be less than minimum height and width');\n  } else if (!minBounds\n    && newBounds.width < 10 || newBounds.height < 10) {\n    throw new Error('width and height cannot be less than 10px');\n  }\n\n  // save old bbox in context\n  context.oldBounds = {\n    width:  shape.width,\n    height: shape.height,\n    x:      shape.x,\n    y:      shape.y\n  };\n\n  // update shape\n  (0,index_esm/* assign */.f0)(shape, {\n    width:  newBounds.width,\n    height: newBounds.height,\n    x:      newBounds.x,\n    y:      newBounds.y\n  });\n\n  return shape;\n};\n\nResizeShapeHandler.prototype.postExecute = function(context) {\n  var modeling = this._modeling;\n\n  var shape = context.shape,\n      oldBounds = context.oldBounds,\n      hints = context.hints || {};\n\n  if (hints.layout === false) {\n    return;\n  }\n\n  (0,index_esm/* forEach */.Ed)(shape.incoming, function(c) {\n    modeling.layoutConnection(c, {\n      connectionEnd: (0,AnchorsHelper/* getResizedTargetAnchor */.Qd)(c, shape, oldBounds)\n    });\n  });\n\n  (0,index_esm/* forEach */.Ed)(shape.outgoing, function(c) {\n    modeling.layoutConnection(c, {\n      connectionStart: (0,AnchorsHelper/* getResizedSourceAnchor */.SL)(c, shape, oldBounds)\n    });\n  });\n\n};\n\nResizeShapeHandler.prototype.revert = function(context) {\n\n  var shape = context.shape,\n      oldBounds = context.oldBounds;\n\n  // restore previous bbox\n  (0,index_esm/* assign */.f0)(shape, {\n    width:  oldBounds.width,\n    height: oldBounds.height,\n    x:      oldBounds.x,\n    y:      oldBounds.y\n  });\n\n  return shape;\n};\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/space-tool/SpaceUtil.js\nvar SpaceUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/space-tool/SpaceUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/SpaceToolHandler.js\n\n\n\n\n\n\n/**\n * @typedef {import('../Modeling').default} Modeling\n */\n\n/**\n * Add or remove space by moving and resizing shapes and updating connection waypoints.\n *\n * @param {Modeling} modeling\n */\nfunction SpaceToolHandler(modeling) {\n  this._modeling = modeling;\n}\n\nSpaceToolHandler.$inject = [ 'modeling' ];\n\nSpaceToolHandler.prototype.preExecute = function(context) {\n  var delta = context.delta,\n      direction = context.direction,\n      movingShapes = context.movingShapes,\n      resizingShapes = context.resizingShapes,\n      start = context.start,\n      oldBounds = {};\n\n  // (1) move shapes\n  this.moveShapes(movingShapes, delta);\n\n  // (2a) save old bounds of resized shapes\n  (0,index_esm/* forEach */.Ed)(resizingShapes, function(shape) {\n    oldBounds[shape.id] = getBounds(shape);\n  });\n\n  // (2b) resize shapes\n  this.resizeShapes(resizingShapes, delta, direction);\n\n  // (3) update connection waypoints\n  this.updateConnectionWaypoints(\n    (0,SpaceUtil/* getWaypointsUpdatingConnections */.wb)(movingShapes, resizingShapes),\n    delta,\n    direction,\n    start,\n    movingShapes,\n    resizingShapes,\n    oldBounds\n  );\n};\n\nSpaceToolHandler.prototype.execute = function() {};\nSpaceToolHandler.prototype.revert = function() {};\n\nSpaceToolHandler.prototype.moveShapes = function(shapes, delta) {\n  var self = this;\n\n  (0,index_esm/* forEach */.Ed)(shapes, function(element) {\n    self._modeling.moveShape(element, delta, null, {\n      autoResize: false,\n      layout: false,\n      recurse: false\n    });\n  });\n};\n\nSpaceToolHandler.prototype.resizeShapes = function(shapes, delta, direction) {\n  var self = this;\n\n  (0,index_esm/* forEach */.Ed)(shapes, function(shape) {\n    var newBounds = (0,SpaceUtil/* resizeBounds */.zY)(shape, direction, delta);\n\n    self._modeling.resizeShape(shape, newBounds, null, {\n      attachSupport: false,\n      autoResize: false,\n      layout: false\n    });\n  });\n};\n\n/**\n * Update connections waypoints according to the rules:\n *   1. Both source and target are moved/resized => move waypoints by the delta\n *   2. Only one of source and target is moved/resized => re-layout connection with moved start/end\n */\nSpaceToolHandler.prototype.updateConnectionWaypoints = function(\n    connections,\n    delta,\n    direction,\n    start,\n    movingShapes,\n    resizingShapes,\n    oldBounds\n) {\n  var self = this,\n      affectedShapes = movingShapes.concat(resizingShapes);\n\n  (0,index_esm/* forEach */.Ed)(connections, function(connection) {\n    var source = connection.source,\n        target = connection.target,\n        waypoints = copyWaypoints(connection),\n        axis = getAxisFromDirection(direction),\n        layoutHints = {};\n\n    if (includes(affectedShapes, source) && includes(affectedShapes, target)) {\n\n      // move waypoints\n      waypoints = (0,index_esm/* map */.UI)(waypoints, function(waypoint) {\n        if (shouldMoveWaypoint(waypoint, start, direction)) {\n\n          // move waypoint\n          waypoint[ axis ] = waypoint[ axis ] + delta[ axis ];\n        }\n\n        if (waypoint.original && shouldMoveWaypoint(waypoint.original, start, direction)) {\n\n          // move waypoint original\n          waypoint.original[ axis ] = waypoint.original[ axis ] + delta[ axis ];\n        }\n\n        return waypoint;\n      });\n\n      self._modeling.updateWaypoints(connection, waypoints, {\n        labelBehavior: false\n      });\n    } else if (includes(affectedShapes, source) || includes(affectedShapes, target)) {\n\n      // re-layout connection with moved start/end\n      if (includes(movingShapes, source)) {\n        layoutHints.connectionStart = (0,AnchorsHelper/* getMovedSourceAnchor */.H9)(connection, source, delta);\n      } else if (includes(movingShapes, target)) {\n        layoutHints.connectionEnd = (0,AnchorsHelper/* getMovedTargetAnchor */.h4)(connection, target, delta);\n      } else if (includes(resizingShapes, source)) {\n        layoutHints.connectionStart = (0,AnchorsHelper/* getResizedSourceAnchor */.SL)(\n          connection, source, oldBounds[source.id]\n        );\n      } else if (includes(resizingShapes, target)) {\n        layoutHints.connectionEnd = (0,AnchorsHelper/* getResizedTargetAnchor */.Qd)(\n          connection, target, oldBounds[target.id]\n        );\n      }\n\n      self._modeling.layoutConnection(connection, layoutHints);\n    }\n  });\n};\n\n\n// helpers //////////\n\nfunction copyWaypoint(waypoint) {\n  return (0,index_esm/* assign */.f0)({}, waypoint);\n}\n\nfunction copyWaypoints(connection) {\n  return (0,index_esm/* map */.UI)(connection.waypoints, function(waypoint) {\n\n    waypoint = copyWaypoint(waypoint);\n\n    if (waypoint.original) {\n      waypoint.original = copyWaypoint(waypoint.original);\n    }\n\n    return waypoint;\n  });\n}\n\nfunction getAxisFromDirection(direction) {\n  switch (direction) {\n  case 'n':\n    return 'y';\n  case 'w':\n    return 'x';\n  case 's':\n    return 'y';\n  case 'e':\n    return 'x';\n  }\n}\n\nfunction shouldMoveWaypoint(waypoint, start, direction) {\n  var relevantAxis = getAxisFromDirection(direction);\n\n  if (/e|s/.test(direction)) {\n    return waypoint[ relevantAxis ] > start;\n  } else if (/n|w/.test(direction)) {\n    return waypoint[ relevantAxis ] < start;\n  }\n}\n\nfunction includes(array, item) {\n  return array.indexOf(item) !== -1;\n}\n\nfunction getBounds(shape) {\n  return {\n    x: shape.x,\n    y: shape.y,\n    height: shape.height,\n    width: shape.width\n  };\n}\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/ToggleShapeCollapseHandler.js\n\n\n/**\n * @typedef {import('../../model/Types').Shape} Shape\n *\n * @typedef {import('../Modeling').default} Modeling\n */\n\n/**\n * A handler that toggles the collapsed state of an element\n * and the visibility of all its children.\n *\n * @param {Modeling} modeling\n */\nfunction ToggleShapeCollapseHandler(modeling) {\n  this._modeling = modeling;\n}\n\nToggleShapeCollapseHandler.$inject = [ 'modeling' ];\n\n\nToggleShapeCollapseHandler.prototype.execute = function(context) {\n\n  var shape = context.shape,\n      children = shape.children;\n\n  // recursively remember previous visibility of children\n  context.oldChildrenVisibility = getElementsVisibilityRecursive(children);\n\n  // toggle state\n  shape.collapsed = !shape.collapsed;\n\n  // recursively hide/show children\n  var result = setHiddenRecursive(children, shape.collapsed);\n\n  return [ shape ].concat(result);\n};\n\n\nToggleShapeCollapseHandler.prototype.revert = function(context) {\n\n  var shape = context.shape,\n      oldChildrenVisibility = context.oldChildrenVisibility;\n\n  var children = shape.children;\n\n  // recursively set old visability of children\n  var result = restoreVisibilityRecursive(children, oldChildrenVisibility);\n\n  // retoggle state\n  shape.collapsed = !shape.collapsed;\n\n  return [ shape ].concat(result);\n};\n\n\n// helpers //////////////////////\n\n/**\n * Return a map { elementId -> hiddenState}.\n *\n * @param {Shape[]} elements\n *\n * @return {Object}\n */\nfunction getElementsVisibilityRecursive(elements) {\n\n  var result = {};\n\n  (0,index_esm/* forEach */.Ed)(elements, function(element) {\n    result[element.id] = element.hidden;\n\n    if (element.children) {\n      result = (0,index_esm/* assign */.f0)({}, result, getElementsVisibilityRecursive(element.children));\n    }\n  });\n\n  return result;\n}\n\n\nfunction setHiddenRecursive(elements, newHidden) {\n  var result = [];\n  (0,index_esm/* forEach */.Ed)(elements, function(element) {\n    element.hidden = newHidden;\n\n    result = result.concat(element);\n\n    if (element.children) {\n      result = result.concat(setHiddenRecursive(element.children, element.collapsed || newHidden));\n    }\n  });\n\n  return result;\n}\n\nfunction restoreVisibilityRecursive(elements, lastState) {\n  var result = [];\n  (0,index_esm/* forEach */.Ed)(elements, function(element) {\n    element.hidden = lastState[element.id];\n\n    result = result.concat(element);\n\n    if (element.children) {\n      result = result.concat(restoreVisibilityRecursive(element.children, lastState));\n    }\n  });\n\n  return result;\n}\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/UpdateAttachmentHandler.js\n\n\n/**\n * @typedef {import('../Modeling').default} Modeling\n */\n\n/**\n * A handler that implements reversible attaching/detaching of shapes.\n *\n * @param {Modeling} modeling\n */\nfunction UpdateAttachmentHandler(modeling) {\n  this._modeling = modeling;\n}\n\nUpdateAttachmentHandler.$inject = [ 'modeling' ];\n\n\nUpdateAttachmentHandler.prototype.execute = function(context) {\n  var shape = context.shape,\n      newHost = context.newHost,\n      oldHost = shape.host;\n\n  // (0) detach from old host\n  context.oldHost = oldHost;\n  context.attacherIdx = removeAttacher(oldHost, shape);\n\n  // (1) attach to new host\n  addAttacher(newHost, shape);\n\n  // (2) update host\n  shape.host = newHost;\n\n  return shape;\n};\n\nUpdateAttachmentHandler.prototype.revert = function(context) {\n  var shape = context.shape,\n      newHost = context.newHost,\n      oldHost = context.oldHost,\n      attacherIdx = context.attacherIdx;\n\n  // (2) update host\n  shape.host = oldHost;\n\n  // (1) attach to new host\n  removeAttacher(newHost, shape);\n\n  // (0) detach from old host\n  addAttacher(oldHost, shape, attacherIdx);\n\n  return shape;\n};\n\n\nfunction removeAttacher(host, attacher) {\n\n  // remove attacher from host\n  return (0,Collections/* remove */.Od)(host && host.attachers, attacher);\n}\n\nfunction addAttacher(host, attacher, idx) {\n\n  if (!host) {\n    return;\n  }\n\n  var attachers = host.attachers;\n\n  if (!attachers) {\n    host.attachers = attachers = [];\n  }\n\n  (0,Collections/* add */.IH)(attachers, attacher, idx);\n}\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/UpdateWaypointsHandler.js\nfunction UpdateWaypointsHandler() { }\n\nUpdateWaypointsHandler.prototype.execute = function(context) {\n\n  var connection = context.connection,\n      newWaypoints = context.newWaypoints;\n\n  context.oldWaypoints = connection.waypoints;\n\n  connection.waypoints = newWaypoints;\n\n  return connection;\n};\n\nUpdateWaypointsHandler.prototype.revert = function(context) {\n\n  var connection = context.connection,\n      oldWaypoints = context.oldWaypoints;\n\n  connection.waypoints = oldWaypoints;\n\n  return connection;\n};\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/model/index.js\nvar model = __webpack_require__(\"./node_modules/diagram-js/lib/model/index.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/modeling/Modeling.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../model/Types').Element} Element\n * @typedef {import('../../model/Types').Connection} Connection\n * @typedef {import('../../model/Types').Parent} Parent\n * @typedef {import('../../model/Types').Shape} Shape\n * @typedef {import('../../model/Types').Label} Label\n *\n * @typedef {import('../../command/CommandStack').default} CommandStack\n * @typedef {import('../../core/ElementFactory').default} ElementFactory\n * @typedef {import('../../core/EventBus').default} EventBus\n *\n * @typedef {import('../../command/CommandStack').CommandHandlerConstructor} CommandHandlerConstructor\n *\n * @typedef {import('../../util/Types').Dimensions} Dimensions\n * @typedef {import('../../util/Types').Direction} Direction\n * @typedef {import('../../util/Types').Point} Point\n * @typedef {import('../../util/Types').Rect} Rect\n *\n * @typedef { 'x' | 'y' } ModelingDistributeAxis\n *\n * @typedef { 'width' | 'height' } ModelingDistributeDimension\n *\n * @typedef { {\n *   bottom?: number;\n *   center?: number;\n *   left?: number;\n *   middle?: number;\n *   right?: number;\n *   top?: number;\n * } } ModelingAlignAlignment\n *\n * @typedef { {\n *   [key: string]: any;\n * } } ModelingHints\n *\n * @typedef { {\n *   attach?: boolean;\n * } & ModelingHints } ModelingMoveElementsHints\n *\n * @typedef { {\n *   attach?: boolean;\n * } & ModelingHints } ModelingCreateShapeHints\n */\n\n/**\n * @template {Element} U\n *\n * @typedef { {\n *   elements: U[],\n *   range: {\n *     min: number;\n *     max: number;\n *   } }\n * } ModelingDistributeGroup\n */\n\n/**\n * The basic modeling entry point.\n *\n * @template {Connection} [T=Connection]\n * @template {Element} [U=Element]\n * @template {Label} [V=Label]\n * @template {Parent} [W=Parent]\n * @template {Shape} [X=Shape]\n *\n * @param {EventBus} eventBus\n * @param {ElementFactory} elementFactory\n * @param {CommandStack} commandStack\n */\nfunction Modeling(eventBus, elementFactory, commandStack) {\n  this._eventBus = eventBus;\n  this._elementFactory = elementFactory;\n  this._commandStack = commandStack;\n\n  var self = this;\n\n  eventBus.on('diagram.init', function() {\n\n    // register modeling handlers\n    self.registerHandlers(commandStack);\n  });\n}\n\nModeling.$inject = [ 'eventBus', 'elementFactory', 'commandStack' ];\n\n/**\n * Get a map of all command handlers.\n *\n * @return {Map<string, CommandHandlerConstructor>}\n */\nModeling.prototype.getHandlers = function() {\n  return {\n    'shape.append': AppendShapeHandler,\n    'shape.create': CreateShapeHandler,\n    'shape.delete': DeleteShapeHandler,\n    'shape.move': MoveShapeHandler,\n    'shape.resize': ResizeShapeHandler,\n    'shape.replace': ReplaceShapeHandler,\n    'shape.toggleCollapse': ToggleShapeCollapseHandler,\n\n    'spaceTool': SpaceToolHandler,\n\n    'label.create': CreateLabelHandler,\n\n    'connection.create': CreateConnectionHandler,\n    'connection.delete': DeleteConnectionHandler,\n    'connection.move': MoveConnectionHandler,\n    'connection.layout': LayoutConnectionHandler,\n\n    'connection.updateWaypoints': UpdateWaypointsHandler,\n\n    'connection.reconnect': ReconnectConnectionHandler,\n\n    'elements.create': CreateElementsHandler,\n    'elements.move': MoveElementsHandler,\n    'elements.delete': DeleteElementsHandler,\n\n    'elements.distribute': DistributeElements,\n    'elements.align': AlignElements,\n\n    'element.updateAttachment': UpdateAttachmentHandler\n  };\n};\n\n/**\n * Register handlers with the command stack\n *\n * @param {CommandStack} commandStack\n */\nModeling.prototype.registerHandlers = function(commandStack) {\n  (0,index_esm/* forEach */.Ed)(this.getHandlers(), function(handler, id) {\n    commandStack.registerHandler(id, handler);\n  });\n};\n\n\n/**\n * Move a shape by the given delta and optionally to a new parent.\n *\n * @param {X} shape\n * @param {Point} delta\n * @param {W} [newParent]\n * @param {number} [newParentIndex]\n * @param {ModelingHints} [hints]\n */\nModeling.prototype.moveShape = function(shape, delta, newParent, newParentIndex, hints) {\n\n  if (typeof newParentIndex === 'object') {\n    hints = newParentIndex;\n    newParentIndex = null;\n  }\n\n  var context = {\n    shape: shape,\n    delta:  delta,\n    newParent: newParent,\n    newParentIndex: newParentIndex,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('shape.move', context);\n};\n\n\n/**\n * Update the attachment of a shape.\n *\n * @param {X} shape\n * @param {X} [newHost=undefined]\n */\nModeling.prototype.updateAttachment = function(shape, newHost) {\n  var context = {\n    shape: shape,\n    newHost: newHost\n  };\n\n  this._commandStack.execute('element.updateAttachment', context);\n};\n\n\n/**\n * Move elements by a given delta and optionally to a new parent.\n *\n * @param {U[]} shapes\n * @param {Point} delta\n * @param {W} [target]\n * @param {ModelingMoveElementsHints} [hints]\n */\nModeling.prototype.moveElements = function(shapes, delta, target, hints) {\n\n  hints = hints || {};\n\n  var attach = hints.attach;\n\n  var newParent = target,\n      newHost;\n\n  if (attach === true) {\n    newHost = target;\n    newParent = target.parent;\n  } else\n\n  if (attach === false) {\n    newHost = null;\n  }\n\n  var context = {\n    shapes: shapes,\n    delta: delta,\n    newParent: newParent,\n    newHost: newHost,\n    hints: hints\n  };\n\n  this._commandStack.execute('elements.move', context);\n};\n\n/**\n * Move a shape by the given delta and optionally to a new parent.\n *\n * @param {T} connection\n * @param {Point} delta\n * @param {W} [newParent]\n * @param {number} [newParentIndex]\n * @param {ModelingHints} [hints]\n */\nModeling.prototype.moveConnection = function(connection, delta, newParent, newParentIndex, hints) {\n\n  if (typeof newParentIndex === 'object') {\n    hints = newParentIndex;\n    newParentIndex = undefined;\n  }\n\n  var context = {\n    connection: connection,\n    delta: delta,\n    newParent: newParent,\n    newParentIndex: newParentIndex,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('connection.move', context);\n};\n\n/**\n * Layout a connection.\n *\n * @param {T} connection\n * @param {ModelingHints} [hints]\n */\nModeling.prototype.layoutConnection = function(connection, hints) {\n  var context = {\n    connection: connection,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('connection.layout', context);\n};\n\n/**\n * Create a connection.\n *\n * @overlord\n *\n * @param {U} source\n * @param {U} target\n * @param {Partial<T>} connection\n * @param {W} parent\n * @param {ModelingHints} [hints]\n *\n * @return {T}\n */\n\n/**\n * Create a connection.\n *\n * @param {U} source\n * @param {U} target\n * @param {number} parentIndex\n * @param {Partial<T>} connection\n * @param {W} parent\n * @param {ModelingHints} [hints]\n *\n * @return {T}\n */\nModeling.prototype.createConnection = function(source, target, parentIndex, connection, parent, hints) {\n\n  if (typeof parentIndex === 'object') {\n    hints = parent;\n    parent = connection;\n    connection = parentIndex;\n    parentIndex = undefined;\n  }\n\n  connection = this._create('connection', connection);\n\n  var context = {\n    source: source,\n    target: target,\n    parent: parent,\n    parentIndex: parentIndex,\n    connection: connection,\n    hints: hints\n  };\n\n  this._commandStack.execute('connection.create', context);\n\n  return context.connection;\n};\n\n\n/**\n * Create a shape.\n *\n * @overlord\n *\n * @param {Partial<X>} shape\n * @param {Point} position\n * @param {W} target\n * @param {ModelingCreateShapeHints} [hints]\n *\n * @return {X}\n */\n\n/**\n * Create a shape.\n *\n * @param {Partial<X>} shape\n * @param {Point} position\n * @param {W} target\n * @param {number} parentIndex\n * @param {ModelingCreateShapeHints} [hints]\n *\n * @return {X}\n */\nModeling.prototype.createShape = function(shape, position, target, parentIndex, hints) {\n\n  if (typeof parentIndex !== 'number') {\n    hints = parentIndex;\n    parentIndex = undefined;\n  }\n\n  hints = hints || {};\n\n  var attach = hints.attach,\n      parent,\n      host;\n\n  shape = this._create('shape', shape);\n\n  if (attach) {\n    parent = target.parent;\n    host = target;\n  } else {\n    parent = target;\n  }\n\n  var context = {\n    position: position,\n    shape: shape,\n    parent: parent,\n    parentIndex: parentIndex,\n    host: host,\n    hints: hints\n  };\n\n  this._commandStack.execute('shape.create', context);\n\n  return context.shape;\n};\n\n/**\n * Create elements.\n *\n * @param {Partial<U>[]} elements\n * @param {Point} position\n * @param {W} parent\n * @param {number} [parentIndex]\n * @param {ModelingHints} [hints]\n *\n * @return {U[]}\n */\nModeling.prototype.createElements = function(elements, position, parent, parentIndex, hints) {\n  if (!(0,index_esm/* isArray */.kJ)(elements)) {\n    elements = [ elements ];\n  }\n\n  if (typeof parentIndex !== 'number') {\n    hints = parentIndex;\n    parentIndex = undefined;\n  }\n\n  hints = hints || {};\n\n  var context = {\n    position: position,\n    elements: elements,\n    parent: parent,\n    parentIndex: parentIndex,\n    hints: hints\n  };\n\n  this._commandStack.execute('elements.create', context);\n\n  return context.elements;\n};\n\n/**\n * Create a label.\n *\n * @param {U} labelTarget\n * @param {Point} position\n * @param {Partial<V>} label\n * @param {W} [parent]\n *\n * @return {V}\n */\nModeling.prototype.createLabel = function(labelTarget, position, label, parent) {\n\n  label = this._create('label', label);\n\n  var context = {\n    labelTarget: labelTarget,\n    position: position,\n    parent: parent || labelTarget.parent,\n    shape: label\n  };\n\n  this._commandStack.execute('label.create', context);\n\n  return context.shape;\n};\n\n\n/**\n * Create and connect a shape to a source.\n *\n * @param {U} source\n * @param {Partial<X>} shape\n * @param {Point} position\n * @param {W} target\n * @param {ModelingHints} [hints]\n *\n * @return {X}\n */\nModeling.prototype.appendShape = function(source, shape, position, target, hints) {\n\n  hints = hints || {};\n\n  shape = this._create('shape', shape);\n\n  var context = {\n    source: source,\n    position: position,\n    target: target,\n    shape: shape,\n    connection: hints.connection,\n    connectionParent: hints.connectionParent,\n    hints: hints\n  };\n\n  this._commandStack.execute('shape.append', context);\n\n  return context.shape;\n};\n\n/**\n * Remove elements.\n *\n * @param {U[]} elements\n */\nModeling.prototype.removeElements = function(elements) {\n  var context = {\n    elements: elements\n  };\n\n  this._commandStack.execute('elements.delete', context);\n};\n\n/**\n * Distribute elements along a given axis.\n *\n * @param {ModelingDistributeGroup<U>[]} groups\n * @param {ModelingDistributeAxis} axis\n * @param {ModelingDistributeDimension} dimension\n */\nModeling.prototype.distributeElements = function(groups, axis, dimension) {\n  var context = {\n    groups: groups,\n    axis: axis,\n    dimension: dimension\n  };\n\n  this._commandStack.execute('elements.distribute', context);\n};\n\n/**\n * Remove a shape.\n *\n * @param {X} shape\n * @param {ModelingHints} [hints]\n */\nModeling.prototype.removeShape = function(shape, hints) {\n  var context = {\n    shape: shape,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('shape.delete', context);\n};\n\n/**\n * Remove a connection.\n *\n * @param {T} connection\n * @param {ModelingHints} [hints]\n */\nModeling.prototype.removeConnection = function(connection, hints) {\n  var context = {\n    connection: connection,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('connection.delete', context);\n};\n\n/**\n * Replace a shape.\n *\n * @param {X} oldShape\n * @param {Partial<X>} newShape\n * @param {ModelingHints} [hints]\n *\n * @return {X}\n */\nModeling.prototype.replaceShape = function(oldShape, newShape, hints) {\n  var context = {\n    oldShape: oldShape,\n    newData: newShape,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('shape.replace', context);\n\n  return context.newShape;\n};\n\n/**\n * Align elements.\n *\n * @param {U[]} elements\n * @param {ModelingAlignAlignment} alignment\n */\nModeling.prototype.alignElements = function(elements, alignment) {\n  var context = {\n    elements: elements,\n    alignment: alignment\n  };\n\n  this._commandStack.execute('elements.align', context);\n};\n\n/**\n * Resize a shape.\n *\n * @param {X} shape\n * @param {Rect} newBounds\n * @param {Dimensions} [minBounds]\n * @param {ModelingHints} [hints]\n */\nModeling.prototype.resizeShape = function(shape, newBounds, minBounds, hints) {\n  var context = {\n    shape: shape,\n    newBounds: newBounds,\n    minBounds: minBounds,\n    hints: hints\n  };\n\n  this._commandStack.execute('shape.resize', context);\n};\n\n/**\n * Create space along an horizontally or vertically.\n *\n * @param {X[]} movingShapes\n * @param {X[]} resizingShapes\n * @param {Point} delta\n * @param {Direction} direction\n * @param {number} start\n */\nModeling.prototype.createSpace = function(movingShapes, resizingShapes, delta, direction, start) {\n  var context = {\n    delta: delta,\n    direction: direction,\n    movingShapes: movingShapes,\n    resizingShapes: resizingShapes,\n    start: start\n  };\n\n  this._commandStack.execute('spaceTool', context);\n};\n\n/**\n * Update a connetions waypoints.\n *\n * @param {T} connection\n * @param {Point[]} newWaypoints\n * @param {ModelingHints} [hints]\n */\nModeling.prototype.updateWaypoints = function(connection, newWaypoints, hints) {\n  var context = {\n    connection: connection,\n    newWaypoints: newWaypoints,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('connection.updateWaypoints', context);\n};\n\n/**\n * Reconnect a connections source and/or target.\n *\n * @param {T} connection\n * @param {U} source\n * @param {U} target\n * @param {Point|Point[]} dockingOrPoints\n * @param {ModelingHints} [hints]\n */\nModeling.prototype.reconnect = function(connection, source, target, dockingOrPoints, hints) {\n  var context = {\n    connection: connection,\n    newSource: source,\n    newTarget: target,\n    dockingOrPoints: dockingOrPoints,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('connection.reconnect', context);\n};\n\n/**\n * Reconnect a connections source.\n *\n * @param {T} connection\n * @param {U} newSource\n * @param {Point|Point[]} dockingOrPoints\n * @param {ModelingHints} [hints]\n */\nModeling.prototype.reconnectStart = function(connection, newSource, dockingOrPoints, hints) {\n  if (!hints) {\n    hints = {};\n  }\n\n  this.reconnect(connection, newSource, connection.target, dockingOrPoints, (0,index_esm/* assign */.f0)(hints, {\n    docking: 'source'\n  }));\n};\n\n/**\n * Reconnect a connections target.\n *\n * @param {T} connection\n * @param {U} newTarget\n * @param {Point|Point[]} dockingOrPoints\n * @param {ModelingHints} [hints]\n */\nModeling.prototype.reconnectEnd = function(connection, newTarget, dockingOrPoints, hints) {\n  if (!hints) {\n    hints = {};\n  }\n\n  this.reconnect(connection, connection.source, newTarget, dockingOrPoints, (0,index_esm/* assign */.f0)(hints, {\n    docking: 'target'\n  }));\n};\n\n/**\n * Connect two elements.\n *\n * @param {U} source\n * @param {U} target\n * @param {Partial<T>} [attrs]\n * @param {ModelingHints} [hints]\n *\n * @return {T}\n */\nModeling.prototype.connect = function(source, target, attrs, hints) {\n  return this.createConnection(source, target, attrs || {}, source.parent, hints);\n};\n\nModeling.prototype._create = function(type, attrs) {\n  if ((0,model/* isModelElement */.g)(attrs)) {\n    return attrs;\n  } else {\n    return this._elementFactory.create(type, attrs);\n  }\n};\n\n/**\n * Collapse or expand a shape.\n *\n * @param {X} shape\n * @param {ModelingHints} [hints]\n */\nModeling.prototype.toggleCollapse = function(shape, hints) {\n  var context = {\n    shape: shape,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('shape.toggleCollapse', context);\n};\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/modeling/Modeling.js_+_23_modules?")},"./node_modules/diagram-js/lib/features/modeling/cmd/helper/AnchorsHelper.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "H9": () => (/* binding */ getMovedSourceAnchor),\n/* harmony export */   "Qd": () => (/* binding */ getResizedTargetAnchor),\n/* harmony export */   "SL": () => (/* binding */ getResizedSourceAnchor),\n/* harmony export */   "h4": () => (/* binding */ getMovedTargetAnchor)\n/* harmony export */ });\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var _util_AttachUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/diagram-js/lib/util/AttachUtil.js");\n}\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var _layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./node_modules/diagram-js/lib/layout/LayoutUtil.js");\n}\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js");\n}\n\n\n\n\n\n\n/**\n * @typedef {import(\'../../../../core/Types\').ConnectionLike} Connection\n * @typedef {import(\'../../../../core/Types\').ShapeLike} Shape\n *\n * @typedef {import(\'../../../../util/Types\').Point} Point\n * @typedef {import(\'../../../../util/Types\').Rect} Rect\n */\n\n/**\n * @param {Connection} connection\n * @param {Shape} shape\n * @param {Rect} oldBounds\n * @return {Point}\n */\nfunction getResizedSourceAnchor(connection, shape, oldBounds) {\n\n  var waypoints = safeGetWaypoints(connection),\n      waypointsInsideNewBounds = getWaypointsInsideBounds(waypoints, shape),\n      oldAnchor = waypoints[0];\n\n  // new anchor is the last waypoint enclosed be resized source\n  if (waypointsInsideNewBounds.length) {\n    return waypointsInsideNewBounds[ waypointsInsideNewBounds.length - 1 ];\n  }\n\n  return (0,_util_AttachUtil__WEBPACK_IMPORTED_MODULE_0__/* .getNewAttachPoint */ .r)(oldAnchor.original || oldAnchor, oldBounds, shape);\n}\n\n\nfunction getResizedTargetAnchor(connection, shape, oldBounds) {\n\n  var waypoints = safeGetWaypoints(connection),\n      waypointsInsideNewBounds = getWaypointsInsideBounds(waypoints, shape),\n      oldAnchor = waypoints[waypoints.length - 1];\n\n  // new anchor is the first waypoint enclosed be resized target\n  if (waypointsInsideNewBounds.length) {\n    return waypointsInsideNewBounds[ 0 ];\n  }\n\n  return (0,_util_AttachUtil__WEBPACK_IMPORTED_MODULE_0__/* .getNewAttachPoint */ .r)(oldAnchor.original || oldAnchor, oldBounds, shape);\n}\n\n\nfunction getMovedSourceAnchor(connection, source, moveDelta) {\n\n  var waypoints = safeGetWaypoints(connection),\n      oldBounds = subtract(source, moveDelta),\n      oldAnchor = waypoints[ 0 ];\n\n  return (0,_util_AttachUtil__WEBPACK_IMPORTED_MODULE_0__/* .getNewAttachPoint */ .r)(oldAnchor.original || oldAnchor, oldBounds, source);\n}\n\n\nfunction getMovedTargetAnchor(connection, target, moveDelta) {\n\n  var waypoints = safeGetWaypoints(connection),\n      oldBounds = subtract(target, moveDelta),\n      oldAnchor = waypoints[ waypoints.length - 1 ];\n\n  return (0,_util_AttachUtil__WEBPACK_IMPORTED_MODULE_0__/* .getNewAttachPoint */ .r)(oldAnchor.original || oldAnchor, oldBounds, target);\n}\n\n\n// helpers //////////////////////\n\nfunction subtract(bounds, delta) {\n  return {\n    x: bounds.x - delta.x,\n    y: bounds.y - delta.y,\n    width: bounds.width,\n    height: bounds.height\n  };\n}\n\n\n/**\n * Return waypoints of given connection; throw if non exists (should not happen!!).\n *\n * @param {Connection} connection\n *\n * @return {Point[]}\n */\nfunction safeGetWaypoints(connection) {\n\n  var waypoints = connection.waypoints;\n\n  if (!waypoints.length) {\n    throw new Error(\'connection#\' + connection.id + \': no waypoints\');\n  }\n\n  return waypoints;\n}\n\nfunction getWaypointsInsideBounds(waypoints, bounds) {\n  var originalWaypoints = (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .map */ .UI)(waypoints, getOriginal);\n\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .filter */ .hX)(originalWaypoints, function(waypoint) {\n    return isInsideBounds(waypoint, bounds);\n  });\n}\n\n/**\n * Checks if point is inside bounds, incl. edges.\n *\n * @param {Point} point\n * @param {Rect} bounds\n */\nfunction isInsideBounds(point, bounds) {\n  return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_2__/* .getOrientation */ .T8)(bounds, point, 1) === \'intersect\';\n}\n\nfunction getOriginal(point) {\n  return point.original || point;\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/modeling/cmd/helper/AnchorsHelper.js?')},"./node_modules/diagram-js/lib/features/mouse/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ mouse)\n});\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/mouse/Mouse.js\n/**\r\n * @typedef {import('../../core/EventBus').default} EventBus\r\n */\r\n\r\n/**\r\n * @param {EventBus} eventBus\r\n */\r\nfunction Mouse(eventBus) {\r\n  var self = this;\r\n\r\n  this._lastMoveEvent = null;\r\n\r\n  function setLastMoveEvent(mousemoveEvent) {\r\n    self._lastMoveEvent = mousemoveEvent;\r\n  }\r\n\r\n  eventBus.on('canvas.init', function(context) {\r\n    var svg = self._svg = context.svg;\r\n\r\n    svg.addEventListener('mousemove', setLastMoveEvent);\r\n  });\r\n\r\n  eventBus.on('canvas.destroy', function() {\r\n    self._lastMouseEvent = null;\r\n\r\n    self._svg.removeEventListener('mousemove', setLastMoveEvent);\r\n  });\r\n}\r\n\r\nMouse.$inject = [ 'eventBus' ];\r\n\r\nMouse.prototype.getLastMoveEvent = function() {\r\n  return this._lastMoveEvent || createMoveEvent(0, 0);\r\n};\r\n\r\n// helpers //////////\r\n\r\nfunction createMoveEvent(x, y) {\r\n  var event = document.createEvent('MouseEvent');\r\n\r\n  var screenX = x,\r\n      screenY = y,\r\n      clientX = x,\r\n      clientY = y;\r\n\r\n  if (event.initMouseEvent) {\r\n    event.initMouseEvent(\r\n      'mousemove',\r\n      true,\r\n      true,\r\n      window,\r\n      0,\r\n      screenX,\r\n      screenY,\r\n      clientX,\r\n      clientY,\r\n      false,\r\n      false,\r\n      false,\r\n      false,\r\n      0,\r\n      null\r\n    );\r\n  }\r\n\r\n  return event;\r\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/mouse/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const mouse = ({\n  __init__: [ 'mouse' ],\n  mouse: [ 'type', Mouse ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/mouse/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/move/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ move)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/interaction-events/index.js + 1 modules\nvar interaction_events = __webpack_require__(\"./node_modules/diagram-js/lib/features/interaction-events/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/outline/index.js + 1 modules\nvar outline = __webpack_require__(\"./node_modules/diagram-js/lib/features/outline/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/dragging/index.js + 3 modules\nvar dragging = __webpack_require__(\"./node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/preview-support/index.js + 1 modules\nvar preview_support = __webpack_require__(\"./node_modules/diagram-js/lib/features/preview-support/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Event.js\nvar Event = __webpack_require__(\"./node_modules/diagram-js/lib/util/Event.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Mouse.js\nvar Mouse = __webpack_require__(\"./node_modules/diagram-js/lib/util/Mouse.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/move/Move.js\n\n\n\n\n/**\n * @typedef {import('../../core/Types').ElementLike} Element\n * @typedef {import('../../core/Types').ShapeLike} Shape\n *\n * @typedef {import('../dragging/Dragging').default} Dragging\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../modeling/Modeling').default} Modeling\n * @typedef {import('../rules/Rules').default} Rules\n * @typedef {import('../selection/Selection').default} Selection\n */\n\nvar LOW_PRIORITY = 500,\n    MEDIUM_PRIORITY = 1250,\n    HIGH_PRIORITY = 1500;\n\n\n\n\n\nvar round = Math.round;\n\nfunction mid(element) {\n  return {\n    x: element.x + round(element.width / 2),\n    y: element.y + round(element.height / 2)\n  };\n}\n\n/**\n * A plugin that makes shapes draggable / droppable.\n *\n * @param {EventBus} eventBus\n * @param {Dragging} dragging\n * @param {Modeling} modeling\n * @param {Selection} selection\n * @param {Rules} rules\n */\nfunction MoveEvents(\n    eventBus, dragging, modeling,\n    selection, rules) {\n\n  // rules\n\n  function canMove(shapes, delta, position, target) {\n\n    return rules.allowed('elements.move', {\n      shapes: shapes,\n      delta: delta,\n      position: position,\n      target: target\n    });\n  }\n\n\n  // move events\n\n  // assign a high priority to this handler to setup the environment\n  // others may hook up later, e.g. at default priority and modify\n  // the move environment.\n  //\n  // This sets up the context with\n  //\n  // * shape: the primary shape being moved\n  // * shapes: a list of shapes to be moved\n  // * validatedShapes: a list of shapes that are being checked\n  //                    against the rules before and during move\n  //\n  eventBus.on('shape.move.start', HIGH_PRIORITY, function(event) {\n\n    var context = event.context,\n        shape = event.shape,\n        shapes = selection.get().slice();\n\n    // move only single shape if the dragged element\n    // is not part of the current selection\n    if (shapes.indexOf(shape) === -1) {\n      shapes = [ shape ];\n    }\n\n    // ensure we remove nested elements in the collection\n    // and add attachers for a proper dragger\n    shapes = removeNested(shapes);\n\n    // attach shapes to drag context\n    (0,index_esm/* assign */.f0)(context, {\n      shapes: shapes,\n      validatedShapes: shapes,\n      shape: shape\n    });\n  });\n\n\n  // assign a high priority to this handler to setup the environment\n  // others may hook up later, e.g. at default priority and modify\n  // the move environment\n  //\n  eventBus.on('shape.move.start', MEDIUM_PRIORITY, function(event) {\n\n    var context = event.context,\n        validatedShapes = context.validatedShapes,\n        canExecute;\n\n    canExecute = context.canExecute = canMove(validatedShapes);\n\n    // check if we can move the elements\n    if (!canExecute) {\n      return false;\n    }\n  });\n\n  // assign a low priority to this handler\n  // to let others modify the move event before we update\n  // the context\n  //\n  eventBus.on('shape.move.move', LOW_PRIORITY, function(event) {\n\n    var context = event.context,\n        validatedShapes = context.validatedShapes,\n        hover = event.hover,\n        delta = { x: event.dx, y: event.dy },\n        position = { x: event.x, y: event.y },\n        canExecute;\n\n    // check if we can move the elements\n    canExecute = canMove(validatedShapes, delta, position, hover);\n\n    context.delta = delta;\n    context.canExecute = canExecute;\n\n    // simply ignore move over\n    if (canExecute === null) {\n      context.target = null;\n\n      return;\n    }\n\n    context.target = hover;\n  });\n\n  eventBus.on('shape.move.end', function(event) {\n\n    var context = event.context;\n\n    var delta = context.delta,\n        canExecute = context.canExecute,\n        isAttach = canExecute === 'attach',\n        shapes = context.shapes;\n\n    if (canExecute === false) {\n      return false;\n    }\n\n    // ensure we have actual pixel values deltas\n    // (important when zoom level was > 1 during move)\n    delta.x = round(delta.x);\n    delta.y = round(delta.y);\n\n    if (delta.x === 0 && delta.y === 0) {\n\n      // didn't move\n      return;\n    }\n\n    modeling.moveElements(shapes, delta, context.target, {\n      primaryShape: context.shape,\n      attach: isAttach\n    });\n  });\n\n\n  // move activation\n\n  eventBus.on('element.mousedown', function(event) {\n\n    if (!(0,Mouse/* isPrimaryButton */.Id)(event)) {\n      return;\n    }\n\n    var originalEvent = (0,Event/* getOriginal */.Ku)(event);\n\n    if (!originalEvent) {\n      throw new Error('must supply DOM mousedown event');\n    }\n\n    return start(originalEvent, event.element);\n  });\n\n  /**\n   * Start move.\n   *\n   * @param {MouseEvent|TouchEvent} event\n   * @param {Shape} element\n   * @param {boolean} [activate]\n   * @param {Object} [context]\n   */\n  function start(event, element, activate, context) {\n    if ((0,index_esm/* isObject */.Kn)(activate)) {\n      context = activate;\n      activate = false;\n    }\n\n    // do not move connections or the root element\n    if (element.waypoints || !element.parent) {\n      return;\n    }\n\n    // ignore non-draggable hits\n    if ((0,dist_index_esm/* classes */.Sh)(event.target).has('djs-hit-no-move')) {\n      return;\n    }\n\n    var referencePoint = mid(element);\n\n    dragging.init(event, referencePoint, 'shape.move', {\n      cursor: 'grabbing',\n      autoActivate: activate,\n      data: {\n        shape: element,\n        context: context || {}\n      }\n    });\n\n    // we've handled the event\n    return true;\n  }\n\n  // API\n\n  this.start = start;\n}\n\nMoveEvents.$inject = [\n  'eventBus',\n  'dragging',\n  'modeling',\n  'selection',\n  'rules'\n];\n\n\n/**\n * Return a filtered list of elements that do not contain\n * those nested into others.\n *\n * @param {Element[]} elements\n *\n * @return {Element[]} filtered\n */\nfunction removeNested(elements) {\n\n  var ids = (0,index_esm/* groupBy */.vM)(elements, 'id');\n\n  return (0,index_esm/* filter */.hX)(elements, function(element) {\n    while ((element = element.parent)) {\n\n      // parent in selection\n      if (ids[element.id]) {\n        return false;\n      }\n    }\n\n    return true;\n  });\n}\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/SvgTransformUtil.js\nvar SvgTransformUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/SvgTransformUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/ModelUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/move/MovePreview.js\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../model/Types').Element} Element\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../preview-support/PreviewSupport').default} PreviewSupport\n * @typedef {import('../../draw/Styles').default} Styles\n */\n\nvar MovePreview_LOW_PRIORITY = 499;\n\nvar MARKER_DRAGGING = 'djs-dragging',\n    MARKER_OK = 'drop-ok',\n    MARKER_NOT_OK = 'drop-not-ok',\n    MARKER_NEW_PARENT = 'new-parent',\n    MARKER_ATTACH = 'attach-ok';\n\n\n/**\n * Provides previews for moving shapes when moving.\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {Styles} styles\n * @param {PreviewSupport} previewSupport\n */\nfunction MovePreview(\n    eventBus, canvas, styles, previewSupport) {\n\n  function getVisualDragShapes(shapes) {\n    var elements = getAllDraggedElements(shapes);\n\n    var filteredElements = removeEdges(elements);\n\n    return filteredElements;\n  }\n\n  function getAllDraggedElements(shapes) {\n    var allShapes = (0,Elements/* selfAndAllChildren */.PB)(shapes, true);\n\n    var allConnections = (0,index_esm/* map */.UI)(allShapes, function(shape) {\n      return (shape.incoming || []).concat(shape.outgoing || []);\n    });\n\n    return (0,index_esm/* flatten */.xH)(allShapes.concat(allConnections));\n  }\n\n  /**\n   * Sets drop marker on an element.\n   */\n  function setMarker(element, marker) {\n\n    [ MARKER_ATTACH, MARKER_OK, MARKER_NOT_OK, MARKER_NEW_PARENT ].forEach(function(m) {\n\n      if (m === marker) {\n        canvas.addMarker(element, m);\n      } else {\n        canvas.removeMarker(element, m);\n      }\n    });\n  }\n\n  /**\n   * Make an element draggable.\n   *\n   * @param {Object} context\n   * @param {Element} element\n   * @param {boolean} addMarker\n   */\n  function makeDraggable(context, element, addMarker) {\n\n    previewSupport.addDragger(element, context.dragGroup);\n\n    if (addMarker) {\n      canvas.addMarker(element, MARKER_DRAGGING);\n    }\n\n    if (context.allDraggedElements) {\n      context.allDraggedElements.push(element);\n    } else {\n      context.allDraggedElements = [ element ];\n    }\n  }\n\n  // assign a low priority to this handler\n  // to let others modify the move context before\n  // we draw things\n  eventBus.on('shape.move.start', MovePreview_LOW_PRIORITY, function(event) {\n    var context = event.context,\n        dragShapes = context.shapes,\n        allDraggedElements = context.allDraggedElements;\n\n    var visuallyDraggedShapes = getVisualDragShapes(dragShapes);\n\n    if (!context.dragGroup) {\n      var dragGroup = (0,dist_index_esm/* create */.Ue)('g');\n\n      (0,dist_index_esm/* attr */.Lj)(dragGroup, styles.cls('djs-drag-group', [ 'no-events' ]));\n\n      var activeLayer = canvas.getActiveLayer();\n\n      (0,dist_index_esm/* append */.R3)(activeLayer, dragGroup);\n\n      context.dragGroup = dragGroup;\n    }\n\n    // add previews\n    visuallyDraggedShapes.forEach(function(shape) {\n      previewSupport.addDragger(shape, context.dragGroup);\n    });\n\n    // cache all dragged elements / gfx\n    // so that we can quickly undo their state changes later\n    if (!allDraggedElements) {\n      allDraggedElements = getAllDraggedElements(dragShapes);\n    } else {\n      allDraggedElements = (0,index_esm/* flatten */.xH)([\n        allDraggedElements,\n        getAllDraggedElements(dragShapes)\n      ]);\n    }\n\n    // add dragging marker\n    (0,index_esm/* forEach */.Ed)(allDraggedElements, function(e) {\n      canvas.addMarker(e, MARKER_DRAGGING);\n    });\n\n    context.allDraggedElements = allDraggedElements;\n\n    // determine, if any of the dragged elements have different parents\n    context.differentParents = haveDifferentParents(dragShapes);\n  });\n\n  // update previews\n  eventBus.on('shape.move.move', MovePreview_LOW_PRIORITY, function(event) {\n\n    var context = event.context,\n        dragGroup = context.dragGroup,\n        target = context.target,\n        parent = context.shape.parent,\n        canExecute = context.canExecute;\n\n    if (target) {\n      if (canExecute === 'attach') {\n        setMarker(target, MARKER_ATTACH);\n      } else if (context.canExecute && target && target.id !== parent.id) {\n        setMarker(target, MARKER_NEW_PARENT);\n      } else {\n        setMarker(target, context.canExecute ? MARKER_OK : MARKER_NOT_OK);\n      }\n    }\n\n    (0,SvgTransformUtil/* translate */.Iu)(dragGroup, event.dx, event.dy);\n  });\n\n  eventBus.on([ 'shape.move.out', 'shape.move.cleanup' ], function(event) {\n    var context = event.context,\n        target = context.target;\n\n    if (target) {\n      setMarker(target, null);\n    }\n  });\n\n  // remove previews\n  eventBus.on('shape.move.cleanup', function(event) {\n\n    var context = event.context,\n        allDraggedElements = context.allDraggedElements,\n        dragGroup = context.dragGroup;\n\n\n    // remove dragging marker\n    (0,index_esm/* forEach */.Ed)(allDraggedElements, function(e) {\n      canvas.removeMarker(e, MARKER_DRAGGING);\n    });\n\n    if (dragGroup) {\n      (0,dist_index_esm/* remove */.Od)(dragGroup);\n    }\n  });\n\n\n  // API //////////////////////\n\n  /**\n   * Make an element draggable.\n   *\n   * @param {Object} context\n   * @param {Element} element\n   * @param {boolean} addMarker\n   */\n  this.makeDraggable = makeDraggable;\n}\n\nMovePreview.$inject = [\n  'eventBus',\n  'canvas',\n  'styles',\n  'previewSupport'\n];\n\n\n// helpers //////////////////////\n\n/**\n * returns elements minus all connections\n * where source or target is not elements\n */\nfunction removeEdges(elements) {\n\n  var filteredElements = (0,index_esm/* filter */.hX)(elements, function(element) {\n\n    if (!(0,ModelUtil/* isConnection */.Ho)(element)) {\n      return true;\n    } else {\n\n      return (\n        (0,index_esm/* find */.sE)(elements, (0,index_esm/* matchPattern */.KQ)({ id: element.source.id })) &&\n        (0,index_esm/* find */.sE)(elements, (0,index_esm/* matchPattern */.KQ)({ id: element.target.id }))\n      );\n    }\n  });\n\n  return filteredElements;\n}\n\nfunction haveDifferentParents(elements) {\n  return (0,index_esm/* size */.dp)((0,index_esm/* groupBy */.vM)(elements, function(e) { return e.parent && e.parent.id; })) !== 1;\n}\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/move/index.js\n\n\n\n\n\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const move = ({\n  __depends__: [\n    interaction_events/* default */.Z,\n    selection/* default */.Z,\n    outline/* default */.Z,\n    rules/* default */.Z,\n    dragging/* default */.Z,\n    preview_support/* default */.Z\n  ],\n  __init__: [\n    'move',\n    'movePreview'\n  ],\n  move: [ 'type', MoveEvents ],\n  movePreview: [ 'type', MovePreview ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/move/index.js_+_2_modules?")},"./node_modules/diagram-js/lib/features/ordering/OrderingProvider.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ OrderingProvider)\n/* harmony export */ });\n/* harmony import */ var inherits_browser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n/* harmony import */ var _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/lib/command/CommandInterceptor.js\");\n\n\n\n\n/**\n * @typedef {import('../../core/Types').ElementLike} Element\n * @typedef {import('../../core/Types').ShapeLike} Shape\n *\n * @typedef {import('../../core/EventBus').default} EventBus\n */\n\n/**\n * An abstract provider that allows modelers to implement a custom\n * ordering of diagram elements on the canvas.\n *\n * It makes sure that the order is always preserved during element\n * creation and move operations.\n *\n * In order to use this behavior, inherit from it and override\n * the method {@link OrderingProvider#getOrdering}.\n *\n * @example\n *\n * ```javascript\n * function CustomOrderingProvider(eventBus) {\n *   OrderingProvider.call(this, eventBus);\n *\n *   this.getOrdering = function(element, newParent) {\n *     // always insert elements at the front\n *     // when moving\n *     return {\n *       index: 0,\n *       parent: newParent\n *     };\n *   };\n * }\n * ```\n *\n * @param {EventBus} eventBus\n */\nfunction OrderingProvider(eventBus) {\n\n  _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_0__/* [\"default\"].call */ .Z.call(this, eventBus);\n\n\n  var self = this;\n\n  this.preExecute([ 'shape.create', 'connection.create' ], function(event) {\n\n    var context = event.context,\n        element = context.shape || context.connection,\n        parent = context.parent;\n\n    var ordering = self.getOrdering(element, parent);\n\n    if (ordering) {\n\n      if (ordering.parent !== undefined) {\n        context.parent = ordering.parent;\n      }\n\n      context.parentIndex = ordering.index;\n    }\n  });\n\n  this.preExecute([ 'shape.move', 'connection.move' ], function(event) {\n\n    var context = event.context,\n        element = context.shape || context.connection,\n        parent = context.newParent || element.parent;\n\n    var ordering = self.getOrdering(element, parent);\n\n    if (ordering) {\n\n      if (ordering.parent !== undefined) {\n        context.newParent = ordering.parent;\n      }\n\n      context.newParentIndex = ordering.index;\n    }\n  });\n}\n\n/**\n * Return a custom ordering of the element, both in terms\n * of parent element and index in the new parent.\n *\n * Implementors of this method must return an object with\n * `parent` _and_ `index` in it.\n *\n * @param {Element} element\n * @param {Shape} newParent\n *\n * @return {Object} ordering descriptor\n */\nOrderingProvider.prototype.getOrdering = function(element, newParent) {\n  return null;\n};\n\n(0,inherits_browser__WEBPACK_IMPORTED_MODULE_1__/* [\"default\"] */ .Z)(OrderingProvider, _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_0__/* [\"default\"] */ .Z);\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/ordering/OrderingProvider.js?")},"./node_modules/diagram-js/lib/features/outline/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ outline)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar min_dash_dist_index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/outline/Outline.js\n\n\nvar LOW_PRIORITY = 500;\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../model/Types').Element} Element\n *\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../../draw/Styles').default} Styles\n */\n\n/**\n * @class\n *\n * A plugin that adds an outline to shapes and connections that may be activated and styled\n * via CSS classes.\n *\n * @param {EventBus} eventBus\n * @param {Styles} styles\n */\nfunction Outline(eventBus, styles) {\n\n  this.offset = 6;\n\n  var OUTLINE_STYLE = styles.cls('djs-outline', [ 'no-fill' ]);\n\n  var self = this;\n\n  function createOutline(gfx, bounds) {\n    var outline = (0,index_esm/* create */.Ue)('rect');\n\n    (0,index_esm/* attr */.Lj)(outline, (0,min_dash_dist_index_esm/* assign */.f0)({\n      x: 10,\n      y: 10,\n      rx: 4,\n      width: 100,\n      height: 100\n    }, OUTLINE_STYLE));\n\n    (0,index_esm/* append */.R3)(gfx, outline);\n\n    return outline;\n  }\n\n  // A low priortity is necessary, because outlines of labels have to be updated\n  // after the label bounds have been updated in the renderer.\n  eventBus.on([ 'shape.added', 'shape.changed' ], LOW_PRIORITY, function(event) {\n    var element = event.element,\n        gfx = event.gfx;\n\n    var outline = (0,dist_index_esm/* query */.IO)('.djs-outline', gfx);\n\n    if (!outline) {\n      outline = createOutline(gfx, element);\n    }\n\n    self.updateShapeOutline(outline, element);\n  });\n\n  eventBus.on([ 'connection.added', 'connection.changed' ], function(event) {\n    var element = event.element,\n        gfx = event.gfx;\n\n    var outline = (0,dist_index_esm/* query */.IO)('.djs-outline', gfx);\n\n    if (!outline) {\n      outline = createOutline(gfx, element);\n    }\n\n    self.updateConnectionOutline(outline, element);\n  });\n}\n\n\n/**\n * Updates the outline of a shape respecting the dimension of the\n * element and an outline offset.\n *\n * @param {SVGElement} outline\n * @param {Element} element\n */\nOutline.prototype.updateShapeOutline = function(outline, element) {\n\n  (0,index_esm/* attr */.Lj)(outline, {\n    x: -this.offset,\n    y: -this.offset,\n    width: element.width + this.offset * 2,\n    height: element.height + this.offset * 2\n  });\n\n};\n\n\n/**\n * Updates the outline of a connection respecting the bounding box of\n * the connection and an outline offset.\n *\n * @param {SVGElement} outline\n * @param {Element} connection\n */\nOutline.prototype.updateConnectionOutline = function(outline, connection) {\n\n  var bbox = (0,Elements/* getBBox */.jY)(connection);\n\n  (0,index_esm/* attr */.Lj)(outline, {\n    x: bbox.x - this.offset,\n    y: bbox.y - this.offset,\n    width: bbox.width + this.offset * 2,\n    height: bbox.height + this.offset * 2\n  });\n\n};\n\n\nOutline.$inject = [ 'eventBus', 'styles', 'elementRegistry' ];\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/outline/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const outline = ({\n  __init__: [ 'outline' ],\n  outline: [ 'type', Outline ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/outline/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/overlays/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ overlays)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/IdGenerator.js\nvar IdGenerator = __webpack_require__(\"./node_modules/diagram-js/lib/util/IdGenerator.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/overlays/Overlays.js\n\n\n\n\n\n\n\n\n// document wide unique overlay ids\nvar ids = new IdGenerator/* default */.Z('ov');\n\nvar LOW_PRIORITY = 500;\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/ElementRegistry').default} ElementRegistry\n * @typedef {import('../../core/EventBus').default} EventBus\n *\n * @typedef {import('../../model/Types').Element} Element\n *\n * @typedef { {\n *   minZoom?: number,\n *   maxZoom?: number\n * } } OverlaysConfigShow\n *\n * @typedef { {\n *   min?: number,\n *   max?: number\n * } } OverlaysConfigScale\n *\n * @typedef { {\n*   id: string,\n*   type: string | null,\n*   element: Element | string\n* } & OverlayAttrs } Overlay\n*\n * @typedef { {\n *   html: HTMLElement | string,\n *   position: {\n *     top?: number,\n *     right?: number,\n *     bottom?: number,\n *     left?: number\n *   }\n * } & OverlaysConfigDefault } OverlayAttrs\n *\n * @typedef { {\n *   html: HTMLElement,\n *   element: Element,\n *   overlays: Overlay[]\n * } } OverlayContainer\n *\n * @typedef {{\n *   defaults?: OverlaysConfigDefault\n * }} OverlaysConfig\n *\n * @typedef { {\n *  show?: OverlaysConfigShow,\n *  scale?: OverlaysConfigScale | boolean\n * } } OverlaysConfigDefault\n *\n * @typedef { {\n *   id?: string;\n *   element?: Element | string;\n *   type?: string;\n * } | string } OverlaysFilter\n */\n\n/**\n * A service that allows users to attach overlays to diagram elements.\n *\n * The overlay service will take care of overlay positioning during updates.\n *\n * @example\n *\n * ```javascript\n * // add a pink badge on the top left of the shape\n *\n * overlays.add(someShape, {\n *   position: {\n *     top: -5,\n *     left: -5\n *   },\n *   html: '<div style=\"width: 10px; background: fuchsia; color: white;\">0</div>'\n * });\n *\n * // or add via shape id\n *\n * overlays.add('some-element-id', {\n *   position: {\n *     top: -5,\n *     left: -5\n *   }\n *   html: '<div style=\"width: 10px; background: fuchsia; color: white;\">0</div>'\n * });\n *\n * // or add with optional type\n *\n * overlays.add(someShape, 'badge', {\n *   position: {\n *     top: -5,\n *     left: -5\n *   }\n *   html: '<div style=\"width: 10px; background: fuchsia; color: white;\">0</div>'\n * });\n * ```\n *\n * ```javascript\n * // remove an overlay\n *\n * var id = overlays.add(...);\n * overlays.remove(id);\n *\n *\n * You may configure overlay defaults during tool by providing a `config` module\n * with `overlays.defaults` as an entry:\n *\n * {\n *   overlays: {\n *     defaults: {\n *       show: {\n *         minZoom: 0.7,\n *         maxZoom: 5.0\n *       },\n *       scale: {\n *         min: 1\n *       }\n *     }\n * }\n * ```\n *\n * @param {OverlaysConfig} config\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {ElementRegistry} elementRegistry\n */\nfunction Overlays(config, eventBus, canvas, elementRegistry) {\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n  this._elementRegistry = elementRegistry;\n\n  this._ids = ids;\n\n  /**\n   * @type {OverlaysConfigDefault}\n   */\n  this._overlayDefaults = (0,index_esm/* assign */.f0)({\n\n    // no show constraints\n    show: null,\n\n    // always scale\n    scale: true\n  }, config && config.defaults);\n\n  /**\n   * @type {Map<string, Overlay>}\n   */\n  this._overlays = {};\n\n  /**\n   * @type {OverlayContainer[]}\n   */\n  this._overlayContainers = [];\n\n  /**\n   * @type {HTMLElement}\n   */\n  this._overlayRoot = createRoot(canvas.getContainer());\n\n  this._init();\n}\n\n\nOverlays.$inject = [\n  'config.overlays',\n  'eventBus',\n  'canvas',\n  'elementRegistry'\n];\n\n\n/**\n * Returns the overlay with the specified ID or a list of overlays\n * for an element with a given type.\n *\n * @example\n *\n * ```javascript\n * // return the single overlay with the given ID\n * overlays.get('some-id');\n *\n * // return all overlays for the shape\n * overlays.get({ element: someShape });\n *\n * // return all overlays on shape with type 'badge'\n * overlays.get({ element: someShape, type: 'badge' });\n *\n * // shape can also be specified as ID\n * overlays.get({ element: 'element-id', type: 'badge' });\n * ```\n *\n * @param {OverlaysFilter} search The filter to be used to find the overlay(s).\n *\n * @return {Overlay|Overlay[]} The overlay(s).\n */\nOverlays.prototype.get = function(search) {\n\n  if ((0,index_esm/* isString */.HD)(search)) {\n    search = { id: search };\n  }\n\n  if ((0,index_esm/* isString */.HD)(search.element)) {\n    search.element = this._elementRegistry.get(search.element);\n  }\n\n  if (search.element) {\n    var container = this._getOverlayContainer(search.element, true);\n\n    // return a list of overlays when searching by element (+type)\n    if (container) {\n      return search.type ? (0,index_esm/* filter */.hX)(container.overlays, (0,index_esm/* matchPattern */.KQ)({ type: search.type })) : container.overlays.slice();\n    } else {\n      return [];\n    }\n  } else\n  if (search.type) {\n    return (0,index_esm/* filter */.hX)(this._overlays, (0,index_esm/* matchPattern */.KQ)({ type: search.type }));\n  } else {\n\n    // return single element when searching by id\n    return search.id ? this._overlays[search.id] : null;\n  }\n};\n\n/**\n * Adds an HTML overlay to an element.\n *\n * @param {Element|string} element The element to add the overlay to.\n * @param {string} [type] An optional type that can be used to filter.\n * @param {OverlayAttrs} overlay The overlay.\n *\n * @return {string} The overlay's ID that can be used to get or remove it.\n */\nOverlays.prototype.add = function(element, type, overlay) {\n\n  if ((0,index_esm/* isObject */.Kn)(type)) {\n    overlay = type;\n    type = null;\n  }\n\n  if (!element.id) {\n    element = this._elementRegistry.get(element);\n  }\n\n  if (!overlay.position) {\n    throw new Error('must specifiy overlay position');\n  }\n\n  if (!overlay.html) {\n    throw new Error('must specifiy overlay html');\n  }\n\n  if (!element) {\n    throw new Error('invalid element specified');\n  }\n\n  var id = this._ids.next();\n\n  overlay = (0,index_esm/* assign */.f0)({}, this._overlayDefaults, overlay, {\n    id: id,\n    type: type,\n    element: element,\n    html: overlay.html\n  });\n\n  this._addOverlay(overlay);\n\n  return id;\n};\n\n\n/**\n * Remove an overlay with the given ID or all overlays matching the given filter.\n *\n * @see Overlays#get for filter options.\n *\n * @param {OverlaysFilter} filter The filter to be used to find the overlay.\n */\nOverlays.prototype.remove = function(filter) {\n\n  var overlays = this.get(filter) || [];\n\n  if (!(0,index_esm/* isArray */.kJ)(overlays)) {\n    overlays = [ overlays ];\n  }\n\n  var self = this;\n\n  (0,index_esm/* forEach */.Ed)(overlays, function(overlay) {\n\n    var container = self._getOverlayContainer(overlay.element, true);\n\n    if (overlay) {\n      (0,dist_index_esm/* remove */.Od)(overlay.html);\n      (0,dist_index_esm/* remove */.Od)(overlay.htmlContainer);\n\n      delete overlay.htmlContainer;\n      delete overlay.element;\n\n      delete self._overlays[overlay.id];\n    }\n\n    if (container) {\n      var idx = container.overlays.indexOf(overlay);\n      if (idx !== -1) {\n        container.overlays.splice(idx, 1);\n      }\n    }\n  });\n\n};\n\n/**\n * Checks whether overlays are shown.\n *\n * @return {boolean} Whether overlays are shown.\n */\nOverlays.prototype.isShown = function() {\n  return this._overlayRoot.style.display !== 'none';\n};\n\n/**\n * Show all overlays.\n */\nOverlays.prototype.show = function() {\n  setVisible(this._overlayRoot);\n};\n\n/**\n * Hide all overlays.\n */\nOverlays.prototype.hide = function() {\n  setVisible(this._overlayRoot, false);\n};\n\n/**\n * Remove all overlays and their container.\n */\nOverlays.prototype.clear = function() {\n  this._overlays = {};\n\n  this._overlayContainers = [];\n\n  (0,dist_index_esm/* clear */.ZH)(this._overlayRoot);\n};\n\nOverlays.prototype._updateOverlayContainer = function(container) {\n  var element = container.element,\n      html = container.html;\n\n  // update container left,top according to the elements x,y coordinates\n  // this ensures we can attach child elements relative to this container\n\n  var x = element.x,\n      y = element.y;\n\n  if (element.waypoints) {\n    var bbox = (0,Elements/* getBBox */.jY)(element);\n    x = bbox.x;\n    y = bbox.y;\n  }\n\n  setPosition(html, x, y);\n\n  (0,dist_index_esm/* attr */.Lj)(container.html, 'data-container-id', element.id);\n};\n\n\nOverlays.prototype._updateOverlay = function(overlay) {\n\n  var position = overlay.position,\n      htmlContainer = overlay.htmlContainer,\n      element = overlay.element;\n\n  // update overlay html relative to shape because\n  // it is already positioned on the element\n\n  // update relative\n  var left = position.left,\n      top = position.top;\n\n  if (position.right !== undefined) {\n\n    var width;\n\n    if (element.waypoints) {\n      width = (0,Elements/* getBBox */.jY)(element).width;\n    } else {\n      width = element.width;\n    }\n\n    left = position.right * -1 + width;\n  }\n\n  if (position.bottom !== undefined) {\n\n    var height;\n\n    if (element.waypoints) {\n      height = (0,Elements/* getBBox */.jY)(element).height;\n    } else {\n      height = element.height;\n    }\n\n    top = position.bottom * -1 + height;\n  }\n\n  setPosition(htmlContainer, left || 0, top || 0);\n  this._updateOverlayVisibilty(overlay, this._canvas.viewbox());\n};\n\n\nOverlays.prototype._createOverlayContainer = function(element) {\n  var html = (0,dist_index_esm/* domify */.H6)('<div class=\"djs-overlays\" />');\n  (0,dist_index_esm/* assignStyle */.i5)(html, { position: 'absolute' });\n\n  this._overlayRoot.appendChild(html);\n\n  var container = {\n    html: html,\n    element: element,\n    overlays: []\n  };\n\n  this._updateOverlayContainer(container);\n\n  this._overlayContainers.push(container);\n\n  return container;\n};\n\n\nOverlays.prototype._updateRoot = function(viewbox) {\n  var scale = viewbox.scale || 1;\n\n  var matrix = 'matrix(' +\n  [\n    scale,\n    0,\n    0,\n    scale,\n    -1 * viewbox.x * scale,\n    -1 * viewbox.y * scale\n  ].join(',') +\n  ')';\n\n  setTransform(this._overlayRoot, matrix);\n};\n\n\nOverlays.prototype._getOverlayContainer = function(element, raw) {\n  var container = (0,index_esm/* find */.sE)(this._overlayContainers, function(c) {\n    return c.element === element;\n  });\n\n\n  if (!container && !raw) {\n    return this._createOverlayContainer(element);\n  }\n\n  return container;\n};\n\n\nOverlays.prototype._addOverlay = function(overlay) {\n\n  var id = overlay.id,\n      element = overlay.element,\n      html = overlay.html,\n      htmlContainer,\n      overlayContainer;\n\n  // unwrap jquery (for those who need it)\n  if (html.get && html.constructor.prototype.jquery) {\n    html = html.get(0);\n  }\n\n  // create proper html elements from\n  // overlay HTML strings\n  if ((0,index_esm/* isString */.HD)(html)) {\n    html = (0,dist_index_esm/* domify */.H6)(html);\n  }\n\n  overlayContainer = this._getOverlayContainer(element);\n\n  htmlContainer = (0,dist_index_esm/* domify */.H6)('<div class=\"djs-overlay\" data-overlay-id=\"' + id + '\">');\n  (0,dist_index_esm/* assignStyle */.i5)(htmlContainer, { position: 'absolute' });\n\n  htmlContainer.appendChild(html);\n\n  if (overlay.type) {\n    (0,dist_index_esm/* classes */.Sh)(htmlContainer).add('djs-overlay-' + overlay.type);\n  }\n\n  var elementRoot = this._canvas.findRoot(element);\n  var activeRoot = this._canvas.getRootElement();\n\n  setVisible(htmlContainer, elementRoot === activeRoot);\n\n  overlay.htmlContainer = htmlContainer;\n\n  overlayContainer.overlays.push(overlay);\n  overlayContainer.html.appendChild(htmlContainer);\n\n  this._overlays[id] = overlay;\n\n  this._updateOverlay(overlay);\n  this._updateOverlayVisibilty(overlay, this._canvas.viewbox());\n};\n\n\nOverlays.prototype._updateOverlayVisibilty = function(overlay, viewbox) {\n  var show = overlay.show,\n      rootElement = this._canvas.findRoot(overlay.element),\n      minZoom = show && show.minZoom,\n      maxZoom = show && show.maxZoom,\n      htmlContainer = overlay.htmlContainer,\n      activeRootElement = this._canvas.getRootElement(),\n      visible = true;\n\n  if (rootElement !== activeRootElement) {\n    visible = false;\n  } else if (show) {\n    if (\n      ((0,index_esm/* isDefined */.$K)(minZoom) && minZoom > viewbox.scale) ||\n      ((0,index_esm/* isDefined */.$K)(maxZoom) && maxZoom < viewbox.scale)\n    ) {\n      visible = false;\n    }\n  }\n\n  setVisible(htmlContainer, visible);\n\n  this._updateOverlayScale(overlay, viewbox);\n};\n\n\nOverlays.prototype._updateOverlayScale = function(overlay, viewbox) {\n  var shouldScale = overlay.scale,\n      minScale,\n      maxScale,\n      htmlContainer = overlay.htmlContainer;\n\n  var scale, transform = '';\n\n  if (shouldScale !== true) {\n\n    if (shouldScale === false) {\n      minScale = 1;\n      maxScale = 1;\n    } else {\n      minScale = shouldScale.min;\n      maxScale = shouldScale.max;\n    }\n\n    if ((0,index_esm/* isDefined */.$K)(minScale) && viewbox.scale < minScale) {\n      scale = (1 / viewbox.scale || 1) * minScale;\n    }\n\n    if ((0,index_esm/* isDefined */.$K)(maxScale) && viewbox.scale > maxScale) {\n      scale = (1 / viewbox.scale || 1) * maxScale;\n    }\n  }\n\n  if ((0,index_esm/* isDefined */.$K)(scale)) {\n    transform = 'scale(' + scale + ',' + scale + ')';\n  }\n\n  setTransform(htmlContainer, transform);\n};\n\n\nOverlays.prototype._updateOverlaysVisibilty = function(viewbox) {\n\n  var self = this;\n\n  (0,index_esm/* forEach */.Ed)(this._overlays, function(overlay) {\n    self._updateOverlayVisibilty(overlay, viewbox);\n  });\n};\n\n\nOverlays.prototype._init = function() {\n\n  var eventBus = this._eventBus;\n\n  var self = this;\n\n\n  // scroll/zoom integration\n\n  function updateViewbox(viewbox) {\n    self._updateRoot(viewbox);\n    self._updateOverlaysVisibilty(viewbox);\n\n    self.show();\n  }\n\n  eventBus.on('canvas.viewbox.changing', function(event) {\n    self.hide();\n  });\n\n  eventBus.on('canvas.viewbox.changed', function(event) {\n    updateViewbox(event.viewbox);\n  });\n\n\n  // remove integration\n\n  eventBus.on([ 'shape.remove', 'connection.remove' ], function(e) {\n    var element = e.element;\n    var overlays = self.get({ element: element });\n\n    (0,index_esm/* forEach */.Ed)(overlays, function(o) {\n      self.remove(o.id);\n    });\n\n    var container = self._getOverlayContainer(element);\n\n    if (container) {\n      (0,dist_index_esm/* remove */.Od)(container.html);\n      var i = self._overlayContainers.indexOf(container);\n      if (i !== -1) {\n        self._overlayContainers.splice(i, 1);\n      }\n    }\n  });\n\n\n  // move integration\n\n  eventBus.on('element.changed', LOW_PRIORITY, function(e) {\n    var element = e.element;\n\n    var container = self._getOverlayContainer(element, true);\n\n    if (container) {\n      (0,index_esm/* forEach */.Ed)(container.overlays, function(overlay) {\n        self._updateOverlay(overlay);\n      });\n\n      self._updateOverlayContainer(container);\n    }\n  });\n\n\n  // marker integration, simply add them on the overlays as classes, too.\n\n  eventBus.on('element.marker.update', function(e) {\n    var container = self._getOverlayContainer(e.element, true);\n    if (container) {\n      (0,dist_index_esm/* classes */.Sh)(container.html)[e.add ? 'add' : 'remove'](e.marker);\n    }\n  });\n\n\n  eventBus.on('root.set', function() {\n    self._updateOverlaysVisibilty(self._canvas.viewbox());\n  });\n\n  // clear overlays with diagram\n\n  eventBus.on('diagram.clear', this.clear, this);\n};\n\n\n\n// helpers /////////////////////////////\n\nfunction createRoot(parentNode) {\n  var root = (0,dist_index_esm/* domify */.H6)(\n    '<div class=\"djs-overlay-container\" />'\n  );\n\n  (0,dist_index_esm/* assignStyle */.i5)(root, {\n    position: 'absolute',\n    width: 0,\n    height: 0\n  });\n\n  parentNode.insertBefore(root, parentNode.firstChild);\n\n  return root;\n}\n\nfunction setPosition(el, x, y) {\n  (0,dist_index_esm/* assignStyle */.i5)(el, { left: x + 'px', top: y + 'px' });\n}\n\n/**\n * Set element visible\n *\n * @param {DOMElement} el\n * @param {boolean} [visible=true]\n */\nfunction setVisible(el, visible) {\n  el.style.display = visible === false ? 'none' : '';\n}\n\nfunction setTransform(el, transform) {\n\n  el.style['transform-origin'] = 'top left';\n\n  [ '', '-ms-', '-webkit-' ].forEach(function(prefix) {\n    el.style[prefix + 'transform'] = transform;\n  });\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/overlays/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const overlays = ({\n  __init__: [ 'overlays' ],\n  overlays: [ 'type', Overlays ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/overlays/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/palette/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ palette)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/EscapeUtil.js\nvar EscapeUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/EscapeUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/palette/Palette.js\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n *\n * @typedef {import('./PaletteProvider').PaletteEntries} PaletteEntries\n * @typedef {import('./PaletteProvider').default} PaletteProvider\n */\n\nvar TOGGLE_SELECTOR = '.djs-palette-toggle',\n    ENTRY_SELECTOR = '.entry',\n    ELEMENT_SELECTOR = TOGGLE_SELECTOR + ', ' + ENTRY_SELECTOR;\n\nvar PALETTE_PREFIX = 'djs-palette-',\n    PALETTE_SHOWN_CLS = 'shown',\n    PALETTE_OPEN_CLS = 'open',\n    PALETTE_TWO_COLUMN_CLS = 'two-column';\n\nvar DEFAULT_PRIORITY = 1000;\n\n\n/**\n * A palette containing modeling elements.\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n */\nfunction Palette(eventBus, canvas) {\n\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n\n  var self = this;\n\n  eventBus.on('tool-manager.update', function(event) {\n    var tool = event.tool;\n\n    self.updateToolHighlight(tool);\n  });\n\n  eventBus.on('i18n.changed', function() {\n    self._update();\n  });\n\n  eventBus.on('diagram.init', function() {\n\n    self._diagramInitialized = true;\n\n    self._rebuild();\n  });\n}\n\nPalette.$inject = [ 'eventBus', 'canvas' ];\n\n/**\n * @overlord\n *\n * Register a palette provider with default priority. See\n * {@link PaletteProvider} for examples.\n *\n * @param {PaletteProvider} provider\n */\n\n/**\n * Register a palette provider with the given priority. See\n * {@link PaletteProvider} for examples.\n *\n * @param {number} priority\n * @param {PaletteProvider} provider\n */\nPalette.prototype.registerProvider = function(priority, provider) {\n  if (!provider) {\n    provider = priority;\n    priority = DEFAULT_PRIORITY;\n  }\n\n  this._eventBus.on('palette.getProviders', priority, function(event) {\n    event.providers.push(provider);\n  });\n\n  this._rebuild();\n};\n\n\n/**\n * Returns the palette entries.\n *\n * @return {PaletteEntries}\n */\nPalette.prototype.getEntries = function() {\n  var providers = this._getProviders();\n\n  return providers.reduce(addPaletteEntries, {});\n};\n\nPalette.prototype._rebuild = function() {\n\n  if (!this._diagramInitialized) {\n    return;\n  }\n\n  var providers = this._getProviders();\n\n  if (!providers.length) {\n    return;\n  }\n\n  if (!this._container) {\n    this._init();\n  }\n\n  this._update();\n};\n\n/**\n * Initialize palette.\n */\nPalette.prototype._init = function() {\n\n  var self = this;\n\n  var eventBus = this._eventBus;\n\n  var parentContainer = this._getParentContainer();\n\n  var container = this._container = (0,dist_index_esm/* domify */.H6)(Palette.HTML_MARKUP);\n\n  parentContainer.appendChild(container);\n  (0,dist_index_esm/* classes */.Sh)(parentContainer).add(PALETTE_PREFIX + PALETTE_SHOWN_CLS);\n\n  dist_index_esm/* delegate.bind */.cl.bind(container, ELEMENT_SELECTOR, 'click', function(event) {\n\n    var target = event.delegateTarget;\n\n    if ((0,dist_index_esm/* matches */.wB)(target, TOGGLE_SELECTOR)) {\n      return self.toggle();\n    }\n\n    self.trigger('click', event);\n  });\n\n  // prevent drag propagation\n  dist_index_esm/* event.bind */.B.bind(container, 'mousedown', function(event) {\n    event.stopPropagation();\n  });\n\n  // prevent drag propagation\n  dist_index_esm/* delegate.bind */.cl.bind(container, ENTRY_SELECTOR, 'dragstart', function(event) {\n    self.trigger('dragstart', event);\n  });\n\n  eventBus.on('canvas.resized', this._layoutChanged, this);\n\n  eventBus.fire('palette.create', {\n    container: container\n  });\n};\n\nPalette.prototype._getProviders = function(id) {\n\n  var event = this._eventBus.createEvent({\n    type: 'palette.getProviders',\n    providers: []\n  });\n\n  this._eventBus.fire(event);\n\n  return event.providers;\n};\n\n/**\n * Update palette state.\n *\n * @param { {\n *   open?: boolean;\n *   twoColumn?: boolean;\n * } } [state]\n */\nPalette.prototype._toggleState = function(state) {\n\n  state = state || {};\n\n  var parent = this._getParentContainer(),\n      container = this._container;\n\n  var eventBus = this._eventBus;\n\n  var twoColumn;\n\n  var cls = (0,dist_index_esm/* classes */.Sh)(container),\n      parentCls = (0,dist_index_esm/* classes */.Sh)(parent);\n\n  if ('twoColumn' in state) {\n    twoColumn = state.twoColumn;\n  } else {\n    twoColumn = this._needsCollapse(parent.clientHeight, this._entries || {});\n  }\n\n  // always update two column\n  cls.toggle(PALETTE_TWO_COLUMN_CLS, twoColumn);\n  parentCls.toggle(PALETTE_PREFIX + PALETTE_TWO_COLUMN_CLS, twoColumn);\n\n  if ('open' in state) {\n    cls.toggle(PALETTE_OPEN_CLS, state.open);\n    parentCls.toggle(PALETTE_PREFIX + PALETTE_OPEN_CLS, state.open);\n  }\n\n  eventBus.fire('palette.changed', {\n    twoColumn: twoColumn,\n    open: this.isOpen()\n  });\n};\n\nPalette.prototype._update = function() {\n\n  var entriesContainer = (0,dist_index_esm/* query */.IO)('.djs-palette-entries', this._container),\n      entries = this._entries = this.getEntries();\n\n  (0,dist_index_esm/* clear */.ZH)(entriesContainer);\n\n  (0,index_esm/* forEach */.Ed)(entries, function(entry, id) {\n\n    var grouping = entry.group || 'default';\n\n    var container = (0,dist_index_esm/* query */.IO)('[data-group=' + (0,EscapeUtil/* escapeCSS */.D)(grouping) + ']', entriesContainer);\n    if (!container) {\n      container = (0,dist_index_esm/* domify */.H6)('<div class=\"group\"></div>');\n      (0,dist_index_esm/* attr */.Lj)(container, 'data-group', grouping);\n\n      entriesContainer.appendChild(container);\n    }\n\n    var html = entry.html || (\n      entry.separator ?\n        '<hr class=\"separator\" />' :\n        '<div class=\"entry\" draggable=\"true\"></div>');\n\n\n    var control = (0,dist_index_esm/* domify */.H6)(html);\n    container.appendChild(control);\n\n    if (!entry.separator) {\n      (0,dist_index_esm/* attr */.Lj)(control, 'data-action', id);\n\n      if (entry.title) {\n        (0,dist_index_esm/* attr */.Lj)(control, 'title', entry.title);\n      }\n\n      if (entry.className) {\n        addClasses(control, entry.className);\n      }\n\n      if (entry.imageUrl) {\n        var image = (0,dist_index_esm/* domify */.H6)('<img>');\n        (0,dist_index_esm/* attr */.Lj)(image, 'src', entry.imageUrl);\n\n        control.appendChild(image);\n      }\n    }\n  });\n\n  // open after update\n  this.open();\n};\n\n\n/**\n * Trigger an action available on the palette\n *\n * @param {string} action\n * @param {Event} event\n * @param {boolean} [autoActivate=false]\n */\nPalette.prototype.trigger = function(action, event, autoActivate) {\n  var entry,\n      originalEvent,\n      button = event.delegateTarget || event.target;\n\n  if (!button) {\n    return event.preventDefault();\n  }\n\n  entry = (0,dist_index_esm/* attr */.Lj)(button, 'data-action');\n  originalEvent = event.originalEvent || event;\n\n  return this.triggerEntry(entry, action, originalEvent, autoActivate);\n};\n\n/**\n * @param {string} entryId\n * @param {string} action\n * @param {Event} event\n * @param {boolean} [autoActivate=false]\n */\nPalette.prototype.triggerEntry = function(entryId, action, event, autoActivate) {\n  var entries = this._entries,\n      entry,\n      handler;\n\n  entry = entries[entryId];\n\n  // when user clicks on the palette and not on an action\n  if (!entry) {\n    return;\n  }\n\n  handler = entry.action;\n\n  if (this._eventBus.fire('palette.trigger', { entry, event }) === false) {\n    return;\n  }\n\n  // simple action (via callback function)\n  if ((0,index_esm/* isFunction */.mf)(handler)) {\n    if (action === 'click') {\n      return handler(event, autoActivate);\n    }\n  } else {\n    if (handler[action]) {\n      return handler[action](event, autoActivate);\n    }\n  }\n\n  // silence other actions\n  event.preventDefault();\n};\n\nPalette.prototype._layoutChanged = function() {\n  this._toggleState({});\n};\n\n/**\n * Do we need to collapse to two columns?\n *\n * @param {number} availableHeight\n * @param {PaletteEntries} entries\n *\n * @return {boolean}\n */\nPalette.prototype._needsCollapse = function(availableHeight, entries) {\n\n  // top margin + bottom toggle + bottom margin\n  // implementors must override this method if they\n  // change the palette styles\n  var margin = 20 + 10 + 20;\n\n  var entriesHeight = Object.keys(entries).length * 46;\n\n  return availableHeight < entriesHeight + margin;\n};\n\n/**\n * Close the palette.\n */\nPalette.prototype.close = function() {\n  this._toggleState({\n    open: false,\n    twoColumn: false\n  });\n};\n\n/**\n * Open the palette.\n */\nPalette.prototype.open = function() {\n  this._toggleState({ open: true });\n};\n\n/**\n * Toggle the palette.\n */\nPalette.prototype.toggle = function() {\n  if (this.isOpen()) {\n    this.close();\n  } else {\n    this.open();\n  }\n};\n\n/**\n * @param {string} tool\n *\n * @return {boolean}\n */\nPalette.prototype.isActiveTool = function(tool) {\n  return tool && this._activeTool === tool;\n};\n\n/**\n * @param {string} name\n */\nPalette.prototype.updateToolHighlight = function(name) {\n  var entriesContainer,\n      toolsContainer;\n\n  if (!this._toolsContainer) {\n    entriesContainer = (0,dist_index_esm/* query */.IO)('.djs-palette-entries', this._container);\n\n    this._toolsContainer = (0,dist_index_esm/* query */.IO)('[data-group=tools]', entriesContainer);\n  }\n\n  toolsContainer = this._toolsContainer;\n\n  (0,index_esm/* forEach */.Ed)(toolsContainer.children, function(tool) {\n    var actionName = tool.getAttribute('data-action');\n\n    if (!actionName) {\n      return;\n    }\n\n    var toolClasses = (0,dist_index_esm/* classes */.Sh)(tool);\n\n    actionName = actionName.replace('-tool', '');\n\n    if (toolClasses.contains('entry') && actionName === name) {\n      toolClasses.add('highlighted-entry');\n    } else {\n      toolClasses.remove('highlighted-entry');\n    }\n  });\n};\n\n\n/**\n * Return `true` if the palette is opened.\n *\n * @example\n *\n * ```javascript\n * palette.open();\n *\n * if (palette.isOpen()) {\n *   // yes, we are open\n * }\n * ```\n *\n * @return {boolean}\n */\nPalette.prototype.isOpen = function() {\n  return (0,dist_index_esm/* classes */.Sh)(this._container).has(PALETTE_OPEN_CLS);\n};\n\n/**\n * Get parent element of palette.\n *\n * @return {HTMLElement}\n */\nPalette.prototype._getParentContainer = function() {\n  return this._canvas.getContainer();\n};\n\n\n/* markup definition */\n\nPalette.HTML_MARKUP =\n  '<div class=\"djs-palette\">' +\n    '<div class=\"djs-palette-entries\"></div>' +\n    '<div class=\"djs-palette-toggle\"></div>' +\n  '</div>';\n\n\n// helpers //////////////////////\n\nfunction addClasses(element, classNames) {\n\n  var classes = (0,dist_index_esm/* classes */.Sh)(element);\n\n  var actualClassNames = (0,index_esm/* isArray */.kJ)(classNames) ? classNames : classNames.split(/\\s+/g);\n  actualClassNames.forEach(function(cls) {\n    classes.add(cls);\n  });\n}\n\nfunction addPaletteEntries(entries, provider) {\n\n  var entriesOrUpdater = provider.getPaletteEntries();\n\n  if ((0,index_esm/* isFunction */.mf)(entriesOrUpdater)) {\n    return entriesOrUpdater(entries);\n  }\n\n  (0,index_esm/* forEach */.Ed)(entriesOrUpdater, function(entry, id) {\n    entries[id] = entry;\n  });\n\n  return entries;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/palette/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const palette = ({\n  __init__: [ 'palette' ],\n  palette: [ 'type', Palette ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/palette/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/popup-menu/PopupMenuItem.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ PopupMenuItem)\n/* harmony export */ });\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/clsx/dist/clsx.m.js");\n}\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var _ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/htm/preact/index.module.js");\n}\n\n\n\n\n/**\n * @typedef {import(\'./PopupMenuProvider\').PopupMenuEntry} PopupMenuEntry\n */\n\n/**\n * Component that renders a popup menu entry.\n *\n * @param {Object} props\n * @param {string} props.key\n * @param {PopupMenuEntry} props.entry\n * @param {boolean} props.selected\n * @param {(event: MouseEvent) => void} props.onMouseEnter\n * @param {(event: MouseEvent) => void} props.onMouseLeave\n * @param {(event: MouseEvent, entry?: PopupMenuEntry, action?: string) => void} props.onAction\n */\nfunction PopupMenuItem(props) {\n  const {\n    entry,\n    selected,\n    onMouseEnter,\n    onMouseLeave,\n    onAction\n  } = props;\n\n  return _ui__WEBPACK_IMPORTED_MODULE_0__/* .html */ .dy`\n    <li\n      class=${ (0,clsx__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(\'entry\', { selected }) }\n      data-id=${ entry.id }\n      title=${ entry.title || entry.label }\n      onClick=${ onAction }\n      onMouseEnter=${ onMouseEnter }\n      onMouseLeave=${ onMouseLeave }\n      onDragStart=${ (event) => onAction(event, entry, \'dragstart\') }\n      draggable=${ true }\n    >\n      <div class="djs-popup-entry-content">\n        <span\n          class=${ (0,clsx__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(\'djs-popup-entry-name\', entry.className) }\n        >\n          ${ entry.imageUrl ? _ui__WEBPACK_IMPORTED_MODULE_0__/* .html */ .dy`\n            <img class="djs-popup-entry-icon" src=${ entry.imageUrl } alt="" />\n          ` : null }\n\n          ${ entry.label ? _ui__WEBPACK_IMPORTED_MODULE_0__/* .html */ .dy`\n            <span class="djs-popup-label">\n              ${ entry.label }\n            </span>\n          ` : null }\n        </span>\n        ${ entry.description && _ui__WEBPACK_IMPORTED_MODULE_0__/* .html */ .dy`\n          <span\n            class="djs-popup-entry-description"\n            title=${ entry.description }\n          >\n            ${ entry.description }\n          </span>\n        ` }\n      </div>\n      ${ entry.documentationRef && _ui__WEBPACK_IMPORTED_MODULE_0__/* .html */ .dy`\n        <div class="djs-popup-entry-docs">\n          <a\n            href="${ entry.documentationRef }"\n            onClick=${ (event) => event.stopPropagation() }\n            title="Open element documentation"\n            target="_blank"\n            rel="noopener"\n          >\n            <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">\n              <path fill-rule="evenodd" clip-rule="evenodd" d="M10.6368 10.6375V5.91761H11.9995V10.6382C11.9995 10.9973 11.8623 11.3141 11.5878 11.5885C11.3134 11.863 10.9966 12.0002 10.6375 12.0002H1.36266C0.982345 12.0002 0.660159 11.8681 0.396102 11.6041C0.132044 11.34 1.52588e-05 11.0178 1.52588e-05 10.6375V1.36267C1.52588e-05 0.98236 0.132044 0.660173 0.396102 0.396116C0.660159 0.132058 0.982345 2.95639e-05 1.36266 2.95639e-05H5.91624V1.36267H1.36266V10.6375H10.6368ZM12 0H7.2794L7.27873 1.36197H9.68701L3.06507 7.98391L4.01541 8.93425L10.6373 2.31231V4.72059H12V0Z" fill="#818798"/>\n            </svg>\n          </a>\n        </div>\n      ` }\n    </li>\n  `;\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/popup-menu/PopupMenuItem.js?')},"./node_modules/diagram-js/lib/features/popup-menu/PopupMenuList.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ PopupMenuList)\n/* harmony export */ });\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var _ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/preact/hooks/dist/hooks.module.js");\n}\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var _ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/htm/preact/index.module.js");\n}\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var _PopupMenuItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./node_modules/diagram-js/lib/features/popup-menu/PopupMenuItem.js");\n}\n\n\n\n\n/**\n * @typedef {import(\'./PopupMenuProvider\').PopupMenuEntry} PopupMenuEntry\n */\n\n/**\n * Component that renders a popup menu entry list.\n *\n * @param {Object} props\n * @param {PopupMenuEntry[]} props.entries\n * @param {PopupMenuEntry} props.selectedEntry\n * @param {(entry: PopupMenuEntry | null) => void} props.setSelectedEntry\n */\nfunction PopupMenuList(props) {\n  const {\n    selectedEntry,\n    setSelectedEntry,\n    entries,\n    ...restProps\n  } = props;\n\n  const resultsRef = (0,_ui__WEBPACK_IMPORTED_MODULE_0__/* .useRef */ .sO)();\n\n  const groups = (0,_ui__WEBPACK_IMPORTED_MODULE_0__/* .useMemo */ .Ye)(() => groupEntries(entries), [ entries ]);\n\n  // scroll to selected result\n  (0,_ui__WEBPACK_IMPORTED_MODULE_0__/* .useLayoutEffect */ .bt)(() => {\n    const containerEl = resultsRef.current;\n\n    if (!containerEl)\n      return;\n\n    const selectedEl = containerEl.querySelector(\'.selected\');\n\n    if (selectedEl) {\n      scrollIntoView(selectedEl);\n    }\n  }, [ selectedEntry ]);\n\n  return _ui__WEBPACK_IMPORTED_MODULE_1__/* .html */ .dy`\n    <div class="djs-popup-results" ref=${ resultsRef }>\n      ${ groups.map(group => _ui__WEBPACK_IMPORTED_MODULE_1__/* .html */ .dy`\n        ${ group.name && _ui__WEBPACK_IMPORTED_MODULE_1__/* .html */ .dy`\n          <div key=${ group.id } class="entry-header" title=${ group.name }>\n            ${ group.name }\n          </div>\n        ` }\n        <ul class="djs-popup-group" data-group=${ group.id }>\n          ${ group.entries.map(entry => _ui__WEBPACK_IMPORTED_MODULE_1__/* .html */ .dy`\n            <${_PopupMenuItem__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z}\n              key=${ entry.id }\n              entry=${ entry }\n              selected=${ entry === selectedEntry }\n              onMouseEnter=${ () => setSelectedEntry(entry) }\n              onMouseLeave=${ () => setSelectedEntry(null) }\n              ...${ restProps }\n            />\n          `) }\n        </ul>\n      `) }\n    </div>\n  `;\n}\n\n\n// helpers\nfunction groupEntries(entries) {\n  const groups = [];\n\n  const getGroup = group => groups.find(elem => group.id === elem.id);\n\n  const containsGroup = group => !!getGroup(group);\n\n  // legacy support for provider built for the old popUp menu\n  const formatGroup = group =>\n    typeof group === \'string\' ? { id: group } : group;\n\n  entries.forEach(entry => {\n\n    // assume a default group when none is provided\n    const group = entry.group ? formatGroup(entry.group) : { id: \'default\' };\n\n    if (!containsGroup(group)) {\n      groups.push({ ...group, entries: [ entry ] });\n    } else {\n      getGroup(group).entries.push(entry);\n    }\n  });\n\n  return groups;\n}\n\n// helpers ////////////////\n\nfunction scrollIntoView(el) {\n  if (typeof el.scrollIntoViewIfNeeded === \'function\') {\n    el.scrollIntoViewIfNeeded();\n  } else {\n    el.scrollIntoView({\n      scrollMode: \'if-needed\',\n      block: \'nearest\'\n    });\n  }\n}\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/popup-menu/PopupMenuList.js?')},"./node_modules/diagram-js/lib/features/popup-menu/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ popup_menu)\n});\n\n// EXTERNAL MODULE: ./node_modules/preact/dist/preact.module.js\nvar preact_module = __webpack_require__(\"./node_modules/preact/dist/preact.module.js\");\n// EXTERNAL MODULE: ./node_modules/htm/preact/index.module.js + 1 modules\nvar index_module = __webpack_require__(\"./node_modules/htm/preact/index.module.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/preact/hooks/dist/hooks.module.js\nvar hooks_module = __webpack_require__(\"./node_modules/preact/hooks/dist/hooks.module.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/popup-menu/PopupMenuList.js\nvar PopupMenuList = __webpack_require__(\"./node_modules/diagram-js/lib/features/popup-menu/PopupMenuList.js\");\n// EXTERNAL MODULE: ./node_modules/clsx/dist/clsx.m.js\nvar clsx_m = __webpack_require__(\"./node_modules/clsx/dist/clsx.m.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/popup-menu/PopupMenuComponent.js\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('./PopupMenuProvider').PopupMenuEntry} PopupMenuEntry\n * @typedef {import('./PopupMenuProvider').PopupMenuHeaderEntry} PopupMenuHeaderEntry\n *\n * @typedef {import('../../util/Types').Point} Point\n */\n\n/**\n * A component that renders the popup menus.\n *\n * @param {Object} props\n * @param {() => void} props.onClose\n * @param {(element: HTMLElement) => Point} props.position\n * @param {string} props.className\n * @param {PopupMenuEntry[]} props.entries\n * @param {PopupMenuHeaderEntry[]} props.headerEntries\n * @param {number} props.scale\n * @param {string} [props.title]\n * @param {boolean} [props.search]\n * @param {number} [props.width]\n */\nfunction PopupMenuComponent(props) {\n  const {\n    onClose,\n    onSelect,\n    className,\n    headerEntries,\n    position,\n    title,\n    width,\n    scale,\n    search,\n    entries: originalEntries,\n    onOpened,\n    onClosed\n  } = props;\n\n  const searchable = (0,hooks_module/* useMemo */.Ye)(() => {\n    if (!(0,dist_index_esm/* isDefined */.$K)(search)) {\n      return false;\n    }\n\n    return originalEntries.length > 5;\n  }, [ search, originalEntries ]);\n\n  const inputRef = (0,hooks_module/* useRef */.sO)();\n\n  const [ value, setValue ] = (0,hooks_module/* useState */.eJ)('');\n\n  const filterEntries = (0,hooks_module/* useCallback */.I4)((originalEntries, value) => {\n\n    if (!searchable) {\n      return originalEntries;\n    }\n\n    const filter = entry => {\n      if (!value) {\n        return (entry.rank || 0) >= 0;\n      }\n\n      const search = [\n        entry.description || '',\n        entry.label || '',\n        entry.search || ''\n      ]\n        .join('---')\n        .toLowerCase();\n\n      return value\n        .toLowerCase()\n        .split(/\\s/g)\n        .every(term => search.includes(term));\n    };\n\n    return originalEntries.filter(filter);\n  }, [ searchable ]);\n\n  const [ entries, setEntries ] = (0,hooks_module/* useState */.eJ)(filterEntries(originalEntries, value));\n  const [ selectedEntry, setSelectedEntry ] = (0,hooks_module/* useState */.eJ)(entries[0]);\n\n  const updateEntries = (0,hooks_module/* useCallback */.I4)((newEntries) => {\n\n    // select first entry if non is selected\n    if (!selectedEntry || !newEntries.includes(selectedEntry)) {\n      setSelectedEntry(newEntries[0]);\n    }\n\n    setEntries(newEntries);\n  }, [ selectedEntry, setEntries, setSelectedEntry ]);\n\n  // filter entries on value change\n  (0,hooks_module/* useEffect */.d4)(() => {\n    updateEntries(filterEntries(originalEntries, value));\n  }, [ value, originalEntries ]);\n\n  // register global <Escape> handler\n  (0,hooks_module/* useEffect */.d4)(() => {\n    const handleKeyDown = event => {\n      if (event.key === 'Escape') {\n        event.preventDefault();\n\n        return onClose();\n      }\n    };\n\n    document.documentElement.addEventListener('keydown', handleKeyDown);\n\n    return () => {\n      document.documentElement.removeEventListener('keydown', handleKeyDown);\n    };\n  }, []);\n\n  // focus input on initial mount\n  (0,hooks_module/* useLayoutEffect */.bt)(() => {\n    inputRef.current && inputRef.current.focus();\n  }, []);\n\n  // handle keyboard seleciton\n  const keyboardSelect = (0,hooks_module/* useCallback */.I4)(direction => {\n    const idx = entries.indexOf(selectedEntry);\n\n    let nextIdx = idx + direction;\n\n    if (nextIdx < 0) {\n      nextIdx = entries.length - 1;\n    }\n\n    if (nextIdx >= entries.length) {\n      nextIdx = 0;\n    }\n\n    setSelectedEntry(entries[nextIdx]);\n  }, [ entries, selectedEntry, setSelectedEntry ]);\n\n  const handleKeyDown = (0,hooks_module/* useCallback */.I4)(event => {\n    if (event.key === 'Enter' && selectedEntry) {\n      return onSelect(event, selectedEntry);\n    }\n\n    // ARROW_UP or SHIFT + TAB navigation\n    if (event.key === 'ArrowUp' || (event.key === 'Tab' && event.shiftKey)) {\n      keyboardSelect(-1);\n\n      return event.preventDefault();\n    }\n\n    // ARROW_DOWN or TAB navigation\n    if (event.key === 'ArrowDown' || event.key === 'Tab') {\n      keyboardSelect(1);\n\n      return event.preventDefault();\n    }\n  }, [ onSelect, onClose, selectedEntry, keyboardSelect ]);\n\n  const handleKey = (0,hooks_module/* useCallback */.I4)(event => {\n    if ((0,index_esm/* matches */.wB)(event.target, 'input')) {\n      setValue(() => event.target.value);\n    }\n  }, [ setValue ]);\n\n  (0,hooks_module/* useEffect */.d4)(() => {\n    onOpened();\n\n    return () => {\n      onClosed();\n    };\n  }, []);\n\n  const displayHeader = (0,hooks_module/* useMemo */.Ye)(() => title || headerEntries.length > 0, [ title, headerEntries ]);\n\n  return index_module/* html */.dy`\n    <${PopupMenuWrapper}\n      onClose=${ onClose }\n      onKeyup=${ handleKey }\n      onKeydown=${ handleKeyDown }\n      className=${ className }\n      position=${position}\n      width=${ width }\n      scale=${ scale }\n    >\n      ${ displayHeader && index_module/* html */.dy`\n        <div class=\"djs-popup-header\">\n          <h3 class=\"djs-popup-title\" title=${ title }>${ title }</h3>\n          ${ headerEntries.map(entry => index_module/* html */.dy`\n            <span\n              class=${ getHeaderClasses(entry, entry === selectedEntry) }\n              onClick=${ event => onSelect(event, entry) }\n              title=${ entry.title || entry.label }\n              data-id=${ entry.id }\n              onMouseEnter=${ () => setSelectedEntry(entry) }\n              onMouseLeave=${ () => setSelectedEntry(null) }\n            >\n              ${ entry.imageUrl ? index_module/* html */.dy`\n                <img class=\"djs-popup-entry-icon\" src=${ entry.imageUrl } alt=\"\" />\n              ` : null }\n\n              ${ entry.label ? index_module/* html */.dy`\n                <span class=\"djs-popup-label\">${ entry.label }</span>\n              ` : null }\n            </span>\n          `) }\n        </div>\n      ` }\n      ${ originalEntries.length > 0 && index_module/* html */.dy`\n        <div class=\"djs-popup-body\">\n\n          ${ searchable && index_module/* html */.dy`\n          <div class=\"djs-popup-search\">\n            <svg class=\"djs-popup-search-icon\" width=\"14\" height=\"14\" viewBox=\"0 0 14 14\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n              <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M9.0325 8.5H9.625L13.3675 12.25L12.25 13.3675L8.5 9.625V9.0325L8.2975 8.8225C7.4425 9.5575 6.3325 10 5.125 10C2.4325 10 0.25 7.8175 0.25 5.125C0.25 2.4325 2.4325 0.25 5.125 0.25C7.8175 0.25 10 2.4325 10 5.125C10 6.3325 9.5575 7.4425 8.8225 8.2975L9.0325 8.5ZM1.75 5.125C1.75 6.9925 3.2575 8.5 5.125 8.5C6.9925 8.5 8.5 6.9925 8.5 5.125C8.5 3.2575 6.9925 1.75 5.125 1.75C3.2575 1.75 1.75 3.2575 1.75 5.125Z\" fill=\"#22242A\"/>\n            </svg>\n            <input\n                ref=${ inputRef }\n                type=\"text\"\n              />\n          </div>\n          ` }\n\n          <${PopupMenuList/* default */.Z}\n            entries=${ entries }\n            selectedEntry=${ selectedEntry }\n            setSelectedEntry=${ setSelectedEntry }\n            onAction=${ onSelect }\n          />\n        </div>\n        ${ entries.length === 0 && index_module/* html */.dy`\n          <div class=\"djs-popup-no-results\">No matching entries found.</div>\n        ` }\n      ` }\n    </${PopupMenuWrapper}>\n  `;\n}\n\n/**\n * A component that wraps the popup menu.\n *\n * @param {*} props\n */\nfunction PopupMenuWrapper(props) {\n  const {\n    onClose,\n    onKeydown,\n    onKeyup,\n    className,\n    children,\n    position: positionGetter\n  } = props;\n\n  const popupRef = (0,hooks_module/* useRef */.sO)();\n\n  const checkClose = (0,hooks_module/* useCallback */.I4)((event) => {\n\n    const popup = (0,index_esm/* closest */.oq)(event.target, '.djs-popup', true);\n\n    if (popup) {\n      return;\n    }\n\n    onClose();\n  }, [ onClose ]);\n\n  (0,hooks_module/* useLayoutEffect */.bt)(() => {\n    if (typeof positionGetter !== 'function') {\n      return;\n    }\n\n    const popupEl = popupRef.current;\n    const position = positionGetter(popupEl);\n\n    popupEl.style.left = `${position.x}px`;\n    popupEl.style.top = `${position.y}px`;\n  }, [ popupRef.current, positionGetter ]);\n\n  // focus popup initially, on mount\n  (0,hooks_module/* useLayoutEffect */.bt)(() => {\n    popupRef.current && popupRef.current.focus();\n  }, []);\n\n  return index_module/* html */.dy`\n    <div\n      class=\"djs-popup-backdrop\"\n      onClick=${ checkClose }\n    >\n      <div\n        class=${ (0,clsx_m/* default */.Z)('djs-popup', className) }\n        style=${ getPopupStyle(props) }\n        onKeydown=${ onKeydown }\n        onKeyup=${ onKeyup }\n        ref=${ popupRef }\n        tabIndex=\"-1\"\n      >\n        ${children}\n      </div>\n    </div>\n  `;\n}\n\n// helpers //////////////////////\n\nfunction getPopupStyle(props) {\n  return {\n    transform: `scale(${props.scale})`,\n    width: `${props.width}px`\n  };\n}\n\nfunction getHeaderClasses(entry, selected) {\n  return (0,clsx_m/* default */.Z)(\n    'entry',\n    entry.className,\n    entry.active ? 'active' : '',\n    entry.disabled ? 'disabled' : '',\n    selected ? 'selected' : ''\n  );\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/popup-menu/PopupMenu.js\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n *\n * @typedef {import('../../util/Types').Point} Point\n *\n * @typedef {import('./PopupMenuProvider').PopupMenuEntries} PopupMenuEntries\n * @typedef {import('./PopupMenuProvider').PopupMenuEntry} PopupMenuEntry\n * @typedef {import('./PopupMenuProvider').PopupMenuHeaderEntries} PopupMenuHeaderEntries\n * @typedef {import('./PopupMenuProvider').PopupMenuHeaderEntry} PopupMenuHeaderEntry\n * @typedef {import('./PopupMenuProvider').default} PopupMenuProvider\n *\n * @typedef {import('../../model/Types').Element} Element\n *\n * @typedef { {\n *   scale?: {\n *     min?: number;\n *     max?: number;\n *   } | boolean;\n * } } PopupMenuConfig\n *\n * @typedef {Element|Element[]} PopupMenuTarget;\n */\n\nvar DATA_REF = 'data-id';\n\nvar CLOSE_EVENTS = [\n  'contextPad.close',\n  'canvas.viewbox.changing',\n  'commandStack.changed'\n];\n\nvar DEFAULT_PRIORITY = 1000;\n\n/**\n * A popup menu to show a number of actions on the canvas.\n *\n * @param {PopupMenuConfig} config\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n */\nfunction PopupMenu(config, eventBus, canvas) {\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n\n  this._current = null;\n\n  var scale = (0,dist_index_esm/* isDefined */.$K)(config && config.scale) ? config.scale : {\n    min: 1,\n    max: 1.5\n  };\n\n  this._config = {\n    scale: scale\n  };\n\n\n  eventBus.on('diagram.destroy', () => {\n    this.close();\n  });\n\n  eventBus.on('element.changed', event => {\n\n    const element = this.isOpen() && this._current.target;\n\n    if (event.element === element) {\n      this._render();\n    }\n  });\n\n}\n\nPopupMenu.$inject = [\n  'config.popupMenu',\n  'eventBus',\n  'canvas'\n];\n\nPopupMenu.prototype._render = function() {\n\n  const {\n    position: _position,\n    className,\n    entries,\n    headerEntries,\n    options\n  } = this._current;\n\n  const entriesArray = Object.entries(entries).map(\n    ([ key, value ]) => ({ id: key, ...value })\n  );\n\n  const headerEntriesArray = Object.entries(headerEntries).map(\n    ([ key, value ]) => ({ id: key, ...value })\n  );\n\n  const position = _position && (\n    (container) => this._ensureVisible(container, _position)\n  );\n\n  const scale = this._updateScale(this._current.container);\n\n  const onClose = result => this.close(result);\n  const onSelect = (event, entry, action) => this.trigger(event, entry, action);\n\n  (0,preact_module/* render */.sY)(\n    index_module/* html */.dy`\n      <${PopupMenuComponent}\n        onClose=${ onClose }\n        onSelect=${ onSelect }\n        position=${ position }\n        className=${ className }\n        entries=${ entriesArray }\n        headerEntries=${ headerEntriesArray }\n        scale=${ scale }\n        onOpened=${ this._onOpened.bind(this) }\n        onClosed=${ this._onClosed.bind(this) }\n        ...${{ ...options }}\n      />\n    `,\n    this._current.container\n  );\n};\n\n\n/**\n * Open the popup menu at the given position.\n *\n * @param {PopupMenuTarget} target\n * @param {string} providerId\n * @param {Point} position\n * @param {Object} [options]\n */\nPopupMenu.prototype.open = function(target, providerId, position, options) {\n  if (!target) {\n    throw new Error('target is missing');\n  }\n\n  if (!providerId) {\n    throw new Error('providers for <' + providerId + '> not found');\n  }\n\n  if (!position) {\n    throw new Error('position is missing');\n  }\n\n  if (this.isOpen()) {\n    this.close();\n  }\n\n  const {\n    entries,\n    headerEntries\n  } = this._getContext(target, providerId);\n\n  this._current = {\n    position,\n    className: providerId,\n    target,\n    entries,\n    headerEntries,\n    container: this._createContainer({ provider: providerId }),\n    options\n  };\n\n  this._emit('open');\n\n  this._bindAutoClose();\n\n  this._render();\n};\n\n\nPopupMenu.prototype._getContext = function(target, provider) {\n\n  const providers = this._getProviders(provider);\n\n  if (!providers || !providers.length) {\n    throw new Error('provider for <' + provider + '> not found');\n  }\n\n  const entries = this._getEntries(target, providers);\n\n  const headerEntries = this._getHeaderEntries(target, providers);\n\n  return {\n    entries,\n    headerEntries,\n    empty: !(\n      Object.keys(entries).length ||\n          Object.keys(headerEntries).length\n    )\n  };\n};\n\nPopupMenu.prototype.close = function() {\n\n  if (!this.isOpen()) {\n    return;\n  }\n\n  this._emit('close');\n\n  this.reset();\n\n  this._current = null;\n};\n\nPopupMenu.prototype.reset = function() {\n  const container = this._current.container;\n\n  (0,preact_module/* render */.sY)(null, container);\n\n  (0,index_esm/* remove */.Od)(container);\n};\n\nPopupMenu.prototype._emit = function(event, payload) {\n  this._eventBus.fire(`popupMenu.${ event }`, payload);\n};\n\nPopupMenu.prototype._onOpened = function() {\n  this._emit('opened');\n};\n\nPopupMenu.prototype._onClosed = function() {\n  this._emit('closed');\n};\n\nPopupMenu.prototype._createContainer = function(config) {\n\n  var canvas = this._canvas,\n      parent = canvas.getContainer();\n\n  const container = (0,index_esm/* domify */.H6)(`<div class=\"djs-popup-parent djs-scrollable\" data-popup=${config.provider}></div>`);\n\n  parent.appendChild(container);\n\n  return container;\n};\n\n/**\n * Set up listener to close popup automatically on certain events.\n */\nPopupMenu.prototype._bindAutoClose = function() {\n  this._eventBus.once(CLOSE_EVENTS, this.close, this);\n};\n\n\n/**\n * Remove the auto-closing listener.\n*/\nPopupMenu.prototype._unbindAutoClose = function() {\n  this._eventBus.off(CLOSE_EVENTS, this.close, this);\n};\n\n\n/**\n * Updates popup style.transform with respect to the config and zoom level.\n *\n * @return {number}\n */\nPopupMenu.prototype._updateScale = function() {\n  var zoom = this._canvas.zoom();\n\n  var scaleConfig = this._config.scale,\n      minScale,\n      maxScale,\n      scale = zoom;\n\n  if (scaleConfig !== true) {\n\n    if (scaleConfig === false) {\n      minScale = 1;\n      maxScale = 1;\n    } else {\n      minScale = scaleConfig.min;\n      maxScale = scaleConfig.max;\n    }\n\n    if ((0,dist_index_esm/* isDefined */.$K)(minScale) && zoom < minScale) {\n      scale = minScale;\n    }\n\n    if ((0,dist_index_esm/* isDefined */.$K)(maxScale) && zoom > maxScale) {\n      scale = maxScale;\n    }\n\n  }\n\n  return scale;\n};\n\nPopupMenu.prototype._ensureVisible = function(container, position) {\n  var documentBounds = document.documentElement.getBoundingClientRect();\n  var containerBounds = container.getBoundingClientRect();\n\n  var overAxis = {},\n      left = position.x,\n      top = position.y;\n\n  if (position.x + containerBounds.width > documentBounds.width) {\n    overAxis.x = true;\n  }\n\n  if (position.y + containerBounds.height > documentBounds.height) {\n    overAxis.y = true;\n  }\n\n  if (overAxis.x && overAxis.y) {\n    left = position.x - containerBounds.width;\n    top = position.y - containerBounds.height;\n  } else if (overAxis.x) {\n    left = position.x - containerBounds.width;\n    top = position.y;\n  } else if (overAxis.y && position.y < containerBounds.height) {\n    left = position.x;\n    top = 10;\n  } else if (overAxis.y) {\n    left = position.x;\n    top = position.y - containerBounds.height;\n  }\n\n  return {\n    x: left,\n    y: top\n  };\n};\n\n/**\n * Check whether there are no popup menu providers or provided entries for the\n * given target.\n *\n * @param {PopupMenuTarget} target\n * @param {string} providerId\n *\n * @return {boolean}\n */\nPopupMenu.prototype.isEmpty = function(target, providerId) {\n  if (!target) {\n    throw new Error('target is missing');\n  }\n\n  if (!providerId) {\n    throw new Error('provider ID is missing');\n  }\n\n  const providers = this._getProviders(providerId);\n\n  if (!providers || !providers.length) {\n    return true;\n  }\n\n  return this._getContext(target, providerId).empty;\n};\n\n/**\n * @overlord\n *\n * Register a popup menu provider with default priority. See\n * {@link PopupMenuProvider} for examples.\n *\n * @param {string} id\n * @param {PopupMenuProvider} provider\n */\n\n/**\n * Register a popup menu provider with the given priority. See\n * {@link PopupMenuProvider} for examples.\n *\n * @param {string} id\n * @param {number} priority\n * @param {PopupMenuProvider} provider\n */\nPopupMenu.prototype.registerProvider = function(id, priority, provider) {\n  if (!provider) {\n    provider = priority;\n    priority = DEFAULT_PRIORITY;\n  }\n\n  this._eventBus.on('popupMenu.getProviders.' + id, priority, function(event) {\n    event.providers.push(provider);\n  });\n};\n\n/**\n * @param {string} id\n *\n * @return {PopupMenuProvider[]}\n */\nPopupMenu.prototype._getProviders = function(id) {\n  var event = this._eventBus.createEvent({\n    type: 'popupMenu.getProviders.' + id,\n    providers: []\n  });\n\n  this._eventBus.fire(event);\n\n  return event.providers;\n};\n\n/**\n * @param {PopupMenuTarget} target\n * @param {PopupMenuProvider[]} providers\n *\n * @return {PopupMenuEntries}\n */\nPopupMenu.prototype._getEntries = function(target, providers) {\n  var entries = {};\n\n  (0,dist_index_esm/* forEach */.Ed)(providers, function(provider) {\n\n    // handle legacy method\n    if (!provider.getPopupMenuEntries) {\n      (0,dist_index_esm/* forEach */.Ed)(provider.getEntries(target), function(entry) {\n        var id = entry.id;\n\n        if (!id) {\n          throw new Error('entry ID is missing');\n        }\n\n        entries[id] = (0,dist_index_esm/* omit */.CE)(entry, [ 'id' ]);\n      });\n\n      return;\n    }\n\n    var entriesOrUpdater = provider.getPopupMenuEntries(target);\n\n    if ((0,dist_index_esm/* isFunction */.mf)(entriesOrUpdater)) {\n      entries = entriesOrUpdater(entries);\n    } else {\n      (0,dist_index_esm/* forEach */.Ed)(entriesOrUpdater, function(entry, id) {\n        entries[id] = entry;\n      });\n    }\n  });\n\n  return entries;\n};\n\n/**\n * @param {PopupMenuTarget} target\n * @param {PopupMenuProvider[]} providers\n *\n * @return {PopupMenuHeaderEntries}\n */\nPopupMenu.prototype._getHeaderEntries = function(target, providers) {\n  var entries = {};\n\n  (0,dist_index_esm/* forEach */.Ed)(providers, function(provider) {\n\n    // handle legacy method\n    if (!provider.getPopupMenuHeaderEntries) {\n      if (!provider.getHeaderEntries) {\n        return;\n      }\n\n      (0,dist_index_esm/* forEach */.Ed)(provider.getHeaderEntries(target), function(entry) {\n        var id = entry.id;\n\n        if (!id) {\n          throw new Error('entry ID is missing');\n        }\n\n        entries[id] = (0,dist_index_esm/* omit */.CE)(entry, [ 'id' ]);\n      });\n\n      return;\n    }\n\n    var entriesOrUpdater = provider.getPopupMenuHeaderEntries(target);\n\n    if ((0,dist_index_esm/* isFunction */.mf)(entriesOrUpdater)) {\n      entries = entriesOrUpdater(entries);\n    } else {\n      (0,dist_index_esm/* forEach */.Ed)(entriesOrUpdater, function(entry, id) {\n        entries[id] = entry;\n      });\n    }\n  });\n\n  return entries;\n};\n\n\n/**\n * Check if the popup menu is open.\n *\n * @return {boolean}\n */\nPopupMenu.prototype.isOpen = function() {\n  return !!this._current;\n};\n\n\n/**\n * Trigger an action associated with an entry.\n *\n * @param {Event} event\n * @param {PopupMenuEntry} entry\n * @param {string} [action='click']\n *\n * @return {any}\n */\nPopupMenu.prototype.trigger = function(event, entry, action = 'click') {\n\n  // silence other actions\n  event.preventDefault();\n\n  if (!entry) {\n    let element = (0,index_esm/* closest */.oq)(event.delegateTarget || event.target, '.entry', true);\n    let entryId = (0,index_esm/* attr */.Lj)(element, DATA_REF);\n\n    entry = { id: entryId, ...this._getEntry(entryId) };\n  }\n\n  const handler = entry.action;\n\n  if (this._emit('trigger', { entry, event }) === false) {\n    return;\n  }\n\n  if ((0,dist_index_esm/* isFunction */.mf)(handler)) {\n    if (action === 'click') {\n      return handler(event, entry);\n    }\n  } else {\n    if (handler[action]) {\n      return handler[action](event, entry);\n    }\n  }\n};\n\n/**\n * Get the entry (entry or header entry) with the given ID.\n *\n * @param {string} entryId\n *\n * @return {PopupMenuEntry|PopupMenuHeaderEntry}\n */\nPopupMenu.prototype._getEntry = function(entryId) {\n\n  var entry = this._current.entries[ entryId ] || this._current.headerEntries[ entryId ];\n\n\n  if (!entry) {\n    throw new Error('entry not found');\n  }\n\n  return entry;\n};\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/popup-menu/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const popup_menu = ({\n  __init__: [ 'popupMenu' ],\n  popupMenu: [ 'type', PopupMenu ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/popup-menu/index.js_+_2_modules?")},"./node_modules/diagram-js/lib/features/preview-support/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ preview_support)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar min_dom_dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/GraphicsUtil.js\nvar GraphicsUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/GraphicsUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/preview-support/PreviewSupport.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n/**\r\n * @typedef {import('../../core/Types').ElementLike} Element\r\n * @typedef {import('../../core/Types').ShapeLike} Shape\r\n *\r\n * @typedef {import('../../core/Canvas').default} Canvas\r\n * @typedef {import('../../core/ElementRegistry').default} ElementRegistry\r\n * @typedef {import('../../core/EventBus').default} EventBus\r\n * @typedef {import('../../draw/Styles').default} Styles\r\n */\r\n\r\nvar MARKER_TYPES = [\r\n  'marker-start',\r\n  'marker-mid',\r\n  'marker-end'\r\n];\r\n\r\nvar NODES_CAN_HAVE_MARKER = [\r\n  'circle',\r\n  'ellipse',\r\n  'line',\r\n  'path',\r\n  'polygon',\r\n  'polyline',\r\n  'path',\r\n  'rect'\r\n];\r\n\r\n\r\n/**\r\n * Adds support for previews of moving/resizing elements.\r\n *\r\n * @param {ElementRegistry} elementRegistry\r\n * @param {EventBus} eventBus\r\n * @param {Canvas} canvas\r\n * @param {Styles} styles\r\n */\r\nfunction PreviewSupport(elementRegistry, eventBus, canvas, styles) {\r\n  this._elementRegistry = elementRegistry;\r\n  this._canvas = canvas;\r\n  this._styles = styles;\r\n\r\n  this._clonedMarkers = {};\r\n\r\n  var self = this;\r\n\r\n  eventBus.on('drag.cleanup', function() {\r\n    (0,index_esm/* forEach */.Ed)(self._clonedMarkers, function(clonedMarker) {\r\n      (0,dist_index_esm/* remove */.Od)(clonedMarker);\r\n    });\r\n\r\n    self._clonedMarkers = {};\r\n  });\r\n}\r\n\r\nPreviewSupport.$inject = [\r\n  'elementRegistry',\r\n  'eventBus',\r\n  'canvas',\r\n  'styles'\r\n];\r\n\r\n\r\n/**\r\n * Returns graphics of an element.\r\n *\r\n * @param {Element} element\r\n *\r\n * @return {SVGElement}\r\n */\r\nPreviewSupport.prototype.getGfx = function(element) {\r\n  return this._elementRegistry.getGraphics(element);\r\n};\r\n\r\n/**\r\n * Adds a move preview of a given shape to a given SVG group.\r\n *\r\n * @param {Element} element The element to be moved.\r\n * @param {SVGElement} group The SVG group to add the preview to.\r\n * @param {SVGElement} [gfx] The optional graphical element of the element.\r\n *\r\n * @return {SVGElement} The preview.\r\n */\r\nPreviewSupport.prototype.addDragger = function(element, group, gfx) {\r\n  gfx = gfx || this.getGfx(element);\r\n\r\n  var dragger = (0,dist_index_esm/* clone */.d9)(gfx);\r\n  var bbox = gfx.getBoundingClientRect();\r\n\r\n  this._cloneMarkers((0,GraphicsUtil/* getVisual */.s)(dragger));\r\n\r\n  (0,dist_index_esm/* attr */.Lj)(dragger, this._styles.cls('djs-dragger', [], {\r\n    x: bbox.top,\r\n    y: bbox.left\r\n  }));\r\n\r\n  (0,dist_index_esm/* append */.R3)(group, dragger);\r\n\r\n  return dragger;\r\n};\r\n\r\n/**\r\n * Adds a resize preview of a given shape to a given SVG group.\r\n *\r\n * @param {Shape} shape The element to be resized.\r\n * @param {SVGElement} group The SVG group to add the preview to.\r\n *\r\n * @return {SVGElement} The preview.\r\n */\r\nPreviewSupport.prototype.addFrame = function(shape, group) {\r\n\r\n  var frame = (0,dist_index_esm/* create */.Ue)('rect', {\r\n    class: 'djs-resize-overlay',\r\n    width:  shape.width,\r\n    height: shape.height,\r\n    x: shape.x,\r\n    y: shape.y\r\n  });\r\n\r\n  (0,dist_index_esm/* append */.R3)(group, frame);\r\n\r\n  return frame;\r\n};\r\n\r\n/**\r\n * Clone all markers referenced by a node and its child nodes.\r\n *\r\n * @param {SVGElement} gfx\r\n */\r\nPreviewSupport.prototype._cloneMarkers = function(gfx) {\r\n  var self = this;\r\n\r\n  if (gfx.childNodes) {\r\n\r\n    // TODO: use forEach once we drop PhantomJS\r\n    for (var i = 0; i < gfx.childNodes.length; i++) {\r\n\r\n      // recursively clone markers of child nodes\r\n      self._cloneMarkers(gfx.childNodes[ i ]);\r\n    }\r\n  }\r\n\r\n  if (!canHaveMarker(gfx)) {\r\n    return;\r\n  }\r\n\r\n  MARKER_TYPES.forEach(function(markerType) {\r\n    if ((0,dist_index_esm/* attr */.Lj)(gfx, markerType)) {\r\n      var marker = getMarker(gfx, markerType, self._canvas.getContainer());\r\n\r\n      self._cloneMarker(gfx, marker, markerType);\r\n    }\r\n  });\r\n};\r\n\r\n/**\r\n * Clone marker referenced by an element.\r\n *\r\n * @param {SVGElement} gfx\r\n * @param {SVGElement} marker\r\n * @param {string} markerType\r\n */\r\nPreviewSupport.prototype._cloneMarker = function(gfx, marker, markerType) {\r\n  var markerId = marker.id;\r\n\r\n  var clonedMarker = this._clonedMarkers[ markerId ];\r\n\r\n  if (!clonedMarker) {\r\n    clonedMarker = (0,dist_index_esm/* clone */.d9)(marker);\r\n\r\n    var clonedMarkerId = markerId + '-clone';\r\n\r\n    clonedMarker.id = clonedMarkerId;\r\n\r\n    (0,dist_index_esm/* classes */.Sh)(clonedMarker)\r\n      .add('djs-dragger')\r\n      .add('djs-dragger-marker');\r\n\r\n    this._clonedMarkers[ markerId ] = clonedMarker;\r\n\r\n    var defs = (0,min_dom_dist_index_esm/* query */.IO)('defs', this._canvas._svg);\r\n\r\n    if (!defs) {\r\n      defs = (0,dist_index_esm/* create */.Ue)('defs');\r\n\r\n      (0,dist_index_esm/* append */.R3)(this._canvas._svg, defs);\r\n    }\r\n\r\n    (0,dist_index_esm/* append */.R3)(defs, clonedMarker);\r\n  }\r\n\r\n  var reference = idToReference(this._clonedMarkers[ markerId ].id);\r\n\r\n  (0,dist_index_esm/* attr */.Lj)(gfx, markerType, reference);\r\n};\r\n\r\n// helpers //////////\r\n\r\n/**\r\n * Get marker of given type referenced by node.\r\n *\r\n * @param {HTMLElement} node\r\n * @param {string} markerType\r\n * @param {HTMLElement} [parentNode]\r\n *\r\n * @param {HTMLElement}\r\n */\r\nfunction getMarker(node, markerType, parentNode) {\r\n  var id = referenceToId((0,dist_index_esm/* attr */.Lj)(node, markerType));\r\n\r\n  return (0,min_dom_dist_index_esm/* query */.IO)('marker#' + id, parentNode || document);\r\n}\r\n\r\n/**\r\n * Get ID of fragment within current document from its functional IRI reference.\r\n * References may use single or double quotes.\r\n *\r\n * @param {string} reference\r\n *\r\n * @return {string}\r\n */\r\nfunction referenceToId(reference) {\r\n  return reference.match(/url\\(['\"]?#([^'\"]*)['\"]?\\)/)[1];\r\n}\r\n\r\n/**\r\n * Get functional IRI reference for given ID of fragment within current document.\r\n *\r\n * @param {string} id\r\n *\r\n * @return {string}\r\n */\r\nfunction idToReference(id) {\r\n  return 'url(#' + id + ')';\r\n}\r\n\r\n/**\r\n * Check wether node type can have marker attributes.\r\n *\r\n * @param {HTMLElement} node\r\n *\r\n * @return {boolean}\r\n */\r\nfunction canHaveMarker(node) {\r\n  return NODES_CAN_HAVE_MARKER.indexOf(node.nodeName) !== -1;\r\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/preview-support/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const preview_support = ({\n  __init__: [ 'previewSupport' ],\n  previewSupport: [ 'type', PreviewSupport ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/preview-support/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/replace/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ replace)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/replace/Replace.js\n\n\n/**\n * @typedef {import('diagram-js/lib/core/EventBus').default} EventBus\n * @typedef {import('../modeling/Modeling').default} Modeling\n *\n * @typedef {import('../../core/Types').ShapeLike} Shape\n */\n\nvar round = Math.round;\n\n/**\n * Service that allows replacing of elements.\n *\n * @param {Modeling} modeling\n * @param {EventBus} eventBus\n */\nfunction Replace(modeling, eventBus) {\n  this._modeling = modeling;\n  this._eventBus = eventBus;\n}\n\nReplace.$inject = [ 'modeling', 'eventBus' ];\n\n/**\n * Replace an element.\n *\n * @param {Shape} oldElement The element to be replaced.\n * @param {Object} attrs Containing information about the new element, for\n * example the new bounds and type.\n * @param {Object} hints Custom hints that will be attached to the context. It\n * can be used to inject data that is needed in the command chain. For example\n * it could be used in eventbus.on('commandStack.shape.replace.postExecute') to\n * change shape attributes after shape creation.\n *\n * @return {Shape}\n */\nReplace.prototype.replaceElement = function(oldElement, attrs, hints) {\n\n  if (oldElement.waypoints) {\n\n    // TODO(nikku): we do not replace connections, yet\n    return null;\n  }\n\n  var modeling = this._modeling;\n  var eventBus = this._eventBus;\n\n  eventBus.fire('replace.start', {\n    element: oldElement,\n    attrs,\n    hints\n  });\n\n  var width = attrs.width || oldElement.width,\n      height = attrs.height || oldElement.height,\n      x = attrs.x || oldElement.x,\n      y = attrs.y || oldElement.y,\n      centerX = round(x + width / 2),\n      centerY = round(y + height / 2);\n\n  // modeling API requires center coordinates,\n  // account for that when handling shape bounds\n\n  var newElement = modeling.replaceShape(\n    oldElement,\n    (0,index_esm/* assign */.f0)(\n      {},\n      attrs,\n      {\n        x: centerX,\n        y: centerY,\n        width: width,\n        height: height\n      }\n    ),\n    hints\n  );\n\n  eventBus.fire('replace.end', {\n    element: oldElement,\n    newElement,\n    hints\n  });\n\n  return newElement;\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/replace/ReplaceSelectionBehavior.js\nfunction ReplaceSelectionBehavior(selection, eventBus) {\n\n  eventBus.on('replace.end', 500, function(event) {\n    const {\n      newElement,\n      hints = {}\n    } = event;\n\n    if (hints.select === false) {\n      return;\n    }\n\n    selection.select(newElement);\n  });\n\n}\n\nReplaceSelectionBehavior.$inject = [ 'selection', 'eventBus' ];\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/replace/index.js\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const replace = ({\n  __init__: [ 'replace', 'replaceSelectionBehavior' ],\n  replaceSelectionBehavior: [ 'type', ReplaceSelectionBehavior ],\n  replace: [ 'type', Replace ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/replace/index.js_+_2_modules?")},"./node_modules/diagram-js/lib/features/resize/ResizeUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"QG\": () => (/* binding */ ensureConstraints),\n/* harmony export */   \"_P\": () => (/* binding */ substractTRBL),\n/* harmony export */   \"dR\": () => (/* binding */ resizeTRBL),\n/* harmony export */   \"gE\": () => (/* binding */ computeChildrenBBox),\n/* harmony export */   \"oN\": () => (/* binding */ getMinResizeBounds),\n/* harmony export */   \"zY\": () => (/* binding */ resizeBounds)\n/* harmony export */ });\n/* unused harmony exports reattachPoint, addPadding */\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n}\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var _util_Elements__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n}\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var _layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n}\n\n\nvar max = Math.max,\n    min = Math.min;\n\nvar DEFAULT_CHILD_BOX_PADDING = 20;\n\n\n\n\n\n/**\n * @typedef {import('../../core/Types').ElementLike} Element\n * @typedef {import('../../core/Types').ShapeLike} Shape\n *\n * @typedef {import('../../util/Types').Direction} Direction\n * @typedef {import('../../util/Types').Point} Point\n * @typedef {import('../../util/Types').Rect} Rect\n * @typedef {import('../../util/Types').RectTRBL} RectTRBL\n */\n\n/**\n * Substract a TRBL from another\n *\n * @param {RectTRBL} trblA\n * @param {RectTRBL} trblB\n *\n * @return {RectTRBL}\n */\nfunction substractTRBL(trblA, trblB) {\n  return {\n    top: trblA.top - trblB.top,\n    right: trblA.right - trblB.right,\n    bottom: trblA.bottom - trblB.bottom,\n    left: trblA.left - trblB.left\n  };\n}\n\n/**\n * Resize the given bounds by the specified delta from a given anchor point.\n *\n * @param {Rect} bounds the bounding box that should be resized\n * @param {Direction} direction in which the element is resized (nw, ne, se, sw)\n * @param {Point} delta of the resize operation\n *\n * @return {Rect} resized bounding box\n */\nfunction resizeBounds(bounds, direction, delta) {\n  var dx = delta.x,\n      dy = delta.y;\n\n  var newBounds = {\n    x: bounds.x,\n    y: bounds.y,\n    width: bounds.width,\n    height: bounds.height\n  };\n\n  if (direction.indexOf('n') !== -1) {\n    newBounds.y = bounds.y + dy;\n    newBounds.height = bounds.height - dy;\n  } else if (direction.indexOf('s') !== -1) {\n    newBounds.height = bounds.height + dy;\n  }\n\n  if (direction.indexOf('e') !== -1) {\n    newBounds.width = bounds.width + dx;\n  } else if (direction.indexOf('w') !== -1) {\n    newBounds.x = bounds.x + dx;\n    newBounds.width = bounds.width - dx;\n  }\n\n  return newBounds;\n}\n\n\n/**\n * Resize the given bounds by applying the passed\n * { top, right, bottom, left } delta.\n *\n * @param {Rect} bounds\n * @param {RectTRBL} resize\n *\n * @return {Rect}\n */\nfunction resizeTRBL(bounds, resize) {\n  return {\n    x: bounds.x + (resize.left || 0),\n    y: bounds.y + (resize.top || 0),\n    width: bounds.width - (resize.left || 0) + (resize.right || 0),\n    height: bounds.height - (resize.top || 0) + (resize.bottom || 0)\n  };\n}\n\n\nfunction reattachPoint(bounds, newBounds, point) {\n\n  var sx = bounds.width / newBounds.width,\n      sy = bounds.height / newBounds.height;\n\n  return {\n    x: Math.round((newBounds.x + newBounds.width / 2)) - Math.floor(((bounds.x + bounds.width / 2) - point.x) / sx),\n    y: Math.round((newBounds.y + newBounds.height / 2)) - Math.floor(((bounds.y + bounds.height / 2) - point.y) / sy)\n  };\n}\n\n\nfunction applyConstraints(attr, trbl, resizeConstraints) {\n\n  var value = trbl[attr],\n      minValue = resizeConstraints.min && resizeConstraints.min[attr],\n      maxValue = resizeConstraints.max && resizeConstraints.max[attr];\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(minValue)) {\n    value = (/top|left/.test(attr) ? min : max)(value, minValue);\n  }\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(maxValue)) {\n    value = (/top|left/.test(attr) ? max : min)(value, maxValue);\n  }\n\n  return value;\n}\n\nfunction ensureConstraints(currentBounds, resizeConstraints) {\n\n  if (!resizeConstraints) {\n    return currentBounds;\n  }\n\n  var currentTrbl = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(currentBounds);\n\n  return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asBounds */ .z_)({\n    top: applyConstraints('top', currentTrbl, resizeConstraints),\n    right: applyConstraints('right', currentTrbl, resizeConstraints),\n    bottom: applyConstraints('bottom', currentTrbl, resizeConstraints),\n    left: applyConstraints('left', currentTrbl, resizeConstraints)\n  });\n}\n\n\nfunction getMinResizeBounds(direction, currentBounds, minDimensions, childrenBounds) {\n\n  var currentBox = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(currentBounds);\n\n  var minBox = {\n    top: /n/.test(direction) ? currentBox.bottom - minDimensions.height : currentBox.top,\n    left: /w/.test(direction) ? currentBox.right - minDimensions.width : currentBox.left,\n    bottom: /s/.test(direction) ? currentBox.top + minDimensions.height : currentBox.bottom,\n    right: /e/.test(direction) ? currentBox.left + minDimensions.width : currentBox.right\n  };\n\n  var childrenBox = childrenBounds ? (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(childrenBounds) : minBox;\n\n  var combinedBox = {\n    top: min(minBox.top, childrenBox.top),\n    left: min(minBox.left, childrenBox.left),\n    bottom: max(minBox.bottom, childrenBox.bottom),\n    right: max(minBox.right, childrenBox.right)\n  };\n\n  return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asBounds */ .z_)(combinedBox);\n}\n\nfunction asPadding(mayBePadding, defaultValue) {\n  if (typeof mayBePadding !== 'undefined') {\n    return mayBePadding;\n  } else {\n    return DEFAULT_CHILD_BOX_PADDING;\n  }\n}\n\nfunction addPadding(bbox, padding) {\n  var left, right, top, bottom;\n\n  if (typeof padding === 'object') {\n    left = asPadding(padding.left);\n    right = asPadding(padding.right);\n    top = asPadding(padding.top);\n    bottom = asPadding(padding.bottom);\n  } else {\n    left = right = top = bottom = asPadding(padding);\n  }\n\n  return {\n    x: bbox.x - left,\n    y: bbox.y - top,\n    width: bbox.width + left + right,\n    height: bbox.height + top + bottom\n  };\n}\n\n\n/**\n * Is the given element part of the resize\n * targets min boundary box?\n *\n * This is the default implementation which excludes\n * connections and labels.\n *\n * @param {Element} element\n */\nfunction isBBoxChild(element) {\n\n  // exclude connections\n  if (element.waypoints) {\n    return false;\n  }\n\n  // exclude labels\n  if (element.type === 'label') {\n    return false;\n  }\n\n  return true;\n}\n\n/**\n * Return children bounding computed from a shapes children\n * or a list of prefiltered children.\n *\n * @param {Shape|Shape[]} shapeOrChildren\n * @param {RectTRBL|number} padding\n *\n * @return {Rect}\n */\nfunction computeChildrenBBox(shapeOrChildren, padding) {\n\n  var elements;\n\n  // compute based on shape\n  if (shapeOrChildren.length === undefined) {\n\n    // grab all the children that are part of the\n    // parents children box\n    elements = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .filter */ .hX)(shapeOrChildren.children, isBBoxChild);\n\n  } else {\n    elements = shapeOrChildren;\n  }\n\n  if (elements.length) {\n    return addPadding((0,_util_Elements__WEBPACK_IMPORTED_MODULE_2__/* .getBBox */ .jY)(elements), padding);\n  }\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/resize/ResizeUtil.js?")},"./node_modules/diagram-js/lib/features/resize/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ resize)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/dragging/index.js + 3 modules\nvar dragging = __webpack_require__(\"./node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/preview-support/index.js + 1 modules\nvar preview_support = __webpack_require__(\"./node_modules/diagram-js/lib/features/preview-support/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/resize/ResizeUtil.js\nvar ResizeUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/resize/ResizeUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/resize/Resize.js\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Types').ShapeLike} Shape\n *\n * @typedef {import('../../util/Types').Direction} Direction\n * @typedef {import('../../util/Types').Point} Point\n *\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../dragging/Dragging').default} Dragging\n * @typedef {import('../modeling/Modeling').default} Modeling\n * @typedef {import('../rules/Rules').default} Rules\n */\n\nvar DEFAULT_MIN_WIDTH = 10;\n\n\n/**\n * A component that provides resizing of shapes on the canvas.\n *\n * The following components are part of shape resize:\n *\n *  * adding resize handles,\n *  * creating a visual during resize\n *  * checking resize rules\n *  * committing a change once finished\n *\n *\n * ## Customizing\n *\n * It's possible to customize the resizing behaviour by intercepting 'resize.start'\n * and providing the following parameters through the 'context':\n *\n *   * minDimensions ({ width, height }): minimum shape dimensions\n *\n *   * childrenBoxPadding ({ left, top, bottom, right } || number):\n *     gap between the minimum bounding box and the container\n *\n * f.ex:\n *\n * ```javascript\n * eventBus.on('resize.start', 1500, function(event) {\n *   var context = event.context,\n *\n *  context.minDimensions = { width: 140, height: 120 };\n *\n *  // Passing general padding\n *  context.childrenBoxPadding = 30;\n *\n *  // Passing padding to a specific side\n *  context.childrenBoxPadding.left = 20;\n * });\n * ```\n *\n * @param {EventBus} eventBus\n * @param {Rules} rules\n * @param {Modeling} modeling\n * @param {Dragging} dragging\n */\nfunction Resize(eventBus, rules, modeling, dragging) {\n\n  this._dragging = dragging;\n  this._rules = rules;\n\n  var self = this;\n\n\n  /**\n   * Handle resize move by specified delta.\n   *\n   * @param {Object} context\n   * @param {Point} delta\n   */\n  function handleMove(context, delta) {\n\n    var shape = context.shape,\n        direction = context.direction,\n        resizeConstraints = context.resizeConstraints,\n        newBounds;\n\n    context.delta = delta;\n\n    newBounds = (0,ResizeUtil/* resizeBounds */.zY)(shape, direction, delta);\n\n    // ensure constraints during resize\n    context.newBounds = (0,ResizeUtil/* ensureConstraints */.QG)(newBounds, resizeConstraints);\n\n    // update + cache executable state\n    context.canExecute = self.canResize(context);\n  }\n\n  /**\n   * Handle resize start.\n   *\n   * @param {Object} context\n   */\n  function handleStart(context) {\n\n    var resizeConstraints = context.resizeConstraints,\n\n        // evaluate minBounds for backwards compatibility\n        minBounds = context.minBounds;\n\n    if (resizeConstraints !== undefined) {\n      return;\n    }\n\n    if (minBounds === undefined) {\n      minBounds = self.computeMinResizeBox(context);\n    }\n\n    context.resizeConstraints = {\n      min: (0,LayoutUtil/* asTRBL */.JA)(minBounds)\n    };\n  }\n\n  /**\n   * Handle resize end.\n   *\n   * @param {Object} context\n   */\n  function handleEnd(context) {\n    var shape = context.shape,\n        canExecute = context.canExecute,\n        newBounds = context.newBounds;\n\n    if (canExecute) {\n\n      // ensure we have actual pixel values for new bounds\n      // (important when zoom level was > 1 during move)\n      newBounds = (0,LayoutUtil/* roundBounds */.aR)(newBounds);\n\n      if (!boundsChanged(shape, newBounds)) {\n\n        // no resize necessary\n        return;\n      }\n\n      // perform the actual resize\n      modeling.resizeShape(shape, newBounds);\n    }\n  }\n\n\n  eventBus.on('resize.start', function(event) {\n    handleStart(event.context);\n  });\n\n  eventBus.on('resize.move', function(event) {\n    var delta = {\n      x: event.dx,\n      y: event.dy\n    };\n\n    handleMove(event.context, delta);\n  });\n\n  eventBus.on('resize.end', function(event) {\n    handleEnd(event.context);\n  });\n\n}\n\n\nResize.prototype.canResize = function(context) {\n  var rules = this._rules;\n\n  var ctx = (0,index_esm/* pick */.ei)(context, [ 'newBounds', 'shape', 'delta', 'direction' ]);\n\n  return rules.allowed('shape.resize', ctx);\n};\n\n/**\n * Activate a resize operation.\n *\n * You may specify additional contextual information and must specify a\n * resize direction during activation of the resize event.\n *\n * @param {MouseEvent|TouchEvent} event\n * @param {Shape} shape\n * @param {Object|Direction} contextOrDirection\n */\nResize.prototype.activate = function(event, shape, contextOrDirection) {\n  var dragging = this._dragging,\n      context,\n      direction;\n\n  if (typeof contextOrDirection === 'string') {\n    contextOrDirection = {\n      direction: contextOrDirection\n    };\n  }\n\n  context = (0,index_esm/* assign */.f0)({ shape: shape }, contextOrDirection);\n\n  direction = context.direction;\n\n  if (!direction) {\n    throw new Error('must provide a direction (n|w|s|e|nw|se|ne|sw)');\n  }\n\n  dragging.init(event, getReferencePoint(shape, direction), 'resize', {\n    autoActivate: true,\n    cursor: getCursor(direction),\n    data: {\n      shape: shape,\n      context: context\n    }\n  });\n};\n\nResize.prototype.computeMinResizeBox = function(context) {\n  var shape = context.shape,\n      direction = context.direction,\n      minDimensions,\n      childrenBounds;\n\n  minDimensions = context.minDimensions || {\n    width: DEFAULT_MIN_WIDTH,\n    height: DEFAULT_MIN_WIDTH\n  };\n\n  // get children bounds\n  childrenBounds = (0,ResizeUtil/* computeChildrenBBox */.gE)(shape, context.childrenBoxPadding);\n\n  // get correct minimum bounds from given resize direction\n  // basically ensures that the minBounds is max(childrenBounds, minDimensions)\n  return (0,ResizeUtil/* getMinResizeBounds */.oN)(direction, shape, minDimensions, childrenBounds);\n};\n\n\nResize.$inject = [\n  'eventBus',\n  'rules',\n  'modeling',\n  'dragging'\n];\n\n// helpers //////////\n\nfunction boundsChanged(shape, newBounds) {\n  return shape.x !== newBounds.x ||\n    shape.y !== newBounds.y ||\n    shape.width !== newBounds.width ||\n    shape.height !== newBounds.height;\n}\n\nfunction getReferencePoint(shape, direction) {\n  var mid = (0,LayoutUtil/* getMid */.wS)(shape),\n      trbl = (0,LayoutUtil/* asTRBL */.JA)(shape);\n\n  var referencePoint = {\n    x: mid.x,\n    y: mid.y\n  };\n\n  if (direction.indexOf('n') !== -1) {\n    referencePoint.y = trbl.top;\n  } else if (direction.indexOf('s') !== -1) {\n    referencePoint.y = trbl.bottom;\n  }\n\n  if (direction.indexOf('e') !== -1) {\n    referencePoint.x = trbl.right;\n  } else if (direction.indexOf('w') !== -1) {\n    referencePoint.x = trbl.left;\n  }\n\n  return referencePoint;\n}\n\nfunction getCursor(direction) {\n  var prefix = 'resize-';\n\n  if (direction === 'n' || direction === 's') {\n    return prefix + 'ns';\n  } else if (direction === 'e' || direction === 'w') {\n    return prefix + 'ew';\n  } else if (direction === 'nw' || direction === 'se') {\n    return prefix + 'nwse';\n  } else {\n    return prefix + 'nesw';\n  }\n}\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/resize/ResizePreview.js\nvar MARKER_RESIZING = 'djs-resizing',\n    MARKER_RESIZE_NOT_OK = 'resize-not-ok';\n\nvar LOW_PRIORITY = 500;\n\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../preview-support/PreviewSupport').default} PreviewSupport\n */\n\n/**\n * Provides previews for resizing shapes when resizing.\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {PreviewSupport} previewSupport\n */\nfunction ResizePreview(eventBus, canvas, previewSupport) {\n\n  /**\n   * Update resizer frame.\n   *\n   * @param {Object} context\n   */\n  function updateFrame(context) {\n\n    var shape = context.shape,\n        bounds = context.newBounds,\n        frame = context.frame;\n\n    if (!frame) {\n      frame = context.frame = previewSupport.addFrame(shape, canvas.getActiveLayer());\n\n      canvas.addMarker(shape, MARKER_RESIZING);\n    }\n\n    if (bounds.width > 5) {\n      (0,dist_index_esm/* attr */.Lj)(frame, { x: bounds.x, width: bounds.width });\n    }\n\n    if (bounds.height > 5) {\n      (0,dist_index_esm/* attr */.Lj)(frame, { y: bounds.y, height: bounds.height });\n    }\n\n    if (context.canExecute) {\n      (0,dist_index_esm/* classes */.Sh)(frame).remove(MARKER_RESIZE_NOT_OK);\n    } else {\n      (0,dist_index_esm/* classes */.Sh)(frame).add(MARKER_RESIZE_NOT_OK);\n    }\n  }\n\n  /**\n   * Remove resizer frame.\n   *\n   * @param {Object} context\n   */\n  function removeFrame(context) {\n    var shape = context.shape,\n        frame = context.frame;\n\n    if (frame) {\n      (0,dist_index_esm/* remove */.Od)(context.frame);\n    }\n\n    canvas.removeMarker(shape, MARKER_RESIZING);\n  }\n\n  // add and update previews\n  eventBus.on('resize.move', LOW_PRIORITY, function(event) {\n    updateFrame(event.context);\n  });\n\n  // remove previews\n  eventBus.on('resize.cleanup', function(event) {\n    removeFrame(event.context);\n  });\n\n}\n\nResizePreview.$inject = [\n  'eventBus',\n  'canvas',\n  'previewSupport'\n];\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar min_dom_dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Mouse.js\nvar Mouse = __webpack_require__(\"./node_modules/diagram-js/lib/util/Mouse.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/SvgTransformUtil.js\nvar SvgTransformUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/SvgTransformUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/ModelUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/resize/ResizeHandles.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../model/Types').Element} Element\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../resize/Resize').default} Resize\n * @typedef {import('../selection/Selection').default} Selection\n */\n\nvar HANDLE_OFFSET = -6,\n    HANDLE_SIZE = 8,\n    HANDLE_HIT_SIZE = 20;\n\nvar CLS_RESIZER = 'djs-resizer';\n\nvar directions = [ 'n', 'w', 's', 'e', 'nw', 'ne', 'se', 'sw' ];\n\n\n/**\n * This component is responsible for adding resize handles.\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {Selection} selection\n * @param {Resize} resize\n */\nfunction ResizeHandles(eventBus, canvas, selection, resize) {\n\n  this._resize = resize;\n  this._canvas = canvas;\n\n  var self = this;\n\n  eventBus.on('selection.changed', function(e) {\n    var newSelection = e.newSelection;\n\n    // remove old selection markers\n    self.removeResizers();\n\n    // add new selection markers ONLY if single selection\n    if (newSelection.length === 1) {\n      (0,index_esm/* forEach */.Ed)(newSelection, (0,index_esm/* bind */.ak)(self.addResizer, self));\n    }\n  });\n\n  eventBus.on('shape.changed', function(e) {\n    var shape = e.element;\n\n    if (selection.isSelected(shape)) {\n      self.removeResizers();\n\n      self.addResizer(shape);\n    }\n  });\n}\n\n\nResizeHandles.prototype.makeDraggable = function(element, gfx, direction) {\n  var resize = this._resize;\n\n  function startResize(event) {\n\n    // only trigger on left mouse button\n    if ((0,Mouse/* isPrimaryButton */.Id)(event)) {\n      resize.activate(event, element, direction);\n    }\n  }\n\n  min_dom_dist_index_esm/* event.bind */.B.bind(gfx, 'mousedown', startResize);\n  min_dom_dist_index_esm/* event.bind */.B.bind(gfx, 'touchstart', startResize);\n};\n\n\nResizeHandles.prototype._createResizer = function(element, x, y, direction) {\n  var resizersParent = this._getResizersParent();\n\n  var offset = getHandleOffset(direction);\n\n  var group = (0,dist_index_esm/* create */.Ue)('g');\n\n  (0,dist_index_esm/* classes */.Sh)(group).add(CLS_RESIZER);\n  (0,dist_index_esm/* classes */.Sh)(group).add(CLS_RESIZER + '-' + element.id);\n  (0,dist_index_esm/* classes */.Sh)(group).add(CLS_RESIZER + '-' + direction);\n\n  (0,dist_index_esm/* append */.R3)(resizersParent, group);\n\n  var visual = (0,dist_index_esm/* create */.Ue)('rect');\n\n  (0,dist_index_esm/* attr */.Lj)(visual, {\n    x: -HANDLE_SIZE / 2 + offset.x,\n    y: -HANDLE_SIZE / 2 + offset.y,\n    width: HANDLE_SIZE,\n    height: HANDLE_SIZE\n  });\n\n  (0,dist_index_esm/* classes */.Sh)(visual).add(CLS_RESIZER + '-visual');\n\n  (0,dist_index_esm/* append */.R3)(group, visual);\n\n  var hit = (0,dist_index_esm/* create */.Ue)('rect');\n\n  (0,dist_index_esm/* attr */.Lj)(hit, {\n    x: -HANDLE_HIT_SIZE / 2 + offset.x,\n    y: -HANDLE_HIT_SIZE / 2 + offset.y,\n    width: HANDLE_HIT_SIZE,\n    height: HANDLE_HIT_SIZE\n  });\n\n  (0,dist_index_esm/* classes */.Sh)(hit).add(CLS_RESIZER + '-hit');\n\n  (0,dist_index_esm/* append */.R3)(group, hit);\n\n  (0,SvgTransformUtil/* transform */.vs)(group, x, y);\n\n  return group;\n};\n\nResizeHandles.prototype.createResizer = function(element, direction) {\n  var point = getReferencePoint(element, direction);\n\n  var resizer = this._createResizer(element, point.x, point.y, direction);\n\n  this.makeDraggable(element, resizer, direction);\n};\n\n// resize handles implementation ///////////////////////////////\n\n/**\n * Add resizers for a given element.\n *\n * @param {Element} element\n */\nResizeHandles.prototype.addResizer = function(element) {\n  var self = this;\n\n  if ((0,ModelUtil/* isConnection */.Ho)(element) || !this._resize.canResize({ shape: element })) {\n    return;\n  }\n\n  (0,index_esm/* forEach */.Ed)(directions, function(direction) {\n    self.createResizer(element, direction);\n  });\n};\n\n/**\n * Remove all resizers\n */\nResizeHandles.prototype.removeResizers = function() {\n  var resizersParent = this._getResizersParent();\n\n  (0,dist_index_esm/* clear */.ZH)(resizersParent);\n};\n\nResizeHandles.prototype._getResizersParent = function() {\n  return this._canvas.getLayer('resizers');\n};\n\nResizeHandles.$inject = [\n  'eventBus',\n  'canvas',\n  'selection',\n  'resize'\n];\n\n// helpers //////////\n\nfunction getHandleOffset(direction) {\n  var offset = {\n    x: 0,\n    y: 0\n  };\n\n  if (direction.indexOf('e') !== -1) {\n    offset.x = -HANDLE_OFFSET;\n  } else if (direction.indexOf('w') !== -1) {\n    offset.x = HANDLE_OFFSET;\n  }\n\n  if (direction.indexOf('s') !== -1) {\n    offset.y = -HANDLE_OFFSET;\n  } else if (direction.indexOf('n') !== -1) {\n    offset.y = HANDLE_OFFSET;\n  }\n\n  return offset;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/resize/index.js\n\n\n\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const resize = ({\n  __depends__: [\n    rules/* default */.Z,\n    dragging/* default */.Z,\n    preview_support/* default */.Z\n  ],\n  __init__: [\n    'resize',\n    'resizePreview',\n    'resizeHandles'\n  ],\n  resize: [ 'type', Resize ],\n  resizePreview: [ 'type', ResizePreview ],\n  resizeHandles: [ 'type', ResizeHandles ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/resize/index.js_+_3_modules?")},"./node_modules/diagram-js/lib/features/root-elements/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ root_elements)\n});\n\n// EXTERNAL MODULE: ./node_modules/inherits-browser/dist/index.es.js\nvar index_es = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/command/CommandInterceptor.js\nvar CommandInterceptor = __webpack_require__(\"./node_modules/diagram-js/lib/command/CommandInterceptor.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/root-elements/RootElementsBehavior.js\n\n\n\n\n/**\n * @typedef {import('didi').Injector} Injector\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n */\n\n/**\n * A modeling behavior that ensures we set the correct root element\n * as we undo and redo commands.\n *\n * @param {Canvas} canvas\n * @param {Injector} injector\n */\nfunction RootElementsBehavior(canvas, injector) {\n\n  injector.invoke(CommandInterceptor/* default */.Z, this);\n\n  this.executed(function(event) {\n    var context = event.context;\n\n    if (context.rootElement) {\n      canvas.setRootElement(context.rootElement);\n    } else {\n      context.rootElement = canvas.getRootElement();\n    }\n  });\n\n  this.revert(function(event) {\n    var context = event.context;\n\n    if (context.rootElement) {\n      canvas.setRootElement(context.rootElement);\n    }\n  });\n}\n\n(0,index_es/* default */.Z)(RootElementsBehavior, CommandInterceptor/* default */.Z);\n\nRootElementsBehavior.$inject = [ 'canvas', 'injector' ];\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/root-elements/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const root_elements = ({\n  __init__: [ 'rootElementsBehavior' ],\n  rootElementsBehavior: [ 'type', RootElementsBehavior ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/root-elements/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/rules/RuleProvider.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ RuleProvider)\n/* harmony export */ });\n/* harmony import */ var inherits_browser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/inherits-browser/dist/index.es.js");\n/* harmony import */ var _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/diagram-js/lib/command/CommandInterceptor.js");\n\n\n\n\n/**\n * @typedef {import(\'../../core/EventBus\').default} EventBus\n */\n\n/**\n * A basic provider that may be extended to implement modeling rules.\n *\n * Extensions should implement the init method to actually add their custom\n * modeling checks. Checks may be added via the #addRule(action, fn) method.\n *\n * @class\n *\n * @param {EventBus} eventBus\n */\nfunction RuleProvider(eventBus) {\n  _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_0__/* ["default"].call */ .Z.call(this, eventBus);\n\n  this.init();\n}\n\nRuleProvider.$inject = [ \'eventBus\' ];\n\n(0,inherits_browser__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(RuleProvider, _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z);\n\n\n/**\n * Adds a modeling rule for the given action, implemented through\n * a callback function.\n *\n * The callback receives a modeling specific action context\n * to perform its check. It must return `false` to disallow the\n * action from happening or `true` to allow the action. Usually returing\n * `null` denotes that a particular interaction shall be ignored.\n * By returning nothing or `undefined` you pass evaluation to lower\n * priority rules.\n *\n * @example\n *\n * ```javascript\n * ResizableRules.prototype.init = function() {\n *\n *   \\/**\n *    * Return `true`, `false` or nothing to denote\n *    * _allowed_, _not allowed_ and _continue evaluating_.\n *    *\\/\n *   this.addRule(\'shape.resize\', function(context) {\n *\n *     var shape = context.shape;\n *\n *     if (!context.newBounds) {\n *       // check general resizability\n *       if (!shape.resizable) {\n *         return false;\n *       }\n *\n *       // not returning anything (read: undefined)\n *       // will continue the evaluation of other rules\n *       // (with lower priority)\n *       return;\n *     } else {\n *       // element must have minimum size of 10*10 points\n *       return context.newBounds.width > 10 && context.newBounds.height > 10;\n *     }\n *   });\n * };\n * ```\n *\n * @param {string|string[]} actions the identifier for the modeling action to check\n * @param {number} [priority] the priority at which this rule is being applied\n * @param {(any) => any} fn the callback function that performs the actual check\n */\nRuleProvider.prototype.addRule = function(actions, priority, fn) {\n\n  var self = this;\n\n  if (typeof actions === \'string\') {\n    actions = [ actions ];\n  }\n\n  actions.forEach(function(action) {\n\n    self.canExecute(action, priority, function(context, action, event) {\n      return fn(context);\n    }, true);\n  });\n};\n\n/**\n * Implement this method to add new rules during provider initialization.\n */\nRuleProvider.prototype.init = function() {};\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/rules/RuleProvider.js?')},"./node_modules/diagram-js/lib/features/rules/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ rules)\n});\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/rules/Rules.js\n/**\n * @typedef {import('didi').Injector} Injector\n */\n\n/**\n * A service that provides rules for certain diagram actions.\n *\n * The default implementation will hook into the {@link CommandStack}\n * to perform the actual rule evaluation. Make sure to provide the\n * `commandStack` service with this module if you plan to use it.\n *\n * Together with this implementation you may use the {@link import('./RuleProvider').default}\n * to implement your own rule checkers.\n *\n * This module is ment to be easily replaced, thus the tiny foot print.\n *\n * @param {Injector} injector\n */\nfunction Rules(injector) {\n  this._commandStack = injector.get('commandStack', false);\n}\n\nRules.$inject = [ 'injector' ];\n\n\n/**\n * Returns whether or not a given modeling action can be executed\n * in the specified context.\n *\n * This implementation will respond with allow unless anyone\n * objects.\n *\n * @param {string} action The action to be allowed or disallowed.\n * @param {Object} [context] The context for allowing or disallowing the action.\n *\n * @return {boolean|null} Wether the action is allowed. Returns `null` if the action\n * is to be ignored.\n */\nRules.prototype.allowed = function(action, context) {\n  var allowed = true;\n\n  var commandStack = this._commandStack;\n\n  if (commandStack) {\n    allowed = commandStack.canExecute(action, context);\n  }\n\n  // map undefined to true, i.e. no rules\n  return allowed === undefined ? true : allowed;\n};\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/rules/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const rules = ({\n  __init__: [ 'rules' ],\n  rules: [ 'type', Rules ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/rules/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/search-pad/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ search_pad)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/overlays/index.js + 1 modules\nvar overlays = __webpack_require__(\"./node_modules/diagram-js/lib/features/overlays/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/EscapeUtil.js\nvar EscapeUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/EscapeUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\nvar KeyboardUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/search-pad/SearchPad.js\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../overlays/Overlays').default} Overlays\n * @typedef {import('../selection/Selection').default} Selection\n *\n * @typedef {import('../overlays/Overlays').OverlayAttrs} OverlayAttrs\n *\n * @typedef {import('../../util/Types').Dimensions} Dimensions\n *\n * @typedef {import('./SearchPadProvider').default} SearchPadProvider\n * @typedef {import('./SearchPadProvider').SearchResult} SearchResult\n * @typedef {import('./SearchPadProvider').Token} Token\n */\n\n/**\n * Provides searching infrastructure.\n *\n * @param {Canvas} canvas\n * @param {EventBus} eventBus\n * @param {Overlays} overlays\n * @param {Selection} selection\n */\nfunction SearchPad(canvas, eventBus, overlays, selection) {\n  this._open = false;\n  this._results = [];\n  this._eventMaps = [];\n\n  this._canvas = canvas;\n  this._eventBus = eventBus;\n  this._overlays = overlays;\n  this._selection = selection;\n\n  // setup elements\n  this._container = (0,index_esm/* domify */.H6)(SearchPad.BOX_HTML);\n  this._searchInput = (0,index_esm/* query */.IO)(SearchPad.INPUT_SELECTOR, this._container);\n  this._resultsContainer = (0,index_esm/* query */.IO)(SearchPad.RESULTS_CONTAINER_SELECTOR, this._container);\n\n  // attach search pad\n  this._canvas.getContainer().appendChild(this._container);\n\n  // cleanup on destroy\n  eventBus.on([ 'canvas.destroy', 'diagram.destroy' ], this.close, this);\n}\n\n\nSearchPad.$inject = [\n  'canvas',\n  'eventBus',\n  'overlays',\n  'selection'\n];\n\n\n/**\n * Binds and keeps track of all event listereners\n */\nSearchPad.prototype._bindEvents = function() {\n  var self = this;\n\n  function listen(el, selector, type, fn) {\n    self._eventMaps.push({\n      el: el,\n      type: type,\n      listener: index_esm/* delegate.bind */.cl.bind(el, selector, type, fn)\n    });\n  }\n\n  // close search on clicking anywhere outside\n  listen(document, 'html', 'click', function(e) {\n    self.close();\n  });\n\n  // stop event from propagating and closing search\n  // focus on input\n  listen(this._container, SearchPad.INPUT_SELECTOR, 'click', function(e) {\n    e.stopPropagation();\n    e.delegateTarget.focus();\n  });\n\n  // preselect result on hover\n  listen(this._container, SearchPad.RESULT_SELECTOR, 'mouseover', function(e) {\n    e.stopPropagation();\n    self._scrollToNode(e.delegateTarget);\n    self._preselect(e.delegateTarget);\n  });\n\n  // selects desired result on mouse click\n  listen(this._container, SearchPad.RESULT_SELECTOR, 'click', function(e) {\n    e.stopPropagation();\n    self._select(e.delegateTarget);\n  });\n\n  // prevent cursor in input from going left and right when using up/down to\n  // navigate results\n  listen(this._container, SearchPad.INPUT_SELECTOR, 'keydown', function(e) {\n\n    if ((0,KeyboardUtil/* isKey */.ot)('ArrowUp', e)) {\n      e.preventDefault();\n    }\n\n    if ((0,KeyboardUtil/* isKey */.ot)('ArrowDown', e)) {\n      e.preventDefault();\n    }\n  });\n\n  // handle keyboard input\n  listen(this._container, SearchPad.INPUT_SELECTOR, 'keyup', function(e) {\n\n    if ((0,KeyboardUtil/* isKey */.ot)('Escape', e)) {\n      return self.close();\n    }\n\n    if ((0,KeyboardUtil/* isKey */.ot)('Enter', e)) {\n      var selected = self._getCurrentResult();\n\n      return selected ? self._select(selected) : self.close();\n    }\n\n    if ((0,KeyboardUtil/* isKey */.ot)('ArrowUp', e)) {\n      return self._scrollToDirection(true);\n    }\n\n    if ((0,KeyboardUtil/* isKey */.ot)('ArrowDown', e)) {\n      return self._scrollToDirection();\n    }\n\n    // do not search while navigating text input\n    if ((0,KeyboardUtil/* isKey */.ot)([ 'ArrowLeft', 'ArrowRight' ], e)) {\n      return;\n    }\n\n    // anything else\n    self._search(e.delegateTarget.value);\n  });\n};\n\n\n/**\n * Unbinds all previously established listeners\n */\nSearchPad.prototype._unbindEvents = function() {\n  this._eventMaps.forEach(function(m) {\n    index_esm/* delegate.unbind */.cl.unbind(m.el, m.type, m.listener);\n  });\n};\n\n\n/**\n * Performs a search for the given pattern.\n *\n * @param {string} pattern\n */\nSearchPad.prototype._search = function(pattern) {\n  var self = this;\n\n  this._clearResults();\n\n  // do not search on empty query\n  if (!pattern || pattern === '') {\n    return;\n  }\n\n  var searchResults = this._searchProvider.find(pattern);\n\n  if (!searchResults.length) {\n    return;\n  }\n\n  // append new results\n  searchResults.forEach(function(result) {\n    var id = result.element.id;\n    var node = self._createResultNode(result, id);\n    self._results[id] = {\n      element: result.element,\n      node: node\n    };\n  });\n\n  // preselect first result\n  var node = (0,index_esm/* query */.IO)(SearchPad.RESULT_SELECTOR, this._resultsContainer);\n  this._scrollToNode(node);\n  this._preselect(node);\n};\n\n\n/**\n * Navigate to the previous/next result. Defaults to next result.\n *\n * @param {boolean} previous\n */\nSearchPad.prototype._scrollToDirection = function(previous) {\n  var selected = this._getCurrentResult();\n  if (!selected) {\n    return;\n  }\n\n  var node = previous ? selected.previousElementSibling : selected.nextElementSibling;\n  if (node) {\n    this._scrollToNode(node);\n    this._preselect(node);\n  }\n};\n\n\n/**\n * Scroll to the node if it is not visible.\n *\n * @param {HTMLElement} node\n */\nSearchPad.prototype._scrollToNode = function(node) {\n  if (!node || node === this._getCurrentResult()) {\n    return;\n  }\n\n  var nodeOffset = node.offsetTop;\n  var containerScroll = this._resultsContainer.scrollTop;\n\n  var bottomScroll = nodeOffset - this._resultsContainer.clientHeight + node.clientHeight;\n\n  if (nodeOffset < containerScroll) {\n    this._resultsContainer.scrollTop = nodeOffset;\n  } else if (containerScroll < bottomScroll) {\n    this._resultsContainer.scrollTop = bottomScroll;\n  }\n};\n\n\n/**\n * Clears all results data.\n */\nSearchPad.prototype._clearResults = function() {\n  (0,index_esm/* clear */.ZH)(this._resultsContainer);\n\n  this._results = [];\n\n  this._resetOverlay();\n\n  this._eventBus.fire('searchPad.cleared');\n};\n\n\n/**\n * Get currently selected result.\n *\n * @return {HTMLElement}\n */\nSearchPad.prototype._getCurrentResult = function() {\n  return (0,index_esm/* query */.IO)(SearchPad.RESULT_SELECTED_SELECTOR, this._resultsContainer);\n};\n\n\n/**\n * Create result DOM element within results container\n * that corresponds to a search result.\n *\n * 'result' : one of the elements returned by Pad\n * 'id' : id attribute value to assign to the new DOM node\n * return : created DOM element\n *\n * @param {SearchResult} result\n * @param {string} id\n *\n * @return {HTMLElement}\n */\nSearchPad.prototype._createResultNode = function(result, id) {\n  var node = (0,index_esm/* domify */.H6)(SearchPad.RESULT_HTML);\n\n  // create only if available\n  if (result.primaryTokens.length > 0) {\n    createInnerTextNode(node, result.primaryTokens, SearchPad.RESULT_PRIMARY_HTML);\n  }\n\n  // secondary tokens (represent element ID) are allways available\n  createInnerTextNode(node, result.secondaryTokens, SearchPad.RESULT_SECONDARY_HTML);\n\n  (0,index_esm/* attr */.Lj)(node, SearchPad.RESULT_ID_ATTRIBUTE, id);\n\n  this._resultsContainer.appendChild(node);\n\n  return node;\n};\n\n\n/**\n * Register search element provider.\n *\n * @param {SearchPadProvider} provider\n */\nSearchPad.prototype.registerProvider = function(provider) {\n  this._searchProvider = provider;\n};\n\n\n/**\n * Open search pad.\n */\nSearchPad.prototype.open = function() {\n  if (!this._searchProvider) {\n    throw new Error('no search provider registered');\n  }\n\n  if (this.isOpen()) {\n    return;\n  }\n\n  this._bindEvents();\n\n  this._open = true;\n\n  (0,index_esm/* classes */.Sh)(this._container).add('open');\n\n  this._searchInput.focus();\n\n  this._eventBus.fire('searchPad.opened');\n};\n\n\n/**\n * Close search pad.\n */\nSearchPad.prototype.close = function() {\n  if (!this.isOpen()) {\n    return;\n  }\n\n  this._unbindEvents();\n\n  this._open = false;\n\n  (0,index_esm/* classes */.Sh)(this._container).remove('open');\n\n  this._clearResults();\n\n  this._searchInput.value = '';\n  this._searchInput.blur();\n\n  this._resetOverlay();\n\n  this._eventBus.fire('searchPad.closed');\n};\n\n\n/**\n * Toggles search pad on/off.\n */\nSearchPad.prototype.toggle = function() {\n  this.isOpen() ? this.close() : this.open();\n};\n\n\n/**\n * Report state of search pad.\n */\nSearchPad.prototype.isOpen = function() {\n  return this._open;\n};\n\n\n/**\n * Preselect result entry.\n *\n * @param {HTMLElement} element\n */\nSearchPad.prototype._preselect = function(node) {\n  var selectedNode = this._getCurrentResult();\n\n  // already selected\n  if (node === selectedNode) {\n    return;\n  }\n\n  // removing preselection from current node\n  if (selectedNode) {\n    (0,index_esm/* classes */.Sh)(selectedNode).remove(SearchPad.RESULT_SELECTED_CLASS);\n  }\n\n  var id = (0,index_esm/* attr */.Lj)(node, SearchPad.RESULT_ID_ATTRIBUTE);\n  var element = this._results[id].element;\n\n  (0,index_esm/* classes */.Sh)(node).add(SearchPad.RESULT_SELECTED_CLASS);\n\n  this._resetOverlay(element);\n\n  this._canvas.scrollToElement(element, { top: 400 });\n\n  this._selection.select(element);\n\n  this._eventBus.fire('searchPad.preselected', element);\n};\n\n\n/**\n * Select result node.\n *\n * @param {HTMLElement} element\n */\nSearchPad.prototype._select = function(node) {\n  var id = (0,index_esm/* attr */.Lj)(node, SearchPad.RESULT_ID_ATTRIBUTE);\n  var element = this._results[id].element;\n\n  this.close();\n\n  this._resetOverlay();\n\n  this._canvas.scrollToElement(element, { top: 400 });\n\n  this._selection.select(element);\n\n  this._eventBus.fire('searchPad.selected', element);\n};\n\n\n/**\n * Reset overlay removes and, optionally, set\n * overlay to a new element.\n *\n * @param {HTMLElement} element\n */\nSearchPad.prototype._resetOverlay = function(element) {\n  if (this._overlayId) {\n    this._overlays.remove(this._overlayId);\n  }\n\n  if (element) {\n    var box = (0,Elements/* getBBox */.jY)(element);\n    var overlay = constructOverlay(box);\n    this._overlayId = this._overlays.add(element, overlay);\n  }\n};\n\n\n/**\n * Construct overlay object for the given bounding box.\n *\n * @param {Dimensions} box\n *\n * @return {OverlayAttrs}\n */\nfunction constructOverlay(box) {\n\n  var offset = 6;\n  var w = box.width + offset * 2;\n  var h = box.height + offset * 2;\n\n  var styles = {\n    width: w + 'px',\n    height: h + 'px'\n  };\n\n  var html = (0,index_esm/* domify */.H6)('<div class=\"' + SearchPad.OVERLAY_CLASS + '\"></div>');\n\n  (0,index_esm/* assignStyle */.i5)(html, styles);\n\n  return {\n    position: {\n      bottom: h - offset,\n      right: w - offset\n    },\n    show: true,\n    html: html\n  };\n}\n\n\n/**\n * Creates and appends child node from result tokens and HTML template.\n *\n * @param {HTMLElement} node\n * @param {Token[]} tokens\n * @param {string} template\n */\nfunction createInnerTextNode(parentNode, tokens, template) {\n  var text = createHtmlText(tokens);\n  var childNode = (0,index_esm/* domify */.H6)(template);\n  childNode.innerHTML = text;\n  parentNode.appendChild(childNode);\n}\n\n/**\n * Create internal HTML markup from result tokens.\n * Caters for highlighting pattern matched tokens.\n *\n * @param {Token[]} tokens\n *\n * @return {string|null}\n */\nfunction createHtmlText(tokens) {\n  var htmlText = '';\n\n  tokens.forEach(function(t) {\n    if (t.matched) {\n      htmlText += '<strong class=\"' + SearchPad.RESULT_HIGHLIGHT_CLASS + '\">' + (0,EscapeUtil/* escapeHTML */.r)(t.matched) + '</strong>';\n    } else {\n      htmlText += (0,EscapeUtil/* escapeHTML */.r)(t.normal);\n    }\n  });\n\n  return htmlText !== '' ? htmlText : null;\n}\n\n\n/**\n * CONSTANTS\n */\nSearchPad.CONTAINER_SELECTOR = '.djs-search-container';\nSearchPad.INPUT_SELECTOR = '.djs-search-input input';\nSearchPad.RESULTS_CONTAINER_SELECTOR = '.djs-search-results';\nSearchPad.RESULT_SELECTOR = '.djs-search-result';\nSearchPad.RESULT_SELECTED_CLASS = 'djs-search-result-selected';\nSearchPad.RESULT_SELECTED_SELECTOR = '.' + SearchPad.RESULT_SELECTED_CLASS;\nSearchPad.RESULT_ID_ATTRIBUTE = 'data-result-id';\nSearchPad.RESULT_HIGHLIGHT_CLASS = 'djs-search-highlight';\nSearchPad.OVERLAY_CLASS = 'djs-search-overlay';\n\nSearchPad.BOX_HTML =\n  '<div class=\"djs-search-container djs-draggable djs-scrollable\">' +\n    '<div class=\"djs-search-input\">' +\n      '<input type=\"text\"/>' +\n    '</div>' +\n    '<div class=\"djs-search-results\"></div>' +\n  '</div>';\n\nSearchPad.RESULT_HTML =\n  '<div class=\"djs-search-result\"></div>';\n\nSearchPad.RESULT_PRIMARY_HTML =\n  '<div class=\"djs-search-result-primary\"></div>';\n\nSearchPad.RESULT_SECONDARY_HTML =\n  '<p class=\"djs-search-result-secondary\"></p>';\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/search-pad/index.js\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const search_pad = ({\n  __depends__: [\n    overlays/* default */.Z,\n    selection/* default */.Z\n  ],\n  searchPad: [ 'type', SearchPad ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/search-pad/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/selection/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ selection)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/interaction-events/index.js + 1 modules\nvar interaction_events = __webpack_require__(\"./node_modules/diagram-js/lib/features/interaction-events/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/outline/index.js + 1 modules\nvar outline = __webpack_require__(\"./node_modules/diagram-js/lib/features/outline/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/selection/Selection.js\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n */\n\n/**\n * A service that offers the current selection in a diagram.\n * Offers the api to control the selection, too.\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n */\nfunction Selection(eventBus, canvas) {\n\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n\n  /**\n   * @type {Object[]}\n   */\n  this._selectedElements = [];\n\n  var self = this;\n\n  eventBus.on([ 'shape.remove', 'connection.remove' ], function(e) {\n    var element = e.element;\n    self.deselect(element);\n  });\n\n  eventBus.on([ 'diagram.clear', 'root.set' ], function(e) {\n    self.select(null);\n  });\n}\n\nSelection.$inject = [ 'eventBus', 'canvas' ];\n\n/**\n * Deselect an element.\n *\n * @param {Object} element The element to deselect.\n */\nSelection.prototype.deselect = function(element) {\n  var selectedElements = this._selectedElements;\n\n  var idx = selectedElements.indexOf(element);\n\n  if (idx !== -1) {\n    var oldSelection = selectedElements.slice();\n\n    selectedElements.splice(idx, 1);\n\n    this._eventBus.fire('selection.changed', { oldSelection: oldSelection, newSelection: selectedElements });\n  }\n};\n\n/**\n * Get the selected elements.\n *\n * @return {Object[]} The selected elements.\n */\nSelection.prototype.get = function() {\n  return this._selectedElements;\n};\n\n/**\n * Check whether an element is selected.\n *\n * @param {Object} element The element.\n *\n * @return {boolean} Whether the element is selected.\n */\nSelection.prototype.isSelected = function(element) {\n  return this._selectedElements.indexOf(element) !== -1;\n};\n\n\n/**\n * Select one or many elements.\n *\n * @param {Object|Object[]} elements The element(s) to select.\n * @param {boolean} [add] Whether to add the element(s) to the selected elements.\n * Defaults to `false`.\n */\nSelection.prototype.select = function(elements, add) {\n  var selectedElements = this._selectedElements,\n      oldSelection = selectedElements.slice();\n\n  if (!(0,index_esm/* isArray */.kJ)(elements)) {\n    elements = elements ? [ elements ] : [];\n  }\n\n  var canvas = this._canvas;\n\n  var rootElement = canvas.getRootElement();\n\n  elements = elements.filter(function(element) {\n    var elementRoot = canvas.findRoot(element);\n\n    return rootElement === elementRoot;\n  });\n\n  // selection may be cleared by passing an empty array or null\n  // to the method\n  if (add) {\n    (0,index_esm/* forEach */.Ed)(elements, function(element) {\n      if (selectedElements.indexOf(element) !== -1) {\n\n        // already selected\n        return;\n      } else {\n        selectedElements.push(element);\n      }\n    });\n  } else {\n    this._selectedElements = selectedElements = elements.slice();\n  }\n\n  this._eventBus.fire('selection.changed', { oldSelection: oldSelection, newSelection: selectedElements });\n};\n\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/selection/SelectionVisuals.js\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('./Selection').default} Selection\n */\n\nvar MARKER_HOVER = 'hover',\n    MARKER_SELECTED = 'selected';\n\nvar SELECTION_OUTLINE_PADDING = 6;\n\n\n/**\n * A plugin that adds a visible selection UI to shapes and connections\n * by appending the <code>hover</code> and <code>selected</code> classes to them.\n *\n * @class\n *\n * Makes elements selectable, too.\n *\n * @param {Canvas} canvas\n * @param {EventBus} eventBus\n * @param {Selection} selection\n */\nfunction SelectionVisuals(canvas, eventBus, selection) {\n  this._canvas = canvas;\n\n  var self = this;\n\n  this._multiSelectionBox = null;\n\n  function addMarker(e, cls) {\n    canvas.addMarker(e, cls);\n  }\n\n  function removeMarker(e, cls) {\n    canvas.removeMarker(e, cls);\n  }\n\n  eventBus.on('element.hover', function(event) {\n    addMarker(event.element, MARKER_HOVER);\n  });\n\n  eventBus.on('element.out', function(event) {\n    removeMarker(event.element, MARKER_HOVER);\n  });\n\n  eventBus.on('selection.changed', function(event) {\n\n    function deselect(s) {\n      removeMarker(s, MARKER_SELECTED);\n    }\n\n    function select(s) {\n      addMarker(s, MARKER_SELECTED);\n    }\n\n    var oldSelection = event.oldSelection,\n        newSelection = event.newSelection;\n\n    (0,index_esm/* forEach */.Ed)(oldSelection, function(e) {\n      if (newSelection.indexOf(e) === -1) {\n        deselect(e);\n      }\n    });\n\n    (0,index_esm/* forEach */.Ed)(newSelection, function(e) {\n      if (oldSelection.indexOf(e) === -1) {\n        select(e);\n      }\n    });\n\n    self._updateSelectionOutline(newSelection);\n  });\n\n\n  eventBus.on('element.changed', function(event) {\n    if (selection.isSelected(event.element)) {\n      self._updateSelectionOutline(selection.get());\n    }\n  });\n}\n\nSelectionVisuals.$inject = [\n  'canvas',\n  'eventBus',\n  'selection'\n];\n\nSelectionVisuals.prototype._updateSelectionOutline = function(selection) {\n  var layer = this._canvas.getLayer('selectionOutline');\n\n  (0,dist_index_esm/* clear */.ZH)(layer);\n\n  var enabled = selection.length > 1;\n\n  var container = this._canvas.getContainer();\n\n  (0,dist_index_esm/* classes */.Sh)(container)[enabled ? 'add' : 'remove']('djs-multi-select');\n\n  if (!enabled) {\n    return;\n  }\n\n  var bBox = addSelectionOutlinePadding((0,Elements/* getBBox */.jY)(selection));\n\n  var rect = (0,dist_index_esm/* create */.Ue)('rect');\n\n  (0,dist_index_esm/* attr */.Lj)(rect, (0,index_esm/* assign */.f0)({\n    rx: 3\n  }, bBox));\n\n  (0,dist_index_esm/* classes */.Sh)(rect).add('djs-selection-outline');\n\n  (0,dist_index_esm/* append */.R3)(layer, rect);\n};\n\n// helpers //////////\n\nfunction addSelectionOutlinePadding(bBox) {\n  return {\n    x: bBox.x - SELECTION_OUTLINE_PADDING,\n    y: bBox.y - SELECTION_OUTLINE_PADDING,\n    width: bBox.width + SELECTION_OUTLINE_PADDING * 2,\n    height: bBox.height + SELECTION_OUTLINE_PADDING * 2\n  };\n}\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Mouse.js\nvar Mouse = __webpack_require__(\"./node_modules/diagram-js/lib/util/Mouse.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/selection/SelectionBehavior.js\n\n\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/ElementRegistry').default} ElementRegistry\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('./Selection').default} Selection\n */\n\n/**\n * @param {EventBus} eventBus\n * @param {Selection} selection\n * @param {Canvas} canvas\n * @param {ElementRegistry} elementRegistry\n */\nfunction SelectionBehavior(eventBus, selection, canvas, elementRegistry) {\n\n  // Select elements on create\n  eventBus.on('create.end', 500, function(event) {\n    var context = event.context,\n        canExecute = context.canExecute,\n        elements = context.elements,\n        hints = context.hints || {},\n        autoSelect = hints.autoSelect;\n\n    if (canExecute) {\n      if (autoSelect === false) {\n\n        // Select no elements\n        return;\n      }\n\n      if ((0,index_esm/* isArray */.kJ)(autoSelect)) {\n        selection.select(autoSelect);\n      } else {\n\n        // Select all elements by default\n        selection.select(elements.filter(isShown));\n      }\n    }\n  });\n\n  // Select connection targets on connect\n  eventBus.on('connect.end', 500, function(event) {\n    var context = event.context,\n        connection = context.connection;\n\n    if (connection) {\n      selection.select(connection);\n    }\n  });\n\n  // Select shapes on move\n  eventBus.on('shape.move.end', 500, function(event) {\n    var previousSelection = event.previousSelection || [];\n\n    var shape = elementRegistry.get(event.context.shape.id);\n\n    // Always select main shape on move\n    var isSelected = (0,index_esm/* find */.sE)(previousSelection, function(selectedShape) {\n      return shape.id === selectedShape.id;\n    });\n\n    if (!isSelected) {\n      selection.select(shape);\n    }\n  });\n\n  // Select elements on click\n  eventBus.on('element.click', function(event) {\n\n    if (!(0,Mouse/* isPrimaryButton */.Id)(event)) {\n      return;\n    }\n\n    var element = event.element;\n\n    if (element === canvas.getRootElement()) {\n      element = null;\n    }\n\n    var isSelected = selection.isSelected(element),\n        isMultiSelect = selection.get().length > 1;\n\n    // Add to selection if CTRL or SHIFT pressed\n    var add = (0,Mouse/* hasPrimaryModifier */.RJ)(event) || (0,Mouse/* hasSecondaryModifier */.Dw)(event);\n\n    if (isSelected && isMultiSelect) {\n      if (add) {\n\n        // Deselect element\n        return selection.deselect(element);\n      } else {\n\n        // Select element only\n        return selection.select(element);\n      }\n    } else if (!isSelected) {\n\n      // Select element\n      selection.select(element, add);\n    } else {\n\n      // Deselect element\n      selection.deselect(element);\n    }\n  });\n}\n\nSelectionBehavior.$inject = [\n  'eventBus',\n  'selection',\n  'canvas',\n  'elementRegistry'\n];\n\n\nfunction isShown(element) {\n  return !element.hidden;\n}\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/selection/index.js\n\n\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const selection = ({\n  __init__: [ 'selectionVisuals', 'selectionBehavior' ],\n  __depends__: [\n    interaction_events/* default */.Z,\n    outline/* default */.Z\n  ],\n  selection: [ 'type', Selection ],\n  selectionVisuals: [ 'type', SelectionVisuals ],\n  selectionBehavior: [ 'type', SelectionBehavior ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/selection/index.js_+_3_modules?")},"./node_modules/diagram-js/lib/features/snapping/CreateMoveSnapping.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ CreateMoveSnapping)\n/* harmony export */ });\n/* harmony import */ var _SnapContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(\"./node_modules/diagram-js/lib/features/snapping/SnapContext.js\");\n/* harmony import */ var _SnapUtil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/diagram-js/lib/features/snapping/SnapUtil.js\");\n/* harmony import */ var _keyboard_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n/* harmony import */ var _util_ModelUtil__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(\"./node_modules/diagram-js/lib/util/ModelUtil.js\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n/**\r\n * @typedef {import('../../core/ElementRegistry').default} ElementRegistry\r\n * @typedef {import('../../core/EventBus').default} EventBus\r\n * @typedef {import('./Snapping').default} Snapping\r\n */\r\n\r\nvar HIGHER_PRIORITY = 1250;\r\n\r\n\r\n/**\r\n * Snap during create and move.\r\n *\r\n * @param {ElementRegistry} elementRegistry\r\n * @param {EventBus} eventBus\r\n * @param {Snapping} snapping\r\n */\r\nfunction CreateMoveSnapping(elementRegistry, eventBus, snapping) {\r\n  var self = this;\r\n\r\n  this._elementRegistry = elementRegistry;\r\n\r\n  eventBus.on([\r\n    'create.start',\r\n    'shape.move.start'\r\n  ], function(event) {\r\n    self.initSnap(event);\r\n  });\r\n\r\n  eventBus.on([\r\n    'create.move',\r\n    'create.end',\r\n    'shape.move.move',\r\n    'shape.move.end'\r\n  ], HIGHER_PRIORITY, function(event) {\r\n    var context = event.context,\r\n        shape = context.shape,\r\n        snapContext = context.snapContext,\r\n        target = context.target;\r\n\r\n    if (event.originalEvent && (0,_keyboard_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isCmd */ .JS)(event.originalEvent)) {\r\n      return;\r\n    }\r\n\r\n    if ((0,_SnapUtil__WEBPACK_IMPORTED_MODULE_1__/* .isSnapped */ .Wn)(event) || !target) {\r\n      return;\r\n    }\r\n\r\n    var snapPoints = snapContext.pointsForTarget(target);\r\n\r\n    if (!snapPoints.initialized) {\r\n      snapPoints = self.addSnapTargetPoints(snapPoints, shape, target);\r\n\r\n      snapPoints.initialized = true;\r\n    }\r\n\r\n    snapping.snap(event, snapPoints);\r\n  });\r\n\r\n  eventBus.on([\r\n    'create.cleanup',\r\n    'shape.move.cleanup'\r\n  ], function() {\r\n    snapping.hide();\r\n  });\r\n}\r\n\r\nCreateMoveSnapping.$inject = [\r\n  'elementRegistry',\r\n  'eventBus',\r\n  'snapping'\r\n];\r\n\r\nCreateMoveSnapping.prototype.initSnap = function(event) {\r\n  var elementRegistry = this._elementRegistry;\r\n\r\n  var context = event.context,\r\n      shape = context.shape,\r\n      snapContext = context.snapContext;\r\n\r\n  if (!snapContext) {\r\n    snapContext = context.snapContext = new _SnapContext__WEBPACK_IMPORTED_MODULE_2__/* [\"default\"] */ .Z();\r\n  }\r\n\r\n  var shapeMid;\r\n\r\n  if (elementRegistry.get(shape.id)) {\r\n\r\n    // move\r\n    shapeMid = (0,_SnapUtil__WEBPACK_IMPORTED_MODULE_1__/* .mid */ .Pi)(shape, event);\r\n  } else {\r\n\r\n    // create\r\n    shapeMid = {\r\n      x: event.x + (0,_SnapUtil__WEBPACK_IMPORTED_MODULE_1__/* .mid */ .Pi)(shape).x,\r\n      y: event.y + (0,_SnapUtil__WEBPACK_IMPORTED_MODULE_1__/* .mid */ .Pi)(shape).y\r\n    };\r\n  }\r\n\r\n  var shapeTopLeft = {\r\n        x: shapeMid.x - shape.width / 2,\r\n        y: shapeMid.y - shape.height / 2\r\n      },\r\n      shapeBottomRight = {\r\n        x: shapeMid.x + shape.width / 2,\r\n        y: shapeMid.y + shape.height / 2\r\n      };\r\n\r\n  snapContext.setSnapOrigin('mid', {\r\n    x: shapeMid.x - event.x,\r\n    y: shapeMid.y - event.y\r\n  });\r\n\r\n  // snap labels to mid only\r\n  if ((0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_3__/* .isLabel */ .j_)(shape)) {\r\n    return snapContext;\r\n  }\r\n\r\n  snapContext.setSnapOrigin('top-left', {\r\n    x: shapeTopLeft.x - event.x,\r\n    y: shapeTopLeft.y - event.y\r\n  });\r\n\r\n  snapContext.setSnapOrigin('bottom-right', {\r\n    x: shapeBottomRight.x - event.x,\r\n    y: shapeBottomRight.y - event.y\r\n  });\r\n\r\n  return snapContext;\r\n};\r\n\r\nCreateMoveSnapping.prototype.addSnapTargetPoints = function(snapPoints, shape, target) {\r\n  var snapTargets = this.getSnapTargets(shape, target);\r\n\r\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_4__/* .forEach */ .Ed)(snapTargets, function(snapTarget) {\r\n\r\n    // handle labels\r\n    if ((0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_3__/* .isLabel */ .j_)(snapTarget)) {\r\n\r\n      if ((0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_3__/* .isLabel */ .j_)(shape)) {\r\n        snapPoints.add('mid', (0,_SnapUtil__WEBPACK_IMPORTED_MODULE_1__/* .mid */ .Pi)(snapTarget));\r\n      }\r\n\r\n      return;\r\n    }\r\n\r\n    // handle connections\r\n    if ((0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_3__/* .isConnection */ .Ho)(snapTarget)) {\r\n\r\n      // ignore single segment connections\r\n      if (snapTarget.waypoints.length < 3) {\r\n        return;\r\n      }\r\n\r\n      // ignore first and last waypoint\r\n      var waypoints = snapTarget.waypoints.slice(1, -1);\r\n\r\n      (0,min_dash__WEBPACK_IMPORTED_MODULE_4__/* .forEach */ .Ed)(waypoints, function(waypoint) {\r\n        snapPoints.add('mid', waypoint);\r\n      });\r\n\r\n      return;\r\n    }\r\n\r\n    // handle shapes\r\n    snapPoints.add('mid', (0,_SnapUtil__WEBPACK_IMPORTED_MODULE_1__/* .mid */ .Pi)(snapTarget));\r\n  });\r\n\r\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_4__/* .isNumber */ .hj)(shape.x) || !(0,min_dash__WEBPACK_IMPORTED_MODULE_4__/* .isNumber */ .hj)(shape.y)) {\r\n    return snapPoints;\r\n  }\r\n\r\n  // snap to original position when moving\r\n  if (this._elementRegistry.get(shape.id)) {\r\n    snapPoints.add('mid', (0,_SnapUtil__WEBPACK_IMPORTED_MODULE_1__/* .mid */ .Pi)(shape));\r\n  }\r\n\r\n  return snapPoints;\r\n};\r\n\r\nCreateMoveSnapping.prototype.getSnapTargets = function(shape, target) {\r\n  return (0,_SnapUtil__WEBPACK_IMPORTED_MODULE_1__/* .getChildren */ .G)(target).filter(function(child) {\r\n    return !isHidden(child);\r\n  });\r\n};\r\n\r\n// helpers //////////\r\n\r\nfunction isHidden(element) {\r\n  return !!element.hidden;\r\n}\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/snapping/CreateMoveSnapping.js?")},"./node_modules/diagram-js/lib/features/snapping/SnapContext.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ SnapContext)\n/* harmony export */ });\n/* unused harmony export SnapPoints */\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n/* harmony import */ var _SnapUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/lib/features/snapping/SnapUtil.js\");\n\n\n\n\n/**\n * @typedef {import('../../model/Types').Element} Element\n *\n * @typedef {import('../../util/Types').Axis} Axis\n * @typedef {import('../../util/Types').DirectionTRBL} DirectionTRBL\n * @typedef {import('../../util/Types').Point} Point\n *\n * @typedef {DirectionTRBL & 'mid'} SnapLocation\n */\n\n/**\n * A snap context, containing the (possibly incomplete)\n * mappings of drop targets (to identify the snapping)\n * to computed snap points.\n */\nfunction SnapContext() {\n\n  /**\n   * @type {Record<string, SnapPoints>}\n   */\n  this._targets = {};\n\n  /**\n   * @type {Record<SnapLocation, Point>}\n   */\n  this._snapOrigins = {};\n\n  /**\n   * @type {SnapLocation[]}\n   */\n  this._snapLocations = [];\n\n  /**\n   * @type {Record<SnapLocation, Point[]>}\n   */\n  this._defaultSnaps = {};\n}\n\n/**\n * Get the snap origin for a given location.\n *\n * @param {SnapLocation} snapLocation\n *\n * @return {Point}\n */\nSnapContext.prototype.getSnapOrigin = function(snapLocation) {\n  return this._snapOrigins[snapLocation];\n};\n\n/**\n * Set the snap origin for a given location.\n *\n * @param {SnapLocation} snapLocation\n * @param {Point} snapOrigin\n */\nSnapContext.prototype.setSnapOrigin = function(snapLocation, snapOrigin) {\n  this._snapOrigins[snapLocation] = snapOrigin;\n\n  if (this._snapLocations.indexOf(snapLocation) === -1) {\n    this._snapLocations.push(snapLocation);\n  }\n};\n\n/**\n * Add a default snap point.\n *\n * @param {SnapLocation} snapLocation\n * @param {Point} point\n */\nSnapContext.prototype.addDefaultSnap = function(snapLocation, point) {\n\n  var snapValues = this._defaultSnaps[snapLocation];\n\n  if (!snapValues) {\n    snapValues = this._defaultSnaps[snapLocation] = [];\n  }\n\n  snapValues.push(point);\n};\n\n/**\n * Get the snap locations for this context.\n *\n * @return {SnapLocation[]}\n */\nSnapContext.prototype.getSnapLocations = function() {\n  return this._snapLocations;\n};\n\n/**\n * Set the snap locations for this context.\n *\n * The order of locations determines precedence.\n *\n * @param {SnapLocation[]} snapLocations\n */\nSnapContext.prototype.setSnapLocations = function(snapLocations) {\n  this._snapLocations = snapLocations;\n};\n\n/**\n * Get snap points for the given target.\n *\n * @param {Element|string} target\n *\n * @return {SnapPoints}\n */\nSnapContext.prototype.pointsForTarget = function(target) {\n\n  var targetId = target.id || target;\n\n  var snapPoints = this._targets[targetId];\n\n  if (!snapPoints) {\n    snapPoints = this._targets[targetId] = new SnapPoints();\n    snapPoints.initDefaults(this._defaultSnaps);\n  }\n\n  return snapPoints;\n};\n\n\n/**\n * Add points to snap to.\n */\nfunction SnapPoints() {\n\n  /**\n   * Example:\n   *\n   * ```javascript\n   * {\n   *   'top-right': {\n   *     x: [ 100, 200, 300 ]\n   *     y: [ 100, 200, 300 ]\n   *   }\n   * }\n   * ```\n   *\n   * @type {Record<string, Record<Axis, number[]>>}\n   */\n  this._snapValues = {};\n}\n\n/**\n * Add a snap point.\n *\n * @param {SnapLocation} snapLocation\n * @param {Point} point\n */\nSnapPoints.prototype.add = function(snapLocation, point) {\n\n  var snapValues = this._snapValues[snapLocation];\n\n  if (!snapValues) {\n    snapValues = this._snapValues[snapLocation] = { x: [], y: [] };\n  }\n\n  if (snapValues.x.indexOf(point.x) === -1) {\n    snapValues.x.push(point.x);\n  }\n\n  if (snapValues.y.indexOf(point.y) === -1) {\n    snapValues.y.push(point.y);\n  }\n};\n\n/**\n * Snap a point's x or y value.\n *\n * @param {Point} point\n * @param {SnapLocation} snapLocation\n * @param {Axis} axis\n * @param {number} tolerance\n *\n * @return {number}\n */\nSnapPoints.prototype.snap = function(point, snapLocation, axis, tolerance) {\n  var snappingValues = this._snapValues[snapLocation];\n\n  return snappingValues && (0,_SnapUtil__WEBPACK_IMPORTED_MODULE_0__/* .snapTo */ .By)(point[axis], snappingValues[axis], tolerance);\n};\n\n/**\n * Initialize default snap points.\n *\n * @param {Record<SnapLocation, Point[]>} defaultSnaps\n */\nSnapPoints.prototype.initDefaults = function(defaultSnaps) {\n\n  var self = this;\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .forEach */ .Ed)(defaultSnaps || {}, function(snapPoints, snapLocation) {\n    (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .forEach */ .Ed)(snapPoints, function(point) {\n      self.add(snapLocation, point);\n    });\n  });\n};\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/snapping/SnapContext.js?")},"./node_modules/diagram-js/lib/features/snapping/SnapUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"By\": () => (/* binding */ snapTo),\n/* harmony export */   \"G\": () => (/* binding */ getChildren),\n/* harmony export */   \"Pi\": () => (/* binding */ mid),\n/* harmony export */   \"U\": () => (/* binding */ setSnapped),\n/* harmony export */   \"Wn\": () => (/* binding */ isSnapped),\n/* harmony export */   \"hT\": () => (/* binding */ bottomRight),\n/* harmony export */   \"w3\": () => (/* binding */ topLeft)\n/* harmony export */ });\n/* unused harmony exports topRight, bottomLeft */\n/**\n * @typedef {import('../../core/Types').ConnectionLike} Connection\n * @typedef {import('../../core/Types').ShapeLike} Shape\n *\n * @typedef {import('../../core/EventBus').Event} Event\n *\n * @typedef {import('../../util/Types').Axis} Axis\n */\n\nvar abs = Math.abs,\n    round = Math.round;\n\n\n/**\n * Snap value to a collection of reference values.\n *\n * @param {number} value\n * @param {Array<number>} values\n * @param {number} [tolerance=10]\n *\n * @return {number} the value we snapped to or null, if none snapped\n */\nfunction snapTo(value, values, tolerance) {\n  tolerance = tolerance === undefined ? 10 : tolerance;\n\n  var idx, snapValue;\n\n  for (idx = 0; idx < values.length; idx++) {\n    snapValue = values[idx];\n\n    if (abs(snapValue - value) <= tolerance) {\n      return snapValue;\n    }\n  }\n}\n\n\nfunction topLeft(bounds) {\n  return {\n    x: bounds.x,\n    y: bounds.y\n  };\n}\n\nfunction topRight(bounds) {\n  return {\n    x: bounds.x + bounds.width,\n    y: bounds.y\n  };\n}\n\nfunction bottomLeft(bounds) {\n  return {\n    x: bounds.x,\n    y: bounds.y + bounds.height\n  };\n}\n\nfunction bottomRight(bounds) {\n  return {\n    x: bounds.x + bounds.width,\n    y: bounds.y + bounds.height\n  };\n}\n\nfunction mid(bounds, defaultValue) {\n\n  if (!bounds || isNaN(bounds.x) || isNaN(bounds.y)) {\n    return defaultValue;\n  }\n\n  return {\n    x: round(bounds.x + bounds.width / 2),\n    y: round(bounds.y + bounds.height / 2)\n  };\n}\n\n\n/**\n * Retrieve the snap state of the given event.\n *\n * @param {Event} event\n * @param {Axis} axis\n *\n * @return {boolean} the snapped state\n *\n */\nfunction isSnapped(event, axis) {\n  var snapped = event.snapped;\n\n  if (!snapped) {\n    return false;\n  }\n\n  if (typeof axis === 'string') {\n    return snapped[axis];\n  }\n\n  return snapped.x && snapped.y;\n}\n\n\n/**\n * Set the given event as snapped.\n *\n * This method may change the x and/or y position of the shape\n * from the given event!\n *\n * @param {Event} event\n * @param {Axis} axis\n * @param {number|boolean} value\n *\n * @return {number} old value\n */\nfunction setSnapped(event, axis, value) {\n  if (typeof axis !== 'string') {\n    throw new Error('axis must be in [x, y]');\n  }\n\n  if (typeof value !== 'number' && value !== false) {\n    throw new Error('value must be Number or false');\n  }\n\n  var delta,\n      previousValue = event[axis];\n\n  var snapped = event.snapped = (event.snapped || {});\n\n\n  if (value === false) {\n    snapped[axis] = false;\n  } else {\n    snapped[axis] = true;\n\n    delta = value - previousValue;\n\n    event[axis] += delta;\n    event['d' + axis] += delta;\n  }\n\n  return previousValue;\n}\n\n/**\n * Get children of a shape.\n *\n * @param {Shape} parent\n *\n * @return {Array<Shape|Connection>}\n */\nfunction getChildren(parent) {\n  return parent.children || [];\n}\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/snapping/SnapUtil.js?")},"./node_modules/diagram-js/lib/features/snapping/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ snapping)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/snapping/CreateMoveSnapping.js\nvar CreateMoveSnapping = __webpack_require__(\"./node_modules/diagram-js/lib/features/snapping/CreateMoveSnapping.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/snapping/SnapContext.js\nvar SnapContext = __webpack_require__(\"./node_modules/diagram-js/lib/features/snapping/SnapContext.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/snapping/SnapUtil.js\nvar SnapUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/snapping/SnapUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\nvar KeyboardUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/ModelUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/snapping/ResizeSnapping.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n/**\r\n * @typedef {import('../../core/EventBus').default} EventBus\r\n * @typedef {import('./Snapping').default} Snapping\r\n */\r\n\r\nvar HIGHER_PRIORITY = 1250;\r\n\r\n\r\n/**\r\n * Snap during resize.\r\n *\r\n * @param {EventBus} eventBus\r\n * @param {Snapping} snapping\r\n */\r\nfunction ResizeSnapping(eventBus, snapping) {\r\n  var self = this;\r\n\r\n  eventBus.on([ 'resize.start' ], function(event) {\r\n    self.initSnap(event);\r\n  });\r\n\r\n  eventBus.on([\r\n    'resize.move',\r\n    'resize.end',\r\n  ], HIGHER_PRIORITY, function(event) {\r\n    var context = event.context,\r\n        shape = context.shape,\r\n        parent = shape.parent,\r\n        direction = context.direction,\r\n        snapContext = context.snapContext;\r\n\r\n    if (event.originalEvent && (0,KeyboardUtil/* isCmd */.JS)(event.originalEvent)) {\r\n      return;\r\n    }\r\n\r\n    if ((0,SnapUtil/* isSnapped */.Wn)(event)) {\r\n      return;\r\n    }\r\n\r\n    var snapPoints = snapContext.pointsForTarget(parent);\r\n\r\n    if (!snapPoints.initialized) {\r\n      snapPoints = self.addSnapTargetPoints(snapPoints, shape, parent, direction);\r\n\r\n      snapPoints.initialized = true;\r\n    }\r\n\r\n    if (isHorizontal(direction)) {\r\n      (0,SnapUtil/* setSnapped */.U)(event, 'x', event.x);\r\n    }\r\n\r\n    if (isVertical(direction)) {\r\n      (0,SnapUtil/* setSnapped */.U)(event, 'y', event.y);\r\n    }\r\n\r\n    snapping.snap(event, snapPoints);\r\n  });\r\n\r\n  eventBus.on([ 'resize.cleanup' ], function() {\r\n    snapping.hide();\r\n  });\r\n}\r\n\r\nResizeSnapping.prototype.initSnap = function(event) {\r\n  var context = event.context,\r\n      shape = context.shape,\r\n      direction = context.direction,\r\n      snapContext = context.snapContext;\r\n\r\n  if (!snapContext) {\r\n    snapContext = context.snapContext = new SnapContext/* default */.Z();\r\n  }\r\n\r\n  var snapOrigin = getSnapOrigin(shape, direction);\r\n\r\n  snapContext.setSnapOrigin('corner', {\r\n    x: snapOrigin.x - event.x,\r\n    y: snapOrigin.y - event.y\r\n  });\r\n\r\n  return snapContext;\r\n};\r\n\r\nResizeSnapping.prototype.addSnapTargetPoints = function(snapPoints, shape, target, direction) {\r\n  var snapTargets = this.getSnapTargets(shape, target);\r\n\r\n  (0,index_esm/* forEach */.Ed)(snapTargets, function(snapTarget) {\r\n    snapPoints.add('corner', (0,SnapUtil/* bottomRight */.hT)(snapTarget));\r\n    snapPoints.add('corner', (0,SnapUtil/* topLeft */.w3)(snapTarget));\r\n  });\r\n\r\n  snapPoints.add('corner', getSnapOrigin(shape, direction));\r\n\r\n  return snapPoints;\r\n};\r\n\r\nResizeSnapping.$inject = [\r\n  'eventBus',\r\n  'snapping'\r\n];\r\n\r\nResizeSnapping.prototype.getSnapTargets = function(shape, target) {\r\n  return (0,SnapUtil/* getChildren */.G)(target).filter(function(child) {\r\n    return !isAttached(child, shape)\r\n      && !(0,ModelUtil/* isConnection */.Ho)(child)\r\n      && !isHidden(child)\r\n      && !(0,ModelUtil/* isLabel */.j_)(child);\r\n  });\r\n};\r\n\r\n// helpers //////////\r\n\r\nfunction getSnapOrigin(shape, direction) {\r\n  var mid = (0,LayoutUtil/* getMid */.wS)(shape),\r\n      trbl = (0,LayoutUtil/* asTRBL */.JA)(shape);\r\n\r\n  var snapOrigin = {\r\n    x: mid.x,\r\n    y: mid.y\r\n  };\r\n\r\n  if (direction.indexOf('n') !== -1) {\r\n    snapOrigin.y = trbl.top;\r\n  } else if (direction.indexOf('s') !== -1) {\r\n    snapOrigin.y = trbl.bottom;\r\n  }\r\n\r\n  if (direction.indexOf('e') !== -1) {\r\n    snapOrigin.x = trbl.right;\r\n  } else if (direction.indexOf('w') !== -1) {\r\n    snapOrigin.x = trbl.left;\r\n  }\r\n\r\n  return snapOrigin;\r\n}\r\n\r\nfunction isAttached(element, host) {\r\n  return element.host === host;\r\n}\r\n\r\nfunction isHidden(element) {\r\n  return !!element.hidden;\r\n}\r\n\r\nfunction isHorizontal(direction) {\r\n  return direction === 'n' || direction === 's';\r\n}\r\n\r\nfunction isVertical(direction) {\r\n  return direction === 'e' || direction === 'w';\r\n}\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/snapping/Snapping.js\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n *\n * @typedef {import('../../core/EventBus').Event} Event\n *\n * @typedef {import('./SnapContext').SnapPoints} SnapPoints\n */\n\nvar SNAP_TOLERANCE = 7;\n\nvar SNAP_LINE_HIDE_DELAY = 1000;\n\n\n/**\n * Generic snapping feature.\n *\n * @param {Canvas} canvas\n */\nfunction Snapping(canvas) {\n  this._canvas = canvas;\n\n  // delay hide by 1000 seconds since last snap\n  this._asyncHide = (0,index_esm/* debounce */.Ds)((0,index_esm/* bind */.ak)(this.hide, this), SNAP_LINE_HIDE_DELAY);\n}\n\nSnapping.$inject = [ 'canvas' ];\n\n/**\n * Snap an event to given snap points.\n *\n * @param {Event} event\n * @param {SnapPoints} snapPoints\n */\nSnapping.prototype.snap = function(event, snapPoints) {\n  var context = event.context,\n      snapContext = context.snapContext,\n      snapLocations = snapContext.getSnapLocations();\n\n  var snapping = {\n    x: (0,SnapUtil/* isSnapped */.Wn)(event, 'x'),\n    y: (0,SnapUtil/* isSnapped */.Wn)(event, 'y')\n  };\n\n  (0,index_esm/* forEach */.Ed)(snapLocations, function(location) {\n    var snapOrigin = snapContext.getSnapOrigin(location);\n\n    var snapCurrent = {\n      x: event.x + snapOrigin.x,\n      y: event.y + snapOrigin.y\n    };\n\n    // snap both axis if not snapped already\n    (0,index_esm/* forEach */.Ed)([ 'x', 'y' ], function(axis) {\n      var locationSnapping;\n\n      if (!snapping[axis]) {\n        locationSnapping = snapPoints.snap(snapCurrent, location, axis, SNAP_TOLERANCE);\n\n        if (locationSnapping !== undefined) {\n          snapping[axis] = {\n            value: locationSnapping,\n            originValue: locationSnapping - snapOrigin[axis]\n          };\n        }\n      }\n    });\n\n    // no need to continue snapping\n    if (snapping.x && snapping.y) {\n      return false;\n    }\n  });\n\n  // show snap lines\n  this.showSnapLine('vertical', snapping.x && snapping.x.value);\n  this.showSnapLine('horizontal', snapping.y && snapping.y.value);\n\n  // snap event\n  (0,index_esm/* forEach */.Ed)([ 'x', 'y' ], function(axis) {\n    var axisSnapping = snapping[axis];\n\n    if ((0,index_esm/* isObject */.Kn)(axisSnapping)) {\n      (0,SnapUtil/* setSnapped */.U)(event, axis, axisSnapping.originValue);\n    }\n  });\n};\n\nSnapping.prototype._createLine = function(orientation) {\n  var root = this._canvas.getLayer('snap');\n\n  var line = (0,dist_index_esm/* create */.Ue)('path');\n\n  (0,dist_index_esm/* attr */.Lj)(line, { d: 'M0,0 L0,0' });\n\n  (0,dist_index_esm/* classes */.Sh)(line).add('djs-snap-line');\n\n  (0,dist_index_esm/* append */.R3)(root, line);\n\n  return {\n    update: function(position) {\n\n      if (!(0,index_esm/* isNumber */.hj)(position)) {\n        (0,dist_index_esm/* attr */.Lj)(line, { display: 'none' });\n      } else {\n        if (orientation === 'horizontal') {\n          (0,dist_index_esm/* attr */.Lj)(line, {\n            d: 'M-100000,' + position + ' L+100000,' + position,\n            display: ''\n          });\n        } else {\n          (0,dist_index_esm/* attr */.Lj)(line, {\n            d: 'M ' + position + ',-100000 L ' + position + ', +100000',\n            display: ''\n          });\n        }\n      }\n    }\n  };\n};\n\nSnapping.prototype._createSnapLines = function() {\n  this._snapLines = {\n    horizontal: this._createLine('horizontal'),\n    vertical: this._createLine('vertical')\n  };\n};\n\nSnapping.prototype.showSnapLine = function(orientation, position) {\n\n  var line = this.getSnapLine(orientation);\n\n  if (line) {\n    line.update(position);\n  }\n\n  this._asyncHide();\n};\n\nSnapping.prototype.getSnapLine = function(orientation) {\n  if (!this._snapLines) {\n    this._createSnapLines();\n  }\n\n  return this._snapLines[orientation];\n};\n\nSnapping.prototype.hide = function() {\n  (0,index_esm/* forEach */.Ed)(this._snapLines, function(snapLine) {\n    snapLine.update();\n  });\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/snapping/index.js\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const snapping = ({\n  __init__: [\n    'createMoveSnapping',\n    'resizeSnapping',\n    'snapping'\n  ],\n  createMoveSnapping: [ 'type', CreateMoveSnapping/* default */.Z ],\n  resizeSnapping: [ 'type', ResizeSnapping ],\n  snapping: [ 'type', Snapping ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/snapping/index.js_+_2_modules?")},"./node_modules/diagram-js/lib/features/space-tool/SpaceTool.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ SpaceTool)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n/* harmony import */ var _layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n/* harmony import */ var _util_Elements__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n/* harmony import */ var _SpaceUtil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/diagram-js/lib/features/space-tool/SpaceUtil.js\");\n/* harmony import */ var _util_Mouse__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/lib/util/Mouse.js\");\n/* harmony import */ var _util_Cursor__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(\"./node_modules/diagram-js/lib/util/Cursor.js\");\n/* harmony import */ var _util_ModelUtil__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(\"./node_modules/diagram-js/lib/util/ModelUtil.js\");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Types').ShapeLike} Shape\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../dragging/Dragging').default} Dragging\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../modeling/Modeling').default} Modeling\n * @typedef {import('../mouse/Mouse').default} Mouse\n * @typedef {import('../rules/Rules').default} Rules\n * @typedef {import('../tool-manager/ToolManager').default} ToolManager\n *\n * @typedef {import('../../util/Types').Axis} Axis\n * @typedef {import('../../util/Types').Direction} Direction\n * @typedef {import('../../util/Types').Point} Point\n */\n\nvar abs = Math.abs,\n    round = Math.round;\n\nvar AXIS_TO_DIMENSION = {\n  x: 'width',\n  y: 'height'\n};\n\nvar CURSOR_CROSSHAIR = 'crosshair';\n\nvar DIRECTION_TO_TRBL = {\n  n: 'top',\n  w: 'left',\n  s: 'bottom',\n  e: 'right'\n};\n\nvar HIGH_PRIORITY = 1500;\n\nvar DIRECTION_TO_OPPOSITE = {\n  n: 's',\n  w: 'e',\n  s: 'n',\n  e: 'w'\n};\n\nvar PADDING = 20;\n\n\n/**\n * Add or remove space by moving and resizing elements.\n *\n * @param {Canvas} canvas\n * @param {Dragging} dragging\n * @param {EventBus} eventBus\n * @param {Modeling} modeling\n * @param {Rules} rules\n * @param {ToolManager} toolManager\n * @param {Mouse} mouse\n */\nfunction SpaceTool(\n    canvas, dragging, eventBus,\n    modeling, rules, toolManager,\n    mouse) {\n\n  this._canvas = canvas;\n  this._dragging = dragging;\n  this._eventBus = eventBus;\n  this._modeling = modeling;\n  this._rules = rules;\n  this._toolManager = toolManager;\n  this._mouse = mouse;\n\n  var self = this;\n\n  toolManager.registerTool('space', {\n    tool: 'spaceTool.selection',\n    dragging: 'spaceTool'\n  });\n\n  eventBus.on('spaceTool.selection.end', function(event) {\n    eventBus.once('spaceTool.selection.ended', function() {\n      self.activateMakeSpace(event.originalEvent);\n    });\n  });\n\n  eventBus.on('spaceTool.move', HIGH_PRIORITY , function(event) {\n    var context = event.context,\n        initialized = context.initialized;\n\n    if (!initialized) {\n      initialized = context.initialized = self.init(event, context);\n    }\n\n    if (initialized) {\n      ensureConstraints(event);\n    }\n  });\n\n  eventBus.on('spaceTool.end', function(event) {\n    var context = event.context,\n        axis = context.axis,\n        direction = context.direction,\n        movingShapes = context.movingShapes,\n        resizingShapes = context.resizingShapes,\n        start = context.start;\n\n    if (!context.initialized) {\n      return;\n    }\n\n    ensureConstraints(event);\n\n    var delta = {\n      x: 0,\n      y: 0\n    };\n\n    delta[ axis ] = round(event[ 'd' + axis ]);\n\n    self.makeSpace(movingShapes, resizingShapes, delta, direction, start);\n\n    eventBus.once('spaceTool.ended', function(event) {\n\n      // activate space tool selection after make space\n      self.activateSelection(event.originalEvent, true, true);\n    });\n  });\n}\n\nSpaceTool.$inject = [\n  'canvas',\n  'dragging',\n  'eventBus',\n  'modeling',\n  'rules',\n  'toolManager',\n  'mouse'\n];\n\n/**\n * Activate space tool selection.\n *\n * @param {MouseEvent|TouchEvent} event\n * @param {boolean} autoActivate\n * @param {boolean} reactivate\n */\nSpaceTool.prototype.activateSelection = function(event, autoActivate, reactivate) {\n  this._dragging.init(event, 'spaceTool.selection', {\n    autoActivate: autoActivate,\n    cursor: CURSOR_CROSSHAIR,\n    data: {\n      context: {\n        reactivate: reactivate\n      }\n    },\n    trapClick: false\n  });\n};\n\n/**\n * Activate space tool make space.\n *\n * @param {MouseEvent|TouchEvent} event\n */\nSpaceTool.prototype.activateMakeSpace = function(event) {\n  this._dragging.init(event, 'spaceTool', {\n    autoActivate: true,\n    cursor: CURSOR_CROSSHAIR,\n    data: {\n      context: {}\n    }\n  });\n};\n\n/**\n * Make space.\n *\n * @param {Array<Shape>} movingShapes\n * @param {Array<Shape>} resizingShapes\n * @param {Point} delta\n * @param {Direction} direction\n * @param {number} start\n */\nSpaceTool.prototype.makeSpace = function(movingShapes, resizingShapes, delta, direction, start) {\n  return this._modeling.createSpace(movingShapes, resizingShapes, delta, direction, start);\n};\n\n/**\n * Initialize make space and return true if that was successful.\n *\n * @param {MouseEvent|TouchEvent} event\n * @param {Object} context\n *\n * @return {boolean}\n */\nSpaceTool.prototype.init = function(event, context) {\n  var axis = abs(event.dx) > abs(event.dy) ? 'x' : 'y',\n      delta = event[ 'd' + axis ],\n      start = event[ axis ] - delta;\n\n  if (abs(delta) < 5) {\n    return false;\n  }\n\n  // invert delta to remove space when moving left\n  if (delta < 0) {\n    delta *= -1;\n  }\n\n  // invert delta to add/remove space when removing/adding space if modifier key is pressed\n  if ((0,_util_Mouse__WEBPACK_IMPORTED_MODULE_0__/* .hasPrimaryModifier */ .RJ)(event)) {\n    delta *= -1;\n  }\n\n  var direction = (0,_SpaceUtil__WEBPACK_IMPORTED_MODULE_1__/* .getDirection */ .Mg)(axis, delta);\n\n  var root = this._canvas.getRootElement();\n\n  var children = (0,_util_Elements__WEBPACK_IMPORTED_MODULE_2__/* .selfAndAllChildren */ .PB)(root, true);\n\n  var elements = this.calculateAdjustments(children, axis, delta, start);\n\n  var minDimensions = this._eventBus.fire('spaceTool.getMinDimensions', {\n    axis: axis,\n    direction: direction,\n    shapes: elements.resizingShapes,\n    start: start\n  });\n\n  var spaceToolConstraints = getSpaceToolConstraints(elements, axis, direction, start, minDimensions);\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .assign */ .f0)(\n    context,\n    elements,\n    {\n      axis: axis,\n      direction: direction,\n      spaceToolConstraints: spaceToolConstraints,\n      start: start\n    }\n  );\n\n  (0,_util_Cursor__WEBPACK_IMPORTED_MODULE_4__/* .set */ .t8)('resize-' + (axis === 'x' ? 'ew' : 'ns'));\n\n  return true;\n};\n\n/**\n * Get elements to be moved and resized.\n *\n * @param {Array<Shape>} elements\n * @param {Axis} axis\n * @param {Point} delta\n * @param {number} start\n *\n * @return {Object}\n */\nSpaceTool.prototype.calculateAdjustments = function(elements, axis, delta, start) {\n  var rules = this._rules;\n\n  var movingShapes = [],\n      resizingShapes = [];\n\n  var attachers = [],\n      connections = [];\n\n  function moveShape(shape) {\n    if (!movingShapes.includes(shape)) {\n      movingShapes.push(shape);\n    }\n\n    var label = shape.label;\n\n    // move external label if its label target is moving\n    if (label && !movingShapes.includes(label)) {\n      movingShapes.push(label);\n    }\n  }\n\n  function resizeShape(shape) {\n    if (!resizingShapes.includes(shape)) {\n      resizingShapes.push(shape);\n    }\n  }\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .forEach */ .Ed)(elements, function(element) {\n    if (!element.parent || (0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_5__/* .isLabel */ .j_)(element)) {\n      return;\n    }\n\n    // handle connections separately\n    if ((0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_5__/* .isConnection */ .Ho)(element)) {\n      connections.push(element);\n\n      return;\n    }\n\n    var shapeStart = element[ axis ],\n        shapeEnd = shapeStart + element[ AXIS_TO_DIMENSION[ axis ] ];\n\n    // handle attachers separately\n    if (isAttacher(element)\n      && ((delta > 0 && (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_6__/* .getMid */ .wS)(element)[ axis ] > start)\n        || (delta < 0 && (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_6__/* .getMid */ .wS)(element)[ axis ] < start))) {\n      attachers.push(element);\n\n      return;\n    }\n\n    // move shape if its start is after space tool\n    if ((delta > 0 && shapeStart > start)\n      || (delta < 0 && shapeEnd < start)) {\n      moveShape(element);\n\n      return;\n    }\n\n    // resize shape if it's resizable and its start is before and its end is after space tool\n    if (shapeStart < start\n      && shapeEnd > start\n      && rules.allowed('shape.resize', { shape: element })\n    ) {\n      resizeShape(element);\n\n      return;\n    }\n  });\n\n  // move attacher if its host is moving\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .forEach */ .Ed)(movingShapes, function(shape) {\n    var attachers = shape.attachers;\n\n    if (attachers) {\n      (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .forEach */ .Ed)(attachers, function(attacher) {\n        moveShape(attacher);\n      });\n    }\n  });\n\n  var allShapes = movingShapes.concat(resizingShapes);\n\n  // move attacher if its mid is after space tool and its host is moving or resizing\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .forEach */ .Ed)(attachers, function(attacher) {\n    var host = attacher.host;\n\n    if (includes(allShapes, host)) {\n      moveShape(attacher);\n    }\n  });\n\n  allShapes = movingShapes.concat(resizingShapes);\n\n  // move external label if its label target's (connection) source and target are moving\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .forEach */ .Ed)(connections, function(connection) {\n    var source = connection.source,\n        target = connection.target,\n        label = connection.label;\n\n    if (includes(allShapes, source)\n      && includes(allShapes, target)\n      && label) {\n      moveShape(label);\n    }\n  });\n\n  return {\n    movingShapes: movingShapes,\n    resizingShapes: resizingShapes\n  };\n};\n\nSpaceTool.prototype.toggle = function() {\n\n  if (this.isActive()) {\n    return this._dragging.cancel();\n  }\n\n  var mouseEvent = this._mouse.getLastMoveEvent();\n\n  this.activateSelection(mouseEvent, !!mouseEvent);\n};\n\nSpaceTool.prototype.isActive = function() {\n  var context = this._dragging.context();\n\n  if (context) {\n    return /^spaceTool/.test(context.prefix);\n  }\n\n  return false;\n};\n\n// helpers //////////\n\nfunction addPadding(trbl) {\n  return {\n    top: trbl.top - PADDING,\n    right: trbl.right + PADDING,\n    bottom: trbl.bottom + PADDING,\n    left: trbl.left - PADDING\n  };\n}\n\nfunction ensureConstraints(event) {\n  var context = event.context,\n      spaceToolConstraints = context.spaceToolConstraints;\n\n  if (!spaceToolConstraints) {\n    return;\n  }\n\n  var x, y;\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(spaceToolConstraints.left)) {\n    x = Math.max(event.x, spaceToolConstraints.left);\n\n    event.dx = event.dx + x - event.x;\n    event.x = x;\n  }\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(spaceToolConstraints.right)) {\n    x = Math.min(event.x, spaceToolConstraints.right);\n\n    event.dx = event.dx + x - event.x;\n    event.x = x;\n  }\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(spaceToolConstraints.top)) {\n    y = Math.max(event.y, spaceToolConstraints.top);\n\n    event.dy = event.dy + y - event.y;\n    event.y = y;\n  }\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(spaceToolConstraints.bottom)) {\n    y = Math.min(event.y, spaceToolConstraints.bottom);\n\n    event.dy = event.dy + y - event.y;\n    event.y = y;\n  }\n}\n\nfunction getSpaceToolConstraints(elements, axis, direction, start, minDimensions) {\n  var movingShapes = elements.movingShapes,\n      resizingShapes = elements.resizingShapes;\n\n  if (!resizingShapes.length) {\n    return;\n  }\n\n  var spaceToolConstraints = {},\n      min,\n      max;\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .forEach */ .Ed)(resizingShapes, function(resizingShape) {\n    var attachers = resizingShape.attachers,\n        children = resizingShape.children;\n\n    var resizingShapeBBox = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_6__/* .asTRBL */ .JA)(resizingShape);\n\n    // find children that are not moving or resizing\n    var nonMovingResizingChildren = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .filter */ .hX)(children, function(child) {\n      return !(0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_5__/* .isConnection */ .Ho)(child) &&\n        !(0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_5__/* .isLabel */ .j_)(child) &&\n        !includes(movingShapes, child) &&\n        !includes(resizingShapes, child);\n    });\n\n    // find children that are moving\n    var movingChildren = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .filter */ .hX)(children, function(child) {\n      return !(0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_5__/* .isConnection */ .Ho)(child) && !(0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_5__/* .isLabel */ .j_)(child) && includes(movingShapes, child);\n    });\n\n    var minOrMax,\n        nonMovingResizingChildrenBBox,\n        movingChildrenBBox,\n        movingAttachers = [],\n        nonMovingAttachers = [],\n        movingAttachersBBox,\n        movingAttachersConstraint,\n        nonMovingAttachersBBox,\n        nonMovingAttachersConstraint;\n\n    if (nonMovingResizingChildren.length) {\n      nonMovingResizingChildrenBBox = addPadding((0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_6__/* .asTRBL */ .JA)((0,_util_Elements__WEBPACK_IMPORTED_MODULE_2__/* .getBBox */ .jY)(nonMovingResizingChildren)));\n\n      minOrMax = start -\n        resizingShapeBBox[ DIRECTION_TO_TRBL[ direction ] ] +\n        nonMovingResizingChildrenBBox[ DIRECTION_TO_TRBL[ direction ] ];\n\n      if (direction === 'n') {\n        spaceToolConstraints.bottom = max = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(max) ? Math.min(max, minOrMax) : minOrMax;\n      } else if (direction === 'w') {\n        spaceToolConstraints.right = max = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(max) ? Math.min(max, minOrMax) : minOrMax;\n      } else if (direction === 's') {\n        spaceToolConstraints.top = min = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(min) ? Math.max(min, minOrMax) : minOrMax;\n      } else if (direction === 'e') {\n        spaceToolConstraints.left = min = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(min) ? Math.max(min, minOrMax) : minOrMax;\n      }\n    }\n\n    if (movingChildren.length) {\n      movingChildrenBBox = addPadding((0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_6__/* .asTRBL */ .JA)((0,_util_Elements__WEBPACK_IMPORTED_MODULE_2__/* .getBBox */ .jY)(movingChildren)));\n\n      minOrMax = start -\n        movingChildrenBBox[ DIRECTION_TO_TRBL[ DIRECTION_TO_OPPOSITE[ direction ] ] ] +\n        resizingShapeBBox[ DIRECTION_TO_TRBL[ DIRECTION_TO_OPPOSITE[ direction ] ] ];\n\n      if (direction === 'n') {\n        spaceToolConstraints.bottom = max = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(max) ? Math.min(max, minOrMax) : minOrMax;\n      } else if (direction === 'w') {\n        spaceToolConstraints.right = max = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(max) ? Math.min(max, minOrMax) : minOrMax;\n      } else if (direction === 's') {\n        spaceToolConstraints.top = min = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(min) ? Math.max(min, minOrMax) : minOrMax;\n      } else if (direction === 'e') {\n        spaceToolConstraints.left = min = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(min) ? Math.max(min, minOrMax) : minOrMax;\n      }\n    }\n\n    if (attachers && attachers.length) {\n      attachers.forEach(function(attacher) {\n        if (includes(movingShapes, attacher)) {\n          movingAttachers.push(attacher);\n        } else {\n          nonMovingAttachers.push(attacher);\n        }\n      });\n\n      if (movingAttachers.length) {\n        movingAttachersBBox = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_6__/* .asTRBL */ .JA)((0,_util_Elements__WEBPACK_IMPORTED_MODULE_2__/* .getBBox */ .jY)(movingAttachers.map(_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_6__/* .getMid */ .wS)));\n\n        movingAttachersConstraint = resizingShapeBBox[ DIRECTION_TO_TRBL[ DIRECTION_TO_OPPOSITE[ direction ] ] ]\n              - (movingAttachersBBox[ DIRECTION_TO_TRBL[ DIRECTION_TO_OPPOSITE[ direction ] ] ] - start);\n      }\n\n      if (nonMovingAttachers.length) {\n        nonMovingAttachersBBox = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_6__/* .asTRBL */ .JA)((0,_util_Elements__WEBPACK_IMPORTED_MODULE_2__/* .getBBox */ .jY)(nonMovingAttachers.map(_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_6__/* .getMid */ .wS)));\n\n        nonMovingAttachersConstraint = nonMovingAttachersBBox[ DIRECTION_TO_TRBL[ direction ] ]\n              - (resizingShapeBBox[ DIRECTION_TO_TRBL[ direction ] ] - start);\n      }\n\n      if (direction === 'n') {\n        minOrMax = Math.min(movingAttachersConstraint || Infinity, nonMovingAttachersConstraint || Infinity);\n\n        spaceToolConstraints.bottom = max = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(max) ? Math.min(max, minOrMax) : minOrMax;\n      } else if (direction === 'w') {\n        minOrMax = Math.min(movingAttachersConstraint || Infinity, nonMovingAttachersConstraint || Infinity);\n\n        spaceToolConstraints.right = max = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(max) ? Math.min(max, minOrMax) : minOrMax;\n      } else if (direction === 's') {\n        minOrMax = Math.max(movingAttachersConstraint || -Infinity, nonMovingAttachersConstraint || -Infinity);\n\n        spaceToolConstraints.top = min = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(min) ? Math.max(min, minOrMax) : minOrMax;\n      } else if (direction === 'e') {\n        minOrMax = Math.max(movingAttachersConstraint || -Infinity, nonMovingAttachersConstraint || -Infinity);\n\n        spaceToolConstraints.left = min = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(min) ? Math.max(min, minOrMax) : minOrMax;\n      }\n    }\n\n    var resizingShapeMinDimensions = minDimensions && minDimensions[ resizingShape.id ];\n\n    if (resizingShapeMinDimensions) {\n\n      if (direction === 'n') {\n        minOrMax = start +\n          resizingShape[ AXIS_TO_DIMENSION [ axis ] ] -\n          resizingShapeMinDimensions[ AXIS_TO_DIMENSION[ axis ] ];\n\n        spaceToolConstraints.bottom = max = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(max) ? Math.min(max, minOrMax) : minOrMax;\n      } else if (direction === 'w') {\n        minOrMax = start +\n          resizingShape[ AXIS_TO_DIMENSION [ axis ] ] -\n          resizingShapeMinDimensions[ AXIS_TO_DIMENSION[ axis ] ];\n\n        spaceToolConstraints.right = max = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(max) ? Math.min(max, minOrMax) : minOrMax;\n      } else if (direction === 's') {\n        minOrMax = start -\n          resizingShape[ AXIS_TO_DIMENSION [ axis ] ] +\n          resizingShapeMinDimensions[ AXIS_TO_DIMENSION[ axis ] ];\n\n        spaceToolConstraints.top = min = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(min) ? Math.max(min, minOrMax) : minOrMax;\n      } else if (direction === 'e') {\n        minOrMax = start -\n          resizingShape[ AXIS_TO_DIMENSION [ axis ] ] +\n          resizingShapeMinDimensions[ AXIS_TO_DIMENSION[ axis ] ];\n\n        spaceToolConstraints.left = min = (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(min) ? Math.max(min, minOrMax) : minOrMax;\n      }\n    }\n  });\n\n  return spaceToolConstraints;\n}\n\nfunction includes(array, item) {\n  return array.indexOf(item) !== -1;\n}\n\nfunction isAttacher(element) {\n  return !!element.host;\n}\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/space-tool/SpaceTool.js?")},"./node_modules/diagram-js/lib/features/space-tool/SpaceUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Mg\": () => (/* binding */ getDirection),\n/* harmony export */   \"wb\": () => (/* binding */ getWaypointsUpdatingConnections),\n/* harmony export */   \"zY\": () => (/* binding */ resizeBounds)\n/* harmony export */ });\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n}\n/**\n * @typedef {import('../../core/Types').ConnectionLike} Connection\n * @typedef {import('../../core/Types').ShapeLike} Shape\n *\n * @typedef {import('../../util/Types').Axis} Axis\n * @typedef {import('../../util/Types').Direction} Direction\n * @typedef {import('../../util/Types').Point} Point\n * @typedef {import('../../util/Types').Rect} Rect\n */\n\n\n\n/**\n * Return direction given axis and delta.\n *\n * @param {Axis} axis\n * @param {number} delta\n *\n * @return {Direction}\n */\nfunction getDirection(axis, delta) {\n\n  if (axis === 'x') {\n    if (delta > 0) {\n      return 'e';\n    }\n\n    if (delta < 0) {\n      return 'w';\n    }\n  }\n\n  if (axis === 'y') {\n    if (delta > 0) {\n      return 's';\n    }\n\n    if (delta < 0) {\n      return 'n';\n    }\n  }\n\n  return null;\n}\n\n/**\n * Returns connections whose waypoints are to be updated. Waypoints are to be updated if start\n * or end is to be moved or resized.\n *\n * @param {Array<Shape>} movingShapes\n * @param {Array<Shape>} resizingShapes\n *\n * @return {Array<Connection>}\n */\nfunction getWaypointsUpdatingConnections(movingShapes, resizingShapes) {\n  var waypointsUpdatingConnections = [];\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(movingShapes.concat(resizingShapes), function(shape) {\n    var incoming = shape.incoming,\n        outgoing = shape.outgoing;\n\n    (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(incoming.concat(outgoing), function(connection) {\n      var source = connection.source,\n          target = connection.target;\n\n      if (includes(movingShapes, source) ||\n        includes(movingShapes, target) ||\n        includes(resizingShapes, source) ||\n        includes(resizingShapes, target)) {\n\n        if (!includes(waypointsUpdatingConnections, connection)) {\n          waypointsUpdatingConnections.push(connection);\n        }\n      }\n    });\n  });\n\n  return waypointsUpdatingConnections;\n}\n\nfunction includes(array, item) {\n  return array.indexOf(item) !== -1;\n}\n\n/**\n * Resize bounds.\n *\n * @param {Rect} bounds\n * @param {Direction} direction\n * @param {Point} delta\n *\n * @return {Rect}\n */\nfunction resizeBounds(bounds, direction, delta) {\n  var x = bounds.x,\n      y = bounds.y,\n      width = bounds.width,\n      height = bounds.height,\n      dx = delta.x,\n      dy = delta.y;\n\n  switch (direction) {\n  case 'n':\n    return {\n      x: x,\n      y: y + dy,\n      width: width,\n      height: height - dy\n    };\n  case 's':\n    return {\n      x: x,\n      y: y,\n      width: width,\n      height: height + dy\n    };\n  case 'w':\n    return {\n      x: x + dx,\n      y: y,\n      width: width - dx,\n      height: height\n    };\n  case 'e':\n    return {\n      x: x,\n      y: y,\n      width: width + dx,\n      height: height\n    };\n  default:\n    throw new Error('unknown direction: ' + direction);\n  }\n}\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/space-tool/SpaceUtil.js?")},"./node_modules/diagram-js/lib/features/space-tool/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ space_tool)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/dragging/index.js + 3 modules\nvar dragging = __webpack_require__(\"./node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/tool-manager/index.js + 1 modules\nvar tool_manager = __webpack_require__(\"./node_modules/diagram-js/lib/features/tool-manager/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/preview-support/index.js + 1 modules\nvar preview_support = __webpack_require__(\"./node_modules/diagram-js/lib/features/preview-support/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/mouse/index.js + 1 modules\nvar mouse = __webpack_require__(\"./node_modules/diagram-js/lib/features/mouse/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/space-tool/SpaceTool.js\nvar SpaceTool = __webpack_require__(\"./node_modules/diagram-js/lib/features/space-tool/SpaceTool.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/SvgTransformUtil.js\nvar SvgTransformUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/SvgTransformUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/ModelUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/space-tool/SpaceToolPreview.js\n\n\nvar MARKER_DRAGGING = 'djs-dragging',\n    MARKER_RESIZING = 'djs-resizing';\n\nvar LOW_PRIORITY = 250;\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/ElementRegistry').default} ElementRegistry\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../../draw/Styles').default} Styles\n */\n\nvar max = Math.max;\n\n\n/**\n * Provides previews for selecting/moving/resizing shapes when creating/removing space.\n *\n * @param {EventBus} eventBus\n * @param {ElementRegistry} elementRegistry\n * @param {Canvas} canvas\n * @param {Styles} styles\n */\nfunction SpaceToolPreview(\n    eventBus, elementRegistry, canvas,\n    styles, previewSupport) {\n\n  function addPreviewGfx(collection, dragGroup) {\n    (0,index_esm/* forEach */.Ed)(collection, function(element) {\n      previewSupport.addDragger(element, dragGroup);\n\n      canvas.addMarker(element, MARKER_DRAGGING);\n    });\n  }\n\n  // add crosshair\n  eventBus.on('spaceTool.selection.start', function(event) {\n    var space = canvas.getLayer('space'),\n        context = event.context;\n\n    var orientation = {\n      x: 'M 0,-10000 L 0,10000',\n      y: 'M -10000,0 L 10000,0'\n    };\n\n    var crosshairGroup = (0,dist_index_esm/* create */.Ue)('g');\n    (0,dist_index_esm/* attr */.Lj)(crosshairGroup, styles.cls('djs-crosshair-group', [ 'no-events' ]));\n\n    (0,dist_index_esm/* append */.R3)(space, crosshairGroup);\n\n    // horizontal path\n    var pathX = (0,dist_index_esm/* create */.Ue)('path');\n    (0,dist_index_esm/* attr */.Lj)(pathX, 'd', orientation.x);\n    (0,dist_index_esm/* classes */.Sh)(pathX).add('djs-crosshair');\n\n    (0,dist_index_esm/* append */.R3)(crosshairGroup, pathX);\n\n    // vertical path\n    var pathY = (0,dist_index_esm/* create */.Ue)('path');\n    (0,dist_index_esm/* attr */.Lj)(pathY, 'd', orientation.y);\n    (0,dist_index_esm/* classes */.Sh)(pathY).add('djs-crosshair');\n\n    (0,dist_index_esm/* append */.R3)(crosshairGroup, pathY);\n\n    context.crosshairGroup = crosshairGroup;\n  });\n\n  // update crosshair\n  eventBus.on('spaceTool.selection.move', function(event) {\n    var crosshairGroup = event.context.crosshairGroup;\n\n    (0,SvgTransformUtil/* translate */.Iu)(crosshairGroup, event.x, event.y);\n  });\n\n  // remove crosshair\n  eventBus.on('spaceTool.selection.cleanup', function(event) {\n    var context = event.context,\n        crosshairGroup = context.crosshairGroup;\n\n    if (crosshairGroup) {\n      (0,dist_index_esm/* remove */.Od)(crosshairGroup);\n    }\n  });\n\n  // add and update move/resize previews\n  eventBus.on('spaceTool.move', LOW_PRIORITY, function(event) {\n\n    var context = event.context,\n        line = context.line,\n        axis = context.axis,\n        movingShapes = context.movingShapes,\n        resizingShapes = context.resizingShapes;\n\n    if (!context.initialized) {\n      return;\n    }\n\n    if (!context.dragGroup) {\n      var spaceLayer = canvas.getLayer('space');\n\n      line = (0,dist_index_esm/* create */.Ue)('path');\n      (0,dist_index_esm/* attr */.Lj)(line, 'd', 'M0,0 L0,0');\n      (0,dist_index_esm/* classes */.Sh)(line).add('djs-crosshair');\n\n      (0,dist_index_esm/* append */.R3)(spaceLayer, line);\n\n      context.line = line;\n\n      var dragGroup = (0,dist_index_esm/* create */.Ue)('g');\n      (0,dist_index_esm/* attr */.Lj)(dragGroup, styles.cls('djs-drag-group', [ 'no-events' ]));\n\n      (0,dist_index_esm/* append */.R3)(canvas.getActiveLayer(), dragGroup);\n\n      // shapes\n      addPreviewGfx(movingShapes, dragGroup);\n\n      // connections\n      var movingConnections = context.movingConnections = elementRegistry.filter(function(element) {\n        var sourceIsMoving = false;\n\n        (0,index_esm/* forEach */.Ed)(movingShapes, function(shape) {\n          (0,index_esm/* forEach */.Ed)(shape.outgoing, function(connection) {\n            if (element === connection) {\n              sourceIsMoving = true;\n            }\n          });\n        });\n\n        var targetIsMoving = false;\n\n        (0,index_esm/* forEach */.Ed)(movingShapes, function(shape) {\n          (0,index_esm/* forEach */.Ed)(shape.incoming, function(connection) {\n            if (element === connection) {\n              targetIsMoving = true;\n            }\n          });\n        });\n\n        var sourceIsResizing = false;\n\n        (0,index_esm/* forEach */.Ed)(resizingShapes, function(shape) {\n          (0,index_esm/* forEach */.Ed)(shape.outgoing, function(connection) {\n            if (element === connection) {\n              sourceIsResizing = true;\n            }\n          });\n        });\n\n        var targetIsResizing = false;\n\n        (0,index_esm/* forEach */.Ed)(resizingShapes, function(shape) {\n          (0,index_esm/* forEach */.Ed)(shape.incoming, function(connection) {\n            if (element === connection) {\n              targetIsResizing = true;\n            }\n          });\n        });\n\n        return (0,ModelUtil/* isConnection */.Ho)(element)\n          && (sourceIsMoving || sourceIsResizing)\n          && (targetIsMoving || targetIsResizing);\n      });\n\n\n      addPreviewGfx(movingConnections, dragGroup);\n\n      context.dragGroup = dragGroup;\n    }\n\n    if (!context.frameGroup) {\n      var frameGroup = (0,dist_index_esm/* create */.Ue)('g');\n      (0,dist_index_esm/* attr */.Lj)(frameGroup, styles.cls('djs-frame-group', [ 'no-events' ]));\n\n      (0,dist_index_esm/* append */.R3)(canvas.getActiveLayer(), frameGroup);\n\n      var frames = [];\n\n      (0,index_esm/* forEach */.Ed)(resizingShapes, function(shape) {\n        var frame = previewSupport.addFrame(shape, frameGroup);\n\n        var initialBounds = frame.getBBox();\n\n        frames.push({\n          element: frame,\n          initialBounds: initialBounds\n        });\n\n        canvas.addMarker(shape, MARKER_RESIZING);\n      });\n\n      context.frameGroup = frameGroup;\n      context.frames = frames;\n    }\n\n    var orientation = {\n      x: 'M' + event.x + ', -10000 L' + event.x + ', 10000',\n      y: 'M -10000, ' + event.y + ' L 10000, ' + event.y\n    };\n\n    (0,dist_index_esm/* attr */.Lj)(line, { d: orientation[ axis ] });\n\n    var opposite = { x: 'y', y: 'x' };\n    var delta = { x: event.dx, y: event.dy };\n    delta[ opposite[ context.axis ] ] = 0;\n\n    // update move previews\n    (0,SvgTransformUtil/* translate */.Iu)(context.dragGroup, delta.x, delta.y);\n\n    // update resize previews\n    (0,index_esm/* forEach */.Ed)(context.frames, function(frame) {\n      var element = frame.element,\n          initialBounds = frame.initialBounds,\n          width,\n          height;\n\n      if (context.direction === 'e') {\n        (0,dist_index_esm/* attr */.Lj)(element, {\n          width: max(initialBounds.width + delta.x, 5)\n        });\n      } else {\n        width = max(initialBounds.width - delta.x, 5);\n\n        (0,dist_index_esm/* attr */.Lj)(element, {\n          width: width,\n          x: initialBounds.x + initialBounds.width - width\n        });\n      }\n\n      if (context.direction === 's') {\n        (0,dist_index_esm/* attr */.Lj)(element, {\n          height: max(initialBounds.height + delta.y, 5)\n        });\n      } else {\n        height = max(initialBounds.height - delta.y, 5);\n\n        (0,dist_index_esm/* attr */.Lj)(element, {\n          height: height,\n          y: initialBounds.y + initialBounds.height - height\n        });\n      }\n    });\n\n  });\n\n  // remove move/resize previews\n  eventBus.on('spaceTool.cleanup', function(event) {\n\n    var context = event.context,\n        movingShapes = context.movingShapes,\n        movingConnections = context.movingConnections,\n        resizingShapes = context.resizingShapes,\n        line = context.line,\n        dragGroup = context.dragGroup,\n        frameGroup = context.frameGroup;\n\n    // moving shapes\n    (0,index_esm/* forEach */.Ed)(movingShapes, function(shape) {\n      canvas.removeMarker(shape, MARKER_DRAGGING);\n    });\n\n    // moving connections\n    (0,index_esm/* forEach */.Ed)(movingConnections, function(connection) {\n      canvas.removeMarker(connection, MARKER_DRAGGING);\n    });\n\n    if (dragGroup) {\n      (0,dist_index_esm/* remove */.Od)(line);\n      (0,dist_index_esm/* remove */.Od)(dragGroup);\n    }\n\n    (0,index_esm/* forEach */.Ed)(resizingShapes, function(shape) {\n      canvas.removeMarker(shape, MARKER_RESIZING);\n    });\n\n    if (frameGroup) {\n      (0,dist_index_esm/* remove */.Od)(frameGroup);\n    }\n  });\n}\n\nSpaceToolPreview.$inject = [\n  'eventBus',\n  'elementRegistry',\n  'canvas',\n  'styles',\n  'previewSupport'\n];\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/space-tool/index.js\n\n\n\n\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const space_tool = ({\n  __init__: [ 'spaceToolPreview' ],\n  __depends__: [\n    dragging/* default */.Z,\n    rules/* default */.Z,\n    tool_manager/* default */.Z,\n    preview_support/* default */.Z,\n    mouse/* default */.Z\n  ],\n  spaceTool: [ 'type', SpaceTool/* default */.Z ],\n  spaceToolPreview: [ 'type', SpaceToolPreview ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/space-tool/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/tool-manager/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ tool_manager)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/dragging/index.js + 3 modules\nvar dragging = __webpack_require__(\"./node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/tool-manager/ToolManager.js\n\n\n\n\n/**\n * @typedef {import('../dragging/Dragging').default} Dragging\n * @typedef {import('../../core/EventBus').default} EventBus\n *\n * @typedef {import('../../core/EventBus').Event} Event\n */\n\nvar LOW_PRIORITY = 250;\n\n/**\n * The tool manager acts as middle-man between the available tool's and the Palette,\n * it takes care of making sure that the correct active state is set.\n *\n * @param {EventBus} eventBus\n * @param {Dragging} dragging\n */\nfunction ToolManager(eventBus, dragging) {\n  this._eventBus = eventBus;\n  this._dragging = dragging;\n\n  this._tools = [];\n  this._active = null;\n}\n\nToolManager.$inject = [ 'eventBus', 'dragging' ];\n\n/**\n * Register a tool.\n *\n * @param {string} name\n * @param { {\n *   dragging: string;\n *   tool: string;\n * } } events\n */\nToolManager.prototype.registerTool = function(name, events) {\n  var tools = this._tools;\n\n  if (!events) {\n    throw new Error('A tool has to be registered with it\\'s \"events\"');\n  }\n\n  tools.push(name);\n\n  this.bindEvents(name, events);\n};\n\nToolManager.prototype.isActive = function(tool) {\n  return tool && this._active === tool;\n};\n\nToolManager.prototype.length = function(tool) {\n  return this._tools.length;\n};\n\nToolManager.prototype.setActive = function(tool) {\n  var eventBus = this._eventBus;\n\n  if (this._active !== tool) {\n    this._active = tool;\n\n    eventBus.fire('tool-manager.update', { tool: tool });\n  }\n};\n\nToolManager.prototype.bindEvents = function(name, events) {\n  var eventBus = this._eventBus,\n      dragging = this._dragging;\n\n  var eventsToRegister = [];\n\n  eventBus.on(events.tool + '.init', function(event) {\n    var context = event.context;\n\n    // Active tools that want to reactivate themselves must do this explicitly\n    if (!context.reactivate && this.isActive(name)) {\n      this.setActive(null);\n\n      dragging.cancel();\n      return;\n    }\n\n    this.setActive(name);\n\n  }, this);\n\n  // TODO: add test cases\n  (0,index_esm/* forEach */.Ed)(events, function(event) {\n    eventsToRegister.push(event + '.ended');\n    eventsToRegister.push(event + '.canceled');\n  });\n\n  eventBus.on(eventsToRegister, LOW_PRIORITY, function(event) {\n\n    // We defer the de-activation of the tool to the .activate phase,\n    // so we're able to check if we want to toggle off the current\n    // active tool or switch to a new one\n    if (!this._active) {\n      return;\n    }\n\n    if (isPaletteClick(event)) {\n      return;\n    }\n\n    this.setActive(null);\n  }, this);\n\n};\n\n\n// helpers ///////////////\n\n/**\n * Check if a given event is a palette click event.\n *\n * @param {Event} event\n *\n * @return {boolean}\n */\nfunction isPaletteClick(event) {\n  var target = event.originalEvent && event.originalEvent.target;\n\n  return target && (0,dist_index_esm/* closest */.oq)(target, '.group[data-group=\"tools\"]');\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/tool-manager/index.js\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const tool_manager = ({\n  __depends__: [\n    dragging/* default */.Z\n  ],\n  __init__: [ 'toolManager' ],\n  toolManager: [ 'type', ToolManager ]\n});\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/tool-manager/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/features/tooltips/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ tooltips)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/IdGenerator.js\nvar IdGenerator = __webpack_require__(\"./node_modules/diagram-js/lib/util/IdGenerator.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/tooltips/Tooltips.js\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n *\n * @typedef {import('../../util/Types').RectTRBL} RectTRBL\n *\n * @typedef { {\n *   html: string | HTMLElement;\n *   position: RectTRBL;\n *   show?: {\n *     minZoom?: number;\n *     maxZoom?: number;\n *   };\n *   timeout?: number;\n * } } Tooltip\n */\n\n// document wide unique tooltip ids\nvar ids = new IdGenerator/* default */.Z('tt');\n\n\nfunction createRoot(parentNode) {\n  var root = (0,dist_index_esm/* domify */.H6)(\n    '<div class=\"djs-tooltip-container\" />'\n  );\n\n  (0,dist_index_esm/* assignStyle */.i5)(root, {\n    position: 'absolute',\n    width: '0',\n    height: '0'\n  });\n\n  parentNode.insertBefore(root, parentNode.firstChild);\n\n  return root;\n}\n\n\nfunction setPosition(el, x, y) {\n  (0,dist_index_esm/* assignStyle */.i5)(el, { left: x + 'px', top: y + 'px' });\n}\n\nfunction setVisible(el, visible) {\n  el.style.display = visible === false ? 'none' : '';\n}\n\n\nvar tooltipClass = 'djs-tooltip',\n    tooltipSelector = '.' + tooltipClass;\n\n/**\n * A service that allows users to render tool tips on the diagram.\n *\n * The tooltip service will take care of updating the tooltip positioning\n * during navigation + zooming.\n *\n * @example\n *\n * ```javascript\n *\n * // add a pink badge on the top left of the shape\n * tooltips.add({\n *   position: {\n *     x: 50,\n *     y: 100\n *   },\n *   html: '<div style=\"width: 10px; background: fuchsia; color: white;\">0</div>'\n * });\n *\n * // or with optional life span\n * tooltips.add({\n *   position: {\n *     top: -5,\n *     left: -5\n *   },\n *   html: '<div style=\"width: 10px; background: fuchsia; color: white;\">0</div>',\n *   ttl: 2000\n * });\n *\n * // remove a tool tip\n * var id = tooltips.add(...);\n *\n * tooltips.remove(id);\n * ```\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n */\nfunction Tooltips(eventBus, canvas) {\n\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n\n  this._ids = ids;\n\n  this._tooltipDefaults = {\n    show: {\n      minZoom: 0.7,\n      maxZoom: 5.0\n    }\n  };\n\n  /**\n   * @type {Record<string, Tooltip>}\n   */\n  this._tooltips = {};\n\n  // root html element for all tooltips\n  this._tooltipRoot = createRoot(canvas.getContainer());\n\n\n  var self = this;\n\n  dist_index_esm/* delegate.bind */.cl.bind(this._tooltipRoot, tooltipSelector, 'mousedown', function(event) {\n    event.stopPropagation();\n  });\n\n  dist_index_esm/* delegate.bind */.cl.bind(this._tooltipRoot, tooltipSelector, 'mouseover', function(event) {\n    self.trigger('mouseover', event);\n  });\n\n  dist_index_esm/* delegate.bind */.cl.bind(this._tooltipRoot, tooltipSelector, 'mouseout', function(event) {\n    self.trigger('mouseout', event);\n  });\n\n  this._init();\n}\n\n\nTooltips.$inject = [ 'eventBus', 'canvas' ];\n\n\n/**\n * Adds an HTML tooltip to the diagram.\n *\n * @param {Tooltip} tooltip\n *\n * @return {string} ID of the tooltip.\n */\nTooltips.prototype.add = function(tooltip) {\n\n  if (!tooltip.position) {\n    throw new Error('must specifiy tooltip position');\n  }\n\n  if (!tooltip.html) {\n    throw new Error('must specifiy tooltip html');\n  }\n\n  var id = this._ids.next();\n\n  tooltip = (0,index_esm/* assign */.f0)({}, this._tooltipDefaults, tooltip, {\n    id: id\n  });\n\n  this._addTooltip(tooltip);\n\n  if (tooltip.timeout) {\n    this.setTimeout(tooltip);\n  }\n\n  return id;\n};\n\n/**\n * @param {string} action\n * @param {Event} event\n */\nTooltips.prototype.trigger = function(action, event) {\n\n  var node = event.delegateTarget || event.target;\n\n  var tooltip = this.get((0,dist_index_esm/* attr */.Lj)(node, 'data-tooltip-id'));\n\n  if (!tooltip) {\n    return;\n  }\n\n  if (action === 'mouseover' && tooltip.timeout) {\n    this.clearTimeout(tooltip);\n  }\n\n  if (action === 'mouseout' && tooltip.timeout) {\n\n    // cut timeout after mouse out\n    tooltip.timeout = 1000;\n\n    this.setTimeout(tooltip);\n  }\n};\n\n/**\n * Get tooltip with given ID.\n *\n * @param {Tooltip|string} id\n *\n * @return {Tooltip|undefined}\n */\nTooltips.prototype.get = function(id) {\n\n  if (typeof id !== 'string') {\n    id = id.id;\n  }\n\n  return this._tooltips[id];\n};\n\n/**\n * @param {Tooltip} tooltip\n */\nTooltips.prototype.clearTimeout = function(tooltip) {\n\n  tooltip = this.get(tooltip);\n\n  if (!tooltip) {\n    return;\n  }\n\n  var removeTimer = tooltip.removeTimer;\n\n  if (removeTimer) {\n    clearTimeout(removeTimer);\n    tooltip.removeTimer = null;\n  }\n};\n\n/**\n * @param {Tooltip} tooltip\n */\nTooltips.prototype.setTimeout = function(tooltip) {\n\n  tooltip = this.get(tooltip);\n\n  if (!tooltip) {\n    return;\n  }\n\n  this.clearTimeout(tooltip);\n\n  var self = this;\n\n  tooltip.removeTimer = setTimeout(function() {\n    self.remove(tooltip);\n  }, tooltip.timeout);\n};\n\n/**\n * Remove tooltip with given ID.\n *\n * @param {string | Tooltip} id\n */\nTooltips.prototype.remove = function(id) {\n\n  var tooltip = this.get(id);\n\n  if (tooltip) {\n    (0,dist_index_esm/* remove */.Od)(tooltip.html);\n    (0,dist_index_esm/* remove */.Od)(tooltip.htmlContainer);\n\n    delete tooltip.htmlContainer;\n\n    delete this._tooltips[tooltip.id];\n  }\n};\n\n\nTooltips.prototype.show = function() {\n  setVisible(this._tooltipRoot);\n};\n\n\nTooltips.prototype.hide = function() {\n  setVisible(this._tooltipRoot, false);\n};\n\n\nTooltips.prototype._updateRoot = function(viewbox) {\n  var a = viewbox.scale || 1;\n  var d = viewbox.scale || 1;\n\n  var matrix = 'matrix(' + a + ',0,0,' + d + ',' + (-1 * viewbox.x * a) + ',' + (-1 * viewbox.y * d) + ')';\n\n  this._tooltipRoot.style.transform = matrix;\n  this._tooltipRoot.style['-ms-transform'] = matrix;\n};\n\n\nTooltips.prototype._addTooltip = function(tooltip) {\n\n  var id = tooltip.id,\n      html = tooltip.html,\n      htmlContainer,\n      tooltipRoot = this._tooltipRoot;\n\n  // unwrap jquery (for those who need it)\n  if (html.get && html.constructor.prototype.jquery) {\n    html = html.get(0);\n  }\n\n  // create proper html elements from\n  // tooltip HTML strings\n  if ((0,index_esm/* isString */.HD)(html)) {\n    html = (0,dist_index_esm/* domify */.H6)(html);\n  }\n\n  htmlContainer = (0,dist_index_esm/* domify */.H6)('<div data-tooltip-id=\"' + id + '\" class=\"' + tooltipClass + '\">');\n  (0,dist_index_esm/* assignStyle */.i5)(htmlContainer, { position: 'absolute' });\n\n  htmlContainer.appendChild(html);\n\n  if (tooltip.type) {\n    (0,dist_index_esm/* classes */.Sh)(htmlContainer).add('djs-tooltip-' + tooltip.type);\n  }\n\n  if (tooltip.className) {\n    (0,dist_index_esm/* classes */.Sh)(htmlContainer).add(tooltip.className);\n  }\n\n  tooltip.htmlContainer = htmlContainer;\n\n  tooltipRoot.appendChild(htmlContainer);\n\n  this._tooltips[id] = tooltip;\n\n  this._updateTooltip(tooltip);\n};\n\n\nTooltips.prototype._updateTooltip = function(tooltip) {\n\n  var position = tooltip.position,\n      htmlContainer = tooltip.htmlContainer;\n\n  // update overlay html based on tooltip x, y\n\n  setPosition(htmlContainer, position.x, position.y);\n};\n\n\nTooltips.prototype._updateTooltipVisibilty = function(viewbox) {\n\n  (0,index_esm/* forEach */.Ed)(this._tooltips, function(tooltip) {\n    var show = tooltip.show,\n        htmlContainer = tooltip.htmlContainer,\n        visible = true;\n\n    if (show) {\n      if (show.minZoom > viewbox.scale ||\n          show.maxZoom < viewbox.scale) {\n        visible = false;\n      }\n\n      setVisible(htmlContainer, visible);\n    }\n  });\n};\n\nTooltips.prototype._init = function() {\n\n  var self = this;\n\n  // scroll/zoom integration\n\n  function updateViewbox(viewbox) {\n    self._updateRoot(viewbox);\n    self._updateTooltipVisibilty(viewbox);\n\n    self.show();\n  }\n\n  this._eventBus.on('canvas.viewbox.changing', function(event) {\n    self.hide();\n  });\n\n  this._eventBus.on('canvas.viewbox.changed', function(event) {\n    updateViewbox(event.viewbox);\n  });\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/tooltips/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const tooltips = ({\n  __init__: [ 'tooltips' ],\n  tooltips: [ 'type', Tooltips ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/features/tooltips/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/i18n/translate/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ i18n_translate)\n});\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/i18n/translate/translate.js\n/**\n * @typedef { {\n *   [key: string]: string;\n * } } TranslateReplacements\n */\n\n/**\n * A simple translation stub to be used for multi-language support\n * in diagrams. Can be easily replaced with a more sophisticated\n * solution.\n *\n * @example\n *\n * ```javascript\n * // use it inside any diagram component by injecting `translate`.\n *\n * function MyService(translate) {\n *   alert(translate('HELLO {you}', { you: 'You!' }));\n * }\n * ```\n *\n * @param {string} template to interpolate\n * @param {TranslateReplacements} [replacements] a map with substitutes\n *\n * @return {string} the translated string\n */\nfunction translate(template, replacements) {\n\n  replacements = replacements || {};\n\n  return template.replace(/{([^}]+)}/g, function(_, key) {\n    return replacements[key] || '{' + key + '}';\n  });\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/i18n/translate/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const i18n_translate = ({\n  translate: [ 'value', translate ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/i18n/translate/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/layout/BaseLayouter.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ BaseLayouter)\n/* harmony export */ });\n/* harmony import */ var _LayoutUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n/**\n * @typedef {import('../core/Types').ElementLike} Element\n * @typedef {import('../core/Types').ConnectionLike} Connection\n *\n * @typedef {import('../util').Point} Point\n *\n * @typedef { {\n *   connectionStart?: Point;\n *   connectionEnd?: Point;\n *   source?: Element;\n *   target?: Element;\n * } } LayoutConnectionHints\n */\n\n\n\n\n/**\n * A base connection layouter implementation\n * that layouts the connection by directly connecting\n * mid(source) + mid(target).\n */\nfunction BaseLayouter() {}\n\n\n/**\n * Return the new layouted waypoints for the given connection.\n *\n * The connection passed is still unchanged; you may figure out about\n * the new connection start / end via the layout hints provided.\n *\n * @param {Connection} connection\n * @param {LayoutConnectionHints} [hints]\n *\n * @return {Point[]} The waypoints of the laid out connection.\n */\nBaseLayouter.prototype.layoutConnection = function(connection, hints) {\n\n  hints = hints || {};\n\n  return [\n    hints.connectionStart || (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getMid */ .wS)(hints.source || connection.source),\n    hints.connectionEnd || (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getMid */ .wS)(hints.target || connection.target)\n  ];\n};\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/layout/BaseLayouter.js?")},"./node_modules/diagram-js/lib/layout/CroppingConnectionDocking.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ CroppingConnectionDocking)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n/* harmony import */ var _LayoutUtil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n\n\n\n\n/**\n * @typedef {import('../core/ElementRegistry').default} ElementRegistry\n * @typedef {import('../core/GraphicsFactory').default} GraphicsFactory\n */\n\nfunction dockingToPoint(docking) {\n\n  // use the dockings actual point and\n  // retain the original docking\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .assign */ .f0)({ original: docking.point.original || docking.point }, docking.actual);\n}\n\n\n/**\n * A {@link ConnectionDocking} that crops connection waypoints based on\n * the path(s) of the connection source and target.\n *\n * @param {ElementRegistry} elementRegistry\n * @param {GraphicsFactory} graphicsFactory\n */\nfunction CroppingConnectionDocking(elementRegistry, graphicsFactory) {\n  this._elementRegistry = elementRegistry;\n  this._graphicsFactory = graphicsFactory;\n}\n\nCroppingConnectionDocking.$inject = [ 'elementRegistry', 'graphicsFactory' ];\n\n\n/**\n * @inheritDoc ConnectionDocking#getCroppedWaypoints\n */\nCroppingConnectionDocking.prototype.getCroppedWaypoints = function(connection, source, target) {\n\n  source = source || connection.source;\n  target = target || connection.target;\n\n  var sourceDocking = this.getDockingPoint(connection, source, true),\n      targetDocking = this.getDockingPoint(connection, target);\n\n  var croppedWaypoints = connection.waypoints.slice(sourceDocking.idx + 1, targetDocking.idx);\n\n  croppedWaypoints.unshift(dockingToPoint(sourceDocking));\n  croppedWaypoints.push(dockingToPoint(targetDocking));\n\n  return croppedWaypoints;\n};\n\n/**\n * Return the connection docking point on the specified shape\n *\n * @inheritDoc ConnectionDocking#getDockingPoint\n */\nCroppingConnectionDocking.prototype.getDockingPoint = function(connection, shape, dockStart) {\n\n  var waypoints = connection.waypoints,\n      dockingIdx,\n      dockingPoint,\n      croppedPoint;\n\n  dockingIdx = dockStart ? 0 : waypoints.length - 1;\n  dockingPoint = waypoints[dockingIdx];\n\n  croppedPoint = this._getIntersection(shape, connection, dockStart);\n\n  return {\n    point: dockingPoint,\n    actual: croppedPoint || dockingPoint,\n    idx: dockingIdx\n  };\n};\n\n\n// helpers //////////////////////\n\nCroppingConnectionDocking.prototype._getIntersection = function(shape, connection, takeFirst) {\n\n  var shapePath = this._getShapePath(shape),\n      connectionPath = this._getConnectionPath(connection);\n\n  return (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .getElementLineIntersection */ .Hz)(shapePath, connectionPath, takeFirst);\n};\n\nCroppingConnectionDocking.prototype._getConnectionPath = function(connection) {\n  return this._graphicsFactory.getConnectionPath(connection);\n};\n\nCroppingConnectionDocking.prototype._getShapePath = function(shape) {\n  return this._graphicsFactory.getShapePath(shape);\n};\n\nCroppingConnectionDocking.prototype._getGfx = function(element) {\n  return this._elementRegistry.getGraphics(element);\n};\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/layout/CroppingConnectionDocking.js?")},"./node_modules/diagram-js/lib/layout/LayoutUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Hz\": () => (/* binding */ getElementLineIntersection),\n/* harmony export */   \"JA\": () => (/* binding */ asTRBL),\n/* harmony export */   \"Re\": () => (/* binding */ filterRedundantWaypoints),\n/* harmony export */   \"T8\": () => (/* binding */ getOrientation),\n/* harmony export */   \"aR\": () => (/* binding */ roundBounds),\n/* harmony export */   \"ex\": () => (/* binding */ roundPoint),\n/* harmony export */   \"wS\": () => (/* binding */ getMid),\n/* harmony export */   \"z_\": () => (/* binding */ asBounds)\n/* harmony export */ });\n/* unused harmony exports getBoundsMid, getConnectionMid, getIntersections */\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n}\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var _util_Geometry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(\"./node_modules/diagram-js/lib/util/Geometry.js\");\n}\n/* harmony import */ var path_intersection__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/path-intersection/intersect.js\");\n/* harmony import */ var path_intersection__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(path_intersection__WEBPACK_IMPORTED_MODULE_0__);\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var _util_ModelUtil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/diagram-js/lib/util/ModelUtil.js\");\n}\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../core/Types').ElementLike} Element\n * @typedef {import('../core/Types').ConnectionLike} Connection\n *\n * @typedef {import('../util/Types').DirectionTRBL} DirectionTRBL\n * @typedef {import('../util/Types').Point} Point\n * @typedef {import('../util/Types').Rect} Rect\n * @typedef {import('../util/Types').RectTRBL} RectTRBL\n */\n\n/**\n * @param {Rect} bounds\n *\n * @returns {Rect}\n */\nfunction roundBounds(bounds) {\n  return {\n    x: Math.round(bounds.x),\n    y: Math.round(bounds.y),\n    width: Math.round(bounds.width),\n    height: Math.round(bounds.height)\n  };\n}\n\n/**\n * @param {Point} point\n *\n * @returns {Point}\n */\nfunction roundPoint(point) {\n\n  return {\n    x: Math.round(point.x),\n    y: Math.round(point.y)\n  };\n}\n\n\n/**\n * Convert the given bounds to a { top, left, bottom, right } descriptor.\n *\n * @param {Point|Rect} bounds\n *\n * @return {RectTRBL}\n */\nfunction asTRBL(bounds) {\n  return {\n    top: bounds.y,\n    right: bounds.x + (bounds.width || 0),\n    bottom: bounds.y + (bounds.height || 0),\n    left: bounds.x\n  };\n}\n\n\n/**\n * Convert a { top, left, bottom, right } to an objects bounds.\n *\n * @param {RectTRBL} trbl\n *\n * @return {Rect}\n */\nfunction asBounds(trbl) {\n  return {\n    x: trbl.left,\n    y: trbl.top,\n    width: trbl.right - trbl.left,\n    height: trbl.bottom - trbl.top\n  };\n}\n\n\n/**\n * Get the mid of the given bounds or point.\n *\n * @param {Point|Rect} bounds\n *\n * @return {Point}\n */\nfunction getBoundsMid(bounds) {\n  return roundPoint({\n    x: bounds.x + (bounds.width || 0) / 2,\n    y: bounds.y + (bounds.height || 0) / 2\n  });\n}\n\n\n/**\n * Get the mid of the given Connection.\n *\n * @param {Connection} connection\n *\n * @return {Point}\n */\nfunction getConnectionMid(connection) {\n  var waypoints = connection.waypoints;\n\n  // calculate total length and length of each segment\n  var parts = waypoints.reduce(function(parts, point, index) {\n\n    var lastPoint = waypoints[index - 1];\n\n    if (lastPoint) {\n      var lastPart = parts[parts.length - 1];\n\n      var startLength = lastPart && lastPart.endLength || 0;\n      var length = distance(lastPoint, point);\n\n      parts.push({\n        start: lastPoint,\n        end: point,\n        startLength: startLength,\n        endLength: startLength + length,\n        length: length\n      });\n    }\n\n    return parts;\n  }, []);\n\n  var totalLength = parts.reduce(function(length, part) {\n    return length + part.length;\n  }, 0);\n\n  // find which segement contains middle point\n  var midLength = totalLength / 2;\n\n  var i = 0;\n  var midSegment = parts[i];\n\n  while (midSegment.endLength < midLength) {\n    midSegment = parts[++i];\n  }\n\n  // calculate relative position on mid segment\n  var segmentProgress = (midLength - midSegment.startLength) / midSegment.length;\n\n  var midPoint = {\n    x: midSegment.start.x + (midSegment.end.x - midSegment.start.x) * segmentProgress,\n    y: midSegment.start.y + (midSegment.end.y - midSegment.start.y) * segmentProgress\n  };\n\n  return midPoint;\n}\n\n\n/**\n * Get the mid of the given Element.\n *\n * @param {Element} element\n *\n * @return {Point}\n */\nfunction getMid(element) {\n  if ((0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_1__/* .isConnection */ .Ho)(element)) {\n    return getConnectionMid(element);\n  }\n\n  return getBoundsMid(element);\n}\n\n// orientation utils //////////////////////\n\n/**\n * Get orientation of the given rectangle with respect to\n * the reference rectangle.\n *\n * A padding (positive or negative) may be passed to influence\n * horizontal / vertical orientation and intersection.\n *\n * @param {Rect} rect\n * @param {Rect} reference\n * @param {Point|number} padding\n *\n * @return {DirectionTRBL} the orientation; one of top, top-left, left, ..., bottom, right or intersect.\n */\nfunction getOrientation(rect, reference, padding) {\n\n  padding = padding || 0;\n\n  // make sure we can use an object, too\n  // for individual { x, y } padding\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .isObject */ .Kn)(padding)) {\n    padding = { x: padding, y: padding };\n  }\n\n\n  var rectOrientation = asTRBL(rect),\n      referenceOrientation = asTRBL(reference);\n\n  var top = rectOrientation.bottom + padding.y <= referenceOrientation.top,\n      right = rectOrientation.left - padding.x >= referenceOrientation.right,\n      bottom = rectOrientation.top - padding.y >= referenceOrientation.bottom,\n      left = rectOrientation.right + padding.x <= referenceOrientation.left;\n\n  var vertical = top ? 'top' : (bottom ? 'bottom' : null),\n      horizontal = left ? 'left' : (right ? 'right' : null);\n\n  if (horizontal && vertical) {\n    return vertical + '-' + horizontal;\n  } else {\n    return horizontal || vertical || 'intersect';\n  }\n}\n\n\n// intersection utils //////////////////////\n\n/**\n * Get intersection between an element and a line path.\n *\n * @param {string} elementPath\n * @param {string} linePath\n * @param {boolean} cropStart Whether to crop start or end.\n *\n * @return {Point}\n */\nfunction getElementLineIntersection(elementPath, linePath, cropStart) {\n\n  var intersections = getIntersections(elementPath, linePath);\n\n  // recognize intersections\n  // only one -> choose\n  // two close together -> choose first\n  // two or more distinct -> pull out appropriate one\n  // none -> ok (fallback to point itself)\n  if (intersections.length === 1) {\n    return roundPoint(intersections[0]);\n  } else if (intersections.length === 2 && (0,_util_Geometry__WEBPACK_IMPORTED_MODULE_3__/* .pointDistance */ .tW)(intersections[0], intersections[1]) < 1) {\n    return roundPoint(intersections[0]);\n  } else if (intersections.length > 1) {\n\n    // sort by intersections based on connection segment +\n    // distance from start\n    intersections = (0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .sortBy */ .MR)(intersections, function(i) {\n      var distance = Math.floor(i.t2 * 100) || 1;\n\n      distance = 100 - distance;\n\n      distance = (distance < 10 ? '0' : '') + distance;\n\n      // create a sort string that makes sure we sort\n      // line segment ASC + line segment position DESC (for cropStart)\n      // line segment ASC + line segment position ASC (for cropEnd)\n      return i.segment2 + '#' + distance;\n    });\n\n    return roundPoint(intersections[cropStart ? 0 : intersections.length - 1]);\n  }\n\n  return null;\n}\n\n\nfunction getIntersections(a, b) {\n  return path_intersection__WEBPACK_IMPORTED_MODULE_0___default()(a, b);\n}\n\n\nfunction filterRedundantWaypoints(waypoints) {\n\n  // alter copy of waypoints, not original\n  waypoints = waypoints.slice();\n\n  var idx = 0,\n      point,\n      previousPoint,\n      nextPoint;\n\n  while (waypoints[idx]) {\n    point = waypoints[idx];\n    previousPoint = waypoints[idx - 1];\n    nextPoint = waypoints[idx + 1];\n\n    if ((0,_util_Geometry__WEBPACK_IMPORTED_MODULE_3__/* .pointDistance */ .tW)(point, nextPoint) === 0 ||\n        (0,_util_Geometry__WEBPACK_IMPORTED_MODULE_3__/* .pointsOnLine */ .ZS)(previousPoint, nextPoint, point)) {\n\n      // remove point, if overlapping with {nextPoint}\n      // or on line with {previousPoint} -> {point} -> {nextPoint}\n      waypoints.splice(idx, 1);\n    } else {\n      idx++;\n    }\n  }\n\n  return waypoints;\n}\n\n// helpers //////////////////////\n\nfunction distance(a, b) {\n  return Math.sqrt(Math.pow(a.x - b.x, 2) + Math.pow(a.y - b.y, 2));\n}\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/layout/LayoutUtil.js?")},"./node_modules/diagram-js/lib/layout/ManhattanLayout.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Fb\": () => (/* binding */ withoutRedundantPoints),\n/* harmony export */   \"ju\": () => (/* binding */ repairConnection)\n/* harmony export */ });\n/* unused harmony exports connectPoints, connectRectangles, tryLayoutStraight */\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n}\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var _LayoutUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n}\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var _util_Geometry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(\"./node_modules/diagram-js/lib/util/Geometry.js\");\n}\n\n\n\n\n\n\n/**\n * @typedef {import('../util/Types').Point} Point\n * @typedef {import('../util/Types').Rect} Rect\n */\n\nvar MIN_SEGMENT_LENGTH = 20,\n    POINT_ORIENTATION_PADDING = 5;\n\nvar round = Math.round;\n\nvar INTERSECTION_THRESHOLD = 20,\n    ORIENTATION_THRESHOLD = {\n      'h:h': 20,\n      'v:v': 20,\n      'h:v': -10,\n      'v:h': -10\n    };\n\nfunction needsTurn(orientation, startDirection) {\n  return !{\n    t: /top/,\n    r: /right/,\n    b: /bottom/,\n    l: /left/,\n    h: /./,\n    v: /./\n  }[startDirection].test(orientation);\n}\n\nfunction canLayoutStraight(direction, targetOrientation) {\n  return {\n    t: /top/,\n    r: /right/,\n    b: /bottom/,\n    l: /left/,\n    h: /left|right/,\n    v: /top|bottom/\n  }[direction].test(targetOrientation);\n}\n\nfunction getSegmentBendpoints(a, b, directions) {\n  var orientation = (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getOrientation */ .T8)(b, a, POINT_ORIENTATION_PADDING);\n\n  var startDirection = directions.split(':')[0];\n\n  var xmid = round((b.x - a.x) / 2 + a.x),\n      ymid = round((b.y - a.y) / 2 + a.y);\n\n  var segmentEnd, segmentDirections;\n\n  var layoutStraight = canLayoutStraight(startDirection, orientation),\n      layoutHorizontal = /h|r|l/.test(startDirection),\n      layoutTurn = false;\n\n  var turnNextDirections = false;\n\n  if (layoutStraight) {\n    segmentEnd = layoutHorizontal ? { x: xmid, y: a.y } : { x: a.x, y: ymid };\n\n    segmentDirections = layoutHorizontal ? 'h:h' : 'v:v';\n  } else {\n    layoutTurn = needsTurn(orientation, startDirection);\n\n    segmentDirections = layoutHorizontal ? 'h:v' : 'v:h';\n\n    if (layoutTurn) {\n\n      if (layoutHorizontal) {\n        turnNextDirections = ymid === a.y;\n\n        segmentEnd = {\n          x: a.x + MIN_SEGMENT_LENGTH * (/l/.test(startDirection) ? -1 : 1),\n          y: turnNextDirections ? ymid + MIN_SEGMENT_LENGTH : ymid\n        };\n      } else {\n        turnNextDirections = xmid === a.x;\n\n        segmentEnd = {\n          x: turnNextDirections ? xmid + MIN_SEGMENT_LENGTH : xmid,\n          y: a.y + MIN_SEGMENT_LENGTH * (/t/.test(startDirection) ? -1 : 1)\n        };\n      }\n\n    } else {\n      segmentEnd = {\n        x: xmid,\n        y: ymid\n      };\n    }\n  }\n\n  return {\n    waypoints: getBendpoints(a, segmentEnd, segmentDirections).concat(segmentEnd),\n    directions:  segmentDirections,\n    turnNextDirections: turnNextDirections\n  };\n}\n\nfunction getStartSegment(a, b, directions) {\n  return getSegmentBendpoints(a, b, directions);\n}\n\nfunction getEndSegment(a, b, directions) {\n  var invertedSegment = getSegmentBendpoints(b, a, invertDirections(directions));\n\n  return {\n    waypoints: invertedSegment.waypoints.slice().reverse(),\n    directions: invertDirections(invertedSegment.directions),\n    turnNextDirections: invertedSegment.turnNextDirections\n  };\n}\n\nfunction getMidSegment(startSegment, endSegment) {\n\n  var startDirection = startSegment.directions.split(':')[1],\n      endDirection = endSegment.directions.split(':')[0];\n\n  if (startSegment.turnNextDirections) {\n    startDirection = startDirection == 'h' ? 'v' : 'h';\n  }\n\n  if (endSegment.turnNextDirections) {\n    endDirection = endDirection == 'h' ? 'v' : 'h';\n  }\n\n  var directions = startDirection + ':' + endDirection;\n\n  var bendpoints = getBendpoints(\n    startSegment.waypoints[startSegment.waypoints.length - 1],\n    endSegment.waypoints[0],\n    directions\n  );\n\n  return {\n    waypoints: bendpoints,\n    directions: directions\n  };\n}\n\nfunction invertDirections(directions) {\n  return directions.split(':').reverse().join(':');\n}\n\n/**\n * Handle simple layouts with maximum two bendpoints.\n */\nfunction getSimpleBendpoints(a, b, directions) {\n\n  var xmid = round((b.x - a.x) / 2 + a.x),\n      ymid = round((b.y - a.y) / 2 + a.y);\n\n  // one point, right or left from a\n  if (directions === 'h:v') {\n    return [ { x: b.x, y: a.y } ];\n  }\n\n  // one point, above or below a\n  if (directions === 'v:h') {\n    return [ { x: a.x, y: b.y } ];\n  }\n\n  // vertical segment between a and b\n  if (directions === 'h:h') {\n    return [\n      { x: xmid, y: a.y },\n      { x: xmid, y: b.y }\n    ];\n  }\n\n  // horizontal segment between a and b\n  if (directions === 'v:v') {\n    return [\n      { x: a.x, y: ymid },\n      { x: b.x, y: ymid }\n    ];\n  }\n\n  throw new Error('invalid directions: can only handle varians of [hv]:[hv]');\n}\n\n\n/**\n * Returns the mid points for a manhattan connection between two points.\n *\n * @example h:h (horizontal:horizontal)\n *\n * [a]----[x]\n *         |\n *        [x]----[b]\n *\n * @example h:v (horizontal:vertical)\n *\n * [a]----[x]\n *         |\n *        [b]\n *\n * @example h:r (horizontal:right)\n *\n * [a]----[x]\n *         |\n *    [b]-[x]\n *\n * @param {Point} a\n * @param {Point} b\n * @param {string} directions\n *\n * @return {Point[]}\n */\nfunction getBendpoints(a, b, directions) {\n  directions = directions || 'h:h';\n\n  if (!isValidDirections(directions)) {\n    throw new Error(\n      'unknown directions: <' + directions + '>: ' +\n      'must be specified as <start>:<end> ' +\n      'with start/end in { h,v,t,r,b,l }'\n    );\n  }\n\n  // compute explicit directions, involving trbl dockings\n  // using a three segmented layouting algorithm\n  if (isExplicitDirections(directions)) {\n    var startSegment = getStartSegment(a, b, directions),\n        endSegment = getEndSegment(a, b, directions),\n        midSegment = getMidSegment(startSegment, endSegment);\n\n    return [].concat(\n      startSegment.waypoints,\n      midSegment.waypoints,\n      endSegment.waypoints\n    );\n  }\n\n  // handle simple [hv]:[hv] cases that can be easily computed\n  return getSimpleBendpoints(a, b, directions);\n}\n\n/**\n * Create a connection between the two points according\n * to the manhattan layout (only horizontal and vertical) edges.\n *\n * @param {Point} a\n * @param {Point} b\n * @param {string} [directions='h:h'] Specifies manhattan directions for each\n * point as {direction}:{direction}. A direction for a point is either\n * `h` (horizontal) or `v` (vertical).\n *\n * @return {Point[]}\n */\nfunction connectPoints(a, b, directions) {\n\n  var points = getBendpoints(a, b, directions);\n\n  points.unshift(a);\n  points.push(b);\n\n  return withoutRedundantPoints(points);\n}\n\n\n/**\n * Connect two rectangles using a manhattan layouted connection.\n *\n * @param {Rect} source source rectangle\n * @param {Rect} target target rectangle\n * @param {Point} [start] source docking\n * @param {Point} [end] target docking\n * @param {Object} [hints]\n * @param {string} [hints.preserveDocking=source] preserve docking on selected side\n * @param {string[]} [hints.preferredLayouts]\n * @param {Point|boolean} [hints.connectionStart] whether the start changed\n * @param {Point|boolean} [hints.connectionEnd] whether the end changed\n *\n * @return {Point[]} connection points\n */\nfunction connectRectangles(source, target, start, end, hints) {\n\n  var preferredLayouts = hints && hints.preferredLayouts || [];\n\n  var preferredLayout = (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .without */ .zu)(preferredLayouts, 'straight')[0] || 'h:h';\n\n  var threshold = ORIENTATION_THRESHOLD[preferredLayout] || 0;\n\n  var orientation = (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getOrientation */ .T8)(source, target, threshold);\n\n  var directions = getDirections(orientation, preferredLayout);\n\n  start = start || (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getMid */ .wS)(source);\n  end = end || (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getMid */ .wS)(target);\n\n  var directionSplit = directions.split(':');\n\n  // compute actual docking points for start / end\n  // this ensures we properly layout only parts of the\n  // connection that lies in between the two rectangles\n  var startDocking = getDockingPoint(start, source, directionSplit[0], invertOrientation(orientation)),\n      endDocking = getDockingPoint(end, target, directionSplit[1], orientation);\n\n  return connectPoints(startDocking, endDocking, directions);\n}\n\n\n/**\n * Repair the connection between two rectangles, of which one has been updated.\n *\n * @param {Rect} source\n * @param {Rect} target\n * @param {Point} [start]\n * @param {Point} [end]\n * @param {Point[]} [waypoints]\n * @param {Object} [hints]\n * @param {string[]} [hints.preferredLayouts] The list of preferred layouts.\n * @param {boolean} [hints.connectionStart]\n * @param {boolean} [hints.connectionEnd]\n *\n * @return {Point[]} The waypoints of the repaired connection.\n */\nfunction repairConnection(source, target, start, end, waypoints, hints) {\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .kJ)(start)) {\n    waypoints = start;\n    hints = end;\n\n    start = (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getMid */ .wS)(source);\n    end = (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getMid */ .wS)(target);\n  }\n\n  hints = (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .assign */ .f0)({ preferredLayouts: [] }, hints);\n  waypoints = waypoints || [];\n\n  var preferredLayouts = hints.preferredLayouts,\n      preferStraight = preferredLayouts.indexOf('straight') !== -1,\n      repairedWaypoints;\n\n  // just layout non-existing or simple connections\n  // attempt to render straight lines, if required\n\n  // attempt to layout a straight line\n  repairedWaypoints = preferStraight && tryLayoutStraight(source, target, start, end, hints);\n\n  if (repairedWaypoints) {\n    return repairedWaypoints;\n  }\n\n  // try to layout from end\n  repairedWaypoints = hints.connectionEnd && tryRepairConnectionEnd(target, source, end, waypoints);\n\n  if (repairedWaypoints) {\n    return repairedWaypoints;\n  }\n\n  // try to layout from start\n  repairedWaypoints = hints.connectionStart && tryRepairConnectionStart(source, target, start, waypoints);\n\n  if (repairedWaypoints) {\n    return repairedWaypoints;\n  }\n\n  // or whether nothing seems to have changed\n  if (!hints.connectionStart && !hints.connectionEnd && waypoints && waypoints.length) {\n    return waypoints;\n  }\n\n  // simply reconnect if nothing else worked\n  return connectRectangles(source, target, start, end, hints);\n}\n\n\nfunction inRange(a, start, end) {\n  return a >= start && a <= end;\n}\n\nfunction isInRange(axis, a, b) {\n  var size = {\n    x: 'width',\n    y: 'height'\n  };\n\n  return inRange(a[axis], b[axis], b[axis] + b[size[axis]]);\n}\n\n/**\n * Lay out a straight connection.\n *\n * @param {Rect} source\n * @param {Rect} target\n * @param {Point} start\n * @param {Point} end\n * @param {Object} [hints]\n * @param {string} [hints.preserveDocking]\n *\n * @return {Point[]|null} The waypoints or null if layout isn't possible.\n */\nfunction tryLayoutStraight(source, target, start, end, hints) {\n  var axis = {},\n      primaryAxis,\n      orientation;\n\n  orientation = (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getOrientation */ .T8)(source, target);\n\n  // only layout a straight connection if shapes are\n  // horizontally or vertically aligned\n  if (!/^(top|bottom|left|right)$/.test(orientation)) {\n    return null;\n  }\n\n  if (/top|bottom/.test(orientation)) {\n    primaryAxis = 'x';\n  }\n\n  if (/left|right/.test(orientation)) {\n    primaryAxis = 'y';\n  }\n\n  if (hints.preserveDocking === 'target') {\n\n    if (!isInRange(primaryAxis, end, source)) {\n      return null;\n    }\n\n    axis[primaryAxis] = end[primaryAxis];\n\n    return [\n      {\n        x: axis.x !== undefined ? axis.x : start.x,\n        y: axis.y !== undefined ? axis.y : start.y,\n        original: {\n          x: axis.x !== undefined ? axis.x : start.x,\n          y: axis.y !== undefined ? axis.y : start.y\n        }\n      },\n      {\n        x: end.x,\n        y: end.y\n      }\n    ];\n\n  } else {\n\n    if (!isInRange(primaryAxis, start, target)) {\n      return null;\n    }\n\n    axis[primaryAxis] = start[primaryAxis];\n\n    return [\n      {\n        x: start.x,\n        y: start.y\n      },\n      {\n        x: axis.x !== undefined ? axis.x : end.x,\n        y: axis.y !== undefined ? axis.y : end.y,\n        original: {\n          x: axis.x !== undefined ? axis.x : end.x,\n          y: axis.y !== undefined ? axis.y : end.y\n        }\n      }\n    ];\n  }\n\n}\n\n/**\n * Repair a connection from start.\n *\n * @param {Rect} moved\n * @param {Rect} other\n * @param {Point} newDocking\n * @param {Point[]} points originalPoints from moved to other\n *\n * @return {Point[]|null} The waypoints of the repaired connection.\n */\nfunction tryRepairConnectionStart(moved, other, newDocking, points) {\n  return _tryRepairConnectionSide(moved, other, newDocking, points);\n}\n\n/**\n * Repair a connection from end.\n *\n * @param {Rect} moved\n * @param {Rect} other\n * @param {Point} newDocking\n * @param {Point[]} points originalPoints from moved to other\n *\n * @return {Point[]|null} The waypoints of the repaired connection.\n */\nfunction tryRepairConnectionEnd(moved, other, newDocking, points) {\n  var waypoints = points.slice().reverse();\n\n  waypoints = _tryRepairConnectionSide(moved, other, newDocking, waypoints);\n\n  return waypoints ? waypoints.reverse() : null;\n}\n\n/**\n * Repair a connection from one side that moved.\n *\n * @param {Rect} moved\n * @param {Rect} other\n * @param {Point} newDocking\n * @param {Point[]} points originalPoints from moved to other\n *\n * @return {Point[]} The waypoints of the repaired connection.\n */\nfunction _tryRepairConnectionSide(moved, other, newDocking, points) {\n\n  function needsRelayout(points) {\n    if (points.length < 3) {\n      return true;\n    }\n\n    if (points.length > 4) {\n      return false;\n    }\n\n    // relayout if two points overlap\n    // this is most likely due to\n    return !!(0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .find */ .sE)(points, function(p, idx) {\n      var q = points[idx - 1];\n\n      return q && (0,_util_Geometry__WEBPACK_IMPORTED_MODULE_2__/* .pointDistance */ .tW)(p, q) < 3;\n    });\n  }\n\n  function repairBendpoint(candidate, oldPeer, newPeer) {\n\n    var alignment = (0,_util_Geometry__WEBPACK_IMPORTED_MODULE_2__/* .pointsAligned */ .Or)(oldPeer, candidate);\n\n    switch (alignment) {\n    case 'v':\n\n      // repair horizontal alignment\n      return { x: newPeer.x, y: candidate.y };\n    case 'h':\n\n      // repair vertical alignment\n      return { x: candidate.x, y: newPeer.y };\n    }\n\n    return { x: candidate.x, y: candidate. y };\n  }\n\n  function removeOverlapping(points, a, b) {\n    var i;\n\n    for (i = points.length - 2; i !== 0; i--) {\n\n      // intersects (?) break, remove all bendpoints up to this one and relayout\n      if ((0,_util_Geometry__WEBPACK_IMPORTED_MODULE_2__/* .pointInRect */ .qr)(points[i], a, INTERSECTION_THRESHOLD) ||\n          (0,_util_Geometry__WEBPACK_IMPORTED_MODULE_2__/* .pointInRect */ .qr)(points[i], b, INTERSECTION_THRESHOLD)) {\n\n        // return sliced old connection\n        return points.slice(i);\n      }\n    }\n\n    return points;\n  }\n\n  // (0) only repair what has layoutable bendpoints\n\n  // (1) if only one bendpoint and on shape moved onto other shapes axis\n  //     (horizontally / vertically), relayout\n\n  if (needsRelayout(points)) {\n    return null;\n  }\n\n  var oldDocking = points[0],\n      newPoints = points.slice(),\n      slicedPoints;\n\n  // (2) repair only last line segment and only if it was layouted before\n\n  newPoints[0] = newDocking;\n  newPoints[1] = repairBendpoint(newPoints[1], oldDocking, newDocking);\n\n\n  // (3) if shape intersects with any bendpoint after repair,\n  //     remove all segments up to this bendpoint and repair from there\n  slicedPoints = removeOverlapping(newPoints, moved, other);\n\n  if (slicedPoints !== newPoints) {\n    newPoints = _tryRepairConnectionSide(moved, other, newDocking, slicedPoints);\n  }\n\n  // (4) do NOT repair if repaired bendpoints are aligned\n  if (newPoints && (0,_util_Geometry__WEBPACK_IMPORTED_MODULE_2__/* .pointsAligned */ .Or)(newPoints)) {\n    return null;\n  }\n\n  return newPoints;\n}\n\n\n/**\n * Returns the manhattan directions connecting two rectangles\n * with the given orientation.\n *\n * Will always return the default layout, if it is specific\n * regarding sides already (trbl).\n *\n * @example\n *\n * ```javascript\n * getDirections('top'); // -> 'v:v'\n * getDirections('intersect'); // -> 't:t'\n *\n * getDirections('top-right', 'v:h'); // -> 'v:h'\n * getDirections('top-right', 'h:h'); // -> 'h:h'\n * ```\n *\n * @param {string} orientation\n * @param {string} defaultLayout\n *\n * @return {string}\n */\nfunction getDirections(orientation, defaultLayout) {\n\n  // don't override specific trbl directions\n  if (isExplicitDirections(defaultLayout)) {\n    return defaultLayout;\n  }\n\n  switch (orientation) {\n  case 'intersect':\n    return 't:t';\n\n  case 'top':\n  case 'bottom':\n    return 'v:v';\n\n  case 'left':\n  case 'right':\n    return 'h:h';\n\n  // 'top-left'\n  // 'top-right'\n  // 'bottom-left'\n  // 'bottom-right'\n  default:\n    return defaultLayout;\n  }\n}\n\nfunction isValidDirections(directions) {\n  return directions && /^h|v|t|r|b|l:h|v|t|r|b|l$/.test(directions);\n}\n\nfunction isExplicitDirections(directions) {\n  return directions && /t|r|b|l/.test(directions);\n}\n\nfunction invertOrientation(orientation) {\n  return {\n    'top': 'bottom',\n    'bottom': 'top',\n    'left': 'right',\n    'right': 'left',\n    'top-left': 'bottom-right',\n    'bottom-right': 'top-left',\n    'top-right': 'bottom-left',\n    'bottom-left': 'top-right',\n  }[orientation];\n}\n\nfunction getDockingPoint(point, rectangle, dockingDirection, targetOrientation) {\n\n  // ensure we end up with a specific docking direction\n  // based on the targetOrientation, if <h|v> is being passed\n\n  if (dockingDirection === 'h') {\n    dockingDirection = /left/.test(targetOrientation) ? 'l' : 'r';\n  }\n\n  if (dockingDirection === 'v') {\n    dockingDirection = /top/.test(targetOrientation) ? 't' : 'b';\n  }\n\n  if (dockingDirection === 't') {\n    return { original: point, x: point.x, y: rectangle.y };\n  }\n\n  if (dockingDirection === 'r') {\n    return { original: point, x: rectangle.x + rectangle.width, y: point.y };\n  }\n\n  if (dockingDirection === 'b') {\n    return { original: point, x: point.x, y: rectangle.y + rectangle.height };\n  }\n\n  if (dockingDirection === 'l') {\n    return { original: point, x: rectangle.x, y: point.y };\n  }\n\n  throw new Error('unexpected dockingDirection: <' + dockingDirection + '>');\n}\n\n\n/**\n * Return list of waypoints with redundant ones filtered out.\n *\n * @example\n *\n * Original points:\n *\n *   [x] ----- [x] ------ [x]\n *                         |\n *                        [x] ----- [x] - [x]\n *\n * Filtered:\n *\n *   [x] ---------------- [x]\n *                         |\n *                        [x] ----------- [x]\n *\n * @param {Point[]} waypoints\n *\n * @return {Point[]}\n */\nfunction withoutRedundantPoints(waypoints) {\n  return waypoints.reduce(function(points, p, idx) {\n\n    var previous = points[points.length - 1],\n        next = waypoints[idx + 1];\n\n    if (!(0,_util_Geometry__WEBPACK_IMPORTED_MODULE_2__/* .pointsOnLine */ .ZS)(previous, next, p, 0)) {\n      points.push(p);\n    }\n\n    return points;\n  }, []);\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/layout/ManhattanLayout.js?")},"./node_modules/diagram-js/lib/model/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"U\": () => (/* binding */ create),\n/* harmony export */   \"g\": () => (/* binding */ isModelElement)\n/* harmony export */ });\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n}\n/* harmony import */ var inherits_browser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n/* harmony import */ var object_refs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/object-refs/index.js\");\n/* harmony import */ var object_refs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(object_refs__WEBPACK_IMPORTED_MODULE_0__);\n\n\n\n\n\nvar parentRefs = new (object_refs__WEBPACK_IMPORTED_MODULE_0___default())({ name: 'children', enumerable: true, collection: true }, { name: 'parent' }),\n    labelRefs = new (object_refs__WEBPACK_IMPORTED_MODULE_0___default())({ name: 'labels', enumerable: true, collection: true }, { name: 'labelTarget' }),\n    attacherRefs = new (object_refs__WEBPACK_IMPORTED_MODULE_0___default())({ name: 'attachers', collection: true }, { name: 'host' }),\n    outgoingRefs = new (object_refs__WEBPACK_IMPORTED_MODULE_0___default())({ name: 'outgoing', collection: true }, { name: 'source' }),\n    incomingRefs = new (object_refs__WEBPACK_IMPORTED_MODULE_0___default())({ name: 'incoming', collection: true }, { name: 'target' });\n\n/**\n * @typedef {import('./Types').Element} Element\n * @typedef {import('./Types').Shape} Shape\n * @typedef {import('./Types').Root} Root\n * @typedef {import('./Types').Label} Label\n * @typedef {import('./Types').Connection} Connection\n */\n\n/**\n * The basic graphical representation\n *\n * @class\n * @constructor\n */\nfunction ElementImpl() {\n\n  /**\n   * The object that backs up the shape\n   *\n   * @name Element#businessObject\n   * @type Object\n   */\n  Object.defineProperty(this, 'businessObject', {\n    writable: true\n  });\n\n\n  /**\n   * Single label support, will mapped to multi label array\n   *\n   * @name Element#label\n   * @type Object\n   */\n  Object.defineProperty(this, 'label', {\n    get: function() {\n      return this.labels[0];\n    },\n    set: function(newLabel) {\n\n      var label = this.label,\n          labels = this.labels;\n\n      if (!newLabel && label) {\n        labels.remove(label);\n      } else {\n        labels.add(newLabel, 0);\n      }\n    }\n  });\n\n  /**\n   * The parent shape\n   *\n   * @name Element#parent\n   * @type Shape\n   */\n  parentRefs.bind(this, 'parent');\n\n  /**\n   * The list of labels\n   *\n   * @name Element#labels\n   * @type Label\n   */\n  labelRefs.bind(this, 'labels');\n\n  /**\n   * The list of outgoing connections\n   *\n   * @name Element#outgoing\n   * @type Array<Connection>\n   */\n  outgoingRefs.bind(this, 'outgoing');\n\n  /**\n   * The list of incoming connections\n   *\n   * @name Element#incoming\n   * @type Array<Connection>\n   */\n  incomingRefs.bind(this, 'incoming');\n}\n\n\n/**\n * A graphical object\n *\n * @class\n * @constructor\n *\n * @extends ElementImpl\n */\nfunction ShapeImpl() {\n  ElementImpl.call(this);\n\n  /**\n   * Indicates frame shapes\n   *\n   * @name ShapeImpl#isFrame\n   * @type boolean\n   */\n\n  /**\n   * The list of children\n   *\n   * @name ShapeImpl#children\n   * @type Element[]\n   */\n  parentRefs.bind(this, 'children');\n\n  /**\n   * @name ShapeImpl#host\n   * @type Shape\n   */\n  attacherRefs.bind(this, 'host');\n\n  /**\n   * @name ShapeImpl#attachers\n   * @type Shape\n   */\n  attacherRefs.bind(this, 'attachers');\n}\n\n(0,inherits_browser__WEBPACK_IMPORTED_MODULE_1__/* [\"default\"] */ .Z)(ShapeImpl, ElementImpl);\n\n\n/**\n * A root graphical object\n *\n * @class\n * @constructor\n *\n * @extends ElementImpl\n */\nfunction RootImpl() {\n  ElementImpl.call(this);\n\n  /**\n   * The list of children\n   *\n   * @name RootImpl#children\n   * @type Element[]\n   */\n  parentRefs.bind(this, 'children');\n}\n\n(0,inherits_browser__WEBPACK_IMPORTED_MODULE_1__/* [\"default\"] */ .Z)(RootImpl, ShapeImpl);\n\n\n/**\n * A label for an element\n *\n * @class\n * @constructor\n *\n * @extends ShapeImpl\n */\nfunction LabelImpl() {\n  ShapeImpl.call(this);\n\n  /**\n   * The labeled element\n   *\n   * @name LabelImpl#labelTarget\n   * @type Element\n   */\n  labelRefs.bind(this, 'labelTarget');\n}\n\n(0,inherits_browser__WEBPACK_IMPORTED_MODULE_1__/* [\"default\"] */ .Z)(LabelImpl, ShapeImpl);\n\n\n/**\n * A connection between two elements\n *\n * @class\n * @constructor\n *\n * @extends ElementImpl\n */\nfunction ConnectionImpl() {\n  ElementImpl.call(this);\n\n  /**\n   * The element this connection originates from\n   *\n   * @name ConnectionImpl#source\n   * @type Element\n   */\n  outgoingRefs.bind(this, 'source');\n\n  /**\n   * The element this connection points to\n   *\n   * @name ConnectionImpl#target\n   * @type Element\n   */\n  incomingRefs.bind(this, 'target');\n}\n\n(0,inherits_browser__WEBPACK_IMPORTED_MODULE_1__/* [\"default\"] */ .Z)(ConnectionImpl, ElementImpl);\n\n\nvar types = {\n  connection: ConnectionImpl,\n  shape: ShapeImpl,\n  label: LabelImpl,\n  root: RootImpl\n};\n\n/**\n * Creates a root element.\n *\n * @overlord\n *\n * @example\n *\n * ```javascript\n * import * as Model from 'diagram-js/lib/model';\n *\n * const root = Model.create('root', {\n *   x: 100,\n *   y: 100,\n *   width: 100,\n *   height: 100\n * });\n * ```\n *\n * @param {'root'} type\n * @param {any} [attrs]\n *\n * @return {Root}\n */\n\n/**\n * Creates a connection.\n *\n * @overlord\n *\n * @example\n *\n * ```javascript\n * import * as Model from 'diagram-js/lib/model';\n *\n * const connection = Model.create('connection', {\n *   waypoints: [\n *     { x: 100, y: 100 },\n *     { x: 200, y: 100 }\n *   ]\n * });\n * ```\n *\n * @param {'connection'} type\n * @param {any} [attrs]\n *\n * @return {Connection}\n */\n\n/**\n * Creates a shape.\n *\n * @overlord\n *\n * @example\n *\n * ```javascript\n * import * as Model from 'diagram-js/lib/model';\n *\n * const shape = Model.create('shape', {\n *   x: 100,\n *   y: 100,\n *   width: 100,\n *   height: 100\n * });\n * ```\n *\n * @param {'shape'} type\n * @param {any} [attrs]\n *\n * @return {Shape}\n */\n\n/**\n * Creates a label.\n *\n * @example\n *\n * ```javascript\n * import * as Model from 'diagram-js/lib/model';\n *\n * const label = Model.create('label', {\n *   x: 100,\n *   y: 100,\n *   width: 100,\n *   height: 100,\n *   labelTarget: shape\n * });\n * ```\n *\n * @param {'label'} type\n * @param {Object} [attrs]\n *\n * @return {Label}\n */\nfunction create(type, attrs) {\n  var Type = types[type];\n  if (!Type) {\n    throw new Error('unknown type: <' + type + '>');\n  }\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .assign */ .f0)(new Type(), attrs);\n}\n\n/**\n * Checks whether an object is a model instance.\n *\n * @param {any} obj\n *\n * @return {boolean}\n */\nfunction isModelElement(obj) {\n  return obj instanceof ElementImpl;\n}\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/model/index.js?")},"./node_modules/diagram-js/lib/navigation/keyboard-move/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ keyboard_move)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/index.js + 1 modules\nvar keyboard = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/navigation/keyboard-move/KeyboardMove.js\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../features/keyboard/Keyboard').default} Keyboard\n */\n\nvar DEFAULT_CONFIG = {\n  moveSpeed: 50,\n  moveSpeedAccelerated: 200\n};\n\n\n/**\n * A feature that allows users to move the canvas using the keyboard.\n *\n * @param {Object} config\n * @param {number} [config.moveSpeed=50]\n * @param {number} [config.moveSpeedAccelerated=200]\n * @param {Keyboard} keyboard\n * @param {Canvas} canvas\n */\nfunction KeyboardMove(\n    config,\n    keyboard,\n    canvas\n) {\n\n  var self = this;\n\n  this._config = (0,index_esm/* assign */.f0)({}, DEFAULT_CONFIG, config || {});\n\n  keyboard.addListener(arrowsListener);\n\n\n  function arrowsListener(context) {\n\n    var event = context.keyEvent,\n        config = self._config;\n\n    if (!keyboard.isCmd(event)) {\n      return;\n    }\n\n    if (keyboard.isKey([\n      'ArrowLeft', 'Left',\n      'ArrowUp', 'Up',\n      'ArrowDown', 'Down',\n      'ArrowRight', 'Right'\n    ], event)) {\n\n      var speed = (\n        keyboard.isShift(event) ?\n          config.moveSpeedAccelerated :\n          config.moveSpeed\n      );\n\n      var direction;\n\n      switch (event.key) {\n      case 'ArrowLeft':\n      case 'Left':\n        direction = 'left';\n        break;\n      case 'ArrowUp':\n      case 'Up':\n        direction = 'up';\n        break;\n      case 'ArrowRight':\n      case 'Right':\n        direction = 'right';\n        break;\n      case 'ArrowDown':\n      case 'Down':\n        direction = 'down';\n        break;\n      }\n\n      self.moveCanvas({\n        speed: speed,\n        direction: direction\n      });\n\n      return true;\n    }\n  }\n\n  /**\n   * @param {{\n   *   direction: 'up' | 'down' | 'left' | 'right';\n   *   speed: number;\n   * }} options\n   */\n  this.moveCanvas = function(options) {\n\n    var dx = 0,\n        dy = 0,\n        speed = options.speed;\n\n    var actualSpeed = speed / Math.min(Math.sqrt(canvas.viewbox().scale), 1);\n\n    switch (options.direction) {\n    case 'left': // Left\n      dx = actualSpeed;\n      break;\n    case 'up': // Up\n      dy = actualSpeed;\n      break;\n    case 'right': // Right\n      dx = -actualSpeed;\n      break;\n    case 'down': // Down\n      dy = -actualSpeed;\n      break;\n    }\n\n    canvas.scroll({\n      dx: dx,\n      dy: dy\n    });\n  };\n\n}\n\n\nKeyboardMove.$inject = [\n  'config.keyboardMove',\n  'keyboard',\n  'canvas'\n];\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/navigation/keyboard-move/index.js\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const keyboard_move = ({\n  __depends__: [\n    keyboard/* default */.Z\n  ],\n  __init__: [ 'keyboardMove' ],\n  keyboardMove: [ 'type', KeyboardMove ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/navigation/keyboard-move/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/navigation/movecanvas/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ movecanvas)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Cursor.js\nvar Cursor = __webpack_require__(\"./node_modules/diagram-js/lib/util/Cursor.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/ClickTrap.js\nvar ClickTrap = __webpack_require__(\"./node_modules/diagram-js/lib/util/ClickTrap.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/PositionUtil.js\nvar PositionUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/PositionUtil.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Event.js\nvar Event = __webpack_require__(\"./node_modules/diagram-js/lib/util/Event.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/navigation/movecanvas/MoveCanvas.js\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n */\n\nvar THRESHOLD = 15;\n\n\n/**\n * Move the canvas via mouse.\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n */\nfunction MoveCanvas(eventBus, canvas) {\n\n  var context;\n\n\n  // listen for move on element mouse down;\n  // allow others to hook into the event before us though\n  // (dragging / element moving will do this)\n  eventBus.on('element.mousedown', 500, function(e) {\n    return handleStart(e.originalEvent);\n  });\n\n\n  function handleMove(event) {\n\n    var start = context.start,\n        button = context.button,\n        position = (0,Event/* toPoint */.jt)(event),\n        delta = (0,PositionUtil/* delta */.p)(position, start);\n\n    if (!context.dragging && MoveCanvas_length(delta) > THRESHOLD) {\n      context.dragging = true;\n\n      if (button === 0) {\n        (0,ClickTrap/* install */.N)(eventBus);\n      }\n\n      (0,Cursor/* set */.t8)('grab');\n    }\n\n    if (context.dragging) {\n\n      var lastPosition = context.last || context.start;\n\n      delta = (0,PositionUtil/* delta */.p)(position, lastPosition);\n\n      canvas.scroll({\n        dx: delta.x,\n        dy: delta.y\n      });\n\n      context.last = position;\n    }\n\n    // prevent select\n    event.preventDefault();\n  }\n\n\n  function handleEnd(event) {\n    index_esm/* event.unbind */.B.unbind(document, 'mousemove', handleMove);\n    index_esm/* event.unbind */.B.unbind(document, 'mouseup', handleEnd);\n\n    context = null;\n\n    (0,Cursor/* unset */.zN)();\n  }\n\n  function handleStart(event) {\n\n    // event is already handled by '.djs-draggable'\n    if ((0,index_esm/* closest */.oq)(event.target, '.djs-draggable')) {\n      return;\n    }\n\n    var button = event.button;\n\n    // reject right mouse button or modifier key\n    if (button >= 2 || event.ctrlKey || event.shiftKey || event.altKey) {\n      return;\n    }\n\n    context = {\n      button: button,\n      start: (0,Event/* toPoint */.jt)(event)\n    };\n\n    index_esm/* event.bind */.B.bind(document, 'mousemove', handleMove);\n    index_esm/* event.bind */.B.bind(document, 'mouseup', handleEnd);\n\n    // we've handled the event\n    return true;\n  }\n\n  this.isActive = function() {\n    return !!context;\n  };\n\n}\n\n\nMoveCanvas.$inject = [\n  'eventBus',\n  'canvas'\n];\n\n\n\n// helpers ///////\n\nfunction MoveCanvas_length(point) {\n  return Math.sqrt(Math.pow(point.x, 2) + Math.pow(point.y, 2));\n}\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/navigation/movecanvas/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const movecanvas = ({\n  __init__: [ 'moveCanvas' ],\n  moveCanvas: [ 'type', MoveCanvas ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/navigation/movecanvas/index.js_+_1_modules?")},"./node_modules/diagram-js/lib/navigation/touch/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ navigation_touch)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/interaction-events/index.js + 1 modules\nvar interaction_events = __webpack_require__(\"./node_modules/diagram-js/lib/features/interaction-events/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/hammerjs/hammer.js\nvar hammer = __webpack_require__(\"./node_modules/hammerjs/hammer.js\");\nvar hammer_default = /*#__PURE__*/__webpack_require__.n(hammer);\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Event.js\nvar Event = __webpack_require__(\"./node_modules/diagram-js/lib/util/Event.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/touch/TouchInteractionEvents.js\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('didi').Injector} Injector\n *\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/ElementRegistry').default} ElementRegistry\n * @typedef {import('../../core/EventBus').default} EventBus\n * @typedef {import('../interaction-events/InteractionEvents').default} InteractionEvents\n */\n\nvar MIN_ZOOM = 0.2,\n    MAX_ZOOM = 4;\n\nvar mouseEvents = [\n  'mousedown',\n  'mouseup',\n  'mouseover',\n  'mouseout',\n  'click',\n  'dblclick'\n];\n\nfunction log() {\n\n  // console.log.apply(console, arguments);\n}\n\nfunction get(service, injector) {\n  return injector.get(service, false);\n}\n\nfunction stopEvent(event) {\n\n  event.preventDefault();\n\n  if (typeof event.stopPropagation === 'function') {\n    event.stopPropagation();\n  } else if (event.srcEvent && typeof event.srcEvent.stopPropagation === 'function') {\n\n    // iPhone & iPad\n    event.srcEvent.stopPropagation();\n  }\n\n  if (typeof event.stopImmediatePropagation === 'function') {\n    event.stopImmediatePropagation();\n  }\n}\n\n\nfunction createTouchRecognizer(node) {\n\n  function stopMouse(event) {\n\n    (0,index_esm/* forEach */.Ed)(mouseEvents, function(e) {\n      dist_index_esm/* event.bind */.B.bind(node, e, stopEvent, true);\n    });\n  }\n\n  function allowMouse(event) {\n    setTimeout(function() {\n      (0,index_esm/* forEach */.Ed)(mouseEvents, function(e) {\n        dist_index_esm/* event.unbind */.B.unbind(node, e, stopEvent, true);\n      });\n    }, 500);\n  }\n\n  dist_index_esm/* event.bind */.B.bind(node, 'touchstart', stopMouse, true);\n  dist_index_esm/* event.bind */.B.bind(node, 'touchend', allowMouse, true);\n  dist_index_esm/* event.bind */.B.bind(node, 'touchcancel', allowMouse, true);\n\n  // A touch event recognizer that handles\n  // touch events only (we know, we can already handle\n  // mouse events out of the box)\n\n  var recognizer = new (hammer_default()).Manager(node, {\n    inputClass: (hammer_default()).TouchInput,\n    recognizers: [],\n    domEvents: true\n  });\n\n\n  var tap = new (hammer_default()).Tap();\n  var pan = new (hammer_default()).Pan({ threshold: 10 });\n  var press = new (hammer_default()).Press();\n  var pinch = new (hammer_default()).Pinch();\n\n  var doubleTap = new (hammer_default()).Tap({ event: 'doubletap', taps: 2 });\n\n  pinch.requireFailure(pan);\n  pinch.requireFailure(press);\n\n  recognizer.add([ pan, press, pinch, doubleTap, tap ]);\n\n  recognizer.reset = function(force) {\n    var recognizers = this.recognizers,\n        session = this.session;\n\n    if (session.stopped) {\n      return;\n    }\n\n    log('recognizer', 'stop');\n\n    recognizer.stop(force);\n\n    setTimeout(function() {\n      var i, r;\n\n      log('recognizer', 'reset');\n      for (i = 0; (r = recognizers[i]); i++) {\n        r.reset();\n        r.state = 8; // FAILED STATE\n      }\n\n      session.curRecognizer = null;\n    }, 0);\n  };\n\n  recognizer.on('hammer.input', function(event) {\n    if (event.srcEvent.defaultPrevented) {\n      recognizer.reset(true);\n    }\n  });\n\n  return recognizer;\n}\n\n/**\n * A plugin that provides touch events for elements.\n *\n * @param {Injector} injector\n * @param {Canvas} canvas\n * @param {EventBus} eventBus\n * @param {ElementRegistry} elementRegistry\n * @param {InteractionEvents} interactionEvents\n */\nfunction TouchInteractionEvents(\n    injector, canvas, eventBus,\n    elementRegistry, interactionEvents) {\n\n  // optional integrations\n  var dragging = get('dragging', injector),\n      move = get('move', injector),\n      contextPad = get('contextPad', injector),\n      palette = get('palette', injector);\n\n  // the touch recognizer\n  var recognizer;\n\n  function handler(type, buttonType) {\n\n    return function(event) {\n      log('element', type, event);\n\n      var gfx = getGfx(event.target),\n          element = gfx && elementRegistry.get(gfx);\n\n      // translate into an actual mouse click event\n      if (buttonType) {\n        event.srcEvent.button = buttonType;\n      }\n\n      return interactionEvents.fire(type, event, element);\n    };\n  }\n\n\n  function getGfx(target) {\n    var node = (0,dist_index_esm/* closest */.oq)(target, 'svg, .djs-element', true);\n    return node;\n  }\n\n  function initEvents(svg) {\n\n    // touch recognizer\n    recognizer = createTouchRecognizer(svg);\n\n    function startGrabCanvas(event) {\n\n      log('canvas', 'grab start');\n\n      var lx = 0, ly = 0;\n\n      function update(e) {\n\n        var dx = e.deltaX - lx,\n            dy = e.deltaY - ly;\n\n        canvas.scroll({ dx: dx, dy: dy });\n\n        lx = e.deltaX;\n        ly = e.deltaY;\n      }\n\n      function end(e) {\n        recognizer.off('panmove', update);\n        recognizer.off('panend', end);\n        recognizer.off('pancancel', end);\n\n        log('canvas', 'grab end');\n      }\n\n      recognizer.on('panmove', update);\n      recognizer.on('panend', end);\n      recognizer.on('pancancel', end);\n    }\n\n    function startGrab(event) {\n\n      var gfx = getGfx(event.target),\n          element = gfx && elementRegistry.get(gfx);\n\n      // recognizer\n      if (move && canvas.getRootElement() !== element) {\n        log('element', 'move start', element, event, true);\n        return move.start(event, element, true);\n      } else {\n        startGrabCanvas(event);\n      }\n    }\n\n    function startZoom(e) {\n\n      log('canvas', 'zoom start');\n\n      var zoom = canvas.zoom(),\n          mid = e.center;\n\n      function update(e) {\n\n        var ratio = 1 - (1 - e.scale) / 1.50,\n            newZoom = Math.max(MIN_ZOOM, Math.min(MAX_ZOOM, ratio * zoom));\n\n        canvas.zoom(newZoom, mid);\n\n        stopEvent(e);\n      }\n\n      function end(e) {\n        recognizer.off('pinchmove', update);\n        recognizer.off('pinchend', end);\n        recognizer.off('pinchcancel', end);\n\n        recognizer.reset(true);\n\n        log('canvas', 'zoom end');\n      }\n\n      recognizer.on('pinchmove', update);\n      recognizer.on('pinchend', end);\n      recognizer.on('pinchcancel', end);\n    }\n\n    recognizer.on('tap', handler('element.click'));\n    recognizer.on('doubletap', handler('element.dblclick', 1));\n\n    recognizer.on('panstart', startGrab);\n    recognizer.on('press', startGrab);\n\n    recognizer.on('pinchstart', startZoom);\n  }\n\n  if (dragging) {\n\n    // simulate hover during dragging\n    eventBus.on('drag.move', function(event) {\n\n      var originalEvent = event.originalEvent;\n\n      if (!originalEvent || originalEvent instanceof MouseEvent) {\n        return;\n      }\n\n      var position = (0,Event/* toPoint */.jt)(originalEvent);\n\n      // this gets really expensive ...\n      var node = document.elementFromPoint(position.x, position.y),\n          gfx = getGfx(node),\n          element = gfx && elementRegistry.get(gfx);\n\n      if (element !== event.hover) {\n        if (event.hover) {\n          dragging.out(event);\n        }\n\n        if (element) {\n          dragging.hover({ element: element, gfx: gfx });\n\n          event.hover = element;\n          event.hoverGfx = gfx;\n        }\n      }\n    });\n  }\n\n  if (contextPad) {\n\n    eventBus.on('contextPad.create', function(event) {\n      var node = event.pad.html;\n\n      // touch recognizer\n      var padRecognizer = createTouchRecognizer(node);\n\n      padRecognizer.on('panstart', function(event) {\n        log('context-pad', 'panstart', event);\n        contextPad.trigger('dragstart', event, true);\n      });\n\n      padRecognizer.on('press', function(event) {\n        log('context-pad', 'press', event);\n        contextPad.trigger('dragstart', event, true);\n      });\n\n      padRecognizer.on('tap', function(event) {\n        log('context-pad', 'tap', event);\n        contextPad.trigger('click', event);\n      });\n    });\n  }\n\n  if (palette) {\n    eventBus.on('palette.create', function(event) {\n      var node = event.container;\n\n      // touch recognizer\n      var padRecognizer = createTouchRecognizer(node);\n\n      padRecognizer.on('panstart', function(event) {\n        log('palette', 'panstart', event);\n        palette.trigger('dragstart', event, true);\n      });\n\n      padRecognizer.on('press', function(event) {\n        log('palette', 'press', event);\n        palette.trigger('dragstart', event, true);\n      });\n\n      padRecognizer.on('tap', function(event) {\n        log('palette', 'tap', event);\n        palette.trigger('click', event);\n      });\n    });\n  }\n\n  eventBus.on('canvas.init', function(event) {\n    initEvents(event.svg);\n  });\n}\n\n\nTouchInteractionEvents.$inject = [\n  'injector',\n  'canvas',\n  'eventBus',\n  'elementRegistry',\n  'interactionEvents',\n  'touchFix'\n];\n\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar tiny_svg_dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/touch/TouchFix.js\n\n\n/**\n * @typedef {import('../../core/EventBus').default} EventBus\n */\n\n/**\n * @param {EventBus} eventBus\n */\nfunction TouchFix(eventBus) {\n\n  var self = this;\n\n  eventBus.on('canvas.init', function(e) {\n    self.addBBoxMarker(e.svg);\n  });\n}\n\nTouchFix.$inject = [ 'eventBus' ];\n\n\n/**\n * Safari mobile (iOS 7) does not fire touchstart event in <SVG> element\n * if there is no shape between 0,0 and viewport elements origin.\n *\n * So touchstart event is only fired when the <g class=\"viewport\"> element was hit.\n * Putting an element over and below the 'viewport' fixes that behavior.\n *\n * @param {SVGElement} svg\n */\nTouchFix.prototype.addBBoxMarker = function(svg) {\n\n  var markerStyle = {\n    fill: 'none',\n    class: 'outer-bound-marker'\n  };\n\n  var rect1 = (0,tiny_svg_dist_index_esm/* create */.Ue)('rect');\n  (0,tiny_svg_dist_index_esm/* attr */.Lj)(rect1, {\n    x: -10000,\n    y: 10000,\n    width: 10,\n    height: 10\n  });\n  (0,tiny_svg_dist_index_esm/* attr */.Lj)(rect1, markerStyle);\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(svg, rect1);\n\n  var rect2 = (0,tiny_svg_dist_index_esm/* create */.Ue)('rect');\n  (0,tiny_svg_dist_index_esm/* attr */.Lj)(rect2, {\n    x: 10000,\n    y: 10000,\n    width: 10,\n    height: 10\n  });\n  (0,tiny_svg_dist_index_esm/* attr */.Lj)(rect2, markerStyle);\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(svg, rect2);\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/touch/index.js\n\n\n\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const touch = ({\n  __depends__: [ interaction_events/* default */.Z ],\n  __init__: [ 'touchInteractionEvents' ],\n  touchInteractionEvents: [ 'type', TouchInteractionEvents ],\n  touchFix: [ 'type', TouchFix ]\n});\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/navigation/touch/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const navigation_touch = ({\n  __depends__: [\n    touch\n  ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/navigation/touch/index.js_+_3_modules?")},"./node_modules/diagram-js/lib/navigation/zoomscroll/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ zoomscroll)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Math.js\nvar util_Math = __webpack_require__(\"./node_modules/diagram-js/lib/util/Math.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/navigation/zoomscroll/ZoomUtil.js\n\n\n/**\n * Get step size for given range and number of steps.\n *\n * @param {Object} range\n * @param {number} range.min\n * @param {number} range.max\n * @param {number} steps\n */\nfunction getStepSize(range, steps) {\n\n  var minLinearRange = (0,util_Math/* log10 */.m)(range.min),\n      maxLinearRange = (0,util_Math/* log10 */.m)(range.max);\n\n  var absoluteLinearRange = Math.abs(minLinearRange) + Math.abs(maxLinearRange);\n\n  return absoluteLinearRange / steps;\n}\n\n/**\n * @param {Object} range\n * @param {number} range.min\n * @param {number} range.max\n * @param {number} scale\n */\nfunction cap(range, scale) {\n  return Math.max(range.min, Math.min(range.max, scale));\n}\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/navigation/zoomscroll/ZoomScroll.js\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('../../core/Canvas').default} Canvas\n * @typedef {import('../../core/EventBus').default} EventBus\n *\n * @typedef {import('../../util/Types').Point} Point\n */\n\nvar sign = Math.sign || function(n) {\n  return n >= 0 ? 1 : -1;\n};\n\nvar RANGE = { min: 0.2, max: 4 },\n    NUM_STEPS = 10;\n\nvar DELTA_THRESHOLD = 0.1;\n\nvar DEFAULT_SCALE = 0.75;\n\n/**\n * An implementation of zooming and scrolling within the\n * {@link Canvas} via the mouse wheel.\n *\n * Mouse wheel zooming / scrolling may be disabled using\n * the {@link toggle(enabled)} method.\n *\n * @param {Object} [config]\n * @param {boolean} [config.enabled=true] default enabled state\n * @param {number} [config.scale=.75] scroll sensivity\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n */\nfunction ZoomScroll(config, eventBus, canvas) {\n\n  config = config || {};\n\n  this._enabled = false;\n\n  this._canvas = canvas;\n  this._container = canvas._container;\n\n  this._handleWheel = (0,dist_index_esm/* bind */.ak)(this._handleWheel, this);\n\n  this._totalDelta = 0;\n  this._scale = config.scale || DEFAULT_SCALE;\n\n  var self = this;\n\n  eventBus.on('canvas.init', function(e) {\n    self._init(config.enabled !== false);\n  });\n}\n\nZoomScroll.$inject = [\n  'config.zoomScroll',\n  'eventBus',\n  'canvas'\n];\n\n/**\n * @param {Point} delta\n */\nZoomScroll.prototype.scroll = function scroll(delta) {\n  this._canvas.scroll(delta);\n};\n\n\nZoomScroll.prototype.reset = function reset() {\n  this._canvas.zoom('fit-viewport');\n};\n\n/**\n * Zoom depending on delta.\n *\n * @param {number} delta\n * @param {Point} position\n */\nZoomScroll.prototype.zoom = function zoom(delta, position) {\n\n  // zoom with half the step size of stepZoom\n  var stepSize = getStepSize(RANGE, NUM_STEPS * 2);\n\n  // add until threshold reached\n  this._totalDelta += delta;\n\n  if (Math.abs(this._totalDelta) > DELTA_THRESHOLD) {\n    this._zoom(delta, position, stepSize);\n\n    // reset\n    this._totalDelta = 0;\n  }\n};\n\n\nZoomScroll.prototype._handleWheel = function handleWheel(event) {\n\n  // event is already handled by '.djs-scrollable'\n  if ((0,index_esm/* closest */.oq)(event.target, '.djs-scrollable', true)) {\n    return;\n  }\n\n  var element = this._container;\n\n  event.preventDefault();\n\n  // pinch to zoom is mapped to wheel + ctrlKey = true\n  // in modern browsers (!)\n\n  var isZoom = event.ctrlKey;\n\n  var isHorizontalScroll = event.shiftKey;\n\n  var factor = -1 * this._scale,\n      delta;\n\n  if (isZoom) {\n    factor *= event.deltaMode === 0 ? 0.020 : 0.32;\n  } else {\n    factor *= event.deltaMode === 0 ? 1.0 : 16.0;\n  }\n\n  if (isZoom) {\n    var elementRect = element.getBoundingClientRect();\n\n    var offset = {\n      x: event.clientX - elementRect.left,\n      y: event.clientY - elementRect.top\n    };\n\n    delta = (\n      Math.sqrt(\n        Math.pow(event.deltaY, 2) +\n        Math.pow(event.deltaX, 2)\n      ) * sign(event.deltaY) * factor\n    );\n\n    // zoom in relative to diagram {x,y} coordinates\n    this.zoom(delta, offset);\n  } else {\n\n    if (isHorizontalScroll) {\n      delta = {\n        dx: factor * event.deltaY,\n        dy: 0\n      };\n    } else {\n      delta = {\n        dx: factor * event.deltaX,\n        dy: factor * event.deltaY\n      };\n    }\n\n    this.scroll(delta);\n  }\n};\n\n/**\n * Zoom with fixed step size.\n *\n * @param {number} delta Zoom delta (1 for zooming in, -1 for zooming out).\n * @param {Point} position\n */\nZoomScroll.prototype.stepZoom = function stepZoom(delta, position) {\n\n  var stepSize = getStepSize(RANGE, NUM_STEPS);\n\n  this._zoom(delta, position, stepSize);\n};\n\n\n/**\n * Zoom in/out given a step size.\n *\n * @param {number} delta\n * @param {Point} position\n * @param {number} stepSize\n */\nZoomScroll.prototype._zoom = function(delta, position, stepSize) {\n  var canvas = this._canvas;\n\n  var direction = delta > 0 ? 1 : -1;\n\n  var currentLinearZoomLevel = (0,util_Math/* log10 */.m)(canvas.zoom());\n\n  // snap to a proximate zoom step\n  var newLinearZoomLevel = Math.round(currentLinearZoomLevel / stepSize) * stepSize;\n\n  // increase or decrease one zoom step in the given direction\n  newLinearZoomLevel += stepSize * direction;\n\n  // calculate the absolute logarithmic zoom level based on the linear zoom level\n  // (e.g. 2 for an absolute x2 zoom)\n  var newLogZoomLevel = Math.pow(10, newLinearZoomLevel);\n\n  canvas.zoom(cap(RANGE, newLogZoomLevel), position);\n};\n\n\n/**\n * Toggle the zoom scroll ability via mouse wheel.\n *\n * @param {boolean} [newEnabled] new enabled state\n */\nZoomScroll.prototype.toggle = function toggle(newEnabled) {\n\n  var element = this._container;\n  var handleWheel = this._handleWheel;\n\n  var oldEnabled = this._enabled;\n\n  if (typeof newEnabled === 'undefined') {\n    newEnabled = !oldEnabled;\n  }\n\n  // only react on actual changes\n  if (oldEnabled !== newEnabled) {\n\n    // add or remove wheel listener based on\n    // changed enabled state\n    index_esm/* event */.B[newEnabled ? 'bind' : 'unbind'](element, 'wheel', handleWheel, false);\n  }\n\n  this._enabled = newEnabled;\n\n  return newEnabled;\n};\n\n\nZoomScroll.prototype._init = function(newEnabled) {\n  this.toggle(newEnabled);\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/navigation/zoomscroll/index.js\n\n\n\n/**\n * @type { import('didi').ModuleDeclaration }\n */\n/* harmony default export */ const zoomscroll = ({\n  __init__: [ 'zoomScroll' ],\n  zoomScroll: [ 'type', ZoomScroll ]\n});\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/navigation/zoomscroll/index.js_+_2_modules?")},"./node_modules/diagram-js/lib/util/AttachUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"r\": () => (/* binding */ getNewAttachPoint),\n/* harmony export */   \"s\": () => (/* binding */ getNewAttachShapeDelta)\n/* harmony export */ });\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var _layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n}\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var _PositionUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/lib/util/PositionUtil.js\");\n}\n\n\n\n\n/**\n * @typedef {import('../model/Types').Shape} Shape\n *\n * @typedef {import('../util/Types').Point} Point\n * @typedef {import('../util/Types').Rect} Rect\n */\n\n/**\n * Calculates the absolute point relative to the new element's position.\n *\n * @param {Point} point [absolute]\n * @param {Rect} oldBounds\n * @param {Rect} newBounds\n *\n * @return {Point} point [absolute]\n */\nfunction getNewAttachPoint(point, oldBounds, newBounds) {\n  var oldCenter = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .center */ .b)(oldBounds),\n      newCenter = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .center */ .b)(newBounds),\n      oldDelta = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .delta */ .p)(point, oldCenter);\n\n  var newDelta = {\n    x: oldDelta.x * (newBounds.width / oldBounds.width),\n    y: oldDelta.y * (newBounds.height / oldBounds.height)\n  };\n\n  return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .roundPoint */ .ex)({\n    x: newCenter.x + newDelta.x,\n    y: newCenter.y + newDelta.y\n  });\n}\n\n\n/**\n * Calculates the shape's delta relative to a new position\n * of a certain element's bounds.\n *\n * @param {Shape} shape\n * @param {Rect} oldBounds\n * @param {Rect} newBounds\n *\n * @return {Point} delta\n */\nfunction getNewAttachShapeDelta(shape, oldBounds, newBounds) {\n  var shapeCenter = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .center */ .b)(shape),\n      oldCenter = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .center */ .b)(oldBounds),\n      newCenter = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .center */ .b)(newBounds),\n      shapeDelta = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .delta */ .p)(shape, shapeCenter),\n      oldCenterDelta = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .delta */ .p)(shapeCenter, oldCenter),\n      stickyPositionDelta = getStickyPositionDelta(shapeCenter, oldBounds, newBounds);\n\n  if (stickyPositionDelta) {\n    return stickyPositionDelta;\n  }\n\n  var newCenterDelta = {\n    x: oldCenterDelta.x * (newBounds.width / oldBounds.width),\n    y: oldCenterDelta.y * (newBounds.height / oldBounds.height)\n  };\n\n  var newShapeCenter = {\n    x: newCenter.x + newCenterDelta.x,\n    y: newCenter.y + newCenterDelta.y\n  };\n\n  return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .roundPoint */ .ex)({\n    x: newShapeCenter.x + shapeDelta.x - shape.x,\n    y: newShapeCenter.y + shapeDelta.y - shape.y\n  });\n}\n\nfunction getStickyPositionDelta(oldShapeCenter, oldBounds, newBounds) {\n  var oldTRBL = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(oldBounds),\n      newTRBL = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(newBounds);\n\n  if (isMoved(oldTRBL, newTRBL)) {\n    return null;\n  }\n\n  var oldOrientation = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .getOrientation */ .T8)(oldBounds, oldShapeCenter),\n      stickyPositionDelta,\n      newShapeCenter,\n      newOrientation;\n\n  if (oldOrientation === 'top') {\n    stickyPositionDelta = {\n      x: 0,\n      y: newTRBL.bottom - oldTRBL.bottom\n    };\n  } else if (oldOrientation === 'bottom') {\n    stickyPositionDelta = {\n      x: 0,\n      y: newTRBL.top - oldTRBL.top\n    };\n  } else if (oldOrientation === 'right') {\n    stickyPositionDelta = {\n      x: newTRBL.left - oldTRBL.left,\n      y: 0\n    };\n  } else if (oldOrientation === 'left') {\n    stickyPositionDelta = {\n      x: newTRBL.right - oldTRBL.right,\n      y: 0\n    };\n  } else {\n\n    // fallback to proportional movement for corner-placed attachments\n    return null;\n  }\n\n  newShapeCenter = {\n    x: oldShapeCenter.x + stickyPositionDelta.x,\n    y: oldShapeCenter.y + stickyPositionDelta.y\n  };\n\n  newOrientation = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .getOrientation */ .T8)(newBounds, newShapeCenter);\n\n  if (newOrientation !== oldOrientation) {\n\n    // fallback to proportional movement if orientation would otherwise change\n    return null;\n  }\n\n  return stickyPositionDelta;\n}\n\nfunction isMoved(oldTRBL, newTRBL) {\n  return isHorizontallyMoved(oldTRBL, newTRBL) || isVerticallyMoved(oldTRBL, newTRBL);\n}\n\nfunction isHorizontallyMoved(oldTRBL, newTRBL) {\n  return oldTRBL.right !== newTRBL.right && oldTRBL.left !== newTRBL.left;\n}\n\nfunction isVerticallyMoved(oldTRBL, newTRBL) {\n  return oldTRBL.top !== newTRBL.top && oldTRBL.bottom !== newTRBL.bottom;\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/AttachUtil.js?")},"./node_modules/diagram-js/lib/util/ClickTrap.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"N\": () => (/* binding */ install)\n/* harmony export */ });\n/**\n * @typedef {import('../core/EventBus').EventBus} EventBus\n */\n\nvar TRAP_PRIORITY = 5000;\n\n/**\n * Installs a click trap that prevents a ghost click following a dragging operation.\n *\n * @param {EventBus} eventBus\n * @param {string} [eventName='element.click']\n *\n * @return {() => void} a function to immediately remove the installed trap.\n */\nfunction install(eventBus, eventName) {\n\n  eventName = eventName || 'element.click';\n\n  function trap() {\n    return false;\n  }\n\n  eventBus.once(eventName, TRAP_PRIORITY, trap);\n\n  return function() {\n    eventBus.off(eventName, trap);\n  };\n}\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/ClickTrap.js?")},"./node_modules/diagram-js/lib/util/Collections.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "IH": () => (/* binding */ add),\n/* harmony export */   "Od": () => (/* binding */ remove),\n/* harmony export */   "cq": () => (/* binding */ indexOf)\n/* harmony export */ });\n/**\n * Failsafe remove an element from a collection\n *\n * @param {Array<Object>} [collection]\n * @param {Object} [element]\n *\n * @return {number} the previous index of the element\n */\nfunction remove(collection, element) {\n\n  if (!collection || !element) {\n    return -1;\n  }\n\n  var idx = collection.indexOf(element);\n\n  if (idx !== -1) {\n    collection.splice(idx, 1);\n  }\n\n  return idx;\n}\n\n/**\n * Fail save add an element to the given connection, ensuring\n * it does not yet exist.\n *\n * @param {Array<Object>} collection\n * @param {Object} element\n * @param {number} [idx]\n */\nfunction add(collection, element, idx) {\n\n  if (!collection || !element) {\n    return;\n  }\n\n  if (typeof idx !== \'number\') {\n    idx = -1;\n  }\n\n  var currentIdx = collection.indexOf(element);\n\n  if (currentIdx !== -1) {\n\n    if (currentIdx === idx) {\n\n      // nothing to do, position has not changed\n      return;\n    } else {\n\n      if (idx !== -1) {\n\n        // remove from current position\n        collection.splice(currentIdx, 1);\n      } else {\n\n        // already exists in collection\n        return;\n      }\n    }\n  }\n\n  if (idx !== -1) {\n\n    // insert at specified position\n    collection.splice(idx, 0, element);\n  } else {\n\n    // push to end\n    collection.push(element);\n  }\n}\n\n\n/**\n * Fail save get the index of an element in a collection.\n *\n * @param {Array<Object>} collection\n * @param {Object} element\n *\n * @return {number} the index or -1 if collection or element do\n *                  not exist or the element is not contained.\n */\nfunction indexOf(collection, element) {\n\n  if (!collection || !element) {\n    return -1;\n  }\n\n  return collection.indexOf(element);\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/Collections.js?')},"./node_modules/diagram-js/lib/util/Cursor.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "t8": () => (/* binding */ set),\n/* harmony export */   "zN": () => (/* binding */ unset)\n/* harmony export */ });\n/* unused harmony export has */\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var min_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/min-dom/dist/index.esm.js");\n}\n\n\nvar CURSOR_CLS_PATTERN = /^djs-cursor-.*$/;\n\n/**\n * @param {string} mode\n */\nfunction set(mode) {\n  var classes = (0,min_dom__WEBPACK_IMPORTED_MODULE_0__/* .classes */ .Sh)(document.body);\n\n  classes.removeMatching(CURSOR_CLS_PATTERN);\n\n  if (mode) {\n    classes.add(\'djs-cursor-\' + mode);\n  }\n}\n\nfunction unset() {\n  set(null);\n}\n\n/**\n * @param {string} mode\n *\n * @return {boolean}\n */\nfunction has(mode) {\n  var classes = domClasses(document.body);\n\n  return classes.has(\'djs-cursor-\' + mode);\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/Cursor.js?')},"./node_modules/diagram-js/lib/util/Elements.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"He\": () => (/* binding */ isFrameElement),\n/* harmony export */   \"PB\": () => (/* binding */ selfAndAllChildren),\n/* harmony export */   \"RH\": () => (/* binding */ getEnclosedElements),\n/* harmony export */   \"cd\": () => (/* binding */ getParents),\n/* harmony export */   \"jY\": () => (/* binding */ getBBox),\n/* harmony export */   \"oL\": () => (/* binding */ getType),\n/* harmony export */   \"om\": () => (/* binding */ eachElement),\n/* harmony export */   \"vA\": () => (/* binding */ getClosure)\n/* harmony export */ });\n/* unused harmony exports add, selfAndChildren, selfAndDirectChildren */\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n}\n\n\n/**\n * @typedef {import('../model/Types').Connection} Connection\n * @typedef {import('../model/Types').Element} Element\n * @typedef {import('../model/Types').Shape} Shape\n *\n * @typedef {import('../../type/Types').Rect} Rect\n *\n * @typedef { {\n *   allShapes: Record<string, Shape>,\n *   allConnections: Record<string, Connection>,\n *   topLevel: Record<string, Element>,\n *   enclosedConnections: Record<string, Connection>,\n *   enclosedElements: Record<string, Element>\n * } } Closure\n */\n\n/**\n * Get parent elements.\n *\n * @param {Element[]} elements\n *\n * @return {Element[]}\n */\nfunction getParents(elements) {\n\n  // find elements that are not children of any other elements\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .filter */ .hX)(elements, function(element) {\n    return !(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .find */ .sE)(elements, function(e) {\n      return e !== element && getParent(element, e);\n    });\n  });\n}\n\n\nfunction getParent(element, parent) {\n  if (!parent) {\n    return;\n  }\n\n  if (element === parent) {\n    return parent;\n  }\n\n  if (!element.parent) {\n    return;\n  }\n\n  return getParent(element.parent, parent);\n}\n\n\n/**\n * Adds an element to a collection and returns true if the\n * element was added.\n *\n * @param {Object[]} elements\n * @param {Object} element\n * @param {boolean} [unique]\n */\nfunction add(elements, element, unique) {\n  var canAdd = !unique || elements.indexOf(element) === -1;\n\n  if (canAdd) {\n    elements.push(element);\n  }\n\n  return canAdd;\n}\n\n\n/**\n * Iterate over each element in a collection, calling the iterator function `fn`\n * with (element, index, recursionDepth).\n *\n * Recurse into all elements that are returned by `fn`.\n *\n * @param {Element|Element[]} elements\n * @param {(element: Element, index: number, depth: number) => Element[] | boolean | undefined} fn\n * @param {number} [depth] maximum recursion depth\n */\nfunction eachElement(elements, fn, depth) {\n\n  depth = depth || 0;\n\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .kJ)(elements)) {\n    elements = [ elements ];\n  }\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(elements, function(s, i) {\n    var filter = fn(s, i, depth);\n\n    if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .kJ)(filter) && filter.length) {\n      eachElement(filter, fn, depth + 1);\n    }\n  });\n}\n\n\n/**\n * Collects self + child elements up to a given depth from a list of elements.\n *\n * @param {Element|Element[]} elements the elements to select the children from\n * @param {boolean} unique whether to return a unique result set (no duplicates)\n * @param {number} maxDepth the depth to search through or -1 for infinite\n *\n * @return {Element[]} found elements\n */\nfunction selfAndChildren(elements, unique, maxDepth) {\n  var result = [],\n      processedChildren = [];\n\n  eachElement(elements, function(element, i, depth) {\n    add(result, element, unique);\n\n    var children = element.children;\n\n    // max traversal depth not reached yet\n    if (maxDepth === -1 || depth < maxDepth) {\n\n      // children exist && children not yet processed\n      if (children && add(processedChildren, children, unique)) {\n        return children;\n      }\n    }\n  });\n\n  return result;\n}\n\n/**\n * Return self + direct children for a number of elements\n *\n * @param {Element[]} elements to query\n * @param {boolean} [allowDuplicates] to allow duplicates in the result set\n *\n * @return {Element[]} the collected elements\n */\nfunction selfAndDirectChildren(elements, allowDuplicates) {\n  return selfAndChildren(elements, !allowDuplicates, 1);\n}\n\n\n/**\n * Return self + ALL children for a number of elements\n *\n * @param {Element[]} elements to query\n * @param {boolean} [allowDuplicates] to allow duplicates in the result set\n *\n * @return {Element[]} the collected elements\n */\nfunction selfAndAllChildren(elements, allowDuplicates) {\n  return selfAndChildren(elements, !allowDuplicates, -1);\n}\n\n\n/**\n * Gets the the closure for all selected elements,\n * their enclosed children and connections.\n *\n * @param {Element[]} elements\n * @param {boolean} [isTopLevel=true]\n * @param {Closure} [closure]\n *\n * @return {Closure} newClosure\n */\nfunction getClosure(elements, isTopLevel, closure) {\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isUndefined */ .o8)(isTopLevel)) {\n    isTopLevel = true;\n  }\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isObject */ .Kn)(isTopLevel)) {\n    closure = isTopLevel;\n    isTopLevel = true;\n  }\n\n\n  closure = closure || {};\n\n  var allShapes = copyObject(closure.allShapes),\n      allConnections = copyObject(closure.allConnections),\n      enclosedElements = copyObject(closure.enclosedElements),\n      enclosedConnections = copyObject(closure.enclosedConnections);\n\n  var topLevel = copyObject(\n    closure.topLevel,\n    isTopLevel && (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .groupBy */ .vM)(elements, function(e) { return e.id; })\n  );\n\n\n  function handleConnection(c) {\n    if (topLevel[c.source.id] && topLevel[c.target.id]) {\n      topLevel[c.id] = [ c ];\n    }\n\n    // not enclosed as a child, but maybe logically\n    // (connecting two moved elements?)\n    if (allShapes[c.source.id] && allShapes[c.target.id]) {\n      enclosedConnections[c.id] = enclosedElements[c.id] = c;\n    }\n\n    allConnections[c.id] = c;\n  }\n\n  function handleElement(element) {\n\n    enclosedElements[element.id] = element;\n\n    if (element.waypoints) {\n\n      // remember connection\n      enclosedConnections[element.id] = allConnections[element.id] = element;\n    } else {\n\n      // remember shape\n      allShapes[element.id] = element;\n\n      // remember all connections\n      (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(element.incoming, handleConnection);\n\n      (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(element.outgoing, handleConnection);\n\n      // recurse into children\n      return element.children;\n    }\n  }\n\n  eachElement(elements, handleElement);\n\n  return {\n    allShapes: allShapes,\n    allConnections: allConnections,\n    topLevel: topLevel,\n    enclosedConnections: enclosedConnections,\n    enclosedElements: enclosedElements\n  };\n}\n\n/**\n * Returns the surrounding bbox for all elements in\n * the array or the element primitive.\n *\n * @param {Element|Element[]} elements\n * @param {boolean} [stopRecursion=false]\n *\n * @return {Rect}\n */\nfunction getBBox(elements, stopRecursion) {\n\n  stopRecursion = !!stopRecursion;\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .kJ)(elements)) {\n    elements = [ elements ];\n  }\n\n  var minX,\n      minY,\n      maxX,\n      maxY;\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(elements, function(element) {\n\n    // If element is a connection the bbox must be computed first\n    var bbox = element;\n    if (element.waypoints && !stopRecursion) {\n      bbox = getBBox(element.waypoints, true);\n    }\n\n    var x = bbox.x,\n        y = bbox.y,\n        height = bbox.height || 0,\n        width = bbox.width || 0;\n\n    if (x < minX || minX === undefined) {\n      minX = x;\n    }\n    if (y < minY || minY === undefined) {\n      minY = y;\n    }\n\n    if ((x + width) > maxX || maxX === undefined) {\n      maxX = x + width;\n    }\n    if ((y + height) > maxY || maxY === undefined) {\n      maxY = y + height;\n    }\n  });\n\n  return {\n    x: minX,\n    y: minY,\n    height: maxY - minY,\n    width: maxX - minX\n  };\n}\n\n\n/**\n * Returns all elements that are enclosed from the bounding box.\n *\n *   * If bbox.(width|height) is not specified the method returns\n *     all elements with element.x/y > bbox.x/y\n *   * If only bbox.x or bbox.y is specified, method return all elements with\n *     e.x > bbox.x or e.y > bbox.y\n *\n * @param {Element[]} elements List of Elements to search through\n * @param {Rect} bbox the enclosing bbox.\n *\n * @return {Element[]} enclosed elements\n */\nfunction getEnclosedElements(elements, bbox) {\n\n  var filteredElements = {};\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(elements, function(element) {\n\n    var e = element;\n\n    if (e.waypoints) {\n      e = getBBox(e);\n    }\n\n    if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(bbox.y) && (e.x > bbox.x)) {\n      filteredElements[element.id] = element;\n    }\n    if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(bbox.x) && (e.y > bbox.y)) {\n      filteredElements[element.id] = element;\n    }\n    if (e.x > bbox.x && e.y > bbox.y) {\n      if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(bbox.width) && (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(bbox.height) &&\n          e.width + e.x < bbox.width + bbox.x &&\n          e.height + e.y < bbox.height + bbox.y) {\n\n        filteredElements[element.id] = element;\n      } else if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(bbox.width) || !(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(bbox.height)) {\n        filteredElements[element.id] = element;\n      }\n    }\n  });\n\n  return filteredElements;\n}\n\n/**\n * Get the element's type\n *\n * @param {Element} element\n *\n * @return {'connection' | 'shape' | 'root'}\n */\nfunction getType(element) {\n\n  if ('waypoints' in element) {\n    return 'connection';\n  }\n\n  if ('x' in element) {\n    return 'shape';\n  }\n\n  return 'root';\n}\n\n/**\n * @param {Element} element\n *\n * @return {boolean}\n */\nfunction isFrameElement(element) {\n  return !!(element && element.isFrame);\n}\n\n// helpers ///////////////////////////////\n\nfunction copyObject(src1, src2) {\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .assign */ .f0)({}, src1 || {}, src2 || {});\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/Elements.js?")},"./node_modules/diagram-js/lib/util/EscapeUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"D\": () => (/* binding */ escapeCSS),\n/* harmony export */   \"r\": () => (/* binding */ escapeHTML)\n/* harmony export */ });\n/**\n * @param {string} str\n *\n * @return {string}\n */\nfunction escapeCSS(str) {\n  return CSS.escape(str);\n}\n\nvar HTML_ESCAPE_MAP = {\n  '&': '&amp;',\n  '<': '&lt;',\n  '>': '&gt;',\n  '\"': '&quot;',\n  '\\'': '&#39;'\n};\n\n/**\n * @param {string} str\n *\n * @return {string}\n */\nfunction escapeHTML(str) {\n  str = '' + str;\n\n  return str && str.replace(/[&<>\"']/g, function(match) {\n    return HTML_ESCAPE_MAP[match];\n  });\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/EscapeUtil.js?")},"./node_modules/diagram-js/lib/util/Event.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Ku\": () => (/* binding */ getOriginal),\n/* harmony export */   \"UW\": () => (/* binding */ stopPropagation),\n/* harmony export */   \"jt\": () => (/* binding */ toPoint)\n/* harmony export */ });\n/**\n * @typedef {import('../util/Types').Point} Point\n */\n\nfunction __stopPropagation(event) {\n  if (!event || typeof event.stopPropagation !== 'function') {\n    return;\n  }\n\n  event.stopPropagation();\n}\n\n/**\n * @param {import('../core/EventBus').Event} event\n *\n * @return {Event}\n */\nfunction getOriginal(event) {\n  return event.originalEvent || event.srcEvent;\n}\n\n/**\n * @param {Event|import('../core/EventBus').Event} event\n */\nfunction stopPropagation(event) {\n  __stopPropagation(event);\n  __stopPropagation(getOriginal(event));\n}\n\n/**\n * @param {Event} event\n *\n * @return {Point|null}\n */\nfunction toPoint(event) {\n\n  if (event.pointers && event.pointers.length) {\n    event = event.pointers[0];\n  }\n\n  if (event.touches && event.touches.length) {\n    event = event.touches[0];\n  }\n\n  return event ? {\n    x: event.clientX,\n    y: event.clientY\n  } : null;\n}\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/Event.js?")},"./node_modules/diagram-js/lib/util/Geometry.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Or\": () => (/* binding */ pointsAligned),\n/* harmony export */   \"SO\": () => (/* binding */ getMidPoint),\n/* harmony export */   \"ZS\": () => (/* binding */ pointsOnLine),\n/* harmony export */   \"qr\": () => (/* binding */ pointInRect),\n/* harmony export */   \"tW\": () => (/* binding */ pointDistance)\n/* harmony export */ });\n/* unused harmony export pointsAlignedOnAxis */\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n}\n\n\n/**\n * @typedef {import('../util/Types').Axis} Axis\n * @typedef {import('../util/Types').Point} Point\n * @typedef {import('../util/Types').Rect} Rect\n */\n\n/**\n * Computes the distance between two points.\n *\n * @param {Point} a\n * @param {Point} b\n *\n * @return {number} The distance between the two points.\n */\nfunction pointDistance(a, b) {\n  if (!a || !b) {\n    return -1;\n  }\n\n  return Math.sqrt(\n    Math.pow(a.x - b.x, 2) +\n    Math.pow(a.y - b.y, 2)\n  );\n}\n\n\n/**\n * Returns true if the point r is on the line between p and q.\n *\n * @param {Point} p\n * @param {Point} q\n * @param {Point} r\n * @param {number} [accuracy=5] The accuracy with which to check (lower is better).\n *\n * @return {boolean}\n */\nfunction pointsOnLine(p, q, r, accuracy) {\n\n  if (typeof accuracy === 'undefined') {\n    accuracy = 5;\n  }\n\n  if (!p || !q || !r) {\n    return false;\n  }\n\n  var val = (q.x - p.x) * (r.y - p.y) - (q.y - p.y) * (r.x - p.x),\n      dist = pointDistance(p, q);\n\n  // @see http://stackoverflow.com/a/907491/412190\n  return Math.abs(val / dist) <= accuracy;\n}\n\n\nvar ALIGNED_THRESHOLD = 2;\n\n/**\n * Check whether two points are horizontally or vertically aligned.\n *\n * @param {Point[]|Point} a\n * @param {Point} [b]\n *\n * @return {string|boolean} If and how the two points are aligned ('h', 'v' or `false`).\n */\nfunction pointsAligned(a, b) {\n  var points = Array.from(arguments).flat();\n\n  const axisMap = {\n    'x': 'v',\n    'y': 'h'\n  };\n\n  for (const [ axis, orientation ] of Object.entries(axisMap)) {\n    if (pointsAlignedOnAxis(axis, points)) {\n      return orientation;\n    }\n  }\n\n  return false;\n}\n\n/**\n * @param {Axis} axis\n * @param {Point[]} points\n *\n * @return {boolean}\n */\nfunction pointsAlignedOnAxis(axis, points) {\n  const referencePoint = points[0];\n\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .every */ .yW)(points, function(point) {\n    return Math.abs(referencePoint[axis] - point[axis]) <= ALIGNED_THRESHOLD;\n  });\n}\n\n/**\n * Returns true if the point p is inside the rectangle rect\n *\n * @param {Point} p\n * @param {Rect} rect\n * @param {number} tolerance\n *\n * @return {boolean}\n */\nfunction pointInRect(p, rect, tolerance) {\n  tolerance = tolerance || 0;\n\n  return p.x > rect.x - tolerance &&\n         p.y > rect.y - tolerance &&\n         p.x < rect.x + rect.width + tolerance &&\n         p.y < rect.y + rect.height + tolerance;\n}\n\n/**\n * Returns a point in the middle of points p and q\n *\n * @param {Point} p\n * @param {Point} q\n *\n * @return {Point} The mid point between the two points.\n */\nfunction getMidPoint(p, q) {\n  return {\n    x: Math.round(p.x + ((q.x - p.x) / 2.0)),\n    y: Math.round(p.y + ((q.y - p.y) / 2.0))\n  };\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/Geometry.js?")},"./node_modules/diagram-js/lib/util/GraphicsUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "G": () => (/* binding */ getChildren),\n/* harmony export */   "s": () => (/* binding */ getVisual)\n/* harmony export */ });\n/**\n * SVGs for elements are generated by the {@link GraphicsFactory}.\n *\n * This utility gives quick access to the important semantic\n * parts of an element.\n */\n\n/**\n * Returns the visual part of a diagram element.\n *\n * @param {SVGElement} gfx\n *\n * @return {SVGElement}\n */\nfunction getVisual(gfx) {\n  return gfx.childNodes[0];\n}\n\n/**\n * Returns the children for a given diagram element.\n *\n * @param {SVGElement} gfx\n * @return {SVGElement}\n */\nfunction getChildren(gfx) {\n  return gfx.parentNode.childNodes[1];\n}\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/GraphicsUtil.js?')},"./node_modules/diagram-js/lib/util/IdGenerator.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ IdGenerator)\n/* harmony export */ });\n/**\n * Util that provides unique IDs.\n *\n * @class\n * @constructor\n *\n * The ids can be customized via a given prefix and contain a random value to avoid collisions.\n *\n * @param {string} [prefix] a prefix to prepend to generated ids (for better readability)\n */\nfunction IdGenerator(prefix) {\n\n  this._counter = 0;\n  this._prefix = (prefix ? prefix + '-' : '') + Math.floor(Math.random() * 1000000000) + '-';\n}\n\n/**\n * Returns a next unique ID.\n *\n * @return {string} the id\n */\nIdGenerator.prototype.next = function() {\n  return this._prefix + (++this._counter);\n};\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/IdGenerator.js?")},"./node_modules/diagram-js/lib/util/LineIntersection.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"t\": () => (/* binding */ getApproxIntersection)\n/* harmony export */ });\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var _Geometry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/diagram-js/lib/util/Geometry.js\");\n}\n/* harmony import */ var path_intersection__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/path-intersection/intersect.js\");\n/* harmony import */ var path_intersection__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(path_intersection__WEBPACK_IMPORTED_MODULE_0__);\n\n\n\n\n/**\n * @typedef {import('../util/Types').Point} Point\n *\n * @typedef { {\n *   bendpoint?: boolean;\n *   index: number;\n *   point: Point;\n * } } Intersection\n */\n\nvar round = Math.round,\n    max = Math.max;\n\n\nfunction circlePath(center, r) {\n  var x = center.x,\n      y = center.y;\n\n  return [\n    [ 'M', x, y ],\n    [ 'm', 0, -r ],\n    [ 'a', r, r, 0, 1, 1, 0, 2 * r ],\n    [ 'a', r, r, 0, 1, 1, 0, -2 * r ],\n    [ 'z' ]\n  ];\n}\n\nfunction linePath(points) {\n  var segments = [];\n\n  points.forEach(function(p, idx) {\n    segments.push([ idx === 0 ? 'M' : 'L', p.x, p.y ]);\n  });\n\n  return segments;\n}\n\n\nvar INTERSECTION_THRESHOLD = 10;\n\n/**\n * @param {Point[]} waypoints\n * @param {Point} reference\n *\n * @return {Intersection|null}\n */\nfunction getBendpointIntersection(waypoints, reference) {\n\n  var i, w;\n\n  for (i = 0; (w = waypoints[i]); i++) {\n\n    if ((0,_Geometry__WEBPACK_IMPORTED_MODULE_1__/* .pointDistance */ .tW)(w, reference) <= INTERSECTION_THRESHOLD) {\n      return {\n        point: waypoints[i],\n        bendpoint: true,\n        index: i\n      };\n    }\n  }\n\n  return null;\n}\n\n/**\n * @param {Point[]} waypoints\n * @param {Point} reference\n *\n * @return {Intersection|null}\n */\nfunction getPathIntersection(waypoints, reference) {\n\n  var intersections = path_intersection__WEBPACK_IMPORTED_MODULE_0___default()(circlePath(reference, INTERSECTION_THRESHOLD), linePath(waypoints));\n\n  var a = intersections[0],\n      b = intersections[intersections.length - 1],\n      idx;\n\n  if (!a) {\n\n    // no intersection\n    return null;\n  }\n\n  if (a !== b) {\n\n    if (a.segment2 !== b.segment2) {\n\n      // we use the bendpoint in between both segments\n      // as the intersection point\n\n      idx = max(a.segment2, b.segment2) - 1;\n\n      return {\n        point: waypoints[idx],\n        bendpoint: true,\n        index: idx\n      };\n    }\n\n    return {\n      point: {\n        x: (round(a.x + b.x) / 2),\n        y: (round(a.y + b.y) / 2)\n      },\n      index: a.segment2\n    };\n  }\n\n  return {\n    point: {\n      x: round(a.x),\n      y: round(a.y)\n    },\n    index: a.segment2\n  };\n}\n\n/**\n * Returns the closest point on the connection towards a given reference point.\n *\n * @param {Point[]} waypoints\n * @param {Point} reference\n *\n * @return {Intersection|null}\n */\nfunction getApproxIntersection(waypoints, reference) {\n  return getBendpointIntersection(waypoints, reference) || getPathIntersection(waypoints, reference);\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/LineIntersection.js?")},"./node_modules/diagram-js/lib/util/Math.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "m": () => (/* binding */ log10)\n/* harmony export */ });\n/**\n * Get the logarithm of x with base 10.\n *\n * @param {number} x\n */\nfunction log10(x) {\n  return Math.log(x) / Math.log(10);\n}\n\n\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/Math.js?')},"./node_modules/diagram-js/lib/util/ModelUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Ho": () => (/* binding */ isConnection),\n/* harmony export */   "j_": () => (/* binding */ isLabel)\n/* harmony export */ });\n/* unused harmony export isRoot */\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js");\n}\n\n\n/**\n * Checks whether a value is an instance of Connection.\n *\n * @param {any} value\n *\n * @return {boolean}\n */\nfunction isConnection(value) {\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isObject */ .Kn)(value) && (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .has */ .e$)(value, \'waypoints\');\n}\n\n/**\n * Checks whether a value is an instance of Label.\n *\n * @param {any} value\n *\n * @return {boolean}\n */\nfunction isLabel(value) {\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isObject */ .Kn)(value) && (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .has */ .e$)(value, \'labelTarget\');\n}\n\n/**\n * Checks whether a value is an instance of Root.\n *\n * @param {any} value\n *\n * @return {boolean}\n */\nfunction isRoot(value) {\n  return isObject(value) && isNil(value.parent);\n}\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/ModelUtil.js?')},"./node_modules/diagram-js/lib/util/Mouse.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Dw": () => (/* binding */ hasSecondaryModifier),\n/* harmony export */   "Id": () => (/* binding */ isPrimaryButton),\n/* harmony export */   "L7": () => (/* binding */ isAuxiliaryButton),\n/* harmony export */   "RJ": () => (/* binding */ hasPrimaryModifier)\n/* harmony export */ });\n/* unused harmony exports isButton, isSecondaryButton */\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var _Event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/diagram-js/lib/util/Event.js");\n}\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var _Platform__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/diagram-js/lib/util/Platform.js");\n}\n\n\n\n\n\n\n/**\n * @param {MouseEvent} event\n * @param {string} button\n *\n * @return {boolean}\n */\nfunction isButton(event, button) {\n  return ((0,_Event__WEBPACK_IMPORTED_MODULE_0__/* .getOriginal */ .Ku)(event) || event).button === button;\n}\n\n/**\n * @param {MouseEvent} event\n *\n * @return {boolean}\n */\nfunction isPrimaryButton(event) {\n\n  // button === 0 -> left áka primary mouse button\n  return isButton(event, 0);\n}\n\n/**\n * @param {MouseEvent} event\n *\n * @return {boolean}\n */\nfunction isAuxiliaryButton(event) {\n\n  // button === 1 -> auxiliary áka wheel button\n  return isButton(event, 1);\n}\n\n/**\n * @param {MouseEvent} event\n *\n * @return {boolean}\n */\nfunction isSecondaryButton(event) {\n\n  // button === 2 -> right áka secondary button\n  return isButton(event, 2);\n}\n\n/**\n * @param {MouseEvent} event\n *\n * @return {boolean}\n */\nfunction hasPrimaryModifier(event) {\n  var originalEvent = (0,_Event__WEBPACK_IMPORTED_MODULE_0__/* .getOriginal */ .Ku)(event) || event;\n\n  if (!isPrimaryButton(event)) {\n    return false;\n  }\n\n  // Use cmd as primary modifier key for mac OS\n  if ((0,_Platform__WEBPACK_IMPORTED_MODULE_1__/* .isMac */ .V)()) {\n    return originalEvent.metaKey;\n  } else {\n    return originalEvent.ctrlKey;\n  }\n}\n\n/**\n * @param {MouseEvent} event\n *\n * @return {boolean}\n */\nfunction hasSecondaryModifier(event) {\n  var originalEvent = (0,_Event__WEBPACK_IMPORTED_MODULE_0__/* .getOriginal */ .Ku)(event) || event;\n\n  return isPrimaryButton(event) && originalEvent.shiftKey;\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/Mouse.js?')},"./node_modules/diagram-js/lib/util/Platform.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "V": () => (/* binding */ isMac)\n/* harmony export */ });\nfunction isMac() {\n  return (/mac/i).test(navigator.platform);\n}\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/Platform.js?')},"./node_modules/diagram-js/lib/util/PositionUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"b\": () => (/* binding */ center),\n/* harmony export */   \"p\": () => (/* binding */ delta)\n/* harmony export */ });\n/**\n * @typedef {import('../util/Types').Point} Point\n * @typedef {import('../util/Types').Rect} Rect\n */\n\n/**\n * @param {Rect} bounds\n * @return {Point}\n */\nfunction center(bounds) {\n  return {\n    x: bounds.x + (bounds.width / 2),\n    y: bounds.y + (bounds.height / 2)\n  };\n}\n\n\n/**\n * @param {Point} a\n * @param {Point} b\n * @return {Point}\n */\nfunction delta(a, b) {\n  return {\n    x: a.x - b.x,\n    y: a.y - b.y\n  };\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/PositionUtil.js?")},"./node_modules/diagram-js/lib/util/Removal.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"r\": () => (/* binding */ saveClear)\n/* harmony export */ });\n/**\n * Remove from the beginning of a collection until it is empty.\n *\n * This is a null-safe operation that ensures elements\n * are being removed from the given collection until the\n * collection is empty.\n *\n * The implementation deals with the fact that a remove operation\n * may touch, i.e. remove multiple elements in the collection\n * at a time.\n *\n * @param {Object[]} [collection]\n * @param {(element: Object) => void} removeFn\n *\n * @return {Object[]} the cleared collection\n */\nfunction saveClear(collection, removeFn) {\n\n  if (typeof removeFn !== 'function') {\n    throw new Error('removeFn iterator must be a function');\n  }\n\n  if (!collection) {\n    return;\n  }\n\n  var e;\n\n  while ((e = collection[0])) {\n    removeFn(e);\n  }\n\n  return collection;\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/Removal.js?")},"./node_modules/diagram-js/lib/util/RenderUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"KO\": () => (/* binding */ componentsToPath),\n/* harmony export */   \"W5\": () => (/* binding */ createLine),\n/* harmony export */   \"cq\": () => (/* binding */ updateLine)\n/* harmony export */ });\n/* unused harmony export toSVGPoints */\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n}\nif (\"bpmnEntLanguageService\" == __webpack_require__.j) {\n\t/* harmony import */ var tiny_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n}\n\n\n\n\n\n/**\n * @typedef {(string|number)[]} Component\n *\n * @typedef {import('../util/Types').Point} Point\n */\n\n/**\n * @param {Component[] | Component[][]} elements\n *\n * @return {string}\n */\nfunction componentsToPath(elements) {\n  return elements.flat().join(',').replace(/,?([A-z]),?/g, '$1');\n}\n\n/**\n * @param {Point[]} points\n *\n * @return {string}\n */\nfunction toSVGPoints(points) {\n  var result = '';\n\n  for (var i = 0, p; (p = points[i]); i++) {\n    result += p.x + ',' + p.y + ' ';\n  }\n\n  return result;\n}\n\n/**\n * @param {Point} point\n *\n * @return {Component[]}\n */\nfunction move(point) {\n  return [ 'M', point.x, point.y ];\n}\n\n/**\n * @param {Point} point\n *\n * @return {Component[]}\n */\nfunction lineTo(point) {\n  return [ 'L', point.x, point.y ];\n}\n\n/**\n * @param {Point} p1\n * @param {Point} p2\n * @param {Point} p3\n *\n * @return {Component[]}\n */\nfunction curveTo(p1, p2, p3) {\n  return [ 'C', p1.x, p1.y, p2.x, p2.y, p3.x, p3.y ];\n}\n\n/**\n * @param {Point[]} waypoints\n * @param {number} [cornerRadius]\n * @return {Component[][]}\n */\nfunction drawPath(waypoints, cornerRadius) {\n  const pointCount = waypoints.length;\n\n  const path = [ move(waypoints[0]) ];\n\n  for (let i = 1; i < pointCount; i++) {\n\n    const pointBefore = waypoints[i - 1];\n    const point = waypoints[i];\n    const pointAfter = waypoints[i + 1];\n\n    if (!pointAfter || !cornerRadius) {\n      path.push(lineTo(point));\n\n      continue;\n    }\n\n    const effectiveRadius = Math.min(\n      cornerRadius,\n      vectorLength(point.x - pointBefore.x, point.y - pointBefore.y),\n      vectorLength(pointAfter.x - point.x, pointAfter.y - point.y)\n    );\n\n    if (!effectiveRadius) {\n      path.push(lineTo(point));\n\n      continue;\n    }\n\n    const beforePoint = getPointAtLength(point, pointBefore, effectiveRadius);\n    const beforePoint2 = getPointAtLength(point, pointBefore, effectiveRadius * .5);\n\n    const afterPoint = getPointAtLength(point, pointAfter, effectiveRadius);\n    const afterPoint2 = getPointAtLength(point, pointAfter, effectiveRadius * .5);\n\n    path.push(lineTo(beforePoint));\n    path.push(curveTo(beforePoint2, afterPoint2, afterPoint));\n  }\n\n  return path;\n}\n\nfunction getPointAtLength(start, end, length) {\n\n  const deltaX = end.x - start.x;\n  const deltaY = end.y - start.y;\n\n  const totalLength = vectorLength(deltaX, deltaY);\n\n  const percent = length / totalLength;\n\n  return {\n    x: start.x + deltaX * percent,\n    y: start.y + deltaY * percent\n  };\n}\n\nfunction vectorLength(x, y) {\n  return Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2));\n}\n\n/**\n * @param {Point[]} points\n * @param {number|Object} [attrs]\n * @param {number} [radius]\n *\n * @return {SVGElement}\n */\nfunction createLine(points, attrs, radius) {\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(attrs)) {\n    radius = attrs;\n    attrs = null;\n  }\n\n  if (!attrs) {\n    attrs = {};\n  }\n\n  const line = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .create */ .Ue)('path', attrs);\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(radius)) {\n    line.dataset.cornerRadius = String(radius);\n  }\n\n  return updateLine(line, points);\n}\n\n/**\n * @param {SVGElement} gfx\n * @param {Point[]} points\n *\n * @return {SVGElement}\n */\nfunction updateLine(gfx, points) {\n\n  const cornerRadius = parseInt(gfx.dataset.cornerRadius, 10) || 0;\n\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .Lj)(gfx, {\n    d: componentsToPath(drawPath(points, cornerRadius))\n  });\n\n  return gfx;\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/RenderUtil.js?")},"./node_modules/diagram-js/lib/util/SvgTransformUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Iu": () => (/* binding */ translate),\n/* harmony export */   "U1": () => (/* binding */ rotate),\n/* harmony export */   "vs": () => (/* binding */ transform)\n/* harmony export */ });\n/* unused harmony export scale */\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var tiny_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/tiny-svg/dist/index.esm.js");\n}\n\r\n\r\n\r\n/**\r\n * @param {SVGElement} gfx\r\n * @param {number} x\r\n * @param {number} y\r\n * @param {number} [angle]\r\n * @param {number} [amount]\r\n */\r\nfunction transform(gfx, x, y, angle, amount) {\r\n  var translate = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .createTransform */ .pH)();\r\n  translate.setTranslate(x, y);\r\n\r\n  var rotate = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .createTransform */ .pH)();\r\n  rotate.setRotate(angle || 0, 0, 0);\r\n\r\n  var scale = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .createTransform */ .pH)();\r\n  scale.setScale(amount || 1, amount || 1);\r\n\r\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .transform */ .vs)(gfx, [ translate, rotate, scale ]);\r\n}\r\n\r\n\r\n/**\r\n * @param {SVGElement} gfx\r\n * @param {number} x\r\n * @param {number} y\r\n */\r\nfunction translate(gfx, x, y) {\r\n  var translate = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .createTransform */ .pH)();\r\n  translate.setTranslate(x, y);\r\n\r\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .transform */ .vs)(gfx, translate);\r\n}\r\n\r\n\r\n/**\r\n * @param {SVGElement} gfx\r\n * @param {number} angle\r\n */\r\nfunction rotate(gfx, angle) {\r\n  var rotate = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .createTransform */ .pH)();\r\n  rotate.setRotate(angle, 0, 0);\r\n\r\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .transform */ .vs)(gfx, rotate);\r\n}\r\n\r\n\r\n/**\r\n * @param {SVGElement} gfx\r\n * @param {number} amount\r\n */\r\nfunction scale(gfx, amount) {\r\n  var scale = createTransform();\r\n  scale.setScale(amount, amount);\r\n\r\n  svgTransform(gfx, scale);\r\n}\r\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/SvgTransformUtil.js?')},"./node_modules/diagram-js/lib/util/Text.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ Text)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n/* harmony import */ var tiny_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n/* harmony import */ var min_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n\n\n\n\n\n\n\n/**\n * @typedef {import('../util/Types').Dimensions} Dimensions\n *\n * @typedef { {\n *   top: number;\n *   left: number;\n *   right: number;\n *   bottom: number;\n * } } Padding\n *\n * @typedef { number | Partial<Padding> } PaddingConfig\n *\n * @typedef { {\n *   horizontal: 'center' | 'left';\n *   vertical: 'top' | 'center';\n * } } Alignment\n *\n *  @typedef { 'center-middle' | 'center-top' } AlignmentConfig\n *\n * @typedef { Partial<{\n *   align: AlignmentConfig;\n *   style: Record<string, number | string>;\n *   padding: PaddingConfig;\n * }> } BaseTextConfig\n *\n * @typedef { BaseTextConfig & Partial<{\n *   size: Dimensions;\n * }> } TextConfig\n *\n * @typedef { BaseTextConfig & Partial<{\n *   box: Dimensions;\n *   fitBox: boolean;\n * }> } TextLayoutConfig\n *\n *  @typedef { Dimensions & {\n *  text: string;\n * } } LineDescriptor\n */\n\nvar DEFAULT_BOX_PADDING = 0;\n\nvar DEFAULT_LABEL_SIZE = {\n  width: 150,\n  height: 50\n};\n\n\n/**\n * @param {AlignmentConfig} align\n * @return {Alignment}\n */\nfunction parseAlign(align) {\n\n  var parts = align.split('-');\n\n  return {\n    horizontal: parts[0] || 'center',\n    vertical: parts[1] || 'top'\n  };\n}\n\n/**\n * @param {PaddingConfig} padding\n *\n * @return {Padding}\n */\nfunction parsePadding(padding) {\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isObject */ .Kn)(padding)) {\n    return (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .assign */ .f0)({ top: 0, left: 0, right: 0, bottom: 0 }, padding);\n  } else {\n    return {\n      top: padding,\n      left: padding,\n      right: padding,\n      bottom: padding\n    };\n  }\n}\n\n/**\n * @param {string} text\n * @param {SVGTextElement} fakeText\n *\n * @return {import('../util/Types').Dimensions}\n */\nfunction getTextBBox(text, fakeText) {\n\n  fakeText.textContent = text;\n\n  var textBBox;\n\n  try {\n    var bbox,\n        emptyLine = text === '';\n\n    // add dummy text, when line is empty to\n    // determine correct height\n    fakeText.textContent = emptyLine ? 'dummy' : text;\n\n    textBBox = fakeText.getBBox();\n\n    // take text rendering related horizontal\n    // padding into account\n    bbox = {\n      width: textBBox.width + textBBox.x * 2,\n      height: textBBox.height\n    };\n\n    if (emptyLine) {\n\n      // correct width\n      bbox.width = 0;\n    }\n\n    return bbox;\n  } catch (e) {\n    return { width: 0, height: 0 };\n  }\n}\n\n\n/**\n * Layout the next line and return the layouted element.\n *\n * Alters the lines passed.\n *\n * @param {string[]} lines\n * @param {number} maxWidth\n * @param {SVGTextElement} fakeText\n *\n * @return {LineDescriptor} the line descriptor\n */\nfunction layoutNext(lines, maxWidth, fakeText) {\n\n  var originalLine = lines.shift(),\n      fitLine = originalLine;\n\n  var textBBox;\n\n  for (;;) {\n    textBBox = getTextBBox(fitLine, fakeText);\n\n    textBBox.width = fitLine ? textBBox.width : 0;\n\n    // try to fit\n    if (fitLine === ' ' || fitLine === '' || textBBox.width < Math.round(maxWidth) || fitLine.length < 2) {\n      return fit(lines, fitLine, originalLine, textBBox);\n    }\n\n    fitLine = shortenLine(fitLine, textBBox.width, maxWidth);\n  }\n}\n\n/**\n * @param {string[]} lines\n * @param {string} fitLine\n * @param {string} originalLine\n * @param {Dimensions} textBBox\n *\n * @return {LineDescriptor}\n */\nfunction fit(lines, fitLine, originalLine, textBBox) {\n  if (fitLine.length < originalLine.length) {\n    var remainder = originalLine.slice(fitLine.length).trim();\n\n    lines.unshift(remainder);\n  }\n\n  return {\n    width: textBBox.width,\n    height: textBBox.height,\n    text: fitLine\n  };\n}\n\nvar SOFT_BREAK = '\\u00AD';\n\n\n/**\n * Shortens a line based on spacing and hyphens.\n * Returns the shortened result on success.\n *\n * @param {string} line\n * @param {number} maxLength the maximum characters of the string\n *\n * @return {string} the shortened string\n */\nfunction semanticShorten(line, maxLength) {\n\n  var parts = line.split(/(\\s|-|\\u00AD)/g),\n      part,\n      shortenedParts = [],\n      length = 0;\n\n  // try to shorten via break chars\n  if (parts.length > 1) {\n\n    while ((part = parts.shift())) {\n      if (part.length + length < maxLength) {\n        shortenedParts.push(part);\n        length += part.length;\n      } else {\n\n        // remove previous part, too if hyphen does not fit anymore\n        if (part === '-' || part === SOFT_BREAK) {\n          shortenedParts.pop();\n        }\n\n        break;\n      }\n    }\n  }\n\n  var last = shortenedParts[shortenedParts.length - 1];\n\n  // translate trailing soft break to actual hyphen\n  if (last && last === SOFT_BREAK) {\n    shortenedParts[shortenedParts.length - 1] = '-';\n  }\n\n  return shortenedParts.join('');\n}\n\n\n/**\n * @param {string} line\n * @param {number} width\n * @param {number} maxWidth\n *\n * @return {string}\n */\nfunction shortenLine(line, width, maxWidth) {\n  var length = Math.max(line.length * (maxWidth / width), 1);\n\n  // try to shorten semantically (i.e. based on spaces and hyphens)\n  var shortenedLine = semanticShorten(line, length);\n\n  if (!shortenedLine) {\n\n    // force shorten by cutting the long word\n    shortenedLine = line.slice(0, Math.max(Math.round(length - 1), 1));\n  }\n\n  return shortenedLine;\n}\n\n\n/**\n * @return {SVGSVGElement}\n */\nfunction getHelperSvg() {\n  var helperSvg = document.getElementById('helper-svg');\n\n  if (!helperSvg) {\n    helperSvg = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .create */ .Ue)('svg');\n\n    (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .Lj)(helperSvg, {\n      id: 'helper-svg'\n    });\n\n    (0,min_dom__WEBPACK_IMPORTED_MODULE_2__/* .assignStyle */ .i5)(helperSvg, {\n      visibility: 'hidden',\n      position: 'fixed',\n      width: 0,\n      height: 0\n    });\n\n    document.body.appendChild(helperSvg);\n  }\n\n  return helperSvg;\n}\n\n\n/**\n * Creates a new label utility\n *\n * @param {TextConfig} config\n */\nfunction Text(config) {\n\n  this._config = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .assign */ .f0)({}, {\n    size: DEFAULT_LABEL_SIZE,\n    padding: DEFAULT_BOX_PADDING,\n    style: {},\n    align: 'center-top'\n  }, config || {});\n}\n\n/**\n * Returns the layouted text as an SVG element.\n *\n * @param {string} text\n * @param {TextLayoutConfig} options\n *\n * @return {SVGElement}\n */\nText.prototype.createText = function(text, options) {\n  return this.layoutText(text, options).element;\n};\n\n/**\n * Returns a labels layouted dimensions.\n *\n * @param {string} text to layout\n * @param {TextLayoutConfig} options\n *\n * @return {Dimensions}\n */\nText.prototype.getDimensions = function(text, options) {\n  return this.layoutText(text, options).dimensions;\n};\n\n/**\n * Creates and returns a label and its bounding box.\n *\n * @param {string} text the text to render on the label\n * @param {TextLayoutConfig} options\n *\n * @return { {\n *   element: SVGElement,\n *   dimensions: Dimensions\n * } }\n */\nText.prototype.layoutText = function(text, options) {\n  var box = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .assign */ .f0)({}, this._config.size, options.box),\n      style = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .assign */ .f0)({}, this._config.style, options.style),\n      align = parseAlign(options.align || this._config.align),\n      padding = parsePadding(options.padding !== undefined ? options.padding : this._config.padding),\n      fitBox = options.fitBox || false;\n\n  var lineHeight = getLineHeight(style);\n\n  // we split text by lines and normalize\n  // {soft break} + {line break} => { line break }\n  var lines = text.split(/\\u00AD?\\r?\\n/),\n      layouted = [];\n\n  var maxWidth = box.width - padding.left - padding.right;\n\n  // ensure correct rendering by attaching helper text node to invisible SVG\n  var helperText = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .create */ .Ue)('text');\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .Lj)(helperText, { x: 0, y: 0 });\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .Lj)(helperText, style);\n\n  var helperSvg = getHelperSvg();\n\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .append */ .R3)(helperSvg, helperText);\n\n  while (lines.length) {\n    layouted.push(layoutNext(lines, maxWidth, helperText));\n  }\n\n  if (align.vertical === 'middle') {\n    padding.top = padding.bottom = 0;\n  }\n\n  var totalHeight = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .reduce */ .u4)(layouted, function(sum, line, idx) {\n    return sum + (lineHeight || line.height);\n  }, 0) + padding.top + padding.bottom;\n\n  var maxLineWidth = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .reduce */ .u4)(layouted, function(sum, line, idx) {\n    return line.width > sum ? line.width : sum;\n  }, 0);\n\n  // the y position of the next line\n  var y = padding.top;\n\n  if (align.vertical === 'middle') {\n    y += (box.height - totalHeight) / 2;\n  }\n\n  // magic number initial offset\n  y -= (lineHeight || layouted[0].height) / 4;\n\n\n  var textElement = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .create */ .Ue)('text');\n\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .Lj)(textElement, style);\n\n  // layout each line taking into account that parent\n  // shape might resize to fit text size\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(layouted, function(line) {\n\n    var x;\n\n    y += (lineHeight || line.height);\n\n    switch (align.horizontal) {\n    case 'left':\n      x = padding.left;\n      break;\n\n    case 'right':\n      x = ((fitBox ? maxLineWidth : maxWidth)\n        - padding.right - line.width);\n      break;\n\n    default:\n\n      // aka center\n      x = Math.max((((fitBox ? maxLineWidth : maxWidth)\n        - line.width) / 2 + padding.left), 0);\n    }\n\n    var tspan = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .create */ .Ue)('tspan');\n    (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .Lj)(tspan, { x: x, y: y });\n\n    tspan.textContent = line.text;\n\n    (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .append */ .R3)(textElement, tspan);\n  });\n\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .remove */ .Od)(helperText);\n\n  var dimensions = {\n    width: maxLineWidth,\n    height: totalHeight\n  };\n\n  return {\n    dimensions: dimensions,\n    element: textElement\n  };\n};\n\n\nfunction getLineHeight(style) {\n  if ('fontSize' in style && 'lineHeight' in style) {\n    return style.lineHeight * parseInt(style.fontSize, 10);\n  }\n}\n\n\n//# sourceURL=webpack://VBCP/./node_modules/diagram-js/lib/util/Text.js?")}}]);