/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.actions;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceAdminAction;
import de.viadee.confluence.enterprisecore.action.SpaceAdminPageActionService;
import de.viadee.confluence.enterprisecore.service.SpaceConfigurationService;
import java.util.Map;

public class SpaceAdminPageAction
extends SpaceAdminAction {
    private static final String webResourceKey = "de.viadee.confluence.bpmn-plugin-enterprise.space-admin-page";
    private static final String pluginShorthand = "BPMN";
    private static final String pluginKey = "de.viadee.confluence.bpmn-plugin-enterprise";
    private final SpaceConfigurationService spaceConfigurationService;
    private Map<String, String> validationValues;
    private Map<String, String> bpmnElementsOptions;
    private Map<String, String[]> bpmnElementsOptionsGroups;
    private Map<String, String> bpmnElementsToIcons;

    public SpaceAdminPageAction(SpaceConfigurationService spaceConfigurationService) {
        this.spaceConfigurationService = spaceConfigurationService;
    }

    public String execute() {
        Space space = this.getSpace();
        if (space == null) {
            return "error";
        }
        SpaceAdminPageActionService spaceAdminPageActionService = new SpaceAdminPageActionService(this.spaceConfigurationService, space.getKey());
        String action = spaceAdminPageActionService.execute();
        this.validationValues = spaceAdminPageActionService.getValidationValues();
        this.bpmnElementsOptions = spaceAdminPageActionService.getBpmnElementsConfigChecked();
        this.bpmnElementsOptionsGroups = spaceAdminPageActionService.getBpmnElementsConfigGroups();
        this.bpmnElementsToIcons = spaceAdminPageActionService.getBpmnElementsToIcons();
        return action;
    }

    public String getWebResourceKey() {
        return webResourceKey;
    }

    public static String getPluginShorthand() {
        return pluginShorthand;
    }

    public static String getPluginKey() {
        return pluginKey;
    }

    public Map<String, String> getValidationValues() {
        return this.validationValues;
    }

    public Map<String, String> getBpmnElementsOptions() {
        return this.bpmnElementsOptions;
    }

    public Map<String, String[]> getBpmnElementsOptionsGroups() {
        return this.bpmnElementsOptionsGroups;
    }

    public Map<String, String> getBpmnElementsToIcons() {
        return this.bpmnElementsToIcons;
    }
}

