(()=>{var __webpack_modules__={"../../../../../../MDF-core/core-js/node_modules/jquery.alphanum/jquery.alphanum.js":()=>{eval("/********************************************************************\n* Limit the characters that may be entered in a text field\n* Common options: alphanumeric, alphabetic or numeric\n* Kevin Sheedy, 2012\n* http://github.com/KevinSheedy/jquery.alphanum\n*********************************************************************/\n(function( $ ){\n\n  // API ///////////////////////////////////////////////////////////////////\n  $.fn.alphanum = function(settings) {\n\n    var combinedSettings = getCombinedSettingsAlphaNum(settings);\n\n    var $collection = this;\n\n    setupEventHandlers($collection, trimAlphaNum, combinedSettings);\n\n    return this;\n  };\n\n  $.fn.alpha = function(settings) {\n\n    var defaultAlphaSettings = getCombinedSettingsAlphaNum('alpha');\n    var combinedSettings = getCombinedSettingsAlphaNum(settings, defaultAlphaSettings);\n\n    var $collection = this;\n\n    setupEventHandlers($collection, trimAlphaNum, combinedSettings);\n\n    return this;\n  };\n\n  $.fn.numeric = function(settings) {\n\n    var combinedSettings = getCombinedSettingsNum(settings);\n    var $collection = this;\n\n    setupEventHandlers($collection, trimNum, combinedSettings);\n\n    $collection.blur(function(){\n      numericField_Blur(this, combinedSettings);\n    });\n\n    return this;\n  };\n\n  // End of API /////////////////////////////////////////////////////////////\n\n\n  // Start Settings ////////////////////////////////////////////////////////\n\n  var DEFAULT_SETTINGS_ALPHANUM = {\n    allow              : '',    // Allow extra characters\n    disallow           : '',    // Disallow extra characters\n    allowSpace         : true,  // Allow the space character\n    allowNewline       : true,  // Allow the newline character \\n ascii 10\n    allowNumeric       : true,  // Allow digits 0-9\n    allowUpper         : true,  // Allow upper case characters\n    allowLower         : true,  // Allow lower case characters\n    allowCaseless      : true,  // Allow characters that don't have both upper & lower variants - eg Arabic or Chinese\n    allowLatin         : true,  // a-z A-Z\n    allowOtherCharSets : true,  // eg é, Á, Arabic, Chinese etc\n    forceUpper         : false, // Convert lower case characters to upper case\n    forceLower         : false, // Convert upper case characters to lower case\n    maxLength          : NaN    // eg Max Length\n  };\n\n  var DEFAULT_SETTINGS_NUM = {\n    allowPlus           : false, // Allow the + sign\n    allowMinus          : true,  // Allow the - sign\n    allowThouSep        : true,  // Allow the thousands separator, default is the comma eg 12,000\n    allowDecSep         : true,  // Allow the decimal separator, default is the fullstop eg 3.141\n    allowLeadingSpaces  : false,\n    maxDigits           : NaN,   // The max number of digits\n    maxDecimalPlaces    : NaN,   // The max number of decimal places\n    maxPreDecimalPlaces : NaN,   // The max number digits before the decimal point\n    max                 : NaN,   // The max numeric value allowed\n    min                 : NaN    // The min numeric value allowed\n  };\n\n  // Some pre-defined groups of settings for convenience\n  var CONVENIENCE_SETTINGS_ALPHANUM = {\n    'alpha' : {\n      allowNumeric  : false\n    },\n    'upper' : {\n      allowNumeric  : false,\n      allowUpper    : true,\n      allowLower    : false,\n      allowCaseless : true\n    },\n    'lower' : {\n      allowNumeric  : false,\n      allowUpper    : false,\n      allowLower    : true,\n      allowCaseless : true\n    }\n  };\n\n  // Some pre-defined groups of settings for convenience\n  var CONVENIENCE_SETTINGS_NUMERIC = {\n    'integer' : {\n      allowPlus    : false,\n      allowMinus   : true,\n      allowThouSep : false,\n      allowDecSep  : false\n    },\n    'positiveInteger' : {\n      allowPlus    : false,\n      allowMinus   : false,\n      allowThouSep : false,\n      allowDecSep  : false\n    }\n  };\n\n\n  var BLACKLIST   = getBlacklistAscii() + getBlacklistNonAscii();\n  var THOU_SEP    = ',';\n  var DEC_SEP     = '.';\n  var DIGITS      = getDigitsMap();\n  var LATIN_CHARS = getLatinCharsSet();\n\n  // Return the blacklisted special chars that are encodable using 7-bit ascii\n  function getBlacklistAscii(){\n    var blacklist = '!@#$%^&*()+=[]\\\\\\';,/{}|\":<>?~`.-_';\n    blacklist += ' '; // 'Space' is on the blacklist but can be enabled using the 'allowSpace' config entry\n    return blacklist;\n  }\n\n  // Return the blacklisted special chars that are NOT encodable using 7-bit ascii\n  // We want this .js file to be encoded using 7-bit ascii so it can reach the widest possible audience\n  // Higher order chars must be escaped eg \"\\xAC\"\n  // Not too worried about comments containing higher order characters for now (let's wait and see if it becomes a problem)\n  function getBlacklistNonAscii(){\n    var blacklist =\n        '\\xAC'     // ¬\n      + '\\u20AC'   // €\n      + '\\xA3'     // £\n      + '\\xA6'     // ¦\n      ;\n    return blacklist;\n  }\n\n  // End Settings ////////////////////////////////////////////////////////\n\n\n  // Implementation details go here ////////////////////////////////////////////////////////\n\n  function setupEventHandlers($textboxes, trimFunction, settings) {\n\n    $textboxes.each(function(){\n\n      var $textbox = $(this);\n\n      $textbox\n        // Unbind existing alphanum event handlers\n        .off('.alphanum')\n\n        .on('keyup.alphanum change.alphanum paste.alphanum', function(e){\n\n          var pastedText = '';\n\n          if(e.originalEvent && e.originalEvent.clipboardData && e.originalEvent.clipboardData.getData)\n            pastedText = e.originalEvent.clipboardData.getData('text/plain');\n\n          // setTimeout is necessary for handling the 'paste' event\n          setTimeout(function(){\n            trimTextbox($textbox, trimFunction, settings, pastedText);\n          }, 0);\n        })\n\n        .on('keypress.alphanum', function(e){\n\n        // Determine which key is pressed.\n        // If it's a control key, then allow the event's default action to occur eg backspace, tab\n          var charCode = !e.charCode ? e.which : e.charCode;\n          if(isControlKey(charCode)\n          || e.ctrlKey\n          || e.metaKey ) // cmd on MacOS\n            return;\n\n          var newChar         = String.fromCharCode(charCode);\n\n          // Determine if some text was selected / highlighted when the key was pressed\n          var selectionObject = $textbox.selection();\n          var start = selectionObject.start;\n          var end   = selectionObject.end;\n\n          var textBeforeKeypress  = $textbox.val();\n\n          // The new char may be inserted:\n          //  1) At the start\n          //  2) In the middle\n          //  3) At the end\n          //  4) User highlights some text and then presses a key which would replace the highlighted text\n          //\n          // Here we build the string that would result after the keypress.\n          // If the resulting string is invalid, we cancel the event.\n          // Unfortunately, it isn't enough to just check if the new char is valid because some chars\n          // are position sensitive eg the decimal point '.'' or the minus sign '-'' are only valid in certain positions.\n          var potentialTextAfterKeypress = textBeforeKeypress.substring(0, start) + newChar + textBeforeKeypress.substring(end);\n          var validatedText              = trimFunction(potentialTextAfterKeypress, settings);\n\n          // If the keypress would cause the textbox to contain invalid characters, then cancel the keypress event\n          if(validatedText != potentialTextAfterKeypress)\n            e.preventDefault();\n        });\n    });\n\n  }\n\n  // Ensure the text is a valid number when focus leaves the textbox\n  // This catches the case where a user enters '-' or '.' without entering any digits\n  function numericField_Blur(inputBox, settings) {\n    var fieldValueNumeric = parseFloat($(inputBox).val());\n    var $inputBox = $(inputBox);\n\n    if(isNaN(fieldValueNumeric)) {\n      $inputBox.val('');\n      return;\n    }\n\n    if(isNumeric(settings.min) && fieldValueNumeric < settings.min)\n      $inputBox.val('');\n\n    if(isNumeric(settings.max) && fieldValueNumeric > settings.max)\n      $inputBox.val('');\n  }\n\n  function isNumeric(value) {\n    return !isNaN(value);\n  }\n\n  function isControlKey(charCode) {\n\n    if(charCode >= 32)\n      return false;\n    if(charCode == 10)\n      return false;\n    if(charCode == 13)\n      return false;\n\n    return true;\n  }\n\n  // One way to prevent a character being entered is to cancel the keypress event.\n  // However, this gets messy when you have to deal with things like copy paste which isn't a keypress.\n  // Which event gets fired first, keypress or keyup? What about IE6 etc etc?\n  // Instead, it's easier to allow the 'bad' character to be entered and then to delete it immediately after.\n\n  function trimTextbox($textBox, trimFunction, settings, pastedText){\n\n    var inputString = $textBox.val();\n\n    if(inputString == '' && pastedText.length > 0)\n      inputString = pastedText;\n\n    var outputString = trimFunction(inputString, settings);\n\n    if(inputString == outputString)\n      return;\n\n    var caretPos = $textBox.alphanum_caret();\n\n    $textBox.val(outputString);\n\n    //Reset the caret position\n    if(inputString.length ==(outputString.length + 1))\n      $textBox.alphanum_caret(caretPos - 1);\n    else\n      $textBox.alphanum_caret(caretPos);\n  }\n\n  function getCombinedSettingsAlphaNum(settings, defaultSettings){\n    if(typeof defaultSettings == 'undefined')\n      defaultSettings = DEFAULT_SETTINGS_ALPHANUM;\n    var userSettings, combinedSettings = {};\n    if(typeof settings === 'string')\n      userSettings = CONVENIENCE_SETTINGS_ALPHANUM[settings];\n    else if(typeof settings == 'undefined')\n      userSettings = {};\n    else\n      userSettings = settings;\n\n    $.extend(combinedSettings, defaultSettings, userSettings);\n\n    if(typeof combinedSettings.blacklist == 'undefined')\n      combinedSettings.blacklistSet = getBlacklistSet(combinedSettings.allow, combinedSettings.disallow);\n\n    return combinedSettings;\n  }\n\n  function getCombinedSettingsNum(settings){\n    var userSettings, combinedSettings = {};\n    if(typeof settings === 'string')\n      userSettings = CONVENIENCE_SETTINGS_NUMERIC[settings];\n    else if(typeof settings == 'undefined')\n      userSettings = {};\n    else\n      userSettings = settings;\n\n    $.extend(combinedSettings, DEFAULT_SETTINGS_NUM, userSettings);\n\n    return combinedSettings;\n  }\n\n\n  // This is the heart of the algorithm\n  function alphanum_allowChar(validatedStringFragment, Char, settings){\n\n    if(settings.maxLength && validatedStringFragment.length >= settings.maxLength)\n      return false;\n\n    if(settings.allow.indexOf(Char) >=0 )\n      return true;\n\n    if(settings.allowSpace && (Char == ' '))\n      return true;\n\n    if(!settings.allowNewline && (Char == '\\n' || Char == '\\r'))\n      return false;\n\n    if(settings.blacklistSet.contains(Char))\n      return false;\n\n    if(!settings.allowNumeric && DIGITS[Char])\n      return false;\n\n    if(!settings.allowUpper && isUpper(Char))\n      return false;\n\n    if(!settings.allowLower && isLower(Char))\n      return false;\n\n    if(!settings.allowCaseless && isCaseless(Char))\n      return false;\n\n    if(!settings.allowLatin && LATIN_CHARS.contains(Char))\n      return false;\n\n    if(!settings.allowOtherCharSets){\n      if(DIGITS[Char] || LATIN_CHARS.contains(Char))\n        return true;\n      else\n        return false;\n    }\n\n    return true;\n  }\n\n  function numeric_allowChar(validatedStringFragment, Char, settings){\n\n    if(DIGITS[Char]) {\n\n      if(isMaxDigitsReached(validatedStringFragment, settings))\n        return false;\n\n      if(isMaxPreDecimalsReached(validatedStringFragment, settings))\n        return false;\n\n      if(isMaxDecimalsReached(validatedStringFragment, settings))\n        return false;\n\n      if(isGreaterThanMax(validatedStringFragment + Char, settings))\n        return false;\n\n      if(isLessThanMin(validatedStringFragment + Char, settings))\n        return false;\n\n      return true;\n    }\n\n    if(settings.allowPlus && Char == '+' && validatedStringFragment == '')\n      return true;\n\n    if(settings.allowMinus && Char == '-' && validatedStringFragment == '')\n      return true;\n\n    if(Char == THOU_SEP && settings.allowThouSep && allowThouSep(validatedStringFragment))\n      return true;\n\n    if(Char == DEC_SEP) {\n      // Only one decimal separator allowed\n      if(validatedStringFragment.indexOf(DEC_SEP) >= 0)\n        return false;\n      // Don't allow decimal separator when maxDecimalPlaces is set to 0\n      if(settings.allowDecSep && settings.maxDecimalPlaces === 0)\n        return false;\n      if(settings.allowDecSep)\n        return true;\n    }\n\n    return false;\n  }\n\n  function countDigits(string) {\n\n    // Error handling, nulls etc\n    string = string + '';\n\n    // Count the digits\n    return string.replace(/[^0-9]/g,'').length;\n  }\n\n  function isMaxDigitsReached(string, settings) {\n\n    var maxDigits = settings.maxDigits;\n\n    if(maxDigits === '' || isNaN(maxDigits))\n      return false; // In this case, there is no maximum\n\n    var numDigits = countDigits(string);\n\n    if(numDigits >= maxDigits)\n      return true;\n\n    return false;\n  }\n\n  function isMaxDecimalsReached(string, settings) {\n\n    var maxDecimalPlaces = settings.maxDecimalPlaces;\n\n    if(maxDecimalPlaces === '' || isNaN(maxDecimalPlaces))\n      return false; // In this case, there is no maximum\n\n    var indexOfDecimalPoint = string.indexOf(DEC_SEP);\n\n    if(indexOfDecimalPoint == -1)\n      return false;\n\n    var decimalSubstring = string.substring(indexOfDecimalPoint);\n    var numDecimals = countDigits(decimalSubstring);\n\n    if(numDecimals >= maxDecimalPlaces)\n      return true;\n\n    return false;\n  }\n\n  function isMaxPreDecimalsReached(string, settings) {\n\n    var maxPreDecimalPlaces = settings.maxPreDecimalPlaces;\n\n    if(maxPreDecimalPlaces === '' || isNaN(maxPreDecimalPlaces))\n      return false; // In this case, there is no maximum\n\n    var indexOfDecimalPoint = string.indexOf(DEC_SEP);\n\n    if(indexOfDecimalPoint >= 0)\n      return false;\n\n    var numPreDecimalDigits = countDigits(string);\n\n    if(numPreDecimalDigits >= maxPreDecimalPlaces)\n      return true;\n\n    return false;\n  }\n\n  function isGreaterThanMax(numericString, settings) {\n\n    if(!settings.max || settings.max < 0)\n      return false;\n\n    var outputNumber = parseFloat(numericString);\n    if(outputNumber > settings.max)\n      return true;\n\n    return false;\n  }\n\n  function isLessThanMin(numericString, settings) {\n\n    if(!settings.min || settings.min > 0)\n      return false;\n\n    var outputNumber = parseFloat(numericString);\n    if(outputNumber < settings.min)\n      return true;\n\n    return false;\n  }\n\n  /********************************\n   * Trims a string according to the settings provided\n   ********************************/\n  function trimAlphaNum(inputString, settings){\n\n    if(typeof inputString != 'string')\n      return inputString;\n\n    var inChars = inputString.split('');\n    var outChars = [];\n    var i = 0;\n    var Char;\n\n    for(i=0; i<inChars.length; i++){\n      Char = inChars[i];\n      var validatedStringFragment = outChars.join('');\n      if(alphanum_allowChar(validatedStringFragment, Char, settings))\n        outChars.push(Char);\n    }\n\n    var outputString = outChars.join('');\n\n    if(settings.forceLower)\n      outputString = outputString.toLowerCase();\n    else if(settings.forceUpper)\n      outputString = outputString.toUpperCase();\n\n    return outputString;\n  }\n\n  function trimNum(inputString, settings){\n    if(typeof inputString != 'string')\n      return inputString;\n\n    var inChars = inputString.split('');\n    var outChars = [];\n    var i = 0;\n    var Char;\n\n    for(i=0; i<inChars.length; i++){\n      Char = inChars[i];\n      var validatedStringFragment = outChars.join('');\n      if(numeric_allowChar(validatedStringFragment, Char, settings))\n        outChars.push(Char);\n    }\n\n    return outChars.join('');\n  }\n\n  function isUpper(Char){\n    var upper = Char.toUpperCase();\n    var lower = Char.toLowerCase();\n\n    if( (Char == upper) && (upper != lower))\n      return true;\n    else\n      return false;\n  }\n\n  function isLower(Char){\n    var upper = Char.toUpperCase();\n    var lower = Char.toLowerCase();\n\n    if( (Char == lower) && (upper != lower))\n      return true;\n    else\n      return false;\n  }\n\n  function isCaseless(Char){\n    if(Char.toUpperCase() == Char.toLowerCase())\n      return true;\n    else\n      return false;\n  }\n\n  function getBlacklistSet(allow, disallow){\n\n    var setOfBadChars  = new Set(BLACKLIST + disallow);\n    var setOfGoodChars = new Set(allow);\n\n    var blacklistSet   = setOfBadChars.subtract(setOfGoodChars);\n\n    return blacklistSet;\n  }\n\n  function getDigitsMap(){\n    var array = '0123456789'.split('');\n    var map = {};\n    var i = 0;\n    var digit;\n\n    for(i=0; i<array.length; i++){\n      digit = array[i];\n      map[digit] = true;\n    }\n\n    return map;\n  }\n\n  function getLatinCharsSet(){\n    var lower = 'abcdefghijklmnopqrstuvwxyz';\n    var upper = lower.toUpperCase();\n    var azAZ = new Set(lower + upper);\n\n    return azAZ;\n  }\n\n  function allowThouSep(currentString) {\n\n    // Can't start with a THOU_SEP\n    if(currentString.length == 0)\n      return false;\n\n    // Can't have a THOU_SEP anywhere after a DEC_SEP\n    var posOfDecSep = currentString.indexOf(DEC_SEP);\n    if(posOfDecSep >= 0)\n      return false;\n\n    var posOfFirstThouSep       = currentString.indexOf(THOU_SEP);\n\n    // Check if this is the first occurrence of a THOU_SEP\n    if(posOfFirstThouSep < 0)\n      return true;\n\n    var posOfLastThouSep        = currentString.lastIndexOf(THOU_SEP);\n    var charsSinceLastThouSep   = currentString.length - posOfLastThouSep - 1;\n\n    // Check if there has been 3 digits since the last THOU_SEP\n    if(charsSinceLastThouSep < 3)\n      return false;\n\n    var digitsSinceFirstThouSep = countDigits(currentString.substring(posOfFirstThouSep));\n\n    // Check if there has been a multiple of 3 digits since the first THOU_SEP\n    if((digitsSinceFirstThouSep % 3) > 0)\n      return false;\n\n    return true;\n  }\n\n  ////////////////////////////////////////////////////////////////////////////////////\n  // Implementation of a Set\n  ////////////////////////////////////////////////////////////////////////////////////\n  function Set(elems){\n    if(typeof elems == 'string')\n      this.map = stringToMap(elems);\n    else\n      this.map = {};\n  }\n\n  Set.prototype.add = function(set){\n\n    var newSet = this.clone();\n\n    for(var key in set.map)\n      newSet.map[key] = true;\n\n    return newSet;\n  };\n\n  Set.prototype.subtract = function(set){\n\n    var newSet = this.clone();\n\n    for(var key in set.map)\n      delete newSet.map[key];\n\n    return newSet;\n  };\n\n  Set.prototype.contains = function(key){\n    if(this.map[key])\n      return true;\n    else\n      return false;\n  };\n\n  Set.prototype.clone = function(){\n    var newSet = new Set();\n\n    for(var key in this.map)\n      newSet.map[key] = true;\n\n    return newSet;\n  };\n  ////////////////////////////////////////////////////////////////////////////////////\n\n  function stringToMap(string){\n    var map = {};\n    var array = string.split('');\n    var i=0;\n    var Char;\n\n    for(i=0; i<array.length; i++){\n      Char = array[i];\n      map[Char] = true;\n    }\n\n    return map;\n  }\n\n  // Backdoor for testing\n  $.fn.alphanum.backdoorAlphaNum = function(inputString, settings){\n    var combinedSettings = getCombinedSettingsAlphaNum(settings);\n\n    return trimAlphaNum(inputString, combinedSettings);\n  };\n\n  $.fn.alphanum.backdoorNumeric = function(inputString, settings){\n    var combinedSettings = getCombinedSettingsNum(settings);\n\n    return trimNum(inputString, combinedSettings);\n  };\n\n  $.fn.alphanum.setNumericSeparators = function(settings) {\n\n    if(settings.thousandsSeparator.length != 1)\n      return;\n\n    if(settings.decimalSeparator.length != 1)\n      return;\n\n    THOU_SEP = settings.thousandsSeparator;\n    DEC_SEP = settings.decimalSeparator;\n  };\n\n})( jQuery );\n\n/*eslint-disable */\n//Include the 3rd party lib: jquery.caret.js\n\n\n// Set caret position easily in jQuery\n// Written by and Copyright of Luke Morton, 2011\n// Licensed under MIT\n(function ($) {\n  // Behind the scenes method deals with browser\n  // idiosyncrasies and such\n  function caretTo(el, index) {\n    if (el.createTextRange) {\n      var range = el.createTextRange();\n      range.move(\"character\", index);\n      range.select();\n    } else if (el.selectionStart != null) {\n      el.focus();\n      el.setSelectionRange(index, index);\n    }\n  };\n\n  // Another behind the scenes that collects the\n  // current caret position for an element\n\n  // TODO: Get working with Opera\n  function caretPos(el) {\n    if (\"selection\" in document) {\n      var range = el.createTextRange();\n      try {\n        range.setEndPoint(\"EndToStart\", document.selection.createRange());\n      } catch (e) {\n        // Catch IE failure here, return 0 like\n        // other browsers\n        return 0;\n      }\n      return range.text.length;\n    } else if (el.selectionStart != null) {\n      return el.selectionStart;\n    }\n  };\n\n  // The following methods are queued under fx for more\n  // flexibility when combining with $.fn.delay() and\n  // jQuery effects.\n\n  // Set caret to a particular index\n  $.fn.alphanum_caret = function (index, offset) {\n    if (typeof(index) === \"undefined\") {\n      return caretPos(this.get(0));\n    }\n\n    return this.queue(function (next) {\n      if (isNaN(index)) {\n        var i = $(this).val().indexOf(index);\n\n        if (offset === true) {\n          i += index.length;\n        } else if (typeof(offset) !== \"undefined\") {\n          i += offset;\n        }\n\n        caretTo(this, i);\n      } else {\n        caretTo(this, index);\n      }\n\n      next();\n    });\n  };\n}(jQuery));\n\n/**********************************************************\n* Selection Library\n* Used to determine what text is highlighted in the textbox before a key is pressed.\n* http://donejs.com/docs.html#!jQuery.fn.selection\n* https://github.com/jupiterjs/jquerymx/blob/master/dom/selection/selection.js\n***********************************************************/\n(function(e){var t=function(e){return e.replace(/([a-z])([a-z]+)/gi,function(e,t,n){return t+n.toLowerCase()}).replace(/_/g,\"\")},n=function(e){return e.replace(/^([a-z]+)_TO_([a-z]+)/i,function(e,t,n){return n+\"_TO_\"+t})},r=function(e){return e?e.ownerDocument.defaultView||e.ownerDocument.parentWindow:window},i=function(t,n){var r=e.Range.current(t).clone(),i=e.Range(t).select(t);if(!r.overlaps(i)){return null}if(r.compare(\"START_TO_START\",i)<1){startPos=0;r.move(\"START_TO_START\",i)}else{fromElementToCurrent=i.clone();fromElementToCurrent.move(\"END_TO_START\",r);startPos=fromElementToCurrent.toString().length}if(r.compare(\"END_TO_END\",i)>=0){endPos=i.toString().length}else{endPos=startPos+r.toString().length}return{start:startPos,end:endPos}},s=function(t){var n=r(t);if(t.selectionStart!==undefined){if(document.activeElement&&document.activeElement!=t&&t.selectionStart==t.selectionEnd&&t.selectionStart==0){return{start:t.value.length,end:t.value.length}}return{start:t.selectionStart,end:t.selectionEnd}}else if(n.getSelection){return i(t,n)}else{try{if(t.nodeName.toLowerCase()==\"input\"){var s=r(t).document.selection.createRange(),o=t.createTextRange();o.setEndPoint(\"EndToStart\",s);var u=o.text.length;return{start:u,end:u+s.text.length}}else{var a=i(t,n);if(!a){return a}var f=e.Range.current().clone(),l=f.clone().collapse().range,c=f.clone().collapse(false).range;l.moveStart(\"character\",-1);c.moveStart(\"character\",-1);if(a.startPos!=0&&l.text==\"\"){a.startPos+=2}if(a.endPos!=0&&c.text==\"\"){a.endPos+=2}return a}}catch(h){return{start:t.value.length,end:t.value.length}}}},o=function(e,t,n){var i=r(e);if(e.setSelectionRange){if(n===undefined){e.focus();e.setSelectionRange(t,t)}else{e.select();e.selectionStart=t;e.selectionEnd=n}}else if(e.createTextRange){var s=e.createTextRange();s.moveStart(\"character\",t);n=n||t;s.moveEnd(\"character\",n-e.value.length);s.select()}else if(i.getSelection){var o=i.document,u=i.getSelection(),f=o.createRange(),l=[t,n!==undefined?n:t];a([e],l);f.setStart(l[0].el,l[0].count);f.setEnd(l[1].el,l[1].count);u.removeAllRanges();u.addRange(f)}else if(i.document.body.createTextRange){var f=document.body.createTextRange();f.moveToElementText(e);f.collapse();f.moveStart(\"character\",t);f.moveEnd(\"character\",n!==undefined?n:t);f.select()}},u=function(e,t,n,r){if(typeof n[0]===\"number\"&&n[0]<t){n[0]={el:r,count:n[0]-e}}if(typeof n[1]===\"number\"&&n[1]<=t){n[1]={el:r,count:n[1]-e};}},a=function(e,t,n){var r,i;n=n||0;for(var s=0;e[s];s++){r=e[s];if(r.nodeType===3||r.nodeType===4){i=n;n+=r.nodeValue.length;u(i,n,t,r)}else if(r.nodeType!==8){n=a(r.childNodes,t,n)}}return n};jQuery.fn.selection=function(e,t){if(e!==undefined){return this.each(function(){o(this,e,t)})}else{return s(this[0])}};e.fn.selection.getCharElement=a})(jQuery);\n/*eslint-enable */\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/node_modules/jquery.alphanum/jquery.alphanum.js?")},"../../../../../../MDF-core/core-js/app/model/enum/app-type-html-prefix.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "U": () => (/* binding */ AppTypeHtmlPrefixEnum)\n/* harmony export */ });\nvar AppTypeHtmlPrefixEnum;\n(function (AppTypeHtmlPrefixEnum) {\n    AppTypeHtmlPrefixEnum["MDF"] = "vcfcp-ent";\n    AppTypeHtmlPrefixEnum["VBCP_ENT"] = "vxcp-ent-mdf";\n    AppTypeHtmlPrefixEnum["DMN_ENT"] = "vxcp-ent-mdf";\n})(AppTypeHtmlPrefixEnum || (AppTypeHtmlPrefixEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/model/enum/app-type-html-prefix.enum.ts?')},"../../../../../../MDF-core/core-js/app/model/enum/attribute-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "S": () => (/* binding */ AttributeTypeEnum)\n/* harmony export */ });\nvar AttributeTypeEnum;\n(function (AttributeTypeEnum) {\n    AttributeTypeEnum["STRING"] = "STRING";\n    AttributeTypeEnum["NUMBER"] = "NUMBER";\n    AttributeTypeEnum["CHECKBOX"] = "CHECKBOX";\n    AttributeTypeEnum["RADIO"] = "RADIO";\n    AttributeTypeEnum["DROPDOWN"] = "DROPDOWN";\n    AttributeTypeEnum["DATE"] = "DATE";\n    AttributeTypeEnum["USER"] = "USER";\n    AttributeTypeEnum["CALCULATION"] = "CALCULATION";\n    AttributeTypeEnum["STATIC_TEXT"] = "STATIC_TEXT";\n})(AttributeTypeEnum || (AttributeTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/model/enum/attribute-type.enum.ts?')},"../../../../../../MDF-core/core-js/app/model/enum/calculation-operator.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "u": () => (/* binding */ CalculationOperatorEnum)\n/* harmony export */ });\nvar CalculationOperatorEnum;\n(function (CalculationOperatorEnum) {\n    CalculationOperatorEnum["ADDITION"] = "+";\n    CalculationOperatorEnum["+"] = "ADDITION";\n    CalculationOperatorEnum["SUBTRACTION"] = "-";\n    CalculationOperatorEnum["-"] = "SUBTRACTION";\n    CalculationOperatorEnum["MULTIPLICATION"] = "*";\n    CalculationOperatorEnum["*"] = "MULTIPLICATION";\n    CalculationOperatorEnum["DIVISION"] = "/";\n    CalculationOperatorEnum["/"] = "DIVISION";\n    CalculationOperatorEnum["POWER"] = "^";\n    CalculationOperatorEnum["^"] = "POWER";\n    CalculationOperatorEnum["ROUND_BRACKET_OPEN_RIGHT"] = "(";\n    CalculationOperatorEnum["("] = "ROUND_BRACKET_OPEN_RIGHT";\n    CalculationOperatorEnum["ROUND_BRACKET_OPEN_LEFT"] = ")";\n    CalculationOperatorEnum[")"] = "ROUND_BRACKET_OPEN_LEFT";\n})(CalculationOperatorEnum || (CalculationOperatorEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/model/enum/calculation-operator.enum.ts?')},"../../../../../../MDF-core/core-js/app/model/enum/calculation-validation.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "H": () => (/* binding */ CalculationValidationEnum)\n/* harmony export */ });\nvar CalculationValidationEnum;\n(function (CalculationValidationEnum) {\n    CalculationValidationEnum["VALID"] = "VALID";\n    CalculationValidationEnum["INVALID"] = "INVALID";\n})(CalculationValidationEnum || (CalculationValidationEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/model/enum/calculation-validation.enum.ts?')},"../../../../../../MDF-core/core-js/app/model/enum/field-definition-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "m": () => (/* binding */ FieldDefinitionTypeEnum)\n/* harmony export */ });\nvar FieldDefinitionTypeEnum;\n(function (FieldDefinitionTypeEnum) {\n    FieldDefinitionTypeEnum["STRING"] = "vCFCP_STRING";\n    FieldDefinitionTypeEnum["NUMBER"] = "vCFCP_NUMBER";\n    FieldDefinitionTypeEnum["CHECKBOX"] = "vCFCP_CHECKBOX";\n    FieldDefinitionTypeEnum["RADIO"] = "vCFCP_RADIO";\n    FieldDefinitionTypeEnum["DROPDOWN"] = "vCFCP_DROPDOWN";\n    FieldDefinitionTypeEnum["DATE"] = "vCFCP_DATE";\n    FieldDefinitionTypeEnum["USER"] = "vCFCP_USER";\n    FieldDefinitionTypeEnum["COMPLEX"] = "vCFCP_COMPLEX";\n    FieldDefinitionTypeEnum["CALCULATION"] = "vCFCP_CALCULATION";\n    FieldDefinitionTypeEnum["STATIC_TEXT"] = "vCFCP_STATIC_TEXT";\n    FieldDefinitionTypeEnum["UNDEFINED"] = "NO-DEFINITION-EXISTS";\n})(FieldDefinitionTypeEnum || (FieldDefinitionTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/model/enum/field-definition-type.enum.ts?')},"../../../../../../MDF-core/core-js/app/model/enum/mdf-template-names.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "c": () => (/* binding */ MdfTemplateNamesEnum)\n/* harmony export */ });\nvar MdfTemplateNamesEnum;\n(function (MdfTemplateNamesEnum) {\n    MdfTemplateNamesEnum["QUERY_EDITOR_DISPLAY_SETTINGS"] = "queryEditorDisplaySettings";\n    MdfTemplateNamesEnum["QUERY_EDITOR_CHART_PLACEHOLDER_NUMERIC"] = "queryEditorChartPlaceholderNumeric";\n    MdfTemplateNamesEnum["QUERY_EDITOR_CHART_PLACEHOLDER_CATEGORICAL"] = "queryEditorChartPlaceholderCategorical";\n    MdfTemplateNamesEnum["QUERY_VIEWER_TABLE_HEADER"] = "fieldQueryTableHeader";\n    MdfTemplateNamesEnum["QUERY_VIEWER_STATIC_TEXT_SECTION"] = "fieldQueryStaticTextFieldsSection";\n    MdfTemplateNamesEnum["DATA_ATTRIBUTE_INPUT"] = "dataAttributeInput";\n    MdfTemplateNamesEnum["PREDEFINED_VALUE_INPUT"] = "predefinedValueInput";\n    MdfTemplateNamesEnum["PREDEFINED_VALUE_INPUT_CALCULATION"] = "predefinedValueInputCalculation";\n    MdfTemplateNamesEnum["PREDEFINED_VALUE_INPUT_STATIC_TEXT"] = "predefinedValueInputStaticText";\n    MdfTemplateNamesEnum["EXPORT_CSV_DIALOG"] = "exportCsvDialog";\n    MdfTemplateNamesEnum["MACRO_DIALOG_VCFCP"] = "macroDialogVCFCP";\n    MdfTemplateNamesEnum["MDF_USER_MENTION_DISPLAY"] = "mdfUserMentionDisplay";\n    MdfTemplateNamesEnum["MDF_CONFLUENCE_LABEL"] = "mdfConfluenceLabel";\n    MdfTemplateNamesEnum["CALC_DROPDOWN_DISPLAY"] = "calcDropdownDisplay";\n})(MdfTemplateNamesEnum || (MdfTemplateNamesEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/model/enum/mdf-template-names.enum.ts?')},"../../../../../../MDF-core/core-js/app/model/enum/predefined-value-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Q": () => (/* binding */ PredefinedValueTypeEnum)\n/* harmony export */ });\nvar PredefinedValueTypeEnum;\n(function (PredefinedValueTypeEnum) {\n    PredefinedValueTypeEnum["DROPDOWN_OPTION"] = "dropdownOption";\n    PredefinedValueTypeEnum["CHECKBOX_OPTION"] = "checkboxOption";\n    PredefinedValueTypeEnum["RADIO_OPTION"] = "radioOption";\n    PredefinedValueTypeEnum["CALCULATION_INPUT"] = "calculationInput";\n    PredefinedValueTypeEnum["STATIC_TEXT_INPUT"] = "staticTextInput";\n})(PredefinedValueTypeEnum || (PredefinedValueTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/model/enum/predefined-value-type.enum.ts?')},"../../../../../../MDF-core/core-js/app/model/enum/vcfcp-id-prefix.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "d": () => (/* binding */ VcfcpIdPrefixEnum)\n/* harmony export */ });\nvar VcfcpIdPrefixEnum;\n(function (VcfcpIdPrefixEnum) {\n    VcfcpIdPrefixEnum["vcfcpInstanceId"] = "vcfcpInstanceId_";\n    VcfcpIdPrefixEnum["vcfcpDefinitionId"] = "vcfcpDefinitionId_";\n    VcfcpIdPrefixEnum["vcfcpValueId"] = "vcfcpValueId_";\n    VcfcpIdPrefixEnum["vcfcpQueryId"] = "vcfcpQueryId_";\n    VcfcpIdPrefixEnum["vcfcpAttributeId"] = "vcfcpAttributeId_";\n    VcfcpIdPrefixEnum["vcfcpChartId"] = "vcfcpChart_";\n})(VcfcpIdPrefixEnum || (VcfcpIdPrefixEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/model/enum/vcfcp-id-prefix.enum.ts?')},"../../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ VxcpLogger)\n/* harmony export */ });\nclass VxcpLogger {\n    constructor(pluginName, serviceName, isEnabled = true) {\n        this.pluginName = pluginName;\n        this.serviceName = serviceName;\n        this.isEnabled = isEnabled;\n    }\n    logFatal(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`FATAL@${logHeader}: ${description}`);\n        }\n    }\n    logError(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`ERROR@${logHeader}: ${description}`);\n        }\n    }\n    logWarning(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.warn(`WARNING@${logHeader}: ${description}`);\n        }\n    }\n    logInfo(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.info(`INFO@${logHeader}: ${description}`);\n        }\n    }\n    enableLogging(isEnabled = true) {\n        this.isEnabled = isEnabled;\n    }\n    getLogHeader(methodName) {\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"../../../../../../vCFCP/app-server-enterprise/src/main/js/app/services/caretUtils.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Ly": () => (/* binding */ getCaretCoordinates),\n/* harmony export */   "yH": () => (/* binding */ setCurrentCursorPosition)\n/* harmony export */ });\n/* unused harmony exports getCaretIndex, getCaretPositionOfElementWithInnerHMTLNodes */\nfunction getCaretCoordinates() {\n    let x = 0;\n    let y = 0;\n    const isSupported = typeof window.getSelection !== "undefined";\n    if (isSupported) {\n        const selection = window.getSelection();\n        if (selection) {\n            if (selection.rangeCount !== 0) {\n                const range = selection.getRangeAt(0).cloneRange();\n                range.collapse(true);\n                const rect = range.getClientRects()[0];\n                if (rect) {\n                    x = rect.left;\n                    y = rect.top;\n                }\n            }\n        }\n    }\n    return { x, y };\n}\nfunction getCaretIndex(element) {\n    let position = 0;\n    const isSupported = typeof window.getSelection !== "undefined";\n    if (isSupported) {\n        const selection = window.getSelection();\n        if (selection) {\n            if (selection.rangeCount !== 0) {\n                const range = selection.getRangeAt(0);\n                const preCaretRange = range.cloneRange();\n                preCaretRange.selectNodeContents(element);\n                preCaretRange.setEnd(range.endContainer, range.endOffset);\n                position = preCaretRange.toString().length;\n            }\n        }\n    }\n    return position;\n}\nfunction getCaretPositionOfElementWithInnerHMTLNodes(element) {\n    const target = document.createTextNode("\\u0001");\n    const selection = document.getSelection();\n    if (selection) {\n        selection.getRangeAt(0).insertNode(target);\n    }\n    const position = element.innerHTML.indexOf("\\u0001");\n    const parentOfTarget = target.parentNode;\n    if (parentOfTarget) {\n        parentOfTarget.removeChild(target);\n    }\n    return position;\n}\nfunction createRange(node, chars, range) {\n    if (!range) {\n        range = document.createRange();\n        range.selectNode(node);\n        range.setStart(node, 0);\n    }\n    if (chars.count === 0) {\n        range.setEnd(node, chars.count);\n    }\n    else if (node && chars.count > 0) {\n        if (node.nodeType === Node.TEXT_NODE) {\n            if (node.textContent.length < chars.count) {\n                chars.count -= node.textContent.length;\n            }\n            else {\n                range.setEnd(node, chars.count);\n                chars.count = 0;\n            }\n        }\n        else {\n            for (let lp = 0; lp < node.childNodes.length; lp++) {\n                range = createRange(node.childNodes[lp], chars, range);\n                if (chars.count === 0) {\n                    break;\n                }\n            }\n        }\n    }\n    return range;\n}\nfunction setCurrentCursorPosition(element, chars) {\n    if (chars >= 0) {\n        const selection = window.getSelection();\n        const range = createRange(element.parentNode, { count: chars });\n        if (range && selection) {\n            range.collapse(false);\n            selection.removeAllRanges();\n            selection.addRange(range);\n        }\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vCFCP/app-server-enterprise/src/main/js/app/services/caretUtils.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model-language/empty-language.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "l": () => (/* binding */ EmptyLanguageService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_app_file_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/file-type.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\nclass EmptyLanguageService {\n    constructor() {\n        return;\n    }\n    hasInit() {\n        return false;\n    }\n    isSavingPossibleInView() {\n        return true;\n    }\n    getLinting() {\n        return;\n    }\n    getCustomReplaceMenu() {\n        return;\n    }\n    getCanvas() {\n        return;\n    }\n    getZoomScroll() {\n        return;\n    }\n    openMinimap() {\n        return;\n    }\n    toggleMinimap() {\n        return;\n    }\n    parseXml(xml) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return {\n                elementsById: {},\n                references: [],\n                rootElement: null,\n                warnings: [],\n            };\n        });\n    }\n    importXml(xml, operationType, saveCallbackForMigration) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return {\n                warnings: [],\n            };\n        });\n    }\n    saveXml(options) {\n        return;\n    }\n    saveSvg(options) {\n        return;\n    }\n    waitForCommentsUpdated(callback) {\n        return;\n    }\n    toggleEmbeddedComments() {\n        return false;\n    }\n    loadEmbeddedComments(showEmbeddedComments) {\n        return;\n    }\n    registerEvent(event, callback) {\n        return;\n    }\n    registerViewChangeEvent(panelWrapperId, panelToggleId, openTableCallback, openDrdCallback) {\n        return;\n    }\n    registerChangeEvent(changeCallback) {\n        return;\n    }\n    getAllElements() {\n        return [];\n    }\n    getElement(elementId) {\n        return;\n    }\n    alignElements(type) {\n        return;\n    }\n    distributeElements(type) {\n        return;\n    }\n    undo() {\n        return __awaiter(this, void 0, void 0, function* () {\n            return;\n        });\n    }\n    redo() {\n        return __awaiter(this, void 0, void 0, function* () {\n            return;\n        });\n    }\n    getPreviousSelectedVersion() {\n        return 0;\n    }\n    setPreviousSelectedVersion(selectedVersion) {\n        return;\n    }\n    unbindKeyboard() {\n        return;\n    }\n    bindKeyboardToDocument() {\n        return;\n    }\n    getCurrentOverlays(domElement) {\n        return [];\n    }\n    getOverlays() {\n        return;\n    }\n    getModdle() {\n        return;\n    }\n    getModeling() {\n        return;\n    }\n    addOverlay(domElement, overlayId, config) {\n        return;\n    }\n    removeOverlay(config) {\n        return;\n    }\n    getElementRegistry() {\n        return;\n    }\n    getEventBus() {\n        return;\n    }\n    getSelection() {\n        return;\n    }\n    getDi(element) {\n        return;\n    }\n    getSelectedElements() {\n        return;\n    }\n    getDiagramFileType() {\n        return _model_enum_app_file_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FileTypeEnum.BPMN */ .W.BPMN;\n    }\n    updateProperties(domElement, value) {\n        return;\n    }\n    callModdleCreate(bpmnElementTypeEnum) {\n        return;\n    }\n    isModelerMode() {\n        return false;\n    }\n    showAttributePanelInMode() {\n        return true;\n    }\n    getIds() {\n        return;\n    }\n    isDragAndDropImportSupported() {\n        return true;\n    }\n    createMarkdownEditorElementDesc(appMode, selector) {\n        return null;\n    }\n    createMarkdownEditorProcessRefDesc(appMode, selector) {\n        return null;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model-language/empty-language.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "GU": () => (/* binding */ getLanguageRestService)\n/* harmony export */ });\n/* unused harmony exports getLanguageRestServiceForPluginType, getEmptyLanguageService */\n/* harmony import */ var _model_enum_app_plugin_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/plugin-type.enum.ts");\n\n\nconst getLanguageRestService = () => {\n    if (false) {}\n    else {\n        return getBpmnRestService();\n    }\n};\nconst getLanguageRestServiceForPluginType = (pluginType) => {\n    if (pluginType === PluginTypeEnum.DMN_ENTERPRISE) {\n        return getDmnRestService();\n    }\n    else {\n        return getBpmnRestService();\n    }\n};\nconst getEmptyLanguageService = () => {\n    return new EmptyLanguageRestService();\n};\nconst getBpmnRestService = () => {\n    return window.VBCP.bpmnEntLanguageService.getLanguageRestService();\n};\nconst getDmnRestService = () => {\n    return window.VDCPENT.dmnEntLanguageService.getLanguageRestService();\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "hw": () => (/* binding */ getPlatformMDFService),\n/* harmony export */   "j": () => (/* binding */ getPluginService),\n/* harmony export */   "km": () => (/* binding */ getPlatformService)\n/* harmony export */ });\nconst getPluginService = () => {\n    if (false) {}\n    else {\n        return getBpmnPluginService();\n    }\n};\nconst getDmnPluginService = () => {\n    return window.VDCPENT.dmnEntPlugin;\n};\nconst getBpmnPluginService = () => {\n    return window.VBCP.bpmnEntPlugin;\n};\nconst getPlatformService = () => {\n    if (false) {}\n    else {\n        return getBpmnPlatformService();\n    }\n};\nconst getPlatformMDFService = () => {\n    if (false) {}\n    else {\n        return getBpmnPlatformMDFService();\n    }\n};\nconst getDmnPlatformService = () => {\n    return window.VDCPENT.dmnEntPlatformJS;\n};\nconst getBpmnPlatformService = () => {\n    return window.VBCP.bpmnEntPlatformJS;\n};\nconst getDmnPlatformMDFService = () => {\n    return window.VDCPENT.dmnEntPlatformMDF;\n};\nconst getBpmnPlatformMDFService = () => {\n    return window.VBCP.bpmnEntPlatformMDF;\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/app-mode.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "v": () => (/* binding */ AppModeEnum)\n/* harmony export */ });\n/* unused harmony export APP_MODE_CLASSES */\nvar AppModeEnum;\n(function (AppModeEnum) {\n    AppModeEnum["EDITOR"] = "EDITOR";\n    AppModeEnum["PRESENTATION"] = "PRESENTATION";\n    AppModeEnum["DIFFER"] = "DIFFER";\n    AppModeEnum["DIFFER_WITH_MINIMAP"] = "DIFFER_WITH_MINIMAP";\n    AppModeEnum["XMLEDITOR"] = "XMLEDITOR";\n    AppModeEnum["TABLE"] = "TABLE";\n    AppModeEnum["VIEWER"] = "VIEWER";\n    AppModeEnum["VIEWER_DIALOG"] = "VIEWER_DIALOG";\n})(AppModeEnum || (AppModeEnum = {}));\nconst APP_MODE_CLASSES = {\n    [AppModeEnum.EDITOR]: "vxcp-ent-app-mode-editor",\n    [AppModeEnum.PRESENTATION]: "vxcp-ent-app-mode-presentation",\n    [AppModeEnum.XMLEDITOR]: "vxcp-ent-app-mode-xml-editor",\n    [AppModeEnum.DIFFER]: "vxcp-ent-app-mode-differ",\n    [AppModeEnum.DIFFER_WITH_MINIMAP]: "vxcp-ent-app-mode-differ",\n    [AppModeEnum.TABLE]: "vxcp-ent-app-mode-table",\n    [AppModeEnum.VIEWER_DIALOG]: "vxcp-ent-app-mode-viewer-dialog",\n    [AppModeEnum.VIEWER]: "vxcp-ent-app-mode-viewer",\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/app-mode.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/app-rest-path.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* unused harmony exports EnterpriseRestPathEnum, EnterpriseActionPathEnum, FreeRestPathEnum */\nvar EnterpriseRestPathEnum;\n(function (EnterpriseRestPathEnum) {\n    EnterpriseRestPathEnum["BPMN"] = "bpmn-modeler-enterprise";\n    EnterpriseRestPathEnum["DMN"] = "dmn-plugin-enterprise";\n})(EnterpriseRestPathEnum || (EnterpriseRestPathEnum = {}));\nvar EnterpriseActionPathEnum;\n(function (EnterpriseActionPathEnum) {\n    EnterpriseActionPathEnum["BPMN"] = "bpmn-plugin-enterprise";\n    EnterpriseActionPathEnum["DMN"] = "dmn-plugin-enterprise";\n})(EnterpriseActionPathEnum || (EnterpriseActionPathEnum = {}));\nvar FreeRestPathEnum;\n(function (FreeRestPathEnum) {\n    FreeRestPathEnum["BPMN"] = "bpmn-modeler";\n    FreeRestPathEnum["DMN"] = "dmn-modeler";\n})(FreeRestPathEnum || (FreeRestPathEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/app-rest-path.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/app-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "K": () => (/* binding */ AppTypeEnum)\n/* harmony export */ });\nvar AppTypeEnum;\n(function (AppTypeEnum) {\n    AppTypeEnum["CLOUD_ENTERPRISE"] = "cloud-enterprise";\n    AppTypeEnum["SERVER_ENTERPRISE"] = "server-enterprise";\n    AppTypeEnum["SERVER_FREE"] = "server-free";\n})(AppTypeEnum || (AppTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/app-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/dmn-table-mode.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "J": () => (/* binding */ DmnTableModeEnum)\n/* harmony export */ });\nvar DmnTableModeEnum;\n(function (DmnTableModeEnum) {\n    DmnTableModeEnum["VIEWER"] = "view";\n    DmnTableModeEnum["EDITOR"] = "edit";\n})(DmnTableModeEnum || (DmnTableModeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/dmn-table-mode.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/file-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "W": () => (/* binding */ FileTypeEnum)\n/* harmony export */ });\nvar FileTypeEnum;\n(function (FileTypeEnum) {\n    FileTypeEnum["BPMN"] = ".bpmn";\n    FileTypeEnum["SVG"] = ".svg";\n    FileTypeEnum["PNG"] = ".png";\n    FileTypeEnum["DMN"] = ".dmn";\n    FileTypeEnum["PDF"] = ".pdf";\n    FileTypeEnum["DOC"] = ".doc;.docx";\n    FileTypeEnum["PPT"] = ".ppt;.pptx";\n    FileTypeEnum["IMAGE"] = ".jpg;.jpeg;.png";\n    FileTypeEnum["CSV"] = ".csv";\n    FileTypeEnum["JSON"] = ".json";\n    FileTypeEnum["XML"] = ".xml";\n    FileTypeEnum["ANY"] = "";\n})(FileTypeEnum || (FileTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/file-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/from-mode.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "p": () => (/* binding */ FromModeEnum)\n/* harmony export */ });\nvar FromModeEnum;\n(function (FromModeEnum) {\n    FromModeEnum["URL"] = "URL";\n    FromModeEnum["CONFLUENCE_VIEWER"] = "CONFLUENCE_VIEWER";\n    FromModeEnum["CONFLUENCE_EDITOR"] = "CONFLUENCE_EDITOR";\n})(FromModeEnum || (FromModeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/from-mode.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/plugin-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* unused harmony exports PluginTypeEnum, MacroEnterpriseNameEnum, MacroFreeNameEnum */\nvar PluginTypeEnum;\n(function (PluginTypeEnum) {\n    PluginTypeEnum["DMN"] = "DMN";\n    PluginTypeEnum["DMN_ENTERPRISE"] = "DMN";\n    PluginTypeEnum["BPMN"] = "BPMN";\n})(PluginTypeEnum || (PluginTypeEnum = {}));\nvar MacroEnterpriseNameEnum;\n(function (MacroEnterpriseNameEnum) {\n    MacroEnterpriseNameEnum["DMN"] = "vdcp-macro-enterprise";\n    MacroEnterpriseNameEnum["BPMN"] = "vbcp-macro-enterprise";\n    MacroEnterpriseNameEnum["BPMN_PROCESS_NET"] = "vbcp-enterprise-process-net-macro";\n    MacroEnterpriseNameEnum["DMN_PROCESS_NET"] = "vdcp-enterprise-process-net-macro";\n})(MacroEnterpriseNameEnum || (MacroEnterpriseNameEnum = {}));\nvar MacroFreeNameEnum;\n(function (MacroFreeNameEnum) {\n    MacroFreeNameEnum["DMN"] = "vdcp-macro";\n    MacroFreeNameEnum["BPMN"] = "vbcp-macro";\n})(MacroFreeNameEnum || (MacroFreeNameEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app/plugin-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/browser/key-name.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "i": () => (/* binding */ KeyNameEnum)\n/* harmony export */ });\nvar KeyNameEnum;\n(function (KeyNameEnum) {\n    KeyNameEnum["Tab"] = "Tab";\n    KeyNameEnum["Enter"] = "Enter";\n    KeyNameEnum["Shift"] = "Shift";\n    KeyNameEnum["Control"] = "Control";\n    KeyNameEnum["Alt"] = "Alt";\n    KeyNameEnum["CapsLock"] = "CapsLock";\n    KeyNameEnum["Escape"] = "Escape";\n    KeyNameEnum["Space"] = "Space";\n    KeyNameEnum["PageUp"] = "PageUp";\n    KeyNameEnum["PageDown"] = "PageDown";\n    KeyNameEnum["ArrowLeft"] = "ArrowLeft";\n    KeyNameEnum["ArrowUp"] = "ArrowUp";\n    KeyNameEnum["ArrowRight"] = "ArrowRight";\n    KeyNameEnum["ArrowDown"] = "ArrowDown";\n})(KeyNameEnum || (KeyNameEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/browser/key-name.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dialog/template-names.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "X": () => (/* binding */ TemplateNamesEnum)\n/* harmony export */ });\nvar TemplateNamesEnum;\n(function (TemplateNamesEnum) {\n    TemplateNamesEnum["EXPORT_PNG_DIALOG"] = "exportPngDialog";\n    TemplateNamesEnum["USER_MENTION_DISPLAY"] = "userMentionDisplay";\n    TemplateNamesEnum["CONFLUENCE_LABEL"] = "confluenceLabel";\n    TemplateNamesEnum["CREATE_WIZARD"] = "createWizard";\n    TemplateNamesEnum["CREATE_WIZARD_DIALOG"] = "createWizardDialog";\n    TemplateNamesEnum["EXPORT_CSV_DIALOG"] = "exportCsvDialog";\n    TemplateNamesEnum["EXPORT_TABLE_TO_CONFLUENCE"] = "exportTableToConfluence";\n    TemplateNamesEnum["DIFFER"] = "differ";\n    TemplateNamesEnum["DIFFER_TABLE"] = "differTable";\n    TemplateNamesEnum["DIFFER_DIALOG"] = "differDialog";\n    TemplateNamesEnum["DIFFER_PREVIEW_DIALOG"] = "differPreviewDialog";\n    TemplateNamesEnum["DIAGRAM_AS_TABLE"] = "diagramAsTable";\n    TemplateNamesEnum["XML_EDITOR"] = "xmlEditor";\n    TemplateNamesEnum["SHORTCUT_TABLE"] = "shortcutTable";\n    TemplateNamesEnum["WELCOME_SCREEN_DIALOG"] = "welcomeScreenDialog";\n    TemplateNamesEnum["USER_SURVEY_2022_DIALOG"] = "userSurvey2022Dialog";\n    TemplateNamesEnum["MACRO_DIALOG_ENTERPRISE"] = "macroDialogEnterprise";\n    TemplateNamesEnum["MACRO_DIALOG_PROCESS_NET"] = "macroDialogProcessNet";\n    TemplateNamesEnum["PLUGIN_ANALYSIS_DIALOG"] = "pluginAnalysisDialog";\n    TemplateNamesEnum["ATTRIBUTE_PANEL"] = "attributePanel";\n    TemplateNamesEnum["MACRO_CONFIGURATION_DIALOG"] = "macroConfigurationDialog";\n    TemplateNamesEnum["MDF_EDIT_FIELD_INSTANCE"] = "mdfEditFieldInstance";\n    TemplateNamesEnum["LINTER_TABLE"] = "linterTable";\n    TemplateNamesEnum["LINTER"] = "linter";\n    TemplateNamesEnum["INCOMING_DIAGRAM_LINKS"] = "incomingDiagramLinks";\n    TemplateNamesEnum["SHOW_DIAGRAM_DIALOG"] = "showDiagramDialog";\n    TemplateNamesEnum["IMAGE_PREVIEW_DIALOG"] = "imagePreviewDialog";\n    TemplateNamesEnum["PDF_PREVIEW_DIALOG"] = "pdfPreviewDialog";\n    TemplateNamesEnum["JIRA_ISSUE_PREVIEW_DIALOG"] = "jiraIssuePreviewTemplate";\n    TemplateNamesEnum["ADD_ELEMENT_LINK_DIAOLG"] = "addElementLinkDialog";\n    TemplateNamesEnum["VERSION_HISTORY_DIALOG"] = "versionHistoryDialog";\n    TemplateNamesEnum["COMMENT_DIALOG"] = "commentDialog";\n    TemplateNamesEnum["NAVBAR"] = "navbar";\n    TemplateNamesEnum["VIADEE_INFO_DIALOG"] = "viadeeInfoDialog";\n    TemplateNamesEnum["DOWNLOAD_DIAGRAM_DIALOG"] = "downloadDiagramDialog";\n    TemplateNamesEnum["IMPORT_EXISTING_DIAGRAM_DIALOG"] = "importExistingDiagramDialog";\n    TemplateNamesEnum["NEWS_MESSAGE_BOX"] = "newsMessageBox";\n    TemplateNamesEnum["NEWS_MESSAGE_ENTRIES"] = "newsMessageEntries";\n    TemplateNamesEnum["VERSION_NAME_DIALOG"] = "versionNameDialog";\n    TemplateNamesEnum["TUTORIAL_DIALOG"] = "tutorialDialog";\n    TemplateNamesEnum["VERSION_DROPDOWN_ITEMS"] = "versionDropdownItems";\n    TemplateNamesEnum["WARNING_DIALOG"] = "warningDialog";\n    TemplateNamesEnum["IMPORT_VCS_DIAGRAM_DIALOG"] = "importVCSDiagramDialog";\n    TemplateNamesEnum["PUSH_TO_VCS_DIALOG"] = "pushToVCSDialog";\n})(TemplateNamesEnum || (TemplateNamesEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dialog/template-names.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dialog/warning-dialog-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "K": () => (/* binding */ WarningDialogTypeEnum)\n/* harmony export */ });\nvar WarningDialogTypeEnum;\n(function (WarningDialogTypeEnum) {\n    WarningDialogTypeEnum["PAGE_NOT_SAVED"] = "page-not-saved";\n    WarningDialogTypeEnum["SAVE_BEFORE_IMPORT"] = "save-before-import";\n    WarningDialogTypeEnum["SAVE_BEFORE_VCS_PUSH"] = "save-before-vcs-push";\n    WarningDialogTypeEnum["SAVE_BEFORE_EXIT"] = "save-before-exit";\n    WarningDialogTypeEnum["SAVE_BEFORE_OPEN_CONFIGS"] = "save-before-open-configs";\n    WarningDialogTypeEnum["LOADING_BROKEN_XML"] = "loading-broken-xml";\n    WarningDialogTypeEnum["SAVING_INVALID_XML"] = "saving-invalid-xml";\n    WarningDialogTypeEnum["SAVING_XML_WITH_WARNINGS"] = "saving-xml-with-warnings";\n    WarningDialogTypeEnum["WRONG_FILE_FORMAT"] = "wrong-file-format";\n    WarningDialogTypeEnum["RESET_DIAGRAM"] = "reset-diagram";\n    WarningDialogTypeEnum["RESET_DIAGRAM_AND_SAVED_IN_BETWEEN"] = "reset-diagram-and-saved-in-between";\n    WarningDialogTypeEnum["DIAGRAM_SAVED_IN_BETWEEN"] = "saved-in-between";\n    WarningDialogTypeEnum["DIFFER_DIAGRAM_TOO_BIG"] = "differ-diagram-too-big";\n    WarningDialogTypeEnum["DIFFER_FILE_DOES_NOT_EXIST"] = "differ-file-does-not-exist";\n    WarningDialogTypeEnum["NO_VERSIONS_TO_COMPARE"] = "no-versions-to-compare";\n    WarningDialogTypeEnum["START_MIGRATION"] = "start-migration";\n    WarningDialogTypeEnum["BROWSER_NOT_SUPPORTED"] = "browser-not-supported";\n    WarningDialogTypeEnum["NO_PNG_UPLOAD"] = "no-png-upload";\n    WarningDialogTypeEnum["SESSION_EXPIRED"] = "session-expired";\n    WarningDialogTypeEnum["NO_CONNECTION"] = "no-connection";\n    WarningDialogTypeEnum["LICENSE_NOT_VALID"] = "license-not-valid";\n    WarningDialogTypeEnum["SOME_ERROR_APPEARED"] = "some-error-appeared";\n    WarningDialogTypeEnum["ATTACHMENTS_NOT_UPLOADED"] = "attachments-not-uploaded";\n    WarningDialogTypeEnum["EDITOR_MACRO_NOT_EXIST"] = "editor-macro-not-exist";\n    WarningDialogTypeEnum["LEGACY_WIKILINKS"] = "legacy-links";\n    WarningDialogTypeEnum["MACRO_NOT_ALLOWED_HERE"] = "macro-not-allowed-here";\n    WarningDialogTypeEnum["DUPLICATE_RENAME_ERROR"] = "duplicate-rename-error";\n    WarningDialogTypeEnum["PNG_RENAME_ERROR"] = "png-rename-error";\n    WarningDialogTypeEnum["PNG_COPY_ERROR"] = "png-copy-error";\n    WarningDialogTypeEnum["XML_RENAME_ERROR"] = "xml-rename-error";\n    WarningDialogTypeEnum["TABLE_NOT_EXPORTED"] = "table-not-exported";\n    WarningDialogTypeEnum["VERSION_NOT_AVAILABLE_EDITOR"] = "version-not-available";\n    WarningDialogTypeEnum["AUTHENTICATION_TOKEN_REQUIRED"] = "jira-authentication-token-required";\n    WarningDialogTypeEnum["DELETE_RESOLVED_COMMENTS"] = "delete-resolved-comments";\n    WarningDialogTypeEnum["RESET_ADMIN_PAGE_CONFIGS"] = "reset-admin-page-configs";\n    WarningDialogTypeEnum["DIAGRAM_ALREADY_EXISTS_ON_PAGE"] = "diagram-already-exists-on-page";\n    WarningDialogTypeEnum["DELETE_ALL_LINKS"] = "delete-all-diagram-links";\n    WarningDialogTypeEnum["SYNC_ALL_LINKS"] = "sync-all-diagram-links";\n    WarningDialogTypeEnum["NEW_DIAGRAM_NOT_SAVED"] = "new-diagram-not-saved";\n    WarningDialogTypeEnum["NEW_DIAGRAM_NOT_SAVED_YET"] = "new-diagram-not-saved-yet";\n    WarningDialogTypeEnum["COPY_DIAGRAM_AND_CREATE_MACRO_ERROR"] = "copy-diagram-and-create-macro-error";\n    WarningDialogTypeEnum["UPLOAD_DIAGRAM_AND_CREATE_MACRO_ERROR"] = "upload-diagram-and-create-macro-error";\n    WarningDialogTypeEnum["FETCH_DIAGRAM_AND_CREATE_MACRO_ERROR"] = "fetch-diagram-and-create-macro-error";\n    WarningDialogTypeEnum["FETCH_DIAGRAM_FROM_VCS_ERROR"] = "fetch-diagram-from-vcs-error";\n    WarningDialogTypeEnum["INVALID_SIMULATION_MODEL_ERROR"] = "invalid-simulation-model-error";\n})(WarningDialogTypeEnum || (WarningDialogTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dialog/warning-dialog-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/element-links/overlay-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Iu": () => (/* binding */ OverlayTypeLabelEnum),\n/* harmony export */   "ws": () => (/* binding */ OverlayTypeXmlEnum)\n/* harmony export */ });\n/* unused harmony exports OverlayTypeIconClassEnum, OverlayTypeConfigKeyEnum, DistinctOverlayType, OverlayDefaultAction */\nvar OverlayTypeXmlEnum;\n(function (OverlayTypeXmlEnum) {\n    OverlayTypeXmlEnum["EMBEDDED_COMMENTS"] = "viadee:Comment";\n    OverlayTypeXmlEnum["DOCUMENTATION"] = "bpmn:documentation";\n    OverlayTypeXmlEnum["MARKDOWN_DOCUMENTATION"] = "viadee:MarkdownDocumentation";\n    OverlayTypeXmlEnum["LEGACY_WIKILINK"] = "viadee:WikiLinks";\n    OverlayTypeXmlEnum["BPMN"] = "viadee:BpmnLinks";\n    OverlayTypeXmlEnum["DMN_ENTERPRISE"] = "viadee:DmnEnterpriseLinks";\n    OverlayTypeXmlEnum["DMN"] = "viadee:DmnLinks";\n    OverlayTypeXmlEnum["CONFLUENCE_PAGE"] = "viadee:PageLinks";\n    OverlayTypeXmlEnum["CONFLUENCE_ATTACHMENT"] = "viadee:ConfluenceAttachmentLink";\n    OverlayTypeXmlEnum["EXTERNAL_CONTENT"] = "viadee:ExternalLinks";\n    OverlayTypeXmlEnum["JIRA_ISSUE"] = "viadee:JiraIssueLink";\n    OverlayTypeXmlEnum["MDF_INSTANCE"] = "viadee:MdfInstance";\n    OverlayTypeXmlEnum["ANY"] = "viadee:AnyLinks";\n})(OverlayTypeXmlEnum || (OverlayTypeXmlEnum = {}));\nvar OverlayTypeLabelEnum;\n(function (OverlayTypeLabelEnum) {\n    OverlayTypeLabelEnum["EMBEDDED_COMMENTS"] = "embedded-comments";\n    OverlayTypeLabelEnum["DOCUMENTATION"] = "documentation";\n    OverlayTypeLabelEnum["MARKDOWN_DOCUMENTATION"] = "viadee:MarkdownDocumentation";\n    OverlayTypeLabelEnum["BPMN"] = "bpmn";\n    OverlayTypeLabelEnum["BPMN_NEW_TARGET_PAGE"] = "bpmn-new-target-page";\n    OverlayTypeLabelEnum["LEGACY_BPMN"] = "attachment";\n    OverlayTypeLabelEnum["DMN_ENTERPRISE"] = "dmn-enterprise";\n    OverlayTypeLabelEnum["DMN"] = "dmn";\n    OverlayTypeLabelEnum["DMN_NEW_TARGET_PAGE"] = "dmn-new-target-page";\n    OverlayTypeLabelEnum["CONFLUENCE_PAGE"] = "confluence-page";\n    OverlayTypeLabelEnum["LEGACY_CONFLUENCE_PAGE"] = "search-page";\n    OverlayTypeLabelEnum["CONFLUENCE_ATTACHMENT"] = "confluence-attachment";\n    OverlayTypeLabelEnum["EXTERNAL_CONTENT"] = "external-content";\n    OverlayTypeLabelEnum["LEGACY_EXTERNAL_CONTENT"] = "external";\n    OverlayTypeLabelEnum["JIRA_ISSUE"] = "jira-issue";\n    OverlayTypeLabelEnum["MDF_INSTANCE"] = "mdf-instance";\n})(OverlayTypeLabelEnum || (OverlayTypeLabelEnum = {}));\nvar OverlayTypeIconClassEnum;\n(function (OverlayTypeIconClassEnum) {\n    OverlayTypeIconClassEnum["EMBEDDED_COMMENTS"] = "";\n    OverlayTypeIconClassEnum["DOCUMENTATION"] = "vxcp-ent-icon-documentation";\n    OverlayTypeIconClassEnum["BPMN"] = "vxcp-ent-icon-bpmn";\n    OverlayTypeIconClassEnum["DMN_ENTERPRISE"] = "vxcp-ent-icon-dmn";\n    OverlayTypeIconClassEnum["DMN"] = "vxcp-ent-icon-dmn";\n    OverlayTypeIconClassEnum["CONFLUENCE_PAGE"] = "vxcp-ent-icon-confluence-page";\n    OverlayTypeIconClassEnum["CONFLUENCE_ATTACHMENT"] = "vxcp-ent-icon-attachment";\n    OverlayTypeIconClassEnum["EXTERNAL_CONTENT"] = "vxcp-ent-icon-external";\n    OverlayTypeIconClassEnum["JIRA_ISSUE"] = "vxcp-ent-icon-jira-issue";\n    OverlayTypeIconClassEnum["MDF_INSTANCE"] = "vxcp-ent-icon-mdf-instance";\n})(OverlayTypeIconClassEnum || (OverlayTypeIconClassEnum = {}));\nvar OverlayTypeConfigKeyEnum;\n(function (OverlayTypeConfigKeyEnum) {\n    OverlayTypeConfigKeyEnum["EMBEDDED_COMMENTS"] = "showEmbeddedComments";\n    OverlayTypeConfigKeyEnum["DOCUMENTATION"] = "showDocumentation";\n    OverlayTypeConfigKeyEnum["BPMN"] = "showBpmnLinks";\n    OverlayTypeConfigKeyEnum["DMN_ENTERPRISE"] = "showDmnLinks";\n    OverlayTypeConfigKeyEnum["DMN"] = "showDmnLinks";\n    OverlayTypeConfigKeyEnum["CONFLUENCE_PAGE"] = "showConfluencePageLinks";\n    OverlayTypeConfigKeyEnum["CONFLUENCE_ATTACHMENT"] = "showConfluenceAttachmentLinks";\n    OverlayTypeConfigKeyEnum["EXTERNAL_CONTENT"] = "showExternalContentLinks";\n    OverlayTypeConfigKeyEnum["JIRA_ISSUE"] = "showJiraIssueLinks";\n    OverlayTypeConfigKeyEnum["MDF_INSTANCE"] = "showMdfInstanceLinks";\n})(OverlayTypeConfigKeyEnum || (OverlayTypeConfigKeyEnum = {}));\nvar DistinctOverlayType;\n(function (DistinctOverlayType) {\n    DistinctOverlayType["DOCUMENTATION"] = "documentation";\n    DistinctOverlayType["BPMN"] = "bpmn";\n    DistinctOverlayType["DMN"] = "dmn";\n    DistinctOverlayType["CONFLUENCE_PAGE"] = "confluence-page";\n    DistinctOverlayType["EXTERNAL_CONTENT"] = "external-content";\n    DistinctOverlayType["CONFLUENCE_ATTACHMENT"] = "confluence-attachment";\n    DistinctOverlayType["JIRA_ISSUE"] = "jira";\n    DistinctOverlayType["MDF_INSTANCE"] = "mdf";\n})(DistinctOverlayType || (DistinctOverlayType = {}));\nvar OverlayDefaultAction;\n(function (OverlayDefaultAction) {\n    OverlayDefaultAction["OPEN_PANEL"] = "openPanel";\n    OverlayDefaultAction["WONT_DRAW"] = "wontDraw";\n})(OverlayDefaultAction || (OverlayDefaultAction = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/element-links/overlay-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/extensions/panel-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* unused harmony export PanelTypeEnum */\nvar PanelTypeEnum;\n(function (PanelTypeEnum) {\n    PanelTypeEnum["VBCP_PANEL"] = "VBCP_PANEL";\n    PanelTypeEnum["BPMN_JS_PANEL"] = "BPMN_JS_PANEL";\n})(PanelTypeEnum || (PanelTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/extensions/panel-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/extensions/resize-direction.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "c": () => (/* binding */ ResizeDirectionEnum)\n/* harmony export */ });\nvar ResizeDirectionEnum;\n(function (ResizeDirectionEnum) {\n    ResizeDirectionEnum["TOP_TO_BOTTOM"] = "TOP_TO_BOTTOM";\n    ResizeDirectionEnum["BOTTOM_TO_TOP"] = "BOTTOM_TO_TOP";\n    ResizeDirectionEnum["LEFT_TO_RIGHT"] = "LEFT_TO_RIGHT";\n    ResizeDirectionEnum["RIGHT_TO_LEFT"] = "RIGHT_TO_LEFT";\n})(ResizeDirectionEnum || (ResizeDirectionEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/extensions/resize-direction.enum.ts?')},"../../../../../../vXCP-enterprise-core/platform-specific/on-premise/platformMDF.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  "getPlatformMdfService": () => (/* binding */ getPlatformMdfService)\n});\n\n// EXTERNAL MODULE: ../../../../../../MDF-core/core-js/app/services/calculation.service.ts\nvar calculation_service = __webpack_require__("../../../../../../MDF-core/core-js/app/services/calculation.service.ts");\n// EXTERNAL MODULE: ../../../../../../MDF-core/core-js/app/services/id.service.ts\nvar id_service = __webpack_require__("../../../../../../MDF-core/core-js/app/services/id.service.ts");\n// EXTERNAL MODULE: ../../../../../../MDF-core/core-js/app/services/field-definition.service.ts\nvar field_definition_service = __webpack_require__("../../../../../../MDF-core/core-js/app/services/field-definition.service.ts");\n// EXTERNAL MODULE: ../../../../../../MDF-core/core-js/app/services/field-instance.service.ts\nvar field_instance_service = __webpack_require__("../../../../../../MDF-core/core-js/app/services/field-instance.service.ts");\n// EXTERNAL MODULE: ../../../../../../MDF-core/core-js/app/services/field-rendering/field-rendering-utils.service.ts\nvar field_rendering_utils_service = __webpack_require__("../../../../../../MDF-core/core-js/app/services/field-rendering/field-rendering-utils.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/managed-data-fields.service.ts\nvar managed_data_fields_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/managed-data-fields.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/managed-data-fields-rendering-impl.service.ts\nvar managed_data_fields_rendering_impl_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/managed-data-fields-rendering-impl.service.ts");\n// EXTERNAL MODULE: ../../../../../../MDF-core/core-js/app/services/field-rendering/field-rendering-core.service.ts\nvar field_rendering_core_service = __webpack_require__("../../../../../../MDF-core/core-js/app/services/field-rendering/field-rendering-core.service.ts");\n// EXTERNAL MODULE: ../../../../../../MDF-core/core-js/app/services/mdf-sanitizer.service.ts\nvar mdf_sanitizer_service = __webpack_require__("../../../../../../MDF-core/core-js/app/services/mdf-sanitizer.service.ts");\n// EXTERNAL MODULE: ../../../../../../MDF-core/core-js/app/services/user-mention.service.ts\nvar user_mention_service = __webpack_require__("../../../../../../MDF-core/core-js/app/services/user-mention.service.ts");\n// EXTERNAL MODULE: ../../../../../../MDF-core/core-js/app/services/attribute-validator.service.ts\nvar attribute_validator_service = __webpack_require__("../../../../../../MDF-core/core-js/app/services/attribute-validator.service.ts");\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/platform-specific/on-premise/platform-mdf.service.ts\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\nclass PlatformMdfService {\n    initNumberInputValidator() {\n        return (0,attribute_validator_service/* initNumberInputValidator */.k)();\n    }\n    initManagedDataFields(managedDataFieldsService, pageId, vbcpEntId, languageService, $canvas) {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield managedDataFieldsService.initManagedDataFieldsInPanel(pageId, vbcpEntId, languageService, $canvas);\n        });\n    }\n    getMdfCalculationService(platformUtils, mdfSanitizerService) {\n        return new calculation_service/* CalculationService */.H(platformUtils, mdfSanitizerService);\n    }\n    getMdfSanitizerService() {\n        return new mdf_sanitizer_service/* MdfSanitizerService */.O();\n    }\n    getMdfIdService() {\n        return new id_service/* IdService */.K();\n    }\n    getUserMentionService(platformUtils, appTypeHtmlPrefix) {\n        return new user_mention_service/* UserMentionService */.V(platformUtils, appTypeHtmlPrefix);\n    }\n    getMdfFieldDefinitionService(appTypeHtmlPrefix, platformUtils) {\n        return new field_definition_service/* FieldDefinitionService */.y(appTypeHtmlPrefix, platformUtils);\n    }\n    getMdfFieldInstanceService(mdfIdService, platformUtils, appTypeHtmlPrefix) {\n        return new field_instance_service/* FieldInstanceService */.p(mdfIdService, platformUtils, appTypeHtmlPrefix);\n    }\n    getMdfFieldRenderingUtilsService() {\n        return new field_rendering_utils_service/* FieldRenderingUtilsService */.t();\n    }\n    getManagedDataFieldsService(xmlExtensionService, currentAppMode, managedDataFieldsRenderingService, mdfUserMentionService, mdfIdService, mdfFieldInstanceService, mdfFieldDefinitionService) {\n        return new managed_data_fields_service/* ManagedDataFieldsService */._(xmlExtensionService, currentAppMode, managedDataFieldsRenderingService, mdfUserMentionService, mdfIdService, mdfFieldInstanceService, mdfFieldDefinitionService);\n    }\n    getManagedDataFieldsRenderingImplService(mdfRenderingCoreService, mdfFieldInstanceService) {\n        return new managed_data_fields_rendering_impl_service/* ManagedDataFieldsRenderingImplService */.T(mdfRenderingCoreService, mdfFieldInstanceService);\n    }\n    getMdfFieldRenderingCoreService(mdfUserMentionService, mdfFieldDefinitionService, mdfRenderingUtilsService, mdfIdService, platformUtils, appTypeHtmlPrefix, mdfFieldInstanceService, calculationService) {\n        return new field_rendering_core_service/* FieldRenderingCoreService */.T(mdfUserMentionService, mdfFieldDefinitionService, mdfRenderingUtilsService, mdfIdService, platformUtils, appTypeHtmlPrefix, mdfFieldInstanceService, calculationService);\n    }\n}\n\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/platform-specific/on-premise/platformMDF.service.ts\n\nconst getPlatformMdfService = () => {\n    return new PlatformMdfService();\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/platform-specific/on-premise/platformMDF.service.ts_+_1_modules?')}},__webpack_module_cache__={},deferred;function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var t=__webpack_module_cache__[e]={id:e,loaded:!1,exports:{}};return __webpack_modules__[e].call(t.exports,t,t.exports,__webpack_require__),t.loaded=!0,t.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(e,n,t,r)=>{if(!n){var a=1/0;for(l=0;l<deferred.length;l++){for(var[n,t,r]=deferred[l],i=!0,o=0;o<n.length;o++)(!1&r||a>=r)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](n[o])))?n.splice(o--,1):(i=!1,r<a&&(a=r));if(i){deferred.splice(l--,1);var s=t();void 0!==s&&(e=s)}}return e}r=r||0;for(var l=deferred.length;l>0&&deferred[l-1][2]>r;l--)deferred[l]=deferred[l-1];deferred[l]=[n,t,r]},__webpack_require__.n=e=>{var n=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(n,{a:n}),n},__webpack_require__.d=(e,n)=>{for(var t in n)__webpack_require__.o(n,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:n[t]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},__webpack_require__.nmd=e=>(e.paths=[],e.children||(e.children=[]),e),__webpack_require__.j="bpmnEntPlatformMDF",(()=>{var e={bpmnEntPlatformMDF:0};__webpack_require__.O.j=n=>0===e[n];var n=(n,t)=>{var r,a,[i,o,s]=t,l=0;if(i.some((n=>0!==e[n]))){for(r in o)__webpack_require__.o(o,r)&&(__webpack_require__.m[r]=o[r]);if(s)var u=s(__webpack_require__)}for(n&&n(t);l<i.length;l++)a=i[l],__webpack_require__.o(e,a)&&e[a]&&e[a][0](),e[a]=0;return __webpack_require__.O(u)},t=self.webpackChunkVBCP=self.webpackChunkVBCP||[];t.forEach(n.bind(null,0)),t.push=n.bind(null,t.push.bind(t))})();var __webpack_exports__=__webpack_require__.O(void 0,["bpmnEntVendors","bpmnEntServices"],(()=>__webpack_require__("../../../../../../vXCP-enterprise-core/platform-specific/on-premise/platformMDF.service.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VBCP=window.VBCP||{}).bpmnEntPlatformMDF=__webpack_exports__})();