(()=>{"use strict";var __webpack_modules__={"../../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ VxcpLogger)\n/* harmony export */ });\nclass VxcpLogger {\n    constructor(pluginName, serviceName, isEnabled = true) {\n        this.pluginName = pluginName;\n        this.serviceName = serviceName;\n        this.isEnabled = isEnabled;\n    }\n    logFatal(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`FATAL@${logHeader}: ${description}`);\n        }\n    }\n    logError(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`ERROR@${logHeader}: ${description}`);\n        }\n    }\n    logWarning(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.warn(`WARNING@${logHeader}: ${description}`);\n        }\n    }\n    logInfo(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.info(`INFO@${logHeader}: ${description}`);\n        }\n    }\n    enableLogging(isEnabled = true) {\n        this.isEnabled = isEnabled;\n    }\n    getLogHeader(methodName) {\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/components/process-net-macro-dialog.component.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/warning-dialog-type.enum.ts\nvar warning_dialog_type_enum = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/warning-dialog-type.enum.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/license.service.ts\nvar license_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/license.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts\nvar language_rest_factory = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts\nvar plugin_specific_factory = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/process-net-macro-type.enum.ts\nvar ProcessNetMacroTypeEnum;\n(function (ProcessNetMacroTypeEnum) {\n    ProcessNetMacroTypeEnum["SPACE"] = "space";\n    ProcessNetMacroTypeEnum["PAGE"] = "page";\n})(ProcessNetMacroTypeEnum || (ProcessNetMacroTypeEnum = {}));\n\n// EXTERNAL MODULE: ../../../../../../core/vxcp-logger/src/vxcp-logger.ts\nvar vxcp_logger = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/id-generator.service.ts\nvar id_generator_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/id-generator.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts\nvar template_names_enum = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/utils/dialog.service.ts\nvar dialog_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/dialog.service.ts");\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/components/process-net-macro-dialog.component.ts\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\nconst PlatformMacroDialog = (0,plugin_specific_factory/* getPlatformService */.km)().getPlatformMacroDialog() || {};\nconst PlatformUtils = (0,plugin_specific_factory/* getPlatformService */.km)().getPlatformUtils() || {};\nconst PluginService = (0,plugin_specific_factory/* getPluginService */.j)();\nconst licenseService = new license_service/* LicenseService */.E();\nconst dialogService = new dialog_service/* DialogService */.x();\nconst languageRestService = language_rest_factory/* getLanguageRestService */.GU();\nconst macroName = PluginService.getProcessNetMacroName();\nconst pluginShorthand = PluginService.getPluginShorthand();\nconst dialogId = `#vxcp-ent-dialog-process-net-macro-${pluginShorthand}`;\nconst createSpaceMacroTabId = `vxcp-ent-dialog-process-net-macro-${pluginShorthand}-tab-space`;\nconst createPageMacroTabId = `vxcp-ent-dialog-process-net-macro-${pluginShorthand}-tab-page`;\nconst errorClass = `.vxcp-ent-dialog-process-net-macro-${pluginShorthand}-error`;\nlet currentMacroType;\nconst vxcpLogger = new vxcp_logger/* default */.Z((0,plugin_specific_factory/* getPluginService */.j)().getPluginName(), "macroDialogProcessNet");\n(($) => __awaiter(void 0, void 0, void 0, function* () {\n    yield PlatformMacroDialog.bindCodeToRte();\n    yield initMacroDialog($);\n}))($);\nfunction initMacroDialog($) {\n    return __awaiter(this, void 0, void 0, function* () {\n        const customDialog = yield PlatformUtils.getTemplate(template_names_enum/* TemplateNamesEnum.MACRO_DIALOG_PROCESS_NET */.X.MACRO_DIALOG_PROCESS_NET, { pluginShorthand });\n        $("body").append(customDialog);\n        AJS.tabs.setup();\n        currentMacroType = ProcessNetMacroTypeEnum.SPACE;\n        const $dialog = $(dialogId);\n        const $cancel = $(dialogId + "-close");\n        const $submit = $(dialogId + "-submit");\n        const $spaceInput = $(dialogId + "-space-name-input");\n        const $pageInput = $(dialogId + "-page-name-input");\n        const errorId = $(dialogId + "-error");\n        $dialog.on("tabSelect", (e) => __awaiter(this, void 0, void 0, function* () {\n            handleMacroDialogTabSelect(e);\n        }));\n        $cancel.off();\n        $cancel.on("click", (e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            PlatformMacroDialog.hideProcessNetMacroDialog();\n        });\n        $dialog.on("tabSelect", (e) => __awaiter(this, void 0, void 0, function* () {\n            handleMacroDialogTabSelect(e);\n        }));\n        dialog_service/* DialogService.initEscKey */.x.initEscKey($cancel, $spaceInput);\n        dialog_service/* DialogService.initEnterKey */.x.initEnterKey($submit, $spaceInput);\n        Confluence.Binder.autocompleteSpace($(`#vxcp-ent-dialog-process-net-macro-${pluginShorthand}-space-autocomplete-binder`));\n        Confluence.Binder.autocompletePage($(`#vxcp-ent-dialog-process-net-macro-${pluginShorthand}-page-autocomplete-binder`));\n        AJS.tabs.change($(`#${createSpaceMacroTabId}`));\n        let selectedSpaceKey = "";\n        let selectedPageId = "";\n        $spaceInput.on("keydown", () => {\n            selectedSpaceKey = "";\n            $submit.prop("disabled", true);\n        });\n        $pageInput.on("keydown", () => {\n            selectedPageId = "";\n            $submit.prop("disabled", true);\n        });\n        $spaceInput.on({\n            "selected.autocomplete-content": (event, params) => {\n                event.stopPropagation();\n                event.preventDefault();\n                $(errorClass).empty();\n                selectedSpaceKey = params.content.key;\n                $submit.prop("disabled", false);\n            },\n        });\n        $pageInput.on({\n            "selected.autocomplete-content": (event, params) => {\n                event.stopPropagation();\n                event.preventDefault();\n                $(errorClass).empty();\n                selectedPageId = params.content.id;\n                $submit.prop("disabled", false);\n            },\n        });\n        $submit.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            e.stopPropagation();\n            e.preventDefault();\n            if (!checkInputNotEmpty(selectedSpaceKey, selectedPageId)) {\n                const errorText = yield PlatformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.process-net.macro-dialog.no-empty-input");\n                $(`${errorId}-${currentMacroType}`).text(errorText);\n                return;\n            }\n            yield submitMacro(selectedSpaceKey, selectedPageId);\n        }));\n        PlatformMacroDialog.registerOpenerFunctionProcessNet(insertEditMacro);\n    });\n}\nfunction checkInputNotEmpty(selectedSpaceKey, selectedPageId) {\n    if (currentMacroType === ProcessNetMacroTypeEnum.SPACE) {\n        return !!selectedSpaceKey;\n    }\n    else if (currentMacroType === ProcessNetMacroTypeEnum.PAGE) {\n        return !!selectedPageId;\n    }\n    return false;\n}\nfunction handleMacroDialogTabSelect(e) {\n    switch (e.target.id) {\n        case createSpaceMacroTabId:\n            currentMacroType = ProcessNetMacroTypeEnum.SPACE;\n            break;\n        case createPageMacroTabId:\n            currentMacroType = ProcessNetMacroTypeEnum.PAGE;\n            break;\n    }\n}\nfunction clearFields() {\n    const $spaceInput = $(dialogId + "-space-name-input");\n    const $pageInput = $(dialogId + "-page-name-input");\n    const $error = $(errorClass);\n    $spaceInput.val("");\n    $pageInput.val("");\n    $error.text("");\n}\nfunction submitMacro(spaceKey, pageId) {\n    return __awaiter(this, void 0, void 0, function* () {\n        let currentParams = {};\n        const processNetId = (0,id_generator_service/* generateVbcpProcessNetId */.l)();\n        switch (currentMacroType) {\n            case ProcessNetMacroTypeEnum.SPACE:\n                currentParams = { "vxcp-process-net-id": processNetId, spaceKey, pageId: "" };\n                break;\n            case ProcessNetMacroTypeEnum.PAGE:\n                currentParams = { "vxcp-process-net-id": processNetId, pageId, spaceKey: "" };\n                break;\n        }\n        const macro = {\n            name: macroName.trim(),\n            params: currentParams,\n            body: "",\n        };\n        PlatformUtils.addMacroToPage(macro, dialogId);\n    });\n}\nfunction resetMacroDialog($submit, $loadingDiv, $form, $dialog) {\n    clearFields();\n    $(dialogId + "-restricted-warning").hide();\n    $submit.hide();\n    $loadingDiv.show();\n    $form.hide();\n    $dialog.removeClass("aui-dialog2-warning");\n}\nfunction hideLoadingShowContent($loadingDiv, $form, $submit, $input) {\n    $loadingDiv.hide();\n    $form.show();\n    $submit.show();\n    $input.focus();\n}\nfunction hideLoadingShowError($loadingDiv, $dialog) {\n    vxcpLogger.logInfo("hideLoadingShowError", "The diagram cannot be inserted due to space restrictions. Please contact your system administrator.");\n    $loadingDiv.hide();\n    $dialog.addClass("aui-dialog2-warning");\n    $(dialogId + "-restricted-warning").show();\n}\nfunction checkSpacePermissions(spaceKey, $loadingDiv, $dialog, $form, $submit, $input) {\n    return __awaiter(this, void 0, void 0, function* () {\n        const appPathComponent = languageRestService.getPluginRestComponent();\n        const restUrlSetting = PlatformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/settings`);\n        const restPathSpaces = `/rest/${appPathComponent}/1.0/spaces/${spaceKey}`;\n        const restUrlSpaces = PlatformUtils.buildRestUrl(restPathSpaces);\n        try {\n            const globalSettings = yield PlatformUtils.makeRequest({\n                cache: false,\n                url: restUrlSetting,\n                type: "GET",\n            });\n            if (!globalSettings || globalSettings.restricted) {\n                const isCurrentSpaceEnabled = yield PlatformUtils.makeRequest({\n                    cache: false,\n                    url: restUrlSpaces,\n                    type: "GET",\n                });\n                if (!isCurrentSpaceEnabled) {\n                    hideLoadingShowError($loadingDiv, $dialog);\n                    return;\n                }\n            }\n            hideLoadingShowContent($loadingDiv, $form, $submit, $input);\n        }\n        catch (requestErr) {\n            hideLoadingShowError($loadingDiv, $dialog);\n            vxcpLogger.logWarning("checkSpacePermissions", "While trying to check for space restrictions, the request crashed. Please check the following error for details. Not allowing the creation of new macros.", requestErr);\n        }\n    });\n}\nfunction insertEditMacro(macro) {\n    return __awaiter(this, void 0, void 0, function* () {\n        yield PlatformMacroDialog.lazyLoadI18nTexts();\n        const $dialog = $(dialogId);\n        const $submit = $(dialogId + "-submit");\n        const $input = $(dialogId + "-name-input");\n        const licenseType = yield licenseService.getLicenseType();\n        const licenseFlag = yield licenseService.licenseHandlingForMacroDialogBefore(licenseType);\n        if (!licenseFlag) {\n            return;\n        }\n        const envParams = yield PlatformUtils.getParams();\n        if (envParams.cloudContentType === "comment") {\n            yield dialogService.confirmWarningDialog(warning_dialog_type_enum/* WarningDialogTypeEnum.MACRO_NOT_ALLOWED_HERE */.K.MACRO_NOT_ALLOWED_HERE);\n            return;\n        }\n        if (macro.params) {\n            const spaceKey = macro.params.spaceKey;\n            const $form = $(dialogId + " form");\n            const $loadingDiv = $(dialogId + "-loading-space-permissions");\n            resetMacroDialog($submit, $loadingDiv, $form, $dialog);\n            const spaceInput = $(`${dialogId}-space-name-input`);\n            spaceInput.val(spaceKey);\n            AJS.dialog2(dialogId).show();\n            const spaceKeyForPermission = envParams.spaceKey;\n            yield checkSpacePermissions(spaceKeyForPermission, $loadingDiv, $dialog, $form, $submit, $input);\n        }\n        else {\n            const $form = $(dialogId + " form");\n            const $loadingDiv = $(dialogId + "-loading-space-permissions");\n            resetMacroDialog($submit, $loadingDiv, $form, $dialog);\n            AJS.dialog2(dialogId).show();\n            const spaceKey = envParams.spaceKey;\n            yield checkSpacePermissions(spaceKey, $loadingDiv, $dialog, $form, $submit, $input);\n        }\n        yield licenseService.licenseHandlingForMacroDialogAfter(licenseType);\n    });\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/components/process-net-macro-dialog.component.ts_+_1_modules?')},"../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "GU": () => (/* binding */ getLanguageRestService)\n/* harmony export */ });\n/* unused harmony exports getLanguageRestServiceForPluginType, getEmptyLanguageService */\n/* harmony import */ var _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts");\n\n\nconst getLanguageRestService = () => {\n    if (false) {}\n    else {\n        return getBpmnRestService();\n    }\n};\nconst getLanguageRestServiceForPluginType = (pluginType) => {\n    if (pluginType === PluginTypeEnum.DMN_ENTERPRISE) {\n        return getDmnRestService();\n    }\n    else {\n        return getBpmnRestService();\n    }\n};\nconst getEmptyLanguageService = () => {\n    return new EmptyLanguageRestService();\n};\nconst getBpmnRestService = () => {\n    return window.VBCP.bpmnEntLanguageService.getLanguageRestService();\n};\nconst getDmnRestService = () => {\n    return window.VDCPENT.dmnEntLanguageService.getLanguageRestService();\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "j": () => (/* binding */ getPluginService),\n/* harmony export */   "km": () => (/* binding */ getPlatformService)\n/* harmony export */ });\n/* unused harmony export getPlatformMDFService */\nconst getPluginService = () => {\n    if (false) {}\n    else {\n        return getBpmnPluginService();\n    }\n};\nconst getDmnPluginService = () => {\n    return window.VDCPENT.dmnEntPlugin;\n};\nconst getBpmnPluginService = () => {\n    return window.VBCP.bpmnEntPlugin;\n};\nconst getPlatformService = () => {\n    if (false) {}\n    else {\n        return getBpmnPlatformService();\n    }\n};\nconst getPlatformMDFService = () => {\n    if (false) {}\n    else {\n        return getBpmnPlatformMDFService();\n    }\n};\nconst getDmnPlatformService = () => {\n    return window.VDCPENT.dmnEntPlatformJS;\n};\nconst getBpmnPlatformService = () => {\n    return window.VBCP.bpmnEntPlatformJS;\n};\nconst getDmnPlatformMDFService = () => {\n    return window.VDCPENT.dmnEntPlatformMDF;\n};\nconst getBpmnPlatformMDFService = () => {\n    return window.VBCP.bpmnEntPlatformMDF;\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-mode.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "v": () => (/* binding */ AppModeEnum)\n/* harmony export */ });\n/* unused harmony export APP_MODE_CLASSES */\nvar AppModeEnum;\n(function (AppModeEnum) {\n    AppModeEnum["EDITOR"] = "EDITOR";\n    AppModeEnum["PRESENTATION"] = "PRESENTATION";\n    AppModeEnum["DIFFER"] = "DIFFER";\n    AppModeEnum["DIFFER_WITH_MINIMAP"] = "DIFFER_WITH_MINIMAP";\n    AppModeEnum["XMLEDITOR"] = "XMLEDITOR";\n    AppModeEnum["TABLE"] = "TABLE";\n    AppModeEnum["VIEWER"] = "VIEWER";\n    AppModeEnum["VIEWER_DIALOG"] = "VIEWER_DIALOG";\n})(AppModeEnum || (AppModeEnum = {}));\nconst APP_MODE_CLASSES = {\n    [AppModeEnum.EDITOR]: "vxcp-ent-app-mode-editor",\n    [AppModeEnum.PRESENTATION]: "vxcp-ent-app-mode-presentation",\n    [AppModeEnum.XMLEDITOR]: "vxcp-ent-app-mode-xml-editor",\n    [AppModeEnum.DIFFER]: "vxcp-ent-app-mode-differ",\n    [AppModeEnum.DIFFER_WITH_MINIMAP]: "vxcp-ent-app-mode-differ",\n    [AppModeEnum.TABLE]: "vxcp-ent-app-mode-table",\n    [AppModeEnum.VIEWER_DIALOG]: "vxcp-ent-app-mode-viewer-dialog",\n    [AppModeEnum.VIEWER]: "vxcp-ent-app-mode-viewer",\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-mode.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-rest-path.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* unused harmony exports EnterpriseRestPathEnum, EnterpriseActionPathEnum, FreeRestPathEnum */\nvar EnterpriseRestPathEnum;\n(function (EnterpriseRestPathEnum) {\n    EnterpriseRestPathEnum["BPMN"] = "bpmn-modeler-enterprise";\n    EnterpriseRestPathEnum["DMN"] = "dmn-plugin-enterprise";\n})(EnterpriseRestPathEnum || (EnterpriseRestPathEnum = {}));\nvar EnterpriseActionPathEnum;\n(function (EnterpriseActionPathEnum) {\n    EnterpriseActionPathEnum["BPMN"] = "bpmn-plugin-enterprise";\n    EnterpriseActionPathEnum["DMN"] = "dmn-plugin-enterprise";\n})(EnterpriseActionPathEnum || (EnterpriseActionPathEnum = {}));\nvar FreeRestPathEnum;\n(function (FreeRestPathEnum) {\n    FreeRestPathEnum["BPMN"] = "bpmn-modeler";\n    FreeRestPathEnum["DMN"] = "dmn-modeler";\n})(FreeRestPathEnum || (FreeRestPathEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-rest-path.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dmn-table-mode.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "J": () => (/* binding */ DmnTableModeEnum)\n/* harmony export */ });\nvar DmnTableModeEnum;\n(function (DmnTableModeEnum) {\n    DmnTableModeEnum["VIEWER"] = "view";\n    DmnTableModeEnum["EDITOR"] = "edit";\n})(DmnTableModeEnum || (DmnTableModeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dmn-table-mode.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/from-mode.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "p": () => (/* binding */ FromModeEnum)\n/* harmony export */ });\nvar FromModeEnum;\n(function (FromModeEnum) {\n    FromModeEnum["URL"] = "URL";\n    FromModeEnum["CONFLUENCE_VIEWER"] = "CONFLUENCE_VIEWER";\n    FromModeEnum["CONFLUENCE_EDITOR"] = "CONFLUENCE_EDITOR";\n})(FromModeEnum || (FromModeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/from-mode.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/key-name.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "i": () => (/* binding */ KeyNameEnum)\n/* harmony export */ });\nvar KeyNameEnum;\n(function (KeyNameEnum) {\n    KeyNameEnum["Tab"] = "Tab";\n    KeyNameEnum["Enter"] = "Enter";\n    KeyNameEnum["Shift"] = "Shift";\n    KeyNameEnum["Control"] = "Control";\n    KeyNameEnum["Alt"] = "Alt";\n    KeyNameEnum["CapsLock"] = "CapsLock";\n    KeyNameEnum["Escape"] = "Escape";\n    KeyNameEnum["Space"] = "Space";\n    KeyNameEnum["PageUp"] = "PageUp";\n    KeyNameEnum["PageDown"] = "PageDown";\n    KeyNameEnum["ArrowLeft"] = "ArrowLeft";\n    KeyNameEnum["ArrowUp"] = "ArrowUp";\n    KeyNameEnum["ArrowRight"] = "ArrowRight";\n    KeyNameEnum["ArrowDown"] = "ArrowDown";\n})(KeyNameEnum || (KeyNameEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/key-name.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/license-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "y": () => (/* binding */ LicenseTypeEnum)\n/* harmony export */ });\nvar LicenseTypeEnum;\n(function (LicenseTypeEnum) {\n    LicenseTypeEnum["VALID"] = "VALID";\n    LicenseTypeEnum["MAINTENANCE_EXPIRED"] = "MAINTENANCE_EXPIRED";\n    LicenseTypeEnum["EVAL"] = "EVAL";\n    LicenseTypeEnum["INVALID"] = "INVALID";\n})(LicenseTypeEnum || (LicenseTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/license-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* unused harmony exports OverlayTypeXmlEnum, OverlayTypeLabelEnum, OverlayTypeIconClassEnum, OverlayTypeConfigKeyEnum, DistinctOverlayType, OverlayDefaultAction */\nvar OverlayTypeXmlEnum;\n(function (OverlayTypeXmlEnum) {\n    OverlayTypeXmlEnum["EMBEDDED_COMMENTS"] = "viadee:Comment";\n    OverlayTypeXmlEnum["DOCUMENTATION"] = "bpmn:documentation";\n    OverlayTypeXmlEnum["MARKDOWN_DOCUMENTATION"] = "viadee:MarkdownDocumentation";\n    OverlayTypeXmlEnum["LEGACY_WIKILINK"] = "viadee:WikiLinks";\n    OverlayTypeXmlEnum["BPMN"] = "viadee:BpmnLinks";\n    OverlayTypeXmlEnum["DMN_ENTERPRISE"] = "viadee:DmnEnterpriseLinks";\n    OverlayTypeXmlEnum["DMN"] = "viadee:DmnLinks";\n    OverlayTypeXmlEnum["CONFLUENCE_PAGE"] = "viadee:PageLinks";\n    OverlayTypeXmlEnum["CONFLUENCE_ATTACHMENT"] = "viadee:ConfluenceAttachmentLink";\n    OverlayTypeXmlEnum["EXTERNAL_CONTENT"] = "viadee:ExternalLinks";\n    OverlayTypeXmlEnum["JIRA_ISSUE"] = "viadee:JiraIssueLink";\n    OverlayTypeXmlEnum["MDF_INSTANCE"] = "viadee:MdfInstance";\n    OverlayTypeXmlEnum["ANY"] = "viadee:AnyLinks";\n})(OverlayTypeXmlEnum || (OverlayTypeXmlEnum = {}));\nvar OverlayTypeLabelEnum;\n(function (OverlayTypeLabelEnum) {\n    OverlayTypeLabelEnum["EMBEDDED_COMMENTS"] = "embedded-comments";\n    OverlayTypeLabelEnum["DOCUMENTATION"] = "documentation";\n    OverlayTypeLabelEnum["MARKDOWN_DOCUMENTATION"] = "viadee:MarkdownDocumentation";\n    OverlayTypeLabelEnum["BPMN"] = "bpmn";\n    OverlayTypeLabelEnum["BPMN_NEW_TARGET_PAGE"] = "bpmn-new-target-page";\n    OverlayTypeLabelEnum["LEGACY_BPMN"] = "attachment";\n    OverlayTypeLabelEnum["DMN_ENTERPRISE"] = "dmn-enterprise";\n    OverlayTypeLabelEnum["DMN"] = "dmn";\n    OverlayTypeLabelEnum["DMN_NEW_TARGET_PAGE"] = "dmn-new-target-page";\n    OverlayTypeLabelEnum["CONFLUENCE_PAGE"] = "confluence-page";\n    OverlayTypeLabelEnum["LEGACY_CONFLUENCE_PAGE"] = "search-page";\n    OverlayTypeLabelEnum["CONFLUENCE_ATTACHMENT"] = "confluence-attachment";\n    OverlayTypeLabelEnum["EXTERNAL_CONTENT"] = "external-content";\n    OverlayTypeLabelEnum["LEGACY_EXTERNAL_CONTENT"] = "external";\n    OverlayTypeLabelEnum["JIRA_ISSUE"] = "jira-issue";\n    OverlayTypeLabelEnum["MDF_INSTANCE"] = "mdf-instance";\n})(OverlayTypeLabelEnum || (OverlayTypeLabelEnum = {}));\nvar OverlayTypeIconClassEnum;\n(function (OverlayTypeIconClassEnum) {\n    OverlayTypeIconClassEnum["EMBEDDED_COMMENTS"] = "";\n    OverlayTypeIconClassEnum["DOCUMENTATION"] = "vxcp-ent-icon-documentation";\n    OverlayTypeIconClassEnum["BPMN"] = "vxcp-ent-icon-bpmn";\n    OverlayTypeIconClassEnum["DMN_ENTERPRISE"] = "vxcp-ent-icon-dmn";\n    OverlayTypeIconClassEnum["DMN"] = "vxcp-ent-icon-dmn";\n    OverlayTypeIconClassEnum["CONFLUENCE_PAGE"] = "vxcp-ent-icon-confluence-page";\n    OverlayTypeIconClassEnum["CONFLUENCE_ATTACHMENT"] = "vxcp-ent-icon-attachment";\n    OverlayTypeIconClassEnum["EXTERNAL_CONTENT"] = "vxcp-ent-icon-external";\n    OverlayTypeIconClassEnum["JIRA_ISSUE"] = "vxcp-ent-icon-jira-issue";\n    OverlayTypeIconClassEnum["MDF_INSTANCE"] = "vxcp-ent-icon-mdf-instance";\n})(OverlayTypeIconClassEnum || (OverlayTypeIconClassEnum = {}));\nvar OverlayTypeConfigKeyEnum;\n(function (OverlayTypeConfigKeyEnum) {\n    OverlayTypeConfigKeyEnum["EMBEDDED_COMMENTS"] = "showEmbeddedComments";\n    OverlayTypeConfigKeyEnum["DOCUMENTATION"] = "showDocumentation";\n    OverlayTypeConfigKeyEnum["BPMN"] = "showBpmnLinks";\n    OverlayTypeConfigKeyEnum["DMN_ENTERPRISE"] = "showDmnLinks";\n    OverlayTypeConfigKeyEnum["DMN"] = "showDmnLinks";\n    OverlayTypeConfigKeyEnum["CONFLUENCE_PAGE"] = "showConfluencePageLinks";\n    OverlayTypeConfigKeyEnum["CONFLUENCE_ATTACHMENT"] = "showConfluenceAttachmentLinks";\n    OverlayTypeConfigKeyEnum["EXTERNAL_CONTENT"] = "showExternalContentLinks";\n    OverlayTypeConfigKeyEnum["JIRA_ISSUE"] = "showJiraIssueLinks";\n    OverlayTypeConfigKeyEnum["MDF_INSTANCE"] = "showMdfInstanceLinks";\n})(OverlayTypeConfigKeyEnum || (OverlayTypeConfigKeyEnum = {}));\nvar DistinctOverlayType;\n(function (DistinctOverlayType) {\n    DistinctOverlayType["DOCUMENTATION"] = "documentation";\n    DistinctOverlayType["BPMN"] = "bpmn";\n    DistinctOverlayType["DMN"] = "dmn";\n    DistinctOverlayType["CONFLUENCE_PAGE"] = "confluence-page";\n    DistinctOverlayType["EXTERNAL_CONTENT"] = "external-content";\n    DistinctOverlayType["CONFLUENCE_ATTACHMENT"] = "confluence-attachment";\n    DistinctOverlayType["JIRA_ISSUE"] = "jira";\n    DistinctOverlayType["MDF_INSTANCE"] = "mdf";\n})(DistinctOverlayType || (DistinctOverlayType = {}));\nvar OverlayDefaultAction;\n(function (OverlayDefaultAction) {\n    OverlayDefaultAction["OPEN_PANEL"] = "openPanel";\n    OverlayDefaultAction["WONT_DRAW"] = "wontDraw";\n})(OverlayDefaultAction || (OverlayDefaultAction = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* unused harmony exports PluginTypeEnum, MacroEnterpriseNameEnum, MacroFreeNameEnum */\nvar PluginTypeEnum;\n(function (PluginTypeEnum) {\n    PluginTypeEnum["DMN"] = "DMN";\n    PluginTypeEnum["DMN_ENTERPRISE"] = "DMN";\n    PluginTypeEnum["BPMN"] = "BPMN";\n})(PluginTypeEnum || (PluginTypeEnum = {}));\nvar MacroEnterpriseNameEnum;\n(function (MacroEnterpriseNameEnum) {\n    MacroEnterpriseNameEnum["DMN"] = "vdcp-macro-enterprise";\n    MacroEnterpriseNameEnum["BPMN"] = "vbcp-macro-enterprise";\n    MacroEnterpriseNameEnum["BPMN_PROCESS_NET"] = "vbcp-enterprise-process-net-macro";\n    MacroEnterpriseNameEnum["DMN_PROCESS_NET"] = "vdcp-enterprise-process-net-macro";\n})(MacroEnterpriseNameEnum || (MacroEnterpriseNameEnum = {}));\nvar MacroFreeNameEnum;\n(function (MacroFreeNameEnum) {\n    MacroFreeNameEnum["DMN"] = "vdcp-macro";\n    MacroFreeNameEnum["BPMN"] = "vbcp-macro";\n})(MacroFreeNameEnum || (MacroFreeNameEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/resize-direction.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* unused harmony export ResizeDirectionEnum */\nvar ResizeDirectionEnum;\n(function (ResizeDirectionEnum) {\n    ResizeDirectionEnum["TOP_TO_BOTTOM"] = "TOP_TO_BOTTOM";\n    ResizeDirectionEnum["BOTTOM_TO_TOP"] = "BOTTOM_TO_TOP";\n    ResizeDirectionEnum["LEFT_TO_RIGHT"] = "LEFT_TO_RIGHT";\n    ResizeDirectionEnum["RIGHT_TO_LEFT"] = "RIGHT_TO_LEFT";\n})(ResizeDirectionEnum || (ResizeDirectionEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/resize-direction.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "X": () => (/* binding */ TemplateNamesEnum)\n/* harmony export */ });\nvar TemplateNamesEnum;\n(function (TemplateNamesEnum) {\n    TemplateNamesEnum["EXPORT_PNG_DIALOG"] = "exportPngDialog";\n    TemplateNamesEnum["USER_MENTION_DISPLAY"] = "userMentionDisplay";\n    TemplateNamesEnum["CONFLUENCE_LABEL"] = "confluenceLabel";\n    TemplateNamesEnum["CREATE_WIZARD"] = "createWizard";\n    TemplateNamesEnum["CREATE_WIZARD_DIALOG"] = "createWizardDialog";\n    TemplateNamesEnum["EXPORT_CSV_DIALOG"] = "exportCsvDialog";\n    TemplateNamesEnum["EXPORT_TABLE_TO_CONFLUENCE"] = "exportTableToConfluence";\n    TemplateNamesEnum["DIFFER"] = "differ";\n    TemplateNamesEnum["DIFFER_TABLE"] = "differTable";\n    TemplateNamesEnum["DIFFER_DIALOG"] = "differDialog";\n    TemplateNamesEnum["DIFFER_PREVIEW_DIALOG"] = "differPreviewDialog";\n    TemplateNamesEnum["DIAGRAM_AS_TABLE"] = "diagramAsTable";\n    TemplateNamesEnum["XML_EDITOR"] = "xmlEditor";\n    TemplateNamesEnum["SHORTCUT_TABLE"] = "shortcutTable";\n    TemplateNamesEnum["WELCOME_SCREEN_DIALOG"] = "welcomeScreenDialog";\n    TemplateNamesEnum["USER_SURVEY_2022_DIALOG"] = "userSurvey2022Dialog";\n    TemplateNamesEnum["MACRO_DIALOG_ENTERPRISE"] = "macroDialogEnterprise";\n    TemplateNamesEnum["MACRO_DIALOG_PROCESS_NET"] = "macroDialogProcessNet";\n    TemplateNamesEnum["PLUGIN_ANALYSIS_DIALOG"] = "pluginAnalysisDialog";\n    TemplateNamesEnum["ATTRIBUTE_PANEL"] = "attributePanel";\n    TemplateNamesEnum["MACRO_CONFIGURATION_DIALOG"] = "macroConfigurationDialog";\n    TemplateNamesEnum["MDF_EDIT_FIELD_INSTANCE"] = "mdfEditFieldInstance";\n    TemplateNamesEnum["LINTER_TABLE"] = "linterTable";\n    TemplateNamesEnum["LINTER"] = "linter";\n    TemplateNamesEnum["INCOMING_DIAGRAM_LINKS"] = "incomingDiagramLinks";\n    TemplateNamesEnum["SHOW_DIAGRAM_DIALOG"] = "showDiagramDialog";\n    TemplateNamesEnum["IMAGE_PREVIEW_DIALOG"] = "imagePreviewDialog";\n    TemplateNamesEnum["PDF_PREVIEW_DIALOG"] = "pdfPreviewDialog";\n    TemplateNamesEnum["JIRA_ISSUE_PREVIEW_DIALOG"] = "jiraIssuePreviewTemplate";\n    TemplateNamesEnum["ADD_ELEMENT_LINK_DIAOLG"] = "addElementLinkDialog";\n    TemplateNamesEnum["VERSION_HISTORY_DIALOG"] = "versionHistoryDialog";\n    TemplateNamesEnum["COMMENT_DIALOG"] = "commentDialog";\n    TemplateNamesEnum["NAVBAR"] = "navbar";\n    TemplateNamesEnum["VIADEE_INFO_DIALOG"] = "viadeeInfoDialog";\n    TemplateNamesEnum["DOWNLOAD_DIAGRAM_DIALOG"] = "downloadDiagramDialog";\n    TemplateNamesEnum["IMPORT_EXISTING_DIAGRAM_DIALOG"] = "importExistingDiagramDialog";\n    TemplateNamesEnum["NEWS_MESSAGE_BOX"] = "newsMessageBox";\n    TemplateNamesEnum["NEWS_MESSAGE_ENTRIES"] = "newsMessageEntries";\n    TemplateNamesEnum["VERSION_NAME_DIALOG"] = "versionNameDialog";\n    TemplateNamesEnum["TUTORIAL_DIALOG"] = "tutorialDialog";\n    TemplateNamesEnum["VERSION_DROPDOWN_ITEMS"] = "versionDropdownItems";\n    TemplateNamesEnum["WARNING_DIALOG"] = "warningDialog";\n    TemplateNamesEnum["IMPORT_VCS_DIAGRAM_DIALOG"] = "importVCSDiagramDialog";\n    TemplateNamesEnum["PUSH_TO_VCS_DIALOG"] = "pushToVCSDialog";\n})(TemplateNamesEnum || (TemplateNamesEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/warning-dialog-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "K": () => (/* binding */ WarningDialogTypeEnum)\n/* harmony export */ });\nvar WarningDialogTypeEnum;\n(function (WarningDialogTypeEnum) {\n    WarningDialogTypeEnum["PAGE_NOT_SAVED"] = "page-not-saved";\n    WarningDialogTypeEnum["SAVE_BEFORE_IMPORT"] = "save-before-import";\n    WarningDialogTypeEnum["SAVE_BEFORE_VCS_PUSH"] = "save-before-vcs-push";\n    WarningDialogTypeEnum["SAVE_BEFORE_EXIT"] = "save-before-exit";\n    WarningDialogTypeEnum["SAVE_BEFORE_OPEN_CONFIGS"] = "save-before-open-configs";\n    WarningDialogTypeEnum["LOADING_BROKEN_XML"] = "loading-broken-xml";\n    WarningDialogTypeEnum["SAVING_INVALID_XML"] = "saving-invalid-xml";\n    WarningDialogTypeEnum["SAVING_XML_WITH_WARNINGS"] = "saving-xml-with-warnings";\n    WarningDialogTypeEnum["WRONG_FILE_FORMAT"] = "wrong-file-format";\n    WarningDialogTypeEnum["RESET_DIAGRAM"] = "reset-diagram";\n    WarningDialogTypeEnum["RESET_DIAGRAM_AND_SAVED_IN_BETWEEN"] = "reset-diagram-and-saved-in-between";\n    WarningDialogTypeEnum["DIAGRAM_SAVED_IN_BETWEEN"] = "saved-in-between";\n    WarningDialogTypeEnum["DIFFER_DIAGRAM_TOO_BIG"] = "differ-diagram-too-big";\n    WarningDialogTypeEnum["DIFFER_FILE_DOES_NOT_EXIST"] = "differ-file-does-not-exist";\n    WarningDialogTypeEnum["NO_VERSIONS_TO_COMPARE"] = "no-versions-to-compare";\n    WarningDialogTypeEnum["START_MIGRATION"] = "start-migration";\n    WarningDialogTypeEnum["BROWSER_NOT_SUPPORTED"] = "browser-not-supported";\n    WarningDialogTypeEnum["NO_PNG_UPLOAD"] = "no-png-upload";\n    WarningDialogTypeEnum["SESSION_EXPIRED"] = "session-expired";\n    WarningDialogTypeEnum["NO_CONNECTION"] = "no-connection";\n    WarningDialogTypeEnum["LICENSE_NOT_VALID"] = "license-not-valid";\n    WarningDialogTypeEnum["SOME_ERROR_APPEARED"] = "some-error-appeared";\n    WarningDialogTypeEnum["ATTACHMENTS_NOT_UPLOADED"] = "attachments-not-uploaded";\n    WarningDialogTypeEnum["EDITOR_MACRO_NOT_EXIST"] = "editor-macro-not-exist";\n    WarningDialogTypeEnum["LEGACY_WIKILINKS"] = "legacy-links";\n    WarningDialogTypeEnum["MACRO_NOT_ALLOWED_HERE"] = "macro-not-allowed-here";\n    WarningDialogTypeEnum["DUPLICATE_RENAME_ERROR"] = "duplicate-rename-error";\n    WarningDialogTypeEnum["PNG_RENAME_ERROR"] = "png-rename-error";\n    WarningDialogTypeEnum["PNG_COPY_ERROR"] = "png-copy-error";\n    WarningDialogTypeEnum["XML_RENAME_ERROR"] = "xml-rename-error";\n    WarningDialogTypeEnum["TABLE_NOT_EXPORTED"] = "table-not-exported";\n    WarningDialogTypeEnum["VERSION_NOT_AVAILABLE_EDITOR"] = "version-not-available";\n    WarningDialogTypeEnum["AUTHENTICATION_TOKEN_REQUIRED"] = "jira-authentication-token-required";\n    WarningDialogTypeEnum["DELETE_RESOLVED_COMMENTS"] = "delete-resolved-comments";\n    WarningDialogTypeEnum["RESET_ADMIN_PAGE_CONFIGS"] = "reset-admin-page-configs";\n    WarningDialogTypeEnum["DIAGRAM_ALREADY_EXISTS_ON_PAGE"] = "diagram-already-exists-on-page";\n    WarningDialogTypeEnum["DELETE_ALL_LINKS"] = "delete-all-diagram-links";\n    WarningDialogTypeEnum["SYNC_ALL_LINKS"] = "sync-all-diagram-links";\n    WarningDialogTypeEnum["NEW_DIAGRAM_NOT_SAVED"] = "new-diagram-not-saved";\n    WarningDialogTypeEnum["NEW_DIAGRAM_NOT_SAVED_YET"] = "new-diagram-not-saved-yet";\n    WarningDialogTypeEnum["COPY_DIAGRAM_AND_CREATE_MACRO_ERROR"] = "copy-diagram-and-create-macro-error";\n    WarningDialogTypeEnum["UPLOAD_DIAGRAM_AND_CREATE_MACRO_ERROR"] = "upload-diagram-and-create-macro-error";\n    WarningDialogTypeEnum["FETCH_DIAGRAM_AND_CREATE_MACRO_ERROR"] = "fetch-diagram-and-create-macro-error";\n    WarningDialogTypeEnum["FETCH_DIAGRAM_FROM_VCS_ERROR"] = "fetch-diagram-from-vcs-error";\n})(WarningDialogTypeEnum || (WarningDialogTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/warning-dialog-type.enum.ts?')}},__webpack_module_cache__={},deferred;function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var r=__webpack_module_cache__[e]={id:e,loaded:!1,exports:{}};return __webpack_modules__[e].call(r.exports,r,r.exports,__webpack_require__),r.loaded=!0,r.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(e,n,r,a)=>{if(!n){var o=1/0;for(p=0;p<deferred.length;p++){for(var[n,r,a]=deferred[p],t=!0,i=0;i<n.length;i++)(!1&a||o>=a)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](n[i])))?n.splice(i--,1):(t=!1,a<o&&(o=a));if(t){deferred.splice(p--,1);var s=r();void 0!==s&&(e=s)}}return e}a=a||0;for(var p=deferred.length;p>0&&deferred[p-1][2]>a;p--)deferred[p]=deferred[p-1];deferred[p]=[n,r,a]},__webpack_require__.n=e=>{var n=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(n,{a:n}),n},__webpack_require__.d=(e,n)=>{for(var r in n)__webpack_require__.o(n,r)&&!__webpack_require__.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:n[r]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},__webpack_require__.nmd=e=>(e.paths=[],e.children||(e.children=[]),e),__webpack_require__.j="bpmnEntProcessNetMacroDialog",(()=>{var e={bpmnEntProcessNetMacroDialog:0};__webpack_require__.O.j=n=>0===e[n];var n=(n,r)=>{var a,o,[t,i,s]=r,p=0;if(t.some((n=>0!==e[n]))){for(a in i)__webpack_require__.o(i,a)&&(__webpack_require__.m[a]=i[a]);if(s)var c=s(__webpack_require__)}for(n&&n(r);p<t.length;p++)o=t[p],__webpack_require__.o(e,o)&&e[o]&&e[o][0](),e[o]=0;return __webpack_require__.O(c)},r=self.webpackChunkVBCP=self.webpackChunkVBCP||[];r.forEach(n.bind(null,0)),r.push=n.bind(null,r.push.bind(r))})();var __webpack_exports__=__webpack_require__.O(void 0,["bpmnEntVendors","bpmnEntServices"],(()=>__webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/components/process-net-macro-dialog.component.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VBCP=window.VBCP||{}).bpmnEntProcessNetMacroDialog=__webpack_exports__})();