"use strict";(self.webpackChunkVBCP=self.webpackChunkVBCP||[]).push([["bpmnEntServices"],{"../../../../../../MDF-core/core-js/app/services/attribute-validator.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "k": () => (/* binding */ initNumberInputValidator)\n/* harmony export */ });\n/* harmony import */ var _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/attribute-type.enum.ts");\n/* harmony import */ var jquery_alphanum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../MDF-core/core-js/node_modules/jquery.alphanum/jquery.alphanum.js");\n/* harmony import */ var jquery_alphanum__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jquery_alphanum__WEBPACK_IMPORTED_MODULE_1__);\n\n\nfunction initNumberInputValidator(query = false) {\n    $.fn.alphanum.setNumericSeparators({\n        thousandsSeparator: " ",\n        decimalSeparator: ".",\n    });\n    $("body").on("click keypress change keyup keydown", () => {\n        const $numberInputs = $("body").find(`input.vcfcp-${_model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.NUMBER */ .S.NUMBER}`);\n        $numberInputs.off(".alphanum");\n        $numberInputs.alphanum({\n            allowNumeric: true,\n            allow: ".<>ANDOR=!()-",\n            disallow: "§",\n            allowSpace: true,\n            allowUpper: false,\n            allowLower: false,\n            allowNewline: false,\n            allowOtherCharSets: false,\n        });\n        $numberInputs.off("keydown");\n        $numberInputs.on("keydown", (e) => {\n            _checkSpecialCharacterLogic(e);\n        });\n        function _checkSpecialCharacterLogic(event) {\n            const cursorIndex = event.target.selectionStart;\n            const oldValue = event.target.value;\n            const characterBeforeCursor = oldValue.charAt(cursorIndex - 1);\n            switch (event.key) {\n                case ",":\n                case ".":\n                    event.preventDefault();\n                    if (!/^\\d+$/.test(characterBeforeCursor)) {\n                        break;\n                    }\n                    let decimalAllowed = true;\n                    for (let i = cursorIndex; i < event.target.value.length; i++) {\n                        if (event.target.value.charAt(i) === "O" || event.target.value.charAt(i) === "A") {\n                            break;\n                        }\n                        if (event.target.value.charAt(i) === ".") {\n                            decimalAllowed = false;\n                            break;\n                        }\n                    }\n                    for (let i = cursorIndex; i > 0; i--) {\n                        if (event.target.value.charAt(i) === "R" || event.target.value.charAt(i) === "D") {\n                            break;\n                        }\n                        if (event.target.value.charAt(i) === ".") {\n                            decimalAllowed = false;\n                            break;\n                        }\n                    }\n                    if (decimalAllowed) {\n                        event.target.value = oldValue.substring(0, cursorIndex) + "." + oldValue.substring(cursorIndex, oldValue.length);\n                        event.target.setSelectionRange(cursorIndex + 1, cursorIndex + 1);\n                    }\n                    break;\n                case "o":\n                case "O":\n                    event.preventDefault();\n                    if (!query) {\n                        break;\n                    }\n                    if (/^\\d+$/.test(characterBeforeCursor) || characterBeforeCursor === " " || characterBeforeCursor === ")") {\n                        event.target.value = oldValue.substring(0, cursorIndex) + "OR" + oldValue.substring(cursorIndex, oldValue.length);\n                        event.target.setSelectionRange(cursorIndex + 3, cursorIndex + 3);\n                    }\n                    break;\n                case "<":\n                case ">":\n                    event.preventDefault();\n                    if (!query) {\n                        break;\n                    }\n                    if (characterBeforeCursor === "" || characterBeforeCursor === "R" || characterBeforeCursor === "D" || characterBeforeCursor === " " || characterBeforeCursor === "(") {\n                        event.target.value = oldValue.substring(0, cursorIndex) + event.key + oldValue.substring(cursorIndex, oldValue.length);\n                        event.target.setSelectionRange(cursorIndex + 1, cursorIndex + 1);\n                    }\n                    break;\n                case "=":\n                    event.preventDefault();\n                    if (!query) {\n                        break;\n                    }\n                    if (characterBeforeCursor === "" ||\n                        characterBeforeCursor === "R" ||\n                        characterBeforeCursor === "D" ||\n                        characterBeforeCursor === "<" ||\n                        characterBeforeCursor === ">" ||\n                        characterBeforeCursor === " " ||\n                        characterBeforeCursor === "!") {\n                        event.target.value = oldValue.substring(0, cursorIndex) + "=" + oldValue.substring(cursorIndex, oldValue.length);\n                        event.target.setSelectionRange(cursorIndex + 1, cursorIndex + 1);\n                    }\n                    break;\n                case "!":\n                    event.preventDefault();\n                    if (!query) {\n                        break;\n                    }\n                    if (characterBeforeCursor === "" || characterBeforeCursor === "R" || characterBeforeCursor === "D" || characterBeforeCursor === " ") {\n                        event.target.value = oldValue.substring(0, cursorIndex) + "!" + oldValue.substring(cursorIndex, oldValue.length);\n                        event.target.setSelectionRange(cursorIndex + 1, cursorIndex + 1);\n                    }\n                    break;\n                case "-":\n                    if (!query && !(cursorIndex === 0)) {\n                        event.preventDefault();\n                        return;\n                    }\n                    break;\n                case "a":\n                case "A":\n                    event.preventDefault();\n                    if (!query) {\n                        break;\n                    }\n                    if (!(/^\\d+$/.test(characterBeforeCursor) || characterBeforeCursor === " " || characterBeforeCursor === ")")) {\n                        break;\n                    }\n                    event.target.value = oldValue.substring(0, cursorIndex) + "AND" + oldValue.substring(cursorIndex, oldValue.length);\n                    event.target.setSelectionRange(cursorIndex + 4, cursorIndex + 4);\n                    break;\n                case "N":\n                case "D":\n                case "R":\n                    event.preventDefault();\n                    break;\n                case " ":\n                    if (!query) {\n                        event.preventDefault();\n                    }\n                    break;\n                default:\n                    break;\n            }\n        }\n    });\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/services/attribute-validator.service.ts?')},"../../../../../../MDF-core/core-js/app/services/calculation.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "H": () => (/* binding */ CalculationService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_calculation_validation_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/calculation-validation.enum.ts");\nif ("bpmnEntPlatformMDF" == __webpack_require__.j) {\n\t/* harmony import */ var _vCFCP_app_server_enterprise_src_main_js_app_services_caretUtils_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../vCFCP/app-server-enterprise/src/main/js/app/services/caretUtils.service.ts");\n}\n/* harmony import */ var _model_enum_predefined_value_type_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/predefined-value-type.enum.ts");\n/* harmony import */ var _model_enum_calculation_operator_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/calculation-operator.enum.ts");\n/* harmony import */ var mathparser_org_mxparser_out_Expression__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../MDF-core/core-js/node_modules/mathparser.org-mxparser/out/Expression.js");\n/* harmony import */ var mathparser_org_mxparser_out_Argument__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../MDF-core/core-js/node_modules/mathparser.org-mxparser/out/Argument.js");\n/* harmony import */ var _model_enum_mdf_template_names_enum__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/mdf-template-names.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\nconst debounce = __webpack_require__("../../../../../../node_modules/lodash/debounce.js");\nclass CalculationService {\n    constructor(platformUtils, sanitizerService) {\n        this.platformUtils = platformUtils;\n        this.sanitizerService = sanitizerService;\n    }\n    evaluateMathExpression(mathExpression) {\n        const expression = mathparser_org_mxparser_out_Expression__WEBPACK_IMPORTED_MODULE_3__.Expression.createWithExpression(mathExpression);\n        const calculationResult = expression.calculate();\n        expression.checkLexSyntax();\n        const calculationResultRound = calculationResult !== Infinity ? mathparser_org_mxparser_out_Expression__WEBPACK_IMPORTED_MODULE_3__.Expression.createWithExpression("round(" + calculationResult.toString() + ",2)").calculate() : calculationResult;\n        const result = this.getMathObjectFromCalcResult(calculationResultRound, expression);\n        return result;\n    }\n    evaluateMathExpressionWithArgumentsArray(mathExpression, argumentsArray) {\n        if (argumentsArray && argumentsArray.length > 0) {\n            const expression = mathparser_org_mxparser_out_Expression__WEBPACK_IMPORTED_MODULE_3__.Expression.createWithExpressionAndArgumentValues(mathExpression, ...argumentsArray);\n            const calculationResult = expression.calculate();\n            expression.checkLexSyntax();\n            const calculationResultRound = calculationResult !== Infinity ? mathparser_org_mxparser_out_Expression__WEBPACK_IMPORTED_MODULE_3__.Expression.createWithExpression("round(" + calculationResult.toString() + ",2)").calculate() : calculationResult;\n            return this.getMathObjectFromCalcResult(calculationResultRound, expression);\n        }\n        else {\n            return this.evaluateMathExpression(mathExpression);\n        }\n    }\n    getMathObjectFromCalcResult(calcResult, expression) {\n        if (!isNaN(calcResult)) {\n            return { validation: _model_enum_calculation_validation_enum__WEBPACK_IMPORTED_MODULE_0__/* .CalculationValidationEnum.VALID */ .H.VALID, calculationResult: calcResult.toString() };\n        }\n        else {\n            return { validation: _model_enum_calculation_validation_enum__WEBPACK_IMPORTED_MODULE_0__/* .CalculationValidationEnum.INVALID */ .H.INVALID, errorMessage: expression.getErrorMessage() };\n        }\n    }\n    openAndInitDropdownAttributeOverlay($fragment, $dataAttributesContainer, caretPositionOfAtCharWithInnerHtmlNodes, caretPositionOfCharAt) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $inputDiv = $fragment.find(".vcfcp-calc-math-exp-input-div");\n            let $CalculationEditorDropdownDisplay = $fragment.find(".vcfcp-calculation-editor-dropdown-display");\n            let $userAttributeInput = $CalculationEditorDropdownDisplay.find("input.vcfcp-attribute-search");\n            if ($CalculationEditorDropdownDisplay.length > 0) {\n                $userAttributeInput.trigger("focus");\n                return;\n            }\n            $CalculationEditorDropdownDisplay = $(yield this.platformUtils.getTemplate(_model_enum_mdf_template_names_enum__WEBPACK_IMPORTED_MODULE_5__/* .MdfTemplateNamesEnum.CALC_DROPDOWN_DISPLAY */ .c.CALC_DROPDOWN_DISPLAY));\n            $userAttributeInput = $CalculationEditorDropdownDisplay.find("input.vcfcp-attribute-search");\n            const $mathExpAreaOverlay = $fragment.find(".vcfcp-calc-math-exp-overlay");\n            $mathExpAreaOverlay.append($CalculationEditorDropdownDisplay);\n            const pos = _vCFCP_app_server_enterprise_src_main_js_app_services_caretUtils_service__WEBPACK_IMPORTED_MODULE_6__/* .getCaretCoordinates */ .Ly();\n            const cursorPosX = pos.x + window.scrollX;\n            const cursorPosY = pos.y + window.scrollY;\n            const $parentsList = $CalculationEditorDropdownDisplay.parentsUntil(".vcfcp-data-attributes-container");\n            const dataAttributeContainer = $parentsList.get($parentsList.length - 1);\n            const globalTopPosOfDataAttributeContainer = dataAttributeContainer.getBoundingClientRect().top + window.scrollY;\n            const globalLeftPosOfDataAttributeContainer = dataAttributeContainer.getBoundingClientRect().left + window.scrollX;\n            const resY = cursorPosY - globalTopPosOfDataAttributeContainer + 25;\n            const resX = cursorPosX - globalLeftPosOfDataAttributeContainer;\n            $CalculationEditorDropdownDisplay[0].style.left = resX + "px";\n            $CalculationEditorDropdownDisplay[0].style.top = resY + "px";\n            $userAttributeInput.trigger("focus");\n            const $initAttributeList = $CalculationEditorDropdownDisplay.find(".vcfcp-attribute-results-list");\n            $initAttributeList.empty();\n            yield this.fillAttributeList($fragment, $dataAttributesContainer, this.getActiveNumberAttributes($dataAttributesContainer), caretPositionOfAtCharWithInnerHtmlNodes, caretPositionOfCharAt);\n            $userAttributeInput.on("keydown", (keyEvent) => {\n                const $attributeResultsListContainer = $CalculationEditorDropdownDisplay.find(".vcfcp-attribute-results-list-container");\n                const $attributeList = $CalculationEditorDropdownDisplay.find(".vcfcp-attribute-results-list");\n                const $attributes = $attributeList.find("li");\n                const $selectedAttribute = $attributeList.find(".active");\n                let indexOfSelectedAttribute = $attributes.index($selectedAttribute);\n                const attributeNameToMention = $userAttributeInput.val();\n                if ((keyEvent.key === "Backspace" || keyEvent.key === "Delete") && !attributeNameToMention.length) {\n                    keyEvent.preventDefault();\n                    $CalculationEditorDropdownDisplay.remove();\n                    $inputDiv.trigger("focus");\n                    _vCFCP_app_server_enterprise_src_main_js_app_services_caretUtils_service__WEBPACK_IMPORTED_MODULE_6__/* .setCurrentCursorPosition */ .yH($inputDiv[0], caretPositionOfCharAt);\n                    $inputDiv[0].selectionEnd = caretPositionOfAtCharWithInnerHtmlNodes;\n                }\n                else if (keyEvent.key === "Escape") {\n                    $CalculationEditorDropdownDisplay.remove();\n                    $inputDiv.trigger("focus");\n                }\n                else if (keyEvent.key === "Enter") {\n                    keyEvent.preventDefault();\n                    $selectedAttribute.trigger("click");\n                }\n                else if (keyEvent.key === "ArrowDown" || keyEvent.key === "ArrowUp") {\n                    keyEvent.preventDefault();\n                    if (keyEvent.key === "ArrowDown") {\n                        if (indexOfSelectedAttribute > -1) {\n                            $attributes[indexOfSelectedAttribute].classList.remove("active");\n                        }\n                        indexOfSelectedAttribute++;\n                        if (indexOfSelectedAttribute < $attributes.length) {\n                            $attributes[indexOfSelectedAttribute].classList.add("active");\n                        }\n                        else {\n                            $attributes[$attributes.length - 1].classList.add("active");\n                        }\n                    }\n                    else if (keyEvent.key === "ArrowUp") {\n                        if (indexOfSelectedAttribute > -1) {\n                            $attributes[indexOfSelectedAttribute].classList.remove("active");\n                        }\n                        indexOfSelectedAttribute--;\n                        if (indexOfSelectedAttribute > -1) {\n                            $attributes[indexOfSelectedAttribute].classList.add("active");\n                        }\n                        else {\n                            $attributes[0].classList.add("active");\n                        }\n                    }\n                    const $dropdownEntry = $attributeList.find(".active");\n                    const dropdownEntryHeight = $dropdownEntry.outerHeight();\n                    const scrollBarPos = $attributeResultsListContainer.scrollTop();\n                    const viewport = scrollBarPos + $attributeResultsListContainer.height();\n                    const dropdownEntryOffset = dropdownEntryHeight * indexOfSelectedAttribute;\n                    if (dropdownEntryOffset < scrollBarPos || dropdownEntryOffset + dropdownEntryHeight > viewport) {\n                        $attributeResultsListContainer.scrollTop(dropdownEntryOffset);\n                    }\n                    $userAttributeInput.val($attributeList.find(".active").children(0).html());\n                    return;\n                }\n            });\n            const debouncedRefreshSearchResults = debounce((keyEvent) => __awaiter(this, void 0, void 0, function* () {\n                const attributeNameToMention = $userAttributeInput.val();\n                const $attributeList = $CalculationEditorDropdownDisplay.find(".vcfcp-attribute-results-list");\n                if (keyEvent.key.length > 1 && keyEvent.key !== "Backspace") {\n                    return;\n                }\n                $attributeList.empty();\n                const foundNumberAttributes = this.filterDataAttributes(this.getActiveNumberAttributes($dataAttributesContainer), attributeNameToMention);\n                yield this.fillAttributeList($fragment, $dataAttributesContainer, foundNumberAttributes, caretPositionOfAtCharWithInnerHtmlNodes, caretPositionOfCharAt);\n            }), 300);\n            $userAttributeInput.on("keyup", debouncedRefreshSearchResults);\n        });\n    }\n    fillAttributeList($fragment, $dataAttributesContainer, foundNumberAttributes, caretPositionOfAtCharWithInnerHtmlNodes, caretPositionOfAtChar) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $inputDiv = $fragment.find(".vcfcp-calc-math-exp-input-div");\n            let divInputInnerHTML = $inputDiv.html();\n            const $CalculationEditorDropdownDisplay = $fragment.find(".vcfcp-calculation-editor-dropdown-display");\n            const $attributeList = $CalculationEditorDropdownDisplay.find(".vcfcp-attribute-results-list");\n            if (!foundNumberAttributes.length) {\n                const $noAttributes = $(`<li class="vcfcp-attribute-dropdown-entry">\n                                ${yield this.platformUtils.getText("de.viadee.confluence.managed-data-fields.message.no-attributes-found")}\n                            </li>`);\n                $attributeList.append($noAttributes);\n                return;\n            }\n            foundNumberAttributes.forEach((attribute) => {\n                const labelDisplayName = attribute.label;\n                const $attributeDropdownEntry = $(`<li class="vcfcp-attribute-dropdown-entry">\n                                    <a class="vcfcp-attribute-dropdown-entry-a" data-vcfcp-a-attribute-id="${attribute.vcfcpAttributeId}">${labelDisplayName}</a>\n                                </li>`);\n                $attributeDropdownEntry.on("click", () => __awaiter(this, void 0, void 0, function* () {\n                    const oldDivInputInnerHTMLLength = divInputInnerHTML.length;\n                    divInputInnerHTML = $inputDiv.html();\n                    const diff = divInputInnerHTML.length - oldDivInputInnerHTMLLength;\n                    caretPositionOfAtCharWithInnerHtmlNodes = caretPositionOfAtCharWithInnerHtmlNodes + diff;\n                    const textBeforeAttributeMention = divInputInnerHTML.slice(0, caretPositionOfAtCharWithInnerHtmlNodes - 1);\n                    const textAfterAttributeMention = divInputInnerHTML.slice(caretPositionOfAtCharWithInnerHtmlNodes);\n                    const newInputValue = `${textBeforeAttributeMention}<a class="vcfcp-attribute-variable" data-vcfcp-variable-attribute-id="${attribute.vcfcpAttributeId}"  contenteditable="false" style="color:black; font-weight:bold; font-style:normal">@${attribute.label}</a>` +\n                        "&nbsp;" +\n                        `${textAfterAttributeMention}`;\n                    $inputDiv.html(`${newInputValue}`);\n                    $CalculationEditorDropdownDisplay.remove();\n                    const pos = caretPositionOfAtChar + diff;\n                    const posNew = pos + attribute.label.length + 1;\n                    _vCFCP_app_server_enterprise_src_main_js_app_services_caretUtils_service__WEBPACK_IMPORTED_MODULE_6__/* .setCurrentCursorPosition */ .yH($inputDiv[0], posNew);\n                    $inputDiv.trigger("focus");\n                    this.updateCalculationInputDiv($dataAttributesContainer);\n                }));\n                $attributeList.append($attributeDropdownEntry);\n            });\n        });\n    }\n    filterDataAttributes(attributeList, searchWord) {\n        if (searchWord.length === 0) {\n            return attributeList;\n        }\n        const searchWordLower = searchWord.toLowerCase();\n        return attributeList.filter((dataAttribute) => {\n            if (dataAttribute.label.toLowerCase().includes(searchWordLower)) {\n                return true;\n            }\n        });\n    }\n    updateCalculationInputDiv($dataAttributesContainer) {\n        const dataAttributes = this.getActiveNumberAttributes($dataAttributesContainer);\n        const tempSetOfActiveIds = new Set();\n        dataAttributes.forEach((dataAttribute) => {\n            tempSetOfActiveIds.add(dataAttribute.vcfcpAttributeId);\n            const $attributeVariable = $dataAttributesContainer.find("a[data-vcfcp-variable-attribute-id=" + dataAttribute.vcfcpAttributeId + "]");\n            const $attributeVariableDropdownEntry = $dataAttributesContainer.find("a[data-vcfcp-a-attribute-id=" + dataAttribute.vcfcpAttributeId + "]");\n            if ($attributeVariable.length > 0) {\n                $attributeVariable.html("@" + dataAttribute.label);\n            }\n            if ($attributeVariableDropdownEntry.length > 0) {\n                $attributeVariableDropdownEntry.html(dataAttribute.label);\n            }\n        });\n        $dataAttributesContainer.find(".vcfcp-attribute-variable").each((index, element) => {\n            const id = $(element).attr("data-vcfcp-variable-attribute-id");\n            if (tempSetOfActiveIds.has(id)) {\n            }\n            else {\n                $(element).remove();\n            }\n        });\n        $dataAttributesContainer.find(".vcfcp-attribute-dropdown-entry-a").each((index, element) => {\n            const id = $(element).attr("data-vcfcp-a-attribute-id");\n            if (tempSetOfActiveIds.has(id)) {\n            }\n            else {\n                $(element).remove();\n            }\n        });\n    }\n    getActiveNumberAttributes($dataAttributesContainer) {\n        const dataAttributes = [];\n        const attributeOrderIndex = 0;\n        $dataAttributesContainer.children().each((index, element) => {\n            const $attributeContainer = $(element);\n            const attributeLabel = this.sanitizerService.getSanitizedString($attributeContainer.find(`.vcfcp-data-attribute-label-input`).val());\n            const attributeType = this.sanitizerService.getSanitizedString($attributeContainer.find(`.vcfcp-attribute-type-select`).val(), { USE_PROFILES: { html: true } });\n            let id = $attributeContainer.attr("data-attribute-id");\n            if (id === undefined) {\n                id = $attributeContainer.attr("tempId");\n            }\n            if (attributeType === "NUMBER" && attributeLabel.length > 0) {\n                dataAttributes.push({\n                    vcfcpAttributeId: id,\n                    orderIndex: attributeOrderIndex,\n                    type: attributeType,\n                    label: attributeLabel,\n                });\n            }\n        });\n        return dataAttributes;\n    }\n    getPredefinedValuesCalculationWithValidation($attributeContainer, $dataAttributesContainer) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const predefinedValues = new Array();\n            let dataAttributeId;\n            const $inputDivs = $attributeContainer.find(".vcfcp-calc-math-exp-input-div");\n            const $inputDivsMathExp = $inputDivs.clone();\n            const $inputDivsMathExpToCheckSyntaxFirstCheck = $inputDivs.clone();\n            const $inputDivsMathExpToCheckSyntaxThirdCheck = $inputDivs.clone();\n            $inputDivsMathExp.children().each((index, child) => {\n                const tempId = $(child).attr("data-vcfcp-variable-attribute-id");\n                if (tempId) {\n                    dataAttributeId = $dataAttributesContainer.find("div[tempId=" + tempId + "]").attr("data-attribute-id");\n                    if (dataAttributeId === undefined) {\n                        dataAttributeId = tempId;\n                    }\n                    dataAttributeId = ";" + dataAttributeId + ";";\n                    dataAttributeId = "(" + dataAttributeId + ")";\n                    const $idTextNode = document.createTextNode(dataAttributeId);\n                    $(child).replaceWith($idTextNode);\n                }\n                else {\n                }\n            });\n            let mathExpression = $inputDivsMathExp.text();\n            mathExpression = mathExpression.replace(/\\s+/g, "");\n            const mathExpressionCopy = mathExpression;\n            const dataAttributesWithAllDirectBracketsRegex = new RegExp(/\\(+;.*?;\\)+/g);\n            let result;\n            while ((result = dataAttributesWithAllDirectBracketsRegex.exec(mathExpressionCopy))) {\n                const matchingString = result[0];\n                let numberOpeningBrackets = 0;\n                let numberClosingBrackets = 0;\n                matchingString.match(/^\\(+/g).forEach((element) => {\n                    numberOpeningBrackets = element.length;\n                });\n                matchingString.match(/\\)+$/g).forEach((element) => {\n                    numberClosingBrackets = element.length;\n                });\n                const numberOfBracketsToDelete = Math.min(numberOpeningBrackets, numberClosingBrackets) - 1;\n                const replacementString = matchingString.substring(numberOfBracketsToDelete, matchingString.length - numberOfBracketsToDelete);\n                mathExpression = mathExpression.replace(result[0], replacementString);\n            }\n            predefinedValues.push({\n                type: _model_enum_predefined_value_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .PredefinedValueTypeEnum.CALCULATION_INPUT */ .Q.CALCULATION_INPUT,\n                orderIndex: 0,\n                value: mathExpression,\n            });\n            $inputDivsMathExpToCheckSyntaxFirstCheck.children().each((index, child) => {\n                const tempId = $(child).attr("data-vcfcp-variable-attribute-id");\n                if (tempId) {\n                    $(child).replaceWith(document.createTextNode("x"));\n                }\n                else {\n                }\n            });\n            const argumentsSet = new Set();\n            $inputDivsMathExpToCheckSyntaxThirdCheck.children().each((index, child) => {\n                const tempId = $(child).attr("data-vcfcp-variable-attribute-id");\n                if (tempId) {\n                    const cleanedVariableName = $(child)\n                        .text()\n                        .replaceAll(/@/g, "v")\n                        .replaceAll(/(\\s+)/g, "")\n                        .replaceAll(/[^a-zA-Z]/g, "z");\n                    argumentsSet.add(cleanedVariableName);\n                    const $idTextNode = document.createTextNode(cleanedVariableName);\n                    $(child).replaceWith($idTextNode);\n                }\n                else {\n                }\n            });\n            const argumentsArray = [];\n            for (const value of argumentsSet) {\n                argumentsArray.push(mathparser_org_mxparser_out_Argument__WEBPACK_IMPORTED_MODULE_4__.Argument.createArgumentWithNameAndValue(value.toString(), Number(this.generateRandomNumberOneToHundred())));\n            }\n            let mathExpressionToCheckSyntaxFirstCheck = $inputDivsMathExpToCheckSyntaxFirstCheck.text();\n            let mathExpressionToCheckSyntaxThirdCheck = $inputDivsMathExpToCheckSyntaxThirdCheck.text();\n            mathExpressionToCheckSyntaxFirstCheck = mathExpressionToCheckSyntaxFirstCheck.replace(/\\s+/g, "");\n            mathExpressionToCheckSyntaxThirdCheck = mathExpressionToCheckSyntaxThirdCheck.replace(/\\s+/g, "");\n            let operatorBetweenArgumentsMissing = false;\n            const regex = /x/g;\n            const matches = mathExpressionToCheckSyntaxFirstCheck.matchAll(regex);\n            for (const match of matches) {\n                if (match.index !== undefined) {\n                    if (match.index > 0) {\n                        if (_model_enum_calculation_operator_enum__WEBPACK_IMPORTED_MODULE_2__/* .CalculationOperatorEnum */ .u[mathExpressionToCheckSyntaxFirstCheck.charAt(match.index - 1).toString()]) {\n                        }\n                        else {\n                            operatorBetweenArgumentsMissing = true;\n                            break;\n                        }\n                    }\n                    if (!(match.index + match[0].length >= mathExpressionToCheckSyntaxFirstCheck.length)) {\n                        if (_model_enum_calculation_operator_enum__WEBPACK_IMPORTED_MODULE_2__/* .CalculationOperatorEnum */ .u[mathExpressionToCheckSyntaxFirstCheck.charAt(match.index + match[0].length)]) {\n                        }\n                        else {\n                            operatorBetweenArgumentsMissing = true;\n                            break;\n                        }\n                    }\n                }\n            }\n            const regOpenParenthesis = /\\(/g;\n            const regClosePraenthesis = /\\)/g;\n            let moreOpeningThanClosingParenthesis = false;\n            let moreClosingThanOpeningParenthesis = false;\n            let matchesOpenParenthesis = mathExpressionToCheckSyntaxThirdCheck.match(regOpenParenthesis);\n            let matchesCloseParenthesis = mathExpressionToCheckSyntaxThirdCheck.match(regClosePraenthesis);\n            matchesCloseParenthesis = matchesCloseParenthesis ? matchesCloseParenthesis : [];\n            matchesOpenParenthesis = matchesOpenParenthesis ? matchesOpenParenthesis : [];\n            if (matchesOpenParenthesis.length > matchesCloseParenthesis.length) {\n                moreOpeningThanClosingParenthesis = true;\n            }\n            else if (matchesOpenParenthesis.length < matchesCloseParenthesis.length) {\n                moreClosingThanOpeningParenthesis = true;\n            }\n            let mathResult;\n            if (operatorBetweenArgumentsMissing) {\n                mathResult = { validation: _model_enum_calculation_validation_enum__WEBPACK_IMPORTED_MODULE_0__/* .CalculationValidationEnum.INVALID */ .H.INVALID, errorMessage: "Operator between arguments missing" };\n                yield this.showMathEvaluationMessage(mathResult, $attributeContainer);\n            }\n            else if (moreOpeningThanClosingParenthesis) {\n                mathResult = { validation: _model_enum_calculation_validation_enum__WEBPACK_IMPORTED_MODULE_0__/* .CalculationValidationEnum.INVALID */ .H.INVALID, errorMessage: "More opening parenthesis than closing ones" };\n                yield this.showMathEvaluationMessage(mathResult, $attributeContainer);\n            }\n            else if (moreClosingThanOpeningParenthesis) {\n                mathResult = { validation: _model_enum_calculation_validation_enum__WEBPACK_IMPORTED_MODULE_0__/* .CalculationValidationEnum.INVALID */ .H.INVALID, errorMessage: "More closing parenthesis than opening ones" };\n                yield this.showMathEvaluationMessage(mathResult, $attributeContainer);\n            }\n            else {\n                mathResult = this.evaluateMathExpressionWithArgumentsArray(mathExpressionToCheckSyntaxThirdCheck, argumentsArray);\n                if (mathResult.validation === _model_enum_calculation_validation_enum__WEBPACK_IMPORTED_MODULE_0__/* .CalculationValidationEnum.INVALID */ .H.INVALID) {\n                    yield this.showMathEvaluationMessage(mathResult, $attributeContainer);\n                }\n            }\n            return { predefinedValues: predefinedValues, mathExpressionValidation: mathResult.validation };\n        });\n    }\n    showMathEvaluationMessage(mathResult, $attributeContainer) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $errorDiv = $attributeContainer.find(".error-calculation-editor-container");\n            $errorDiv.empty();\n            $errorDiv.append("<u>" + (yield this.platformUtils.getText("de.viadee.confluence.managed-data-fields.warning.invalid-math-expression")) + "</u>");\n            if (mathResult.errorMessage) {\n                const message = yield this.interpretCalculationErrorMessage(mathResult.errorMessage);\n                if (message.length > 0) {\n                    $errorDiv.append("<u>:</u>" + " " + message + "");\n                }\n            }\n        });\n    }\n    reconstructMathExpression(mathExpressionWithIds, $dataAttributesContainer) {\n        let mathExpression = mathExpressionWithIds;\n        const mathExpressionToIterate = mathExpressionWithIds;\n        let char;\n        for (let x = 0; x < mathExpressionToIterate.length; x++) {\n            char = mathExpressionToIterate.charAt(x);\n            if (char === ";") {\n                let id = "";\n                do {\n                    id = id.concat(char);\n                    x++;\n                    char = mathExpressionToIterate.charAt(x);\n                } while (char !== ";");\n                id = id.concat(char);\n                const $attribute = $dataAttributesContainer.find("div[data-attribute-id=" + id.substring(1, id.length - 1) + "]");\n                const attributeLabel = this.sanitizerService.getSanitizedString($attribute.find(`.vcfcp-data-attribute-label-input`).val());\n                const replacerId = `<a class="vcfcp-attribute-variable" data-vcfcp-variable-attribute-id="${id.substring(1, id.length - 1)}" contenteditable="false" style="color:black; font-weight:bold; font-style:normal">@${attributeLabel}</a>`;\n                mathExpression = mathExpression.replace(id, replacerId);\n            }\n            else {\n            }\n        }\n        if (mathExpression.charAt(0) === "<") {\n            mathExpression = "&nbsp;" + mathExpression;\n        }\n        if (mathExpression.charAt(mathExpression.length - 1) === ">") {\n            mathExpression = mathExpression + "&nbsp;";\n        }\n        return mathExpression;\n    }\n    interpretCalculationErrorMessage(message) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (message.includes("lexical error")) {\n                const regex = /column\\s(?<columIndex>\\d*)\\./gm;\n                const match = regex.exec(message);\n                if (match && match.groups) {\n                    const pos = match.groups.columIndex;\n                    return (yield this.platformUtils.getText("de.viadee.confluence.managed-data-fields.warning.calc-error-position")) + " " + pos;\n                }\n            }\n            else if (message.includes("Duplicated <KEYWORD>")) {\n                return yield this.platformUtils.getText("de.viadee.confluence.managed-data-fields.warning.duplicate-keyword");\n            }\n            else if (message.includes("Operator between arguments missing")) {\n                return yield this.platformUtils.getText("de.viadee.confluence.managed-data-fields.warning.operator-missing");\n            }\n            else if (message.includes("More closing parenthesis than opening ones")) {\n                return yield this.platformUtils.getText("de.viadee.confluence.managed-data-fields.warning.closing-parenthesis");\n            }\n            else if (message.includes("More opening parenthesis than closing ones")) {\n                return yield this.platformUtils.getText("de.viadee.confluence.managed-data-fields.warning.opening-parenthesis");\n            }\n            return "";\n        });\n    }\n    generateRandomNumberOneToHundred() {\n        return Math.floor(Math.random() * 100) + 1;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/services/calculation.service.ts?')},"../../../../../../MDF-core/core-js/app/services/encoding.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "d": () => (/* binding */ customStringEncoding)\n/* harmony export */ });\n/* unused harmony export decodeHtmlEntity */\n/* harmony import */ var js_base64__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../MDF-core/core-js/node_modules/js-base64/base64.mjs");\n\nconst customStringEncoding = (mode, str) => {\n    switch (mode) {\n        case "encode":\n            const base64String = js_base64__WEBPACK_IMPORTED_MODULE_0__/* .Base64.encode */ .DS.encode(str);\n            const customBase64String = base64String.replace(/=/g, "!");\n            const result = customBase64String.replace(/=/g, "!");\n            return result;\n        case "decode":\n            const normalBase64 = str.replace(/!/g, "=");\n            const utf8String = js_base64__WEBPACK_IMPORTED_MODULE_0__/* .Base64.decode */ .DS.decode(normalBase64);\n            return utf8String;\n        default:\n            throw Error("customStringEncoding: Unexpected mode-type");\n    }\n};\nconst decodeHtmlEntity = (str) => {\n    const htmlEntity = str.replace(/&quot;/g, \'"\');\n    return htmlEntity.replace(/&#(\\d+);/g, (match, dec) => {\n        return String.fromCharCode(dec);\n    });\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/services/encoding.service.ts?')},"../../../../../../MDF-core/core-js/app/services/field-definition.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "y": () => (/* binding */ FieldDefinitionService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_field_definition_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/field-definition-type.enum.ts");\n/* harmony import */ var _model_enum_predefined_value_type_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/predefined-value-type.enum.ts");\n/* harmony import */ var _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/attribute-type.enum.ts");\n/* harmony import */ var _model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/app-type-html-prefix.enum.ts");\n/* harmony import */ var _utils_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../MDF-core/core-js/app/services/utils.service.ts");\nif ("bpmnEntPlatformMDF" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../MDF-core/core-js/app/services/mdf-sanitizer.service.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\nclass FieldDefinitionService {\n    constructor(appType, platformUtils) {\n        this.appType = appType;\n        this.platformUtils = platformUtils;\n        this.baseUrl = "/rest/managed-data-fields/1.0/fielddefinitions";\n        this.pluginName = _utils_service__WEBPACK_IMPORTED_MODULE_4__/* .initPluginName */ .lM(this.appType);\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z(this.pluginName, "FieldDefinitionService");\n    }\n    mergeAttributesWithCurrentDefinition(fieldDefinitionAttributes, othersAttributes) {\n        var _a;\n        const mergedAttributes = [];\n        for (const definitionAttribute of fieldDefinitionAttributes) {\n            const definitionAttributeToCopy = definitionAttribute;\n            definitionAttributeToCopy.values = [];\n            if (dataAttributeIsInAttributesList(definitionAttribute, othersAttributes)) {\n                const instanceAttribute = getAttributeFromAttributesList(definitionAttribute, othersAttributes);\n                definitionAttributeToCopy.values = instanceAttribute.values;\n                if (definitionAttribute.predefinedValues && definitionAttribute.predefinedValues.length > 0) {\n                    for (const selectedValue of instanceAttribute.values) {\n                        if (!isValuePredefined(selectedValue, definitionAttribute.predefinedValues) && selectedValue !== null) {\n                            const predefinedValueType = definitionAttribute.predefinedValues[0].type;\n                            definitionAttributeToCopy.predefinedValues.push({\n                                value: selectedValue,\n                                type: predefinedValueType,\n                                orderIndex: ((_a = definitionAttributeToCopy.predefinedValues) === null || _a === void 0 ? void 0 : _a.length) || 0,\n                                outdated: true,\n                            });\n                        }\n                    }\n                }\n            }\n            mergedAttributes.push(definitionAttributeToCopy);\n        }\n        for (const instanceAttribute of othersAttributes) {\n            if (!dataAttributeIsInAttributesList(instanceAttribute, mergedAttributes)) {\n                if (instanceAttribute.values.length > 0) {\n                    if (!(instanceAttribute.values.length === 1 && instanceAttribute.values[0] === "")) {\n                        instanceAttribute.outdated = true;\n                        instanceAttribute.orderIndex = (mergedAttributes === null || mergedAttributes === void 0 ? void 0 : mergedAttributes.length) || 0;\n                        mergedAttributes.push(instanceAttribute);\n                    }\n                }\n            }\n        }\n        return mergedAttributes;\n        function dataAttributeIsInAttributesList(dataAttribute, list) {\n            const matchingAttributeIndex = list.findIndex((attribute) => attribute.vcfcpAttributeId === dataAttribute.vcfcpAttributeId);\n            return matchingAttributeIndex !== -1;\n        }\n        function getAttributeFromAttributesList(dataAttribute, list) {\n            return list.find((attribute) => attribute.vcfcpAttributeId === dataAttribute.vcfcpAttributeId);\n        }\n        function getPredefinedValueFromList(predefinedValue, list) {\n            return list.find((value) => value.value === predefinedValue.value);\n        }\n        function isValuePredefined(value, list) {\n            const tempPredefObj = { value, type: _model_enum_predefined_value_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .PredefinedValueTypeEnum.CHECKBOX_OPTION */ .Q.CHECKBOX_OPTION, orderIndex: 0 };\n            return getPredefinedValueFromList(tempPredefObj, list);\n        }\n    }\n    addNewFieldDefinition(fieldDefinition) {\n        return __awaiter(this, void 0, void 0, function* () {\n            fieldDefinition = _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldDefinition */ .O.sanitizeFieldDefinition(fieldDefinition);\n            const url = this.buildRestUrl(`${this.baseUrl}/add`);\n            return $.ajax({\n                url,\n                type: "POST",\n                cache: false,\n                contentType: "application/json; charset=utf-8",\n                data: JSON.stringify(fieldDefinition),\n                async: false,\n                success: (data) => {\n                    return data;\n                },\n                error: (error) => __awaiter(this, void 0, void 0, function* () {\n                    if (!(error.status === 404)) {\n                        this.vxcpLogger.logError("addNewFieldDefinition", "ERROR @FieldDefinitionService.addNewFieldDefinition: REST-Error occurred while saving new field definition on the server.", error);\n                    }\n                }),\n            });\n        });\n    }\n    updateFieldDefinition(fieldDefinition) {\n        return __awaiter(this, void 0, void 0, function* () {\n            fieldDefinition = _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldDefinition */ .O.sanitizeFieldDefinition(fieldDefinition);\n            const url = this.buildRestUrl(`${this.baseUrl}/edit/${fieldDefinition.vcfcpDefinitionId}`);\n            return $.ajax({\n                url,\n                type: "PUT",\n                cache: false,\n                contentType: "application/json; charset=utf-8",\n                data: JSON.stringify(fieldDefinition),\n                async: false,\n                success: (data) => {\n                    return data;\n                },\n                error: (error) => __awaiter(this, void 0, void 0, function* () {\n                    if (!(error.status === 404)) {\n                        this.vxcpLogger.logError("updateFieldDefinition", "ERROR @FieldDefinitionService.updateFieldDefinition: REST-Error occurred while updating field definition on the server.", error);\n                    }\n                }),\n            });\n        });\n    }\n    doesFieldDefinitionWithNameExist(name) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.baseUrl}/${name}`);\n            return new Promise((resolve, reject) => {\n                $.ajax({\n                    type: "HEAD",\n                    cache: false,\n                    url,\n                    dataType: "json",\n                    success: (a, b, c) => {\n                        if (c.status === 204) {\n                            resolve(false);\n                        }\n                        else {\n                            resolve(true);\n                        }\n                    },\n                    error: (err) => __awaiter(this, void 0, void 0, function* () {\n                        this.vxcpLogger.logError("doesFieldDefinitionWithNameExist", "ERROR @FieldDefinitionService.getFieldDefinitionByName: REST-Error occurred while getting field definition from server.", err);\n                        reject(false);\n                    }),\n                });\n            });\n        });\n    }\n    getFieldDefinitionByNameOrId(name) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.baseUrl}/${name}`);\n            return $.ajax({\n                type: "GET",\n                cache: false,\n                url,\n                dataType: "json",\n                success: (fieldDefinition, b, xhr) => {\n                    return _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldDefinition */ .O.sanitizeFieldDefinition(fieldDefinition);\n                },\n                error: (err, a, b) => __awaiter(this, void 0, void 0, function* () {\n                    this.vxcpLogger.logInfo("getFieldDefinitionByName", "ERROR @FieldDefinitionService.getFieldDefinitionByName: REST-Error occurred while getting field definition from server.", err);\n                }),\n            });\n        });\n    }\n    getDataAttributeById(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.baseUrl}/dataAttribute/${id}`);\n            return $.ajax({\n                type: "GET",\n                cache: false,\n                url,\n                dataType: "json",\n                success: (dataAttribute, b, xhr) => {\n                    return _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeDataAttribute */ .O.sanitizeDataAttribute(dataAttribute);\n                },\n                error: (err, a, b) => __awaiter(this, void 0, void 0, function* () {\n                    this.vxcpLogger.logInfo("getDataAttributeById", "ERROR @FieldDefinitionService.getDataAttributeById: REST-Error occurred while getting data attribute from server.", err);\n                }),\n            });\n        });\n    }\n    getAllFieldDefinitionsForUser() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.baseUrl}/all`);\n            return new Promise((resolve, reject) => {\n                $.ajax({\n                    type: "GET",\n                    cache: false,\n                    url,\n                    dataType: "json",\n                    success: (data) => {\n                        resolve(data.map((fieldDefinition) => _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldDefinition */ .O.sanitizeFieldDefinition(fieldDefinition)));\n                    },\n                    error: (err) => __awaiter(this, void 0, void 0, function* () {\n                        const errorText = "ERROR @FieldDefinitionService.getAllFieldDefinitions: REST-Error occurred while getting field definitions from server";\n                        this.vxcpLogger.logInfo("getAllFieldDefinitions", errorText);\n                        reject(null);\n                    }),\n                });\n            });\n        });\n    }\n    getAllFieldDefinitionsForSpace(spaceKey) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.baseUrl}/space/${spaceKey}`);\n            return new Promise((resolve, reject) => {\n                $.ajax({\n                    type: "GET",\n                    cache: false,\n                    url,\n                    dataType: "json",\n                    success: (data) => {\n                        data.map((fieldDefinition) => _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldDefinition */ .O.sanitizeFieldDefinition(fieldDefinition));\n                        resolve(data.map((fieldDefinition) => _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldDefinition */ .O.sanitizeFieldDefinition(fieldDefinition)));\n                    },\n                    error: (err) => __awaiter(this, void 0, void 0, function* () {\n                        const errorText = "ERROR @FieldDefinitionService.getAllFieldDefinitions: REST-Error occurred while getting field definitions from server";\n                        this.vxcpLogger.logInfo("getAllFieldDefinitions", errorText);\n                        reject(null);\n                    }),\n                });\n            });\n        });\n    }\n    deleteFieldDefinition(name) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.baseUrl}/delete/${name}`);\n            yield $.ajax({\n                type: "DELETE",\n                cache: false,\n                url,\n                dataType: "json",\n                success: (data) => {\n                    return data;\n                },\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    this.vxcpLogger.logError("deleteFieldDefinition", "ERROR @FieldDefinitionService.deleteFieldDefinition: REST-Error occurred while deleting field definition from server.", err);\n                }),\n            });\n        });\n    }\n    deleteAllDefinitions() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.baseUrl}/delete/wipeAllDefinitions`);\n            return $.ajax({\n                type: "DELETE",\n                cache: false,\n                url,\n                dataType: "json",\n                success: (data) => {\n                    this.vxcpLogger.logInfo("deleteAllDefinitions", "deletion successful.", data);\n                },\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    this.vxcpLogger.logError("deleteAllDefinitions", "ERROR @FieldDefinitionService.deleteAllDefinitions: REST-Error occurred while deleting field instance by macro id.", err);\n                }),\n            });\n        });\n    }\n    dataTypeToI18nLabel(type) {\n        let i18nBasePath = "";\n        switch (this.appType) {\n            case _model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_3__/* .AppTypeHtmlPrefixEnum.MDF */ .U.MDF:\n                i18nBasePath = "de.viadee.confluence.managed-data-fields.fieldtype";\n                break;\n            case _model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_3__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT:\n                i18nBasePath = "de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.managed-data-fields-tab.fieldtype";\n                break;\n            case _model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_3__/* .AppTypeHtmlPrefixEnum.DMN_ENT */ .U.DMN_ENT:\n                i18nBasePath = "de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.managed-data-fields-tab.fieldtype";\n                break;\n            default:\n                i18nBasePath = "de.viadee.confluence.managed-data-fields.fieldtype";\n                break;\n        }\n        switch (type) {\n            case _model_enum_field_definition_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FieldDefinitionTypeEnum.STRING */ .m.STRING:\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .AttributeTypeEnum.STRING */ .S.STRING:\n                return this.platformUtils.getText(`${i18nBasePath}.vCFCP_String`);\n            case _model_enum_field_definition_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FieldDefinitionTypeEnum.NUMBER */ .m.NUMBER:\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .AttributeTypeEnum.NUMBER */ .S.NUMBER:\n                return this.platformUtils.getText(`${i18nBasePath}.vCFCP_Number`);\n            case _model_enum_field_definition_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FieldDefinitionTypeEnum.CHECKBOX */ .m.CHECKBOX:\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .AttributeTypeEnum.CHECKBOX */ .S.CHECKBOX:\n                return this.platformUtils.getText(`${i18nBasePath}.vCFCP_Checkbox`);\n            case _model_enum_field_definition_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FieldDefinitionTypeEnum.RADIO */ .m.RADIO:\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .AttributeTypeEnum.RADIO */ .S.RADIO:\n                return this.platformUtils.getText(`${i18nBasePath}.vCFCP_Radio`);\n            case _model_enum_field_definition_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FieldDefinitionTypeEnum.COMPLEX */ .m.COMPLEX:\n                return this.platformUtils.getText(`${i18nBasePath}.vCFCP_Complex`);\n            case _model_enum_field_definition_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FieldDefinitionTypeEnum.DATE */ .m.DATE:\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .AttributeTypeEnum.DATE */ .S.DATE:\n                return this.platformUtils.getText(`${i18nBasePath}.vCFCP_Date`);\n            case _model_enum_field_definition_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FieldDefinitionTypeEnum.DROPDOWN */ .m.DROPDOWN:\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .AttributeTypeEnum.DROPDOWN */ .S.DROPDOWN:\n                return this.platformUtils.getText(`${i18nBasePath}.vCFCP_Dropdown`);\n            case _model_enum_field_definition_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FieldDefinitionTypeEnum.USER */ .m.USER:\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .AttributeTypeEnum.USER */ .S.USER:\n                return this.platformUtils.getText(`${i18nBasePath}.vCFCP_User`);\n            case _model_enum_field_definition_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FieldDefinitionTypeEnum.CALCULATION */ .m.CALCULATION:\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .AttributeTypeEnum.CALCULATION */ .S.CALCULATION:\n                return this.platformUtils.getText(`${i18nBasePath}.vCFCP_Calculation`);\n            default:\n                return "unknown type";\n        }\n    }\n    buildRestUrl(restCall) {\n        const baseUrl = this.platformUtils.buildConfluenceBaseUrl();\n        const restUrl = decodeURI(baseUrl + restCall);\n        return encodeURI(restUrl);\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/services/field-definition.service.ts?')},"../../../../../../MDF-core/core-js/app/services/field-instance.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "p": () => (/* binding */ FieldInstanceService)\n/* harmony export */ });\nif ("bpmnEntPlatformMDF" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/attribute-type.enum.ts");\n/* harmony import */ var _model_enum_predefined_value_type_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/predefined-value-type.enum.ts");\n/* harmony import */ var _model_enum_vcfcp_id_prefix_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/vcfcp-id-prefix.enum.ts");\n/* harmony import */ var _encoding_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../MDF-core/core-js/app/services/encoding.service.ts");\n/* harmony import */ var _utils_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../MDF-core/core-js/app/services/utils.service.ts");\n/* harmony import */ var _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../MDF-core/core-js/app/services/mdf-sanitizer.service.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\nclass FieldInstanceService {\n    constructor(idService, platformUtils, appType) {\n        this.idService = idService;\n        this.platformUtils = platformUtils;\n        this.appType = appType;\n        this.fieldInstanceRestBaseUrl = "/rest/managed-data-fields/1.0/fieldinstances";\n        this.performRequest = (url, restType) => __awaiter(this, void 0, void 0, function* () {\n            return $.ajax({\n                type: restType,\n                cache: false,\n                url,\n                dataType: "json",\n                success: (data) => {\n                    return data;\n                },\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    this.vxcpLogger.logError("performRequest", "Error occurred performing a REST request.", err);\n                    return Promise.reject(err);\n                }),\n            });\n        });\n        this.pluginName = _utils_service__WEBPACK_IMPORTED_MODULE_4__/* .initPluginName */ .lM(appType);\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z(this.pluginName, "FieldInstanceService");\n    }\n    createFieldInstanceFromUserInput($fieldDefinitionElement, selectedFieldDefinitionName, fieldDefinitions, pageId, vbcpEntId = "") {\n        const dataAttributes = this.createAttributeObjectsFromInput($fieldDefinitionElement);\n        const fieldDef = this.getLocalFieldDefinitionByNameOrId(selectedFieldDefinitionName, fieldDefinitions);\n        const attributesWrapper = {\n            dataAttributes,\n        };\n        const valueJsonString = JSON.stringify(attributesWrapper);\n        const newInstanceId = this.idService.generateUuid(_model_enum_vcfcp_id_prefix_enum__WEBPACK_IMPORTED_MODULE_2__/* .VcfcpIdPrefixEnum.vcfcpInstanceId */ .d.vcfcpInstanceId);\n        const fieldInstance = {\n            vcfcpDefinitionId: fieldDef.vcfcpDefinitionId,\n            vcfcpInstanceId: newInstanceId,\n            valueId: this.idService.generateValueId(valueJsonString, newInstanceId),\n            pageid: pageId,\n            macroid: "undefined",\n            vbcpModelId: vbcpEntId,\n            value: valueJsonString,\n            definitionName: fieldDef.name,\n            published: false,\n        };\n        return _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldInstance */ .O.sanitizeFieldInstance(fieldInstance);\n    }\n    getLocalFieldDefinitionByNameOrId(queryTerm, fieldDefinitions) {\n        if (queryTerm.startsWith("vcfcpDefinition")) {\n            return fieldDefinitions.find((element) => element.vcfcpDefinitionId === queryTerm);\n        }\n        else {\n            return fieldDefinitions.find((element) => element.name === queryTerm);\n        }\n    }\n    createAttributeObjectsFromInput($fieldInstanceOrDefinitionDiv) {\n        const $attributesHtmls = $fieldInstanceOrDefinitionDiv.find(`.${this.appType}-viewer-field-attribute`);\n        const dataAttributes = [];\n        let attributeOrderIndex = 0;\n        $attributesHtmls.each((index, attributeDiv) => {\n            const attributeObject = {\n                vcfcpAttributeId: $(attributeDiv).data("attribute-id"),\n                type: $(attributeDiv).data("attribute-type"),\n                label: String($(attributeDiv).data("attribute-label")),\n                orderIndex: attributeOrderIndex,\n                predefinedValues: [],\n                values: [],\n            };\n            const predefinedValues = [];\n            const values = this.readInputValues(attributeDiv, predefinedValues);\n            attributeObject.predefinedValues = predefinedValues;\n            attributeObject.values = values;\n            dataAttributes.push(attributeObject);\n            attributeOrderIndex++;\n        });\n        return dataAttributes.map((dataAttribute) => _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeDataAttribute */ .O.sanitizeDataAttribute(dataAttribute));\n    }\n    readInputValues(attributeDiv, predefinedValues) {\n        let values = [];\n        switch ($(attributeDiv).data("attribute-type")) {\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.STRING */ .S.STRING:\n                const inputString = $(attributeDiv).find("textarea").val();\n                values.push(inputString.trim());\n                break;\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.NUMBER */ .S.NUMBER:\n                const input = $(attributeDiv).find("input").val();\n                values.push(input.trim());\n                break;\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.RADIO */ .S.RADIO:\n                values = this.getRadioInput(attributeDiv, predefinedValues);\n                break;\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.DROPDOWN */ .S.DROPDOWN:\n                values = this.getDropdownInput(attributeDiv, predefinedValues);\n                break;\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.CHECKBOX */ .S.CHECKBOX:\n                values = this.getCheckboxInput(attributeDiv, predefinedValues);\n                break;\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.DATE */ .S.DATE:\n                values.push($(attributeDiv).find("input").val());\n                break;\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.USER */ .S.USER:\n                values = this.getUserInput(attributeDiv);\n                break;\n            case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.CALCULATION */ .S.CALCULATION:\n                values = this.getCalculationInput(attributeDiv, predefinedValues);\n        }\n        return values.map((value) => _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.getSanitizedString */ .O.getSanitizedString(value));\n    }\n    getCalculationInput(attributeDiv, predefinedValues) {\n        const mathExpEncoded = $(attributeDiv).find(".math-expression").attr("data-math-expression");\n        let predefinedValueMathExp;\n        if (mathExpEncoded) {\n            predefinedValueMathExp = (0,_encoding_service__WEBPACK_IMPORTED_MODULE_3__/* .customStringEncoding */ .d)("decode", mathExpEncoded);\n        }\n        let predefinedValueOrderIndex = 0;\n        predefinedValues.push({\n            value: predefinedValueMathExp,\n            type: _model_enum_predefined_value_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .PredefinedValueTypeEnum.CALCULATION_INPUT */ .Q.CALCULATION_INPUT,\n            orderIndex: predefinedValueOrderIndex,\n        });\n        predefinedValueOrderIndex++;\n        return [];\n    }\n    getRadioInput(attributeDiv, predefinedValues) {\n        let predefinedValueOrderIndex = 0;\n        const values = [];\n        const $radioButtons = $(attributeDiv).find("input");\n        $radioButtons.each((idx, radioBtn) => {\n            predefinedValues.push({\n                value: $(radioBtn).val(),\n                type: _model_enum_predefined_value_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .PredefinedValueTypeEnum.RADIO_OPTION */ .Q.RADIO_OPTION,\n                orderIndex: predefinedValueOrderIndex,\n            });\n            predefinedValueOrderIndex++;\n            if ($(radioBtn).prop("checked")) {\n                values.push($(radioBtn).val());\n            }\n        });\n        return values;\n    }\n    getCheckboxInput(attributeDiv, predefinedValues) {\n        const values = [];\n        let predefinedValueOrderIndex = 0;\n        const $checkBoxes = $(attributeDiv).find("form").find("input");\n        $checkBoxes.each((idx, checkBox) => {\n            predefinedValues.push({\n                value: $(checkBox).val(),\n                type: _model_enum_predefined_value_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .PredefinedValueTypeEnum.CHECKBOX_OPTION */ .Q.CHECKBOX_OPTION,\n                orderIndex: predefinedValueOrderIndex,\n            });\n            predefinedValueOrderIndex++;\n            if ($(checkBox).prop("checked")) {\n                values.push($(checkBox).val());\n            }\n        });\n        return values;\n    }\n    getDropdownInput(attributeDiv, predefinedValues) {\n        const values = [];\n        let predefinedValueOrderIndex = 0;\n        const $dropdownOptions = $(attributeDiv).find("option");\n        $dropdownOptions.each((idx, dropOption) => {\n            predefinedValues.push({\n                value: $(dropOption).val(),\n                type: _model_enum_predefined_value_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .PredefinedValueTypeEnum.DROPDOWN_OPTION */ .Q.DROPDOWN_OPTION,\n                orderIndex: predefinedValueOrderIndex,\n            });\n            predefinedValueOrderIndex++;\n        });\n        const selectedValue = $(attributeDiv).find("select").val();\n        if (selectedValue) {\n            values.push(selectedValue);\n        }\n        return values;\n    }\n    getUserInput(attributeDiv) {\n        const values = [];\n        const $users = $(attributeDiv).find(`.${this.appType}-confluence-user`);\n        $users.each((userIndex, user) => {\n            const $userHTML = $(user);\n            const userKey = $userHTML.attr("data-vcfcp-confluence-user-id");\n            if (userKey) {\n                values.push(userKey);\n            }\n        });\n        return values;\n    }\n    addOrUpdateFieldInstanceVersion(fieldInstance) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.fieldInstanceRestBaseUrl}/update`);\n            return $.ajax({\n                url,\n                type: "POST",\n                cache: false,\n                contentType: "application/json; charset=utf-8",\n                data: JSON.stringify(_mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldInstance */ .O.sanitizeFieldInstance(fieldInstance)),\n                async: false,\n                success: (data) => {\n                    this.vxcpLogger.logInfo("addOrUpdateFieldInstance", "Creation/Update successful.", data);\n                    return data;\n                },\n                error: (error) => __awaiter(this, void 0, void 0, function* () {\n                    this.vxcpLogger.logError("addOrUpdateFieldInstance", "ERROR @FieldInstanceService.addOrUpdateFieldInstance: Error occurred while adding/editing a new field instance.", error);\n                }),\n            });\n        });\n    }\n    getAllPublishedInstances(pageId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.fieldInstanceRestBaseUrl}/getInstancesOfPage/${pageId}`);\n            return $.ajax({\n                type: "GET",\n                cache: false,\n                url,\n                dataType: "json",\n                success: (fieldInstances) => {\n                    return _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldInstances */ .O.sanitizeFieldInstances(fieldInstances);\n                },\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    this.vxcpLogger.logError("getAllFieldInstances", "Rejected. Error: REST-Error occurred while getting all field instances.", err);\n                    return Promise.reject(err);\n                }),\n            });\n        });\n    }\n    getAllFieldInstancesOfDefinitionId(definitionId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.fieldInstanceRestBaseUrl}/vcfcpDefinitionId/${definitionId}`);\n            const fieldInstances = yield this.collectPaginatedResults(url);\n            return _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldInstances */ .O.sanitizeFieldInstances(fieldInstances);\n        });\n    }\n    collectPaginatedResults(url, stopAfter = -1, restType = "GET") {\n        return __awaiter(this, void 0, void 0, function* () {\n            const collectedResults = [];\n            let hasMore = true;\n            let nextPageQueryParams = "";\n            while (hasMore) {\n                try {\n                    let nextPageUrl;\n                    if (url.includes("?")) {\n                        nextPageUrl = `${url}&${nextPageQueryParams}`;\n                    }\n                    else {\n                        nextPageUrl = `${url}?${nextPageQueryParams}`;\n                    }\n                    const paginatedResponse = yield this.performRequest(nextPageUrl, restType);\n                    collectedResults.push(...paginatedResponse.results);\n                    hasMore = paginatedResponse.hasMore;\n                    if (paginatedResponse.hasMore && paginatedResponse.next && collectedResults.length) {\n                        nextPageQueryParams = paginatedResponse.next;\n                    }\n                    if (stopAfter !== -1 && collectedResults.length >= stopAfter) {\n                        break;\n                    }\n                }\n                catch (e) {\n                    this.vxcpLogger.logError("collectPaginatedResults", `Error occurred collecting paginated results. Returning all so far fetched (${collectedResults.length})`, e);\n                    break;\n                }\n            }\n            return collectedResults;\n        });\n    }\n    updateAllInstanceVersionsOfInstanceId(instanceId, propsToUpdate) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let url = this.buildRestUrl(`${this.fieldInstanceRestBaseUrl}/updateAllInstanceVersions?instanceId=${instanceId}`);\n            for (const prop in propsToUpdate) {\n                if (propsToUpdate.hasOwnProperty(prop)) {\n                    if (prop === "value" || prop === "valueId") {\n                        alert("Development Warning: Are you sure to update the value of ALL instance versions? Aborting..");\n                        return;\n                    }\n                    url = url + `&${prop}=${propsToUpdate[prop]}`;\n                }\n            }\n            return $.ajax({\n                type: "POST",\n                cache: false,\n                url,\n                contentType: "application/json; charset=utf-8",\n                dataType: "json",\n                data: "",\n                success: (data) => {\n                    return data;\n                },\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    this.vxcpLogger.logError("getAllFieldInstancesOfDefinitionId", "Rejected. Error: REST-Error occurred while getting field instances by definition id.", err);\n                    return Promise.reject(err);\n                }),\n            });\n        });\n    }\n    getFieldInstanceByMacroId(macroId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.fieldInstanceRestBaseUrl}/${macroId}`);\n            return $.ajax({\n                type: "GET",\n                cache: false,\n                url,\n                dataType: "json",\n                success: (fieldInstance) => {\n                    return _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldInstance */ .O.sanitizeFieldInstance(fieldInstance);\n                },\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    this.vxcpLogger.logError("getFieldInstanceByMacroId", "Rejected. Error: REST-Error occurred while getting a field instance by macro id.", err);\n                    return Promise.reject(err);\n                }),\n            });\n        });\n    }\n    getFieldInstanceByInstanceId(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.fieldInstanceRestBaseUrl}/vcfcpInstanceId/${id}`);\n            return $.ajax({\n                type: "GET",\n                cache: false,\n                url,\n                dataType: "json",\n                success: (fieldInstance) => {\n                    return _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldInstance */ .O.sanitizeFieldInstance(fieldInstance);\n                },\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    this.vxcpLogger.logError("getFieldInstanceByInstanceId", "ERROR @FieldInstanceService.getFieldInstanceByInstanceId: REST-Error occurred while getting field instance by universally unique id.", err);\n                    return Promise.reject(err);\n                }),\n            });\n        });\n    }\n    getFieldInstanceVersionByValueId(valueId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.fieldInstanceRestBaseUrl}/valueId/${valueId}`);\n            return $.ajax({\n                type: "GET",\n                cache: false,\n                url,\n                dataType: "json",\n                success: (data) => {\n                    return _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldInstance */ .O.sanitizeFieldInstance(data);\n                },\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    this.vxcpLogger.logError("getFieldInstanceVersionByValueId", "ERROR @FieldInstanceService.getFieldInstanceVersionByValueId: REST-Error occurred while getting field instance by universally unique id.", err);\n                    return Promise.reject(err);\n                }),\n            });\n        });\n    }\n    setFieldInstanceMacroIdByInstanceId(vcfcpInstanceId, macroid) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.fieldInstanceRestBaseUrl}/setMacroId/${vcfcpInstanceId}/${macroid}`);\n            return $.ajax({\n                type: "GET",\n                cache: false,\n                url,\n                dataType: "json",\n                success: (data) => {\n                    return _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldInstance */ .O.sanitizeFieldInstance(data);\n                },\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    this.vxcpLogger.logError("setFieldInstanceMacroIdByUuid", "ERROR @FieldInstanceService.getFieldInstanceByMacroId: REST-Error occurred while setting field instance by universally unique id.", err);\n                    return Promise.reject(err);\n                }),\n            });\n        });\n    }\n    updateValueOfFieldInstanceByMacroId(macroId, fieldInstanceValue) {\n        return __awaiter(this, void 0, void 0, function* () {\n            fieldInstanceValue = _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldInstanceValueObj */ .O.sanitizeFieldInstanceValueObj(fieldInstanceValue);\n            const url = this.buildRestUrl(`${this.fieldInstanceRestBaseUrl}/${macroId}`);\n            return $.ajax({\n                type: "POST",\n                cache: false,\n                url,\n                contentType: "application/json; charset=utf-8",\n                dataType: "json",\n                data: JSON.stringify(fieldInstanceValue),\n                success: (data) => {\n                    return _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_5__/* .MdfSanitizerService.sanitizeFieldInstanceValueObj */ .O.sanitizeFieldInstanceValueObj(data);\n                },\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    this.vxcpLogger.logError("updateSelectedValues", "ERROR @FieldInstanceService.updateSelectedValues: REST-Error occurred while updating selected field instance values.", err);\n                }),\n            });\n        });\n    }\n    deleteFieldInstanceByMacroId(macroId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.fieldInstanceRestBaseUrl}/delete/${macroId}`);\n            return $.ajax({\n                type: "DELETE",\n                cache: false,\n                url,\n                dataType: "json",\n                success: (data) => {\n                    this.vxcpLogger.logInfo("deleteFieldInstanceByMacroId", "deletion successful.", data);\n                    return data;\n                },\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    this.vxcpLogger.logError("deleteFieldInstanceByMacroId", "ERROR @FieldDefinitionService.deleteFieldDefinition: REST-Error occurred while deleting field instance by macro id.", err);\n                }),\n            });\n        });\n    }\n    deleteFieldInstanceByInstanceId(instanceId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.buildRestUrl(`${this.fieldInstanceRestBaseUrl}/delete/instanceId/${instanceId}`);\n            return $.ajax({\n                type: "DELETE",\n                cache: false,\n                url,\n                dataType: "json",\n                success: (data) => {\n                },\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                }),\n            });\n        });\n    }\n    buildRestUrl(restCall) {\n        const baseUrl = this.platformUtils.buildConfluenceBaseUrl();\n        const restUrl = decodeURI(baseUrl + restCall);\n        return encodeURI(restUrl);\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/services/field-instance.service.ts?')},"../../../../../../MDF-core/core-js/app/services/field-rendering/field-rendering-core.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "T": () => (/* binding */ FieldRenderingCoreService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/attribute-type.enum.ts");\n/* harmony import */ var _utils_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../MDF-core/core-js/app/services/utils.service.ts");\n/* harmony import */ var _model_enum_field_definition_type_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/field-definition-type.enum.ts");\n/* harmony import */ var _model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/app-type-html-prefix.enum.ts");\n/* harmony import */ var _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../MDF-core/core-js/app/services/mdf-sanitizer.service.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __asyncValues = (undefined && undefined.__asyncValues) || function (o) {\n    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");\n    var m = o[Symbol.asyncIterator], i;\n    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);\n    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }\n    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }\n};\n\n\n\n\n\nclass FieldRenderingCoreService {\n    constructor(userMentionService, fieldDefinitionService, fieldRenderingUtilsService, idService, platformUtils, appType, fieldInstanceService, calculationService) {\n        this.i18nBasePath = "";\n        this.platformUtils = platformUtils;\n        this.appTypeHtmlPrefix = appType;\n        this.initAppTypeI18n(this.appTypeHtmlPrefix);\n        this.userMentionService = userMentionService;\n        this.fieldDefinitionService = fieldDefinitionService;\n        this.fieldRenderingUtils = fieldRenderingUtilsService;\n        this.idService = idService;\n        this.fieldInstanceService = fieldInstanceService;\n        this.calculationService = calculationService;\n    }\n    initAppTypeI18n(appType) {\n        switch (appType) {\n            case _model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_3__/* .AppTypeHtmlPrefixEnum.MDF */ .U.MDF:\n                this.i18nBasePath = "de.viadee.confluence.managed-data-fields.core";\n                break;\n            case _model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_3__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT:\n                this.i18nBasePath = "de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.managed-data-fields-tab";\n                break;\n            default:\n                this.i18nBasePath = "de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.managed-data-fields-tab";\n        }\n    }\n    getFieldInstanceHtml(fieldInstance, isEditable = false) {\n        return __awaiter(this, void 0, void 0, function* () {\n            fieldInstance = _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_4__/* .MdfSanitizerService.sanitizeFieldInstance */ .O.sanitizeFieldInstance(fieldInstance);\n            const instanceValueObj = JSON.parse(fieldInstance.value);\n            let fieldDefinitionType;\n            let fieldDefinitionName;\n            let noDefinitionExists;\n            let $domObj;\n            let fieldDefinition;\n            try {\n                fieldDefinition = yield this.fieldDefinitionService.getFieldDefinitionByNameOrId(fieldInstance.vcfcpDefinitionId);\n                fieldDefinitionType = fieldDefinition.vcfcpType;\n                fieldDefinitionName = fieldDefinition.name;\n                $domObj = $(this.getFieldInstanceMetaDataHtml(fieldInstance, fieldDefinitionType));\n                noDefinitionExists = false;\n            }\n            catch (e) {\n                $domObj = $(this.getFieldInstanceHtmlNoDefinition(fieldInstance));\n                fieldInstance.definitionName ? (fieldDefinitionName = fieldInstance.definitionName) : (fieldDefinitionName = undefined);\n                noDefinitionExists = true;\n            }\n            $domObj.append(this.getEmptyTableHtml());\n            const shouldShowDefinitionName = instanceValueObj.dataAttributes.length > 1 || (instanceValueObj.dataAttributes.length === 1 && instanceValueObj.dataAttributes[0].label !== fieldDefinitionName);\n            if (fieldDefinitionName && shouldShowDefinitionName) {\n                $domObj.find("thead").append(this.getDefinitionNameHeaderHtml(fieldDefinitionName));\n            }\n            instanceValueObj.dataAttributes = _utils_service__WEBPACK_IMPORTED_MODULE_1__/* .sortDataAttributesByOrderId */ .wO(instanceValueObj.dataAttributes);\n            for (const attribute of instanceValueObj.dataAttributes) {\n                const $result = yield this.getDataAttributeHtml(attribute, isEditable, false, fieldInstance);\n                $domObj.find(`#${this.appTypeHtmlPrefix}-data-attributes-tbody`).append($result);\n            }\n            if (fieldInstance.fallbackInstance) {\n                $domObj.append(yield this.getFallbackInfoHtml());\n            }\n            if (fieldInstance.deprecated) {\n                $domObj.append(yield this.getDeprecatedInfoHtml());\n            }\n            if (noDefinitionExists) {\n                $domObj.append(yield this.getDefinitionDeletedWarningHtml());\n            }\n            if (isEditable) {\n                FieldRenderingCoreService.enableEditFeatures($domObj);\n            }\n            if (!isEditable && fieldDefinition && fieldDefinition.hideUnselectedValues) {\n                FieldRenderingCoreService.hideUnselectedValues($domObj);\n            }\n            return $domObj;\n        });\n    }\n    static hideUnselectedValues($domObj) {\n        const $radios = $domObj.find(":radio");\n        const $checkboxes = $domObj.find("input:checkbox");\n        $radios.each((index, element) => {\n            if (!$(element).prop("checked")) {\n                $(element).parent().hide();\n            }\n        });\n        $checkboxes.each((index, element) => {\n            if (!$(element).prop("checked")) {\n                $(element).parent().hide();\n            }\n        });\n    }\n    static enableEditFeatures($domObj) {\n        $domObj.find("*").prop("disabled", false);\n        $domObj.find("*").prop("readonly", false);\n        $domObj.find("*").removeClass("disabled");\n    }\n    getFallbackInfoHtml() {\n        return __awaiter(this, void 0, void 0, function* () {\n            return `<div> <form class="aui"><div class="description">\n                    <span class="aui-icon aui-icon-small aui-iconfont-info-circle"></span>\n                    ${yield this.platformUtils.getText(`${this.i18nBasePath}.fallbackInstanceInfo`)}</div></form>`;\n        });\n    }\n    getDeprecatedInfoHtml() {\n        return __awaiter(this, void 0, void 0, function* () {\n            return `<div> <form class="aui"><div class="description">\n                    <span class="aui-icon aui-icon-small aui-iconfont-error"></span>\n                     ${yield this.platformUtils.getText(`${this.i18nBasePath}.deprecated-mdf-1-0-warning.text1`)}</br>\n                     ${yield this.platformUtils.getText(`${this.i18nBasePath}.deprecated-mdf-1-0-warning.text2`)}</div></form>`;\n        });\n    }\n    getDefinitionDeletedWarningHtml() {\n        return __awaiter(this, void 0, void 0, function* () {\n            return ` <div><form class="aui"><div class="description">\n                      <span class="aui-icon aui-icon-small aui-iconfont-error"></span>\n                      ${yield this.platformUtils.getText(`${this.i18nBasePath}.definitionDeletedWarning`)}</div></form>`;\n        });\n    }\n    getDefinitionNameHeaderHtml(fieldDefinitionName) {\n        return `<tr><th colspan="2" class="confluenceTh">\n                  <i style="font-weight: normal; font-size: x-large">${_mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_4__/* .MdfSanitizerService.getSanitizedString */ .O.getSanitizedString(fieldDefinitionName.toUpperCase())}</i>\n               </th></tr>`;\n    }\n    getEmptyTableHtml() {\n        return ` <table class="confluenceTable">\n                 <thead/>\n                <tbody id="${this.appTypeHtmlPrefix}-data-attributes-tbody">\n                </tbody>\n            </table> `;\n    }\n    getFieldInstanceHtmlNoDefinition(fieldInstance) {\n        return ` <div class="${this.appTypeHtmlPrefix}-viewer-field-instance ${this.appTypeHtmlPrefix}-viewer-field-viewer no-definition-for-instance"\n                     id="${fieldInstance.vcfcpInstanceId}" \n                     data-vcfcpInstanceId="${fieldInstance.vcfcpInstanceId}" \n                     data-vcfcpDefinitionId="${fieldInstance.vcfcpDefinitionId}" \n                     data-valueId="${fieldInstance.valueId}" \n                     data-vcfcpType=${_model_enum_field_definition_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .FieldDefinitionTypeEnum.UNDEFINED */ .m.UNDEFINED}" >\n                </div>`;\n    }\n    getFieldInstanceMetaDataHtml(fieldInstance, fieldDefinitionType) {\n        return `<div class="${this.appTypeHtmlPrefix}-viewer-field-instance ${this.appTypeHtmlPrefix}-viewer-field-viewer" \n                 data-vcfcpInstanceId="${fieldInstance.vcfcpInstanceId}" \n                 data-vcfcpDefinitionId="${fieldInstance.vcfcpDefinitionId}"\n                 data-valueId="${fieldInstance.valueId}" \n                 data-vcfcpType="${fieldDefinitionType}" >\n            </div>`;\n    }\n    getFieldDefinitionHtml(fieldDefinition, isEditable = false) {\n        var e_1, _a;\n        return __awaiter(this, void 0, void 0, function* () {\n            fieldDefinition = _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_4__/* .MdfSanitizerService.sanitizeFieldDefinition */ .O.sanitizeFieldDefinition(fieldDefinition);\n            const $domObj = $(this.getFieldDefinitionMetaDataHtml(fieldDefinition));\n            const isDefinition = true;\n            fieldDefinition.dataAttributes = _utils_service__WEBPACK_IMPORTED_MODULE_1__/* .sortDataAttributesByOrderId */ .wO(fieldDefinition.dataAttributes);\n            try {\n                for (var _b = __asyncValues(fieldDefinition.dataAttributes), _c; _c = yield _b.next(), !_c.done;) {\n                    const dataAttribute = _c.value;\n                    const $dataAttribute = yield this.getDataAttributeHtml(dataAttribute, isEditable, isDefinition);\n                    $domObj.find(`#${this.appTypeHtmlPrefix}-data-attributes-tbody`).append($dataAttribute);\n                }\n            }\n            catch (e_1_1) { e_1 = { error: e_1_1 }; }\n            finally {\n                try {\n                    if (_c && !_c.done && (_a = _b.return)) yield _a.call(_b);\n                }\n                finally { if (e_1) throw e_1.error; }\n            }\n            if (isEditable) {\n                FieldRenderingCoreService.enableEditFeatures($domObj);\n            }\n            return $domObj;\n        });\n    }\n    getFieldDefinitionMetaDataHtml(fieldDefinition) {\n        return ` <div class="${this.appTypeHtmlPrefix}-viewer-field-definition ${this.appTypeHtmlPrefix}-viewer-field-viewer" \n                             data-field-definition-name="${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(fieldDefinition.name)}" \n                             data-vcfcpDefinitionId="${fieldDefinition.vcfcpDefinitionId}" \n                             data-vcfcpType="${fieldDefinition.vcfcpType}" >\n                             <table class="confluenceTable">\n                                <thead/>\n                                <tbody id="${this.appTypeHtmlPrefix}-data-attributes-tbody">\n                                </tbody>\n                             </table>\n                        </div>`;\n    }\n    getDataAttributeHtml(dataAttribute, isEditable = false, isDefinition = false, fieldInstance) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const fieldInstanceValueId = fieldInstance ? fieldInstance.valueId : undefined;\n            const escapedAttribute = this.fieldRenderingUtils.htmlEscapeDataAttributes([dataAttribute])[0];\n            const $domObj = $(this.getDataAttributeMetaDataHtml(dataAttribute, escapedAttribute));\n            const dataTypeI18n = yield this.fieldDefinitionService.dataTypeToI18nLabel(escapedAttribute.type);\n            $domObj.append(this.getAttributeLabelTableRowHtml(escapedAttribute.label, dataTypeI18n, isEditable, isDefinition));\n            if (dataAttribute.outdated) {\n                $domObj.find("th").prepend(`<span class="aui-icon aui-icon-small aui-iconfont-cross"></span>`);\n            }\n            const $fieldContent = $domObj.find(`#${this.appTypeHtmlPrefix}-field-content`);\n            dataAttribute = _utils_service__WEBPACK_IMPORTED_MODULE_1__/* .sortDataAttributesByOrderId */ .wO([dataAttribute])[0];\n            switch (dataAttribute.type) {\n                case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.STRING */ .S.STRING:\n                    const tdStringContent = this.getStringAttributeValueTdHtml(dataAttribute, isEditable);\n                    $fieldContent.append(tdStringContent);\n                    break;\n                case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.NUMBER */ .S.NUMBER:\n                    const tdNumberContent = this.getNumberAttributeValueTdHtml(dataAttribute, isEditable);\n                    $fieldContent.append(tdNumberContent);\n                    break;\n                case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.USER */ .S.USER:\n                    const $users = yield this.userMentionService.getUsersDataAttribute(dataAttribute.values || [], isEditable);\n                    $fieldContent.append($users);\n                    break;\n                case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.DROPDOWN */ .S.DROPDOWN:\n                    const $dropdownHtml = this.getDropdownValueHtml(dataAttribute);\n                    $fieldContent.append($dropdownHtml);\n                    break;\n                case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.RADIO */ .S.RADIO:\n                    if (dataAttribute.predefinedValues && dataAttribute.predefinedValues.length > 0) {\n                        const fixedName = this.idService.generateUuid();\n                        $fieldContent.append(`<div class="${this.appTypeHtmlPrefix}-viewer-checkbox-field disabled" id="${this.appTypeHtmlPrefix}-viewer-radio-field"></div>`);\n                        for (const predefinedValue of dataAttribute.predefinedValues) {\n                            if (predefinedValue.outdated) {\n                                $fieldContent.find(`#${this.appTypeHtmlPrefix}-viewer-radio-field`).append(this.getRadioInputHtmlOutdated(fixedName, predefinedValue.value));\n                            }\n                            else {\n                                $fieldContent.find(`#${this.appTypeHtmlPrefix}-viewer-radio-field`).append(this.getRadioInputHtml(fixedName, predefinedValue.value));\n                            }\n                        }\n                    }\n                    if (dataAttribute.values && dataAttribute.values.length > 0) {\n                        const selectedValue = dataAttribute.values[0];\n                        const $radios = $fieldContent.find(":radio");\n                        $radios.each((index, element) => {\n                            if ($(element).val() === selectedValue) {\n                                $(element).prop("checked", true);\n                            }\n                        });\n                    }\n                    break;\n                case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.CHECKBOX */ .S.CHECKBOX:\n                    $fieldContent.append(`<div><form class="${this.appTypeHtmlPrefix}-viewer-checkbox-field disabled"></form></div>`);\n                    if (dataAttribute.predefinedValues && dataAttribute.predefinedValues.length > 0) {\n                        for (const predefinedValue of dataAttribute.predefinedValues) {\n                            if (predefinedValue.outdated) {\n                                $fieldContent.find("form").append(this.getCheckboxInputHtmlOutdated(predefinedValue.value));\n                            }\n                            else {\n                                $fieldContent.find("form").append(this.getCheckboxInputHtml(predefinedValue.value));\n                            }\n                        }\n                    }\n                    if (dataAttribute.values && dataAttribute.values.length > 0) {\n                        const selectedValues = dataAttribute.values;\n                        const $checkboxes = $fieldContent.find("input:checkbox");\n                        $checkboxes.each((index, element) => {\n                            if (selectedValues.includes($(element).val())) {\n                                $(element).prop("checked", true);\n                            }\n                        });\n                    }\n                    break;\n                case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.DATE */ .S.DATE:\n                    let dateContent = "";\n                    if (dataAttribute.values && dataAttribute.values.length > 0) {\n                        dateContent = dataAttribute.values[0];\n                    }\n                    let tdDateContent = "";\n                    if (isEditable) {\n                        tdDateContent = `<input class="aui-date-picker ${this.appTypeHtmlPrefix}-viewer-date-field" type="date" value="${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(dateContent)}" />`;\n                    }\n                    else {\n                        dateContent = this.fieldRenderingUtils.internationalizeDateString(dateContent);\n                        tdDateContent = `<div class="${this.appTypeHtmlPrefix}-viewer-checkbox-field ${this.appTypeHtmlPrefix}-viewer-date-text">${dateContent}</div>`;\n                    }\n                    $fieldContent.append(tdDateContent);\n                    break;\n                case _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.CALCULATION */ .S.CALCULATION:\n                    const noVariablesAssignedText = yield this.platformUtils.getText(`${this.i18nBasePath}.warning.variables-null`);\n                    const tdCalcContent = yield this.fieldRenderingUtils.getCalculationHtml(dataAttribute, fieldInstanceValueId, isEditable, this.fieldInstanceService, this.fieldDefinitionService, this.calculationService, noVariablesAssignedText, fieldInstance);\n                    $fieldContent.append(tdCalcContent);\n            }\n            return $domObj;\n        });\n    }\n    getCheckboxInputHtml(predefinedValue) {\n        predefinedValue = predefinedValue = _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_4__/* .MdfSanitizerService.getSanitizedString */ .O.getSanitizedString(predefinedValue);\n        return `<div class="disabled ${this.appTypeHtmlPrefix}-viewer-checkbox-entry">\n                 <input type="checkbox" style="display: inline; vertical-align: middle" value="${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(predefinedValue)}" disabled>  \n                    ${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(predefinedValue)}</br>\n              </div>`;\n    }\n    getCheckboxInputHtmlOutdated(predefinedValue) {\n        predefinedValue = predefinedValue = _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_4__/* .MdfSanitizerService.getSanitizedString */ .O.getSanitizedString(predefinedValue);\n        return ` <div class="disabled ${this.appTypeHtmlPrefix}-viewer-checkbox-entry">\n                    <span class="aui-icon aui-icon-small aui-iconfont-cross"></span>\n                     <input type="checkbox" style="display: inline; vertical-align: middle" value="${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(predefinedValue)}" disabled>  \n                          <i>${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(predefinedValue)}</i></br>\n                  </div> `;\n    }\n    getRadioInputHtml(fixedName, predefinedValue) {\n        predefinedValue = predefinedValue = _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_4__/* .MdfSanitizerService.getSanitizedString */ .O.getSanitizedString(predefinedValue);\n        return `  <div style="text-align: left;" class="disabled ${this.appTypeHtmlPrefix}-viewer-checkbox-entry">\n                       <input class="radio ${this.appTypeHtmlPrefix}-radio-btn" style="display: inline; vertical-align: middle; margin-top: -2px" type="radio" name="${fixedName}" \n                          value="${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(predefinedValue)}" disabled>\n                        <div style="display: inline;">${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(predefinedValue)}</div>\n               </div>`;\n    }\n    getRadioInputHtmlOutdated(fixedName, predefinedValue) {\n        predefinedValue = predefinedValue = _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_4__/* .MdfSanitizerService.getSanitizedString */ .O.getSanitizedString(predefinedValue);\n        return ` <div style="text-align: left;" class="disabled ${this.appTypeHtmlPrefix}-viewer-checkbox-entry">\n                      <span class="aui-icon aui-icon-small aui-iconfont-cross"></span>\n                       <input class="radio ${this.appTypeHtmlPrefix}-radio-btn" style="display: inline; vertical-align: middle; margin-top: -2px" type="radio" name="${fixedName}" \n                             value="${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(predefinedValue)}" disabled>\n                       <div style="display: inline;"><i>${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(predefinedValue)}</i></div>\n                  </div>`;\n    }\n    getDropdownValueHtml(dataAttribute) {\n        const $dropdownDiv = $(`<div id="${this.appTypeHtmlPrefix}-dropdown"><select class="${this.appTypeHtmlPrefix}-viewer-dropdown disabled"></select></div>`);\n        if (dataAttribute.predefinedValues && dataAttribute.predefinedValues.length > 0) {\n            for (const predefinedValue of dataAttribute.predefinedValues) {\n                predefinedValue.value = _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_4__/* .MdfSanitizerService.getSanitizedString */ .O.getSanitizedString(predefinedValue.value);\n                if (predefinedValue.outdated) {\n                    $dropdownDiv.find("select").append(`\n                                <option value="${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(predefinedValue.value)}" disabled>\n                                    &#10006;<i> ${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(predefinedValue.value)}</i>\n                                </option>`);\n                }\n                else {\n                    $dropdownDiv\n                        .find("select")\n                        .append(`<option value="${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(predefinedValue.value)}" disabled>${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(predefinedValue.value)}</option>`);\n                }\n            }\n            $dropdownDiv.find("select").val("");\n        }\n        if (dataAttribute.values && dataAttribute.values.length > 0) {\n            $dropdownDiv.find("select").val(dataAttribute.values[0]);\n        }\n        return $dropdownDiv;\n    }\n    getStringAttributeValueTdHtml(dataAttribute, isEditable) {\n        let stringContent = "";\n        if (dataAttribute.values && dataAttribute.values.length > 0) {\n            for (const val of dataAttribute.values) {\n                stringContent += val;\n            }\n        }\n        let tdStringContent;\n        if (isEditable) {\n            tdStringContent = `<textarea class="${this.appTypeHtmlPrefix}-viewer-input-field" class="textarea">${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(stringContent)}</textarea>`;\n        }\n        else {\n            tdStringContent = `<div class="${this.appTypeHtmlPrefix}-viewer-checkbox-field ${this.appTypeHtmlPrefix}-viewer-date-text">${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(stringContent)}</div>`;\n        }\n        return tdStringContent;\n    }\n    getNumberAttributeValueTdHtml(dataAttribute, isEditable) {\n        let content = "";\n        if (dataAttribute.values && dataAttribute.values.length > 0) {\n            for (const val of dataAttribute.values) {\n                content += val;\n            }\n        }\n        let tdContent;\n        if (isEditable) {\n            tdContent = `<input class="${this.appTypeHtmlPrefix}-viewer-input-field vcfcp-${_model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.NUMBER */ .S.NUMBER}" value="${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(content)}"/>`;\n        }\n        else {\n            tdContent = `<div class="${this.appTypeHtmlPrefix}-viewer-checkbox-field \n                ${this.appTypeHtmlPrefix}-viewer-date-text">${this.fieldRenderingUtils.htmlEscapeSpecialCharacters(content)}</div>`;\n        }\n        return tdContent;\n    }\n    getAttributeLabelTableRowHtml(label, attributeType, isEditable, isDefinition = false) {\n        let attributeTypeHtml = "";\n        if (isEditable || isDefinition) {\n            attributeTypeHtml = `<div class="${this.appTypeHtmlPrefix}-attribute-data-type vcfcp-description">${attributeType}</div>`;\n        }\n        return `<th class="confluenceTh ${this.appTypeHtmlPrefix}-attribute-label-col" style="min-width: 70px; word-wrap: break-word; vertical-align: middle; text-align: center; display: table-cell;">\n                    <div>${label}</div>\n                    ${attributeTypeHtml}\n                </th>\n                <td class="confluenceTd ${this.appTypeHtmlPrefix}-attribute-content-col" style="align-content: center; vertical-align: middle;" id="${this.appTypeHtmlPrefix}-field-content"></td>`;\n    }\n    getDataAttributeMetaDataHtml(dataAttribute, escapedAttribute) {\n        return `<tr class="${this.appTypeHtmlPrefix}-viewer-field-attribute"\n                  data-attribute-id="${dataAttribute.vcfcpAttributeId}"\n                  data-attribute-type="${dataAttribute.type}"\n                  data-attribute-label="${escapedAttribute.label}"\n                  data-attribute-description="${escapedAttribute.description}"></tr>`;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/services/field-rendering/field-rendering-core.service.ts?')},"../../../../../../MDF-core/core-js/app/services/field-rendering/field-rendering-utils.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "t": () => (/* binding */ FieldRenderingUtilsService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/attribute-type.enum.ts");\n/* harmony import */ var _encoding_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../MDF-core/core-js/app/services/encoding.service.ts");\n/* harmony import */ var _model_enum_calculation_validation_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/calculation-validation.enum.ts");\n/* harmony import */ var _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../MDF-core/core-js/app/services/mdf-sanitizer.service.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nclass FieldRenderingUtilsService {\n    htmlEscapeDataAttributes(dataAttributes) {\n        const escapedAttributes = [];\n        for (const attribute of dataAttributes) {\n            escapedAttributes.push({\n                description: this.htmlEscapeSpecialCharacters(attribute.description),\n                label: this.htmlEscapeSpecialCharacters(attribute.label),\n                orderIndex: attribute.orderIndex,\n                outdated: attribute.outdated,\n                predefinedValues: this.escapePredefinedValues(attribute.predefinedValues),\n                type: attribute.type,\n                values: [],\n                vcfcpAttributeId: attribute.vcfcpAttributeId,\n            });\n        }\n        return escapedAttributes;\n    }\n    escapePredefinedValues(predefinedValues) {\n        const escapedPredefinedValues = [];\n        if (!predefinedValues) {\n            return escapedPredefinedValues;\n        }\n        for (const predefValue of predefinedValues) {\n            escapedPredefinedValues.push({\n                type: predefValue.type,\n                outdated: predefValue.outdated,\n                value: this.htmlEscapeSpecialCharacters(predefValue.value),\n                orderIndex: predefValue.orderIndex,\n            });\n        }\n        return escapedPredefinedValues;\n    }\n    htmlEscapeSpecialCharacters(str) {\n        if (!str) {\n            return "";\n        }\n        const map = {\n            "&amp;": "&",\n            "&lt;": "<",\n            "&gt;": ">",\n            "&quot;": \'"\',\n            "&#039;": "\'",\n            "&#96;": "`",\n            "&#o;": "ô",\n            "&#O;": "Ô",\n            "&#i;": "í",\n        };\n        const keys = [];\n        for (const key in map) {\n            if (map.hasOwnProperty(key)) {\n                keys.push(key);\n            }\n        }\n        const regex = new RegExp(keys.join("|"), "g");\n        const unescapedString = str.replace(regex, (m) => {\n            return map[m];\n        });\n        return unescapedString;\n    }\n    htmlUnescapeSpecialCharacters(str) {\n        if (!str) {\n            return "";\n        }\n        const map = {\n            "&amp;": "&",\n            "&lt;": "<",\n            "&gt;": ">",\n            "&quot;": \'"\',\n            "&#039;": "\'",\n            "&#96;": "`",\n            "&#o;": "ô",\n            "&#O;": "Ô",\n            "&#i;": "í",\n        };\n        const keys = [];\n        for (const key in map) {\n            if (map.hasOwnProperty(key)) {\n                keys.push(key);\n            }\n        }\n        const regex = new RegExp(keys.join("|"), "g");\n        const unescapedString = str.replace(regex, (m) => {\n            return map[m];\n        });\n        return unescapedString;\n    }\n    internationalizeDateString(dateString) {\n        if (AJS.Meta.get("user-locale") === "de_DE") {\n            try {\n                const date = new Date(dateString);\n                const dateTimeFormat = new Intl.DateTimeFormat("de", {\n                    year: "numeric",\n                    month: "2-digit",\n                    day: "2-digit",\n                });\n                const [{ value: day }, , { value: month }, , { value: year }] = dateTimeFormat.formatToParts(date);\n                return `${day}.${month}.${year}`;\n            }\n            catch (e) {\n                return dateString;\n            }\n        }\n        else {\n            return dateString;\n        }\n    }\n    getCalculationHtml(dataAttribute, fieldInstanceValueId, isEditable, fieldInstanceService, fieldDefinitionService, calculationService, noVariablesAssignedText, unsavedFieldInstance) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let mathExpressionLabels = "";\n            let mathExpressionValues = "";\n            let mathExpData = "";\n            let nullValuesCounter = 0;\n            const mathValuesMap = new Map();\n            const fieldInstance = unsavedFieldInstance ? unsavedFieldInstance : fieldInstanceValueId ? yield fieldInstanceService.getFieldInstanceVersionByValueId(fieldInstanceValueId) : undefined;\n            if (fieldInstance) {\n                const dataAttributesOfFieldInstance = JSON.parse(fieldInstance.value).dataAttributes;\n                for (let i = 0; i < dataAttributesOfFieldInstance.length; i++) {\n                    if (dataAttributesOfFieldInstance[i].type === _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AttributeTypeEnum.NUMBER */ .S.NUMBER) {\n                        if (dataAttributesOfFieldInstance[i].vcfcpAttributeId && dataAttributesOfFieldInstance[i].values[0]) {\n                            mathValuesMap.set(dataAttributesOfFieldInstance[i].vcfcpAttributeId, dataAttributesOfFieldInstance[i].values[0]);\n                        }\n                    }\n                }\n            }\n            else {\n            }\n            if (dataAttribute.predefinedValues !== undefined && dataAttribute.predefinedValues[0] !== undefined) {\n                mathExpData = `data-math-expression="${(0,_encoding_service__WEBPACK_IMPORTED_MODULE_1__/* .customStringEncoding */ .d)("encode", dataAttribute.predefinedValues[0].value)}"`;\n                const mathExpressionWithIds = dataAttribute.predefinedValues[0].value;\n                let char;\n                for (let i = 0; i < mathExpressionWithIds.length; i++) {\n                    char = mathExpressionWithIds.charAt(i);\n                    if (char === ";") {\n                        i++;\n                        char = mathExpressionWithIds.charAt(i);\n                        let id = "";\n                        while (char !== ";") {\n                            id = id.concat(char);\n                            i++;\n                            char = mathExpressionWithIds.charAt(i);\n                        }\n                        const dataAttributeForArgument = yield fieldDefinitionService.getDataAttributeById(id);\n                        mathExpressionLabels = mathExpressionLabels.concat(dataAttributeForArgument.label);\n                        const value = mathValuesMap.get(id);\n                        if (!value) {\n                            nullValuesCounter++;\n                        }\n                        else if (!(value.length > 0)) {\n                            nullValuesCounter++;\n                        }\n                        else {\n                            mathExpressionValues = mathExpressionValues.concat(value);\n                        }\n                    }\n                    else {\n                        mathExpressionValues = mathExpressionValues.concat(char);\n                        mathExpressionLabels = mathExpressionLabels.concat(char);\n                    }\n                }\n            }\n            else {\n            }\n            const mathResult = calculationService.evaluateMathExpression(mathExpressionValues);\n            let tdCalcContent = "";\n            if (fieldInstance && mathResult.validation !== _model_enum_calculation_validation_enum__WEBPACK_IMPORTED_MODULE_2__/* .CalculationValidationEnum.INVALID */ .H.INVALID && !isEditable && nullValuesCounter === 0) {\n                tdCalcContent = `<div class="math-expression math-result" ${mathExpData}>${_mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_3__/* .MdfSanitizerService.getSanitizedString */ .O.getSanitizedString(mathResult.calculationResult)}</div>`;\n            }\n            else if (nullValuesCounter > 0 && fieldInstance) {\n                tdCalcContent = `<div class="math-expression math-formula-invalid" ${mathExpData}>${_mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_3__/* .MdfSanitizerService.getSanitizedString */ .O.getSanitizedString(mathExpressionLabels)}</div>\n                                     <span class="aui-icon aui-icon-small aui-iconfont-cross"></span>\n                                     <i>${noVariablesAssignedText}</i>`;\n            }\n            else {\n                tdCalcContent = `<div class="math-expression math-formula" ${mathExpData}>${_mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_3__/* .MdfSanitizerService.getSanitizedString */ .O.getSanitizedString(mathExpressionLabels)}</div>`;\n            }\n            return tdCalcContent;\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/services/field-rendering/field-rendering-utils.service.ts?')},"../../../../../../MDF-core/core-js/app/services/id.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "K": () => (/* binding */ IdService)\n/* harmony export */ });\nif ("bpmnEntPlatformMDF" == __webpack_require__.j) {\n\t/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../MDF-core/core-js/node_modules/uuid/dist/esm-browser/v4.js");\n}\n/* harmony import */ var _model_enum_vcfcp_id_prefix_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/vcfcp-id-prefix.enum.ts");\n\n\nconst sha256 = __webpack_require__("../../../../../../MDF-core/core-js/node_modules/hash.js/lib/hash/sha/256.js");\nclass IdService {\n    generateUuid(prefix) {\n        const uuid = (0,uuid__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)();\n        if (prefix) {\n            return prefix.concat(uuid);\n        }\n        return uuid;\n    }\n    generateValueId(valueString, instanceId) {\n        const hash = sha256().update(instanceId.concat(valueString)).digest("hex");\n        return _model_enum_vcfcp_id_prefix_enum__WEBPACK_IMPORTED_MODULE_0__/* .VcfcpIdPrefixEnum.vcfcpValueId.concat */ .d.vcfcpValueId.concat(hash);\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/services/id.service.ts?')},"../../../../../../MDF-core/core-js/app/services/mdf-sanitizer.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "O": () => (/* binding */ MdfSanitizerService)\n/* harmony export */ });\n/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../MDF-core/core-js/node_modules/dompurify/dist/purify.js");\n/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(dompurify__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _braintree_sanitize_url__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../MDF-core/core-js/node_modules/@braintree/sanitize-url/dist/index.js");\n\n\nclass MdfSanitizerService {\n    constructor() {\n    }\n    static sanitizeUrl(url) {\n        return (0,_braintree_sanitize_url__WEBPACK_IMPORTED_MODULE_1__/* .sanitizeUrl */ .N)(url);\n    }\n    static sanitize(input, configureOption) {\n        return dompurify__WEBPACK_IMPORTED_MODULE_0___default().sanitize(input, configureOption);\n    }\n    getSanitizedString(input, configureOption = { USE_PROFILES: { html: false } }) {\n        return MdfSanitizerService.sanitize(input, configureOption).toString();\n    }\n    static getSanitizedString(input, configureOption = { USE_PROFILES: { html: false } }) {\n        const sanitizedString = MdfSanitizerService.sanitize(input, configureOption).toString();\n        if (sanitizedString === "undefined" || sanitizedString.length === 0) {\n            return "";\n        }\n        return sanitizedString;\n    }\n    static sanitizeFieldInstances(fieldInstances) {\n        if (fieldInstances.length === 0) {\n            return [];\n        }\n        return fieldInstances.map(fieldInstance => MdfSanitizerService.sanitizeFieldInstance(fieldInstance));\n    }\n    static sanitizeFieldInstance(fieldInstance) {\n        fieldInstance.value = MdfSanitizerService.getSanitizedString(fieldInstance.value);\n        fieldInstance.definitionName = fieldInstance.definitionName ? MdfSanitizerService.getSanitizedString(fieldInstance.definitionName) : undefined;\n        fieldInstance.bpmnDiagramName = fieldInstance.bpmnDiagramName ? MdfSanitizerService.getSanitizedString(fieldInstance.bpmnDiagramName) : undefined;\n        fieldInstance.bpmnActivityName = fieldInstance.bpmnActivityName ? MdfSanitizerService.getSanitizedString(fieldInstance.bpmnActivityName) : undefined;\n        return fieldInstance;\n    }\n    static sanitizeFieldInstanceValueObj(valueObj) {\n        valueObj.dataAttributes = valueObj.dataAttributes.map(dataAttribute => MdfSanitizerService.sanitizeDataAttribute(dataAttribute));\n        return valueObj;\n    }\n    static sanitizeFieldDefinition(fieldDefinition) {\n        fieldDefinition.name = MdfSanitizerService.getSanitizedString(fieldDefinition.name);\n        fieldDefinition.description = fieldDefinition.description ? MdfSanitizerService.getSanitizedString(fieldDefinition.description) : "";\n        if (fieldDefinition.dataAttributes && fieldDefinition.dataAttributes.length > 0) {\n            fieldDefinition.dataAttributes = fieldDefinition.dataAttributes.map((dataAttribute) => MdfSanitizerService.sanitizeDataAttribute(dataAttribute));\n        }\n        return fieldDefinition;\n    }\n    static sanitizeDataAttribute(dataAttribute) {\n        dataAttribute.label = MdfSanitizerService.getSanitizedString(dataAttribute.label);\n        dataAttribute.description = dataAttribute.description ? MdfSanitizerService.getSanitizedString(dataAttribute.description) : "";\n        if (dataAttribute.predefinedValues && dataAttribute.predefinedValues.length > 0) {\n            dataAttribute.predefinedValues = dataAttribute.predefinedValues.map((predefinedValue) => MdfSanitizerService.sanitizePredefinedValue(predefinedValue));\n        }\n        if (typeof (dataAttribute.values) === "object") {\n            dataAttribute.values = dataAttribute.values.map((value) => MdfSanitizerService.getSanitizedString(value));\n        }\n        return dataAttribute;\n    }\n    static sanitizePredefinedValue(predefinedValue) {\n        predefinedValue.value = MdfSanitizerService.getSanitizedString(predefinedValue.value);\n        return predefinedValue;\n    }\n    static sanitizeFieldQuery(query) {\n        query.dataAttributes = query.dataAttributes.map(dataAttribute => MdfSanitizerService.sanitizeDataAttribute(dataAttribute));\n        query.vcfcpDefinitionName = query.vcfcpDefinitionName ? MdfSanitizerService.getSanitizedString(query.vcfcpDefinitionName) : undefined;\n        if (query.displaySettings && query.displaySettings.excludedTableColumns.length > 0) {\n            query.displaySettings.excludedTableColumns = query.displaySettings.excludedTableColumns.map(column => MdfSanitizerService.getSanitizedString(column));\n        }\n        return query;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/services/mdf-sanitizer.service.ts?')},"../../../../../../MDF-core/core-js/app/services/user-mention.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "V": () => (/* binding */ UserMentionService)\n/* harmony export */ });\n/* harmony import */ var lodash_debounce__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../node_modules/lodash/debounce.js");\n/* harmony import */ var lodash_debounce__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_debounce__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _utils_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../MDF-core/core-js/app/services/utils.service.ts");\n/* harmony import */ var _model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/app-type-html-prefix.enum.ts");\nif ("bpmnEntPlatformMDF" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../MDF-core/core-js/app/services/mdf-sanitizer.service.ts");\n/* harmony import */ var _vXCP_enterprise_core_core_js_app_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts");\n/* harmony import */ var _model_enum_mdf_template_names_enum__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/mdf-template-names.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\nclass UserMentionService {\n    constructor(platformUtils, appType) {\n        this.platformUtils = platformUtils;\n        this.appType = appType;\n        this.baseURL = this.platformUtils.buildConfluenceBaseUrl();\n        this.templateNames = {\n            userMentionDisplay: _model_enum_mdf_template_names_enum__WEBPACK_IMPORTED_MODULE_5__/* .MdfTemplateNamesEnum.MDF_USER_MENTION_DISPLAY */ .c.MDF_USER_MENTION_DISPLAY,\n            confluenceLabel: _model_enum_mdf_template_names_enum__WEBPACK_IMPORTED_MODULE_5__/* .MdfTemplateNamesEnum.MDF_CONFLUENCE_LABEL */ .c.MDF_CONFLUENCE_LABEL,\n        };\n        this.pluginName = _utils_service__WEBPACK_IMPORTED_MODULE_1__/* .initPluginName */ .lM(appType);\n        this.initTemplateNames();\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z(this.pluginName, "UserMentionService");\n    }\n    initTemplateNames() {\n        switch (this.appType) {\n            case _model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_2__/* .AppTypeHtmlPrefixEnum.MDF */ .U.MDF:\n                this.templateNames = {\n                    userMentionDisplay: _vXCP_enterprise_core_core_js_app_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_4__/* .TemplateNamesEnum.USER_MENTION_DISPLAY */ .X.USER_MENTION_DISPLAY,\n                    confluenceLabel: _vXCP_enterprise_core_core_js_app_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_4__/* .TemplateNamesEnum.CONFLUENCE_LABEL */ .X.CONFLUENCE_LABEL,\n                };\n                break;\n            default:\n                this.templateNames = {\n                    userMentionDisplay: _model_enum_mdf_template_names_enum__WEBPACK_IMPORTED_MODULE_5__/* .MdfTemplateNamesEnum.MDF_USER_MENTION_DISPLAY */ .c.MDF_USER_MENTION_DISPLAY,\n                    confluenceLabel: _model_enum_mdf_template_names_enum__WEBPACK_IMPORTED_MODULE_5__/* .MdfTemplateNamesEnum.MDF_CONFLUENCE_LABEL */ .c.MDF_CONFLUENCE_LABEL,\n                };\n        }\n    }\n    getUsersDataAttribute(userIDs, isEditable = false) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $userMentionDisplay = $(yield this.platformUtils.getTemplate(this.templateNames.userMentionDisplay, { isEditable }));\n            const $userList = $userMentionDisplay.find(`.${this.appType}-users`);\n            yield _utils_service__WEBPACK_IMPORTED_MODULE_1__/* .asyncForEach */ .ML(userIDs, (userKey) => __awaiter(this, void 0, void 0, function* () {\n                const $user = yield this.getUserListEntry(userKey, isEditable);\n                $userList.append($user);\n            }));\n            if (isEditable) {\n                const $userInput = $userMentionDisplay.find(`.${this.appType}-viewer-username-input-field`);\n                this.initInputListener($userInput);\n            }\n            else {\n                if (!userIDs.length) {\n                    $userMentionDisplay.find(`.${this.appType}-user-mention-input-box-non-editable`).show();\n                }\n            }\n            return $userMentionDisplay;\n        });\n    }\n    getUserListEntry(userKey, isEditable = false) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const labelHTML = yield this.platformUtils.getTemplate(this.templateNames.confluenceLabel);\n            const $label = $(labelHTML);\n            const $li = $("<li></li>");\n            $li.append($label);\n            this.fillLabelWithSpinner($label, userKey, isEditable);\n            return $li;\n        });\n    }\n    initInputListener($input) {\n        const searchThrottle = 300;\n        $input.on("input", lodash_debounce__WEBPACK_IMPORTED_MODULE_0___default()((event) => __awaiter(this, void 0, void 0, function* () {\n            yield this.handleInput(event, $input);\n        }), searchThrottle));\n    }\n    handleInput(event, $inputElement) {\n        return __awaiter(this, void 0, void 0, function* () {\n            event.preventDefault();\n            const $userList = $inputElement.parent().find(`.${this.appType}-users-results-list`);\n            const $dropdown = $inputElement.parent().find(`.${this.appType}-user-dropdown`);\n            if ($inputElement.val() !== "") {\n                $dropdown.show();\n            }\n            else {\n                $dropdown.hide();\n            }\n            yield this.fillUserDropdown($userList, $inputElement.val());\n        });\n    }\n    fillUserDropdown($DropdownUserList, inputString) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const timeout = 200;\n            $DropdownUserList.children().remove();\n            const labelHTML = yield this.platformUtils.getTemplate(this.templateNames.confluenceLabel);\n            const $addedUserList = $DropdownUserList.parents(`.${this.appType}-user-mention-display`).find(`.${this.appType}-users`);\n            const $userInput = $DropdownUserList.parents(`.${this.appType}-user-mention-display`).find("input");\n            const userData = yield this.getUsersBySearchString(inputString);\n            if (!userData.length) {\n                $DropdownUserList.append(`<li class="${this.appType}-user-dropdown-entry">${yield this.platformUtils.getText("de.viadee.confluence.managed-data-fields.attribute-type.user.input.dropdown.empty.result")}</li>`);\n                return;\n            }\n            userData.forEach((user) => {\n                const imageHTML = "";\n                const $userHTML = $(`<li class="${this.appType}-user-dropdown-entry">\n                                  <a href="" data-vcfcp-confluence-user-id = "${user.userKey}">${imageHTML}   ${user.displayName}</a>\n                                </li>`);\n                $userHTML.on("click", (clickEvent) => __awaiter(this, void 0, void 0, function* () {\n                    clickEvent.preventDefault();\n                    const $li = $("<li></li>");\n                    const $label = $(labelHTML);\n                    this.fillLabelWithUser($label, user, true);\n                    const $closer = $label.find(`.${this.appType}-confluence-label-close`);\n                    $closer.on("click", (closerClickEvent) => {\n                        closerClickEvent.preventDefault();\n                        const $currentCloser = $(closerClickEvent.currentTarget);\n                        setTimeout(() => {\n                            $currentCloser.parent().remove();\n                        }, 50);\n                    });\n                    $li.append($label);\n                    $addedUserList.append($li);\n                    setTimeout(() => {\n                        $DropdownUserList.parent().hide();\n                        $userInput.val("");\n                        $DropdownUserList.children().remove();\n                    }, timeout);\n                }));\n                $DropdownUserList.append($userHTML);\n            });\n            const $options = $DropdownUserList.find("li");\n            $options.on("hover", (hoverEvent) => {\n                const hoveredOption = hoverEvent.currentTarget;\n                hoveredOption.classList.add("active");\n                $options.not(hoveredOption).removeClass("active");\n            });\n        });\n    }\n    fillLabelWithUser($label, user, closable) {\n        $label.find(`.${this.appType}-confluence-user`).attr("data-vcfcp-confluence-user-id", user.userKey);\n        if (closable) {\n            $label.find(`.${this.appType}-confluence-label-close`).show();\n        }\n        else {\n            $label.find(`.${this.appType}-confluence-label-close`).hide();\n        }\n        const $userLink = $label.find(`.${this.appType}-confluence-user`);\n        const userProfileURL = encodeURI(`${this.baseURL}/display/~${user.username}`);\n        $userLink.attr("href", userProfileURL);\n        $userLink.text(user.displayName);\n    }\n    fillLabelWithSpinner($label, userKey, closable) {\n        $label.find(`.${this.appType}-confluence-user`).attr("data-vcfcp-confluence-user-id", userKey);\n        if (closable) {\n            $label.find(`.${this.appType}-confluence-label-close`).show();\n            const $closer = $label.find(`.${this.appType}-confluence-label-close`);\n            $closer.on("click", (clickEvent) => {\n                clickEvent.preventDefault();\n                const $currentCloser = $(clickEvent.currentTarget);\n                setTimeout(() => {\n                    $currentCloser.parent().remove();\n                }, 200);\n            });\n        }\n        else {\n            $label.removeClass("aui-label-closeable");\n            $label.find(`.${this.appType}-confluence-label-close`).remove();\n        }\n        const spinnerHTML = `<aui-spinner size="small"></aui-spinner>`;\n        $label.find(`.${this.appType}-confluence-user`).append(spinnerHTML);\n    }\n    fillUserPlaceholders() {\n        const labels = $(`.${this.appType}-confluence-label`)\n            .toArray()\n            .map((label) => $(label));\n        labels.forEach(($label) => __awaiter(this, void 0, void 0, function* () {\n            const userKey = $label.find(`.${this.appType}-confluence-user`).attr("data-vcfcp-confluence-user-id") || "";\n            if (userKey.length) {\n                try {\n                    const user = yield this.getUserById(userKey);\n                    if (user.username === user.userKey) {\n                        user.displayName = yield this.platformUtils.getText("de.viadee.confluence.managed-data-fields.attribute-type.user.deleted");\n                    }\n                    user.displayName = _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_3__/* .MdfSanitizerService.getSanitizedString */ .O.getSanitizedString(user.displayName);\n                    user.username = _mdf_sanitizer_service__WEBPACK_IMPORTED_MODULE_3__/* .MdfSanitizerService.getSanitizedString */ .O.getSanitizedString(user.username);\n                    $label.find("aui-spinner").remove();\n                    this.fillLabelWithUser($label, user, true);\n                }\n                catch (e) {\n                    this.vxcpLogger.logError("fillUserPlaceholders", "Failed to request information on user ", {\n                        userkey: userKey,\n                        error: e,\n                    });\n                }\n            }\n        }));\n    }\n    getUsersBySearchString(userName) {\n        return __awaiter(this, void 0, void 0, function* () {\n            userName = userName.replace(/^@/, "");\n            userName = userName.toLowerCase();\n            if (!userName) {\n                return [];\n            }\n            const cqlString = `user~"${userName}"&start=0&limit=100`;\n            const restPartURL = `/rest/api/search?cql=${cqlString}`;\n            const searchURL = this.platformUtils.buildRestUrl(restPartURL);\n            const requestOpts = {\n                type: "GET",\n                url: searchURL,\n                dataType: "json",\n            };\n            let users = [];\n            try {\n                const searchRequest = yield this.platformUtils.makeRequest(requestOpts);\n                users = searchRequest.results.map((res) => res.user);\n            }\n            catch (error) {\n                this.vxcpLogger.logError("getUsersBySearchString", "Search request failed", error);\n            }\n            return users;\n        });\n    }\n    getUserById(userID) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const restPartURL = `/rest/api/user?key=${userID}`;\n            const fullURL = this.platformUtils.buildRestUrl(encodeURI(restPartURL));\n            const requestOpts = {\n                type: "GET",\n                url: fullURL,\n                dataType: "json",\n            };\n            try {\n                const requestRes = yield this.platformUtils.makeRequest(requestOpts);\n                return requestRes;\n            }\n            catch (error) {\n                if (error.status === 403) {\n                    this.vxcpLogger.logInfo("getUserById", "Error occurred getting user. Are you logged in?", {\n                        userID,\n                        error,\n                    });\n                    return {\n                        username: "notAllowed",\n                        userKey: userID,\n                        displayName: this.platformUtils.getText("de.viadee.confluence.managed-data-fields.attribute-type.user.unknown"),\n                    };\n                }\n                else {\n                    this.vxcpLogger.logError("getUserById", "Error occurred getting user.", { userID, error });\n                    return {\n                        username: "error",\n                        userKey: userID,\n                        displayName: this.platformUtils.getText("de.viadee.confluence.managed-data-fields.attribute-type.user.unknown"),\n                    };\n                }\n            }\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/services/user-mention.service.ts?')},"../../../../../../MDF-core/core-js/app/services/utils.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "ML": () => (/* binding */ asyncForEach),\n/* harmony export */   "lM": () => (/* binding */ initPluginName),\n/* harmony export */   "wO": () => (/* binding */ sortDataAttributesByOrderId)\n/* harmony export */ });\n/* unused harmony exports getMacroParamsFromMacroNode, bindToRte, wait, awaitI18NResources, forDataAttributeTypeGetFieldDefinitionType, forFieldDefTypeGetAttributeType, forDataAttributeTypeGetPredefinedValueType */\n/* harmony import */ var _model_enum_field_definition_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/field-definition-type.enum.ts");\n/* harmony import */ var _model_enum_attribute_type_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/attribute-type.enum.ts");\n/* harmony import */ var _model_enum_predefined_value_type_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/predefined-value-type.enum.ts");\n/* harmony import */ var _model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/app-type-html-prefix.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nfunction getMacroParamsFromMacroNode($node) {\n    const paramsAsString = $node.attr("data-macro-parameters");\n    const params = paramsAsString.split("|");\n    const paramsObj = {};\n    params.forEach((element) => {\n        const paramName = element.split("=")[0];\n        paramsObj[paramName] = element.split("=")[1];\n    });\n    return paramsObj;\n}\nconst asyncForEach = (array, callback) => __awaiter(void 0, void 0, void 0, function* () {\n    for (let idx = 0; idx < array.length; idx++) {\n        yield callback(array[idx], idx, array);\n    }\n});\nfunction bindToRte() {\n    return __awaiter(this, void 0, void 0, function* () {\n        return new Promise((resolve) => {\n            AJS.bind("init.rte", () => {\n                AJS.I18n.get("de.viadee.confluence.managed-data-fields", resolve);\n            });\n        });\n    });\n}\nconst wait = (element, ms) => {\n    return new Promise((resolve, reject) => {\n        const waitForEl = (selector, tries, count = 0) => {\n            const el = $(selector);\n            if (el.length > 0) {\n                resolve(true);\n            }\n            else {\n                setTimeout(() => {\n                    count++;\n                    if (count < tries) {\n                        waitForEl(selector, tries--, count);\n                    }\n                    else {\n                        resolve(false);\n                    }\n                }, 100);\n            }\n        };\n        const maxTries = ms / 100;\n        waitForEl(element, maxTries);\n    });\n};\nfunction awaitI18NResources() {\n    return new Promise((resolve) => {\n        AJS.toInit(() => {\n            AJS.I18n.get("de.viadee.confluence.managed-data-fields", resolve);\n        });\n    });\n}\nfunction forDataAttributeTypeGetFieldDefinitionType(dataAttributeType) {\n    switch (dataAttributeType) {\n        case AttributeTypeEnum.STRING:\n            return FieldDefinitionTypeEnum.STRING;\n        case AttributeTypeEnum.NUMBER:\n            return FieldDefinitionTypeEnum.NUMBER;\n        case AttributeTypeEnum.USER:\n            return FieldDefinitionTypeEnum.USER;\n        case AttributeTypeEnum.DATE:\n            return FieldDefinitionTypeEnum.DATE;\n        case AttributeTypeEnum.DROPDOWN:\n            return FieldDefinitionTypeEnum.DROPDOWN;\n        case AttributeTypeEnum.CHECKBOX:\n            return FieldDefinitionTypeEnum.CHECKBOX;\n        case AttributeTypeEnum.RADIO:\n            return FieldDefinitionTypeEnum.RADIO;\n        case AttributeTypeEnum.CALCULATION:\n            return FieldDefinitionTypeEnum.CALCULATION;\n    }\n}\nfunction forFieldDefTypeGetAttributeType(fieldTypeEnum) {\n    switch (fieldTypeEnum) {\n        case FieldDefinitionTypeEnum.DROPDOWN:\n            return AttributeTypeEnum.DROPDOWN;\n        case FieldDefinitionTypeEnum.RADIO:\n            return AttributeTypeEnum.RADIO;\n        case FieldDefinitionTypeEnum.STRING:\n            return AttributeTypeEnum.STRING;\n        case FieldDefinitionTypeEnum.DATE:\n            return AttributeTypeEnum.DATE;\n        case FieldDefinitionTypeEnum.CHECKBOX:\n            return AttributeTypeEnum.CHECKBOX;\n        case FieldDefinitionTypeEnum.USER:\n            return AttributeTypeEnum.USER;\n        case FieldDefinitionTypeEnum.NUMBER:\n            return AttributeTypeEnum.NUMBER;\n        case FieldDefinitionTypeEnum.CALCULATION:\n            return AttributeTypeEnum.CALCULATION;\n        case FieldDefinitionTypeEnum.COMPLEX:\n            throw Error("vcfcpCOMPLEX Field does not have a corresponding native data attribute type.");\n    }\n}\nfunction forDataAttributeTypeGetPredefinedValueType(attributeTypeEnum) {\n    switch (attributeTypeEnum) {\n        case AttributeTypeEnum.RADIO:\n            return PredefinedValueTypeEnum.RADIO_OPTION;\n        case AttributeTypeEnum.DROPDOWN:\n            return PredefinedValueTypeEnum.DROPDOWN_OPTION;\n        case AttributeTypeEnum.CHECKBOX:\n            return PredefinedValueTypeEnum.CHECKBOX_OPTION;\n        default:\n            throw Error("Utils.forDataAttributeTypeGetPredefinedValueType(): For the given AttributeType there does not exist a predefined value type");\n    }\n}\nfunction sortDataAttributesByOrderId(dataAttributes) {\n    var _a;\n    for (const attribute of dataAttributes) {\n        if (attribute.predefinedValues && attribute.predefinedValues.length > 0) {\n            (_a = attribute.predefinedValues) === null || _a === void 0 ? void 0 : _a.sort((a, b) => {\n                return a.orderIndex - b.orderIndex;\n            });\n        }\n    }\n    dataAttributes.sort((a, b) => {\n        return a.orderIndex - b.orderIndex;\n    });\n    return dataAttributes;\n}\nfunction initPluginName(appType) {\n    switch (appType) {\n        case _model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_3__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT:\n            return "BPMN MODELER ENTERPRISE";\n        case _model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_3__/* .AppTypeHtmlPrefixEnum.MDF */ .U.MDF:\n            return "MANAGED DATA FIELDS";\n        case _model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_3__/* .AppTypeHtmlPrefixEnum.DMN_ENT */ .U.DMN_ENT:\n            return "DMN MODELER ENTERPRISE";\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../MDF-core/core-js/app/services/utils.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/admin/ao-diagram-links.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "m": () => (/* binding */ AoDiagramLinksService)\n/* harmony export */ });\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/warning-dialog-type.enum.ts");\n/* harmony import */ var _model_enum_rest_type_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/rest-type.enum.ts");\nif ("bpmnEntAdmin" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _utils_spinner_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/spinner.service.ts");\nif ("bpmnEntAdmin" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\nclass AoDiagramLinksService {\n    constructor(languageRestService, pluginService, messageService) {\n        this.languageRestService = languageRestService;\n        this.pluginService = pluginService;\n        this.messageService = messageService;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_4__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.$deleteAllLinksBtn = $("#vxcp-ent-delete-all-diagram-links-btn");\n        this.$syncAllLinksBtn = $("#vxcp-ent-sync-all-diagram-links-btn");\n        this.pluginShorthand = this.pluginService.getPluginShorthand();\n        this.spinnerService = new _utils_spinner_service__WEBPACK_IMPORTED_MODULE_3__/* .SpinnerService */ .V("diagram-links");\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z(this.pluginService.getPluginName(), "AoDiagramLinksService");\n    }\n    initAllDiagramLinksAction() {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.initDeleteAllDiagramLinks();\n            yield this.initSyncAllDiagramLinks();\n        });\n    }\n    isCloudApp() {\n        return this.platformUtils.isCloudApp();\n    }\n    initDeleteAllDiagramLinks() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.isCloudApp()) {\n                return;\n            }\n            this.$deleteAllLinksBtn.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                if (this.$deleteAllLinksBtn.hasClass("loading")) {\n                    return;\n                }\n                const backupInfo = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.warning-dialog.delete-all-diagram-links.backup-info");\n                const $additionalContent = $("<div>").addClass("aui-message aui-message-error");\n                $("<h4>").text(backupInfo).appendTo($additionalContent);\n                if (yield (0,_utils_utils__WEBPACK_IMPORTED_MODULE_0__.confirmWarningDialog)(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .WarningDialogTypeEnum.DELETE_ALL_LINKS */ .K.DELETE_ALL_LINKS, $additionalContent)) {\n                    this.toggleSpinner(true);\n                    const appPathComponent = this.languageRestService.getPluginRestComponent();\n                    const restUrl = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/diagramLinks`);\n                    const result = yield this.platformUtils.makeRequest({\n                        url: restUrl,\n                        type: _model_enum_rest_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .RestTypeEnum.DELETE */ .T.DELETE,\n                    });\n                    this.toggleSpinner(false);\n                    if (result === "true") {\n                        const title = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.delete-diagram-links.success.title");\n                        const body = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.delete-diagram-links.success.body");\n                        this.messageService.setSuccessMessage(title, body, { fadeOut: true, delay: 6000 });\n                    }\n                    else {\n                        const title = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.delete-diagram-links.error.title");\n                        const body = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.delete-diagram-links.error.body");\n                        this.messageService.setWarningMessage(title, body, { fadeOut: true, delay: 6000 });\n                    }\n                }\n                else {\n                    this.toggleSpinner(false);\n                }\n            }));\n        });\n    }\n    initSyncAllDiagramLinks() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.isCloudApp()) {\n                return;\n            }\n            this.$syncAllLinksBtn.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                if (this.$syncAllLinksBtn.hasClass("loading")) {\n                    return;\n                }\n                const additionalDesc = yield this.platformUtils.getText(`de.viadee.confluence.viadee-plugin-enterprise.warning-dialog.sync-all-diagram-links.additional-desc`, this.pluginShorthand);\n                const backupInfo = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.warning-dialog.sync-all-diagram-links.backup-info");\n                const $additionalDesc = $("<p>").text(additionalDesc);\n                const $additionalContentBackupInfo = $("<div>").addClass("aui-message aui-message-error");\n                $("<h4>").text(backupInfo).appendTo($additionalContentBackupInfo);\n                const $additionalContent = $additionalDesc.add($additionalContentBackupInfo);\n                if (yield (0,_utils_utils__WEBPACK_IMPORTED_MODULE_0__.confirmWarningDialog)(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .WarningDialogTypeEnum.SYNC_ALL_LINKS */ .K.SYNC_ALL_LINKS, $additionalContent)) {\n                    this.toggleSpinner(true);\n                    const appPathComponent = this.languageRestService.getPluginRestComponent();\n                    const restUrl = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/diagramLinks/sync`);\n                    try {\n                        const result = yield this.platformUtils.makeRequest({\n                            url: restUrl,\n                            type: _model_enum_rest_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .RestTypeEnum.GET */ .T.GET,\n                        });\n                        this.toggleSpinner(false);\n                        if (result) {\n                            const title = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.sync-diagram-links.success.title");\n                            const body = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.sync-diagram-links.success.body", result);\n                            this.messageService.setSuccessMessage(title, body);\n                        }\n                        else {\n                            const title = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.sync-diagram-links.error.title");\n                            const body = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.sync-diagram-links.error.body");\n                            this.messageService.setWarningMessage(title, body);\n                        }\n                    }\n                    catch (e) {\n                        this.vxcpLogger.logError("migrationWarningDialog submit", "Error while updating DB", e);\n                        const title = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.sync-diagram-links.error.title");\n                        const body = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.sync-diagram-links.error.body");\n                        this.messageService.setWarningMessage(title, body);\n                        this.toggleSpinner(false);\n                    }\n                }\n            }));\n        });\n    }\n    toggleSpinner(show = true) {\n        if (show) {\n            this.spinnerService.show();\n        }\n        else {\n            this.spinnerService.hide();\n        }\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/admin/ao-diagram-links.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/admin/bitbucket-config.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "O": () => (/* binding */ BitbucketConfigService)\n/* harmony export */ });\nif ("bpmnEntAdmin" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nif ("bpmnEntAdmin" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\nclass BitbucketConfigService {\n    constructor(languageRestService, pluginService, messageService) {\n        this.languageRestService = languageRestService;\n        this.pluginService = pluginService;\n        this.messageService = messageService;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_0__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.appPathComponent = "";\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z(this.pluginService.getPluginName(), "BitbucketConfigService");\n        this.appPathComponent = this.languageRestService.getPluginRestComponent();\n    }\n    initBitbucketConfig() {\n        var _a;\n        return __awaiter(this, void 0, void 0, function* () {\n            const getBitbucketAppConfig = () => __awaiter(this, void 0, void 0, function* () {\n                const url = this.platformUtils.buildRestUrl(`/rest/${this.appPathComponent}/1.0/bitbucket/config`);\n                const headers = { "X-Atlassian-Token": "no-check" };\n                return yield this.platformUtils.makeRequest({\n                    url,\n                    headers,\n                    method: "GET",\n                });\n            });\n            const updateBitbucketAppConfig = (bitbucketClientId, bitbucketBaseUrl) => __awaiter(this, void 0, void 0, function* () {\n                const url = this.platformUtils.buildRestUrl(`/rest/${this.appPathComponent}/1.0/bitbucket/config`);\n                const data = { bitbucketClientId, bitbucketBaseUrl };\n                const headers = { "X-Atlassian-Token": "no-check" };\n                try {\n                    yield this.platformUtils.makeRequest({\n                        url,\n                        headers,\n                        type: "PUT",\n                        contentType: "application/json",\n                        data: JSON.stringify(data),\n                        cache: false,\n                    });\n                    const messageHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.saveDiagram.success.title");\n                    const messageBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.saveDiagram.success.body");\n                    $("#vxcp-ent-bitbucket-configs-message").empty();\n                    this.messageService.setSuccessMessage(messageHeading, messageBody, {\n                        fadeOut: true,\n                        identifier: "#vxcp-ent-bitbucket-configs-message",\n                    });\n                }\n                catch (e) {\n                    const messageHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.vcs.error.title");\n                    const messageBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.vcs.error.desc");\n                    $("#vxcp-ent-gitlab-configs-message").empty();\n                    this.messageService.setWarningMessage(messageHeading, messageBody, {\n                        fadeOut: true,\n                        identifier: "#vxcp-ent-gitlab-configs-message",\n                    });\n                    this.vxcpLogger.logError("updateBitbucketAppConfig", "Error while updating global app configs", e);\n                }\n            });\n            const getAppLinkNameFromXml = (appLinkData) => {\n                const $appLinkData = $(appLinkData);\n                const xmlString = $appLinkData[0].childNodes[0].innerHTML;\n                const nameRegEx = new RegExp(/<name>.*<\\/name>/gi);\n                const appName = xmlString.match(nameRegEx);\n                return appName;\n            };\n            const $appLinksListId = "#vxcp-ent-bitbucket-applinks";\n            let currentBitbucketAppConfig;\n            try {\n                currentBitbucketAppConfig = yield getBitbucketAppConfig();\n            }\n            catch (e) {\n                currentBitbucketAppConfig = { bitbucketClientId: "", bitbucketBaseUrl: "" };\n            }\n            if ((_a = currentBitbucketAppConfig.bitbucketClientId) === null || _a === void 0 ? void 0 : _a.length) {\n                try {\n                    const id = currentBitbucketAppConfig.bitbucketClientId;\n                    const appLinkUrl = `rest/applinks/1.0/applicationlink/${id}`;\n                    const appLinkRestUrl = this.platformUtils.buildRestUrl(appLinkUrl);\n                    const appLinkData = yield this.platformUtils.makeRequest({\n                        method: "GET",\n                        url: appLinkRestUrl,\n                    });\n                    const name = getAppLinkNameFromXml(appLinkData);\n                    const $allResultsAppLinks = $(`<fieldset id="vxcp-ent-admin-bitbucket-results"></fieldset>`);\n                    const url = currentBitbucketAppConfig.bitbucketBaseUrl;\n                    const elemId = `vxcp-ent-applink-${id}`;\n                    const $radioForApplication = `<input type="radio" name="vxcp-ent-bitbucket-applink" checked="checked" value="${id}" data-baseUrl="${url}" id="${elemId}"><label for="${elemId}">${name}: ${url}</label>`;\n                    $allResultsAppLinks.append($radioForApplication);\n                    $($appLinksListId).append($allResultsAppLinks);\n                }\n                catch (e) {\n                    const noResultsText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.bitbucket.no-applink-yet");\n                    $($appLinksListId).append(`<i>${noResultsText}</i>`);\n                }\n            }\n            else {\n                const noResultsText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.bitbucket.no-applink-yet");\n                $("#vxcp-ent-bitbucket-applinks").append(`<i>${noResultsText}</i>`);\n            }\n            const $bitbucketFetchBtn = $("#vxcp-ent-bitbucket-configs-fetch");\n            const $bitbucketClearBtn = $("#vxcp-ent-bitbucket-config-clear");\n            $bitbucketFetchBtn.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                $($appLinksListId).empty();\n                $("#vxcp-ent-bitbucket-loading").show();\n                const appLinkUrl = `rest/applinks/1.0/listApplicationlinks`;\n                const appLinkRestUrl = this.platformUtils.buildRestUrl(appLinkUrl);\n                const appLinkData = yield this.platformUtils.makeRequest({\n                    method: "GET",\n                    url: appLinkRestUrl,\n                });\n                const $appLinkData = $(appLinkData);\n                const xmlString = $appLinkData[0].childNodes[0].outerHTML;\n                const xmlParser = new DOMParser();\n                const xmlDoc = xmlParser.parseFromString(xmlString, "text/xml");\n                const appList = xmlDoc.getElementsByTagName("application");\n                if (Array.from(appList).length === 0) {\n                    const noResultsText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.bitbucket.no-applinks-found");\n                    $($appLinksListId).append(`<i>${noResultsText}</i>`);\n                }\n                const $allResultsAppLinks = $(`<fieldset id="vxcp-ent-admin-bitbucket-results"></fieldset>`);\n                Array.from(appList).forEach((application) => {\n                    const id = application.getElementsByTagName("id")[0].childNodes[0].nodeValue;\n                    const url = application.getElementsByTagName("rpcUrl")[0].childNodes[0].nodeValue;\n                    const name = application.getElementsByTagName("name")[0].childNodes[0].nodeValue;\n                    const elemId = `vxcp-ent-applink-${id}`;\n                    const $radioForApplication = `<li><input type="radio" name="vxcp-ent-bitbucket-applink" value="${id}" data-baseUrl="${url}" id="${elemId}"><label for="${elemId}">${name}: ${url}</label></li>`;\n                    $allResultsAppLinks.append($radioForApplication);\n                });\n                $($appLinksListId).append($allResultsAppLinks);\n                $("#vxcp-ent-bitbucket-loading").hide();\n            }));\n            $("#vxcp-ent-bitbucket-config-submit").click((e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                const $selectedBitbucketRadio = $(\'input[name="vxcp-ent-bitbucket-applink"]:checked\');\n                const bitbucketAppId = $selectedBitbucketRadio.val();\n                const bitbucketBaseUrl = $selectedBitbucketRadio.attr("data-baseUrl");\n                yield updateBitbucketAppConfig(bitbucketAppId || "", bitbucketBaseUrl);\n            }));\n            $bitbucketClearBtn.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                const $selectedBitbucketRadio = $(\'input[name="vxcp-ent-bitbucket-applink"]:checked\');\n                $selectedBitbucketRadio.prop("checked", false);\n                const bitbucketAppId = "";\n                const bitbucketBaseUrl = "";\n                yield updateBitbucketAppConfig(bitbucketAppId, bitbucketBaseUrl);\n            }));\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/admin/bitbucket-config.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/admin/bpmn-elements-config.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "c": () => (/* binding */ BpmnElementsConfigService)\n/* harmony export */ });\nif (/^bpmnEnt(Admin|SpaceAdminPage)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nif (/^bpmnEnt(Admin|SpaceAdminPage)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _model_configs_default_bpmn_elements_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/configs/default-bpmn-elements.config.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\nclass BpmnElementsConfigService {\n    constructor(messageService, bpmnElementsConfigRestService) {\n        this.messageService = messageService;\n        this.bpmnElementsConfigRestService = bpmnElementsConfigRestService;\n        this.pluginService = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__/* .getPluginService */ .j)();\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.defaultBpmnElementsConfig = _model_configs_default_bpmn_elements_config__WEBPACK_IMPORTED_MODULE_0__/* .defaultBpmnElementsConfig */ .f;\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z(this.pluginService.getPluginName(), "BpmnElementsConfigService");\n    }\n    init(newDefaultBpmnElementsConfig) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.defaultBpmnElementsConfig = newDefaultBpmnElementsConfig;\n            $("#vxcp-ent-config-bpmn-elements-legend").attr("href", this.pluginService.getSymbolReferenceUrl());\n            $(".vxcp-ent-config-bpmn-elements-group-toggle").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                const $bpmnElementsGroupToggle = $(e.target);\n                const bpmnElementsGroup = $bpmnElementsGroupToggle.attr("bpmn-elements-group");\n                const $bpmnElementsGroupToggles = $(`.vxcp-ent-config-bpmn-element-option-toggle[bpmn-elements-group=${bpmnElementsGroup}]`);\n                $bpmnElementsGroupToggles.prop("checked", $bpmnElementsGroupToggle.prop("checked"));\n            }));\n            $(".vxcp-ent-config-bpmn-element-option-toggle").on("change", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                const bpmnElementsGroup = $(e.target).attr("bpmn-elements-group");\n                const $bpmnElementsGroupToggles = $(`.vxcp-ent-config-bpmn-element-option-toggle[bpmn-elements-group=${bpmnElementsGroup}]`);\n                const isBpmnElementsGroupToggled = $bpmnElementsGroupToggles.toArray().some((element) => {\n                    return $(element).prop("checked");\n                });\n                $(`.vxcp-ent-config-bpmn-elements-group-toggle[bpmn-elements-group=${bpmnElementsGroup}]`).prop("checked", isBpmnElementsGroupToggled);\n            }));\n            $(".vxcp-ent-config-bpmn-elements-config-submit").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                const bpmnElementsGroup = $(e.target).attr("bpmn-elements-group");\n                yield this.submitBpmnElementsConfig(bpmnElementsGroup);\n            }));\n            $(".vxcp-ent-config-bpmn-elements-config-reset").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                const bpmnElementsGroup = $(e.target).attr("bpmn-elements-group");\n                yield this.resetBpmnElementsConfig(bpmnElementsGroup);\n            }));\n        });\n    }\n    submitBpmnElementsConfig(bpmnElementsGroup) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const bpmnElementsGroupConfig = this.getBpmnElementsGroupConfigFromToggles(bpmnElementsGroup);\n                yield this.bpmnElementsConfigRestService.updateBpmnElementsConfig(bpmnElementsGroupConfig);\n                const messageTitle = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.saveDiagram.success.title");\n                const messageBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.saveDiagram.success.body");\n                this.messageService.setSuccessMessage(messageTitle, messageBody, { fadeOut: true, closeable: true, inForeground: true, identifier: "#vxcp-ent-config-bpmn-elements-message-box" });\n                window.scrollTo(0, 0);\n            }\n            catch (e) {\n                this.vxcpLogger.logError("submitBpmnElementsConfig", "Error updating bpmn elements config", e);\n            }\n        });\n    }\n    resetBpmnElementsConfig(bpmnElementsGroup) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                yield this.bpmnElementsConfigRestService.deleteBpmnElementsConfig(bpmnElementsGroup);\n                const bpmnElementsGroupConfig = this.getBpmnElementsGroupConfigFromDefault(bpmnElementsGroup);\n                this.updateBpmnElementsConfigToggles(bpmnElementsGroupConfig);\n                const messageTitle = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.config-reset.success.title");\n                const messageBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.config-reset.success.body");\n                this.messageService.setSuccessMessage(messageTitle, messageBody, { fadeOut: true, closeable: true, inForeground: true, identifier: "#vxcp-ent-config-bpmn-elements-message-box" });\n                window.scrollTo(0, 0);\n            }\n            catch (e) {\n                this.vxcpLogger.logError("resetReplaceMenuConfig", "Error resetting replace menu config", e);\n            }\n        });\n    }\n    updateBpmnElementsConfigToggles(bpmnElementsConfig) {\n        for (const bpmnElement in bpmnElementsConfig) {\n            if (bpmnElementsConfig.hasOwnProperty(bpmnElement)) {\n                $(`#vxcp-ent-config-bpmn-element-${bpmnElement}-toggle`).prop("checked", bpmnElementsConfig[bpmnElement]);\n            }\n        }\n    }\n    getBpmnElementsGroupConfigFromToggles(bpmnElementsGroup) {\n        const bpmnElementsGroupConfig = {};\n        const $bpmnElementsGroupToggles = $(`.vxcp-ent-config-bpmn-element-option-toggle[bpmn-elements-group=${bpmnElementsGroup}]`);\n        $bpmnElementsGroupToggles.each((index, element) => {\n            const $bpmnElementOptionToggle = $(element);\n            const bpmnElement = $bpmnElementOptionToggle.attr("bpmn-element");\n            if (bpmnElement) {\n                bpmnElementsGroupConfig[bpmnElement] = $bpmnElementOptionToggle.prop("checked");\n            }\n        });\n        return bpmnElementsGroupConfig;\n    }\n    getBpmnElementsGroupConfigFromDefault(bpmnElementsGroup) {\n        const bpmnElementsGroupConfig = {};\n        const $bpmnElementsGroupToggles = $(`.vxcp-ent-config-bpmn-element-option-toggle[bpmn-elements-group=${bpmnElementsGroup}]`);\n        $bpmnElementsGroupToggles.each((index, element) => {\n            const bpmnElement = $(element).attr("bpmn-element");\n            if (bpmnElement) {\n                bpmnElementsGroupConfig[bpmnElement] = this.defaultBpmnElementsConfig[bpmnElement];\n            }\n        });\n        return bpmnElementsGroupConfig;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/admin/bpmn-elements-config.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/admin/cloud-migration.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "H": () => (/* binding */ CloudMigrationService)\n/* harmony export */ });\nif ("bpmnEntAdmin" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/file-type.enum.ts");\n/* harmony import */ var file_saver__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/node_modules/file-saver/dist/FileSaver.min.js");\n/* harmony import */ var file_saver__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(file_saver__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\n/* harmony import */ var _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/routing.service.ts");\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\nif ("bpmnEntAdmin" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\nclass CloudMigrationService {\n    constructor(pluginService, attachmentService, macroService, messageService) {\n        this.pluginService = pluginService;\n        this.attachmentService = attachmentService;\n        this.macroService = macroService;\n        this.messageService = messageService;\n        this.$exportBtn = $("#vxcp-ent-cloud-migration-export-btn");\n        this.$importBtn = $("#vxcp-ent-cloud-migration-import-btn");\n        this.$outputTextArea = $("#vxcp-ent-cloud-migration-output");\n        this.$progressBarDiv = $("#vxcp-ent-cloud-migration-progress-div");\n        this.$progressBarExport = $("#vxcp-ent-cloud-migration-progress-bar-export");\n        this.$progressBarImport = $("#vxcp-ent-cloud-migration-progress-bar-import");\n        this.$progressBarImportCounter = $("#vxcp-ent-cloud-migration-progress-counter");\n        this.$userManualLink = $("#vxcp-ent-cloud-migration-help-link");\n        this.importMessageId = "#vxcp-ent-cloud-migration-import-message";\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.languageRestService = _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_2__/* .getLanguageRestService */ .GU();\n        this.appPathComponent = this.languageRestService.getPluginRestComponent();\n        this.serverPageInfo = {};\n        this.cloudPageInfo = {};\n        this.diagramUpdateErrorCollection = [];\n        this.linkUpdateErrorCollection = [];\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z(this.pluginService.getPluginName(), "CloudMigrationService");\n    }\n    init() {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.initJQuerySelectors();\n            this.$outputTextArea.val("");\n            yield this.initFileUpload();\n            this.$exportBtn.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                yield this.startExportFromServerDC();\n            }));\n            this.$importBtn.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                $(this.importMessageId).empty();\n                const input = document.getElementById("vxcp-ent-file-input");\n                input.click();\n            }));\n            this.$outputTextArea.on("focus", (e) => {\n                $(e.target).select();\n            });\n            const userManualLink = yield this.getUserManualLinkCloudMigration();\n            this.$userManualLink.attr("href", userManualLink);\n        });\n    }\n    initJQuerySelectors() {\n        this.$exportBtn = $("#vxcp-ent-cloud-migration-export-btn");\n        this.$importBtn = $("#vxcp-ent-cloud-migration-import-btn");\n        this.$outputTextArea = $("#vxcp-ent-cloud-migration-output");\n        this.$progressBarDiv = $("#vxcp-ent-cloud-migration-progress-div");\n        this.$progressBarExport = $("#vxcp-ent-cloud-migration-progress-bar-export");\n        this.$progressBarImport = $("#vxcp-ent-cloud-migration-progress-bar-import");\n        this.$progressBarImportCounter = $("#vxcp-ent-cloud-migration-progress-counter");\n        this.$userManualLink = $("#vxcp-ent-cloud-migration-help-link");\n    }\n    getUserManualLinkCloudMigration() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const data = yield (0,_atlassian_routing_service__WEBPACK_IMPORTED_MODULE_3__/* .getUrlCollectionFromBucket */ .XR)();\n            const linkCollection = data.result;\n            return this.pluginService.getUserManualCloudMigration(linkCollection);\n        });\n    }\n    startImportInCloud(fileContent) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                this.serverPageInfo = JSON.parse(fileContent);\n            }\n            catch (e) {\n                const errorTitle = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.admin-page.cloud-migration.error.title");\n                const errorMessageBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.admin-page.cloud-migration.error.file-format.body");\n                this.messageService.setErrorMessage(errorTitle, errorMessageBody, {\n                    fadeOut: false,\n                    identifier: this.importMessageId,\n                });\n                return;\n            }\n            if (!this.serverPageInfo || !this.serverPageInfo.from || !this.serverPageInfo.app || !this.serverPageInfo.pages) {\n                const errorTitle = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.admin-page.cloud-migration.error.title");\n                const errorMessageBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.admin-page.cloud-migration.error.file-content-missing.body");\n                this.messageService.setErrorMessage(errorTitle, errorMessageBody, {\n                    fadeOut: false,\n                    identifier: this.importMessageId,\n                });\n                return;\n            }\n            this.vxcpLogger.logInfo("Cloud Migration", "Imported On-Premise Migration File successfully.", this.serverPageInfo);\n            this.setUIWorking();\n            try {\n                const cloudPages = yield this.fetchAllPages(true);\n                this.cloudPageInfo = {\n                    app: this.pluginService.getPluginName(),\n                    from: this.platformUtils.getAppType(),\n                    baseUrl: this.platformUtils.buildConfluenceBaseUrl(),\n                    pages: cloudPages,\n                };\n            }\n            catch (e) {\n                const errorTitle = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.admin-page.cloud-migration.error.title");\n                const errorMessageBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.admin-page.cloud-migration.error.body");\n                this.messageService.setErrorMessage(errorTitle, errorMessageBody, {\n                    fadeOut: false,\n                    identifier: this.importMessageId,\n                });\n                this.setUIReady();\n                return;\n            }\n            this.vxcpLogger.logInfo("Cloud Migration", "Gathered Cloud Instance page information.", this.cloudPageInfo);\n            let progressCounter = 0;\n            this.diagramUpdateErrorCollection = [];\n            this.linkUpdateErrorCollection = [];\n            const totalTodo = this.cloudPageInfo.pages.length;\n            this.updateProgressBarImport(progressCounter, totalTodo);\n            for (const cloudPage of this.cloudPageInfo.pages) {\n                const xmlAttachmentsOfPageInfo = yield this.getXMLAttachmentsInfo(cloudPage.id);\n                if (xmlAttachmentsOfPageInfo.length > 0) {\n                    for (const xmlAttachmentInfo of xmlAttachmentsOfPageInfo) {\n                        yield this.updateDiagramLinks(xmlAttachmentInfo);\n                    }\n                }\n                progressCounter++;\n                this.updateProgressBarImport(progressCounter);\n                this.$progressBarImportCounter.text(`(${progressCounter}/${totalTodo})`);\n                this.vxcpLogger.logInfo("Cloud Migration", `Progress: ${progressCounter}/${totalTodo}`);\n            }\n            const errorCollection = [];\n            errorCollection.push(...this.diagramUpdateErrorCollection);\n            errorCollection.push(...this.linkUpdateErrorCollection);\n            const errorBody = yield this.getErrorMessageText(errorCollection);\n            const messageTitle = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.admin-page.cloud-migration.success.title");\n            const messageBody = (yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.admin-page.cloud-migration.success.body")).concat(errorBody);\n            if (errorCollection.length) {\n                this.messageService.setWarningMessage(messageTitle, messageBody, {\n                    fadeOut: false,\n                    identifier: this.importMessageId,\n                });\n            }\n            else {\n                this.messageService.setSuccessMessage(messageTitle, messageBody, {\n                    fadeOut: false,\n                    identifier: this.importMessageId,\n                });\n            }\n            this.setUIReady();\n        });\n    }\n    getErrorMessageText(errorCollection) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!errorCollection.length) {\n                return "";\n            }\n            let errorBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.admin-page.cloud-migration.error-list.desc");\n            errorBody = `<p>${errorBody}</p><ul>`;\n            yield (0,_utils_utils__WEBPACK_IMPORTED_MODULE_4__.asyncForEach)(errorCollection, (err, idx) => __awaiter(this, void 0, void 0, function* () {\n                let btn = "";\n                if (err.pageId) {\n                    const pageUrl = yield (0,_atlassian_routing_service__WEBPACK_IMPORTED_MODULE_3__/* .getUrlConfluencePage */ .PI)(err.pageId);\n                    btn = `( <a title="${err.attachmentName}" href="${pageUrl}" target="_blank">${err.attachmentName}</a> )`;\n                }\n                errorBody = errorBody + `<li>${err.attachmentName} ${btn}: ${err.reason}</li>`;\n            }));\n            errorBody = `${errorBody}</ul>`;\n            return errorBody;\n        });\n    }\n    updateDiagramLinks(xmlAttachment) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const fileType = this.pluginService.getFileEnding();\n            const fileNameWithoutEnding = xmlAttachment.title.replace(fileType, "");\n            try {\n                const attachmentData = yield this.loadLatestAttachment(xmlAttachment.title, xmlAttachment.pageId);\n                if (!attachmentData || !attachmentData.data) {\n                    return;\n                }\n                const attachmentXmlString = attachmentData.data;\n                const updatedXml = yield this.migrateAttachmentXMLToCloud(attachmentXmlString);\n                if (updatedXml === attachmentXmlString) {\n                    return;\n                }\n                const updatedAttachmentFile = new Blob([updatedXml]);\n                const uploadResponse = yield this.attachmentService.updateAttachmentById(xmlAttachment.id, updatedAttachmentFile, xmlAttachment.title, xmlAttachment.pageId, "Migrated Diagram Links to Confluence Cloud.", `/rest/${this.appPathComponent}/1.0/cloud-migration/confluence/rest/api/content/${xmlAttachment.pageId}/child/attachment/${xmlAttachment.id}/data`);\n                const vbcpEntId = yield this.macroService.getVbcpEntIdByDiagramName(this.pluginService.getMacroName(), xmlAttachment.pageId, fileNameWithoutEnding, `/rest/${this.appPathComponent}/1.0/cloud-migration/confluence/rest/api/content`);\n                if (vbcpEntId.length === 0) {\n                    this.vxcpLogger.logWarning("CloudMigration", `Could not find vbcpEntId for attachment ${xmlAttachment.title} on page ${xmlAttachment.pageId}. Perhaps no Macro exists. Continuing.`);\n                    return;\n                }\n                if (uploadResponse.version && uploadResponse.version.number) {\n                    yield this.updateShownAttachmentVersionSilently(xmlAttachment.pageId, vbcpEntId, uploadResponse.version.number);\n                }\n            }\n            catch (e) {\n                this.diagramUpdateErrorCollection.push({\n                    pageId: xmlAttachment.pageId,\n                    attachmentName: xmlAttachment.title,\n                    reason: `Failed migrating diagram ${xmlAttachment.title} on page ${xmlAttachment.pageId}`,\n                });\n                this.vxcpLogger.logWarning("updateDiagramLinks", `Failed migrating diagram ${xmlAttachment.title} on page ${xmlAttachment.pageId}`);\n            }\n        });\n    }\n    loadLatestAttachment(fullFileName, pageId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const restPath = `/rest/${this.appPathComponent}/1.0/cloud-migration/confluence/rest/api/content/${pageId}/child/attachment?start=0&filename=${fullFileName}&expand=version`;\n            const attachmentData = yield this.attachmentService.getAttachmentDataByFileName(pageId, fullFileName, restPath);\n            if (!attachmentData.length || attachmentData.length !== 1) {\n                return;\n            }\n            const attachmentId = attachmentData[0].id;\n            const latestAttachmentVersion = attachmentData[0].version.number;\n            const downloadUrl = this.platformUtils.buildRestUrl(`/rest/${this.appPathComponent}/1.0/cloud-migration/getAttachment/${attachmentId}/version/${latestAttachmentVersion}`);\n            const response = yield this.platformUtils.makeRequest({\n                url: downloadUrl,\n                type: "GET",\n                headers: { "X-Atlassian-Token": "no-check" },\n            });\n            return response;\n        });\n    }\n    updateShownAttachmentVersionSilently(pageId, vbcpEntId, newShownAttachmentVersion) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const dataToSend = {\n                shownAttachmentVersion: newShownAttachmentVersion,\n            };\n            const configBaseUrl = this.platformUtils.buildRestUrl(`/rest/${this.languageRestService.getPluginRestComponent()}/1.0/cloud-migration`);\n            const url = configBaseUrl + `/updateConfigAsApp/${pageId}/${vbcpEntId}/shownAttachmentVersion?minorEdit=true`;\n            return yield this.platformUtils.makeRequest({\n                cache: false,\n                url,\n                type: "POST",\n                data: JSON.stringify(dataToSend),\n                contentType: "application/json",\n                headers: { "X-Atlassian-Token": "no-check" },\n                error: (err) => {\n                    this.vxcpLogger.logError("CloudMigration", "Failed updating shownAttachmentVersion.", err);\n                    return err;\n                },\n            });\n        });\n    }\n    migrateAttachmentXMLToCloud(inputXml) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let updatedXml = inputXml;\n            const viadeeDiagramLinksRegex = /(<viadee:bpmnLinks|<viadee:pageLinks|<viadee:dmnEnterpriseLinks).*?(\\/>)/g;\n            const viadeeAttachmentLinksRegex = /<viadee:confluenceAttachmentLink.*?(\\/>)/g;\n            const diagramLinkFragmentMatches = inputXml.match(viadeeDiagramLinksRegex) || [];\n            const attachmentLinkFragmentMatches = inputXml.match(viadeeAttachmentLinksRegex) || [];\n            if (diagramLinkFragmentMatches.length === 0 && attachmentLinkFragmentMatches.length === 0) {\n                return inputXml;\n            }\n            for (const diagramLinkFragment of diagramLinkFragmentMatches) {\n                const updatedDiagramLinkFragment = this.updateDiagramLinkFragmentToCloud(diagramLinkFragment);\n                updatedXml = updatedXml.replace(diagramLinkFragment, updatedDiagramLinkFragment);\n            }\n            for (const attachmentLinkFragment of attachmentLinkFragmentMatches) {\n                const updatedAttachmentLinkFragment = yield this.updateAttachmentLinkFragmentToCloud(attachmentLinkFragment);\n                updatedXml = updatedXml.replace(attachmentLinkFragment, updatedAttachmentLinkFragment);\n            }\n            return updatedXml;\n        });\n    }\n    updateDiagramLinkFragmentToCloud(inputDiagramLinkFragment) {\n        const pageIdRegex = /pageId="\\d*"/g;\n        const pageIdMatch = inputDiagramLinkFragment.match(pageIdRegex);\n        if (!pageIdMatch || pageIdMatch.length > 1) {\n            return inputDiagramLinkFragment;\n        }\n        const serverPageId = pageIdMatch[0].replace(/"/g, "").replace("pageId=", "");\n        const cloudPageInfo = this.lookUpCloudPageInfo(serverPageId);\n        if (!cloudPageInfo || cloudPageInfo.id.length === 0) {\n            return inputDiagramLinkFragment;\n        }\n        const updatedDiagramLinkFragment = inputDiagramLinkFragment.replace(pageIdMatch[0], `pageId="${cloudPageInfo.id}"`);\n        return updatedDiagramLinkFragment;\n    }\n    updateAttachmentLinkFragmentToCloud(inputAttachmentLinkFragment) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const linkedAttachmentTitleRegex = /title=".*?"\\s/g;\n            const linkedAttachmentTitleMatch = inputAttachmentLinkFragment.match(linkedAttachmentTitleRegex);\n            if (!linkedAttachmentTitleMatch || linkedAttachmentTitleMatch.length !== 1) {\n                return inputAttachmentLinkFragment;\n            }\n            const linkedAttachmentTitle = linkedAttachmentTitleMatch[0].substring(\'title="\'.length, linkedAttachmentTitleMatch[0].length - 2);\n            const linkedAttachmentSpaceKey = this.parseSpaceFromAttachmentLinkServer(inputAttachmentLinkFragment);\n            if (!linkedAttachmentSpaceKey) {\n                return inputAttachmentLinkFragment;\n            }\n            let updatedLinkedAttachmentWebUiLink = "";\n            try {\n                updatedLinkedAttachmentWebUiLink = yield this._getWebUIUrlForUniqueAttachmentInSpace(linkedAttachmentTitle, linkedAttachmentSpaceKey);\n                if (!updatedLinkedAttachmentWebUiLink || !updatedLinkedAttachmentWebUiLink.includes("viewpageattachments")) {\n                    return inputAttachmentLinkFragment;\n                }\n            }\n            catch (e) {\n                this.vxcpLogger.logInfo("CloudMigration", "Got error or found multiple attachments. Did not update an attachment link.");\n                const index = this.linkUpdateErrorCollection.findIndex((error) => {\n                    return error.attachmentName === linkedAttachmentTitle;\n                });\n                if (index === -1) {\n                    this.linkUpdateErrorCollection.push({\n                        pageId: "",\n                        attachmentName: linkedAttachmentTitle,\n                        reason: `Links to this attachment were not migrated. Either it is not present or not unique within the Confluence space (${linkedAttachmentSpaceKey}), or an error occurred.`,\n                    });\n                }\n                return inputAttachmentLinkFragment;\n            }\n            updatedLinkedAttachmentWebUiLink = this.platformUtils.buildConfluenceBaseUrl().concat(updatedLinkedAttachmentWebUiLink);\n            updatedLinkedAttachmentWebUiLink = \'url="\'.concat(updatedLinkedAttachmentWebUiLink).concat(\'" \');\n            const fullUrlPropertyMatchRegex = /url=".*?"\\s/;\n            const fullUrlPropertyMatches = inputAttachmentLinkFragment.match(fullUrlPropertyMatchRegex);\n            if (!fullUrlPropertyMatches || fullUrlPropertyMatches.length !== 1) {\n                return inputAttachmentLinkFragment;\n            }\n            return inputAttachmentLinkFragment.replace(fullUrlPropertyMatches[0], updatedLinkedAttachmentWebUiLink);\n        });\n    }\n    parseSpaceFromAttachmentLinkServer(linkFragment) {\n        const spaceFromUrlRegex = /url=".*?\\/display\\/.*?\\//;\n        const spaceInUrlMatch = linkFragment.match(spaceFromUrlRegex);\n        if (!spaceInUrlMatch || spaceInUrlMatch.length !== 1) {\n            return null;\n        }\n        let linkedSpaceKey = spaceInUrlMatch[0].replace(`url="${this.serverPageInfo.baseUrl}/display/`, "");\n        linkedSpaceKey = linkedSpaceKey.replace("/", "");\n        if (!linkedSpaceKey || linkedSpaceKey.length < 1) {\n            return null;\n        }\n        return linkedSpaceKey;\n    }\n    lookUpCloudPageInfo(serverPageId) {\n        const pageInfoServer = this.serverPageInfo.pages.find((pageInfo) => {\n            return pageInfo.id === serverPageId;\n        });\n        if (!pageInfoServer) {\n            this.vxcpLogger.logWarning("Cloud Migration", "Did not find a matching cloud page for server page " + serverPageId);\n            return null;\n        }\n        return this.cloudPageInfo.pages.find((pageInfo) => {\n            return pageInfo.title === pageInfoServer.title && pageInfo.space.key === pageInfoServer.space.key;\n        });\n    }\n    getXMLAttachmentsInfo(pageId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`/rest/${this.appPathComponent}/1.0/cloud-migration/confluence/rest/api/content/${pageId}/child/attachment`);\n            const headers = {\n                "X-Atlassian-Token": "no-check",\n                "Content-Type": "application/json",\n            };\n            try {\n                const response = yield this.platformUtils.makeRequest({\n                    type: "GET",\n                    url,\n                    headers,\n                });\n                if (response.results.length === 0) {\n                    return [];\n                }\n                const xmlAttachments = response.results.filter((attachment) => {\n                    if (attachment.title.endsWith(this.pluginService.getFileEnding())) {\n                        return attachment;\n                    }\n                });\n                const xmlAttachmentsCleaned = [];\n                xmlAttachments.map((attachment) => {\n                    const cleaned = {\n                        id: attachment.id,\n                        title: attachment.title,\n                        pageId,\n                    };\n                    xmlAttachmentsCleaned.push(cleaned);\n                });\n                return xmlAttachmentsCleaned;\n            }\n            catch (e) {\n                return [];\n            }\n        });\n    }\n    initFileUpload() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const input = document.getElementById("vxcp-ent-file-input");\n            if (!input) {\n                return;\n            }\n            if (!window.File || !window.FileReader || !window.FileList || !window.Blob || !input.files) {\n                const errorTitle = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.admin-page.cloud-migration.error.title");\n                const errorBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.admin-page.cloud-migration.error.browser.body");\n                this.messageService.setErrorMessage(errorTitle, errorBody, {\n                    fadeOut: false,\n                    identifier: this.importMessageId,\n                });\n                return;\n            }\n            input.onchange = (e) => {\n                const file = e.target.files[0];\n                const reader = new FileReader();\n                reader.readAsText(file);\n                reader.onload = (readerEvent) => {\n                    if (!readerEvent.target) {\n                        return;\n                    }\n                    const content = readerEvent.target.result;\n                    this.startImportInCloud(content);\n                };\n            };\n        });\n    }\n    startExportFromServerDC() {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.setUIWorking();\n            try {\n                const totalSize = yield this.getTotalSize();\n                this.updateProgressBarExport(0, totalSize);\n                const pageInfo = yield this.fetchAllPages(false);\n                const exportObj = {\n                    app: this.pluginService.getPluginName(),\n                    from: this.platformUtils.getAppType(),\n                    baseUrl: this.platformUtils.buildConfluenceBaseUrl(),\n                    pages: pageInfo,\n                };\n                const jsonString = JSON.stringify(exportObj);\n                this.$outputTextArea.val(jsonString);\n                const blob = new Blob([jsonString], { type: "application/json" });\n                this.downloadBlob(blob, "Cloud_Migration_Export_" + new Date().getTime(), _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FileTypeEnum.JSON */ .W.JSON);\n            }\n            catch (e) {\n                this.vxcpLogger.logError("Cloud Migration Data Export", "Exporting data failed. ", e);\n                this.$outputTextArea.val("An error occurred while exporting data.");\n            }\n            finally {\n                this.setUIReady();\n            }\n        });\n    }\n    setUIWorking() {\n        this.$exportBtn.attr("disabled", "");\n        this.$importBtn.attr("disabled", "");\n        this.$outputTextArea.val("");\n        this.$progressBarDiv.removeClass("vxcp-ent-hidden");\n    }\n    setUIReady() {\n        this.$progressBarExport.attr("indeterminate", "");\n        this.$progressBarImport.attr("indeterminate", "");\n        this.$progressBarDiv.addClass("vxcp-ent-hidden");\n        this.$exportBtn.removeAttr("disabled");\n        this.$importBtn.removeAttr("disabled");\n        this.$progressBarDiv.addClass("vxcp-ent-hidden");\n    }\n    downloadBlob(blobObject, fileName, fileType) {\n        try {\n            file_saver__WEBPACK_IMPORTED_MODULE_1___default().saveAs(blobObject, fileName + fileType);\n        }\n        catch (e) {\n            this.vxcpLogger.logError("CloudMigrationService", "Could not initiate file download.");\n        }\n    }\n    fetchAllPages(useCloudBackend) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let start = 0;\n            const limit = 100;\n            let moreResults = true;\n            const results = [];\n            try {\n                while (moreResults) {\n                    const response = yield this.getConfluencePages(start, limit, useCloudBackend);\n                    if (response.results.length) {\n                        for (const result of response.results) {\n                            const cleanedResult = {\n                                id: result.id,\n                                type: result.type,\n                                status: result.status,\n                                title: result.title,\n                                space: {\n                                    id: result.space.id,\n                                    key: result.space.key,\n                                    name: result.space.name,\n                                },\n                            };\n                            results.push(cleanedResult);\n                        }\n                    }\n                    this.updateProgressBarExport(results.length);\n                    if (response.results.length < limit) {\n                        moreResults = false;\n                    }\n                    else {\n                        start += limit;\n                    }\n                }\n                return results;\n            }\n            catch (e) {\n                this.vxcpLogger.logError("Cloud Migration", "An error occurred fetching Confluence pages", e);\n                this.setUIReady();\n                throw e;\n            }\n        });\n    }\n    getConfluencePages(start, limit, useCloudBackend) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let url = this.platformUtils.buildRestUrl(`/rest/api/content?cql=${encodeURI("type IN (blogpost,page)")}&start=${start}&limit=${limit}&expand=space`);\n            if (useCloudBackend) {\n                url = this.platformUtils.buildRestUrl(`/rest/${this.appPathComponent}/1.0/cloud-migration/confluence/rest/api/content?cql=${encodeURI("type IN (blogpost,page)")}&start=${start}&limit=${limit}&expand=space`);\n            }\n            const response = yield this.platformUtils.makeRequest({\n                type: "GET",\n                url,\n            });\n            return response;\n        });\n    }\n    updateProgressBarExport(current, max) {\n        const progress = document.getElementById("vxcp-ent-cloud-migration-progress-bar-export");\n        if (!progress) {\n            return;\n        }\n        if (max) {\n            progress.max = max;\n        }\n        progress.value = current;\n        this.$progressBarExport.removeAttr("indeterminate");\n    }\n    updateProgressBarImport(current, max) {\n        const progress = document.getElementById("vxcp-ent-cloud-migration-progress-bar-import");\n        if (!progress) {\n            return;\n        }\n        if (max) {\n            progress.max = max;\n        }\n        progress.value = current;\n        this.$progressBarImport.removeAttr("indeterminate");\n    }\n    getTotalSize() {\n        return __awaiter(this, void 0, void 0, function* () {\n            let url = this.platformUtils.buildRestUrl(`/rest/api/search`);\n            url = url.concat(`?cql=${encodeURI("type IN (blogpost,page)")}&start=${0}&limit=${1}`);\n            const headers = {\n                "X-Atlassian-Token": "no-check",\n                "Content-Type": "application/json",\n            };\n            const response = yield this.platformUtils.makeRequest({\n                type: "GET",\n                url,\n                headers,\n            });\n            return response.totalSize;\n        });\n    }\n    _getWebUIUrlForUniqueAttachmentInSpace(title, spaceKey) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n                let url = this.platformUtils.buildRestUrl(`/rest/${this.appPathComponent}/1.0/cloud-migration/confluence/rest/api/search`);\n                url = url.concat(`?cql=type=attachment ${encodeURI(`and title="${title}" and space=${spaceKey}`)}`);\n                const headers = {\n                    "X-Atlassian-Token": "no-check",\n                    "Content-Type": "application/json",\n                };\n                try {\n                    const response = yield this.platformUtils.makeRequest({\n                        type: "GET",\n                        url,\n                        headers,\n                    });\n                    if (response.totalSize !== 1) {\n                        reject("Found 0 or >1 matches.");\n                    }\n                    resolve(response.results[0].content._links.webui);\n                }\n                catch (e) {\n                    reject();\n                }\n            }));\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/admin/cloud-migration.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/admin/gitlab-config.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "a": () => (/* binding */ GitlabConfigService)\n/* harmony export */ });\nif ("bpmnEntAdmin" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\nclass GitlabConfigService {\n    constructor(languageRestService, appConfigService, messageService) {\n        this.languageRestService = languageRestService;\n        this.appConfigService = appConfigService;\n        this.messageService = messageService;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_0__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.restPathComponent = "";\n        this.restPathComponent = this.languageRestService.getPluginRestComponent();\n    }\n    initGitLabConfiguration() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $redirectURIContainer = $("#vxcp-ent-gitlab-config-redirect-uri");\n            const appPathComponent = this.languageRestService.getPluginRestComponent();\n            const redirectUri = yield this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/gitlab/oauth/redirect`);\n            $redirectURIContainer.text(redirectUri);\n            const $gitLabClientIdInput = $("#vxcp-ent-gitlab-client-id-input");\n            const $gitLabClientSecretInput = $("#vxcp-ent-gitlab-client-secret-input");\n            const $gitLabBaseUrlInput = $("#vxcp-ent-gitlab-base-url-input");\n            const $gitLabConfigSubmit = $("#vxcp-ent-gitlab-config-submit");\n            const $gitLabConfigClearAll = $("#vxcp-ent-gitlab-config-clear");\n            const $gitLabConfigTestConnection = $("#vxcp-ent-gitlab-config-test-connection");\n            let currentConfig = { gitLabClientId: "", gitLabClientSecret: "", gitLabBaseUrl: "" };\n            try {\n                currentConfig = yield this.appConfigService.getGitlabAppConfig();\n            }\n            catch (e) {\n            }\n            $gitLabClientIdInput.val(currentConfig.gitLabClientId);\n            $gitLabClientSecretInput.val(currentConfig.gitLabClientSecret);\n            $gitLabBaseUrlInput.val(currentConfig.gitLabBaseUrl);\n            $gitLabConfigSubmit.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                const gitLabClientId = $gitLabClientIdInput.val().trim();\n                const gitLabClientSecret = $gitLabClientSecretInput.val().trim();\n                let gitLabBaseUrl = $gitLabBaseUrlInput.val().trim();\n                if (gitLabBaseUrl.endsWith("/")) {\n                    gitLabBaseUrl = gitLabBaseUrl.slice(0, -1);\n                }\n                if (!gitLabBaseUrl.includes("http")) {\n                    const errorHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.gitLab.malformed-url.title");\n                    const errorBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.gitLab.malformed-url.body");\n                    $("#vxcp-ent-gitlab-configs-message").empty();\n                    this.messageService.setErrorMessage(errorHeading, errorBody, { identifier: "#vxcp-ent-gitlab-configs-message" });\n                    return;\n                }\n                try {\n                    yield this.appConfigService.updateGitlabAppConfig(this.restPathComponent, gitLabClientId, gitLabClientSecret, gitLabBaseUrl);\n                    const messageHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.saveDiagram.success.title");\n                    const messageBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.saveDiagram.success.body");\n                    $("#vxcp-ent-gitlab-configs-message").empty();\n                    this.messageService.setSuccessMessage(messageHeading, messageBody, {\n                        fadeOut: true,\n                        identifier: "#vxcp-ent-gitlab-configs-message",\n                    });\n                }\n                catch (e) {\n                    const errorHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.gitLab.config-save-error.title");\n                    const errorBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.gitLab.config-save-error.body");\n                    $("#vxcp-ent-gitlab-configs-message").empty();\n                    this.messageService.setErrorMessage(errorHeading, errorBody, { identifier: "#vxcp-ent-gitlab-configs-message" });\n                }\n            }));\n            $gitLabConfigClearAll.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                const gitLabClientId = "";\n                const gitLabClientSecret = "";\n                const gitLabBaseUrl = "";\n                $gitLabClientIdInput.val(gitLabClientId);\n                $gitLabClientSecretInput.val(gitLabClientSecret);\n                $gitLabBaseUrlInput.val(gitLabBaseUrl);\n                try {\n                    yield this.appConfigService.updateGitlabAppConfig(this.restPathComponent, gitLabClientId, gitLabClientSecret, gitLabBaseUrl);\n                    $("#vxcp-ent-gitlab-configs-message").empty();\n                    const messageHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.saveDiagram.success.title");\n                    const messageBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.saveDiagram.success.body");\n                    this.messageService.setSuccessMessage(messageHeading, messageBody, {\n                        fadeOut: true,\n                        identifier: "#vxcp-ent-gitlab-configs-message",\n                    });\n                }\n                catch (e) {\n                    const errorHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.gitLab.config-save-error.title");\n                    const errorBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.gitLab.config-save-error.body");\n                    $("#vxcp-ent-gitlab-configs-message").empty();\n                    this.messageService.setErrorMessage(errorHeading, errorBody, { identifier: "#vxcp-ent-gitlab-configs-message" });\n                }\n            }));\n            $gitLabConfigTestConnection.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                const gitLabClientId = ($gitLabClientIdInput.val() || "").toString().trim();\n                const gitLabClientSecret = ($gitLabClientSecretInput.val() || "").toString().trim();\n                let gitLabBaseUrl = ($gitLabBaseUrlInput.val() || "").toString().trim();\n                if (!gitLabBaseUrl) {\n                    $gitLabBaseUrlInput.addClass("invalid");\n                    setTimeout(() => {\n                        $gitLabBaseUrlInput.removeClass("invalid");\n                    }, 5000);\n                    return;\n                }\n                if (!gitLabClientId.length) {\n                    $gitLabClientIdInput.addClass("invalid");\n                    setTimeout(() => {\n                        $gitLabClientIdInput.removeClass("invalid");\n                    }, 5000);\n                    return;\n                }\n                if (!gitLabClientSecret.length) {\n                    $gitLabClientSecretInput.addClass("invalid");\n                    setTimeout(() => {\n                        $gitLabClientSecretInput.removeClass("invalid");\n                    }, 5000);\n                    return;\n                }\n                if (gitLabBaseUrl.endsWith("/")) {\n                    gitLabBaseUrl = gitLabBaseUrl.slice(0, -1);\n                }\n                if (!gitLabBaseUrl.includes("http")) {\n                    const errorHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.gitLab.malformed-url.title");\n                    const errorBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.gitLab.malformed-url.body");\n                    $("#vxcp-ent-gitlab-configs-message").empty();\n                    this.messageService.setErrorMessage(errorHeading, errorBody, { identifier: "#vxcp-ent-gitlab-configs-message" });\n                    return;\n                }\n                const accountId = yield this.platformUtils.getUser();\n                const oauthRestUrl = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/gitlab/oauth/test?baseUrl=${gitLabBaseUrl}&appId=${gitLabClientId}&appSecret=${gitLabClientSecret}&accountId=${accountId}`);\n                const authenticationUrl = yield this.platformUtils.makeRequest({\n                    url: oauthRestUrl,\n                    method: "GET",\n                    dataType: "text",\n                });\n                window.open(authenticationUrl, "_blank");\n            }));\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/admin/gitlab-config.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/admin/global-diagram-config.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "o": () => (/* binding */ GlobalDiagramConfigService)\n/* harmony export */ });\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/warning-dialog-type.enum.ts");\n/* harmony import */ var _model_enum_browser_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/browser.enum.ts");\nif ("bpmnEntAdmin" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nclass GlobalDiagramConfigService {\n    constructor(colorSyncService, browserService, appConfigService, messageService, validatorService) {\n        this.colorSyncService = colorSyncService;\n        this.browserService = browserService;\n        this.appConfigService = appConfigService;\n        this.messageService = messageService;\n        this.validatorService = validatorService;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n    }\n    initGlobalConfig() {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.initGeneralConfig();\n            yield this.initResetGeneralConfig();\n            yield this.initLinkConfig();\n            yield this.initResetLinkConfig();\n            yield this.initViewConfig();\n            yield this.initResetViewConfig();\n        });\n    }\n    initGeneralConfig() {\n        return __awaiter(this, void 0, void 0, function* () {\n            $("#vxcp-ent-general-config-submit").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                yield this.submitGeneralConfig(true);\n            }));\n        });\n    }\n    initResetGeneralConfig() {\n        return __awaiter(this, void 0, void 0, function* () {\n            $("#vxcp-ent-general-config-reset").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                if (yield (0,_utils_utils__WEBPACK_IMPORTED_MODULE_0__.confirmWarningDialog)(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .WarningDialogTypeEnum.RESET_ADMIN_PAGE_CONFIGS */ .K.RESET_ADMIN_PAGE_CONFIGS)) {\n                    const configElements = this.getConfigElements();\n                    configElements.commentedSavingToggle.checked = false;\n                    configElements.showEmbeddedCommentsToggle.checked = true;\n                    configElements.showDocumentationToggle.checked = true;\n                    configElements.saveZoomPositionToggle.checked = false;\n                    configElements.showWelcomeScreenToggle.checked = true;\n                    yield this.submitGeneralConfig(false);\n                }\n            }));\n        });\n    }\n    submitGeneralConfig(submitMessage) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const newConfigValues = this.getValuesFromConfigDialog();\n            if (typeof newConfigValues === "boolean") {\n                return;\n            }\n            try {\n                yield this.appConfigService.updateGeneralConfig(newConfigValues.showDocumentation.toString(), newConfigValues.commentedSaving.toString(), newConfigValues.saveZoomPosition.toString(), newConfigValues.showEmbeddedComments.toString(), newConfigValues.showWelcomeScreen.toString());\n                const message = yield this.getConfigSubmitMessage(submitMessage);\n                $("#vxcp-ent-general-configs-message").empty();\n                this.messageService.setSuccessMessage(message.messageHeading, message.messageBody, {\n                    fadeOut: true,\n                    identifier: "#vxcp-ent-general-configs-message",\n                });\n            }\n            catch (e) {\n            }\n        });\n    }\n    initLinkConfig() {\n        return __awaiter(this, void 0, void 0, function* () {\n            $("#vxcp-ent-link-config-submit").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                yield this.submitLinkConfig(true);\n            }));\n        });\n    }\n    initResetLinkConfig() {\n        return __awaiter(this, void 0, void 0, function* () {\n            $("#vxcp-ent-link-config-reset").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                if (yield (0,_utils_utils__WEBPACK_IMPORTED_MODULE_0__.confirmWarningDialog)(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .WarningDialogTypeEnum.RESET_ADMIN_PAGE_CONFIGS */ .K.RESET_ADMIN_PAGE_CONFIGS)) {\n                    const configElements = this.getConfigElements();\n                    configElements.showBpmnLinksToggle.checked = true;\n                    configElements.showDmnLinksToggle.checked = true;\n                    configElements.showConfluencePageLinksToggle.checked = true;\n                    configElements.showConfluenceAttachmentLinksToggle.checked = true;\n                    configElements.showExternalContentLinksToggle.checked = true;\n                    configElements.showJiraIssueLinksToggle.checked = true;\n                    configElements.showMdfInstanceLinksToggle.checked = true;\n                    configElements.showBpmnInTabToggle.checked = false;\n                    configElements.showDmnInTabToggle.checked = false;\n                    configElements.showAttachmentsInTabToggle.checked = false;\n                    configElements.showJiraIssuesInTabToggle.checked = false;\n                    yield this.submitLinkConfig(false);\n                }\n            }));\n        });\n    }\n    submitLinkConfig(submitMessage) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const newConfigValues = this.getValuesFromConfigDialog();\n            if (typeof newConfigValues === "boolean") {\n                return;\n            }\n            try {\n                yield this.appConfigService.updateLinkConfig(newConfigValues.showConfluencePageLinks.toString(), newConfigValues.showConfluenceAttachmentLinks.toString(), newConfigValues.showExternalContentLinks.toString(), newConfigValues.showBpmnLinks.toString(), newConfigValues.showJiraIssueLinks.toString(), newConfigValues.showDmnLinks.toString(), newConfigValues.showBpmnInTab.toString(), newConfigValues.showAttachmentsInTab.toString(), newConfigValues.showDmnInTab.toString(), newConfigValues.showJiraIssuesInTab.toString(), newConfigValues.showMdfInstanceLinks.toString(), newConfigValues.showAnyLinks.toString());\n                const message = yield this.getConfigSubmitMessage(submitMessage);\n                $("#vxcp-ent-link-configs-message").empty();\n                this.messageService.setSuccessMessage(message.messageHeading, message.messageBody, {\n                    fadeOut: true,\n                    identifier: "#vxcp-ent-link-configs-message",\n                });\n            }\n            catch (e) {\n            }\n        });\n    }\n    initViewConfig() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $configDialog = $("#vxcp-ent-admin-page");\n            const $colorPicker = $configDialog.find("#vxcp-ent-config-background-color-color-picker");\n            const $noColorPickerWarning = $configDialog.find("#vxcp-ent-colorpicker-no-color-picker-warning");\n            const $viewerHeightInput = $configDialog.find("#vxcp-ent-config-viewer-height-input");\n            this.colorSyncService.init("#vxcp-ent-config-background-color-color-picker", "#vxcp-ent-config-background-color-input", "#vxcp-ent-diagram-background-color-error");\n            if (this.browserService.isBrowser([_model_enum_browser_enum__WEBPACK_IMPORTED_MODULE_2__/* .BrowserEnum.INTERNET_EXPLORER */ .p.INTERNET_EXPLORER])) {\n                $colorPicker.hide();\n                $noColorPickerWarning.show();\n            }\n            const viewerHeightToggleId = "#vxcp-ent-config-custom-viewer-height-toggle";\n            const showMaxViewerHeightToggleId = "#vxcp-ent-config-max-viewer-height-toggle";\n            const $viewerHeightToggle = $(viewerHeightToggleId);\n            const $showMaxViewerHeightToggle = $(showMaxViewerHeightToggleId);\n            $viewerHeightToggle.on("change", (changeEvent) => setTimeout(() => {\n                const clickedToggle = changeEvent.currentTarget;\n                $viewerHeightInput.prop("disabled", !clickedToggle.checked);\n                if (clickedToggle.checked && $showMaxViewerHeightToggle.length) {\n                    $showMaxViewerHeightToggle.get(0).checked = false;\n                }\n            }));\n            $showMaxViewerHeightToggle.on("change", (changeEvent) => setTimeout(() => {\n                const clickedToggle = changeEvent.currentTarget;\n                if (clickedToggle.checked) {\n                    $viewerHeightToggle.prop("checked", false);\n                    $viewerHeightInput.prop("disabled", true);\n                }\n            }));\n            $("#vxcp-ent-show-config-submit").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                yield this.submitViewConfig(true);\n            }));\n        });\n    }\n    initResetViewConfig() {\n        return __awaiter(this, void 0, void 0, function* () {\n            $("#vxcp-ent-show-config-reset").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                if (yield (0,_utils_utils__WEBPACK_IMPORTED_MODULE_0__.confirmWarningDialog)(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .WarningDialogTypeEnum.RESET_ADMIN_PAGE_CONFIGS */ .K.RESET_ADMIN_PAGE_CONFIGS)) {\n                    const configElements = this.getConfigElements();\n                    this.colorSyncService.setColor("#ffffff");\n                    configElements.loadImageInViewerDropdown.value = "model";\n                    configElements.enableCustomViewerHeightToggle.checked = false;\n                    configElements.viewerHeightInput.value = "250";\n                    configElements.showMaximalHeightToggle.checked = false;\n                    configElements.showBpmnJsPanelToggle.checked = true;\n                    $("#vxcp-ent-config-viewer-height-input").removeClass("invalid");\n                    yield this.submitViewConfig(false);\n                }\n            }));\n        });\n    }\n    submitViewConfig(submitMessage) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $configDialog = $("#vxcp-ent-admin-page");\n            const $viewerHeightErrorMessage = $configDialog.find("#vxcp-ent-config-viewer-height-error");\n            const newConfigValues = this.getValuesFromConfigDialog();\n            if (typeof newConfigValues === "boolean") {\n                return;\n            }\n            const flagValid = yield this.validateConfig(newConfigValues);\n            if (!flagValid) {\n                return;\n            }\n            try {\n                const viewerHeightIsValidNumber = yield this.validatorService.isIntegerValue(newConfigValues.viewerHeight);\n                if (viewerHeightIsValidNumber) {\n                    $viewerHeightErrorMessage.addClass("vxcp-ent-hidden");\n                    $viewerHeightErrorMessage.text("");\n                }\n                yield this.appConfigService.updateViewConfig(newConfigValues.diagramBackgroundColor, newConfigValues.loadImageInViewer, newConfigValues.showMaximalHeight.toString(), newConfigValues.enableCustomViewerHeight.toString(), newConfigValues.viewerHeight, newConfigValues.showBpmnJsPanel.toString());\n                const message = yield this.getConfigSubmitMessage(submitMessage);\n                $("#vxcp-ent-view-configs-message").empty();\n                this.messageService.setSuccessMessage(message.messageHeading, message.messageBody, {\n                    fadeOut: true,\n                    identifier: "#vxcp-ent-view-configs-message",\n                });\n            }\n            catch (e) {\n            }\n        });\n    }\n    validateConfig(configValues) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!this.validatorService.validateColor(configValues.diagramBackgroundColor)) {\n                return false;\n            }\n            const errorMessageViewerHeight = yield this.validatorService.validateViewerHeightInput(configValues.viewerHeight);\n            if (errorMessageViewerHeight) {\n                const $configViewerHeightError = $("#vxcp-ent-config-viewer-height-error");\n                $("#vxcp-ent-config-viewer-height-input").addClass("invalid");\n                $configViewerHeightError.text(errorMessageViewerHeight);\n                $configViewerHeightError.removeClass("vxcp-ent-hidden");\n                return false;\n            }\n            return true;\n        });\n    }\n    getValuesFromConfigDialog() {\n        const configElements = this.getConfigElements();\n        const showAnyLinks = configElements.showDmnLinksToggle.checked ||\n            configElements.showBpmnLinksToggle.checked ||\n            configElements.showDocumentationToggle.checked ||\n            configElements.showConfluencePageLinksToggle.checked ||\n            configElements.showConfluenceAttachmentLinksToggle.checked ||\n            configElements.showExternalContentLinksToggle.checked ||\n            configElements.showJiraIssueLinksToggle.checked ||\n            configElements.showMdfInstanceLinksToggle.checked;\n        const configElementValues = {\n            showAnyLinks,\n            showDocumentation: configElements.showDocumentationToggle.checked,\n            commentedSaving: configElements.commentedSavingToggle.checked,\n            showEmbeddedComments: configElements.showEmbeddedCommentsToggle.checked,\n            saveZoomPosition: configElements.saveZoomPositionToggle.checked,\n            showWelcomeScreen: configElements.showWelcomeScreenToggle.checked,\n            showConfluencePageLinks: configElements.showConfluencePageLinksToggle.checked,\n            showConfluenceAttachmentLinks: configElements.showConfluenceAttachmentLinksToggle.checked,\n            showMdfInstanceLinks: configElements.showMdfInstanceLinksToggle.checked,\n            showExternalContentLinks: configElements.showExternalContentLinksToggle.checked,\n            showBpmnLinks: configElements.showBpmnLinksToggle.checked,\n            showJiraIssueLinks: configElements.showJiraIssueLinksToggle.checked,\n            showDmnLinks: configElements.showDmnLinksToggle.checked,\n            showBpmnInTab: configElements.showBpmnInTabToggle.checked,\n            showAttachmentsInTab: configElements.showAttachmentsInTabToggle.checked,\n            showDmnInTab: configElements.showDmnInTabToggle.checked,\n            showJiraIssuesInTab: configElements.showJiraIssuesInTabToggle.checked,\n            enableCustomViewerHeight: configElements.enableCustomViewerHeightToggle.checked,\n            showMaximalHeight: configElements.showMaximalHeightToggle.checked,\n            showBpmnJsPanel: configElements.showBpmnJsPanelToggle.checked,\n            diagramBackgroundColor: configElements.diagramBackgroundColor.value,\n            viewerHeight: configElements.viewerHeightInput.value,\n            loadImageInViewer: configElements.loadImageInViewerDropdown.value,\n        };\n        return configElementValues;\n    }\n    getConfigElements() {\n        const configDialogElements = {\n            showDocumentationToggle: $("#vxcp-ent-config-show-documentation-toggle")[0],\n            commentedSavingToggle: $("#vxcp-ent-config-commented-saving-toggle")[0],\n            saveZoomPositionToggle: $("#vxcp-ent-config-save-zoom-position-toggle")[0],\n            showEmbeddedCommentsToggle: $("#vxcp-ent-config-show-embedded-comments-toggle")[0],\n            showWelcomeScreenToggle: $("#vxcp-ent-config-welcome-screen-toggle")[0],\n            showConfluencePageLinksToggle: $("#vxcp-ent-config-show-confluence-page-links-toggle")[0],\n            showConfluenceAttachmentLinksToggle: $("#vxcp-ent-config-show-confluence-attachment-links-toggle")[0],\n            showExternalContentLinksToggle: $("#vxcp-ent-config-show-external-content-links-toggle")[0],\n            showJiraIssueLinksToggle: $("#vxcp-ent-config-show-jira-issue-links-toggle")[0],\n            showBpmnLinksToggle: $("#vxcp-ent-config-show-bpmn-links-toggle")[0],\n            showDmnLinksToggle: $("#vxcp-ent-config-show-dmn-links-toggle")[0],\n            showMdfInstanceLinksToggle: $("#vxcp-ent-config-show-mdf-instance-links-toggle")[0],\n            showBpmnInTabToggle: $("#vxcp-ent-config-open-bpmn-link-tab-toggle")[0],\n            showAttachmentsInTabToggle: $("#vxcp-ent-config-open-attachment-link-tab-toggle")[0],\n            showDmnInTabToggle: $("#vxcp-ent-config-open-dmn-link-tab-toggle")[0],\n            showJiraIssuesInTabToggle: $("#vxcp-ent-config-open-jira-issue-link-tab-toggle")[0],\n            showMaximalHeightToggle: $("#vxcp-ent-config-max-viewer-height-toggle")[0],\n            enableCustomViewerHeightToggle: $("#vxcp-ent-config-custom-viewer-height-toggle")[0],\n            showBpmnJsPanelToggle: $("#vxcp-ent-config-show-bpmn-js-panel-toggle")[0],\n            viewerHeightInput: $("#vxcp-ent-config-viewer-height-input")[0],\n            diagramBackgroundColor: $("#vxcp-ent-config-background-color-input")[0],\n            loadImageInViewerDropdown: $("#vxcp-ent-config-load-image-in-viewer-dropdown")[0],\n            viewerHeightErrorMessage: $("#vxcp-ent-config-viewer-height-error")[0],\n        };\n        return configDialogElements;\n    }\n    getConfigSubmitMessage(submitMessage) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let messageHeading;\n            let messageBody;\n            if (submitMessage) {\n                messageHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.saveDiagram.success.title");\n                messageBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.saveDiagram.success.body");\n            }\n            else {\n                messageHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.config-reset.success.title");\n                messageBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.config-reset.success.body");\n            }\n            return { messageHeading, messageBody };\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/admin/global-diagram-config.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/admin/linter-config.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "E": () => (/* binding */ LinterConfigService)\n/* harmony export */ });\nif ("bpmnEntSpaceAdminPage" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nif ("bpmnEntSpaceAdminPage" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\nclass LinterConfigService {\n    constructor(messageService, linterConfigRestService) {\n        this.messageService = messageService;\n        this.linterConfigRestService = linterConfigRestService;\n        this.pluginService = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_0__/* .getPluginService */ .j)();\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_0__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z(this.pluginService.getPluginName(), "LinterConfigService");\n    }\n    initLinterConfig() {\n        return __awaiter(this, void 0, void 0, function* () {\n            $("#vxcp-ent-space-config-linter-config-submit").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                yield this.submitLinterConfig();\n            }));\n            $("#vxcp-ent-space-config-linter-config-reset").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                yield this.resetLinterConfig();\n            }));\n        });\n    }\n    updateLinterConfigSelection(linterConfig) {\n        for (const validation in linterConfig) {\n            if (linterConfig.hasOwnProperty(validation)) {\n                $(`#vxcp-ent-space-config-linter-${validation}-dropdown`).val(linterConfig[validation]);\n            }\n        }\n    }\n    submitLinterConfig() {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const linterConfig = yield this.linterConfigRestService.updateLinterConfig(this.getLinterConfig());\n                this.updateLinterConfigSelection(linterConfig);\n                const messageTitle = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.saveDiagram.success.title");\n                const messageBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.saveDiagram.success.body");\n                this.messageService.setSuccessMessage(messageTitle, messageBody, { fadeOut: true, closeable: true, inForeground: true, identifier: "#vxcp-ent-space-config-linter-message-box" });\n                window.scrollTo(0, 0);\n            }\n            catch (e) {\n                this.vxcpLogger.logError("submitLinterConfig", "Error updating linter config", e);\n            }\n        });\n    }\n    resetLinterConfig() {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const linterConfig = yield this.linterConfigRestService.resetLinterConfig();\n                this.updateLinterConfigSelection(linterConfig);\n                const messageTitle = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.config-reset.success.title");\n                const messageBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.notification.config-reset.success.body");\n                this.messageService.setSuccessMessage(messageTitle, messageBody, { fadeOut: true, closeable: true, inForeground: true, identifier: "#vxcp-ent-space-config-linter-message-box" });\n                window.scrollTo(0, 0);\n            }\n            catch (e) {\n                this.vxcpLogger.logError("resetLinterConfig", "Error resetting linter config", e);\n            }\n        });\n    }\n    getLinterConfig() {\n        const config = {};\n        const $validationSelections = $(".vxcp-ent-space-config-linter-validation-select");\n        $validationSelections.each((index, element) => {\n            const $validationSelection = $(element);\n            const validation = $validationSelection.attr("validation-key");\n            if (validation) {\n                config[validation] = $validationSelection.val();\n            }\n        });\n        return config;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/admin/linter-config.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/admin/macro-migration.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Q": () => (/* binding */ MacroMigrationService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_app_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-type.enum.ts");\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/warning-dialog-type.enum.ts");\n/* harmony import */ var _model_enum_message_type_enum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/message-type.enum.ts");\nif ("bpmnEntAdmin" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nif ("bpmnEntAdmin" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\nclass MacroMigrationService {\n    constructor(pluginService, upgradeService, spinnerService, messageService) {\n        this.pluginService = pluginService;\n        this.upgradeService = upgradeService;\n        this.spinnerService = spinnerService;\n        this.messageService = messageService;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.progressStatus = [];\n        this.$migrateAllCheckbox = $("#vxcp-ent-migration-all-pages-checkbox");\n        this.$migratePageCheckbox = $("#vxcp-ent-migration-one-page-checkbox");\n        this.$migrateSpaceCheckbox = $("#vxcp-ent-migration-one-space-checkbox");\n        this.$pageIdInput = $("#vxcp-ent-migration-one-page-input");\n        this.$spaceKeyInput = $("#vxcp-ent-migration-one-space-input");\n        this.$startAnalysisBtn = $("#vxcp-ent-migration-input-analysis");\n        this.$startMigrationBtn = $("#vxcp-ent-migration-input-start");\n        this.progressBarId = "#vxcp-ent-spinner-status";\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z(this.pluginService.getPluginName(), "MacroMigrationService");\n        this.pluginShorthand = this.pluginService.getPluginShorthand();\n    }\n    isCloudApp() {\n        return this.platformUtils.isCloudApp();\n    }\n    initMacroMigration() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.isCloudApp()) {\n                return;\n            }\n            const checkUpgradeStatus = (request) => {\n                setTimeout(() => __awaiter(this, void 0, void 0, function* () {\n                    if (!request.status || !request.response) {\n                        this.vxcpLogger.logInfo("checkUpgradeStatus", "Status request included no information, waiting for next check.");\n                        checkUpgradeStatus(request);\n                        return;\n                    }\n                    let upgradeTask;\n                    try {\n                        upgradeTask = JSON.parse(request.response);\n                        if (upgradeTask.results && upgradeTask.results.length) {\n                            upgradeTask.results.forEach((task) => {\n                                if (task.name.translation === "viadee.upgrade.task") {\n                                    upgradeTask = task;\n                                }\n                            });\n                        }\n                    }\n                    catch (e) {\n                        this.vxcpLogger.logWarning("checkUpgradeStatus", "An error occurred while checking for status of upgrading free macros.", e);\n                        this.hideProgressSpinner();\n                        yield this.prepareAndShowUpgradeMessage(request.response);\n                    }\n                    const percentageComplete = upgradeTask.percentageComplete ? upgradeTask.percentageComplete / 100 : 0;\n                    this.platformUtils.updateProgress(this.progressBarId, percentageComplete, upgradeTask.elapsedTime);\n                    const upgradeMessages = upgradeTask.messages;\n                    const upgradeData = upgradeMessages && upgradeMessages.length ? upgradeTask.messages[0].translation : "";\n                    if (upgradeTask.successful && upgradeTask.percentageComplete >= 100) {\n                        setTimeout(() => __awaiter(this, void 0, void 0, function* () {\n                            this.hideProgressSpinner();\n                            yield this.prepareAndShowUpgradeMessage(upgradeData);\n                        }), 2000);\n                    }\n                    else if (!upgradeTask.successful) {\n                        setTimeout(() => __awaiter(this, void 0, void 0, function* () {\n                            this.hideProgressSpinner();\n                            yield this.prepareAndShowUpgradeMessage(upgradeData);\n                        }), 2000);\n                    }\n                    else {\n                        setTimeout(() => __awaiter(this, void 0, void 0, function* () {\n                            yield this.showAbortIfUpgradeIsStuck(upgradeData);\n                            const statusRequest = this.upgradeService.getUpgradeProgress(upgradeTask.id);\n                            statusRequest.onload = () => {\n                                checkUpgradeStatus(statusRequest);\n                            };\n                            statusRequest.onerror = (error) => __awaiter(this, void 0, void 0, function* () {\n                                this.vxcpLogger.logWarning("checkUpgradeStatus", "An error occurred while checking for status of upgrading free bpmn macros.", error);\n                                this.hideProgressSpinner();\n                                yield this.prepareAndShowUpgradeMessage(upgradeData);\n                            });\n                        }), 3000);\n                    }\n                }), 500);\n            };\n            const stillRunningTaskId = (yield this.upgradeService.getRunningTaskId(true));\n            if (stillRunningTaskId) {\n                this.showProgressSpinner();\n                const runningTaskRequest = this.upgradeService.getUpgradeProgress(stillRunningTaskId);\n                runningTaskRequest.onload = () => {\n                    checkUpgradeStatus(runningTaskRequest);\n                };\n            }\n            if (this.platformUtils.getAppType() !== _model_enum_app_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AppTypeEnum.CLOUD_ENTERPRISE */ .K.CLOUD_ENTERPRISE) {\n                Confluence.Binder.autocompletePage($("#vxcp-ent-migration-one-page-autocomplete-binder"));\n                Confluence.Binder.autocompleteSpace($("#vxcp-ent-migration-one-space-autocomplete-binder"));\n            }\n            let selectedPageId;\n            let selectedSpaceKey;\n            this.$pageIdInput.on({\n                "selected.autocomplete-content": (event, params) => {\n                    event.stopPropagation();\n                    event.preventDefault();\n                    selectedPageId = params.content.id;\n                },\n            });\n            this.$spaceKeyInput.on({\n                "selected.autocomplete-content": (event, params) => {\n                    event.stopPropagation();\n                    event.preventDefault();\n                    selectedSpaceKey = params.content.key;\n                },\n            });\n            this.$startAnalysisBtn.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                yield this.showAnalysisDialog();\n            }));\n            this.$startMigrationBtn.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                if (this.$startMigrationBtn.hasClass("loading")) {\n                    return;\n                }\n                this.$spaceKeyInput.removeClass("invalid");\n                this.$pageIdInput.removeClass("invalid");\n                this.platformUtils.clearMessageBar();\n                const isAllChecked = this.$migrateAllCheckbox.prop("checked");\n                const isPageChecked = isAllChecked ? null : this.$migratePageCheckbox.prop("checked");\n                const isSpaceChecked = isAllChecked ? null : this.$migrateSpaceCheckbox.prop("checked");\n                const pageId = isPageChecked ? selectedPageId : null;\n                const spaceKey = isSpaceChecked ? selectedSpaceKey : null;\n                if (!(isPageChecked || isSpaceChecked || isAllChecked)) {\n                    const heading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.error");\n                    const body = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.error.nothing-checked");\n                    this.messageService.setErrorMessage(heading, body);\n                    return;\n                }\n                else if (isSpaceChecked && !spaceKey) {\n                    const heading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.error");\n                    const body = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.error.no-space-key", this.pluginShorthand);\n                    this.messageService.setErrorMessage(heading, body);\n                    this.$spaceKeyInput.addClass("invalid");\n                    return;\n                }\n                else if (isPageChecked && !pageId) {\n                    const heading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.error");\n                    const body = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.error.no-page-id", this.pluginShorthand);\n                    this.messageService.setErrorMessage(heading, body);\n                    this.$pageIdInput.addClass("invalid");\n                    return;\n                }\n                let requestUrl = "upgradeAllMacros";\n                requestUrl = isSpaceChecked ? `upgradeMacrosInSpace` : requestUrl;\n                requestUrl = isPageChecked ? `upgradeMacrosOnPage` : requestUrl;\n                const additionalDesc = yield this.platformUtils.getText(`de.viadee.confluence.viadee-plugin-enterprise.warning-dialog.start-migration.additional-desc`, this.pluginShorthand);\n                const resetInfo = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.warning-dialog.start-migration.reset-info", this.pluginShorthand);\n                const backupInfo = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.warning-dialog.start-migration.backup-info");\n                const $additionalDesc = $("<p>").text(additionalDesc);\n                const $additionalContentBackupInfo = $("<div>").addClass("aui-message aui-message-error");\n                $("<h4>").text(backupInfo).appendTo($additionalContentBackupInfo);\n                let $additionalContent = $additionalDesc.add($additionalContentBackupInfo);\n                const $additionalContentResetInfo = $("<div>").addClass("aui-message aui-message-info").text(resetInfo);\n                $additionalContent = $additionalContent.add($additionalContentResetInfo);\n                if (yield (0,_utils_utils__WEBPACK_IMPORTED_MODULE_1__.confirmWarningDialog)(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .WarningDialogTypeEnum.START_MIGRATION */ .K.START_MIGRATION, $additionalContent)) {\n                    const upgradeLoadingText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.loading");\n                    this.showProgressSpinner(upgradeLoadingText);\n                    const contentKey = pageId ? pageId : spaceKey ? spaceKey : "";\n                    const upgradeRequest = yield this.upgradeService.startUpgradeTask(requestUrl, contentKey);\n                    upgradeRequest.onload = () => {\n                        this.progressStatus = [];\n                        checkUpgradeStatus(upgradeRequest);\n                    };\n                    upgradeRequest.onerror = (error) => __awaiter(this, void 0, void 0, function* () {\n                        this.vxcpLogger.logWarning("$startMigrationBtn", "An error occurred while processing the upgrade Request. Stopping further upgrades and showing current status.", error);\n                        const upgradeTask = JSON.parse(upgradeRequest.response);\n                        const upgradeMessages = upgradeTask.messages;\n                        const upgradeData = upgradeMessages && upgradeMessages.length ? upgradeTask.messages[0].translation : "";\n                        yield this.prepareAndShowUpgradeMessage(upgradeData);\n                        this.hideProgressSpinner();\n                    });\n                }\n                else {\n                    this.$startMigrationBtn.removeClass("loading");\n                }\n                return;\n            }));\n            const freePluginKey = this.pluginService.getFreePluginKey();\n            const restUrl = this.platformUtils.buildRestUrl(`/rest/plugins/1.0/${freePluginKey}-key/`);\n            try {\n                const freePluginInformation = yield $.ajax({\n                    method: "GET",\n                    url: restUrl,\n                });\n                const freePluginVersionString = freePluginInformation.version;\n                const freePluginVersionStringArray = freePluginVersionString.split(".", 3);\n                const freePluginVersionUpToDate = this.pluginService.getFreePluginVersionUpToDate();\n                const upgradePossible = this.upgradeService.checkFreeMacroVersionsBeforeMigration(freePluginVersionStringArray, freePluginVersionUpToDate);\n                if (!upgradePossible) {\n                    const headerFreeVersionOutdated = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.free-version-outdated.header", this.pluginShorthand);\n                    const bodyFreeVersionOutdated = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.free-version-outdated.body", this.pluginShorthand);\n                    this.messageService.setWarningMessage(headerFreeVersionOutdated, bodyFreeVersionOutdated);\n                }\n            }\n            catch (e) {\n            }\n        });\n    }\n    showProgressSpinner(alternativeLoadingText) {\n        this.$startMigrationBtn.addClass("loading");\n        this.$startAnalysisBtn.addClass("loading");\n        $("#vxcp-ent-spinner-timeout-abort").remove();\n        this.platformUtils.updateProgress(this.progressBarId, 0);\n        this.spinnerService.show(alternativeLoadingText);\n        window.onbeforeunload = (event) => __awaiter(this, void 0, void 0, function* () {\n            const leaveText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.exit-warning-dialog.desc");\n            event.returnValue = leaveText;\n            return leaveText;\n        });\n    }\n    hideProgressSpinner() {\n        this.$startMigrationBtn.removeClass("loading");\n        this.$startAnalysisBtn.removeClass("loading");\n        this.spinnerService.hide();\n        this.platformUtils.updateProgress(this.progressBarId, 0);\n        window.onbeforeunload = () => {\n            return;\n        };\n    }\n    showAbortIfUpgradeIsStuck(upgradeData) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const upgradeStats = JSON.parse(upgradeData);\n                this.progressStatus.push(upgradeStats.macroCounter);\n                if (this.progressStatus.length > 9) {\n                    const firstStatus = this.progressStatus.shift();\n                    if (firstStatus === upgradeStats.macroCounter) {\n                        const $abortLink = $("#vxcp-ent-spinner-timeout-abort");\n                        if (!$abortLink.length) {\n                            const abortText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.loading.abort-text");\n                            const abortLinkText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.loading.abort-link");\n                            $("#vxcp-ent-spinner").append(`<div id="vxcp-ent-spinner-timeout-abort">\n                                    ${abortText}\n                                    <a id="vxcp-ent-spinner-abort-task">${abortLinkText}</a>\n                                </div>`);\n                            $("#vxcp-ent-spinner-abort-task").on("click", () => __awaiter(this, void 0, void 0, function* () {\n                                this.vxcpLogger.logInfo("showAbortIfUpgradeIsStuck", "Killing running upgrade task as requested.");\n                                yield this.upgradeService.killAllRunningTasks();\n                                this.hideProgressSpinner();\n                                this.messageService.setSuccessMessage("Running upgrade tasks successfully aborted", "All upgrade tasks, which were still running were successfully aborted.");\n                            }));\n                        }\n                    }\n                }\n            }\n            catch (e) {\n                return;\n            }\n        });\n    }\n    prepareAndShowUpgradeMessage(upgradeData) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let messageHeading = "";\n            let messageBody = "";\n            try {\n                const upgradeStats = JSON.parse(upgradeData);\n                const beforeStatsText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.stats.desc-before");\n                const diagramsText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.stats.diagrams");\n                const pagesText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.stats.pages");\n                const spacesText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.stats.spaces");\n                const afterStatsText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.stats.desc-after", this.pluginShorthand);\n                let messageType = _model_enum_message_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .MessageTypeEnum.SUCCESS */ .D.SUCCESS;\n                if ((upgradeStats.errorMessages && upgradeStats.errorMessages.length) || (upgradeStats.exceptionMessages && upgradeStats.exceptionMessages.length)) {\n                    messageType = _model_enum_message_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .MessageTypeEnum.ERROR */ .D.ERROR;\n                }\n                else if (!upgradeStats.macroCounter) {\n                    messageType = _model_enum_message_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .MessageTypeEnum.WARNING */ .D.WARNING;\n                }\n                switch (messageType) {\n                    case _model_enum_message_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .MessageTypeEnum.SUCCESS */ .D.SUCCESS:\n                        messageHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.success");\n                        const successText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.success.desc", this.pluginShorthand);\n                        messageBody = `<p>${successText}</p><hr>\n                        <p>${beforeStatsText}</p>\n                        <ul>\n                            <li>${upgradeStats.macroCounter} ${diagramsText}</li>\n                            <li>${upgradeStats.pageCounter} ${pagesText}</li>\n                            <li>${upgradeStats.spaceCounter} ${spacesText}</li>\n                        </ul>\n                        <p>${afterStatsText}</p>`;\n                        this.messageService.setSuccessMessage(messageHeading, messageBody);\n                        break;\n                    case _model_enum_message_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .MessageTypeEnum.WARNING */ .D.WARNING:\n                        messageHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.no-macros", this.pluginShorthand);\n                        messageBody = `<p>${yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.no-macros.desc", this.pluginShorthand)}</p>`;\n                        this.messageService.setWarningMessage(messageHeading, messageBody);\n                        break;\n                    case _model_enum_message_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .MessageTypeEnum.ERROR */ .D.ERROR:\n                        messageHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.error");\n                        const errorText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.error.desc", this.pluginShorthand);\n                        const errorText3 = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.error.desc2", this.pluginShorthand);\n                        const errorText2 = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.error.desc3");\n                        let errorListHtml = "";\n                        upgradeStats.errorMessages.forEach((errMessage) => {\n                            errorListHtml = errorListHtml.concat(`<li>${errMessage}</li>`);\n                        });\n                        upgradeStats.exceptionMessages.forEach((exceptMessage) => {\n                            errorListHtml = errorListHtml.concat(`<li>${exceptMessage}</li>`);\n                        });\n                        messageBody = `<p>${errorText} <br>${errorText3}</p>\n                        <hr>\n                        <p>${beforeStatsText}</p>\n                        <ul>\n                            <li>${upgradeStats.macroCounter} ${diagramsText}</li>\n                            <li>${upgradeStats.pageCounter} ${pagesText}</li>\n                            <li>${upgradeStats.spaceCounter} ${spacesText}</li>\n                        </ul>\n                        <p>${afterStatsText}</p>\n                        <hr>\n                        <p>${errorText2}</p>\n                        <ul>\n                            ${errorListHtml}\n                        </ul>`;\n                        this.messageService.setErrorMessage(messageHeading, messageBody);\n                        break;\n                    default:\n                        this.vxcpLogger.logError("prepareAndShowUpgradeMessage", `Missing messageType! Got ${messageType}. As developer please verifier given parameter.`);\n                        break;\n                }\n            }\n            catch (e) {\n                const statusText = upgradeData;\n                if (statusText && statusText.includes("successful")) {\n                    messageHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.success");\n                    const successText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.success.desc");\n                    messageBody = `<p>${successText}</p>`;\n                    this.messageService.setSuccessMessage(messageHeading, messageBody);\n                }\n                else {\n                    messageHeading = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.error");\n                    const errorText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.message.error.desc", this.pluginShorthand);\n                    messageBody = `<p>${errorText}</p>`;\n                    this.messageService.setErrorMessage(messageHeading, messageBody);\n                }\n            }\n        });\n    }\n    showAnalysisDialog() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const analysisLoadingText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.migration.loading-analysis");\n            this.showProgressSpinner(analysisLoadingText);\n            const analysisRequest = this.upgradeService.startAnalysis();\n            analysisRequest\n                .then((analysisData) => __awaiter(this, void 0, void 0, function* () {\n                const contextPath = yield this.platformUtils.getContextPath();\n                const templateData = Object.assign({\n                    pluginShorthand: this.pluginShorthand,\n                    contextPath,\n                }, analysisData);\n                this.platformUtils.updateProgress(this.progressBarId, 1);\n                setTimeout(() => __awaiter(this, void 0, void 0, function* () {\n                    this.hideProgressSpinner();\n                    const analysisDialog = yield this.platformUtils.getTemplate(_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_4__/* .TemplateNamesEnum.PLUGIN_ANALYSIS_DIALOG */ .X.PLUGIN_ANALYSIS_DIALOG, templateData);\n                    const dialogId = "#vxcp-ent-plugin-analysis-dialog";\n                    const $analysisDialog = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_1__.showDialogFromTemplateStringAndInitButtons)(dialogId, analysisDialog, true, true);\n                    const $dataTable = $analysisDialog.find("#vxcp-ent-plugin-analysis-dialog-table");\n                    this.platformUtils.setTableSortable($dataTable);\n                    const $checkboxFree = $analysisDialog.find("#vxcp-ent-plugin-analysis-dialog-show-free-pages");\n                    $checkboxFree.on("click", () => {\n                        if ($checkboxFree.prop("checked")) {\n                            $analysisDialog.find(".vxcp-ent-plugin-analysis-page-free").show();\n                        }\n                        else {\n                            $analysisDialog.find(".vxcp-ent-plugin-analysis-page-free").hide();\n                        }\n                    });\n                    const $checkboxEnt = $analysisDialog.find("#vxcp-ent-plugin-analysis-dialog-show-ent-pages");\n                    $checkboxEnt.on("click", () => {\n                        if ($checkboxEnt.prop("checked")) {\n                            $analysisDialog.find(".vxcp-ent-plugin-analysis-page-ent").show();\n                        }\n                        else {\n                            $analysisDialog.find(".vxcp-ent-plugin-analysis-page-ent").hide();\n                        }\n                    });\n                    const $continueBtn = $analysisDialog.find(`${dialogId}-continue`);\n                    $continueBtn.on("click", () => __awaiter(this, void 0, void 0, function* () {\n                        yield this.showAnalysisDialog();\n                    }));\n                }), 500);\n            }))\n                .catch((error) => {\n                this.vxcpLogger.logError("showAnalysisDialog", "An error occurred while analysing all confluence content. The analysis failed. Please try again or get in contact with viadee Unternehmensberatung AG", error);\n                this.platformUtils.updateProgress(this.progressBarId, 1);\n                setTimeout(() => {\n                    this.messageService.setErrorMessage("Analysis failed", "The analysis failed. Please try again or get in contact with viadee Unternehmensberatung AG.");\n                    this.hideProgressSpinner();\n                }, 500);\n            });\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/admin/macro-migration.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/admin/whitelist-spaces.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "$": () => (/* binding */ WhitelistSpacesService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_app_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-type.enum.ts");\nif ("bpmnEntAdmin" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nif ("bpmnEntAdmin" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\nclass WhitelistSpacesService {\n    constructor(languageRestService, pluginService, messageService) {\n        this.languageRestService = languageRestService;\n        this.pluginService = pluginService;\n        this.messageService = messageService;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z(this.pluginService.getPluginName(), "WhitelistSpacesService");\n    }\n    isCloudApp() {\n        return this.platformUtils.isCloudApp();\n    }\n    initWhitelistingSpaces() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.isCloudApp()) {\n                return;\n            }\n            const txtDelete = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.settings.configuration.spacename.delete");\n            const $submit = $("#vxcp-ent-whitelist-add-space-to-whitelist-submit");\n            $submit.prop("disabled", true);\n            const $input = $("#space-title-field");\n            const $messageBox = $("#vxcp-ent-modeler-messages");\n            const $tbody = $("#vxcp-ent-whitelist-table-body");\n            const $checkbox = $("#vxcp-ent-whitelist-enable-restriction-in-plugin");\n            const $formDiv = $("#vxcp-ent-whitelist-add-space-to-whitelist-form");\n            $formDiv.prop("hidden", true);\n            const appPathComponent = this.languageRestService.getPluginRestComponent();\n            const whitelistSpaceUrl = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/spaces`);\n            const globalSettingsUrl = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/settings`);\n            $input.bind("selected.autocomplete-content", () => {\n                if ($submit.prop("disabled")) {\n                    $submit.removeAttr("disabled");\n                }\n            });\n            $input.bind("change keydown keyup", (event) => {\n                const key = event.keyCode || event.charCode;\n                if (key === 8 || key === 46) {\n                    const inputLength = $input.val().length;\n                    if (inputLength <= 1) {\n                        $submit.prop("disabled", true);\n                    }\n                }\n            });\n            $checkbox.click((e) => {\n                const keyChecked = "checked";\n                const currentTarget = e.currentTarget;\n                try {\n                    const json = currentTarget[keyChecked] ? createSettingsJson(false) : createSettingsJson(true);\n                    $formDiv.prop("hidden", currentTarget[keyChecked]);\n                    if (!e.target[keyChecked]) {\n                        fetchAndDisplayWhitelistedSpaces();\n                    }\n                    updateSettings(json);\n                }\n                catch (error) {\n                    this.vxcpLogger.logError("$checkbox.click", "An error occurred while updating setting: Whitelist enabled/disabled. Setting will not be updated.", error);\n                }\n            });\n            const createSettingsJson = (value) => {\n                const restrictUsage = { restrict: value };\n                return JSON.stringify(restrictUsage);\n            };\n            const updateSettings = (settings) => {\n                $.ajax({\n                    cache: false,\n                    url: globalSettingsUrl,\n                    contentType: "application/json",\n                    type: "POST",\n                    data: settings,\n                });\n            };\n            $submit.click((event) => __awaiter(this, void 0, void 0, function* () {\n                event.preventDefault();\n                const json = yield createJsonFromInputField();\n                addSpaceByKey(json);\n                clearInputField();\n                $submit.prop("disabled", true);\n            }));\n            if (this.platformUtils.getAppType() !== _model_enum_app_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .AppTypeEnum.CLOUD_ENTERPRISE */ .K.CLOUD_ENTERPRISE) {\n                Confluence.Binder.autocompleteSpace($("#space-autocomplete-binder"));\n            }\n            const clearTableBody = () => {\n                $tbody.empty();\n            };\n            const clearInputField = () => {\n                $input.val("");\n            };\n            const trimWhiteSpaces = (input) => {\n                return input.trim();\n            };\n            const createJsonFromInputField = () => __awaiter(this, void 0, void 0, function* () {\n                const inputValue = $input.val().toString();\n                const spaceKey = trimWhiteSpaces(inputValue);\n                const whitelistedSpace = [];\n                const params = yield this.platformUtils.getParams();\n                whitelistedSpace.push({\n                    key: spaceKey,\n                    name: "",\n                    user: params.currentUserFullname,\n                    date: new Date().toJSON().slice(0, 10),\n                });\n                return JSON.stringify(whitelistedSpace);\n            });\n            const populateTableWithData = (data) => {\n                $.each(data, (i, space) => {\n                    $("<tr>")\n                        .append($("<td>").text(space.name), $(\'<td id="">\').text(space.key), $("<td>").text(space.user), $("<td>").text(space.date), $("<td>")\n                        .append(`<button class="aui-button">${txtDelete}</button>`)\n                        .on("click", ".aui-button", (event) => {\n                        event.preventDefault();\n                        const spaceKeyToDelete = $(event.target).parent().siblings().eq(1).text();\n                        deleteSpaceByKey(spaceKeyToDelete);\n                    }))\n                        .appendTo("#vxcp-ent-whitelist-spaces-table");\n                });\n            };\n            const fetchAndDisplayWhitelistedSpaces = () => {\n                $messageBox.empty();\n                $.ajax({\n                    cache: true,\n                    url: whitelistSpaceUrl,\n                    type: "GET",\n                })\n                    .done((data, status, xhr) => {\n                    if (xhr.status === 200) {\n                        clearTableBody();\n                        populateTableWithData(data);\n                    }\n                })\n                    .fail((jqXHR, textStatus) => {\n                    if (jqXHR.status === 404) {\n                        this.messageService.setErrorMessage("No Spaces enabled", "There are no spaces which are enabled for the bpmn-modeler plugin");\n                    }\n                    else {\n                        throw new Error("Some error happened. Please try again later");\n                    }\n                });\n            };\n            const deleteSpaceByKey = (spaceKey) => {\n                $.ajax({\n                    cache: false,\n                    url: whitelistSpaceUrl.concat("/").concat(spaceKey),\n                    type: "DELETE",\n                })\n                    .done((data, status, xhr) => {\n                    fetchAndDisplayWhitelistedSpaces();\n                })\n                    .fail((jqHXR, textStatus) => {\n                    fetchAndDisplayWhitelistedSpaces();\n                });\n            };\n            const addSpaceByKey = (json) => {\n                if (!json) {\n                    this.messageService.setErrorMessage("No Spaces", "You have to provide at least one space");\n                    return;\n                }\n                try {\n                    $.ajax({\n                        cache: false,\n                        url: whitelistSpaceUrl,\n                        type: "POST",\n                        contentType: "application/json",\n                        data: json,\n                    }).done(() => {\n                        fetchAndDisplayWhitelistedSpaces();\n                    });\n                }\n                catch (jqXHR) {\n                    if (jqXHR.status === 422) {\n                        this.messageService.setErrorMessage("Space already enabled", "This space is already enabled");\n                    }\n                }\n            };\n            $("th").click((e) => {\n                const table = $(e.target).parents("table").eq(0);\n                let rows = table\n                    .find("tr:gt(0)")\n                    .toArray()\n                    .sort(comparer($(e.target).index()));\n                const keyAsc = "asc";\n                e.target[keyAsc] = !e.target[keyAsc];\n                if (e.target[keyAsc]) {\n                    rows = rows.reverse();\n                }\n                for (const row of rows) {\n                    table.append(row);\n                }\n            });\n            const comparer = (index) => {\n                return (a, b) => {\n                    const valA = getCellValue(a, index);\n                    const valB = getCellValue(b, index);\n                    return $.isNumeric(valA) && $.isNumeric(valB) ? valA - valB : valA.localeCompare(valB);\n                };\n            };\n            const getCellValue = (row, index) => {\n                return $(row).children("td").eq(index).html();\n            };\n            if ($checkbox.prop("checked")) {\n                $formDiv.prop("hidden", true);\n            }\n            else {\n                fetchAndDisplayWhitelistedSpaces();\n                $formDiv.prop("hidden", false);\n            }\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/admin/whitelist-spaces.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/app-config.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "_": () => (/* binding */ AppConfigService)\n/* harmony export */ });\n/* harmony import */ var _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\nif (/^bpmnEnt(((NavigatedPrev|V)iewe|Edito)r|Admin|MacroDialog)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nif (/^bpmnEnt(((NavigatedPrev|V)iewe|Edito)r|Admin|MacroDialog)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\nclass AppConfigService {\n    constructor(platformUtils) {\n        this.platformUtils = platformUtils;\n        this.languageRestService = _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__/* .getLanguageRestService */ .GU();\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__/* .getPluginService */ .j)().getPluginName(), "AppConfigService");\n        const appPathComponent = this.languageRestService.getPluginRestComponent();\n        this.restPathComponent = `/rest/${appPathComponent}/1.0`;\n    }\n    updateGitlabAppConfig(restPathComponent, gitLabClientId, gitLabClientSecret, gitLabBaseUrl) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/gitlab/config`);\n            const data = { gitLabClientId, gitLabClientSecret, gitLabBaseUrl };\n            const headers = { "X-Atlassian-Token": "no-check" };\n            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n                yield this.platformUtils\n                    .makeRequest({\n                    url,\n                    headers,\n                    type: "PUT",\n                    contentType: "application/json",\n                    data: JSON.stringify(data),\n                    cache: false,\n                })\n                    .then((response) => {\n                    resolve(response);\n                })\n                    .catch((err) => {\n                    this.vxcpLogger.logError("updateGitlabAppConfig", "PUT request was rejected.", err);\n                    reject(err);\n                });\n            }));\n        });\n    }\n    updateGeneralConfig(showDocumentation, commentedSaving, saveZoomPosition, showEmbeddedComments, showWelcomeScreen) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/generalConfig/config`);\n            const data = { showDocumentation, commentedSaving, saveZoomPosition, showEmbeddedComments, showWelcomeScreen };\n            const headers = { "X-Atlassian-Token": "no-check" };\n            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n                yield this.platformUtils\n                    .makeRequest({\n                    url,\n                    headers,\n                    type: "PUT",\n                    contentType: "application/json",\n                    data: JSON.stringify(data),\n                    cache: false,\n                })\n                    .then((response) => {\n                    resolve(response);\n                })\n                    .catch((err) => {\n                    this.vxcpLogger.logError("updateGeneralConfig", "PUT request was rejected.", err);\n                    reject(err);\n                });\n            }));\n        });\n    }\n    updateLinkConfig(showConfluencePageLinks, showConfluenceAttachmentLinks, showExternalContentLinks, showBpmnLinks, showJiraIssueLinks, showDmnLinks, showBpmnInTab, showAttachmentsInTab, showDmnInTab, showJiraIssuesInTab, showMdfInstanceLinks, showAnyLinks) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/linkConfig/config`);\n            const data = {\n                showConfluencePageLinks,\n                showConfluenceAttachmentLinks,\n                showExternalContentLinks,\n                showBpmnLinks,\n                showJiraIssueLinks,\n                showDmnLinks,\n                showBpmnInTab,\n                showAttachmentsInTab,\n                showDmnInTab,\n                showJiraIssuesInTab,\n                showMdfInstanceLinks,\n                showAnyLinks,\n            };\n            const headers = { "X-Atlassian-Token": "no-check" };\n            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n                yield this.platformUtils\n                    .makeRequest({\n                    url,\n                    headers,\n                    type: "PUT",\n                    contentType: "application/json",\n                    data: JSON.stringify(data),\n                    cache: false,\n                })\n                    .then((response) => {\n                    resolve(response);\n                })\n                    .catch((err) => {\n                    this.vxcpLogger.logError("updateLinkConfig", "PUT request was rejected.", err);\n                    reject(err);\n                });\n            }));\n        });\n    }\n    getGitlabAppConfig(singleParam) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let url = "";\n            if (singleParam) {\n                url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/gitlab/config/${singleParam}`);\n            }\n            else {\n                url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/gitlab/config`);\n            }\n            const headers = { "X-Atlassian-Token": "no-check" };\n            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n                yield this.platformUtils\n                    .makeRequest({\n                    url,\n                    headers,\n                    method: "GET",\n                })\n                    .then((result) => {\n                    resolve(result);\n                })\n                    .catch((err) => {\n                    reject(err);\n                });\n            }));\n        });\n    }\n    updateViewConfig(diagramBackgroundColor, loadImageInViewer, showMaximalHeight, enableCustomViewerHeight, viewerHeight, showBpmnJsPanel) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/viewConfig/config`);\n            const data = {\n                diagramBackgroundColor,\n                loadImageInViewer,\n                showMaximalHeight,\n                enableCustomViewerHeight,\n                viewerHeight,\n                showBpmnJsPanel,\n            };\n            const headers = { "X-Atlassian-Token": "no-check" };\n            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n                yield this.platformUtils\n                    .makeRequest({\n                    url,\n                    headers,\n                    type: "PUT",\n                    contentType: "application/json",\n                    data: JSON.stringify(data),\n                    cache: false,\n                })\n                    .then((response) => {\n                    resolve(response);\n                })\n                    .catch((err) => {\n                    this.vxcpLogger.logError("updateViewConfig", "PUT request was rejected.", err);\n                    reject(err);\n                });\n            }));\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/app-config.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/attachments.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "L": () => (/* binding */ AttachmentService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/file-type.enum.ts");\n/* harmony import */ var _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\nif (/^bpmnEnt(((NavigatedPrev|V)iewe|Edito)r|Admin|MacroDialog)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nif (/^bpmnEnt(((NavigatedPrev|V)iewe|Edito)r|Admin|MacroDialog)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/node_modules/uuid/dist/esm-browser/v4.js");\n}\nif (/^bpmnEnt(((NavigatedPrev|V)iewe|Edito)r|Admin|MacroDialog)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\nclass AttachmentService {\n    constructor() {\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__/* .getPluginService */ .j)().getPluginName(), "AttachmentService");\n        this.languageRestService = _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_1__/* .getLanguageRestService */ .GU();\n    }\n    getAttachmentDataByFileName(pageId, attachmentName, restPathOverwrite) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let url = this.platformUtils.buildRestUrl(`/rest/api/content/${pageId}/child/attachment?start=0&filename=${attachmentName}&expand=version`);\n            if (restPathOverwrite) {\n                url = this.platformUtils.buildRestUrl(`${restPathOverwrite}`);\n            }\n            const attachmentList = yield this.platformUtils.makeRequest({\n                type: "GET",\n                url,\n            });\n            return attachmentList.results;\n        });\n    }\n    updateAttachmentById(attachmentId, file, fileName, pageId, comment, restPathOverwrite) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let url = this.platformUtils.buildRestUrl(`/rest/api/content/${pageId}/child/attachment/${attachmentId}/data`);\n            if (restPathOverwrite) {\n                url = this.platformUtils.buildRestUrl(`${restPathOverwrite}`);\n            }\n            const data = new FormData();\n            data.append("file", file, fileName);\n            if (comment) {\n                data.append("comment", comment);\n            }\n            data.append("minorEdit", "true");\n            const headers = {\n                "X-Atlassian-Token": "no-check",\n            };\n            const params = {\n                url,\n                type: "POST",\n                headers,\n                data,\n                processData: false,\n                contentType: false,\n            };\n            return this.platformUtils.makeRequest(params);\n        });\n    }\n    copyAllVersionsOfAttachment(fileType, sourcePageId, sourceFileName, targetPageId, targetFileName, copyPngSupported) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let latestVersionObj;\n            try {\n                latestVersionObj = yield this.getAttachmentVersion(sourceFileName.concat(fileType), sourcePageId);\n            }\n            catch (e) {\n                return;\n            }\n            const attachmentId = latestVersionObj.id;\n            const attachments = [];\n            for (let i = 1; i <= latestVersionObj.version; i = i + 1) {\n                const version = i.toString(10);\n                const attachment = yield this.copyVersionOfAttachment(version, attachmentId, fileType, sourcePageId, sourceFileName, targetPageId, targetFileName, copyPngSupported);\n                attachments.push(attachment);\n            }\n            return attachments;\n        });\n    }\n    copyLatestVersionOfAttachment(fileType, sourcePageId, sourceFileName, targetPageId, targetFileName, copyPngSupported) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let result;\n            try {\n                result = yield this.getAttachmentVersion(sourceFileName.concat(fileType), sourcePageId);\n            }\n            catch (e) {\n                return;\n            }\n            if (result.status === 404) {\n                this.vxcpLogger.logWarning("copyLatestVersionOfAttachment", `Could not find version for: ${targetPageId}, ${targetFileName}`);\n                return;\n            }\n            const attachmentId = result.id;\n            return yield this.copyVersionOfAttachment(result.version, attachmentId, fileType, sourcePageId, sourceFileName, targetPageId, targetFileName, copyPngSupported);\n        });\n    }\n    copyVersionOfAttachment(version, attachmentId, fileType, sourcePageId, sourceFileName, targetPageId, targetFileName, copyPngSupported = true) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = yield this.platformUtils.buildAttachmentDownloadURL(sourcePageId, sourceFileName.concat(fileType), version, attachmentId);\n            let opts = {};\n            if (fileType === _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FileTypeEnum.PNG */ .W.PNG && copyPngSupported) {\n                opts = {\n                    xhrFields: {\n                        responseType: "blob",\n                    },\n                };\n            }\n            try {\n                const data = yield this.makeGetRequest(url, opts);\n                const file = new Blob([data]);\n                return yield this.uploadAttachment(file, targetFileName.concat(fileType), targetPageId, "");\n            }\n            catch (e) {\n                if (e.status !== 404) {\n                    throw e;\n                }\n            }\n        });\n    }\n    uploadNewAttachment(file, fileName, pageId, comment) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`/rest/api/content/${pageId}/child/attachment`);\n            const data = new FormData();\n            data.append("file", file, fileName);\n            if (comment) {\n                data.append("comment", comment);\n            }\n            data.append("minorEdit", "true");\n            const headers = { "X-Atlassian-Token": "no-check" };\n            const params = {\n                url,\n                type: "POST",\n                headers,\n                data,\n                processData: false,\n                contentType: false,\n            };\n            return this.platformUtils.makeRequest(params);\n        });\n    }\n    makeGetRequest(url, opts) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const options = Object.assign({\n                type: "GET",\n                url,\n            }, opts);\n            return yield this.platformUtils.makeRequest(options);\n        });\n    }\n    getAllAttachmentAttributes(pageId, diagramNameWithFileType, currentVersion, attachmentId) {\n        const promises = [];\n        for (let version = 1; version <= currentVersion; version++) {\n            promises.push(this.getAttachmentAttribute(pageId, diagramNameWithFileType, String(version), attachmentId));\n        }\n        return Promise.all(promises);\n    }\n    getAttachmentHistoryRequest(attachmentId) {\n        return this.platformUtils.makeRequest({\n            url: this.platformUtils.buildRestUrl(`/rest/api/content/${attachmentId}/history`),\n            type: "GET",\n        });\n    }\n    uploadAttachment(file, fileName, pageId, comment) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const attachmentData = yield this.getAttachmentDataByFileName(pageId, fileName);\n                const attachmentId = attachmentData.length > 0 ? attachmentData[0].id : undefined;\n                if (attachmentId) {\n                    return yield this.updateAttachmentById(attachmentId, file, fileName, pageId, comment);\n                }\n                return yield this.uploadNewAttachment(file, fileName, pageId, comment);\n            }\n            catch (error) {\n                this.vxcpLogger.logError("uploadAttachment", `Failed uploading the attachment ${fileName}.`, error);\n                return Promise.reject(error);\n            }\n        });\n    }\n    renameAttachment(pageId, attachmentName, newAttachmentName, type) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!pageId || !attachmentName || !newAttachmentName) {\n                throw new Error("ERROR @attachments.service.renameAttachment: Missing pageId or attachment-Name or new AttachmentInterface-Name, please check input parameters!");\n            }\n            const newAttachmentNameTrimmed = newAttachmentName.trim();\n            const appPathComponent = this.languageRestService.getPluginRestComponent();\n            const uuid = (0,uuid__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)();\n            if (newAttachmentNameTrimmed.toUpperCase() === attachmentName.toUpperCase()) {\n                const placeholderAttachmentName = "placeholderAttachmentName" + uuid;\n                let url = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/attachmenthandler/rename?pageId=${pageId}&attachmentName=${attachmentName}${type}&newAttachmentName=${placeholderAttachmentName}${type}`);\n                yield this.platformUtils.makeRequest({\n                    cache: false,\n                    url,\n                    type: "GET",\n                });\n                url = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/attachmenthandler/rename?pageId=${pageId}&attachmentName=${placeholderAttachmentName}${type}&newAttachmentName=${newAttachmentNameTrimmed}${type}`);\n                yield this.platformUtils.makeRequest({\n                    cache: false,\n                    url,\n                    type: "GET",\n                });\n            }\n            else {\n                const url = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/attachmenthandler/rename?pageId=${pageId}&attachmentName=${attachmentName}${type}&newAttachmentName=${newAttachmentNameTrimmed}${type}`);\n                yield this.platformUtils.makeRequest({\n                    cache: false,\n                    url,\n                    type: "GET",\n                });\n            }\n        });\n    }\n    checkIfAttachmentNameAlreadyExistsAsBpmnOrPng(pageId, attachmentName, oldAttachmentName, fileType) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!pageId || !attachmentName) {\n                throw new Error("ERROR @checkIfAttachmentNameAlreadyExistsAsBpmnOrPng: Missing pageId or attachment-Name, please check input parameters!");\n            }\n            const urlXml = this.platformUtils.buildRestUrl(`/rest/api/content/${pageId}/child/attachment?start=0&filename=${attachmentName}${fileType}`);\n            const urlPng = this.platformUtils.buildRestUrl(`/rest/api/content/${pageId}/child/attachment?start=0&filename=${attachmentName}${_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FileTypeEnum.PNG */ .W.PNG}`);\n            if (attachmentName.toUpperCase() === oldAttachmentName.toUpperCase()) {\n                return false;\n            }\n            const resultsXml = yield this.platformUtils.makeRequest({\n                cache: false,\n                url: urlXml,\n                type: "GET",\n            });\n            const resultsPng = yield this.platformUtils.makeRequest({\n                cache: false,\n                url: urlPng,\n                type: "GET",\n            });\n            return resultsXml.length > 0 || resultsPng.length > 0;\n        });\n    }\n    loadAttachment(diagramName, diagramFileType, pageId, attachmentVersion = -1) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const diagramNameFileType = diagramName.concat(diagramFileType);\n                let version;\n                const attachmentData = yield this.getAttachmentDataByFileName(pageId, diagramNameFileType);\n                if (!attachmentData.length || attachmentVersion === 0) {\n                    return {\n                        status: 404,\n                        responseText: "Attachment not Found",\n                        attachmentFound: false,\n                    };\n                }\n                const attachmentId = attachmentData[0].id;\n                if (attachmentVersion > 0) {\n                    version = attachmentVersion;\n                }\n                else {\n                    version = attachmentData[0].version.number;\n                }\n                try {\n                    const url = yield this.platformUtils.buildAttachmentDownloadURL(pageId, diagramNameFileType, version, attachmentId);\n                    const data = yield this.makeGetRequest(url);\n                    return {\n                        data,\n                        id: attachmentId,\n                        version,\n                    };\n                }\n                catch (error) {\n                    return {\n                        status: 404,\n                        responseText: `specific version ${version} not found`,\n                        attachmentFound: true,\n                    };\n                }\n            }\n            catch (error) {\n                return error;\n            }\n        });\n    }\n    loadJsonFile(pageId, filename) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const attachmentData = yield this.getAttachmentDataByFileName(pageId, filename);\n            const attachmentId = attachmentData[0].id;\n            const version = attachmentData[0].version.number;\n            const url = yield this.platformUtils.buildAttachmentDownloadURL(pageId, filename, version, attachmentId);\n            return yield this.makeGetRequest(url);\n        });\n    }\n    loadAttachmentAttributes(pageId, diagramNameWithFileType, latestDiagramVersion, previousSelectedVersion, attachmentId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const dataArray = [];\n                const attachmentAttributes = yield this.getAllAttachmentAttributes(pageId, diagramNameWithFileType, latestDiagramVersion, attachmentId);\n                for (let i = attachmentAttributes.length - 1; i >= 0; i = i - 1) {\n                    if (attachmentAttributes[i]) {\n                        dataArray.push({\n                            version: attachmentAttributes[i].attachmentVersion,\n                            editor: attachmentAttributes[i].attachmentCreator,\n                            date: attachmentAttributes[i].attachmentDate,\n                            comment: attachmentAttributes[i].attachmentComment,\n                        });\n                    }\n                }\n                const currentShowingVersion = previousSelectedVersion || latestDiagramVersion;\n                return {\n                    versions: dataArray,\n                    current: currentShowingVersion,\n                };\n            }\n            catch (error) {\n                this.vxcpLogger.logError("loadAttachmentAttributes", "Attachment details could not be loaded.", error);\n            }\n        });\n    }\n    getDiagramVersionProperties(pageId, diagramName, fileType) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const diagramVersionPropertyKey = "de.viadee.modeler.bpmn";\n            const contentProperty = yield this.getContentProperty(pageId, diagramName, fileType, diagramVersionPropertyKey);\n            return new Promise((resolve, reject) => {\n                resolve(contentProperty.value);\n            });\n        });\n    }\n    getContentProperty(pageId, diagramName, fileType, propertyKey) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const attachmentDataByFileName = yield this.getAttachmentDataByFileName(pageId, diagramName + fileType);\n                const attachmentId = attachmentDataByFileName[0].id;\n                const attachmentProperty = this.platformUtils.buildRestUrl(`/rest/api/content/${attachmentId}/property/`);\n                const resultProperty = yield this.platformUtils.makeRequest({\n                    cache: false,\n                    url: attachmentProperty,\n                    type: "GET",\n                    dataType: "json",\n                    error: (xhr, statusText, errorThrown) => {\n                        const errorMessage = `Rest-Error for ${attachmentProperty}` + xhr + " " + statusText;\n                        this.vxcpLogger.logError("getContentProperty", errorMessage, errorThrown);\n                    },\n                });\n                for (const res of resultProperty.results) {\n                    if (res.key === propertyKey) {\n                        return res;\n                    }\n                }\n                return {\n                    key: propertyKey,\n                    value: [],\n                    version: {\n                        number: 0,\n                        minorEdit: false,\n                        hidden: false,\n                    },\n                };\n            }\n            catch (e) {\n                return {\n                    key: propertyKey,\n                    value: [],\n                    version: {\n                        number: 0,\n                        minorEdit: false,\n                        hidden: false,\n                    },\n                };\n            }\n        });\n    }\n    putContentProperty(pageId, diagramName, fileType, propertyKey, propertyValue) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const attachmentDataByFileName = yield this.getAttachmentDataByFileName(pageId, diagramName + fileType);\n            const attachmentId = attachmentDataByFileName[0].id;\n            const attachmentProperty = this.platformUtils.buildRestUrl(`/rest/api/content/${attachmentId}/property/${propertyKey}`);\n            const propertyValueJSONString = JSON.stringify(propertyValue);\n            yield this.platformUtils.makeRequest({\n                url: attachmentProperty,\n                type: "PUT",\n                contentType: "application/json",\n                data: propertyValueJSONString,\n                error: (xhr, statusText, errorThrown) => {\n                    const errorMessage = ` Rest-Error for ${attachmentProperty} with data ${propertyValueJSONString}` + xhr + " " + statusText;\n                    this.vxcpLogger.logError("putContentProperty", errorMessage, errorThrown);\n                },\n            });\n        });\n    }\n    getAttachmentVersion(name, pageId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const attachmentData = yield this.getAttachmentDataByFileName(pageId, name);\n            if (attachmentData.length) {\n                const attachmentId = attachmentData[0].id || "";\n                const attachmentVersion = attachmentData[0].version ? attachmentData[0].version.number : 0;\n                return {\n                    id: attachmentId,\n                    version: attachmentVersion,\n                };\n            }\n            else {\n                return {\n                    status: 404,\n                    responseText: "Attachment not Found",\n                };\n            }\n        });\n    }\n    getAttachmentAttribute(pageId, diagramNameWithFileType, version, attachmentId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const appPathComponent = this.languageRestService.getPluginRestComponent();\n                const url = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/attachments/versionData/${pageId}/${diagramNameWithFileType}/${version}/${attachmentId}`);\n                const attachmentVersionData = yield this.platformUtils.makeRequest({\n                    url,\n                    type: "GET",\n                    dataType: "json",\n                    error: (err) => __awaiter(this, void 0, void 0, function* () {\n                        this.vxcpLogger.logError("getAttachmentAttribute", `Rest-Error for ${url}`, err);\n                        return null;\n                    }),\n                });\n                const localDate = new Date(attachmentVersionData.date);\n                return {\n                    attachmentVersion: version,\n                    attachmentComment: attachmentVersionData.comment,\n                    attachmentCreator: attachmentVersionData.creator,\n                    attachmentDate: localDate.toLocaleString(),\n                };\n            }\n            catch (e) {\n                return null;\n            }\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/attachments.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/confluence-user-rest-api-util.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "getUserByUserKey": () => (/* binding */ getUserByUserKey)\n/* harmony export */ });\n/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\nconst platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_0__/* .getPlatformService */ .km)().getPlatformUtils() || {};\nconst getUserByUserKey = (confluenceUserKey) => __awaiter(void 0, void 0, void 0, function* () {\n    const restUrl = decodeURI(platformUtils.buildRestUrlForUserNameByKeyAccountId(confluenceUserKey));\n    try {\n        const user = yield platformUtils.makeRequest({\n            type: "GET",\n            url: restUrl,\n        });\n        user.userId = user.userKey || user.accountId || "unknown";\n        const userProfilePath = user.username ? `/display/~${user.username}` : `/people/${user.accountId}`;\n        user.url = platformUtils.buildRestUrl(userProfilePath);\n        return user;\n    }\n    catch (err) {\n        return {\n            displayName: "Unknown",\n            userId: confluenceUserKey,\n            username: "unknown",\n            url: "",\n        };\n    }\n});\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/confluence-user-rest-api-util.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/diagram-configuration.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "z": () => (/* binding */ DiagramConfigurationService)\n/* harmony export */ });\n/* harmony import */ var _attribute_panel_color_sync_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/color-sync.service.ts");\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/warning-dialog-type.enum.ts");\n/* harmony import */ var _utils_browser_factory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/browser.factory.ts");\n/* harmony import */ var _model_enum_browser_enum__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/browser.enum.ts");\n/* harmony import */ var _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/file-type.enum.ts");\n/* harmony import */ var _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\nif (/^bpmnEnt(((NavigatedPrev|V)iewe|Edito)r|MacroDialog)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nif (/^bpmnEnt(((NavigatedPrev|V)iewe|Edito)r|MacroDialog)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _routing_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/routing.service.ts");\n/* harmony import */ var _model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\nclass DiagramConfigurationService {\n    constructor(validatorService, gitLabRestService, bitbucketRestService, attachmentService, messageService, managedDataFieldsService) {\n        this.validatorService = validatorService;\n        this.gitLabRestService = gitLabRestService;\n        this.bitbucketRestService = bitbucketRestService;\n        this.attachmentService = attachmentService;\n        this.messageService = messageService;\n        this.managedDataFieldsService = managedDataFieldsService;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_9__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.colorSyncService = new _attribute_panel_color_sync_service__WEBPACK_IMPORTED_MODULE_0__/* .ColorSyncService */ .q(this.validatorService);\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_9__/* .getPluginService */ .j)().getPluginName(), "ConfigurationService");\n        this.languageRestService = _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_6__/* .getLanguageRestService */ .GU();\n        const appPathComponent = this.languageRestService.getPluginRestComponent();\n        this.configBaseUrl = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/configuration/`);\n        this.browserService = _utils_browser_factory__WEBPACK_IMPORTED_MODULE_3__/* .getBrowserService */ .i();\n    }\n    getDefaultConfigs() {\n        return {\n            showConfluencePageLinks: true,\n            showDocumentation: true,\n            showDmnLinks: true,\n            showBpmnLinks: true,\n            showJiraIssueLinks: true,\n            showMdfInstanceLinks: true,\n            showAnyLinks: true,\n            showBpmnJsPanel: true,\n            showExternalContentLinks: true,\n            showConfluenceAttachmentLinks: true,\n            commentedSaving: false,\n            diagramBackgroundColor: "#ffffff",\n            diagramName: "",\n            enableCustomViewerHeight: false,\n            viewerHeight: "250",\n            showMaximalHeight: false,\n            showBpmnInTab: false,\n            showAttachmentsInTab: false,\n            showDmnInTab: false,\n            showJiraIssuesInTab: false,\n            showEmbeddedComments: true,\n            loadImageInViewer: "model",\n            saveZoomPosition: false,\n            shownAttachmentVersion: "",\n            gitLabRepoUrl: "",\n            gitLabBranchName: "",\n            gitLabTagName: "",\n            gitLabProjectId: "",\n            gitLabFilePath: "",\n            gitLabCommitId: "",\n            bitbucketCommitId: "",\n            bitbucketRepoUrl: "",\n            bitbucketRepoSlug: "",\n            bitbucketBranchName: "",\n            bitbucketTagName: "",\n            bitbucketProjectKey: "",\n            bitbucketFilePath: "",\n        };\n    }\n    getAllConfigsForXmlType(pageId, vbcpEntId, macroKeyForConfigs) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const getConfigsUrl = `${pageId}/getConfig/${vbcpEntId}/${macroKeyForConfigs}`;\n            const configs = yield this.platformUtils.makeRequest({\n                cache: false,\n                url: this.configBaseUrl + getConfigsUrl,\n                type: "GET",\n                dataType: "json",\n            });\n            try {\n                configs.gitLabRepoUrl = yield this.gitLabRestService.getGitlabAppConfig("gitLabBaseUrl");\n            }\n            catch (e) {\n                configs.gitLabRepoUrl = "";\n            }\n            return configs;\n        });\n    }\n    getAllConfigs(pageId, vbcpEntId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const macroKeyForConfigs = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_9__/* .getPluginService */ .j)().getMacroName();\n            return yield this.getAllConfigsForXmlType(pageId, vbcpEntId, macroKeyForConfigs);\n        });\n    }\n    getAllConfigsByMacroId(pageId, macroId, macroKeyForConfigs) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const getConfigsUrl = `${pageId}/getConfig/macroId/${macroId}/${macroKeyForConfigs}`;\n            const configs = yield this.platformUtils.makeRequest({\n                cache: false,\n                url: this.configBaseUrl + getConfigsUrl,\n                type: "GET",\n                dataType: "json",\n            });\n            try {\n                configs.gitLabRepoUrl = yield this.gitLabRestService.getGitlabAppConfig("gitLabBaseUrl");\n            }\n            catch (e) {\n                configs.gitLabRepoUrl = "";\n            }\n            return configs;\n        });\n    }\n    parseAllFromHtmlContentByVbcpEntId(htmlContent, macroName, vbcpEntId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const configValues = this.getDefaultConfigs();\n            const parser = new DOMParser();\n            const doc = parser.parseFromString(htmlContent, "text/html");\n            const macroNodes = Array.from(doc.querySelectorAll("img.editor-inline-macro"));\n            if (macroNodes.length === 0) {\n                return configValues;\n            }\n            const macro = macroNodes\n                .filter((node) => { var _a; return (_a = node.getAttribute("data-macro-name")) === null || _a === void 0 ? void 0 : _a.includes(macroName); })\n                .find((node) => { var _a; return (_a = node.getAttribute("data-macro-parameters")) === null || _a === void 0 ? void 0 : _a.includes(`vbcpEntId=${vbcpEntId}`); });\n            if (!macro) {\n                return configValues;\n            }\n            macro\n                .getAttribute("data-macro-parameters")\n                .split("|")\n                .map((keyValueStr) => {\n                const keyValueSlices = keyValueStr.split("=");\n                const key = keyValueSlices[0];\n                const value = keyValueSlices[1];\n                const defaultValue = configValues[key];\n                if (typeof defaultValue === "boolean") {\n                    return { key, value: value === "true" || !!parseInt(value) };\n                }\n                else if (typeof defaultValue === "number") {\n                    return { key, value: parseInt(value) };\n                }\n                return { key, value };\n            })\n                .forEach((pair) => (configValues[pair.key] = pair.value));\n            return configValues;\n        });\n    }\n    createDefaultConfigs(pageId, appPathComponent) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const configBaseUrl = appPathComponent ? this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/configuration/`) : this.configBaseUrl;\n            const getConfigsUrl = pageId + "/defaultConfigs/";\n            return yield this.platformUtils.makeRequest({\n                cache: false,\n                url: configBaseUrl + getConfigsUrl,\n                type: "GET",\n                dataType: "json",\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    if (err.status === 401) {\n                        const viewPagePath = `/pages/viewpage.action?pageId=${pageId}`;\n                        const viewPageUrl = this.platformUtils.buildRestUrl(viewPagePath);\n                        const $additionalContent = $("<p>");\n                        $("<a>", { href: viewPageUrl, target: "_blank", text: "Login" }).appendTo($additionalContent);\n                        yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.confirmWarningDialog(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .WarningDialogTypeEnum.SESSION_EXPIRED */ .K.SESSION_EXPIRED, $additionalContent);\n                    }\n                    else {\n                        const errorText = "REST-Error occurred while getting default configs from server.";\n                        this.vxcpLogger.logError("createDefaultConfigs", errorText, err);\n                        yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.showSystemErrorDialog(pageId, "ERROR @DiagramConfigurationService.createDefaultConfigs :" + errorText, err);\n                    }\n                }),\n            });\n        });\n    }\n    getSingleConfig(parameterKey, pageId, vbcpEntId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const getConfigsUrl = `${pageId}/getSingleConfig/${vbcpEntId}/${parameterKey}`;\n            return yield this.platformUtils.makeRequest({\n                cache: false,\n                url: this.configBaseUrl + getConfigsUrl,\n                type: "GET",\n                dataType: "json",\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    switch (err.status) {\n                        case 404:\n                            break;\n                        case 401:\n                            const viewPagePath = `/pages/viewpage.action?pageId=${pageId}`;\n                            const viewPageUrl = this.platformUtils.buildRestUrl(viewPagePath);\n                            const $additionalContent = $("<p>");\n                            $("<a>", { href: viewPageUrl, target: "_blank", text: "Login" }).appendTo($additionalContent);\n                            yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.confirmWarningDialog(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .WarningDialogTypeEnum.SESSION_EXPIRED */ .K.SESSION_EXPIRED, $additionalContent);\n                            break;\n                        default:\n                            const errorText = "REST-Error occurred while getting config-value from server.";\n                            this.vxcpLogger.logError("getSingleConfig", errorText);\n                            yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.showSystemErrorDialog(pageId, "ERROR @DiagramConfigurationService.getSingleConfig: " + errorText, err);\n                    }\n                }),\n            });\n        });\n    }\n    updateSingleConfig(parameterKey, pageId, vbcpEntId, newConfigValue, minorEdit = true) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let updateConfigsUrl = `${pageId}/updateConfig/${vbcpEntId}/${parameterKey}`;\n            if (minorEdit) {\n                updateConfigsUrl = `${updateConfigsUrl}?minorEdit=true`;\n            }\n            const dataToSend = {};\n            dataToSend[parameterKey] = newConfigValue;\n            return yield this.platformUtils.makeRequest({\n                cache: false,\n                url: this.configBaseUrl + updateConfigsUrl,\n                type: "POST",\n                data: JSON.stringify(dataToSend),\n                contentType: "application/json",\n                headers: { "X-Atlassian-Token": "no-check" },\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    if (parameterKey !== "attachmentIdBpmn") {\n                        const errorText = `REST-Error occurred while saving configs on the server for ${parameterKey}`;\n                        yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.showSystemErrorDialog(pageId, "ERROR @DiagramConfigurationService.updateSingleConfig: " + errorText, err);\n                    }\n                    return err;\n                }),\n            });\n        });\n    }\n    setVbcpEntId(pageId, macroId, macroKeyForConfigs) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const updateConfigsUrl = `${pageId}/setVbcpEntId/${macroId}/${macroKeyForConfigs}`;\n            return yield this.platformUtils.makeRequest({\n                cache: false,\n                url: this.configBaseUrl + updateConfigsUrl,\n                type: "GET",\n                dataType: "json",\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    const errorText = "REST-Error occurred while saving new vbcpEntId on the server";\n                    this.vxcpLogger.logError("setVbcpEntId", errorText, err);\n                    yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.showSystemErrorDialog(pageId, "ERROR @DiagramConfigurationService.setVbcpEntId: " + errorText, err);\n                }),\n            });\n        });\n    }\n    showConfigDialog(pageId, vbcpEntId, $canvas) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.platformUtils.removeDjsHelperSvg();\n            const configValues = yield this.getAllConfigs(pageId, vbcpEntId);\n            const confluenceParams = yield this.platformUtils.getParams();\n            const confluenceVersion = confluenceParams.versionNumber;\n            const isOldConfluence = confluenceVersion.substring(0, 3) < 5.9;\n            const pluginStandard = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_9__/* .getPluginService */ .j)().getPluginStandard();\n            const pluginShorthand = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_9__/* .getPluginService */ .j)().getPluginShorthand();\n            const appType = this.platformUtils.getAppType();\n            const macroConfigurationDialog = yield this.platformUtils.getTemplate(_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_8__/* .TemplateNamesEnum.MACRO_CONFIGURATION_DIALOG */ .X.MACRO_CONFIGURATION_DIALOG, {\n                isOldConfluence,\n                pluginStandard,\n                appType,\n                pluginShorthand,\n            });\n            $canvas.append(macroConfigurationDialog);\n            const dialogId = "#vxcp-ent-config-dialog";\n            const $configDialog = $(dialogId);\n            const $configForm = $configDialog.find("form");\n            const $configMenu = $configDialog.find(".vxcp-ent-dialog-menu-container");\n            const $configLoading = $configDialog.find("#loading");\n            const $diagramNameInput = $configDialog.find("#vxcp-ent-config-diagram-name-input");\n            const $viewerHeightInput = $configDialog.find("#vxcp-ent-config-viewer-height-input");\n            const $colorPicker = $configDialog.find("#vxcp-ent-config-background-color-color-picker");\n            const $noColorPickerWarning = $configDialog.find("#vxcp-ent-colorpicker-no-color-picker-warning");\n            const $continueBtn = $(dialogId + "-submit");\n            if (this.browserService.isBrowser([_model_enum_browser_enum__WEBPACK_IMPORTED_MODULE_4__/* .BrowserEnum.INTERNET_EXPLORER */ .p.INTERNET_EXPLORER])) {\n                $colorPicker.hide();\n                $noColorPickerWarning.show();\n            }\n            this.colorSyncService.init("#vxcp-ent-config-background-color-color-picker", "#vxcp-ent-config-background-color-input", "#vxcp-ent-diagram-background-color-error");\n            _utils_utils__WEBPACK_IMPORTED_MODULE_1__.initEscKey($("body"), $(dialogId + "-abort"));\n            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n                let actConfigs = configValues;\n                if (!actConfigs) {\n                    try {\n                        actConfigs = yield this.getAllConfigs(pageId, vbcpEntId);\n                    }\n                    catch (configError) {\n                        const errorText = "REST-Error occurred while getting configs from server.";\n                        this.vxcpLogger.logError("showConfigDialog", errorText, configError);\n                        yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.showSystemErrorDialog(pageId, "ERROR @DiagramConfigurationService.showConfigDialog: " + errorText, configError);\n                        reject(configError);\n                    }\n                }\n                $configLoading.hide();\n                $configMenu.show();\n                $configForm.show();\n                $continueBtn.removeAttr("disabled");\n                $diagramNameInput.val(actConfigs.diagramName);\n                this.colorSyncService.setColor(actConfigs.diagramBackgroundColor);\n                $viewerHeightInput.val(actConfigs.viewerHeight);\n                $viewerHeightInput.prop("disabled", !actConfigs.enableCustomViewerHeight);\n                const viewerHeightToggleId = "#vxcp-ent-config-custom-viewer-height-toggle";\n                const showMaxViewerHeightToggleId = "#vxcp-ent-config-max-viewer-height-toggle";\n                const $viewerHeightToggle = $(viewerHeightToggleId);\n                const $showMaxViewerHeightToggle = $(showMaxViewerHeightToggleId);\n                $viewerHeightToggle.on("click", (clickEvent) => {\n                    const clickedToggle = clickEvent.currentTarget;\n                    setTimeout(() => {\n                        $viewerHeightInput.prop("disabled", !clickedToggle.checked);\n                        $showMaxViewerHeightToggle.prop("checked", false);\n                    }, 0);\n                });\n                $showMaxViewerHeightToggle.on("click", (clickEvent) => {\n                    setTimeout(() => {\n                        $viewerHeightToggle.prop("checked", false);\n                        $viewerHeightInput.prop("disabled", true);\n                    }, 0);\n                });\n                this.preselectConfigValues(actConfigs, $configDialog);\n                this.platformUtils.showDialog(dialogId);\n                $configDialog.show();\n                const $submit = $configDialog.find(`${dialogId}-submit`);\n                const $abort = $configDialog.find(`${dialogId}-abort`);\n                _utils_utils__WEBPACK_IMPORTED_MODULE_1__.initEscKey($configDialog, $abort);\n                _utils_utils__WEBPACK_IMPORTED_MODULE_1__.initEnterKey($configDialog, $submit);\n                $abort.on("click", () => {\n                    this.platformUtils.hideDialog(dialogId);\n                });\n                this.platformUtils.getDialog(dialogId).on("hide", () => {\n                    $configDialog.remove();\n                });\n                resolve($configDialog);\n            }));\n        });\n    }\n    preselectConfigValues(actConfigs, $configDialog) {\n        const $showLoadImageInViewerDropDown = $configDialog.find("#vxcp-ent-config-load-image-in-viewer-dropdown");\n        const $gitlabRepoUrlInput = $configDialog.find("#vxcp-ent-gitlab-config-repo-url-input");\n        const $gitlabProjectIdInput = $configDialog.find("#vxcp-ent-gitlab-config-project-id-input");\n        const $gitlabBranchNameInput = $configDialog.find("#vxcp-ent-gitlab-config-branch-input");\n        const $gitlabTagNameInput = $configDialog.find("#vxcp-ent-gitlab-config-tag-input");\n        const $gitlabFilePathInput = $configDialog.find("#vxcp-ent-gitlab-config-file-path-input");\n        const showMaxViewerHeightToggleId = "#vxcp-ent-config-max-viewer-height-toggle";\n        const viewerHeightToggleId = "#vxcp-ent-config-custom-viewer-height-toggle";\n        const $bitbucketRepoUrlInput = $configDialog.find("#vxcp-ent-bitbucket-config-repo-url-input");\n        const $bitbucketProjectIdInput = $configDialog.find("#vxcp-ent-bitbucket-config-project-id-input");\n        const $bitbucketBranchNameInput = $configDialog.find("#vxcp-ent-bitbucket-config-branch-input");\n        const $bitbucketTagNameInput = $configDialog.find("#vxcp-ent-bitbucket-config-tag-input");\n        const $bitbucketRepoSlugInput = $configDialog.find("#vxcp-ent-bitbucket-config-repo-slug-input");\n        const $bitbucketFilePathInput = $configDialog.find("#vxcp-ent-bitbucket-config-file-path-input");\n        this.setConfigDialogToggle("#vxcp-ent-config-show-bpmn-links-toggle", actConfigs.showBpmnLinks);\n        this.setConfigDialogToggle("#vxcp-ent-config-show-bpmn-js-panel-toggle", actConfigs.showBpmnJsPanel);\n        this.setConfigDialogToggle("#vxcp-ent-config-show-dmn-links-toggle", actConfigs.showDmnLinks);\n        this.setConfigDialogToggle("#vxcp-ent-config-show-jira-issue-links-toggle", actConfigs.showJiraIssueLinks);\n        this.setConfigDialogToggle("#vxcp-ent-config-show-mdf-instance-links-toggle", actConfigs.showMdfInstanceLinks);\n        this.setConfigDialogToggle("#vxcp-ent-config-show-confluence-page-links-toggle", actConfigs.showConfluencePageLinks);\n        this.setConfigDialogToggle("#vxcp-ent-config-show-confluence-attachment-links-toggle", actConfigs.showConfluenceAttachmentLinks);\n        this.setConfigDialogToggle("#vxcp-ent-config-show-external-content-links-toggle", actConfigs.showExternalContentLinks);\n        this.setConfigDialogToggle("#vxcp-ent-config-show-documentation-toggle", actConfigs.showDocumentation);\n        this.setConfigDialogToggle("#vxcp-ent-config-commented-saving-toggle", actConfigs.commentedSaving);\n        this.setConfigDialogToggle("#vxcp-ent-config-show-embedded-comments-toggle", actConfigs.showEmbeddedComments);\n        this.setConfigDialogToggle("#vxcp-ent-config-save-zoom-position-toggle", actConfigs.saveZoomPosition);\n        this.setConfigDialogToggle("#vxcp-ent-config-open-bpmn-link-tab-toggle", actConfigs.showBpmnInTab);\n        this.setConfigDialogToggle("#vxcp-ent-config-open-attachment-link-tab-toggle", actConfigs.showAttachmentsInTab);\n        this.setConfigDialogToggle("#vxcp-ent-config-open-jira-issue-link-tab-toggle", actConfigs.showJiraIssuesInTab);\n        this.setConfigDialogToggle("#vxcp-ent-config-open-dmn-link-tab-toggle", actConfigs.showDmnInTab);\n        this.setConfigDialogToggle(showMaxViewerHeightToggleId, actConfigs.showMaximalHeight);\n        this.setConfigDialogToggle(viewerHeightToggleId, actConfigs.enableCustomViewerHeight);\n        $showLoadImageInViewerDropDown.val(actConfigs.loadImageInViewer);\n        $gitlabBranchNameInput.val(actConfigs.gitLabBranchName || "");\n        $gitlabTagNameInput.val(actConfigs.gitLabTagName || "");\n        $gitlabFilePathInput.val(actConfigs.gitLabFilePath || "");\n        $gitlabProjectIdInput.val(actConfigs.gitLabProjectId || "");\n        $gitlabRepoUrlInput.val(actConfigs.gitLabRepoUrl || "");\n        $bitbucketBranchNameInput.val(actConfigs.bitbucketBranchName || "");\n        $bitbucketTagNameInput.val(actConfigs.bitbucketTagName || "");\n        $bitbucketFilePathInput.val(actConfigs.bitbucketFilePath || "");\n        $bitbucketProjectIdInput.val(actConfigs.bitbucketProjectKey || "");\n        $bitbucketRepoUrlInput.val(actConfigs.bitbucketRepoUrl || "");\n        $bitbucketRepoSlugInput.val(actConfigs.bitbucketRepoSlug || "");\n    }\n    getValuesFromConfigDialog(oldConfigs) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const dialogElements = this.getDialogElements();\n            const configElements = this.getConfigElements();\n            if (!dialogElements || !configElements) {\n                return false;\n            }\n            const showAnyLinks = configElements.showDmnLinksToggle.checked ||\n                configElements.showBpmnLinksToggle.checked ||\n                configElements.showDocumentationToggle.checked ||\n                configElements.showConfluencePageLinksToggle.checked ||\n                configElements.showConfluenceAttachmentLinksToggle.checked ||\n                configElements.showExternalContentLinksToggle.checked ||\n                configElements.showJiraIssueLinksToggle.checked ||\n                configElements.showMdfInstanceLinksToggle.checked;\n            const configElementValues = {\n                showConfluencePageLinks: configElements.showConfluencePageLinksToggle.checked,\n                showBpmnLinks: configElements.showBpmnLinksToggle.checked,\n                showDmnLinks: configElements.showDmnLinksToggle.checked,\n                showJiraIssueLinks: configElements.showJiraIssueLinksToggle.checked,\n                showMdfInstanceLinks: configElements.showMdfInstanceLinksToggle.checked,\n                showExternalContentLinks: configElements.showExternalContentLinksToggle.checked,\n                showAnyLinks,\n                showBpmnJsPanel: configElements.showBpmnJsPanelToggle.checked,\n                showConfluenceAttachmentLinks: configElements.showConfluenceAttachmentLinksToggle.checked,\n                showDocumentation: configElements.showDocumentationToggle.checked,\n                commentedSaving: configElements.commentedSavingToggle.checked,\n                diagramBackgroundColor: configElements.diagramBackgroundColor.value,\n                diagramName: configElements.diagramNameInput.value,\n                enableCustomViewerHeight: configElements.viewerHeightToggle.checked,\n                viewerHeight: configElements.viewerHeightInput.value,\n                showMaximalHeight: configElements.showMaximalHeightToggle.checked,\n                showBpmnInTab: configElements.showBpmnInTabToggle.checked,\n                showAttachmentsInTab: configElements.showAttachmentsInTabToggle.checked,\n                showDmnInTab: configElements.showDmnInTabToggle.checked,\n                showJiraIssuesInTab: configElements.showJiraIssuesInTabToggle.checked,\n                showEmbeddedComments: configElements.showEmbeddedCommentsToggle.checked,\n                saveZoomPosition: configElements.saveZoomPositionToggle.checked,\n                loadImageInViewer: configElements.loadImageInViewerDropdown.value,\n                gitLabRepoUrl: configElements.gitLabRepoUrlInput.value.trim() || "",\n                gitLabBranchName: configElements.gitLabBranchNameInput.value.trim() || "",\n                gitLabTagName: configElements.gitLabTagNameInput.value.trim() || "",\n                gitLabFilePath: configElements.gitLabFilePathInput.value.trim() || "",\n                gitLabProjectId: configElements.gitLabProjectIdInput.value.trim() || "",\n                bitbucketBranchName: configElements.bitbucketBranchNameInput.value.trim() || "",\n                bitbucketTagName: configElements.bitbucketTagNameInput.value.trim() || "",\n                bitbucketFilePath: configElements.bitbucketFilePathInput.value.trim() || "",\n                bitbucketProjectKey: configElements.bitbucketProjectIdInput.value.trim() || "",\n                bitbucketRepoUrl: configElements.bitbucketRepoUrlInput.value.trim() || "",\n                bitbucketRepoSlug: configElements.bitbucketRepoSlugInput.value.trim() || "",\n            };\n            const isGitLabBranchTabActive = $("#vxcp-ent-gitlab-config-branch-tab").hasClass("vxcp-ent-tab-selected");\n            if (isGitLabBranchTabActive) {\n                configElementValues.gitLabTagName = "";\n                if (configElementValues.gitLabRepoUrl && configElementValues.gitLabProjectId && configElementValues.gitLabBranchName && configElementValues.gitLabFilePath) {\n                    const latestCommit = yield this.gitLabRestService.getCommit(configElementValues.gitLabRepoUrl, configElementValues.gitLabProjectId, configElementValues.gitLabBranchName, configElementValues.gitLabFilePath, "");\n                    configElementValues.gitLabCommitId = latestCommit.id;\n                }\n            }\n            else {\n                configElementValues.gitLabBranchName = "";\n            }\n            const isBitbucketBranchTabActive = $("#vxcp-ent-bitbucket-config-branch-tab").hasClass("vxcp-ent-tab-selected");\n            if (isBitbucketBranchTabActive) {\n                configElementValues.bitbucketTagName = "";\n                if (configElementValues.bitbucketRepoUrl &&\n                    configElementValues.bitbucketProjectKey &&\n                    configElementValues.bitbucketBranchName &&\n                    configElementValues.bitbucketFilePath &&\n                    configElementValues.bitbucketRepoSlug) {\n                    const latestCommit = yield this.bitbucketRestService.getCommit(configElementValues.bitbucketRepoUrl, configElementValues.bitbucketProjectKey, configElementValues.bitbucketBranchName, configElementValues.bitbucketFilePath, configElementValues.bitbucketRepoSlug);\n                    configElementValues.bitbucketCommitId = latestCommit.id;\n                }\n            }\n            else {\n                configElementValues.bitbucketBranchName = "";\n            }\n            const newConfigValues = Object.assign({}, oldConfigs);\n            Object.assign(newConfigValues, configElementValues);\n            return newConfigValues;\n        });\n    }\n    validateConfig(configValues, diagramName) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const dialogElements = this.getDialogElements();\n            const configElements = this.getConfigElements();\n            if (!dialogElements || !configElements) {\n                return false;\n            }\n            const errorMessageDiagramName = yield this.validatorService.validateDiagramNameInput(configValues.diagramName, diagramName);\n            if (errorMessageDiagramName) {\n                configElements.diagramNameInput.classList.add("invalid");\n                dialogElements.diagramNameErrorMessage.innerText = errorMessageDiagramName;\n                dialogElements.diagramNameErrorMessage.classList.remove("vxcp-ent-hidden");\n                return false;\n            }\n            if (!this.validatorService.validateColor(configValues.diagramBackgroundColor)) {\n                return false;\n            }\n            const errorMessageViewerHeight = yield this.validatorService.validateViewerHeightInput(configValues.viewerHeight);\n            if (errorMessageViewerHeight) {\n                configElements.viewerHeightInput.classList.add("invalid");\n                dialogElements.viewerHeightErrorMessage.innerText = errorMessageViewerHeight;\n                dialogElements.viewerHeightErrorMessage.classList.remove("vxcp-ent-hidden");\n                return false;\n            }\n            return true;\n        });\n    }\n    updateAllConfigs(pageId, vbcpEntId, newConfigs, minorEdit = false) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.showConfigLoading();\n            let updateConfigsUrl = `${pageId}/updateConfig/${vbcpEntId}`;\n            if (minorEdit) {\n                updateConfigsUrl = `${updateConfigsUrl}?minorEdit=true`;\n            }\n            return yield this.platformUtils.makeRequest({\n                cache: false,\n                url: this.configBaseUrl + updateConfigsUrl,\n                type: "POST",\n                data: JSON.stringify(newConfigs),\n                contentType: "application/json",\n                error: (err) => __awaiter(this, void 0, void 0, function* () {\n                    const errorText = "REST-Error occurred while saving configs on the server";\n                    this.vxcpLogger.logError("updateAllConfigs", errorText, err);\n                    yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.showSystemErrorDialog(pageId, "ERROR @DiagramConfigurationService.updateAllConfigs: " + errorText, err);\n                }),\n            });\n        });\n    }\n    updateAllConfigsExceptDiagramName(pageId, vbcpEntId, oldDiagramName, newConfigs) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const configs = Object.assign({}, newConfigs);\n            configs.diagramName = oldDiagramName;\n            return yield this.updateAllConfigs(pageId, vbcpEntId, configs);\n        });\n    }\n    showErrorMessage(error) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let errorMessageText = "";\n            const dialogElements = this.getDialogElements();\n            const configElements = this.getConfigElements();\n            if (!dialogElements || !configElements) {\n                return false;\n            }\n            const loadingText = dialogElements.loadingText;\n            const errorMessageField = dialogElements.diagramNameErrorMessage;\n            const continueBtn = dialogElements.continueBtn;\n            const diagramNameInput = configElements.diagramNameInput;\n            loadingText.style.display = "none";\n            switch (error.status) {\n                case 404: {\n                    errorMessageText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.macro-configuration-dialog.error.notfound");\n                    break;\n                }\n                case 409: {\n                    errorMessageText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.macro-configuration-dialog.error.namechange");\n                    break;\n                }\n                default: {\n                    errorMessageText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.macro-configuration-dialog.service-unavailable");\n                    break;\n                }\n            }\n            diagramNameInput.classList.add("invalid");\n            dialogElements.diagramNameErrorMessage.innerText = errorMessageText;\n            errorMessageField.classList.remove("vxcp-ent-hidden");\n            continueBtn.disabled = false;\n            return errorMessageText;\n        });\n    }\n    showConfigLoading() {\n        const dialogElements = this.getDialogElements();\n        if (!dialogElements) {\n            return false;\n        }\n        dialogElements.menu.style.display = "none";\n        dialogElements.content.style.display = "none";\n        dialogElements.loadingText.style.display = "block";\n        dialogElements.continueBtn.disabled = true;\n    }\n    getDialogElements() {\n        const dialogId = "vxcp-ent-config-dialog";\n        const configDialog = document.getElementById(dialogId);\n        if (!configDialog) {\n            return false;\n        }\n        const menu = configDialog.querySelector(".vxcp-ent-dialog-menu-container");\n        const content = configDialog.querySelector(".aui-dialog2-content form");\n        const diagramNameErrorMessage = configDialog.querySelector("#vxcp-ent-config-diagram-name-error");\n        const viewerHeightErrorMessage = configDialog.querySelector("#vxcp-ent-config-viewer-height-error");\n        const backgroundColorErrorMessage = configDialog.querySelector("#vxcp-ent-diagram-background-color-error");\n        const loadingText = configDialog.querySelector("#loading");\n        const continueBtn = configDialog.querySelector(`#${dialogId}-submit`);\n        const configDialogElements = Object.create({\n            menu,\n            content,\n            diagramNameErrorMessage,\n            viewerHeightErrorMessage,\n            backgroundColorErrorMessage,\n            loadingText,\n            continueBtn,\n        });\n        if (!configDialogElements) {\n            return false;\n        }\n        return configDialogElements;\n    }\n    getConfigElements() {\n        const dialogId = "vxcp-ent-config-dialog";\n        const configDialog = document.getElementById(dialogId);\n        if (!configDialog) {\n            return false;\n        }\n        const diagramNameInput = configDialog.querySelector("#vxcp-ent-config-diagram-name-input");\n        const viewerHeightInput = configDialog.querySelector("#vxcp-ent-config-viewer-height-input");\n        const viewerHeightToggle = configDialog.querySelector("#vxcp-ent-config-custom-viewer-height-toggle");\n        const showMaximalHeightToggle = configDialog.querySelector("#vxcp-ent-config-max-viewer-height-toggle");\n        const showBpmnLinksToggle = configDialog.querySelector("#vxcp-ent-config-show-bpmn-links-toggle");\n        const showDmnLinksToggle = configDialog.querySelector("#vxcp-ent-config-show-dmn-links-toggle");\n        const showJiraIssueLinksToggle = configDialog.querySelector("#vxcp-ent-config-show-jira-issue-links-toggle");\n        const showMdfInstanceLinksToggle = configDialog.querySelector("#vxcp-ent-config-show-mdf-instance-links-toggle");\n        const showConfluencePageLinksToggle = configDialog.querySelector("#vxcp-ent-config-show-confluence-page-links-toggle");\n        const showConfluenceAttachmentLinksToggle = configDialog.querySelector("#vxcp-ent-config-show-confluence-attachment-links-toggle");\n        const showExternalContentLinksToggle = configDialog.querySelector("#vxcp-ent-config-show-external-content-links-toggle");\n        const showDocumentationToggle = configDialog.querySelector("#vxcp-ent-config-show-documentation-toggle");\n        const commentedSavingToggle = configDialog.querySelector("#vxcp-ent-config-commented-saving-toggle");\n        const showAttachmentsInTabToggle = configDialog.querySelector("#vxcp-ent-config-open-attachment-link-tab-toggle");\n        const showBpmnInTabToggle = configDialog.querySelector("#vxcp-ent-config-open-bpmn-link-tab-toggle");\n        const showDmnInTabToggle = configDialog.querySelector("#vxcp-ent-config-open-dmn-link-tab-toggle");\n        const showJiraIssuesInTabToggle = configDialog.querySelector("#vxcp-ent-config-open-jira-issue-link-tab-toggle");\n        const showEmbeddedCommentsToggle = configDialog.querySelector("#vxcp-ent-config-show-embedded-comments-toggle");\n        const showBpmnJsPanelToggle = configDialog.querySelector("#vxcp-ent-config-show-bpmn-js-panel-toggle");\n        const saveZoomPositionToggle = configDialog.querySelector("#vxcp-ent-config-save-zoom-position-toggle");\n        const diagramBackgroundColor = configDialog.querySelector("#vxcp-ent-config-background-color-input");\n        const loadImageInViewerDropdown = configDialog.querySelector("#vxcp-ent-config-load-image-in-viewer-dropdown");\n        const gitLabRepoUrlInput = configDialog.querySelector("#vxcp-ent-gitlab-config-repo-url-input");\n        const gitLabProjectIdInput = configDialog.querySelector("#vxcp-ent-gitlab-config-project-id-input");\n        const gitLabBranchNameInput = configDialog.querySelector("#vxcp-ent-gitlab-config-branch-input");\n        const gitLabTagNameInput = configDialog.querySelector("#vxcp-ent-gitlab-config-tag-input");\n        const gitLabFilePathInput = configDialog.querySelector("#vxcp-ent-gitlab-config-file-path-input");\n        const bitbucketRepoUrlInput = configDialog.querySelector("#vxcp-ent-bitbucket-config-repo-url-input");\n        const bitbucketProjectIdInput = configDialog.querySelector("#vxcp-ent-bitbucket-config-project-id-input");\n        const bitbucketBranchNameInput = configDialog.querySelector("#vxcp-ent-bitbucket-config-branch-input");\n        const bitbucketTagNameInput = configDialog.querySelector("#vxcp-ent-bitbucket-config-tag-input");\n        const bitbucketFilePathInput = configDialog.querySelector("#vxcp-ent-bitbucket-config-file-path-input");\n        const bitbucketRepoSlugInput = configDialog.querySelector("#vxcp-ent-bitbucket-config-repo-slug-input");\n        const configElements = Object.create({\n            diagramNameInput,\n            viewerHeightInput,\n            viewerHeightToggle,\n            showMaximalHeightToggle,\n            showConfluencePageLinksToggle,\n            showConfluenceAttachmentLinksToggle,\n            showExternalContentLinksToggle,\n            showDocumentationToggle,\n            showJiraIssueLinksToggle,\n            showMdfInstanceLinksToggle,\n            showDmnLinksToggle,\n            showBpmnLinksToggle,\n            commentedSavingToggle,\n            diagramBackgroundColor,\n            showAttachmentsInTabToggle,\n            showBpmnInTabToggle,\n            showDmnInTabToggle,\n            showJiraIssuesInTabToggle,\n            showEmbeddedCommentsToggle,\n            showBpmnJsPanelToggle,\n            saveZoomPositionToggle,\n            loadImageInViewerDropdown,\n            gitLabRepoUrlInput,\n            gitLabProjectIdInput,\n            gitLabBranchNameInput,\n            gitLabTagNameInput,\n            gitLabFilePathInput,\n            bitbucketRepoUrlInput,\n            bitbucketProjectIdInput,\n            bitbucketBranchNameInput,\n            bitbucketTagNameInput,\n            bitbucketFilePathInput,\n            bitbucketRepoSlugInput,\n        });\n        if (!configElements) {\n            return false;\n        }\n        return configElements;\n    }\n    setConfigDialogToggle(toggleId, configValue) {\n        const dialogId = "#vxcp-ent-config-dialog";\n        const $configDialog = $(dialogId);\n        const $toggle = $configDialog.find(toggleId);\n        const isChecked = configValue ? configValue.toString() : null;\n        $toggle.attr("checked", isChecked);\n    }\n    renameDiagram(latestDiagramVersion, pageId, vbcpEntId, newConfigs, oldDiagramName, appFileType) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (latestDiagramVersion) {\n                const nameIsAlreadyUsed = yield this.attachmentService.checkIfAttachmentNameAlreadyExistsAsBpmnOrPng(pageId, newConfigs.diagramName, oldDiagramName, appFileType);\n                if (nameIsAlreadyUsed) {\n                    if (yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.confirmWarningDialog(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .WarningDialogTypeEnum.DUPLICATE_RENAME_ERROR */ .K.DUPLICATE_RENAME_ERROR)) {\n                        (0,_routing_service__WEBPACK_IMPORTED_MODULE_7__/* .openConfluencePage */ .SP)(pageId, "_parent");\n                    }\n                    return;\n                }\n                try {\n                    yield this.attachmentService.renameAttachment(pageId, oldDiagramName, newConfigs.diagramName, appFileType);\n                }\n                catch (err) {\n                    if (yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.confirmWarningDialog(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .WarningDialogTypeEnum.XML_RENAME_ERROR */ .K.XML_RENAME_ERROR)) {\n                        (0,_routing_service__WEBPACK_IMPORTED_MODULE_7__/* .openConfluencePage */ .SP)(pageId, "_parent");\n                    }\n                    return;\n                }\n                try {\n                    yield this.attachmentService.renameAttachment(pageId, oldDiagramName, newConfigs.diagramName, _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_5__/* .FileTypeEnum.PNG */ .W.PNG);\n                }\n                catch (err) {\n                    if (yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.confirmWarningDialog(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .WarningDialogTypeEnum.PNG_RENAME_ERROR */ .K.PNG_RENAME_ERROR)) {\n                        (0,_routing_service__WEBPACK_IMPORTED_MODULE_7__/* .openConfluencePage */ .SP)(pageId, "_parent");\n                    }\n                }\n                yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.setTitleName(newConfigs.diagramName);\n                if (this.managedDataFieldsService) {\n                    yield this.managedDataFieldsService.setNewBpmnNameToAllMdfInstances(newConfigs.diagramName);\n                }\n                yield this.updateSingleConfig("diagramName", pageId, vbcpEntId, newConfigs.diagramName);\n                return newConfigs.diagramName;\n            }\n            else {\n                let nameIsAlreadyUsed = false;\n                const caseSensitive = true;\n                if (newConfigs.diagramName.toLowerCase() !== oldDiagramName.toLowerCase())\n                    nameIsAlreadyUsed = !(yield this.validatorService.validateDiagramNameUniquenessThroughMacroService(newConfigs.diagramName, pageId, caseSensitive));\n                if (!nameIsAlreadyUsed) {\n                    yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.setTitleName(newConfigs.diagramName);\n                    yield this.updateSingleConfig("diagramName", pageId, vbcpEntId, newConfigs.diagramName);\n                    return newConfigs.diagramName;\n                }\n                else\n                    this.messageService.setWarningMessage(yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.warning-dialog.duplicate-rename-error.headline"), yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.warning-dialog.duplicate-rename-error.desc"), { fadeOut: true, delay: 3000 });\n            }\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/diagram-configuration.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/global-bpmn-elements-config-rest.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "r": () => (/* binding */ GlobalBpmnElementsConfigRestService)\n/* harmony export */ });\nif (/^bpmnEnt(Admin|SpaceAdminPage)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\nif (/^bpmnEnt(Admin|SpaceAdminPage)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _model_configs_default_bpmn_elements_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/configs/default-bpmn-elements.config.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nclass GlobalBpmnElementsConfigRestService {\n    constructor() {\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__/* .getPluginService */ .j)().getPluginName(), "GlobalBpmnElementsConfigRestService");\n        const languageRestService = _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__/* .getLanguageRestService */ .GU();\n        const appPathComponent = languageRestService.getPluginRestComponent();\n        this.restPathComponent = `/rest/${appPathComponent}/1.0`;\n    }\n    updateBpmnElementsConfig(bpmnElementsConfig) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/bpmnElementsGlobalConfig`);\n            const headers = { "X-Atlassian-Token": "no-check" };\n            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n                yield this.platformUtils\n                    .makeRequest({\n                    url,\n                    headers,\n                    type: "POST",\n                    contentType: "application/json",\n                    data: JSON.stringify(bpmnElementsConfig),\n                    cache: false,\n                })\n                    .then((response) => {\n                    resolve(response);\n                })\n                    .catch((err) => {\n                    this.vxcpLogger.logError("updateBpmnElementsConfig", "POST request was rejected.", err);\n                    reject(err);\n                });\n            }));\n        });\n    }\n    deleteBpmnElementsConfig(bpmnElementsGroup) {\n        const url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/bpmnElementsGlobalConfig?bpmnElementsGroup=${bpmnElementsGroup}`);\n        const headers = { "X-Atlassian-Token": "no-check" };\n        return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n            yield this.platformUtils\n                .makeRequest({\n                url,\n                headers,\n                type: "DELETE",\n                contentType: "application/json",\n                cache: false,\n            })\n                .then((response) => {\n                resolve(response);\n            })\n                .catch((err) => {\n                this.vxcpLogger.logError("deleteBpmnElementsConfig", "DELETE request was rejected.", err);\n                reject(err);\n            });\n        }));\n    }\n    getBpmnElementsConfig() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/bpmnElementsGlobalConfig`);\n            const headers = { "X-Atlassian-Token": "no-check" };\n            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n                yield this.platformUtils\n                    .makeRequest({\n                    url,\n                    headers,\n                    type: "GET",\n                    contentType: "application/json",\n                    cache: false,\n                })\n                    .then((response) => {\n                    resolve(response);\n                })\n                    .catch((err) => {\n                    this.vxcpLogger.logError("getBpmnElementsConfig", "GET request was rejected.", err);\n                    resolve(_model_configs_default_bpmn_elements_config__WEBPACK_IMPORTED_MODULE_1__/* .defaultBpmnElementsConfig */ .f);\n                });\n            }));\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/global-bpmn-elements-config-rest.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/id-generator.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ generateVbcpEntId),\n/* harmony export */   "l": () => (/* binding */ generateVbcpProcessNetId)\n/* harmony export */ });\nif (!/^bpmnEnt(LanguageService|PlatformMDF|ProcessNetViewer|SpaceAdminPage)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/node_modules/uuid/dist/esm-browser/v4.js");\n}\n\nconst generateVbcpEntId = () => {\n    const vbcpEntIdPrefix = "vxcp-ent-id-";\n    const uuid = (0,uuid__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)();\n    return vbcpEntIdPrefix.concat(uuid);\n};\nconst generateVbcpProcessNetId = () => {\n    const idPrefix = "vxcp-process-net-id-";\n    const uuid = (0,uuid__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)();\n    return idPrefix.concat(uuid);\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/id-generator.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/jira-rest.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "U": () => (/* binding */ JiraRestService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/jira-Rest-Errors.enum.ts");\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/warning-dialog-type.enum.ts");\n/* harmony import */ var _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-mode.enum.ts");\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _utils_message_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/message.service.ts");\n}\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\nclass JiraRestService {\n    constructor(appMode) {\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_4__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.jiraInstances = [];\n        this.messageContainerId = "#vxcp-ent-dialog-link-message-container";\n        this.jiraInstanceReachable = true;\n        this.appMode = appMode;\n        this.messageService = new _utils_message_service__WEBPACK_IMPORTED_MODULE_5__/* .MessageService */ .e();\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_4__/* .getPluginService */ .j)().getPluginName(), "JiraRestService");\n        this.initConnections();\n    }\n    initConnections() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const jiraInstance = yield this.getLinkedJiraInstance(false);\n            if (jiraInstance) {\n                const jiraRestTestPath = `${jiraInstance.url}/rest/api/2/myself`;\n                const appLinkJiraRestTestPath = `/plugins/servlet/applinks/proxy?appId=${jiraInstance.id}&path=${jiraRestTestPath}`;\n                const restTestUrl = this.platformUtils.buildRestUrl(appLinkJiraRestTestPath);\n                try {\n                    yield this.platformUtils.makeRequest({\n                        type: "GET",\n                        url: restTestUrl,\n                    });\n                }\n                catch (error) {\n                    if ((error.status === 401 && !error.responseText) || error.status === 504) {\n                        this.jiraInstanceReachable = false;\n                        this.vxcpLogger.logWarning("initConnections", "Could not establish connection to linked Jira instance.", error);\n                    }\n                    return;\n                }\n            }\n        });\n    }\n    getMultipleIssuesByJql(jqlQuery, showWarnings, appLinkId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const results = [];\n            const jiraInstance = yield this.getLinkedJiraInstance(showWarnings, appLinkId);\n            if (!jiraInstance) {\n                return [];\n            }\n            const jiraSearchRequestPath = `${jiraInstance.url}/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?jqlQuery=(${jqlQuery})&returnMax=true&tempMax=20&field=summary&field=type&field=link&field=status`;\n            const jqlRestPath = `/plugins/servlet/applinks/proxy?appId=${jiraInstance.id}&path=${jiraSearchRequestPath}`;\n            const jqlRestUrl = encodeURI(this.platformUtils.buildRestUrl(jqlRestPath));\n            let issuesAsXml;\n            if (!this.jiraInstanceReachable) {\n                if (showWarnings) {\n                    yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.JIRA_UNAVAILABLE */ .Q.JIRA_UNAVAILABLE);\n                }\n                return [];\n            }\n            try {\n                issuesAsXml = yield this.platformUtils.makeRequest({\n                    type: "GET",\n                    url: jqlRestUrl,\n                    dataType: "xml",\n                });\n            }\n            catch (error) {\n                if (showWarnings && ((error.status === 401 && error.responseText) || error.status === 400)) {\n                    yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.AUTHENTICATION_TOKEN_REQUIRED */ .Q.AUTHENTICATION_TOKEN_REQUIRED);\n                    this.vxcpLogger.logWarning("getMultipleIssuesByJql", "Authentication with Jira instance required", error);\n                }\n                else if (error.status === 401 && !error.responseText) {\n                    this.jiraInstanceReachable = false;\n                    this.vxcpLogger.logWarning("getMultipleIssuesByJql", "Could not establish connection to linked Jira instance.", error);\n                    if (showWarnings) {\n                        yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.JIRA_UNAVAILABLE */ .Q.JIRA_UNAVAILABLE);\n                    }\n                }\n                else if (error.status === 504) {\n                    let message = error.responseText || "";\n                    message = message.toLowerCase();\n                    if (message.includes("authentication failed: signature_invalid")) {\n                    }\n                    else {\n                        this.vxcpLogger.logWarning("getMultipleIssuesByJql", "Could not establish connection to linked Jira instance.", error);\n                        this.jiraInstanceReachable = false;\n                        if (showWarnings) {\n                            yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.JIRA_UNAVAILABLE */ .Q.JIRA_UNAVAILABLE);\n                        }\n                    }\n                }\n                else {\n                    yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.GENERIC_JIRA_ERROR */ .Q.GENERIC_JIRA_ERROR);\n                }\n                return [];\n            }\n            const $issuesXml = $(issuesAsXml).find("item");\n            $issuesXml.each((index, issueXml) => {\n                const issueKey = $(issueXml).find("key").text();\n                const issueSummary = $(issueXml).find("summary").text();\n                const issueLink = $(issueXml).find("link").text();\n                const $issueStatusWrapper = $(issueXml).find("status");\n                const issueStatusAsText = $issueStatusWrapper.text();\n                const issueStatusIconUrl = $issueStatusWrapper.attr("iconUrl") || "";\n                const $issueTypeWrapper = $(issueXml).find("type");\n                const issueTypeAsText = $issueTypeWrapper.text();\n                const issueTypeIconUrl = $issueTypeWrapper.attr("iconUrl") || "";\n                const issue = {\n                    key: issueKey,\n                    self: issueLink,\n                    fields: {\n                        summary: issueSummary,\n                        status: {\n                            iconurl: issueStatusIconUrl,\n                            name: issueStatusAsText,\n                        },\n                        issuetype: {\n                            iconUrl: issueTypeIconUrl,\n                            name: issueTypeAsText,\n                        },\n                    },\n                };\n                results.push(issue);\n            });\n            return results;\n        });\n    }\n    getSingleIssueByKey(issueKey, showWarnings, appLinkId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const jiraInstance = yield this.getLinkedJiraInstance(showWarnings, appLinkId);\n            if (!jiraInstance) {\n                return;\n            }\n            const jiraSearchRequestPath = `${jiraInstance.url}/rest/api/2/issue/${issueKey}`;\n            const jqlRestPath = `/plugins/servlet/applinks/proxy?appId=${jiraInstance.id}&path=${jiraSearchRequestPath}&expand=renderedFields`;\n            const jqlRestUrl = this.platformUtils.buildRestUrl(jqlRestPath);\n            let singleIssue;\n            if (!this.jiraInstanceReachable) {\n                if (showWarnings) {\n                    yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.JIRA_UNAVAILABLE */ .Q.JIRA_UNAVAILABLE);\n                }\n                return;\n            }\n            try {\n                singleIssue = yield this.platformUtils.makeRequest({\n                    type: "GET",\n                    url: jqlRestUrl,\n                    dataType: "json",\n                });\n                return singleIssue;\n            }\n            catch (error) {\n                if (showWarnings && error.status === 401 && error.responseText) {\n                    yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.AUTHENTICATION_TOKEN_REQUIRED */ .Q.AUTHENTICATION_TOKEN_REQUIRED);\n                    this.vxcpLogger.logWarning("getMultipleIssuesByJql", "Authentication with Jira instance required", error);\n                }\n                else if ((error.status === 401 && !error.responseText) || error.status === 504) {\n                    this.jiraInstanceReachable = false;\n                    this.vxcpLogger.logWarning("getSingleIssueByKey", "Could not establish connection to linked Jira instance.", error);\n                    if (showWarnings) {\n                        yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.JIRA_UNAVAILABLE */ .Q.JIRA_UNAVAILABLE);\n                    }\n                }\n                else {\n                    if (showWarnings) {\n                        yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.GENERIC_JIRA_ERROR */ .Q.GENERIC_JIRA_ERROR);\n                    }\n                }\n                return;\n            }\n        });\n    }\n    getLinkedJiraInstance(showWarnings = false, appLinkId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!this.jiraInstances.length) {\n                yield this.initLinkedJiraInstances(showWarnings);\n            }\n            if (!this.jiraInstances.length) {\n                return;\n            }\n            let jiraInstance;\n            if (appLinkId) {\n                jiraInstance = this.jiraInstances.find((instance) => instance.id === appLinkId);\n                if (jiraInstance) {\n                    return jiraInstance;\n                }\n                else {\n                    this.vxcpLogger.logWarning("getLinkedJiraInstance", "AppLink Id of Issue does not match that of any linked Jira instance");\n                    if (showWarnings) {\n                        yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.NO_JIRA_INSTANCE_LINKED */ .Q.NO_JIRA_INSTANCE_LINKED);\n                    }\n                    return;\n                }\n            }\n            jiraInstance = this.jiraInstances.find((instance) => instance.selected);\n            if (jiraInstance) {\n                return jiraInstance;\n            }\n            else {\n                this.vxcpLogger.logWarning("getLinkedJiraInstance", "No application link to any Jira instance was found.");\n                if (showWarnings) {\n                    yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.NO_JIRA_INSTANCE_LINKED */ .Q.NO_JIRA_INSTANCE_LINKED);\n                }\n                return;\n            }\n        });\n    }\n    openJiraAuthenticationLink(appLinkId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const jiraInstance = yield this.getLinkedJiraInstance(true, appLinkId);\n            if (jiraInstance) {\n                const authenticationPath = `/plugins/servlet/applinks/oauth/login-dance/authorize?applicationLinkID=${jiraInstance.id}`;\n                const authenticationUrl = this.platformUtils.buildRestUrl(authenticationPath);\n                window.open(authenticationUrl, "_blank");\n            }\n            else {\n                this.vxcpLogger.logWarning("getLinkedJiraInstance", "No application link to any Jira instance was found.");\n                yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.NO_JIRA_INSTANCE_LINKED */ .Q.NO_JIRA_INSTANCE_LINKED);\n            }\n        });\n    }\n    getJiraInstanceReachable() {\n        return this.jiraInstanceReachable;\n    }\n    initLinkedJiraInstances(showWarnings = false) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let linkedJiraInstances = [];\n            try {\n                linkedJiraInstances = yield this.platformUtils.getJiraAppLinks();\n            }\n            catch (error) {\n                if (showWarnings && error.status === 404) {\n                    yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.APPLICATION_LINKS_UNAVAILABLE */ .Q.APPLICATION_LINKS_UNAVAILABLE);\n                    return;\n                }\n                else {\n                    if (showWarnings) {\n                        yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.GENERIC_JIRA_ERROR */ .Q.GENERIC_JIRA_ERROR);\n                    }\n                    return;\n                }\n            }\n            if (showWarnings && !linkedJiraInstances.length) {\n                yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.NO_JIRA_INSTANCE_LINKED */ .Q.NO_JIRA_INSTANCE_LINKED);\n                return;\n            }\n            this.jiraInstances = linkedJiraInstances;\n        });\n    }\n    handleJiraRestError(errorType) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const isInViewer = this.appMode === _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_3__/* .AppModeEnum.VIEWER */ .v.VIEWER;\n            $(this.messageContainerId).empty();\n            switch (errorType) {\n                case _model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.AUTHENTICATION_TOKEN_REQUIRED */ .Q.AUTHENTICATION_TOKEN_REQUIRED:\n                    if (!isInViewer) {\n                        if (yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.confirmWarningDialog(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .WarningDialogTypeEnum.AUTHENTICATION_TOKEN_REQUIRED */ .K.AUTHENTICATION_TOKEN_REQUIRED)) {\n                            yield this.openJiraAuthenticationLink();\n                        }\n                    }\n                    break;\n                case _model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.JIRA_UNAVAILABLE */ .Q.JIRA_UNAVAILABLE:\n                    if (!isInViewer) {\n                        const jiraUnavailableTitle = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.jira-link.jira-unavailable.title");\n                        const jiraUnavailableBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.jira-link.jira-unavailable.body");\n                        this.messageService.setWarningMessage(jiraUnavailableTitle, jiraUnavailableBody, {\n                            identifier: this.messageContainerId,\n                            closeable: false,\n                            delay: 2000,\n                            inForeground: true,\n                        });\n                    }\n                    break;\n                case _model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.APPLICATION_LINKS_UNAVAILABLE */ .Q.APPLICATION_LINKS_UNAVAILABLE:\n                    if (!isInViewer) {\n                        const appLinksUnavailableTitle = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.jira-link.app-links-unavailable.title");\n                        const appLinksUnavailableBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.jira-link.app-links-unavailable.body");\n                        this.messageService.setWarningMessage(appLinksUnavailableTitle, appLinksUnavailableBody, {\n                            identifier: this.messageContainerId,\n                            closeable: false,\n                            delay: 2000,\n                            inForeground: true,\n                        });\n                    }\n                    break;\n                case _model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.NO_JIRA_INSTANCE_LINKED */ .Q.NO_JIRA_INSTANCE_LINKED:\n                    if (!isInViewer) {\n                        const noInstanceLinkedTitle = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.jira-link.no-instance-linked.title");\n                        const noInstanceLinkedBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.jira-link.no-instance-linked.body");\n                        this.messageService.setWarningMessage(noInstanceLinkedTitle, noInstanceLinkedBody, {\n                            identifier: $(this.messageContainerId).length ? this.messageContainerId : undefined,\n                            closeable: !$(this.messageContainerId).length,\n                            delay: 2000,\n                            inForeground: true,\n                        });\n                    }\n                    break;\n                case _model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.GENERIC_JIRA_ERROR */ .Q.GENERIC_JIRA_ERROR:\n                    if (!isInViewer) {\n                        const genericJiraErrorTitle = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.jira-link.generic-error.title");\n                        const genericJiraErrorBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.jira-link.generic-error.body");\n                        this.messageService.setWarningMessage(genericJiraErrorTitle, genericJiraErrorBody, {\n                            identifier: this.messageContainerId,\n                            closeable: false,\n                            delay: 2000,\n                            inForeground: true,\n                        });\n                    }\n                    break;\n                default:\n                    yield this.handleJiraRestError(_model_enum_jira_Rest_Errors_enum__WEBPACK_IMPORTED_MODULE_0__/* .JiraRestErrorsEnum.GENERIC_JIRA_ERROR */ .Q.GENERIC_JIRA_ERROR);\n                    break;\n            }\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/jira-rest.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/license.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "E": () => (/* binding */ LicenseService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/license-type.enum.ts");\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _routing_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/routing.service.ts");\n/* harmony import */ var _model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/warning-dialog-type.enum.ts");\nif (/^bpmnEnt((|ProcessNet)MacroDialog|Admin|Editor|Viewer)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _utils_message_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/message.service.ts");\n}\n/* harmony import */ var _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\nif (/^bpmnEnt((|ProcessNet)MacroDialog|Admin|Editor|Viewer)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nif (/^bpmnEnt((|ProcessNet)MacroDialog|Admin|Editor|Viewer)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\nclass LicenseService {\n    constructor() {\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.platformMacroDialog = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__/* .getPlatformService */ .km)().getPlatformMacroDialog() || {};\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__/* .getPluginService */ .j)().getPluginName(), "LicenseService");\n        this.messageService = new _utils_message_service__WEBPACK_IMPORTED_MODULE_7__/* .MessageService */ .e();\n        this.languageRestService = _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_4__/* .getLanguageRestService */ .GU();\n        this.appPathComponent = this.languageRestService.getPluginRestComponent();\n    }\n    getLeftDaysForEvalLicense() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`/rest/${this.appPathComponent}/1.0/license/expiryDaysLeft`);\n            const jsonData = yield this.platformUtils.makeRequest({\n                cache: false,\n                url,\n                type: "GET",\n                dataType: "json",\n                error: (err) => {\n                    this.vxcpLogger.logError("getLeftDaysForEvalLicense", "REST-Error occurred while getting left days for eval license from server.", err);\n                },\n            });\n            return jsonData;\n        });\n    }\n    getLicenseType() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`/rest/${this.appPathComponent}/1.0/license/licenseType`);\n            const jsonData = yield this.platformUtils.makeRequest({\n                cache: false,\n                url,\n                type: "GET",\n                dataType: "json",\n                error: (err) => {\n                    this.vxcpLogger.logError("getLicenseType", "REST-Error occurred while getting license type from server.", err);\n                },\n            });\n            return jsonData;\n        });\n    }\n    licenseHandlingForMacroDialogBefore(licenseType) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const licenseValid = yield this.isLicenseValid();\n            if (!licenseValid) {\n                yield this.showNoValidLicenseDialogForMacroDialog();\n            }\n            return licenseValid;\n        });\n    }\n    isLicenseValid() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const licenseType = yield this.getLicenseType();\n            return licenseType !== _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.INVALID */ .y.INVALID;\n        });\n    }\n    licenseHandlingForMacroDialogAfter(licenseType) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let flag = true;\n            switch (licenseType) {\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.EVAL */ .y.EVAL:\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.MAINTENANCE_EXPIRED */ .y.MAINTENANCE_EXPIRED:\n                    flag = false;\n                    yield this.showExpiredLicenseMessageForMacroDialog();\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.VALID */ .y.VALID:\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.INVALID */ .y.INVALID:\n                    break;\n                default:\n                    flag = false;\n            }\n            return flag;\n        });\n    }\n    licenseHandlingForConfigurationPageBefore(licenseType) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let flag = true;\n            switch (licenseType) {\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.EVAL */ .y.EVAL:\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.MAINTENANCE_EXPIRED */ .y.MAINTENANCE_EXPIRED:\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.VALID */ .y.VALID:\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.INVALID */ .y.INVALID:\n                    flag = false;\n                    yield this.showNoValidLicenseDialogForConfigurationPage();\n                    break;\n                default:\n                    flag = false;\n            }\n            return flag;\n        });\n    }\n    licenseHandlingForAppBefore(licenseType, pageId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let flag = true;\n            switch (licenseType) {\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.EVAL */ .y.EVAL:\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.MAINTENANCE_EXPIRED */ .y.MAINTENANCE_EXPIRED:\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.VALID */ .y.VALID:\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.INVALID */ .y.INVALID:\n                    flag = false;\n                    yield this.showNoValidLicenseDialogForApp(pageId);\n                    break;\n                default:\n            }\n            return flag;\n        });\n    }\n    licenseHandlingForAppAfter(licenseType) {\n        return __awaiter(this, void 0, void 0, function* () {\n            switch (licenseType) {\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.EVAL */ .y.EVAL:\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.MAINTENANCE_EXPIRED */ .y.MAINTENANCE_EXPIRED:\n                    yield this.showExpiredLicenseMessageInWelcomeScreenForApp();\n                    this.showExpiredLicenseWarningInNavbarForApp();\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.VALID */ .y.VALID:\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.INVALID */ .y.INVALID:\n                    break;\n                default:\n            }\n        });\n    }\n    licenseHandlingForViewer(licenseType, pageId, macroId, languageService, $canvas, buttons) {\n        return __awaiter(this, void 0, void 0, function* () {\n            switch (licenseType) {\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.EVAL */ .y.EVAL:\n                    yield this.showLeftTimeForEvalLicenseAtViewer(pageId, macroId);\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.MAINTENANCE_EXPIRED */ .y.MAINTENANCE_EXPIRED:\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.VALID */ .y.VALID:\n                    break;\n                case _model_enum_license_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .LicenseTypeEnum.INVALID */ .y.INVALID:\n                    this.setWatermarkToViewer($canvas);\n                    this.showNoValidLicenseDialogForViewerButtons(buttons);\n                    this.showNoValidLicenseDialogForAnyLinks(pageId, macroId);\n                    this.showNoValidLicenseDialogForAnyComment(pageId, macroId, languageService);\n                    this.disableAttributePanelForNoValidLicense(macroId);\n                    break;\n                default:\n                    this.setWatermarkToViewer($canvas);\n                    this.showNoValidLicenseDialogForViewerButtons(buttons);\n                    this.showNoValidLicenseDialogForAnyLinks(pageId, macroId);\n                    this.showNoValidLicenseDialogForAnyComment(pageId, macroId, languageService);\n                    this.disableAttributePanelForNoValidLicense(macroId);\n            }\n        });\n    }\n    showLeftTimeForEvalLicenseAtViewer(pageId, macroId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const leftDays = yield this.getLeftDaysForEvalLicense();\n            if (leftDays <= 5) {\n                const body = leftDays === 0\n                    ? yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.license.evaluation.left-days.body.none")\n                    : (yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.license.evaluation.left-days.body.01")) +\n                        ` ${leftDays} ` +\n                        (yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.license.evaluation.left-days.body.02"));\n                this.messageService.setWarningMessage(yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.license.evaluation.left-days.title"), body, {\n                    identifier: `#vxcp-ent-message-box-viewer-${pageId}-${macroId}`,\n                });\n            }\n        });\n    }\n    setWatermarkToViewer($canvas) {\n        $canvas.addClass("vxcp-ent-watermark-no-license");\n    }\n    showNoValidLicenseDialogForViewerButtons(buttons) {\n        buttons.$downloadXmlBtn.off("click").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            yield this.showNoValidLicenseDialogHelper(e);\n        }));\n        buttons.$downloadPngBtn.off("click").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            yield this.showNoValidLicenseDialogHelper(e);\n        }));\n        buttons.$showLinksBtn.off("click").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            yield this.showNoValidLicenseDialogHelper(e);\n        }));\n        buttons.$showEmbeddedCommentsBtn.off("click").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            yield this.showNoValidLicenseDialogHelper(e);\n        }));\n        buttons.$presentationModeBtn.off("click").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            yield this.showNoValidLicenseDialogHelper(e);\n        }));\n        buttons.$editBtn.off("click").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            yield this.showNoValidLicenseDialogHelper(e);\n        }));\n        buttons.$helpWizardBtn.off("click").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            yield this.showNoValidLicenseDialogHelper(e);\n        }));\n    }\n    showNoValidLicenseDialogForAnyLinks(pageId, macroId) {\n        const overlayLinks = $(`#vxcp-ent-viewer-${pageId}-${macroId}`).find(".vxcp-ent-overlay-link");\n        for (const elem of overlayLinks) {\n            $(elem)\n                .off("click")\n                .on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                yield this.showNoValidLicenseDialogHelper(e);\n            }));\n        }\n    }\n    showNoValidLicenseDialogForAnyComment(pageId, macroId, languageService) {\n        const eventBus = languageService.getEventBus();\n        eventBus.on("comments.updated", () => {\n            this.deactivateCommentToggles(pageId, macroId);\n        });\n        this.deactivateCommentToggles(pageId, macroId);\n    }\n    deactivateCommentToggles(pageId, macroId) {\n        const $allCommentToggles = $(`#vxcp-ent-viewer-${pageId}-${macroId}`).find(".vxcp-ent-comments-toggle");\n        $allCommentToggles.off("click");\n        $allCommentToggles.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            yield this.showNoValidLicenseDialogHelper(e);\n        }));\n    }\n    disableAttributePanelForNoValidLicense(macroId) {\n        $(`.vxcp-ent-vbcp-panel-toggle`)\n            .off("click")\n            .on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            yield this.showNoValidLicenseDialogHelper(e);\n        }));\n    }\n    showNoValidLicenseDialogHelper(e) {\n        return __awaiter(this, void 0, void 0, function* () {\n            e.stopPropagation();\n            e.preventDefault();\n            yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.confirmWarningDialog(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .WarningDialogTypeEnum.LICENSE_NOT_VALID */ .K.LICENSE_NOT_VALID);\n        });\n    }\n    showNoValidLicenseDialogForMacroDialog() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.confirmWarningDialog(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .WarningDialogTypeEnum.LICENSE_NOT_VALID */ .K.LICENSE_NOT_VALID)) {\n                this.platformMacroDialog.hideMacroDialog();\n            }\n        });\n    }\n    showNoValidLicenseDialogForConfigurationPage() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.confirmWarningDialog(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .WarningDialogTypeEnum.LICENSE_NOT_VALID */ .K.LICENSE_NOT_VALID)) {\n                const url = this.platformUtils.buildRestUrl("/plugins/servlet/upm");\n                window.open(url, "_self");\n            }\n            const overlay = document.getElementById("vxcp-ent-spinner-overlay");\n            if (overlay) {\n                overlay.style.visibility = "visible";\n            }\n        });\n    }\n    showNoValidLicenseDialogForApp(pageId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.confirmWarningDialog(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .WarningDialogTypeEnum.LICENSE_NOT_VALID */ .K.LICENSE_NOT_VALID)) {\n                _routing_service__WEBPACK_IMPORTED_MODULE_2__/* .openConfluencePage */ .SP(pageId, "_parent");\n            }\n        });\n    }\n    showExpiredLicenseMessageForMacroDialog() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if ($("#vxcp-ent-macro-dialog-message-license").children().length > 0) {\n                return;\n            }\n            this.messageService.setWarningMessage(yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.license.expired.macro-dialog.title"), yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.license.expired.macro-dialog.body"), {\n                identifier: "#vxcp-ent-macro-dialog-message-license",\n                closeable: false,\n            });\n        });\n    }\n    showExpiredLicenseMessageInWelcomeScreenForApp() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const welcomeScreen = document.getElementById("vxcp-ent-dialog-welcome-screen");\n            if (welcomeScreen) {\n                this.messageService.setWarningMessage(yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.license.expired.macro-dialog.title"), yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.license.expired.macro-dialog.body"), {\n                    identifier: "#vxcp-ent-macro-dialog-message-license",\n                    closeable: false,\n                });\n            }\n        });\n    }\n    showExpiredLicenseWarningInNavbarForApp() {\n        $("#vxcp-ent-toolbar-license-warning").removeClass("vxcp-ent-hidden");\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/license.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/macro.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "f": () => (/* binding */ MacroService)\n/* harmony export */ });\n/* harmony import */ var _routing_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/routing.service.ts");\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/warning-dialog-type.enum.ts");\nif (/^bpmnEnt(((NavigatedPrev|V)iewe|Edito)r|Admin|MacroDialog)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/file-type.enum.ts");\n/* harmony import */ var _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts");\nif (/^bpmnEnt(((NavigatedPrev|V)iewe|Edito)r|Admin|MacroDialog)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _id_generator_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/id-generator.service.ts");\n}\nif (/^bpmnEnt(((NavigatedPrev|V)iewe|Edito)r|Admin|MacroDialog)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\nclass MacroService {\n    constructor(enumConverterService) {\n        this.enumConverterService = enumConverterService;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__/* .getPluginService */ .j)().getPluginName(), "MacroService");\n    }\n    createStorageFormatString(macroName, configValues) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const filteredParamKeys = Object.keys(configValues).filter((key) => !!configValues[key]);\n            filteredParamKeys.sort((a, b) => a.localeCompare(b));\n            return `<ac:structured-macro ac:name="${macroName}">` + filteredParamKeys.map((key) => this.getMacroParamAsString(key, configValues[key])).join("") + `</ac:structured-macro>`;\n        });\n    }\n    createEditorInlineFormatString(macroName, configValues) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const filteredParamKeys = Object.keys(configValues).filter((key) => !!configValues[key]);\n            filteredParamKeys.sort((a, b) => a.localeCompare(b));\n            const macroParams = filteredParamKeys.map((key) => `${key}=${configValues[key]}`).join("|");\n            const definition = `{${macroName}:${macroParams}}`;\n            const locale = yield this.platformUtils.getLocale();\n            const imgSrc = this.platformUtils.buildRestUrl(`/plugins/servlet/confluence/placeholder/macro?definition=${btoa(definition)}&locale=${locale}`);\n            return `<img class="editor-inline-macro" src="${imgSrc}" data-macro-name="${macroName}" data-macro-parameters="${macroParams}" data-attachment-copy="">`;\n        });\n    }\n    getMacroId(pageId, diagramName, vbcpEntId, macroKey, freeMacroKey, caseInsensitive, includePageEditor) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const params = yield this.platformUtils.getParams();\n            if (params.newPage) {\n                return "";\n            }\n            const restCall = this.platformUtils.buildRestUrl(`/rest/api/content/${pageId}?expand=body.storage`);\n            const restCallChild = this.platformUtils.buildRestUrl(`/rest/api/content/${pageId}/child/comment?expand=body.storage`);\n            let pageData;\n            let commentsData;\n            try {\n                pageData = yield this.platformUtils.makeRequest({\n                    type: "GET",\n                    url: restCall,\n                });\n                commentsData = yield this.platformUtils.makeRequest({\n                    type: "GET",\n                    url: restCallChild,\n                });\n            }\n            catch (err) {\n                this.vxcpLogger.logWarning("getMacroId", "No page content or comments found. In most cases not a problem if page is new.", err);\n                return "";\n            }\n            return this.getMacroIdFromPageOrCommentsData(pageData, commentsData, diagramName, vbcpEntId, macroKey, freeMacroKey, caseInsensitive, includePageEditor);\n        });\n    }\n    getMacroIdFromPageOrCommentsData(pageData, commentsData, diagramName, vbcpEntId, macroKey, freeMacroKey, caseInsensitive, includePageEditor) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return ((yield this.getMacroIdFromPageData(pageData, diagramName, vbcpEntId, macroKey, freeMacroKey, caseInsensitive, includePageEditor)) ||\n                (yield this.getMacroIdFromCommentsData(commentsData, diagramName, vbcpEntId, macroKey, freeMacroKey, caseInsensitive)) ||\n                "");\n        });\n    }\n    getMacroIdFromPageData(pageData, diagramName, vbcpEntId, macroKey, freeMacroKey, caseInsensitive, includePageEditor) {\n        var _a, _b;\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!((_b = (_a = pageData === null || pageData === void 0 ? void 0 : pageData.body) === null || _a === void 0 ? void 0 : _a.storage) === null || _b === void 0 ? void 0 : _b.value)) {\n                return "";\n            }\n            const url = window.location.pathname;\n            if (!includePageEditor && (url.includes("editpage.action") || url.includes("editblogpost.action") || url.includes("resumedraft.action"))) {\n                return "";\n            }\n            return this.getMacroIdFromContentData(pageData, diagramName, vbcpEntId, macroKey, freeMacroKey, caseInsensitive);\n        });\n    }\n    getMacroIdFromCommentsData(commentsData, diagramName, vbcpEntId, macroKey, freeMacroKey, caseInsensitive) {\n        var _a;\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!((_a = commentsData === null || commentsData === void 0 ? void 0 : commentsData.results) === null || _a === void 0 ? void 0 : _a.length)) {\n                return "";\n            }\n            return commentsData.results.find((comment) => this.getMacroIdFromContentData(comment, diagramName, vbcpEntId, macroKey, freeMacroKey, caseInsensitive));\n        });\n    }\n    getVbcpEntIdByDiagramName(macroKey, pageId, diagramName, restPathOverwrite) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const params = yield this.platformUtils.getParams();\n            if (params.newPage) {\n                return "";\n            }\n            const restUrlBase = restPathOverwrite && restPathOverwrite.length > 1 ? restPathOverwrite : "/rest/api/content";\n            const restUrlPage = this.platformUtils.buildRestUrl(`${restUrlBase}/${pageId}?expand=body.storage`);\n            const restUrlComment = this.platformUtils.buildRestUrl(`${restUrlBase}/${pageId}/child/comment?expand=body.storage`);\n            let pageData;\n            let commentData;\n            try {\n                pageData = yield this.platformUtils.makeRequest({\n                    type: "GET",\n                    url: restUrlPage,\n                });\n                commentData = yield this.platformUtils.makeRequest({\n                    type: "GET",\n                    url: restUrlComment,\n                });\n            }\n            catch (err) {\n                this.vxcpLogger.logWarning("getVbcpEntIdByDiagramName", "No page content or comments found. In most cases not a problem if page is new.", err);\n                return "";\n            }\n            let vbcpEntId = "";\n            const url = window.location.pathname;\n            if (!url.includes("editpage.action") && !url.includes("editblogpost.action") && !url.includes("resumedraft.action")) {\n                vbcpEntId = this.getVbcpEntIdFromContentData(macroKey, pageData, "diagramName", diagramName);\n            }\n            const commentsExist = commentData && commentData.results && commentData.results.length;\n            if ((!vbcpEntId || !vbcpEntId.length) && commentsExist) {\n                commentData.results.forEach((comment) => {\n                    vbcpEntId = this.getVbcpEntIdFromContentData(macroKey, comment, "diagramName", diagramName);\n                    if (vbcpEntId) {\n                        return vbcpEntId;\n                    }\n                });\n            }\n            return vbcpEntId;\n        });\n    }\n    getVbcpEntIdByMacroId(pageId, macroId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const params = yield this.platformUtils.getParams();\n            if (params.newPage) {\n                return "";\n            }\n            const restCall = this.platformUtils.buildRestUrl(`/rest/api/content/${pageId}?expand=body.storage`);\n            const restCallChilds = this.platformUtils.buildRestUrl(`/rest/api/content/${pageId}/child/comment?expand=body.storage`);\n            let pageData;\n            let commentData;\n            try {\n                pageData = yield this.platformUtils.makeRequest({\n                    type: "GET",\n                    url: restCall,\n                });\n                commentData = yield this.platformUtils.makeRequest({\n                    type: "GET",\n                    url: restCallChilds,\n                });\n            }\n            catch (err) {\n                this.vxcpLogger.logWarning("getVbcpEntIdByMacroId", "No page content or comments found. In most cases not a problem if page is new.", err);\n                return "";\n            }\n            let vbcpEntId = "";\n            const url = window.location.pathname;\n            if (!url.includes("editpage.action") && !url.includes("editblogpost.action") && !url.includes("resumedraft.action")) {\n                vbcpEntId = this.getVbcpEntIdFromContentDataByMacroId(pageData, macroId);\n            }\n            const commentsExist = commentData && commentData.results && commentData.results.length;\n            if ((!vbcpEntId || !vbcpEntId.length) && commentsExist) {\n                commentData.results.forEach((comment) => {\n                    vbcpEntId = this.getVbcpEntIdFromContentDataByMacroId(comment, macroId);\n                    if (vbcpEntId) {\n                        return vbcpEntId;\n                    }\n                });\n            }\n            return vbcpEntId;\n        });\n    }\n    isFreeDiagram(diagramType, pageId, diagramName) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const restCall = this.platformUtils.buildRestUrl(`/rest/api/content/${pageId}?expand=body.storage`);\n            let pageData;\n            try {\n                pageData = yield this.platformUtils.makeRequest({\n                    type: "GET",\n                    url: restCall,\n                });\n            }\n            catch (err) {\n                return false;\n            }\n            return this.isFreeDiagramFromContentData(diagramType, pageData, diagramName);\n        });\n    }\n    checkIfActiveMacroExists(diagramName, pageId, macroKey, freeMacroKey) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const macroId = yield this.getMacroId(pageId, diagramName, "", macroKey, freeMacroKey);\n            return macroId.length > 0;\n        });\n    }\n    checkIfActiveMacroExistsFromPageOrCommentData(diagramName, pageData, commentData, macroKey, freeMacroKey, caseInsensitive, includePageEditor) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const macroId = yield this.getMacroIdFromPageOrCommentsData(pageData, commentData, diagramName, "", macroKey, freeMacroKey, caseInsensitive, includePageEditor);\n            return macroId.length > 0;\n        });\n    }\n    getMacroIdFromContentData(dataWithBodyStorage, diagramName, vbcpEntId, enterpriseMacroKey, freeMacroKey, caseInsensitive) {\n        let dataStorageFormat = dataWithBodyStorage.body.storage.value;\n        let diagramNameParamKeyEnterprise = "diagramName";\n        let diagramNameParamKeyFree = enterpriseMacroKey === _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_4__/* .MacroEnterpriseNameEnum.BPMN */ .ib.BPMN ? "diagramName" : "dmnTableName";\n        let vbcpEntIdParameterKey = "vbcpEntId";\n        if (caseInsensitive) {\n            dataStorageFormat = dataStorageFormat.toLowerCase();\n            diagramName = diagramName.toLowerCase();\n            diagramNameParamKeyEnterprise = diagramNameParamKeyEnterprise.toLowerCase();\n            diagramNameParamKeyFree = diagramNameParamKeyFree.toLowerCase();\n            vbcpEntIdParameterKey = vbcpEntIdParameterKey.toLowerCase();\n        }\n        const splitPageDataMacros = dataStorageFormat.split("ac:structured-macro");\n        for (const singleMacro of splitPageDataMacros) {\n            let macroId = "";\n            macroId = this.searchMacroIdByMacroParam(singleMacro, enterpriseMacroKey, diagramNameParamKeyEnterprise, diagramName);\n            if (macroId && macroId.length > 0) {\n                return macroId;\n            }\n            macroId = this.searchMacroIdByMacroParam(singleMacro, enterpriseMacroKey, vbcpEntIdParameterKey, vbcpEntId);\n            if (macroId && macroId.length > 0) {\n                return macroId;\n            }\n            macroId = this.searchMacroIdByMacroParam(singleMacro, freeMacroKey, diagramNameParamKeyFree, diagramName);\n            if (macroId && macroId.length > 0) {\n                return macroId;\n            }\n        }\n        return "";\n    }\n    getVbcpEntIdFromContentData(macroKey, dataWithBodyStorage, parameterKey, parameterValue) {\n        const splitPageDataMacros = dataWithBodyStorage.body.storage.value.split("ac:structured-macro");\n        let vbcpEntId = "";\n        splitPageDataMacros.find((singleMacro) => {\n            const vbcpEntEnterprise = this.searchVbcpEntIdByMacroParam(singleMacro, macroKey, parameterKey, parameterValue);\n            if (vbcpEntEnterprise) {\n                vbcpEntId = vbcpEntEnterprise;\n                return vbcpEntEnterprise;\n            }\n        });\n        return vbcpEntId;\n    }\n    getVbcpEntIdFromContentDataByMacroId(dataWithBodyStorage, macroId) {\n        const splitPageDataMacros = dataWithBodyStorage.body.storage.value.split("ac:structured-macro");\n        const macroKey = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__/* .getPluginService */ .j)().getMacroName();\n        let vbcpEntId = "";\n        splitPageDataMacros.find((singleMacro) => {\n            const vbcpEntEnterprise = this.searchVbcpEntIdbyMacroId(singleMacro, macroKey, macroId);\n            if (vbcpEntEnterprise) {\n                vbcpEntId = vbcpEntEnterprise;\n                return vbcpEntEnterprise;\n            }\n        });\n        return vbcpEntId;\n    }\n    isFreeDiagramFromContentData(diagramType, dataWithBodyStorage, diagramName) {\n        const freeMacroKey = this.enumConverterService.convertEnumValue(diagramType, _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .FileTypeEnum */ .W, _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_4__/* .MacroFreeNameEnum */ .pi);\n        const diagramParameterNameFree = diagramType === _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .FileTypeEnum.BPMN */ .W.BPMN ? "diagramName" : "dmnTableName";\n        const splitPageDataMacros = dataWithBodyStorage.body.storage.value.split("ac:structured-macro");\n        const isFree = splitPageDataMacros.some((singleMacro) => {\n            return this.searchMacroIdByMacroParam(singleMacro, freeMacroKey, diagramParameterNameFree, diagramName);\n        });\n        return isFree;\n    }\n    isFreeDiagramFromCommentsData(diagramType, commentsData, diagramName) {\n        var _a;\n        if (!((_a = commentsData === null || commentsData === void 0 ? void 0 : commentsData.results) === null || _a === void 0 ? void 0 : _a.length)) {\n            return false;\n        }\n        return commentsData.results.some((comment) => this.isFreeDiagramFromContentData(diagramType, comment, diagramName));\n    }\n    checkIfMacroExists(diagramName, pageId, noEditorEntryIfMacroNotExists) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (diagramName.length > 0) {\n                return true;\n            }\n            const targetWindow = noEditorEntryIfMacroNotExists ? "_self" : "_blank";\n            if (yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.confirmWarningDialog(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .WarningDialogTypeEnum.EDITOR_MACRO_NOT_EXIST */ .K.EDITOR_MACRO_NOT_EXIST, undefined, true, !noEditorEntryIfMacroNotExists)) {\n                _routing_service__WEBPACK_IMPORTED_MODULE_0__/* .openConfluencePage */ .SP(pageId, targetWindow);\n            }\n            return false;\n        });\n    }\n    createMacroData(macroName, configValues) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!configValues.shownAttachmentVersion) {\n                configValues.shownAttachmentVersion = "0";\n            }\n            if (!configValues.vbcpEntId) {\n                configValues.vbcpEntId = (0,_id_generator_service__WEBPACK_IMPORTED_MODULE_7__/* .generateVbcpEntId */ .Z)();\n            }\n            return {\n                name: macroName,\n                params: configValues,\n                body: "",\n            };\n        });\n    }\n    searchMacroIdByMacroParam(macroData, macroName, parameterKey, parameterValue) {\n        let macroId = "";\n        const encodedParameterValue = _utils_utils__WEBPACK_IMPORTED_MODULE_1__.encodeToHtmlEntities(parameterValue);\n        if (macroData.indexOf(`ac:name="${macroName}"`) !== -1 && macroData.indexOf(this.getMacroParamAsString(parameterKey, encodedParameterValue)) !== -1) {\n            const splitMacroId = macroData.split(\'ac:macro-id="\');\n            if (splitMacroId.length < 2) {\n                return macroId;\n            }\n            const splitQuotes = splitMacroId[1].split(\'"\');\n            if (!splitQuotes.length) {\n                return macroId;\n            }\n            macroId = splitQuotes[0];\n        }\n        return macroId;\n    }\n    searchVbcpEntIdByMacroParam(macroData, macroName, parameterKey, parameterValue) {\n        let vbcpEntId = "";\n        try {\n            const encodedParameterValue = _utils_utils__WEBPACK_IMPORTED_MODULE_1__.encodeToHtmlEntities(parameterValue);\n            if (macroData.indexOf(`ac:name="${macroName}"`) !== -1 && macroData.indexOf(this.getMacroParamAsString(parameterKey, encodedParameterValue)) !== -1) {\n                const splitId = macroData.split(`ac:name="vbcpEntId">`);\n                const splitEnd = splitId[1].split("<");\n                vbcpEntId = splitEnd[0];\n            }\n        }\n        catch (e) {\n        }\n        return vbcpEntId;\n    }\n    searchVbcpEntIdbyMacroId(macroData, macroName, macroId) {\n        let vbcpEntId = "";\n        try {\n            const encodedParameterValue = _utils_utils__WEBPACK_IMPORTED_MODULE_1__.encodeToHtmlEntities(macroId);\n            const macroIdString = this.getMacroIdAsParameterString(encodedParameterValue);\n            if (macroData.indexOf(`ac:name="${macroName}"`) !== -1 && macroData.indexOf(macroIdString) !== -1) {\n                const splitId = macroData.split(`ac:name="vbcpEntId">`);\n                const splitEnd = splitId[1].split("<");\n                vbcpEntId = splitEnd[0];\n            }\n        }\n        catch (e) {\n        }\n        return vbcpEntId;\n    }\n    getMacroParamAsString(parameterKey, parameterValue) {\n        return `<ac:parameter ac:name="${parameterKey}">${parameterValue}</ac:parameter>`;\n    }\n    getMacroIdAsParameterString(macroId) {\n        return ` ac:macro-id="${macroId}"`;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/macro.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/page.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Ld": () => (/* binding */ getPageIdByConfluencePageUrlAndPageName),\n/* harmony export */   "S4": () => (/* binding */ getPageDataByPageId),\n/* harmony export */   "eG": () => (/* binding */ updateMacroParameterNewPageVersion),\n/* harmony export */   "mC": () => (/* binding */ appendContentToPage),\n/* harmony export */   "rl": () => (/* binding */ getPageContentByPageId),\n/* harmony export */   "ty": () => (/* binding */ putContentBelowViewer),\n/* harmony export */   "ww": () => (/* binding */ getCommentsContentByPageId)\n/* harmony export */ });\n/* unused harmony exports getPageDataByPageNameAndSpaceKey, getPageNameByPageId, getPageBreadcrumbByPageId, getPageIdByPageNameAndSpaceKey, putUpdatedPageVersion */\n/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\nconst PlatformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_0__/* .getPlatformService */ .km)().getPlatformUtils() || {};\nconst getPageDataByPageNameAndSpaceKey = (pageName, spaceKey) => __awaiter(void 0, void 0, void 0, function* () {\n    const restPath = `/rest/api/content?title=${pageName}&spaceKey=${spaceKey}`;\n    const restUrl = PlatformUtils.buildRestUrl(encodeURI(restPath));\n    return PlatformUtils.makeRequest({\n        type: "GET",\n        url: restUrl,\n    });\n});\nconst getPageNameByPageId = (pageId) => __awaiter(void 0, void 0, void 0, function* () {\n    const restPath = `/rest/api/content/${pageId}`;\n    const restUrl = PlatformUtils.buildRestUrl(restPath);\n    return PlatformUtils.makeRequest({\n        type: "GET",\n        url: restUrl,\n    });\n});\nconst getPageBreadcrumbByPageId = (pageId) => __awaiter(void 0, void 0, void 0, function* () {\n    const restPath = `/rest/api/content/${pageId}`;\n    const restUrl = PlatformUtils.buildRestUrl(restPath);\n    return PlatformUtils.makeRequest({\n        type: "GET",\n        url: restUrl,\n    });\n});\nconst getPageIdByPageNameAndSpaceKey = (pageName, spaceKey) => {\n    const restPath = `/rest/api/content?title=${pageName}&spaceKey=${spaceKey}`;\n    const restUrl = PlatformUtils.buildRestUrl(encodeURI(restPath));\n    return PlatformUtils.makeRequest({\n        type: "GET",\n        url: restUrl,\n    });\n};\nconst getPageDataByPageId = (pageId, historicPageVersion) => __awaiter(void 0, void 0, void 0, function* () {\n    let url = PlatformUtils.buildRestUrl(`/rest/api/content/${pageId}?expand=body.storage,version,space`);\n    if (historicPageVersion) {\n        url = url.concat(`&status=historical&version=${historicPageVersion}`);\n    }\n    return yield PlatformUtils.makeRequest({\n        type: "GET",\n        url,\n    });\n});\nconst getPageContentByPageId = (pageId) => __awaiter(void 0, void 0, void 0, function* () {\n    const url = PlatformUtils.buildRestUrl(`/rest/api/content/${pageId}?expand=body.storage`);\n    return yield PlatformUtils.makeRequest({\n        type: "GET",\n        url,\n    });\n});\nconst getCommentsContentByPageId = (pageId) => __awaiter(void 0, void 0, void 0, function* () {\n    const url = PlatformUtils.buildRestUrl(`/rest/api/content/${pageId}/child/comment?expand=body.storage`);\n    return yield PlatformUtils.makeRequest({\n        type: "GET",\n        url,\n    });\n});\nconst getPageIdByConfluencePageUrlAndPageName = (pageUrl, pageNameWithSpace) => __awaiter(void 0, void 0, void 0, function* () {\n    var _a, _b;\n    if (pageUrl.includes("/spaces/")) {\n        if (pageUrl.includes("/pages/")) {\n            const splitUrlByPageId = pageUrl.split("/pages/");\n            const pageIdSubstring = splitUrlByPageId[1];\n            const pageId = pageIdSubstring.split("/")[0];\n            return pageId;\n        }\n        const splittedUrl = pageUrl.split("/");\n        const indexOfSpaces = splittedUrl.findIndex((val) => val === "spaces");\n        const spaceKey = indexOfSpaces > -1 ? splittedUrl[indexOfSpaces + 1] : "";\n        try {\n            const response = yield getPageDataByPageNameAndSpaceKey(pageNameWithSpace, spaceKey);\n            return (_b = (_a = response.results[0]) === null || _a === void 0 ? void 0 : _a.id) !== null && _b !== void 0 ? _b : "";\n        }\n        catch (e) {\n            return "";\n        }\n    }\n    else {\n        const pageName = pageNameWithSpace.split(" (")[0];\n        if (pageUrl.includes("viewpage.action")) {\n            const split = pageUrl.split("=");\n            return split[split.length - 1];\n        }\n        else if (pageUrl.includes("/display/")) {\n            let spaceKey = pageUrl.split("/display/")[1];\n            spaceKey = spaceKey.split("/")[0];\n            const apiCall = yield getPageDataByPageNameAndSpaceKey(pageName, spaceKey);\n            return apiCall.results[0].id;\n        }\n        else {\n            return "";\n        }\n    }\n});\nconst putContentBelowViewer = (pageId, vbcpEntId, newContentBelowMacro = "") => __awaiter(void 0, void 0, void 0, function* () {\n    const pageData = yield getPageDataByPageId(pageId);\n    let storageValue = pageData.body.storage.value;\n    const newPageVersion = pageData.version.number + 1;\n    const singleMacro = findMacroStringByVbcpEntId(storageValue, vbcpEntId);\n    if (singleMacro) {\n        let updatedMacro = singleMacro;\n        updatedMacro = updatedMacro.concat(newContentBelowMacro);\n        const cleanUpdatedMacro = updatedMacro.replace(/\\$/g, "$$$$");\n        storageValue = storageValue.replace(singleMacro, cleanUpdatedMacro);\n    }\n    return yield putUpdatedPageVersion(pageId, pageData, newPageVersion, storageValue);\n});\nconst appendContentToPage = (pageId, content) => __awaiter(void 0, void 0, void 0, function* () {\n    const pageData = yield getPageDataByPageId(pageId);\n    const storageValue = pageData.body.storage.value;\n    const newPageVersion = pageData.version.number + 1;\n    let updatedStorageValue;\n    if (storageValue.endsWith("</ac:layout>")) {\n        content = `<ac:layout-section ac:type="single"><ac:layout-cell><p>${content}</p></ac:layout-cell></ac:layout-section>`;\n        updatedStorageValue = storageValue.replace("</ac:layout>", `${content}</ac:layout>`);\n    }\n    else {\n        updatedStorageValue = storageValue.concat(`<p>${content}</p>`);\n    }\n    return yield putUpdatedPageVersion(pageId, pageData, newPageVersion, updatedStorageValue);\n});\nconst updateMacroParameterNewPageVersion = (pageId, vbcpEntId, parameterKey, newParameterValue) => __awaiter(void 0, void 0, void 0, function* () {\n    const pageData = yield getPageDataByPageId(pageId);\n    let storageValue = pageData.body.storage.value;\n    const newPageVersion = pageData.version.number + 1;\n    const singleMacro = findMacroStringByVbcpEntId(storageValue, vbcpEntId);\n    if (singleMacro) {\n        let updatedMacro = singleMacro;\n        const newParamString = `<ac:parameter ac:name="${parameterKey}">${newParameterValue}</ac:parameter>`;\n        const oldParamRegExp = new RegExp(`<ac:parameter ac:name="${parameterKey}">(\\\\w|\\\\s|-|,|#)<\\/ac:parameter>`, "g");\n        const oldParamStrings = updatedMacro.match(oldParamRegExp);\n        if (!oldParamStrings || !oldParamStrings.length) {\n            updatedMacro = updatedMacro.replace("</ac:structured-macro>", `${newParamString}</ac:structured-macro>`);\n        }\n        else {\n            updatedMacro = updatedMacro.replace(oldParamStrings[0], newParamString);\n        }\n        const cleanUpdatedMacro = updatedMacro.replace(/\\$/g, "$$$$");\n        storageValue = storageValue.replace(singleMacro, cleanUpdatedMacro);\n    }\n    return yield putUpdatedPageVersion(pageId, pageData, newPageVersion, storageValue);\n});\nconst putUpdatedPageVersion = (pageId, pageData, pageVersion, storageValue, minorEdit = true) => __awaiter(void 0, void 0, void 0, function* () {\n    const newPageBody = {\n        version: {\n            number: pageVersion,\n            minorEdit,\n        },\n        id: pageData.id,\n        key: pageData.space.key,\n        title: pageData.title,\n        type: pageData.type,\n        body: {\n            storage: {\n                value: storageValue,\n                representation: pageData.body.storage.representation,\n            },\n        },\n    };\n    return yield PlatformUtils.makeRequest({\n        type: "PUT",\n        url: PlatformUtils.buildRestUrl(`/rest/api/content/${pageId}`),\n        data: JSON.stringify(newPageBody),\n        headers: {\n            "X-Atlassian-Token": "no-check",\n            "Content-Type": "application/json",\n            Accept: "application/json",\n        },\n    }, "application/json");\n});\nconst findMacroStringByVbcpEntId = (storageValue, vbcpEntId) => {\n    let foundMacro = "";\n    const allMacrosArray = storageValue.split("<ac:structured-macro ");\n    allMacrosArray.forEach((singleMacro) => {\n        if (singleMacro.length > 5 && singleMacro.includes(`ac:name="vbcpEntId">${vbcpEntId}<`)) {\n            const endOfMacroString = `</ac:structured-macro>`;\n            const endOfMacroIndex = singleMacro.indexOf(endOfMacroString);\n            foundMacro = singleMacro.slice(0, endOfMacroIndex + endOfMacroString.length);\n        }\n    });\n    return foundMacro;\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/page.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/routing.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "$w": () => (/* binding */ getUserManualLinkForNavigationbar),\n/* harmony export */   "CY": () => (/* binding */ getUrlPreviewOtherApp),\n/* harmony export */   "El": () => (/* binding */ buildDownloadAttachmentUrl),\n/* harmony export */   "En": () => (/* binding */ getUrlAppSamePlugin),\n/* harmony export */   "Gz": () => (/* binding */ getModelerTutorialVideoBucketURL),\n/* harmony export */   "JR": () => (/* binding */ createUrlPng),\n/* harmony export */   "PI": () => (/* binding */ getUrlConfluencePage),\n/* harmony export */   "SE": () => (/* binding */ getErrorIframe),\n/* harmony export */   "SP": () => (/* binding */ openConfluencePage),\n/* harmony export */   "Sz": () => (/* binding */ createGeneralImageTag),\n/* harmony export */   "XR": () => (/* binding */ getUrlCollectionFromBucket),\n/* harmony export */   "Xu": () => (/* binding */ getUrlCollectionBucketURL),\n/* harmony export */   "cG": () => (/* binding */ getUrlAppByOverlayType),\n/* harmony export */   "eb": () => (/* binding */ createDmnFreeIFrame),\n/* harmony export */   "gp": () => (/* binding */ getUrlAppOtherPlugin),\n/* harmony export */   "hO": () => (/* binding */ createViewerIFrame),\n/* harmony export */   "nU": () => (/* binding */ getDmnFreeIframeLink),\n/* harmony export */   "oJ": () => (/* binding */ getNewsContentBucketURL),\n/* harmony export */   "z2": () => (/* binding */ isUrlHealthy)\n/* harmony export */ });\n/* unused harmony exports getStorageBucketUrlPrefix, getUrlConfluencePageEditor */\n/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n/* harmony import */ var _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\n/* harmony import */ var _model_enum_dmn_table_mode_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dmn-table-mode.enum.ts");\n/* harmony import */ var _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts");\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _model_enum_app_rest_path_enum__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-rest-path.enum.ts");\n/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\nconst PlatformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n\nconst vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__/* .getPluginService */ .j)().getPluginName(), "RoutingService");\nconst IFRAME_ERROR_AUTO_OPEN_DELAY = 500;\nconst getAppActionPathByLinkOverlayType = (overlayType) => {\n    let path = "";\n    switch (overlayType) {\n        case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .OverlayTypeXmlEnum.DMN_ENTERPRISE */ .ws.DMN_ENTERPRISE:\n        case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .OverlayTypeXmlEnum.DMN */ .ws.DMN:\n            path = _model_enum_app_rest_path_enum__WEBPACK_IMPORTED_MODULE_4__/* .EnterpriseActionPathEnum.DMN */ .EN.DMN;\n            break;\n        case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .OverlayTypeXmlEnum.BPMN */ .ws.BPMN:\n            path = _model_enum_app_rest_path_enum__WEBPACK_IMPORTED_MODULE_4__/* .EnterpriseActionPathEnum.BPMN */ .EN.BPMN;\n            break;\n    }\n    return path;\n};\nconst getUrlCollectionFromBucket = () => __awaiter(void 0, void 0, void 0, function* () {\n    const url = getUrlCollectionBucketURL();\n    return yield PlatformUtils.makeRequest({\n        url,\n        method: "GET",\n        dataType: "json",\n        contentType: "application/json",\n    });\n});\nconst getStorageBucketUrlPrefix = () => {\n    if (false) {}\n    else {\n        return "https://storage.googleapis.com/viadee-atlassian-plugins-prod-storage-bucket";\n    }\n};\nconst getNewsContentBucketURL = () => {\n    const prefix = getStorageBucketUrlPrefix();\n    return `${prefix}/bpmn-modeler-news-content.json`;\n};\nconst getUrlCollectionBucketURL = () => {\n    const prefix = getStorageBucketUrlPrefix();\n    return `${prefix}/url-collection.json`;\n};\nconst getUserManualLinkForNavigationbar = () => __awaiter(void 0, void 0, void 0, function* () {\n    const url = getUrlCollectionBucketURL();\n    const data = yield PlatformUtils.makeRequest({\n        url,\n        method: "GET",\n        dataType: "json",\n        contentType: "application/json",\n    });\n    const linkCollection = data.result;\n    return (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__/* .getPluginService */ .j)().getUserManualSubprocesses(linkCollection);\n});\nconst getModelerTutorialVideoBucketURL = () => {\n    const prefix = getStorageBucketUrlPrefix();\n    const filePath = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_5__/* .getPluginService */ .j)().getModelerTutorialVideoBucketURL();\n    return `${prefix}${filePath}`;\n};\nconst getUrlAppSamePlugin = (routingParams) => {\n    const appPathComponent = (0,_model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__/* .getLanguageRestService */ .GU)().getPluginEditorActionComponent();\n    return getUrlApp(appPathComponent, routingParams);\n};\nconst getUrlAppByOverlayType = (overlayType, routingParams) => __awaiter(void 0, void 0, void 0, function* () {\n    let appPathComponent = getAppActionPathByLinkOverlayType(overlayType);\n    if (!appPathComponent) {\n        appPathComponent = (0,_model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__/* .getLanguageRestService */ .GU)().getPluginEditorActionComponent();\n    }\n    return getUrlApp(appPathComponent, routingParams);\n});\nconst getUrlApp = (appPathComponent, routingParams) => __awaiter(void 0, void 0, void 0, function* () {\n    const editDiagramPath = `/plugins/${appPathComponent}/edit-diagram.action`;\n    let queryParams = `?pageId=${routingParams.pageId}&vbcpEntId=${routingParams.vbcpEntId}&appMode=${routingParams.appMode}&fromMode=${routingParams.fromMode}`;\n    queryParams = routingParams.diagramVersion ? queryParams.concat(`&version=${routingParams.diagramVersion}`) : queryParams;\n    const restPath = yield PlatformUtils.addTokenToUrl(`${editDiagramPath}${queryParams}`);\n    return PlatformUtils.buildRestUrl(restPath);\n});\nconst getUrlPreviewOtherApp = (routingParams, diagramName) => __awaiter(void 0, void 0, void 0, function* () {\n    const appPathComponent = (0,_model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__/* .getLanguageRestService */ .GU)().getPluginRestComponentOtherApp();\n    const actionPath = `/plugins/${appPathComponent}/preview-diagram.action`;\n    let queryParams = `?pageId=${routingParams.pageId}&vbcpEntId=${routingParams.vbcpEntId}&diagramName=${diagramName}`;\n    queryParams = routingParams.diagramVersion ? queryParams.concat(`&shownAttachmentVersion=${routingParams.diagramVersion}`) : queryParams;\n    const restPath = yield PlatformUtils.addTokenToUrl(`${actionPath}${queryParams}`);\n    return PlatformUtils.buildRestUrl(restPath);\n});\nconst getUrlAppOtherPlugin = (routingParams) => __awaiter(void 0, void 0, void 0, function* () {\n    const appPathComponent = (0,_model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__/* .getLanguageRestService */ .GU)().getPluginEditorActionComponentOtherApp();\n    return getUrlApp(appPathComponent, routingParams);\n});\nconst getUrlConfluencePage = (pageId) => {\n    return PlatformUtils.buildRestUrl(`/pages/viewpage.action?pageId=${pageId}`);\n};\nconst getUrlConfluencePageEditor = (pageId) => {\n    return PlatformUtils.buildRestUrl(`/pages/editpage.action?pageId=${pageId}`);\n};\nconst openConfluencePage = (pageId, targetWindow) => {\n    window.open(getUrlConfluencePage(pageId), targetWindow);\n};\nfunction getDmnFreeIframeLink(pageId, dmnTableName, mode) {\n    const dmnTableId = _utils_utils__WEBPACK_IMPORTED_MODULE_3__.createDmnTableId(dmnTableName);\n    return PlatformUtils.buildRestUrl(`/plugins/dmn-plugin/${mode}-dmntable.action?pageId=${pageId}&dmnTableId=${dmnTableId}&dmnTableName=${dmnTableName}&editorFromLink=true`);\n}\nconst createUrlPng = (diagramName, pageId, version) => {\n    let restPath = `/download/attachments/${pageId}/${diagramName}.png`;\n    restPath = version ? restPath.concat(`?version=${version}`) : restPath;\n    return PlatformUtils.buildRestUrl(restPath);\n};\nconst buildDownloadAttachmentUrl = (pageId, attachmentName) => {\n    return PlatformUtils.buildRestUrl(`/download/attachments/${pageId}/${attachmentName}`);\n};\nconst isUrlHealthy = (url) => __awaiter(void 0, void 0, void 0, function* () {\n    try {\n        yield PlatformUtils.makeRequest({\n            type: "HEAD",\n            url,\n        });\n        return true;\n    }\n    catch (e) {\n        return false;\n    }\n});\nconst createViewerIFrame = (url, readyCallback) => __awaiter(void 0, void 0, void 0, function* () {\n    const iframe = document.createElement("iframe");\n    iframe.setAttribute("id", "vxcp-ent-dialog-preview-diagram-app");\n    iframe.setAttribute("style", "position: absolute; width: 100%; height: 100%; top: 0px; left: 0px; border: 0px none; z-index: 3000;");\n    iframe.setAttribute("src", url);\n    iframe.onload = () => {\n        handleIframeLoad(readyCallback);\n    };\n    iframe.onerror = () => {\n        handleIframeError();\n    };\n    return iframe;\n});\nconst getErrorIframe = (readyCallback) => __awaiter(void 0, void 0, void 0, function* () {\n    const iframe = document.createElement("iframe");\n    iframe.setAttribute("id", "vxcp-ent-dialog-preview-diagram-app");\n    iframe.setAttribute("style", "position: absolute; width: 100%; height: 100%; top: 0px; left: 0px; border: 0px none; z-index: 3000;");\n    iframe.onload = () => {\n        handleIframeLoad(readyCallback);\n        handleIframeError();\n    };\n    return iframe;\n});\nconst handleIframeLoad = (readyCallback) => __awaiter(void 0, void 0, void 0, function* () {\n    $("body").css("overflow", "hidden");\n    $("#vxcp-ent-viewer-dialog #vxcp-ent-diagram-loading").hide();\n    if (readyCallback) {\n        readyCallback();\n    }\n});\nconst handleIframeError = () => __awaiter(void 0, void 0, void 0, function* () {\n    const bIsCloudApp = PlatformUtils.isCloudApp();\n    const errorTextKey = bIsCloudApp\n        ? "de.viadee.confluence.viadee-plugin-enterprise.preview-diagram-dialog.error.cloud"\n        : "de.viadee.confluence.viadee-plugin-enterprise.preview-diagram-dialog.error";\n    const errorText = yield PlatformUtils.getText(errorTextKey);\n    $("#vxcp-ent-dialog-preview-diagram-app").parent().text(errorText);\n    if (bIsCloudApp) {\n        setTimeout(() => {\n            $("#vxcp-ent-dialog-show-diagram-goto-confluence-page").click();\n        }, IFRAME_ERROR_AUTO_OPEN_DELAY);\n    }\n});\nconst createDmnFreeIFrame = (pageId, dmnTableName) => {\n    const iframe = document.createElement("iframe");\n    iframe.setAttribute("id", "vxcp-ent-dialog-dmn-editor");\n    iframe.setAttribute("style", "position: absolute; width: 100%; height: 100%; top: 0px; left: 0px; border: 0px none; z-index: 3000;");\n    iframe.setAttribute("src", getDmnFreeIframeLink(pageId, dmnTableName, _model_enum_dmn_table_mode_enum__WEBPACK_IMPORTED_MODULE_1__/* .DmnTableModeEnum.VIEWER */ .J.VIEWER));\n    iframe.onload = () => {\n        $("body").css("overflow", "hidden");\n        $(".vxcp-ent-dialog-show-diagram-header #vxcp-ent-diagram-loading").hide();\n        $("#vxcp-ent-dialog-dmn-editor").contents().find(".dmntable-title").hide();\n    };\n    return iframe;\n};\nconst createGeneralImageTag = (url) => __awaiter(void 0, void 0, void 0, function* () {\n    const image = document.createElement("img");\n    const errorText = yield PlatformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.preview-attachment-dialog.error");\n    image.setAttribute("id", "vxcp-ent-dialog-preview-attachment-image");\n    image.setAttribute("src", url);\n    image.onload = () => {\n        $("body").css("overflow", "hidden");\n    };\n    image.onerror = () => {\n        $("#vxcp-ent-dialog-preview-attachment-image").parent().text(errorText);\n    };\n    return image;\n});\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/routing.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/space-bpmn-elements-config-rest.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "F": () => (/* binding */ SpaceBpmnElementsConfigRestService)\n/* harmony export */ });\nif (/^bpmnEnt(Editor|SpaceAdminPage)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\nif (/^bpmnEnt(Editor|SpaceAdminPage)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _model_configs_default_bpmn_elements_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/configs/default-bpmn-elements.config.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nclass SpaceBpmnElementsConfigRestService {\n    constructor() {\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.spaceKey = "";\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__/* .getPluginService */ .j)().getPluginName(), "SpaceBpmnElementsConfigRestService");\n        const languageRestService = _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__/* .getLanguageRestService */ .GU();\n        const appPathComponent = languageRestService.getPluginRestComponent();\n        this.restPathComponent = `/rest/${appPathComponent}/1.0`;\n    }\n    init(spaceKey) {\n        this.spaceKey = spaceKey;\n    }\n    updateBpmnElementsConfig(bpmnElementsConfig) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/spaceConfig/${this.spaceKey}/bpmnElementsConfig`);\n            const headers = { "X-Atlassian-Token": "no-check" };\n            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n                yield this.platformUtils\n                    .makeRequest({\n                    url,\n                    headers,\n                    type: "POST",\n                    contentType: "application/json",\n                    data: JSON.stringify(bpmnElementsConfig),\n                    cache: false,\n                })\n                    .then((response) => {\n                    resolve(response);\n                })\n                    .catch((err) => {\n                    this.vxcpLogger.logError("updateBpmnElementsConfig", "POST request was rejected.", err);\n                    reject(err);\n                });\n            }));\n        });\n    }\n    deleteBpmnElementsConfig(bpmnElementsGroup) {\n        const url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/spaceConfig/${this.spaceKey}/bpmnElementsConfig?bpmnElementsGroup=${bpmnElementsGroup}`);\n        const headers = { "X-Atlassian-Token": "no-check" };\n        return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n            yield this.platformUtils\n                .makeRequest({\n                url,\n                headers,\n                type: "DELETE",\n                contentType: "application/json",\n                cache: false,\n            })\n                .then((response) => {\n                resolve(response);\n            })\n                .catch((err) => {\n                this.vxcpLogger.logError("deleteBpmnElementsConfig", "DELETE request was rejected.", err);\n                reject(err);\n            });\n        }));\n    }\n    getBpmnElementsConfig() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/spaceConfig/${this.spaceKey}/bpmnElementsConfig`);\n            const headers = { "X-Atlassian-Token": "no-check" };\n            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n                yield this.platformUtils\n                    .makeRequest({\n                    url,\n                    headers,\n                    type: "GET",\n                    contentType: "application/json",\n                    cache: false,\n                })\n                    .then((response) => {\n                    resolve(response);\n                })\n                    .catch((err) => {\n                    this.vxcpLogger.logError("getBpmnElementsConfig", "GET request was rejected.", err);\n                    resolve(_model_configs_default_bpmn_elements_config__WEBPACK_IMPORTED_MODULE_1__/* .defaultBpmnElementsConfig */ .f);\n                });\n            }));\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/space-bpmn-elements-config-rest.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/space-linter-config-rest.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "x": () => (/* binding */ SpaceLinterConfigRestService)\n/* harmony export */ });\nif (/^bpmnEnt(Editor|SpaceAdminPage)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\nif (/^bpmnEnt(Editor|SpaceAdminPage)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _model_configs_default_linter_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/configs/default-linter.config.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nclass SpaceLinterConfigRestService {\n    constructor() {\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.spaceKey = "";\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__/* .getPluginService */ .j)().getPluginName(), "SpaceLinterConfigRestService");\n        const languageRestService = _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__/* .getLanguageRestService */ .GU();\n        const appPathComponent = languageRestService.getPluginRestComponent();\n        this.restPathComponent = `/rest/${appPathComponent}/1.0`;\n    }\n    init(spaceKey) {\n        this.spaceKey = spaceKey;\n    }\n    updateLinterConfig(linterConfig) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/spaceConfig/${this.spaceKey}/linter`);\n            const headers = { "X-Atlassian-Token": "no-check" };\n            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n                yield this.platformUtils\n                    .makeRequest({\n                    url,\n                    headers,\n                    type: "POST",\n                    contentType: "application/json",\n                    data: JSON.stringify(linterConfig),\n                    cache: false,\n                })\n                    .then((response) => {\n                    resolve(response);\n                })\n                    .catch((err) => {\n                    this.vxcpLogger.logError("updateLinterConfig", "POST request was rejected.", err);\n                    reject(err);\n                });\n            }));\n        });\n    }\n    getLinterConfig() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/spaceConfig/${this.spaceKey}/linter`);\n            const headers = { "X-Atlassian-Token": "no-check" };\n            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n                yield this.platformUtils\n                    .makeRequest({\n                    url,\n                    headers,\n                    type: "GET",\n                    contentType: "application/json",\n                    cache: false,\n                })\n                    .then((response) => {\n                    resolve(response);\n                })\n                    .catch((err) => {\n                    this.vxcpLogger.logError("getLinterConfig", "GET request was rejected.", err);\n                    resolve(_model_configs_default_linter_config__WEBPACK_IMPORTED_MODULE_1__/* .defaultLinterConfig */ .m);\n                });\n            }));\n        });\n    }\n    resetLinterConfig() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.platformUtils.buildRestUrl(`${this.restPathComponent}/spaceConfig/${this.spaceKey}/linter`);\n            const headers = { "X-Atlassian-Token": "no-check" };\n            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {\n                yield this.platformUtils\n                    .makeRequest({\n                    url,\n                    headers,\n                    type: "DELETE",\n                    contentType: "application/json",\n                    cache: false,\n                })\n                    .then((response) => {\n                    resolve(response);\n                })\n                    .catch((err) => {\n                    this.vxcpLogger.logError("resetLinterConfig", "DELETE request was rejected.", err);\n                    reject(err);\n                });\n            }));\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/space-linter-config-rest.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/upgrade.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "V": () => (/* binding */ UpgradeService)\n/* harmony export */ });\n/* harmony import */ var _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\nif ("bpmnEntAdmin" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nif ("bpmnEntAdmin" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nclass UpgradeService {\n    constructor() {\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.getUpgradeProgessUrl = `/rest/api/longtask`;\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__/* .getPluginService */ .j)().getPluginName(), "UpgradeService");\n        this.languageRestService = _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__/* .getLanguageRestService */ .GU();\n        const restPathComponent = this.languageRestService.getPluginRestComponent();\n        this.startUpgradeTaskUrl = `/admin/plugins/${restPathComponent}/doupgradetask.action`;\n    }\n    startUpgradeTask(upgradeType, contentKey) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let urlParams = `?upgradeType=${upgradeType}`;\n            urlParams = contentKey && contentKey.length ? urlParams.concat(`&contentKey=${contentKey}`) : urlParams;\n            const restPath = `${this.startUpgradeTaskUrl}${urlParams}`;\n            const restUrl = this.platformUtils.buildRestUrl(restPath);\n            const xhr = new XMLHttpRequest();\n            xhr.open("POST", restUrl, true);\n            const maxWaitTime = 10000;\n            const noResponseTimer = setTimeout(() => {\n                xhr.abort();\n                return {\n                    status: 503,\n                    message: "Service unreachable",\n                };\n            }, maxWaitTime);\n            xhr.onload = () => {\n                clearTimeout(noResponseTimer);\n            };\n            xhr.onerror = () => {\n                clearTimeout(noResponseTimer);\n            };\n            xhr.send();\n            return xhr;\n        });\n    }\n    getUpgradeProgress(upgradeTaskId) {\n        const specificTaskExtension = upgradeTaskId ? `/${upgradeTaskId}` : "";\n        const restPath = this.getUpgradeProgessUrl.concat(specificTaskExtension);\n        const restUrl = this.platformUtils.buildRestUrl(restPath);\n        const xhr = new XMLHttpRequest();\n        xhr.open("GET", restUrl, true);\n        const maxWaitTime = 10000;\n        const noResponseTimer = setTimeout(() => {\n            xhr.abort();\n            return {\n                status: 503,\n                message: "Service unreachable",\n            };\n        }, maxWaitTime);\n        xhr.onload = () => {\n            clearTimeout(noResponseTimer);\n        };\n        xhr.onerror = () => {\n            clearTimeout(noResponseTimer);\n        };\n        xhr.send();\n        return xhr;\n    }\n    startAnalysis() {\n        const appPathComponent = this.languageRestService.getPluginRestComponent();\n        const restPath = `/rest/${appPathComponent}/1.0/upgrade/start-analysis`;\n        const restUrl = this.platformUtils.buildRestUrl(restPath);\n        return this.platformUtils.makeRequest({\n            type: "GET",\n            url: restUrl,\n        });\n    }\n    getRunningTaskId(onlyNotCompletedTasks) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return new Promise((resolve) => {\n                const allTasksRequest = this.getUpgradeProgress();\n                allTasksRequest.onload = () => {\n                    const allTasks = JSON.parse(allTasksRequest.response);\n                    if (allTasks.size > 0) {\n                        allTasks.results.forEach((task) => {\n                            if (task.name.translation === "upgrade.task.name") {\n                                if (onlyNotCompletedTasks && task.percentageComplete >= 100) {\n                                    return;\n                                }\n                                resolve(task.id);\n                            }\n                        });\n                    }\n                    resolve("");\n                };\n            });\n        });\n    }\n    killAllRunningTasks() {\n        return __awaiter(this, void 0, void 0, function* () {\n            let runningTaskId = (yield this.getRunningTaskId(false));\n            do {\n                yield this.startUpgradeTask("killRunningTask", runningTaskId);\n                runningTaskId = (yield this.getRunningTaskId(false));\n            } while (runningTaskId);\n        });\n    }\n    checkFreeMacroVersionsBeforeMigration(installedFreePluginVersion, freePluginVersionUpToDate) {\n        if (installedFreePluginVersion.length === 0 || freePluginVersionUpToDate.length === 0) {\n            this.vxcpLogger.logError("checkFreeMacroVersionsBeforeMigration", `One of the following parameters has length 0 installedFreePluginVersion: ${installedFreePluginVersion}, freePluginVersionUpToDate: ${freePluginVersionUpToDate}`);\n            return false;\n        }\n        for (let i = 0; i < Math.min(installedFreePluginVersion.length, freePluginVersionUpToDate.length); i++) {\n            const installedFreePluginVersionNumberOnly = this.prepareStringForIntParsing(installedFreePluginVersion[i]);\n            const freePluginVersionUpToDateNumberOnly = this.prepareStringForIntParsing(freePluginVersionUpToDate[i]);\n            const versionInstalled = parseInt(installedFreePluginVersionNumberOnly);\n            if (Number.isNaN(versionInstalled)) {\n                return false;\n            }\n            const versionUpToDate = parseInt(freePluginVersionUpToDateNumberOnly);\n            if (Number.isNaN(versionUpToDate)) {\n                return true;\n            }\n            if (versionInstalled < versionUpToDate) {\n                return false;\n            }\n            if (versionInstalled > versionUpToDate) {\n                return true;\n            }\n        }\n        if (installedFreePluginVersion.length !== freePluginVersionUpToDate.length) {\n            return installedFreePluginVersion.length >= freePluginVersionUpToDate.length;\n        }\n        return true;\n    }\n    prepareStringForIntParsing(stringToBeParsed) {\n        const regex = new RegExp("[^0-9]");\n        const stringShouldBeParsed = regex.test(stringToBeParsed);\n        if (stringShouldBeParsed) {\n            const splittedString = stringToBeParsed.split("-", 1);\n            return splittedString[0];\n        }\n        return stringToBeParsed;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/upgrade.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/user-properties.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "V": () => (/* binding */ UserPropertiesService)\n/* harmony export */ });\n/* harmony import */ var _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\nif ("bpmnEntEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nif ("bpmnEntEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\nclass UserPropertiesService {\n    constructor(platformUtils) {\n        this.platformUtils = platformUtils;\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__/* .getPluginService */ .j)().getPluginName(), "UserPropertiesService");\n        this.languageRestService = _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__/* .getLanguageRestService */ .GU();\n        const appPathComponent = this.languageRestService.getPluginRestComponent();\n        this.restUrl = `/rest/${appPathComponent}/1.0/user`;\n    }\n    updateShowWelcomeScreen(showWelcomeScreen) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const restPath = `${this.restUrl}/setShowWelcomeScreen`;\n            const url = this.platformUtils.buildRestUrl(restPath);\n            const showWelcomeScreenDto = { value: showWelcomeScreen };\n            yield this.makeUserPropertyRequest(url, JSON.stringify(showWelcomeScreenDto), (error) => __awaiter(this, void 0, void 0, function* () {\n                this.vxcpLogger.logError("updateShowWelcomeScreen", "Could not update value", error);\n            }));\n        });\n    }\n    updateShowUserSurvey2022(showUserSurvey2022) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const restPath = `${this.restUrl}/setShowUserSurvey2022`;\n            const url = this.platformUtils.buildRestUrl(restPath);\n            const showUserSurvey2022Dto = { value: showUserSurvey2022 };\n            yield this.makeUserPropertyRequest(url, JSON.stringify(showUserSurvey2022Dto), (error) => __awaiter(this, void 0, void 0, function* () {\n                this.vxcpLogger.logError("updateShowUserSurvey2022", "Could not update value", error);\n            }));\n        });\n    }\n    updateLastNewsSeenDate(updatedLastSeenDate) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const restPath = `${this.restUrl}/lastNewsSeenDate`;\n            const url = this.platformUtils.buildRestUrl(restPath);\n            const updatedLastSeenDateDto = { value: updatedLastSeenDate };\n            yield this.makeUserPropertyRequest(url, JSON.stringify(updatedLastSeenDateDto), (error) => __awaiter(this, void 0, void 0, function* () {\n                this.vxcpLogger.logError("updateLastNewsSeenDate", "Could not update value", error);\n            }));\n        });\n    }\n    updateIsMinimapOpen(isMinimapOpen) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const restPath = `${this.restUrl}/isMinimapOpen`;\n            const url = this.platformUtils.buildRestUrl(restPath);\n            const isMinimapOpenDto = { value: isMinimapOpen };\n            yield this.makeUserPropertyRequest(url, JSON.stringify(isMinimapOpenDto), (error) => __awaiter(this, void 0, void 0, function* () {\n                this.vxcpLogger.logError("updateIsMinimapOpen", "Could not update minimap open value", error);\n            }));\n        });\n    }\n    updateIsAttributePanelOpen(isAttributePanelOpen) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const restPath = `${this.restUrl}/isAttributePanelOpen`;\n            const url = this.platformUtils.buildRestUrl(restPath);\n            const isAttributePanelOpenDto = { value: isAttributePanelOpen };\n            yield this.makeUserPropertyRequest(url, JSON.stringify(isAttributePanelOpenDto), (error) => __awaiter(this, void 0, void 0, function* () {\n                this.vxcpLogger.logError("updateIsAttributePanelOpen", "Could not update Attribute Panel open value", error);\n            }));\n        });\n    }\n    makeUserPropertyRequest(url, data, errorCallback, type = "PUT", headers = { "X-Atlassian-Token": "no-check" }, contentType = "application/json", processData = false) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return this.platformUtils.makeRequest({\n                url,\n                type,\n                cache: false,\n                data,\n                headers,\n                processData,\n                contentType,\n                error: (error) => __awaiter(this, void 0, void 0, function* () {\n                    yield errorCallback(error);\n                }),\n            });\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/user-properties.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/color-sync.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "q": () => (/* binding */ ColorSyncService)\n/* harmony export */ });\nvar Color;\n(function (Color) {\n    Color["DEFAULT_COLOR"] = "#ffffff";\n    Color["TMP_COLOR"] = "#787878";\n})(Color || (Color = {}));\nclass ColorSyncService {\n    constructor(validator) {\n        this.validator = validator;\n        this.color = Object.create({});\n        this.text = Object.create({});\n        this.error = Object.create({});\n        return;\n    }\n    init(colorId, textId, errorId, call) {\n        this.color = document.querySelector(colorId);\n        this.text = document.querySelector(textId);\n        if (errorId) {\n            this.error = document.querySelector(errorId);\n        }\n        else {\n            this.error = document.createElement("span");\n        }\n        this.callback = call;\n        this.registerListeners();\n    }\n    getColor() {\n        return this.color.value;\n    }\n    setColor(colorString) {\n        const color = this.addHash(colorString);\n        if (this.validator.validateColor(color)) {\n            this.color.value = color;\n            this.text.value = color;\n            return;\n        }\n    }\n    registerListeners() {\n        this.color.addEventListener("click", () => {\n            if (this.text.value === Color.DEFAULT_COLOR) {\n                this.color.value = Color.TMP_COLOR;\n            }\n        });\n        this.color.addEventListener("input", (e) => {\n            this.colorChanged(e.target.value);\n        });\n        this.text.addEventListener("input", (e) => {\n            this.colorChanged(e.target.value);\n        });\n    }\n    addHash(color) {\n        if (!color.startsWith("#")) {\n            color = `#${color}`;\n        }\n        return color;\n    }\n    colorChanged(newColor) {\n        newColor = this.addHash(newColor);\n        newColor = newColor === Color.TMP_COLOR ? Color.DEFAULT_COLOR : newColor;\n        if (this.validator.validateColor(newColor) === true) {\n            if (this.text.value !== newColor) {\n                this.text.value = newColor;\n            }\n            if (this.color.value !== newColor) {\n                this.color.value = newColor;\n            }\n            this.error.classList.add("vxcp-ent-hidden");\n            this.text.classList.remove("invalid");\n            if (this.callback) {\n                this.callback(newColor);\n            }\n            return;\n        }\n        this.error.classList.remove("vxcp-ent-hidden");\n        this.text.classList.add("invalid");\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/color-sync.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/color.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "x": () => (/* binding */ ColorService)\n/* harmony export */ });\n/* harmony import */ var lodash_debounce__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/node_modules/lodash/debounce.js");\n/* harmony import */ var lodash_debounce__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_debounce__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _model_enum_browser_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/browser.enum.ts");\n/* harmony import */ var _utils_browser_factory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/browser.factory.ts");\n/* harmony import */ var _model_language_empty_language_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/empty-language.service.ts");\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\nvar Color;\n(function (Color) {\n    Color["DEFAULT_FILL_COLOR"] = "#ffffff";\n    Color["DEFAULT_STROKE_COLOR"] = "#000000";\n    Color["DEFAULT_FONT_COLOR"] = "#000000";\n    Color["TMP_COLOR"] = "#787878";\n})(Color || (Color = {}));\nvar ColorTypeEnum;\n(function (ColorTypeEnum) {\n    ColorTypeEnum["BACKGROUND"] = "fill";\n    ColorTypeEnum["BORDER"] = "stroke";\n    ColorTypeEnum["FONT"] = "font";\n})(ColorTypeEnum || (ColorTypeEnum = {}));\nvar ColorPickerModeEnum;\n(function (ColorPickerModeEnum) {\n    ColorPickerModeEnum["LEGACY"] = "legacy";\n    ColorPickerModeEnum["BPMN_IN_COLOR"] = "bpmn-in-color";\n})(ColorPickerModeEnum || (ColorPickerModeEnum = {}));\nclass ColorService {\n    constructor() {\n        this.fillColorCodeInput = Object.create({});\n        this.fillColorPicker = Object.create({});\n        this.fillColorInputs = [];\n        this.strokeColorCodeInput = Object.create({});\n        this.strokeColorPicker = Object.create({});\n        this.strokeColorInputs = [];\n        this.fontColorCodeInput = Object.create({});\n        this.fontColorPicker = Object.create({});\n        this.fontColorInputs = [];\n        this.languageService = new _model_language_empty_language_service__WEBPACK_IMPORTED_MODULE_3__/* .EmptyLanguageService */ .l();\n        this.panelId = "";\n        this.saveFillColorDebounced = lodash_debounce__WEBPACK_IMPORTED_MODULE_0___default()(this.saveFillColor, 300);\n        this.saveStrokeColorDebounced = lodash_debounce__WEBPACK_IMPORTED_MODULE_0___default()(this.saveStrokeColor, 300);\n        this.saveFontColorDebounced = lodash_debounce__WEBPACK_IMPORTED_MODULE_0___default()(this.saveFontColor, 300);\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_4__/* .getPlatformService */ .km)().getPlatformUtils();\n        this.fontColorText = "";\n        this.borderColorText = "";\n        this.browserService = _utils_browser_factory__WEBPACK_IMPORTED_MODULE_2__/* .getBrowserService */ .i();\n    }\n    initColorInputs(languageService, panelId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.languageService = languageService;\n            this.panelId = panelId;\n            this.fillColorCodeInput = document.querySelector(`${panelId} #fill-color-input`);\n            this.fillColorPicker = document.querySelector(`${panelId} #fill-color-container .vxcp-ent-colorpicker-btn`);\n            this.fillColorInputs.push(this.fillColorCodeInput);\n            this.fillColorInputs.push(this.fillColorPicker);\n            this.strokeColorCodeInput = document.querySelector(`${panelId} #stroke-color-input`);\n            this.strokeColorPicker = document.querySelector(`${panelId} #stroke-color-container .vxcp-ent-colorpicker-btn`);\n            this.strokeColorInputs.push(this.strokeColorCodeInput);\n            this.strokeColorInputs.push(this.strokeColorPicker);\n            this.fontColorCodeInput = document.querySelector(`${panelId} #font-color-input`);\n            this.fontColorPicker = document.querySelector(`${panelId} #font-color-container .vxcp-ent-colorpicker-btn`);\n            this.fontColorInputs.push(this.fontColorCodeInput);\n            this.fontColorInputs.push(this.fontColorPicker);\n            if (this.browserService.isBrowser([_model_enum_browser_enum__WEBPACK_IMPORTED_MODULE_1__/* .BrowserEnum.INTERNET_EXPLORER */ .p.INTERNET_EXPLORER])) {\n                this.fillColorPicker.style.display = "none";\n                this.strokeColorPicker.style.display = "none";\n                const noCPwarningMessage = document.getElementById("vxcp-ent-colorpicker-no-color-picker-warning");\n                noCPwarningMessage.style.display = "block";\n            }\n            this.initEventListeners();\n            this.fontColorText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.business-tab.color-group.custom-font-color");\n            this.borderColorText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.business-tab.color-group.custom-stroke-color");\n            return;\n        });\n    }\n    updateInitialColors(clickedDomElement) {\n        var _a;\n        const curShape = this.languageService.getDi(clickedDomElement);\n        if (!curShape) {\n            return;\n        }\n        if (curShape.label) {\n            this.toggleColorPickerMode(ColorPickerModeEnum.BPMN_IN_COLOR);\n        }\n        else {\n            this.toggleColorPickerMode(ColorPickerModeEnum.LEGACY);\n        }\n        const fillColor = curShape["background-color"] || curShape.fill || Color.DEFAULT_FILL_COLOR;\n        const strokeColor = curShape["border-color"] || curShape.stroke || Color.DEFAULT_STROKE_COLOR;\n        const fontColor = ((_a = curShape.label) === null || _a === void 0 ? void 0 : _a.color) || curShape.stroke || Color.DEFAULT_FONT_COLOR;\n        this.fillColorCodeInput.value = fillColor;\n        this.fillColorPicker.value = fillColor;\n        this.strokeColorCodeInput.value = strokeColor;\n        this.strokeColorPicker.value = strokeColor;\n        this.fontColorCodeInput.value = fontColor;\n        this.fontColorPicker.value = fontColor;\n    }\n    initEventListeners() {\n        $(`${this.panelId} .vxcp-ent-att-panel-btn-color`).on("click", (e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            const clickedElement = e.currentTarget;\n            const cssStyles = getComputedStyle(clickedElement);\n            const newFillColorRgb = cssStyles.backgroundColor || "";\n            const newStrokeColorRgb = cssStyles.borderTopColor || "";\n            const newFillColorHex = this.rgb2hex(newFillColorRgb);\n            const newStrokeColorHex = this.rgb2hex(newStrokeColorRgb);\n            this.paintBpmnElements(newFillColorHex, this.fillColorInputs);\n            this.paintBpmnElements(newStrokeColorHex, this.strokeColorInputs);\n            this.paintBpmnElements(newStrokeColorHex, this.fontColorInputs);\n        });\n        $(`${this.panelId} .vxcp-ent-colorpicker-btn.fill-color`).on("click", () => {\n            if (this.fillColorCodeInput.value === Color.DEFAULT_FILL_COLOR) {\n                this.fillColorPicker.value = Color.TMP_COLOR;\n            }\n        });\n        $(`${this.panelId} .vxcp-ent-colorpicker-btn.stroke-color`).on("click", () => {\n            if (this.strokeColorCodeInput.value === Color.DEFAULT_STROKE_COLOR) {\n                this.strokeColorPicker.value = Color.TMP_COLOR;\n            }\n        });\n        $(`${this.panelId} .vxcp-ent-colorpicker-btn.font-color`).on("click", () => {\n            if (this.fontColorCodeInput.value === Color.DEFAULT_FONT_COLOR) {\n                this.fontColorPicker.value = Color.TMP_COLOR;\n            }\n        });\n        $(`${this.panelId} .vxcp-ent-colorpicker-btn`).on("input change", (e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            const curColorPicker = e.currentTarget;\n            this.changeColor(curColorPicker.value, curColorPicker.parentNode);\n        });\n        $(`${this.panelId} .color-code-input`)\n            .on("change keyup", (e) => {\n            const curColorCodeInput = e.currentTarget;\n            const colorCode = curColorCodeInput.value;\n            const inputWrapper = curColorCodeInput.parentNode;\n            if (!this.validateColorInput(curColorCodeInput)) {\n                return;\n            }\n            this.changeColor(colorCode, inputWrapper);\n        })\n            .on("blur", (e) => {\n            const curColorCodeInput = e.currentTarget;\n            const curColor = curColorCodeInput.value;\n            if (!this.isValidColorCode(curColor)) {\n                this.resetInputs(curColorCodeInput.id);\n            }\n        });\n    }\n    toggleColorPickerMode(mode) {\n        if (mode === ColorPickerModeEnum.LEGACY) {\n            $("#font-color-container").hide();\n            $("#stroke-color-container").find("label").text(this.fontColorText);\n        }\n        else if (mode === ColorPickerModeEnum.BPMN_IN_COLOR) {\n            $("#font-color-container").show();\n            $("#stroke-color-container").find("label").text(this.borderColorText);\n        }\n    }\n    resetInputs(inputId) {\n        let colorInputs;\n        let defaultColor;\n        if (inputId.includes("fill")) {\n            colorInputs = this.fillColorInputs;\n            defaultColor = Color.DEFAULT_FILL_COLOR;\n        }\n        else if (inputId.includes("stroke")) {\n            colorInputs = this.strokeColorInputs;\n            defaultColor = Color.DEFAULT_STROKE_COLOR;\n        }\n        else if (inputId.includes("font")) {\n            colorInputs = this.fontColorInputs;\n            defaultColor = Color.DEFAULT_FONT_COLOR;\n        }\n        const fillColorError = document.querySelector(`${this.panelId} #fill-color-error`);\n        const strokeColorError = document.querySelector(`${this.panelId} #stroke-color-error`);\n        const fontColorError = document.querySelector(`${this.panelId} #font-color-error`);\n        colorInputs.forEach((input) => {\n            input.value = defaultColor;\n            input.classList.remove("invalid");\n        });\n        fillColorError.classList.add("vxcp-ent-att-panel-hidden");\n        strokeColorError.classList.add("vxcp-ent-att-panel-hidden");\n        fontColorError.classList.add("vxcp-ent-att-panel-hidden");\n    }\n    validateColorInput(input) {\n        const inputWrapper = input.parentNode;\n        const errorMessage = inputWrapper.nextSibling;\n        if (!this.isValidColorCode(input.value)) {\n            input.classList.add("invalid");\n            errorMessage.classList.remove("vxcp-ent-att-panel-hidden");\n            return false;\n        }\n        input.classList.remove("invalid");\n        errorMessage.classList.add("vxcp-ent-att-panel-hidden");\n        return true;\n    }\n    changeColor(newColor, inputWrapper) {\n        const colorType = this.getColorTypeForElementId(inputWrapper.id);\n        const newColorModified = this.resetColor(newColor, colorType);\n        this.paintBpmnElements(newColorModified, this.getColorInputs(colorType));\n        const errorMessage = inputWrapper.nextSibling;\n        errorMessage.classList.add("vxcp-ent-att-panel-hidden");\n    }\n    paintBpmnElements(colorCode, colorInputs) {\n        const elementRegistry = this.languageService.getElementRegistry();\n        const allDomElements = elementRegistry.getAll();\n        const numberOfDomElements = allDomElements.length;\n        const selectedElements = this.languageService.getSelection().get();\n        const inputWrapper = colorInputs[0].parentNode;\n        const colorType = this.getColorTypeForElementId(inputWrapper.id);\n        if (numberOfDomElements > 100) {\n            switch (colorType) {\n                case ColorTypeEnum.BACKGROUND:\n                    this.saveFillColorDebounced(selectedElements, colorCode);\n                    break;\n                case ColorTypeEnum.BORDER:\n                    this.saveStrokeColorDebounced(selectedElements, colorCode);\n                    break;\n                case ColorTypeEnum.FONT:\n                    this.saveFontColorDebounced(selectedElements, colorCode);\n                    break;\n            }\n        }\n        else {\n            this.saveNewColor(selectedElements, colorCode, colorType);\n        }\n        colorInputs.forEach((curInput) => {\n            if (curInput.classList.contains("vxcp-ent-colorpicker-btn")) {\n                colorCode = this.recorrectHexCode(colorCode);\n            }\n            curInput.value = colorCode;\n            curInput.classList.remove("invalid");\n        });\n    }\n    saveNewColor(selectedElements, newColor, colorType) {\n        selectedElements.forEach((domElement) => {\n            const curShape = this.languageService.getDi(domElement);\n            newColor = this.recorrectHexCode(newColor);\n            let colorHasChanged = false;\n            switch (colorType) {\n                case ColorTypeEnum.BACKGROUND:\n                    curShape["background-color"] = !curShape["background-color"] ? curShape.fill : curShape["background-color"];\n                    delete curShape.fill;\n                    colorHasChanged = newColor !== curShape["background-color"];\n                    curShape["background-color"] = newColor;\n                    break;\n                case ColorTypeEnum.BORDER:\n                    curShape["border-color"] = !curShape["border-color"] ? curShape.stroke : curShape["border-color"];\n                    delete curShape.stroke;\n                    colorHasChanged = newColor !== curShape["border-color"];\n                    curShape["border-color"] = newColor;\n                    break;\n                default:\n                    if (curShape.label) {\n                        colorHasChanged = newColor !== curShape.label.color;\n                        curShape.label.color = newColor;\n                    }\n            }\n            if (colorHasChanged) {\n                this.languageService.updateProperties(domElement, {});\n            }\n        });\n    }\n    saveFillColor(selectedElements, newColor) {\n        this.saveNewColor(selectedElements, newColor, ColorTypeEnum.BACKGROUND);\n    }\n    saveStrokeColor(selectedElements, newColor) {\n        this.saveNewColor(selectedElements, newColor, ColorTypeEnum.BORDER);\n    }\n    saveFontColor(selectedElements, newColor) {\n        this.saveNewColor(selectedElements, newColor, ColorTypeEnum.FONT);\n    }\n    getColorTypeForElementId(elementId) {\n        if (elementId.includes("fill")) {\n            return ColorTypeEnum.BACKGROUND;\n        }\n        if (elementId.includes("stroke")) {\n            return ColorTypeEnum.BORDER;\n        }\n        return ColorTypeEnum.FONT;\n    }\n    getColorInputs(colorType) {\n        switch (colorType) {\n            case ColorTypeEnum.BACKGROUND:\n                return this.fillColorInputs;\n            case ColorTypeEnum.BORDER:\n                return this.strokeColorInputs;\n            default:\n                return this.fontColorInputs;\n        }\n    }\n    recorrectHexCode(colorCode) {\n        if (colorCode.startsWith("#")) {\n            colorCode = colorCode.substring(1);\n        }\n        if (colorCode.length === 3) {\n            const colors = colorCode.split("");\n            return `#${colors[0]}${colors[0]}${colors[1]}${colors[1]}${colors[2]}${colors[2]}`;\n        }\n        else if (colorCode.length === 6) {\n            return `#${colorCode}`;\n        }\n        else {\n            return Color.DEFAULT_STROKE_COLOR;\n        }\n    }\n    rgb2hex(rgb) {\n        const rgbColors = rgb.match(/^rgb\\((\\d+),\\s*(\\d+),\\s*(\\d+)\\)$/);\n        const hex = (x) => {\n            return ("0" + parseInt(x, 10).toString(16)).slice(-2);\n        };\n        if (!rgbColors) {\n            return Color.DEFAULT_STROKE_COLOR;\n        }\n        const red = hex(rgbColors[1]);\n        const green = hex(rgbColors[2]);\n        const blue = hex(rgbColors[3]);\n        return `#${red}${green}${blue}`;\n    }\n    resetColor(newColor, colorType) {\n        let newColorModified = newColor;\n        if (colorType === ColorTypeEnum.BACKGROUND) {\n            if (this.fillColorPicker.value === Color.TMP_COLOR) {\n                newColorModified = Color.DEFAULT_FILL_COLOR;\n                this.fillColorCodeInput.value = Color.DEFAULT_FILL_COLOR;\n                this.fillColorPicker.value = Color.DEFAULT_FILL_COLOR;\n            }\n        }\n        else if (colorType === ColorTypeEnum.BORDER) {\n            if (this.strokeColorPicker.value === Color.TMP_COLOR) {\n                newColorModified = Color.DEFAULT_STROKE_COLOR;\n                this.strokeColorPicker.value = Color.DEFAULT_STROKE_COLOR;\n                this.strokeColorCodeInput.value = Color.DEFAULT_STROKE_COLOR;\n            }\n        }\n        else if (colorType === ColorTypeEnum.FONT) {\n            if (this.fontColorPicker.value === Color.TMP_COLOR) {\n                newColorModified = Color.DEFAULT_FONT_COLOR;\n                this.fontColorPicker.value = Color.DEFAULT_FONT_COLOR;\n                this.fontColorCodeInput.value = Color.DEFAULT_FONT_COLOR;\n            }\n        }\n        return newColorModified;\n    }\n    isValidColorCode(colorCode) {\n        const validHexColor = new RegExp("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$");\n        const correctedColor = this.recorrectHexCode(colorCode);\n        return validHexColor.test(correctedColor) && validHexColor.test(colorCode);\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/color.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/html-factory.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Ai": () => (/* binding */ showProcessRefFields),\n/* harmony export */   "Tg": () => (/* binding */ hideProcessRefFields),\n/* harmony export */   "uC": () => (/* binding */ createExtensionsTableEntrySanitized),\n/* harmony export */   "wf": () => (/* binding */ createPanel)\n/* harmony export */ });\n/* harmony import */ var _panel_utils_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/panel-utils.service.ts");\n/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n/* harmony import */ var _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\n/* harmony import */ var _model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\nconst PlatformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__/* .getPlatformService */ .km)().getPlatformUtils() || {};\nconst toHtmlList = (str) => {\n    let objectString = str;\n    objectString = "<ul>" + objectString + "</ul>";\n    objectString = objectString.replace(/\\[/g, "<ul>");\n    objectString = objectString.replace(/\\],/g, "</ul><li><b>");\n    objectString = objectString.replace(/\\]/g, "</ul>");\n    objectString = objectString.replace(/":/g, ":</b> ");\n    objectString = objectString.replace(/","/g, \'"</li><li><b>"\');\n    objectString = objectString.replace(/"/g, "");\n    objectString = objectString.replace(/{/g, "<li><b>");\n    objectString = objectString.replace(/},/g, "</li><hr>");\n    objectString = objectString.replace(/}/g, "</li>");\n    return objectString;\n};\nconst createPanel = ($container, panelId, toggleWrapperId, vbcpEntId) => __awaiter(void 0, void 0, void 0, function* () {\n    const text = yield PlatformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.toggle-text.panel-hidden");\n    const html = `    <div  class="vxcp-ent-panel-toggle vxcp-ent-vbcp-panel-toggle">\n        <div  class="vxcp-ent-vbcp-panel-toggle-text vxcp-ent-att-panel-vertical-text">${text} </div>\n                       <span  class="vxcp-ent-vbcp-panel-toggle-icon vxcp-ent-panel-toggle-icon aui-icon aui-icon-small aui-iconfont-arrows-right"></span>\n\n    </div>`;\n    const nakedPanelId = panelId.substring(1);\n    $container.append(`<div id="${nakedPanelId}" class="panel-wrapper"></div>`);\n    const pluginShorthand = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__/* .getPluginService */ .j)().getPluginShorthand();\n    const appType = PlatformUtils.getAppType();\n    const params = {\n        appType,\n        vbcpEntId,\n        pluginShorthand,\n    };\n    const attributePanelHtml = yield PlatformUtils.getTemplate(_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_2__/* .TemplateNamesEnum.ATTRIBUTE_PANEL */ .X.ATTRIBUTE_PANEL, params);\n    $(`${panelId}`).append(attributePanelHtml);\n    $(toggleWrapperId).append(html);\n});\nconst showProcessRefFields = (panelId, processRefObject) => {\n    const $generalAttributes = $(`${panelId} .process-ref-field`);\n    $generalAttributes.removeClass("vxcp-ent-att-panel-hidden");\n    $generalAttributes.removeClass("no-element-selected");\n    _panel_utils_service__WEBPACK_IMPORTED_MODULE_0__/* .loadProcessAttributes */ .YF(panelId, processRefObject);\n};\nconst hideProcessRefFields = (panelId) => {\n    const $generalAttributes = $(`${panelId} .process-ref-field`);\n    $generalAttributes.addClass("vxcp-ent-att-panel-hidden");\n    $generalAttributes.find(".vxcp-ent-att-panel-textfield").val("");\n};\nconst createExtensionsTableEntrySanitized = (extension) => {\n    const processRefIdAddition = "";\n    const ignoredExtensionTypes = ["$type", "set", "get", "namespace"];\n    const ignoredNamespacePrefix = "xmlns";\n    if (extension.$type && (extension.$type.startsWith(ignoredNamespacePrefix) || ignoredExtensionTypes.includes(extension.$type))) {\n        return "";\n    }\n    let tableEntryHtmlAll = `<tr class="${processRefIdAddition}extension-entry"><td class="extension-type">${sanitize(extension.$type)}</td><td class="extension-data"><ul>`;\n    let numberOfAttributesSum = 0;\n    const ignoredProperties = ["set", "get"];\n    for (const property in extension) {\n        if (!extension.hasOwnProperty(property)) {\n            continue;\n        }\n        const { tableEntryHtml, numberOfAttributes } = createExtensionsTableEntryForProperty(extension, tableEntryHtmlAll, numberOfAttributesSum, ignoredProperties, property);\n        numberOfAttributesSum = numberOfAttributes;\n        tableEntryHtmlAll = tableEntryHtml;\n    }\n    tableEntryHtmlAll += "</ul></td></tr>";\n    if (numberOfAttributesSum > 0) {\n        return tableEntryHtmlAll;\n    }\n    else {\n        return "";\n    }\n};\nconst sanitize = (value) => {\n    const sanitizedValue = _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(value);\n    return sanitizedValue.length > 0 ? sanitizedValue : "<i>undefined</i>";\n};\nconst createExtensionsTableEntryForProperty = (extension, tableEntryHtml, numberOfAttributes, ignoredProperties, property) => {\n    if (extension.hasOwnProperty(property) && extension[property]) {\n        if (typeof extension[property] === "boolean" || typeof extension[property] === "number" || typeof extension[property] === "string") {\n            if (property === "$body") {\n                tableEntryHtml += sanitize(extension[property].toString());\n                numberOfAttributes++;\n            }\n            else if (!ignoredProperties.includes(property) && !property.startsWith("$")) {\n                let propertyValue = extension[property];\n                if (extension[property].startsWith("{")) {\n                    propertyValue = toHtmlList(extension[property]);\n                }\n                tableEntryHtml += `<li><b>${sanitize(property)}: </b>${sanitize(propertyValue)}</li>`;\n                numberOfAttributes++;\n            }\n        }\n        else if (extension[property] instanceof Array) {\n            extension[property].forEach((elem) => {\n                const propertyName = elem.name;\n                const propertyValue = elem.value;\n                tableEntryHtml += `<li><b>${sanitize(propertyName)}: </b>${sanitize(propertyValue)}</li>`;\n                numberOfAttributes++;\n            });\n        }\n    }\n    return {\n        tableEntryHtml,\n        numberOfAttributes,\n    };\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/html-factory.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/managed-data-fields-rendering-impl.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "T": () => (/* binding */ ManagedDataFieldsRenderingImplService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-mode.enum.ts");\nif ("bpmnEntPlatformMDF" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\nclass ManagedDataFieldsRenderingImplService {\n    constructor(fieldRenderingCoreService, fieldInstanceService) {\n        this.fieldRenderingCoreService = fieldRenderingCoreService;\n        this.fieldInstanceService = fieldInstanceService;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.platformMDF = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__/* .getPlatformMDFService */ .hw)().getPlatformMdfService() || {};\n    }\n    renderFieldInstance(fieldDefinitionName, fieldDefinitions) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $fieldInstanceDiv = $("#vxcp-ent-mdf-macro-dialog-field-instance");\n            const $descriptionDiv = $("#vxcp-ent-mdf-macro-dialog-description");\n            const fieldDef = this.fieldInstanceService.getLocalFieldDefinitionByNameOrId(fieldDefinitionName, fieldDefinitions);\n            this.resetFieldInstanceElements($fieldInstanceDiv);\n            yield $descriptionDiv.text(fieldDef.description);\n            const $fieldInstanceFragment = $(`<div></div>`);\n            const $renderedField = yield this.getFieldDefinitionHtml(fieldDef, true);\n            $fieldInstanceFragment.append($renderedField);\n            $fieldInstanceDiv.append($fieldInstanceFragment);\n            this.platformMDF.initNumberInputValidator();\n        });\n    }\n    getFieldInstanceHtml(fieldInstance, isEditable = false, appModeEnum) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let $domObj;\n            if (fieldInstance.notFound) {\n                const instanceNotFoundText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.managed-data-fields-tab.instance.not-found");\n                $domObj = $(`<div style="margin-bottom: 25px">${instanceNotFoundText}</div>`);\n                if (appModeEnum === _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_0__/* .AppModeEnum.EDITOR */ .v.EDITOR) {\n                    $domObj.append(this.getActionColumnUnavailableFieldInstance(fieldInstance.vcfcpInstanceId.toLowerCase()));\n                }\n            }\n            else {\n                $domObj = yield this.fieldRenderingCoreService.getFieldInstanceHtml(fieldInstance, isEditable);\n                if (appModeEnum === _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_0__/* .AppModeEnum.EDITOR */ .v.EDITOR) {\n                    $domObj.append(this.getActionColumn(fieldInstance.vcfcpInstanceId.toLowerCase()));\n                }\n            }\n            return $domObj;\n        });\n    }\n    getFieldDefinitionHtml(fieldDefinition, isEditable = false) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return this.fieldRenderingCoreService.getFieldDefinitionHtml(fieldDefinition, isEditable);\n        });\n    }\n    resetFieldInstanceElements($divToClean) {\n        if ($divToClean && $divToClean.children()) {\n            $($divToClean.children()).remove();\n        }\n    }\n    getActionColumnUnavailableFieldInstance(fieldInstanceId) {\n        return `<td id="vxcp-ent-mdf-data-attributes-actions-td">\n                <span class="btn-delete-mdflink aui-icon aui-icon-small aui-iconfont-delete"\n                    id="btn-delete-${fieldInstanceId}"\n                    title="Delete Link"></span>\n                <div id="vxcp-ent-mdf-edit-success-message"</div>\n            </td>`;\n    }\n    getActionColumn(fieldInstanceId) {\n        return `<td id="vxcp-ent-mdf-data-attributes-actions-td">\n            <span class="btn-edit-mdflink aui-icon aui-icon-small aui-iconfont-edit"\n                id="btn-edit-${fieldInstanceId}"\n                title="Edit Link"></span>\n            <span class="btn-delete-mdflink aui-icon aui-icon-small aui-iconfont-delete"\n                id="btn-delete-${fieldInstanceId}"\n                title="Delete Link"></span>\n            <div id="vxcp-ent-mdf-edit-success-message"</div>\n            </td>`;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/managed-data-fields-rendering-impl.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/managed-data-fields.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "_": () => (/* binding */ ManagedDataFieldsService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts");\n/* harmony import */ var _panel_utils_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/panel-utils.service.ts");\n/* harmony import */ var _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-mode.enum.ts");\nif ("bpmnEntPlatformMDF" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _model_language_empty_language_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/empty-language.service.ts");\n/* harmony import */ var _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/from-mode.enum.ts");\n/* harmony import */ var _MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../MDF-core/core-js/app/model/enum/app-type-html-prefix.enum.ts");\n/* harmony import */ var _model_enum_app_type_enum__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-type.enum.ts");\nif ("bpmnEntPlatformMDF" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\nconst Utils = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\nclass ManagedDataFieldsService {\n    constructor(xmlExtensionService, appModeEnum, managedDataFieldsRenderService, managedDataFieldsUserMentionService, mdfIdService, managedDataFieldsInstancesService, managedDataFieldsDefinitionService) {\n        this.xmlExtensionService = xmlExtensionService;\n        this.appModeEnum = appModeEnum;\n        this.managedDataFieldsRenderService = managedDataFieldsRenderService;\n        this.managedDataFieldsUserMentionService = managedDataFieldsUserMentionService;\n        this.mdfIdService = mdfIdService;\n        this.managedDataFieldsInstancesService = managedDataFieldsInstancesService;\n        this.managedDataFieldsDefinitionService = managedDataFieldsDefinitionService;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_8__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.pluginService = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_8__/* .getPluginService */ .j)();\n        this.optionClass = `${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-macro-dialog-option`;\n        this.spaceKey = "";\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z(this.pluginService.getPluginName(), "ManagedDataFieldsService");\n        this.publishInstanceQueue = [];\n        this.deleteInstanceQueue = [];\n        this.xmlExtensionService = xmlExtensionService;\n        this.appModeEnum = appModeEnum;\n        this.languageService = new _model_language_empty_language_service__WEBPACK_IMPORTED_MODULE_3__/* .EmptyLanguageService */ .l();\n    }\n    initManagedDataFieldsInPanel(pageId, vbcpEntId, languageService, $canvas) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const mdfAlive = yield this.checkHealth();\n            this.pageId = pageId;\n            this.vbcpEntId = vbcpEntId;\n            this.languageService = languageService;\n            this.$canvas = $canvas;\n            this.health = mdfAlive;\n            if (mdfAlive) {\n                try {\n                    this.activateMDFInPanel();\n                    if (this.appModeEnum === _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_2__/* .AppModeEnum.EDITOR */ .v.EDITOR) {\n                        yield this.initFieldDefinitions();\n                        const definitionLink = `${this.platformUtils.buildConfluenceBaseUrl()}/plugins/managed-data-fields/manageddatafielddefinition.action`;\n                        const descText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.managed-data-fields-tab.definitionDropdownDesc");\n                        const linkText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.managed-data-fields-tab.definitionDropdownLink");\n                        $(`#${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-choose-field-definition`).html(`${descText}<a href="${definitionLink}" target="_blank"> ${linkText}</a>`);\n                    }\n                }\n                catch (e) {\n                }\n            }\n        });\n    }\n    renderManagedDataFieldsInstance(mdfInstanceParams, bpmnJs) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!this.health) {\n                return;\n            }\n            const $noLinkedInstances = document.getElementById(`${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-field-instances-no-links-${this.vbcpEntId}`);\n            if ($noLinkedInstances) {\n                $noLinkedInstances.remove();\n            }\n            const valueId = mdfInstanceParams.mdfValueId;\n            if (!valueId) {\n                return;\n            }\n            const fieldInstance = yield this.getFieldInstanceByValueId(valueId);\n            const $fieldInstanceHtml = yield this.managedDataFieldsRenderService.getFieldInstanceHtml(fieldInstance, false, this.appModeEnum);\n            $(`#${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-field-instances-${this.vbcpEntId}`).append($fieldInstanceHtml);\n            this.managedDataFieldsUserMentionService.fillUserPlaceholders();\n            this.initActionButtons(fieldInstance, mdfInstanceParams, bpmnJs);\n        });\n    }\n    publishInstances(fromMode) {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield Utils.asyncForEach(this.publishInstanceQueue, (fieldInstance) => __awaiter(this, void 0, void 0, function* () {\n                if (fromMode !== _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_4__/* .FromModeEnum.CONFLUENCE_EDITOR */ .p.CONFLUENCE_EDITOR) {\n                    fieldInstance.published = true;\n                }\n                yield this.managedDataFieldsInstancesService.addOrUpdateFieldInstanceVersion(fieldInstance);\n            }));\n            yield Utils.asyncForEach(this.deleteInstanceQueue, (fieldInstance) => __awaiter(this, void 0, void 0, function* () {\n                if (fromMode !== _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_4__/* .FromModeEnum.CONFLUENCE_EDITOR */ .p.CONFLUENCE_EDITOR) {\n                    fieldInstance.published = false;\n                }\n                yield this.managedDataFieldsInstancesService.addOrUpdateFieldInstanceVersion(fieldInstance);\n            }));\n            this.publishInstanceQueue = [];\n            this.deleteInstanceQueue = [];\n        });\n    }\n    getFieldInstanceByValueId(valueId, withDefinitionName) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!this.health) {\n                return;\n            }\n            let fieldInstance = this.publishInstanceQueue.find((unpublishedFieldInstance) => unpublishedFieldInstance.valueId === valueId);\n            if (!fieldInstance) {\n                try {\n                    fieldInstance = yield this.managedDataFieldsInstancesService.getFieldInstanceVersionByValueId(valueId);\n                }\n                catch (e) {\n                    this.vxcpLogger.logError("getFieldInstanceByValueId", "Error occurred while getting Field Instance", e);\n                }\n            }\n            if (!fieldInstance) {\n                this.vxcpLogger.logWarning("getFieldInstanceByValueId", `Field Instance was not found. (valueId: ${valueId}).`);\n                fieldInstance = {\n                    notFound: true,\n                    vcfcpInstanceId: this.mdfIdService.generateUuid(),\n                    valueId,\n                    vcfcpDefinitionName: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.managed-data-fields-tab.instance.not-found"),\n                };\n                return fieldInstance;\n            }\n            if (withDefinitionName) {\n                const fieldDefinition = yield this.managedDataFieldsDefinitionService.getFieldDefinitionByNameOrId(fieldInstance.vcfcpDefinitionId);\n                if (fieldDefinition) {\n                    fieldInstance.vcfcpDefinitionName = fieldDefinition.name;\n                }\n                else {\n                    fieldInstance.vcfcpDefinitionName = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.managed-data-fields-tab.definitionDeletedWarning");\n                }\n            }\n            return fieldInstance;\n        });\n    }\n    publishFieldInstance(valueId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const fieldInstance = yield this.managedDataFieldsInstancesService.getFieldInstanceVersionByValueId(valueId);\n            fieldInstance.published = true;\n            yield this.managedDataFieldsInstancesService.addOrUpdateFieldInstanceVersion(fieldInstance);\n        });\n    }\n    setNewBpmnNameToAllMdfInstances(newBpmnName) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.platformUtils.getAppType() !== _model_enum_app_type_enum__WEBPACK_IMPORTED_MODULE_6__/* .AppTypeEnum.SERVER_ENTERPRISE */ .K.SERVER_ENTERPRISE || !(yield this.checkHealth())) {\n                return;\n            }\n            const allElements = this.languageService.getElementRegistry().getAll();\n            yield Utils.asyncForEach(allElements, (element) => __awaiter(this, void 0, void 0, function* () {\n                const extensions = this.xmlExtensionService.getAllLinkExtensions(element.businessObject);\n                yield Utils.asyncForEach(extensions, (extension) => __awaiter(this, void 0, void 0, function* () {\n                    if (extension.mdfValueId) {\n                        try {\n                            const fieldInstance = yield this.managedDataFieldsInstancesService.getFieldInstanceVersionByValueId(extension.mdfValueId);\n                            fieldInstance.bpmnDiagramName = newBpmnName;\n                            yield this.managedDataFieldsInstancesService.addOrUpdateFieldInstanceVersion(fieldInstance);\n                        }\n                        catch (error) {\n                            this.vxcpLogger.logInfo("setNewBpmnNameToAllMdfInstances", "ERROR @ManagedDataFieldsService.setNewBpmnNameToAllMdfInstances: REST-Error occurred while setting the bpmn diagram name in the field instances.", error);\n                        }\n                    }\n                }));\n            }));\n        });\n    }\n    setParameters(appModeEnum, spaceKey) {\n        this.appModeEnum = appModeEnum;\n        if (spaceKey) {\n            this.spaceKey = spaceKey;\n        }\n    }\n    checkHealth() {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const url = `${this.platformUtils.buildConfluenceBaseUrl()}/rest/managed-data-fields/1.0/fielddefinitions/health`;\n                const response = yield fetch(url);\n                return response.status === 200;\n            }\n            catch (error) {\n                this.vxcpLogger.logInfo("checkHealth", "ERROR @ManagedDataFieldsService.checkHealth: REST-Error occurred while checking health of Managed Data Fields.", error);\n                return false;\n            }\n        });\n    }\n    activateMDFInPanel() {\n        $(`#${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-health-check-${this.vbcpEntId}`).hide();\n        $(`#vxcp-ent-managed-data-fields-${this.vbcpEntId}`).show();\n    }\n    initFieldDefinitions() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const fieldDefinitions = yield this.managedDataFieldsDefinitionService.getAllFieldDefinitionsForSpace(this.spaceKey);\n            $(`.${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-macro-dialog-option`).remove();\n            this.managedDataFieldsRenderService.resetFieldInstanceElements($(`#${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-macro-dialog-field-instance`));\n            yield this.insertFieldDefinitionInSelectOptions(fieldDefinitions);\n            const $fieldDefinitionSelects = $(`.${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-macro-dialog-field-definitions-dropdowns`);\n            $fieldDefinitionSelects.on("change", (event) => {\n                event.stopPropagation();\n                event.preventDefault();\n                const selectedFieldDefinitionToInstantiate = $(`#${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-field-instance-macro-dialog-select-field-definition`).val();\n                this.managedDataFieldsRenderService.renderFieldInstance(selectedFieldDefinitionToInstantiate, fieldDefinitions);\n                $(`#${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-macro-dialog-submit`).show();\n                $(`#${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-macro-dialog`).css("width", "min-content");\n            });\n            $(`#${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-macro-dialog-submit`).on("click", () => __awaiter(this, void 0, void 0, function* () {\n                const definitionDropdown = $(`#${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-field-instance-macro-dialog-select-field-definition`);\n                const selectedFieldDefinitionToInstantiate = definitionDropdown.val();\n                const $fieldDefinitionElement = $(`#${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-macro-dialog-field-instance`);\n                const fieldInstance = this.managedDataFieldsInstancesService.createFieldInstanceFromUserInput($fieldDefinitionElement, selectedFieldDefinitionToInstantiate, fieldDefinitions, this.pageId, this.vbcpEntId);\n                this.publishInstanceQueue.push(fieldInstance);\n                this.addInstanceToElement(fieldInstance);\n                $(`#${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-macro-dialog-submit`).hide();\n                $fieldDefinitionElement.html("");\n                definitionDropdown.prop("selectedIndex", 0);\n            }));\n        });\n    }\n    insertFieldDefinitionInSelectOptions(fieldDefinitions, all) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $fieldDefinitionSelects = $(`.${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-macro-dialog-field-definitions-dropdowns`);\n            let confluencePageCounter = 0;\n            for (const fieldDef of fieldDefinitions) {\n                if (fieldDef.displayModeBpmnModeler) {\n                    $fieldDefinitionSelects.append(`<option class="${this.optionClass}" value="${fieldDef.vcfcpDefinitionId}">${fieldDef.name}</option>`);\n                }\n                else {\n                    confluencePageCounter++;\n                }\n            }\n            if (confluencePageCounter === fieldDefinitions.length) {\n                $fieldDefinitionSelects.append(`<option class="${this.optionClass} value="">${yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.managed-data-fields-tab.noFieldDefinitionsFound")}</option>"`);\n            }\n        });\n    }\n    addInstanceToElement(fieldInstance) {\n        const moddle = this.languageService.getModdle();\n        const idGenerator = moddle.ids;\n        const elementLink = {\n            id: idGenerator.nextPrefixed("ElementLink_"),\n            type: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.MDF_INSTANCE */ .Iu.MDF_INSTANCE,\n            desc: "",\n            pageId: fieldInstance.pageid,\n            mdfInstanceId: fieldInstance.vcfcpInstanceId,\n            mdfValueId: fieldInstance.valueId,\n            mdfDefinitionId: fieldInstance.vcfcpDefinitionId,\n        };\n        const selectedElements = _panel_utils_service__WEBPACK_IMPORTED_MODULE_1__/* .getSelectedElements */ .eD(this.languageService);\n        const curElement = selectedElements[0];\n        this.xmlExtensionService.createExtension(this.languageService, curElement, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.MDF_INSTANCE */ .ws.MDF_INSTANCE, elementLink);\n    }\n    initActionButtons(fieldInstance, mdfInstanceParams, bpmnJs) {\n        $(`#btn-delete-${fieldInstance.vcfcpInstanceId.toLowerCase()}`).on("click", () => __awaiter(this, void 0, void 0, function* () {\n            if (!fieldInstance.notFound) {\n                this.deleteInstanceQueue.push(fieldInstance);\n            }\n            const selectedElements = _panel_utils_service__WEBPACK_IMPORTED_MODULE_1__/* .getSelectedElements */ .eD(bpmnJs);\n            const curElement = selectedElements[0];\n            this.xmlExtensionService.deleteExtensionById(bpmnJs, curElement, mdfInstanceParams.id);\n        }));\n        $(`#btn-edit-${fieldInstance.vcfcpInstanceId.toLowerCase()}`).on("click", () => __awaiter(this, void 0, void 0, function* () {\n            const selectedElements = _panel_utils_service__WEBPACK_IMPORTED_MODULE_1__/* .getSelectedElements */ .eD(bpmnJs);\n            const curElement = selectedElements[0];\n            this.openEditLinkDialog(fieldInstance, curElement, mdfInstanceParams);\n        }));\n    }\n    openEditLinkDialog(fieldInstance, curElement, mdfInstanceParams) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const dialogId = `#${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-edit-field-instance`;\n            this.platformUtils.removeDjsHelperSvg();\n            const mdfEditDialog = yield this.platformUtils.getTemplate(_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_7__/* .TemplateNamesEnum.MDF_EDIT_FIELD_INSTANCE */ .X.MDF_EDIT_FIELD_INSTANCE);\n            this.$canvas.append(mdfEditDialog);\n            const $fieldInstanceHtml = yield this.managedDataFieldsRenderService.getFieldInstanceHtml(fieldInstance, true);\n            $(`#${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-edit-wrapper`).append($fieldInstanceHtml);\n            this.managedDataFieldsUserMentionService.fillUserPlaceholders();\n            this.platformUtils.showDialog(dialogId);\n            this.platformUtils.getDialog(dialogId).on("hide", () => {\n                $(dialogId).remove();\n            });\n            Utils.initEscKey($("body"), $(dialogId + "-abort"));\n            $(`${dialogId}-abort`).on("click", () => {\n                this.platformUtils.hideDialog(dialogId);\n            });\n            $(`${dialogId}-continue`).on("click", () => __awaiter(this, void 0, void 0, function* () {\n                const $instanceSelector = $(`#${_MDF_core_core_js_app_model_enum_app_type_html_prefix_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeHtmlPrefixEnum.VBCP_ENT */ .U.VBCP_ENT}-edit-wrapper`);\n                const $instance = $instanceSelector.find(`[data-vcfcpinstanceid=${fieldInstance.vcfcpInstanceId}]`);\n                const dataAttributes = this.managedDataFieldsInstancesService.createAttributeObjectsFromInput($instance);\n                const attributesWrapper = {\n                    dataAttributes,\n                };\n                fieldInstance.value = JSON.stringify(attributesWrapper);\n                fieldInstance.published = false;\n                const valueId = this.mdfIdService.generateValueId(fieldInstance.value, fieldInstance.vcfcpInstanceId);\n                fieldInstance.valueId = valueId;\n                this.publishInstanceQueue.push(fieldInstance);\n                const elementLink = mdfInstanceParams;\n                elementLink.mdfValueId = valueId;\n                this.xmlExtensionService.replaceExistingExtension(this.languageService, curElement, elementLink, elementLink.id);\n                this.platformUtils.hideDialog(dialogId);\n            }));\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/managed-data-fields.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/panel-utils.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Fw": () => (/* binding */ preventAnimationsWhileLoading),\n/* harmony export */   "Xs": () => (/* binding */ adjustTextarea),\n/* harmony export */   "YF": () => (/* binding */ loadProcessAttributes),\n/* harmony export */   "Yp": () => (/* binding */ openPanel),\n/* harmony export */   "b1": () => (/* binding */ highlightGroup),\n/* harmony export */   "dR": () => (/* binding */ copyDataToNewElement),\n/* harmony export */   "eD": () => (/* binding */ getSelectedElements),\n/* harmony export */   "hv": () => (/* binding */ selectPanel),\n/* harmony export */   "k5": () => (/* binding */ collapseGroup),\n/* harmony export */   "q3": () => (/* binding */ savePropertyToXml),\n/* harmony export */   "sR": () => (/* binding */ closePanel)\n/* harmony export */ });\n/* unused harmony exports saveOrResetId, switchId, isValidId */\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _model_enum_panel_type_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/panel-type.enum.ts");\n/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n/* harmony import */ var _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\n/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n/* harmony import */ var _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-mode.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\nconst sanitizerService = new _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_2__/* .SanitizerService */ .Y();\nconst PlatformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_4__/* .getPlatformService */ .km)().getPlatformUtils() || {};\nconst vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_4__/* .getPluginService */ .j)().getPluginName(), "panel-utils");\nconst setAnimations = ($parentCanvas, animationDuration = "0s") => {\n    $parentCanvas.find(".vxcp-ent-vbcp-panel").css("animation-duration", animationDuration);\n    $parentCanvas.find(".vxcp-ent-bpmn-js-panel").css("animation-duration", animationDuration);\n};\nconst getEventDefinition = (businessObject) => {\n    const eventDefs = businessObject.eventDefinitions;\n    let eventDefAddition = "";\n    if (eventDefs && eventDefs.length > 0) {\n        const eventDefType = eventDefs[0].$type;\n        eventDefAddition = eventDefType.substring(eventDefType.indexOf(":") + 1, eventDefType.indexOf("EventDefinition"));\n    }\n    return eventDefAddition;\n};\nconst refactIdToType = (languageService, oldDomElement, newDomElement) => __awaiter(void 0, void 0, void 0, function* () {\n    const oldBusinessObject = oldDomElement.businessObject;\n    const newBusinessObject = newDomElement.businessObject;\n    const oldId = oldBusinessObject.id;\n    const newId = newBusinessObject.id;\n    const oldType = oldBusinessObject.$type;\n    const newType = newBusinessObject.$type;\n    let oldTypePrefix = oldType.substring(oldType.indexOf(":") + 1);\n    let newTypePrefix = newType.substring(newType.indexOf(":") + 1);\n    oldTypePrefix = getEventDefinition(oldBusinessObject) + oldTypePrefix;\n    newTypePrefix = getEventDefinition(newBusinessObject) + newTypePrefix;\n    const isCustomId = !oldId.startsWith(oldTypePrefix);\n    if (isCustomId) {\n        return switchId(languageService, newDomElement, oldId);\n    }\n    else if (oldTypePrefix !== newTypePrefix || !newId.startsWith(newTypePrefix)) {\n        const idWithoutPrefix = oldId.substring(oldTypePrefix.length);\n        let newGeneratedId = newTypePrefix + idWithoutPrefix;\n        if (!(yield isValidId(newBusinessObject, newGeneratedId))) {\n            const idManager = newBusinessObject.$model.ids;\n            newGeneratedId = `${newTypePrefix}_${idManager.next()}`;\n        }\n        return switchId(languageService, newDomElement, newGeneratedId);\n    }\n    else {\n        return newDomElement;\n    }\n});\nconst preventAnimationsWhileLoading = ($canvas) => {\n    setAnimations($canvas);\n    setTimeout(() => {\n        setAnimations($canvas, "0.218s");\n    }, 500);\n};\nconst openPanel = (panelWrapperId, panelId, $canvas, panelToggleId) => __awaiter(void 0, void 0, void 0, function* () {\n    const $toggle = $(panelToggleId);\n    const $toggleText = $toggle.find(".vxcp-ent-vbcp-panel-toggle-text");\n    const hideAttributesText = yield PlatformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.toggle-text.panel-shown");\n    $(`${panelId} .vxcp-ent-vbcp-panel`).removeClass("panel-hidden prevent-animation");\n    $toggle.removeClass("prevent-animation");\n    $toggle.addClass("panel-shown");\n    $canvas.addClass("panel-shown");\n    $toggleText.text(hideAttributesText);\n});\nconst selectPanel = (panelWrapperId, panelId, $canvas, panelToggleId, eventBus) => __awaiter(void 0, void 0, void 0, function* () {\n    eventBus.fire("viadee.panel.selected", {\n        panelWrapperId,\n        panelId,\n        panelToggleId,\n        panelType: _model_enum_panel_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .PanelTypeEnum.VBCP_PANEL */ .Y.VBCP_PANEL,\n    });\n});\nconst closePanel = (panelWrapperId, panelId, $canvas, panelToggleId, appMode) => __awaiter(void 0, void 0, void 0, function* () {\n    const $toggle = $(panelToggleId);\n    const $toggleText = $toggle.find(".vxcp-ent-vbcp-panel-toggle-text");\n    const showAttributesText = yield PlatformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.toggle-text.panel-hidden");\n    const $panelWrapper = $(panelWrapperId);\n    $panelWrapper.addClass("panel-hidden");\n    $(panelId + " .vxcp-ent-vbcp-panel").addClass("panel-hidden");\n    $toggle.removeClass("panel-shown");\n    $toggle.addClass("panel-hidden");\n    $canvas.removeClass("panel-shown");\n    if ($(".view-drd").length && appMode === _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_3__/* .AppModeEnum.VIEWER */ .v.VIEWER) {\n        $toggle.css("display", "none");\n        $toggle.addClass("prevent-animation");\n    }\n    else {\n        $toggle.css("display", "block");\n    }\n    $toggleText.text(showAttributesText);\n});\nconst collapseGroup = (groupId, panelId) => {\n    groupId = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_0__.refactId)(groupId);\n    panelId = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_0__.refactId)(panelId);\n    const $group = $(`${panelId} ${groupId}`);\n    if ($group.is(".group-closed")) {\n        $group.removeClass("group-closed");\n    }\n    else {\n        $group.addClass("group-closed");\n    }\n};\nconst highlightGroup = (groupId, panelId) => {\n    groupId = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_0__.refactId)(groupId);\n    panelId = panelId ? (0,_utils_utils__WEBPACK_IMPORTED_MODULE_0__.refactId)(panelId) : "#vxcp-ent-att-panel";\n    const $group = $(`${panelId} ${groupId}`);\n    $group.removeClass("highlighted");\n    $group.removeClass("group-closed");\n    $group.addClass("highlighted");\n    setTimeout(() => {\n        $group.removeClass("highlighted");\n    }, 1000);\n};\nconst adjustTextarea = (panelId) => {\n    const allInputField = "textarea.vxcp-ent-att-panel-textfield";\n    $(panelId)\n        .find(allInputField)\n        .filter((index, element) => {\n        const actInputField = element;\n        if (!actInputField) {\n            return false;\n        }\n        actInputField.style.height = "23px";\n        if (actInputField.scrollHeight > 78) {\n            actInputField.style.height = "78px";\n        }\n        else {\n            actInputField.style.height = `${2 + actInputField.scrollHeight}px`;\n        }\n        return true;\n    });\n};\nconst copyDataToNewElement = (languageService, elementPairs) => {\n    elementPairs.forEach((pair) => __awaiter(void 0, void 0, void 0, function* () {\n        const oldBusinessObject = pair.oldElement.businessObject;\n        const newBusinessObject = pair.newElement.businessObject;\n        if (oldBusinessObject.extensionElements) {\n            newBusinessObject.extensionElements = oldBusinessObject.extensionElements;\n        }\n        const oldAttributes = oldBusinessObject.$attrs;\n        for (const additionalAttribute in oldAttributes) {\n            if (oldAttributes.hasOwnProperty(additionalAttribute)) {\n                newBusinessObject.$attrs[additionalAttribute] = oldAttributes[additionalAttribute];\n            }\n        }\n        return yield refactIdToType(languageService, pair.oldElement, pair.newElement);\n    }));\n};\nconst loadProcessAttributes = (panelId, processRefObject) => {\n    if (!panelId || !processRefObject) {\n        vxcpLogger.logError("loadProcessAttributes", "No panelId or processRefObject given. Please check parameters.");\n        return false;\n    }\n    panelId = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_0__.refactId)(panelId);\n    const $processRefNameInput = $(`${panelId} #process-ref-name-input`);\n    const $processRefDescInput = $(`${panelId} #process-ref-desc-input`);\n    $processRefNameInput.val(processRefObject.name);\n    let processRefDesc = "";\n    if (processRefObject.documentation) {\n        processRefDesc = processRefObject.documentation[0].text;\n    }\n    $processRefDescInput.val(processRefDesc);\n    return true;\n};\nconst savePropertyToXml = (languageService, panelId, $inputField) => __awaiter(void 0, void 0, void 0, function* () {\n    const moddle = languageService.getModdle();\n    const ElementEnum = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_4__/* .getPluginService */ .j)().getElementTypeEnum();\n    const inputFieldId = $inputField.attr("id");\n    const selectedElements = getSelectedElements(languageService);\n    const curElement = selectedElements[0];\n    let actBpmnElement;\n    let actProcessRef;\n    switch (inputFieldId) {\n        case "element-name-input":\n            const newName = sanitizerService.getSanitizedString($inputField.val());\n            curElement.businessObject.name = newName;\n            languageService.updateProperties(curElement, { name: newName });\n            break;\n        case "process-ref-name-input":\n            actBpmnElement = curElement.businessObject;\n            actProcessRef = actBpmnElement.processRef;\n            const newProcessName = sanitizerService.getSanitizedString($inputField.val());\n            actProcessRef.name = newProcessName;\n            languageService.updateProperties(curElement, { processRef: actProcessRef });\n            break;\n        case "element-desc-input":\n            const newDesc = sanitizerService.getSanitizedString($inputField.val());\n            actBpmnElement = curElement.businessObject;\n            actProcessRef = actBpmnElement.processRef;\n            if (!actBpmnElement.documentation) {\n                actBpmnElement.documentation = [];\n            }\n            if (actBpmnElement.documentation.length === 0) {\n                actBpmnElement.documentation[0] = moddle.create(ElementEnum.DOCUMENTATION);\n            }\n            const newDocumentation = actBpmnElement.documentation;\n            newDocumentation[0].text = newDesc;\n            languageService.updateProperties(curElement, { documentation: newDocumentation });\n            break;\n        case "process-ref-desc-input":\n            const newProcessDesc = sanitizerService.getSanitizedString($inputField.val());\n            actBpmnElement = curElement.businessObject;\n            actProcessRef = actBpmnElement.processRef;\n            if (!actProcessRef.documentation) {\n                actProcessRef.documentation = [];\n                actProcessRef.documentation[0] = moddle.create(ElementEnum.DOCUMENTATION);\n            }\n            const newProcessDocumentation = actProcessRef.documentation;\n            newProcessDocumentation[0].text = newProcessDesc;\n            languageService.updateProperties(curElement, { processRef: actProcessRef });\n            break;\n        default:\n            vxcpLogger.logError("savePropToBpmn", "Failed saving the attribute!");\n    }\n});\nconst saveOrResetId = (languageService, panelId, $inputField) => __awaiter(void 0, void 0, void 0, function* () {\n    panelId = refactId(panelId);\n    const newId = $inputField.val();\n    const inputFieldId = $inputField[0].id;\n    const selectedElements = getSelectedElements(languageService);\n    const curElement = selectedElements[0];\n    const isProcessRef = inputFieldId.includes("process-ref");\n    if (curElement) {\n        $inputField.removeClass("invalid");\n        $(`${panelId} .vxcp-ent-att-panel-error-message`).addClass("vxcp-ent-att-panel-hidden");\n        const actBusinessObject = curElement.businessObject;\n        const objectToChangeId = isProcessRef ? actBusinessObject.processRef : actBusinessObject;\n        const oldId = objectToChangeId.id;\n        if (!(yield isValidId(objectToChangeId, newId, isProcessRef))) {\n            $inputField.val(oldId);\n        }\n        else if (oldId !== newId) {\n            switchId(languageService, curElement, newId, isProcessRef);\n        }\n    }\n});\nconst switchId = (languageService, domElement, newId, isProcessRef) => {\n    const businessObject = isProcessRef ? domElement.businessObject.processRef : domElement.businessObject;\n    const idManager = businessObject.$model.ids;\n    idManager.unclaim(businessObject.id);\n    businessObject.id = newId;\n    idManager.claim(newId, businessObject);\n    const newPropertiesObject = isProcessRef ? {} : { id: newId };\n    languageService.updateProperties(domElement, newPropertiesObject);\n};\nconst isValidId = (curBusinessObject, id, isProcessRef) => __awaiter(void 0, void 0, void 0, function* () {\n    const idManager = curBusinessObject.$model.ids;\n    const idIsAssigned = idManager.assigned(id);\n    const idExists = idIsAssigned && idIsAssigned !== curBusinessObject;\n    const idRegEx = new RegExp(/^[A-Za-z][A-Za-z0-9\\u002e\\u005f-]+$/g);\n    const notNullError = yield PlatformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.technical-tab.general-attr-group.id-not-null-error");\n    const notUniqueError = yield PlatformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.technical-tab.general-attr-group.id-not-unique-error");\n    const notValidError = yield PlatformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.technical-tab.general-attr-group.id-not-valid-error");\n    const $errorMessage = isProcessRef ? $("#process-ref-id-error") : $("#element-id-error");\n    $errorMessage.removeClass("vxcp-ent-att-panel-hidden");\n    if (!id) {\n        $errorMessage.text(notNullError);\n        return false;\n    }\n    else if (idExists) {\n        $errorMessage.text(notUniqueError);\n        return false;\n    }\n    else if (!idRegEx.test(id)) {\n        $errorMessage.text(notValidError);\n        return false;\n    }\n    else {\n        $errorMessage.addClass("vxcp-ent-att-panel-hidden");\n        return true;\n    }\n});\nconst getSelectedElements = (languageService) => {\n    return languageService.getSelectedElements();\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/panel-utils.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/panel-wrapper.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  "s": () => (/* binding */ PanelWrapperService)\n});\n\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts\nvar plugin_specific_factory = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/bpmn-dmn-js-properties-panel.service.ts\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\nclass BpmnDmnJsPropertiesPanelService {\n    constructor() {\n        this.platformUtils = (0,plugin_specific_factory/* getPlatformService */.km)().getPlatformUtils() || {};\n        this.panelId = "";\n        this.panelWrapperId = "";\n        this.panelToggleId = "";\n        this.toggleWrapperId = "";\n    }\n    init(uniqueId, panelWrapperId, toggleWrapperId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.panelId = `#vxcp-ent-panel-wrapper-${uniqueId} .vxcp-ent-bpmn-js-panel`;\n            this.panelWrapperId = panelWrapperId;\n            this.toggleWrapperId = toggleWrapperId;\n            this.panelToggleId = `${this.toggleWrapperId} .vxcp-ent-bpmn-js-panel-toggle`;\n            const toggleText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.bpmn-js-panel.toggle-text.panel-hidden");\n            const toggleHtml = `<div class="vxcp-ent-bpmn-js-panel-toggle vxcp-ent-panel-toggle">\n                <div class="vxcp-ent-bpmn-js-panel-toggle-text vxcp-ent-att-panel-vertical-text">${toggleText}</div>\n               <span class=" vxcp-ent-bpmn-js-panel-toggle-icon vxcp-ent-panel-toggle-icon aui-icon aui-icon-small aui-iconfont-arrows-right"></span>\n            </div>`;\n            $(this.toggleWrapperId).append(toggleHtml);\n            return this.panelId;\n        });\n    }\n    getPanelId() {\n        return this.panelId;\n    }\n    getToggleId() {\n        return this.panelToggleId;\n    }\n    togglePanel(togglePanel) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $panel = $(`${this.panelId}`);\n            let openPanel = togglePanel;\n            if (togglePanel === undefined) {\n                openPanel = $panel.is(".panel-hidden");\n            }\n            if (openPanel) {\n                yield this.openPanel();\n            }\n            else {\n                yield this.closePanel();\n            }\n        });\n    }\n    openPanel() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $toggle = $(this.panelToggleId);\n            const $toggleText = $toggle.find(".vxcp-ent-bpmn-js-panel-toggle-text");\n            const hideAttributesText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.bpmn-js-panel.toggle-text.panel-shown");\n            $(this.panelId).removeClass("panel-hidden prevent-animation");\n            $toggle.removeClass("prevent-animation");\n            $toggle.addClass("panel-shown");\n            $toggleText.text(hideAttributesText);\n        });\n    }\n    closePanel() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $toggle = $(this.panelToggleId);\n            const $toggleText = $toggle.find(".vxcp-ent-bpmn-js-panel-toggle-text");\n            const showAttributesText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.bpmn-js-panel.toggle-text.panel-hidden");\n            const $panelWrapper = $(this.panelWrapperId);\n            $panelWrapper.addClass("panel-hidden");\n            $(this.panelId).addClass("panel-hidden");\n            $toggle.removeClass("panel-shown");\n            $toggleText.text(showAttributesText);\n        });\n    }\n}\n\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/components/attribute-panel.component.ts + 1 modules\nvar attribute_panel_component = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/components/attribute-panel.component.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-mode.enum.ts\nvar app_mode_enum = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-mode.enum.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/panel-utils.service.ts\nvar panel_utils_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/panel-utils.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/panel-type.enum.ts\nvar panel_type_enum = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/panel-type.enum.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model-language/empty-language.service.ts\nvar empty_language_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/empty-language.service.ts");\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/panel-wrapper.service.ts\nvar panel_wrapper_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\nclass PanelWrapperService {\n    constructor(xmlExtensionService, confluenceWorkaroundService, linkPropertiesService, panelLinksService, legacyLinkHandler, macroService, linkDialogInitService, managedDataFieldsService) {\n        this.helpWizardStarterId = "#vxcp-ent-att-panel-help-wizard";\n        this.toggleWrapperId = "";\n        this.panelWrapperId = "";\n        this.bpmnjsPanelId = "";\n        this.existsBpmnJsPanel = true;\n        this.languageService = new empty_language_service/* EmptyLanguageService */.l();\n        this.vbcpPanelId = "";\n        this.vbcpPanelToggleId = "";\n        this.bpmnJsPanelToggleId = "";\n        this.bpmnJsPanelContentClass = ".bio-properties-panel-scroll-container";\n        this.vbcpAttributePanel = new attribute_panel_component/* AttributePanel */.Q(xmlExtensionService, confluenceWorkaroundService, linkPropertiesService, panelLinksService, legacyLinkHandler, macroService, linkDialogInitService, managedDataFieldsService);\n        this.bpmnJsPropertiesPanelService = new BpmnDmnJsPropertiesPanelService();\n    }\n    getVbcpAttributePanel() {\n        return this.vbcpAttributePanel;\n    }\n    getBpmnJsAttributePanel() {\n        return this.bpmnJsPropertiesPanelService;\n    }\n    init(appMode, languageService, vbcpEntId, pageId, fromMode, panelWrapperId, toggleWrapperId, $canvas, configValues) {\n        return panel_wrapper_service_awaiter(this, void 0, void 0, function* () {\n            this.panelWrapperId = panelWrapperId;\n            this.toggleWrapperId = toggleWrapperId;\n            this.existsBpmnJsPanel = appMode === app_mode_enum/* AppModeEnum.EDITOR */.v.EDITOR;\n            this.appMode = appMode;\n            this.languageService = languageService;\n            if (this.existsBpmnJsPanel) {\n                this.bpmnjsPanelId = yield this.bpmnJsPropertiesPanelService.init(`${pageId}-${vbcpEntId}`, this.panelWrapperId, this.toggleWrapperId);\n                this.bpmnJsPanelToggleId = this.bpmnJsPropertiesPanelService.getToggleId();\n                this.initBpmnjsPanelToggle();\n            }\n            const $panelWrapper = $(panelWrapperId);\n            yield this.vbcpAttributePanel.init(languageService, vbcpEntId, pageId, fromMode, $panelWrapper, $canvas, configValues, this.appMode);\n            (0,panel_utils_service/* preventAnimationsWhileLoading */.Fw)($panelWrapper);\n            this.vbcpPanelToggleId = this.vbcpAttributePanel.getToggleId();\n            this.vbcpPanelId = `${this.vbcpAttributePanel.getPanelId()} .vxcp-ent-vbcp-panel`;\n            this.initVbcpPanelToggle();\n            yield this.initPanelHeader(appMode);\n            const eventBus = this.languageService.getEventBus();\n            this.initSelectPanelEventListener(eventBus);\n            this.initSelectionChangedEventListener(eventBus);\n        });\n    }\n    getBpmnJsPanelId() {\n        return this.bpmnJsPropertiesPanelService.getPanelId();\n    }\n    getBpmnJsPanelToggleId() {\n        return this.bpmnJsPropertiesPanelService.getToggleId();\n    }\n    getVbcpPanelId() {\n        return this.vbcpAttributePanel.getToggleId();\n    }\n    getVbcpPanelToggleId() {\n        return this.vbcpAttributePanel.getPanelId();\n    }\n    initSelectPanelEventListener(eventBus) {\n        eventBus.on("viadee.panel.selected", (e, ids) => panel_wrapper_service_awaiter(this, void 0, void 0, function* () {\n            let fromPanel;\n            let fromPanelToggleId;\n            let toPanel;\n            let toPanelToggleId;\n            switch (ids.panelType) {\n                case panel_type_enum/* PanelTypeEnum.BPMN_JS_PANEL */.Y.BPMN_JS_PANEL:\n                    fromPanel = this.vbcpPanelId;\n                    fromPanelToggleId = this.vbcpPanelToggleId;\n                    toPanel = this.bpmnjsPanelId;\n                    toPanelToggleId = this.bpmnJsPanelToggleId;\n                    break;\n                case panel_type_enum/* PanelTypeEnum.VBCP_PANEL */.Y.VBCP_PANEL:\n                default:\n                    fromPanel = this.bpmnjsPanelId;\n                    fromPanelToggleId = this.bpmnJsPanelToggleId;\n                    toPanel = this.vbcpPanelId;\n                    toPanelToggleId = this.vbcpPanelToggleId;\n                    break;\n            }\n            if (this.isPanelHidden()) {\n                yield this.togglePanel(true);\n                if (ids.panelType === panel_type_enum/* PanelTypeEnum.BPMN_JS_PANEL */.Y.BPMN_JS_PANEL) {\n                    this.switchPanel(fromPanel, fromPanelToggleId, toPanel, toPanelToggleId);\n                }\n            }\n            else {\n                this.switchPanel(fromPanel, fromPanelToggleId, toPanel, toPanelToggleId);\n            }\n        }));\n    }\n    initSelectionChangedEventListener(eventBus) {\n        eventBus.on("viadee.selection.changed", (event) => panel_wrapper_service_awaiter(this, void 0, void 0, function* () {\n            event.stopPropagation();\n            event.preventDefault();\n            if (event.oldSelection.length > 1 && event.newSelection.length <= 1) {\n                $(this.bpmnJsPanelContentClass).toggleClass("panel-hidden", this.isVbcpPanelSelected());\n            }\n        }));\n    }\n    togglePanel(openPanel) {\n        return panel_wrapper_service_awaiter(this, void 0, void 0, function* () {\n            const doOpenPanel = openPanel === undefined ? this.isPanelHidden() : openPanel;\n            if (doOpenPanel) {\n                yield this.openPanel();\n            }\n            else {\n                yield this.closePanel();\n            }\n            $(this.vbcpPanelId).toggleClass("panel-selected", doOpenPanel);\n            $(this.vbcpPanelToggleId).toggleClass("panel-selected", doOpenPanel);\n            if (this.existsBpmnJsPanel) {\n                $(this.bpmnjsPanelId).removeClass("panel-selected");\n                $(this.bpmnjsPanelId).addClass("panel-hidden");\n                $(this.bpmnJsPanelToggleId).removeClass("panel-selected");\n                $(this.bpmnJsPanelContentClass).addClass("panel-hidden");\n            }\n        });\n    }\n    switchPanel(fromPanelId, fromPanelToggleId, toPanelId, toPanelToggleId) {\n        const $fromPanel = $(fromPanelId);\n        const $toPanel = $(toPanelId);\n        if ($fromPanel.hasClass("panel-hidden") && !$fromPanel.hasClass("panel-selected") && $toPanel.hasClass("panel-selected") && !$toPanel.hasClass("panel-hidden")) {\n            return;\n        }\n        $(toPanelToggleId).addClass("panel-selected");\n        $(fromPanelToggleId).removeClass("panel-selected");\n        $(this.vbcpPanelId).addClass("prevent-animation");\n        $(this.bpmnjsPanelId).addClass("prevent-animation");\n        $fromPanel.removeClass("panel-selected");\n        $fromPanel.addClass("panel-hidden");\n        $toPanel.addClass("panel-selected");\n        $toPanel.removeClass("panel-hidden");\n        $(this.bpmnJsPanelContentClass).toggleClass("panel-hidden");\n    }\n    switchToVbcpPanel() {\n        const $selectedToggle = $(this.toggleWrapperId).find(".panel-selected");\n        const $vbcpToggle = $(this.vbcpPanelToggleId);\n        const $vbcpPanel = $(this.vbcpPanelId);\n        const $selectedPanel = $(this.panelWrapperId).find(".panel-selected");\n        $selectedToggle.removeClass("panel-selected");\n        $vbcpToggle.addClass("panel-selected");\n        $selectedPanel.addClass("prevent-animation");\n        $vbcpPanel.addClass("prevent-animation");\n        $selectedPanel.removeClass("panel-selected");\n        $selectedPanel.addClass("panel-hidden");\n        if (this.existsBpmnJsPanel) {\n            $(this.bpmnJsPanelContentClass).addClass("panel-hidden");\n        }\n        $vbcpPanel.addClass("panel-selected");\n        $vbcpPanel.removeClass("panel-hidden");\n    }\n    initVbcpPanelToggle() {\n        $(this.vbcpPanelToggleId).off();\n        $(this.vbcpPanelToggleId).on("click", (e) => panel_wrapper_service_awaiter(this, void 0, void 0, function* () {\n            e.stopPropagation();\n            e.preventDefault();\n            if (this.isPanelHidden()) {\n                yield this.openPanel();\n                $(this.vbcpPanelId).addClass("panel-selected");\n                $(this.vbcpPanelToggleId).addClass("panel-selected");\n                $(this.bpmnJsPanelContentClass).addClass("panel-hidden");\n            }\n            else if (this.isVbcpPanelSelected()) {\n                yield this.closePanel();\n            }\n            else {\n                this.switchPanel(this.bpmnjsPanelId, this.bpmnJsPanelToggleId, this.vbcpPanelId, this.vbcpPanelToggleId);\n                yield this.vbcpAttributePanel.loadElementAttributes();\n            }\n        }));\n    }\n    initBpmnjsPanelToggle() {\n        $(this.bpmnJsPanelToggleId).off();\n        $(this.bpmnJsPanelToggleId).on("click", (e) => panel_wrapper_service_awaiter(this, void 0, void 0, function* () {\n            e.stopPropagation();\n            e.preventDefault();\n            if (this.isPanelHidden()) {\n                $(this.bpmnjsPanelId).addClass("panel-selected");\n                $(this.bpmnJsPanelToggleId).addClass("panel-selected");\n                $(this.bpmnJsPanelContentClass).removeClass("panel-hidden");\n                yield this.openPanel();\n                $(this.vbcpPanelId).addClass("panel-hidden");\n            }\n            else if (this.isBpmnJsPanelSelected()) {\n                yield this.closePanel();\n            }\n            else {\n                this.switchPanel(this.vbcpPanelId, this.vbcpPanelToggleId, this.bpmnjsPanelId, this.bpmnJsPanelToggleId);\n            }\n        }));\n    }\n    openPanel() {\n        return panel_wrapper_service_awaiter(this, void 0, void 0, function* () {\n            const $showNavbarLink = $("#vxcp-ent-navbar-show");\n            const $pluginVersion = $("#vxcp-ent-plugin-version");\n            $pluginVersion.addClass("panel-shown");\n            $showNavbarLink.addClass("panel-shown");\n            $(this.panelWrapperId).removeClass("panel-hidden");\n            yield this.vbcpAttributePanel.togglePanel(true);\n            if (this.existsBpmnJsPanel) {\n                yield this.bpmnJsPropertiesPanelService.togglePanel(true);\n            }\n        });\n    }\n    closePanel() {\n        return panel_wrapper_service_awaiter(this, void 0, void 0, function* () {\n            const $pluginVersion = $("#vxcp-ent-plugin-version");\n            const $showNavbarLink = $("#vxcp-ent-navbar-show");\n            $pluginVersion.removeClass("panel-shown");\n            $showNavbarLink.removeClass("panel-shown");\n            $(this.vbcpPanelId).removeClass("prevent-animation");\n            $(this.bpmnjsPanelId).removeClass("prevent-animation");\n            $(this.bpmnjsPanelId).removeClass("panel-selected");\n            $(this.vbcpPanelId).removeClass("panel-selected");\n            $(this.bpmnJsPanelToggleId).removeClass("panel-selected");\n            $(this.vbcpPanelToggleId).removeClass("panel-selected");\n            $(this.panelWrapperId).addClass("panel-hidden");\n            yield this.vbcpAttributePanel.togglePanel(false);\n            if (this.existsBpmnJsPanel) {\n                yield this.bpmnJsPropertiesPanelService.togglePanel(false);\n                $(this.bpmnJsPanelContentClass).addClass("panel-hidden");\n            }\n        });\n    }\n    resetPanel(languageService, configValues) {\n        return panel_wrapper_service_awaiter(this, void 0, void 0, function* () {\n            return yield this.vbcpAttributePanel.resetPanel(languageService, configValues);\n        });\n    }\n    toggleLinkOverlaysOfType(overlayType) {\n        return panel_wrapper_service_awaiter(this, void 0, void 0, function* () {\n            return yield this.vbcpAttributePanel.toggleLinkOverlaysOfType(overlayType);\n        });\n    }\n    toggleAllLinkOverlays() {\n        return panel_wrapper_service_awaiter(this, void 0, void 0, function* () {\n            return yield this.vbcpAttributePanel.toggleAllLinkOverlays();\n        });\n    }\n    updateConfigValues(configs) {\n        return panel_wrapper_service_awaiter(this, void 0, void 0, function* () {\n            return yield this.vbcpAttributePanel.updateLinkConfigValues(configs);\n        });\n    }\n    isPanelHidden() {\n        return $(this.panelWrapperId).is(".panel-hidden");\n    }\n    isVbcpPanelSelected() {\n        return $(this.vbcpPanelId).is(".panel-selected");\n    }\n    isBpmnJsPanelSelected() {\n        return $(this.bpmnjsPanelId).is(".panel-selected");\n    }\n    initPanelHeader(appMode) {\n        return panel_wrapper_service_awaiter(this, void 0, void 0, function* () {\n            if (appMode === app_mode_enum/* AppModeEnum.EDITOR */.v.EDITOR) {\n                $("#vxcp-ent-att-panel-header").hide();\n                $(".vxcp-ent-vbcp-panel").css("background-color", "");\n            }\n            else {\n                $(".vxcp-ent-vbcp-panel").css("padding-top", 0);\n                $(".vxcp-ent-vbcp-panel").css("background-color", "#f8f8f8");\n            }\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/panel-wrapper.service.ts_+_1_modules?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/xml-extension.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "m": () => (/* binding */ XmlExtensionService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts");\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n\n\n\n\n\nclass XmlExtensionService {\n    constructor(aoDiagramLinkService) {\n        this.aoDiagramLinkService = aoDiagramLinkService;\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__/* .getPluginService */ .j)().getPluginName(), "XmlExtensionService");\n        this.pluginService = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__/* .getPluginService */ .j)();\n    }\n    getExtensionsOfType(bpmnElement, extensionType) {\n        const extensions = bpmnElement.extensionElements;\n        if (!extensions || !extensions.values || extensions.values.length < 1) {\n            return [];\n        }\n        if (extensionType) {\n            return bpmnElement.extensionElements.values.filter((extension) => {\n                return extension.$type === extensionType;\n            });\n        }\n        else {\n            return bpmnElement.extensionElements.values;\n        }\n    }\n    getAllLinkExtensions(currentBusinessObject, includeDocumentation) {\n        var _a;\n        const allLinks = [];\n        for (const linkType in _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws) {\n            if (!linkType || linkType === "EMBEDDED_COMMENTS") {\n                continue;\n            }\n            if (isNaN(Number(linkType))) {\n                const links = this.getExtensionsOfType(currentBusinessObject, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws[linkType]);\n                allLinks.push.apply(allLinks, links);\n                if (currentBusinessObject.processRef) {\n                    const processRefLinks = this.getExtensionsOfType(currentBusinessObject.processRef, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws[linkType]);\n                    allLinks.push.apply(allLinks, processRefLinks);\n                }\n            }\n        }\n        if (includeDocumentation) {\n            if (currentBusinessObject.documentation && currentBusinessObject.documentation.length > 0 && ((_a = currentBusinessObject.documentation[0].text) === null || _a === void 0 ? void 0 : _a.length) > 0) {\n                const documentationLink = {\n                    $type: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.DOCUMENTATION */ .ws.DOCUMENTATION,\n                    id: "ElementDocumentation1",\n                    type: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DOCUMENTATION */ .Iu.DOCUMENTATION,\n                    desc: currentBusinessObject.documentation[0].text,\n                };\n                allLinks.push(documentationLink);\n            }\n        }\n        allLinks.map((link) => {\n            link.url = link.url ? _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(link.url) : undefined;\n        });\n        return allLinks;\n    }\n    createExtension(languageService, domElement, extensionType, newExtensionData) {\n        const moddle = languageService.getModdle();\n        const modeling = languageService.getModeling();\n        const eventBus = languageService.getEventBus();\n        const businessObject = domElement.businessObject;\n        if (!businessObject.extensionElements) {\n            const xmlExtensionTagName = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__/* .getPluginService */ .j)().getExtensionElementXmlTagName();\n            businessObject.extensionElements = moddle.create(xmlExtensionTagName);\n        }\n        let newExtension = moddle.create(extensionType);\n        newExtension.url = newExtension.url ? _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(newExtension.url) : undefined;\n        businessObject.extensionElements.get("values").push(newExtension);\n        newExtension = Object.assign(newExtension, newExtensionData);\n        modeling.updateProperties(domElement, {});\n        if (!(extensionType === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.MDF_INSTANCE */ .ws.MDF_INSTANCE)) {\n            eventBus.fire("viadee.elementlinks.changed", domElement);\n        }\n        else {\n            eventBus.fire("viadee.mdflinks.changed", domElement);\n        }\n        if (newExtensionData.type === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN || newExtensionData.type === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN_ENTERPRISE */ .Iu.DMN_ENTERPRISE) {\n            const elementType = businessObject.$type || "";\n            this.aoDiagramLinkService.pushLinkToAddQueue(newExtensionData, this.pluginService.getPluginShorthand(), businessObject.name || "", elementType);\n        }\n        return newExtension;\n    }\n    replaceExistingExtension(languageService, domElement, updatedExtension, oldId) {\n        this.deleteExtensionById(languageService, domElement, oldId, true);\n        const newExtensionInfo = Object.assign({}, updatedExtension);\n        delete newExtensionInfo.$type;\n        newExtensionInfo.url = newExtensionInfo.url ? _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(newExtensionInfo.url) : undefined;\n        this.createExtension(languageService, domElement, updatedExtension.$type, newExtensionInfo);\n    }\n    getAllExtensions(businessObject) {\n        let extensionList = [];\n        if (!businessObject) {\n            return extensionList;\n        }\n        const specialAttributes = ["id", "name", "documentation"];\n        for (const classicAttribute in businessObject) {\n            if (businessObject.hasOwnProperty(classicAttribute) &&\n                !classicAttribute.startsWith("$") &&\n                specialAttributes.indexOf(classicAttribute) < 0 &&\n                typeof businessObject[classicAttribute] !== "function" &&\n                !(businessObject[classicAttribute] instanceof Object)) {\n                extensionList.push({\n                    $type: classicAttribute,\n                    $body: businessObject[classicAttribute],\n                });\n            }\n        }\n        for (const additionalAttribute in businessObject.$attrs) {\n            if (businessObject.$attrs && businessObject.$attrs.hasOwnProperty(additionalAttribute)) {\n                extensionList.push({\n                    $type: additionalAttribute,\n                    $body: businessObject.$attrs[additionalAttribute],\n                });\n            }\n        }\n        const extensionElements = businessObject.extensionElements || null;\n        if (extensionElements) {\n            extensionElements.$children = extensionElements.values;\n            const excludedTypes = Object.values(_model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws);\n            excludedTypes.push("viadee:Comment");\n            extensionList = this.getAllChildrenNotTypeOf(extensionElements, extensionList, excludedTypes);\n        }\n        return extensionList;\n    }\n    deleteExtensionById(languageService, domElement, idOfExtensionToDelete, skipSaving = false) {\n        const modeling = languageService.getModeling();\n        const eventBus = languageService.getEventBus();\n        let extensionToDelete;\n        let businessObject = domElement.businessObject;\n        let allExtensions = businessObject.extensionElements ? businessObject.extensionElements.values : [];\n        let indexOfExtensionToDelete = this.getIndexOfExtension(allExtensions, idOfExtensionToDelete);\n        if (indexOfExtensionToDelete < 0 && businessObject.processRef && businessObject.processRef.extensionElements) {\n            businessObject = businessObject.processRef;\n            allExtensions = businessObject.extensionElements.values;\n            indexOfExtensionToDelete = this.getIndexOfExtension(allExtensions, idOfExtensionToDelete);\n        }\n        extensionToDelete = allExtensions[indexOfExtensionToDelete];\n        if (indexOfExtensionToDelete < 0) {\n            this.vxcpLogger.logWarning("deleteExtensionById", `Could not find extension ${idOfExtensionToDelete}. Neither on element itself, nor on processRef.`);\n            return;\n        }\n        allExtensions.splice(indexOfExtensionToDelete, 1);\n        if (allExtensions.length > 0) {\n            businessObject.extensionElements.values = allExtensions;\n        }\n        else {\n            businessObject.extensionElements = undefined;\n        }\n        if (!skipSaving) {\n            modeling.updateProperties(domElement, {});\n            if (extensionToDelete.type === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.MDF_INSTANCE */ .Iu.MDF_INSTANCE) {\n                eventBus.fire("viadee.mdflinks.changed", domElement);\n            }\n            else {\n                eventBus.fire("viadee.elementlinks.changed", domElement);\n            }\n            if (extensionToDelete.type === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN) {\n                const elementName = domElement.businessObject.name;\n                const elementType = domElement.businessObject.$type || "";\n                this.aoDiagramLinkService.pushLinkToDeleteQueue(extensionToDelete, this.pluginService.getPluginShorthand(), elementName, elementType);\n            }\n        }\n    }\n    getIndexOfExtension(allExtensions, idOfExtensionToDelete) {\n        let indexOfExtensionToDelete = -1;\n        for (let i = 0; i < allExtensions.length; i++) {\n            if (allExtensions[i].id) {\n                if (allExtensions[i].id.toLowerCase() === idOfExtensionToDelete.toLowerCase()) {\n                    indexOfExtensionToDelete = i;\n                    break;\n                }\n            }\n        }\n        return indexOfExtensionToDelete;\n    }\n    getAllChildrenNotTypeOf(extension, allChildren, excludedTypes) {\n        if (!extension.$children) {\n            return allChildren;\n        }\n        extension.$children.forEach((child) => {\n            if (excludedTypes.indexOf(child.$type) === -1) {\n                allChildren.push(child);\n                this.getAllChildrenNotTypeOf(child, allChildren, excludedTypes);\n            }\n        });\n        return allChildren;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/xml-extension.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/bpmn-ent-specific/bpmn-custom-replace-menu.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "h": () => (/* binding */ BpmnCustomReplaceMenuService)\n/* harmony export */ });\n/* harmony import */ var _model_language_language_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language.factory.ts");\n/* harmony import */ var _atlassian_space_bpmn_elements_config_rest_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/space-bpmn-elements-config-rest.service.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\nclass BpmnCustomReplaceMenuService {\n    constructor() {\n        this.languageService = (0,_model_language_language_factory__WEBPACK_IMPORTED_MODULE_0__/* .getEmptyLanguageService */ .a5)();\n        this.spaceKey = "";\n        this.bpmnElementsConfigRestService = new _atlassian_space_bpmn_elements_config_rest_service__WEBPACK_IMPORTED_MODULE_1__/* .SpaceBpmnElementsConfigRestService */ .F();\n    }\n    init(languageService, spaceKey) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.languageService = languageService;\n            this.spaceKey = spaceKey;\n            this.bpmnElementsConfigRestService.init(this.spaceKey);\n            this.customReplaceMenu = this.languageService.getCustomReplaceMenu();\n            if (!this.customReplaceMenu) {\n                return;\n            }\n            const replaceMenuConfig = yield this.bpmnElementsConfigRestService.getBpmnElementsConfig();\n            this.customReplaceMenu.setReplaceMenuConfig(replaceMenuConfig);\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/bpmn-ent-specific/bpmn-custom-replace-menu.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/bpmn-ent-specific/bpmn-lint.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "_": () => (/* binding */ BpmnLintService)\n/* harmony export */ });\n/* harmony import */ var _model_language_language_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language.factory.ts");\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _utils_translate_translator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/translate/translator.ts");\n/* harmony import */ var _atlassian_space_linter_config_rest_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/space-linter-config-rest.service.ts");\n/* harmony import */ var _utils_extension_tab_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/extension-tab.service.ts");\n/* harmony import */ var _modeling_zoom_utils_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/modeling/zoom-utils.service.ts");\n/* harmony import */ var _model_enum_resize_direction_enum__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/resize-direction.enum.ts");\n/* harmony import */ var _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\n/* harmony import */ var _model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\nclass BpmnLintService {\n    constructor(platformUtils, pluginService) {\n        this.languageService = (0,_model_language_language_factory__WEBPACK_IMPORTED_MODULE_0__/* .getEmptyLanguageService */ .a5)();\n        this.spaceKey = "";\n        this.platformUtils = platformUtils;\n        this.pluginService = pluginService;\n        this.linterConfigRestService = new _atlassian_space_linter_config_rest_service__WEBPACK_IMPORTED_MODULE_3__/* .SpaceLinterConfigRestService */ .x();\n    }\n    init(languageService, $bpmnLintBtn, $canvas, spaceKey) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.languageService = languageService;\n            this.bpmnLinter = this.languageService.getLinting();\n            this.$bpmnLintBtn = $bpmnLintBtn;\n            this.spaceKey = spaceKey;\n            this.$canvas = $canvas;\n            this.linterConfigRestService.init(this.spaceKey);\n            this.removePointerEventsFromErrorInfoBox();\n            this.hideErrorInfoBox();\n        });\n    }\n    initLinterSlider() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $slider = $("#vxcp-ent-linter-slider");\n            const $content = $("#vxcp-ent-linter-list");\n            const $wrapper = $("#vxcp-ent-linter-wrapper");\n            yield (0,_utils_utils__WEBPACK_IMPORTED_MODULE_1__.initSlider)($slider, $content, $wrapper, _model_enum_resize_direction_enum__WEBPACK_IMPORTED_MODULE_6__/* .ResizeDirectionEnum.BOTTOM_TO_TOP */ .c.BOTTOM_TO_TOP);\n        });\n    }\n    toggleBpmnLinter() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!this.bpmnLinter) {\n                return;\n            }\n            try {\n                const spaceLintConfig = yield this.linterConfigRestService.getLinterConfig();\n                for (const key of Object.keys(spaceLintConfig)) {\n                    const configValue = spaceLintConfig[key];\n                    if (configValue === "off") {\n                        delete this.bpmnLinter._linterConfig.config.rules[key];\n                    }\n                    else {\n                        this.bpmnLinter._linterConfig.config.rules[key] = spaceLintConfig[key];\n                    }\n                }\n            }\n            finally {\n                this.bpmnLinter.toggle();\n                if (this.bpmnLinter.isActive()) {\n                    yield this.activateBpmnLinter();\n                }\n                else {\n                    this.deactivateBpmnLinter();\n                }\n            }\n        });\n    }\n    updateErrorTable() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const modelingIssues = this.bpmnLinter._issues;\n            const issuesValues = Object.values(modelingIssues);\n            const issues = [];\n            issuesValues.forEach((value) => {\n                value.forEach((v) => {\n                    issues.push(v);\n                });\n            });\n            $(".vxcp-ent-linter-table-body").empty();\n            const elementRegistry = this.languageService.getElementRegistry();\n            yield (0,_utils_utils__WEBPACK_IMPORTED_MODULE_1__.asyncForEach)(issues, (issue, index) => __awaiter(this, void 0, void 0, function* () {\n                const element = elementRegistry.get(issue.id);\n                if (!element) {\n                    return;\n                }\n                const elementName = element.businessObject.name ? element.businessObject.name : "";\n                const tableRowHtml = yield this.getErrorTableRowForIssue(issue, index, elementName);\n                $(".vxcp-ent-linter-table-body").append(tableRowHtml);\n                const orgElement = $(`[data-element-id="${issue.id}"]`);\n                if (orgElement.hasClass("djs-element")) {\n                    $(`#${issue.id}-${index}-table`)\n                        .parent()\n                        .hover(() => {\n                        const isError = $(`#${issue.id}-${index}-table`).parent().hasClass("vxcp-ent-linter-table-row-error");\n                        const djsClass = isError ? "vxcp-ent-linter-modeling-error" : "vxcp-ent-linter-modeling-warning";\n                        orgElement.find(".djs-visual").children()[0].classList.add(djsClass);\n                    }, () => {\n                        const isError = $(`#${issue.id}-${index}-table`).parent().hasClass("vxcp-ent-linter-table-row-error");\n                        const djsClass = isError ? "vxcp-ent-linter-modeling-error" : "vxcp-ent-linter-modeling-warning";\n                        orgElement.find(".djs-visual").children()[0].classList.remove(djsClass);\n                    });\n                }\n            }));\n            $("#vxcp-ent-linter-table tr").on("click", (e) => {\n                e.preventDefault();\n                const $clickedElement = $(e.currentTarget);\n                $clickedElement.addClass("selected").siblings().removeClass("selected");\n                const selectedElementId = (0,_utils_extension_tab_service__WEBPACK_IMPORTED_MODULE_4__/* .getIdBySelectedElementFromExtensionTab */ .HP)($clickedElement, 3);\n                const element = elementRegistry.get(selectedElementId);\n                if (element.type === "bpmn:Process") {\n                    (0,_utils_extension_tab_service__WEBPACK_IMPORTED_MODULE_4__/* .unselectHighlightedElements */ .yl)();\n                    (0,_modeling_zoom_utils_service__WEBPACK_IMPORTED_MODULE_5__/* .zoomDiagramFitToCanvas */ .gJ)(this.languageService, 30, 30, 50, 0);\n                }\n                else {\n                    (0,_utils_extension_tab_service__WEBPACK_IMPORTED_MODULE_4__/* .focusElement */ .C5)(selectedElementId, this.languageService);\n                }\n            });\n        });\n    }\n    getErrorTableRowForIssue(issue, index, elementName) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const errorType = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.linter-error-list-tab.other-extensions-group.error");\n            const warningType = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.linter-error-list-tab.other-extensions-group.warning");\n            const locale = yield this.platformUtils.getLocale();\n            const translatedIssueMessage = (0,_utils_translate_translator__WEBPACK_IMPORTED_MODULE_2__/* .translateLinterErrors */ .q)(locale, issue.rule, issue.message);\n            switch (issue.category) {\n                case "error":\n                    return `<tr class="vxcp-ent-linter-table-row-error">\n                            <td>${index + 1}</td>\n                            <td>${_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_7__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(elementName)}</td>\n                            <td id="${issue.id}-${index}-table"><p class="vxcp-ent-linter-element-id">${issue.id}</p></td>\n                            <td>${_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_7__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(translatedIssueMessage)}</td>\n                            <td><span class="vxcp-ent-linter-error-label">${errorType}</span></td>\n                        </tr>`;\n                case "warn":\n                default:\n                    return `<tr class="vxcp-ent-linter-table-row-warning">\n                            <td>${index + 1}</td>\n                            <td>${_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_7__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(elementName)}</td>\n                            <td id="${issue.id}-${index}-table"><p class="vxcp-ent-linter-element-id">${issue.id}</p></td>\n                            <td>${_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_7__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(translatedIssueMessage)}</td>\n                            <td><span class="vxcp-ent-linter-warning-label">${warningType}</span></td>\n                        </tr>`;\n            }\n        });\n    }\n    activateBpmnLinter() {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.showErrorInfoBox();\n            const $canvasWrapper = this.$canvas.parent();\n            const bpmnLintTemplate = yield this.platformUtils.getTemplate(_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_8__/* .TemplateNamesEnum.LINTER */ .X.LINTER);\n            this.$bpmnLintBtn.addClass("icon-selected");\n            $canvasWrapper.append(bpmnLintTemplate);\n            $canvasWrapper[0].style.backgroundColor = "#ffffff";\n            $("#vxcp-ent-differ-diagram-loading").show();\n            const $listOfModelingErrorsBtn = $(document).find("#vxcp-ent-linter-list-icon");\n            const $modelingErrorsList = $(document).find("#vxcp-ent-linter-list");\n            $listOfModelingErrorsBtn.on("click", (e) => {\n                e.preventDefault();\n                if ($modelingErrorsList.hasClass("collapsed")) {\n                    $modelingErrorsList.removeClass("collapsed");\n                }\n                else {\n                    $modelingErrorsList.addClass("collapsed");\n                    (0,_utils_extension_tab_service__WEBPACK_IMPORTED_MODULE_4__/* .unselectHighlightedElements */ .yl)();\n                }\n            });\n            const $bpmnLintTable = $(document).find("#vxcp-ent-linter-errors");\n            const bpmnLintTableTemplate = yield this.platformUtils.getTemplate(_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_8__/* .TemplateNamesEnum.LINTER_TABLE */ .X.LINTER_TABLE);\n            if ($bpmnLintTable && bpmnLintTableTemplate) {\n                $bpmnLintTable.html(bpmnLintTableTemplate);\n            }\n            yield this.updateErrorTable();\n            const eventBus = this.languageService.getEventBus();\n            eventBus.on(["linting.completed"], (e) => __awaiter(this, void 0, void 0, function* () {\n                yield this.updateErrorTable();\n            }));\n            yield this.initLinterSlider();\n        });\n    }\n    deactivateBpmnLinter() {\n        if (this.bpmnLinter && this.bpmnLinter.isActive()) {\n            this.bpmnLinter.toggle();\n        }\n        this.$bpmnLintBtn.removeClass("icon-selected");\n        this.hideErrorInfoBox();\n        const $bpmnLintWrapper = document.getElementById("vxcp-ent-linter-wrapper");\n        if ($bpmnLintWrapper) {\n            $bpmnLintWrapper.remove();\n        }\n    }\n    removePointerEventsFromErrorInfoBox() {\n        const $errorInfoBox = this.getErrorInfoBox();\n        $errorInfoBox.css("pointer-events", "none");\n    }\n    hideErrorInfoBox() {\n        const $errorInfoBox = this.getErrorInfoBox();\n        $errorInfoBox.hide();\n    }\n    showErrorInfoBox() {\n        const $errorInfoBox = this.getErrorInfoBox();\n        $errorInfoBox.show();\n    }\n    getErrorInfoBox() {\n        const modelerContainerClass = this.pluginService.getModelerContainerClass();\n        const $bjsContainer = $(`.${modelerContainerClass}`);\n        return $bjsContainer.find(`.bjsl-button`);\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/bpmn-ent-specific/bpmn-lint.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/comala/comala-integration.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ ComalaIntegrationService)\n/* harmony export */ });\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _atlassian_page_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/page.service.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\nclass ComalaIntegrationService {\n    constructor() {\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n    }\n    getComalaMetadataForPage(pageId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const url = this.getConfluenceRestComalaMetadataUrl(pageId);\n            try {\n                const requestResult = yield this.platformUtils.makeRequest({\n                    url,\n                    type: "GET",\n                });\n                return this.platformUtils.getComalaProperties(requestResult);\n            }\n            catch (e) {\n                return null;\n            }\n        });\n    }\n    getShownAttachmentVersionOfHistoricPageVersion(macroKey, pageId, pageVersion, vbcpEntId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const pageData = yield (0,_atlassian_page_service__WEBPACK_IMPORTED_MODULE_0__/* .getPageDataByPageId */ .S4)(pageId, pageVersion.toString());\n            const storageFormatString = pageData.body.storage.value;\n            const macros = this.getMacros(macroKey, storageFormatString);\n            for (const macro of macros) {\n                const macrosEntId = this.getParameterFromSingleMacroStorageFormat(macro, "vbcpEntId");\n                if (macrosEntId === vbcpEntId) {\n                    return parseInt(this.getParameterFromSingleMacroStorageFormat(macro, "shownAttachmentVersion"));\n                }\n            }\n            return -1;\n        });\n    }\n    isComalaActive(pageId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const comalaAppProps = yield this.getComalaMetadataForPage(pageId);\n            return !!comalaAppProps;\n        });\n    }\n    getComalaApprovedShownAttachmentVersion(macroKey, pageId, vbcpEntId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let comalaApprovedShownAttachmentVersion = -1;\n            const comalaAppProps = yield this.getComalaMetadataForPage(pageId);\n            if (comalaAppProps) {\n                const comalaApprovedPageVersion = this.platformUtils.getApprovedVersionOfComalaProperties(comalaAppProps);\n                if (comalaApprovedPageVersion >= 0) {\n                    comalaApprovedShownAttachmentVersion = yield this.getShownAttachmentVersionOfHistoricPageVersion(macroKey, pageId, comalaApprovedPageVersion, vbcpEntId);\n                }\n            }\n            return comalaApprovedShownAttachmentVersion;\n        });\n    }\n    getMacros(macroKey, storageFormatString) {\n        const findEachMacro = new RegExp(`<ac:structured-macro ac:name="${macroKey}.*?ac:structured-macro>`, "gm");\n        const macros = [];\n        let result;\n        while ((result = findEachMacro.exec(storageFormatString)) !== null) {\n            const singleMacroStorageFormat = result[0];\n            macros.push(singleMacroStorageFormat);\n        }\n        return macros;\n    }\n    getParameterFromSingleMacroStorageFormat(singleMacroStorageFormat, parameterKey) {\n        const regexString = `(?:"${parameterKey}">)(.*?)(?=<)`;\n        const paramValueRegex = new RegExp(regexString);\n        const matches = singleMacroStorageFormat.match(paramValueRegex);\n        if (matches) {\n            let match = matches[0];\n            match = match.replace(`"${parameterKey}">`, "");\n            return match;\n        }\n        return "-1";\n    }\n    getConfluenceRestComalaMetadataUrl(pageId) {\n        return `${this.platformUtils.buildConfluenceBaseUrl()}/rest/api/content/${pageId}?expand=metadata.properties.comalaworkflows,metadata.properties.cw_status`;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/comala/comala-integration.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/differ/differ-coloring.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "E": () => (/* binding */ DifferColoringService)\n/* harmony export */ });\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var _differ_events_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/differ/differ-events.service.ts");\n}\n/* harmony import */ var _utils_extension_tab_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/extension-tab.service.ts");\n/* harmony import */ var _model_enum_differ_colors_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/differ-colors.enum.ts");\n/* harmony import */ var _model_enum_differ_symbols_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/differ-symbols.enum.ts");\n/* harmony import */ var _model_enum_model_element_type_enum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/model-element-type.enum.ts");\n/* harmony import */ var _differ_html_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/differ/differ-html.service.ts");\n\n\n\n\n\n\nclass DifferColoringService {\n    constructor() {\n        this.differHtmlService = new _differ_html_service__WEBPACK_IMPORTED_MODULE_4__/* .DifferHtmlService */ .o();\n    }\n    setRightVersionForOverlays(value) {\n        this.differHtmlService.setRightVersion(value);\n    }\n    setLeftVersionForOverlays(value) {\n        this.differHtmlService.setLeftVersion(value);\n    }\n    colorAllElements(languageService, viewerType, $links, changes) {\n        const overlays = languageService.getOverlays();\n        this.colorElementsOfType($links[viewerType], languageService, overlays, changes, "_added");\n        this.colorElementsOfType($links[viewerType], languageService, overlays, changes, "_removed");\n        this.colorElementsOfType($links[viewerType], languageService, overlays, changes, "_layoutChanged");\n        this.colorElementsOfType($links[viewerType], languageService, overlays, changes, "_changed");\n    }\n    colorElementsOfType($viewer, languageService, overlays, changes, extension) {\n        if (!changes) {\n            return;\n        }\n        const color = this.getColorCode(extension);\n        Object.keys(changes[extension]).forEach((val, i) => {\n            if (languageService.getElementRegistry().get(val) && languageService.getElementRegistry().get(val).type === "bpmn:Group") {\n                return;\n            }\n            const idx = Object.keys(changes[extension])[i];\n            let id = changes[extension][idx].id;\n            if (extension === "_changed") {\n                id = changes[extension][idx].model.id;\n            }\n            const element = $viewer.find(`[data-element-id = ${id} ] g *[style*=fill]`);\n            if (element[0]) {\n                if (element[0].tagName === "path") {\n                    element[0].style.stroke = color;\n                }\n                else {\n                    element[0].style.fill = color;\n                }\n            }\n            const symbol = this.getOverlaySymbol(extension);\n            const className = this.getMarkerClass(extension);\n            this.differHtmlService.addMarker(overlays, id, className, symbol);\n            if (extension === "_changed") {\n                const viewerId = $viewer.attr("id");\n                const idExtension = viewerId.includes("differ") ? "-diff" : "-original";\n                (0,_differ_events_service__WEBPACK_IMPORTED_MODULE_5__/* .addClickhandlerOverlays */ .Fp)($viewer, idExtension, changes[extension], idx, id);\n                this.differHtmlService.addOverlays(idExtension, changes[extension], idx, id, overlays);\n            }\n        });\n    }\n    getOverlaySymbol(extension) {\n        switch (extension) {\n            case "_added":\n                return _model_enum_differ_symbols_enum__WEBPACK_IMPORTED_MODULE_2__/* .DifferSymnbolsEnum.ADDED */ .E.ADDED;\n            case "_removed":\n                return _model_enum_differ_symbols_enum__WEBPACK_IMPORTED_MODULE_2__/* .DifferSymnbolsEnum.REMOVED */ .E.REMOVED;\n            case "_layoutChanged":\n                return _model_enum_differ_symbols_enum__WEBPACK_IMPORTED_MODULE_2__/* .DifferSymnbolsEnum.LAYOUT_CHANGED */ .E.LAYOUT_CHANGED;\n            case "_changed":\n                return _model_enum_differ_symbols_enum__WEBPACK_IMPORTED_MODULE_2__/* .DifferSymnbolsEnum.CHANGED */ .E.CHANGED;\n            default:\n                return _model_enum_differ_symbols_enum__WEBPACK_IMPORTED_MODULE_2__/* .DifferSymnbolsEnum.DEFAULT */ .E.DEFAULT;\n        }\n    }\n    getMarkerClass(extension) {\n        let className = "vxcp-ent-marker-";\n        switch (extension) {\n            case "_added":\n                className = className.concat("added");\n                break;\n            case "_removed":\n                className = className.concat("removed");\n                break;\n            case "_layoutChanged":\n                className = className.concat("layoutChanged");\n                break;\n            case "_changed":\n                className = className.concat("changed");\n                break;\n            default:\n                className = "";\n                break;\n        }\n        return className;\n    }\n    getColorCode(extension) {\n        let color;\n        switch (extension) {\n            case "_added":\n                color = _model_enum_differ_colors_enum__WEBPACK_IMPORTED_MODULE_1__/* .DifferColorsEnum.ADDED */ .H.ADDED;\n                break;\n            case "_removed":\n                color = _model_enum_differ_colors_enum__WEBPACK_IMPORTED_MODULE_1__/* .DifferColorsEnum.REMOVED */ .H.REMOVED;\n                break;\n            case "_layoutChanged":\n                color = _model_enum_differ_colors_enum__WEBPACK_IMPORTED_MODULE_1__/* .DifferColorsEnum.LAYOUT_CHANGED */ .H.LAYOUT_CHANGED;\n                break;\n            case "_changed":\n                color = _model_enum_differ_colors_enum__WEBPACK_IMPORTED_MODULE_1__/* .DifferColorsEnum.CHANGED */ .H.CHANGED;\n                break;\n            default:\n                color = _model_enum_differ_colors_enum__WEBPACK_IMPORTED_MODULE_1__/* .DifferColorsEnum.DEFAULT */ .H.DEFAULT;\n                break;\n        }\n        return color;\n    }\n    highlightSelectedElement(id, $links, languageServiceLeft, languageServiceRight) {\n        (0,_utils_extension_tab_service__WEBPACK_IMPORTED_MODULE_0__/* .unselectHighlightedElements */ .yl)();\n        const elementRightId = languageServiceLeft.getElementRegistry().get(id);\n        const elementLeftId = languageServiceRight.getElementRegistry().get(id);\n        if (this.isRootElement(elementRightId, elementLeftId)) {\n            return;\n        }\n        const elementLeft = $links.$viewerLeft.find(`[data-element-id = ${id}] g *[style*=fill]`);\n        const elementRight = $links.$viewerRight.find(`[data-element-id = ${id}] g *[style*=fill]`);\n        let movedViewerLeft = false;\n        let movedViewerRight = false;\n        let movingScaleLeft = [0, 0];\n        let movingScaleRight = [0, 0];\n        if (elementLeft[0]) {\n            elementLeft[0].classList.add("selectedForHighlight");\n            movingScaleLeft = (0,_utils_extension_tab_service__WEBPACK_IMPORTED_MODULE_0__/* .getMovingScale */ .bw)(id, languageServiceLeft);\n            movedViewerLeft = true;\n            this.moveOneViewer(languageServiceLeft, languageServiceRight, movingScaleLeft);\n        }\n        if (elementRight[0]) {\n            movedViewerRight = true;\n            elementRight[0].classList.add("selectedForHighlight");\n            movingScaleRight = (0,_utils_extension_tab_service__WEBPACK_IMPORTED_MODULE_0__/* .getMovingScale */ .bw)(id, languageServiceRight);\n            this.moveOneViewer(languageServiceRight, languageServiceLeft, movingScaleRight);\n        }\n        if (movedViewerLeft && !movedViewerRight) {\n            this.moveOneViewer(languageServiceRight, languageServiceLeft, movingScaleLeft);\n        }\n        else if (!movedViewerLeft && movedViewerRight) {\n            this.moveOneViewer(languageServiceLeft, languageServiceRight, movingScaleRight);\n        }\n    }\n    isRootElement(elementA, elementB) {\n        const types = [_model_enum_model_element_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .BpmnElementTypeEnum.COLLABORATION */ .o.COLLABORATION, _model_enum_model_element_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .BpmnElementTypeEnum.PROCESS */ .o.PROCESS];\n        return (elementA && types.indexOf(elementA.type) > -1) || (elementB && types.indexOf(elementB.type) > -1);\n    }\n    moveOneViewer(languageServiceOfMovingViewer, languageServiceOfOtherViewer, movingScale) {\n        languageServiceOfMovingViewer.getEventBus().off("canvas.viewbox.changing");\n        (0,_differ_events_service__WEBPACK_IMPORTED_MODULE_5__/* .hideOverlayOnMove */ .jc)(languageServiceOfMovingViewer, languageServiceOfOtherViewer);\n        (0,_utils_extension_tab_service__WEBPACK_IMPORTED_MODULE_0__/* .moveViewBox */ .Vl)(languageServiceOfMovingViewer, movingScale);\n        (0,_differ_events_service__WEBPACK_IMPORTED_MODULE_5__/* .syncEventBus */ .OC)(languageServiceOfOtherViewer, languageServiceOfMovingViewer);\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/differ/differ-coloring.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/differ/differ-dialog.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "O": () => (/* binding */ DifferDialogService)\n/* harmony export */ });\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _navbar_attachment_version_name_dialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/navbar/attachment-version-name-dialog.ts");\n/* harmony import */ var _input_output_diagram_version_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/input-output/diagram-version.service.ts");\n/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n/* harmony import */ var _model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\nconst PlatformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_4__/* .getPlatformService */ .km)().getPlatformUtils() || {};\nclass DifferDialogService {\n    constructor(params, diagramName, fileType, pageId, configValues, allowNameVersion, callbackContinue) {\n        this.dialogId = "#vxcp-ent-differ-dialog";\n        this.trRowIdPattern = "vxcp-ent-attachment-attachment-version";\n        this.attachmentAttributesModuleIdPrefix = "#vxcp-ent-attachment-attributes-dialog";\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_4__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.params = params;\n        this.diagramName = diagramName;\n        this.fileType = fileType;\n        this.pageId = pageId;\n        this.allowNameVersion = allowNameVersion;\n        this.callbackContinue = callbackContinue;\n        this.diagramVersionService = new _input_output_diagram_version_service__WEBPACK_IMPORTED_MODULE_2__/* .DiagramVersionService */ .l();\n    }\n    showDifferDialog() {\n        return __awaiter(this, void 0, void 0, function* () {\n            let selectedOptions = [];\n            const template = yield PlatformUtils.getTemplate(_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_3__/* .TemplateNamesEnum.DIFFER_DIALOG */ .X.DIFFER_DIALOG, this.params);\n            (0,_utils_utils__WEBPACK_IMPORTED_MODULE_0__.showDialogFromTemplateStringAndInitButtons)(this.dialogId, template, true, false);\n            this.initFilterCheckboxHandler(() => {\n                selectedOptions = [];\n                $(`${this.attachmentAttributesModuleIdPrefix}-text tr`).removeClass("selected");\n            });\n            if (this.allowNameVersion) {\n                this.initStarButtonHandler(this.showDifferDialog);\n            }\n            else {\n                this.disableStarButton();\n            }\n            $(`${this.attachmentAttributesModuleIdPrefix}-text tr`).on("click", (e) => {\n                const target = $(e.currentTarget);\n                if (target.hasClass("selected")) {\n                    const val = target.attr("id").replace(this.trRowIdPattern, "");\n                    target.removeClass("selected");\n                    const idx = selectedOptions.indexOf(val);\n                    selectedOptions.splice(idx, 1);\n                }\n                else {\n                    target.addClass("selected");\n                    selectedOptions.push(target.attr("id").replace(this.trRowIdPattern, ""));\n                    if (selectedOptions.length > 2) {\n                        const firstElement = $("#" + this.trRowIdPattern + selectedOptions[0]);\n                        firstElement.removeClass("selected");\n                        selectedOptions.shift();\n                    }\n                }\n            });\n            $(this.dialogId + "-continue").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.preventDefault();\n                e.stopPropagation();\n                if (selectedOptions.length < 2) {\n                    const text = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.differ.diagram-diff-error");\n                    this.setErrorMessage(text);\n                    return;\n                }\n                else {\n                    let versionLeft;\n                    let versionRight;\n                    if (parseInt(selectedOptions[0], 10) > parseInt(selectedOptions[1], 10)) {\n                        versionLeft = parseInt(selectedOptions[1], 10);\n                        versionRight = parseInt(selectedOptions[0], 10);\n                    }\n                    else {\n                        versionLeft = parseInt(selectedOptions[0], 10);\n                        versionRight = parseInt(selectedOptions[1], 10);\n                    }\n                    PlatformUtils.hideDialog(this.dialogId);\n                    const versionNameLeft = this.diagramVersionService.getVersionNameOfAttachment(this.params, String(versionLeft));\n                    const versionNameRight = this.diagramVersionService.getVersionNameOfAttachment(this.params, String(versionRight));\n                    this.callbackContinue({ version: versionLeft, versionName: versionNameLeft }, {\n                        version: versionRight,\n                        versionName: versionNameRight,\n                    });\n                }\n            }));\n        });\n    }\n    initFilterCheckboxHandler(removeSelection) {\n        $(this.dialogId + "-filter").on("change", (e) => {\n            const filter = $(e.currentTarget);\n            const filterActive = filter.prop("checked");\n            removeSelection();\n            if (filterActive) {\n                this.diagramVersionService\n                    .getUnnamedVersions(this.params)\n                    .map((version) => {\n                    return `#${this.trRowIdPattern}` + version;\n                })\n                    .forEach((trElementId) => {\n                    $(trElementId).hide();\n                });\n            }\n            else {\n                $(`[id^=${this.trRowIdPattern}]`).show();\n            }\n        });\n    }\n    initStarButtonHandler(callbackNavigateBack) {\n        $(".vxcp-ent-version-star-button").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            const starButton = $(e.currentTarget);\n            const selectedVersion = starButton.parent().parent().attr("id").replace("vxcp-ent-attachment-attachment-version", "");\n            const attachmentVersionNameService = new _navbar_attachment_version_name_dialog__WEBPACK_IMPORTED_MODULE_1__/* .AttachmentVersionNameDialogService */ .R(selectedVersion, this.params, this.diagramName, this.fileType, this.pageId, callbackNavigateBack.bind(this));\n            PlatformUtils.hideDialog(this.dialogId);\n            yield attachmentVersionNameService.showVersionNameDialog();\n        }));\n    }\n    disableStarButton() {\n        $(".vxcp-ent-version-star-button").prop("disabled", true);\n    }\n    setErrorMessage(text) {\n        $("#vxcp-ent-differ-input-error").html(text);\n        $("#vxcp-ent-differ-input-error").removeClass("vxcp-ent-hidden");\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/differ/differ-dialog.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/differ/differ-events.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Fp": () => (/* binding */ addClickhandlerOverlays),\n/* harmony export */   "OC": () => (/* binding */ syncEventBus),\n/* harmony export */   "jc": () => (/* binding */ hideOverlayOnMove),\n/* harmony export */   "sp": () => (/* binding */ syncCanvas)\n/* harmony export */ });\nconst hideOverlayOnMove = (languageService, languageDifferService) => {\n    languageService.getEventBus().on("canvas.viewbox.changing", () => {\n        languageService.getOverlays().hide();\n        languageDifferService.getOverlays().hide();\n    });\n};\nconst syncCanvas = (changedViewerLanguageService, otherViewerLanguageService) => {\n    const newViewbox = changedViewerLanguageService.getCanvas().viewbox(false);\n    otherViewerLanguageService.getCanvas().viewbox(newViewbox);\n};\nconst syncEventBus = (languageService, languageDifferService) => {\n    languageDifferService.getEventBus().on("canvas.viewbox.changing", () => {\n        languageService.getEventBus().off("canvas.viewbox.changing");\n        syncCanvas(languageDifferService, languageService);\n        languageService.getEventBus().on("canvas.viewbox.changing", () => {\n            syncCanvas(languageService, languageDifferService);\n        });\n    });\n    hideOverlayOnMove(languageService, languageDifferService);\n    hideOverlayOnMove(languageDifferService, languageService);\n};\nconst clickedOverlay = (overlayId) => {\n    const $overlay = $(`[id=${overlayId}]`);\n    $overlay.toggleClass("vxcp-ent-hidden");\n};\nconst addClickhandlerOverlays = ($currentViewer, idExtension, changes, idx, id) => {\n    $currentViewer.find(`[data-element-id =${id}]`).click((e) => {\n        e.preventDefault();\n        e.stopPropagation();\n        clickedOverlay(`vxcp-ent-differ-overlay-${id}${idExtension}`);\n    });\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/differ/differ-events.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/differ/differ-html.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "o": () => (/* binding */ DifferHtmlService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_model_element_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/model-element-type.enum.ts");\n/* harmony import */ var _attribute_panel_html_factory_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/html-factory.service.ts");\n/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n/* harmony import */ var _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\nconst PlatformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__/* .getPlatformService */ .km)().getPlatformUtils() || {};\nclass DifferHtmlService {\n    constructor() {\n        this.rightVersion = "";\n        this.leftVersion = "";\n    }\n    setRightVersion(value) {\n        this.rightVersion = value;\n    }\n    setLeftVersion(value) {\n        this.leftVersion = value;\n    }\n    getTemplateObject(changes, extension) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const changesList = [];\n            if (extension === "_changed") {\n                for (const key1 in changes[extension]) {\n                    if (!changes[extension].hasOwnProperty(key1)) {\n                        continue;\n                    }\n                    changesList.push(changes[extension][key1].model);\n                }\n            }\n            else {\n                for (const key in changes[extension]) {\n                    if (!changes[extension].hasOwnProperty(key)) {\n                        continue;\n                    }\n                    changesList.push(changes[extension][key]);\n                }\n            }\n            const list = [];\n            const stringedExt = yield this.getKindOfChange(extension);\n            if (changesList.length > 0) {\n                changesList\n                    .filter((val) => val.$type !== _model_enum_model_element_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .BpmnElementTypeEnum.DATA_OBJECT */ .o.DATA_OBJECT)\n                    .map((val) => {\n                    list.push({\n                        name: val.name || "",\n                        type: val.$type.replace("bpmn:", ""),\n                        change: stringedExt,\n                        identifier: val.id,\n                    });\n                });\n            }\n            return list;\n        });\n    }\n    getKindOfChange(extension) {\n        return __awaiter(this, void 0, void 0, function* () {\n            switch (extension) {\n                case "_added":\n                    return yield PlatformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.differ-table.added");\n                case "_removed":\n                    return yield PlatformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.differ-table.removed");\n                case "_changed":\n                    return yield PlatformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.differ-table.changed");\n                case "_layoutChanged":\n                    return yield PlatformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.differ-table.layoutChanged");\n                default:\n                    return "";\n            }\n        });\n    }\n    getOverlayHtml(changedAttributeValues, attributeKey, changedElement) {\n        return new Promise((resolve) => {\n            let newValue = changedAttributeValues.newValue || "";\n            let oldValue = changedAttributeValues.oldValue || "";\n            switch (attributeKey) {\n                case "extensionElements":\n                    const newExtensions = newValue.values || [];\n                    let allExtensionOverlaysHtml = "";\n                    newExtensions.forEach((extension) => {\n                        let curExtensionOverlayHtml;\n                        if (extension.$type === "camunda:Properties") {\n                            curExtensionOverlayHtml = (0,_attribute_panel_html_factory_service__WEBPACK_IMPORTED_MODULE_1__/* .createExtensionsTableEntrySanitized */ .uC)(extension);\n                        }\n                        else {\n                            const urlOfElementLink = extension.url || "";\n                            const urlLinkHtml = urlOfElementLink ? `<a target="_blank" href="${urlOfElementLink}">URL</a>` : "";\n                            curExtensionOverlayHtml = `<tr>\n                            <td>${extension.$type}</td>\n                            <td></td>\n                            <td>${urlLinkHtml}</td>\n                        </tr>`;\n                        }\n                        allExtensionOverlaysHtml = allExtensionOverlaysHtml.concat(curExtensionOverlayHtml);\n                    });\n                    resolve(allExtensionOverlaysHtml);\n                    break;\n                case "documentation[0]":\n                    attributeKey = "description";\n                    if (!newValue) {\n                        newValue = changedElement.documentation[0];\n                    }\n                    newValue = newValue.text || "";\n                    oldValue = oldValue.text || "";\n                    break;\n                default:\n                    break;\n            }\n            const overlayHtml = `<tr><td>${_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_2__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(attributeKey)}</td><td>${_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_2__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(oldValue)}</td><td>${_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_2__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(newValue)}</td></tr>`;\n            resolve(overlayHtml);\n        });\n    }\n    addOverlays(idExtension, changes, idx, id, overlays) {\n        const changedAttributes = changes[idx].attrs;\n        const changedElement = changes[idx].model;\n        const promises = [];\n        for (const attributeKey in changedAttributes) {\n            if (changedAttributes[attributeKey] && attributeKey !== "name") {\n                promises.push(this.getOverlayHtml(changedAttributes[attributeKey], attributeKey, changedElement));\n            }\n        }\n        Promise.all(promises)\n            .then((overlayHtmlList) => __awaiter(this, void 0, void 0, function* () {\n            yield this.addOverlayHtml(idExtension, id, overlayHtmlList, overlays);\n        }))\n            .catch(() => {\n        });\n    }\n    addOverlayHtml(idExtension, id, overlayHtmlList, overlays) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const attributeText = yield PlatformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.showChangedElementOverlay.attribute");\n            if (overlayHtmlList.length === 0) {\n                return;\n            }\n            const beginHtml = `<div id="vxcp-ent-differ-overlay-${id}${idExtension}" class="vxcp-ent-differ-overlays">\n                                    <table>\n                                        <tbody>\n                                            <tr>\n                                                <th>${attributeText}</th>\n                                                <th>${this.leftVersion}</th>\n                                                <th>${this.rightVersion}</th>\n                                            </tr>`;\n            const endHtml = `</td></tr> </tbody></table> </div>`;\n            let htmlString = beginHtml;\n            overlayHtmlList.forEach((text) => {\n                htmlString += text;\n            });\n            htmlString += endHtml;\n            overlays.add(id, {\n                position: {\n                    left: -50,\n                    top: 90,\n                },\n                scale: { min: 1 },\n                html: htmlString,\n            });\n        });\n    }\n    addMarker(overlays, elementId, className, symbol) {\n        try {\n            overlays.add(elementId, "diff", {\n                position: {\n                    top: -12,\n                    right: 12,\n                },\n                html: `<span class="vxcp-ent-differ-marker ${className}">${symbol}</span>`,\n            });\n        }\n        catch (e) {\n        }\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/differ/differ-html.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/differ/differ-layout.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "h": () => (/* binding */ DifferLayoutService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_differ_symbols_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/differ-symbols.enum.ts");\n/* harmony import */ var _input_output_diagram_version_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/input-output/diagram-version.service.ts");\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n\n\n\nclass DifferLayoutService {\n    initScreens($links, versionLeft, versionRight, zoomBtnContainerId = "vxcp-ent-editor-app") {\n        if ($links.$viewerLeft.length) {\n            $links.$viewerLeft.get(0).style.width = "50%";\n        }\n        if ($links.$viewerRight.length) {\n            $links.$viewerRight.get(0).style.width = "50%";\n        }\n        $("#vxcp-ent-differ-version-left").removeClass("vxcp-ent-hidden");\n        $("#vxcp-ent-differ-version-right").removeClass("vxcp-ent-hidden");\n        $("#vxcp-ent-differ-version-left-text").html(_input_output_diagram_version_service__WEBPACK_IMPORTED_MODULE_1__/* .DiagramVersionService.formatVersionString */ .l.formatVersionString(versionLeft));\n        $("#vxcp-ent-differ-version-right-text").html(_input_output_diagram_version_service__WEBPACK_IMPORTED_MODULE_1__/* .DiagramVersionService.formatVersionString */ .l.formatVersionString(versionRight));\n        $links.$colorMenu.find(".vxcp-ent-differ-changed").html(_model_enum_differ_symbols_enum__WEBPACK_IMPORTED_MODULE_0__/* .DifferSymnbolsEnum.CHANGED */ .E.CHANGED);\n        $links.$colorMenu.find(".vxcp-ent-differ-layout").html(_model_enum_differ_symbols_enum__WEBPACK_IMPORTED_MODULE_0__/* .DifferSymnbolsEnum.LAYOUT_CHANGED */ .E.LAYOUT_CHANGED);\n        $links.$colorMenu.find(".vxcp-ent-differ-added").html(_model_enum_differ_symbols_enum__WEBPACK_IMPORTED_MODULE_0__/* .DifferSymnbolsEnum.ADDED */ .E.ADDED);\n        $links.$colorMenu.find(".vxcp-ent-differ-removed").html(_model_enum_differ_symbols_enum__WEBPACK_IMPORTED_MODULE_0__/* .DifferSymnbolsEnum.REMOVED */ .E.REMOVED);\n        $links.$colorMenu.removeClass("vxcp-ent-hidden");\n        $links.$diagramVersion.addClass("vxcp-ent-hidden");\n        const zoomBtnContainer = document.getElementById(zoomBtnContainerId);\n        if (!zoomBtnContainer) {\n            return;\n        }\n        const differCanvas = zoomBtnContainer.querySelector("#vxcp-ent-differ-canvas");\n        const zoomWrapper = zoomBtnContainer.querySelector("#vxcp-ent-zoom-btn-wrapper");\n        let $bjsContainer;\n        if (differCanvas) {\n            const modelerContainerClass = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_2__/* .getPluginService */ .j)().getModelerContainerClass();\n            $bjsContainer = differCanvas.getElementsByClassName(modelerContainerClass)[0];\n        }\n        if ($bjsContainer && zoomWrapper) {\n            $bjsContainer.appendChild(zoomWrapper);\n        }\n    }\n    toggleAllDifferOverlays(btn) {\n        const showHide = btn.hasClass("vxcp-ent-show-differ-overlays");\n        btn.toggleClass("vxcp-ent-show-differ-overlays");\n        $(".vxcp-ent-differ-overlays").toggleClass("vxcp-ent-hidden", showHide);\n    }\n    exitDiffer(languageService, languageDifferService, $links) {\n        languageService.getEventBus().off("canvas.viewbox.changing");\n        languageDifferService.getEventBus().off("canvas.viewbox.changing");\n        $links.$viewerRight.remove();\n        if ($links.$viewerLeft.length) {\n            $links.$viewerLeft.get(0).style.width = "";\n        }\n        const zoomScroll = languageService.getZoomScroll();\n        zoomScroll.toggle(true);\n        const viewer = document.getElementsByClassName("vxcp-ent-editor-canvas")[0];\n        const zoomWrapper = document.getElementById("vxcp-ent-zoom-btn-wrapper");\n        if (viewer && zoomWrapper) {\n            viewer.appendChild(zoomWrapper);\n        }\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/differ/differ-layout.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-comments/embedded-comments-utils.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "createNewCommentExtension": () => (/* binding */ createNewCommentExtension),\n/* harmony export */   "deleteOrUpdateExistingCommentExtension": () => (/* binding */ deleteOrUpdateExistingCommentExtension),\n/* harmony export */   "getCommentExtensions": () => (/* binding */ getCommentExtensions),\n/* harmony export */   "getDataOfDeprecatedComment": () => (/* binding */ getDataOfDeprecatedComment),\n/* harmony export */   "migrateDeprecatedTimeStringToISOTimeString": () => (/* binding */ migrateDeprecatedTimeStringToISOTimeString)\n/* harmony export */ });\n/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n/* harmony import */ var _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\nconst platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__/* .getPlatformService */ .km)().getPlatformUtils() || {};\nconst vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__/* .getPluginService */ .j)().getPluginName(), "CommentsUtils");\nconst getCommentExtensions = (element) => __awaiter(void 0, void 0, void 0, function* () {\n    const bo = element.businessObject;\n    const extElem = bo.extensionElements;\n    if (!extElem || !extElem.values) {\n        return [];\n    }\n    const comments = extElem.values.filter((ext) => {\n        const isComment = ext.$type === "viadee:Comment";\n        if (isComment && typeof ext.resolved === "string") {\n            ext.resolved = ext.resolved === "true";\n        }\n        return isComment;\n    });\n    const deprecatedComments = extElem.values.filter((ext) => {\n        return ext.$type === "viadee:Comments";\n    });\n    if (deprecatedComments.length) {\n        const migratedComments = yield migrateDeprecatedComments(element, deprecatedComments[0]);\n        comments.push.apply(comments, migratedComments);\n        deleteOrUpdateExistingCommentExtension(element, deprecatedComments[0]);\n    }\n    comments.sort((commentA, commentB) => {\n        return commentA.dateTime < commentB.dateTime ? -1 : commentA.dateTime > commentB.dateTime ? 1 : 0;\n    });\n    comments.forEach((c) => (c.content = _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_0__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(c.content)));\n    return comments;\n});\nconst createNewCommentExtension = (element, newCommentData) => {\n    const bo = element.businessObject;\n    const xmlExtensionTag = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__/* .getPluginService */ .j)().getExtensionElementXmlTagName();\n    if (!element.businessObject.extensionElements) {\n        element.businessObject.extensionElements = bo.$model.create(xmlExtensionTag);\n    }\n    if (newCommentData.$type) {\n        delete newCommentData.$type;\n    }\n    const newCommentExt = bo.$model.create("viadee:Comment", newCommentData);\n    const allExtensions = element.businessObject.extensionElements.get("values");\n    allExtensions.push(newCommentExt);\n    element.businessObject.extensionElements.set("values", allExtensions);\n    return newCommentExt;\n};\nconst deleteOrUpdateExistingCommentExtension = (element, commentToDelete, newCommentData) => {\n    const allExtensions = element.businessObject.extensionElements.get("values");\n    const attributesToCheck = Object.keys(commentToDelete);\n    for (let idx = 0; idx < allExtensions.length; idx++) {\n        let elementsAreDifferent = false;\n        const currentExt = allExtensions[idx];\n        for (const attributeKey of attributesToCheck) {\n            if (!currentExt.hasOwnProperty(attributeKey) || currentExt[attributeKey] !== commentToDelete[attributeKey]) {\n                elementsAreDifferent = true;\n                break;\n            }\n        }\n        if (!elementsAreDifferent) {\n            if (newCommentData) {\n                if (newCommentData.$type) {\n                    delete newCommentData.$type;\n                }\n                const newCommentExt = element.businessObject.$model.create("viadee:Comment", newCommentData);\n                allExtensions.splice(idx, 1, newCommentExt);\n            }\n            else {\n                allExtensions.splice(idx, 1);\n            }\n            break;\n        }\n    }\n    element.businessObject.extensionElements.set("values", allExtensions);\n    return allExtensions;\n};\nconst migrateDeprecatedComments = (element, deprecatedComment) => __awaiter(void 0, void 0, void 0, function* () {\n    if (!deprecatedComment || !deprecatedComment.text) {\n        return [];\n    }\n    const commentsToMigrate = deprecatedComment.text.split(/;\\r?\\n;/).map((str) => {\n        return str.split(/§#/, 2);\n    });\n    const migratedComments = [];\n    for (const commentToMigrate of commentsToMigrate) {\n        const newCommentData = yield getDataOfDeprecatedComment(commentToMigrate);\n        createNewCommentExtension(element, newCommentData);\n        migratedComments.push(newCommentData);\n    }\n    return migratedComments;\n});\nconst getDataOfDeprecatedComment = (deprecatedComment) => __awaiter(void 0, void 0, void 0, function* () {\n    if (!deprecatedComment.length || deprecatedComment.length < 2) {\n        vxcpLogger.logWarning("getDataOfDeprecatedComment", "Deprecated comment is not an array or empty. Maybe the comment format is unknown or invalid.", { deprecatedComment });\n        return {};\n    }\n    const oldMetaDataString = deprecatedComment[0];\n    const commentContent = deprecatedComment[1];\n    const userKeyReg = "([\\\\w\\\\s\\u00c4\\u00e4\\u00d6\\u00f6\\u00dc\\u00fc\\u00df|<>,;.$%&()/=?:_#\'+*~!-§\\"]+)";\n    const confluenceUserNameReg = "([\\\\w\\\\s\\u00c4\\u00e4\\u00d6\\u00f6\\u00dc\\u00fc\\u00df|<>,;.$%&()/=?:_#\'+*~!-§]+)";\n    const dateReg = "([\\\\d]{2}.[\\\\d]{2,3}.[\\\\d]{4})";\n    const timeReg = "([\\\\d]{2}[\\\\d]{2})";\n    const deprecatedCommentRegexV1 = new RegExp(`${confluenceUserNameReg}[<]{7}${userKeyReg}[>]{7}${dateReg}[-]${timeReg}`);\n    const deprecatedCommentRegexV2 = new RegExp(`[<]{7}${userKeyReg}[>]{7}${dateReg}[-]${timeReg}`);\n    const deprecatedCommentV1 = deprecatedCommentRegexV1.exec(oldMetaDataString);\n    const deprecatedCommentV2 = deprecatedCommentRegexV2.exec(oldMetaDataString);\n    if (!deprecatedCommentV1 && !deprecatedCommentV2) {\n        vxcpLogger.logWarning("getDataOfDeprecatedComment", "Comment does not match any of our deprecated formats.", { deprecatedComment, oldMetaDataString });\n        return {};\n    }\n    let userKey = `Unknown`;\n    let dateTimeString = "1970-01-01T00:00:00.000Z";\n    if (deprecatedCommentV1) {\n        const userName = deprecatedCommentV1[1];\n        const date = deprecatedCommentV1[3];\n        const time = deprecatedCommentV1[4];\n        const getUserRestUrl = platformUtils.buildRestUrl(`/rest/api/user?username=${userName}`);\n        try {\n            const userData = yield platformUtils.makeRequest({\n                type: "GET",\n                url: getUserRestUrl,\n            });\n            userKey = userData.userKey;\n        }\n        catch (err) {\n        }\n        dateTimeString = migrateDeprecatedTimeStringToISOTimeString(date, time);\n    }\n    else if (deprecatedCommentV2) {\n        userKey = deprecatedCommentV2[1];\n        const date = deprecatedCommentV2[2];\n        const time = deprecatedCommentV2[3];\n        dateTimeString = migrateDeprecatedTimeStringToISOTimeString(date, time);\n    }\n    return {\n        userKey,\n        dateTime: dateTimeString,\n        resolved: false,\n        content: commentContent,\n    };\n});\nconst migrateDeprecatedTimeStringToISOTimeString = (date, time) => {\n    const dateInfos = date.split(".");\n    const day = dateInfos[0];\n    let month = dateInfos[1];\n    if (month.length === 3) {\n        month = month.substring(1);\n    }\n    const year = dateInfos[2];\n    const timeHours = time.substring(0, 2);\n    const timeMinutes = time.substring(2);\n    return new Date(`${year}-${month}-${day}T${timeHours}:${timeMinutes}`).toISOString();\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-comments/embedded-comments-utils.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-comments/user-mention.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "V": () => (/* binding */ UserMentionService)\n/* harmony export */ });\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nif ("bpmnEntLanguageService" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\nclass UserMentionService {\n    constructor() {\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_0__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_0__/* .getPluginService */ .j)().getPluginName(), "UserMentionService");\n    }\n    getUsersBySearchString(userName) {\n        return __awaiter(this, void 0, void 0, function* () {\n            userName = userName.replace(/@/g, "");\n            userName = userName.toLowerCase();\n            if (!userName) {\n                return [];\n            }\n            const searchURL = this.platformUtils.buildRestUrlForUserKeyAccountIdByName(userName);\n            const requestOpts = {\n                type: "GET",\n                url: searchURL,\n                dataType: "json",\n            };\n            let users = [];\n            try {\n                const searchRequest = yield this.platformUtils.makeRequest(requestOpts);\n                users = searchRequest.results.map((res) => {\n                    const user = res.user;\n                    user.userId = user.userKey || user.accountId || "unknown";\n                    return user;\n                });\n            }\n            catch (error) {\n                this.vxcpLogger.logError("getUsersBySearchString", "Search request failed", error);\n            }\n            return users;\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-comments/user-mention.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/ao-diagram-link.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "F": () => (/* binding */ AoDiagramLinkService)\n/* harmony export */ });\nif (/^bpmnEnt(((NavigatedPrev|V)iewe|Edito)r|MacroDialog)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _model_enum_rest_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/rest-type.enum.ts");\n/* harmony import */ var _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts");\n/* harmony import */ var _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nclass AoDiagramLinkService {\n    constructor(languageRestService, pluginService, messageService, enumConverterService) {\n        this.languageRestService = languageRestService;\n        this.pluginService = pluginService;\n        this.messageService = messageService;\n        this.enumConverterService = enumConverterService;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.publishQueue = [];\n        this.sourcePageId = "";\n        this.sourceVbcpEntId = "";\n    }\n    setSourceIds(sourcePageId, sourceVbcpEntId) {\n        this.sourcePageId = sourcePageId;\n        this.sourceVbcpEntId = sourceVbcpEntId;\n    }\n    pushLinkToAddQueue(newExtensionData, diagramType, elementName, elementType) {\n        const targetDiagramType = this.enumConverterService.convertEnumValue(newExtensionData.type, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .OverlayTypeLabelEnum */ .Iu, _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .PluginTypeEnum */ .AQ);\n        const data = {\n            targetPageId: newExtensionData.pageId,\n            targetVbcpEntId: newExtensionData.vbcpEntId,\n            targetDiagramType,\n            sourceDiagramType: diagramType,\n            sourcePageId: this.sourcePageId,\n            sourceVbcpEntId: this.sourceVbcpEntId,\n            elementName,\n            elementType,\n        };\n        this.publishQueue.push({ type: _model_enum_rest_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .RestTypeEnum.POST */ .T.POST, link: data });\n    }\n    pushLinkToDeleteQueue(newExtensionData, diagramType, elementName, elementType) {\n        const targetDiagramType = this.enumConverterService.convertEnumValue(newExtensionData.type, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .OverlayTypeLabelEnum */ .Iu, _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .PluginTypeEnum */ .AQ);\n        const data = {\n            targetPageId: newExtensionData.pageId,\n            targetVbcpEntId: newExtensionData.vbcpEntId,\n            targetDiagramType,\n            sourceDiagramType: diagramType,\n            sourcePageId: this.sourcePageId,\n            sourceVbcpEntId: this.sourceVbcpEntId,\n            elementName,\n            elementType,\n        };\n        this.publishQueue.push({ type: _model_enum_rest_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .RestTypeEnum.DELETE */ .T.DELETE, link: data });\n    }\n    publishLinksToDb() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.platformUtils.isCloudApp()) {\n                return;\n            }\n            let appPathComponent = this.languageRestService.getPluginRestComponent();\n            if (this.pluginService.getPluginShorthand() === _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .PluginTypeEnum.DMN */ .AQ.DMN) {\n                appPathComponent = this.languageRestService.getPluginRestComponentOtherApp();\n            }\n            const restUrl = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/diagramLinks`);\n            for (const data of this.publishQueue) {\n                try {\n                    yield this.platformUtils.makeRequest({\n                        url: restUrl,\n                        type: data.type,\n                        contentType: "application/json",\n                        data: JSON.stringify(data.link),\n                    });\n                }\n                catch (e) {\n                    if (e.status === 404 && this.pluginService.getPluginShorthand() === _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .PluginTypeEnum.DMN */ .AQ.DMN) {\n                        continue;\n                    }\n                    const title = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.update-links.error.title");\n                    const body = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.notification.update-links.error.body");\n                    this.messageService.setWarningMessage(title, body);\n                }\n            }\n            this.publishQueue = [];\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/ao-diagram-link.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/incoming-diagram-links.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "C": () => (/* binding */ IncomingDiagramLinksService)\n/* harmony export */ });\nif ("bpmnEntEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\n/* harmony import */ var _process_net_process_net_table_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/process-net/process-net-table.service.ts");\n/* harmony import */ var _utils_enum_converter_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/enum-converter.service.ts");\n/* harmony import */ var _viewer_language_font_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/viewer/language-font.service.ts");\n/* harmony import */ var _process_net_process_net_utils_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/process-net/process-net-utils.service.ts");\n/* harmony import */ var _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts");\nif ("bpmnEntEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _atlassian_page_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/page.service.ts");\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _model_enum_resize_direction_enum__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/resize-direction.enum.ts");\n/* harmony import */ var _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\n/* harmony import */ var _utils_pagination_service__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/pagination.service.ts");\n/* harmony import */ var _model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass IncomingDiagramLinksService {\n    constructor() {\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_12__/* .getPlatformService */ .km)().getPlatformUtils();\n        this.languageRestService = _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_0__/* .getLanguageRestService */ .GU();\n        this.inLinksTableClass = "vxcp-ent-incoming-diagram-links";\n        this.tdIconClass = "vxcp-ent-process-net-table-icon-td";\n        this.enumConverterService = new _utils_enum_converter_service__WEBPACK_IMPORTED_MODULE_2__/* .EnumConverterService */ .A();\n        this.paginationService = new _utils_pagination_service__WEBPACK_IMPORTED_MODULE_10__/* .PaginationService */ .N();\n        this.languageFontService = new _viewer_language_font_service__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z(this.enumConverterService);\n        this.processNetUtilsService = new _process_net_process_net_utils_service__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z(this.languageFontService);\n        this.processNetTableService = new _process_net_process_net_table_service__WEBPACK_IMPORTED_MODULE_1__/* .ProcessNetTableService */ .k(this.processNetUtilsService);\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_12__/* .getPluginService */ .j)().getPluginName(), "IncomingDiagramLinksService");\n    }\n    isFeatureActive() {\n        return (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_12__/* .getPluginService */ .j)().getPluginShorthand() === _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_5__/* .PluginTypeEnum.BPMN */ .AQ.BPMN && !this.platformUtils.isCloudApp();\n    }\n    initIncomingDiagramLinks($canvas, vbcpEntId, pageId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!this.isFeatureActive())\n                return;\n            const incomingDiagramLinksTable = yield this.platformUtils.getTemplate(_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_11__/* .TemplateNamesEnum.INCOMING_DIAGRAM_LINKS */ .X.INCOMING_DIAGRAM_LINKS);\n            $canvas.append(incomingDiagramLinksTable);\n            yield this.initTable(pageId, vbcpEntId);\n            yield this.initButtons(pageId, vbcpEntId);\n        });\n    }\n    initTable(pageId, vbcpEntId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const appPathComponent = this.languageRestService.getPluginRestComponent();\n            const restUrl = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/diagramLinks/in/${pageId}/${vbcpEntId}`);\n            let result;\n            try {\n                result = yield this.paginationService.collectPaginatedResults(restUrl);\n            }\n            catch (e) {\n                this.vxcpLogger.logWarning("initTable", "Error in Rest Call to get incoming links", e);\n                return;\n            }\n            const tableHtml = yield this.buildTableHtml(result);\n            $("#vxcp-ent-incoming-diagram-links-viewer").html(tableHtml);\n            yield this.initFilter();\n        });\n    }\n    buildTableHtml(incomingLinks) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const diagramName = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.incoming-diagram-links-tab.table.diagram-name");\n            const linkLocation = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.incoming-diagram-links-tab.table.diagram-location");\n            const elementName = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.incoming-diagram-links-tab.table.element-name");\n            const elementType = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.incoming-diagram-links-tab.table.diagram-type");\n            const spaceFilterHeader = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.incoming-diagram-links-tab.filter.header");\n            const allSpacesFilter = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.incoming-diagram-links-tab.filter.all-spaces");\n            let html = "";\n            let filterOptionsHtml = `<select id="vxcp-ent-incoming-links-filter-space"> <option selected value="all">${allSpacesFilter}</option>`;\n            const spaceIdToSpaceName = new Map();\n            const spaceIdToPageIds = new Map();\n            if (!incomingLinks || !incomingLinks.length) {\n                const noIncomingLinksMsg = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.editor.incoming-diagram-links-tab.table.no-links");\n                html = \'<td id="vxcp-ent-incoming-diagram-links-no-links" colspan="5">\\n\' + noIncomingLinksMsg + "\\n" + "</td>";\n            }\n            else {\n                for (const link of incomingLinks) {\n                    let sourceSpaceInfo;\n                    try {\n                        sourceSpaceInfo = yield _atlassian_page_service__WEBPACK_IMPORTED_MODULE_6__/* .getPageDataByPageId */ .S4(link.sourcePageId);\n                    }\n                    catch (e) {\n                        incomingLinks = incomingLinks.filter((l) => l !== link);\n                    }\n                    if (sourceSpaceInfo !== undefined) {\n                        const sourceSpaceId = _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_9__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(sourceSpaceInfo.space.id);\n                        const sourceSpaceName = _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_9__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(sourceSpaceInfo.space.name);\n                        if (!spaceIdToSpaceName.has(sourceSpaceId))\n                            spaceIdToSpaceName.set(sourceSpaceId, sourceSpaceName);\n                        if (!spaceIdToPageIds.has(sourceSpaceId))\n                            spaceIdToPageIds.set(sourceSpaceId, [link.sourcePageId]);\n                        else if (!spaceIdToPageIds.get(sourceSpaceId).includes(link.sourcePageId))\n                            spaceIdToPageIds.get(sourceSpaceId).push(link.sourcePageId);\n                    }\n                }\n                for (const [spaceId, spaceName] of spaceIdToSpaceName) {\n                    filterOptionsHtml = `${filterOptionsHtml} <option value="${spaceId}"> ${spaceName}</option>`;\n                }\n                filterOptionsHtml = `${filterOptionsHtml} </select>`;\n                html = yield this.buildCompleteTableBodyHtml(incomingLinks, spaceIdToPageIds, spaceIdToSpaceName);\n            }\n            html = `<table id ="vxcp-ent-incoming-diagram-links-table-id" class="vxcp-ent-extension-table">\n             <tr>\n             <th class="vxcp-ent-incoming-diagram-links-incoming-table">#</th> \n             <th class="vxcp-ent-incoming-diagram-links-incoming-table">${_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_9__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(diagramName)}</th> \n             <th class="vxcp-ent-incoming-diagram-links-incoming-table">${_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_9__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkLocation)}</th> \n             <th class="vxcp-ent-incoming-diagram-links-incoming-table">${_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_9__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(elementName)}</th> \n             <th class="vxcp-ent-incoming-diagram-links-incoming-table">${_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_9__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(elementType)}</th> \n             <th><label for="vxcp-ent-incoming-links-filter-space" style="display: inline-block;padding-right: 10px;">${spaceFilterHeader}</label> ${filterOptionsHtml}</th>\n             </tr>${html}</tr>\n             </table>`;\n            return html;\n        });\n    }\n    buildCompleteTableBodyHtml(incomingLinks, spaceIdToPageIds, spaceIdToSpaceName) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let body = "";\n            let counter = 0;\n            for (const inLink of incomingLinks) {\n                counter++;\n                const spaceId = yield IncomingDiagramLinksService.findSpaceIdForPageIdUtil(inLink.sourcePageId, spaceIdToPageIds);\n                const row = `<tr class="vxcp-ent-incoming-diagram-links-row-${spaceId} vxcp-ent-incoming-diagram-links-row">`;\n                const inLinkType = inLink.sourceDiagramType;\n                const routingParamsIn = this.processNetTableService.getRoutingParamsInLink(inLink);\n                const elementTypeIconWithHover = this.processNetUtilsService.getElementTypeIconWithHover(inLink.elementType);\n                const processUrlAndPageLinkTdsIn = yield this.processNetTableService.getDiagramUrlAndPageLinkTds(inLink.sourceDiagramName, routingParamsIn, inLinkType, this.inLinksTableClass);\n                const inLinkTd = `${processUrlAndPageLinkTdsIn}  <td class="${this.inLinksTableClass}"> ${_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_9__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(inLink.elementName)} </td> <td class="${this.inLinksTableClass} ${this.tdIconClass}"> ${elementTypeIconWithHover}</td>`;\n                let space = "";\n                if (spaceId !== undefined) {\n                    space = `<td class="${this.inLinksTableClass}"> ${spaceIdToSpaceName.get(spaceId)} </td>`;\n                }\n                else {\n                    space = `<td class="${this.inLinksTableClass}"> n.a. </td>`;\n                }\n                body = `${body} ${row} <td class="${this.inLinksTableClass}">${counter}</td>  ${inLinkTd} ${space}</tr>`;\n            }\n            return body;\n        });\n    }\n    hideIncomingDiagramLinks() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $incomingDiagramLinksCard = $("#vxcp-ent-incoming-diagram-links-card-id");\n            const $incomingDiagramLinksBtn = $(".vxcp-ent-btn-incomingLinks-mode");\n            $incomingDiagramLinksCard.addClass("vxcp-ent-hidden");\n            $incomingDiagramLinksBtn.removeClass("icon-selected");\n            yield this.collapseTable();\n        });\n    }\n    collapseTable() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $content = $("#vxcp-ent-incoming-diagram-links-content-id");\n            const $slider = $("#vxcp-ent-incoming-diagram-links-slider-id");\n            $content.addClass("collapsed");\n            $slider.addClass("collapsed");\n        });\n    }\n    initButtons(pageId, vbcpEntId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $incomingDiagramLinksCard = $("#vxcp-ent-incoming-diagram-links-card-id");\n            const $incomingDiagramLinksContent = $("#vxcp-ent-incoming-diagram-links-content-id");\n            const $slider = $("#vxcp-ent-incoming-diagram-links-slider-id");\n            const $incomingDiagramLinksWrapper = $("#vxcp-ent-incoming-diagram-links-wrapper-id");\n            $incomingDiagramLinksCard.on("click", (e) => {\n                if ($incomingDiagramLinksContent.hasClass("collapsed")) {\n                    $incomingDiagramLinksContent.removeClass("collapsed");\n                    $slider.removeClass("collapsed");\n                    this.initTable(pageId, vbcpEntId);\n                }\n                else {\n                    this.collapseTable();\n                }\n            });\n            yield (0,_utils_utils__WEBPACK_IMPORTED_MODULE_7__.initSlider)($slider, $incomingDiagramLinksContent, $incomingDiagramLinksWrapper, _model_enum_resize_direction_enum__WEBPACK_IMPORTED_MODULE_8__/* .ResizeDirectionEnum.BOTTOM_TO_TOP */ .c.BOTTOM_TO_TOP);\n            yield this.collapseTable();\n        });\n    }\n    handleIncomingLinksBtn(identifier) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $incomingDiagramLinksCard = $("#vxcp-ent-incoming-diagram-links-card-id");\n            const $incomingDiagramLinksContent = $("#vxcp-ent-incoming-diagram-links-content-id");\n            if (!$incomingDiagramLinksCard.hasClass("vxcp-ent-hidden")) {\n                yield this.hideIncomingDiagramLinks();\n            }\n            else {\n                $incomingDiagramLinksCard.removeClass("vxcp-ent-hidden");\n                $incomingDiagramLinksContent.css("height", "300px");\n                $(identifier).addClass("icon-selected");\n            }\n        });\n    }\n    initFilter() {\n        return __awaiter(this, void 0, void 0, function* () {\n            $(`#vxcp-ent-incoming-links-filter-space`).on("change", (e) => {\n                const val = $("#vxcp-ent-incoming-links-filter-space").val() || "all";\n                if (val === "all") {\n                    $(".vxcp-ent-incoming-diagram-links-row").show();\n                }\n                else {\n                    const classToShow = `.vxcp-ent-incoming-diagram-links-row-${val}`;\n                    $(`.vxcp-ent-incoming-diagram-links-row${classToShow}`).show();\n                    $(`.vxcp-ent-incoming-diagram-links-row:not(${classToShow})`).hide();\n                }\n            });\n        });\n    }\n    static findSpaceIdForPageIdUtil(pageId, spaceToPageIds) {\n        return __awaiter(this, void 0, void 0, function* () {\n            for (const [spaceId, pages] of spaceToPageIds) {\n                if (pages.includes(pageId))\n                    return spaceId;\n            }\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/incoming-diagram-links.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/legacy-link-handler.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "y": () => (/* binding */ LegacyLinkHandler)\n/* harmony export */ });\n/* harmony import */ var _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts");\n/* harmony import */ var _utils_spinner_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/spinner.service.ts");\n/* harmony import */ var _atlassian_page_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/page.service.ts");\n/* harmony import */ var _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/file-type.enum.ts");\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\nclass LegacyLinkHandler {\n    constructor(xmlExtensionService, macroService, linkUtilsService) {\n        this.xmlExtensionService = xmlExtensionService;\n        this.macroService = macroService;\n        this.linkUtilsService = linkUtilsService;\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_6__/* .getPluginService */ .j)().getPluginName(), "LegacyLinkHandler");\n    }\n    migrateUpgradedDmnLinks(currentLink, curElement, linksUpdated, showSpinner, spinnerService, languageService) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const isFreeMacro = yield this.macroService.isFreeDiagram(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .FileTypeEnum.DMN */ .W.DMN, currentLink.pageId, currentLink.title);\n            if (!isFreeMacro) {\n                linksUpdated = true;\n                if (showSpinner) {\n                    spinnerService.show();\n                }\n                const updatedLegacyLink = yield this.updateDmnFreeToDmnEnterpriseLink(currentLink);\n                this.xmlExtensionService.replaceExistingExtension(languageService, curElement, updatedLegacyLink, currentLink.id);\n            }\n            return linksUpdated;\n        });\n    }\n    checkAllLinksAndUpdateLegacyLinks(languageService, showSpinner = true) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let linksUpdated = false;\n            const spinnerService = new _utils_spinner_service__WEBPACK_IMPORTED_MODULE_1__/* .SpinnerService */ .V();\n            const elementRegistry = languageService.getElementRegistry();\n            const domElements = elementRegistry.getAll();\n            for (const curElement of domElements) {\n                const modelElement = curElement.businessObject;\n                const elementLinks = this.xmlExtensionService.getAllLinkExtensions(modelElement);\n                if (elementLinks.length === 0) {\n                    continue;\n                }\n                for (const currentLink of elementLinks) {\n                    if (currentLink.$type === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.BPMN */ .ws.BPMN || currentLink.$type === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.DMN */ .ws.DMN || currentLink.$type === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.DMN_ENTERPRISE */ .ws.DMN_ENTERPRISE) {\n                        if (!currentLink.vbcpEntId) {\n                            yield this.linkUtilsService.getVbcpEntIdAndUpdateLink(currentLink, curElement, languageService);\n                        }\n                    }\n                    if (currentLink.$type === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.DMN */ .ws.DMN && currentLink.type === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN) {\n                        linksUpdated = yield this.migrateUpgradedDmnLinks(currentLink, curElement, linksUpdated, showSpinner, spinnerService, languageService);\n                    }\n                    if (currentLink.$type === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.LEGACY_WIKILINK */ .ws.LEGACY_WIKILINK) {\n                        linksUpdated = true;\n                        if (showSpinner) {\n                            spinnerService.show();\n                        }\n                        const updatedLegacyLink = yield this.updateLinkToNewFormat(currentLink);\n                        this.xmlExtensionService.replaceExistingExtension(languageService, curElement, updatedLegacyLink, currentLink.id);\n                    }\n                    else {\n                        switch (currentLink.type) {\n                            case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.LEGACY_BPMN */ .Iu.LEGACY_BPMN:\n                                currentLink.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN;\n                                languageService.updateProperties(curElement, {});\n                                break;\n                            case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.LEGACY_CONFLUENCE_PAGE */ .Iu.LEGACY_CONFLUENCE_PAGE:\n                                currentLink.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.CONFLUENCE_PAGE */ .Iu.CONFLUENCE_PAGE;\n                                languageService.updateProperties(curElement, {});\n                                break;\n                            case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.LEGACY_EXTERNAL_CONTENT */ .Iu.LEGACY_EXTERNAL_CONTENT:\n                                currentLink.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.EXTERNAL_CONTENT */ .Iu.EXTERNAL_CONTENT;\n                                languageService.updateProperties(curElement, {});\n                                break;\n                        }\n                    }\n                }\n            }\n            return linksUpdated;\n        });\n    }\n    updateDmnFreeToDmnEnterpriseLink(oldLink) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const macroKey = "vdcp-macro-enterprise";\n            const vbcpEntId = yield this.macroService.getVbcpEntIdByDiagramName(macroKey, oldLink.pageId, oldLink.title || "");\n            return {\n                id: oldLink.id,\n                desc: oldLink.desc,\n                $type: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.DMN_ENTERPRISE */ .ws.DMN_ENTERPRISE,\n                type: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN_ENTERPRISE */ .Iu.DMN_ENTERPRISE,\n                pageId: oldLink.pageId,\n                vbcpEntId,\n            };\n        });\n    }\n    updateLinkToNewFormat(oldLink) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (oldLink.jiraAppId) {\n                oldLink.appId = oldLink.jiraAppId;\n                delete oldLink.jiraAppId;\n            }\n            if (oldLink.$type !== _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.LEGACY_WIKILINK */ .ws.LEGACY_WIKILINK && oldLink.$type !== _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.BPMN */ .ws.BPMN) {\n                return oldLink;\n            }\n            else if (oldLink.$type === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.BPMN */ .ws.BPMN) {\n                if (oldLink.vbcpEntId) {\n                    oldLink.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN;\n                    return oldLink;\n                }\n                else {\n                    return yield this.getBpmnLinkWithVbcpEntId(oldLink);\n                }\n            }\n            let newLinkType;\n            oldLink.type = oldLink.type.replace("-link", "");\n            oldLink.desc = _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_4__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(oldLink.desc);\n            oldLink.title = _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_4__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(oldLink.title);\n            const genericParams = {\n                id: oldLink.id,\n                desc: oldLink.desc,\n                type: oldLink.type,\n            };\n            const dmnEnterpriseMacroKey = "vdcp-macro-enterprise";\n            const dmnFreeMacroKey = "vdcp-macro";\n            switch (oldLink.type) {\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.LEGACY_BPMN */ .Iu.LEGACY_BPMN:\n                    if (oldLink.title.includes(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .FileTypeEnum.BPMN */ .W.BPMN)) {\n                        const macroKey = "vbcp-macro-enterprise";\n                        const freeMacroKey = "vbcp-macro";\n                        const bpmnParams = yield this.linkUtilsService.getDiagramParamsFromUrl(oldLink.ur, macroKey, freeMacroKey);\n                        if (bpmnParams.vbcpEntId.length > 0) {\n                            genericParams.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN;\n                            genericParams.vbcpEntId = bpmnParams.vbcpEntId;\n                            genericParams.macroId = bpmnParams.macroId;\n                            genericParams.pageId = bpmnParams.pageId;\n                            newLinkType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.BPMN */ .ws.BPMN;\n                        }\n                        else {\n                            newLinkType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.EXTERNAL_CONTENT */ .ws.EXTERNAL_CONTENT;\n                            genericParams.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.EXTERNAL_CONTENT */ .Iu.EXTERNAL_CONTENT;\n                            genericParams.url = oldLink.url;\n                            genericParams.title = oldLink.title;\n                        }\n                    }\n                    else if (oldLink.title.includes(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .FileTypeEnum.PNG */ .W.PNG)) {\n                        newLinkType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.EXTERNAL_CONTENT */ .ws.EXTERNAL_CONTENT;\n                        genericParams.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.EXTERNAL_CONTENT */ .Iu.EXTERNAL_CONTENT;\n                        genericParams.url = oldLink.url;\n                        genericParams.title = oldLink.title;\n                    }\n                    else {\n                        this.vxcpLogger.logInfo("updateLinkToNewFormat", "Unknown link type. Creating external link.");\n                        newLinkType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.EXTERNAL_CONTENT */ .ws.EXTERNAL_CONTENT;\n                        genericParams.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.EXTERNAL_CONTENT */ .Iu.EXTERNAL_CONTENT;\n                        genericParams.url = oldLink.url;\n                        genericParams.title = oldLink.title;\n                    }\n                    break;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN_ENTERPRISE */ .Iu.DMN_ENTERPRISE:\n                    const dmnTableParams = yield this.linkUtilsService.getDiagramParamsFromUrl(oldLink.ur, dmnEnterpriseMacroKey, dmnFreeMacroKey);\n                    if (dmnTableParams.vbcpEntId.length > 0) {\n                        genericParams.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN_ENTERPRISE */ .Iu.DMN_ENTERPRISE;\n                        genericParams.vbcpEntId = dmnTableParams.vbcpEntId;\n                        genericParams.macroId = dmnTableParams.macroId;\n                        genericParams.pageId = dmnTableParams.pageId;\n                        newLinkType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.DMN_ENTERPRISE */ .ws.DMN_ENTERPRISE;\n                    }\n                    else {\n                        newLinkType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.EXTERNAL_CONTENT */ .ws.EXTERNAL_CONTENT;\n                        genericParams.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.EXTERNAL_CONTENT */ .Iu.EXTERNAL_CONTENT;\n                        genericParams.url = oldLink.url;\n                        genericParams.title = oldLink.title;\n                    }\n                    break;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN:\n                    const dmnFreeTableParams = this.linkUtilsService.getDmnFreeParamsFromUrl(oldLink.url);\n                    if (yield this.macroService.checkIfActiveMacroExists(dmnFreeTableParams.tableName, dmnFreeTableParams.pageId, dmnEnterpriseMacroKey, dmnFreeMacroKey)) {\n                        newLinkType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.DMN */ .ws.DMN;\n                        genericParams.pageId = dmnFreeTableParams.pageId;\n                        genericParams.title = dmnFreeTableParams.tableName;\n                    }\n                    else {\n                        newLinkType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.EXTERNAL_CONTENT */ .ws.EXTERNAL_CONTENT;\n                        genericParams.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.EXTERNAL_CONTENT */ .Iu.EXTERNAL_CONTENT;\n                        genericParams.url = oldLink.url;\n                        genericParams.title = oldLink.title;\n                    }\n                    break;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.LEGACY_CONFLUENCE_PAGE */ .Iu.LEGACY_CONFLUENCE_PAGE:\n                    try {\n                        genericParams.pageId = yield _atlassian_page_service__WEBPACK_IMPORTED_MODULE_2__/* .getPageIdByConfluencePageUrlAndPageName */ .Ld(oldLink.url, oldLink.title);\n                        newLinkType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.CONFLUENCE_PAGE */ .ws.CONFLUENCE_PAGE;\n                        genericParams.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.CONFLUENCE_PAGE */ .Iu.CONFLUENCE_PAGE;\n                    }\n                    catch (e) {\n                        newLinkType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.EXTERNAL_CONTENT */ .ws.EXTERNAL_CONTENT;\n                        genericParams.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.EXTERNAL_CONTENT */ .Iu.EXTERNAL_CONTENT;\n                        genericParams.url = oldLink.url;\n                        genericParams.title = oldLink.title;\n                    }\n                    break;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.LEGACY_EXTERNAL_CONTENT */ .Iu.LEGACY_EXTERNAL_CONTENT:\n                    genericParams.title = oldLink.title;\n                    genericParams.url = oldLink.url;\n                    newLinkType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.EXTERNAL_CONTENT */ .ws.EXTERNAL_CONTENT;\n                    genericParams.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.EXTERNAL_CONTENT */ .Iu.EXTERNAL_CONTENT;\n                    break;\n                default:\n                    this.vxcpLogger.logInfo("updateLinkToNewFormat", " Unknown legacy link type. Creating external link.");\n                    newLinkType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.EXTERNAL_CONTENT */ .ws.EXTERNAL_CONTENT;\n                    genericParams.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.EXTERNAL_CONTENT */ .Iu.EXTERNAL_CONTENT;\n                    genericParams.title = oldLink.title;\n                    genericParams.url = oldLink.url;\n                    break;\n            }\n            if (newLinkType === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.EXTERNAL_CONTENT */ .ws.EXTERNAL_CONTENT && genericParams.url) {\n                if (!genericParams.url.startsWith("http://") && !genericParams.url.startsWith("https://")) {\n                    genericParams.url = `https://${genericParams.url}`;\n                }\n            }\n            return {\n                id: genericParams.id,\n                desc: genericParams.desc,\n                $type: newLinkType,\n                type: genericParams.type,\n                macroId: genericParams.macroId,\n                pageId: genericParams.pageId,\n                title: genericParams.title,\n                url: genericParams.url,\n            };\n        });\n    }\n    getBpmnLinkWithVbcpEntId(oldLink) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const configs = yield this.linkUtilsService.getConfigsOfLinkedXml(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .FileTypeEnum.BPMN */ .W.BPMN, oldLink);\n            return {\n                $type: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.BPMN */ .ws.BPMN,\n                id: oldLink.id,\n                type: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN,\n                desc: oldLink.desc,\n                vbcpEntId: configs.vbcpEntId,\n                macroId: oldLink.macroId,\n                pageId: oldLink.pageId,\n            };\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/legacy-link-handler.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/link-dialog-init.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "k": () => (/* binding */ LinkDialogInitService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts");\n/* harmony import */ var _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/file-type.enum.ts");\n/* harmony import */ var _attribute_panel_panel_utils_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/panel-utils.service.ts");\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _atlassian_page_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/page.service.ts");\n/* harmony import */ var _model_enum_link_preview_type_enum__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/link-preview-type.enum.ts");\nif ("bpmnEntEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\n/* harmony import */ var _model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/warning-dialog-type.enum.ts");\n/* harmony import */ var _model_enum_app_rest_path_enum__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-rest-path.enum.ts");\n/* harmony import */ var _components_search_diagram_search_input_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/components/search/diagram-search-input.component.ts");\n/* harmony import */ var _components_search_page_search_input_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/components/search/page-search-input.component.ts");\n/* harmony import */ var _components_search_attachment_search_input_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/components/search/attachment-search-input.component.ts");\n/* harmony import */ var _components_search_jira_issue_search_input_component__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/components/search/jira-issue-search-input.component.ts");\nif ("bpmnEntEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass LinkDialogInitService {\n    constructor(tabbedDialogService, searchAttachmentService, searchDiagramService, searchPageService, searchJiraIssueService, linkDialogSubpagesService, linkPreviewService, linkUtilsService, jiraRestService, xmlExtensionService, enumConverterService, validatorService, searchSuggestionsService, timeService) {\n        this.tabbedDialogService = tabbedDialogService;\n        this.searchAttachmentService = searchAttachmentService;\n        this.searchDiagramService = searchDiagramService;\n        this.searchPageService = searchPageService;\n        this.searchJiraIssueService = searchJiraIssueService;\n        this.linkDialogSubpagesService = linkDialogSubpagesService;\n        this.linkPreviewService = linkPreviewService;\n        this.linkUtilsService = linkUtilsService;\n        this.jiraRestService = jiraRestService;\n        this.xmlExtensionService = xmlExtensionService;\n        this.enumConverterService = enumConverterService;\n        this.validatorService = validatorService;\n        this.searchSuggestionsService = searchSuggestionsService;\n        this.timeService = timeService;\n        this.dialogId = "#vxcp-ent-dialog-link";\n        this.initialMenuSelectionType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN;\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_15__/* .getPluginService */ .j)().getPluginName(), "LinkDialogInitService");\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_15__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.diagramLinkInputChanged = false;\n        this.bpmnDiagramSearchInput = new _components_search_diagram_search_input_component__WEBPACK_IMPORTED_MODULE_9__/* .DiagramSearchInputComponent */ .E(this.platformUtils, this.timeService);\n        this.bpmnNewDiagramTargetPageSearchInput = new _components_search_page_search_input_component__WEBPACK_IMPORTED_MODULE_10__/* .PageSearchInputComponent */ .c(this.platformUtils, this.timeService);\n        this.dmnDiagramSearchInput = new _components_search_diagram_search_input_component__WEBPACK_IMPORTED_MODULE_9__/* .DiagramSearchInputComponent */ .E(this.platformUtils, this.timeService);\n        this.dmnNewDiagramTargetPageSearchInput = new _components_search_page_search_input_component__WEBPACK_IMPORTED_MODULE_10__/* .PageSearchInputComponent */ .c(this.platformUtils, this.timeService);\n        this.pageSearchInput = new _components_search_page_search_input_component__WEBPACK_IMPORTED_MODULE_10__/* .PageSearchInputComponent */ .c(this.platformUtils, this.timeService);\n        this.attachmentSearchInput = new _components_search_attachment_search_input_component__WEBPACK_IMPORTED_MODULE_11__/* .AttachmentSearchInputComponent */ .x(this.platformUtils, this.timeService);\n        this.jiraIssueSearchInput = new _components_search_jira_issue_search_input_component__WEBPACK_IMPORTED_MODULE_12__/* .JiraIssueSearchInputComponent */ .H(this.platformUtils, this.timeService);\n    }\n    isBpmnEntPluginInstalled() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const appPathComponent = _model_enum_app_rest_path_enum__WEBPACK_IMPORTED_MODULE_8__/* .EnterpriseRestPathEnum.BPMN */ .wF.BPMN;\n            try {\n                const url = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/license/licenseType`);\n                const res = yield this.platformUtils.makeRequest({ url, type: "GET" });\n                return res !== undefined;\n            }\n            catch (e) {\n                return false;\n            }\n        });\n    }\n    isDmnFreePluginInstalled() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const appPathComponent = _model_enum_app_rest_path_enum__WEBPACK_IMPORTED_MODULE_8__/* .FreeRestPathEnum.DMN */ .tT.DMN;\n            try {\n                const url = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/health`);\n                const res = yield this.platformUtils.makeRequest({ url, type: "GET" });\n                return res !== undefined;\n            }\n            catch (e) {\n                return false;\n            }\n        });\n    }\n    isDmnEntPluginInstalled() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const appPathComponent = _model_enum_app_rest_path_enum__WEBPACK_IMPORTED_MODULE_8__/* .EnterpriseRestPathEnum.DMN */ .wF.DMN;\n            try {\n                const url = this.platformUtils.buildRestUrl(`/rest/${appPathComponent}/1.0/license/licenseType`);\n                const res = yield this.platformUtils.makeRequest({ url, type: "GET" });\n                return res !== undefined;\n            }\n            catch (e) {\n                return false;\n            }\n        });\n    }\n    openAddOrEditLinkDialog(languageService, $canvas, pageId, vbcpEntId, fromMode, linkToEditXmlProps, linkToEditHtmlProps) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const isDmnEnterpriseInstalled = yield this.isDmnEntPluginInstalled();\n            const showDmnFreeHintInDialog = yield this.isDmnFreePluginInstalled();\n            const dialogId = this.dialogId;\n            this.platformUtils.removeDjsHelperSvg();\n            const linkTypes = [];\n            for (const linkType in _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum */ .Iu) {\n                if (!linkType || !_model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.hasOwnProperty */ .Iu.hasOwnProperty(linkType) || !_model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum.hasOwnProperty */ .eN.hasOwnProperty(linkType)) {\n                    continue;\n                }\n                if (linkType === "EMBEDDED_COMMENTS" || linkType === "DMN_ENTERPRISE" || linkType === "DOCUMENTATION" || linkType === "MDF_INSTANCE") {\n                    continue;\n                }\n                const label = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum */ .Iu[linkType];\n                linkTypes.push({\n                    label,\n                    iconClass: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum */ .eN[linkType],\n                    textMenu: yield this.platformUtils.getText(`de.viadee.confluence.viadee-plugin-enterprise.add-elementlink-dialog.menu.${label}`),\n                    textDesc: yield this.platformUtils.getText(`de.viadee.confluence.viadee-plugin-enterprise.add-elementlink-dialog.${label}.desc`),\n                    textInfo: yield this.platformUtils.getText(`de.viadee.confluence.viadee-plugin-enterprise.add-elementlink-dialog.${label}.info`),\n                    textInputTitle: yield this.platformUtils.getText(`de.viadee.confluence.viadee-plugin-enterprise.add-elementlink-dialog.${label}.input-label.title`),\n                    textInputUrl: yield this.platformUtils.getText(`de.viadee.confluence.viadee-plugin-enterprise.add-elementlink-dialog.${label}.input-label.url`),\n                    textInputDesc: yield this.platformUtils.getText(`de.viadee.confluence.viadee-plugin-enterprise.add-elementlink-dialog.${label}.input-label.desc`),\n                });\n            }\n            const params = { linkTypes, showDmnFreeHintInDialog };\n            const addElementLinkDialog = yield this.platformUtils.getTemplate(_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_13__/* .TemplateNamesEnum.ADD_ELEMENT_LINK_DIAOLG */ .X.ADD_ELEMENT_LINK_DIAOLG, params);\n            $canvas.append(addElementLinkDialog);\n            if (isDmnEnterpriseInstalled) {\n                $("#vxcp-ent-link-dialog-dmn-free-disclaimer").addClass("vxcp-ent-hidden");\n            }\n            this.platformUtils.showDialog(dialogId);\n            if (linkToEditHtmlProps) {\n                const linkType = linkToEditHtmlProps.type === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN_ENTERPRISE */ .Iu.DMN_ENTERPRISE ? _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN : linkToEditHtmlProps.type;\n                this.tabbedDialogService.openDialogPage(`vxcp-ent-link-${linkType}-menu`, `vxcp-ent-link-${linkType}`);\n                $(".vxcp-ent-dialog-menu-container").addClass("vxcp-ent-att-panel-hidden");\n                $(dialogId).removeClass("aui-dialog2-large").addClass("aui-dialog2-medium");\n                $(`#vxcp-ent-link-${linkType} .vxcp-ent-link-title-input`).val(_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkToEditHtmlProps.title));\n                $(`#vxcp-ent-link-${linkType} .vxcp-ent-link-url-input`).val(_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkToEditHtmlProps.url));\n                $(`#vxcp-ent-link-${linkType} .vxcp-ent-link-desc-input`).val(_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(decodeURIComponent(linkToEditHtmlProps.desc)));\n            }\n            this.tabbedDialogService.initDialogEventListeners();\n            this.linkDialogSubpagesService.initDialogEventListeners(dialogId);\n            this.initDialogEventListenersAttachmentLink(dialogId, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN, pageId, vbcpEntId, $canvas, linkToEditXmlProps);\n            this.initDialogEventListenersAttachmentLink(dialogId, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN, pageId, vbcpEntId, $canvas, linkToEditXmlProps);\n            this.initDialogEventListenersAttachmentLink(dialogId, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.CONFLUENCE_ATTACHMENT */ .Iu.CONFLUENCE_ATTACHMENT, pageId, vbcpEntId, $canvas, linkToEditXmlProps);\n            this.initDialogEventListenersLinkInputs(dialogId, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.CONFLUENCE_PAGE */ .Iu.CONFLUENCE_PAGE);\n            this.initDialogEventListenersLinkInputs(dialogId, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.EXTERNAL_CONTENT */ .Iu.EXTERNAL_CONTENT);\n            this.initDialogEventListenersLinkInputs(dialogId, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.JIRA_ISSUE */ .Iu.JIRA_ISSUE);\n            yield this.initAutoCompleteBinderDefault(linkToEditXmlProps);\n            this.initDialogButtons(dialogId, languageService, pageId, fromMode, linkToEditXmlProps);\n            yield this.initDialogLinkNewDiagram(dialogId, pageId, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN, this.isBpmnEntPluginInstalled.bind(this));\n            yield this.initDialogLinkNewDiagram(dialogId, pageId, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN, this.isDmnEntPluginInstalled.bind(this));\n            let initialType = (linkToEditHtmlProps === null || linkToEditHtmlProps === void 0 ? void 0 : linkToEditHtmlProps.type) || this.initialMenuSelectionType;\n            if (initialType === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN_ENTERPRISE */ .Iu.DMN_ENTERPRISE) {\n                initialType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN;\n            }\n            const $initialTypeLabelMenuButton = $(`#vxcp-ent-link-${initialType}-menu`);\n            $initialTypeLabelMenuButton.trigger("click");\n            yield this.fillSearchSuggestions();\n        });\n    }\n    fillSearchSuggestions() {\n        return __awaiter(this, void 0, void 0, function* () {\n            return Promise.all([\n                this.bpmnDiagramSearchInput.suggest(),\n                this.bpmnNewDiagramTargetPageSearchInput.suggest(),\n                this.dmnDiagramSearchInput.suggest(),\n                this.dmnNewDiagramTargetPageSearchInput.suggest(),\n                this.pageSearchInput.suggest(),\n                this.attachmentSearchInput.suggest(),\n            ]);\n        });\n    }\n    initDialogEventListenersAttachmentLink(dialogId, linkTypeLabel, pageId, vbcpEntId, $canvas, elementLinkToEdit) {\n        const titleInputId = `#vxcp-ent-link-${linkTypeLabel}-title-input`;\n        $(titleInputId).on({\n            "selected.autocomplete-content": (event, params) => __awaiter(this, void 0, void 0, function* () {\n                event.stopPropagation();\n                event.preventDefault();\n                this.diagramLinkInputChanged = true;\n                const selectedPageAttributes = params.content;\n                const selectedPageLinkTag = selectedPageAttributes.link[2];\n                const selectedPageUrl = selectedPageLinkTag.href;\n                const urlInputId = `#vxcp-ent-link-${linkTypeLabel}-url-input`;\n                const $searchUrlInput = $(urlInputId);\n                $searchUrlInput.val(selectedPageUrl);\n                yield this.tabbedDialogService.validateInput($searchUrlInput);\n                $(`${dialogId}-continue`).trigger("focus");\n            }),\n            keydown: (e) => {\n                if (e.key !== "Tab" && e.which !== 40 && e.which !== 39 && e.which !== 38 && e.which !== 37) {\n                    const urlInputId = `#vxcp-ent-link-${linkTypeLabel}-url-input`;\n                    $(urlInputId).val("");\n                }\n            },\n        });\n        const urlCopyId = `#vxcp-ent-link-${linkTypeLabel}-url-copy`;\n        $(urlCopyId).on("click", (e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            const urlInputId = `#vxcp-ent-link-${linkTypeLabel}-url-input`;\n            $(urlInputId).select();\n            document.execCommand("copy");\n        });\n        const urlOpenId = `#vxcp-ent-link-${linkTypeLabel}-url-open`;\n        $(urlOpenId).on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            e.stopPropagation();\n            e.preventDefault();\n            const urlInputId = `#vxcp-ent-link-${linkTypeLabel}-url-input`;\n            const url = $(urlInputId).val();\n            const linkTitle = $(titleInputId).val();\n            const linkPreviewType = this.linkPreviewService.getLinkPreviewType(linkTitle);\n            if (!url) {\n                return;\n            }\n            if (linkTypeLabel === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN) {\n                const macroKey = "vbcp-macro-enterprise";\n                const freeMacroKey = "vbcp-macro";\n                yield this.openEnterpriseDiagramPreview(macroKey, freeMacroKey, _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.BPMN */ .W.BPMN, url, linkTitle, pageId, vbcpEntId, $canvas, elementLinkToEdit);\n                return;\n            }\n            else if (linkTypeLabel === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN) {\n                const $titleInput = $("#vxcp-ent-link-dmn-title-input");\n                const isFreeMacro = $titleInput.prop("data-is-free");\n                if (isFreeMacro) {\n                    const linkTableName = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_3__.getFileNameWithoutTypeEnding)(linkTitle);\n                    const linkPageId = _utils_utils__WEBPACK_IMPORTED_MODULE_3__.getQueryParam("pageId", url);\n                    let dmnParams;\n                    if (elementLinkToEdit) {\n                        if (this.diagramLinkInputChanged) {\n                            dmnParams = this.linkUtilsService.getDmnFreeParamsFromUrl(url);\n                        }\n                        else {\n                            dmnParams = {\n                                tableName: linkTableName,\n                                pageId: linkPageId,\n                            };\n                        }\n                    }\n                    else {\n                        dmnParams = this.linkUtilsService.getDmnFreeParamsFromUrl(url);\n                    }\n                    yield this.linkPreviewService.openDmnFreePreviewDialog($canvas, dmnParams.tableName, dmnParams.pageId, false);\n                    return;\n                }\n                else {\n                    const macroKey = "vdcp-macro-enterprise";\n                    const freeMacroKey = "vdcp-macro";\n                    yield this.openEnterpriseDiagramPreview(macroKey, freeMacroKey, _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.DMN */ .W.DMN, url, linkTitle, pageId, vbcpEntId, $canvas, elementLinkToEdit);\n                    return;\n                }\n            }\n            else if (linkPreviewType === _model_enum_link_preview_type_enum__WEBPACK_IMPORTED_MODULE_5__/* .LinkPreviewTypeEnum.IMAGE */ .d.IMAGE || linkPreviewType === _model_enum_link_preview_type_enum__WEBPACK_IMPORTED_MODULE_5__/* .LinkPreviewTypeEnum.PDF */ .d.PDF) {\n                if ($canvas) {\n                    yield this.linkPreviewService.openConfluenceAttachmentPreviewDialog($canvas, linkTitle, url);\n                    return;\n                }\n                else {\n                    window.open(url, "_blank");\n                }\n            }\n            window.open(url, "_blank");\n        }));\n    }\n    openEnterpriseDiagramPreview(macroKey, freeMacroKey, fileType, url, linkTitle, pageId, vbcpEntId, $canvas, elementLinkToEdit) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let diagramParams;\n            if (elementLinkToEdit) {\n                if (this.diagramLinkInputChanged) {\n                    diagramParams = yield this.linkUtilsService.getDiagramParamsFromUrl(url, macroKey, freeMacroKey);\n                }\n                else {\n                    const linkDiagramName = linkTitle.replace(fileType, "");\n                    const linkPageId = _utils_utils__WEBPACK_IMPORTED_MODULE_3__.getQueryParam("pageId", url);\n                    const linkVbcpEntId = _utils_utils__WEBPACK_IMPORTED_MODULE_3__.getQueryParam("vbcpEntId", url);\n                    diagramParams = {\n                        diagramName: linkDiagramName,\n                        pageId: linkPageId,\n                        vbcpEntId: linkVbcpEntId,\n                    };\n                }\n            }\n            else {\n                diagramParams = yield this.linkUtilsService.getDiagramParamsFromUrl(url, macroKey, freeMacroKey);\n            }\n            yield this.linkPreviewService.openDiagramPreviewDialog(fileType, diagramParams, pageId, vbcpEntId, false, $canvas);\n        });\n    }\n    initAutoCompleteBinderDefault(elementLinkToEdit) {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.bpmnDiagramSearchInput.init({\n                $input: $("#vxcp-ent-link-bpmn-title-input"),\n                $resultsWrapper: $("#vxcp-ent-link-bpmn-results"),\n                search: (value, startFrom, cursor) => __awaiter(this, void 0, void 0, function* () {\n                    this.diagramLinkInputChanged = true;\n                    return this.searchDiagram(this.bpmnDiagramSearchInput, value, _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.BPMN */ .W.BPMN, false, startFrom, cursor);\n                }),\n                onResultListItemClick: (e, item) => __awaiter(this, void 0, void 0, function* () {\n                    yield this.onDiagramResultListItemClick(this.bpmnDiagramSearchInput, e, item, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN);\n                }),\n                spinnerType: "new",\n                suggest: () => __awaiter(this, void 0, void 0, function* () {\n                    return this.searchSuggestionsService.fetchSuggestions([\n                        yield this.searchSuggestionsService.createLastUpdatedDiagramsProvider(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.BPMN */ .W.BPMN),\n                        yield this.searchSuggestionsService.createLastViewedDiagramsProvider(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.BPMN */ .W.BPMN),\n                    ]);\n                }),\n            });\n            yield this.bpmnDiagramSearchInput.bind();\n            const $bpmnNewDiagramTargetPageNameInput = $("#vxcp-ent-link-bpmn-new-target-page-title-input");\n            const $bpmnNewDiagramTargetPageUrlInput = $("#vxcp-ent-link-bpmn-new-target-page-url-input");\n            yield this.bpmnNewDiagramTargetPageSearchInput.init({\n                $input: $bpmnNewDiagramTargetPageNameInput,\n                $resultsWrapper: $("#vxcp-ent-link-bpmn-new-target-page-results"),\n                search: (value, startFrom, cursor) => __awaiter(this, void 0, void 0, function* () {\n                    return this.searchPage(this.bpmnNewDiagramTargetPageSearchInput, value, startFrom, cursor);\n                }),\n                onResultListItemClick: (e, item) => __awaiter(this, void 0, void 0, function* () {\n                    yield this.onNewDiagramTargetPageResultListItemClick(this.bpmnNewDiagramTargetPageSearchInput, e, item, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN);\n                }),\n                spinnerType: "new",\n                suggest: () => __awaiter(this, void 0, void 0, function* () {\n                    return this.searchSuggestionsService.fetchSuggestions([\n                        yield this.searchSuggestionsService.createLastUpdatedPagesProvider(),\n                        yield this.searchSuggestionsService.createLastViewedPagesProvider(),\n                    ]);\n                }),\n            });\n            yield this.bpmnNewDiagramTargetPageSearchInput.bind();\n            $bpmnNewDiagramTargetPageNameInput.on("input keydown", (e) => {\n                $bpmnNewDiagramTargetPageNameInput.removeClass("invalid");\n                $bpmnNewDiagramTargetPageUrlInput.val("");\n            });\n            yield this.dmnDiagramSearchInput.init({\n                $input: $("#vxcp-ent-link-dmn-title-input"),\n                $resultsWrapper: $("#vxcp-ent-link-dmn-results"),\n                search: (value, startFrom, cursor) => __awaiter(this, void 0, void 0, function* () {\n                    this.diagramLinkInputChanged = true;\n                    return this.searchDiagram(this.dmnDiagramSearchInput, value, _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.DMN */ .W.DMN, true, startFrom, cursor);\n                }),\n                onResultListItemClick: (e, item) => __awaiter(this, void 0, void 0, function* () {\n                    yield this.onDiagramResultListItemClick(this.dmnDiagramSearchInput, e, item, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN);\n                    if (item.isFree) {\n                        $("#vxcp-ent-link-dialog-dmn-free-disclaimer").removeClass("vxcp-ent-hidden");\n                    }\n                }),\n                spinnerType: "new",\n                suggest: () => __awaiter(this, void 0, void 0, function* () {\n                    return this.searchSuggestionsService.fetchSuggestions([\n                        yield this.searchSuggestionsService.createLastUpdatedDiagramsProvider(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.DMN */ .W.DMN),\n                        yield this.searchSuggestionsService.createLastViewedDiagramsProvider(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.DMN */ .W.DMN),\n                    ]);\n                }),\n            });\n            yield this.dmnDiagramSearchInput.bind();\n            const $dmnNewDiagramTargetPageNameInput = $("#vxcp-ent-link-dmn-new-target-page-title-input");\n            const $dmnNewDiagramTargetPageUrlInput = $("#vxcp-ent-link-dmn-new-target-page-url-input");\n            yield this.dmnNewDiagramTargetPageSearchInput.init({\n                $input: $dmnNewDiagramTargetPageNameInput,\n                $resultsWrapper: $("#vxcp-ent-link-dmn-new-target-page-results"),\n                search: (value, startFrom, cursor) => __awaiter(this, void 0, void 0, function* () {\n                    return this.searchPage(this.dmnNewDiagramTargetPageSearchInput, value, startFrom, cursor);\n                }),\n                onResultListItemClick: (e, item) => __awaiter(this, void 0, void 0, function* () {\n                    yield this.onNewDiagramTargetPageResultListItemClick(this.dmnNewDiagramTargetPageSearchInput, e, item, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN);\n                }),\n                spinnerType: "new",\n                suggest: () => __awaiter(this, void 0, void 0, function* () {\n                    return this.searchSuggestionsService.fetchSuggestions([\n                        yield this.searchSuggestionsService.createLastUpdatedPagesProvider(),\n                        yield this.searchSuggestionsService.createLastViewedPagesProvider(),\n                    ]);\n                }),\n            });\n            yield this.dmnNewDiagramTargetPageSearchInput.bind();\n            $dmnNewDiagramTargetPageNameInput.on("input keydown", (e) => {\n                $dmnNewDiagramTargetPageNameInput.removeClass("invalid");\n                $dmnNewDiagramTargetPageUrlInput.val("");\n            });\n            yield this.pageSearchInput.init({\n                $input: $("#vxcp-ent-link-confluence-page-title-input"),\n                $resultsWrapper: $("#vxcp-ent-link-confluence-page-results"),\n                search: (value, startFrom, cursor) => __awaiter(this, void 0, void 0, function* () {\n                    return this.searchPage(this.pageSearchInput, value, startFrom, cursor);\n                }),\n                onResultListItemClick: (e, item) => __awaiter(this, void 0, void 0, function* () {\n                    yield this.onResultListItemClick(this.pageSearchInput, e, item, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.CONFLUENCE_PAGE */ .Iu.CONFLUENCE_PAGE);\n                }),\n                spinnerType: "new",\n                suggest: () => __awaiter(this, void 0, void 0, function* () {\n                    return this.searchSuggestionsService.fetchSuggestions([\n                        yield this.searchSuggestionsService.createLastUpdatedPagesProvider(),\n                        yield this.searchSuggestionsService.createLastViewedPagesProvider(),\n                    ]);\n                }),\n            });\n            yield this.pageSearchInput.bind();\n            const $attachmentSelectFileType = $("#vxcp-ent-link-confluence-attachment-select-type");\n            const $attachmentInputTitle = $("#vxcp-ent-link-confluence-attachment-title-input");\n            const $attachmentInputUrl = $("#vxcp-ent-link-confluence-attachment-url-input");\n            $attachmentSelectFileType.on("change", () => {\n                $attachmentInputTitle.val("");\n                $attachmentInputUrl.val("");\n                this.attachmentSearchInput.reset();\n                this.attachmentSearchInput.resetSuggestions();\n                return this.attachmentSearchInput.suggest();\n            });\n            yield this.attachmentSearchInput.init({\n                $input: $attachmentInputTitle,\n                $resultsWrapper: $("#vxcp-ent-link-confluence-attachment-results"),\n                search: (value, startFrom) => __awaiter(this, void 0, void 0, function* () {\n                    const fileType = _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum */ .W[$attachmentSelectFileType.val()];\n                    return this.searchAttachment(this.attachmentSearchInput, value, fileType, startFrom);\n                }),\n                onResultListItemClick: (e, item) => __awaiter(this, void 0, void 0, function* () {\n                    yield this.onResultListItemClick(this.attachmentSearchInput, e, item, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.CONFLUENCE_ATTACHMENT */ .Iu.CONFLUENCE_ATTACHMENT);\n                }),\n                spinnerType: "new",\n                suggest: () => __awaiter(this, void 0, void 0, function* () {\n                    const fileType = _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum */ .W[$attachmentSelectFileType.val()];\n                    const lastUpdatedAttachmentsProvider = yield this.searchSuggestionsService.createLastUpdatedAttachmentsProvider(fileType);\n                    const lastViewedAttachmentsProvider = yield this.searchSuggestionsService.createLastViewedAttachmentsProvider(fileType);\n                    return this.searchSuggestionsService.fetchSuggestions([\n                        Object.assign(Object.assign({}, lastUpdatedAttachmentsProvider), { provide: (limit, startFrom) => __awaiter(this, void 0, void 0, function* () {\n                                if (fileType === _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.ANY */ .W.ANY) {\n                                    return this.excludeDiagramsFromAttachmentsSearchSuggestionProvider(lastUpdatedAttachmentsProvider, limit, startFrom);\n                                }\n                                return lastUpdatedAttachmentsProvider.provide(limit, startFrom);\n                            }) }),\n                        Object.assign(Object.assign({}, lastViewedAttachmentsProvider), { provide: (limit, startFrom) => __awaiter(this, void 0, void 0, function* () {\n                                if (fileType === _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.ANY */ .W.ANY) {\n                                    return this.excludeDiagramsFromAttachmentsSearchSuggestionProvider(lastViewedAttachmentsProvider, limit, startFrom);\n                                }\n                                return lastViewedAttachmentsProvider.provide(limit, startFrom);\n                            }) }),\n                    ]);\n                }),\n            });\n            yield this.attachmentSearchInput.bind();\n            yield this.jiraIssueSearchInput.init({\n                $input: $("#vxcp-ent-link-jira-issue-title-input"),\n                $resultsWrapper: $("#vxcp-ent-link-jira-issue-results"),\n                search: (value, startFrom) => __awaiter(this, void 0, void 0, function* () {\n                    return this.searchJiraIssue(this.jiraIssueSearchInput, value, startFrom);\n                }),\n                onResultListItemClick: (e, item) => __awaiter(this, void 0, void 0, function* () {\n                    yield this.onJiraIssueResultListItemClick(this.jiraIssueSearchInput, e, item, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.JIRA_ISSUE */ .Iu.JIRA_ISSUE);\n                }),\n                spinnerType: "new",\n            });\n            yield this.jiraIssueSearchInput.bind();\n        });\n    }\n    excludeDiagramsFromAttachmentsSearchSuggestionProvider(provider, limit, startFrom) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const filteredItems = [];\n            let items = [];\n            let nextStartFrom = startFrom;\n            do {\n                items = yield provider.provide(limit, nextStartFrom);\n                filteredItems.push(...items.filter((item) => !item.title.endsWith(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.BPMN */ .W.BPMN) && !item.title.endsWith(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.DMN */ .W.DMN)));\n                nextStartFrom += limit;\n            } while (items.length > 0 && filteredItems.length < limit);\n            return filteredItems;\n        });\n    }\n    initDialogEventListenersLinkInputs(dialogId, linkTypeLabel) {\n        $(`#vxcp-ent-link-${linkTypeLabel}-url-copy`).on("click", (e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            $(`#vxcp-ent-link-${linkTypeLabel}-url-input`).select();\n            document.execCommand("copy");\n        });\n        $(`#vxcp-ent-link-${linkTypeLabel}-url-open`).on("click", (e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            let url = $(`#vxcp-ent-link-${linkTypeLabel}-url-input`).val();\n            if (!url) {\n                return;\n            }\n            if (!(url.startsWith("http") || url.startsWith("https"))) {\n                url = `https://${url}`;\n            }\n            window.open(url, "_blank");\n        });\n    }\n    initDialogButtons(dialogId, languageService, pageId, fromMode, elementLinkToEditReadOnly) {\n        const moddle = languageService.getModdle();\n        const selectedElements = _attribute_panel_panel_utils_service__WEBPACK_IMPORTED_MODULE_2__/* .getSelectedElements */ .eD(languageService);\n        const curElement = selectedElements[0];\n        this.platformUtils.getDialog(dialogId).on("hide", () => {\n            $(dialogId).remove();\n        });\n        $(dialogId + "-abort").on("click", () => {\n            this.diagramLinkInputChanged = false;\n            this.platformUtils.hideDialog(dialogId);\n        });\n        _utils_utils__WEBPACK_IMPORTED_MODULE_3__.initEscKey($("body"), $(dialogId + "-abort"));\n        this.platformUtils.hideUnsupportedFeaturesAddLinkDialog();\n        $(`${dialogId}-continue`).on("click", () => __awaiter(this, void 0, void 0, function* () {\n            this.showContinueSpinner(dialogId);\n            const selectedDialogPageInfo = this.linkDialogSubpagesService.getSelectedDialogPageInfo();\n            const $titleInput = $(selectedDialogPageInfo.pageId + " .vxcp-ent-link-title-input");\n            const $urlInput = $(selectedDialogPageInfo.pageId + " .vxcp-ent-link-url-input");\n            const $descInput = $(selectedDialogPageInfo.pageId + " .vxcp-ent-link-desc-input");\n            let titleInputValue = "";\n            let urlInputValue = "";\n            let descInputValue = "";\n            let newVbcpEntId = "";\n            let isUnsaved = false;\n            switch (selectedDialogPageInfo.subPage) {\n                case "new":\n                    const createdDiagram = yield this.onCreateNewDiagram(languageService, selectedDialogPageInfo.page, pageId, fromMode);\n                    if (!createdDiagram) {\n                        this.hideContinueSpinner(dialogId);\n                        return;\n                    }\n                    titleInputValue = _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(createdDiagram.attachments.raw.title);\n                    urlInputValue = _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(createdDiagram.attachments.raw.previewUrl);\n                    descInputValue = _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(createdDiagram.desc);\n                    newVbcpEntId = createdDiagram.configValues.vbcpEntId;\n                    isUnsaved = createdDiagram.isUnsaved;\n                    break;\n                default:\n                    $titleInput.val(_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString($titleInput.val()));\n                    $descInput.val(_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString($descInput.val()));\n                    if (!(yield this.tabbedDialogService.validateInput([$titleInput, $urlInput]))) {\n                        this.hideContinueSpinner(dialogId);\n                        return;\n                    }\n                    titleInputValue = $titleInput.val();\n                    urlInputValue = $urlInput.val();\n                    descInputValue = $descInput.val();\n            }\n            const elementLink = elementLinkToEditReadOnly ? Object.assign({}, elementLinkToEditReadOnly) : {};\n            const oldId = elementLinkToEditReadOnly ? elementLinkToEditReadOnly.id : "";\n            let extensionType = this.enumConverterService.convertEnumValue(selectedDialogPageInfo.page, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum */ .Iu, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws);\n            if (!elementLink.id || elementLink.id.includes("WikiLink_")) {\n                const idGenerator = moddle.ids;\n                elementLink.id = idGenerator.nextPrefixed("ElementLink_");\n                elementLink.type = selectedDialogPageInfo.page;\n            }\n            const newUrl = urlInputValue;\n            elementLink.title = titleInputValue;\n            elementLink.desc = encodeURIComponent(descInputValue);\n            switch (selectedDialogPageInfo.page) {\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN:\n                    const macroKey = "vbcp-macro-enterprise";\n                    const freeMacroKey = "vbcp-macro";\n                    if (elementLink.url === newUrl) {\n                        break;\n                    }\n                    let bpmnParams;\n                    if (elementLinkToEditReadOnly) {\n                        if (this.diagramLinkInputChanged) {\n                            bpmnParams = yield this.linkUtilsService.getDiagramParamsFromUrl(newUrl, macroKey, freeMacroKey);\n                        }\n                        else {\n                            const linkTitle = elementLink.title;\n                            const linkDiagramName = linkTitle.replace(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.BPMN */ .W.BPMN, "");\n                            const linkPageId = _utils_utils__WEBPACK_IMPORTED_MODULE_3__.getQueryParam("pageId", newUrl);\n                            const linkVbcpEntId = _utils_utils__WEBPACK_IMPORTED_MODULE_3__.getQueryParam("vbcpEntId", newUrl);\n                            bpmnParams = {\n                                diagramName: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkDiagramName),\n                                pageId: linkPageId,\n                                vbcpEntId: linkVbcpEntId,\n                            };\n                        }\n                    }\n                    else {\n                        bpmnParams = yield this.linkUtilsService.getDiagramParamsFromUrl(newUrl, macroKey, freeMacroKey);\n                    }\n                    elementLink.pageId = bpmnParams.pageId;\n                    elementLink.macroId = bpmnParams.macroId;\n                    elementLink.vbcpEntId = bpmnParams.vbcpEntId;\n                    if (!elementLink.vbcpEntId) {\n                        elementLink.vbcpEntId = newVbcpEntId;\n                    }\n                    break;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN:\n                    if (elementLink.url === newUrl) {\n                        break;\n                    }\n                    const dmnMacroKey = "vdcp-macro-enterprise";\n                    const dmnFreeMacroKey = "vdcp-macro";\n                    const isFreeMacro = $titleInput.prop("data-is-free");\n                    if (isFreeMacro) {\n                        let dmnTableParams;\n                        if (elementLinkToEditReadOnly) {\n                            if (this.diagramLinkInputChanged) {\n                                dmnTableParams = this.linkUtilsService.getDmnFreeParamsFromUrl(newUrl);\n                            }\n                            else {\n                                const linkTitle = elementLink.title;\n                                const linkTableName = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_3__.getFileNameWithoutTypeEnding)(linkTitle);\n                                const linkPageId = _utils_utils__WEBPACK_IMPORTED_MODULE_3__.getQueryParam("pageId", newUrl);\n                                dmnTableParams = {\n                                    tableName: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkTableName),\n                                    pageId: linkPageId,\n                                };\n                            }\n                        }\n                        else {\n                            dmnTableParams = this.linkUtilsService.getDmnFreeParamsFromUrl(newUrl);\n                        }\n                        elementLink.pageId = dmnTableParams.pageId;\n                        elementLink.title = dmnTableParams.tableName;\n                        delete elementLink.vbcpEntId;\n                        delete elementLink.macroId;\n                        elementLink.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN;\n                        extensionType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.DMN */ .ws.DMN;\n                        break;\n                    }\n                    else {\n                        extensionType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.DMN_ENTERPRISE */ .ws.DMN_ENTERPRISE;\n                        if (elementLink.url === newUrl) {\n                            break;\n                        }\n                        let dmnParams;\n                        if (elementLinkToEditReadOnly) {\n                            if (this.diagramLinkInputChanged) {\n                                dmnParams = yield this.linkUtilsService.getDiagramParamsFromUrl(newUrl, dmnMacroKey, dmnFreeMacroKey);\n                            }\n                            else {\n                                const linkTitle = elementLink.title;\n                                const linkDiagramName = linkTitle.replace(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.DMN */ .W.DMN, "");\n                                const linkPageId = _utils_utils__WEBPACK_IMPORTED_MODULE_3__.getQueryParam("pageId", newUrl);\n                                const linkVbcpEntId = _utils_utils__WEBPACK_IMPORTED_MODULE_3__.getQueryParam("vbcpEntId", newUrl);\n                                dmnParams = {\n                                    diagramName: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkDiagramName),\n                                    pageId: linkPageId,\n                                    vbcpEntId: linkVbcpEntId,\n                                };\n                            }\n                        }\n                        else {\n                            dmnParams = yield this.linkUtilsService.getDiagramParamsFromUrl(newUrl, dmnMacroKey, dmnFreeMacroKey);\n                        }\n                        elementLink.pageId = dmnParams.pageId;\n                        elementLink.macroId = dmnParams.macroId;\n                        elementLink.vbcpEntId = dmnParams.vbcpEntId;\n                        elementLink.type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN_ENTERPRISE */ .Iu.DMN_ENTERPRISE;\n                        if (!elementLink.vbcpEntId) {\n                            elementLink.vbcpEntId = newVbcpEntId;\n                        }\n                        break;\n                    }\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.CONFLUENCE_PAGE */ .Iu.CONFLUENCE_PAGE:\n                    elementLink.pageId = yield _atlassian_page_service__WEBPACK_IMPORTED_MODULE_4__/* .getPageIdByConfluencePageUrlAndPageName */ .Ld(newUrl, elementLink.title);\n                    break;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.CONFLUENCE_ATTACHMENT */ .Iu.CONFLUENCE_ATTACHMENT:\n                    elementLink.url = _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(newUrl);\n                    break;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.JIRA_ISSUE */ .Iu.JIRA_ISSUE:\n                    const regexIssueKey = new RegExp(/[A-Z]{1,10}-[0-9]+/g);\n                    const potentialIssueKeys = newUrl.match(regexIssueKey);\n                    const issueKey = potentialIssueKeys && potentialIssueKeys.length ? potentialIssueKeys[0] : "";\n                    elementLink.issueKey = issueKey;\n                    const jiraInstance = yield this.jiraRestService.getLinkedJiraInstance(true);\n                    if (jiraInstance) {\n                        elementLink.appId = jiraInstance.id;\n                        elementLink.url = `${jiraInstance.url}/browse/${issueKey}`;\n                    }\n                    break;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.EXTERNAL_CONTENT */ .Iu.EXTERNAL_CONTENT:\n                default:\n                    if (!newUrl.startsWith("http://") && !newUrl.startsWith("https://")) {\n                        elementLink.url = `https://${newUrl}`;\n                    }\n                    else {\n                        elementLink.url = _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(newUrl);\n                    }\n                    break;\n            }\n            if (!elementLinkToEditReadOnly) {\n                this.xmlExtensionService.createExtension(languageService, curElement, extensionType, elementLink);\n            }\n            else {\n                const newElementLink = Object.assign({}, elementLink);\n                delete newElementLink.$type;\n                newElementLink.$type = extensionType;\n                this.xmlExtensionService.replaceExistingExtension(languageService, curElement, newElementLink, oldId);\n            }\n            this.hideContinueSpinner(dialogId);\n            this.platformUtils.hideDialog(dialogId);\n            this.diagramLinkInputChanged = false;\n            switch (selectedDialogPageInfo.page) {\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN:\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN:\n                    if (isUnsaved) {\n                        yield _utils_utils__WEBPACK_IMPORTED_MODULE_3__.confirmWarningDialog(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_7__/* .WarningDialogTypeEnum.NEW_DIAGRAM_NOT_SAVED_YET */ .K.NEW_DIAGRAM_NOT_SAVED_YET);\n                    }\n                    break;\n            }\n        }));\n    }\n    initDialogLinkNewDiagram(dialogId, pageId, linkTypeLabel, activate = true) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $linkDiagramContainer = $(`#vxcp-ent-link-${linkTypeLabel}`);\n            const $linkDiagramSubpagesMenuContainer = $linkDiagramContainer.find(".vxcp-ent-link-subpages-menu-container");\n            if (typeof activate === "boolean") {\n                if (activate) {\n                    $linkDiagramSubpagesMenuContainer.removeClass("vxcp-ent-hidden");\n                }\n                else {\n                    $linkDiagramSubpagesMenuContainer.addClass("vxcp-ent-hidden");\n                }\n            }\n            else {\n                activate().then((value) => {\n                    if (value) {\n                        $linkDiagramSubpagesMenuContainer.removeClass("vxcp-ent-hidden");\n                    }\n                    else {\n                        $linkDiagramSubpagesMenuContainer.addClass("vxcp-ent-hidden");\n                    }\n                });\n            }\n            const $linkMenuItem = $(`#vxcp-ent-link-${linkTypeLabel}-menu`);\n            $linkMenuItem.on("click", (e) => {\n                this.linkDialogSubpagesService.resetSubPageForLinkType(dialogId, linkTypeLabel);\n            });\n            const $linkExistingDiagramButton = $linkDiagramSubpagesMenuContainer.find(`#vxcp-ent-link-${linkTypeLabel}-existing-button`);\n            const $linkNewDiagramButton = $linkDiagramSubpagesMenuContainer.find(`#vxcp-ent-link-${linkTypeLabel}-new-button`);\n            $linkExistingDiagramButton.on("click", (e) => {\n                this.linkDialogSubpagesService.setSubPageForLinkType(dialogId, linkTypeLabel, "existing");\n            });\n            $linkNewDiagramButton.on("click", (e) => {\n                this.linkDialogSubpagesService.setSubPageForLinkType(dialogId, linkTypeLabel, "new");\n            });\n            const $linkNewDiagramContainer = $linkDiagramContainer.find(`#vxcp-ent-link-${linkTypeLabel}-new-container`);\n            const $linkNewDiagramTargetPageNameInput = $linkNewDiagramContainer.find(`#vxcp-ent-link-${linkTypeLabel}-new-target-page-title-input`);\n            const $linkNewDiagramTargetPageUrlInput = $linkNewDiagramContainer.find(`#vxcp-ent-link-${linkTypeLabel}-new-target-page-url-input`);\n            const $linkNewDiagramNameInput = $linkNewDiagramContainer.find(`#vxcp-ent-link-${linkTypeLabel}-new-title-input`);\n            const $linkNewDiagramNameInputError = $linkNewDiagramContainer.find(`#vxcp-ent-link-${linkTypeLabel}-new-title-input-error`);\n            $linkNewDiagramNameInput.on("input keydown", (e) => {\n                $linkNewDiagramNameInput.removeClass("invalid");\n                $linkNewDiagramNameInputError.empty();\n                $linkNewDiagramNameInputError.addClass("vxcp-ent-hidden");\n            });\n            if (!!pageId) {\n                const pageData = yield _atlassian_page_service__WEBPACK_IMPORTED_MODULE_4__/* .getPageDataByPageId */ .S4(pageId);\n                $linkNewDiagramTargetPageNameInput.val(pageData.title);\n                $linkNewDiagramTargetPageUrlInput.val(this.platformUtils.buildRestUrl(pageData._links.webui, true));\n            }\n        });\n    }\n    searchDiagram(searchInput, value, fileType, includeFreeDiagrams, startFrom, cursor) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return this.searchDiagramService.searchDiagramWithCql(value, fileType, includeFreeDiagrams, false, (results, start) => __awaiter(this, void 0, void 0, function* () {\n                return searchInput.progress(value, results, start);\n            }), (results, maxTotalSize, nextStart, _cursor, filteredResultsCount) => __awaiter(this, void 0, void 0, function* () {\n                return searchInput.done(value, results, maxTotalSize, nextStart, _cursor, filteredResultsCount);\n            }), undefined, startFrom, cursor);\n        });\n    }\n    searchPage(searchInput, value, startFrom, cursor) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return this.searchPageService.searchPageWithCql(value, (results, start) => __awaiter(this, void 0, void 0, function* () {\n                return searchInput.progress(value, results, start);\n            }), (results, maxTotalSize, nextStart, _cursor) => __awaiter(this, void 0, void 0, function* () {\n                return searchInput.done(value, results, maxTotalSize, nextStart, _cursor);\n            }), undefined, startFrom, cursor);\n        });\n    }\n    searchAttachment(searchInput, value, fileType, startFrom, cursor) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return this.searchAttachmentService.searchAttachmentWithCql(value, fileType, (results, start) => __awaiter(this, void 0, void 0, function* () {\n                return searchInput.progress(value, results, start);\n            }), (results, maxTotalSize, nextStart, _cursor) => __awaiter(this, void 0, void 0, function* () {\n                return searchInput.done(value, results, maxTotalSize, nextStart, _cursor);\n            }), undefined, startFrom, cursor);\n        });\n    }\n    searchJiraIssue(searchInput, value, startFrom, cursor) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const result = yield this.searchJiraIssueService.searchJiraIssueWithJql(value);\n            const results = result.results;\n            const processedResults = yield searchInput.progress(value, results, 0);\n            yield searchInput.done(value, results, results.length, results.length);\n            return Object.assign(Object.assign({}, result), { results: processedResults });\n        });\n    }\n    showContinueSpinner(dialogId) {\n        const $footerActions = $(`${dialogId} .aui-dialog2-footer-actions`);\n        $footerActions.find("button").attr("disabled", "disabled");\n        const spinnerId = `${dialogId.substr(1)}-continue-spinner`;\n        const $existingSpinner = $(`#${spinnerId}`);\n        const $spinner = $existingSpinner.empty() ? $footerActions.prepend(`<aui-spinner id="${spinnerId}" class="spinner" size="small"></aui-spinner>`) : $existingSpinner;\n        return $spinner;\n    }\n    hideContinueSpinner(dialogId) {\n        const $footerActions = $(`${dialogId} .aui-dialog2-footer-actions`);\n        $footerActions.find("button").removeAttr("disabled");\n        const $existingSpinner = $(`${dialogId}-continue-spinner`);\n        $existingSpinner.remove();\n    }\n    onDiagramResultListItemClick(searchInput, e, item, type) {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield searchInput.onResultListItemClickDefault(e, item);\n            const itemRelativeUrl = item._links.webui;\n            const itemUrl = this.platformUtils.buildRestUrl(itemRelativeUrl, true);\n            const $urlInput = $(`#vxcp-ent-link-${type}-url-input`);\n            $urlInput.val(itemUrl);\n            const $titleInput = $(`#vxcp-ent-link-${type}-title-input`);\n            $titleInput.prop("data-is-free", item.isFree);\n            const $continueButton = $(`${this.dialogId}-continue`);\n            $continueButton.focus();\n        });\n    }\n    onNewDiagramTargetPageResultListItemClick(searchInput, e, item, type) {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield searchInput.onResultListItemClickDefault(e, item);\n            const itemRelativeUrl = item._links.webui;\n            const itemUrl = this.platformUtils.buildRestUrl(itemRelativeUrl, true);\n            const $urlInput = $(`#vxcp-ent-link-${type}-new-target-page-url-input`);\n            $urlInput.val(itemUrl);\n            $urlInput.removeClass("invalid");\n            const $continueButton = $(`${this.dialogId}-continue`);\n            $continueButton.focus();\n        });\n    }\n    onResultListItemClick(searchInput, e, item, type) {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield searchInput.onResultListItemClickDefault(e, item);\n            const itemRelativeUrl = item._links.webui;\n            const itemUrl = this.platformUtils.buildRestUrl(itemRelativeUrl, true);\n            const $urlInput = $(`#vxcp-ent-link-${type}-url-input`);\n            $urlInput.val(itemUrl);\n            const $continueButton = $(`${this.dialogId}-continue`);\n            $continueButton.focus();\n        });\n    }\n    onJiraIssueResultListItemClick(searchInput, e, item, type) {\n        return __awaiter(this, void 0, void 0, function* () {\n            searchInput.reset(item.title || item.key, false);\n            const itemUrl = item.self;\n            const $urlInput = $(`#vxcp-ent-link-${type}-url-input`);\n            $urlInput.val(itemUrl);\n            const $continueButton = $(`${this.dialogId}-continue`);\n            $continueButton.focus();\n        });\n    }\n    onCreateNewDiagram(languageService, linkTypeLabel, sourcePageId, fromMode) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $linkDiagramContainer = $(`#vxcp-ent-link-${linkTypeLabel}`);\n            const $linkNewDiagramContainer = $linkDiagramContainer.find(`#vxcp-ent-link-${linkTypeLabel}-new-container`);\n            const $linkNewDiagramTargetPageNameInput = $linkNewDiagramContainer.find(`#vxcp-ent-link-${linkTypeLabel}-new-target-page-title-input`);\n            const $linkNewDiagramTargetPageUrlInput = $linkNewDiagramContainer.find(`#vxcp-ent-link-${linkTypeLabel}-new-target-page-url-input`);\n            const $linkNewDiagramNameInput = $linkNewDiagramContainer.find(`#vxcp-ent-link-${linkTypeLabel}-new-title-input`);\n            const $linkNewDiagramNameInputError = $linkNewDiagramContainer.find(`#vxcp-ent-link-${linkTypeLabel}-new-title-input-error`);\n            const $linkNewDiagramDescTextarea = $linkNewDiagramContainer.find(`#vxcp-ent-link-${linkTypeLabel}-new-desc-input`);\n            $linkNewDiagramTargetPageNameInput.val(_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString($linkNewDiagramTargetPageNameInput.val()));\n            $linkNewDiagramTargetPageUrlInput.val(_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString($linkNewDiagramTargetPageUrlInput.val()));\n            $linkNewDiagramNameInput.val(_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString($linkNewDiagramNameInput.val()).trim());\n            $linkNewDiagramDescTextarea.val(_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_6__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString($linkNewDiagramDescTextarea.val()).trim());\n            if (!(yield this.tabbedDialogService.validateInput([$linkNewDiagramTargetPageNameInput, $linkNewDiagramTargetPageUrlInput, $linkNewDiagramNameInput]))) {\n                return;\n            }\n            const targetPageName = $linkNewDiagramTargetPageNameInput.val();\n            const targetPageUrl = $linkNewDiagramTargetPageUrlInput.val();\n            const targetPageId = yield _atlassian_page_service__WEBPACK_IMPORTED_MODULE_4__/* .getPageIdByConfluencePageUrlAndPageName */ .Ld(targetPageUrl, targetPageName);\n            const diagramName = $linkNewDiagramNameInput.val();\n            const diagramNameErrorMessage = yield this.validatorService.validateDiagramNameInput(diagramName, "", "", false, targetPageId);\n            if (diagramNameErrorMessage) {\n                $linkNewDiagramNameInput.addClass("invalid");\n                $linkNewDiagramNameInputError.removeClass("vxcp-ent-hidden");\n                $linkNewDiagramNameInputError.text(diagramNameErrorMessage);\n                return;\n            }\n            const macroName = this.enumConverterService.convertOverlayTypeLabelToMacroEntName(linkTypeLabel);\n            if (!macroName) {\n                this.vxcpLogger.logError("onCreateNewDiagram", `Unknown linkTypeLabel: ${linkTypeLabel}`);\n                return;\n            }\n            const newDiagramInfo = yield this.linkUtilsService.createAndAppendNewDiagram(languageService, sourcePageId, fromMode, macroName, diagramName, targetPageId);\n            if (!newDiagramInfo) {\n                yield _utils_utils__WEBPACK_IMPORTED_MODULE_3__.confirmWarningDialog(_model_enum_warning_dialog_type_enum__WEBPACK_IMPORTED_MODULE_7__/* .WarningDialogTypeEnum.NEW_DIAGRAM_NOT_SAVED */ .K.NEW_DIAGRAM_NOT_SAVED);\n                return;\n            }\n            return Object.assign(Object.assign({ pageId: targetPageId }, newDiagramInfo), { desc: $linkNewDiagramDescTextarea.val() });\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/link-dialog-init.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/link-dialog-subpages.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "H": () => (/* binding */ LinkDialogSubpagesService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts");\nif ("bpmnEntEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\nclass LinkDialogSubpagesService {\n    constructor(tabbedDialogService) {\n        this.tabbedDialogService = tabbedDialogService;\n        this.defaultSubPagePerLinkType = {\n            [_model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN]: "existing",\n            [_model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN]: "existing",\n        };\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_1__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.selectedSubPagePerLinkType = {};\n    }\n    initDialogEventListeners(dialogId) {\n        $("#vxcp-ent-dialog-link .vxcp-ent-dialog-menu .vxcp-ent-dialog-menu-item").on("click", (e) => {\n            this.refreshDialogContinueButton(dialogId);\n        });\n    }\n    getSelectedDialogPageInfo() {\n        const selectedDialogPageId = this.tabbedDialogService.getSelectedDialogPageId();\n        const selectedDialogPage = selectedDialogPageId.substr(15);\n        return {\n            pageId: selectedDialogPageId,\n            page: selectedDialogPage,\n            subPage: this.selectedSubPagePerLinkType[selectedDialogPage],\n        };\n    }\n    resetSubPageForLinkType(dialogId, linkTypeLabel) {\n        const defaultSubPage = this.defaultSubPagePerLinkType[linkTypeLabel];\n        if (defaultSubPage) {\n            this.setSubPageForLinkType(dialogId, linkTypeLabel, defaultSubPage);\n        }\n    }\n    setSubPageForLinkType(dialogId, linkTypeLabel, newSubPage) {\n        this.selectedSubPagePerLinkType[linkTypeLabel] = newSubPage;\n        this.refreshSubPage(linkTypeLabel);\n        this.refreshDialogContinueButton(dialogId);\n    }\n    refreshSubPage(linkTypeLabel) {\n        const currentSubPage = this.selectedSubPagePerLinkType[linkTypeLabel];\n        const $linkDiagramContainer = $(`#vxcp-ent-link-${linkTypeLabel}`);\n        const $linkExistingDiagramButton = $linkDiagramContainer.find(`#vxcp-ent-link-${linkTypeLabel}-existing-button`);\n        const $linkExistingDiagramContainerChildren = $linkDiagramContainer.children(".vxcp-ent-dialog-link-entry, .vxcp-ent-link-info-container");\n        const $linkNewDiagramButton = $linkDiagramContainer.find(`#vxcp-ent-link-${linkTypeLabel}-new-button`);\n        const $linkNewDiagramContainer = $linkDiagramContainer.find(`#vxcp-ent-link-${linkTypeLabel}-new-container`);\n        switch (currentSubPage) {\n            case "new":\n                $linkExistingDiagramButton.removeClass("selected");\n                $linkNewDiagramButton.addClass("selected");\n                $linkExistingDiagramContainerChildren.addClass("vxcp-ent-hidden");\n                $linkNewDiagramContainer.removeClass("vxcp-ent-hidden");\n                break;\n            case "existing":\n            default:\n                $linkNewDiagramButton.removeClass("selected");\n                $linkExistingDiagramButton.addClass("selected");\n                $linkNewDiagramContainer.addClass("vxcp-ent-hidden");\n                $linkExistingDiagramContainerChildren.removeClass("vxcp-ent-hidden");\n                break;\n        }\n    }\n    refreshDialogContinueButton(dialogId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const selectedDialogPageInfo = this.getSelectedDialogPageInfo();\n            let continueLabelKey = "de.viadee.confluence.viadee-plugin-enterprise.add-elementlink-dialog.continue";\n            if (selectedDialogPageInfo.subPage && selectedDialogPageInfo.subPage !== this.defaultSubPagePerLinkType[selectedDialogPageInfo.page]) {\n                continueLabelKey = continueLabelKey.concat(`-${selectedDialogPageInfo.subPage}`);\n            }\n            const label = yield this.platformUtils.getText(continueLabelKey);\n            const $dialogContinueButton = $(`${dialogId}-continue`);\n            $dialogContinueButton.text(label);\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/link-dialog-subpages.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/link-html-factory.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "E": () => (/* binding */ LinkHtmlFactory)\n/* harmony export */ });\n/* harmony import */ var _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts");\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\n/* harmony import */ var _overlays_overlay_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/overlays/overlay-utils.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nclass LinkHtmlFactory {\n    constructor(enumConverterService) {\n        this.enumConverterService = enumConverterService;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_3__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.loadingSpinner = `<aui-spinner size="small"></aui-spinner>`;\n    }\n    createLinkOverlayHtml(domElementId, overlayTypeIcon, hoverText) {\n        const linkTypeLabel = this.enumConverterService.convertEnumValue(overlayTypeIcon, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum */ .eN, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum */ .Iu);\n        const overlayId = _overlays_overlay_utils__WEBPACK_IMPORTED_MODULE_2__/* .getIdentifierForLinkOverlay */ .c(linkTypeLabel, domElementId);\n        const overlayClass = this.getClassesForLinkOverlay(overlayTypeIcon).join(" ");\n        const overlayHoverText = _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(hoverText);\n        const $overlay = $("<span>", {\n            id: overlayId,\n            class: overlayClass,\n            title: overlayHoverText,\n        });\n        return $overlay;\n    }\n    getClassesForLinkOverlay(overlayTypeIcon) {\n        const linkTypeLabel = this.enumConverterService.convertEnumValue(overlayTypeIcon, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum */ .eN, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum */ .Iu);\n        return [this.getLinkClassForType(linkTypeLabel), `vxcp-ent-overlay-link`, overlayTypeIcon];\n    }\n    getLinkClassForType(linkTypeLabel) {\n        if (linkTypeLabel === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN_ENTERPRISE */ .Iu.DMN_ENTERPRISE) {\n            return this.getLinkClassForType(_model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN);\n        }\n        return `vxcp-ent-overlay-link-${linkTypeLabel}`;\n    }\n    createLinkTableHtml(linkId, linkTypeXml, linkDesc, editable) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const linkIdLowerCase = linkId.toLowerCase();\n            const iconClass = this.enumConverterService.convertEnumValue(linkTypeXml, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum */ .eN);\n            const iconHoverText = yield this.getIconHoverText(iconClass);\n            let elementLinkDesc = decodeURIComponent(linkDesc) || "";\n            if (elementLinkDesc.length > 100) {\n                elementLinkDesc = this.loadingSpinner;\n            }\n            const actionLinksColumnHtml = `<td class="vxcp-ent-att-panel-elementlink-actions">\n            <span class="btn-edit-elementlink aui-icon aui-icon-small aui-iconfont-edit"\n                  id="btn-edit-${linkIdLowerCase}"\n                  title="Edit Link"></span>\n            <span class="btn-delete-elementlink aui-icon aui-icon-small aui-iconfont-delete"\n                  id="btn-delete-${linkIdLowerCase}"\n                  title="Delete Link"></span>\n        </td>`;\n            const shownActionLinksColumnHtml = editable ? actionLinksColumnHtml : "";\n            return `<tr id="elementlink-entry-${linkIdLowerCase}" class="elementlink-entry">\n            <td class="elementlink-type">\n                <div class="${iconClass} vxcp-ent-overlay-link vxcp-ent-att-table-icon" title="${iconHoverText}"></div>\n            </td>\n            <td class="elementlink-title">\n                <a id="btn-href-${linkIdLowerCase}" href="" target="_blank">\n                    ${this.loadingSpinner}\n                </a>\n                <span id="unsaved-hint-${linkIdLowerCase}" class="aui-icon aui-icon-small aui-iconfont-info-filled vxcp-ent-hidden"></span>\n                <span id="missing-hint-${linkIdLowerCase}" class="aui-icon aui-icon-small aui-iconfont-warning vxcp-ent-hidden"></span>\n            </td>\n            <td class="elementlink-desc">\n                ${_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(elementLinkDesc)}\n            </td>\n            ${shownActionLinksColumnHtml}\n        </tr>`;\n        });\n    }\n    updateLinkTableHtml(htmlPropsOfLink) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let showLessText = "less";\n            let showMoreText = "more";\n            try {\n                showLessText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.business-tab.elementlink-group.table.desc.show-less");\n                showMoreText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.business-tab.elementlink-group.table.desc.show-more");\n            }\n            catch (e) {\n            }\n            const linkId = htmlPropsOfLink.id.toLowerCase();\n            const entryId = `elementlink-entry-${linkId}`;\n            const hrefBtnId = `btn-href-${linkId}`;\n            const $currentEntry = $(`#${entryId}`);\n            const $descColumn = $currentEntry.find(`td.elementlink-desc`);\n            const $hrefBtn = $currentEntry.find(`#${hrefBtnId}`);\n            const $typeIcon = $currentEntry.find(`.vxcp-ent-overlay-link.vxcp-ent-att-table-icon`);\n            const description = decodeURIComponent(htmlPropsOfLink.desc);\n            if (description.length > 100) {\n                const descColumnContent = `\n            <div id="elementlink-desc-${linkId}"\n                 class="aui-expander-content vxcp-ent-att-panel-reveal-elementlink-desc">\n                ${_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(description)}\n                <a id="elementlink-desc-trigger-${linkId}"\n                   data-replace-text="${showLessText}"\n                   data-replace-selector=".reveal-text-trigger-text"\n                   class="aui-expander-trigger aui-expander-reveal-text vxcp-ent-att-panel-reveal-elementlink-desc-trigger"\n                   aria-controls="elementlink-desc-${linkId}">\n                    <span class="reveal-text-trigger-text">${showMoreText}</span>\n                </a>\n            </div>`;\n                $descColumn.html(descColumnContent);\n            }\n            $hrefBtn.attr("href", _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(htmlPropsOfLink.url));\n            $hrefBtn.html(_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(decodeURI(htmlPropsOfLink.title)));\n            $typeIcon.attr("class", `${htmlPropsOfLink.iconClass} vxcp-ent-overlay-link vxcp-ent-att-table-icon`);\n            return htmlPropsOfLink;\n        });\n    }\n    getIconHoverText(iconClass) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let iconHoverText = "";\n            switch (iconClass) {\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum.BPMN */ .eN.BPMN:\n                    iconHoverText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.link-table.hover.bpmn");\n                    return iconHoverText;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum.DMN */ .eN.DMN:\n                    iconHoverText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.link-table.hover.dmn");\n                    return iconHoverText;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum.CONFLUENCE_ATTACHMENT */ .eN.CONFLUENCE_ATTACHMENT:\n                    iconHoverText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.link-table.hover.confluence-attachment");\n                    return iconHoverText;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum.CONFLUENCE_PAGE */ .eN.CONFLUENCE_PAGE:\n                    iconHoverText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.link-table.hover.confluence-page");\n                    return iconHoverText;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum.EXTERNAL_CONTENT */ .eN.EXTERNAL_CONTENT:\n                    iconHoverText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.link-table.hover.external");\n                    return iconHoverText;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum.JIRA_ISSUE */ .eN.JIRA_ISSUE:\n                    iconHoverText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.link-table.hover.jira");\n                    return iconHoverText;\n            }\n            return iconHoverText;\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/link-html-factory.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/link-properties.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "w": () => (/* binding */ LinkPropertiesService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts");\n/* harmony import */ var _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/file-type.enum.ts");\n/* harmony import */ var _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-mode.enum.ts");\n/* harmony import */ var _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/from-mode.enum.ts");\n/* harmony import */ var _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/routing.service.ts");\n/* harmony import */ var _atlassian_page_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/page.service.ts");\n/* harmony import */ var _link_html_factory_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/link-html-factory.service.ts");\n/* harmony import */ var _model_enum_link_preview_type_enum__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/link-preview-type.enum.ts");\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _model_enum_dmn_table_mode_enum__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dmn-table-mode.enum.ts");\n/* harmony import */ var _model_enum_app_type_enum__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-type.enum.ts");\n/* harmony import */ var _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\nclass LinkPropertiesService {\n    constructor(legacyLinkHandler, linkUtilsService, jiraRestService, enumConverterService, linkPreviewService, managedDataFieldsService, currentAppMode) {\n        this.legacyLinkHandler = legacyLinkHandler;\n        this.linkUtilsService = linkUtilsService;\n        this.jiraRestService = jiraRestService;\n        this.enumConverterService = enumConverterService;\n        this.linkPreviewService = linkPreviewService;\n        this.managedDataFieldsService = managedDataFieldsService;\n        this.currentAppMode = currentAppMode;\n        this.pluginService = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_11__/* .getPluginService */ .j)();\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_11__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.textLinkUnavailable = "[unavailable]";\n        this.linkHtmlFactory = new _link_html_factory_service__WEBPACK_IMPORTED_MODULE_6__/* .LinkHtmlFactory */ .E(this.enumConverterService);\n    }\n    buildLinkTableHtml($container, xmlPropsOfLink, editable) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const linkEntryHtml = yield this.linkHtmlFactory.createLinkTableHtml(xmlPropsOfLink.id, xmlPropsOfLink.$type, xmlPropsOfLink.desc, editable);\n            $container.append(linkEntryHtml);\n            return this.getHtmlPropsOfLink(xmlPropsOfLink).then(this.linkHtmlFactory.updateLinkTableHtml.bind(this));\n        });\n    }\n    openLink(linkHtmlProps, linkXmlProps, configValues, vbcpEntId, pageId, $parentToAppendDialog, editable, $canvas) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const pluginFileType = this.pluginService.getFileEnding();\n            const linkFileType = this.enumConverterService.convertOverlayTypeLabelToFileType(linkHtmlProps.type);\n            const bIsSameDiagramPlugin = pluginFileType === linkFileType;\n            const bOpenDiagramInNewTab = this.platformUtils.isCloudApp() && !bIsSameDiagramPlugin;\n            switch (linkHtmlProps.type) {\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN:\n                    if (configValues.showBpmnInTab) {\n                        this.linkPreviewService.openLink(linkHtmlProps.url);\n                    }\n                    else if (bOpenDiagramInNewTab && linkXmlProps.pageId) {\n                        const targetPageUrl = _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_4__/* .getUrlConfluencePage */ .PI(linkXmlProps.pageId);\n                        this.linkPreviewService.openLink(targetPageUrl);\n                    }\n                    else {\n                        yield this.linkPreviewService.prepareAndOpenDiagramPreviewDialog(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.BPMN */ .W.BPMN, linkXmlProps, linkHtmlProps, vbcpEntId, pageId, editable, $canvas);\n                    }\n                    break;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN_ENTERPRISE */ .Iu.DMN_ENTERPRISE:\n                    if (configValues.showDmnInTab) {\n                        this.linkPreviewService.openLink(linkHtmlProps.url);\n                    }\n                    else if (bOpenDiagramInNewTab && linkXmlProps.pageId) {\n                        const targetPageUrl = _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_4__/* .getUrlConfluencePage */ .PI(linkXmlProps.pageId);\n                        this.linkPreviewService.openLink(targetPageUrl);\n                    }\n                    else {\n                        yield this.linkPreviewService.prepareAndOpenDiagramPreviewDialog(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.DMN */ .W.DMN, linkXmlProps, linkHtmlProps, vbcpEntId, pageId, editable, $canvas);\n                    }\n                    break;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN:\n                    if (configValues.showDmnInTab) {\n                        this.linkPreviewService.openLink(linkHtmlProps.url);\n                    }\n                    else if (bOpenDiagramInNewTab && linkXmlProps.pageId) {\n                        const targetPageUrl = _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_4__/* .getUrlConfluencePage */ .PI(linkXmlProps.pageId);\n                        this.linkPreviewService.openLink(targetPageUrl);\n                    }\n                    else {\n                        yield this.linkPreviewService.prepareAndOpenDmnFreeDiagramPreviewDialog(linkXmlProps, _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.DMN */ .W.DMN, $canvas);\n                    }\n                    break;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.JIRA_ISSUE */ .Iu.JIRA_ISSUE:\n                    if (configValues.showJiraIssuesInTab) {\n                        this.linkPreviewService.openLink(linkHtmlProps.url);\n                    }\n                    else {\n                        yield this.linkPreviewService.openAndInitJiraIssuePreviewDialog($parentToAppendDialog, linkXmlProps);\n                    }\n                    break;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.CONFLUENCE_ATTACHMENT */ .Iu.CONFLUENCE_ATTACHMENT:\n                    const isPreviewPossible = this.linkPreviewService.getLinkPreviewType(linkHtmlProps.title) !== _model_enum_link_preview_type_enum__WEBPACK_IMPORTED_MODULE_7__/* .LinkPreviewTypeEnum.OTHER */ .d.OTHER;\n                    if (configValues.showAttachmentsInTab || !isPreviewPossible) {\n                        this.linkPreviewService.openLink(linkHtmlProps.url);\n                    }\n                    else {\n                        yield this.linkPreviewService.openConfluenceAttachmentPreviewDialog($parentToAppendDialog, linkHtmlProps.title, linkHtmlProps.url);\n                    }\n                    break;\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.CONFLUENCE_PAGE */ .Iu.CONFLUENCE_PAGE:\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.EXTERNAL_CONTENT */ .Iu.EXTERNAL_CONTENT:\n                    let sameTab = false;\n                    if (this.platformUtils.getAppType() !== _model_enum_app_type_enum__WEBPACK_IMPORTED_MODULE_9__/* .AppTypeEnum.CLOUD_ENTERPRISE */ .K.CLOUD_ENTERPRISE &&\n                        this.currentAppMode === _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_2__/* .AppModeEnum.VIEWER */ .v.VIEWER &&\n                        linkHtmlProps.url.includes(this.platformUtils.buildConfluenceBaseUrl())) {\n                        const url = `${this.platformUtils.buildConfluenceBaseUrl()}/rest/api/content/${pageId}`;\n                        let pageName = "";\n                        try {\n                            const response = yield this.platformUtils.makeRequest({\n                                url,\n                                type: "GET",\n                            });\n                            pageName = response.title;\n                        }\n                        catch (e) {\n                        }\n                        sameTab =\n                            linkHtmlProps.url.includes(`viewpage.action?pageId=${pageId}`) ||\n                                (linkHtmlProps.url.includes("/display/") && linkHtmlProps.url.includes(pageName) && pageName.length > 0);\n                    }\n                    this.linkPreviewService.openLink(linkHtmlProps.url, sameTab);\n                    break;\n                default:\n                    this.linkPreviewService.openLink(linkHtmlProps.url);\n                    break;\n            }\n        });\n    }\n    getHtmlPropsOfLink(linkXmlProps) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.textLinkUnavailable = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.link-unavailable.title");\n            linkXmlProps = yield this.legacyLinkHandler.updateLinkToNewFormat(linkXmlProps);\n            switch (linkXmlProps.$type) {\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.BPMN */ .ws.BPMN:\n                    return yield this.getHtmlPropsOfEnterpriseLink(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.BPMN */ .W.BPMN, linkXmlProps);\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.DMN_ENTERPRISE */ .ws.DMN_ENTERPRISE:\n                    return yield this.getHtmlPropsOfEnterpriseLink(_model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .FileTypeEnum.DMN */ .W.DMN, linkXmlProps);\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.DMN */ .ws.DMN:\n                    return this.getHtmlPropsOfDmnLink(linkXmlProps);\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.CONFLUENCE_PAGE */ .ws.CONFLUENCE_PAGE:\n                    return yield this.getHtmlPropsOfConfluencePageLink(linkXmlProps);\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.JIRA_ISSUE */ .ws.JIRA_ISSUE:\n                    return yield this.getHtmlPropsOfJiraIssueLink(linkXmlProps);\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.MDF_INSTANCE */ .ws.MDF_INSTANCE:\n                    return yield this.getHtmlPropsOfMdfInstanceLink(linkXmlProps);\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.CONFLUENCE_ATTACHMENT */ .ws.CONFLUENCE_ATTACHMENT:\n                    return this.getHtmlPropsOfAttachmentLink(linkXmlProps);\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.EXTERNAL_CONTENT */ .ws.EXTERNAL_CONTENT:\n                    return this.getHtmlPropsOfExternalLink(linkXmlProps);\n                default:\n                    return this.getDefaultHtmlPropsOfLink(linkXmlProps);\n            }\n        });\n    }\n    getHtmlPropsOfDmnLink(linkXmlProps) {\n        const linkTitle = linkXmlProps.title || this.textLinkUnavailable;\n        let linkUrl = "";\n        if (linkXmlProps.title) {\n            linkUrl = _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_4__/* .getDmnFreeIframeLink */ .nU(linkXmlProps.pageId, linkXmlProps.title, _model_enum_dmn_table_mode_enum__WEBPACK_IMPORTED_MODULE_8__/* .DmnTableModeEnum.VIEWER */ .J.VIEWER);\n        }\n        const htmlProps = {\n            id: linkXmlProps.id,\n            type: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN */ .Iu.DMN,\n            iconClass: this.enumConverterService.convertEnumValue(linkXmlProps.$type, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum */ .eN),\n            desc: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkXmlProps.desc),\n            title: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkTitle),\n            url: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(linkUrl),\n        };\n        return htmlProps;\n    }\n    getHtmlPropsOfEnterpriseLink(fileType, linkXmlProps) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const diagramConfigs = yield this.linkUtilsService.getConfigsOfLinkedXml(fileType, linkXmlProps);\n            const diagramVersion = diagramConfigs.shownAttachmentVersion;\n            const diagramName = diagramConfigs.diagramName;\n            const routingParams = {\n                pageId: linkXmlProps.pageId,\n                vbcpEntId: linkXmlProps.vbcpEntId,\n                appMode: _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_2__/* .AppModeEnum.PRESENTATION */ .v.PRESENTATION,\n                fromMode: _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_3__/* .FromModeEnum.URL */ .p.URL,\n                diagramVersion,\n            };\n            const linkTitle = !!diagramName ? diagramName.concat(fileType) : this.textLinkUnavailable;\n            const linkUrl = yield _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_4__/* .getUrlAppByOverlayType */ .cG(linkXmlProps === null || linkXmlProps === void 0 ? void 0 : linkXmlProps.$type, routingParams);\n            let linkType;\n            switch (linkXmlProps.$type) {\n                case _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum.DMN_ENTERPRISE */ .ws.DMN_ENTERPRISE:\n                    linkType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN_ENTERPRISE */ .Iu.DMN_ENTERPRISE;\n                    break;\n                default:\n                    linkType = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.BPMN */ .Iu.BPMN;\n                    break;\n            }\n            return {\n                id: linkXmlProps.id,\n                type: linkType,\n                iconClass: this.enumConverterService.convertEnumValue(linkXmlProps.$type, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum */ .eN),\n                desc: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkXmlProps.desc),\n                title: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkTitle),\n                url: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(linkUrl),\n                isUnsaved: diagramConfigs.isUnsaved,\n                isMissing: this.checkIfMissing(diagramConfigs),\n            };\n        });\n    }\n    getHtmlPropsOfConfluencePageLink(linkXmlProps) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let linkTitle = this.textLinkUnavailable;\n            try {\n                const page = yield _atlassian_page_service__WEBPACK_IMPORTED_MODULE_5__/* .getPageDataByPageId */ .S4(linkXmlProps.pageId);\n                const pageName = encodeURI(_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(page.title));\n                const pageSpace = _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(page.space.name);\n                linkTitle = !!pageName && !!pageSpace ? `${pageName} (${pageSpace})` : this.textLinkUnavailable;\n            }\n            catch (e) {\n            }\n            const linkUrl = yield _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_4__/* .getUrlConfluencePage */ .PI(linkXmlProps.pageId);\n            return {\n                id: linkXmlProps.id,\n                type: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.CONFLUENCE_PAGE */ .Iu.CONFLUENCE_PAGE,\n                iconClass: this.enumConverterService.convertEnumValue(linkXmlProps.$type, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum */ .eN),\n                desc: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkXmlProps.desc),\n                title: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkTitle),\n                url: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(linkUrl),\n            };\n        });\n    }\n    getHtmlPropsOfJiraIssueLink(linkXmlProps) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const jiraReachable = this.jiraRestService.getJiraInstanceReachable();\n            const jiraInstance = jiraReachable ? yield this.jiraRestService.getLinkedJiraInstance() : undefined;\n            const issue = jiraReachable ? yield this.jiraRestService.getSingleIssueByKey(linkXmlProps.issueKey) : undefined;\n            let linkTitle = `${linkXmlProps.issueKey} ${this.textLinkUnavailable}`;\n            let linkUrl = `${linkXmlProps.url}`;\n            let showAuthenticateJiraWarning = false;\n            if (jiraInstance && jiraInstance.url && issue) {\n                linkTitle = `${issue.key}: ${issue.fields.summary} (${issue.fields.status.name})`;\n                linkUrl = `${jiraInstance.url}/browse/${issue.key}`;\n            }\n            else {\n                showAuthenticateJiraWarning = true;\n            }\n            return {\n                id: linkXmlProps.id,\n                type: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.JIRA_ISSUE */ .Iu.JIRA_ISSUE,\n                iconClass: this.enumConverterService.convertEnumValue(linkXmlProps.$type, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum */ .eN),\n                desc: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkXmlProps.desc),\n                title: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkTitle),\n                url: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(linkUrl),\n                showWarningForType: showAuthenticateJiraWarning,\n            };\n        });\n    }\n    getHtmlPropsOfMdfInstanceLink(linkXmlProps) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!this.managedDataFieldsService) {\n                return {};\n            }\n            if (!linkXmlProps.mdfValueId) {\n                return {\n                    id: linkXmlProps.id,\n                    type: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.MDF_INSTANCE */ .Iu.MDF_INSTANCE,\n                    iconClass: this.enumConverterService.convertEnumValue(linkXmlProps.$type, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum */ .eN),\n                    desc: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkXmlProps.desc),\n                    title: "",\n                    url: "",\n                };\n            }\n            const fieldInstance = yield this.managedDataFieldsService.getFieldInstanceByValueId(linkXmlProps.mdfValueId, true);\n            let title = "";\n            if (fieldInstance) {\n                title = fieldInstance.vcfcpDefinitionName;\n            }\n            else {\n                title = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.attribute-panel.managed-data-fields-tab.no-field-instance-found");\n            }\n            return {\n                id: linkXmlProps.id,\n                type: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.MDF_INSTANCE */ .Iu.MDF_INSTANCE,\n                iconClass: this.enumConverterService.convertEnumValue(linkXmlProps.$type, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum */ .eN),\n                desc: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkXmlProps.desc),\n                title: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(title),\n                url: "",\n            };\n        });\n    }\n    getHtmlPropsOfAttachmentLink(linkXmlProps) {\n        const linkTitle = linkXmlProps.title || this.textLinkUnavailable;\n        const linkUrl = linkXmlProps.url;\n        return {\n            id: linkXmlProps.id,\n            type: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.CONFLUENCE_ATTACHMENT */ .Iu.CONFLUENCE_ATTACHMENT,\n            iconClass: this.enumConverterService.convertEnumValue(linkXmlProps.$type, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum */ .eN),\n            desc: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkXmlProps.desc),\n            title: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkTitle),\n            url: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(linkUrl),\n        };\n    }\n    getHtmlPropsOfExternalLink(linkXmlProps) {\n        const linkTitle = linkXmlProps.title || this.textLinkUnavailable;\n        const linkUrl = linkXmlProps.url;\n        return {\n            id: linkXmlProps.id,\n            type: _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.EXTERNAL_CONTENT */ .Iu.EXTERNAL_CONTENT,\n            iconClass: this.enumConverterService.convertEnumValue(linkXmlProps.$type, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum */ .eN),\n            desc: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkXmlProps.desc),\n            title: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkTitle),\n            url: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(linkUrl),\n        };\n    }\n    getDefaultHtmlPropsOfLink(linkXmlProps) {\n        const linkTitle = linkXmlProps.title || this.textLinkUnavailable;\n        const linkUrl = linkXmlProps.url;\n        return {\n            id: linkXmlProps.id,\n            type: linkXmlProps.type,\n            iconClass: this.enumConverterService.convertEnumValue(linkXmlProps.$type, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeXmlEnum */ .ws, _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeIconClassEnum */ .eN),\n            desc: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkXmlProps.desc),\n            title: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(linkTitle),\n            url: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_10__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(linkUrl),\n        };\n    }\n    checkIfMissing(diagramConfigs) {\n        return !diagramConfigs.shownAttachmentVersion || diagramConfigs.shownAttachmentVersion.length === 0;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/link-properties.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/link-utils.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "f": () => (/* binding */ LinkUtilsService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/file-type.enum.ts");\n/* harmony import */ var _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts");\n/* harmony import */ var _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts");\nif (/^bpmnEnt(Editor|MacroDialog|Viewer)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _atlassian_id_generator_service__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/id-generator.service.ts");\n}\nif (/^bpmnEnt(Editor|MacroDialog|Viewer)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/from-mode.enum.ts");\n/* harmony import */ var _atlassian_page_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/page.service.ts");\n/* harmony import */ var _model_enum_app_type_enum__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-type.enum.ts");\n/* harmony import */ var _model_enum_app_rest_path_enum__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-rest-path.enum.ts");\nif (/^bpmnEnt(Editor|MacroDialog|Viewer)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\nclass LinkUtilsService {\n    constructor(diagramConfigurationService, diagramTemplateService, macroService, attachmentService, enumConverterService) {\n        this.diagramConfigurationService = diagramConfigurationService;\n        this.diagramTemplateService = diagramTemplateService;\n        this.macroService = macroService;\n        this.attachmentService = attachmentService;\n        this.enumConverterService = enumConverterService;\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z((0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_9__/* .getPluginService */ .j)().getPluginName(), "LinkUtilsService");\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_9__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n    }\n    getDiagramParamsFromUrl(url, macroKey, freeMacroKey) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const splitURL = url.split("%2F");\n            const pageId = splitURL[1];\n            const diagramName = splitURL[3].split(".")[0];\n            const diagramNameDecode = decodeURI(diagramName);\n            const diagramNameRegEx = diagramNameDecode.replace(/\\+/g, " ");\n            let vbcpEntId = yield this.macroService.getVbcpEntIdByDiagramName(macroKey, pageId, diagramNameRegEx);\n            let macroId = "";\n            if (!vbcpEntId) {\n                macroId = yield this.macroService.getMacroId(pageId, diagramNameRegEx, "", macroKey, freeMacroKey);\n                if (macroId) {\n                    const vbcpEntIdObject = yield this.diagramConfigurationService.setVbcpEntId(pageId, macroId, macroKey);\n                    vbcpEntId = vbcpEntIdObject.value;\n                }\n            }\n            return {\n                pageId,\n                diagramName: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_7__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(diagramNameRegEx),\n                vbcpEntId,\n                macroId,\n            };\n        });\n    }\n    getDmnFreeParamsFromUrl(url) {\n        const splitURL = url.split("%2F");\n        const pageId = splitURL[1];\n        const diagramName = splitURL[3].split(".")[0];\n        const diagramNameDecode = decodeURI(diagramName);\n        const diagramNameRegEx = diagramNameDecode.replace(/\\+/g, " ");\n        return {\n            tableName: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_7__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(diagramNameRegEx),\n            pageId,\n        };\n    }\n    getConfigsOfLinkedXml(diagramType, linkXmlProps) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const macroKeyForConfigs = this.enumConverterService.convertEnumValue(diagramType, _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FileTypeEnum */ .W, _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .MacroEnterpriseNameEnum */ .ib);\n            let diagramConfigs = yield this.diagramConfigurationService.getDefaultConfigs();\n            try {\n                if (!linkXmlProps.vbcpEntId && linkXmlProps.macroId) {\n                    diagramConfigs = yield this.diagramConfigurationService.getAllConfigsByMacroId(linkXmlProps.pageId, linkXmlProps.macroId, macroKeyForConfigs);\n                    let vbcpEntId = diagramConfigs.vbcpEntId;\n                    if (!vbcpEntId) {\n                        const vbcpEntIdObject = yield this.diagramConfigurationService.setVbcpEntId(linkXmlProps.pageId, linkXmlProps.macroId, macroKeyForConfigs);\n                        vbcpEntId = vbcpEntIdObject.value;\n                    }\n                    linkXmlProps.vbcpEntId = vbcpEntId;\n                }\n                else if (!!linkXmlProps.vbcpEntId) {\n                    diagramConfigs = yield this.diagramConfigurationService.getAllConfigsForXmlType(linkXmlProps.pageId, linkXmlProps.vbcpEntId, macroKeyForConfigs);\n                    if (!diagramConfigs.vbcpEntId) {\n                        const editorContent = yield this.platformUtils.getConfluenceEditorContent();\n                        diagramConfigs = yield this.diagramConfigurationService.parseAllFromHtmlContentByVbcpEntId(editorContent, macroKeyForConfigs, linkXmlProps.vbcpEntId);\n                        diagramConfigs.isUnsaved = true;\n                    }\n                }\n                return diagramConfigs;\n            }\n            catch (error) {\n                return this.diagramConfigurationService.getDefaultConfigs();\n            }\n        });\n    }\n    getVbcpEntIdAndUpdateLink(curLink, element, languageService) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const diagramType = curLink.$type === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .OverlayTypeXmlEnum.DMN */ .ws.DMN || curLink.$type === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_2__/* .OverlayTypeXmlEnum.DMN_ENTERPRISE */ .ws.DMN_ENTERPRISE ? _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FileTypeEnum.DMN */ .W.DMN : _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FileTypeEnum.BPMN */ .W.BPMN;\n                const diagramConfigs = yield this.getConfigsOfLinkedXml(diagramType, curLink);\n                if (diagramConfigs.vbcpEntId) {\n                    curLink.vbcpEntId = diagramConfigs.vbcpEntId;\n                }\n                languageService.updateProperties(element, {});\n            }\n            catch (error) {\n                return "";\n            }\n        });\n    }\n    createAndAppendNewDiagram(languageService, sourcePageId, fromMode, macroName, diagramName, targetPageId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const newDiagramInfo = yield this.createNewDiagram(languageService, macroName, diagramName, targetPageId);\n            if (!newDiagramInfo) {\n                return null;\n            }\n            if (this.platformUtils.getAppType() !== _model_enum_app_type_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppTypeEnum.CLOUD_ENTERPRISE */ .K.CLOUD_ENTERPRISE && targetPageId === sourcePageId && fromMode === _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_3__/* .FromModeEnum.CONFLUENCE_EDITOR */ .p.CONFLUENCE_EDITOR) {\n                const newMacroInstanceEditorInlineFormat = yield this.macroService.createEditorInlineFormatString(macroName, newDiagramInfo.configValues);\n                if (!(yield this.platformUtils.appendContentToConfluenceEditor(newMacroInstanceEditorInlineFormat))) {\n                    const error = { sourcePageId, fromMode, diagramName, targetPageId, newMacroInstanceEditorInlineFormat };\n                    this.vxcpLogger.logError("appendContentToConfluenceEditor", `Could not append macro for ${diagramName} to confluence-editor.`, error);\n                    return null;\n                }\n                return Object.assign(Object.assign({}, newDiagramInfo), { isUnsaved: true });\n            }\n            const newMacroInstanceStorageFormat = yield this.macroService.createStorageFormatString(macroName, newDiagramInfo.configValues);\n            const appendResult = yield _atlassian_page_service__WEBPACK_IMPORTED_MODULE_4__/* .appendContentToPage */ .mC(targetPageId, newMacroInstanceStorageFormat);\n            if (!appendResult) {\n                const error = { sourcePageId, fromMode, diagramName, targetPageId, newMacroInstanceStorageFormat };\n                this.vxcpLogger.logError("appendContentToPage", `Could not append macro for ${diagramName} to page ${targetPageId}.`, error);\n                return null;\n            }\n            return Object.assign(Object.assign({}, newDiagramInfo), { isUnsaved: false });\n        });\n    }\n    createNewDiagram(languageService, macroName, diagramName, pageId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const pluginType = this.enumConverterService.convertEnumValue(macroName, _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .MacroEnterpriseNameEnum */ .ib, _model_enum_app_rest_path_enum__WEBPACK_IMPORTED_MODULE_6__/* .EnterpriseRestPathEnum */ .wF);\n            const defaultConfigValues = yield this.diagramConfigurationService.createDefaultConfigs(pageId, pluginType);\n            const configValues = Object.assign({}, defaultConfigValues);\n            configValues.diagramName = diagramName;\n            configValues.vbcpEntId = (0,_atlassian_id_generator_service__WEBPACK_IMPORTED_MODULE_10__/* .generateVbcpEntId */ .Z)();\n            const savedAttachments = yield this.uploadDiagramToConfluence(languageService, macroName, diagramName, pageId, configValues.vbcpEntId);\n            if (!savedAttachments) {\n                return null;\n            }\n            configValues.attachmentIdBpmn = savedAttachments.raw.id;\n            configValues.shownAttachmentVersion = savedAttachments.raw.version;\n            return {\n                configValues,\n                attachments: savedAttachments,\n            };\n        });\n    }\n    uploadDiagramToConfluence(languageService, macroName, diagramName, pageId, vbcpEntId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const fileType = this.enumConverterService.convertEnumValue(macroName, _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_1__/* .MacroEnterpriseNameEnum */ .ib, _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FileTypeEnum */ .W);\n            const newDiagram = yield this.diagramTemplateService.createDiagram(languageService, diagramName, "default" + fileType);\n            const newDiagramBlob = new Blob([newDiagram]);\n            const savedDiagramAttachment = yield this.uploadDiagramAttachment(diagramName, pageId, vbcpEntId, fileType, newDiagramBlob);\n            if (!savedDiagramAttachment) {\n                return null;\n            }\n            return {\n                raw: savedDiagramAttachment,\n            };\n        });\n    }\n    uploadDiagramAttachment(diagramName, pageId, vbcpEntId, fileType, data) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const fileName = diagramName + fileType;\n            let attachment = null;\n            try {\n                const uploadResponse = yield this.attachmentService.uploadAttachment(data, fileName, pageId, "");\n                if (uploadResponse.results) {\n                    if (uploadResponse.results.length === 0) {\n                        return null;\n                    }\n                    attachment = uploadResponse.results[0];\n                }\n                else if (uploadResponse.id) {\n                    attachment = uploadResponse;\n                }\n                else {\n                    return null;\n                }\n            }\n            catch (uploadAttachmentError) {\n                this.vxcpLogger.logError("uploadDiagramAttachment", `An error occurred while uploading the ${fileType} file to Confluence. The attachment could not be uploaded.`, uploadAttachmentError);\n                uploadAttachmentError.diagramFileType = fileType;\n                throw uploadAttachmentError;\n            }\n            return {\n                id: attachment.id,\n                title: attachment.title,\n                version: attachment.version.number,\n                fileType,\n                downloadUrl: attachment._links.download,\n                previewUrl: attachment._links.webui,\n            };\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/link-utils.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/overlays/overlay-update.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  "V": () => (/* binding */ OverlayUpdateService)\n});\n\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/model-element-type.enum.ts\nvar model_element_type_enum = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/model-element-type.enum.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts\nvar overlay_type_enum = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/overlays/overlay-utils.ts\nvar overlay_utils = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/overlays/overlay-utils.ts");\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/overlays/overlay-creation.service.ts\n\nclass OverlayCreationService {\n    constructor(languageService) {\n        this.iconWidth = 22;\n        this.iconHeight = 22;\n        this.commentsWidth = 22;\n        this.overlays = languageService.getOverlays();\n    }\n    updateOverlaysOfBpmnJs(languageService) {\n        this.overlays = languageService.getOverlays();\n    }\n    add(domElement, identifier, overlayHTML, overlayInformation) {\n        const domElementWidth = Number(`${domElement.width}`);\n        const maximumNumberOfOverlaysPerRow = Math.floor(domElementWidth / this.iconWidth);\n        const row = Math.ceil((overlayInformation.position + 1) / maximumNumberOfOverlaysPerRow);\n        const topPos = row * -this.iconHeight;\n        const rowCorrectedPosition = overlayInformation.position % maximumNumberOfOverlaysPerRow;\n        const rightPos = this.iconWidth + this.iconWidth * rowCorrectedPosition + this.commentsWidth;\n        this.overlays.add(domElement, identifier, {\n            position: {\n                top: topPos,\n                right: rightPos,\n            },\n            show: {\n                minZoom: 0,\n                maxZoom: 5.0,\n            },\n            html: overlayHTML,\n        });\n    }\n    remove(domElement, overlayTypeLabel) {\n        const overlayIdentifier = overlayTypeLabel ? overlay_utils/* getIdentifierForLinkOverlay */.c(overlayTypeLabel) : "";\n        this.overlays.remove({\n            element: domElement.id,\n            type: overlayIdentifier,\n        });\n    }\n}\n\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/panel-utils.service.ts\nvar panel_utils_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/panel-utils.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/file-type.enum.ts\nvar file_type_enum = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/file-type.enum.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts\nvar utils = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model-language/empty-language.service.ts\nvar empty_language_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/empty-language.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/link-html-factory.service.ts\nvar link_html_factory_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/link-html-factory.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts\nvar plugin_specific_factory = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts\nvar sanitizer_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\n// EXTERNAL MODULE: ../../../../../../core/vxcp-logger/src/vxcp-logger.ts\nvar vxcp_logger = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/overlays/overlay-update.service.ts\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\nconst OVERLAY_HOVERTEXT_DOCUMENTATION_MAX_LENGTH = 1000;\nclass OverlayUpdateService {\n    constructor(xmlExtensionService, enumConverterService, linkPropertiesService, legacyLinkHandler, macroService) {\n        this.xmlExtensionService = xmlExtensionService;\n        this.enumConverterService = enumConverterService;\n        this.linkPropertiesService = linkPropertiesService;\n        this.legacyLinkHandler = legacyLinkHandler;\n        this.macroService = macroService;\n        this.platformUtils = (0,plugin_specific_factory/* getPlatformService */.km)().getPlatformUtils() || {};\n        this.vxcpLogger = new vxcp_logger/* default */.Z((0,plugin_specific_factory/* getPluginService */.j)().getPluginName(), "OverlayUpdateService");\n        this.OVERLAY_ORDER = [\n            overlay_type_enum/* DistinctOverlayType.DOCUMENTATION */.aK.DOCUMENTATION,\n            overlay_type_enum/* DistinctOverlayType.BPMN */.aK.BPMN,\n            overlay_type_enum/* DistinctOverlayType.DMN */.aK.DMN,\n            overlay_type_enum/* DistinctOverlayType.CONFLUENCE_PAGE */.aK.CONFLUENCE_PAGE,\n            overlay_type_enum/* DistinctOverlayType.CONFLUENCE_ATTACHMENT */.aK.CONFLUENCE_ATTACHMENT,\n            overlay_type_enum/* DistinctOverlayType.EXTERNAL_CONTENT */.aK.EXTERNAL_CONTENT,\n            overlay_type_enum/* DistinctOverlayType.JIRA_ISSUE */.aK.JIRA_ISSUE,\n            overlay_type_enum/* DistinctOverlayType.MDF_INSTANCE */.aK.MDF_INSTANCE,\n        ];\n        this.languageService = new empty_language_service/* EmptyLanguageService */.l();\n        this.overlayCreationService = new OverlayCreationService(this.languageService);\n        this.configValues = {};\n        this.$canvas = $();\n        this.panelId = "";\n        this.panelWrapperId = "";\n        this.panelToggleId = "";\n        this.pageId = "";\n        this.vbcpEntId = "";\n        this.isModelerMode = false;\n        this.linkHtmlFactory = new link_html_factory_service/* LinkHtmlFactory */.E(this.enumConverterService);\n    }\n    initOverlayUpdateService(configValues, elementRegistry, $canvas, panelId, panelWrapperId, panelToggleId, pageId, languageService, vbcpEntId, isModelerMode) {\n        this.overlayCreationService = new OverlayCreationService(languageService);\n        this.configValues = configValues;\n        this.elementRegistry = elementRegistry;\n        this.$canvas = $canvas;\n        this.panelId = panelId;\n        this.panelWrapperId = panelWrapperId;\n        this.panelToggleId = panelToggleId;\n        this.pageId = pageId;\n        this.languageService = languageService;\n        this.vbcpEntId = vbcpEntId;\n        this.isModelerMode = isModelerMode;\n    }\n    updateLanguageService(languageService) {\n        this.languageService = languageService;\n        this.overlayCreationService.updateOverlaysOfBpmnJs(languageService);\n    }\n    setAllLinkConfigValues(configValues) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.configValues = configValues;\n            this.configValues.showAnyLinks = this.computeShowAnyLinks(this.configValues);\n            yield this.updateOverlays();\n            return this.configValues;\n        });\n    }\n    computeShowAnyLinks(configValues) {\n        return (configValues.showBpmnLinks ||\n            configValues.showDmnLinks ||\n            configValues.showConfluencePageLinks ||\n            configValues.showConfluenceAttachmentLinks ||\n            configValues.showExternalContentLinks ||\n            configValues.showDocumentation ||\n            configValues.showJiraIssueLinks ||\n            configValues.showMdfInstanceLinks);\n    }\n    toggleAllLinkOverlays() {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.configValues.showAnyLinks = !this.computeShowAnyLinks(this.configValues);\n            this.configValues.showBpmnLinks = this.configValues.showAnyLinks;\n            this.configValues.showDmnLinks = this.configValues.showAnyLinks;\n            this.configValues.showConfluencePageLinks = this.configValues.showAnyLinks;\n            this.configValues.showConfluenceAttachmentLinks = this.configValues.showAnyLinks;\n            this.configValues.showExternalContentLinks = this.configValues.showAnyLinks;\n            this.configValues.showDocumentation = this.configValues.showAnyLinks;\n            this.configValues.showJiraIssueLinks = this.configValues.showAnyLinks;\n            this.configValues.showMdfInstanceLinks = this.configValues.showAnyLinks;\n            yield this.updateOverlays();\n            return this.configValues;\n        });\n    }\n    updateOverlays(domElement) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!this.$canvas || this.$canvas.is(":hidden")) {\n                return;\n            }\n            if (!domElement) {\n                const allElements = this.elementRegistry.getAll();\n                allElements.forEach((element) => {\n                    this.updateOverlays(element).catch((error) => this.vxcpLogger.logWarning("updateOverlays", error));\n                });\n                return;\n            }\n            const businessObject = domElement.businessObject;\n            if (!businessObject || domElement.type === "label" || domElement.type === model_element_type_enum/* BpmnElementTypeEnum.PROCESS */.o.PROCESS || domElement.type === model_element_type_enum/* DmnElementTypeEnum.DEFINITIONS */.Q.DEFINITIONS) {\n                return;\n            }\n            const allLinksOrderedByType = this.xmlExtensionService.getAllLinkExtensions(businessObject, true);\n            yield (0,utils.asyncForEach)(allLinksOrderedByType, (link) => __awaiter(this, void 0, void 0, function* () {\n                if (link.$type === overlay_type_enum/* OverlayTypeXmlEnum.DMN */.ws.DMN && link.type === overlay_type_enum/* OverlayTypeLabelEnum.DMN */.Iu.DMN) {\n                    const isFreeMacro = yield this.macroService.isFreeDiagram(file_type_enum/* FileTypeEnum.DMN */.W.DMN, link.pageId, link.title);\n                    if (!isFreeMacro) {\n                        link = yield this.legacyLinkHandler.updateDmnFreeToDmnEnterpriseLink(link);\n                    }\n                }\n                return this.legacyLinkHandler.updateLinkToNewFormat(link);\n            }));\n            const linkOverlaysInfo = yield this.generateOverlaysInformation(allLinksOrderedByType, domElement);\n            this.updateAllEmbeddedCommentsOverlay();\n            const overlayUpdateResults = yield Promise.allSettled(linkOverlaysInfo.map((overlayInfo) => this.updateOverlay(domElement, overlayInfo)));\n            const overlayUpdateInformations = overlayUpdateResults.filter((result) => result.status === "fulfilled").map((result) => result.value);\n            setTimeout(() => this.postProcessOverlays(allLinksOrderedByType, overlayUpdateInformations));\n        });\n    }\n    getTargetForOverlayClickHandler(allLinks, overlayType, domElement) {\n        const overlayXMLTypes = [this.enumConverterService.convertEnumValue(overlayType, overlay_type_enum/* DistinctOverlayType */.aK, overlay_type_enum/* OverlayTypeXmlEnum */.ws)];\n        if (overlayType === overlay_type_enum/* DistinctOverlayType.DMN */.aK.DMN) {\n            overlayXMLTypes.push(overlay_type_enum/* OverlayTypeXmlEnum.DMN_ENTERPRISE */.ws.DMN_ENTERPRISE);\n        }\n        const linksOfType = allLinks.filter((link) => {\n            return overlayXMLTypes.includes(link.$type);\n        });\n        if (linksOfType.length === 0) {\n            return overlay_type_enum/* OverlayDefaultAction.WONT_DRAW */.s1.WONT_DRAW;\n        }\n        const showOverlayConfigKey = this.enumConverterService.convertEnumValue(overlayType, overlay_type_enum/* DistinctOverlayType */.aK, overlay_type_enum/* OverlayTypeConfigKeyEnum */._9);\n        const showOverlay = this.configValues[showOverlayConfigKey];\n        if (!showOverlay) {\n            return overlay_type_enum/* OverlayDefaultAction.WONT_DRAW */.s1.WONT_DRAW;\n        }\n        if (domElement.layer && domElement.layer.startsWith("root-")) {\n            return overlay_type_enum/* OverlayDefaultAction.WONT_DRAW */.s1.WONT_DRAW;\n        }\n        if (overlayType === overlay_type_enum/* DistinctOverlayType.MDF_INSTANCE */.aK.MDF_INSTANCE || overlayType === overlay_type_enum/* DistinctOverlayType.DOCUMENTATION */.aK.DOCUMENTATION) {\n            return overlay_type_enum/* OverlayDefaultAction.OPEN_PANEL */.s1.OPEN_PANEL;\n        }\n        if (linksOfType.length > 1) {\n            return overlay_type_enum/* OverlayDefaultAction.OPEN_PANEL */.s1.OPEN_PANEL;\n        }\n        if (linksOfType.length === 1) {\n            return linksOfType[0];\n        }\n    }\n    generateOverlaysInformation(allLinks, domElement) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const clickTargets = [];\n            Object.values(overlay_type_enum/* DistinctOverlayType */.aK).forEach((overlayType) => {\n                const targetInfo = {\n                    overlayType,\n                    action: this.getTargetForOverlayClickHandler(allLinks, overlayType, domElement),\n                };\n                clickTargets.push(targetInfo);\n            });\n            const getClickTargetForOverlayType = (overlayType) => {\n                return clickTargets.find((item) => item.overlayType === overlayType);\n            };\n            const computePosition = (targetInfo) => {\n                if (!targetInfo) {\n                    return -1;\n                }\n                let intrinsicPosition = -1;\n                if (targetInfo.action === overlay_type_enum/* OverlayDefaultAction.WONT_DRAW */.s1.WONT_DRAW) {\n                    return -1;\n                }\n                intrinsicPosition = this.OVERLAY_ORDER.indexOf(targetInfo.overlayType);\n                const distinctLinksPriorityOrdered = clickTargets.sort((a, b) => {\n                    return this.OVERLAY_ORDER.indexOf(a.overlayType) - this.OVERLAY_ORDER.indexOf(b.overlayType);\n                });\n                const higherPriorityOrderedDistinctList = distinctLinksPriorityOrdered.slice(0, distinctLinksPriorityOrdered.findIndex((a) => a.overlayType === targetInfo.overlayType));\n                const numberOfHigherPrioritizedOverlaysThatAreNotDrawn = higherPriorityOrderedDistinctList.filter((el) => {\n                    return el.action === overlay_type_enum/* OverlayDefaultAction.WONT_DRAW */.s1.WONT_DRAW;\n                }).length;\n                const finalPosition = intrinsicPosition - numberOfHigherPrioritizedOverlaysThatAreNotDrawn;\n                return finalPosition;\n            };\n            const overlaysInformation = [];\n            yield (0,utils.asyncForEach)(Object.values(overlay_type_enum/* DistinctOverlayType */.aK), (overlayType) => __awaiter(this, void 0, void 0, function* () {\n                var _a;\n                const overlayTypeIcon = this.enumConverterService.convertEnumValue(overlayType, overlay_type_enum/* DistinctOverlayType */.aK, overlay_type_enum/* OverlayTypeIconClassEnum */.eN);\n                const overlayInformation = {\n                    overlayId: overlay_utils/* getIdentifierForLinkOverlay */.c(overlayType, domElement.id),\n                    overlayType,\n                    overlayTypeIcon,\n                    showOverlayConfigKey: this.enumConverterService.convertEnumValue(overlayTypeIcon, overlay_type_enum/* OverlayTypeIconClassEnum */.eN, overlay_type_enum/* OverlayTypeConfigKeyEnum */._9),\n                    overlayClickTarget: (_a = getClickTargetForOverlayType(overlayType)) === null || _a === void 0 ? void 0 : _a.action,\n                    position: computePosition(getClickTargetForOverlayType(overlayType)),\n                    initialHoverText: yield this.getHoverTextHeaderForLink(overlayType),\n                };\n                overlaysInformation.push(overlayInformation);\n            }));\n            return overlaysInformation;\n        });\n    }\n    updateAllEmbeddedCommentsOverlay() {\n        const showComments = this.configValues.showEmbeddedComments;\n        const $comments = $(".djs-overlay.djs-overlay-comments");\n        $comments.toggleClass("vxcp-ent-hidden", !showComments);\n        const $toggle = $(".djs-overlay.djs-overlay-comment-toggle");\n        $toggle.toggleClass("vxcp-ent-hidden", !showComments);\n    }\n    updateOverlay(domElement, overlayInformation) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const overlayTypeAsLabelEnum = this.enumConverterService.convertEnumValue(overlayInformation.overlayTypeIcon, overlay_type_enum/* OverlayTypeIconClassEnum */.eN, overlay_type_enum/* OverlayTypeLabelEnum */.Iu);\n            const bShowOverlay = this.configValues[overlayInformation.showOverlayConfigKey];\n            if (!bShowOverlay || overlayInformation.position === -1 || overlayInformation.overlayClickTarget === overlay_type_enum/* OverlayDefaultAction.WONT_DRAW */.s1.WONT_DRAW) {\n                this.overlayCreationService.remove(domElement, overlayTypeAsLabelEnum);\n                return {\n                    domElement,\n                    overlayInformation,\n                };\n            }\n            const overlayId = overlay_utils/* getIdentifierForLinkOverlay */.c(overlayInformation.overlayType);\n            const $linkOverlay = this.linkHtmlFactory.createLinkOverlayHtml(domElement.id, overlayInformation.overlayTypeIcon, overlayInformation.initialHoverText);\n            this.overlayCreationService.remove(domElement, overlayTypeAsLabelEnum);\n            this.overlayCreationService.add(domElement, overlayId, $linkOverlay, overlayInformation);\n            yield this.attachSimpleOverlayClickHandler($linkOverlay, domElement, overlayInformation);\n            return {\n                domElement,\n                overlayInformation,\n                $linkOverlay,\n            };\n        });\n    }\n    attachSimpleOverlayClickHandler($linkOverlay, domElement, overlayInformation) {\n        return __awaiter(this, void 0, void 0, function* () {\n            $linkOverlay.off("click");\n            $linkOverlay.on("click", this.getOpenPanelClickHandlerFunction(overlayInformation, domElement));\n            return $linkOverlay;\n        });\n    }\n    shouldAttachComplexClickHandler(overlayInformation, configValues) {\n        const showOverlay = configValues[overlayInformation.showOverlayConfigKey];\n        return (showOverlay &&\n            overlayInformation.overlayTypeIcon !== overlay_type_enum/* OverlayTypeIconClassEnum.MDF_INSTANCE */.eN.MDF_INSTANCE &&\n            overlayInformation.overlayTypeIcon !== overlay_type_enum/* OverlayTypeIconClassEnum.DOCUMENTATION */.eN.DOCUMENTATION &&\n            overlayInformation.overlayClickTarget !== overlay_type_enum/* OverlayDefaultAction.OPEN_PANEL */.s1.OPEN_PANEL);\n    }\n    attachComplexOverlayClickHandlerToLinkOverlay($linkOverlay, overlayInformation) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const linkHtmlProps = yield this.linkPropertiesService.getHtmlPropsOfLink(overlayInformation.overlayClickTarget);\n            $linkOverlay.off("click");\n            $linkOverlay.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.stopPropagation();\n                e.preventDefault();\n                yield this.linkPropertiesService.openLink(linkHtmlProps, overlayInformation.overlayClickTarget, this.configValues, this.vbcpEntId, this.pageId, this.$canvas, this.isModelerMode, this.$canvas);\n            }));\n            return $linkOverlay;\n        });\n    }\n    getOpenPanelClickHandlerFunction(overlayInformation, domElement) {\n        let handlerFunction;\n        if (overlayInformation.overlayTypeIcon === overlay_type_enum/* OverlayTypeIconClassEnum.MDF_INSTANCE */.eN.MDF_INSTANCE) {\n            handlerFunction = (e) => __awaiter(this, void 0, void 0, function* () {\n                e.stopPropagation();\n                e.preventDefault();\n                yield this.showMdfInAttrPanel(domElement);\n            });\n        }\n        else if (overlayInformation.overlayTypeIcon === overlay_type_enum/* OverlayTypeIconClassEnum.DOCUMENTATION */.eN.DOCUMENTATION) {\n            handlerFunction = (e) => __awaiter(this, void 0, void 0, function* () {\n                e.stopPropagation();\n                e.preventDefault();\n                yield this.showDescriptionDocumentationInAttrPanel(domElement);\n            });\n        }\n        else {\n            handlerFunction = (e) => __awaiter(this, void 0, void 0, function* () {\n                e.stopPropagation();\n                e.preventDefault();\n                yield this.showAvailableLinksInAttrPanel(domElement);\n            });\n        }\n        return handlerFunction;\n    }\n    showAvailableLinksInAttrPanel(domElement) {\n        return __awaiter(this, void 0, void 0, function* () {\n            $("#business-attributes-tab-link").trigger("click");\n            yield panel_utils_service/* selectPanel */.hv(this.panelWrapperId, this.panelId, this.$canvas, this.panelToggleId, this.languageService.getEventBus());\n            this.languageService.getSelection().select(domElement);\n            panel_utils_service/* highlightGroup */.b1("elementlinks-group", this.panelId);\n        });\n    }\n    showMdfInAttrPanel(domElement) {\n        return __awaiter(this, void 0, void 0, function* () {\n            $("#managed-data-fields-tab-link").trigger("click");\n            yield panel_utils_service/* selectPanel */.hv(this.panelWrapperId, this.panelId, this.$canvas, this.panelToggleId, this.languageService.getEventBus());\n            this.languageService.getSelection().select(domElement);\n            panel_utils_service/* highlightGroup */.b1("group-managed-data-fields", this.panelId);\n        });\n    }\n    showDescriptionDocumentationInAttrPanel(domElement) {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield panel_utils_service/* selectPanel */.hv(this.panelWrapperId, this.panelId, this.$canvas, this.panelToggleId, this.languageService.getEventBus());\n            this.languageService.getSelection().select(domElement);\n            panel_utils_service/* highlightGroup */.b1("name-and-description-group", this.panelId);\n        });\n    }\n    postProcessOverlays(allLinks, overlaysUpdateInformation) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (allLinks.length === 0) {\n                return;\n            }\n            const linksPerType = this.getLinksPerType(allLinks);\n            if (Object.keys(linksPerType).length === 0) {\n                return;\n            }\n            yield (0,utils.asyncForEach)(overlaysUpdateInformation, (overlayUpdateInformation) => __awaiter(this, void 0, void 0, function* () {\n                const overlayInformation = overlayUpdateInformation.overlayInformation;\n                const overlayType = overlayInformation.overlayType;\n                if (!linksPerType.hasOwnProperty(overlayType)) {\n                    return;\n                }\n                const overlayId = overlayInformation.overlayId;\n                const $linkOverlay = $("#" + overlayId);\n                if ($linkOverlay.length === 0) {\n                    return;\n                }\n                const bShouldAttachComplexClickHandler = this.shouldAttachComplexClickHandler(overlayInformation, this.configValues);\n                if (bShouldAttachComplexClickHandler) {\n                    yield this.attachComplexOverlayClickHandlerToLinkOverlay($linkOverlay, overlayInformation);\n                }\n                const hoverText = yield this.getHoverTextForLinksOfType(overlayType, linksPerType[overlayType]);\n                this.applyHoverTextToLinkOverlay($linkOverlay, hoverText);\n            }));\n        });\n    }\n    applyHoverTextToLinkOverlay($linkOverlay, hoverText) {\n        if (!hoverText || hoverText.length === 0) {\n            $linkOverlay.removeAttr("title");\n            return;\n        }\n        $linkOverlay.attr("title", hoverText);\n    }\n    getLinksPerType(allLinks) {\n        const linksPerType = {};\n        allLinks.forEach((link) => {\n            const linkType = Object.values(overlay_type_enum/* DistinctOverlayType */.aK).find((type) => { var _a; return (_a = link.type) === null || _a === void 0 ? void 0 : _a.includes(type); });\n            if (!linkType) {\n                this.vxcpLogger.logWarning("getLinksPerType", "Unknown linkType: " + link.type);\n                return;\n            }\n            if (!linksPerType.hasOwnProperty(linkType)) {\n                linksPerType[linkType] = [];\n            }\n            linksPerType[linkType].push(link);\n        });\n        return linksPerType;\n    }\n    getHoverTextForLinksOfType(overlayType, linksOfType) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const hoverTextHeader = yield this.getHoverTextHeaderForLink(overlayType);\n            const hoverTextBodyLines = yield (0,utils.asyncMapEach)(linksOfType, (link) => __awaiter(this, void 0, void 0, function* () {\n                const hoverTextBodyLine = yield this.getHoverTextBodyLineForLink(overlayType, link);\n                if (!hoverTextBodyLine) {\n                    return;\n                }\n                return hoverTextBodyLine;\n            })).then((lines) => lines.filter((line) => !!line && line.length > 0));\n            if (hoverTextBodyLines.length === 0) {\n                return hoverTextHeader;\n            }\n            return [hoverTextHeader + ":", ...hoverTextBodyLines].join("\\n");\n        });\n    }\n    getHoverTextHeaderForLink(overlayType) {\n        return __awaiter(this, void 0, void 0, function* () {\n            switch (overlayType) {\n                case overlay_type_enum/* DistinctOverlayType.DOCUMENTATION */.aK.DOCUMENTATION:\n                    return this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.overlays.documentation.tooltip.label");\n                case overlay_type_enum/* DistinctOverlayType.BPMN */.aK.BPMN:\n                    return this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.overlays.bpmn.tooltip.label");\n                case overlay_type_enum/* DistinctOverlayType.DMN */.aK.DMN:\n                    return this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.overlays.dmn.tooltip.label");\n                case overlay_type_enum/* DistinctOverlayType.CONFLUENCE_PAGE */.aK.CONFLUENCE_PAGE:\n                    return this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.overlays.confluence-page.tooltip.label");\n                case overlay_type_enum/* DistinctOverlayType.CONFLUENCE_ATTACHMENT */.aK.CONFLUENCE_ATTACHMENT:\n                    return this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.overlays.attachment.tooltip.label");\n                case overlay_type_enum/* DistinctOverlayType.JIRA_ISSUE */.aK.JIRA_ISSUE:\n                    return this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.overlays.jira-issue.tooltip.label");\n                case overlay_type_enum/* DistinctOverlayType.MDF_INSTANCE */.aK.MDF_INSTANCE:\n                    return this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.overlays.mdf-instance.tooltip.label");\n                case overlay_type_enum/* DistinctOverlayType.EXTERNAL_CONTENT */.aK.EXTERNAL_CONTENT:\n                    return this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.overlays.external-content.tooltip.label");\n            }\n        });\n    }\n    getHoverTextBodyLineForLink(overlayType, link) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const linkHtmlPropsOverlays = yield this.linkPropertiesService.getHtmlPropsOfLink(link);\n            switch (overlayType) {\n                case overlay_type_enum/* DistinctOverlayType.DOCUMENTATION */.aK.DOCUMENTATION:\n                    const sanitizedDesc = linkHtmlPropsOverlays.desc ? sanitizer_service/* SanitizerService.getSanitizedString */.Y.getSanitizedString(linkHtmlPropsOverlays.desc) : null;\n                    if (!sanitizedDesc) {\n                        return;\n                    }\n                    if (sanitizedDesc.length > OVERLAY_HOVERTEXT_DOCUMENTATION_MAX_LENGTH) {\n                        return sanitizedDesc.substring(0, OVERLAY_HOVERTEXT_DOCUMENTATION_MAX_LENGTH) + "...";\n                    }\n                    return sanitizedDesc;\n                case overlay_type_enum/* DistinctOverlayType.BPMN */.aK.BPMN:\n                case overlay_type_enum/* DistinctOverlayType.DMN */.aK.DMN:\n                case overlay_type_enum/* DistinctOverlayType.CONFLUENCE_PAGE */.aK.CONFLUENCE_PAGE:\n                case overlay_type_enum/* DistinctOverlayType.CONFLUENCE_ATTACHMENT */.aK.CONFLUENCE_ATTACHMENT:\n                case overlay_type_enum/* DistinctOverlayType.JIRA_ISSUE */.aK.JIRA_ISSUE:\n                case overlay_type_enum/* DistinctOverlayType.EXTERNAL_CONTENT */.aK.EXTERNAL_CONTENT:\n                    const sanitizedTitle = linkHtmlPropsOverlays.title ? sanitizer_service/* SanitizerService.getSanitizedString */.Y.getSanitizedString(linkHtmlPropsOverlays.title) : null;\n                    if (!sanitizedTitle) {\n                        return;\n                    }\n                    return "- " + decodeURIComponent(sanitizedTitle);\n                case overlay_type_enum/* DistinctOverlayType.MDF_INSTANCE */.aK.MDF_INSTANCE:\n                    break;\n            }\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/overlays/overlay-update.service.ts_+_1_modules?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/overlays/overlay-utils.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "c": () => (/* binding */ getIdentifierForLinkOverlay)\n/* harmony export */ });\n/* harmony import */ var _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts");\n/* harmony import */ var _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\n\n\nfunction getIdentifierForLinkOverlay(overlayType, domElementId) {\n    if (domElementId) {\n        const domElementIdLowerCase = _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_1__/* .SanitizerService.getSanitizedString */ .Y.getSanitizedString(domElementId.toLowerCase());\n        return getIdentifierForLinkOverlay(overlayType) + "-" + domElementIdLowerCase;\n    }\n    if (overlayType === _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum.DMN_ENTERPRISE */ .Iu.DMN_ENTERPRISE) {\n        return getIdentifierForLinkOverlay(_model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .DistinctOverlayType.DMN */ .aK.DMN);\n    }\n    return `vxcp-ent-overlay-link-${overlayType}`;\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/overlays/overlay-utils.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/panel-links.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "a": () => (/* binding */ PanelLinksService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts");\n/* harmony import */ var _model_language_empty_language_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/empty-language.service.ts");\n/* harmony import */ var _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/from-mode.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\nclass PanelLinksService {\n    constructor(linkPropertiesService, xmlExtensionService, linkDialogInitService, managedDataFieldsService) {\n        this.linkPropertiesService = linkPropertiesService;\n        this.xmlExtensionService = xmlExtensionService;\n        this.linkDialogInitService = linkDialogInitService;\n        this.managedDataFieldsService = managedDataFieldsService;\n        this.languageService = new _model_language_empty_language_service__WEBPACK_IMPORTED_MODULE_1__/* .EmptyLanguageService */ .l();\n        this.configValues = {};\n        this.vbcpEntId = "";\n        this.pageId = "";\n        this.fromMode = _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_2__/* .FromModeEnum.URL */ .p.URL;\n    }\n    initPanelLinksService(languageService, $canvas, configValues, vbcpEntId, pageId, fromMode) {\n        this.languageService = languageService;\n        this.$canvas = $canvas;\n        this.configValues = configValues;\n        this.vbcpEntId = vbcpEntId;\n        this.pageId = pageId;\n        this.fromMode = fromMode;\n    }\n    updateConfigValues(configValues) {\n        this.configValues = configValues;\n    }\n    updateElementLinksTable(elementLinks, $tableBody, domElement, editable) {\n        elementLinks.forEach((linkXmlProps) => {\n            if (linkXmlProps.mdfInstanceId && this.managedDataFieldsService) {\n                this.managedDataFieldsService.renderManagedDataFieldsInstance(linkXmlProps, this.languageService);\n                return;\n            }\n            this.linkPropertiesService.buildLinkTableHtml($tableBody, linkXmlProps, editable).then((linkHtmlProps) => {\n                const linkId = linkHtmlProps.id.toLowerCase();\n                const tableRowId = `#elementlink-entry-${linkId}`;\n                const hrefBtnId = `#btn-href-${linkId}`;\n                const editBtnId = `#btn-edit-${linkId}`;\n                const deleteBtnId = `#btn-delete-${linkId}`;\n                const unsavedHintId = `#unsaved-hint-${linkId}`;\n                const missingHintId = `#missing-hint-${linkId}`;\n                const unsavedDiagramsHintId = `#vxcp-ent-att-panel-warning-unsaved-diagrams`;\n                const missingDiagramsHintId = `#vxcp-ent-att-panel-warning-missing-diagrams`;\n                const warningsForTypeId = `#vxcp-ent-att-panel-warning-${linkHtmlProps.type}`;\n                const $tableRow = $(tableRowId);\n                const $table = $tableRow.parents("table.vxcp-ent-att-panel-table");\n                const $hrefBtn = $(hrefBtnId);\n                const $icon = $tableRow.find(".vxcp-ent-overlay-link.vxcp-ent-att-table-icon");\n                const $loading = $(`<aui-spinner size="small">`).hide().insertAfter($icon);\n                if (linkHtmlProps.isMissing) {\n                    $(missingHintId).removeClass("vxcp-ent-hidden");\n                    $(missingDiagramsHintId).removeClass("vxcp-ent-hidden");\n                }\n                else if (linkHtmlProps.isUnsaved) {\n                    $(unsavedHintId).removeClass("vxcp-ent-hidden");\n                    $(unsavedDiagramsHintId).removeClass("vxcp-ent-hidden");\n                }\n                if (linkHtmlProps.showWarningForType) {\n                    $(warningsForTypeId).removeClass("vxcp-ent-hidden");\n                }\n                $hrefBtn.off("click");\n                if (!linkHtmlProps.isUnsaved && !linkHtmlProps.isMissing) {\n                    $hrefBtn.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                        e.stopPropagation();\n                        e.preventDefault();\n                        $icon.hide();\n                        $loading.show();\n                        $table.addClass("loading");\n                        yield this.linkPropertiesService.openLink(linkHtmlProps, linkXmlProps, this.configValues, this.vbcpEntId, this.pageId, this.$canvas, editable, this.$canvas);\n                        $table.removeClass("loading");\n                        $loading.hide();\n                        $icon.show();\n                    }));\n                }\n                else {\n                    $(editBtnId).addClass("vxcp-ent-hidden");\n                    $hrefBtn.removeAttr("href");\n                }\n                if (editable) {\n                    this.initTableActionButtons($tableBody, editBtnId, deleteBtnId, domElement, linkXmlProps, linkHtmlProps);\n                }\n            });\n        });\n    }\n    updateMdfPanel(elementLinks) {\n        if (!this.managedDataFieldsService) {\n            return;\n        }\n        elementLinks.forEach((linkXmlProps) => {\n            if (this.managedDataFieldsService) {\n                this.managedDataFieldsService.renderManagedDataFieldsInstance(linkXmlProps, this.languageService);\n            }\n        });\n    }\n    hideAllWarningsBelowLinkTable() {\n        const warningIds = ["#vxcp-ent-att-panel-warning-unsaved-diagrams", "#vxcp-ent-att-panel-warning-missing-diagrams"];\n        const typeLables = Object.keys(_model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum */ .Iu);\n        typeLables.forEach((typeLabel) => {\n            const type = _model_enum_overlay_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .OverlayTypeLabelEnum */ .Iu[typeLabel];\n            warningIds.push("#vxcp-ent-att-panel-warning-" + type);\n        });\n        warningIds.forEach((id) => $(id).addClass("vxcp-ent-hidden"));\n    }\n    initTableActionButtons($table, editBtnId, deleteBtnId, domElement, linkXmlProps, linkHtmlProps) {\n        const $btnEdit = $table.find(`${editBtnId}`);\n        $btnEdit.off("click");\n        if (this.linkDialogInitService && !linkHtmlProps.isMissing && !linkHtmlProps.isUnsaved) {\n            $btnEdit.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.stopPropagation();\n                e.preventDefault();\n                yield this.linkDialogInitService.openAddOrEditLinkDialog(this.languageService, this.$canvas, this.pageId, this.vbcpEntId, this.fromMode, linkXmlProps, linkHtmlProps);\n            }));\n        }\n        $table\n            .find(`${deleteBtnId}`)\n            .off("click")\n            .on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            e.stopPropagation();\n            e.preventDefault();\n            this.xmlExtensionService.deleteExtensionById(this.languageService, domElement, linkXmlProps.id);\n        }));\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/panel-links.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/preview/link-preview.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "t": () => (/* binding */ LinkPreviewService)\n/* harmony export */ });\n/* harmony import */ var _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/file-type.enum.ts");\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/routing.service.ts");\n/* harmony import */ var _model_enum_link_preview_type_enum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/link-preview-type.enum.ts");\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts");\n/* harmony import */ var _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-mode.enum.ts");\n/* harmony import */ var _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/from-mode.enum.ts");\n/* harmony import */ var _comala_comala_integration_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/comala/comala-integration.service.ts");\n/* harmony import */ var _model_enum_preview_dialog_type_enum__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/preview-dialog-type.enum.ts");\n/* harmony import */ var _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/security/sanitizer.service.ts");\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\n/* harmony import */ var _model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nconst PREVIEW_DIALOG_CLOSE_BUTTON_DELAY = 5000;\nclass LinkPreviewService {\n    constructor(macroService, jiraRestService, previewSamePluginXmlService, previewConfluenceAttachmentService, configurationService, enumConverterService, appMode) {\n        this.macroService = macroService;\n        this.jiraRestService = jiraRestService;\n        this.previewSamePluginXmlService = previewSamePluginXmlService;\n        this.previewConfluenceAttachmentService = previewConfluenceAttachmentService;\n        this.configurationService = configurationService;\n        this.enumConverterService = enumConverterService;\n        this.appMode = appMode;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_11__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.pluginService = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_11__/* .getPluginService */ .j)();\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z(this.pluginService.getPluginName(), "LinkPreviewService");\n        this.comalaIntegrationService = new _comala_comala_integration_service__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z();\n    }\n    prepareAndOpenDiagramPreviewDialog(diagramType, diagramLink, linkHtmlProps, vbcpEntId, pageId, isModelerMode, $canvas) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const linkTitle = linkHtmlProps.title || "";\n            let diagramName = linkTitle.indexOf(diagramType) >= 0 ? linkTitle : "";\n            const fileEndingRegExp = new RegExp(`${diagramType}$`);\n            diagramName = diagramName.replace(fileEndingRegExp, "");\n            const diagramParams = {\n                pageId: diagramLink.pageId || "",\n                diagramName,\n                macroId: diagramLink.macroId || "",\n                vbcpEntId: diagramLink.vbcpEntId || "",\n            };\n            yield this.openDiagramPreviewDialog(diagramType, diagramParams, pageId, vbcpEntId, isModelerMode, $canvas);\n        });\n    }\n    prepareAndOpenDmnFreeDiagramPreviewDialog(linkXmlProps, diagramType, $canvas) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const linkTitle = linkXmlProps.title || "";\n            const dmnTableName = linkTitle.replace(diagramType, "");\n            const linkPageId = linkXmlProps.pageId || "";\n            yield this.openDmnFreePreviewDialog($canvas, dmnTableName, linkPageId);\n        });\n    }\n    openDmnFreePreviewDialog($canvas, dmnTableName, pageId, canEdit = true) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const dialogId = "#vxcp-ent-dialog-show-diagram";\n            const pluginType = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_11__/* .getPluginService */ .j)().getPluginShorthand();\n            const params = {\n                diagramName: dmnTableName,\n                canEdit,\n                projectName: "",\n                branchName: "",\n                showRefresh: true,\n                showPresentation: true,\n                appType: this.platformUtils.getAppType(),\n                pluginType,\n            };\n            this.platformUtils.removeDjsHelperSvg();\n            const showDmnDiagramDialog = yield this.platformUtils.getTemplate(_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_10__/* .TemplateNamesEnum.SHOW_DIAGRAM_DIALOG */ .X.SHOW_DIAGRAM_DIALOG, params);\n            $canvas.append(showDmnDiagramDialog);\n            _utils_utils__WEBPACK_IMPORTED_MODULE_1__.initDmnFreePreviewDialogBtns(dialogId, pageId, dmnTableName);\n            this.platformUtils.showDialog(dialogId);\n            const iframe = _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_2__/* .createDmnFreeIFrame */ .eb(pageId, dmnTableName);\n            const $dialogCanvas = $("#vxcp-ent-viewer-dialog-canvas-id");\n            $dialogCanvas.removeClass("vxcp-ent-viewer-dialog-canvas");\n            $dialogCanvas.addClass("vxcp-ent-viewer-dmn-dialog-canvas");\n            $dialogCanvas.append(iframe);\n        });\n    }\n    openSameDiagramPreviewDialog(diagramType, diagramParams, pageId, vbcpEntId, isModelerMode) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!(yield this.macroService.checkIfMacroExists(diagramParams.diagramName, diagramParams.pageId))) {\n                return;\n            }\n            const dialogId = "#vxcp-ent-dialog-show-diagram";\n            this.platformUtils.removeDjsHelperSvg();\n            const canEdit = (isModelerMode || $("#vxcp-ent-toolbar-viewer-edit").length);\n            const pluginType = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_11__/* .getPluginService */ .j)().getPluginShorthand();\n            const showDiagramDialogTemplateParams = {\n                diagramName: diagramParams.diagramName,\n                canEdit,\n                projectName: "",\n                branchName: "",\n                showRefresh: true,\n                showPresentation: true,\n                appType: this.platformUtils.getAppType(),\n                pluginType,\n            };\n            const showDiagramDialog = yield this.platformUtils.getTemplate(_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_10__/* .TemplateNamesEnum.SHOW_DIAGRAM_DIALOG */ .X.SHOW_DIAGRAM_DIALOG, showDiagramDialogTemplateParams);\n            if (this.appMode === _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppModeEnum.VIEWER */ .v.VIEWER && this.platformUtils.isCloudApp()) {\n                const cloudPreviewDialogInitData = {\n                    previewPluginType: this.pluginService.getPluginShorthand(),\n                    previewDialogType: _model_enum_preview_dialog_type_enum__WEBPACK_IMPORTED_MODULE_8__/* .PreviewDialogTypeEnum.DIAGRAM */ .M.DIAGRAM,\n                    htmlContent: showDiagramDialog,\n                    initMethodArgs: [diagramParams],\n                    pageId,\n                    vbcpEntId,\n                };\n                this.platformUtils.createPreviewDialogIframe(cloudPreviewDialogInitData);\n            }\n            else {\n                const $macros = $(".vxcp-ent-content");\n                if ($macros.length > 1) {\n                    const curMacro = $(`#vxcp-ent-viewer-${pageId}-${vbcpEntId}`);\n                    curMacro.append(showDiagramDialog);\n                }\n                else {\n                    $macros.append(showDiagramDialog);\n                }\n                this.platformUtils.showDialog(dialogId);\n                const $dialog = $(dialogId);\n                const $dialogButtons = $dialog.find(".aui-dialog2-header-secondary > .vxcp-ent-dialog-show-diagram-button");\n                $dialogButtons.hide();\n                try {\n                    yield this.previewSamePluginXmlService.init(diagramType, diagramParams.pageId, diagramParams.vbcpEntId, diagramParams.macroId);\n                }\n                catch (e) {\n                    this.vxcpLogger.logError("openSameDiagramPreviewDialog", "Could not initialize preview for same plugin.", e);\n                }\n                $dialogButtons.show();\n                const $closeButton = $dialogButtons.filter(dialogId + "-close");\n                _utils_utils__WEBPACK_IMPORTED_MODULE_1__.initEscKey($dialog, $closeButton);\n            }\n        });\n    }\n    openDiagramPreviewDialog(diagramType, diagramParams, pageId, vbcpEntId, isModelerMode, $canvas) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const sameModelLanguage = this.pluginService.getFileEnding() === diagramType;\n            if (sameModelLanguage) {\n                return this.openSameDiagramPreviewDialog(diagramType, diagramParams, pageId, vbcpEntId, isModelerMode);\n            }\n            return this.openOtherPluginDiagramPreviewDialog(diagramType, diagramParams, isModelerMode, $canvas);\n        });\n    }\n    openOtherPluginDiagramPreviewDialog(diagramType, diagramParams, isModelerMode, $canvas) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const dialogId = "#vxcp-ent-dialog-show-diagram";\n            const macroKey = this.enumConverterService.convertEnumValue(diagramType, _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FileTypeEnum */ .W, _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_4__/* .MacroEnterpriseNameEnum */ .ib);\n            if (!diagramParams.vbcpEntId && diagramParams.macroId) {\n                diagramParams.vbcpEntId = yield this.configurationService.setVbcpEntId(diagramParams.pageId, diagramParams.macroId, macroKey);\n            }\n            const configsOfLinkedDiagram = yield this.configurationService.getAllConfigsForXmlType(diagramParams.pageId, diagramParams.vbcpEntId, macroKey);\n            const canEdit = (isModelerMode || $("#vxcp-ent-toolbar-viewer-edit").length);\n            const pluginType = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_11__/* .getPluginService */ .j)().getPluginShorthand();\n            const showRefreshButton = !this.platformUtils.isCloudApp();\n            const params = {\n                diagramName: diagramParams.diagramName,\n                canEdit,\n                projectName: "",\n                branchName: "",\n                showRefresh: showRefreshButton,\n                showPresentation: true,\n                appType: this.platformUtils.getAppType(),\n                pluginType,\n            };\n            this.platformUtils.removeDjsHelperSvg();\n            const showDiagramDialog = yield this.platformUtils.getTemplate(_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_10__/* .TemplateNamesEnum.SHOW_DIAGRAM_DIALOG */ .X.SHOW_DIAGRAM_DIALOG, params);\n            const routingParams = {\n                pageId: diagramParams.pageId,\n                vbcpEntId: diagramParams.vbcpEntId,\n                appMode: _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppModeEnum.VIEWER_DIALOG */ .v.VIEWER_DIALOG,\n                fromMode: _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_6__/* .FromModeEnum.URL */ .p.URL,\n            };\n            if (this.appMode === _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppModeEnum.VIEWER */ .v.VIEWER && this.platformUtils.isCloudApp()) {\n                const cloudPreviewDialogInitData = {\n                    previewDialogType: _model_enum_preview_dialog_type_enum__WEBPACK_IMPORTED_MODULE_8__/* .PreviewDialogTypeEnum.DIAGRAM */ .M.DIAGRAM,\n                    previewPluginType: this.pluginService.getPluginShorthandOtherApp(),\n                    htmlContent: showDiagramDialog,\n                    initMethodArgs: [diagramParams],\n                    pageId: diagramParams.pageId,\n                    vbcpEntId: diagramParams.vbcpEntId,\n                };\n                this.platformUtils.createPreviewDialogIframe(cloudPreviewDialogInitData);\n            }\n            else {\n                $canvas.append(showDiagramDialog);\n                this.platformUtils.showDialog(dialogId);\n                const $dialog = $(dialogId);\n                const $dialogButtons = $dialog.find(".aui-dialog2-header-secondary > .vxcp-ent-dialog-show-diagram-button");\n                $dialogButtons.hide();\n                const $closeButton = $dialogButtons.filter(`${dialogId}-close`);\n                this.initOtherPluginDiagramPreviewDialogButtons(diagramType, dialogId, diagramParams, configsOfLinkedDiagram);\n                let iframe;\n                try {\n                    let version = yield this.comalaIntegrationService.getComalaApprovedShownAttachmentVersion(macroKey, routingParams.pageId, diagramParams.vbcpEntId);\n                    if (version < 0 && configsOfLinkedDiagram.shownAttachmentVersion) {\n                        version = parseInt(configsOfLinkedDiagram.shownAttachmentVersion);\n                    }\n                    routingParams.diagramVersion = version.toString();\n                    const viewerUrl = yield _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_2__/* .getUrlPreviewOtherApp */ .CY(routingParams, diagramParams.diagramName);\n                    const bIsHealthy = yield _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_2__/* .isUrlHealthy */ .z2(viewerUrl);\n                    if (!bIsHealthy) {\n                        iframe = yield _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_2__/* .getErrorIframe */ .SE(() => {\n                            $dialogButtons.show();\n                        });\n                        this.vxcpLogger.logWarning("openOtherPluginDiagramPreviewDialog", "URL is not healthy: " + viewerUrl);\n                    }\n                    else {\n                        iframe = yield _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_2__/* .createViewerIFrame */ .hO(viewerUrl, () => {\n                            $dialogButtons.show();\n                        });\n                    }\n                }\n                catch (e) {\n                    iframe = yield _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_2__/* .getErrorIframe */ .SE(() => {\n                        $closeButton.show();\n                    });\n                    this.vxcpLogger.logError("openOtherPluginDiagramPreviewDialog", "Could not init preview for other plugin.", e);\n                }\n                const $dialogCanvas = $("#vxcp-ent-viewer-dialog-canvas-id");\n                $dialogCanvas.append(iframe);\n                setTimeout(() => {\n                    $closeButton.show();\n                }, PREVIEW_DIALOG_CLOSE_BUTTON_DELAY);\n            }\n        });\n    }\n    openConfluenceAttachmentPreviewDialog($canvas, linkTitle, linkUrl) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const dialogId = "#vxcp-ent-dialog-preview-attachment";\n            this.platformUtils.removeDjsHelperSvg();\n            const nextBtnText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.preview-attachment-dialog.next-page");\n            const previousBtnText = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.preview-attachment-dialog.previous-page");\n            const pluginType = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_11__/* .getPluginService */ .j)().getPluginShorthand();\n            const dialogParams = { fileName: linkTitle, nextBtnText, previousBtnText, pluginType };\n            const linkPreviewType = this.getLinkPreviewType(linkTitle);\n            const dialogTemplate = linkPreviewType === _model_enum_link_preview_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .LinkPreviewTypeEnum.IMAGE */ .d.IMAGE ? _model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_10__/* .TemplateNamesEnum.IMAGE_PREVIEW_DIALOG */ .X.IMAGE_PREVIEW_DIALOG : _model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_10__/* .TemplateNamesEnum.PDF_PREVIEW_DIALOG */ .X.PDF_PREVIEW_DIALOG;\n            const previewDialog = yield this.platformUtils.getTemplate(dialogTemplate, dialogParams);\n            const pageIdRegExp = new RegExp("preview=%2F([0-9]+)");\n            const pageIdRegExpMatch = linkUrl.match(pageIdRegExp) || [];\n            const pageId = pageIdRegExpMatch.length > 0 ? pageIdRegExpMatch[1] : "";\n            const downloadUrl = _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_2__/* .buildDownloadAttachmentUrl */ .El(pageId, linkTitle);\n            if (this.appMode === _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppModeEnum.VIEWER */ .v.VIEWER && this.platformUtils.isCloudApp()) {\n                const cloudPreviewDialogInitData = {\n                    previewDialogType: _model_enum_preview_dialog_type_enum__WEBPACK_IMPORTED_MODULE_8__/* .PreviewDialogTypeEnum.ATTACHMENT */ .M.ATTACHMENT,\n                    htmlContent: previewDialog,\n                    initMethodArgs: [downloadUrl, linkUrl, linkPreviewType],\n                    pageId,\n                };\n                this.platformUtils.createPreviewDialogIframe(cloudPreviewDialogInitData);\n            }\n            else {\n                $canvas.append(previewDialog);\n                _utils_utils__WEBPACK_IMPORTED_MODULE_1__.initEscKey($(dialogId), $(dialogId + "-close"));\n                this.platformUtils.showDialog(dialogId);\n                yield this.previewConfluenceAttachmentService.init(downloadUrl, linkUrl, linkPreviewType);\n            }\n        });\n    }\n    openAndInitJiraIssuePreviewDialog($canvas, jiraLinkXmlProps) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const dialogId = "#vxcp-ent-dialog-preview-jira-issue";\n            this.platformUtils.removeDjsHelperSvg();\n            const pluginType = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_11__/* .getPluginService */ .j)().getPluginShorthand();\n            const templateParams = {\n                issueKey: jiraLinkXmlProps.issueKey,\n                issueUrl: _security_sanitizer_service__WEBPACK_IMPORTED_MODULE_9__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(jiraLinkXmlProps.url),\n                pluginType,\n            };\n            const dialogTemplate = yield this.platformUtils.getTemplate(_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_10__/* .TemplateNamesEnum.JIRA_ISSUE_PREVIEW_DIALOG */ .X.JIRA_ISSUE_PREVIEW_DIALOG, templateParams);\n            $canvas.append(dialogTemplate);\n            this.platformUtils.showDialog(dialogId);\n            const $closeBtn = $(`${dialogId}-close`);\n            const $openBtn = $(`${dialogId}-open`);\n            $closeBtn.on("click", (e) => {\n                e.stopPropagation();\n                e.preventDefault();\n                this.platformUtils.hideDialog(dialogId);\n            });\n            $openBtn.on("click", (e) => {\n                e.stopPropagation();\n                e.preventDefault();\n                window.open(jiraLinkXmlProps.url, "_blank");\n            });\n            const $loadingText = $(`${dialogId}-loading`);\n            const $error = $(`${dialogId}-info-error`);\n            const $detailHeader = $(`.vxcp-ent-dialog-preview-jira-issue-info-detail-header`);\n            const jiraInstance = yield this.jiraRestService.getLinkedJiraInstance();\n            if (jiraInstance) {\n                const jiraIssue = yield this.jiraRestService.getSingleIssueByKey(jiraLinkXmlProps.issueKey);\n                if (jiraIssue) {\n                    yield this.initJiraPreviewDialog(dialogId, jiraIssue);\n                    return;\n                }\n            }\n            const jiraIssueInfoError = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.preview-jira-issue.error");\n            $loadingText.hide();\n            $detailHeader.hide();\n            $error.html(jiraIssueInfoError);\n            return;\n        });\n    }\n    initJiraPreviewDialog(dialogId, jiraIssue) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $loadingText = $(`${dialogId}-loading`);\n            const $key = $(`${dialogId}-info-key`);\n            const $status = $(`${dialogId}-info-status`);\n            const $summary = $(`${dialogId}-info-summary`);\n            const $assignee = $(`${dialogId}-info-assignee`);\n            const $typeIcon = $(`${dialogId}-info-type-icon`);\n            const $description = $(`${dialogId}-info-description`);\n            const typeIconUrl = jiraIssue.fields.issuetype.iconUrl;\n            const typeIconHtml = `<img src="${typeIconUrl}"/>`;\n            const keyString = jiraIssue.key;\n            let descriptionString = "";\n            if (jiraIssue.renderedFields) {\n                descriptionString = jiraIssue.renderedFields.description || "";\n            }\n            else {\n                descriptionString = jiraIssue.fields.description || "";\n            }\n            const status = jiraIssue.fields.status;\n            const statusString = status.name;\n            const summaryString = jiraIssue.fields.summary;\n            const assigneeObject = jiraIssue.fields.assignee;\n            let assigneeName = "";\n            if (assigneeObject) {\n                assigneeName = assigneeObject.displayName;\n            }\n            else {\n                assigneeName = " - ";\n            }\n            $loadingText.hide();\n            $typeIcon.html(typeIconHtml);\n            $key.html(` ${keyString}`);\n            $status.append(` ${statusString}`);\n            $summary.append(` ${summaryString}`);\n            $description.append(` ${descriptionString}`);\n            $assignee.append(` ${assigneeName}`);\n        });\n    }\n    getLinkPreviewType(linkTitle) {\n        const linkTitleLowerCase = linkTitle.toLowerCase();\n        let linkPreviewType = _model_enum_link_preview_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .LinkPreviewTypeEnum.OTHER */ .d.OTHER;\n        if (linkTitleLowerCase.includes(".pdf")) {\n            linkPreviewType = _model_enum_link_preview_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .LinkPreviewTypeEnum.PDF */ .d.PDF;\n        }\n        else if (linkTitleLowerCase.includes(".jpg") ||\n            linkTitleLowerCase.includes(".jpeg") ||\n            linkTitleLowerCase.includes(".png") ||\n            linkTitleLowerCase.includes(".svg") ||\n            linkTitleLowerCase.includes(".gif")) {\n            linkPreviewType = _model_enum_link_preview_type_enum__WEBPACK_IMPORTED_MODULE_3__/* .LinkPreviewTypeEnum.IMAGE */ .d.IMAGE;\n        }\n        return linkPreviewType;\n    }\n    openLink(linkUrl, sameTab = false) {\n        if (!linkUrl) {\n            return;\n        }\n        const target = sameTab ? "_self" : "_blank";\n        window.open(_security_sanitizer_service__WEBPACK_IMPORTED_MODULE_9__/* .SanitizerService.sanitizeUrl */ .Y.sanitizeUrl(linkUrl), target);\n    }\n    initOtherPluginDiagramPreviewDialogButtons(diagramType, dialogId, diagramParams, configsOfLinkedDiagram) {\n        $(`${dialogId}-goto-confluence-page`).on("click", () => __awaiter(this, void 0, void 0, function* () {\n            window.open((0,_atlassian_routing_service__WEBPACK_IMPORTED_MODULE_2__/* .getUrlConfluencePage */ .PI)(diagramParams.pageId), "_blank");\n        }));\n        $(`${dialogId}-close`).on("click", (e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            this.platformUtils.hideDialog(dialogId);\n        });\n        (0,_utils_utils__WEBPACK_IMPORTED_MODULE_1__.initEscKey)($(dialogId), $(dialogId + "-close"));\n        $(`${dialogId}-presentation-mode`).on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            e.preventDefault();\n            e.stopPropagation();\n            const routingParams = {\n                pageId: diagramParams.pageId,\n                vbcpEntId: diagramParams.vbcpEntId,\n                appMode: _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppModeEnum.PRESENTATION */ .v.PRESENTATION,\n                fromMode: _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_6__/* .FromModeEnum.URL */ .p.URL,\n            };\n            if (configsOfLinkedDiagram.shownAttachmentVersion) {\n                routingParams.diagramVersion = configsOfLinkedDiagram.shownAttachmentVersion;\n            }\n            const urlPresentationMode = yield (0,_atlassian_routing_service__WEBPACK_IMPORTED_MODULE_2__/* .getUrlAppOtherPlugin */ .gp)(routingParams);\n            window.open(urlPresentationMode, "_blank");\n        }));\n        $(`${dialogId}-editor-mode`).on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            e.stopPropagation();\n            e.preventDefault();\n            const routingParams = {\n                pageId: diagramParams.pageId,\n                vbcpEntId: diagramParams.vbcpEntId,\n                appMode: _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppModeEnum.EDITOR */ .v.EDITOR,\n                fromMode: _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_6__/* .FromModeEnum.URL */ .p.URL,\n            };\n            if (configsOfLinkedDiagram.shownAttachmentVersion) {\n                routingParams.diagramVersion = configsOfLinkedDiagram.shownAttachmentVersion;\n            }\n            const urlEditMode = yield (0,_atlassian_routing_service__WEBPACK_IMPORTED_MODULE_2__/* .getUrlAppOtherPlugin */ .gp)(routingParams);\n            window.open(urlEditMode, "_blank");\n        }));\n        $(`${dialogId}-refresh`).on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n            e.preventDefault();\n            e.stopPropagation();\n            $("#vxcp-ent-viewer-dialog #vxcp-ent-diagram-loading").show();\n            const macroKey = this.enumConverterService.convertEnumValue(diagramType, _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_0__/* .FileTypeEnum */ .W, _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_4__/* .MacroEnterpriseNameEnum */ .ib);\n            const refreshConfigs = yield this.configurationService.getAllConfigsForXmlType(diagramParams.pageId, diagramParams.vbcpEntId, macroKey);\n            const routingParams = {\n                pageId: diagramParams.pageId,\n                vbcpEntId: diagramParams.vbcpEntId,\n                appMode: _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_5__/* .AppModeEnum.VIEWER_DIALOG */ .v.VIEWER_DIALOG,\n                fromMode: _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_6__/* .FromModeEnum.URL */ .p.URL,\n            };\n            if (refreshConfigs.shownAttachmentVersion) {\n                routingParams.diagramVersion = refreshConfigs.shownAttachmentVersion;\n            }\n            const viewerUrl = yield _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_2__/* .getUrlPreviewOtherApp */ .CY(routingParams, diagramParams.diagramName);\n            const iFrame = document.getElementById("vxcp-ent-dialog-preview-diagram-app");\n            if (iFrame) {\n                iFrame.setAttribute("src", viewerUrl);\n            }\n        }));\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/preview/link-preview.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/preview/preview-confluence-attachment.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  "F": () => (/* binding */ PreviewConfluenceAttachmentService)\n});\n\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/routing.service.ts\nvar routing_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/routing.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/link-preview-type.enum.ts\nvar link_preview_type_enum = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/link-preview-type.enum.ts");\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/preview/pdf-viewer.service.ts\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nconst pdfjsLib = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/node_modules/pdfjs-dist/build/pdf.js");\nclass PdfViewerService {\n    constructor() {\n        this.scale = 1.5;\n        this.pdfDoc = null;\n        this.pageNum = 1;\n        this.pageRendering = false;\n        this.pageNumPending = null;\n    }\n    reset() {\n        this.pdfDoc = null;\n        this.scale = 1.5;\n        this.pageNum = 1;\n        this.pageRendering = false;\n        this.pageNumPending = null;\n    }\n    renderPage(num) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.pageRendering = true;\n            const page = yield this.pdfDoc.getPage(num);\n            const viewport = page.getViewport({ scale: this.scale });\n            this.canvas.height = viewport.height;\n            this.canvas.width = viewport.width;\n            const renderContext = {\n                canvasContext: this.ctx,\n                viewport,\n            };\n            const renderTask = page.render(renderContext);\n            yield renderTask.promise;\n            $("#vxcp-ent-dialog-preview-attachment-loading").hide();\n            this.pageRendering = false;\n            if (this.pageNumPending !== null) {\n                yield this.renderPage(this.pageNumPending);\n                this.pageNumPending = null;\n            }\n            document.getElementById("vxcp-ent-dialog-preview-attachment-page-num").textContent = num.toString();\n        });\n    }\n    renderPDF(url) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const loadingTask = pdfjsLib.getDocument(url);\n            const pdf = yield loadingTask.promise;\n            this.pdfDoc = pdf;\n            document.getElementById("vxcp-ent-dialog-preview-attachment-page-count").textContent = pdf.numPages.toString();\n            this.canvas = document.getElementById("vxcp-ent-dialog-preview-attachment-content");\n            this.ctx = this.canvas.getContext("2d");\n            document.getElementById("vxcp-ent-dialog-preview-attachment-previous").addEventListener("click", () => __awaiter(this, void 0, void 0, function* () {\n                yield this.onPrevPage();\n            }));\n            document.getElementById("vxcp-ent-dialog-preview-attachment-next").addEventListener("click", () => __awaiter(this, void 0, void 0, function* () {\n                yield this.onNextPage();\n            }));\n            yield this.renderPage(this.pageNum);\n        });\n    }\n    queueRenderPage(num) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.pageRendering) {\n                this.pageNumPending = num;\n            }\n            else {\n                yield this.renderPage(num);\n            }\n        });\n    }\n    onPrevPage() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.pageNum <= 1) {\n                return;\n            }\n            this.pageNum--;\n            yield this.queueRenderPage(this.pageNum);\n        });\n    }\n    onNextPage() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.pageNum >= this.pdfDoc.numPages) {\n                return;\n            }\n            this.pageNum++;\n            yield this.queueRenderPage(this.pageNum);\n        });\n    }\n}\n\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts\nvar plugin_specific_factory = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/preview/preview-confluence-attachment.service.ts\nvar preview_confluence_attachment_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nclass PreviewConfluenceAttachmentService {\n    constructor() {\n        this.platformUtils = (0,plugin_specific_factory/* getPlatformService */.km)().getPlatformUtils() || {};\n        this.dialogId = "";\n        this.downloadUrl = "";\n        this.previewUrl = "";\n        this.linkPreviewType = link_preview_type_enum/* LinkPreviewTypeEnum.IMAGE */.d.IMAGE;\n        this.dialogId = "#vxcp-ent-dialog-preview-attachment";\n        this.pdfViewerService = new PdfViewerService();\n    }\n    init(downloadUrl, previewUrl, linkPreviewType, dialogIsIframe) {\n        return preview_confluence_attachment_service_awaiter(this, void 0, void 0, function* () {\n            this.$closeBtn = $(`${this.dialogId}-close`);\n            this.$openBtn = $(`${this.dialogId}-open-link`);\n            this.$clickContent = $(`${this.dialogId}-click-content`);\n            this.downloadUrl = downloadUrl;\n            this.previewUrl = previewUrl;\n            this.linkPreviewType = linkPreviewType;\n            yield this.showPreview(this.downloadUrl);\n            this.$clickContent.on("click", (e) => {\n                e.stopPropagation();\n                e.preventDefault();\n                window.open(this.previewUrl, "_blank");\n            });\n            this.$closeBtn.on("click", (e) => {\n                e.stopPropagation();\n                e.preventDefault();\n                this.pdfViewerService.reset();\n                this.platformUtils.hideDialog(this.dialogId, dialogIsIframe);\n            });\n            this.$openBtn.on("click", (e) => preview_confluence_attachment_service_awaiter(this, void 0, void 0, function* () {\n                e.stopPropagation();\n                e.preventDefault();\n                window.open(this.previewUrl, "_blank");\n            }));\n        });\n    }\n    createImagePreviewHtml(url) {\n        return preview_confluence_attachment_service_awaiter(this, void 0, void 0, function* () {\n            return yield routing_service/* createGeneralImageTag */.Sz(url);\n        });\n    }\n    showPreview(url) {\n        return preview_confluence_attachment_service_awaiter(this, void 0, void 0, function* () {\n            const isPdf = this.linkPreviewType === link_preview_type_enum/* LinkPreviewTypeEnum.PDF */.d.PDF;\n            if (isPdf) {\n                yield this.showPdfPreview(url);\n            }\n            else {\n                const html = yield this.createImagePreviewHtml(url);\n                $(`${this.dialogId} #vxcp-ent-dialog-preview-attachment-content`).append(html);\n            }\n        });\n    }\n    showPdfPreview(url) {\n        return preview_confluence_attachment_service_awaiter(this, void 0, void 0, function* () {\n            try {\n                yield this.pdfViewerService.renderPDF(url);\n            }\n            catch (e) {\n                window.open(this.previewUrl, "_blank");\n                this.platformUtils.hideDialog(this.dialogId);\n            }\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/preview/preview-confluence-attachment.service.ts_+_1_modules?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/preview/preview-same-plugin-xml.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "t": () => (/* binding */ PreviewSamePluginXmlService)\n/* harmony export */ });\n/* harmony import */ var _model_language_language_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language.factory.ts");\n/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/utils.ts");\n/* harmony import */ var _viewer_viewer_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/viewer/viewer.service.ts");\n/* harmony import */ var _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/routing.service.ts");\n/* harmony import */ var _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-mode.enum.ts");\n/* harmony import */ var _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/from-mode.enum.ts");\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/file-type.enum.ts");\n/* harmony import */ var _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts");\n/* harmony import */ var _comala_comala_integration_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/comala/comala-integration.service.ts");\nif (/^bpmnEnt(Edito|Viewe)r$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("../../../../../../core/vxcp-logger/src/vxcp-logger.ts");\n}\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass PreviewSamePluginXmlService {\n    constructor(attachmentService, configurationService, messageService, diagramService, enumConverterService) {\n        this.attachmentService = attachmentService;\n        this.configurationService = configurationService;\n        this.messageService = messageService;\n        this.diagramService = diagramService;\n        this.enumConverterService = enumConverterService;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_9__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.pluginService = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_9__/* .getPluginService */ .j)();\n        this.dialogId = "";\n        this.pageId = "";\n        this.vbcpEntId = "";\n        this.macroId = "";\n        this.vxcpLogger = new _core_vxcp_logger_src_vxcp_logger__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z(this.pluginService.getPluginName(), "PreviewBpmnService");\n        this.configValues = this.configurationService.getDefaultConfigs();\n        this.languageService = _model_language_language_factory__WEBPACK_IMPORTED_MODULE_0__/* .getEmptyLanguageService */ .a5();\n        this.comalaIntegrationService = new _comala_comala_integration_service__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z();\n    }\n    init(diagramType, pageId, vbcpEntId, macroId, dialogIsIframe) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.pageId = pageId || _utils_utils__WEBPACK_IMPORTED_MODULE_1__.getQueryParam("pageId");\n            this.vbcpEntId = vbcpEntId;\n            this.macroId = macroId || "";\n            if ($("#vxcp-ent-viewer-dialog").length) {\n                this.$viewer = $("#vxcp-ent-viewer-dialog");\n            }\n            else {\n                this.$viewer = $(`#vxcp-ent-viewer-${this.pageId}-${this.vbcpEntId}`);\n            }\n            if ($("#vxcp-ent-viewer-canvas").length > 0) {\n                this.$canvas = $("#vxcp-ent-viewer-canvas");\n            }\n            else {\n                this.$canvas = $("#vxcp-ent-viewer-dialog-canvas-id");\n            }\n            this.dialogId = "#vxcp-ent-dialog-show-diagram";\n            this.$editBtn = $(`${this.dialogId}-editor-mode`);\n            this.$closeBtn = $(`${this.dialogId}-close`);\n            this.$presentationModeBtn = $(`${this.dialogId}-presentation-mode`);\n            this.$refreshBtn = $(`${this.dialogId}-refresh`);\n            this.$goToConfluencePageBtn = $(`${this.dialogId}-goto-confluence-page`);\n            this.languageService = _model_language_language_factory__WEBPACK_IMPORTED_MODULE_0__/* .getLanguageService */ .Oi(_model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_4__/* .AppModeEnum.VIEWER_DIALOG */ .v.VIEWER_DIALOG, this.$canvas, this.messageService);\n            try {\n                this.configValues = yield this.getConfigsOfDialogDiagram(diagramType);\n            }\n            catch (configError) {\n                const errorText = "REST-Error occurred while getting configs from server.";\n                this.vxcpLogger.logError("init", errorText, configError);\n                yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.showSystemErrorDialog(this.pageId, errorText, configError);\n                return;\n            }\n            const $expander = this.$viewer.closest(".expand-container");\n            $expander.children(".expand-control").on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.stopPropagation();\n                e.preventDefault();\n                _viewer_viewer_service__WEBPACK_IMPORTED_MODULE_2__/* .resizeViewer */ .Ux(this.languageService, this.$viewer, this.configValues);\n            }));\n            const modelerContainerClass = this.pluginService.getModelerContainerClass();\n            this.$refreshBtn.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.stopPropagation();\n                e.preventDefault();\n                this.showLoading();\n                try {\n                    this.configValues = yield this.getConfigsOfDialogDiagram(diagramType);\n                }\n                catch (configError) {\n                    const errorText = "ERROR @PreviewBpmnService.refreshBtnOnClick: REST-Error occurred while getting configs from server.";\n                    this.vxcpLogger.logError("init", "refreshBtnOnClick: REST-Error occurred while getting configs from server.", configError);\n                    yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.showSystemErrorDialog(this.pageId, errorText, configError);\n                    return;\n                }\n                const uniqueAncestorId = this.$viewer.attr("id");\n                const $breadcrumbHelperButton = uniqueAncestorId ? $(`#${uniqueAncestorId} .vxcp-ent-navigation-help-button`) : $(".vxcp-ent-navigation-help-button");\n                $breadcrumbHelperButton.remove();\n                yield this.loadDiagramAndResizeViewer(diagramType);\n            }));\n            this.$closeBtn.on("click", (e) => {\n                e.stopPropagation();\n                e.preventDefault();\n                this.platformUtils.hideDialog(this.dialogId, dialogIsIframe);\n            });\n            this.$presentationModeBtn.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.stopPropagation();\n                e.preventDefault();\n                const routingParams = {\n                    pageId: this.pageId,\n                    vbcpEntId: this.vbcpEntId,\n                    appMode: _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_4__/* .AppModeEnum.PRESENTATION */ .v.PRESENTATION,\n                    fromMode: _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_5__/* .FromModeEnum.URL */ .p.URL,\n                };\n                if (this.configValues.shownAttachmentVersion) {\n                    routingParams.diagramVersion = this.configValues.shownAttachmentVersion;\n                }\n                const urlPresentationMode = yield _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_3__/* .getUrlAppSamePlugin */ .En(routingParams);\n                window.open(urlPresentationMode, "_blank");\n            }));\n            this.$editBtn.on("click", (e) => __awaiter(this, void 0, void 0, function* () {\n                e.stopPropagation();\n                e.preventDefault();\n                const routingParams = {\n                    pageId: this.pageId,\n                    vbcpEntId: this.vbcpEntId,\n                    appMode: _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_4__/* .AppModeEnum.EDITOR */ .v.EDITOR,\n                    fromMode: _model_enum_from_mode_enum__WEBPACK_IMPORTED_MODULE_5__/* .FromModeEnum.URL */ .p.URL,\n                };\n                const urlEditor = yield _atlassian_routing_service__WEBPACK_IMPORTED_MODULE_3__/* .getUrlAppSamePlugin */ .En(routingParams);\n                window.open(urlEditor, "_blank");\n            }));\n            this.$goToConfluencePageBtn.on("click", () => __awaiter(this, void 0, void 0, function* () {\n                window.open((0,_atlassian_routing_service__WEBPACK_IMPORTED_MODULE_3__/* .getUrlConfluencePage */ .PI)(pageId), "_blank");\n            }));\n            this.displayViewer(this.$viewer);\n            yield this.loadDiagramAndResizeViewer(diagramType);\n            const $bjsContainer = $(`#vxcp-ent-viewer-dialog-canvas-id .${modelerContainerClass}`);\n            yield _viewer_viewer_service__WEBPACK_IMPORTED_MODULE_2__/* .createZoomButtons */ .Z9(this.languageService, this.$canvas, $bjsContainer);\n        });\n    }\n    loadDiagramAndResizeViewer(diagramType) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const $loading = this.showLoading();\n            let attachment;\n            const macroKey = this.enumConverterService.convertEnumValue(diagramType, _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_6__/* .FileTypeEnum */ .W, _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_7__/* .MacroEnterpriseNameEnum */ .ib);\n            let version = parseInt(this.configValues.shownAttachmentVersion || "0") || -1;\n            const comalaActive = yield this.comalaIntegrationService.isComalaActive(this.pageId);\n            if (comalaActive) {\n                version = yield this.comalaIntegrationService.getComalaApprovedShownAttachmentVersion(macroKey, this.pageId, this.vbcpEntId);\n            }\n            if (version < 0) {\n                version = 0;\n            }\n            attachment = yield this.attachmentService.loadAttachment(this.configValues.diagramName, diagramType, this.pageId, version);\n            if (attachment && attachment.status && attachment.status === 404 && attachment.attachmentFound) {\n                const warningTitle = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.viewer.linked-version-not-found.title");\n                const warningBody = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.viewer.linked-version-not-found.body");\n                this.messageService.setWarningMessage(warningTitle, warningBody, {\n                    fadeOut: true,\n                    identifier: "#vxcp-ent-modeler-messages",\n                    delay: 7000,\n                });\n            }\n            yield this.diagramService.loadDiagramForPreview(this.languageService, attachment, this.configValues.diagramName, this.pageId, this.configValues, this.dialogId);\n            const configValuesForResizing = Object.assign({}, this.configValues);\n            configValuesForResizing.viewerHeight = "350";\n            _viewer_viewer_service__WEBPACK_IMPORTED_MODULE_2__/* .resizeViewer */ .Ux(this.languageService, this.$viewer, configValuesForResizing);\n            const newDiagramBackgroundColor = this.configValues.diagramBackgroundColor;\n            if (newDiagramBackgroundColor) {\n                this.$canvas[0].style.backgroundColor = newDiagramBackgroundColor;\n            }\n            this.hideLoading($loading);\n            const hoverTextHelpButton = yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.button.hover.subprocess-nav");\n            yield _utils_utils__WEBPACK_IMPORTED_MODULE_1__.initSubprocessNavigation(this.languageService, hoverTextHelpButton, this.$viewer.attr("id"));\n        });\n    }\n    displayViewer($viewer) {\n        $viewer.show();\n    }\n    getConfigsOfDialogDiagram(diagramType) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const macroKey = this.enumConverterService.convertEnumValue(diagramType, _model_enum_file_type_enum__WEBPACK_IMPORTED_MODULE_6__/* .FileTypeEnum */ .W, _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_7__/* .MacroEnterpriseNameEnum */ .ib);\n            if (!this.vbcpEntId && this.macroId) {\n                this.vbcpEntId = yield this.configurationService.setVbcpEntId(this.pageId, this.macroId, macroKey);\n            }\n            return yield this.configurationService.getAllConfigsForXmlType(this.pageId, this.vbcpEntId, macroKey);\n        });\n    }\n    showLoading($loading) {\n        if (!($loading === null || $loading === void 0 ? void 0 : $loading.length)) {\n            $loading = this.$loading;\n        }\n        $loading.show();\n        return $loading;\n    }\n    hideLoading($loading) {\n        if (!($loading === null || $loading === void 0 ? void 0 : $loading.length)) {\n            $loading = this.$loading;\n        }\n        $loading.hide();\n        return $loading;\n    }\n    get $loading() {\n        return $(this.dialogId).find("#vxcp-ent-diagram-loading");\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/preview/preview-same-plugin-xml.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/preview/preview-vcs.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "q": () => (/* binding */ PreviewVcsService)\n/* harmony export */ });\n/* harmony import */ var _viewer_viewer_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/viewer/viewer.service.ts");\n/* harmony import */ var _input_output_diagram_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/input-output/diagram.service.ts");\nif (/^bpmnEnt(Editor|MacroDialog)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _utils_message_service__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/message.service.ts");\n}\n/* harmony import */ var _navbar_version_dropdown_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/navbar/version-dropdown.service.ts");\n/* harmony import */ var _input_output_diagram_version_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/input-output/diagram-version.service.ts");\nif (/^bpmnEnt(Editor|MacroDialog)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _input_output_diagram_state_service__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/input-output/diagram-state.service.ts");\n}\n/* harmony import */ var _input_output_diagram_template_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/input-output/diagram-template.service.ts");\nif (/^bpmnEnt(Editor|MacroDialog)$/.test(__webpack_require__.j)) {\n\t/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n}\n/* harmony import */ var _model_enum_loading_type_enum__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/loading-type.enum.ts");\n/* harmony import */ var _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-mode.enum.ts");\n/* harmony import */ var _model_language_language_factory__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language.factory.ts");\n/* harmony import */ var _model_language_empty_language_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/empty-language.service.ts");\n/* harmony import */ var _utils_spinner_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/spinner.service.ts");\n/* harmony import */ var _model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/template-names.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass PreviewVcsService {\n    constructor(attachmentService, configurationService, aoDiagramLinkService) {\n        this.attachmentService = attachmentService;\n        this.configurationService = configurationService;\n        this.aoDiagramLinkService = aoDiagramLinkService;\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_11__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.messageService = new _utils_message_service__WEBPACK_IMPORTED_MODULE_12__/* .MessageService */ .e();\n        this.versionDropdownService = new _navbar_version_dropdown_service__WEBPACK_IMPORTED_MODULE_2__/* .VersionDropdownService */ .u();\n        this.diagramVersionService = new _input_output_diagram_version_service__WEBPACK_IMPORTED_MODULE_3__/* .DiagramVersionService */ .l();\n        this.diagramTemplateService = new _input_output_diagram_template_service__WEBPACK_IMPORTED_MODULE_4__/* .DiagramTemplateService */ .z();\n        this.diagramStateService = new _input_output_diagram_state_service__WEBPACK_IMPORTED_MODULE_13__/* .DiagramStateService */ .B();\n        this.languageServicePreview = new _model_language_empty_language_service__WEBPACK_IMPORTED_MODULE_8__/* .EmptyLanguageService */ .l();\n        this.diagramService = new _input_output_diagram_service__WEBPACK_IMPORTED_MODULE_1__/* .DiagramService */ .p(this.diagramStateService, this.attachmentService, this.configurationService, this.diagramVersionService, this.diagramTemplateService, this.versionDropdownService, this.messageService, this.aoDiagramLinkService, new _utils_spinner_service__WEBPACK_IMPORTED_MODULE_9__/* .SpinnerService */ .V());\n    }\n    initPreviewDiagram(xml, dialogId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.$viewer = $("#vxcp-ent-viewer-dialog");\n            this.$canvas = $("#vxcp-ent-viewer-dialog-canvas-id");\n            const $closeBtn = $(`${dialogId}-close`);\n            $closeBtn.on("click", (e) => {\n                e.stopPropagation();\n                e.preventDefault();\n                this.platformUtils.hideDialog(dialogId);\n            });\n            this.languageServicePreview = _model_language_language_factory__WEBPACK_IMPORTED_MODULE_7__/* .getLanguageService */ .Oi(_model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_6__/* .AppModeEnum.VIEWER_DIALOG */ .v.VIEWER_DIALOG, this.$canvas, this.messageService);\n            this.configValues = this.configurationService.getDefaultConfigs();\n            try {\n                yield this.diagramService.loadXml(this.languageServicePreview, _model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_6__/* .AppModeEnum.VIEWER_DIALOG */ .v.VIEWER_DIALOG, xml, dialogId, _model_enum_loading_type_enum__WEBPACK_IMPORTED_MODULE_5__/* .LoadingTypeEnum.OPEN_DIAGRAM_IN_VIEWER */ .z.OPEN_DIAGRAM_IN_VIEWER, "", false);\n            }\n            catch (e) {\n                $(dialogId).remove();\n                throw e;\n            }\n            this.displayViewer(this.$viewer);\n            yield this.resizeViewer();\n            const modelerContainerClass = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_11__/* .getPluginService */ .j)().getModelerContainerClass();\n            const $bjsContainer = $(`#vxcp-ent-viewer-dialog-canvas-id .${modelerContainerClass}`);\n            yield _viewer_viewer_service__WEBPACK_IMPORTED_MODULE_0__/* .createZoomButtons */ .Z9(this.languageServicePreview, this.$canvas, $bjsContainer);\n        });\n    }\n    initPreviewDiffer(xmlA, xmlB, versionA, versionB) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const dialogId = "#vxcp-ent-dialog-differ-preview";\n            const $closeBtn = $(`${dialogId}-close`);\n            $closeBtn.on("click", (e) => {\n                e.stopPropagation();\n                e.preventDefault();\n                this.platformUtils.hideDialog(dialogId);\n            });\n            const $canvasWrapper = $("#vxcp-ent-viewer-dialog");\n            const differTemplate = yield this.platformUtils.getTemplate(_model_enum_template_names_enum__WEBPACK_IMPORTED_MODULE_10__/* .TemplateNamesEnum.DIFFER */ .X.DIFFER);\n            $canvasWrapper.append(differTemplate);\n            yield this.initPreviewDiagram(xmlA, dialogId);\n            const differApp = _model_language_language_factory__WEBPACK_IMPORTED_MODULE_7__/* .getDifferComponent */ .Zr();\n            $canvasWrapper[0].style.backgroundColor = "#ffffff";\n            $("#vxcp-ent-differ-diagram-loading").show();\n            const $canvasDiff = $("#vxcp-ent-differ-canvas");\n            this.$canvas.css("width", "50%");\n            const languageServiceDiffer = _model_language_language_factory__WEBPACK_IMPORTED_MODULE_7__/* .getLanguageService */ .Oi(_model_enum_app_mode_enum__WEBPACK_IMPORTED_MODULE_6__/* .AppModeEnum.DIFFER */ .v.DIFFER, $canvasDiff, this.messageService);\n            const changes = yield differApp.getDiffResultChanges(xmlA, xmlB);\n            yield differApp.showDiffer(xmlA, xmlB, versionA, versionB, this.languageServicePreview, languageServiceDiffer, changes, ".vxcp-ent-dialog-color-menu", "#vxcp-ent-viewer-dialog-canvas-id", "vxcp-ent-dialog-differ-preview", "#vxcp-ent-dialog-differ-preview");\n            $("#vxcp-ent-viewer-dialog").height("100%");\n            this.diagramStateService.setCurrentlyShownDiagramVersion(parseInt(versionB.version));\n        });\n    }\n    resizeViewer() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const canvas = this.languageServicePreview.getCanvas();\n            const canvasHidden = !canvas.getSize().height;\n            if (!canvasHidden) {\n                yield this.diagramService.showDiagram(this.languageServicePreview, "");\n            }\n            this.diagramStateService.setDiagramSaved(true);\n            const configValuesForResizing = Object.assign({}, this.configValues);\n            configValuesForResizing.viewerHeight = "400";\n            configValuesForResizing.enableCustomViewerHeight = true;\n            _viewer_viewer_service__WEBPACK_IMPORTED_MODULE_0__/* .resizeViewer */ .Ux(this.languageServicePreview, this.$viewer, configValuesForResizing);\n        });\n    }\n    displayViewer($viewer) {\n        $viewer.show();\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/services/element-links/preview/preview-vcs.service.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/services/help-wizard/help-wizard.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  "n": () => (/* binding */ HelpWizard)\n});\n\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/node_modules/driver.js/dist/driver.min.js\nvar driver_min = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/node_modules/driver.js/dist/driver.min.js");\nvar driver_min_default = /*#__PURE__*/__webpack_require__.n(driver_min);\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts\nvar plugin_specific_factory = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model-language/empty-language.service.ts\nvar empty_language_service = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/empty-language.service.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/help-wizard.enum.ts\nvar help_wizard_enum = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/help-wizard.enum.ts");\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/help-wizard/help-wizard.utils.ts\nvar help_wizard_utils = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/help-wizard/help-wizard.utils.ts");\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/help-wizard/viewer-help-wizard.service.ts\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\nclass ViewerHelpWizardService {\n    constructor() {\n        this.platformUtils = (0,plugin_specific_factory/* getPlatformService */.km)().getPlatformUtils() || {};\n    }\n    getElementsAsArray(htmlElement, includeBpmnJsPanel, canEditPage = false) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const viewerWizardSteps = [];\n            const pluginService = (0,plugin_specific_factory/* getPluginService */.j)();\n            const pluginShorthand = pluginService.getPluginShorthand();\n            const fileExtension = pluginService.getFileEnding().toString();\n            viewerWizardSteps.push({\n                element: htmlElement[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.conf-macro"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.conf-macro", pluginShorthand),\n                    position: "down",\n                },\n            });\n            viewerWizardSteps.push({\n                element: htmlElement.find(".vxcp-ent-diagram-title")[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.diagram-title"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.diagram-title", pluginShorthand),\n                    position: "down",\n                },\n            });\n            viewerWizardSteps.push({\n                element: htmlElement.find(".vxcp-ent-content")[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.viewer"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.viewer"),\n                    position: "down",\n                },\n            });\n            viewerWizardSteps.push({\n                element: htmlElement.find("#vxcp-ent-diagram-name")[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.diagram-name"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.diagram-name"),\n                    position: "left",\n                },\n                prepare: (current) => __awaiter(this, void 0, void 0, function* () {\n                    return true;\n                }),\n                update: (current) => __awaiter(this, void 0, void 0, function* () {\n                    const elementId = current.element.id;\n                    help_wizard_utils/* setBackgroundForHighlightedDiagramName */.kd(elementId);\n                }),\n                clean: (current) => __awaiter(this, void 0, void 0, function* () {\n                    const elementId = current.element.id;\n                    help_wizard_utils/* resetBackgroundForDeselectedHtmlElement */.PS(elementId);\n                    help_wizard_utils/* resetBackgroundColorForDriver */.G9();\n                }),\n            });\n            viewerWizardSteps.push({\n                element: htmlElement.find("#vxcp-ent-diagram-version")[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.viewer-diagram-version"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.viewer-diagram-version"),\n                    position: "left",\n                },\n            });\n            viewerWizardSteps.push({\n                element: htmlElement.find("#vxcp-ent-viewer-btn-download-xml")[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.xml-export"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.xml-export", pluginShorthand, fileExtension),\n                    position: "left",\n                },\n            });\n            viewerWizardSteps.push({\n                element: htmlElement.find("#vxcp-ent-viewer-btn-download-png")[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.png-export"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.png-export", pluginShorthand),\n                    position: "left",\n                },\n            });\n            viewerWizardSteps.push({\n                element: htmlElement.find("#vxcp-ent-viewer-show-links")[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.show-links"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.show-links"),\n                    position: "left",\n                },\n            });\n            viewerWizardSteps.push({\n                element: htmlElement.find("#vxcp-ent-viewer-show-embedded-comments")[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.show-comments"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.show-comments"),\n                    position: "left",\n                },\n            });\n            viewerWizardSteps.push({\n                element: htmlElement.find("#vxcp-ent-viewer-presentation-mode")[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.pres-mode"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.pres-mode"),\n                    position: "left",\n                },\n            });\n            if (canEditPage) {\n                viewerWizardSteps.push({\n                    element: htmlElement.find("#vxcp-ent-toolbar-viewer-edit")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.edit"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.edit"),\n                        position: "left",\n                    },\n                });\n            }\n            return viewerWizardSteps;\n        });\n    }\n}\n\n// EXTERNAL MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts\nvar plugin_type_enum = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts");\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/services/help-wizard/editor-help-wizard.service.ts\nvar editor_help_wizard_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nclass EditorHelpWizardService {\n    constructor() {\n        this.platformUtils = (0,plugin_specific_factory/* getPlatformService */.km)().getPlatformUtils() || {};\n        this.pluginService = (0,plugin_specific_factory/* getPluginService */.j)();\n        this.pluginStandard = this.pluginService.getPluginStandard();\n        this.fileExtension = this.pluginService.getFileEnding().toString();\n        this.pluginShorthand = this.pluginService.getPluginShorthand();\n        this.isServer = !this.platformUtils.isCloudApp();\n        this.isBpmnApp = this.pluginShorthand === plugin_type_enum/* PluginTypeEnum.BPMN */.AQ.BPMN;\n    }\n    getElementsAsArray(htmlElement, includeBpmnJsPanel, canEditPage = true) {\n        return editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n            const introductionStep = yield this.getIntroductionStep(htmlElement);\n            const navbarSteps = yield this.getNavbarSteps(htmlElement);\n            const toolbarStepsAllApps = yield this.getToolbarStepsAllApps(htmlElement);\n            const paletteStepsDmn = yield this.getPaletteStepsDmn(htmlElement);\n            const paletteStepsBpmn = yield this.getPaletteStepsBpmn(htmlElement);\n            const canvasSteps = yield this.getCanvasSteps(htmlElement);\n            const bpmnJsPanelSteps = yield this.getBpmnJsPanelSteps(htmlElement, includeBpmnJsPanel);\n            const attrPanelStepsAllApps = yield this.getAttrPanelStepsAllApps(htmlElement);\n            const attrPanelStepMdf = yield this.getAttrPanelStepMdf(htmlElement);\n            const attrPanelStepOtherExtensions = yield this.getAttrPanelStepOtherExtensions(htmlElement);\n            const allEditorSteps = Array();\n            const menu = $("#main");\n            let allAppsMatrixIdx = 0;\n            if (menu.hasClass("main-without-navbar")) {\n                const steps = this.getStepsWithoutNavbar(paletteStepsBpmn, paletteStepsDmn, canvasSteps, bpmnJsPanelSteps, attrPanelStepsAllApps, attrPanelStepMdf, attrPanelStepOtherExtensions);\n                this.concatArrays(allEditorSteps, steps);\n            }\n            else {\n                this.concatArrays(allEditorSteps, introductionStep);\n                this.concatArrays(allEditorSteps, navbarSteps);\n                this.concatArrays(allEditorSteps, toolbarStepsAllApps[allAppsMatrixIdx]);\n                allAppsMatrixIdx++;\n                if (this.isServer) {\n                    this.concatArrays(allEditorSteps, yield this.getToolbarStepJiraLinks(htmlElement));\n                }\n                this.concatArrays(allEditorSteps, toolbarStepsAllApps[allAppsMatrixIdx]);\n                allAppsMatrixIdx++;\n                if (this.isBpmnApp && this.isServer) {\n                    this.concatArrays(allEditorSteps, yield this.getToolbarStepMdfLinks(htmlElement));\n                }\n                this.concatArrays(allEditorSteps, toolbarStepsAllApps[allAppsMatrixIdx]);\n                allAppsMatrixIdx++;\n                this.concatArrays(allEditorSteps, yield this.getToolbarStepDmnLinks(htmlElement));\n                this.concatArrays(allEditorSteps, toolbarStepsAllApps[allAppsMatrixIdx]);\n                allAppsMatrixIdx++;\n                if (this.isBpmnApp) {\n                    this.concatArrays(allEditorSteps, yield this.getToolbarStepDocumentation(htmlElement));\n                }\n                this.concatArrays(allEditorSteps, toolbarStepsAllApps[allAppsMatrixIdx]);\n                allAppsMatrixIdx++;\n                if (this.isBpmnApp) {\n                    this.concatArrays(allEditorSteps, yield this.getToolbarStepDiffer(htmlElement));\n                }\n                this.concatArrays(allEditorSteps, toolbarStepsAllApps[allAppsMatrixIdx]);\n                allAppsMatrixIdx++;\n                if (this.isBpmnApp) {\n                    this.concatArrays(allEditorSteps, yield this.getToolbarStepTokenSimulation(htmlElement));\n                    this.concatArrays(allEditorSteps, yield this.getToolbarStepBpmnLinter(htmlElement));\n                    if (this.isServer) {\n                        this.concatArrays(allEditorSteps, yield this.getToolbarStepIncomingLinks(htmlElement));\n                    }\n                    this.concatArrays(allEditorSteps, yield this.getToolbarStepResize(htmlElement));\n                }\n                this.concatArrays(allEditorSteps, toolbarStepsAllApps[allAppsMatrixIdx]);\n                allAppsMatrixIdx++;\n                const steps = this.getStepsWithoutNavbar(paletteStepsBpmn, paletteStepsDmn, canvasSteps, bpmnJsPanelSteps, attrPanelStepsAllApps, attrPanelStepMdf, attrPanelStepOtherExtensions);\n                this.concatArrays(allEditorSteps, steps);\n            }\n            return allEditorSteps;\n        });\n    }\n    getAttrPanelStepsAllApps(htmlElement) {\n        return editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n            const attrPanelSteps = [];\n            attrPanelSteps.push({\n                element: htmlElement.find(".vxcp-ent-vbcp-panel-toggle")[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.attr-panel-toggle"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.attr-panel-toggle"),\n                    position: "left",\n                },\n            }, {\n                element: htmlElement.find(".vxcp-ent-panel-wrapper")[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.attr-panel"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.attr-panel"),\n                    position: "left",\n                },\n                prepare: () => editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n                    const $current = $(".vxcp-ent-panel-wrapper");\n                    $current.css("width", "350px");\n                    return true;\n                }),\n                clean: () => editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n                    const $current = $(".vxcp-ent-panel-wrapper");\n                    $current.css("width", "");\n                    return true;\n                }),\n            }, {\n                element: htmlElement.find(".bio-properties-panel-header")[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.panel-header"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.panel-header"),\n                    position: "left",\n                },\n            }, {\n                element: htmlElement.find("#name-and-description-group")[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.panel-group-name-and-description"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.panel-group-name-and-description"),\n                    position: "left",\n                },\n                prepare: () => editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n                    help_wizard_utils/* openPanelGroup */.qp("#name-and-description-group");\n                    return true;\n                }),\n                clean: () => editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n                    help_wizard_utils/* closePanelGroup */.Dw("#name-and-description-group");\n                    return true;\n                }),\n            });\n            if (this.isBpmnApp) {\n                attrPanelSteps.push({\n                    element: htmlElement.find("#color-group")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.panel-color-group"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.panel-color-group"),\n                        position: "left",\n                    },\n                    prepare: () => editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n                        help_wizard_utils/* openPanelGroup */.qp("#color-group");\n                        return true;\n                    }),\n                    clean: () => editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n                        help_wizard_utils/* closePanelGroup */.Dw("#color-group");\n                        return true;\n                    }),\n                });\n            }\n            attrPanelSteps.push({\n                element: htmlElement.find("#elementlinks-group")[0],\n                popover: {\n                    title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.fach-attr-elementlinks"),\n                    description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.fach-attr-elementlinks"),\n                    position: "left",\n                },\n                prepare: () => editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n                    help_wizard_utils/* openPanelGroup */.qp("#elementlinks-group");\n                    return true;\n                }),\n                clean: () => editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n                    help_wizard_utils/* closePanelGroup */.Dw("#elementlinks-group");\n                    return true;\n                }),\n            });\n            return attrPanelSteps;\n        });\n    }\n    getAttrPanelStepMdf(htmlElement) {\n        return editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n            return [\n                {\n                    element: htmlElement.find("#group-managed-data-fields")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.managed-data-fields-group"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.managed-data-fields-group"),\n                        position: "left",\n                    },\n                    prepare: () => editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n                        help_wizard_utils/* openPanelGroup */.qp("#group-managed-data-fields");\n                        return true;\n                    }),\n                    clean: () => editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n                        help_wizard_utils/* closePanelGroup */.Dw("#group-managed-data-fields");\n                        return true;\n                    }),\n                },\n            ];\n        });\n    }\n    getAttrPanelStepOtherExtensions(htmlElement) {\n        return editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n            return [\n                {\n                    element: htmlElement.find("#other-extensions-group")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.tech-attr-ext"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.tech-attr-ext"),\n                        position: "left",\n                    },\n                    prepare: () => editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n                        help_wizard_utils/* openPanelGroup */.qp("#other-extensions-group");\n                        return true;\n                    }),\n                    clean: () => editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n                        help_wizard_utils/* closePanelGroup */.Dw("#other-extensions-group");\n                        return true;\n                    }),\n                },\n            ];\n        });\n    }\n    getBpmnJsPanelSteps(htmlElement, includeBpmnJsPanel) {\n        return editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n            let bpmnJsPanelSteps = [];\n            if (includeBpmnJsPanel) {\n                bpmnJsPanelSteps = [\n                    {\n                        element: htmlElement.find(".vxcp-ent-bpmn-js-panel-toggle")[0],\n                        popover: {\n                            title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.bpmn-js-panel-toggle"),\n                            description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.bpmn-js-panel-toggle"),\n                            position: "left",\n                        },\n                    },\n                ];\n            }\n            return bpmnJsPanelSteps;\n        });\n    }\n    getCanvasSteps(htmlElement) {\n        return editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n            const canvasSteps = [\n                {\n                    element: htmlElement.find("#vxcp-ent-zoom-btn-reset-to-view-port")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.btn-view"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.btn-view"),\n                        position: "left",\n                    },\n                },\n                {\n                    element: htmlElement.find("#vxcp-ent-zoom-btn-reset")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.btn-reset"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.btn-reset"),\n                        position: "left",\n                    },\n                },\n                {\n                    element: htmlElement.find("#vxcp-ent-zoom-btn-in")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.btn-in"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.btn-in"),\n                        position: "left",\n                    },\n                },\n                {\n                    element: htmlElement.find("#vxcp-ent-zoom-btn-out")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.btn-out"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.btn-out"),\n                        position: "left",\n                    },\n                },\n            ];\n            return canvasSteps;\n        });\n    }\n    getPaletteStepsBpmn(htmlElement) {\n        return editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n            return [\n                {\n                    element: htmlElement.find(".djs-palette")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.palette"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.palette", this.pluginStandard),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .bpmn-icon-hand-tool")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.hand-tool"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.hand-tool"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .bpmn-icon-lasso-tool")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.lasso-tool"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.lasso-tool"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .bpmn-icon-space-tool")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.space-tool"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.space-tool"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .bpmn-icon-connection-multi")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.global-connect-tool"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.global-connect-tool"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .bpmn-icon-start-event-none")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.start-event"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.start-event"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .bpmn-icon-intermediate-event-none")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.boundary-event"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.boundary-event"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .bpmn-icon-end-event-none")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.end-event"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.end-event"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .bpmn-icon-gateway-none")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.gateway"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.gateway"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .bpmn-icon-task")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.task"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.task"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .bpmn-icon-subprocess-expanded")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.subprocess"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.subprocess"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .bpmn-icon-data-object")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.data-object"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.data-object"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .bpmn-icon-data-store")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.data-store"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.data-store"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .bpmn-icon-participant")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.pool"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.pool"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .bpmn-icon-group")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.group"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.group"),\n                        position: "right",\n                    },\n                },\n            ];\n        });\n    }\n    getPaletteStepsDmn(htmlElement) {\n        return editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n            const paletteStepsDmn = [\n                {\n                    element: htmlElement.find(".djs-palette")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.palette"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.palette", this.pluginStandard),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .dmn-icon-hand-tool")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.hand-tool"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.hand-tool"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .dmn-icon-lasso-tool")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.lasso-tool"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.lasso-tool"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .dmn-icon-decision")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.dmn-decision"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.dmn-decision"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .dmn-icon-input-data")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.dmn-input-data"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.dmn-input-data"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .dmn-icon-knowledge-source")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.dmn-knowledge-source"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.dmn-knowledge-source"),\n                        position: "right",\n                    },\n                },\n                {\n                    element: htmlElement.find(".djs-palette .dmn-icon-business-knowledge")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.dmn-business-knowledge"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.dmn-business-knowledge"),\n                        position: "right",\n                    },\n                },\n            ];\n            return paletteStepsDmn;\n        });\n    }\n    getToolbarStepMdfLinks(htmlElement) {\n        return editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n            return [\n                {\n                    element: htmlElement.find("#vxcp-ent-toolbar-show-mdf-instance-links")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.mdf-instance-links"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.mdf-instance-links"),\n                        position: "down",\n                    },\n                },\n            ];\n        });\n    }\n    getToolbarStepDocumentation(htmlElement) {\n        return editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n            return [\n                {\n                    element: htmlElement.find("#vxcp-ent-toolbar-show-documentation")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.show-description"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.show-description"),\n                        position: "down",\n                    },\n                },\n            ];\n        });\n    }\n    getToolbarStepJiraLinks(htmlElement) {\n        return editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n            return [\n                {\n                    element: htmlElement.find("#vxcp-ent-toolbar-show-jira-issue-links")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.title.jira-issue-links"),\n                        description: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard.desc.jira-issue-links"),\n                        position: "down",\n                    },\n                },\n            ];\n        });\n    }\n    getToolbarStepDmnLinks(htmlElement) {\n        return editor_help_wizard_service_awaiter(this, void 0, void 0, function* () {\n            return [\n                {\n                    element: htmlElement.find("#vxcp-ent-toolbar-show-dmn-links")[0],\n                    popover: {\n                        title: yield this.platformUtils.getText("de.viadee.confluence.viadee-plugin-enterprise.helpwizard