(()=>{"use strict";var __webpack_modules__={"../../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ VxcpLogger)\n/* harmony export */ });\nclass VxcpLogger {\n    constructor(pluginName, serviceName, isEnabled = true) {\n        this.pluginName = pluginName;\n        this.serviceName = serviceName;\n        this.isEnabled = isEnabled;\n    }\n    logFatal(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`FATAL@${logHeader}: ${description}`);\n        }\n    }\n    logError(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`ERROR@${logHeader}: ${description}`);\n        }\n    }\n    logWarning(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.warn(`WARNING@${logHeader}: ${description}`);\n        }\n    }\n    logInfo(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.info(`INFO@${logHeader}: ${description}`);\n        }\n    }\n    enableLogging(isEnabled = true) {\n        this.isEnabled = isEnabled;\n    }\n    getLogHeader(methodName) {\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/components/admin-page.component.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "AdminPageComponent": () => (/* binding */ AdminPageComponent)\n/* harmony export */ });\n/* harmony import */ var _services_utils_spinner_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/spinner.service.ts");\n/* harmony import */ var _services_atlassian_upgrade_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/upgrade.service.ts");\n/* harmony import */ var _services_atlassian_license_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/license.service.ts");\n/* harmony import */ var _services_utils_message_service__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/message.service.ts");\n/* harmony import */ var _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts");\n/* harmony import */ var _model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts");\n/* harmony import */ var _services_utils_tabbed_dialog_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/tabbed-dialog.service.ts");\n/* harmony import */ var _services_attribute_panel_color_sync_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/attribute-panel/color-sync.service.ts");\n/* harmony import */ var _services_utils_validator_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/validator.service.ts");\n/* harmony import */ var _services_atlassian_macro_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/macro.service.ts");\n/* harmony import */ var _services_utils_browser_factory__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/browser.factory.ts");\n/* harmony import */ var _services_utils_enum_converter_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/enum-converter.service.ts");\n/* harmony import */ var _services_atlassian_app_config_service__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/app-config.service.ts");\n/* harmony import */ var _services_atlassian_routing_service__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/routing.service.ts");\n/* harmony import */ var _services_admin_global_diagram_config_service__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/admin/global-diagram-config.service.ts");\n/* harmony import */ var _services_admin_whitelist_spaces_service__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/admin/whitelist-spaces.service.ts");\n/* harmony import */ var _services_admin_gitlab_config_service__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/admin/gitlab-config.service.ts");\n/* harmony import */ var _services_admin_bitbucket_config_service__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/admin/bitbucket-config.service.ts");\n/* harmony import */ var _services_admin_ao_diagram_links_service__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/admin/ao-diagram-links.service.ts");\n/* harmony import */ var _services_admin_macro_migration_service__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/admin/macro-migration.service.ts");\n/* harmony import */ var _services_admin_cloud_migration_service__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/admin/cloud-migration.service.ts");\n/* harmony import */ var _services_atlassian_attachments_service__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/attachments.service.ts");\n/* harmony import */ var _services_atlassian_global_bpmn_elements_config_rest_service__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/global-bpmn-elements-config-rest.service.ts");\n/* harmony import */ var _services_admin_bpmn_elements_config_service__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/admin/bpmn-elements-config.service.ts");\n/* harmony import */ var _model_configs_default_bpmn_elements_config__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/configs/default-bpmn-elements.config.ts");\n/* harmony import */ var _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass AdminPageComponent {\n    constructor() {\n        this.platformUtils = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_24__/* .getPlatformService */ .km)().getPlatformUtils() || {};\n        this.$userManualLink = $("#vxcp-ent-admin-page-help-link");\n        this.pluginService = (0,_model_language_plugin_specific_factory__WEBPACK_IMPORTED_MODULE_24__/* .getPluginService */ .j)();\n        this.licenseService = new _services_atlassian_license_service__WEBPACK_IMPORTED_MODULE_2__/* .LicenseService */ .E();\n        this.appConfigService = new _services_atlassian_app_config_service__WEBPACK_IMPORTED_MODULE_10__/* .AppConfigService */ ._(this.platformUtils);\n        this.macroService = new _services_atlassian_macro_service__WEBPACK_IMPORTED_MODULE_7__/* .MacroService */ .f(new _services_utils_enum_converter_service__WEBPACK_IMPORTED_MODULE_9__/* .EnumConverterService */ .A());\n        this.messageService = new _services_utils_message_service__WEBPACK_IMPORTED_MODULE_25__/* .MessageService */ .e();\n        this.spinnerService = new _services_utils_spinner_service__WEBPACK_IMPORTED_MODULE_0__/* .SpinnerService */ .V();\n        this.upgradeService = new _services_atlassian_upgrade_service__WEBPACK_IMPORTED_MODULE_1__/* .UpgradeService */ .V();\n        this.configurationDialogService = new _services_utils_tabbed_dialog_service__WEBPACK_IMPORTED_MODULE_4__/* .TabbedDialogService */ .t();\n        this.attachmentService = new _services_atlassian_attachments_service__WEBPACK_IMPORTED_MODULE_19__/* .AttachmentService */ .L();\n        this.validatorService = new _services_utils_validator_service__WEBPACK_IMPORTED_MODULE_6__/* .ValidatorService */ .o(this.macroService);\n        this.colorSyncService = new _services_attribute_panel_color_sync_service__WEBPACK_IMPORTED_MODULE_5__/* .ColorSyncService */ .q(this.validatorService);\n        this.browserService = _services_utils_browser_factory__WEBPACK_IMPORTED_MODULE_8__/* .getBrowserService */ .i();\n        this.languageRestService = _model_language_language_rest_factory__WEBPACK_IMPORTED_MODULE_3__/* .getLanguageRestService */ .GU();\n        this.globalDiagramConfigService = new _services_admin_global_diagram_config_service__WEBPACK_IMPORTED_MODULE_12__/* .GlobalDiagramConfigService */ .o(this.colorSyncService, this.browserService, this.appConfigService, this.messageService, this.validatorService);\n        this.whitelistSpacesService = new _services_admin_whitelist_spaces_service__WEBPACK_IMPORTED_MODULE_13__/* .WhitelistSpacesService */ .$(this.languageRestService, this.pluginService, this.messageService);\n        this.gitlabConfigService = new _services_admin_gitlab_config_service__WEBPACK_IMPORTED_MODULE_14__/* .GitlabConfigService */ .a(this.languageRestService, this.appConfigService, this.messageService);\n        this.bitbucketConfigService = new _services_admin_bitbucket_config_service__WEBPACK_IMPORTED_MODULE_15__/* .BitbucketConfigService */ .O(this.languageRestService, this.pluginService, this.messageService);\n        this.aoDiagramLinksService = new _services_admin_ao_diagram_links_service__WEBPACK_IMPORTED_MODULE_16__/* .AoDiagramLinksService */ .m(this.languageRestService, this.pluginService, this.messageService);\n        this.macroMigrationService = new _services_admin_macro_migration_service__WEBPACK_IMPORTED_MODULE_17__/* .MacroMigrationService */ .Q(this.pluginService, this.upgradeService, this.spinnerService, this.messageService);\n        this.cloudMigrationService = new _services_admin_cloud_migration_service__WEBPACK_IMPORTED_MODULE_18__/* .CloudMigrationService */ .H(this.pluginService, this.attachmentService, this.macroService, this.messageService);\n        this.bpmnElementsConfigRestService = new _services_atlassian_global_bpmn_elements_config_rest_service__WEBPACK_IMPORTED_MODULE_20__/* .GlobalBpmnElementsConfigRestService */ .r();\n        this.bpmnElementsConfigService = new _services_admin_bpmn_elements_config_service__WEBPACK_IMPORTED_MODULE_21__/* .BpmnElementsConfigService */ .c(this.messageService, this.bpmnElementsConfigRestService);\n    }\n    init() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const licenseType = yield this.licenseService.getLicenseType();\n            const licenseFlag = yield this.licenseService.licenseHandlingForConfigurationPageBefore(licenseType);\n            if (!licenseFlag) {\n                return;\n            }\n            const userManualLink = yield this.getUserManualLink();\n            this.$userManualLink.attr("href", userManualLink);\n            this.configurationDialogService.initDialogEventListeners();\n            yield this.globalDiagramConfigService.initGlobalConfig();\n            yield this.whitelistSpacesService.initWhitelistingSpaces();\n            yield this.gitlabConfigService.initGitLabConfiguration();\n            yield this.bitbucketConfigService.initBitbucketConfig();\n            yield this.macroMigrationService.initMacroMigration();\n            yield this.cloudMigrationService.init();\n            if (this.pluginService.getPluginShorthand() === _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_23__/* .PluginTypeEnum.BPMN */ .AQ.BPMN) {\n                yield this.aoDiagramLinksService.initAllDiagramLinksAction();\n                yield this.bpmnElementsConfigService.init(_model_configs_default_bpmn_elements_config__WEBPACK_IMPORTED_MODULE_22__/* .defaultBpmnElementsConfig */ .f);\n            }\n        });\n    }\n    getUserManualLink() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const data = yield (0,_services_atlassian_routing_service__WEBPACK_IMPORTED_MODULE_11__/* .getUrlCollectionFromBucket */ .XR)();\n            const linkCollection = data.result;\n            return this.pluginService.getUserManualLinkAdminFeatures(linkCollection);\n        });\n    }\n    static get() {\n        if (this.INSTANCE) {\n            return this.INSTANCE;\n        }\n        this.INSTANCE = new AdminPageComponent();\n        return this.INSTANCE;\n    }\n}\nAdminPageComponent.INSTANCE = null;\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/components/admin-page.component.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "GU": () => (/* binding */ getLanguageRestService)\n/* harmony export */ });\n/* unused harmony exports getLanguageRestServiceForPluginType, getEmptyLanguageService */\n/* harmony import */ var _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts");\n\n\nconst getLanguageRestService = () => {\n    if (false) {}\n    else {\n        return getBpmnRestService();\n    }\n};\nconst getLanguageRestServiceForPluginType = (pluginType) => {\n    if (pluginType === PluginTypeEnum.DMN_ENTERPRISE) {\n        return getDmnRestService();\n    }\n    else {\n        return getBpmnRestService();\n    }\n};\nconst getEmptyLanguageService = () => {\n    return new EmptyLanguageRestService();\n};\nconst getBpmnRestService = () => {\n    return window.VBCP.bpmnEntLanguageService.getLanguageRestService();\n};\nconst getDmnRestService = () => {\n    return window.VDCPENT.dmnEntLanguageService.getLanguageRestService();\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "j": () => (/* binding */ getPluginService),\n/* harmony export */   "km": () => (/* binding */ getPlatformService)\n/* harmony export */ });\n/* unused harmony export getPlatformMDFService */\nconst getPluginService = () => {\n    if (false) {}\n    else {\n        return getBpmnPluginService();\n    }\n};\nconst getDmnPluginService = () => {\n    return window.VDCPENT.dmnEntPlugin;\n};\nconst getBpmnPluginService = () => {\n    return window.VBCP.bpmnEntPlugin;\n};\nconst getPlatformService = () => {\n    if (false) {}\n    else {\n        return getBpmnPlatformService();\n    }\n};\nconst getPlatformMDFService = () => {\n    if (false) {}\n    else {\n        return getBpmnPlatformMDFService();\n    }\n};\nconst getDmnPlatformService = () => {\n    return window.VDCPENT.dmnEntPlatformJS;\n};\nconst getBpmnPlatformService = () => {\n    return window.VBCP.bpmnEntPlatformJS;\n};\nconst getDmnPlatformMDFService = () => {\n    return window.VDCPENT.dmnEntPlatformMDF;\n};\nconst getBpmnPlatformMDFService = () => {\n    return window.VBCP.bpmnEntPlatformMDF;\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/configs/default-bpmn-elements.config.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "f": () => (/* binding */ defaultBpmnElementsConfig)\n/* harmony export */ });\nconst defaultBpmnElementsConfig = {\n    "replace-with-message-start": true,\n    "replace-with-timer-start": true,\n    "replace-with-conditional-start": true,\n    "replace-with-signal-start": true,\n    "replace-with-error-start": true,\n    "replace-with-escalation-start": true,\n    "replace-with-compensation-start": true,\n    "replace-with-non-interrupting-message-start": true,\n    "replace-with-non-interrupting-timer-start": true,\n    "replace-with-non-interrupting-conditional-start": true,\n    "replace-with-non-interrupting-signal-start": true,\n    "replace-with-non-interrupting-escalation-start": true,\n    "replace-with-message-intermediate-catch": true,\n    "replace-with-message-intermediate-throw": true,\n    "replace-with-timer-intermediate-catch": true,\n    "replace-with-escalation-intermediate-throw": true,\n    "replace-with-conditional-intermediate-catch": true,\n    "replace-with-link-intermediate-catch": true,\n    "replace-with-link-intermediate-throw": true,\n    "replace-with-compensation-intermediate-throw": true,\n    "replace-with-signal-intermediate-catch": true,\n    "replace-with-signal-intermediate-throw": true,\n    "replace-with-message-boundary": true,\n    "replace-with-timer-boundary": true,\n    "replace-with-escalation-boundary": true,\n    "replace-with-conditional-boundary": true,\n    "replace-with-error-boundary": true,\n    "replace-with-cancel-boundary": true,\n    "replace-with-signal-boundary": true,\n    "replace-with-compensation-boundary": true,\n    "replace-with-non-interrupting-message-boundary": true,\n    "replace-with-non-interrupting-timer-boundary": true,\n    "replace-with-non-interrupting-escalation-boundary": true,\n    "replace-with-non-interrupting-conditional-boundary": true,\n    "replace-with-non-interrupting-signal-boundary": true,\n    "replace-with-message-end": true,\n    "replace-with-escalation-end": true,\n    "replace-with-error-end": true,\n    "replace-with-cancel-end": true,\n    "replace-with-compensation-end": true,\n    "replace-with-signal-end": true,\n    "replace-with-terminate-end": true,\n    "replace-with-send-task": true,\n    "replace-with-receive-task": true,\n    "replace-with-user-task": true,\n    "replace-with-manual-task": true,\n    "replace-with-rule-task": true,\n    "replace-with-service-task": true,\n    "replace-with-script-task": true,\n    "replace-with-call-activity": true,\n    "toggle-parallel-mi": true,\n    "toggle-sequential-mi": true,\n    "toggle-loop": true,\n    "replace-with-parallel-gateway": true,\n    "replace-with-inclusive-gateway": true,\n    "replace-with-complex-gateway": true,\n    "replace-with-event-based-gateway": true,\n    "replace-with-transaction": true,\n    "replace-with-event-subprocess": true,\n    "replace-with-collapsed-subprocess": true,\n    "toggle-adhoc": true,\n    "replace-with-default-flow": true,\n    "replace-with-conditional-flow": true,\n    "toggle-is-collection": true,\n    "replace-with-collapsed-pool": true,\n    "toggle-participant-multiplicity": true,\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/configs/default-bpmn-elements.config.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-mode.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "v": () => (/* binding */ AppModeEnum)\n/* harmony export */ });\nvar AppModeEnum;\n(function (AppModeEnum) {\n    AppModeEnum["EDITOR"] = "EDITOR";\n    AppModeEnum["PRESENTATION"] = "PRESENTATION";\n    AppModeEnum["DIFFER"] = "DIFFER";\n    AppModeEnum["DIFFER_WITH_MINIMAP"] = "DIFFER_WITH_MINIMAP";\n    AppModeEnum["XMLEDITOR"] = "XMLEDITOR";\n    AppModeEnum["TABLE"] = "TABLE";\n    AppModeEnum["VIEWER"] = "VIEWER";\n    AppModeEnum["VIEWER_DIALOG"] = "VIEWER_DIALOG";\n})(AppModeEnum || (AppModeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-mode.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-rest-path.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* unused harmony exports EnterpriseRestPathEnum, EnterpriseActionPathEnum, FreeRestPathEnum */\nvar EnterpriseRestPathEnum;\n(function (EnterpriseRestPathEnum) {\n    EnterpriseRestPathEnum["BPMN"] = "bpmn-modeler-enterprise";\n    EnterpriseRestPathEnum["DMN"] = "dmn-plugin-enterprise";\n})(EnterpriseRestPathEnum || (EnterpriseRestPathEnum = {}));\nvar EnterpriseActionPathEnum;\n(function (EnterpriseActionPathEnum) {\n    EnterpriseActionPathEnum["BPMN"] = "bpmn-plugin-enterprise";\n    EnterpriseActionPathEnum["DMN"] = "dmn-plugin-enterprise";\n})(EnterpriseActionPathEnum || (EnterpriseActionPathEnum = {}));\nvar FreeRestPathEnum;\n(function (FreeRestPathEnum) {\n    FreeRestPathEnum["BPMN"] = "bpmn-modeler";\n    FreeRestPathEnum["DMN"] = "dmn-modeler";\n})(FreeRestPathEnum || (FreeRestPathEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-rest-path.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "K": () => (/* binding */ AppTypeEnum)\n/* harmony export */ });\nvar AppTypeEnum;\n(function (AppTypeEnum) {\n    AppTypeEnum["CLOUD_ENTERPRISE"] = "cloud-enterprise";\n    AppTypeEnum["SERVER_ENTERPRISE"] = "server-enterprise";\n    AppTypeEnum["SERVER_FREE"] = "server-free";\n})(AppTypeEnum || (AppTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/browser.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "p": () => (/* binding */ BrowserEnum)\n/* harmony export */ });\nvar BrowserEnum;\n(function (BrowserEnum) {\n    BrowserEnum["INTERNET_EXPLORER"] = "Internet Explorer";\n    BrowserEnum["MICROSOFT_EDGE"] = "Microsoft Edge";\n    BrowserEnum["SAFARI"] = "Safari";\n    BrowserEnum["UNDEFINED"] = "UNDEFINED";\n})(BrowserEnum || (BrowserEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/browser.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dmn-table-mode.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* unused harmony export DmnTableModeEnum */\nvar DmnTableModeEnum;\n(function (DmnTableModeEnum) {\n    DmnTableModeEnum["VIEWER"] = "view";\n    DmnTableModeEnum["EDITOR"] = "edit";\n})(DmnTableModeEnum || (DmnTableModeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/dmn-table-mode.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/file-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "W": () => (/* binding */ FileTypeEnum)\n/* harmony export */ });\nvar FileTypeEnum;\n(function (FileTypeEnum) {\n    FileTypeEnum["BPMN"] = ".bpmn";\n    FileTypeEnum["SVG"] = ".svg";\n    FileTypeEnum["PNG"] = ".png";\n    FileTypeEnum["DMN"] = ".dmn";\n    FileTypeEnum["PDF"] = ".pdf";\n    FileTypeEnum["DOC"] = ".doc;.docx";\n    FileTypeEnum["PPT"] = ".ppt;.pptx";\n    FileTypeEnum["IMAGE"] = ".jpg;.jpeg;.png";\n    FileTypeEnum["CSV"] = ".csv";\n    FileTypeEnum["JSON"] = ".json";\n    FileTypeEnum["XML"] = ".xml";\n    FileTypeEnum["ANY"] = "";\n})(FileTypeEnum || (FileTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/file-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/key-name.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "i": () => (/* binding */ KeyNameEnum)\n/* harmony export */ });\nvar KeyNameEnum;\n(function (KeyNameEnum) {\n    KeyNameEnum["Tab"] = "Tab";\n    KeyNameEnum["Enter"] = "Enter";\n    KeyNameEnum["Shift"] = "Shift";\n    KeyNameEnum["Control"] = "Control";\n    KeyNameEnum["Alt"] = "Alt";\n    KeyNameEnum["CapsLock"] = "CapsLock";\n    KeyNameEnum["Escape"] = "Escape";\n    KeyNameEnum["Space"] = "Space";\n    KeyNameEnum["PageUp"] = "PageUp";\n    KeyNameEnum["PageDown"] = "PageDown";\n    KeyNameEnum["ArrowLeft"] = "ArrowLeft";\n    KeyNameEnum["ArrowUp"] = "ArrowUp";\n    KeyNameEnum["ArrowRight"] = "ArrowRight";\n    KeyNameEnum["ArrowDown"] = "ArrowDown";\n})(KeyNameEnum || (KeyNameEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/key-name.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/license-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "y": () => (/* binding */ LicenseTypeEnum)\n/* harmony export */ });\nvar LicenseTypeEnum;\n(function (LicenseTypeEnum) {\n    LicenseTypeEnum["VALID"] = "VALID";\n    LicenseTypeEnum["MAINTENANCE_EXPIRED"] = "MAINTENANCE_EXPIRED";\n    LicenseTypeEnum["EVAL"] = "EVAL";\n    LicenseTypeEnum["INVALID"] = "INVALID";\n})(LicenseTypeEnum || (LicenseTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/license-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/message-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "D": () => (/* binding */ MessageTypeEnum)\n/* harmony export */ });\nvar MessageTypeEnum;\n(function (MessageTypeEnum) {\n    MessageTypeEnum["INFO"] = "info";\n    MessageTypeEnum["SUCCESS"] = "success";\n    MessageTypeEnum["WARNING"] = "warning";\n    MessageTypeEnum["ERROR"] = "error";\n})(MessageTypeEnum || (MessageTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/message-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Iu": () => (/* binding */ OverlayTypeLabelEnum)\n/* harmony export */ });\n/* unused harmony exports OverlayTypeXmlEnum, OverlayTypeIconClassEnum, OverlayTypeConfigKeyEnum, DistinctOverlayType, OverlayDefaultAction */\nvar OverlayTypeXmlEnum;\n(function (OverlayTypeXmlEnum) {\n    OverlayTypeXmlEnum["EMBEDDED_COMMENTS"] = "viadee:Comment";\n    OverlayTypeXmlEnum["DOCUMENTATION"] = "bpmn:documentation";\n    OverlayTypeXmlEnum["LEGACY_WIKILINK"] = "viadee:WikiLinks";\n    OverlayTypeXmlEnum["BPMN"] = "viadee:BpmnLinks";\n    OverlayTypeXmlEnum["DMN_ENTERPRISE"] = "viadee:DmnEnterpriseLinks";\n    OverlayTypeXmlEnum["DMN"] = "viadee:DmnLinks";\n    OverlayTypeXmlEnum["CONFLUENCE_PAGE"] = "viadee:PageLinks";\n    OverlayTypeXmlEnum["CONFLUENCE_ATTACHMENT"] = "viadee:ConfluenceAttachmentLink";\n    OverlayTypeXmlEnum["EXTERNAL_CONTENT"] = "viadee:ExternalLinks";\n    OverlayTypeXmlEnum["JIRA_ISSUE"] = "viadee:JiraIssueLink";\n    OverlayTypeXmlEnum["MDF_INSTANCE"] = "viadee:MdfInstance";\n    OverlayTypeXmlEnum["ANY"] = "viadee:AnyLinks";\n})(OverlayTypeXmlEnum || (OverlayTypeXmlEnum = {}));\nvar OverlayTypeLabelEnum;\n(function (OverlayTypeLabelEnum) {\n    OverlayTypeLabelEnum["EMBEDDED_COMMENTS"] = "embedded-comments";\n    OverlayTypeLabelEnum["DOCUMENTATION"] = "documentation";\n    OverlayTypeLabelEnum["BPMN"] = "bpmn";\n    OverlayTypeLabelEnum["BPMN_NEW_TARGET_PAGE"] = "bpmn-new-target-page";\n    OverlayTypeLabelEnum["LEGACY_BPMN"] = "attachment";\n    OverlayTypeLabelEnum["DMN_ENTERPRISE"] = "dmn-enterprise";\n    OverlayTypeLabelEnum["DMN"] = "dmn";\n    OverlayTypeLabelEnum["DMN_NEW_TARGET_PAGE"] = "dmn-new-target-page";\n    OverlayTypeLabelEnum["CONFLUENCE_PAGE"] = "confluence-page";\n    OverlayTypeLabelEnum["LEGACY_CONFLUENCE_PAGE"] = "search-page";\n    OverlayTypeLabelEnum["CONFLUENCE_ATTACHMENT"] = "confluence-attachment";\n    OverlayTypeLabelEnum["EXTERNAL_CONTENT"] = "external-content";\n    OverlayTypeLabelEnum["LEGACY_EXTERNAL_CONTENT"] = "external";\n    OverlayTypeLabelEnum["JIRA_ISSUE"] = "jira-issue";\n    OverlayTypeLabelEnum["MDF_INSTANCE"] = "mdf-instance";\n})(OverlayTypeLabelEnum || (OverlayTypeLabelEnum = {}));\nvar OverlayTypeIconClassEnum;\n(function (OverlayTypeIconClassEnum) {\n    OverlayTypeIconClassEnum["EMBEDDED_COMMENTS"] = "";\n    OverlayTypeIconClassEnum["DOCUMENTATION"] = "vxcp-ent-icon-documentation";\n    OverlayTypeIconClassEnum["BPMN"] = "vxcp-ent-icon-bpmn";\n    OverlayTypeIconClassEnum["DMN_ENTERPRISE"] = "vxcp-ent-icon-dmn";\n    OverlayTypeIconClassEnum["DMN"] = "vxcp-ent-icon-dmn";\n    OverlayTypeIconClassEnum["CONFLUENCE_PAGE"] = "vxcp-ent-icon-confluence-page";\n    OverlayTypeIconClassEnum["CONFLUENCE_ATTACHMENT"] = "vxcp-ent-icon-attachment";\n    OverlayTypeIconClassEnum["EXTERNAL_CONTENT"] = "vxcp-ent-icon-external";\n    OverlayTypeIconClassEnum["JIRA_ISSUE"] = "vxcp-ent-icon-jira-issue";\n    OverlayTypeIconClassEnum["MDF_INSTANCE"] = "vxcp-ent-icon-mdf-instance";\n})(OverlayTypeIconClassEnum || (OverlayTypeIconClassEnum = {}));\nvar OverlayTypeConfigKeyEnum;\n(function (OverlayTypeConfigKeyEnum) {\n    OverlayTypeConfigKeyEnum["EMBEDDED_COMMENTS"] = "showEmbeddedComments";\n    OverlayTypeConfigKeyEnum["DOCUMENTATION"] = "showDocumentation";\n    OverlayTypeConfigKeyEnum["BPMN"] = "showBpmnLinks";\n    OverlayTypeConfigKeyEnum["DMN_ENTERPRISE"] = "showDmnLinks";\n    OverlayTypeConfigKeyEnum["DMN"] = "showDmnLinks";\n    OverlayTypeConfigKeyEnum["CONFLUENCE_PAGE"] = "showConfluencePageLinks";\n    OverlayTypeConfigKeyEnum["CONFLUENCE_ATTACHMENT"] = "showConfluenceAttachmentLinks";\n    OverlayTypeConfigKeyEnum["EXTERNAL_CONTENT"] = "showExternalContentLinks";\n    OverlayTypeConfigKeyEnum["JIRA_ISSUE"] = "showJiraIssueLinks";\n    OverlayTypeConfigKeyEnum["MDF_INSTANCE"] = "showMdfInstanceLinks";\n})(OverlayTypeConfigKeyEnum || (OverlayTypeConfigKeyEnum = {}));\nvar DistinctOverlayType;\n(function (DistinctOverlayType) {\n    DistinctOverlayType["DOCUMENTATION"] = "documentation";\n    DistinctOverlayType["BPMN"] = "bpmn";\n    DistinctOverlayType["DMN"] = "dmn";\n    DistinctOverlayType["CONFLUENCE_PAGE"] = "confluence-page";\n    DistinctOverlayType["EXTERNAL_CONTENT"] = "external-content";\n    DistinctOverlayType["CONFLUENCE_ATTACHMENT"] = "confluence-attachment";\n    DistinctOverlayType["JIRA_ISSUE"] = "jira";\n    DistinctOverlayType["MDF_INSTANCE"] = "mdf";\n})(DistinctOverlayType || (DistinctOverlayType = {}));\nvar OverlayDefaultAction;\n(function (OverlayDefaultAction) {\n    OverlayDefaultAction["OPEN_PANEL"] = "openPanel";\n    OverlayDefaultAction["WONT_DRAW"] = "wontDraw";\n})(OverlayDefaultAction || (OverlayDefaultAction = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/overlay-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "AQ": () => (/* binding */ PluginTypeEnum),\n/* harmony export */   "ib": () => (/* binding */ MacroEnterpriseNameEnum),\n/* harmony export */   "pi": () => (/* binding */ MacroFreeNameEnum)\n/* harmony export */ });\nvar PluginTypeEnum;\n(function (PluginTypeEnum) {\n    PluginTypeEnum["DMN"] = "DMN";\n    PluginTypeEnum["DMN_ENTERPRISE"] = "DMN";\n    PluginTypeEnum["BPMN"] = "BPMN";\n})(PluginTypeEnum || (PluginTypeEnum = {}));\nvar MacroEnterpriseNameEnum;\n(function (MacroEnterpriseNameEnum) {\n    MacroEnterpriseNameEnum["DMN"] = "vdcp-macro-enterprise";\n    MacroEnterpriseNameEnum["BPMN"] = "vbcp-macro-enterprise";\n    MacroEnterpriseNameEnum["BPMN_PROCESS_NET"] = "vbcp-enterprise-process-net-macro";\n    MacroEnterpriseNameEnum["DMN_PROCESS_NET"] = "vdcp-enterprise-process-net-macro";\n})(MacroEnterpriseNameEnum || (MacroEnterpriseNameEnum = {}));\nvar MacroFreeNameEnum;\n(function (MacroFreeNameEnum) {\n    MacroFreeNameEnum["DMN"] = "vdcp-macro";\n    MacroFreeNameEnum["BPMN"] = "vbcp-macro";\n})(MacroFreeNameEnum || (MacroFreeNameEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/resize-direction.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* unused harmony export ResizeDirectionEnum */\nvar ResizeDirectionEnum;\n(function (ResizeDirectionEnum) {\n    ResizeDirectionEnum["TOP_TO_BOTTOM"] = "TOP_TO_BOTTOM";\n    ResizeDirectionEnum["BOTTOM_TO_TOP"] = "BOTTOM_TO_TOP";\n    ResizeDirectionEnum["LEFT_TO_RIGHT"] = "LEFT_TO_RIGHT";\n    ResizeDirectionEnum["RIGHT_TO_LEFT"] = "RIGHT_TO_LEFT";\n})(ResizeDirectionEnum || (ResizeDirectionEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/resize-direction.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/rest-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "T": () => (/* binding */ RestTypeEnum)\n/* harmony export */ });\nvar RestTypeEnum;\n(function (RestTypeEnum) {\n    RestTypeEnum["GET"] = "GET";\n    RestTypeEnum["DELETE"] = "DELETE";\n    RestTypeEnum["POST"] = "POST";\n    RestTypeEnum["PUT"] = "PUT";\n})(RestTypeEnum || (RestTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/rest-type.enum.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/warning-dialog-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "K": () => (/* binding */ WarningDialogTypeEnum)\n/* harmony export */ });\nvar WarningDialogTypeEnum;\n(function (WarningDialogTypeEnum) {\n    WarningDialogTypeEnum["PAGE_NOT_SAVED"] = "page-not-saved";\n    WarningDialogTypeEnum["SAVE_BEFORE_IMPORT"] = "save-before-import";\n    WarningDialogTypeEnum["SAVE_BEFORE_VCS_PUSH"] = "save-before-vcs-push";\n    WarningDialogTypeEnum["SAVE_BEFORE_EXIT"] = "save-before-exit";\n    WarningDialogTypeEnum["SAVE_BEFORE_OPEN_CONFIGS"] = "save-before-open-configs";\n    WarningDialogTypeEnum["LOADING_BROKEN_XML"] = "loading-broken-xml";\n    WarningDialogTypeEnum["SAVING_INVALID_XML"] = "saving-invalid-xml";\n    WarningDialogTypeEnum["SAVING_XML_WITH_WARNINGS"] = "saving-xml-with-warnings";\n    WarningDialogTypeEnum["WRONG_FILE_FORMAT"] = "wrong-file-format";\n    WarningDialogTypeEnum["RESET_DIAGRAM"] = "reset-diagram";\n    WarningDialogTypeEnum["RESET_DIAGRAM_AND_SAVED_IN_BETWEEN"] = "reset-diagram-and-saved-in-between";\n    WarningDialogTypeEnum["DIAGRAM_SAVED_IN_BETWEEN"] = "saved-in-between";\n    WarningDialogTypeEnum["DIFFER_DIAGRAM_TOO_BIG"] = "differ-diagram-too-big";\n    WarningDialogTypeEnum["DIFFER_FILE_DOES_NOT_EXIST"] = "differ-file-does-not-exist";\n    WarningDialogTypeEnum["NO_VERSIONS_TO_COMPARE"] = "no-versions-to-compare";\n    WarningDialogTypeEnum["START_MIGRATION"] = "start-migration";\n    WarningDialogTypeEnum["BROWSER_NOT_SUPPORTED"] = "browser-not-supported";\n    WarningDialogTypeEnum["NO_PNG_UPLOAD"] = "no-png-upload";\n    WarningDialogTypeEnum["SESSION_EXPIRED"] = "session-expired";\n    WarningDialogTypeEnum["NO_CONNECTION"] = "no-connection";\n    WarningDialogTypeEnum["LICENSE_NOT_VALID"] = "license-not-valid";\n    WarningDialogTypeEnum["SOME_ERROR_APPEARED"] = "some-error-appeared";\n    WarningDialogTypeEnum["ATTACHMENTS_NOT_UPLOADED"] = "attachments-not-uploaded";\n    WarningDialogTypeEnum["EDITOR_MACRO_NOT_EXIST"] = "editor-macro-not-exist";\n    WarningDialogTypeEnum["LEGACY_WIKILINKS"] = "legacy-links";\n    WarningDialogTypeEnum["MACRO_NOT_ALLOWED_HERE"] = "macro-not-allowed-here";\n    WarningDialogTypeEnum["DUPLICATE_RENAME_ERROR"] = "duplicate-rename-error";\n    WarningDialogTypeEnum["PNG_RENAME_ERROR"] = "png-rename-error";\n    WarningDialogTypeEnum["PNG_COPY_ERROR"] = "png-copy-error";\n    WarningDialogTypeEnum["XML_RENAME_ERROR"] = "xml-rename-error";\n    WarningDialogTypeEnum["TABLE_NOT_EXPORTED"] = "table-not-exported";\n    WarningDialogTypeEnum["VERSION_NOT_AVAILABLE_EDITOR"] = "version-not-available";\n    WarningDialogTypeEnum["AUTHENTICATION_TOKEN_REQUIRED"] = "jira-authentication-token-required";\n    WarningDialogTypeEnum["DELETE_RESOLVED_COMMENTS"] = "delete-resolved-comments";\n    WarningDialogTypeEnum["RESET_ADMIN_PAGE_CONFIGS"] = "reset-admin-page-configs";\n    WarningDialogTypeEnum["DIAGRAM_ALREADY_EXISTS_ON_PAGE"] = "diagram-already-exists-on-page";\n    WarningDialogTypeEnum["DELETE_ALL_LINKS"] = "delete-all-diagram-links";\n    WarningDialogTypeEnum["SYNC_ALL_LINKS"] = "sync-all-diagram-links";\n    WarningDialogTypeEnum["NEW_DIAGRAM_NOT_SAVED"] = "new-diagram-not-saved";\n    WarningDialogTypeEnum["NEW_DIAGRAM_NOT_SAVED_YET"] = "new-diagram-not-saved-yet";\n    WarningDialogTypeEnum["COPY_DIAGRAM_AND_CREATE_MACRO_ERROR"] = "copy-diagram-and-create-macro-error";\n    WarningDialogTypeEnum["UPLOAD_DIAGRAM_AND_CREATE_MACRO_ERROR"] = "upload-diagram-and-create-macro-error";\n    WarningDialogTypeEnum["FETCH_DIAGRAM_AND_CREATE_MACRO_ERROR"] = "fetch-diagram-and-create-macro-error";\n    WarningDialogTypeEnum["FETCH_DIAGRAM_FROM_VCS_ERROR"] = "fetch-diagram-from-vcs-error";\n})(WarningDialogTypeEnum || (WarningDialogTypeEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/warning-dialog-type.enum.ts?')}},__webpack_module_cache__={},deferred;function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var r=__webpack_module_cache__[e]={id:e,loaded:!1,exports:{}};return __webpack_modules__[e].call(r.exports,r,r.exports,__webpack_require__),r.loaded=!0,r.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(e,n,r,i)=>{if(!n){var _=1/0;for(s=0;s<deferred.length;s++){for(var[n,r,i]=deferred[s],a=!0,t=0;t<n.length;t++)(!1&i||_>=i)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](n[t])))?n.splice(t--,1):(a=!1,i<_&&(_=i));if(a){deferred.splice(s--,1);var o=r();void 0!==o&&(e=o)}}return e}i=i||0;for(var s=deferred.length;s>0&&deferred[s-1][2]>i;s--)deferred[s]=deferred[s-1];deferred[s]=[n,r,i]},__webpack_require__.n=e=>{var n=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(n,{a:n}),n},__webpack_require__.d=(e,n)=>{for(var r in n)__webpack_require__.o(n,r)&&!__webpack_require__.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:n[r]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},__webpack_require__.nmd=e=>(e.paths=[],e.children||(e.children=[]),e),__webpack_require__.j="bpmnEntAdmin",(()=>{var e={bpmnEntAdmin:0};__webpack_require__.O.j=n=>0===e[n];var n=(n,r)=>{var i,_,[a,t,o]=r,s=0;if(a.some((n=>0!==e[n]))){for(i in t)__webpack_require__.o(t,i)&&(__webpack_require__.m[i]=t[i]);if(o)var p=o(__webpack_require__)}for(n&&n(r);s<a.length;s++)_=a[s],__webpack_require__.o(e,_)&&e[_]&&e[_][0](),e[_]=0;return __webpack_require__.O(p)},r=self.webpackChunkVBCP=self.webpackChunkVBCP||[];r.forEach(n.bind(null,0)),r.push=n.bind(null,r.push.bind(r))})();var __webpack_exports__=__webpack_require__.O(void 0,["bpmnEntVendors","bpmnEntServices"],(()=>__webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/components/admin-page.component.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VBCP=window.VBCP||{}).bpmnEntAdmin=__webpack_exports__})();