(()=>{"use strict";var __webpack_modules__={"../../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ VxcpLogger)\n/* harmony export */ });\nclass VxcpLogger {\n    constructor(pluginName, serviceName, isEnabled = true) {\n        this.pluginName = pluginName;\n        this.serviceName = serviceName;\n        this.isEnabled = isEnabled;\n    }\n    logFatal(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`FATAL@${logHeader}: ${description}`);\n        }\n    }\n    logError(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`ERROR@${logHeader}: ${description}`);\n        }\n    }\n    logWarning(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.warn(`WARNING@${logHeader}: ${description}`);\n        }\n    }\n    logInfo(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.info(`INFO@${logHeader}: ${description}`);\n        }\n    }\n    enableLogging(isEnabled = true) {\n        this.isEnabled = isEnabled;\n    }\n    getLogHeader(methodName) {\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/components/space-admin-page.component.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "SpaceAdminPageComponent": () => (/* binding */ SpaceAdminPageComponent)\n/* harmony export */ });\n/* harmony import */ var _services_utils_tabbed_dialog_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/tabbed-dialog.service.ts");\n/* harmony import */ var _services_utils_message_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/utils/message.service.ts");\n/* harmony import */ var _services_atlassian_space_linter_config_rest_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/space-linter-config-rest.service.ts");\n/* harmony import */ var _services_admin_linter_config_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/admin/linter-config.service.ts");\n/* harmony import */ var _services_atlassian_space_bpmn_elements_config_rest_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/space-bpmn-elements-config-rest.service.ts");\n/* harmony import */ var _services_atlassian_global_bpmn_elements_config_rest_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/atlassian/global-bpmn-elements-config-rest.service.ts");\n/* harmony import */ var _services_admin_bpmn_elements_config_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/services/admin/bpmn-elements-config.service.ts");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\nclass SpaceAdminPageComponent {\n    constructor(spaceKey) {\n        this.spaceKey = spaceKey;\n        this.tabbedDialogService = new _services_utils_tabbed_dialog_service__WEBPACK_IMPORTED_MODULE_0__/* .TabbedDialogService */ .t();\n        this.messageService = new _services_utils_message_service__WEBPACK_IMPORTED_MODULE_6__/* .MessageService */ .e();\n        this.linterConfigRestService = new _services_atlassian_space_linter_config_rest_service__WEBPACK_IMPORTED_MODULE_1__/* .SpaceLinterConfigRestService */ .x();\n        this.linterConfigService = new _services_admin_linter_config_service__WEBPACK_IMPORTED_MODULE_2__/* .LinterConfigService */ .E(this.messageService, this.linterConfigRestService);\n        this.bpmnElementsConfigRestService = new _services_atlassian_space_bpmn_elements_config_rest_service__WEBPACK_IMPORTED_MODULE_3__/* .SpaceBpmnElementsConfigRestService */ .F();\n        this.bpmnElementsConfigService = new _services_admin_bpmn_elements_config_service__WEBPACK_IMPORTED_MODULE_5__/* .BpmnElementsConfigService */ .c(this.messageService, this.bpmnElementsConfigRestService);\n    }\n    init() {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.tabbedDialogService.initDialogEventListeners();\n            this.linterConfigRestService.init(this.spaceKey);\n            yield this.linterConfigService.initLinterConfig();\n            this.bpmnElementsConfigRestService.init(this.spaceKey);\n            const globalBpmnElementsConfigRestService = new _services_atlassian_global_bpmn_elements_config_rest_service__WEBPACK_IMPORTED_MODULE_4__/* .GlobalBpmnElementsConfigRestService */ .r();\n            const defaultBpmnElementsConfig = yield globalBpmnElementsConfigRestService.getBpmnElementsConfig();\n            yield this.bpmnElementsConfigService.init(defaultBpmnElementsConfig);\n        });\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/components/space-admin-page.component.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "GU": () => (/* binding */ getLanguageRestService)\n/* harmony export */ });\n/* unused harmony exports getLanguageRestServiceForPluginType, getEmptyLanguageService */\n/* harmony import */ var _model_enum_plugin_type_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts");\n\n\nconst getLanguageRestService = () => {\n    if (false) {}\n    else {\n        return getBpmnRestService();\n    }\n};\nconst getLanguageRestServiceForPluginType = (pluginType) => {\n    if (pluginType === PluginTypeEnum.DMN_ENTERPRISE) {\n        return getDmnRestService();\n    }\n    else {\n        return getBpmnRestService();\n    }\n};\nconst getEmptyLanguageService = () => {\n    return new EmptyLanguageRestService();\n};\nconst getBpmnRestService = () => {\n    return window.VBCP.bpmnEntLanguageService.getLanguageRestService();\n};\nconst getDmnRestService = () => {\n    return window.VDCPENT.dmnEntLanguageService.getLanguageRestService();\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model-language/language-rest.factory.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "j": () => (/* binding */ getPluginService),\n/* harmony export */   "km": () => (/* binding */ getPlatformService)\n/* harmony export */ });\n/* unused harmony export getPlatformMDFService */\nconst getPluginService = () => {\n    if (false) {}\n    else {\n        return getBpmnPluginService();\n    }\n};\nconst getDmnPluginService = () => {\n    return window.VDCPENT.dmnEntPlugin;\n};\nconst getBpmnPluginService = () => {\n    return window.VBCP.bpmnEntPlugin;\n};\nconst getPlatformService = () => {\n    if (false) {}\n    else {\n        return getBpmnPlatformService();\n    }\n};\nconst getPlatformMDFService = () => {\n    if (false) {}\n    else {\n        return getBpmnPlatformMDFService();\n    }\n};\nconst getDmnPlatformService = () => {\n    return window.VDCPENT.dmnEntPlatformJS;\n};\nconst getBpmnPlatformService = () => {\n    return window.VBCP.bpmnEntPlatformJS;\n};\nconst getDmnPlatformMDFService = () => {\n    return window.VDCPENT.dmnEntPlatformMDF;\n};\nconst getBpmnPlatformMDFService = () => {\n    return window.VBCP.bpmnEntPlatformMDF;\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/configs/default-bpmn-elements.config.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "f": () => (/* binding */ defaultBpmnElementsConfig)\n/* harmony export */ });\nconst defaultBpmnElementsConfig = {\n    "replace-with-message-start": true,\n    "replace-with-timer-start": true,\n    "replace-with-conditional-start": true,\n    "replace-with-signal-start": true,\n    "replace-with-error-start": true,\n    "replace-with-escalation-start": true,\n    "replace-with-compensation-start": true,\n    "replace-with-non-interrupting-message-start": true,\n    "replace-with-non-interrupting-timer-start": true,\n    "replace-with-non-interrupting-conditional-start": true,\n    "replace-with-non-interrupting-signal-start": true,\n    "replace-with-non-interrupting-escalation-start": true,\n    "replace-with-message-intermediate-catch": true,\n    "replace-with-message-intermediate-throw": true,\n    "replace-with-timer-intermediate-catch": true,\n    "replace-with-escalation-intermediate-throw": true,\n    "replace-with-conditional-intermediate-catch": true,\n    "replace-with-link-intermediate-catch": true,\n    "replace-with-link-intermediate-throw": true,\n    "replace-with-compensation-intermediate-throw": true,\n    "replace-with-signal-intermediate-catch": true,\n    "replace-with-signal-intermediate-throw": true,\n    "replace-with-message-boundary": true,\n    "replace-with-timer-boundary": true,\n    "replace-with-escalation-boundary": true,\n    "replace-with-conditional-boundary": true,\n    "replace-with-error-boundary": true,\n    "replace-with-cancel-boundary": true,\n    "replace-with-signal-boundary": true,\n    "replace-with-compensation-boundary": true,\n    "replace-with-non-interrupting-message-boundary": true,\n    "replace-with-non-interrupting-timer-boundary": true,\n    "replace-with-non-interrupting-escalation-boundary": true,\n    "replace-with-non-interrupting-conditional-boundary": true,\n    "replace-with-non-interrupting-signal-boundary": true,\n    "replace-with-message-end": true,\n    "replace-with-escalation-end": true,\n    "replace-with-error-end": true,\n    "replace-with-cancel-end": true,\n    "replace-with-compensation-end": true,\n    "replace-with-signal-end": true,\n    "replace-with-terminate-end": true,\n    "replace-with-send-task": true,\n    "replace-with-receive-task": true,\n    "replace-with-user-task": true,\n    "replace-with-manual-task": true,\n    "replace-with-rule-task": true,\n    "replace-with-service-task": true,\n    "replace-with-script-task": true,\n    "replace-with-call-activity": true,\n    "toggle-parallel-mi": true,\n    "toggle-sequential-mi": true,\n    "toggle-loop": true,\n    "replace-with-parallel-gateway": true,\n    "replace-with-inclusive-gateway": true,\n    "replace-with-complex-gateway": true,\n    "replace-with-event-based-gateway": true,\n    "replace-with-transaction": true,\n    "replace-with-event-subprocess": true,\n    "replace-with-collapsed-subprocess": true,\n    "toggle-adhoc": true,\n    "replace-with-default-flow": true,\n    "replace-with-conditional-flow": true,\n    "toggle-is-collection": true,\n    "replace-with-collapsed-pool": true,\n    "toggle-participant-multiplicity": true,\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/configs/default-bpmn-elements.config.ts?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/configs/default-linter.config.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  "m": () => (/* binding */ defaultLinterConfig)\n});\n\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/validation-level-enum.ts\nvar ValidationLevelEnum;\n(function (ValidationLevelEnum) {\n    ValidationLevelEnum["VALIDATION_OFF"] = "off";\n    ValidationLevelEnum["VALIDATION_ERROR"] = "error";\n    ValidationLevelEnum["VALIDATION_WARN"] = "warn";\n})(ValidationLevelEnum || (ValidationLevelEnum = {}));\n\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/configs/default-linter.config.ts\n\nconst defaultLinterConfig = {\n    "end-event-required": ValidationLevelEnum.VALIDATION_ERROR,\n    "start-event-required": ValidationLevelEnum.VALIDATION_ERROR,\n    "event-sub-process-typed-start-event": ValidationLevelEnum.VALIDATION_ERROR,\n    "label-required": ValidationLevelEnum.VALIDATION_ERROR,\n    "single-blank-start-event": ValidationLevelEnum.VALIDATION_ERROR,\n    "sub-process-blank-start-event": ValidationLevelEnum.VALIDATION_ERROR,\n    "superfluous-gateway": ValidationLevelEnum.VALIDATION_ERROR,\n    "no-disconnected": ValidationLevelEnum.VALIDATION_ERROR,\n    "no-duplicate-sequence-flows": ValidationLevelEnum.VALIDATION_ERROR,\n    "no-gateway-join-fork": ValidationLevelEnum.VALIDATION_ERROR,\n    "no-implicit-split": ValidationLevelEnum.VALIDATION_ERROR,\n    "fake-join": ValidationLevelEnum.VALIDATION_ERROR,\n    "no-bpmndi": ValidationLevelEnum.VALIDATION_WARN,\n    "single-event-definition": ValidationLevelEnum.VALIDATION_WARN,\n    "conditional-flows": ValidationLevelEnum.VALIDATION_OFF,\n    "no-complex-gateway": ValidationLevelEnum.VALIDATION_OFF,\n    "no-inclusive-gateway": ValidationLevelEnum.VALIDATION_OFF,\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/configs/default-linter.config.ts_+_1_modules?')},"../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* unused harmony exports PluginTypeEnum, MacroEnterpriseNameEnum, MacroFreeNameEnum */\nvar PluginTypeEnum;\n(function (PluginTypeEnum) {\n    PluginTypeEnum["DMN"] = "DMN";\n    PluginTypeEnum["DMN_ENTERPRISE"] = "DMN";\n    PluginTypeEnum["BPMN"] = "BPMN";\n})(PluginTypeEnum || (PluginTypeEnum = {}));\nvar MacroEnterpriseNameEnum;\n(function (MacroEnterpriseNameEnum) {\n    MacroEnterpriseNameEnum["DMN"] = "vdcp-macro-enterprise";\n    MacroEnterpriseNameEnum["BPMN"] = "vbcp-macro-enterprise";\n    MacroEnterpriseNameEnum["BPMN_PROCESS_NET"] = "vbcp-enterprise-process-net-macro";\n    MacroEnterpriseNameEnum["DMN_PROCESS_NET"] = "vdcp-enterprise-process-net-macro";\n})(MacroEnterpriseNameEnum || (MacroEnterpriseNameEnum = {}));\nvar MacroFreeNameEnum;\n(function (MacroFreeNameEnum) {\n    MacroFreeNameEnum["DMN"] = "vdcp-macro";\n    MacroFreeNameEnum["BPMN"] = "vbcp-macro";\n})(MacroFreeNameEnum || (MacroFreeNameEnum = {}));\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/model/enum/plugin-type.enum.ts?')}},__webpack_module_cache__={},deferred;function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var r=__webpack_module_cache__[e]={id:e,loaded:!1,exports:{}};return __webpack_modules__[e].call(r.exports,r,r.exports,__webpack_require__),r.loaded=!0,r.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(e,n,r,t)=>{if(!n){var i=1/0;for(s=0;s<deferred.length;s++){for(var[n,r,t]=deferred[s],a=!0,_=0;_<n.length;_++)(!1&t||i>=t)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](n[_])))?n.splice(_--,1):(a=!1,t<i&&(i=t));if(a){deferred.splice(s--,1);var o=r();void 0!==o&&(e=o)}}return e}t=t||0;for(var s=deferred.length;s>0&&deferred[s-1][2]>t;s--)deferred[s]=deferred[s-1];deferred[s]=[n,r,t]},__webpack_require__.n=e=>{var n=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(n,{a:n}),n},__webpack_require__.d=(e,n)=>{for(var r in n)__webpack_require__.o(n,r)&&!__webpack_require__.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:n[r]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},__webpack_require__.nmd=e=>(e.paths=[],e.children||(e.children=[]),e),__webpack_require__.j="bpmnEntSpaceAdminPage",(()=>{var e={bpmnEntSpaceAdminPage:0};__webpack_require__.O.j=n=>0===e[n];var n=(n,r)=>{var t,i,[a,_,o]=r,s=0;if(a.some((n=>0!==e[n]))){for(t in _)__webpack_require__.o(_,t)&&(__webpack_require__.m[t]=_[t]);if(o)var c=o(__webpack_require__)}for(n&&n(r);s<a.length;s++)i=a[s],__webpack_require__.o(e,i)&&e[i]&&e[i][0](),e[i]=0;return __webpack_require__.O(c)},r=self.webpackChunkVBCP=self.webpackChunkVBCP||[];r.forEach(n.bind(null,0)),r.push=n.bind(null,r.push.bind(r))})();var __webpack_exports__=__webpack_require__.O(void 0,["bpmnEntVendors","bpmnEntServices"],(()=>__webpack_require__("../../../../../../vXCP-enterprise-core/core-js/app/components/space-admin-page.component.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VBCP=window.VBCP||{}).bpmnEntSpaceAdminPage=__webpack_exports__})();