/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnpluginenterprise.rest;

import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.model.LinterConfigModel;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.SpaceConfigurationService;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="/spaceConfig")
public class SpaceAdminConfigController
extends AbstractResource {
    private final SpaceConfigurationService spaceConfigurationService;
    private final AuthValidator authValidator;

    public SpaceAdminConfigController(UserAccessor userAccessor, SpacePermissionManager spacePermissionManager, SpaceConfigurationService spaceConfigurationService, PermissionManager permissionManager, SpaceManager spaceManager) {
        super(userAccessor, spacePermissionManager);
        this.spaceConfigurationService = spaceConfigurationService;
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager, spaceManager);
    }

    @POST
    @Path(value="/{spaceKey}/linter")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response saveLinterConfig(@PathParam(value="spaceKey") String spaceKey, Map<String, String> config) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        this.createRequestContext();
        try {
            Map savedConfig = this.spaceConfigurationService.saveLinterConfig(spaceKey, config);
            return Response.ok().entity((Object)savedConfig).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Path(value="/{spaceKey}/linter")
    @Produces(value={"application/json"})
    public Response getLinterConfig(@PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        this.createRequestContext();
        return Response.ok((Object)this.spaceConfigurationService.getLinterConfig(spaceKey)).build();
    }

    @DELETE
    @Path(value="/{spaceKey}/linter")
    @Produces(value={"application/json"})
    public Response deleteLinterConfig(@PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        this.createRequestContext();
        try {
            this.spaceConfigurationService.deleteLinterConfig(spaceKey);
            return Response.ok().entity((Object)LinterConfigModel.getDefaultConfig()).build();
        }
        catch (Exception e) {
            return Response.status((int)500).build();
        }
    }

    @POST
    @Path(value="/{spaceKey}/bpmnElementsConfig")
    @Consumes(value={"application/json"})
    public Response saveBpmnElementsConfig(@PathParam(value="spaceKey") String spaceKey, Map<String, Boolean> config) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        this.createRequestContext();
        this.spaceConfigurationService.saveBpmnElementsConfig(spaceKey, config);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/{spaceKey}/bpmnElementsConfig")
    @Produces(value={"application/json"})
    public Response deleteBpmnElementsConfig(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="bpmnElementsGroup") String bpmnElementsGroup) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.ADMINISTER);
        this.createRequestContext();
        this.spaceConfigurationService.deleteBpmnElementsConfig(spaceKey, bpmnElementsGroup);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/{spaceKey}/bpmnElementsConfig")
    @Produces(value={"application/json"})
    public Response getBpmnElementsConfig(@PathParam(value="spaceKey") String spaceKey) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        this.createRequestContext();
        return Response.ok((Object)this.spaceConfigurationService.getBpmnElementsConfig(spaceKey)).build();
    }
}

