(()=>{var __webpack_modules__={"../../../../../../vXCP-enterprise-core/core-js/app/resources/viadeeXmlExtension.json":module=>{eval('module.exports = {"name":"viadee XML Extension","uri":"http://www.viadee.de","prefix":"viadee","xml":{"tagAlias":"lowerCase"},"types":[{"name":"BpmnLinks","superClass":["Element"],"meta":{"allowedIn":["bpmn:FlowElement","bpmn:RootElement","bpmn:Artifact","bpmn:ConversationNode","bpmn:EventDefinition","bpmn:Collaboration","bpmn:Expression","bpmn:Choreography","bpmn:Performer","bpmn:LoopCharacteristics","bpmn:ResourceRole","bpmn:Participant","bpmn:Lane","dmn:KnowledgeSource","dmn:Definitions","dmn:Decision","dmn:BusinessKnowledgeModel","dmn:InputData"]},"properties":[{"name":"id","isAttr":true,"type":"String"},{"name":"type","isAttr":true,"type":"String"},{"name":"macroId","isAttr":true,"type":"String"},{"name":"pageId","isAttr":true,"type":"String"},{"name":"vbcpEntId","isAttr":true,"type":"String"},{"name":"desc","isAttr":true,"type":"String"}]},{"name":"DmnLinks","superClass":["Element"],"meta":{"allowedIn":["bpmn:FlowElement","bpmn:RootElement","bpmn:Artifact","bpmn:ConversationNode","bpmn:EventDefinition","bpmn:Collaboration","bpmn:Expression","bpmn:Choreography","bpmn:Performer","bpmn:LoopCharacteristics","bpmn:ResourceRole","bpmn:Participant","bpmn:Lane","dmn:KnowledgeSource","dmn:Definitions","dmn:Decision","dmn:BusinessKnowledgeModel","dmn:InputData"]},"properties":[{"name":"id","isAttr":true,"type":"String"},{"name":"type","isAttr":true,"type":"String"},{"name":"pageId","isAttr":true,"type":"String"},{"name":"title","isAttr":true,"type":"String"},{"name":"desc","isAttr":true,"type":"String"}]},{"name":"DmnEnterpriseLinks","superClass":["Element"],"meta":{"allowedIn":["bpmn:FlowElement","bpmn:RootElement","bpmn:Artifact","bpmn:ConversationNode","bpmn:EventDefinition","bpmn:Collaboration","bpmn:Expression","bpmn:Choreography","bpmn:Performer","bpmn:LoopCharacteristics","bpmn:ResourceRole","bpmn:Participant","bpmn:Lane","dmn:KnowledgeSource","dmn:Definitions","dmn:Decision","dmn:BusinessKnowledgeModel","dmn:InputData"]},"properties":[{"name":"id","isAttr":true,"type":"String"},{"name":"type","isAttr":true,"type":"String"},{"name":"pageId","isAttr":true,"type":"String"},{"name":"vbcpEntId","isAttr":true,"type":"String"},{"name":"desc","isAttr":true,"type":"String"}]},{"name":"PageLinks","superClass":["Element"],"meta":{"allowedIn":["bpmn:FlowElement","bpmn:RootElement","bpmn:Artifact","bpmn:ConversationNode","bpmn:EventDefinition","bpmn:Collaboration","bpmn:Expression","bpmn:Choreography","bpmn:Performer","bpmn:LoopCharacteristics","bpmn:ResourceRole","bpmn:Participant","bpmn:Lane","dmn:KnowledgeSource","dmn:Definitions","dmn:Decision","dmn:BusinessKnowledgeModel","dmn:InputData"]},"properties":[{"name":"id","isAttr":true,"type":"String"},{"name":"type","isAttr":true,"type":"String"},{"name":"pageId","isAttr":true,"type":"String"},{"name":"desc","isAttr":true,"type":"String"}]},{"name":"ExternalLinks","superClass":["Element"],"meta":{"allowedIn":["bpmn:FlowElement","bpmn:RootElement","bpmn:Artifact","bpmn:ConversationNode","bpmn:EventDefinition","bpmn:Collaboration","bpmn:Expression","bpmn:Choreography","bpmn:Performer","bpmn:LoopCharacteristics","bpmn:ResourceRole","bpmn:Participant","bpmn:Lane","dmn:KnowledgeSource","dmn:Definitions","dmn:Decision","dmn:BusinessKnowledgeModel","dmn:InputData"]},"properties":[{"name":"id","isAttr":true,"type":"String"},{"name":"type","isAttr":true,"type":"String"},{"name":"title","isAttr":true,"type":"String"},{"name":"url","isAttr":true,"type":"String"},{"name":"desc","isAttr":true,"type":"String"}]},{"name":"WikiLinks","superClass":["Element"],"meta":{"allowedIn":["bpmn:FlowElement","bpmn:RootElement","bpmn:Artifact","bpmn:ConversationNode","bpmn:EventDefinition","bpmn:Collaboration","bpmn:Expression","bpmn:Choreography","bpmn:Performer","bpmn:LoopCharacteristics","bpmn:ResourceRole","bpmn:Participant","bpmn:Lane","dmn:KnowledgeSource","dmn:Definitions","dmn:Decision","dmn:BusinessKnowledgeModel","dmn:InputData"]},"properties":[{"name":"id","isAttr":true,"type":"String"},{"name":"type","isAttr":true,"type":"String"},{"name":"title","isAttr":true,"type":"String"},{"name":"url","isAttr":true,"type":"String"},{"name":"desc","isAttr":true,"type":"String"}]},{"name":"ConfluenceAttachmentLink","superClass":["Element"],"meta":{"allowedIn":["bpmn:FlowElement","bpmn:RootElement","bpmn:Artifact","bpmn:ConversationNode","bpmn:EventDefinition","bpmn:Collaboration","bpmn:Expression","bpmn:Choreography","bpmn:Performer","bpmn:LoopCharacteristics","bpmn:ResourceRole","bpmn:Participant","bpmn:Lane","dmn:KnowledgeSource","dmn:Definitions","dmn:Decision","dmn:BusinessKnowledgeModel","dmn:InputData"]},"properties":[{"name":"id","isAttr":true,"type":"String"},{"name":"type","isAttr":true,"type":"String"},{"name":"title","isAttr":true,"type":"String"},{"name":"url","isAttr":true,"type":"String"},{"name":"desc","isAttr":true,"type":"String"}]},{"name":"JiraIssueLink","superClass":["Element"],"meta":{"allowedIn":["bpmn:FlowElement","bpmn:RootElement","bpmn:Artifact","bpmn:ConversationNode","bpmn:EventDefinition","bpmn:Collaboration","bpmn:Expression","bpmn:Choreography","bpmn:Performer","bpmn:LoopCharacteristics","bpmn:ResourceRole","bpmn:Participant","bpmn:Lane","dmn:KnowledgeSource","dmn:Definitions","dmn:Decision","dmn:BusinessKnowledgeModel","dmn:InputData"]},"properties":[{"name":"id","isAttr":true,"type":"String"},{"name":"type","isAttr":true,"type":"String"},{"name":"issueKey","isAttr":true,"type":"String"},{"name":"jiraAppId","isAttr":true,"type":"String"},{"name":"appId","isAttr":true,"type":"String"},{"name":"url","isAttr":true,"type":"String"},{"name":"desc","isAttr":true,"type":"String"}]},{"name":"MdfInstance","superClass":["Element"],"meta":{"allowedIn":["bpmn:FlowElement","bpmn:RootElement","bpmn:Artifact","bpmn:ConversationNode","bpmn:EventDefinition","bpmn:Collaboration","bpmn:Expression","bpmn:Choreography","bpmn:Performer","bpmn:LoopCharacteristics","bpmn:ResourceRole","bpmn:Participant","bpmn:Lane"]},"properties":[{"name":"id","isAttr":true,"type":"String"},{"name":"type","isAttr":true,"type":"String"},{"name":"mdfInstanceId","isAttr":true,"type":"String"},{"name":"mdfValueId","isAttr":true,"type":"String"},{"name":"mdfDefinitionId","isAttr":true,"type":"String"},{"name":"desc","isAttr":true,"type":"String"}]},{"name":"Comments","superClass":["Element"],"meta":{"allowedIn":["bpmn:FlowElement","bpmn:RootElement","bpmn:Artifact","bpmn:ConversationNode","bpmn:EventDefinition","bpmn:Collaboration","bpmn:Expression","bpmn:Choreography","bpmn:Performer","bpmn:LoopCharacteristics","bpmn:ResourceRole","bpmn:Participant","bpmn:Lane","dmn:KnowledgeSource","dmn:Definitions","dmn:Decision","dmn:BusinessKnowledgeModel","dmn:InputData"]},"properties":[{"name":"textFormat","isAttr":true,"type":"String"},{"name":"text","isAttr":true,"type":"String"}]},{"name":"Comment","superClass":["Element"],"meta":{"allowedIn":["bpmn:FlowElement","bpmn:RootElement","bpmn:Artifact","bpmn:ConversationNode","bpmn:EventDefinition","bpmn:Collaboration","bpmn:Expression","bpmn:Choreography","bpmn:Performer","bpmn:LoopCharacteristics","bpmn:ResourceRole","bpmn:Participant","bpmn:Lane","dmn:KnowledgeSource","dmn:Definitions","dmn:Decision","dmn:BusinessKnowledgeModel","dmn:InputData"]},"properties":[{"name":"userKey","isAttr":true,"type":"String"},{"name":"dateTime","isAttr":true,"type":"String"},{"name":"resolved","isAttr":true,"type":"String"},{"name":"content","isAttr":true,"type":"String"}]}],"enumerations":[],"associations":[]}\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/core-js/app/resources/viadeeXmlExtension.json?')},"../../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ VxcpLogger)\n/* harmony export */ });\nclass VxcpLogger {\n    constructor(pluginName, serviceName, isEnabled = true) {\n        this.pluginName = pluginName;\n        this.serviceName = serviceName;\n        this.isEnabled = isEnabled;\n    }\n    logFatal(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`FATAL@${logHeader}: ${description}`);\n        }\n    }\n    logError(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`ERROR@${logHeader}: ${description}`);\n        }\n    }\n    logWarning(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.warn(`WARNING@${logHeader}: ${description}`);\n        }\n    }\n    logInfo(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.info(`INFO@${logHeader}: ${description}`);\n        }\n    }\n    enableLogging(isEnabled = true) {\n        this.isEnabled = isEnabled;\n    }\n    getLogHeader(methodName) {\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\n    }\n}\n\n\n//# sourceURL=webpack://VBCP/../../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"./plugin-specific/factory/language-factory.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"getDifferComponent\": () => (/* binding */ getDifferComponent),\n  \"getDisableKeyboardBindingModule\": () => (/* binding */ getDisableKeyboardBindingModule),\n  \"getLanguageRestService\": () => (/* binding */ getLanguageRestService),\n  \"getLanguageService\": () => (/* binding */ getLanguageService),\n  \"getTaskResizeModule\": () => (/* binding */ getTaskResizeModule)\n});\n\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/Viewer.js + 13 modules\nvar Viewer = __webpack_require__(\"./node_modules/bpmn-js/lib/Viewer.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/Modeler.js + 124 modules\nvar Modeler = __webpack_require__(\"./node_modules/bpmn-js/lib/Modeler.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/NavigatedViewer.js\nvar NavigatedViewer = __webpack_require__(\"./node_modules/bpmn-js/lib/NavigatedViewer.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js-minimap/node_modules/min-dom/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js-minimap/node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js-minimap/node_modules/min-dash/dist/index.esm.js\nvar min_dash_dist_index_esm = __webpack_require__(\"./node_modules/diagram-js-minimap/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/hammerjs/hammer.js\nvar hammer = __webpack_require__(\"./node_modules/hammerjs/hammer.js\");\nvar hammer_default = /*#__PURE__*/__webpack_require__.n(hammer);\n// EXTERNAL MODULE: ./node_modules/css.escape/css.escape.js\nvar css_escape = __webpack_require__(\"./node_modules/css.escape/css.escape.js\");\nvar css_escape_default = /*#__PURE__*/__webpack_require__.n(css_escape);\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/GraphicsUtil.js\nvar GraphicsUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/GraphicsUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js-minimap/dist/index.esm.js\n\n\n\n\n\n\n\nvar MINIMAP_VIEWBOX_PADDING = 50;\n\nvar RANGE = { min: 0.2, max: 4 },\n    NUM_STEPS = 10;\n\nvar DELTA_THRESHOLD = 0.1;\n\nvar LOW_PRIORITY = 250;\n\n\n/**\n * A minimap that reflects and lets you navigate the diagram.\n */\nfunction Minimap(\n    config, injector, eventBus,\n    canvas, elementRegistry) {\n\n  var self = this;\n\n  this._canvas = canvas;\n  this._elementRegistry = elementRegistry;\n  this._eventBus = eventBus;\n  this._injector = injector;\n\n  this._state = {\n    isOpen: undefined,\n    isDragging: false,\n    initialDragPosition: null,\n    offsetViewport: null,\n    cachedViewbox: null,\n    dragger: null,\n    svgClientRect: null,\n    parentClientRect: null,\n    zoomDelta: 0\n  };\n\n  this._init();\n\n  var documentManager = new (hammer_default()).Manager(document);\n\n  documentManager.add(new (hammer_default()).Pan());\n  documentManager.on('panmove', onMousemove);\n  documentManager.on('panend', onMouseup);\n\n  var svgManager = new (hammer_default()).Manager(this._svg);\n\n  svgManager.add(new (hammer_default()).Pan());\n  svgManager.on('panstart', mousedown(true));\n\n  svgManager.add(new (hammer_default()).Tap());\n  svgManager.on('tap', function(event) {\n    centerViewbox(getPoint(event));\n  });\n\n  var viewportDomManager = new (hammer_default()).Manager(this._viewportDom);\n\n  viewportDomManager.add(new (hammer_default()).Pan());\n  viewportDomManager.on('panstart', mousedown(false));\n\n  this.toggle((config && config.open) || false);\n\n  function centerViewbox(point) {\n\n    // getBoundingClientRect might return zero-dimensional when called for the first time\n    if (!self._state._svgClientRect || isZeroDimensional(self._state._svgClientRect)) {\n      self._state._svgClientRect = self._svg.getBoundingClientRect();\n    }\n\n    var diagramPoint = mapMousePositionToDiagramPoint({\n      x: point.x - self._state._svgClientRect.left,\n      y: point.y - self._state._svgClientRect.top\n    }, self._svg, self._lastViewbox);\n\n    setViewboxCenteredAroundPoint(diagramPoint, self._canvas);\n\n    self._update();\n  }\n\n  function mousedown(center) {\n\n    return function onMousedown(event$1) {\n      var point = getPoint(event$1);\n\n      // getBoundingClientRect might return zero-dimensional when called for the first time\n      if (!self._state._svgClientRect || isZeroDimensional(self._state._svgClientRect)) {\n        self._state._svgClientRect = self._svg.getBoundingClientRect();\n      }\n\n      if (center) {\n        centerViewbox(point);\n      }\n\n      var diagramPoint = mapMousePositionToDiagramPoint({\n        x: point.x - self._state._svgClientRect.left,\n        y: point.y - self._state._svgClientRect.top\n      }, self._svg, self._lastViewbox);\n\n      var viewbox = canvas.viewbox();\n\n      var offsetViewport = getOffsetViewport(diagramPoint, viewbox);\n\n      var initialViewportDomRect = self._viewportDom.getBoundingClientRect();\n\n      // take border into account (regardless of width)\n      var offsetViewportDom = {\n        x: point.x - initialViewportDomRect.left + 1,\n        y: point.y - initialViewportDomRect.top + 1\n      };\n\n      // init dragging\n      (0,min_dash_dist_index_esm/* assign */.f0)(self._state, {\n        cachedViewbox: viewbox,\n        initialDragPosition: {\n          x: point.x,\n          y: point.y\n        },\n        isDragging: true,\n        offsetViewport: offsetViewport,\n        offsetViewportDom: offsetViewportDom,\n        viewportClientRect: self._viewport.getBoundingClientRect(),\n        parentClientRect: self._parent.getBoundingClientRect()\n      });\n\n      index_esm/* event.bind */.B.bind(document, 'mousemove', onMousemove);\n      index_esm/* event.bind */.B.bind(document, 'mouseup', onMouseup);\n    };\n  }\n\n  function onMousemove(event) {\n    var point = getPoint(event);\n\n    // set viewbox if dragging active\n    if (self._state.isDragging) {\n\n      // getBoundingClientRect might return zero-dimensional when called for the first time\n      if (!self._state._svgClientRect || isZeroDimensional(self._state._svgClientRect)) {\n        self._state._svgClientRect = self._svg.getBoundingClientRect();\n      }\n\n      // update viewport DOM\n      var offsetViewportDom = self._state.offsetViewportDom,\n          viewportClientRect = self._state.viewportClientRect,\n          parentClientRect = self._state.parentClientRect;\n\n      (0,min_dash_dist_index_esm/* assign */.f0)(self._viewportDom.style, {\n        top: (point.y - offsetViewportDom.y - parentClientRect.top) + 'px',\n        left: (point.x - offsetViewportDom.x - parentClientRect.left) + 'px'\n      });\n\n      // update overlay\n      var clipPath = getOverlayClipPath(parentClientRect, {\n        top: point.y - offsetViewportDom.y - parentClientRect.top,\n        left: point.x - offsetViewportDom.x - parentClientRect.left,\n        width: viewportClientRect.width,\n        height: viewportClientRect.height\n      });\n\n      (0,min_dash_dist_index_esm/* assign */.f0)(self._overlay.style, {\n        clipPath: clipPath\n      });\n\n      var diagramPoint = mapMousePositionToDiagramPoint({\n        x: point.x - self._state._svgClientRect.left,\n        y: point.y - self._state._svgClientRect.top\n      }, self._svg, self._lastViewbox);\n\n      setViewboxCenteredAroundPoint({\n        x: diagramPoint.x - self._state.offsetViewport.x,\n        y: diagramPoint.y - self._state.offsetViewport.y\n      }, self._canvas);\n    }\n  }\n\n  function onMouseup(event$1) {\n    var point = getPoint(event$1);\n\n    if (self._state.isDragging) {\n\n      // treat event as click\n      if (self._state.initialDragPosition.x === point.x\n          && self._state.initialDragPosition.y === point.y) {\n        centerViewbox(event$1);\n      }\n\n      self._update();\n\n      // end dragging\n      (0,min_dash_dist_index_esm/* assign */.f0)(self._state, {\n        cachedViewbox: null,\n        initialDragPosition: null,\n        isDragging: false,\n        offsetViewport: null,\n        offsetViewportDom: null\n      });\n\n      index_esm/* event.unbind */.B.unbind(document, 'mousemove', onMousemove);\n      index_esm/* event.unbind */.B.unbind(document, 'mouseup', onMouseup);\n    }\n  }\n\n  // dragging viewport scrolls canvas\n  index_esm/* event.bind */.B.bind(this._viewportDom, 'mousedown', mousedown(false));\n  index_esm/* event.bind */.B.bind(this._svg, 'mousedown', mousedown(true));\n\n  index_esm/* event.bind */.B.bind(this._parent, 'wheel', function(event) {\n\n    // stop propagation and handle scroll differently\n    event.preventDefault();\n    event.stopPropagation();\n\n    // only zoom in on ctrl; this aligns with diagram-js navigation behavior\n    if (!event.ctrlKey) {\n      return;\n    }\n\n    // getBoundingClientRect might return zero-dimensional when called for the first time\n    if (!self._state._svgClientRect || isZeroDimensional(self._state._svgClientRect)) {\n      self._state._svgClientRect = self._svg.getBoundingClientRect();\n    }\n\n    // disallow zooming through viewport outside of minimap as it is very confusing\n    if (!isPointInside(event, self._state._svgClientRect)) {\n      return;\n    }\n\n    var factor = event.deltaMode === 0 ? 0.020 : 0.32;\n\n    var delta = (\n      Math.sqrt(\n        Math.pow(event.deltaY, 2) +\n        Math.pow(event.deltaX, 2)\n      ) * sign(event.deltaY) * -factor\n    );\n\n    // add until threshold reached\n    self._state.zoomDelta += delta;\n\n    if (Math.abs(self._state.zoomDelta) > DELTA_THRESHOLD) {\n      var direction = delta > 0 ? 1 : -1;\n\n      var currentLinearZoomLevel = Math.log(canvas.zoom()) / Math.log(10);\n\n      // zoom with half the step size of stepZoom\n      var stepSize = getStepSize(RANGE, NUM_STEPS * 2);\n\n      // snap to a proximate zoom step\n      var newLinearZoomLevel = Math.round(currentLinearZoomLevel / stepSize) * stepSize;\n\n      // increase or decrease one zoom step in the given direction\n      newLinearZoomLevel += stepSize * direction;\n\n      // calculate the absolute logarithmic zoom level based on the linear zoom level\n      // (e.g. 2 for an absolute x2 zoom)\n      var newLogZoomLevel = Math.pow(10, newLinearZoomLevel);\n\n      canvas.zoom(cap(RANGE, newLogZoomLevel), diagramPoint);\n\n      // reset\n      self._state.zoomDelta = 0;\n\n      var diagramPoint = mapMousePositionToDiagramPoint({\n        x: event.clientX - self._state._svgClientRect.left,\n        y: event.clientY - self._state._svgClientRect.top\n      }, self._svg, self._lastViewbox);\n\n      setViewboxCenteredAroundPoint(diagramPoint, self._canvas);\n\n      self._update();\n    }\n  });\n\n  index_esm/* event.bind */.B.bind(this._toggle, 'click', function(event) {\n    event.preventDefault();\n    event.stopPropagation();\n\n    self.toggle();\n  });\n\n  // add shape on shape/connection added\n  eventBus.on([ 'shape.added', 'connection.added' ], function(context) {\n    var element = context.element;\n\n    self._addElement(element);\n\n    self._update();\n  });\n\n  // remove shape on shape/connection removed\n  eventBus.on([ 'shape.removed', 'connection.removed' ], function(context) {\n    var element = context.element;\n\n    self._removeElement(element);\n\n    self._update();\n  });\n\n  // update on elements changed\n  eventBus.on('elements.changed', LOW_PRIORITY, function(context) {\n    var elements = context.elements;\n\n    elements.forEach(function(element) {\n      self._updateElement(element);\n    });\n\n    self._update();\n  });\n\n  // update on element ID update\n  eventBus.on('element.updateId', function(context) {\n    var element = context.element,\n        newId = context.newId;\n\n    self._updateElementId(element, newId);\n  });\n\n  // update on viewbox changed\n  eventBus.on('canvas.viewbox.changed', function() {\n    if (!self._state.isDragging) {\n      self._update();\n    }\n  });\n\n  eventBus.on('canvas.resized', function() {\n\n    // only update if present in DOM\n    if (document.body.contains(self._parent)) {\n      if (!self._state.isDragging) {\n        self._update();\n      }\n\n      self._state._svgClientRect = self._svg.getBoundingClientRect();\n    }\n\n  });\n\n  eventBus.on([ 'root.set', 'plane.set' ], function(event) {\n    self._clear();\n\n    var element = event.element || event.plane.rootElement;\n\n    element.children.forEach(function(el) {\n      self._addElement(el);\n    });\n\n    self._update();\n  });\n\n}\n\nMinimap.$inject = [\n  'config.minimap',\n  'injector',\n  'eventBus',\n  'canvas',\n  'elementRegistry'\n];\n\nMinimap.prototype._init = function() {\n  var canvas = this._canvas,\n      container = canvas.getContainer();\n\n  // create parent div\n  var parent = this._parent = document.createElement('div');\n\n  (0,index_esm/* classes */.Sh)(parent).add('djs-minimap');\n\n  container.appendChild(parent);\n\n  // create toggle\n  var toggle = this._toggle = document.createElement('div');\n\n  (0,index_esm/* classes */.Sh)(toggle).add('toggle');\n\n  parent.appendChild(toggle);\n\n  // create map\n  var map = this._map = document.createElement('div');\n\n  (0,index_esm/* classes */.Sh)(map).add('map');\n\n  parent.appendChild(map);\n\n  // create svg\n  var svg = this._svg = (0,dist_index_esm/* create */.Ue)('svg');\n  (0,dist_index_esm/* attr */.Lj)(svg, { width: '100%', height: '100%' });\n  (0,dist_index_esm/* append */.R3)(map, svg);\n\n  // add groups\n  var elementsGroup = this._elementsGroup = (0,dist_index_esm/* create */.Ue)('g');\n  (0,dist_index_esm/* append */.R3)(svg, elementsGroup);\n\n  var viewportGroup = this._viewportGroup = (0,dist_index_esm/* create */.Ue)('g');\n  (0,dist_index_esm/* append */.R3)(svg, viewportGroup);\n\n  // add viewport SVG\n  var viewport = this._viewport = (0,dist_index_esm/* create */.Ue)('rect');\n\n  (0,dist_index_esm/* classes */.Sh)(viewport).add('viewport');\n\n  (0,dist_index_esm/* append */.R3)(viewportGroup, viewport);\n\n  // prevent drag propagation\n  index_esm/* event.bind */.B.bind(parent, 'mousedown', function(event) {\n    event.stopPropagation();\n  });\n\n  // add viewport DOM\n  var viewportDom = this._viewportDom = document.createElement('div');\n\n  (0,index_esm/* classes */.Sh)(viewportDom).add('viewport-dom');\n\n  this._parent.appendChild(viewportDom);\n\n  // add overlay\n  var overlay = this._overlay = document.createElement('div');\n\n  (0,index_esm/* classes */.Sh)(overlay).add('overlay');\n\n  this._parent.appendChild(overlay);\n};\n\nMinimap.prototype._update = function() {\n  var viewbox = this._canvas.viewbox(),\n      innerViewbox = viewbox.inner,\n      outerViewbox = viewbox.outer;\n\n  if (!validViewbox(viewbox)) {\n    return;\n  }\n\n  var x, y, width, height;\n\n  var widthDifference = outerViewbox.width - innerViewbox.width,\n      heightDifference = outerViewbox.height - innerViewbox.height;\n\n  // update viewbox\n  // x\n  if (innerViewbox.width < outerViewbox.width) {\n    x = innerViewbox.x - widthDifference / 2;\n    width = outerViewbox.width;\n\n    if (innerViewbox.x + innerViewbox.width < outerViewbox.width) {\n      x = Math.min(0, innerViewbox.x);\n    }\n  } else {\n    x = innerViewbox.x;\n    width = innerViewbox.width;\n  }\n\n  // y\n  if (innerViewbox.height < outerViewbox.height) {\n    y = innerViewbox.y - heightDifference / 2;\n    height = outerViewbox.height;\n\n    if (innerViewbox.y + innerViewbox.height < outerViewbox.height) {\n      y = Math.min(0, innerViewbox.y);\n    }\n  } else {\n    y = innerViewbox.y;\n    height = innerViewbox.height;\n  }\n\n  // apply some padding\n  x = x - MINIMAP_VIEWBOX_PADDING;\n  y = y - MINIMAP_VIEWBOX_PADDING;\n  width = width + MINIMAP_VIEWBOX_PADDING * 2;\n  height = height + MINIMAP_VIEWBOX_PADDING * 2;\n\n  this._lastViewbox = {\n    x: x,\n    y: y,\n    width: width,\n    height: height\n  };\n\n  (0,dist_index_esm/* attr */.Lj)(this._svg, {\n    viewBox: x + ', ' + y + ', ' + width + ', ' + height\n  });\n\n  // update viewport SVG\n  (0,dist_index_esm/* attr */.Lj)(this._viewport, {\n    x: viewbox.x,\n    y: viewbox.y,\n    width: viewbox.width,\n    height: viewbox.height\n  });\n\n  // update viewport DOM\n  var parentClientRect = this._state._parentClientRect = this._parent.getBoundingClientRect();\n  var viewportClientRect = this._viewport.getBoundingClientRect();\n\n  var withoutParentOffset = {\n    top: viewportClientRect.top - parentClientRect.top,\n    left: viewportClientRect.left - parentClientRect.left,\n    width: viewportClientRect.width,\n    height: viewportClientRect.height\n  };\n\n  (0,min_dash_dist_index_esm/* assign */.f0)(this._viewportDom.style, {\n    top: withoutParentOffset.top + 'px',\n    left: withoutParentOffset.left + 'px',\n    width: withoutParentOffset.width + 'px',\n    height: withoutParentOffset.height + 'px'\n  });\n\n  // update overlay\n  var clipPath = getOverlayClipPath(parentClientRect, withoutParentOffset);\n\n  (0,min_dash_dist_index_esm/* assign */.f0)(this._overlay.style, {\n    clipPath: clipPath\n  });\n};\n\nMinimap.prototype.open = function() {\n  (0,min_dash_dist_index_esm/* assign */.f0)(this._state, { isOpen: true });\n\n  (0,index_esm/* classes */.Sh)(this._parent).add('open');\n\n  var translate = this._injector.get('translate', false) || function(s) { return s; };\n\n  (0,index_esm/* attr */.Lj)(this._toggle, 'title', translate('Close minimap'));\n\n  this._update();\n\n  this._eventBus.fire('minimap.toggle', { open: true });\n};\n\nMinimap.prototype.close = function() {\n  (0,min_dash_dist_index_esm/* assign */.f0)(this._state, { isOpen: false });\n\n  (0,index_esm/* classes */.Sh)(this._parent).remove('open');\n\n  var translate = this._injector.get('translate', false) || function(s) { return s; };\n\n  (0,index_esm/* attr */.Lj)(this._toggle, 'title', translate('Open minimap'));\n\n  this._eventBus.fire('minimap.toggle', { open: false });\n};\n\nMinimap.prototype.toggle = function(open) {\n\n  var currentOpen = this.isOpen();\n\n  if (typeof open === 'undefined') {\n    open = !currentOpen;\n  }\n\n  if (open == currentOpen) {\n    return;\n  }\n\n  if (open) {\n    this.open();\n  } else {\n    this.close();\n  }\n};\n\nMinimap.prototype.isOpen = function() {\n  return this._state.isOpen;\n};\n\nMinimap.prototype._updateElement = function(element) {\n\n  try {\n\n    // if parent is null element has been removed, if parent is undefined parent is root\n    if (element.parent !== undefined && element.parent !== null) {\n      this._removeElement(element);\n      this._addElement(element);\n    }\n  } catch (error) {\n    console.warn('Minimap#_updateElement errored', error);\n  }\n\n};\n\nMinimap.prototype._updateElementId = function(element, newId) {\n\n  try {\n    var elementGfx = (0,index_esm/* query */.IO)('#' + css_escape_default()(element.id), this._elementsGroup);\n\n    if (elementGfx) {\n      elementGfx.id = newId;\n    }\n  } catch (error) {\n    console.warn('Minimap#_updateElementId errored', error);\n  }\n\n};\n\n/**\n * Checks if an element is on the currently active plane.\n */\nMinimap.prototype.isOnActivePlane = function(element) {\n  var canvas = this._canvas;\n\n  // diagram-js@8\n  if (canvas.findRoot) {\n    return canvas.findRoot(element) === canvas.getRootElement();\n  }\n\n  // diagram-js>=7.4.0\n  if (canvas.findPlane) {\n    return canvas.findPlane(element) === canvas.getActivePlane();\n  }\n\n  // diagram-js<7.4.0\n  return true;\n};\n\n\n/**\n * Adds an element to the minimap.\n */\nMinimap.prototype._addElement = function(element) {\n  var self = this;\n\n  this._removeElement(element);\n\n  if (!this.isOnActivePlane(element)) {\n    return;\n  }\n\n  var parent,\n      x, y;\n\n  var newElementGfx = this._createElement(element);\n  var newElementParentGfx = (0,index_esm/* query */.IO)('#' + css_escape_default()(element.parent.id), this._elementsGroup);\n\n  if (newElementGfx) {\n\n    var elementGfx = this._elementRegistry.getGraphics(element);\n    var parentGfx = this._elementRegistry.getGraphics(element.parent);\n\n    var index = getIndexOfChildInParentChildren(elementGfx, parentGfx);\n\n    // index can be 0\n    if (index !== 'undefined') {\n      if (newElementParentGfx) {\n\n        // in cases of doubt add as last child\n        if (newElementParentGfx.childNodes.length > index) {\n          insertChildAtIndex(newElementGfx, newElementParentGfx, index);\n        } else {\n          insertChildAtIndex(newElementGfx, newElementParentGfx, newElementParentGfx.childNodes.length - 1);\n        }\n\n      } else {\n        this._elementsGroup.appendChild(newElementGfx);\n      }\n\n    } else {\n\n      // index undefined\n      this._elementsGroup.appendChild(newElementGfx);\n    }\n\n    if (isConnection(element)) {\n      parent = element.parent;\n      x = 0;\n      y = 0;\n\n      if (typeof parent.x !== 'undefined' && typeof parent.y !== 'undefined') {\n        x = -parent.x;\n        y = -parent.y;\n      }\n\n      (0,dist_index_esm/* attr */.Lj)(newElementGfx, { transform: 'translate(' + x + ' ' + y + ')' });\n    } else {\n      x = element.x;\n      y = element.y;\n\n      if (newElementParentGfx) {\n        parent = element.parent;\n\n        x -= parent.x;\n        y -= parent.y;\n      }\n\n      (0,dist_index_esm/* attr */.Lj)(newElementGfx, { transform: 'translate(' + x + ' ' + y + ')' });\n    }\n\n    if (element.children && element.children.length) {\n      element.children.forEach(function(child) {\n        self._addElement(child);\n      });\n    }\n\n    return newElementGfx;\n  }\n};\n\nMinimap.prototype._removeElement = function(element) {\n  var elementGfx = this._svg.getElementById(element.id);\n\n  if (elementGfx) {\n    (0,dist_index_esm/* remove */.Od)(elementGfx);\n  }\n};\n\nMinimap.prototype._createElement = function(element) {\n  var gfx = this._elementRegistry.getGraphics(element),\n      visual;\n\n  if (gfx) {\n    visual = (0,GraphicsUtil/* getVisual */.s)(gfx);\n\n    if (visual) {\n      var elementGfx = (0,dist_index_esm/* clone */.d9)(visual);\n      (0,dist_index_esm/* attr */.Lj)(elementGfx, { id: element.id });\n\n      return elementGfx;\n    }\n  }\n};\n\nMinimap.prototype._clear = function() {\n  (0,dist_index_esm/* clear */.ZH)(this._elementsGroup);\n};\n\nfunction isConnection(element) {\n  return element.waypoints;\n}\n\nfunction getOffsetViewport(diagramPoint, viewbox) {\n  var viewboxCenter = {\n    x: viewbox.x + (viewbox.width / 2),\n    y: viewbox.y + (viewbox.height / 2)\n  };\n\n  return {\n    x: diagramPoint.x - viewboxCenter.x,\n    y: diagramPoint.y - viewboxCenter.y\n  };\n}\n\nfunction mapMousePositionToDiagramPoint(position, svg, lastViewbox) {\n\n  // firefox returns 0 for clientWidth and clientHeight\n  var boundingClientRect = svg.getBoundingClientRect();\n\n  // take different aspect ratios of default layers bounding box and minimap into account\n  var bBox =\n    fitAspectRatio(lastViewbox, boundingClientRect.width / boundingClientRect.height);\n\n  // map click position to diagram position\n  var diagramX = map(position.x, 0, boundingClientRect.width, bBox.x, bBox.x + bBox.width),\n      diagramY = map(position.y, 0, boundingClientRect.height, bBox.y, bBox.y + bBox.height);\n\n  return {\n    x: diagramX,\n    y: diagramY\n  };\n}\n\nfunction setViewboxCenteredAroundPoint(point, canvas) {\n\n  // get cached viewbox to preserve zoom\n  var cachedViewbox = canvas.viewbox(),\n      cachedViewboxWidth = cachedViewbox.width,\n      cachedViewboxHeight = cachedViewbox.height;\n\n  canvas.viewbox({\n    x: point.x - cachedViewboxWidth / 2,\n    y: point.y - cachedViewboxHeight / 2,\n    width: cachedViewboxWidth,\n    height: cachedViewboxHeight\n  });\n}\n\nfunction fitAspectRatio(bounds, targetAspectRatio) {\n  var aspectRatio = bounds.width / bounds.height;\n\n  // assigning to bounds throws exception in IE11\n  var newBounds = (0,min_dash_dist_index_esm/* assign */.f0)({}, {\n    x: bounds.x,\n    y: bounds.y,\n    width: bounds.width,\n    height: bounds.height\n  });\n\n  if (aspectRatio > targetAspectRatio) {\n\n    // height needs to be fitted\n    var height = newBounds.width * (1 / targetAspectRatio),\n        y = newBounds.y - ((height - newBounds.height) / 2);\n\n    (0,min_dash_dist_index_esm/* assign */.f0)(newBounds, {\n      y: y,\n      height: height\n    });\n  } else if (aspectRatio < targetAspectRatio) {\n\n    // width needs to be fitted\n    var width = newBounds.height * targetAspectRatio,\n        x = newBounds.x - ((width - newBounds.width) / 2);\n\n    (0,min_dash_dist_index_esm/* assign */.f0)(newBounds, {\n      x: x,\n      width: width\n    });\n  }\n\n  return newBounds;\n}\n\nfunction map(x, inMin, inMax, outMin, outMax) {\n  var inRange = inMax - inMin,\n      outRange = outMax - outMin;\n\n  return (x - inMin) * outRange / inRange + outMin;\n}\n\n/**\n * Returns index of child in children of parent.\n *\n * g\n * '- g.djs-element // parentGfx\n * '- g.djs-children\n *    '- g\n *       '-g.djs-element // childGfx\n */\nfunction getIndexOfChildInParentChildren(childGfx, parentGfx) {\n  var childrenGroup = (0,index_esm/* query */.IO)('.djs-children', parentGfx.parentNode);\n\n  if (!childrenGroup) {\n    return;\n  }\n\n  var childrenArray = [].slice.call(childrenGroup.childNodes);\n\n  var indexOfChild = -1;\n\n  childrenArray.forEach(function(childGroup, index) {\n    if ((0,index_esm/* query */.IO)('.djs-element', childGroup) === childGfx) {\n      indexOfChild = index;\n    }\n  });\n\n  return indexOfChild;\n}\n\nfunction insertChildAtIndex(childGfx, parentGfx, index) {\n  var childContainer = getChildContainer(parentGfx);\n\n  var childrenArray = [].slice.call(childContainer.childNodes);\n\n  var childAtIndex = childrenArray[index];\n\n  if (childAtIndex) {\n    parentGfx.insertBefore(childGfx, childAtIndex.nextSibling);\n  } else {\n    parentGfx.appendChild(childGfx);\n  }\n}\n\nfunction getChildContainer(parentGfx) {\n  var container = (0,index_esm/* query */.IO)('.children', parentGfx);\n\n  if (!container) {\n    container = (0,dist_index_esm/* create */.Ue)('g', { class: 'children' });\n    (0,dist_index_esm/* append */.R3)(parentGfx, container);\n  }\n\n  return container;\n}\n\nfunction isZeroDimensional(clientRect) {\n  return clientRect.width === 0 && clientRect.height === 0;\n}\n\nfunction isPointInside(point, rect) {\n  return point.x > rect.left\n    && point.x < rect.left + rect.width\n    && point.y > rect.top\n    && point.y < rect.top + rect.height;\n}\n\nvar sign = Math.sign || function(n) {\n  return n >= 0 ? 1 : -1;\n};\n\n/**\n * Get step size for given range and number of steps.\n *\n * @param {Object} range - Range.\n * @param {number} range.min - Range minimum.\n * @param {number} range.max - Range maximum.\n */\nfunction getStepSize(range, steps) {\n\n  var minLinearRange = Math.log(range.min) / Math.log(10),\n      maxLinearRange = Math.log(range.max) / Math.log(10);\n\n  var absoluteLinearRange = Math.abs(minLinearRange) + Math.abs(maxLinearRange);\n\n  return absoluteLinearRange / steps;\n}\n\nfunction cap(range, scale) {\n  return Math.max(range.min, Math.min(range.max, scale));\n}\n\nfunction getOverlayClipPath(outer, inner) {\n  var coordinates = [\n    toCoordinatesString(inner.left, inner.top),\n    toCoordinatesString(inner.left + inner.width, inner.top),\n    toCoordinatesString(inner.left + inner.width, inner.top + inner.height),\n    toCoordinatesString(inner.left, inner.top + inner.height),\n    toCoordinatesString(inner.left, outer.height),\n    toCoordinatesString(outer.width, outer.height),\n    toCoordinatesString(outer.width, 0),\n    toCoordinatesString(0, 0),\n    toCoordinatesString(0, outer.height),\n    toCoordinatesString(inner.left, outer.height)\n  ].join(', ');\n\n  return 'polygon(' + coordinates + ')';\n}\n\nfunction toCoordinatesString(x, y) {\n  return x + 'px ' + y + 'px';\n}\n\nfunction validViewbox(viewBox) {\n\n  return (0,min_dash_dist_index_esm/* every */.yW)(viewBox, function(value) {\n\n    // check deeper structures like inner or outer viewbox\n    if ((0,min_dash_dist_index_esm/* isObject */.Kn)(value)) {\n      return validViewbox(value);\n    }\n\n    return (0,min_dash_dist_index_esm/* isNumber */.hj)(value) && isFinite(value);\n  });\n}\n\nfunction getPoint(event) {\n  if (event.center) {\n    return event.center;\n  }\n\n  return {\n    x: event.clientX,\n    y: event.clientY\n  };\n}\n\nvar index = {\r\n  __init__: [ 'minimap' ],\r\n  minimap: [ 'type', Minimap ]\r\n};\n\n\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js-origin/lib/configure-origin.js\n\n\nvar CROSS_COLOR = '#CCC',\n    BORDER_COLOR = 'rgba(0,0,0,0.1)';\n\n\n/**\n * A diagram-js extension that shows a (0, 0) origin indicator\n * on the canvas as well as (optionally) the canvas borders.\n *\n * @param {Object} [config]\n * @param {Canvas} canvas\n */\nfunction ConfigureOrigin(config, canvas) {\n\n  config = config || {};\n\n  var borderColor = config.borderColor || BORDER_COLOR,\n      crossColor = config.crossColor || CROSS_COLOR ;\n\n  var w = 30, h = 2,\n      w_half = w / 2,\n      s = -h / 2,\n      lineStart = w_half + 7;\n\n  var parent = canvas.getLayer('djs-origin', -1);\n\n  var g,\n      line,\n      cross,\n      label;\n\n  g = createEl('g', {\n    'pointer-events': 'none'\n  });\n\n  (0,dist_index_esm/* append */.R3)(parent, g);\n\n  if (config.showBorder !== false) {\n\n    // the dashed lines, marking positive document coordinates\n    line = createEl('path', {\n      'class': cls('border'),\n      'd': path([\n        'M', -lineStart, s,\n        'H', -1000,\n        'M', lineStart, s,\n        'H', 6000,\n        'M', s, -lineStart,\n        'V', -1000,\n        'M', s, lineStart,\n        'V', 3000\n      ]),\n      'fill': 'none',\n      'stroke': borderColor,\n      'stroke-width': h + 'px',\n      'stroke-dasharray': '6, 6',\n      'shape-rendering': 'crispedges'\n    });\n\n    (0,dist_index_esm/* append */.R3)(g, line);\n  }\n\n  // the cross that marks the diagram origin\n  cross = createEl('path', {\n    d: path([\n      'M', -w_half, s,\n      'H', w_half,\n      'M', s, -w_half,\n      'V', w_half\n    ]),\n    'class': cls('cross'),\n    'fill': 'none',\n    'stroke': crossColor,\n    'stroke-width': h + 'px',\n    'stroke-linecap': 'round'\n  });\n\n  (0,dist_index_esm/* append */.R3)(g, cross);\n\n  label = createEl('text', {\n    x: -40,\n    y: -10,\n    fill: crossColor,\n    'class': cls('label'),\n  });\n\n  label.textContent = '(0, 0)';\n\n  (0,dist_index_esm/* append */.R3)(g, label);\n}\n\nConfigureOrigin.$inject = [\n  'config.origin',\n  'canvas'\n];\n\n\n// helpers ///////////////////////////////////\n\nfunction path(parts) {\n  return parts.join(' ');\n}\n\nfunction cls(name) {\n  return 'djs-origin-' + name;\n}\n\nfunction createEl(type, attrs) {\n\n  var el = (0,dist_index_esm/* create */.Ue)(type);\n\n  (0,dist_index_esm/* attr */.Lj)(el, attrs);\n\n  return el;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js-origin/index.js\n\n\n/* harmony default export */ const diagram_js_origin = ({\n  __init__: [\n    ConfigureOrigin\n  ]\n});\n// EXTERNAL MODULE: ./node_modules/bpmnlint/lib/index.js\nvar lib = __webpack_require__(\"./node_modules/bpmnlint/lib/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar node_modules_min_dash_dist_index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar min_dom_dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js-bpmnlint/node_modules/diagram-js/lib/util/EscapeUtil.js\nvar EscapeUtil = __webpack_require__(\"./node_modules/bpmn-js-bpmnlint/node_modules/diagram-js/lib/util/EscapeUtil.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/util/ModelUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-bpmnlint/dist/index.esm.js\n\n\n\n\n\n\nfunction EditorActions(injector, linting) {\n  var editorActions = injector.get('editorActions', false);\n\n  editorActions && editorActions.register({\n    toggleLinting: function() {\n      linting.toggle();\n    }\n  });\n}\n\nEditorActions.$inject = [\n  'injector',\n  'linting'\n];\n\nvar ErrorSvg = \"<svg width=\\\"12\\\" height=\\\"12\\\" xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 352 512\\\"><path fill=\\\"currentColor\\\" d=\\\"M242.72 256l100.07-100.07c12.28-12.28 12.28-32.19 0-44.48l-22.24-22.24c-12.28-12.28-32.19-12.28-44.48 0L176 189.28 75.93 89.21c-12.28-12.28-32.19-12.28-44.48 0L9.21 111.45c-12.28 12.28-12.28 32.19 0 44.48L109.28 256 9.21 356.07c-12.28 12.28-12.28 32.19 0 44.48l22.24 22.24c12.28 12.28 32.2 12.28 44.48 0L176 322.72l100.07 100.07c12.28 12.28 32.2 12.28 44.48 0l22.24-22.24c12.28-12.28 12.28-32.19 0-44.48L242.72 256z\\\"></path></svg>\";\n\nvar WarningSvg = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" width=\\\"12\\\" height=\\\"12\\\" viewBox=\\\"0 0 512 512\\\"><path fill=\\\"currentColor\\\" d=\\\"M288 328.83c-45.518 0-82.419 34.576-82.419 77.229 0 42.652 36.9 77.229 82.419 77.229 45.518 0 82.419-34.577 82.419-77.23 0-42.652-36.9-77.229-82.419-77.229zM207.439 57.034l11.61 204.348c.544 9.334 8.78 16.64 18.755 16.64h100.392c9.975 0 18.211-7.306 18.754-16.64l11.611-204.348c.587-10.082-7.98-18.56-18.754-18.56H226.192c-10.775 0-19.34 8.478-18.753 18.56z\\\"/></svg>\";\n\nvar SuccessSvg = \"<svg width=\\\"12\\\" height=\\\"12\\\" xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 512 512\\\"><path fill=\\\"currentColor\\\" d=\\\"M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z\\\"></path></svg>\";\n\nvar OFFSET_TOP = -7,\r\n    OFFSET_RIGHT = -7;\r\n\r\nvar index_esm_LOW_PRIORITY = 500;\r\n\r\nvar emptyConfig = {\r\n  resolver: {\r\n    resolveRule: function() {\r\n      return null;\r\n    }\r\n  },\r\n  config: {}\r\n};\r\n\r\nvar stateToIcon = {\r\n  error: ErrorSvg,\r\n  warning: WarningSvg,\r\n  success: SuccessSvg,\r\n  inactive: SuccessSvg\r\n};\r\n\r\nfunction Linting(\r\n    bpmnjs,\r\n    canvas,\r\n    config,\r\n    elementRegistry,\r\n    eventBus,\r\n    overlays,\r\n    translate\r\n) {\r\n  this._bpmnjs = bpmnjs;\r\n  this._canvas = canvas;\r\n  this._elementRegistry = elementRegistry;\r\n  this._eventBus = eventBus;\r\n  this._overlays = overlays;\r\n  this._translate = translate;\r\n\r\n  this._issues = {};\r\n\r\n  this._active = config && config.active || false;\r\n  this._linterConfig = emptyConfig;\r\n\r\n  this._overlayIds = {};\r\n\r\n  var self = this;\r\n\r\n  eventBus.on([\r\n    'import.done',\r\n    'elements.changed',\r\n    'linting.configChanged',\r\n    'linting.toggle'\r\n  ], index_esm_LOW_PRIORITY, function(e) {\r\n    if (self.isActive()) {\r\n      self.update();\r\n    }\r\n  });\r\n\r\n  eventBus.on('linting.toggle', function(event) {\r\n\r\n    const active = event.active;\r\n\r\n    if (!active) {\r\n      self._clearIssues();\r\n      self._updateButton();\r\n    }\r\n  });\r\n\r\n  eventBus.on('diagram.clear', function() {\r\n    self._clearIssues();\r\n  });\r\n\r\n  var linterConfig = config && config.bpmnlint;\r\n\r\n  linterConfig && eventBus.once('diagram.init', function() {\r\n\r\n    // bail out if config was already provided\r\n    // during initialization of other modules\r\n    if (self.getLinterConfig() !== emptyConfig) {\r\n      return;\r\n    }\r\n\r\n    try {\r\n      self.setLinterConfig(linterConfig);\r\n    } catch (err) {\r\n      console.error(\r\n        '[bpmn-js-bpmnlint] Invalid lint rules configured. ' +\r\n        'Please doublecheck your linting.bpmnlint configuration, ' +\r\n        'cf. https://github.com/bpmn-io/bpmn-js-bpmnlint#configure-lint-rules'\r\n      );\r\n    }\r\n  });\r\n\r\n  this._init();\r\n}\r\n\r\nLinting.prototype.setLinterConfig = function(linterConfig) {\r\n\r\n  if (!linterConfig.config || !linterConfig.resolver) {\r\n    throw new Error('Expected linterConfig = { config, resolver }');\r\n  }\r\n\r\n  this._linterConfig = linterConfig;\r\n\r\n  this._eventBus.fire('linting.configChanged');\r\n};\r\n\r\nLinting.prototype.getLinterConfig = function() {\r\n  return this._linterConfig;\r\n};\r\n\r\nLinting.prototype._init = function() {\r\n  this._createButton();\r\n\r\n  this._updateButton();\r\n};\r\n\r\nLinting.prototype.isActive = function() {\r\n  return this._active;\r\n};\r\n\r\nLinting.prototype._formatIssues = function(issues) {\r\n\r\n  let self = this;\r\n\r\n  // (1) reduce issues to flat list of issues including the affected element\r\n  let reports = (0,node_modules_min_dash_dist_index_esm.reduce)(issues, function(reports, ruleReports, rule) {\r\n\r\n    return reports.concat(ruleReports.map(function(report) {\r\n      report.rule = rule;\r\n\r\n      return report;\r\n    }));\r\n\r\n  }, []);\r\n\r\n  // (2) if affected element is not visible, then report it on root or participant level\r\n  const participants = self._elementRegistry.filter((ele) => { return (0,ModelUtil.is)(ele, 'bpmn:Participant'); }),\r\n        participantBos = participants.map((ele) => { return ele.businessObject; });\r\n\r\n  reports = (0,node_modules_min_dash_dist_index_esm.map)(reports, function(report) {\r\n    const element = self._elementRegistry.get(report.id);\r\n\r\n    if (!element) {\r\n      report.isChildIssue = true;\r\n      report.actualElementId = report.id;\r\n\r\n      // (2.1) Is a participant referring to the current issue? Then display on participant\r\n      const referringParticipant = participantBos.filter((ele) => {\r\n        return (ele.processRef && ele.processRef.id && ele.processRef.id === report.id);\r\n      });\r\n\r\n      if (referringParticipant.length) {\r\n        report.id = referringParticipant[0].id;\r\n      } else {\r\n\r\n        // (2.2) If there is no partcipant to display it on, display it to root\r\n        report.id = self._canvas.getRootElement().id;\r\n      }\r\n\r\n    }\r\n\r\n    return report;\r\n  });\r\n\r\n  // (3) group issues per elementId (resulting in ie. [elementId1: [{issue1}, {issue2}]] structure)\r\n  reports = (0,node_modules_min_dash_dist_index_esm.groupBy)(reports, function(report) {\r\n    return report.id;\r\n  });\r\n\r\n  return reports;\r\n\r\n};\r\n\r\n/**\r\n * Toggle linting on or off.\r\n *\r\n * @param {boolean} [newActive]\r\n *\r\n * @return {boolean} the new active state\r\n */\r\nLinting.prototype.toggle = function(newActive) {\r\n\r\n  newActive = typeof newActive === 'undefined' ? !this.isActive() : newActive;\r\n\r\n  this._setActive(newActive);\r\n\r\n  return newActive;\r\n};\r\n\r\nLinting.prototype._setActive = function(active) {\r\n\r\n  if (this._active === active) {\r\n    return;\r\n  }\r\n\r\n  this._active = active;\r\n\r\n  this._eventBus.fire('linting.toggle', { active: active });\r\n};\r\n\r\n/**\r\n * Update overlays. Always lint and check wether overlays need update or not.\r\n */\r\nLinting.prototype.update = function() {\r\n  var self = this;\r\n\r\n  var definitions = this._bpmnjs.getDefinitions();\r\n\r\n  if (!definitions) {\r\n    return;\r\n  }\r\n\r\n  var lintStart = this._lintStart = Math.random();\r\n\r\n  this.lint().then(function(newIssues) {\r\n\r\n    if (self._lintStart !== lintStart) {\r\n      return;\r\n    }\r\n\r\n    newIssues = self._formatIssues(newIssues);\r\n\r\n    var remove = {},\r\n        update = {},\r\n        add = {};\r\n\r\n    for (var id1 in self._issues) {\r\n      if (!newIssues[id1]) {\r\n        remove[id1] = self._issues[id1];\r\n      }\r\n    }\r\n\r\n    for (var id2 in newIssues) {\r\n      if (!self._issues[id2]) {\r\n        add[id2] = newIssues[id2];\r\n      } else {\r\n        if (newIssues[id2] !== self._issues[id2]) {\r\n          update[id2] = newIssues[id2];\r\n        }\r\n      }\r\n    }\r\n\r\n    remove = (0,node_modules_min_dash_dist_index_esm.assign)(remove, update);\r\n    add = (0,node_modules_min_dash_dist_index_esm.assign)(add, update);\r\n\r\n    self._clearOverlays();\r\n    self._createIssues(add);\r\n\r\n    self._issues = newIssues;\r\n\r\n    self._updateButton();\r\n\r\n    self._fireComplete(newIssues);\r\n  });\r\n};\r\n\r\nLinting.prototype._fireComplete = function(issues) {\r\n  this._eventBus.fire('linting.completed', { issues: issues });\r\n};\r\n\r\nLinting.prototype._createIssues = function(issues) {\r\n  for (var id in issues) {\r\n    this._createElementIssues(id, issues[id]);\r\n  }\r\n};\r\n\r\n/**\r\n * Create overlay including all issues which are given for a single element.\r\n *\r\n * @param {string} elementId - id of element, for which the issue shall be displayed.\r\n * @param {Array} elementIssues - All element issues including warnings and errors.\r\n */\r\nLinting.prototype._createElementIssues = function(elementId, elementIssues) {\r\n  var element = this._elementRegistry.get(elementId);\r\n\r\n  if (!element) {\r\n    return;\r\n  }\r\n\r\n  // Also attach element to subprocess plane\r\n  var plane = this._elementRegistry.get(elementId + '_plane');\r\n  if (plane) {\r\n    this._createElementIssues(plane.id, elementIssues);\r\n  }\r\n\r\n  var menuPosition;\r\n  var position;\r\n\r\n  var isRoot = !element.parent;\r\n  if (isRoot && (0,ModelUtil.is)(element, 'bpmn:Process')) {\r\n    menuPosition = 'bottom-right';\r\n\r\n    position = {\r\n      top: 20,\r\n      left: 150\r\n    };\r\n  } else if (isRoot && (0,ModelUtil.is)(element, 'bpmn:SubProcess')) {\r\n    menuPosition = 'bottom-right';\r\n\r\n    position = {\r\n      top: 50,\r\n      left: 150\r\n    };\r\n  } else {\r\n    menuPosition = 'top-right';\r\n\r\n    position = {\r\n      top: OFFSET_TOP,\r\n      left: OFFSET_RIGHT\r\n    };\r\n  }\r\n\r\n  var issuesByType = (0,node_modules_min_dash_dist_index_esm.groupBy)(elementIssues, function(elementIssue) {\r\n    return (elementIssue.isChildIssue ? 'child' : '') + elementIssue.category;\r\n  });\r\n\r\n  var errors = issuesByType.error,\r\n      warnings = issuesByType.warn,\r\n      childErrors = issuesByType.childerror,\r\n      childWarnings = issuesByType.childwarn;\r\n\r\n  if (!errors && !warnings && !childErrors && !childWarnings) {\r\n    return;\r\n  }\r\n\r\n  var $html = (0,min_dom_dist_index_esm/* domify */.H6)(\r\n    '<div class=\"bjsl-overlay bjsl-issues-' + menuPosition + '\"></div>'\r\n  );\r\n\r\n  var $icon = (errors || childErrors)\r\n    ? (0,min_dom_dist_index_esm/* domify */.H6)('<div class=\"bjsl-icon bjsl-icon-error\">' + ErrorSvg + '</div>')\r\n    : (0,min_dom_dist_index_esm/* domify */.H6)('<div class=\"bjsl-icon bjsl-icon-warning\">' + WarningSvg + '</div>');\r\n\r\n  var $dropdown = (0,min_dom_dist_index_esm/* domify */.H6)('<div class=\"bjsl-dropdown\"></div>');\r\n  var $dropdownContent = (0,min_dom_dist_index_esm/* domify */.H6)('<div class=\"bjsl-dropdown-content\"></div>');\r\n\r\n  var $issueContainer = (0,min_dom_dist_index_esm/* domify */.H6)('<div class=\"bjsl-issues\"></div>');\r\n\r\n  var $issues = (0,min_dom_dist_index_esm/* domify */.H6)('<div class=\"bjsl-current-element-issues\"></div>');\r\n  var $issueList = (0,min_dom_dist_index_esm/* domify */.H6)('<ul></ul>');\r\n\r\n  $html.appendChild($icon);\r\n  $html.appendChild($dropdown);\r\n\r\n  $dropdown.appendChild($dropdownContent);\r\n  $dropdownContent.appendChild($issueContainer);\r\n\r\n  $issueContainer.appendChild($issues);\r\n\r\n  $issues.appendChild($issueList);\r\n\r\n  // Add errors and warnings to issueList\r\n  if (errors) {\r\n    this._addErrors($issueList, errors);\r\n  }\r\n\r\n  if (warnings) {\r\n    this._addWarnings($issueList, warnings);\r\n  }\r\n\r\n  // If errors or warnings for child elements of the current element are to be displayed,\r\n  // then add an additional list\r\n  if (childErrors || childWarnings) {\r\n    var $childIssues = (0,min_dom_dist_index_esm/* domify */.H6)('<div class=\"bjsl-child-issues\"></div>');\r\n    var $childIssueList = (0,min_dom_dist_index_esm/* domify */.H6)('<ul></ul>');\r\n    var $childIssueLabel = (0,min_dom_dist_index_esm/* domify */.H6)('<a class=\"bjsl-issue-heading\">Issues for child elements:</a>');\r\n\r\n    if (childErrors) {\r\n      this._addErrors($childIssueList, childErrors);\r\n    }\r\n\r\n    if (childWarnings) {\r\n      this._addWarnings($childIssueList, childWarnings);\r\n    }\r\n\r\n    if (errors || warnings) {\r\n      var $childIssuesSeperator = (0,min_dom_dist_index_esm/* domify */.H6)('<hr/>');\r\n      $childIssues.appendChild($childIssuesSeperator);\r\n    }\r\n\r\n    $childIssues.appendChild($childIssueLabel);\r\n    $childIssues.appendChild($childIssueList);\r\n    $issueContainer.appendChild($childIssues);\r\n  }\r\n\r\n  this._overlayIds[elementId] = this._overlays.add(element, 'linting', {\r\n    position: position,\r\n    html: $html,\r\n    scale: {\r\n      min: .9\r\n    }\r\n  });\r\n};\r\n\r\nLinting.prototype._addErrors = function($ul, errors) {\r\n\r\n  var self = this;\r\n\r\n  errors.forEach(function(error) {\r\n    self._addEntry($ul, 'error', error);\r\n  });\r\n};\r\n\r\nLinting.prototype._addWarnings = function($ul, warnings) {\r\n\r\n  var self = this;\r\n\r\n  warnings.forEach(function(error) {\r\n    self._addEntry($ul, 'warning', error);\r\n  });\r\n};\r\n\r\nLinting.prototype._addEntry = function($ul, state, entry) {\r\n\r\n  var rule = entry.rule,\r\n      message = this._translate(entry.message),\r\n      actualElementId = entry.actualElementId;\r\n\r\n  var icon = stateToIcon[state];\r\n\r\n  var $entry = (0,min_dom_dist_index_esm/* domify */.H6)(\r\n    '<li class=\"' + state + '\">' +\r\n      '<span class=\"icon\"> ' + icon + '</span>' +\r\n      '<a title=\"' + (0,EscapeUtil/* escapeHTML */.r)(rule) + ': ' + (0,EscapeUtil/* escapeHTML */.r)(message) + '\" ' +\r\n         'data-rule=\"' + (0,EscapeUtil/* escapeHTML */.r)(rule) + '\" ' +\r\n         'data-message=\"' + (0,EscapeUtil/* escapeHTML */.r)(message) + '\"' +\r\n      '>' +\r\n        (0,EscapeUtil/* escapeHTML */.r)(message) +\r\n      '</a>' +\r\n      (actualElementId\r\n        ? '<a class=\"bjsl-id-hint\"><code>' + actualElementId + '</code></a>'\r\n        : '') +\r\n    '</li>'\r\n  );\r\n\r\n  $ul.appendChild($entry);\r\n};\r\n\r\nLinting.prototype._clearOverlays = function() {\r\n  this._overlays.remove({ type: 'linting' });\r\n\r\n  this._overlayIds = {};\r\n};\r\n\r\nLinting.prototype._clearIssues = function() {\r\n  this._issues = {};\r\n\r\n  this._clearOverlays();\r\n};\r\n\r\nLinting.prototype._setButtonState = function(state, errors, warnings) {\r\n  var button = this._button;\r\n\r\n  var icon = stateToIcon[state];\r\n\r\n  var html = icon + '<span>' + this._translate('{errors} Errors, {warnings} Warnings', { errors: errors.toString(), warnings: warnings.toString() }) + '</span>';\r\n\r\n  [\r\n    'error',\r\n    'inactive',\r\n    'success',\r\n    'warning'\r\n  ].forEach(function(s) {\r\n    if (state === s) {\r\n      button.classList.add('bjsl-button-' + s);\r\n    } else {\r\n      button.classList.remove('bjsl-button-' + s);\r\n    }\r\n  });\r\n\r\n  button.innerHTML = html;\r\n};\r\n\r\nLinting.prototype._updateButton = function() {\r\n\r\n  if (!this.isActive()) {\r\n    this._setButtonState('inactive', 0, 0);\r\n\r\n    return;\r\n  }\r\n\r\n  var errors = 0,\r\n      warnings = 0;\r\n\r\n  for (var id in this._issues) {\r\n    this._issues[id].forEach(function(issue) {\r\n      if (issue.category === 'error') {\r\n        errors++;\r\n      } else if (issue.category === 'warn') {\r\n        warnings++;\r\n      }\r\n    });\r\n  }\r\n\r\n  var state = (errors && 'error') || (warnings && 'warning') || 'success';\r\n\r\n  this._setButtonState(state, errors, warnings);\r\n};\r\n\r\nLinting.prototype._createButton = function() {\r\n\r\n  var self = this;\r\n\r\n  this._button = (0,min_dom_dist_index_esm/* domify */.H6)(\r\n    '<button class=\"bjsl-button bjsl-button-inactive\" title=\"' + this._translate('Toggle linting') + '\"></button>'\r\n  );\r\n\r\n  this._button.addEventListener('click', function() {\r\n    self.toggle();\r\n  });\r\n\r\n  this._canvas.getContainer().appendChild(this._button);\r\n};\r\n\r\nLinting.prototype.lint = function() {\r\n  var definitions = this._bpmnjs.getDefinitions();\r\n\r\n  var linter = new lib.Linter(this._linterConfig);\r\n\r\n  return linter.lint(definitions);\r\n};\r\n\r\nLinting.$inject = [\r\n  'bpmnjs',\r\n  'canvas',\r\n  'config.linting',\r\n  'elementRegistry',\r\n  'eventBus',\r\n  'overlays',\r\n  'translate'\r\n];\n\nvar index_esm_index = {\r\n  __init__: [ 'linting', 'lintingEditorActions' ],\r\n  linting: [ 'type', Linting ],\r\n  lintingEditorActions: ['type', EditorActions ]\r\n};\n\n/* harmony default export */ const bpmn_js_bpmnlint_dist_index_esm = (index_esm_index);\n//# sourceMappingURL=index.esm.js.map\n\n// EXTERNAL MODULE: ./node_modules/bpmn-js-token-simulation/node_modules/min-dom/dist/index.esm.js\nvar node_modules_min_dom_dist_index_esm = __webpack_require__(\"./node_modules/bpmn-js-token-simulation/node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/util/EventHelper.js\nconst TOGGLE_MODE_EVENT = 'tokenSimulation.toggleMode';\r\nconst PLAY_SIMULATION_EVENT = 'tokenSimulation.playSimulation';\r\nconst PAUSE_SIMULATION_EVENT = 'tokenSimulation.pauseSimulation';\r\nconst RESET_SIMULATION_EVENT = 'tokenSimulation.resetSimulation';\r\nconst ANIMATION_CREATED_EVENT = 'tokenSimulation.animationCreated';\r\nconst ANIMATION_SPEED_CHANGED_EVENT = 'tokenSimulation.animationSpeedChanged';\r\nconst ELEMENT_CHANGED_EVENT = 'tokenSimulation.simulator.elementChanged';\r\nconst SCOPE_DESTROYED_EVENT = 'tokenSimulation.simulator.destroyScope';\r\nconst SCOPE_CHANGED_EVENT = 'tokenSimulation.simulator.scopeChanged';\r\nconst SCOPE_CREATE_EVENT = 'tokenSimulation.simulator.createScope';\r\nconst SCOPE_FILTER_CHANGED_EVENT = 'tokenSimulation.scopeFilterChanged';\r\nconst TRACE_EVENT = 'tokenSimulation.simulator.trace';\r\n\r\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/icons/index.js\nvar LogSVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 448 512\\\">\x3c!-- Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --\x3e<path fill=\\\"currentColor\\\" d=\\\"M12.83 352h262.34A12.82 12.82 0 0 0 288 339.17v-38.34A12.82 12.82 0 0 0 275.17 288H12.83A12.82 12.82 0 0 0 0 300.83v38.34A12.82 12.82 0 0 0 12.83 352zm0-256h262.34A12.82 12.82 0 0 0 288 83.17V44.83A12.82 12.82 0 0 0 275.17 32H12.83A12.82 12.82 0 0 0 0 44.83v38.34A12.82 12.82 0 0 0 12.83 96zM432 160H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0 256H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z\\\"/></svg>\";\n\nvar AngleRightSVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 256 512\\\">\x3c!-- Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --\x3e<path fill=\\\"currentColor\\\" d=\\\"M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z\\\"/></svg>\";\n\nvar CheckCircleSVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 512 512\\\">\x3c!-- Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --\x3e<path fill=\\\"currentColor\\\" d=\\\"M504 256c0 136.967-111.033 248-248 248S8 392.967 8 256 119.033 8 256 8s248 111.033 248 248zM227.314 387.314l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.249-16.379-6.249-22.628 0L216 308.118l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.249 16.379 6.249 22.628.001z\\\"/></svg>\";\n\nvar ForkSVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 384 512\\\">\x3c!-- Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --\x3e<path fill=\\\"currentColor\\\" d=\\\"M384 144c0-44.2-35.8-80-80-80s-80 35.8-80 80c0 36.4 24.3 67.1 57.5 76.8-.6 16.1-4.2 28.5-11 36.9-15.4 19.2-49.3 22.4-85.2 25.7-28.2 2.6-57.4 5.4-81.3 16.9v-144c32.5-10.2 56-40.5 56-76.3 0-44.2-35.8-80-80-80S0 35.8 0 80c0 35.8 23.5 66.1 56 76.3v199.3C23.5 365.9 0 396.2 0 432c0 44.2 35.8 80 80 80s80-35.8 80-80c0-34-21.2-63.1-51.2-74.6 3.1-5.2 7.8-9.8 14.9-13.4 16.2-8.2 40.4-10.4 66.1-12.8 42.2-3.9 90-8.4 118.2-43.4 14-17.4 21.1-39.8 21.6-67.9 31.6-10.8 54.4-40.7 54.4-75.9zM80 64c8.8 0 16 7.2 16 16s-7.2 16-16 16-16-7.2-16-16 7.2-16 16-16zm0 384c-8.8 0-16-7.2-16-16s7.2-16 16-16 16 7.2 16 16-7.2 16-16 16zm224-320c8.8 0 16 7.2 16 16s-7.2 16-16 16-16-7.2-16-16 7.2-16 16-16z\\\"/></svg>\";\n\nvar ExclamationTriangleSVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 576 512\\\">\x3c!-- Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --\x3e<path fill=\\\"currentColor\\\" d=\\\"M569.517 440.013C587.975 472.007 564.806 512 527.94 512H48.054c-36.937 0-59.999-40.055-41.577-71.987L246.423 23.985c18.467-32.009 64.72-31.951 83.154 0l239.94 416.028zM288 354c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z\\\"/></svg>\";\n\nvar InfoSVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 192 512\\\">\x3c!-- Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --\x3e<path fill=\\\"currentColor\\\" d=\\\"M20 424.229h20V279.771H20c-11.046 0-20-8.954-20-20V212c0-11.046 8.954-20 20-20h112c11.046 0 20 8.954 20 20v212.229h20c11.046 0 20 8.954 20 20V492c0 11.046-8.954 20-20 20H20c-11.046 0-20-8.954-20-20v-47.771c0-11.046 8.954-20 20-20zM96 0C56.235 0 24 32.235 24 72s32.235 72 72 72 72-32.235 72-72S135.764 0 96 0z\\\"/></svg>\";\n\nvar PauseSVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 448 512\\\">\x3c!-- Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --\x3e<path fill=\\\"currentColor\\\" d=\\\"M144 479H48c-26.5 0-48-21.5-48-48V79c0-26.5 21.5-48 48-48h96c26.5 0 48 21.5 48 48v352c0 26.5-21.5 48-48 48zm304-48V79c0-26.5-21.5-48-48-48h-96c-26.5 0-48 21.5-48 48v352c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48z\\\"/></svg>\";\n\nvar RemovePauseSVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 580.5 448\\\">\\n  <path fill=\\\"currentColor\\\" d=\\\"M112 0C85 0 64 22 64 48v196l192-89V48c0-26-22-48-48-48zm256 0c-27 0-48 22-48 48v77l190-89c-5-21-24-36-46-36Zm144 105-192 89v70l192-89zM256 224 64 314v70l192-90zm256 21-192 89v66c0 27 21 48 48 48h96c26 0 48-21 48-48zM256 364 89 442c7 4 14 6 23 6h96c26 0 48-21 48-48z\\\"/>\\n  <rect fill=\\\"currentColor\\\" width=\\\"63.3\\\" height=\\\"618.2\\\" x=\\\"311.5\\\" y=\\\"-469.4\\\" transform=\\\"rotate(65)\\\" rx=\\\"10\\\"/>\\n</svg>\\n\";\n\nvar PlaySVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 448 512\\\">\x3c!-- Adapted from Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --\x3e<path fill=\\\"currentColor\\\" d=\\\"M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z\\\"/></svg>\";\n\nvar ResetSVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 512 512\\\">\x3c!-- Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --\x3e<path fill=\\\"currentColor\\\" d=\\\"M440.65 12.57l4 82.77A247.16 247.16 0 0 0 255.83 8C134.73 8 33.91 94.92 12.29 209.82A12 12 0 0 0 24.09 224h49.05a12 12 0 0 0 11.67-9.26 175.91 175.91 0 0 1 317-56.94l-101.46-4.86a12 12 0 0 0-12.57 12v47.41a12 12 0 0 0 12 12H500a12 12 0 0 0 12-12V12a12 12 0 0 0-12-12h-47.37a12 12 0 0 0-11.98 12.57zM255.83 432a175.61 175.61 0 0 1-146-77.8l101.8 4.87a12 12 0 0 0 12.57-12v-47.4a12 12 0 0 0-12-12H12a12 12 0 0 0-12 12V500a12 12 0 0 0 12 12h47.35a12 12 0 0 0 12-12.6l-4.15-82.57A247.17 247.17 0 0 0 255.83 504c121.11 0 221.93-86.92 243.55-201.82a12 12 0 0 0-11.8-14.18h-49.05a12 12 0 0 0-11.67 9.26A175.86 175.86 0 0 1 255.83 432z\\\"/></svg>\";\n\nvar TachometerSVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 576 512\\\">\x3c!-- Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --\x3e<path fill=\\\"currentColor\\\" d=\\\"M288 32C128.94 32 0 160.94 0 320c0 52.8 14.25 102.26 39.06 144.8 5.61 9.62 16.3 15.2 27.44 15.2h443c11.14 0 21.83-5.58 27.44-15.2C561.75 422.26 576 372.8 576 320c0-159.06-128.94-288-288-288zm0 64c14.71 0 26.58 10.13 30.32 23.65-1.11 2.26-2.64 4.23-3.45 6.67l-9.22 27.67c-5.13 3.49-10.97 6.01-17.64 6.01-17.67 0-32-14.33-32-32S270.33 96 288 96zM96 384c-17.67 0-32-14.33-32-32s14.33-32 32-32 32 14.33 32 32-14.33 32-32 32zm48-160c-17.67 0-32-14.33-32-32s14.33-32 32-32 32 14.33 32 32-14.33 32-32 32zm246.77-72.41l-61.33 184C343.13 347.33 352 364.54 352 384c0 11.72-3.38 22.55-8.88 32H232.88c-5.5-9.45-8.88-20.28-8.88-32 0-33.94 26.5-61.43 59.9-63.59l61.34-184.01c4.17-12.56 17.73-19.45 30.36-15.17 12.57 4.19 19.35 17.79 15.17 30.36zm14.66 57.2l15.52-46.55c3.47-1.29 7.13-2.23 11.05-2.23 17.67 0 32 14.33 32 32s-14.33 32-32 32c-11.38-.01-20.89-6.28-26.57-15.22zM480 384c-17.67 0-32-14.33-32-32s14.33-32 32-32 32 14.33 32 32-14.33 32-32 32z\\\"/></svg>\";\n\nvar TimesCircleSVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 512 512\\\">\x3c!-- Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --\x3e<path fill=\\\"currentColor\\\" d=\\\"M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm121.6 313.1c4.7 4.7 4.7 12.3 0 17L338 377.6c-4.7 4.7-12.3 4.7-17 0L256 312l-65.1 65.6c-4.7 4.7-12.3 4.7-17 0L134.4 338c-4.7-4.7-4.7-12.3 0-17l65.6-65-65.6-65.1c-4.7-4.7-4.7-12.3 0-17l39.6-39.6c4.7-4.7 12.3-4.7 17 0l65 65.7 65.1-65.6c4.7-4.7 12.3-4.7 17 0l39.6 39.6c4.7 4.7 4.7 12.3 0 17L312 256l65.6 65.1z\\\"/></svg>\";\n\nvar TimesSVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 352 512\\\">\x3c!-- Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --\x3e<path fill=\\\"currentColor\\\" d=\\\"M242.72 256l100.07-100.07c12.28-12.28 12.28-32.19 0-44.48l-22.24-22.24c-12.28-12.28-32.19-12.28-44.48 0L176 189.28 75.93 89.21c-12.28-12.28-32.19-12.28-44.48 0L9.21 111.45c-12.28 12.28-12.28 32.19 0 44.48L109.28 256 9.21 356.07c-12.28 12.28-12.28 32.19 0 44.48l22.24 22.24c12.28 12.28 32.2 12.28 44.48 0L176 322.72l100.07 100.07c12.28 12.28 32.2 12.28 44.48 0l22.24-22.24c12.28-12.28 12.28-32.19 0-44.48L242.72 256z\\\"/></svg>\";\n\nvar ToggleOffSVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 576 512\\\">\x3c!-- Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --\x3e<path fill=\\\"currentColor\\\" d=\\\"M384 64H192C85.961 64 0 149.961 0 256s85.961 192 192 192h192c106.039 0 192-85.961 192-192S490.039 64 384 64zM64 256c0-70.741 57.249-128 128-128 70.741 0 128 57.249 128 128 0 70.741-57.249 128-128 128-70.741 0-128-57.249-128-128zm320 128h-48.905c65.217-72.858 65.236-183.12 0-256H384c70.741 0 128 57.249 128 128 0 70.74-57.249 128-128 128z\\\"/></svg>\";\n\nvar ToggleOnSVG = \"<svg xmlns=\\\"http://www.w3.org/2000/svg\\\" viewBox=\\\"0 0 576 512\\\">\x3c!-- Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --\x3e<path fill=\\\"currentColor\\\" d=\\\"M384 64H192C86 64 0 150 0 256s86 192 192 192h192c106 0 192-86 192-192S490 64 384 64zm0 320c-70.8 0-128-57.3-128-128 0-70.8 57.3-128 128-128 70.8 0 128 57.3 128 128 0 70.8-57.3 128-128 128z\\\"/></svg>\";\n\nfunction createIcon(svg) {\n  return function Icon(className = '') {\n    return `<span class=\"bts-icon ${ className }\">${svg}</span>`;\n  };\n}\n\nconst LogIcon = createIcon(LogSVG);\nconst AngleRightIcon = createIcon(AngleRightSVG);\nconst CheckCircleIcon = createIcon(CheckCircleSVG);\nconst RemovePauseIcon = createIcon(RemovePauseSVG);\nconst ForkIcon = createIcon(ForkSVG);\nconst ExclamationTriangleIcon = createIcon(ExclamationTriangleSVG);\nconst InfoIcon = createIcon(InfoSVG);\nconst PauseIcon = createIcon(PauseSVG);\nconst PlayIcon = createIcon(PlaySVG);\nconst ResetIcon = createIcon(ResetSVG);\nconst TachometerIcon = createIcon(TachometerSVG);\nconst TimesCircleIcon = createIcon(TimesCircleSVG);\nconst TimesIcon = createIcon(TimesSVG);\nconst ToggleOffIcon = createIcon(ToggleOffSVG);\nconst ToggleOnIcon = createIcon(ToggleOnSVG);\n\n\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/toggle-mode/viewer/ToggleMode.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nfunction ToggleMode(eventBus, canvas, selection) {\r\n  this._eventBus = eventBus;\r\n  this._canvas = canvas;\r\n\r\n  this._active = false;\r\n\r\n  eventBus.on('import.parse.start', () => {\r\n\r\n    if (this._active) {\r\n      this.toggleMode(false);\r\n\r\n      eventBus.once('import.done', () => {\r\n        this.toggleMode(true);\r\n      });\r\n    }\r\n  });\r\n\r\n  eventBus.on('diagram.init', () => {\r\n    this._canvasParent = this._canvas.getContainer().parentNode;\r\n\r\n    this._init();\r\n  });\r\n\r\n  eventBus.on('import.parse.start', () => {\r\n\r\n    if (this._active) {\r\n      this.toggleMode(false);\r\n\r\n      eventBus.once('import.done', () => {\r\n        this.toggleMode(true);\r\n      });\r\n    }\r\n  });\r\n}\r\n\r\nToggleMode.prototype._init = function() {\r\n  this._container = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)(`\r\n    <div class=\"bts-toggle-mode\">\r\n      Token Simulation <span class=\"bts-toggle\">${ ToggleOffIcon() }</span>\r\n    </div>\r\n  `);\r\n\r\n  node_modules_min_dom_dist_index_esm/* event.bind */.B.bind(this._container, 'click', () => this.toggleMode());\r\n\r\n  this._canvas.getContainer().appendChild(this._container);\r\n};\r\n\r\nToggleMode.prototype.toggleMode = function(active = !this._active) {\r\n  if (active === this._active) {\r\n    return;\r\n  }\r\n\r\n  if (active) {\r\n    this._container.innerHTML = `Token Simulation <span class=\"bts-toggle\">${ ToggleOnIcon() }</span>`;\r\n\r\n    (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this._canvasParent).add('simulation');\r\n  } else {\r\n    this._container.innerHTML = `Token Simulation <span class=\"bts-toggle\">${ ToggleOffIcon() }</span>`;\r\n\r\n    (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this._canvasParent).remove('simulation');\r\n  }\r\n\r\n  this._eventBus.fire(TOGGLE_MODE_EVENT, {\r\n    active\r\n  });\r\n\r\n  this._active = active;\r\n};\r\n\r\nToggleMode.$inject = [ 'eventBus', 'canvas' ];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/toggle-mode/viewer/index.js\n\n\n/* harmony default export */ const viewer = ({\n  __init__: [\n    'toggleMode'\n  ],\n  toggleMode: [ 'type', ToggleMode ]\n});\n// EXTERNAL MODULE: ./node_modules/ids/dist/index.esm.js\nvar ids_dist_index_esm = __webpack_require__(\"./node_modules/ids/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/ScopeTraits.js\nconst ACTIVATED = 1;\nconst RUNNING = 1 << 1;\nconst ENDING = 1 << 2;\nconst ENDED = 1 << 3;\nconst DESTROYED = 1 << 4;\nconst FAILED = 1 << 5;\nconst TERMINATED = 1 << 6;\nconst CANCELED = 1 << 7;\nconst COMPLETED = 1 << 8;\nconst COMPENSABLE = 1 << 9;\n\nconst ACTIVE = ACTIVATED | RUNNING | ENDING;\nconst NOT_DEAD = ACTIVATED | ENDED;\n\nconst ScopeTraits = Object.freeze({\n  ACTIVATED,\n  RUNNING,\n  ENDING,\n  ENDED,\n  DESTROYED,\n  FAILED,\n  TERMINATED,\n  CANCELED,\n  COMPLETED,\n  COMPENSABLE,\n  ACTIVE,\n  NOT_DEAD\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/ScopeStates.js\n\n\nconst SELF = {};\n\nfunction illegalTransition(state, target) {\n  throw new Error(`illegal transition: ${state.name} -> ${target}`);\n}\n\nfunction orSelf(state, self) {\n  if (state === SELF) {\n    return self;\n  }\n\n  return state;\n}\n\n/**\n * A representation of a scopes state with name, traits, and supported\n * transitions to other states.\n */\nclass ScopeState {\n\n  /**\n   * @param {string} name\n   * @param {number} traits\n   * @param {object} [transitions]\n   * @param {ScopeState} [transitions.start]\n   * @param {ScopeState} [transitions.cancel]\n   * @param {ScopeState} [transitions.complete]\n   * @param {ScopeState} [transitions.destroy]\n   * @param {ScopeState} [transitions.fail]\n   * @param {ScopeState} [transitions.terminate]\n   * @param {ScopeState} [transitions.compensable]\n   */\n  constructor(name, traits, {\n    start,\n    cancel,\n    complete,\n    destroy,\n    fail,\n    terminate,\n    compensable\n  } = {}) {\n    this.name = name;\n\n    /**\n     * A bit-wise encoded set of traits\n     * characterizing the scope.\n     *\n     * @type {number}\n     */\n    this.traits = traits;\n\n    this._start = orSelf(start, this);\n    this._compensable = orSelf(compensable, this);\n    this._cancel = orSelf(cancel, this);\n    this._complete = orSelf(complete, this);\n    this._destroy = orSelf(destroy, this);\n    this._fail = orSelf(fail, this);\n    this._terminate = orSelf(terminate, this);\n  }\n\n  /**\n   * @param {number} trait\n   * @return {boolean}\n   */\n  hasTrait(trait) {\n    return (this.traits & trait) !== 0;\n  }\n\n  /**\n   * @return {ScopeState}\n   */\n  complete() {\n    return this._complete || illegalTransition(this, 'complete');\n  }\n\n  /**\n   * @return {ScopeState}\n   */\n  destroy() {\n    return this._destroy || illegalTransition(this, 'destroy');\n  }\n\n  /**\n   * @return {ScopeState}\n   */\n  cancel() {\n    return this._cancel || illegalTransition(this, 'cancel');\n  }\n\n  /**\n   * @return {ScopeState}\n   */\n  fail() {\n    return this._fail || illegalTransition(this, 'fail');\n  }\n\n  /**\n   * @return {ScopeState}\n   */\n  terminate() {\n    return this._terminate || illegalTransition(this, 'terminate');\n  }\n\n  /**\n   * @return {ScopeState}\n   */\n  compensable() {\n    return this._compensable || illegalTransition(this, 'compensable');\n  }\n\n  /**\n   * @return {ScopeState}\n   */\n  start() {\n    return this._start || illegalTransition(this, 'start');\n  }\n}\n\nconst ScopeStates_FAILED = new ScopeState('failed', ScopeTraits.DESTROYED | ScopeTraits.FAILED);\n\nconst ScopeStates_TERMINATED = new ScopeState('terminated', ScopeTraits.DESTROYED | ScopeTraits.TERMINATED);\n\nconst ScopeStates_COMPLETED = new ScopeState('completed', ScopeTraits.DESTROYED | ScopeTraits.COMPLETED);\n\nconst TERMINATING = new ScopeState('terminating', ScopeTraits.ENDING | ScopeTraits.TERMINATED, {\n  destroy: ScopeStates_TERMINATED\n});\n\nconst CANCELING = new ScopeState('canceling', ScopeTraits.ENDING | ScopeTraits.FAILED | ScopeTraits.CANCELED, {\n  destroy: ScopeStates_FAILED,\n  complete: SELF,\n  terminate: TERMINATING\n});\n\nconst COMPLETING = new ScopeState('completing', ScopeTraits.ENDING | ScopeTraits.COMPLETED, {\n  destroy: ScopeStates_COMPLETED,\n  cancel: CANCELING,\n  terminate: TERMINATING\n});\n\nconst FAILING = new ScopeState('failing', ScopeTraits.ENDING | ScopeTraits.FAILED, {\n  cancel: CANCELING,\n  complete: COMPLETING,\n  destroy: ScopeStates_FAILED,\n  terminate: TERMINATING\n});\n\nconst COMPENSABLE_FAILING = new ScopeState('compensable:failing', ScopeTraits.ENDING | ScopeTraits.FAILED, {\n  complete: SELF,\n  terminate: TERMINATING,\n  destroy: ScopeStates_FAILED\n});\n\nconst COMPENSABLE_COMPLETED = new ScopeState('compensable:completed', ScopeTraits.ENDED | ScopeTraits.COMPLETED, {\n  cancel: CANCELING,\n  fail: COMPENSABLE_FAILING,\n  destroy: ScopeStates_COMPLETED,\n  compensable: SELF\n});\n\nconst COMPENSABLE_COMPLETING = new ScopeState('compensable:completing', ScopeTraits.ENDING | ScopeTraits.COMPLETED, {\n  destroy: COMPENSABLE_COMPLETED,\n  terminate: TERMINATING,\n  compensable: SELF\n});\n\nconst COMPENSABLE_RUNNING = new ScopeState('compensable:running', ScopeTraits.RUNNING | ScopeTraits.COMPENSABLE, {\n  cancel: CANCELING,\n  complete: COMPENSABLE_COMPLETING,\n  compensable: SELF,\n  destroy: COMPENSABLE_COMPLETED,\n  fail: FAILING,\n  terminate: TERMINATING\n});\n\nconst ScopeStates_RUNNING = new ScopeState('running', ScopeTraits.RUNNING, {\n  cancel: CANCELING,\n  complete: COMPLETING,\n  compensable: COMPENSABLE_RUNNING,\n  destroy: ScopeStates_TERMINATED,\n  fail: FAILING,\n  terminate: TERMINATING\n});\n\nconst ScopeStates_ACTIVATED = new ScopeState('activated', ScopeTraits.ACTIVATED, {\n  start: ScopeStates_RUNNING,\n  destroy: ScopeStates_TERMINATED\n});\n\nconst ScopeStates = Object.freeze({\n  ACTIVATED: ScopeStates_ACTIVATED,\n  RUNNING: ScopeStates_RUNNING,\n  CANCELING,\n  COMPLETING,\n  COMPLETED: ScopeStates_COMPLETED,\n  FAILING,\n  FAILED: ScopeStates_FAILED,\n  TERMINATING,\n  TERMINATED: ScopeStates_TERMINATED,\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/Scope.js\n\n\n\n\n/**\n * A representation of anything runnable in token simulation land.\n */\nclass Scope {\n\n  /**\n   * @param {string} id\n   * @param {Element} element\n   * @param {Scope} parent\n   * @param {Scope} initiator\n   *\n   * @constructor\n   */\n  constructor(id, element, parent = null, initiator = null) {\n    this.id = id;\n    this.element = element;\n    this.parent = parent;\n    this.initiator = initiator;\n\n    this.subscriptions = new Set();\n\n    this.children = [];\n    this.state = ScopeStates.ACTIVATED;\n  }\n\n  /**\n   * @return {boolean}\n   */\n  get running() {\n    return this.hasTrait(ScopeTraits.RUNNING);\n  }\n\n  /**\n   * @return {boolean}\n   */\n  get destroyed() {\n    return this.hasTrait(ScopeTraits.DESTROYED);\n  }\n\n  /**\n   * @return {boolean}\n   */\n  get completed() {\n    return this.hasTrait(ScopeTraits.COMPLETED);\n  }\n\n  /**\n   * @return {boolean}\n   */\n  get canceled() {\n    return this.hasTrait(ScopeTraits.CANCELED);\n  }\n\n  /**\n   * @return {boolean}\n   */\n  get failed() {\n    return this.hasTrait(ScopeTraits.FAILED);\n  }\n\n  /**\n   * @param {number} phase\n   * @return {boolean}\n   */\n  hasTrait(trait) {\n    return this.state.hasTrait(trait);\n  }\n\n  /**\n   * Start the scope\n   *\n   * @return {Scope}\n   */\n  start() {\n    this.state = this.state.start();\n\n    return this;\n  }\n\n  /**\n   * Make this scope compensable.\n   *\n   * @return {Scope}\n   */\n  compensable() {\n    this.state = this.state.compensable();\n\n    return this;\n  }\n\n  /**\n   * @param {Scope} initiator\n   *\n   * @return {Scope}\n   */\n  fail(initiator) {\n    if (!this.failed) {\n      this.state = this.state.fail();\n\n      this.failInitiator = initiator;\n    }\n\n    return this;\n  }\n\n  cancel(initiator) {\n\n    if (!this.canceled) {\n      this.state = this.state.cancel();\n\n      this.cancelInitiator = initiator;\n    }\n\n    return this;\n  }\n\n  /**\n   * @param {Scope} initiator\n   *\n   * @return {Scope}\n   */\n  terminate(initiator) {\n    this.state = this.state.terminate();\n\n    this.terminateInitiator = initiator;\n\n    return this;\n  }\n\n  /**\n   * @return {Scope}\n   */\n  complete() {\n    this.state = this.state.complete();\n\n    return this;\n  }\n\n  /**\n   * Destroy the scope\n   *\n   * @param {Scope} initiator\n   *\n   * @return {Scope}\n   */\n  destroy(initiator) {\n    this.state = this.state.destroy();\n\n    this.destroyInitiator = initiator;\n\n    return this;\n  }\n\n  /**\n   * @return {number}\n   */\n  getTokens() {\n    return this.children.filter(c => !c.destroyed).length;\n  }\n\n  /**\n   * @param {Element} element\n   *\n   * @return {number}\n   */\n  getTokensByElement(element) {\n    return this.children.filter(c => !c.destroyed && c.element === element).length;\n  }\n\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/util/SetUtil.js\nfunction filterSet(set, matchFn) {\n\n  const matched = [];\n\n  for (const el of set) {\n    if (matchFn(el)) {\n      matched.push(el);\n    }\n  }\n\n  return matched;\n}\n\nfunction findSet(set, matchFn) {\n\n  for (const el of set) {\n    if (matchFn(el)) {\n      return el;\n    }\n  }\n\n  return null;\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/util/EventsUtil.js\nfunction eventsMatch(a, b) {\n  return [ 'type', 'name', 'ref', 'iref' ].every(attr => !(attr in a) || a[attr] === b[attr]);\n}\n// EXTERNAL MODULE: ./node_modules/bpmn-js-token-simulation/node_modules/min-dash/dist/index.esm.js\nvar bpmn_js_token_simulation_node_modules_min_dash_dist_index_esm = __webpack_require__(\"./node_modules/bpmn-js-token-simulation/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/util/ModelUtil.js\n\n\n\n\n\n\n\nfunction filterSequenceFlows(flows) {\n  return flows.filter(f => (0,ModelUtil.is)(f, 'bpmn:SequenceFlow'));\n}\n\nfunction isMessageFlow(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:MessageFlow');\n}\n\nfunction isSequenceFlow(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:SequenceFlow');\n}\n\nfunction isMessageCatch(element) {\n  return isCatchEvent(element) && isTypedEvent(element, 'bpmn:MessageEventDefinition');\n}\n\nfunction isLinkCatch(element) {\n  return isCatchEvent(element) && isTypedEvent(element, 'bpmn:LinkEventDefinition');\n}\n\nfunction isCompensationEvent(element) {\n  return isCatchEvent(element) && isTypedEvent(element, 'bpmn:CompensateEventDefinition');\n}\n\nfunction isCompensationActivity(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Activity') && element.businessObject.isForCompensation;\n}\n\nfunction isCatchEvent(element) {\n  return (\n    (0,ModelUtil.is)(element, 'bpmn:CatchEvent') ||\n    (0,ModelUtil.is)(element, 'bpmn:ReceiveTask')\n  ) && !isLabel(element);\n}\n\nfunction isBoundaryEvent(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:BoundaryEvent') && !isLabel(element);\n}\n\nfunction isStartEvent(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:StartEvent') && !isLabel(element);\n}\n\nfunction isLabel(element) {\n  return !!element.labelTarget;\n}\n\nfunction isEventSubProcess(element) {\n  return (0,ModelUtil/* getBusinessObject */.SS)(element).triggeredByEvent;\n}\n\nfunction isInterrupting(element) {\n  return (\n    (0,ModelUtil.is)(element, 'bpmn:StartEvent') && (0,ModelUtil/* getBusinessObject */.SS)(element).isInterrupting\n  ) || (\n    (0,ModelUtil.is)(element, 'bpmn:BoundaryEvent') && (0,ModelUtil/* getBusinessObject */.SS)(element).cancelActivity\n  );\n}\n\nfunction isAny(element, types) {\n  return types.some(type => (0,ModelUtil.is)(element, type));\n}\n\nfunction isTypedEvent(event, eventDefinitionType) {\n  return (0,bpmn_js_token_simulation_node_modules_min_dash_dist_index_esm/* some */.G)((0,ModelUtil/* getBusinessObject */.SS)(event).eventDefinitions, definition => {\n    return (0,ModelUtil.is)(definition, eventDefinitionType);\n  });\n}\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/Simulator.js\n\n\n\n\n\n\n\n\n\n\n\n\nfunction Simulator(injector, eventBus, elementRegistry) {\n\n  const ids = injector.get('scopeIds', false) || new ids_dist_index_esm/* default */.Z([ 32, 36 ]);\n\n  // element configuration\n  const configuration = {};\n\n  const behaviors = {};\n\n  const noopBehavior = new NoopBehavior();\n\n  const changedElements = new Set();\n\n  const jobs = [];\n\n  const scopes = new Set();\n  const subscriptions = new Set();\n\n  on('tick', function() {\n    for (const element of changedElements) {\n      emit('elementChanged', {\n        element\n      });\n    }\n\n    changedElements.clear();\n  });\n\n  function queue(scope, task) {\n\n    // add this task\n    jobs.push([ task, scope ]);\n\n    if (jobs.length !== 1) {\n      return;\n    }\n\n    let next;\n\n    while ((next = jobs[0])) {\n\n      const [ task, scope ] = next;\n\n      if (!scope.destroyed) {\n        task();\n      }\n\n      // remove first task\n      jobs.shift();\n    }\n\n    emit('tick');\n  }\n\n  function getBehavior(element) {\n    return behaviors[element.type] || noopBehavior;\n  }\n\n  function signal(context) {\n\n    const {\n      element,\n      parentScope,\n      initiator = null\n    } = context;\n\n    const scope = context.scope || initializeScope({\n      element,\n      parent: parentScope,\n      initiator\n    });\n\n    queue(scope, function() {\n\n      if (!scope.running) {\n        scope.start();\n      }\n\n      trace('signal', {\n        ...context,\n        scope\n      });\n\n      getBehavior(element).signal({\n        ...context,\n        scope\n      });\n\n      if (scope.parent) {\n        scopeChanged(scope.parent);\n      }\n    });\n\n    return scope;\n  }\n\n  function enter(context) {\n\n    const {\n      element,\n      scope: parentScope,\n      initiator = parentScope\n    } = context;\n\n    const scope = initializeScope({\n      element,\n      parent: parentScope,\n      initiator\n    });\n\n    queue(scope, function() {\n\n      if (!scope.running) {\n        scope.start();\n      }\n\n      trace('enter', context);\n\n      getBehavior(element).enter({\n        ...context,\n        initiator,\n        scope\n      });\n\n      scopeChanged(parentScope);\n    });\n\n    return scope;\n  }\n\n  function exit(context) {\n\n    const {\n      element,\n      scope,\n      initiator = scope\n    } = context;\n\n    queue(scope, function() {\n\n      trace('exit', context);\n\n      getBehavior(element).exit({\n        ...context,\n        initiator\n      });\n\n      if (scope.running) {\n        scope.complete();\n      }\n\n      destroyScope(scope, initiator);\n\n      scope.parent && scopeChanged(scope.parent);\n    });\n  }\n\n  function trigger(context) {\n    const {\n      event: _event,\n      initiator,\n      scope\n    } = context;\n\n    // behavior depends on available event subscriptions\n    //\n    // interrupt (one-off, clear all events)\n    //   => keep interrupting boundary event sub-scriptions of same type, if available\n    //\n    // continue (one-off signal)\n    //\n    // non-interrupting (as many as needed)\n\n    const event = getEvent(_event);\n\n    const subscriptions = scope.subscriptions;\n\n    const matchingSubscriptions = filterSet(\n      subscriptions, subscription => eventsMatch(event, subscription.event)\n    );\n\n    const nonInterrupting = matchingSubscriptions.filter(\n      subscription => !subscription.event.interrupting\n    );\n\n    const interrupting = matchingSubscriptions.filter(\n      subscription => subscription.event.interrupting\n    );\n\n    if (!interrupting.length) {\n      return nonInterrupting.map(\n        subscription => subscription.triggerFn(initiator)\n      ).flat();\n    }\n\n    const interrupt = interrupting.find(subscription => !subscription.event.boundary) || interrupting[0];\n\n    const remainingSubscriptions = filterSet(\n      subscriptions,\n      subscription => subscription.event.persistent || isRethrow(subscription.event, interrupt.event)\n    );\n\n    subscriptions.forEach(subscription => {\n      if (!remainingSubscriptions.includes(subscription)) {\n        subscription.remove();\n      }\n    });\n\n    return [ interrupt.triggerFn(initiator) ].flat().filter(s => s);\n  }\n\n  function subscribe(scope, event, triggerFn) {\n\n    event = getEvent(event);\n\n    const element = event.element;\n\n    const subscription = {\n      scope,\n      event,\n      element,\n      triggerFn,\n      remove() {\n        unsubscribe(subscription);\n      }\n    };\n\n    subscriptions.add(subscription);\n\n    scope.subscriptions.add(subscription);\n\n    if (element) {\n      elementChanged(element);\n    }\n\n    return subscription;\n  }\n\n  function unsubscribe(subscription) {\n    const {\n      scope,\n      event\n    } = subscription;\n\n    subscriptions.delete(subscription);\n\n    scope.subscriptions.delete(subscription);\n\n    if (event.element) {\n      elementChanged(event.element);\n    }\n  }\n\n  function createInternalRef(element) {\n    if (\n      (0,ModelUtil.is)(element, 'bpmn:StartEvent') ||\n      (0,ModelUtil.is)(element, 'bpmn:IntermediateCatchEvent') ||\n      (0,ModelUtil.is)(element, 'bpmn:ReceiveTask') ||\n      isSpecialBoundaryEvent(element)\n    ) {\n      return (0,ModelUtil/* getBusinessObject */.SS)(element).name || element.id;\n    }\n\n    return null;\n  }\n\n  function getEvent(element) {\n\n    // do not double-return element\n    if (!element.businessObject) {\n      return element;\n    }\n\n    const interrupting = isInterrupting(element);\n    const boundary = isBoundaryEvent(element);\n\n    // we do create an internal reference for\n    // catch-like events to ensure these can\n    // be triggered via the UI exclusively\n    const iref = createInternalRef(element);\n\n    const baseEvent = {\n      element,\n      interrupting,\n      boundary,\n      ...(iref ? { iref } : {})\n    };\n\n    const eventDefinition = getEventDefinitions(element)[0];\n\n    if (!eventDefinition) {\n\n      return {\n        ...baseEvent,\n        type: isImplicitMessageCatch(element) ? 'message' : 'none'\n      };\n    }\n\n    if ((0,ModelUtil.is)(eventDefinition, 'bpmn:LinkEventDefinition')) {\n      return {\n        ...baseEvent,\n        type: 'link',\n        name: eventDefinition.name\n      };\n    }\n\n    if ((0,ModelUtil.is)(eventDefinition, 'bpmn:SignalEventDefinition')) {\n      return {\n        ...baseEvent,\n        type: 'signal',\n        ref: eventDefinition.signalRef\n      };\n    }\n\n    if ((0,ModelUtil.is)(eventDefinition, 'bpmn:TimerEventDefinition')) {\n      return {\n        ...baseEvent,\n        type: 'timer'\n      };\n    }\n\n    if ((0,ModelUtil.is)(eventDefinition, 'bpmn:ConditionalEventDefinition')) {\n      return {\n        ...baseEvent,\n        type: 'condition',\n      };\n    }\n\n    if ((0,ModelUtil.is)(eventDefinition, 'bpmn:EscalationEventDefinition')) {\n      return {\n        ...baseEvent,\n        type: 'escalation',\n        ref: eventDefinition.escalationRef\n      };\n    }\n\n    if ((0,ModelUtil.is)(eventDefinition, 'bpmn:CancelEventDefinition')) {\n      return {\n        ...baseEvent,\n        type: 'cancel'\n      };\n    }\n\n    if ((0,ModelUtil.is)(eventDefinition, 'bpmn:ErrorEventDefinition')) {\n      return {\n        ...baseEvent,\n        type: 'error',\n        ref: eventDefinition.errorRef\n      };\n    }\n\n    if ((0,ModelUtil.is)(eventDefinition, 'bpmn:MessageEventDefinition')) {\n      return {\n        ...baseEvent,\n        type: 'message',\n        ref: eventDefinition.messageRef\n      };\n    }\n\n    if ((0,ModelUtil.is)(eventDefinition, 'bpmn:CompensateEventDefinition')) {\n\n      let ref = eventDefinition.activityRef && elementRegistry.get(eventDefinition.activityRef.id);\n\n      if (!ref) {\n\n        // start event in event sub-process compensates\n        // parent process (or participant)\n        if (isStartEvent(element) && isEventSubProcess(element.parent)) {\n          ref = element.parent.parent;\n        } else\n\n        // boundary event compensates activity it is attached to\n        if (isBoundaryEvent(element)) {\n          ref = element.host;\n        }\n\n        // parent is cancel scope\n        else {\n          ref = element.parent;\n        }\n      }\n\n      return {\n        ...baseEvent,\n        type: 'compensate',\n        ref,\n        persistent: true\n      };\n    }\n\n    throw new Error('unknown event definition', eventDefinition);\n  }\n\n  function createScope(context, emitEvent = true) {\n\n    const {\n      element,\n      parent: parentScope,\n      initiator\n    } = context;\n\n    emitEvent && trace('createScope', {\n      element,\n      scope: parentScope\n    });\n\n    const scope = new Scope(ids.next(), element, parentScope, initiator);\n\n    if (parentScope) {\n      parentScope.children.push(scope);\n    }\n\n    scopes.add(scope);\n\n    emitEvent && emit('createScope', {\n      scope\n    });\n\n    elementChanged(element);\n\n    if (parentScope) {\n      elementChanged(parentScope.element);\n    }\n\n    return scope;\n  }\n\n  function subscriptionFilter(filter) {\n\n    if (typeof filter === 'function') {\n      return filter;\n    }\n\n    const {\n      event: _event,\n      element,\n      scope\n    } = filter;\n\n    const elements = filter.elements || (element && [ element ]);\n    const event = _event && getEvent(_event);\n\n    return (\n      (subscription) =>\n        (!event || eventsMatch(event, subscription.event)) &&\n        (!elements || elements.includes(subscription.element)) &&\n        (!scope || scope === subscription.scope)\n    );\n  }\n\n  function scopeSubscriptionFilter(event) {\n    const matchesSubscription = event === 'function' ? event : subscriptionFilter(event);\n\n    return (\n      scope => Array.from(scope.subscriptions).some(matchesSubscription)\n    );\n  }\n\n  function scopeFilter(filter) {\n\n    if (typeof filter === 'function') {\n      return filter;\n    }\n\n    const {\n      element,\n      waitsOnElement,\n      parent,\n      trait = ScopeTraits.RUNNING,\n      subscribedTo\n    } = filter;\n\n    const isSubscribed = subscribedTo ? scopeSubscriptionFilter(subscribedTo) : () => true;\n\n    return (\n      scope =>\n        (!element || scope.element === element) &&\n        (!parent || scope.parent === parent) &&\n        (!waitsOnElement || scope.getTokensByElement(waitsOnElement) > 0) &&\n        scope.hasTrait(trait) &&\n        isSubscribed(scope)\n    );\n  }\n\n  function findSubscriptions(filter) {\n    return filterSet(subscriptions, subscriptionFilter(filter));\n  }\n\n  function findSubscription(filter) {\n    return findSet(subscriptions, subscriptionFilter(filter));\n  }\n\n  function findScopes(filter) {\n    return filterSet(scopes, scopeFilter(filter));\n  }\n\n  function findScope(filter) {\n    return findSet(scopes, scopeFilter(filter));\n  }\n\n  function destroyScope(scope, initiator = null) {\n\n    if (scope.destroyed) {\n      return;\n    }\n\n    scope.destroy(initiator);\n\n    // remove outdated subscriptions\n    for (const subscription of scope.subscriptions) {\n      const trait = subscription.event.traits || ScopeTraits.ACTIVE;\n\n      if (!scope.hasTrait(trait)) {\n        unsubscribe(subscription);\n      }\n    }\n\n    // depending on taken transition scope many not actually\n    // be destroyed but in an inactive / completed state\n    //\n    // only perform additional destructive operations in case we're\n    // actually DEAD.\n    if (scope.destroyed) {\n\n      // destroy child scopes\n      for (const childScope of scope.children) {\n        if (!childScope.destroyed) {\n          destroyScope(childScope, initiator);\n        }\n      }\n\n      trace('destroyScope', {\n        element: scope.element,\n        scope\n      });\n\n      // remove dead scope\n      scopes.delete(scope);\n\n      emit('destroyScope', {\n        scope\n      });\n    }\n\n    elementChanged(scope.element);\n\n    if (scope.parent) {\n      elementChanged(scope.parent.element);\n    }\n  }\n\n  function trace(action, context) {\n\n    emit('trace', {\n      ...context,\n      action\n    });\n  }\n\n  function elementChanged(element) {\n    changedElements.add(element);\n\n    // tick, unless jobs are queued\n    // (and tick is going to happen naturally)\n    if (!jobs.length) {\n      emit('tick');\n    }\n  }\n\n  function scopeChanged(scope) {\n    emit('scopeChanged', {\n      scope\n    });\n  }\n\n  function emit(event, payload = {}) {\n    return eventBus.fire(`tokenSimulation.simulator.${event}`, payload);\n  }\n\n  function on(event, callback) {\n    eventBus.on('tokenSimulation.simulator.' + event, callback);\n  }\n\n  function off(event, callback) {\n    eventBus.off('tokenSimulation.simulator.' + event, callback);\n  }\n\n  function setConfig(element, updatedConfig) {\n\n    const existingConfig = getConfig(element);\n\n    configuration[element.id || element] = {\n      ...existingConfig,\n      ...updatedConfig\n    };\n\n    elementChanged(element);\n  }\n\n  function initializeRootScopes() {\n\n    const rootScopes = [];\n\n    elementRegistry.forEach(element => {\n\n      if (!isAny(element, [ 'bpmn:Process', 'bpmn:Participant' ])) {\n        return;\n      }\n\n      const scope = createScope({\n        element\n      }, false);\n\n      rootScopes.push(scope);\n\n      const startEvents = element.children.filter(isStartEvent);\n\n      for (const startEvent of startEvents) {\n\n        const event = {\n          ...getEvent(startEvent),\n          interrupting: false\n        };\n\n        // start events can always be triggered\n        subscribe(scope, event, initiator => signal({\n          element,\n          startEvent,\n          initiator\n        }));\n      }\n    });\n\n    return rootScopes;\n  }\n\n  function initializeScope(context) {\n\n    const {\n      element\n    } = context;\n\n    const scope = createScope(context);\n\n    const {\n      children = [],\n      attachers = []\n    } = element;\n\n    for (const childElement of children) {\n\n      // event sub-process start events\n      if (isEventSubProcess(childElement)) {\n        const startEvents = childElement.children.filter(\n          element => isStartEvent(element) && !isCompensationEvent(element)\n        );\n\n        for (const startEvent of startEvents) {\n          subscribe(scope, startEvent, initiator => {\n\n            return signal({\n              element: childElement,\n              parentScope: scope,\n              startEvent,\n              initiator\n            });\n          });\n        }\n      }\n    }\n\n    for (const attacher of attachers) {\n\n      // boundary events\n      if (isBoundaryEvent(attacher) && !isCompensationEvent(attacher)) {\n\n        subscribe(scope, attacher, initiator => {\n          return signal({\n            element: attacher,\n            parentScope: scope.parent,\n            hostScope: scope,\n            initiator\n          });\n        });\n      }\n    }\n\n    return scope;\n  }\n\n  function getConfig(element) {\n    return configuration[element.id || element] || {};\n  }\n\n  function waitForScopes(scope, scopes) {\n\n    if (!scopes.length) {\n      return;\n    }\n\n    const event = {\n      type: 'all-completed',\n      persistent: false\n    };\n\n    const remainingScopes = new Set(scopes);\n\n    const destroyListener = (destroyEvent) => {\n      remainingScopes.delete(destroyEvent.scope);\n\n      if (remainingScopes.size === 0) {\n        off('destroyScope', destroyListener);\n\n        trigger({\n          scope,\n          event\n        });\n      }\n    };\n\n    on('destroyScope', destroyListener);\n\n    return event;\n  }\n\n  function waitAtElement(element, wait = true) {\n    setConfig(element, {\n      wait\n    });\n  }\n\n  function reset() {\n    for (const scope of scopes) {\n      destroyScope(scope);\n    }\n\n    for (const rootScope of initializeRootScopes()) {\n      scopes.add(rootScope);\n    }\n\n    // TODO(nikku): clear configuration?\n\n    emit('tick');\n    emit('reset');\n  }\n\n  // utilties\n  this.createScope = createScope;\n  this.destroyScope = destroyScope;\n\n  // inspection\n  this.findScope = findScope;\n  this.findScopes = findScopes;\n\n  this.findSubscription = findSubscription;\n  this.findSubscriptions = findSubscriptions;\n\n  // configuration\n  this.waitAtElement = waitAtElement;\n\n  this.waitForScopes = waitForScopes;\n\n  this.setConfig = setConfig;\n  this.getConfig = getConfig;\n\n  // driving simulation forward\n  this.signal = signal;\n  this.enter = enter;\n  this.exit = exit;\n\n  // BPMN event subscriptions and triggers\n  this.subscribe = subscribe;\n  this.trigger = trigger;\n\n  // life-cycle\n  this.reset = reset;\n\n  // emitter\n  this.on = on;\n  this.off = off;\n\n  // extension\n  this.registerBehavior = function(element, behavior) {\n    behaviors[element] = behavior;\n  };\n}\n\nSimulator.$inject = [\n  'injector',\n  'eventBus',\n  'elementRegistry'\n];\n\n\n// helpers /////////////////\n\nfunction NoopBehavior() {\n\n  this.signal = function(context) {\n    console.log('ignored #exit', context.element);\n  };\n\n  this.exit = function(context) {\n    console.log('ignored #exit', context.element);\n  };\n\n  this.enter = function(context) {\n    console.log('ignored #enter', context.element);\n  };\n\n}\n\nfunction isRethrow(event, interrupt) {\n  return (\n    event.type === interrupt.type &&\n    event.boundary && !interrupt.boundary\n  );\n}\n\nfunction isImplicitMessageCatch(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:ReceiveTask') || element.incoming.some(element => (0,ModelUtil.is)(element, 'bpmn:MessageFlow'));\n}\n\nfunction isSpecialBoundaryEvent(element) {\n  if (!isBoundaryEvent(element)) {\n    return false;\n  }\n\n  const eventDefinitions = getEventDefinitions(element);\n\n  return !eventDefinitions[0] || isAny(eventDefinitions[0], [\n    'bpmn:ConditionalEventDefinition', 'bpmn:TimerEventDefinition'\n  ]);\n}\n\nfunction getEventDefinitions(element) {\n  return element.businessObject.get('eventDefinitions') || [];\n}\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/StartEventBehavior.js\nfunction StartEventBehavior(\n    simulator,\n    activityBehavior) {\n\n  this._simulator = simulator;\n  this._activityBehavior = activityBehavior;\n\n  simulator.registerBehavior('bpmn:StartEvent', this);\n}\n\nStartEventBehavior.prototype.signal = function(context) {\n  this._simulator.exit(context);\n};\n\nStartEventBehavior.prototype.exit = function(context) {\n  this._activityBehavior.exit(context);\n};\n\nStartEventBehavior.$inject = [\n  'simulator',\n  'activityBehavior'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/EndEventBehavior.js\nfunction EndEventBehavior(\n    simulator,\n    scopeBehavior,\n    intermediateThrowEventBehavior) {\n\n  this._intermediateThrowEventBehavior = intermediateThrowEventBehavior;\n  this._scopeBehavior = scopeBehavior;\n\n  simulator.registerBehavior('bpmn:EndEvent', this);\n}\n\nEndEventBehavior.$inject = [\n  'simulator',\n  'scopeBehavior',\n  'intermediateThrowEventBehavior'\n];\n\nEndEventBehavior.prototype.enter = function(context) {\n  this._intermediateThrowEventBehavior.enter(context);\n};\n\nEndEventBehavior.prototype.signal = function(context) {\n  this._intermediateThrowEventBehavior.signal(context);\n};\n\nEndEventBehavior.prototype.exit = function(context) {\n\n  const {\n    scope\n  } = context;\n\n  this._scopeBehavior.tryExit(scope.parent, scope);\n};\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/BoundaryEventBehavior.js\n\n\n\nfunction BoundaryEventBehavior(\n    simulator,\n    activityBehavior,\n    scopeBehavior) {\n\n  this._simulator = simulator;\n  this._activityBehavior = activityBehavior;\n  this._scopeBehavior = scopeBehavior;\n\n  simulator.registerBehavior('bpmn:BoundaryEvent', this);\n}\n\nBoundaryEventBehavior.prototype.signal = function(context) {\n\n  const {\n    element,\n    scope,\n    hostScope = this._simulator.findScope({\n      parent: scope.parent,\n      element: element.host\n    })\n  } = context;\n\n  if (!hostScope) {\n    throw new Error('host scope not found');\n  }\n\n  const cancelActivity = (0,ModelUtil/* getBusinessObject */.SS)(element).cancelActivity;\n\n  if (cancelActivity) {\n    this._scopeBehavior.interrupt(hostScope, scope);\n\n    // activities are pending completion before actual exit\n    const event = this._scopeBehavior.tryExit(hostScope, scope);\n\n    if (event) {\n      const subscription = this._simulator.subscribe(hostScope, event, initiator => {\n        subscription.remove();\n\n        return this._simulator.exit(context);\n      });\n\n      return;\n    }\n  }\n\n  this._simulator.exit(context);\n};\n\nBoundaryEventBehavior.prototype.exit = function(context) {\n  this._activityBehavior.exit(context);\n};\n\nBoundaryEventBehavior.$inject = [\n  'simulator',\n  'activityBehavior',\n  'scopeBehavior'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/IntermediateCatchEventBehavior.js\nfunction IntermediateCatchEventBehavior(\r\n    simulator,\r\n    activityBehavior) {\r\n\r\n  this._activityBehavior = activityBehavior;\r\n  this._simulator = simulator;\r\n\r\n  simulator.registerBehavior('bpmn:IntermediateCatchEvent', this);\r\n  simulator.registerBehavior('bpmn:ReceiveTask', this);\r\n}\r\n\r\nIntermediateCatchEventBehavior.$inject = [\r\n  'simulator',\r\n  'activityBehavior'\r\n];\r\n\r\nIntermediateCatchEventBehavior.prototype.signal = function(context) {\r\n  return this._simulator.exit(context);\r\n};\r\n\r\nIntermediateCatchEventBehavior.prototype.enter = function(context) {\r\n  const {\r\n    element\r\n  } = context;\r\n\r\n  // adapt special wait semantics; user must manually\r\n  // trigger to indicate message received\r\n  return this._activityBehavior.signalOnEvent(context, element);\r\n};\r\n\r\nIntermediateCatchEventBehavior.prototype.exit = function(context) {\r\n  this._activityBehavior.exit(context);\r\n};\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/IntermediateThrowEventBehavior.js\nfunction IntermediateThrowEventBehavior(\r\n    simulator,\r\n    activityBehavior,\r\n    eventBehaviors) {\r\n\r\n  this._simulator = simulator;\r\n  this._activityBehavior = activityBehavior;\r\n  this._eventBehaviors = eventBehaviors;\r\n\r\n  simulator.registerBehavior('bpmn:IntermediateThrowEvent', this);\r\n  simulator.registerBehavior('bpmn:SendTask', this);\r\n}\r\n\r\nIntermediateThrowEventBehavior.prototype.enter = function(context) {\r\n  const {\r\n    element\r\n  } = context;\r\n\r\n  const eventBehavior = this._eventBehaviors.get(element);\r\n\r\n  if (eventBehavior) {\r\n    const event = eventBehavior(context);\r\n\r\n    if (event) {\r\n      return this._activityBehavior.signalOnEvent(context, event);\r\n    }\r\n  }\r\n\r\n  this._activityBehavior.enter(context);\r\n};\r\n\r\nIntermediateThrowEventBehavior.prototype.signal = function(context) {\r\n  this._activityBehavior.signal(context);\r\n};\r\n\r\nIntermediateThrowEventBehavior.prototype.exit = function(context) {\r\n  this._activityBehavior.exit(context);\r\n};\r\n\r\nIntermediateThrowEventBehavior.$inject = [\r\n  'simulator',\r\n  'activityBehavior',\r\n  'eventBehaviors'\r\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/ExclusiveGatewayBehavior.js\n\n\n\nfunction ExclusiveGatewayBehavior(simulator) {\n  this._simulator = simulator;\n\n  simulator.registerBehavior('bpmn:ExclusiveGateway', this);\n}\n\nExclusiveGatewayBehavior.prototype.enter = function(context) {\n  this._simulator.exit(context);\n};\n\nExclusiveGatewayBehavior.prototype.exit = function(context) {\n\n  const {\n    element,\n    scope\n  } = context;\n\n  // depends on UI to properly configure activeOutgoing for\n  // each exclusive gateway\n\n  const outgoings = filterSequenceFlows(element.outgoing);\n\n  if (outgoings.length === 1) {\n    return this._simulator.enter({\n      element: outgoings[0],\n      scope: scope.parent\n    });\n  }\n\n  const {\n    activeOutgoing\n  } = this._simulator.getConfig(element);\n\n  const outgoing = outgoings.find(o => o === activeOutgoing);\n\n  if (!outgoing) {\n    throw new Error('no outgoing configured');\n  }\n\n  return this._simulator.enter({\n    element: outgoing,\n    scope: scope.parent\n  });\n};\n\nExclusiveGatewayBehavior.$inject = [ 'simulator' ];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/ParallelGatewayBehavior.js\n\n\n\nfunction ParallelGatewayBehavior(\n    simulator,\n    activityBehavior) {\n\n  this._simulator = simulator;\n  this._activityBehavior = activityBehavior;\n\n  simulator.registerBehavior('bpmn:ParallelGateway', this);\n}\n\nParallelGatewayBehavior.prototype.enter = function(context) {\n\n  const {\n    scope,\n    element\n  } = context;\n\n  const sequenceFlows = filterSequenceFlows(element.incoming);\n\n  const {\n    parent: parentScope\n  } = scope;\n\n  const elementScopes = this._simulator.findScopes({\n    parent: parentScope,\n    element: element\n  });\n\n  if (elementScopes.length === sequenceFlows.length) {\n\n    for (const childScope of elementScopes) {\n\n      if (childScope !== scope) {\n\n        // complete joining child scope\n        this._simulator.destroyScope(childScope.complete(), scope);\n      }\n    }\n\n    this._simulator.exit(context);\n  }\n};\n\nParallelGatewayBehavior.prototype.exit = function(context) {\n  this._activityBehavior.exit(context);\n};\n\nParallelGatewayBehavior.$inject = [\n  'simulator',\n  'activityBehavior'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/EventBasedGatewayBehavior.js\n\n\n\nfunction EventBasedGatewayBehavior(simulator) {\n  this._simulator = simulator;\n\n  simulator.registerBehavior('bpmn:EventBasedGateway', this);\n}\n\nEventBasedGatewayBehavior.$inject = [\n  'simulator'\n];\n\nEventBasedGatewayBehavior.prototype.enter = function(context) {\n\n  const {\n    element,\n    scope\n  } = context;\n\n  const parentScope = scope.parent;\n\n  const triggerElements = getTriggers(element);\n\n  // create subscriptions for outgoing event triggers\n  // do nothing else beyond that\n  const subscriptions = triggerElements.map(\n    triggerElement => this._simulator.subscribe(parentScope, triggerElement, initiator => {\n\n      // cancel all subscriptions\n      subscriptions.forEach(subscription => subscription.remove());\n\n      // destroy this scope\n      this._simulator.destroyScope(scope, initiator);\n\n      // signal triggered event\n      return this._simulator.signal({\n        element: triggerElement,\n        parentScope,\n        initiator\n      });\n    })\n  );\n\n};\n\n\n// helpers ////////////////\n\nfunction getTriggers(element) {\n  return element.outgoing.map(\n    outgoing => outgoing.target\n  ).filter(activity => isAny(activity, [\n    'bpmn:IntermediateCatchEvent',\n    'bpmn:ReceiveTask'\n  ]));\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/ActivityBehavior.js\n\n\n\nfunction ActivityBehavior(\n    simulator,\n    scopeBehavior,\n    transactionBehavior\n) {\n  this._simulator = simulator;\n  this._scopeBehavior = scopeBehavior;\n  this._transactionBehavior = transactionBehavior;\n\n  const elements = [\n    'bpmn:BusinessRuleTask',\n    'bpmn:CallActivity',\n    'bpmn:ManualTask',\n    'bpmn:ScriptTask',\n    'bpmn:ServiceTask',\n    'bpmn:Task',\n    'bpmn:UserTask'\n  ];\n\n  for (const element of elements) {\n    simulator.registerBehavior(element, this);\n  }\n}\n\nActivityBehavior.$inject = [\n  'simulator',\n  'scopeBehavior',\n  'transactionBehavior'\n];\n\nActivityBehavior.prototype.signal = function(context) {\n\n  // trigger messages that are pending send\n  const event = this._triggerMessages(context);\n\n  if (event) {\n    return this.signalOnEvent(context, event);\n  }\n\n  this._simulator.exit(context);\n};\n\nActivityBehavior.prototype.enter = function(context) {\n\n  const {\n    element\n  } = context;\n\n  const continueEvent = this.waitAtElement(element);\n\n  if (continueEvent) {\n    return this.signalOnEvent(context, continueEvent);\n  }\n\n  // trigger messages that are pending send\n  const event = this._triggerMessages(context);\n\n  if (event) {\n    return this.signalOnEvent(context, event);\n  }\n\n  this._simulator.exit(context);\n};\n\nActivityBehavior.prototype.exit = function(context) {\n\n  const {\n    element,\n    scope\n  } = context;\n\n  const parentScope = scope.parent;\n\n  // TODO(nikku): if a outgoing flow is conditional,\n  //              task has exclusive gateway semantics,\n  //              else, task has parallel gateway semantics\n\n  const complete = !scope.failed;\n\n  // compensation is registered AFTER successful completion\n  // of normal scope activities (non event sub-processes).\n  //\n  // we must register it now, not earlier\n  if (complete && !isEventSubProcess(element)) {\n    this._transactionBehavior.registerCompensation(scope);\n  }\n\n  // if exception flow is active,\n  // do not activate any outgoing flows\n  const activatedFlows = complete\n    ? element.outgoing.filter(isSequenceFlow)\n    : [];\n\n  activatedFlows.forEach(\n    element => this._simulator.enter({\n      element,\n      scope: parentScope\n    })\n  );\n\n  // element has token sink semantics\n  if (activatedFlows.length === 0) {\n    this._scopeBehavior.tryExit(parentScope, scope);\n  }\n};\n\nActivityBehavior.prototype.signalOnEvent = function(context, event) {\n\n  const {\n    scope,\n    element\n  } = context;\n\n  const subscription = this._simulator.subscribe(scope, event, initiator => {\n\n    subscription.remove();\n\n    return this._simulator.signal({\n      scope,\n      element,\n      initiator\n    });\n  });\n};\n\n/**\n * Returns an event to subscribe to if wait on element is configured.\n *\n * @param {Element} element\n *\n * @return {Object|null} event\n */\nActivityBehavior.prototype.waitAtElement = function(element) {\n  const wait = this._simulator.getConfig(element).wait;\n\n  return wait && {\n    element,\n    type: 'continue',\n    interrupting: false,\n    boundary: false\n  };\n};\n\nActivityBehavior.prototype._getMessageContexts = function(element, after = null) {\n\n  const filterAfter = after ? ctx => ctx.referencePoint.x > after.x : () => true;\n  const sortByReference = (a, b) => a.referencePoint.x - b.referencePoint.x;\n\n  return [\n    ...element.incoming.filter(isMessageFlow).map(flow => ({\n      incoming: flow,\n      referencePoint: last(flow.waypoints)\n    })),\n    ...element.outgoing.filter(isMessageFlow).map(flow => ({\n      outgoing: flow,\n      referencePoint: first(flow.waypoints)\n    }))\n  ].sort(sortByReference).filter(filterAfter);\n};\n\n/**\n * @param {any} context\n *\n * @return {Object} event to subscribe to proceed\n */\nActivityBehavior.prototype._triggerMessages = function(context) {\n\n  // check for the next message flows to either\n  // trigger or wait for; this implements intuitive,\n  // as-you-would expect message flow execution in modeling\n  // direction (left-to-right).\n\n  const {\n    element,\n    initiator,\n    scope\n  } = context;\n\n  let messageContexts = scope.messageContexts;\n\n  if (!messageContexts) {\n    messageContexts = scope.messageContexts = this._getMessageContexts(element);\n  }\n\n  const initiatingFlow = initiator && initiator.element;\n\n  if (isMessageFlow(initiatingFlow)) {\n\n    // ignore out of bounds messages received;\n    // user may manually advance and force send all outgoing\n    // messages\n    if (scope.expectedIncoming !== initiatingFlow) {\n      console.debug('Simulator :: ActivityBehavior :: ignoring out-of-bounds message');\n\n      return;\n    }\n  }\n\n  while (messageContexts.length) {\n    const {\n      incoming,\n      outgoing\n    } = messageContexts.shift();\n\n    if (incoming) {\n\n      // force sending of all remaining messages,\n      // as the user triggered the task manually (for demonstration\n      // purposes\n      if (!initiator) {\n        continue;\n      }\n\n      // remember expected incoming for future use\n      scope.expectedIncoming = incoming;\n\n      return {\n        element,\n        type: 'message',\n        name: incoming.id,\n        interrupting: false,\n        boundary: false\n      };\n    }\n\n    this._simulator.signal({\n      element: outgoing\n    });\n  }\n\n};\n\n\n// helpers //////////////////\n\nfunction first(arr) {\n  return arr && arr[0];\n}\n\nfunction last(arr) {\n  return arr && arr[arr.length - 1];\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/SubProcessBehavior.js\n\n\n\nfunction SubProcessBehavior(\n    simulator,\n    activityBehavior,\n    scopeBehavior,\n    transactionBehavior,\n    elementRegistry) {\n\n  this._simulator = simulator;\n  this._activityBehavior = activityBehavior;\n  this._scopeBehavior = scopeBehavior;\n  this._transactionBehavior = transactionBehavior;\n  this._elementRegistry = elementRegistry;\n\n  simulator.registerBehavior('bpmn:SubProcess', this);\n  simulator.registerBehavior('bpmn:Transaction', this);\n  simulator.registerBehavior('bpmn:AdHocSubProcess', this);\n}\n\nSubProcessBehavior.$inject = [\n  'simulator',\n  'activityBehavior',\n  'scopeBehavior',\n  'transactionBehavior',\n  'elementRegistry'\n];\n\nSubProcessBehavior.prototype.signal = function(context) {\n  this._start(context);\n};\n\nSubProcessBehavior.prototype.enter = function(context) {\n\n  const {\n    element\n  } = context;\n\n  const continueEvent = this._activityBehavior.waitAtElement(element);\n\n  if (continueEvent) {\n    return this._activityBehavior.signalOnEvent(context, continueEvent);\n  }\n\n  this._start(context);\n};\n\nSubProcessBehavior.prototype.exit = function(context) {\n\n  const {\n    scope\n  } = context;\n\n  const parentScope = scope.parent;\n\n  // successful completion of the fail initiator (event sub-process)\n  // recovers the parent, so that the normal flow is being executed\n  if (parentScope.failInitiator === scope) {\n    parentScope.complete();\n  }\n\n  this._activityBehavior.exit(context);\n};\n\nSubProcessBehavior.prototype._start = function(context) {\n  const {\n    element,\n    startEvent,\n    scope\n  } = context;\n\n  const targetScope = scope.parent;\n\n  if (isEventSubProcess(element)) {\n\n    if (!startEvent) {\n      throw new Error('missing <startEvent>: required for event sub-process');\n    }\n  } else {\n    if (startEvent) {\n      throw new Error('unexpected <startEvent>: not allowed for sub-process');\n    }\n  }\n\n  if (targetScope.destroyed) {\n    throw new Error(`target scope <${targetScope.id}> destroyed`);\n  }\n\n  if (isTransaction(element)) {\n    this._transactionBehavior.setup(context);\n  }\n\n  if (startEvent && isInterrupting(startEvent)) {\n    this._scopeBehavior.interrupt(targetScope, scope);\n  }\n\n  const startEvents = startEvent ? [ startEvent ] : this._findStarts(element);\n\n  for (const element of startEvents) {\n    this._simulator.signal({\n      element,\n      parentScope: scope,\n      initiator: scope\n    });\n  }\n};\n\nSubProcessBehavior.prototype._findStarts = function(element) {\n\n  // ensure bpmn-js@9 compatibility\n  //\n  // sub-process may be collapsed, in this case operate on the plane\n  element = this._elementRegistry.get(element.id + '_plane') || element;\n\n  return element.children.filter(child => {\n\n    if (isLabel(child)) {\n      return false;\n    }\n\n    const incoming = child.incoming.find(c => (0,ModelUtil.is)(c, 'bpmn:SequenceFlow'));\n\n    if (incoming) {\n      return false;\n    }\n\n    if (isCompensationActivity(child)) {\n      return false;\n    }\n\n    if (isEventSubProcess(child)) {\n      return false;\n    }\n\n    return isAny(child, [\n      'bpmn:Activity',\n      'bpmn:StartEvent',\n      'bpmn:EndEvent'\n    ]);\n  });\n};\n\nfunction isTransaction(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Transaction');\n}\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/TransactionBehavior.js\n\n\n\n\n\n\n\n\n\nconst CANCEL_EVENT = {\n  type: 'cancel',\n  interrupting: true,\n  boundary: false,\n  persistent: true\n};\n\n\nfunction TransactionBehavior(simulator, scopeBehavior) {\n  this._simulator = simulator;\n  this._scopeBehavior = scopeBehavior;\n}\n\nTransactionBehavior.$inject = [\n  'simulator',\n  'scopeBehavior'\n];\n\nTransactionBehavior.prototype.setup = function(context) {\n\n  const {\n    scope\n  } = context;\n\n  const cancelSubscription = this._simulator.subscribe(scope, CANCEL_EVENT, (initiator) => {\n\n    cancelSubscription.remove();\n\n    return this.cancel({\n      scope,\n      initiator\n    });\n  });\n\n  const compensateEvent = {\n    type: 'compensate',\n    ref: scope.element,\n    persistent: true,\n    traits: ScopeTraits.NOT_DEAD\n  };\n\n  const compensateSubscription = this._simulator.subscribe(scope, compensateEvent, (initiator) => {\n\n    // need to trigger ordinary\n    // transaction cancelation\n    if (!scope.canceled) {\n      return this._simulator.trigger({\n        event: CANCEL_EVENT,\n        scope\n      });\n    }\n\n    compensateSubscription.remove();\n\n    return this.compensate({\n      scope,\n      element: scope.element,\n      initiator\n    });\n  });\n};\n\nTransactionBehavior.prototype.cancel = function(context) {\n\n  const {\n    scope,\n    initiator\n  } = context;\n\n  // bail out on double cancel\n  if (scope.destroyed) {\n    return;\n  }\n\n  // mark scope as canceled\n  scope.cancel(initiator);\n\n  // trigger compensation on element\n  this._simulator.trigger({\n    event: {\n      type: 'compensate',\n      ref: scope.element\n    },\n    initiator,\n    scope\n  });\n\n  // re-trigger cancel (to trigger boundary cancel events)\n  return this._simulator.trigger({\n    scope,\n    initiator,\n    event: CANCEL_EVENT\n  });\n};\n\nTransactionBehavior.prototype.registerCompensation = function(scope) {\n\n  const {\n    element\n  } = scope;\n\n  // check for compensation triggers\n  //\n  // * embedded compensation event sub-processes\n  // * compensation boundary events\n\n  const compensateStartEvents = element.children.filter(\n    isEventSubProcess\n  ).map(\n    element => element.children.find(\n      element => isStartEvent(element) && isCompensationEvent(element)\n    )\n  ).filter(s => s);\n\n  const compensateBoundaryEvents = element.attachers.filter(isCompensationEvent);\n\n  if (!compensateStartEvents.length && !compensateBoundaryEvents.length) {\n    return;\n  }\n\n  // always register on parent scope\n  const transactionScope = this.findTransactionScope(scope.parent);\n\n  // sub processes may enter a <compensable> state\n  // in that state they are kept alive on exit\n  // until the parent gets destroyed; as long as they are kept alive\n  // compensation can happen on them\n  //\n  if (!(0,ModelUtil.is)(transactionScope.element, 'bpmn:Transaction')) {\n    this.makeCompensable(transactionScope);\n  }\n\n  for (const startEvent of compensateStartEvents) {\n\n    const compensationEvent = {\n      element: startEvent,\n      type: 'compensate',\n      persistent: true,\n      interrupting: true,\n      ref: element,\n      traits: ScopeTraits.NOT_DEAD\n    };\n\n    const compensateEventSub = startEvent.parent;\n\n    const subscription = this._simulator.subscribe(scope, compensationEvent, initiator => {\n\n      subscription.remove();\n\n      return this._simulator.signal({\n        initiator,\n        element: compensateEventSub,\n        startEvent,\n        parentScope: scope\n      });\n    });\n  }\n\n  for (const boundaryEvent of compensateBoundaryEvents) {\n\n    const compensationEvent = {\n      element: boundaryEvent,\n      type: 'compensate',\n      persistent: true,\n      ref: element,\n      traits: ScopeTraits.NOT_DEAD\n    };\n\n    const compensateActivity = boundaryEvent.outgoing.map(\n      outgoing => outgoing.target\n    ).find(\n      isCompensationActivity\n    );\n\n    if (!compensateActivity) {\n      continue;\n    }\n\n    const subscription = this._simulator.subscribe(transactionScope, compensationEvent, initiator => {\n\n      subscription.remove();\n\n      // enter compensate activity like normal task\n      return this._simulator.enter({\n        initiator,\n        element: compensateActivity,\n        scope: transactionScope\n      });\n    });\n  }\n};\n\nTransactionBehavior.prototype.makeCompensable = function(scope) {\n\n  if (scope.hasTrait(ScopeTraits.COMPENSABLE) || !scope.parent) {\n    return;\n  }\n\n  const compensateEvent = {\n    type: 'compensate',\n    ref: scope.element,\n    interrupting: true,\n    persistent: true,\n    traits: ScopeTraits.NOT_DEAD\n  };\n\n  scope.compensable();\n\n  const scopeSub = this._simulator.subscribe(scope, compensateEvent, (initiator) => {\n\n    scopeSub.remove();\n\n    scope.fail(initiator);\n\n    this.compensate({\n      scope,\n      element: scope.element,\n      initiator\n    });\n\n    this._scopeBehavior.tryExit(scope, initiator);\n\n    return scope;\n  });\n\n  const parentScope = scope.parent;\n\n  if (!parentScope) {\n    return;\n  }\n\n  const parentSub = this._simulator.subscribe(parentScope, compensateEvent, initiator => {\n\n    parentSub.remove();\n\n    return this._simulator.trigger({\n      scope,\n      event: compensateEvent,\n      initiator\n    });\n\n  });\n\n  this.makeCompensable(parentScope);\n};\n\n\nTransactionBehavior.prototype.findTransactionScope = function(scope) {\n\n  let parentScope = scope;\n\n  while (parentScope) {\n    const element = parentScope.element;\n\n    if ((0,ModelUtil.is)(element, 'bpmn:SubProcess') && !isEventSubProcess(element)) {\n      return parentScope;\n    }\n\n    if (isAny(element, [\n      'bpmn:Transaction',\n      'bpmn:Process',\n      'bpmn:Participant'\n    ])) {\n      return parentScope;\n    }\n\n    parentScope = parentScope.parent;\n  }\n\n  throw noTransactionContext(scope);\n};\n\nTransactionBehavior.prototype.compensate = function(context) {\n\n  const {\n    scope,\n    element\n  } = context;\n\n  // compensate all\n  const compensateSubscriptions = filterSet(\n    scope.subscriptions,\n    subscription => eventsMatch({ type: 'compensate' }, subscription.event)\n  );\n\n  const localSubscriptions = compensateSubscriptions.filter(subscription => subscription.event.ref === element);\n\n  const otherSubscriptions = compensateSubscriptions.filter(subscription => subscription.event.ref !== element);\n\n  for (const subscription of localSubscriptions) {\n    this._scopeBehavior.preExit(scope, initiator => {\n      return this._simulator.trigger(subscription);\n    });\n  }\n\n  for (const subscription of otherSubscriptions.reverse()) {\n    this._scopeBehavior.preExit(scope, initiator => {\n      return this._simulator.trigger(subscription);\n    });\n  }\n};\n\n\n// helpers ///////////////\n\nfunction noTransactionContext(scope) {\n  throw new Error(`no transaction context for <${scope.id}>`);\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/SequenceFlowBehavior.js\nfunction SequenceFlowBehavior(\n    simulator,\n    scopeBehavior) {\n\n  this._simulator = simulator;\n  this._scopeBehavior = scopeBehavior;\n\n  simulator.registerBehavior('bpmn:SequenceFlow', this);\n}\n\nSequenceFlowBehavior.prototype.enter = function(context) {\n  this._simulator.exit(context);\n};\n\nSequenceFlowBehavior.prototype.exit = function(context) {\n  const {\n    element,\n    scope\n  } = context;\n\n  this._simulator.enter({\n    element: element.target,\n    scope: scope.parent\n  });\n};\n\nSequenceFlowBehavior.$inject = [\n  'simulator',\n  'scopeBehavior'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/MessageFlowBehavior.js\n\n\n\nfunction MessageFlowBehavior(simulator) {\n  this._simulator = simulator;\n\n  simulator.registerBehavior('bpmn:MessageFlow', this);\n}\n\nMessageFlowBehavior.$inject = [ 'simulator' ];\n\nMessageFlowBehavior.prototype.signal = function(context) {\n  this._simulator.exit(context);\n};\n\nMessageFlowBehavior.prototype.exit = function(context) {\n  const {\n    element,\n    scope: initiator\n  } = context;\n\n  const target = element.target;\n\n  // the event triggered is either the message event\n  // represented by the target message start or catch event _or_\n  // an event that uses { name: messageFlow.id } as an identifier\n  const event = isCatchEvent(target) ? target : {\n    type: 'message',\n    element,\n    name: element.id\n  };\n\n  const subscription = this._simulator.findSubscription({\n    event,\n    elements: [ target, target.parent ]\n  });\n\n  if (subscription) {\n    this._simulator.trigger({\n      event,\n      initiator,\n      scope: subscription.scope\n    });\n  }\n};\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/util/ElementHelper.js\n\n\n\n\nfunction is(element, types) {\n  if (element.type === 'label') {\n    return false;\n  }\n\n  if (!Array.isArray(types)) {\n    types = [ types ];\n  }\n\n  return types.some(function(type) {\n    return (0,ModelUtil.is)(element, type);\n  });\n}\n\nfunction getEventDefinition(event, eventDefinitionType) {\n  return (0,bpmn_js_token_simulation_node_modules_min_dash_dist_index_esm/* find */.sE)((0,ModelUtil/* getBusinessObject */.SS)(event).eventDefinitions, definition => {\n    return is(definition, eventDefinitionType);\n  });\n}\n\nfunction ElementHelper_isTypedEvent(event, eventDefinitionType) {\n  return (0,bpmn_js_token_simulation_node_modules_min_dash_dist_index_esm/* some */.G)((0,ModelUtil/* getBusinessObject */.SS)(event).eventDefinitions, definition => {\n    return is(definition, eventDefinitionType);\n  });\n}\n\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/EventBehaviors.js\n\n\n\n\n\n\n\nfunction EventBehaviors(\n    simulator,\n    elementRegistry,\n    scopeBehavior) {\n\n  this._simulator = simulator;\n  this._elementRegistry = elementRegistry;\n  this._scopeBehavior = scopeBehavior;\n}\n\nEventBehaviors.$inject = [\n  'simulator',\n  'elementRegistry',\n  'scopeBehavior'\n];\n\n\nEventBehaviors.prototype.get = function(element) {\n\n  const behaviors = {\n    'bpmn:LinkEventDefinition': (context) => {\n\n      const {\n        element,\n        scope\n      } = context;\n\n      const link = getLinkDefinition(element);\n\n      const parentScope = scope.parent;\n      const parentElement = parentScope.element;\n\n      const linkTargets = parentElement.children.filter(element =>\n        isLinkCatch(element) &&\n        getLinkDefinition(element).name === link.name\n      );\n\n      for (const linkTarget of linkTargets) {\n        this._simulator.signal({\n          element: linkTarget,\n          parentScope,\n          initiator: scope\n        });\n      }\n    },\n\n    'bpmn:SignalEventDefinition': (context) => {\n\n      // HINT: signals work only within the whole diagram,\n      //       triggers start events, boundary events and\n      //       intermediate catch events\n\n      const {\n        element,\n        scope\n      } = context;\n\n      const subscriptions = this._simulator.findSubscriptions({\n        event: element\n      });\n\n      const signaledScopes = new Set();\n\n      for (const subscription of subscriptions) {\n\n        const signaledScope = subscription.scope;\n\n        if (signaledScopes.has(signaledScope)) {\n          continue;\n        }\n\n        signaledScopes.add(signaledScope);\n\n        this._simulator.trigger({\n          event: element,\n          scope: signaledScope,\n          initiator: scope\n        });\n      }\n    },\n\n    'bpmn:EscalationEventDefinition': (context) => {\n\n      // HINT: escalations are propagated up the scope\n      //       chain and caught by the first matching boundary event\n      //       or event sub-process\n\n      const {\n        element,\n        scope\n      } = context;\n\n      const scopes = this._simulator.findScopes({\n        subscribedTo: {\n          event: element\n        },\n        trait: ScopeTraits.ACTIVE\n      });\n\n      let triggerScope = scope;\n\n      while ((triggerScope = triggerScope.parent)) {\n\n        if (scopes.includes(triggerScope)) {\n          this._simulator.trigger({\n            event: element,\n            scope: triggerScope,\n            initiator: scope\n          });\n\n          break;\n        }\n      }\n\n    },\n\n    'bpmn:ErrorEventDefinition': (context) => {\n\n      // HINT: errors are handled in current scope only (does not bubble)\n\n      const {\n        element,\n        scope\n      } = context;\n\n      // TODO(nikku): ensure error always interrupts, also if no error\n      //              catch is present\n      this._simulator.trigger({\n        event: element,\n        initiator: scope,\n        scope: findSubscriptionScope(scope)\n      });\n    },\n    'bpmn:TerminateEventDefinition': (context) => {\n      const {\n        scope\n      } = context;\n\n      this._scopeBehavior.terminate(scope.parent, scope);\n    },\n\n    'bpmn:CancelEventDefinition': (context) => {\n\n      // HINT: cancels the surrounding transaction scope (does not bubble)\n\n      const {\n        scope,\n        element\n      } = context;\n\n      this._simulator.trigger({\n        event: element,\n        initiator: scope,\n        scope: findSubscriptionScope(scope)\n      });\n    },\n\n    'bpmn:CompensateEventDefinition': (context) => {\n\n      const {\n        scope,\n        element\n      } = context;\n\n      return this._simulator.waitForScopes(\n        scope,\n        this._simulator.trigger({\n          event: element,\n          scope: findSubscriptionScope(scope)\n        })\n      );\n    }\n  };\n\n  const entry = Object.entries(behaviors).find(\n    entry => ElementHelper_isTypedEvent(element, entry[0])\n  );\n\n  return entry && entry[1];\n};\n\n\n// helpers ///////////////\n\nfunction getLinkDefinition(element) {\n  return getEventDefinition(element, 'bpmn:LinkEventDefinition');\n}\n\nfunction findSubscriptionScope(scope) {\n\n  // the scope is the first non event sub-process\n  while (isEventSubProcess(scope.parent.element)) {\n    scope = scope.parent;\n  }\n\n  return scope.parent;\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/ScopeBehavior.js\nconst PRE_EXIT_EVENT = {\n  type: 'pre-exit',\n  persistent: true,\n  interrupting: true,\n  boundary: false\n};\n\nconst EXIT_EVENT = {\n  type: 'exit',\n  interrupting: true,\n  boundary: false,\n  persistent: true\n};\n\n\nfunction ScopeBehavior(simulator) {\n  this._simulator = simulator;\n}\n\nScopeBehavior.$inject = [\n  'simulator'\n];\n\n/**\n * Is the given scope finished?\n *\n * @param {Scope}  scope\n * @param {Scope|Function} [excludeScope=null]\n *\n * @return {boolean}\n */\nScopeBehavior.prototype.isFinished = function(scope, excludeScope = null) {\n\n  excludeScope = matchScope(excludeScope);\n\n  return scope.children.every(c => c.destroyed || c.completed || excludeScope(c));\n};\n\n/**\n * Destroy all scope children.\n *\n * @param {Scope} scope\n * @param {Scope} initiator\n * @param {Scope|Function} [excludeScope=null]\n */\nScopeBehavior.prototype.destroyChildren = function(scope, initiator, excludeScope = null) {\n\n  excludeScope = matchScope(excludeScope);\n\n  scope.children.filter(c => !c.destroyed && !excludeScope(c)).map(c => {\n    this._simulator.destroyScope(c, initiator);\n  });\n};\n\nScopeBehavior.prototype.terminate = function(scope, initiator) {\n\n  // kill all child scopes\n  this.destroyChildren(scope, initiator);\n\n  // mark as terminated\n  scope.terminate(initiator);\n\n  // exit immediately\n  this.tryExit(scope, initiator);\n};\n\nScopeBehavior.prototype.interrupt = function(scope, initiator) {\n\n  // kill children but initiator\n  this.destroyChildren(scope, initiator, initiator);\n\n  // mark as failed\n  scope.fail(initiator);\n};\n\nScopeBehavior.prototype.tryExit = function(scope, initiator) {\n  if (!scope) {\n    throw new Error('missing <scope>');\n  }\n\n  if (!initiator) {\n    initiator = scope;\n  }\n\n  if (!this.isFinished(scope, initiator)) {\n    return EXIT_EVENT;\n  }\n\n  const preExitSubscriptions = this._simulator.findSubscriptions({\n    event: PRE_EXIT_EVENT,\n    scope\n  });\n\n  for (const subscription of preExitSubscriptions) {\n\n    const {\n      event,\n      scope\n    } = subscription;\n\n    const scopes = this._simulator.trigger({\n      event,\n      scope,\n      initiator\n    });\n\n    if (scopes.length) {\n      return EXIT_EVENT;\n    }\n  }\n\n  this._simulator.trigger({\n    event: EXIT_EVENT,\n    scope,\n    initiator\n  });\n\n  this.exit({\n    scope,\n    initiator\n  });\n};\n\nScopeBehavior.prototype.exit = function(context) {\n\n  const {\n    scope,\n    initiator\n  } = context;\n\n  if (!initiator) {\n    throw new Error('missing <initiator>');\n  }\n\n  this._simulator.exit({\n    element: scope.element,\n    scope: scope,\n    initiator\n  });\n};\n\nScopeBehavior.prototype.preExit = function(scope, triggerFn) {\n  const subscription = this._simulator.subscribe(scope, PRE_EXIT_EVENT, (initiator) => {\n\n    subscription.remove();\n\n    return triggerFn(initiator);\n  });\n\n  return subscription;\n};\n\n\n// helpers ////////////////\n\n/**\n * Create a scope matcher.\n *\n * @param {Scope|Function} fnOrScope\n *\n * @return { (Scope) => boolean }\n */\nfunction matchScope(fnOrScope) {\n\n  if (typeof fnOrScope === 'function') {\n    return fnOrScope;\n  }\n\n  return (scope) => scope === fnOrScope;\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/ProcessBehavior.js\nfunction ProcessBehavior(\n    simulator,\n    scopeBehavior) {\n\n  this._simulator = simulator;\n  this._scopeBehavior = scopeBehavior;\n\n  simulator.registerBehavior('bpmn:Process', this);\n  simulator.registerBehavior('bpmn:Participant', this);\n}\n\nProcessBehavior.prototype.signal = function(context) {\n\n  const {\n    startEvent,\n    scope\n  } = context;\n\n  if (!startEvent) {\n    throw new Error('missing <startEvent>');\n  }\n\n  this._simulator.signal({\n    element: startEvent,\n    parentScope: scope\n  });\n};\n\nProcessBehavior.prototype.exit = function(context) {\n\n  const {\n    scope,\n    initiator\n  } = context;\n\n  // ensure that all sub-scopes are destroyed\n\n  this._scopeBehavior.destroyChildren(scope, initiator);\n};\n\n\nProcessBehavior.$inject = [\n  'simulator',\n  'scopeBehavior'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/behaviors/index.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/* harmony default export */ const behaviors = ({\n  __init__: [\n    'startEventBehavior',\n    'endEventBehavior',\n    'boundaryEventBehavior',\n    'intermediateCatchEventBehavior',\n    'intermediateThrowEventBehavior',\n    'exclusiveGatewayBehavior',\n    'parallelGatewayBehavior',\n    'eventBasedGatewayBehavior',\n    'subProcessBehavior',\n    'sequenceFlowBehavior',\n    'messageFlowBehavior',\n    'processBehavior'\n  ],\n  startEventBehavior: [ 'type', StartEventBehavior ],\n  endEventBehavior: [ 'type', EndEventBehavior ],\n  boundaryEventBehavior: [ 'type', BoundaryEventBehavior ],\n  intermediateCatchEventBehavior: [ 'type', IntermediateCatchEventBehavior ],\n  intermediateThrowEventBehavior: [ 'type', IntermediateThrowEventBehavior ],\n  exclusiveGatewayBehavior: [ 'type', ExclusiveGatewayBehavior ],\n  parallelGatewayBehavior: [ 'type', ParallelGatewayBehavior ],\n  eventBasedGatewayBehavior: [ 'type', EventBasedGatewayBehavior ],\n  activityBehavior: [ 'type', ActivityBehavior ],\n  subProcessBehavior: [ 'type', SubProcessBehavior ],\n  sequenceFlowBehavior: [ 'type', SequenceFlowBehavior ],\n  messageFlowBehavior: [ 'type', MessageFlowBehavior ],\n  eventBehaviors: [ 'type', EventBehaviors ],\n  scopeBehavior: [ 'type', ScopeBehavior ],\n  processBehavior: [ 'type', ProcessBehavior ],\n  transactionBehavior: [ 'type', TransactionBehavior ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/simulator/index.js\n\n\n\nconst HIGH_PRIORITY = 5000;\n\n/* harmony default export */ const simulator = ({\n  __depends__: [\n    behaviors\n  ],\n  __init__: [\n    [ 'eventBus', 'simulator', function(eventBus, simulator) {\n      eventBus.on([\n        'tokenSimulation.toggleMode',\n        'tokenSimulation.resetSimulation'\n      ], HIGH_PRIORITY, event => {\n        simulator.reset();\n      });\n    } ]\n  ],\n  simulator: [ 'type', Simulator ]\n});\n// EXTERNAL MODULE: ./node_modules/inherits-browser/dist/index.es.js\nvar index_es = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/animation/behaviors/AnimatedMessageFlowBehavior.js\n\n\n\n\n\nfunction AnimatedMessageFlowBehavior(injector, animation) {\n  injector.invoke(MessageFlowBehavior, this);\n\n  this._animation = animation;\n}\n\n(0,index_es/* default */.Z)(AnimatedMessageFlowBehavior, MessageFlowBehavior);\n\nAnimatedMessageFlowBehavior.$inject = [\n  'injector',\n  'animation'\n];\n\nAnimatedMessageFlowBehavior.prototype.signal = function(context) {\n\n  const {\n    element,\n    scope\n  } = context;\n\n  this._animation.animate(element, scope, () => {\n    MessageFlowBehavior.prototype.signal.call(this, context);\n  });\n};\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/animation/behaviors/AnimatedSequenceFlowBehavior.js\n\n\n\n\n\nfunction AnimatedSequenceFlowBehavior(injector, animation) {\n  injector.invoke(SequenceFlowBehavior, this);\n\n  this._animation = animation;\n}\n\n(0,index_es/* default */.Z)(AnimatedSequenceFlowBehavior, SequenceFlowBehavior);\n\nAnimatedSequenceFlowBehavior.$inject = [\n  'injector',\n  'animation'\n];\n\nAnimatedSequenceFlowBehavior.prototype.enter = function(context) {\n\n  const {\n    element,\n    scope\n  } = context;\n\n  this._animation.animate(element, scope, () => {\n    SequenceFlowBehavior.prototype.enter.call(this, context);\n  });\n};\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/animation/behaviors/index.js\n\n\n\n/* harmony default export */ const animation_behaviors = ({\n  sequenceFlowBehavior: [ 'type', AnimatedSequenceFlowBehavior ],\n  messageFlowBehavior: [ 'type', AnimatedMessageFlowBehavior ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/scope-filter/ScopeFilter.js\n\n\nconst DEFAULT_SCOPE_FILTER = (s) => true;\n\n\nfunction ScopeFilter(eventBus, simulator) {\n  this._eventBus = eventBus;\n  this._simulator = simulator;\n\n  this._filter = DEFAULT_SCOPE_FILTER;\n\n  eventBus.on([\n    TOGGLE_MODE_EVENT,\n    RESET_SIMULATION_EVENT\n  ], () => {\n    this._filter = DEFAULT_SCOPE_FILTER;\n  });\n\n  eventBus.on(SCOPE_DESTROYED_EVENT, event => {\n\n    const {\n      scope\n    } = event;\n\n    // if we're currently filtering, ensure newly\n    // created instance is shown\n\n    if (this._scope === scope && scope.parent) {\n      this.toggle(scope.parent);\n    }\n  });\n\n\n  eventBus.on(SCOPE_CREATE_EVENT, event => {\n\n    const {\n      scope\n    } = event;\n\n    // if we're currently filtering, ensure newly\n    // created instance is shown\n\n    if (!scope.parent && this._scope && !isAncestor(this._scope, scope)) {\n      this.toggle(null);\n    }\n  });\n}\n\nScopeFilter.prototype.toggle = function(scope) {\n\n  const setFilter = this._scope !== scope;\n\n  this._scope = setFilter ? scope : null;\n\n  this._filter =\n    this._scope\n      ? s => isAncestor(this._scope, s)\n      : s => true;\n\n  this._eventBus.fire(SCOPE_FILTER_CHANGED_EVENT, {\n    filter: this._filter,\n    scope: this._scope\n  });\n};\n\nScopeFilter.prototype.isShown = function(scope) {\n\n  if (typeof scope === 'string') {\n    scope = this._simulator.findScope(s => s.id === scope);\n  }\n\n  return scope && this._filter(scope);\n};\n\nScopeFilter.prototype.findScope = function(options) {\n  return this._simulator.findScopes(options).filter(s => this.isShown(s))[0];\n};\n\nScopeFilter.$inject = [\n  'eventBus',\n  'simulator'\n];\n\nfunction isAncestor(parent, scope) {\n  do {\n    if (parent === scope) {\n      return true;\n    }\n  } while ((scope = scope.parent));\n\n  return false;\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/scope-filter/index.js\n\n\n/* harmony default export */ const scope_filter = ({\n  scopeFilter: [ 'type', ScopeFilter ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/animation/Animation.js\n\n\n\n\n\n\nconst STYLE = getComputedStyle(document.documentElement);\n\nconst DEFAULT_PRIMARY_COLOR = STYLE.getPropertyValue('--token-simulation-green-base-44');\nconst DEFAULT_AUXILIARY_COLOR = STYLE.getPropertyValue('--token-simulation-white');\n\nfunction noop() {}\n\nfunction getSegmentEasing(index, waypoints) {\n\n  // only a single segment\n  if (waypoints.length === 2) {\n    return EASE_IN_OUT;\n  }\n\n  // first segment\n  if (index === 1) {\n    return EASE_IN;\n  }\n\n  // last segment\n  if (index === waypoints.length - 1) {\n    return EASE_OUT;\n  }\n\n  return EASE_LINEAR;\n}\n\nconst EASE_LINEAR = function(pos) {\n  return pos;\n};\nconst EASE_IN = function(pos) {\n  return -Math.cos(pos * Math.PI / 2) + 1;\n};\nconst EASE_OUT = function(pos) {\n  return Math.sin(pos * Math.PI / 2);\n};\nconst EASE_IN_OUT = function(pos) {\n  return -Math.cos(pos * Math.PI) / 2 + 0.5;\n};\n\nconst TOKEN_SIZE = 20;\n\n\nfunction Animation(canvas, eventBus, scopeFilter) {\n  this._eventBus = eventBus;\n  this._scopeFilter = scopeFilter;\n  this._canvas = canvas;\n\n  this._animations = new Set();\n  this._speed = 1;\n\n  eventBus.on(RESET_SIMULATION_EVENT, () => {\n    this.clearAnimations();\n  });\n\n  eventBus.on(PAUSE_SIMULATION_EVENT, () => {\n    this.pause();\n  });\n\n  eventBus.on(PLAY_SIMULATION_EVENT, () => {\n    this.play();\n  });\n\n  eventBus.on(SCOPE_FILTER_CHANGED_EVENT, event => {\n\n    this.each(animation => {\n      if (this._scopeFilter.isShown(animation.scope)) {\n        animation.show();\n      } else {\n        animation.hide();\n      }\n    });\n  });\n\n  eventBus.on(SCOPE_DESTROYED_EVENT, event => {\n    const {\n      scope\n    } = event;\n\n    this.clearAnimations(scope);\n  });\n}\n\nAnimation.prototype.animate = function(connection, scope, done) {\n  this.createAnimation(connection, scope, done);\n};\n\nAnimation.prototype.pause = function() {\n  this.each(animation => animation.pause());\n};\n\nAnimation.prototype.play = function() {\n  this.each(animation => animation.play());\n};\n\nAnimation.prototype.each = function(fn) {\n  this._animations.forEach(fn);\n};\n\nAnimation.prototype.createAnimation = function(connection, scope, done = noop) {\n  const group = this._getGroup(scope);\n\n  if (!group) {\n    return;\n  }\n\n  const tokenGfx = this._createTokenGfx(group, scope);\n\n  const animation = new TokenAnimation(tokenGfx, connection.waypoints, () => {\n    this._animations.delete(animation);\n\n    done();\n  });\n\n  animation.setSpeed(this.getAnimationSpeed());\n\n  if (!this._scopeFilter.isShown(scope)) {\n    animation.hide();\n  }\n\n  animation.scope = scope;\n  animation.element = connection;\n\n  this._animations.add(animation);\n\n  this._eventBus.fire(ANIMATION_CREATED_EVENT, {\n    animation\n  });\n\n  animation.play();\n\n  return animation;\n};\n\nAnimation.prototype.setAnimationSpeed = function(speed) {\n  this._speed = speed;\n\n  this.each(animation => animation.setSpeed(speed));\n\n  this._eventBus.fire(ANIMATION_SPEED_CHANGED_EVENT, {\n    speed\n  });\n};\n\nAnimation.prototype.getAnimationSpeed = function() {\n  return this._speed;\n};\n\nAnimation.prototype.clearAnimations = function(scope) {\n  this.each(animation => {\n    if (!scope || animation.scope === scope) {\n      animation.remove();\n    }\n  });\n};\n\nAnimation.prototype._createTokenGfx = function(group, scope) {\n  const parent = (0,dist_index_esm/* create */.Ue)(this._getTokenSVG(scope).trim());\n\n  return (0,dist_index_esm/* appendTo */.s7)(parent, group);\n};\n\nAnimation.prototype._getTokenSVG = function(scope) {\n\n  const colors = scope.colors || {\n    primary: DEFAULT_PRIMARY_COLOR,\n    auxiliary: DEFAULT_AUXILIARY_COLOR\n  };\n\n  return `\n    <g class=\"bts-token\">\n      <circle\n        class=\"bts-circle\"\n        r=\"${TOKEN_SIZE / 2}\"\n        cx=\"${TOKEN_SIZE / 2}\"\n        cy=\"${TOKEN_SIZE / 2}\"\n        fill=\"${ colors.primary }\"\n      />\n      <text\n        class=\"bts-text\"\n        transform=\"translate(10, 14)\"\n        text-anchor=\"middle\"\n        fill=\"${ colors.auxiliary }\"\n      >1</text>\n    </g>\n  `;\n};\n\nAnimation.prototype._getGroup = function(scope) {\n\n  var canvas = this._canvas;\n\n  var layer, root;\n\n  // bpmn-js@9 compatibility:\n  // show animation tokens on plane layers\n  if ('findRoot' in canvas) {\n    root = canvas.findRoot(scope.element);\n    layer = canvas._findPlaneForRoot(root).layer;\n  } else {\n    layer = (0,node_modules_min_dom_dist_index_esm/* query */.IO)('.viewport', canvas._svg);\n  }\n\n  var group = (0,node_modules_min_dom_dist_index_esm/* query */.IO)('.bts-animation-tokens', layer);\n\n  if (!group) {\n    group = (0,dist_index_esm/* create */.Ue)('<g class=\"bts-animation-tokens\" />');\n\n    (0,dist_index_esm/* appendTo */.s7)(\n      group,\n      layer\n    );\n  }\n\n  return group;\n};\n\nAnimation.$inject = [\n  'canvas',\n  'eventBus',\n  'scopeFilter'\n];\n\n\nfunction TokenAnimation(gfx, waypoints, done) {\n  this.gfx = gfx;\n  this.waypoints = waypoints;\n  this.done = done;\n\n  this._paused = true;\n  this._t = 0;\n  this._parts = [];\n\n  this.create();\n}\n\nTokenAnimation.prototype.pause = function() {\n  this._paused = true;\n};\n\nTokenAnimation.prototype.play = function() {\n\n  if (this._paused) {\n    this._paused = false;\n\n    this.tick(0);\n  }\n\n  this.schedule();\n};\n\nTokenAnimation.prototype.schedule = function() {\n\n  if (this._paused) {\n    return;\n  }\n\n  if (this._scheduled) {\n    return;\n  }\n\n  const last = Date.now();\n\n  this._scheduled = true;\n\n  requestAnimationFrame(() => {\n    this._scheduled = false;\n\n    if (this._paused) {\n      return;\n    }\n\n    this.tick((Date.now() - last) * this._speed);\n    this.schedule();\n  });\n};\n\n\nTokenAnimation.prototype.tick = function(tElapsed) {\n\n  const t = this._t = this._t + tElapsed;\n\n  const part = this._parts.find(\n    p => p.startTime <= t && p.endTime > t\n  );\n\n  // completed\n  if (!part) {\n    return this.remove();\n  }\n\n  const segmentTime = t - part.startTime;\n  const segmentLength = part.length * part.easing(segmentTime / part.duration);\n\n  const currentLength = part.startLength + segmentLength;\n\n  const point = this._path.getPointAtLength(currentLength);\n\n  this.move(point.x, point.y);\n};\n\nTokenAnimation.prototype.move = function(x, y) {\n  (0,dist_index_esm/* attr */.Lj)(this.gfx, 'transform', `translate(${x}, ${y})`);\n};\n\nTokenAnimation.prototype.create = function() {\n  const waypoints = this.waypoints;\n\n  const parts = waypoints.reduce((parts, point, index) => {\n\n    const lastPoint = waypoints[index - 1];\n\n    if (lastPoint) {\n      const lastPart = parts[parts.length - 1];\n\n      const startLength = lastPart && lastPart.endLength || 0;\n      const length = distance(lastPoint, point);\n\n      parts.push({\n        startLength,\n        endLength: startLength + length,\n        length,\n        easing: getSegmentEasing(index, waypoints)\n      });\n    }\n\n    return parts;\n  }, []);\n\n  const totalLength = parts.reduce(function(length, part) {\n    return length + part.length;\n  }, 0);\n\n  const d = waypoints.reduce((d, waypoint, index) => {\n\n    const x = waypoint.x - TOKEN_SIZE / 2,\n          y = waypoint.y - TOKEN_SIZE / 2;\n\n    d.push([ index > 0 ? 'L' : 'M', x, y ]);\n\n    return d;\n  }, []).flat().join(' ');\n\n  const totalDuration = getAnimationDuration(totalLength);\n\n  this._parts = parts.reduce((parts, part, index) => {\n    const duration = totalDuration / totalLength * part.length;\n    const startTime = index > 0 ? parts[index - 1].endTime : 0;\n    const endTime = startTime + duration;\n\n    return [\n      ...parts,\n      {\n        ...part,\n        startTime,\n        endTime,\n        duration\n      }\n    ];\n  }, []);\n\n  this._path = (0,dist_index_esm/* create */.Ue)(`<path d=\"${d}\" />`);\n  this._t = 0;\n};\n\nTokenAnimation.prototype.show = function() {\n  (0,dist_index_esm/* attr */.Lj)(this.gfx, 'display', '');\n};\n\nTokenAnimation.prototype.hide = function() {\n  (0,dist_index_esm/* attr */.Lj)(this.gfx, 'display', 'none');\n};\n\nTokenAnimation.prototype.remove = function() {\n  this.pause();\n\n  (0,dist_index_esm/* remove */.Od)(this.gfx);\n\n  this.done();\n};\n\nTokenAnimation.prototype.setSpeed = function(speed) {\n  this._speed = speed;\n};\n\nfunction getAnimationDuration(length) {\n  return Math.log(length) * randomBetween(250, 300);\n}\n\nfunction randomBetween(min, max) {\n  return min + Math.floor(Math.random() * (max - min));\n}\n\nfunction distance(a, b) {\n  return Math.sqrt(Math.pow(a.x - b.x, 2) + Math.pow(a.y - b.y, 2));\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/animation/index.js\n\n\n\n\n\n\n/* harmony default export */ const animation = ({\n  __depends__: [\n    simulator,\n    animation_behaviors,\n    scope_filter\n  ],\n  animation: [ 'type', Animation ]\n});\n// EXTERNAL MODULE: ./node_modules/randomcolor/randomColor.js\nvar randomColor = __webpack_require__(\"./node_modules/randomcolor/randomColor.js\");\nvar randomColor_default = /*#__PURE__*/__webpack_require__.n(randomColor);\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/colored-scopes/ColoredScopes.js\n\n\n\n\nconst ColoredScopes_HIGH_PRIORITY = 1500;\n\n\nfunction ColoredScopes(eventBus) {\n\n  const colors = randomColor_default()({\n    count: 60\n  }).filter(c => getContrastYIQ(c.substring(1)) < 200);\n\n  function getContrastYIQ(hexcolor) {\n    var r = parseInt(hexcolor.substr(0,2),16);\n    var g = parseInt(hexcolor.substr(2,2),16);\n    var b = parseInt(hexcolor.substr(4,2),16);\n    var yiq = ((r * 299) + (g * 587) + (b * 114)) / 1000;\n    return yiq;\n  }\n\n  let colorsIdx = 0;\n\n  function getColors(scope) {\n    const {\n      element\n    } = scope;\n\n    if (element && element.type === 'bpmn:MessageFlow') {\n      return {\n        primary: '#999',\n        auxiliary: '#FFF'\n      };\n    }\n\n    if (scope.parent) {\n      return scope.parent.colors;\n    }\n\n    const primary = colors[ (colorsIdx++) % colors.length ];\n\n    return {\n      primary,\n      auxiliary: getContrastYIQ(primary) >= 128 ? '#111' : '#fff'\n    };\n  }\n\n  eventBus.on(SCOPE_CREATE_EVENT, ColoredScopes_HIGH_PRIORITY, event => {\n\n    const {\n      scope\n    } = event;\n\n    scope.colors = getColors(scope);\n  });\n}\n\nColoredScopes.$inject = [\n  'eventBus'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/colored-scopes/index.js\n\n\n/* harmony default export */ const colored_scopes = ({\n  __init__: [\n    'coloredScopes'\n  ],\n  coloredScopes: [ 'type', ColoredScopes ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/context-pads/handler/ExclusiveGatewayHandler.js\n\r\n\r\n\r\n\r\n\r\nfunction ExclusiveGatewayHandler(exclusiveGatewaySettings) {\r\n  this._exclusiveGatewaySettings = exclusiveGatewaySettings;\r\n}\r\n\r\nExclusiveGatewayHandler.prototype.createContextPads = function(element) {\r\n\r\n  const outgoingFlows = element.outgoing.filter(function(outgoing) {\r\n    return is(outgoing, 'bpmn:SequenceFlow');\r\n  });\r\n\r\n  if (outgoingFlows.length < 2) {\r\n    return;\r\n  }\r\n\r\n  const html = `\r\n    <div class=\"bts-context-pad\" title=\"Set Sequence Flow\">\r\n      ${ForkIcon()}\r\n    </div>\r\n  `;\r\n\r\n  const action = () => {\r\n    this._exclusiveGatewaySettings.setSequenceFlow(element);\r\n  };\r\n\r\n  return [\r\n    {\r\n      action,\r\n      element,\r\n      html\r\n    }\r\n  ];\r\n};\r\n\r\nExclusiveGatewayHandler.$inject = [\r\n  'exclusiveGatewaySettings'\r\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/context-pads/handler/PauseHandler.js\n\n\n\n\n\n\nfunction PauseHandler(simulator) {\n  this._simulator = simulator;\n}\n\nPauseHandler.prototype.createContextPads = function(element) {\n\n  if (\n    is(element, 'bpmn:ReceiveTask') || (\n      is(element, 'bpmn:SubProcess') && (0,ModelUtil/* getBusinessObject */.SS)(element).triggeredByEvent\n    )\n  ) {\n    return [];\n  }\n\n  return [\n    this.createPauseContextPad(element)\n  ];\n};\n\nPauseHandler.prototype.createPauseContextPad = function(element) {\n\n  const contexts = () => this._findSubscriptions({\n    element\n  });\n\n  const wait = this._isPaused(element);\n\n  const html = `\n    <div class=\"bts-context-pad ${ wait ? '' : 'show-hover' }\" title=\"${ wait ? 'Remove' : 'Add' } pause point\">\n      ${ (wait ? RemovePauseIcon : PauseIcon)('show-hover') }\n      ${ PauseIcon('hide-hover') }\n    </div>\n  `;\n\n  const action = () => {\n    this._togglePaused(element);\n  };\n\n  return {\n    action,\n    element,\n    hideContexts: contexts,\n    html\n  };\n};\n\nPauseHandler.prototype._isPaused = function(element) {\n\n  const {\n    wait\n  } = this._simulator.getConfig(element);\n\n  return wait;\n};\n\nPauseHandler.prototype._togglePaused = function(element) {\n  const wait = !this._isPaused(element);\n\n  this._simulator.waitAtElement(element, wait);\n};\n\nPauseHandler.prototype._findSubscriptions = function(options) {\n  return this._simulator.findSubscriptions(options);\n};\n\nPauseHandler.$inject = [\n  'simulator'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/context-pads/handler/TriggerHandler.js\n\n\n\nfunction TriggerHandler(simulator) {\n  this._simulator = simulator;\n}\n\nTriggerHandler.$inject = [\n  'simulator'\n];\n\nTriggerHandler.prototype.createContextPads = function(element) {\n  return [\n    this.createTriggerContextPad(element)\n  ];\n};\n\nTriggerHandler.prototype.createTriggerContextPad = function(element) {\n\n  const contexts = () => {\n    return this._findSubscriptions({\n      element\n    });\n  };\n\n  const html = `\n    <div class=\"bts-context-pad\" title=\"Trigger Event\">\n      ${PlayIcon()}\n    </div>\n  `;\n\n  const action = (subscriptions) => {\n\n    const {\n      event,\n      scope\n    } = subscriptions[0];\n\n    return this._simulator.trigger({\n      event,\n      scope\n    });\n  };\n\n  return {\n    action,\n    element,\n    html,\n    contexts\n  };\n};\n\nTriggerHandler.prototype._findSubscriptions = function(options) {\n  return this._simulator.findSubscriptions(options);\n};\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/context-pads/ContextPads.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nconst ContextPads_LOW_PRIORITY = 500;\r\n\r\nconst ContextPads_OFFSET_TOP = -15;\r\nconst OFFSET_LEFT = -15;\r\n\r\n\r\nfunction ContextPads(\r\n    eventBus, elementRegistry,\r\n    overlays, injector,\r\n    canvas, scopeFilter) {\r\n\r\n  this._elementRegistry = elementRegistry;\r\n  this._overlays = overlays;\r\n  this._injector = injector;\r\n  this._canvas = canvas;\r\n  this._scopeFilter = scopeFilter;\r\n\r\n  this._overlayCache = new Map();\r\n\r\n  this._handlerIdx = 0;\r\n\r\n  this._handlers = [];\r\n\r\n  this.registerHandler('bpmn:ExclusiveGateway', ExclusiveGatewayHandler);\r\n\r\n  this.registerHandler('bpmn:Activity', PauseHandler);\r\n\r\n  this.registerHandler('bpmn:StartEvent', TriggerHandler);\r\n  this.registerHandler('bpmn:IntermediateCatchEvent', TriggerHandler);\r\n  this.registerHandler('bpmn:BoundaryEvent', TriggerHandler);\r\n  this.registerHandler('bpmn:Activity', TriggerHandler);\r\n\r\n  eventBus.on(TOGGLE_MODE_EVENT, ContextPads_LOW_PRIORITY, context => {\r\n    const active = context.active;\r\n\r\n    if (active) {\r\n      this.openContextPads();\r\n    } else {\r\n      this.closeContextPads();\r\n    }\r\n  });\r\n\r\n  eventBus.on(RESET_SIMULATION_EVENT, ContextPads_LOW_PRIORITY, () => {\r\n    this.closeContextPads();\r\n    this.openContextPads();\r\n  });\r\n\r\n  eventBus.on(SCOPE_FILTER_CHANGED_EVENT, event => {\r\n\r\n    const showElements = (0,node_modules_min_dom_dist_index_esm/* queryAll */.Kt)(\r\n      '.djs-overlay-ts-context-menu [data-scope-ids]',\r\n      overlays._overlayRoot\r\n    );\r\n\r\n    for (const element of showElements) {\r\n\r\n      const scopeIds = element.dataset.scopeIds.split(',');\r\n\r\n      const shown = scopeIds.some(id => scopeFilter.isShown(id));\r\n\r\n      (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(element).toggle('hidden', !shown);\r\n    }\r\n\r\n    const hideElements = (0,node_modules_min_dom_dist_index_esm/* queryAll */.Kt)(\r\n      '.djs-overlay-ts-context-menu [data-hide-scope-ids]',\r\n      overlays._overlayRoot\r\n    );\r\n\r\n    for (const element of hideElements) {\r\n\r\n      const scopeIds = element.dataset.hideScopeIds.split(',');\r\n\r\n      const shown = scopeIds.some(id => scopeFilter.isShown(id));\r\n\r\n      (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(element).toggle('hidden', shown);\r\n    }\r\n  });\r\n\r\n  eventBus.on(ELEMENT_CHANGED_EVENT, ContextPads_LOW_PRIORITY, event => {\r\n    const {\r\n      element\r\n    } = event;\r\n\r\n    this.updateElementContextPads(element);\r\n  });\r\n}\r\n\r\n/**\r\n * Register a handler for an element type.\r\n * An element type can have multiple handlers.\r\n *\r\n * @param {String} type\r\n * @param {Object} handlerCls\r\n */\r\nContextPads.prototype.registerHandler = function(type, handlerCls) {\r\n  const handler = this._injector.instantiate(handlerCls);\r\n\r\n  handler.hash = String(this._handlerIdx++);\r\n\r\n  this._handlers.push({ handler, type });\r\n};\r\n\r\nContextPads.prototype.getHandlers = function(element) {\r\n\r\n  return (\r\n    this._handlers.filter(\r\n      ({ type }) => is(element, type)\r\n    ).map(\r\n      ({ handler }) => handler\r\n    )\r\n  );\r\n};\r\n\r\nContextPads.prototype.openContextPads = function(parent) {\r\n\r\n  if (!parent) {\r\n    parent = this._canvas.getRootElement();\r\n  }\r\n\r\n  this._elementRegistry.forEach((element) => {\r\n    if (ContextPads_isAncestor(parent, element)) {\r\n      this.updateElementContextPads(element);\r\n    }\r\n  });\r\n};\r\n\r\nContextPads.prototype._getOverlays = function(hash) {\r\n  return this._overlayCache.get(hash) || [];\r\n};\r\n\r\nContextPads.prototype._addOverlay = function(element, options) {\r\n\r\n  const {\r\n    handlerHash\r\n  } = options;\r\n\r\n  if (!handlerHash) {\r\n    throw new Error('<handlerHash> required');\r\n  }\r\n\r\n  const overlayId = this._overlays.add(element, 'ts-context-menu', {\r\n    ...options,\r\n    position: {\r\n      top: ContextPads_OFFSET_TOP,\r\n      left: OFFSET_LEFT\r\n    },\r\n    show: {\r\n      minZoom: 0.5\r\n    }\r\n  });\r\n\r\n  const overlay = this._overlays.get(overlayId);\r\n\r\n  const overlayCache = this._overlayCache;\r\n\r\n  if (!overlayCache.has(handlerHash)) {\r\n    overlayCache.set(handlerHash, []);\r\n  }\r\n\r\n  overlayCache.get(handlerHash).push(overlay);\r\n};\r\n\r\nContextPads.prototype._removeOverlay = function(overlay) {\r\n\r\n  const {\r\n    id,\r\n    handlerHash\r\n  } = overlay;\r\n\r\n  // remove overlay\r\n  this._overlays.remove(id);\r\n\r\n  // remove from overlay cache\r\n  const overlays = this._overlayCache.get(handlerHash) || [];\r\n\r\n  const idx = overlays.indexOf(overlay);\r\n\r\n  if (idx !== -1) {\r\n    overlays.splice(idx, 1);\r\n  }\r\n};\r\n\r\nContextPads.prototype.updateElementContextPads = function(element) {\r\n  for (const handler of this.getHandlers(element)) {\r\n    this._updateElementContextPads(element, handler);\r\n  }\r\n};\r\n\r\nContextPads.prototype._updateElementContextPads = function(element, handler) {\r\n\r\n  const contextPads = (handler.createContextPads(element) || []).filter(p => p);\r\n\r\n  const handlerHash = `${element.id}------${handler.hash}`;\r\n\r\n  const existingOverlays = this._getOverlays(handlerHash);\r\n\r\n  const updatedOverlays = [];\r\n\r\n  for (const contextPad of contextPads) {\r\n\r\n    const {\r\n      element,\r\n      contexts: _contexts,\r\n      hideContexts: _hideContexts,\r\n      action: _action,\r\n      html: _html\r\n    } = contextPad;\r\n\r\n\r\n    const hash = `${contextPad.element.id}-------${_html}`;\r\n\r\n    let existingOverlay = existingOverlays.find(\r\n      o => o.hash === hash\r\n    );\r\n\r\n    const html = existingOverlay && existingOverlay.html || (0,node_modules_min_dom_dist_index_esm/* domify */.H6)(_html);\r\n\r\n    if (_contexts) {\r\n      const contexts = _contexts();\r\n\r\n      html.dataset.scopeIds = contexts.map(c => c.scope.id).join(',');\r\n\r\n      const shownScopes = contexts.filter(c => this._scopeFilter.isShown(c.scope));\r\n\r\n      (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(html).toggle('hidden', shownScopes.length === 0);\r\n    }\r\n\r\n    if (_hideContexts) {\r\n      const contexts = _hideContexts();\r\n\r\n      html.dataset.hideScopeIds = contexts.map(c => c.scope.id).join(',');\r\n\r\n      const shownScopes = contexts.filter(c => this._scopeFilter.isShown(c.scope));\r\n\r\n      (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(html).toggle('hidden', shownScopes.length > 0);\r\n    }\r\n\r\n    if (existingOverlay) {\r\n      updatedOverlays.push(existingOverlay);\r\n\r\n      continue;\r\n    }\r\n\r\n    if (_action) {\r\n\r\n      node_modules_min_dom_dist_index_esm/* event.bind */.B.bind(html, 'click', event => {\r\n        event.preventDefault();\r\n\r\n        const contexts = _contexts\r\n          ? _contexts().filter(c => this._scopeFilter.isShown(c.scope))\r\n          : null;\r\n\r\n        _action(contexts);\r\n      });\r\n    }\r\n\r\n    this._addOverlay(element, {\r\n      hash,\r\n      handlerHash,\r\n      html\r\n    });\r\n  }\r\n\r\n  for (const existingOverlay of existingOverlays) {\r\n    if (!updatedOverlays.includes(existingOverlay)) {\r\n      this._removeOverlay(existingOverlay);\r\n    }\r\n  }\r\n};\r\n\r\nContextPads.prototype.closeContextPads = function() {\r\n  for (const overlays of this._overlayCache.values()) {\r\n\r\n    for (const overlay of overlays) {\r\n      this._closeOverlay(overlay);\r\n    }\r\n  }\r\n\r\n  this._overlayCache.clear();\r\n};\r\n\r\nContextPads.prototype._closeOverlay = function(overlay) {\r\n  this._overlays.remove(overlay.id);\r\n};\r\n\r\nContextPads.$inject = [\r\n  'eventBus',\r\n  'elementRegistry',\r\n  'overlays',\r\n  'injector',\r\n  'canvas',\r\n  'scopeFilter'\r\n];\r\n\r\n\r\n// helpers ///////////////\r\n\r\nfunction ContextPads_isAncestor(ancestor, descendant) {\r\n\r\n  do {\r\n    if (ancestor === descendant) {\r\n      return true;\r\n    }\r\n\r\n    descendant = descendant.parent;\r\n  } while (descendant);\r\n\r\n  return false;\r\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/context-pads/index.js\n\n\n\n\n/* harmony default export */ const context_pads = ({\n  __depends__: [\n    scope_filter\n  ],\n  __init__: [\n    'contextPads'\n  ],\n  contextPads: [ 'type', ContextPads ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/simulation-state/SimulationState.js\n\n\n\n\n\nfunction SimulationState(\n    eventBus,\n    simulator,\n    elementNotifications) {\n\n  eventBus.on(SCOPE_DESTROYED_EVENT, event => {\n    const {\n      scope\n    } = event;\n\n    const {\n      destroyInitiator,\n      element: scopeElement\n    } = scope;\n\n    if (!scope.completed || !destroyInitiator) {\n      return;\n    }\n\n    const processScopes = [\n      'bpmn:Process',\n      'bpmn:Participant'\n    ];\n\n    if (!processScopes.includes(scopeElement.type)) {\n      return;\n    }\n\n    elementNotifications.addElementNotification(destroyInitiator.element, {\n      type: 'success',\n      icon: CheckCircleIcon(),\n      text: 'Finished',\n      scope\n    });\n  });\n}\n\nSimulationState.$inject = [\n  'eventBus',\n  'simulator',\n  'elementNotifications'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/element-notifications/ElementNotifications.js\n\r\n\r\n\r\n\r\nconst ElementNotifications_OFFSET_TOP = -15;\r\nconst ElementNotifications_OFFSET_RIGHT = 15;\r\n\r\n\r\nfunction ElementNotifications(overlays, eventBus) {\r\n  this._overlays = overlays;\r\n\r\n  eventBus.on([\r\n    RESET_SIMULATION_EVENT,\r\n    SCOPE_CREATE_EVENT,\r\n    TOGGLE_MODE_EVENT\r\n  ], () => {\r\n    this.clear();\r\n  });\r\n}\r\n\r\nElementNotifications.prototype.addElementNotification = function(element, options) {\r\n  const position = {\r\n    top: ElementNotifications_OFFSET_TOP,\r\n    right: ElementNotifications_OFFSET_RIGHT\r\n  };\r\n\r\n  const {\r\n    type,\r\n    icon,\r\n    text,\r\n    scope = {}\r\n  } = options;\r\n\r\n  const colors = scope.colors;\r\n\r\n  const colorMarkup = colors\r\n    ? `style=\"color: ${colors.auxiliary}; background: ${colors.primary}\"`\r\n    : '';\r\n\r\n  const html = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)(`\r\n    <div class=\"bts-element-notification ${ type || '' }\" ${colorMarkup}>\r\n      ${ icon || '' }\r\n      <span class=\"bts-text\">${ text }</span>\r\n    </div>\r\n  `);\r\n\r\n  this._overlays.add(element, 'element-notification', {\r\n    position,\r\n    html: html,\r\n    show: {\r\n      minZoom: 0.5\r\n    }\r\n  });\r\n};\r\n\r\nElementNotifications.prototype.clear = function() {\r\n  this._overlays.remove({ type: 'element-notification' });\r\n};\r\n\r\nElementNotifications.prototype.removeElementNotification = function(element) {\r\n  this._overlays.remove({ element: element });\r\n};\r\n\r\nElementNotifications.$inject = [ 'overlays', 'eventBus' ];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/element-notifications/index.js\n\n\n/* harmony default export */ const element_notifications = ({\n  elementNotifications: [ 'type', ElementNotifications ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/notifications/Notifications.js\n\n\n\n\n\n\n\nconst NOTIFICATION_TIME_TO_LIVE = 2000; // ms\n\nconst INFO_ICON = InfoIcon();\n\n\nfunction Notifications(eventBus, canvas, scopeFilter) {\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n  this._scopeFilter = scopeFilter;\n\n  this._init();\n\n  eventBus.on([\n    TOGGLE_MODE_EVENT,\n    RESET_SIMULATION_EVENT\n  ], event => {\n    this.clear();\n  });\n}\n\nNotifications.prototype._init = function() {\n  this.container = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)('<div class=\"bts-notifications\"></div>');\n\n  this._canvas.getContainer().appendChild(this.container);\n};\n\nNotifications.prototype.showNotification = function(options) {\n\n  const {\n    text,\n    type = 'info',\n    icon = INFO_ICON,\n    scope,\n    ttl = NOTIFICATION_TIME_TO_LIVE\n  } = options;\n\n  if (scope && !this._scopeFilter.isShown(scope)) {\n    return;\n  }\n\n  const iconMarkup = icon.startsWith('<')\n    ? icon\n    : `<i class=\"${ icon }\"></i>`;\n\n  const colors = scope && scope.colors;\n\n  const colorMarkup = colors ? `style=\"color: ${colors.auxiliary}; background: ${colors.primary}\"` : '';\n\n  const notification = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)(`\n    <div class=\"bts-notification ${type}\">\n      <span class=\"bts-icon\">${iconMarkup}</span>\n      <span class=\"bts-text\" title=\"${ text }\">${text}</span>\n      ${ scope ? `<span class=\"bts-scope\" ${colorMarkup}>${scope.id}</span>` : '' }\n    </div>\n  `);\n\n  this.container.appendChild(notification);\n\n  // prevent more than 5 notifications at once\n  while (this.container.children.length > 5) {\n    this.container.children[0].remove();\n  }\n\n  setTimeout(function() {\n    notification.remove();\n  }, ttl);\n};\n\nNotifications.prototype.clear = function() {\n  while (this.container.children.length) {\n    this.container.children[0].remove();\n  }\n};\n\nNotifications.$inject = [\n  'eventBus',\n  'canvas',\n  'scopeFilter'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/notifications/index.js\n\n\n\n\n/* harmony default export */ const notifications = ({\n  __depends__: [\n    scope_filter\n  ],\n  notifications: [ 'type', Notifications ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/simulation-state/index.js\n\n\n\n\n\n/* harmony default export */ const simulation_state = ({\n  __depends__: [\n    element_notifications,\n    notifications\n  ],\n  __init__: [\n    'simulationState'\n  ],\n  simulationState: [ 'type', SimulationState ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/show-scopes/ShowScopes.js\n\n\n\n\nconst FILL_COLOR = '--token-simulation-silver-base-97';\nconst STROKE_COLOR = '--token-simulation-green-base-44';\n\nconst ID = 'show-scopes';\n\nconst VERY_HIGH_PRIORITY = 3000;\n\n\nfunction ShowScopes(\n    eventBus,\n    canvas,\n    scopeFilter,\n    elementColors,\n    simulationStyles) {\n\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n  this._scopeFilter = scopeFilter;\n  this._elementColors = elementColors;\n  this._simulationStyles = simulationStyles;\n\n  this._highlight = null;\n\n  this._init();\n\n  eventBus.on(TOGGLE_MODE_EVENT, event => {\n    const active = event.active;\n\n    if (active) {\n      (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this._container).remove('hidden');\n    } else {\n      (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this._container).add('hidden');\n      (0,node_modules_min_dom_dist_index_esm/* clear */.ZH)(this._container);\n\n      this.unhighlightScope();\n    }\n  });\n\n  eventBus.on(SCOPE_FILTER_CHANGED_EVENT, event => {\n\n    const allElements = this.getScopeElements();\n\n    for (const element of allElements) {\n      const scopeId = element.dataset.scopeId;\n\n      (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(element).toggle('inactive', !this._scopeFilter.isShown(scopeId));\n    }\n  });\n\n  eventBus.on(SCOPE_CREATE_EVENT, event => {\n    this.addScope(event.scope);\n  });\n\n  eventBus.on(SCOPE_DESTROYED_EVENT, event => {\n    this.removeScope(event.scope);\n  });\n\n  eventBus.on(SCOPE_CHANGED_EVENT, event => {\n    this.updateScope(event.scope);\n  });\n\n  eventBus.on(RESET_SIMULATION_EVENT, () => {\n    this.removeAllInstances();\n  });\n}\n\nShowScopes.prototype._init = function() {\n  this._container = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)('<div class=\"bts-scopes hidden\"></div>');\n\n  this._canvas.getContainer().appendChild(this._container);\n};\n\nShowScopes.prototype.addScope = function(scope) {\n\n  const processElements = [\n    'bpmn:Process',\n    'bpmn:SubProcess',\n    'bpmn:Participant'\n  ];\n\n  const {\n    element: scopeElement\n  } = scope;\n\n  if (!processElements.includes(scopeElement.type)) {\n    return;\n  }\n\n  const colors = scope.colors;\n\n  const colorMarkup = colors ? `style=\"color: ${colors.auxiliary}; background: ${colors.primary}\"` : '';\n\n  const html = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)(`\n    <div data-scope-id=\"${scope.id}\" class=\"bts-scope\"\n         title=\"View Process Instance ${scope.id}\" ${colorMarkup}>\n      ${scope.getTokens()}\n    </div>\n  `);\n\n  node_modules_min_dom_dist_index_esm/* event.bind */.B.bind(html, 'click', () => {\n    this._scopeFilter.toggle(scope);\n  });\n\n  node_modules_min_dom_dist_index_esm/* event.bind */.B.bind(html, 'mouseenter', () => {\n    this.highlightScope(scopeElement);\n  });\n\n  node_modules_min_dom_dist_index_esm/* event.bind */.B.bind(html, 'mouseleave', () => {\n    this.unhighlightScope();\n  });\n\n  if (!this._scopeFilter.isShown(scope)) {\n    (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(html).add('inactive');\n  }\n\n  this._container.appendChild(html);\n};\n\nShowScopes.prototype.getScopeElements = function() {\n  return (0,node_modules_min_dom_dist_index_esm/* queryAll */.Kt)('[data-scope-id]', this._container);\n};\n\nShowScopes.prototype.getScopeElement = function(scope) {\n  return (0,node_modules_min_dom_dist_index_esm/* query */.IO)(`[data-scope-id=\"${scope.id}\"]`, this._container);\n};\n\nShowScopes.prototype.updateScope = function(scope) {\n  const element = this.getScopeElement(scope);\n\n  if (element) {\n    element.textContent = scope.getTokens();\n  }\n};\n\nShowScopes.prototype.removeScope = function(scope) {\n  const element = this.getScopeElement(scope);\n\n  if (element) {\n    element.remove();\n  }\n};\n\nShowScopes.prototype.removeAllInstances = function() {\n  this._container.innerHTML = '';\n};\n\nShowScopes.prototype.highlightScope = function(element) {\n\n  this.unhighlightScope();\n\n  this._highlight = element;\n\n  this._elementColors.add(element, ID, this._getHighlightColors(), VERY_HIGH_PRIORITY);\n\n  if (!element.parent) {\n    (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this._canvas.getContainer()).add('highlight');\n  }\n};\n\nShowScopes.prototype.unhighlightScope = function() {\n\n  if (!this._highlight) {\n    return;\n  }\n\n  const element = this._highlight;\n\n  this._elementColors.remove(element, ID);\n\n  if (!element.parent) {\n    (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this._canvas.getContainer()).remove('highlight');\n  }\n\n  this._highlight = null;\n};\n\nShowScopes.prototype._getHighlightColors = function() {\n  return {\n    fill: this._simulationStyles.get(FILL_COLOR),\n    stroke: this._simulationStyles.get(STROKE_COLOR)\n  };\n};\n\nShowScopes.$inject = [\n  'eventBus',\n  'canvas',\n  'scopeFilter',\n  'elementColors',\n  'simulationStyles'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/simulation-styles/SimulationStyles.js\nfunction SimulationStyles() {\n  this._cache = {};\n}\n\nSimulationStyles.$inject = [];\n\n\nSimulationStyles.prototype.get = function(prop) {\n\n  const cachedValue = this._cache[prop];\n\n  if (cachedValue) {\n    return cachedValue;\n  }\n\n  if (!this._computedStyle) {\n    this._computedStyle = this._getComputedStyle();\n  }\n\n  return this._cache[prop] = this._computedStyle.getPropertyValue(prop).trim();\n};\n\nSimulationStyles.prototype._getComputedStyle = function() {\n\n  const get = typeof getComputedStyle === 'function'\n    ? getComputedStyle\n    : getComputedStyleMock;\n\n  const element = typeof document !== 'undefined'\n    ? document.documentElement\n    : {};\n\n  return get(element);\n};\n\n\n// helpers //////////////////\n\nfunction getComputedStyleMock() {\n  return {\n    getPropertyValue() {\n      return '';\n    }\n  };\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/simulation-styles/index.js\n\n\n/* harmony default export */ const simulation_styles = ({\n  simulationStyles: [ 'type', SimulationStyles ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/show-scopes/index.js\n\n\n\n\n\n/* harmony default export */ const show_scopes = ({\n  __depends__: [\n    scope_filter,\n    simulation_styles\n  ],\n  __init__: [\n    'showScopes'\n  ],\n  showScopes: [ 'type', ShowScopes ]\n});\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/EscapeUtil.js\nvar util_EscapeUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/EscapeUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/log/Log.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nconst ICON_INFO = InfoIcon();\r\n\r\nfunction getElementName(element) {\r\n  const name = element && element.businessObject.name;\r\n\r\n  return name && (0,util_EscapeUtil/* escapeHTML */.r)(name);\r\n}\r\n\r\n\r\nfunction Log(\r\n    eventBus, notifications,\r\n    tokenSimulationPalette, canvas,\r\n    scopeFilter, simulator) {\r\n\r\n  this._notifications = notifications;\r\n  this._tokenSimulationPalette = tokenSimulationPalette;\r\n  this._canvas = canvas;\r\n  this._scopeFilter = scopeFilter;\r\n\r\n  this._init();\r\n\r\n  eventBus.on(SCOPE_FILTER_CHANGED_EVENT, event => {\r\n    const allElements = (0,node_modules_min_dom_dist_index_esm/* queryAll */.Kt)('.bts-entry[data-scope-id]', this._container);\r\n\r\n    for (const element of allElements) {\r\n      const scopeId = element.dataset.scopeId;\r\n\r\n      (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(element).toggle('inactive', !this._scopeFilter.isShown(scopeId));\r\n    }\r\n  });\r\n\r\n  eventBus.on(SCOPE_DESTROYED_EVENT, event => {\r\n    const {\r\n      scope\r\n    } = event;\r\n\r\n    const {\r\n      element: scopeElement\r\n    } = scope;\r\n\r\n    const completed = scope.completed;\r\n\r\n    const processScopes = [\r\n      'bpmn:Process',\r\n      'bpmn:Participant',\r\n      'bpmn:SubProcess'\r\n    ];\r\n\r\n    if (!processScopes.includes(scopeElement.type)) {\r\n      return;\r\n    }\r\n\r\n    const isSubProcess = is(scopeElement, 'bpmn:SubProcess');\r\n\r\n    const text = `${\r\n      isSubProcess ? (getElementName(scopeElement) || 'SubProcess') : 'Process'\r\n    } ${\r\n      completed ? 'finished' : 'canceled'\r\n    }`;\r\n\r\n    this.log({\r\n      text,\r\n      icon: completed ? CheckCircleIcon() : TimesCircleIcon(),\r\n      scope\r\n    });\r\n  });\r\n\r\n  eventBus.on(SCOPE_CREATE_EVENT, event => {\r\n    const {\r\n      scope\r\n    } = event;\r\n\r\n    const {\r\n      element: scopeElement\r\n    } = scope;\r\n\r\n    const processScopes = [\r\n      'bpmn:Process',\r\n      'bpmn:Participant',\r\n      'bpmn:SubProcess'\r\n    ];\r\n\r\n    if (!processScopes.includes(scopeElement.type)) {\r\n      return;\r\n    }\r\n\r\n    const isSubProcess = is(scopeElement, 'bpmn:SubProcess');\r\n\r\n    const text = `${\r\n      isSubProcess ? (getElementName(scopeElement) || 'SubProcess') : 'Process'\r\n    } started`;\r\n\r\n    this.log({\r\n      text,\r\n      icon: CheckCircleIcon(),\r\n      scope\r\n    });\r\n  });\r\n\r\n  eventBus.on(TRACE_EVENT, event => {\r\n\r\n    const {\r\n      action,\r\n      scope: elementScope,\r\n      element\r\n    } = event;\r\n\r\n    if (action !== 'exit') {\r\n      return;\r\n    }\r\n\r\n    const scope = elementScope.parent;\r\n\r\n    const elementName = getElementName(element);\r\n\r\n    if (is(element, 'bpmn:BusinessRuleTask')) {\r\n      this.log({\r\n        text: elementName || 'Business Rule Task',\r\n        icon: 'bpmn-icon-business-rule',\r\n        scope\r\n      });\r\n    } else if (is(element, 'bpmn:CallActivity')) {\r\n      this.log({\r\n        text: elementName || 'Call Activity',\r\n        icon: 'bpmn-icon-call-activity',\r\n        scope\r\n      });\r\n    } else if (is(element, 'bpmn:IntermediateCatchEvent') || is(element, 'bpmn:IntermediateThrowEvent')) {\r\n      this.log({\r\n        text: elementName || 'Intermediate Event',\r\n        icon: 'bpmn-icon-intermediate-event-none',\r\n        scope\r\n      });\r\n    } if (is(element, 'bpmn:BoundaryEvent')) {\r\n      this.log({\r\n        text: elementName || 'Boundary Event',\r\n        icon: 'bpmn-icon-intermediate-event-none',\r\n        scope\r\n      });\r\n    } else if (is(element, 'bpmn:ManualTask')) {\r\n      this.log({\r\n        text: elementName || 'Manual Task',\r\n        icon: 'bpmn-icon-manual',\r\n        scope\r\n      });\r\n    } else if (is(element, 'bpmn:ScriptTask')) {\r\n      this.log({\r\n        text: elementName || 'Script Task',\r\n        icon: 'bpmn-icon-script',\r\n        scope\r\n      });\r\n    } else if (is(element, 'bpmn:ServiceTask')) {\r\n      this.log({\r\n        text: elementName || 'Service Task',\r\n        icon: 'bpmn-icon-service',\r\n        scope\r\n      });\r\n    } else if (is(element, 'bpmn:Task')) {\r\n      this.log({\r\n        text: elementName || 'Task',\r\n        icon: 'bpmn-icon-task',\r\n        scope\r\n      });\r\n    } else if (is(element, 'bpmn:UserTask')) {\r\n      this.log({\r\n        text: elementName || 'User Task',\r\n        icon: 'bpmn-icon-user',\r\n        scope\r\n      });\r\n    } else if (is(element, 'bpmn:ExclusiveGateway')) {\r\n      if (element.outgoing.length < 2) {\r\n        return;\r\n      }\r\n\r\n      const sequenceFlowName = getElementName(element.sequenceFlow);\r\n\r\n      let text = elementName || 'Gateway';\r\n\r\n      if (sequenceFlowName) {\r\n        text = text.concat(` ${ AngleRightIcon() } ${ sequenceFlowName }`);\r\n      }\r\n\r\n      this.log({\r\n        text,\r\n        icon: 'bpmn-icon-gateway-xor',\r\n        scope\r\n      });\r\n    } else if (is(element, 'bpmn:EndEvent')) {\r\n      if (ElementHelper_isTypedEvent((0,ModelUtil/* getBusinessObject */.SS)(element), 'bpmn:TerminateEventDefinition')) {\r\n        this.log({\r\n          text: elementName || 'Terminate End Event',\r\n          icon: 'bpmn-icon-end-event-terminate',\r\n          scope\r\n        });\r\n      } else {\r\n        this.log({\r\n          text: elementName || 'End Event',\r\n          icon: 'bpmn-icon-end-event-none',\r\n          scope\r\n        });\r\n      }\r\n    } else if (is(element, 'bpmn:StartEvent')) {\r\n      this.log({\r\n        text: elementName || 'Start Event',\r\n        icon: 'bpmn-icon-start-event-none',\r\n        scope\r\n      });\r\n    }\r\n  });\r\n\r\n\r\n  eventBus.on([\r\n    TOGGLE_MODE_EVENT,\r\n    RESET_SIMULATION_EVENT\r\n  ], event => {\r\n    this.clear();\r\n    this.toggle(false);\r\n  });\r\n}\r\n\r\nLog.prototype._init = function() {\r\n  this._container = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)(`\r\n    <div class=\"bts-log hidden djs-scrollable\">\r\n      <div class=\"bts-header\">\r\n        ${ LogIcon('bts-log-icon') }\r\n        Simulation Log\r\n        <button class=\"bts-close\">\r\n          ${ TimesIcon() }\r\n        </button>\r\n      </div>\r\n      <div class=\"bts-content\">\r\n        <p class=\"bts-entry placeholder\">No Entries</p>\r\n      </div>\r\n    </div>\r\n  `);\r\n\r\n  this._placeholder = (0,node_modules_min_dom_dist_index_esm/* query */.IO)('.bts-placeholder', this._container);\r\n\r\n  this._content = (0,node_modules_min_dom_dist_index_esm/* query */.IO)('.bts-content', this._container);\r\n\r\n  node_modules_min_dom_dist_index_esm/* event.bind */.B.bind(this._content, 'mousedown', event => {\r\n    event.stopPropagation();\r\n  });\r\n\r\n  this._close = (0,node_modules_min_dom_dist_index_esm/* query */.IO)('.bts-close', this._container);\r\n\r\n  node_modules_min_dom_dist_index_esm/* event.bind */.B.bind(this._close, 'click', () => {\r\n    this.toggle(false);\r\n  });\r\n\r\n  this._icon = (0,node_modules_min_dom_dist_index_esm/* query */.IO)('.bts-log-icon', this._container);\r\n\r\n  node_modules_min_dom_dist_index_esm/* event.bind */.B.bind(this._icon, 'click', () => {\r\n    this.toggle();\r\n  });\r\n\r\n  this._canvas.getContainer().appendChild(this._container);\r\n\r\n  this.paletteEntry = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)(`\r\n    <div class=\"bts-entry\" title=\"Toggle Simulation Log\">\r\n      ${ LogIcon() }\r\n    </div>\r\n  `);\r\n\r\n  node_modules_min_dom_dist_index_esm/* event.bind */.B.bind(this.paletteEntry, 'click', () => {\r\n    this.toggle();\r\n  });\r\n\r\n  this._tokenSimulationPalette.addEntry(this.paletteEntry, 3);\r\n};\r\n\r\nLog.prototype.isShown = function() {\r\n  const container = this._container;\r\n\r\n  return !(0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(container).has('hidden');\r\n};\r\n\r\nLog.prototype.toggle = function(shown = !this.isShown()) {\r\n  const container = this._container;\r\n\r\n  if (shown) {\r\n    (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(container).remove('hidden');\r\n  } else {\r\n    (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(container).add('hidden');\r\n  }\r\n};\r\n\r\nLog.prototype.log = function(options) {\r\n\r\n  const {\r\n    text,\r\n    type = 'info',\r\n    icon = ICON_INFO,\r\n    scope\r\n  } = options;\r\n\r\n  const content = this._content;\r\n\r\n  (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this._placeholder).add('hidden');\r\n\r\n  if (!this.isShown()) {\r\n    this._notifications.showNotification(options);\r\n  }\r\n\r\n  const iconMarkup = icon.startsWith('<') ? icon : `<i class=\"${icon}\"></i>`;\r\n\r\n  const colors = scope && scope.colors;\r\n\r\n  const colorMarkup = colors ? `style=\"background: ${colors.primary}; color: ${colors.auxiliary}\"` : '';\r\n\r\n  const logEntry = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)(`\r\n    <p class=\"bts-entry ${ type } ${\r\n      scope && this._scopeFilter.isShown(scope) ? '' : 'inactive'\r\n    }\" ${\r\n      scope ? `data-scope-id=\"${scope.id}\"` : ''\r\n    }>\r\n      <span class=\"bts-icon\">${iconMarkup}</span>\r\n      <span class=\"bts-text\" title=\"${ text }\">${text}</span>\r\n      ${\r\n        scope\r\n          ? `<span class=\"bts-scope\" data-scope-id=\"${scope.id}\" ${colorMarkup}>${scope.id}</span>`\r\n          : ''\r\n      }\r\n    </p>\r\n  `);\r\n\r\n  node_modules_min_dom_dist_index_esm/* delegate.bind */.cl.bind(logEntry, '.bts-scope[data-scope-id]', 'click', event => {\r\n    this._scopeFilter.toggle(scope);\r\n  });\r\n\r\n  // determine if the container should scroll,\r\n  // because it is currently scrolled to the very bottom\r\n  const shouldScroll = Math.abs(content.clientHeight + content.scrollTop - content.scrollHeight) < 2;\r\n\r\n  content.appendChild(logEntry);\r\n\r\n  if (shouldScroll) {\r\n    content.scrollTop = content.scrollHeight;\r\n  }\r\n};\r\n\r\nLog.prototype.clear = function() {\r\n  while (this._content.firstChild) {\r\n    this._content.removeChild(this._content.firstChild);\r\n  }\r\n\r\n  this._placeholder = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)('<p class=\"bts-entry placeholder\">No Entries</p>');\r\n\r\n  this._content.appendChild(this._placeholder);\r\n};\r\n\r\nLog.$inject = [\r\n  'eventBus',\r\n  'notifications',\r\n  'tokenSimulationPalette',\r\n  'canvas',\r\n  'scopeFilter',\r\n  'simulator'\r\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/log/index.js\n\n\n\n\n\n/* harmony default export */ const log = ({\n  __depends__: [\n    notifications,\n    scope_filter\n  ],\n  __init__: [\n    'log'\n  ],\n  log: [ 'type', Log ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/element-support/ElementSupport.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nconst UNSUPPORTED_ELEMENTS = [\r\n  'bpmn:InclusiveGateway',\r\n  'bpmn:ComplexGateway'\r\n];\r\n\r\nfunction ElementSupport_isLabel(element) {\r\n  return element.labelTarget;\r\n}\r\n\r\n\r\nfunction ElementSupport(\r\n    eventBus, elementRegistry, canvas,\r\n    notifications, elementNotifications) {\r\n\r\n  this._eventBus = eventBus;\r\n  this._elementRegistry = elementRegistry;\r\n  this._elementNotifications = elementNotifications;\r\n  this._notifications = notifications;\r\n\r\n  this._canvasParent = canvas.getContainer().parentNode;\r\n\r\n  eventBus.on(TOGGLE_MODE_EVENT, event => {\r\n\r\n    if (event.active) {\r\n      this.enable();\r\n    } else {\r\n      this.clear();\r\n    }\r\n  });\r\n}\r\n\r\nElementSupport.prototype.getUnsupportedElements = function() {\r\n  return this._unsupportedElements;\r\n};\r\n\r\nElementSupport.prototype.enable = function() {\r\n\r\n  const unsupportedElements = [];\r\n\r\n  this._elementRegistry.forEach(element => {\r\n\r\n    if (ElementSupport_isLabel(element)) {\r\n      return;\r\n    }\r\n\r\n    if (!is(element, UNSUPPORTED_ELEMENTS)) {\r\n      return;\r\n    }\r\n\r\n    this.showWarning(element);\r\n\r\n    unsupportedElements.push(element);\r\n  });\r\n\r\n  if (unsupportedElements.length) {\r\n\r\n    this._notifications.showNotification({\r\n      text: 'Found unsupported elements',\r\n      icon: ExclamationTriangleIcon(),\r\n      type: 'warning',\r\n      ttl: 5000\r\n    });\r\n  }\r\n\r\n  this._unsupportedElements = unsupportedElements;\r\n};\r\n\r\nElementSupport.prototype.clear = function() {\r\n  (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this._canvasParent).remove('warning');\r\n};\r\n\r\nElementSupport.prototype.showWarning = function(element) {\r\n  this._elementNotifications.addElementNotification(element, {\r\n    type: 'warning',\r\n    icon: ExclamationTriangleIcon(),\r\n    text: 'Not supported'\r\n  });\r\n};\r\n\r\nElementSupport.$inject = [\r\n  'eventBus',\r\n  'elementRegistry',\r\n  'canvas',\r\n  'notifications',\r\n  'elementNotifications'\r\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/element-support/index.js\n\n\n\n\n/* harmony default export */ const element_support = ({\n  __depends__: [\n    element_notifications,\n    notifications\n  ],\n  __init__: [ 'elementSupport' ],\n  elementSupport: [ 'type', ElementSupport ]\n});\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/pause-simulation/PauseSimulation.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nconst PLAY_MARKUP = PlayIcon();\r\nconst PAUSE_MARKUP = PauseIcon();\r\n\r\nconst PauseSimulation_HIGH_PRIORITY = 1500;\r\n\r\n\r\nfunction PauseSimulation(\r\n    eventBus, tokenSimulationPalette,\r\n    notifications, canvas) {\r\n\r\n  this._eventBus = eventBus;\r\n  this._tokenSimulationPalette = tokenSimulationPalette;\r\n  this._notifications = notifications;\r\n\r\n  this.canvasParent = canvas.getContainer().parentNode;\r\n\r\n  this.isActive = false;\r\n  this.isPaused = true;\r\n\r\n  this._init();\r\n\r\n  // unpause on simulation start\r\n  eventBus.on(SCOPE_CREATE_EVENT, PauseSimulation_HIGH_PRIORITY, event => {\r\n    this.activate();\r\n    this.unpause();\r\n  });\r\n\r\n  eventBus.on([\r\n    RESET_SIMULATION_EVENT,\r\n    TOGGLE_MODE_EVENT\r\n  ], () => {\r\n    this.deactivate();\r\n    this.pause();\r\n  });\r\n\r\n  eventBus.on(TRACE_EVENT, PauseSimulation_HIGH_PRIORITY, event => {\r\n    this.unpause();\r\n  });\r\n}\r\n\r\nPauseSimulation.prototype._init = function() {\r\n  this.paletteEntry = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)(`\r\n    <div class=\"bts-entry disabled\" title=\"Play/Pause Simulation\">\r\n      ${ PLAY_MARKUP }\r\n    </div>\r\n  `);\r\n\r\n  node_modules_min_dom_dist_index_esm/* event.bind */.B.bind(this.paletteEntry, 'click', this.toggle.bind(this));\r\n\r\n  this._tokenSimulationPalette.addEntry(this.paletteEntry, 1);\r\n};\r\n\r\nPauseSimulation.prototype.toggle = function() {\r\n  if (this.isPaused) {\r\n    this.unpause();\r\n  } else {\r\n    this.pause();\r\n  }\r\n};\r\n\r\nPauseSimulation.prototype.pause = function() {\r\n  if (!this.isActive) {\r\n    return;\r\n  }\r\n\r\n  (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this.paletteEntry).remove('active');\r\n  (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this.canvasParent).add('paused');\r\n\r\n  this.paletteEntry.innerHTML = PLAY_MARKUP;\r\n\r\n  this._eventBus.fire(PAUSE_SIMULATION_EVENT);\r\n\r\n  this._notifications.showNotification({\r\n    text: 'Pause Simulation'\r\n  });\r\n\r\n  this.isPaused = true;\r\n};\r\n\r\nPauseSimulation.prototype.unpause = function() {\r\n\r\n  if (!this.isActive || !this.isPaused) {\r\n    return;\r\n  }\r\n\r\n  (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this.paletteEntry).add('active');\r\n  (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this.canvasParent).remove('paused');\r\n\r\n  this.paletteEntry.innerHTML = PAUSE_MARKUP;\r\n\r\n  this._eventBus.fire(PLAY_SIMULATION_EVENT);\r\n\r\n  this._notifications.showNotification({\r\n    text: 'Play Simulation'\r\n  });\r\n\r\n  this.isPaused = false;\r\n};\r\n\r\nPauseSimulation.prototype.activate = function() {\r\n  this.isActive = true;\r\n\r\n  (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this.paletteEntry).remove('disabled');\r\n};\r\n\r\nPauseSimulation.prototype.deactivate = function() {\r\n  this.isActive = false;\r\n\r\n  (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this.paletteEntry).remove('active');\r\n  (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this.paletteEntry).add('disabled');\r\n};\r\n\r\nPauseSimulation.$inject = [\r\n  'eventBus',\r\n  'tokenSimulationPalette',\r\n  'notifications',\r\n  'canvas'\r\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/pause-simulation/index.js\n\n\n\n\n/* harmony default export */ const pause_simulation = ({\n  __depends__: [\n    notifications\n  ],\n  __init__: [\n    'pauseSimulation'\n  ],\n  pauseSimulation: [ 'type', PauseSimulation ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/reset-simulation/ResetSimulation.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nfunction ResetSimulation(eventBus, tokenSimulationPalette, notifications) {\r\n  this._eventBus = eventBus;\r\n  this._tokenSimulationPalette = tokenSimulationPalette;\r\n  this._notifications = notifications;\r\n\r\n  this._init();\r\n\r\n  eventBus.on(SCOPE_CREATE_EVENT, () => {\r\n    (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this._paletteEntry).remove('disabled');\r\n  });\r\n\r\n  eventBus.on(TOGGLE_MODE_EVENT, (event) => {\r\n    const active = this._active = event.active;\r\n\r\n    if (!active) {\r\n      this.resetSimulation();\r\n    }\r\n  });\r\n}\r\n\r\nResetSimulation.prototype._init = function() {\r\n  this._paletteEntry = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)(`\r\n    <div class=\"bts-entry disabled\" title=\"Reset Simulation\">\r\n      ${ ResetIcon() }\r\n    </div>\r\n  `);\r\n\r\n  node_modules_min_dom_dist_index_esm/* event.bind */.B.bind(this._paletteEntry, 'click', () => {\r\n    this.resetSimulation();\r\n\r\n    this._notifications.showNotification({\r\n      text: 'Reset Simulation',\r\n      type: 'info'\r\n    });\r\n  });\r\n\r\n  this._tokenSimulationPalette.addEntry(this._paletteEntry, 2);\r\n};\r\n\r\nResetSimulation.prototype.resetSimulation = function() {\r\n  (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this._paletteEntry).add('disabled');\r\n\r\n  this._eventBus.fire(RESET_SIMULATION_EVENT);\r\n};\r\n\r\nResetSimulation.$inject = [\r\n  'eventBus',\r\n  'tokenSimulationPalette',\r\n  'notifications'\r\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/reset-simulation/index.js\n\n\n\n\n/* harmony default export */ const reset_simulation = ({\n  __depends__: [\n    notifications\n  ],\n  __init__: [\n    'resetSimulation'\n  ],\n  resetSimulation: [ 'type', ResetSimulation ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/token-count/TokenCount.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nconst OFFSET_BOTTOM = 10;\r\nconst TokenCount_OFFSET_LEFT = -15;\r\n\r\nconst TokenCount_LOW_PRIORITY = 500;\r\n\r\nconst TokenCount_DEFAULT_PRIMARY_COLOR = '--token-simulation-green-base-44';\r\nconst TokenCount_DEFAULT_AUXILIARY_COLOR = '--token-simulation-white';\r\n\r\n\r\nfunction TokenCount(\r\n    eventBus, overlays,\r\n    simulator, scopeFilter,\r\n    simulationStyles) {\r\n\r\n  this._overlays = overlays;\r\n  this._scopeFilter = scopeFilter;\r\n  this._simulator = simulator;\r\n  this._simulationStyles = simulationStyles;\r\n\r\n  this.overlayIds = {};\r\n\r\n  eventBus.on(ELEMENT_CHANGED_EVENT, TokenCount_LOW_PRIORITY, event => {\r\n\r\n    const {\r\n      element\r\n    } = event;\r\n\r\n    this.removeTokenCounts(element);\r\n    this.addTokenCounts(element);\r\n  });\r\n\r\n  eventBus.on(SCOPE_FILTER_CHANGED_EVENT, event => {\r\n\r\n    const allElements = (0,node_modules_min_dom_dist_index_esm/* queryAll */.Kt)('.bts-token-count[data-scope-id]', overlays._overlayRoot);\r\n\r\n    for (const element of allElements) {\r\n      const scopeId = element.dataset.scopeId;\r\n\r\n      (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(element).toggle('inactive', !this._scopeFilter.isShown(scopeId));\r\n    }\r\n  });\r\n}\r\n\r\nTokenCount.prototype.addTokenCounts = function(element) {\r\n\r\n  if (is(element, 'bpmn:MessageFlow') || is(element, 'bpmn:SequenceFlow')) {\r\n    return;\r\n  }\r\n\r\n  const scopes = this._simulator.findScopes(scope => {\r\n    return (\r\n      !scope.destroyed &&\r\n      scope.children.some(c => !c.destroyed && c.element === element && !c.children.length)\r\n    );\r\n  });\r\n\r\n  this.addTokenCount(element, scopes);\r\n};\r\n\r\nTokenCount.prototype.addTokenCount = function(element, scopes) {\r\n  if (!scopes.length) {\r\n    return;\r\n  }\r\n\r\n  const tokenMarkup = scopes.map(scope => {\r\n    return this._getTokenHTML(element, scope);\r\n  }).join('');\r\n\r\n  const html = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)(`\r\n    <div class=\"bts-token-count-parent\">\r\n      ${tokenMarkup}\r\n    </div>\r\n  `);\r\n\r\n  const position = { bottom: OFFSET_BOTTOM, left: TokenCount_OFFSET_LEFT };\r\n\r\n  const overlayId = this._overlays.add(element, 'token-count', {\r\n    position: position,\r\n    html: html,\r\n    show: {\r\n      minZoom: 0.5\r\n    }\r\n  });\r\n\r\n  this.overlayIds[element.id] = overlayId;\r\n};\r\n\r\nTokenCount.prototype.removeTokenCounts = function(element) {\r\n  this.removeTokenCount(element);\r\n};\r\n\r\nTokenCount.prototype.removeTokenCount = function(element) {\r\n  const overlayId = this.overlayIds[element.id];\r\n\r\n  if (!overlayId) {\r\n    return;\r\n  }\r\n\r\n  this._overlays.remove(overlayId);\r\n\r\n  delete this.overlayIds[element.id];\r\n};\r\n\r\nTokenCount.prototype._getTokenHTML = function(element, scope) {\r\n\r\n  const colors = scope.colors || this._getDefaultColors();\r\n\r\n  return `\r\n    <div data-scope-id=\"${scope.id}\" class=\"bts-token-count waiting ${this._scopeFilter.isShown(scope) ? '' : 'inactive' }\"\r\n         style=\"color: ${colors.auxiliary}; background: ${ colors.primary }\">\r\n      ${scope.getTokensByElement(element)}\r\n    </div>\r\n  `;\r\n};\r\n\r\nTokenCount.prototype._getDefaultColors = function() {\r\n  return {\r\n    primary: this._simulationStyles.get(TokenCount_DEFAULT_PRIMARY_COLOR),\r\n    auxiliary: this._simuationStyles.get(TokenCount_DEFAULT_AUXILIARY_COLOR)\r\n  };\r\n};\r\n\r\nTokenCount.$inject = [\r\n  'eventBus',\r\n  'overlays',\r\n  'simulator',\r\n  'scopeFilter',\r\n  'simulationStyles'\r\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/token-count/index.js\n\n\n\n\n\n/* harmony default export */ const token_count = ({\n  __depends__: [\n    scope_filter,\n    simulation_styles\n  ],\n  __init__: [\n    'tokenCount'\n  ],\n  tokenCount: [ 'type', TokenCount ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/set-animation-speed/SetAnimationSpeed.js\n\n\n\n\nconst SPEEDS = [\n  [ 'Slow', 0.5 ],\n  [ 'Normal', 1 ],\n  [ 'Fast', 2 ]\n];\n\n\n\n\nfunction SetAnimationSpeed(canvas, animation, eventBus) {\n  this._canvas = canvas;\n  this._animation = animation;\n  this._eventBus = eventBus;\n\n  this._init(animation.getAnimationSpeed());\n\n  eventBus.on(TOGGLE_MODE_EVENT, event => {\n    const active = event.active;\n\n    if (!active) {\n      (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this._container).add('hidden');\n    } else {\n      (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(this._container).remove('hidden');\n    }\n  });\n\n  eventBus.on(ANIMATION_SPEED_CHANGED_EVENT, event => {\n    this.setActive(event.speed);\n  });\n}\n\nSetAnimationSpeed.prototype.getToggleSpeed = function(element) {\n  return parseFloat(element.dataset.speed);\n};\n\nSetAnimationSpeed.prototype._init = function(animationSpeed) {\n  this._container = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)(`\n    <div class=\"bts-set-animation-speed hidden\">\n      ${ TachometerIcon() }\n      <div class=\"bts-animation-speed-buttons\">\n        ${\n          SPEEDS.map(([ label, speed ], idx) => `\n            <button title=\"Set animation speed = ${ label }\" data-speed=\"${ speed }\" class=\"bts-animation-speed-button ${speed === animationSpeed ? 'active' : ''}\">\n              ${\n                Array.from({ length: idx + 1 }).map(\n                  () => AngleRightIcon()\n                ).join('')\n              }\n            </button>\n          `).join('')\n        }\n      </div>\n    </div>\n  `);\n\n  node_modules_min_dom_dist_index_esm/* delegate.bind */.cl.bind(this._container, '[data-speed]', 'click', event => {\n\n    const toggle = event.delegateTarget;\n\n    const speed = this.getToggleSpeed(toggle);\n\n    this._animation.setAnimationSpeed(speed);\n  });\n\n  this._canvas.getContainer().appendChild(this._container);\n};\n\nSetAnimationSpeed.prototype.setActive = function(speed) {\n  (0,node_modules_min_dom_dist_index_esm/* queryAll */.Kt)('[data-speed]', this._container).forEach(toggle => {\n\n    const active = this.getToggleSpeed(toggle) === speed;\n\n    (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(toggle)[active ? 'add' : 'remove']('active');\n  });\n};\n\nSetAnimationSpeed.$inject = [\n  'canvas',\n  'animation',\n  'eventBus'\n];\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/set-animation-speed/index.js\n\n\n/* harmony default export */ const set_animation_speed = ({\n  __init__: [\n    'setAnimationSpeed'\n  ],\n  setAnimationSpeed: [ 'type', SetAnimationSpeed ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/exclusive-gateway-settings/ExclusiveGatewaySettings.js\n\r\n\r\n\r\n\r\n\r\nconst SELECTED_COLOR = '--token-simulation-grey-darken-30';\r\nconst NOT_SELECTED_COLOR = '--token-simulation-grey-lighten-56';\r\n\r\nfunction getNext(gateway, sequenceFlow) {\r\n  var outgoing = gateway.outgoing.filter(ExclusiveGatewaySettings_isSequenceFlow);\r\n\r\n  var index = outgoing.indexOf(sequenceFlow || gateway.sequenceFlow);\r\n\r\n  if (outgoing[index + 1]) {\r\n    return outgoing[index + 1];\r\n  } else {\r\n    return outgoing[0];\r\n  }\r\n}\r\n\r\nfunction ExclusiveGatewaySettings_isSequenceFlow(connection) {\r\n  return is(connection, 'bpmn:SequenceFlow');\r\n}\r\n\r\nconst ExclusiveGatewaySettings_ID = 'exclusive-gateway-settings';\r\n\r\nconst ExclusiveGatewaySettings_HIGH_PRIORITY = 2000;\r\n\r\n\r\nfunction ExclusiveGatewaySettings(\r\n    eventBus, elementRegistry,\r\n    elementColors, simulator, simulationStyles) {\r\n\r\n  this._elementRegistry = elementRegistry;\r\n  this._elementColors = elementColors;\r\n  this._simulator = simulator;\r\n  this._simulationStyles = simulationStyles;\r\n\r\n  eventBus.on(TOGGLE_MODE_EVENT, event => {\r\n    if (event.active) {\r\n      this.setSequenceFlowsDefault();\r\n    } else {\r\n      this.resetSequenceFlows();\r\n    }\r\n  });\r\n}\r\n\r\nExclusiveGatewaySettings.prototype.setSequenceFlowsDefault = function() {\r\n  const exclusiveGateways = this._elementRegistry.filter(element => {\r\n    return is(element, 'bpmn:ExclusiveGateway');\r\n  });\r\n\r\n  for (const gateway of exclusiveGateways) {\r\n    this.setSequenceFlow(gateway);\r\n  }\r\n};\r\n\r\nExclusiveGatewaySettings.prototype.resetSequenceFlows = function() {\r\n\r\n  const exclusiveGateways = this._elementRegistry.filter(element => {\r\n    return is(element, 'bpmn:ExclusiveGateway');\r\n  });\r\n\r\n  exclusiveGateways.forEach(exclusiveGateway => {\r\n    if (exclusiveGateway.outgoing.filter(ExclusiveGatewaySettings_isSequenceFlow).length) {\r\n      this.resetSequenceFlow(exclusiveGateway);\r\n    }\r\n  });\r\n};\r\n\r\nExclusiveGatewaySettings.prototype.resetSequenceFlow = function(gateway) {\r\n  this._simulator.setConfig(gateway, { activeOutgoing: undefined });\r\n};\r\n\r\nExclusiveGatewaySettings.prototype.setSequenceFlow = function(gateway) {\r\n\r\n  const outgoing = gateway.outgoing.filter(ExclusiveGatewaySettings_isSequenceFlow);\r\n\r\n  // not forking\r\n  if (outgoing.length < 2) {\r\n    return;\r\n  }\r\n\r\n  const {\r\n    activeOutgoing\r\n  } = this._simulator.getConfig(gateway);\r\n\r\n  let newActiveOutgoing;\r\n\r\n  if (activeOutgoing) {\r\n\r\n    // set next sequence flow\r\n    newActiveOutgoing = getNext(gateway, activeOutgoing);\r\n  } else {\r\n\r\n    // set first sequence flow\r\n    newActiveOutgoing = outgoing[ 0 ];\r\n  }\r\n\r\n  this._simulator.setConfig(gateway, { activeOutgoing: newActiveOutgoing });\r\n\r\n  // set colors\r\n  gateway.outgoing.forEach(outgoing => {\r\n\r\n    const style = outgoing === newActiveOutgoing ? SELECTED_COLOR : NOT_SELECTED_COLOR;\r\n    const stroke = this._simulationStyles.get(style);\r\n\r\n    this._elementColors.add(outgoing, ExclusiveGatewaySettings_ID, {\r\n      stroke\r\n    }, ExclusiveGatewaySettings_HIGH_PRIORITY);\r\n  });\r\n};\r\n\r\nExclusiveGatewaySettings.$inject = [\r\n  'eventBus',\r\n  'elementRegistry',\r\n  'elementColors',\r\n  'simulator',\r\n  'simulationStyles'\r\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/element-colors/ElementColors.js\n\n\n\n\nconst ElementColors_VERY_HIGH_PRIORITY = 50000;\n\n/**\n * @typedef Colors\n * @prop {string} fill\n * @prop {string} stroke\n */\n\n/**\n * @typedef CustomColors\n * @prop {string} fill\n * @prop {string} stroke\n * @prop {number} priority\n */\n\nfunction ElementColors(elementRegistry, eventBus, graphicsFactory) {\n  this._elementRegistry = elementRegistry;\n  this._eventBus = eventBus;\n  this._graphicsFactory = graphicsFactory;\n\n  this._originalColors = {};\n  this._customColors = {};\n\n  eventBus.on(TOGGLE_MODE_EVENT, ElementColors_VERY_HIGH_PRIORITY, event => {\n    const active = event.active;\n\n    if (active) {\n      this._saveOriginalColors();\n    } else {\n      this._applyOriginalColors();\n\n      this._originalColors = {};\n      this._customColors = {};\n    }\n  });\n\n  eventBus.on('saveXML.start', ElementColors_VERY_HIGH_PRIORITY, () => {\n    this._applyOriginalColors();\n\n    eventBus.once('saveXML.done', () => this._applyCustomColors());\n  });\n}\n\nElementColors.$inject = [\n  'elementRegistry',\n  'eventBus',\n  'graphicsFactory'\n];\n\n/**\n * Add colors to an element. Element will be redrawn with highest priority\n * colors.\n *\n * @param {Object} element\n * @param {string} id\n * @param {Colors} colors\n * @param {number} [priority=1000]\n */\nElementColors.prototype.add = function(element, id, colors, priority = 1000) {\n  let elementColors = this._customColors[ element.id ];\n\n  if (!elementColors) {\n    elementColors = this._customColors[ element.id ] = {};\n  }\n\n  elementColors[ id ] = {\n    ...colors,\n    priority\n  };\n\n  this._applyHighestPriorityColor(element);\n};\n\n\n/**\n * Remove colors from an element. Element will be redrawn with highest priority\n * colors.\n *\n * @param {Object} element\n * @param {string} id\n */\nElementColors.prototype.remove = function(element, id) {\n  const elementColors = this._customColors[ element.id ];\n\n  if (elementColors) {\n    delete elementColors[ id ];\n\n    if (!Object.keys(elementColors)) {\n      delete this._customColors[ element.id ];\n    }\n  }\n\n  this._applyHighestPriorityColor(element);\n};\n\nElementColors.prototype._get = function(element) {\n  const di = (0,ModelUtil/* getDi */.DN)(element);\n\n  if (!di) {\n    return undefined;\n  }\n\n  // reading in accordance with bpmn-js@8.7+,\n  // BPMN-in-Color specification\n  if (ElementColors_isLabel(element)) {\n    return {\n      stroke: di.label && di.label.get('color')\n    };\n  } else if ((0,ModelUtil/* isAny */.JZ)(di, [ 'bpmndi:BPMNEdge', 'bpmndi:BPMNShape' ])) {\n    return {\n      fill: di.get('background-color'),\n      stroke: di.get('border-color')\n    };\n  }\n};\n\nElementColors.prototype._set = function(element, colors = {}) {\n  const {\n    fill,\n    stroke\n  } = colors;\n\n  const di = (0,ModelUtil/* getDi */.DN)(element);\n\n  if (!di) {\n    return;\n  }\n\n  // writing in accordance with bpmn-js@8.7+,\n  // BPMN-in-Color specification\n  if (ElementColors_isLabel(element)) {\n    di.label && di.label.set('color', stroke);\n  } else if ((0,ModelUtil/* isAny */.JZ)(di, [ 'bpmndi:BPMNEdge', 'bpmndi:BPMNShape' ])) {\n    di.set('background-color', fill);\n    di.set('border-color', stroke);\n  }\n\n  this._forceRedraw(element);\n};\n\nElementColors.prototype._saveOriginalColors = function() {\n  this._originalColors = {};\n\n  this._elementRegistry.forEach(element => {\n    this._originalColors[ element.id ] = this._get(element);\n  });\n};\n\nElementColors.prototype._applyOriginalColors = function() {\n  this._elementRegistry.forEach(element => {\n    const colors = this._originalColors[ element.id ];\n\n    if (colors) {\n      this._set(element, colors);\n    }\n  });\n};\n\nElementColors.prototype._applyCustomColors = function() {\n  this._elementRegistry.forEach(element => {\n    const elementColors = this._customColors[ element.id ];\n\n    if (elementColors) {\n      this._set(element, getColorsWithHighestPriority(elementColors));\n    }\n  });\n};\n\nElementColors.prototype._applyHighestPriorityColor = function(element) {\n  const elementColors = this._customColors[ element.id ];\n\n  if (!elementColors) {\n    this._set(element, this._originalColors[ element.id ]);\n\n    return;\n  }\n\n  this._set(element, getColorsWithHighestPriority(elementColors));\n};\n\nElementColors.prototype._forceRedraw = function(element) {\n  const gfx = this._elementRegistry.getGraphics(element);\n\n  const type = element.waypoints ? 'connection' : 'shape';\n\n  this._graphicsFactory.update(type, element, gfx);\n};\n\n\n// helpers /////////////////\n\nfunction ElementColors_isLabel(element) {\n  return 'labelTarget' in element;\n}\n\n/**\n * Get colors with highest priority.\n *\n * @param {Map<string, CustomColors>|undefined} colors\n *\n * @returns {Colors|undefined}\n */\nfunction getColorsWithHighestPriority(colors = {}) {\n  const colorsWithHighestPriority = Object.values(colors).reduce((colorsWithHighestPriority, colors) => {\n    const { priority = 1000 } = colors;\n\n    if (!colorsWithHighestPriority || priority > colorsWithHighestPriority.priority) {\n      return colors;\n    }\n\n    return colorsWithHighestPriority;\n  }, undefined);\n\n  if (colorsWithHighestPriority) {\n    const { priority, ...fillAndStroke } = colorsWithHighestPriority;\n\n    return fillAndStroke;\n  }\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/element-colors/index.js\n\n\n/* harmony default export */ const element_colors = ({\n  elementColors: [ 'type', ElementColors ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/exclusive-gateway-settings/index.js\n\n\n\n\n/* harmony default export */ const exclusive_gateway_settings = ({\n  __depends__: [\n    element_colors,\n    simulation_styles\n  ],\n  exclusiveGatewaySettings: [ 'type', ExclusiveGatewaySettings ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/neutral-element-colors/NeutralElementColors.js\n\n\nconst NeutralElementColors_ID = 'neutral-element-colors';\n\nfunction NeutralElementColors(\n    eventBus, elementRegistry, elementColors) {\n\n  this._elementRegistry = elementRegistry;\n  this._elementColors = elementColors;\n\n  eventBus.on(TOGGLE_MODE_EVENT, event => {\n    const { active } = event;\n\n    if (active) {\n      this._setNeutralColors();\n    }\n  });\n}\n\nNeutralElementColors.prototype._setNeutralColors = function() {\n  this._elementRegistry.forEach(element => {\n    this._elementColors.add(element, NeutralElementColors_ID, {\n      stroke: '#212121',\n      fill: '#fff'\n    });\n  });\n};\n\nNeutralElementColors.$inject = [\n  'eventBus',\n  'elementRegistry',\n  'elementColors'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/neutral-element-colors/index.js\n\n\n\n/* harmony default export */ const neutral_element_colors = ({\n  __depends__: [ element_colors ],\n  __init__: [\n    'neutralElementColors'\n  ],\n  neutralElementColors: [ 'type', NeutralElementColors ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/palette/Palette.js\n\r\n\r\n\r\n\r\n\r\nfunction Palette(eventBus, canvas) {\r\n  var self = this;\r\n\r\n  this._canvas = canvas;\r\n\r\n  this.entries = [];\r\n\r\n  this._init();\r\n\r\n  eventBus.on(TOGGLE_MODE_EVENT, function(context) {\r\n    var active = context.active;\r\n\r\n    if (active) {\r\n      (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(self.container).remove('hidden');\r\n    } else {\r\n      (0,node_modules_min_dom_dist_index_esm/* classes */.Sh)(self.container).add('hidden');\r\n    }\r\n  });\r\n}\r\n\r\nPalette.prototype._init = function() {\r\n  this.container = (0,node_modules_min_dom_dist_index_esm/* domify */.H6)('<div class=\"bts-palette hidden\"></div>');\r\n\r\n  this._canvas.getContainer().appendChild(this.container);\r\n};\r\n\r\nPalette.prototype.addEntry = function(entry, index) {\r\n  var childIndex = 0;\r\n\r\n  this.entries.forEach(function(entry) {\r\n    if (index >= entry.index) {\r\n      childIndex++;\r\n    }\r\n  });\r\n\r\n  this.container.insertBefore(entry, this.container.childNodes[childIndex]);\r\n\r\n  this.entries.push({\r\n    entry: entry,\r\n    index: index\r\n  });\r\n};\r\n\r\nPalette.$inject = [ 'eventBus', 'canvas' ];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/features/palette/index.js\n\n\n/* harmony default export */ const palette = ({\n  __init__: [\n    'tokenSimulationPalette'\n  ],\n  tokenSimulationPalette: [ 'type', Palette ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/base.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/* harmony default export */ const base = ({\n  __depends__: [\n    simulator,\n    animation,\n    colored_scopes,\n    context_pads,\n    simulation_state,\n    show_scopes,\n    log,\n    element_support,\n    pause_simulation,\n    reset_simulation,\n    token_count,\n    set_animation_speed,\n    exclusive_gateway_settings,\n    neutral_element_colors,\n    palette\n  ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-token-simulation/lib/viewer.js\n\r\n\r\n\r\n\r\n/* harmony default export */ const lib_viewer = ({\r\n  __depends__: [\r\n    base,\r\n    viewer\r\n  ]\r\n});\n// EXTERNAL MODULE: ./node_modules/@bpmn-io/properties-panel/preact/hooks/dist/hooks.module.js\nvar hooks_module = __webpack_require__(\"./node_modules/@bpmn-io/properties-panel/preact/hooks/dist/hooks.module.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js-properties-panel/node_modules/min-dash/dist/index.esm.js\nvar bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm = __webpack_require__(\"./node_modules/bpmn-js-properties-panel/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/@bpmn-io/properties-panel/dist/index.esm.js + 7 modules\nvar properties_panel_dist_index_esm = __webpack_require__(\"./node_modules/@bpmn-io/properties-panel/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/@bpmn-io/properties-panel/preact/dist/preact.module.js\nvar preact_module = __webpack_require__(\"./node_modules/@bpmn-io/properties-panel/preact/dist/preact.module.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/features/label-editing/LabelUtil.js\nvar LabelUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/features/label-editing/LabelUtil.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/util/DiUtil.js\nvar DiUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/util/DiUtil.js\");\n// EXTERNAL MODULE: ./node_modules/@bpmn-io/properties-panel/preact/compat/dist/compat.module.js\nvar compat_module = __webpack_require__(\"./node_modules/@bpmn-io/properties-panel/preact/compat/dist/compat.module.js\");\n// EXTERNAL MODULE: ./node_modules/@bpmn-io/properties-panel/preact/jsx-runtime/dist/jsxRuntime.module.js\nvar jsxRuntime_module = __webpack_require__(\"./node_modules/@bpmn-io/properties-panel/preact/jsx-runtime/dist/jsxRuntime.module.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\nvar KeyboardUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js-properties-panel/node_modules/min-dom/dist/index.esm.js\nvar bpmn_js_properties_panel_node_modules_min_dom_dist_index_esm = __webpack_require__(\"./node_modules/bpmn-js-properties-panel/node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Collections.js\nvar Collections = __webpack_require__(\"./node_modules/diagram-js/lib/util/Collections.js\");\n// EXTERNAL MODULE: ./node_modules/@bpmn-io/extract-process-variables/zeebe/index.js\nvar zeebe = __webpack_require__(\"./node_modules/@bpmn-io/extract-process-variables/zeebe/index.js\");\n// EXTERNAL MODULE: ./node_modules/array-move/index.js\nvar array_move = __webpack_require__(\"./node_modules/array-move/index.js\");\n// EXTERNAL MODULE: ./node_modules/@bpmn-io/extract-process-variables/dist/index.js\nvar dist = __webpack_require__(\"./node_modules/@bpmn-io/extract-process-variables/dist/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/i18n/translate/index.js + 1 modules\nvar translate = __webpack_require__(\"./node_modules/diagram-js/lib/i18n/translate/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/command/CommandInterceptor.js\nvar CommandInterceptor = __webpack_require__(\"./node_modules/diagram-js/lib/command/CommandInterceptor.js\");\n// EXTERNAL MODULE: ./node_modules/semver-compare/index.js\nvar semver_compare = __webpack_require__(\"./node_modules/semver-compare/index.js\");\nvar semver_compare_default = /*#__PURE__*/__webpack_require__.n(semver_compare);\n// EXTERNAL MODULE: ./node_modules/@bpmn-io/element-templates-validator/dist/index.esm.js\nvar element_templates_validator_dist_index_esm = __webpack_require__(\"./node_modules/@bpmn-io/element-templates-validator/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/classnames/index.js\nvar classnames = __webpack_require__(\"./node_modules/classnames/index.js\");\nvar classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);\n;// CONCATENATED MODULE: ./node_modules/bpmn-js-properties-panel/dist/index.esm.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nconst BpmnPropertiesPanelContext = (0,preact_module/* createContext */.kr)({\n  selectedElement: null,\n  injector: null,\n  getService() {\n    return null;\n  }\n});\n\nfunction useService(type, strict) {\n  const {\n    getService\n  } = (0,hooks_module/* useContext */.qp)(BpmnPropertiesPanelContext);\n  return getService(type, strict);\n}\n\nfunction _extends$1o() { _extends$1o = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1o.apply(this, arguments); }\nvar AssociationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1o({\n  width: \"32\",\n  height: \"32\",\n  xmlns: \"http://www.w3.org/2000/svg\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  stroke: \"#000\",\n  strokeWidth: \"2\",\n  fill: \"none\",\n  strokeDasharray: \"3.3,6\",\n  strokeLinecap: \"square\",\n  d: \"M1.5 30.5l29-29\"\n})));\n\nfunction _extends$1n() { _extends$1n = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1n.apply(this, arguments); }\nvar BusinessRuleTaskIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1n({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M6.494 3C2.916 3 0 5.903 0 9.475v13.383c0 3.572 2.916 6.475 6.494 6.475h19.012c3.578 0 6.494-2.903 6.494-6.475V9.475C32 5.903 29.084 3 25.506 3H6.494zm0 2h19.012C28.015 5 30 6.98 30 9.475v13.383c0 2.495-1.985 4.475-4.494 4.475H6.494C3.985 27.333 2 25.353 2 22.858V9.475C2 6.98 3.985 5 6.494 5zM5.296 7.398v12.665h16.87V7.398H5.296zm.718 4.386h15.433v3.44H9.985v-3.432h-.719v3.431H6.014v-3.44zm0 4.158h3.252v3.403H6.014v-3.403zm3.97 0h11.463v3.403H9.985v-3.403z\"\n}), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M6.079 8.209v3.587H21.44V8.209z\"\n})));\n\nfunction _extends$1m() { _extends$1m = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1m.apply(this, arguments); }\nvar CallActivityIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1m({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M24.978 3c3.761 0 6.89 2.979 7.018 6.695l.004.238V22.4c0 3.747-3.05 6.804-6.783 6.93l-.24.003H7.023c-3.761 0-6.89-2.978-7.018-6.695L0 22.4V9.933C0 6.187 3.05 3.13 6.783 3.004L7.023 3h17.955zm0 3.667H7.022c-1.842 0-3.255 1.344-3.35 3.079l-.005.187V22.4c0 1.761 1.35 3.167 3.16 3.262l.195.005L10 25.666V15h12v10.666h2.978c1.842 0 3.255-1.344 3.35-3.079l.005-.187V9.933c0-1.761-1.35-3.166-3.16-3.261l-.195-.005zm-3.732 9.087H10.754v9.912h10.491v-9.912zm-4.475 1.817v2.658h2.658v1.542H16.77v2.658H15.23V21.77H12.57V20.23h2.658V17.57h1.542z\"\n})));\n\nfunction _extends$1l() { _extends$1l = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1l.apply(this, arguments); }\nvar CollaborationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1l({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"g\", {\n  fillRule: \"evenodd\"\n}, /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  fillRule: \"nonzero\",\n  d: \"M0 0v8.62h32V0H0zm1.655 7.054v-5.37h28.62v5.37H1.656zM0 23.38V32h32v-8.62H0zm1.655 7.054v-5.37h28.62v5.37H1.656z\"\n}), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M24 8l4 7h-8l4-7zm0 2l-2.28 4h4.56L24 10zM23.5 21h1v3h-1zM23.5 15h1v3h-1zM8 24l-4-7h8l-4 7zm0-2l2.28-4H5.72L8 22zM7.5 8h1v3h-1zM7.5 14h1v3h-1z\"\n}))));\n\nfunction _extends$1k() { _extends$1k = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1k.apply(this, arguments); }\nvar ConditionalFlowIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1k({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M32 .041S20.42 5.95 14.537 8.713c1.26 1.15 2.432 2.392 3.648 3.588-5.703 5.78-3.15 3.303-8.087 8.316l-8.472 1.377L0 32l10.006-1.626.098-.598 1.279-7.873c4.975-5.052 2.403-2.555 8.118-8.346 1.218 1.214 2.43 2.435 3.648 3.648C26.29 11.018 32 .041 32 .041zM9.603 22.397L8.54 28.91 2.03 29.97l1.061-6.515 6.512-1.058z\"\n})));\n\nfunction _extends$1j() { _extends$1j = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1j.apply(this, arguments); }\nvar ConnectionIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1j({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M32 .06S20.33 6.014 14.403 8.798c1.27 1.16 2.451 2.41 3.676 3.616L0 30.734 1.325 32l18.08-18.32c1.227 1.223 2.448 2.453 3.676 3.676C26.247 11.12 32 .06 32 .06z\"\n})));\n\nfunction _extends$1i() { _extends$1i = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1i.apply(this, arguments); }\nvar DataInputOutputAssociationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1i({\n  width: \"32\",\n  height: \"32\",\n  xmlns: \"http://www.w3.org/2000/svg\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  stroke: \"#000\",\n  strokeWidth: \"2\",\n  strokeLinecap: \"round\",\n  strokeDasharray: \"1.1,4.3\",\n  d: \"M1.5 30.5L27 5\"\n}), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M31.803.197L26.5 16.107l-1.52-1.52 3.783-11.35-11.35 3.783-1.52-1.52z\"\n})));\n\nfunction _extends$1h() { _extends$1h = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1h.apply(this, arguments); }\nvar DataInputIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1h({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M20.833 0H3.488v32H28V7.36L20.833 0zm-2.105 1.818v7.507h7.454v20.857H5.306V1.818h13.422zm1.818.493l5.06 5.196h-5.06V2.311zm-9.182.86v3.744H7.081v3.222h4.283v3.743l5.7-5.354-5.7-5.354zm.808 1.868l3.711 3.487-3.71 3.487V9.329H7.888V7.723h4.283V5.039z\"\n})));\n\nfunction _extends$1g() { _extends$1g = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1g.apply(this, arguments); }\nvar DataObjectIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1g({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M21.345 0H4v32h24.512V7.36L21.345 0zM19.24 1.818v7.507h7.454v20.857H5.818V1.818H19.24zm1.818.493l5.06 5.196h-5.06V2.311z\"\n})));\n\nfunction _extends$1f() { _extends$1f = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1f.apply(this, arguments); }\nvar DataOutputIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1f({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M20.833 0H3.488v32H28V7.36L20.833 0zm-2.105 1.818v7.507h7.454v20.857H5.306V1.818h13.422zm1.818.493l5.06 5.196h-5.06V2.311zm-9.182.86v3.744H7.081v3.222h4.283v3.743l5.7-5.354-5.7-5.354z\"\n})));\n\nfunction _extends$1e() { _extends$1e = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1e.apply(this, arguments); }\nvar DataStoreIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1e({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M16.008 1c-3.712 0-7.417.306-10.319.939-1.45.316-2.7.71-3.68 1.226C1.065 3.662.297 4.304.061 5.23a.823.823 0 00-.035.15L0 5.502l.017.084c-.012 7.41 0 14.46 0 22.08l.017.082c.203.985.995 1.656 1.975 2.172.98.517 2.23.91 3.68 1.226 2.902.633 6.607.94 10.319.94 3.711 0 7.416-.307 10.318-.94 1.451-.316 2.701-.71 3.68-1.226.98-.516 1.772-1.187 1.975-2.172l.017-.082V5.541a.825.825 0 000-.106v-.016l-.002-.013a.823.823 0 00-.046-.197c-.244-.916-1.007-1.55-1.943-2.044-.98-.516-2.23-.91-3.68-1.226C23.423 1.306 19.718 1 16.006 1zm0 1.646c3.62 0 7.245.308 9.968.901 1.36.297 2.497.67 3.263 1.074.612.323.932.643 1.063.882-.131.24-.451.56-1.063.882-.766.404-1.902.777-3.263 1.074-2.723.594-6.349.901-9.968.901-3.62 0-7.245-.307-9.968-.901-1.361-.297-2.497-.67-3.264-1.074-.611-.322-.931-.642-1.062-.882.13-.24.451-.56 1.062-.882.767-.403 1.903-.777 3.264-1.074 2.723-.593 6.348-.9 9.968-.9zM1.664 7.647c.112.067.227.132.345.194.98.517 2.23.91 3.68 1.226 2.902.633 6.607.94 10.319.94 3.711 0 7.416-.307 10.318-.94 1.451-.316 2.701-.71 3.68-1.226.119-.062.234-.127.346-.194v1.93c-.08.245-.398.619-1.113.995-.766.404-1.902.777-3.263 1.074-2.723.594-6.349.901-9.968.901-3.62 0-7.245-.307-9.968-.9-1.361-.298-2.497-.671-3.264-1.075-.714-.376-1.032-.75-1.112-.995v-1.93zm0 4.187c.112.067.227.132.345.195.98.516 2.23.91 3.68 1.226 2.902.632 6.607.938 10.319.938 3.711 0 7.416-.306 10.318-.938 1.451-.317 2.701-.71 3.68-1.226.119-.063.234-.128.346-.195v1.93c-.08.245-.398.619-1.113.995-.766.404-1.902.777-3.263 1.074-2.723.594-6.349.901-9.968.901-3.62 0-7.245-.307-9.968-.9-1.361-.298-2.497-.67-3.264-1.075-.714-.376-1.032-.75-1.112-.995v-1.93zm0 4.188c.112.067.227.131.345.194.98.516 2.23.91 3.68 1.226 2.902.633 6.607.939 10.319.939 3.711 0 7.416-.306 10.318-.94 1.451-.316 2.701-.709 3.68-1.225.119-.063.234-.127.346-.194V27.47c-.08.245-.398.618-1.113.995-.766.404-1.902.777-3.263 1.074-2.723.594-6.349.9-9.968.9-3.62 0-7.245-.306-9.968-.9-1.361-.297-2.497-.67-3.264-1.074-.714-.377-1.032-.75-1.112-.995V16.022z\"\n})));\n\nfunction _extends$1d() { _extends$1d = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1d.apply(this, arguments); }\nvar DefaultFlowIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1d({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M32 .06S20.33 6.014 14.403 8.798c1.27 1.16 2.451 2.41 3.676 3.616L6.84 23.804H.046v1.755h5.063L0 30.735 1.325 32l6.357-6.441h7.145v-1.756H9.414l9.99-10.123c1.228 1.223 2.45 2.453 3.677 3.676C26.247 11.12 32 .06 32 .06z\"\n})));\n\nfunction _extends$1c() { _extends$1c = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1c.apply(this, arguments); }\nvar EndEventCancelIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1c({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.676.051C7.943.058.834 6.501.104 14.21c-.783 6.565 2.912 13.427 8.942 16.216 5.6 2.737 12.789 1.87 17.434-2.344 4.725-4.09 6.79-11.06 4.714-17.006C29.22 5.009 23.394.364 16.978.083A18.532 18.532 0 0015.676.05zm.317 5.006c5.695-.165 10.916 4.858 10.983 10.555.246 5.212-3.67 10.33-8.864 11.204-5.026 1.007-10.6-1.898-12.36-6.777-1.894-4.826.039-10.928 4.649-13.46a11.082 11.082 0 015.592-1.522zm-3.955 3.918L8.94 12.072l3.985 3.985-3.913 3.913 3.048 3.047 3.913-3.913 3.987 3.987 3.096-3.096-3.987-3.987 3.913-3.913-3.047-3.048-3.913 3.913-3.985-3.985z\"\n})));\n\nfunction _extends$1b() { _extends$1b = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1b.apply(this, arguments); }\nvar EndEventCompensationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1b({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.676.051C7.943.058.834 6.501.104 14.21c-.783 6.565 2.912 13.427 8.942 16.216 5.6 2.737 12.789 1.87 17.434-2.344 4.725-4.09 6.79-11.06 4.714-17.006C29.22 5.009 23.394.364 16.978.083A18.532 18.532 0 0015.676.05zm.317 5.006c5.695-.165 10.916 4.858 10.983 10.555.246 5.212-3.67 10.33-8.864 11.204-5.026 1.007-10.6-1.898-12.36-6.777-1.894-4.826.039-10.928 4.649-13.46a11.082 11.082 0 015.592-1.522zm-.56 5.744l-7.407 5.23 7.408 5.234v-5.057c2.384 1.687 4.771 3.371 7.157 5.057V10.801l-7.157 5.054v-5.054z\"\n})));\n\nfunction _extends$1a() { _extends$1a = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1a.apply(this, arguments); }\nvar EndEventErrorIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1a({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.676.051C7.943.058.834 6.501.104 14.21c-.783 6.565 2.912 13.427 8.942 16.216 5.6 2.737 12.789 1.87 17.434-2.344 4.725-4.09 6.79-11.06 4.714-17.006C29.22 5.009 23.394.364 16.978.083A18.532 18.532 0 0015.676.05zm.317 5.006c5.695-.165 10.916 4.858 10.983 10.555.246 5.212-3.67 10.33-8.864 11.204-5.026 1.007-10.6-1.898-12.36-6.777-1.894-4.826.039-10.928 4.649-13.46a11.082 11.082 0 015.592-1.522zm6.132 4.166l-3.633 7.363-4.516-5.874-4.102 12.131 4.599-5.91 4.743 5.427 2.909-13.137z\"\n})));\n\nfunction _extends$19() { _extends$19 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$19.apply(this, arguments); }\nvar EndEventEscalationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$19({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.676.051C7.943.058.834 6.501.104 14.21c-.783 6.565 2.912 13.427 8.942 16.216 5.6 2.737 12.789 1.87 17.434-2.344 4.725-4.09 6.79-11.06 4.714-17.006C29.22 5.009 23.394.364 16.978.083A18.532 18.532 0 0015.676.05zm.317 5.006c5.695-.165 10.916 4.858 10.983 10.555.246 5.212-3.67 10.33-8.864 11.204-5.026 1.007-10.6-1.898-12.36-6.777-1.894-4.826.039-10.928 4.649-13.46a11.082 11.082 0 015.592-1.522zm.006 3.9c-1.672 4.653-2.733 9.5-4.406 14.153 1.535-1.525 2.872-3.234 4.406-4.759l4.406 4.76c-1.497-4.71-2.91-9.445-4.406-14.155z\"\n})));\n\nfunction _extends$18() { _extends$18 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$18.apply(this, arguments); }\nvar EndEventLinkIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$18({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.676 0C7.943.007.834 6.45.104 14.16c-.783 6.565 2.912 13.427 8.942 16.216 5.6 2.737 12.789 1.87 17.434-2.344 4.725-4.09 6.79-11.06 4.714-17.006C29.22 4.958 23.394.313 16.978.032A18.532 18.532 0 0015.676 0zm.317 5.006c5.695-.165 10.916 4.858 10.983 10.555.246 5.212-3.67 10.33-8.864 11.204-5.026 1.007-10.6-1.898-12.36-6.777-1.894-4.826.039-10.928 4.649-13.46a11.082 11.082 0 015.592-1.522zm1.78 4.065v3.555H9.779v6.713h7.994v3.554l5.828-6.91-5.828-6.912z\"\n})));\n\nfunction _extends$17() { _extends$17 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$17.apply(this, arguments); }\nvar EndEventMessageIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$17({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.676 0C7.943.007.834 6.45.104 14.16c-.783 6.565 2.912 13.427 8.942 16.216 5.6 2.737 12.789 1.87 17.434-2.344 4.725-4.09 6.79-11.06 4.714-17.006C29.22 4.958 23.394.313 16.978.032A18.532 18.532 0 0015.676 0zm.317 5.006c5.695-.165 10.916 4.858 10.983 10.555.246 5.212-3.67 10.33-8.864 11.204-5.026 1.007-10.6-1.898-12.36-6.777-1.894-4.826.039-10.928 4.649-13.46a11.082 11.082 0 015.592-1.522zm-5.91 5.448l6.041 4.9 6.04-4.9H10.084zm-1.34 1.137v9.92h14.513v-9.718l-7.132 5.786-7.381-5.988z\"\n})));\n\nfunction _extends$16() { _extends$16 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$16.apply(this, arguments); }\nvar EndEventMultipleIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$16({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.676 0C7.943.007.834 6.45.104 14.16c-.783 6.565 2.912 13.427 8.942 16.216 5.6 2.737 12.789 1.87 17.434-2.344 4.725-4.09 6.79-11.06 4.714-17.006C29.22 4.958 23.394.313 16.978.032A18.529 18.529 0 0015.676 0zm.317 5.006c5.695-.165 10.916 4.858 10.983 10.555.246 5.212-3.67 10.33-8.864 11.204-5.026 1.007-10.6-1.898-12.36-6.777-1.894-4.826.039-10.928 4.649-13.46a11.082 11.082 0 015.592-1.522zm.011 3.039l-7.619 5.53 2.91 8.95h9.418l2.91-8.95-7.619-5.53z\"\n})));\n\nfunction _extends$15() { _extends$15 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$15.apply(this, arguments); }\nvar EndEventNoneIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$15({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.84.042C8.654-.01 1.913 5.437.4 12.454-1.057 18.62 1.554 25.495 6.784 29.09c5.076 3.636 12.31 3.92 17.59.544 5.309-3.251 8.435-9.744 7.445-15.921C30.91 7.307 25.795 1.738 19.442.422a16.064 16.064 0 00-3.602-.38zm.382 5.01c5.28-.017 10.13 4.353 10.669 9.61.687 5.025-2.552 10.281-7.423 11.792-4.754 1.617-10.486-.447-12.962-4.856-2.74-4.575-1.574-11.094 2.768-14.27a11.05 11.05 0 016.948-2.276z\"\n})));\n\nfunction _extends$14() { _extends$14 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$14.apply(this, arguments); }\nvar EndEventSignalIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$14({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.676.051C7.943.058.834 6.501.104 14.21c-.783 6.565 2.912 13.427 8.942 16.216 5.6 2.737 12.789 1.87 17.434-2.344 4.725-4.09 6.79-11.06 4.714-17.006C29.22 5.009 23.394.364 16.978.083A18.532 18.532 0 0015.676.05zm.317 5.006c5.695-.165 10.916 4.858 10.983 10.555.246 5.212-3.67 10.33-8.864 11.204-5.026 1.007-10.6-1.898-12.36-6.777-1.894-4.826.039-10.928 4.649-13.46a11.082 11.082 0 015.592-1.522zm.006 3.492c-2.261 4.07-4.532 8.136-6.797 12.204h13.595L15.999 8.55z\"\n})));\n\nfunction _extends$13() { _extends$13 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$13.apply(this, arguments); }\nvar EndEventTerminateIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$13({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.676.051C7.943.058.834 6.501.104 14.21c-.783 6.565 2.912 13.427 8.942 16.216 5.6 2.737 12.789 1.87 17.434-2.344 4.725-4.09 6.79-11.06 4.714-17.006C29.22 5.009 23.394.364 16.978.083A18.532 18.532 0 0015.676.05zm.317 5.006c5.695-.165 10.916 4.858 10.983 10.555.246 5.212-3.67 10.33-8.864 11.204-5.026 1.007-10.6-1.898-12.36-6.777-1.894-4.826.039-10.928 4.649-13.46a11.082 11.082 0 015.592-1.522zm.006 2.859c-5.264-.2-9.495 5.551-7.755 10.516 1.366 5.085 8.108 7.436 12.339 4.301 4.455-2.807 4.708-9.943.462-13.058A8.128 8.128 0 0016 7.915z\"\n})));\n\nfunction _extends$12() { _extends$12 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$12.apply(this, arguments); }\nvar EventSubProcessExpandedIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$12({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M7.295 4.78h1.779V3.003h-1.78V4.78zm3.558 0h1.779V3.003h-1.78V4.78zm3.557 0h1.78V3.003h-1.78V4.78zm3.558 0h1.78V3.003h-1.78V4.78zm3.558 0h1.779V3.003h-1.779V4.78zm3.558 0c.55.014 1.106-.034 1.654.045l.245-1.762c-.629-.096-1.266-.05-1.9-.061V4.78zM5.732 3.004a5.933 5.933 0 00-.915.093c.111.582.226 1.164.315 1.75.358-.101.947.098.746-.483-.096-.382.164-1.208-.146-1.36zm22.372 2.281c.427.234.812.547 1.13.915.42-.4 1.002-.777 1.33-1.18a5.863 5.863 0 00-1.593-1.289l-.867 1.554zm-25.27-1.44c-.587.354-1.11.811-1.539 1.345.47.333.96.86 1.417 1.077.299-.362.66-.673 1.065-.913-.328-.493-.55-1.055-.944-1.509zM30.515 7.26c-.563.046-.557.342-.378.784.154.25-.097.862.25.85.525-.023 1.14.043 1.612-.032a5.891 5.891 0 00-.362-2.027l-1.122.425zM.268 7.114A6.042 6.042 0 000 9.052h1.78c-.013-.5.047-1.003.208-1.478L.296 7.027l-.026.079-.002.008zM30.22 12.45H32v-1.779h-1.779v1.779zm-30.22.16h1.78v-1.779H0v1.78zm30.22 3.398H32v-1.78h-1.779v1.78zm-30.22.16h1.78v-1.779H0v1.779zm30.22 3.398H32v-1.78h-1.779v1.78zm-30.22.16h1.78v-1.78H0v1.78zm30.22 3.397H32v-1.779h-1.779v1.78zm-30.22.16h1.78v-1.778H0v1.778zm30.137 1.47a4.059 4.059 0 01-.522 1.32c.506.283 1.046.715 1.53.908a5.836 5.836 0 00.744-1.918c-.576-.094-1.209-.264-1.752-.31zm-29.984.51c.157.676.435 1.325.82 1.904l1.486-.977a4.065 4.065 0 01-.577-1.347l-1.73.42zm28.427 1.943c-.371.277-.79.49-1.234.627l.548 1.693a5.84 5.84 0 001.835-.96l-1.082-1.412-.066.05-.001.002zm-26.164 1.47c.567.413 1.21.722 1.886.907.14-.569.343-1.175.444-1.722a4.062 4.062 0 01-1.283-.624l-1.047 1.438zm3.88 1.119h1.779v-1.78h-1.78v1.78zm3.55 0h1.787v-1.78H9.846v1.78zm3.565 0h1.78v-1.78h-1.78v1.78zm3.558 0h1.78v-1.78h-1.78v1.78zm3.451 0h1.743v-1.78h-1.743v1.78zm3.665 0h1.779v-1.78h-1.78v1.78zm-1.922-.545V16.776H9.846V29.25h12.318zM10.967 17.905h10.068V27.97H10.967V17.905zm1.336 3.998v1.711h7.396v-1.711h-7.396z\",\n  opacity: \".97\"\n})));\n\nfunction _extends$11() { _extends$11 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$11.apply(this, arguments); }\nvar GatewayComplexIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$11({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M16.001 0a1.29 1.29 0 00-.917.373L.373 15.084a1.316 1.316 0 00.002 1.834l14.71 14.709a1.313 1.313 0 001.833 0l14.711-14.711a1.316 1.316 0 00-.002-1.834L16.917.372A1.294 1.294 0 0016.002 0zM16 2.181l13.821 13.821L16 29.823 2.179 16.003 16 2.18zm-.327 6.79v.007l-.145.027-.118.08-.083.123-.028.145v4.954L11.793 10.8l-.125-.08-.14-.029-.144.027-.122.082-.46.46-.085.125-.026.142.028.14.08.125 3.505 3.505H9.347l-.001-.002-.145.032-.118.08-.083.122-.028.146v.652l.029.147.082.119.12.08.144.032h4.956L10.8 20.207v-.001l-.084.124-.026.142.028.14.08.124.46.461.126.082.14.029.143-.027.124-.084L15.3 17.69v4.964-.001l.028.147.082.12.12.08.144.031h.652l.148-.03.118-.08.083-.12.028-.146v-4.962l3.505 3.505.126.082.14.027.142-.027.124-.084.461-.46.083-.123s.028-.144.027-.146l-.028-.14-.082-.126-3.496-3.496h4.948l.148-.03.119-.08.082-.12.028-.147v-.652l-.028-.145-.083-.122-.119-.08s-.147-.033-.147-.031h-4.964l3.512-3.512.082-.122.029-.144-.028-.14-.084-.124-.46-.461-.123-.082-.14-.027-.145.027-.122.082-3.507 3.507V9.348l-.028-.146-.082-.122-.12-.08-.147-.029h-.652z\"\n})));\n\nfunction _extends$10() { _extends$10 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$10.apply(this, arguments); }\nvar GatewayEventBasedIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$10({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M16 0a1.29 1.29 0 00-.918.373L.371 15.084a1.316 1.316 0 00.002 1.834l14.71 14.709a1.313 1.313 0 001.833 0l14.711-14.711a1.316 1.316 0 00-.002-1.834L16.915.372A1.294 1.294 0 0016 0zm-.002 2.181l13.821 13.821-13.821 13.821-13.821-13.82L15.998 2.18zm0 5.876l-.254.185-7.377 5.355 2.915 8.964h9.433l2.915-8.964-7.631-5.54zm0 1.07l6.614 4.8-2.526 7.769h-8.175l-2.526-7.768 6.614-4.802z\"\n})));\n\nfunction _extends$$() { _extends$$ = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$$.apply(this, arguments); }\nvar GatewayNoneIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$$({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M.373 15.084a1.316 1.316 0 00.002 1.834l14.71 14.709a1.313 1.313 0 001.833 0l14.711-14.711a1.316 1.316 0 00-.002-1.834L16.917.373a1.313 1.313 0 00-1.833 0L.373 15.084zm1.806.918L16 2.182l13.821 13.82L16 29.823 2.179 16.003z\"\n})));\n\nfunction _extends$_() { _extends$_ = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$_.apply(this, arguments); }\nvar GatewayOrIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$_({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M16.001 0a1.29 1.29 0 00-.917.373L.373 15.084a1.316 1.316 0 00.002 1.834l14.71 14.709a1.313 1.313 0 001.833 0l14.711-14.711a1.316 1.316 0 00-.002-1.834L16.917.372A1.294 1.294 0 0016.002 0zM16 2.181l13.821 13.821L16 29.823 2.179 16.003 16 2.18zm0 6.379a7.447 7.447 0 00-7.44 7.441A7.447 7.447 0 0016 23.443 7.447 7.447 0 0023.443 16a7.447 7.447 0 00-7.441-7.441zm0 .825a6.61 6.61 0 016.617 6.616A6.61 6.61 0 0116 22.618 6.61 6.61 0 019.385 16 6.61 6.61 0 0116 9.385z\"\n})));\n\nfunction _extends$Z() { _extends$Z = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$Z.apply(this, arguments); }\nvar GatewayParallelIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$Z({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M16.001 0a1.29 1.29 0 00-.917.373L.373 15.084a1.316 1.316 0 00.002 1.834l14.71 14.709a1.313 1.313 0 001.833 0l14.711-14.711a1.316 1.316 0 00-.002-1.834L16.917.372A1.294 1.294 0 0016.002 0zM16 2.181l13.821 13.821L16 29.823 2.179 16.003 16 2.18zm-.377 5.708l-.168.032-.136.092-.096.14-.032.168v6.868h-6.87l-.002-.002-.166.037-.137.092v-.002l-.095.141-.033.167v.753s.032.169.034.17l.094.138.138.092.167.036h6.87v6.867l-.001-.001.033.17.095.138.138.092s.166.035.167.037h.752l.17-.036.137-.092.095-.137.033-.17v-6.867h6.868l.17-.035.137-.092.095-.137.033-.17v-.753s-.033-.165-.032-.167l-.096-.14-.138-.093s-.17-.037-.17-.035H16.81V8.323l-.033-.168-.094-.14-.138-.092-.17-.034h-.752z\"\n})));\n\nfunction _extends$Y() { _extends$Y = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$Y.apply(this, arguments); }\nvar GatewayXorIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$Y({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M16 0a1.29 1.29 0 00-.918.373L.371 15.084a1.316 1.316 0 00.002 1.834l14.71 14.709a1.313 1.313 0 001.833 0l14.711-14.711a1.316 1.316 0 00-.002-1.834L16.915.372A1.294 1.294 0 0016 0zm-.002 2.181l13.821 13.821-13.821 13.821-13.821-13.82L15.998 2.18zm-5.162 7.69l-.166.032-.141.096-.532.532s-.097.142-.097.144l-.03.164.032.162.093.144 4.857 4.858-4.855 4.855v-.001L9.9 21l-.03.164.032.162s.093.142.093.144l.531.532.146.095.162.032.164-.03.144-.097 4.855-4.856 4.857 4.857.145.095.162.032.164-.03.144-.097.531-.532.095-.14.033-.168-.033-.162-.095-.146L17.144 16 22 11.144l.095-.14.033-.166-.033-.163-.097-.144-.532-.532-.14-.095-.163-.032-.166.032-.141.095L16 14.855l-4.858-4.858v-.002l-.144-.092-.162-.032z\"\n})));\n\nfunction _extends$X() { _extends$X = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$X.apply(this, arguments); }\nvar GroupIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$X({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M6.34.016c-2.333.025-4.684 1.77-5.29 4.17C.608 5.848.88 7.608.804 9.314v2.922h2.041c.038-2.332-.076-4.673.062-7C3.14 3.355 4.869 1.938 6.643 2.04h8.956V.009c-3.086 0-6.173-.02-9.258 0v.007zm13.094 2.023h1.92V.009h-1.92v2.03zm5.756 0c1.265-.069 2.66.045 3.602 1.055 1.036.983 1.201 2.523 1.122 3.91v6.313h2.078c-.03-2.677.062-5.36-.047-8.032-.17-2.743-2.62-5.111-5.215-5.236-.511-.064-1.027-.02-1.54-.033v2.023zM.803 18.319h2.041v-2.026H.804v2.026zm29.11 1.084h2.08v-2.03h-2.08v2.03zM.804 26.148c.004 2.218 1.393 4.366 3.313 5.28 1.728.853 3.681.448 5.521.544.43-.112 1.29.231 1.435-.183v-1.847c-1.788-.043-3.584.094-5.365-.082-1.67-.354-2.919-2.048-2.863-3.844v-3.644H.804v3.777zm29.11-.068c.04 1.961-1.508 3.787-3.381 3.842-1.954.06-3.914.02-5.87.026v2.03c2.118-.042 4.242.08 6.355-.063 2.524-.264 4.818-2.644 4.94-5.323.08-1.039.014-2.085.035-3.126h-2.078v2.613zm-15.006 5.898h1.92v-2.03h-1.92v2.03z\"\n})));\n\nfunction _extends$W() { _extends$W = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$W.apply(this, arguments); }\nvar IntermediateEventCatchCancelIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$W({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.049C8.195-.111.935 6.286.125 14.03c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.93 23.445.454 17.201.095c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.22.872 11.725 4.985 6.962c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.215-2.282-2.022-5.3-3.217-8.357-3.22zM16 5.021c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.082 11.082 0 0116 5.021zm-3.956 3.946l-3.096 3.097 3.985 3.985-3.913 3.913 3.047 3.048 3.913-3.913 3.988 3.987 3.097-3.096L19.076 16l3.914-3.913-3.048-3.048-3.913 3.913-3.986-3.985zm-.002 1.222l3.988 3.987 3.913-3.913 1.826 1.826-3.913 3.913 3.985 3.986-1.873 1.873-3.985-3.985-3.913 3.913-1.827-1.827 3.914-3.913-3.988-3.987 1.873-1.873z\"\n})));\n\nfunction _extends$V() { _extends$V = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$V.apply(this, arguments); }\nvar IntermediateEventCatchCompensationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$V({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.049C8.195-.11.935 6.286.125 14.03c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.93 23.445.453 17.201.095c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.22.872 11.725 4.985 6.962c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.216-2.282-2.021-5.3-3.216-8.357-3.22zM16 5.021c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.083 11.083 0 0116 5.021zm-.56 5.772l-7.408 5.231 7.409 5.234v-5.057c2.385 1.687 4.771 3.371 7.157 5.057V10.793l-7.157 5.055v-5.055zm-.865 1.665v7.125l-5.048-3.562 5.048-3.563zm7.161 0v7.132l-5.048-3.566 5.048-3.566z\"\n})));\n\nfunction _extends$U() { _extends$U = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$U.apply(this, arguments); }\nvar IntermediateEventCatchConditionIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$U({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.97.04h-.127C8.713-.018 2.003 5.334.437 12.286c-1.51 6.123.98 13.005 6.136 16.665 5.125 3.788 12.546 4.105 17.912.623 5.272-3.276 8.33-9.766 7.325-15.916-.904-6.241-5.79-11.7-11.95-13.143A16.082 16.082 0 0015.97.04zm-.181 1.724c.115 0 .23 0 .347.003 6.625-.066 12.823 5.149 13.89 11.69 1.13 5.91-1.908 12.349-7.262 15.138-5.473 3.013-12.866 1.884-17.116-2.726C1.291 21.372.444 13.914 3.802 8.602c2.493-4.112 7.169-6.819 11.987-6.838zm.283 1.554c-.117 0-.234.002-.351.005-6.1 0-11.691 5.049-12.346 11.114-.78 5.684 2.795 11.612 8.218 13.52 5.139 1.943 11.416.101 14.624-4.38 3.461-4.583 3.262-11.538-.596-15.831-2.36-2.747-5.924-4.423-9.549-4.428zm-.078 1.695c.078 0 .156 0 .234.003 5.4 0 10.321 4.556 10.734 9.942.563 5.13-2.958 10.364-7.971 11.678-4.832 1.41-10.457-.935-12.746-5.446-2.463-4.559-1.2-10.795 3.014-13.883a11.072 11.072 0 016.735-2.294zm-5.352 4.266V22.761h10.716V9.279H10.642zm.863.866h8.987v11.75h-8.987v-11.75zm.927 1.323v.862h7.133v-.862h-7.133zm0 2.602v.866h7.133v-.866h-7.133zm0 3.008v.862h7.133v-.862h-7.133zm0 2.717v.863h7.133v-.863h-7.133z\"\n})));\n\nfunction _extends$T() { _extends$T = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$T.apply(this, arguments); }\nvar IntermediateEventCatchErrorIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$T({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.049C8.195-.11.935 6.286.125 14.03c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.93 23.445.453 17.201.095c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.22.872 11.725 4.985 6.962c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.216-2.282-2.021-5.3-3.216-8.357-3.22zM16 5.021c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.083 11.083 0 0116 5.021zm6.132 4.194c-1.21 2.455-2.422 4.91-3.633 7.364l-4.516-5.875-4.103 12.133 4.6-5.912c1.58 1.81 3.162 3.619 4.744 5.429L22.13 9.215zM14.383 13.1l4.295 5.445 1.073-2.387-1.027 4.131-4.384-5.157-1.778 2.75 1.821-4.782z\"\n})));\n\nfunction _extends$S() { _extends$S = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$S.apply(this, arguments); }\nvar IntermediateEventCatchEscalationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$S({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.049C8.195-.11.935 6.286.125 14.03c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.93 23.445.453 17.201.095c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.22.872 11.725 4.985 6.962c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.216-2.282-2.021-5.3-3.216-8.357-3.22zM16 5.021c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.083 11.083 0 0116 5.021zm.006 3.927c-1.672 4.654-2.734 9.502-4.406 14.155 1.534-1.525 2.872-3.234 4.406-4.759l4.406 4.76c-1.496-4.71-2.91-9.446-4.406-14.156zm.032 2.929c.822 2.586 1.598 5.186 2.42 7.771l-2.42-2.612c-.682.597-2.452 2.884-2.338 2.388.87-2.487 1.447-5.067 2.338-7.547z\"\n})));\n\nfunction _extends$R() { _extends$R = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$R.apply(this, arguments); }\nvar IntermediateEventCatchLinkIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$R({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.049C8.195-.11.935 6.286.125 14.03c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.93 23.445.453 17.201.095c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.22.872 11.725 4.985 6.962c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.216-2.282-2.021-5.3-3.216-8.357-3.22zM16 5.021c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.083 11.083 0 0116 5.021zm1.78 4.093v3.555H9.785v6.714h7.994v3.554l5.829-6.911-5.83-6.912zm.974 2.584l3.61 4.295-3.61 4.294v-1.933h-7.88v-4.688h7.88v-1.968z\"\n})));\n\nfunction _extends$Q() { _extends$Q = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$Q.apply(this, arguments); }\nvar IntermediateEventCatchMessageIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$Q({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.049C8.195-.11.935 6.286.125 14.03c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.93 23.445.453 17.201.095c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.22.872 11.725 4.985 6.962c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.216-2.282-2.021-5.3-3.216-8.357-3.22zM16 5.021c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.083 11.083 0 0116 5.021zm-7.245 5.475v11.06h14.502v-11.06H8.754zm3.222 1.728h8.057c-1.427.878-2.854 2.806-4.281 3.016l-3.776-3.016zm9.554 1.017v6.587H10.48V13.24l5.524 4.414 5.526-4.414z\"\n})));\n\nfunction _extends$P() { _extends$P = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$P.apply(this, arguments); }\nvar IntermediateEventCatchMultipleIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$P({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.003C8.195-.156.935 6.24.125 13.985c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.884 23.445.407 17.201.049c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.174.872 11.679 4.985 6.916c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.216-2.282-2.021-5.3-3.216-8.357-3.22zM16 4.975c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.083 11.083 0 0116 4.975zm.006 3.073l-7.62 5.531 2.91 8.95h9.42l2.91-8.95-7.62-5.53zm0 1.067l6.604 4.794-2.523 7.757h-8.162l-2.522-7.757 6.603-4.794z\"\n})));\n\nfunction _extends$O() { _extends$O = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$O.apply(this, arguments); }\nvar IntermediateEventCatchNonInterruptingConditionIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$O({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M10.638 9.563V23.056h10.724V9.563H10.638zm.863.866h8.995v11.76H11.5V10.43zm.928 1.324v.862h7.139v-.862h-7.14zm0 2.605v.866h7.139v-.866h-7.14zm0 3.01v.863h7.139v-.863h-7.14zm0 2.72v.863h7.139v-.864h-7.14zM15.999.308h-.004l-.188.001h-.011l-.188.004h-.011L15.41.32h-.011l-.187.008h-.005L15.2.33l-.187.01h-.005l-.005.001-.187.013h-.011L14.62.37h-.01l-.186.018h-.011l-.185.02-.005.001h-.006l-.185.022-.005.001h-.005l-.185.025h-.005l-.005.001-.185.027h-.005l-.005.001-.184.029h-.005l-.005.001-.183.031-.006.001-.005.001-.182.033-.006.001-.005.001-.182.035-.005.001-.005.001-.182.038h-.005l-.005.002-.181.04h-.005l-.005.002-.18.042-.006.001-.005.001-.18.044-.005.002h-.005l-.17.045-.152.054-.139.082-.121.106-.1.127-.074.143-.046.155-.017.16.013.16.043.156.07.145.097.13.119.108.137.085.15.058.159.03.16-.001.133-.023.165-.043.168-.041.171-.04.171-.037.172-.036.17-.033.173-.03.17-.03.177-.027.171-.025.175-.022.175-.02.175-.02.176-.016.175-.014.177-.012.176-.01.177-.007.174-.006.177-.003.178-.001h.177l.178.004.174.006.177.007.176.01.177.012.175.014.176.017.175.018.175.02.175.023.171.025.176.027.17.03.174.03.17.033.171.036.154.033.16.02.161-.01.156-.04.146-.069.131-.094.111-.117.087-.135.061-.15.032-.158.002-.16-.027-.16-.057-.15L20 1.023l-.108-.12-.128-.097-.145-.073-.128-.038-.158-.035-.005-.001-.005-.001L19.14.62h-.005l-.005-.002-.182-.035h-.006L18.938.58l-.182-.033h-.006l-.005-.002-.183-.03-.005-.001-.006-.001-.183-.029h-.005l-.006-.001-.184-.027h-.005l-.005-.001-.185-.024h-.005L17.968.43 17.783.41l-.006-.001h-.005l-.185-.02h-.006l-.005-.001L17.39.37h-.005L17.38.368l-.187-.015h-.005l-.005-.001-.187-.013h-.011L16.8.328h-.011L16.6.32h-.011l-.187-.006h-.011L16.204.31h-.011L16.005.31H16zm9.016 2.935l-.16.004-.158.033-.15.062-.134.09-.116.111-.093.132-.067.147-.038.156-.01.161.022.16.05.153.078.141.103.124.102.087.045.034.142.106.137.105.14.11.136.11.135.112.134.115.134.117.13.115.132.122.128.12.127.122.126.125.124.126.124.128.121.13.118.128.118.132.117.133.113.134.113.136.11.136.109.137.109.142.104.14.103.14.101.142.1.144.099.146.095.145.094.147.093.15.092.15.087.149.087.15.084.152.084.155.08.152.08.155.04.081.084.138.11.119.128.096.145.072.155.043.16.013.16-.016.155-.046.144-.074.127-.099.106-.12.083-.14.055-.151.026-.16-.004-.16-.034-.158-.05-.124-.042-.085-.002-.004-.003-.005-.084-.165-.002-.004-.003-.005-.086-.164-.002-.004-.003-.005-.088-.162-.002-.005-.003-.005-.09-.161-.002-.005-.003-.004-.092-.16-.003-.005-.002-.005-.094-.16-.003-.004-.003-.004-.096-.159-.002-.004-.003-.005-.098-.157-.003-.004-.003-.005-.1-.156-.003-.004-.003-.005-.101-.154-.003-.005-.003-.004-.104-.154-.003-.004-.003-.005-.106-.152-.003-.005-.003-.004-.108-.151-.003-.004-.003-.005-.11-.15-.003-.004-.003-.004-.111-.15-.004-.003-.003-.005-.113-.147-.004-.004-.003-.005-.115-.146-.004-.004-.003-.004-.117-.145-.004-.004-.003-.004-.12-.144-.003-.004-.003-.004-.121-.142-.004-.004-.003-.004-.123-.141-.003-.004-.004-.004-.125-.14-.003-.004-.004-.004-.127-.138-.003-.004-.004-.004-.128-.136-.004-.004-.004-.004-.13-.135-.004-.004-.004-.004-.132-.134-.003-.004-.004-.003-.134-.133-.004-.003-.004-.004-.135-.13-.004-.004-.004-.004-.136-.128-.004-.004-.004-.004-.138-.126-.004-.004-.004-.003-.14-.125-.004-.004-.004-.003-.14-.123-.005-.004-.004-.003-.142-.121-.004-.004-.004-.003-.144-.12-.004-.003-.004-.003-.145-.117-.004-.004-.004-.003-.147-.115-.004-.004-.004-.003-.148-.113-.004-.003-.004-.004-.149-.111-.004-.003-.004-.004-.05-.036-.14-.083-.15-.055-.16-.027zm-18.381.344l-.161.008-.157.037-.147.066-.111.074-.04.032-.005.003-.004.004-.145.117-.004.003-.004.004-.144.119-.004.003-.004.004-.142.12-.004.004-.004.004-.141.123-.004.003-.004.004-.14.125-.004.003-.004.004-.138.126-.004.004-.004.004-.136.128-.004.004-.004.004-.135.13-.004.004-.004.003-.134.133-.004.003L4.682 5l-.132.134-.003.004-.004.004-.13.135-.004.004-.004.004-.128.136-.004.004-.004.004-.126.138-.004.004-.003.004-.125.14-.004.004-.003.004-.123.14-.004.005-.003.004-.121.142-.004.004-.003.004-.12.144-.003.004-.003.004-.117.145-.004.004-.003.004-.115.146-.004.005-.003.004-.113.147-.003.005-.004.004-.111.149-.003.004-.004.004-.11.15-.002.005-.003.004-.108.151-.003.004-.003.005-.106.152-.003.005-.003.004-.104.154-.003.004-.003.005-.102.154-.003.005-.002.004-.1.156-.003.005-.003.004-.098.157-.003.005-.003.004-.096.159-.002.004-.003.005-.094.16-.003.004-.002.004-.092.16-.003.005-.003.005-.09.161-.002.005-.003.005-.088.162-.002.005-.003.004-.086.164-.002.005-.002.004-.084.165-.003.005-.002.004-.082.166-.002.004-.003.005-.08.167-.002.004-.002.005-.078.168-.002.004-.002.005-.045.1-.053.153-.023.16.007.16.037.157.065.148.092.132.114.114.134.09.148.064.157.035.161.006.16-.025.152-.054.14-.08.121-.106.1-.126.065-.118.043-.095.074-.16.075-.155.077-.157.08-.155.08-.152.083-.155.085-.152.086-.15.088-.149.091-.15.094-.15.094-.147.095-.145.099-.146.1-.144.1-.142.104-.14.104-.14.11-.142.107-.137.11-.136.114-.136.113-.134.117-.133.118-.132.117-.129.122-.13.124-.127.123-.126.127-.125.127-.122.128-.12.132-.122.13-.115.133-.117.135-.115.135-.111.136-.11.037-.03.117-.11.094-.132.068-.146.04-.156.01-.161-.02-.16-.05-.154-.076-.141-.102-.125-.123-.104-.14-.08-.153-.051-.16-.023zM16 3.595h-.005l-.148.001h-.01l-.147.003h-.011l-.147.005h-.011l-.146.007h-.011l-.146.009h-.011l-.146.01h-.005l-.005.001-.146.012h-.011l-.145.014h-.006l-.005.001-.05.006-.158.031-.15.06-.135.088-.117.111-.094.13-.069.147-.04.156-.01.16.019.16.049.154.076.142.102.125.123.105.14.08.152.051.16.023.134-.003.045-.005.135-.013.133-.01.136-.01.135-.007.137-.006.136-.004.136-.003h.274l.136.003.136.004.136.006.136.007.136.01.133.01.135.013.135.014.135.016.134.018.132.018.134.021.133.023.133.024.133.025.13.027.132.03.132.03.129.031.13.034.129.035.129.036.13.04.126.038.128.042.126.042.128.045.127.047.126.047.12.048.127.051.123.052.006.002.147.048.16.021.16-.009.157-.038.147-.067.131-.093.112-.116.089-.135.062-.149.033-.158.004-.16-.027-.16-.055-.151-.083-.139-.107-.12-.127-.099-.118-.063-.004-.001-.005-.003-.005-.002-.133-.056-.005-.002-.005-.002-.134-.054-.004-.002-.005-.002-.135-.053-.005-.002-.005-.002-.135-.051-.005-.002-.005-.002-.135-.05-.005-.001-.005-.002-.137-.048-.005-.001-.005-.002-.137-.046-.005-.002-.005-.002-.137-.044-.005-.002-.005-.001-.138-.043-.006-.002-.005-.001-.138-.042-.005-.001-.005-.002-.14-.04H19.4l-.005-.002-.14-.038-.005-.001-.005-.002-.14-.036-.005-.001-.005-.001-.141-.035-.005-.001-.005-.001-.142-.033-.005-.001-.005-.001-.142-.031-.005-.002h-.005l-.142-.03-.005-.001-.005-.001-.143-.028h-.005l-.005-.002-.143-.025-.006-.001-.005-.001-.143-.024-.005-.001-.006-.001-.143-.022-.006-.001h-.005l-.144-.022h-.005l-.006-.001-.144-.019h-.005l-.006-.001-.144-.017h-.006l-.005-.001-.145-.016h-.011l-.145-.014H17.1l-.005-.001-.146-.012h-.01l-.146-.01-.006-.001h-.005l-.146-.009h-.011l-.147-.006h-.01L16.32 3.6h-.011l-.147-.003h-.011l-.147-.001H16zm-5.482 1.366l-.16.008-.157.037-.123.053-.06.032-.005.002-.004.003-.128.069-.004.002-.005.003-.126.07-.005.003-.004.002-.126.072-.005.003-.004.003-.125.073-.004.003-.005.003-.124.075-.004.003-.005.002-.123.077-.004.003-.005.003-.122.078-.004.003-.005.003-.121.08-.004.002-.005.003-.12.082-.005.003-.004.003-.12.083-.004.003-.004.003-.118.084-.005.003-.004.003-.118.086-.004.003-.004.003-.117.088-.004.003-.004.003-.116.089-.004.003-.004.004-.114.09-.005.003-.004.003-.113.092-.004.004-.004.003-.113.093-.004.004-.004.003-.111.095-.005.003-.004.004-.11.096-.004.004-.004.003-.11.098-.003.003-.004.004-.108.1-.004.003-.004.003-.107.101-.004.004-.004.003-.106.102-.004.004-.003.004-.105.103-.004.004-.004.004-.103.105-.004.004-.004.003-.102.106-.003.004-.004.004-.1.107-.004.004-.004.004-.099.108-.004.004-.003.004-.098.11-.003.003-.004.004-.096.11-.004.005-.003.004-.095.111-.003.004-.004.004-.093.113-.003.004-.004.004-.092.113-.003.004-.003.005-.09.114-.004.004-.003.004-.089.116-.003.004-.003.004-.088.117-.003.004-.003.004-.086.118-.003.004-.003.005-.084.118-.003.004-.003.005-.083.12-.003.003-.003.005-.082.12-.003.005-.002.004-.068.103-.076.142-.048.154-.018.16.011.161.041.156.07.146.095.13.117.11.136.086.15.06.158.03.162.002.158-.03.15-.057.138-.085.119-.109.082-.105.065-.099.075-.11.077-.113.077-.107.08-.11.08-.108.084-.108.083-.105.086-.106.086-.104.088-.104.089-.101.09-.102.093-.101.093-.099.094-.097.095-.096.098-.097.098-.095.099-.093.1-.092.103-.091.101-.089.104-.088.104-.086.106-.086.106-.083.106-.082.109-.082.108-.079.11-.078.11-.076.112-.076.112-.074.113-.072.113-.071.115-.07.115-.068.118-.067.117-.065.12-.065.054-.029.135-.088.116-.111.094-.132.068-.146.04-.156.009-.161-.02-.16-.05-.153-.078-.142-.102-.125-.123-.103-.141-.079-.153-.051-.16-.022zm13.91 2.116l-.162.008-.157.037-.147.066-.132.092-.113.116-.09.134-.063.148-.034.157-.005.162.025.159.055.152.082.138.086.103.09.09.094.098.092.099.093.1.091.103.089.101.088.104.086.104.086.106.083.105.083.108.08.108.081.11.077.107.077.112.075.111.075.114.072.113.071.113.07.114.068.118.067.115.065.118.064.117.062.117.061.121.059.119.059.122.056.121.054.12.055.125.051.123.051.125.048.123.048.127.047.126.044.125.043.128.042.129.039.126.038.13.022.076.058.15.085.137.11.119.129.096.145.07.155.043.16.013.161-.017.154-.046.144-.075.126-.1.106-.12.082-.14.055-.151.025-.16-.005-.16-.026-.132-.023-.082-.002-.005-.001-.005-.042-.139-.001-.005-.002-.005-.043-.138-.001-.005-.002-.005-.044-.137-.002-.005-.002-.005-.046-.137-.002-.005-.001-.005-.048-.137-.002-.005-.002-.005-.05-.135-.001-.005-.002-.005-.051-.135-.002-.005-.002-.005-.053-.135-.002-.005-.002-.005-.054-.133-.002-.005-.002-.005-.057-.133-.002-.005-.002-.005-.057-.132-.003-.005-.002-.005-.06-.132-.001-.005-.002-.004-.061-.132-.003-.004-.002-.005-.063-.13-.002-.005-.002-.005-.064-.13-.003-.004-.002-.005-.066-.129-.002-.004-.003-.005-.067-.128-.002-.005-.003-.004-.069-.128-.002-.004-.003-.005-.07-.126-.003-.005-.003-.004-.072-.126-.002-.005-.003-.004-.074-.125-.002-.004-.003-.005-.075-.124-.003-.004-.003-.005-.076-.123-.003-.004-.003-.005-.078-.122-.003-.004-.003-.005-.08-.121-.003-.004-.003-.005-.081-.12-.003-.005-.003-.004-.083-.12-.003-.004-.003-.004-.084-.118-.003-.005-.003-.004-.086-.118-.003-.004-.004-.004-.087-.117-.003-.004-.003-.004-.09-.116-.002-.004-.004-.004-.09-.114-.003-.005-.004-.004-.091-.113-.004-.004-.003-.004-.094-.113-.003-.004-.003-.004-.095-.111-.004-.004-.003-.004-.096-.11-.004-.005-.003-.004-.098-.11-.004-.003-.003-.004-.1-.108-.003-.004-.004-.004-.1-.107-.004-.004-.004-.004-.102-.106-.003-.003-.004-.004-.093-.095-.124-.103-.14-.08-.153-.05-.16-.023zM4.45 13.135l-.161.002-.158.032-.15.06-.135.088-.118.11-.094.131-.069.146-.035.129-.026.132v.005l-.002.005-.025.143-.001.005-.001.006-.024.143-.001.005-.001.006-.022.143-.001.006-.001.005-.02.144-.001.005-.001.005-.019.145v.005l-.001.006-.017.144v.006l-.001.005-.016.145v.011l-.014.145v.005l-.001.006-.012.146v.01l-.01.146-.001.006v.005l-.009.146v.011l-.007.146v.011l-.004.147v.011l-.003.147v.01l-.002.148v.01l.001.148v.01l.003.147v.011l.005.147v.01l.007.147v.011l.009.146v.011l.01.146v.01l.013.146v.011l.014.145v.005l.001.006.016.145v.011l.018.144v.006l.001.005.019.144v.006l.001.005.021.144v.005l.002.006.022.143v.006l.002.005.024.143v.005l.002.006.025.143.001.005.001.005.028.143.001.005.001.005.03.142v.005l.002.006.03.141.002.005.001.005.033.142v.005l.002.005.035.14v.006l.002.005.036.14.002.005.001.005.038.14.001.005.002.005.04.14v.005l.002.005.042.138.001.006.002.005.042.138.002.005.002.005.017.054.064.148.09.134.114.114.132.092.148.065.157.037.16.007.16-.023.153-.052.14-.08.123-.104.102-.125.076-.142.049-.153.02-.16-.011-.161-.031-.13-.017-.051-.039-.126-.038-.13-.037-.128-.035-.13-.033-.128-.033-.134-.03-.13-.029-.131-.026-.13-.026-.133-.024-.133-.023-.133-.02-.132-.02-.136-.017-.132-.016-.135-.014-.135-.012-.133-.012-.138-.009-.133-.007-.136-.006-.138-.004-.134-.003-.136v-.274l.003-.136.004-.134.006-.139.007-.136.01-.133.01-.138.013-.132.014-.135.016-.135.017-.132.02-.137.02-.13.023-.134.024-.133.024-.126.016-.16-.014-.161-.044-.155-.072-.145-.098-.128-.12-.108-.137-.084-.15-.057-.16-.029zm26.698 1.601l-.161.01-.157.04-.146.067-.131.093-.112.117-.088.135-.061.149-.033.157-.005.134.006.14.006.176.003.177.001.178-.001.177-.003.178-.006.177-.007.176-.01.177-.012.176-.015.176-.016.173-.018.175-.02.175-.024.174-.025.175-.026.17-.03.174-.03.173-.033.17-.036.172-.037.17-.04.17-.042.172-.043.168-.045.166-.048.169-.05.167-.052.168-.053.164-.056.166-.058.166-.06.16-.062.165-.062.158-.066.165-.068.16-.07.16-.07.158-.075.159-.074.155-.079.158-.08.158-.06.15-.03.158-.001.161.029.159.058.15.085.137.108.119.13.097.144.07.156.044.16.013.16-.017.155-.046.143-.074.127-.1.107-.12.07-.115.083-.164.003-.005.002-.004.082-.166.002-.005.003-.004.08-.167.002-.005.002-.004.078-.168.002-.005.002-.004.076-.169.002-.004.002-.005.074-.17.002-.004.002-.005.072-.17.002-.005.002-.005.07-.171.001-.005.002-.005.068-.172.002-.004.002-.005.065-.173.002-.005.002-.005.063-.173.002-.005.002-.005.06-.174.003-.005.001-.005.06-.175.001-.005.002-.005.057-.176.001-.005.002-.005.055-.177.001-.005.002-.005.052-.177.002-.005.001-.005.051-.178.001-.005.002-.005.048-.179.002-.005v-.005l.047-.179.001-.005.002-.005.044-.18v-.005l.002-.005.042-.18.001-.006.001-.005.04-.181.001-.005.001-.005.037-.182.002-.005v-.005l.036-.182v-.006l.002-.005.033-.182v-.006l.002-.005.03-.183.001-.005.001-.005.029-.184v-.005l.001-.006.027-.184v-.005l.001-.005.024-.185v-.005l.001-.005.022-.185v-.006l.001-.005.02-.185v-.006l.001-.005.017-.186v-.005l.001-.005.015-.187v-.005l.001-.005.013-.187v-.01l.01-.187.001-.006v-.005l.009-.187v-.011l.006-.187V16.7l.004-.188v-.011l.001-.188v-.01l-.001-.188v-.011l-.004-.188v-.011l-.006-.187v-.011l-.007-.145-.022-.16-.05-.152-.08-.141-.103-.124-.125-.102-.141-.077-.153-.05-.16-.02zm-30.21.572l-.161.001-.158.032-.15.06-.136.087-.117.11-.095.131-.068.146-.04.156-.012.133-.001.14v.01l.001.188v.011l.004.188v.011l.006.187v.011l.008.187v.011l.011.187v.005l.001.005.013.187v.01l.016.187v.01l.018.186v.011l.02.185.001.005v.006l.022.185.001.005v.005l.025.185v.005l.001.005.027.184v.006l.001.005.029.184v.005l.001.005.031.183.001.005.001.006.033.182.001.005.001.006.035.182.001.005.001.005.038.182v.005l.002.005.04.181v.005l.002.005.042.18.001.006.001.005.044.18.002.005v.005l.047.18.001.004.002.005.048.179.002.005.001.005.05.178.002.005.001.005.053.177.002.005.001.005.055.177.002.005.001.005.057.176.002.005.001.005.06.175.001.005.002.005.061.174.002.005.002.005.063.173.002.005.002.005.065.173.002.005.002.004.067.172.002.005.002.005.07.171.002.005.002.005.072.17.002.005.002.004.074.17.002.005.002.004.076.169.002.004.002.005.078.168.002.004.002.005.08.167.003.004.002.005.082.166.002.004.003.005.02.04.086.136.11.118.13.095.146.07.156.041.16.012.16-.019.155-.048.142-.075.126-.1.105-.123.08-.14.054-.152.024-.16-.006-.16-.036-.158-.051-.123-.018-.034-.078-.158-.074-.155-.074-.16-.071-.157-.07-.16-.068-.16-.067-.165-.062-.158-.062-.164-.059-.161-.058-.166-.056-.166-.053-.164-.052-.168-.05-.167-.048-.17-.045-.165-.043-.168-.043-.172-.039-.17-.037-.17-.036-.172-.033-.17-.03-.173-.03-.174-.027-.17-.025-.175-.022-.174-.021-.175-.018-.175-.017-.173-.014-.176-.012-.176-.01-.177-.007-.176-.006-.177-.003-.178-.001-.177v-.134l-.013-.16-.044-.156-.072-.144-.097-.129-.12-.108-.137-.085-.15-.057-.159-.028zm26.798 2.024l-.16.007-.157.038-.148.066-.132.092-.113.115-.09.134-.062.148-.03.127-.001.004-.023.134-.024.133-.026.133-.026.13-.03.132-.03.129-.032.134-.033.128-.035.13-.037.128-.038.13-.04.126-.04.128-.044.128-.044.126-.046.126-.048.126-.05.125-.05.125-.051.122-.054.123-.055.122-.056.12-.058.122-.06.12-.061.12-.063.119-.062.116-.067.119-.066.116-.069.115-.069.115-.07.113-.073.113-.074.112-.076.113-.077.112-.077.107-.08.11-.08.107-.085.11-.044.056-.088.135-.06.15-.033.158-.002.16.027.16.057.15.083.138.108.12.128.098.144.072.155.045.16.015.161-.016.155-.044.144-.073.128-.098.09-.099.05-.061.003-.004.003-.005.089-.115.003-.004.003-.005.088-.116.003-.004.003-.005.086-.117.003-.004.003-.005.084-.118.003-.004.003-.005.083-.12.003-.004.003-.004.081-.12.003-.005.003-.004.08-.121.003-.005.003-.004.078-.122.003-.005.003-.004.077-.123.002-.005.003-.004.075-.124.003-.005.003-.004.073-.125.003-.005.003-.004.072-.126.002-.004.003-.005.07-.126.003-.005.002-.005.07-.127.002-.004.002-.005.068-.128.002-.005.002-.004.066-.13.003-.004.002-.005.064-.13.002-.004.003-.005.062-.13.002-.005.003-.005.06-.13.003-.005.002-.005.06-.132.002-.005.002-.005.057-.132.003-.005.002-.005.056-.133.002-.005.002-.005.054-.134.002-.004.002-.005.053-.135.002-.005.002-.005.051-.135.002-.005.002-.005.05-.135.001-.005.002-.005.048-.137.001-.005.002-.005.046-.137.002-.005.002-.005.044-.137.002-.005.002-.005.042-.138.002-.005.001-.006.042-.138.001-.005.002-.005.04-.14v-.005l.002-.005.038-.14.001-.005.002-.005.036-.14.001-.005.001-.005.035-.141.001-.005.001-.005.033-.142.001-.005.001-.005.031-.141.001-.006.002-.005.029-.142v-.005l.002-.005.028-.143v-.005l.002-.005.025-.143.001-.006.001-.005.024-.143.001-.005.001-.006.001-.006.01-.161-.02-.16-.05-.154-.077-.141-.102-.125-.123-.104-.141-.079-.153-.051-.16-.022zM6.841 23.019l-.16.024-.152.053-.14.08-.122.105-.101.126-.076.142-.048.154-.018.16.011.161.041.156.07.146.077.109.04.048.003.004.003.004.095.111.003.004.004.004.096.11.004.005.003.004.098.109.003.004.004.004.1.108.003.004.003.004.101.107.004.004.003.004.102.105.004.004.004.004.103.105.004.004.004.003.105.104.003.004.004.003.106.102.004.004.004.004.107.1.004.004.004.004.108.099.004.003.004.004.11.098.003.003.004.004.11.096.004.003.005.004.11.095.005.003.004.004.113.093.004.003.004.004.113.091.004.004.005.003.114.09.004.004.004.003.116.089.004.003.004.003.117.088.004.003.004.003.118.086.004.003.005.003.118.084.004.003.005.003.119.083.004.003.005.003.12.081.005.003.004.003.121.08.005.003.004.003.122.078.005.003.004.003.123.076.005.003.004.003.124.075.005.003.004.003.125.073.004.003.005.002.126.073.004.002.005.003.126.07.005.003.004.002.128.07.004.002.005.002.128.067.005.003.004.002.13.066.004.002.005.003.13.064.004.002.005.003.13.062.005.002.004.003.132.06.004.003.005.002.132.06.005.002.005.002.132.057.005.002.005.002.133.057.005.002.005.002.133.054.005.002.005.002.13.05.154.045.16.016.16-.015.156-.045.144-.072.128-.098.108-.12.083-.138.057-.15.028-.16-.003-.16-.032-.159-.061-.149-.088-.135-.11-.117-.132-.094-.12-.058-.124-.049-.126-.051-.122-.051-.122-.054-.12-.054-.126-.058-.119-.057-.12-.06-.12-.06-.118-.063-.117-.064-.119-.066-.116-.066-.115-.068-.115-.07-.113-.07-.115-.074-.112-.074-.11-.075-.11-.076-.112-.08-.11-.08-.109-.081-.106-.082-.104-.082-.106-.086-.105-.087-.101-.086-.105-.091-.1-.09-.1-.091-.1-.094-.097-.094-.1-.098-.093-.095-.096-.1-.093-.098-.092-.101-.089-.1-.09-.102-.088-.104-.036-.043-.114-.114-.133-.091-.148-.065-.157-.036-.161-.006zm15.063 2.701l-.16.014-.156.044-.12.057-.06.034-.12.066-.117.064-.118.062-.12.061-.12.06-.118.057-.126.058-.12.054-.122.054-.122.05-.126.052-.125.05-.124.046-.127.047-.125.044-.129.043-.126.04-.13.042-.128.038-.127.035-.13.036-.131.034-.129.031-.132.03-.13.03-.135.027-.133.026-.13.023-.13.022-.137.021-.132.02-.134.017-.132.015-.138.015-.135.013-.133.01-.138.01-.136.007-.134.006-.136.004-.14.003-.16.018-.155.047-.142.076-.127.1-.105.122-.08.14-.054.151-.025.16.006.16.035.158.064.148.09.134.114.114.133.092.147.065.157.036.134.008.145-.002h.011l.147-.005h.01l.147-.007h.011l.146-.009h.011l.146-.01h.005l.005-.001.146-.012h.011l.145-.014h.005l.006-.001.145-.016h.011l.144-.018h.006l.005-.001.144-.02h.011l.144-.021.005-.001h.006l.143-.023.006-.001h.005l.143-.025h.005l.006-.002.143-.026h.005l.005-.002.143-.027.005-.001.005-.001.142-.03h.005l.005-.002.142-.03.005-.002.005-.001.142-.033.005-.001.005-.001.14-.035.006-.001.005-.001.14-.037h.005l.005-.002.14-.038.005-.002h.005l.14-.04.005-.002.005-.001.138-.042.005-.001.006-.002.138-.043.005-.001.005-.002.137-.044.005-.002.005-.002.137-.046.005-.002.005-.001.137-.048.005-.002.005-.002.135-.05.005-.001.005-.002.135-.051.005-.002.005-.002.135-.053.005-.002.004-.002.134-.054.005-.002.005-.002.133-.057.005-.002.005-.002.132-.057.005-.003.005-.002.132-.06.005-.001.004-.002.131-.061.005-.003.005-.002.13-.062.005-.003.005-.002.13-.064.004-.003.005-.002.128-.066.005-.002.005-.003.128-.067.005-.002.004-.003.127-.069.005-.002.005-.003.126-.07.005-.003.004-.003.065-.037.132-.093.112-.115.089-.135.062-.149.034-.157.003-.161-.026-.16-.055-.15-.082-.14-.107-.12-.127-.1-.144-.073-.154-.046-.16-.016zM6.33 27.127l-.16.023-.152.053-.14.08-.122.105-.101.126-.076.142-.048.154-.02.16.012.161.041.156.07.146.094.13.096.093.032.026.004.003.004.004.145.117.004.003.004.004.146.115.005.003.004.004.147.113.005.003.004.004.149.111.004.003.004.003.15.11.005.003.004.003.151.108.004.003.005.003.152.106.005.003.004.003.154.104.004.003.005.003.154.102.005.002.004.003.156.1.005.003.004.003.157.098.005.003.004.002.159.096.004.003.005.003.16.094.004.003.004.002.16.092.005.003.005.002.161.09.005.003.005.002.162.088.005.003.004.002.164.086.005.003.004.002.165.084.005.003.004.002.166.082.004.002.005.003.167.08.004.002.005.002.168.078.004.002.005.002.168.076.005.002.005.002.17.074.004.002.005.002.17.072.005.002.005.002.17.07.006.002.005.001.171.068.005.002.005.002.173.065.005.002.005.002.173.063.005.002.005.002.174.06.005.003.005.001.175.06.005.001.005.002.176.057.005.001.005.002.176.055.006.001.005.002.177.052.005.002.005.001.178.05.005.002.005.002.178.048.006.001.005.002.179.046.005.001.005.002.18.044h.005l.005.002.18.042.006.001.005.001.159.035.16.02.16-.01.157-.04.146-.069.13-.094.112-.117.087-.136.06-.149.033-.158.002-.161-.028-.159-.057-.15-.084-.138-.108-.12-.128-.098-.144-.072-.128-.039-.154-.033-.168-.04-.171-.041-.17-.044-.168-.046-.167-.047-.168-.05-.165-.051-.166-.054-.166-.056-.163-.057-.165-.06-.161-.062-.164-.064-.16-.065-.16-.068-.162-.07-.157-.07-.157-.074-.157-.075-.156-.077-.153-.079-.156-.082-.153-.082-.154-.086-.15-.086-.152-.09-.148-.09-.147-.092-.149-.095-.145-.095-.144-.098-.145-.1-.143-.102-.14-.103-.14-.104-.14-.108-.139-.11-.136-.11-.027-.022-.133-.091-.148-.065-.157-.036-.161-.006zm19.215.087l-.16.01-.157.039-.146.067-.11.076-.064.051-.139.11-.14.108-.14.104-.14.103-.143.101-.145.101-.144.098-.145.095-.149.095-.148.093-.147.089-.152.09-.15.086-.154.086-.153.082-.156.082-.153.079-.156.077-.157.075-.158.073-.157.071-.16.07-.16.068-.161.065-.164.064-.161.061-.165.06-.163.058-.166.056-.166.054-.166.051-.167.05-.167.047-.17.046-.168.044-.171.042-.168.039-.17.037-.11.023-.154.047-.143.075-.126.1-.106.122-.081.139-.054.152-.025.16.006.16.035.158.063.148.09.133.114.115.132.092.148.065.157.037.16.007.133-.016.115-.024.005-.001.005-.001.181-.04h.005l.005-.002.18-.042.006-.001.005-.001.18-.044.005-.002.005-.001.18-.046.004-.002h.005l.179-.05h.005l.005-.002.178-.05.005-.002.005-.002.177-.052.005-.002.005-.001.177-.055.005-.002.005-.001.176-.057.005-.002.005-.002.175-.059.005-.001.005-.002.174-.061.005-.002.005-.002.173-.063.005-.002.005-.002.173-.065.004-.002.005-.002.172-.068.005-.002.005-.002.171-.07.005-.001.005-.002.17-.072.005-.002.004-.002.17-.074.005-.002.004-.002.169-.076.004-.002.005-.002.168-.078.004-.002.005-.003.167-.08.004-.002.005-.002.166-.082.004-.002.005-.003.165-.084.004-.002.005-.003.163-.086.005-.002.005-.003.162-.088.005-.002.005-.003.161-.09.005-.002.004-.003.16-.092.005-.003.005-.002.16-.094.004-.003.004-.003.158-.096.005-.002.004-.003.158-.098.004-.003.005-.003.156-.1.004-.003.004-.003.155-.101.005-.003.004-.003.154-.104.004-.003.004-.003.153-.106.004-.003.005-.003.151-.108.004-.003.005-.003.15-.11.004-.003.004-.003.149-.112.004-.003.004-.003.148-.113.004-.004.004-.003.147-.115.004-.004.004-.003.068-.055.116-.113.092-.132.066-.147.038-.157.008-.16-.022-.16-.05-.153-.08-.14-.103-.125-.124-.102-.142-.077-.153-.05-.16-.02z\"\n})));\n\nfunction _extends$N() { _extends$N = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$N.apply(this, arguments); }\nvar IntermediateEventCatchNonInterruptingEscalationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$N({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M16.012 9.222c-1.673 4.657-2.735 9.508-4.409 14.164 1.536-1.526 2.874-3.236 4.41-4.762l4.408 4.762c-1.497-4.712-2.911-9.451-4.409-14.164zm.032 2.93c.823 2.588 1.599 5.19 2.421 7.777l-2.42-2.614c-.683.598-2.454 2.886-2.34 2.39.871-2.489 1.448-5.07 2.34-7.552zM16.012.312c-1.448.02-2.93.157-4.302.628-.852.447-.255 1.863.66 1.574 2.255-.608 4.648-.607 6.922-.108.934.075 1.228-1.376.338-1.67C18.451.44 17.227.317 16.012.311zm9.012 2.934c-.913-.104-1.272 1.258-.454 1.648 1.834 1.36 3.293 3.185 4.31 5.22.526.776 1.842.098 1.515-.78a15.522 15.522 0 00-5.06-6.006c-.1-.044-.203-.07-.31-.082zM6.65 3.59c-.762.089-1.24.809-1.805 1.267C3.38 6.295 2.163 8.007 1.37 9.905c-.266.898 1.094 1.484 1.564.675a14.825 14.825 0 014.327-5.56c.476-.515.09-1.419-.612-1.431zm9.362.007c-.698.066-1.689-.16-2.033.635-.282.733.535 1.358 1.217 1.125 1.806-.147 3.63.203 5.293.907.902.255 1.472-1.112.656-1.573-1.6-.735-3.374-1.089-5.133-1.094zm-5.479 1.365c-.835.15-1.517.76-2.21 1.226-1.203.94-2.318 2.061-3.057 3.402-.33.904 1.063 1.552 1.547.723 1.045-1.656 2.596-2.925 4.285-3.873.545-.499.171-1.463-.565-1.478zm13.903 2.115c-.875-.07-1.22 1.173-.501 1.627 1.325 1.34 2.188 3.062 2.748 4.84.468.84 1.869.21 1.557-.699-.604-2.118-1.751-4.097-3.351-5.615a.93.93 0 00-.453-.153zM4.467 13.132c-.822-.07-.996.826-1.046 1.455-.256 1.93-.094 3.933.562 5.769.406.844 1.807.365 1.612-.551a11.498 11.498 0 01-.334-5.808.874.874 0 00-.794-.865zm26.687 1.6c-.746-.037-1.014.785-.879 1.395.043 2.393-.57 4.771-1.66 6.894-.31.884 1.02 1.536 1.53.75a15.632 15.632 0 001.821-8.372.876.876 0 00-.812-.667zm-30.197.571c-.782-.073-1.044.775-.933 1.404.068 2.414.661 4.833 1.809 6.962.534.77 1.842.076 1.505-.798a14.833 14.833 0 01-1.603-6.861.876.876 0 00-.778-.707zm26.787 2.024c-.777-.048-.952.797-1.021 1.392-.354 1.692-1.202 3.231-2.216 4.608-.407.872.925 1.638 1.48.852 1.361-1.733 2.296-3.827 2.582-6.017a.874.874 0 00-.825-.835zM6.857 23.012c-.808.018-1.082 1.122-.47 1.59 1.393 1.607 3.187 2.886 5.194 3.599.91.222 1.43-1.165.598-1.596a11.495 11.495 0 01-4.723-3.396.899.899 0 00-.599-.197zm15.057 2.7c-.81.194-1.504.76-2.325.972-1.203.458-2.5.536-3.758.664-.869.307-.573 1.728.346 1.663 2.201-.034 4.412-.626 6.293-1.778.604-.495.227-1.532-.556-1.521zM6.346 27.118c-.833.008-1.11 1.218-.395 1.617 1.986 1.602 4.358 2.749 6.868 3.226.933.076 1.227-1.376.338-1.67a14.838 14.838 0 01-6.345-3.066.929.929 0 00-.466-.107zm19.208.087c-.766.09-1.241.841-1.922 1.158-1.516.991-3.251 1.58-4.996 2.005-.872.405-.346 1.849.584 1.604 2.543-.526 4.98-1.66 6.963-3.344.47-.52.072-1.42-.63-1.423z\"\n})));\n\nfunction _extends$M() { _extends$M = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$M.apply(this, arguments); }\nvar IntermediateEventCatchNonInterruptingMessageIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$M({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M8.742 10.464v11.072h14.516V10.464H8.742zm3.224 1.73h8.066a69569 69569 0 00-4.034 3.22l-4.032-3.22zm9.565 1.018v6.594H10.469v-6.593L16 17.63l5.532-4.419zM16 0h-.005l-.188.001h-.011l-.188.004h-.011l-.187.006h-.011l-.187.008h-.005L15.2.02l-.187.01h-.005l-.005.001-.187.013h-.011L14.62.06h-.01l-.186.018h-.011l-.185.02-.005.001h-.006l-.185.022-.005.001h-.005l-.185.025h-.005l-.005.001-.185.027h-.005l-.005.001-.184.029h-.005l-.005.001-.183.031-.006.001-.005.001-.182.033-.006.001-.005.001-.182.035-.005.001-.005.001-.182.038h-.005l-.005.002-.181.04h-.005l-.005.002-.18.042-.006.001-.005.001-.18.044-.005.002h-.005l-.17.045-.152.054-.139.082-.121.106-.1.127-.074.143-.046.155-.017.16.013.16.043.156.07.145.097.13.119.108.137.085.15.058.159.03.16-.001.133-.023.165-.043.168-.041.171-.04.171-.037.172-.036.17-.033.173-.03.17-.03.177-.027.171-.025.175-.022.175-.02.175-.02.176-.016.175-.014.177-.012.176-.01.177-.007.174-.006.177-.003L16 1.73h.177l.178.004.174.006.177.007.176.01.177.012.175.014.176.017.175.018.175.02.175.023.171.025.176.027.17.03.174.03.17.033.171.036.154.033.16.02.161-.01.156-.04.146-.069.131-.094.111-.117.087-.135.061-.15.032-.158.002-.16-.027-.16-.057-.15L20 .714l-.108-.12-.128-.097-.145-.073-.128-.038-.158-.035-.005-.001-.005-.001L19.14.31h-.005l-.005-.002-.182-.035h-.006l-.005-.002-.182-.033h-.006l-.005-.002-.183-.03-.005-.001-.006-.001-.183-.029h-.005l-.006-.001-.184-.027h-.005l-.005-.001-.185-.024h-.005L17.968.12 17.783.1l-.006-.001h-.005l-.185-.02h-.006l-.005-.001L17.39.06h-.005L17.38.06l-.187-.015h-.005l-.005-.001-.187-.013h-.011L16.8.02h-.011L16.6.01h-.011l-.187-.006h-.011L16.204 0h-.011L16.005 0H16zm9.015 2.935l-.16.004-.158.033-.15.062-.134.09-.116.111-.093.132-.067.147-.038.156-.01.161.022.16.05.153.078.141.103.124.102.087.045.034.142.106.137.105.14.11.136.11.135.112.134.115.134.117.13.115.132.122.128.12.127.122.126.125.124.126.124.128.121.13.118.128.118.132.117.133.113.134.113.136.11.136.109.137.109.142.104.14.103.14.101.142.1.144.099.146.095.145.094.147.093.15.092.15.087.149.087.15.084.152.084.155.08.152.08.155.04.081.084.138.11.119.128.096.145.072.155.043.16.013.16-.016.155-.046.144-.074.127-.099.106-.12.083-.14.055-.151.026-.16-.004-.16-.034-.158-.05-.124-.042-.085-.002-.004-.003-.005-.084-.165-.002-.004-.003-.005-.086-.164-.002-.004-.003-.005-.088-.162-.002-.005-.003-.005-.09-.161-.002-.005-.003-.004-.092-.16-.003-.005-.002-.005-.094-.16-.003-.004-.003-.004-.096-.159-.002-.004-.003-.005-.098-.157-.003-.004-.003-.005-.1-.156-.003-.004-.003-.005-.101-.154-.003-.005-.003-.004-.104-.154-.003-.004-.003-.005-.106-.152-.003-.005-.003-.004-.108-.151-.003-.004-.003-.005-.11-.15-.003-.004-.003-.004-.111-.15-.004-.003-.003-.005-.113-.147-.004-.004-.003-.005-.115-.146-.004-.004-.003-.004-.117-.145-.004-.004-.003-.004-.12-.144-.003-.004-.003-.004-.121-.142-.004-.004-.003-.004-.123-.141-.003-.004-.004-.004-.125-.14-.003-.004-.004-.004-.127-.138-.003-.004-.004-.004-.128-.136-.004-.004-.004-.004-.13-.135-.004-.004-.004-.004-.132-.134-.003-.004-.004-.003-.134-.133-.004-.003-.004-.004-.135-.13-.004-.004-.004-.004-.136-.128-.004-.004-.004-.004-.138-.126-.004-.004-.004-.003-.14-.125-.004-.004-.004-.003-.14-.123-.005-.004-.004-.003-.142-.121-.004-.004-.004-.003-.144-.12-.004-.003-.004-.003-.145-.117-.004-.004-.004-.003-.147-.115-.004-.004-.004-.003-.148-.113-.004-.003-.004-.004-.149-.111-.004-.003-.004-.004-.05-.036-.14-.083-.15-.055-.16-.027zM6.634 3.28l-.161.008-.157.037-.147.066-.111.074-.04.032-.005.003-.004.004-.145.117-.004.003-.004.004-.144.119-.004.003-.004.004-.142.12-.004.004-.004.004-.141.123-.004.003-.004.004-.14.125-.004.003-.004.004-.138.126-.004.004-.004.004-.136.128-.004.004-.004.004-.135.13-.004.004-.004.003-.134.133-.004.003-.004.004-.132.134-.003.004-.004.004-.13.135-.004.004-.004.004-.128.136-.004.004-.004.004-.126.138-.004.004-.003.004-.125.14-.004.004-.003.004-.123.14-.004.005-.003.004-.121.142-.004.004-.003.004-.12.144-.003.004-.003.004-.117.145-.004.004-.003.004-.115.146-.004.005-.003.004-.113.147-.003.005-.004.004-.111.149-.003.004-.004.004-.11.15-.002.005-.003.004-.108.151-.003.004-.003.005-.106.152-.003.005-.003.004-.104.154-.003.004-.003.005-.102.154-.003.005-.002.004-.1.156-.003.005-.003.004-.098.157-.003.005-.003.004-.096.159-.002.004-.003.005-.094.16-.003.004-.002.004-.092.16-.003.005-.003.005-.09.161-.002.005-.003.005-.088.162-.002.005-.003.004-.086.164-.002.005-.002.004-.084.165-.003.005-.002.004-.082.166-.002.004-.003.005-.08.167-.002.004-.002.005-.078.168-.002.004-.002.005-.045.1-.053.153-.023.16.007.16.037.157.065.148.092.132.114.114.134.09.148.064.157.035.161.006.16-.025.152-.054.14-.08.121-.106.1-.126.065-.118.043-.095.074-.16.075-.155.077-.157.08-.155.08-.152.083-.155.085-.152.086-.15.088-.149.091-.15.094-.15.094-.147.095-.145.099-.146.1-.144.1-.142.104-.14.104-.14.11-.142.107-.137.11-.136.114-.136.113-.134.117-.133.118-.132.117-.129.122-.13.124-.127.123-.126.127-.125.127-.122.128-.12.132-.122.13-.115.133-.117.135-.115.135-.111.136-.11.037-.03.117-.11.094-.132.068-.146.04-.156.01-.161-.02-.16-.05-.154-.076-.141-.102-.125-.123-.104-.14-.08-.153-.051-.16-.023zM16 3.286h-.005l-.148.001h-.01l-.147.003h-.011l-.147.005h-.011l-.146.007h-.011l-.146.009h-.011l-.146.01h-.005l-.005.001-.146.012h-.011l-.145.014h-.006l-.005.001-.05.006-.158.031-.15.06-.135.088-.117.111-.094.13-.069.147-.04.156-.01.16.019.16.049.154.076.142.102.125.123.105.14.08.152.051.16.023.134-.003.045-.005.135-.013.133-.01.136-.01.135-.007.137-.006.136-.004.136-.003h.274l.136.003.136.004.136.006.136.007.136.01.133.01.135.013.135.014.135.016.134.018.132.018.134.021.133.023.133.024.133.025.13.027.132.03.132.03.129.031.13.034.129.035.129.036.13.04.126.038.128.042.126.042.128.045.127.047.126.047.12.048.127.051.123.052.006.002.147.048.16.021.16-.009.157-.038.147-.067.131-.093.112-.116.089-.135.062-.149.033-.158.004-.16-.027-.16-.055-.151-.083-.139-.107-.12-.127-.099-.118-.063-.004-.001-.005-.003-.005-.002-.133-.056-.005-.002-.005-.002-.134-.054-.004-.002-.005-.002-.135-.053-.005-.002-.005-.002-.135-.051-.005-.002-.005-.002-.135-.05-.005-.001-.005-.002-.137-.048-.005-.001-.005-.002-.137-.046-.005-.002-.005-.002-.137-.044-.005-.002-.005-.001-.138-.043-.006-.002-.005-.001-.138-.042-.005-.001-.005-.002-.14-.04H19.4l-.005-.002-.14-.038-.005-.001-.005-.002-.14-.036-.005-.001-.005-.001-.141-.035-.005-.001-.005-.001-.142-.033-.005-.001-.005-.001-.142-.031-.005-.002h-.005l-.142-.03-.005-.001-.005-.001-.143-.028h-.005l-.005-.002-.143-.025-.006-.001-.005-.001-.143-.024-.005-.001-.006-.001-.143-.022-.006-.001h-.005l-.144-.022h-.005l-.006-.001-.144-.019h-.005l-.006-.001-.144-.017h-.006l-.005-.001-.145-.016h-.011l-.145-.014H17.1l-.005-.001-.146-.012h-.01l-.146-.01-.006-.001h-.005l-.146-.009h-.011l-.147-.006h-.01l-.147-.005h-.011l-.147-.003h-.011l-.147-.001H16zm-5.482 1.366l-.16.008-.157.037-.123.053-.06.032-.005.002-.004.003-.128.069-.004.002-.005.003-.126.07-.005.003-.004.002-.126.072-.005.003-.004.003-.125.073-.004.003-.005.003-.124.075-.004.003-.005.002-.123.077-.004.003-.005.003-.122.078-.004.003-.005.003-.121.08-.004.002-.005.003-.12.082-.005.003-.004.003-.12.083-.004.003-.004.003-.118.084-.005.003-.004.003-.118.086-.004.003-.004.003-.117.088-.004.003-.004.003-.116.089-.004.003-.004.004-.114.09-.005.003-.004.003-.113.092-.004.004-.004.003-.113.093-.004.004-.004.003-.111.095-.005.003-.004.004-.11.096-.004.004-.004.003-.11.098-.003.003-.004.004-.108.1-.004.003-.004.003-.107.101-.004.004-.004.003-.106.102-.004.004-.003.004-.105.103-.004.004-.004.004-.103.105-.004.004-.004.003-.102.106-.003.004-.004.004-.1.107-.004.004-.004.004-.099.108-.004.004-.003.004-.098.11-.003.003-.004.004-.096.11-.004.005-.003.004-.095.111-.003.004-.004.004-.093.113-.003.004-.004.004-.092.113-.003.004-.003.005-.09.114-.004.004-.003.004-.089.116-.003.004-.003.004-.088.117-.003.004-.003.004-.086.118-.003.004-.003.005-.084.118-.003.004-.003.005-.083.12-.003.003-.003.005-.082.12-.003.005-.002.004-.068.103-.076.142-.048.154-.018.16.011.161.041.156.07.146.095.13.117.11.136.086.15.06.158.03.162.002.158-.03.15-.057.138-.085.119-.109.082-.105.065-.099.075-.11.077-.113.077-.107.08-.11.08-.108.084-.108.083-.105.086-.106.086-.104.088-.104.089-.101.09-.102.093-.101.093-.099.094-.097.095-.096.098-.097.098-.095.099-.093.1-.092.103-.091.101-.089.104-.088.104-.086.106-.086.106-.083.106-.082.109-.082.108-.079.11-.078.11-.076.112-.076.112-.074.113-.072.113-.071.115-.07.115-.068.118-.067.117-.065.12-.065.054-.029.135-.088.116-.111.094-.132.068-.146.04-.156.009-.161-.02-.16-.05-.153-.078-.142-.102-.125-.123-.103-.141-.079-.153-.051-.16-.022zm13.91 2.116l-.162.008-.157.037-.147.066-.132.092-.113.116-.09.134-.063.148-.034.157-.005.162.025.159.055.152.082.138.086.103.09.09.094.098.092.099.093.1.091.103.089.101.088.104.086.104.086.106.083.105.083.108.08.108.081.11.077.107.077.112.075.111.075.114.072.113.071.113.07.114.068.118.067.115.065.118.064.117.062.117.061.121.059.119.059.122.056.121.054.12.055.125.051.123.051.125.048.123.048.127.047.126.044.125.043.128.042.129.039.126.038.13.022.076.058.15.085.137.11.119.129.096.145.07.155.043.16.013.161-.017.154-.046.144-.075.126-.1.106-.12.082-.14.055-.151.025-.16-.005-.16-.026-.132-.023-.082-.002-.005-.001-.005-.042-.139-.001-.005-.002-.005-.043-.138-.001-.005-.002-.005-.044-.137-.002-.005-.002-.005-.046-.137-.002-.005-.001-.005-.048-.137-.002-.005-.002-.005-.05-.135-.001-.005-.002-.005-.051-.135-.002-.005-.002-.005-.053-.135-.002-.005-.002-.005-.054-.133-.002-.005-.002-.005-.057-.133-.002-.005-.002-.005-.057-.132-.003-.005-.002-.005-.06-.132-.001-.005-.002-.004-.061-.132-.003-.004-.002-.005-.063-.13-.002-.005-.002-.005-.064-.13-.003-.004-.002-.005-.066-.129-.002-.004-.003-.005-.067-.128-.002-.005-.003-.004-.069-.128-.002-.004-.003-.005-.07-.126-.003-.005-.003-.004-.072-.126-.002-.005-.003-.004-.074-.125-.002-.004-.003-.005-.075-.124-.003-.004-.003-.005-.076-.123-.003-.004-.003-.005-.078-.122-.003-.004-.003-.005-.08-.121-.003-.004-.003-.005-.081-.12-.003-.005-.003-.004-.083-.12-.003-.004-.003-.004-.084-.118-.003-.005-.003-.004-.086-.118-.003-.004-.004-.004-.087-.117-.003-.004-.003-.004-.09-.116-.002-.004-.004-.004-.09-.114-.003-.005-.004-.004-.091-.113-.004-.004-.003-.004-.094-.113-.003-.004-.003-.004-.095-.111-.004-.004-.003-.004-.096-.11-.004-.005-.003-.004-.098-.11-.004-.003-.003-.004-.1-.108-.003-.004-.004-.004-.1-.107-.004-.004-.004-.004-.102-.106-.003-.003-.004-.004-.093-.095-.124-.103-.14-.08-.153-.05-.16-.023zM4.45 12.826l-.161.002-.158.032-.15.06-.135.088-.118.11-.094.131-.069.146-.035.129-.026.132v.005l-.002.005-.025.143-.001.005-.001.006-.024.143-.001.005-.001.006-.022.143-.001.006-.001.005-.02.144-.001.005-.001.005-.019.145v.005l-.001.006-.017.144v.006l-.001.005-.016.145v.011l-.014.145v.005l-.001.006-.012.146v.01l-.01.146-.001.006v.005l-.009.146v.011l-.007.146v.011l-.004.147v.011l-.003.147v.01l-.002.148v.01l.001.148v.01l.003.147v.011l.005.147v.01l.007.147v.011l.009.146v.011l.01.146v.01l.013.146v.011l.014.145v.005l.001.006.016.145v.011l.018.144v.006l.001.005.019.144v.006l.001.005.021.144v.005l.002.006.022.143v.006l.002.005.024.143v.005l.002.006.025.143.001.005.001.005.028.143.001.005.001.005.03.142v.005l.002.006.03.141.002.005.001.005.033.142v.005l.002.005.035.14v.006l.002.005.036.14.002.005.001.005.038.14.001.005.002.005.04.14v.005l.002.005.042.138.001.006.002.005.042.138.002.005.002.005.017.054.064.148.09.134.114.114.132.092.148.065.157.037.16.007.16-.023.153-.052.14-.08.123-.104.102-.125.076-.142.049-.153.02-.16-.011-.161-.031-.13-.017-.051-.039-.126-.038-.13-.037-.128-.035-.13-.033-.128-.033-.134-.03-.13-.029-.131-.026-.13-.026-.133-.024-.133-.023-.133-.02-.132-.02-.136-.017-.132-.016-.135-.014-.135-.012-.133-.012-.138-.009-.133-.007-.136-.006-.138-.004-.134-.003-.136v-.274l.003-.136.004-.134.006-.139.007-.136.01-.133.01-.138.013-.132.014-.135.016-.135.017-.132.02-.137.02-.13.023-.134.024-.133.024-.126.016-.16-.014-.161-.044-.155-.072-.145-.098-.128-.12-.108-.137-.084-.15-.057-.16-.029zm26.698 1.601l-.161.01-.157.04-.146.067-.131.093-.112.117-.088.135-.061.149-.033.157-.005.134.006.14.006.176.003.177.001.178-.001.177-.003.178-.006.177-.007.176-.01.177-.012.176-.015.176-.016.173-.018.175-.02.175-.024.174-.025.175-.026.17-.03.174-.03.173-.033.17-.036.172-.037.17-.04.17-.042.172-.043.168-.045.166-.048.169-.05.167-.052.168-.053.164-.056.166-.058.166-.06.16-.062.165-.062.158-.066.165-.068.16-.07.16-.07.158-.075.159-.074.155-.079.158-.08.158-.06.15-.03.158-.001.161.029.159.058.15.085.137.108.119.13.097.144.07.156.044.16.013.16-.017.155-.046.143-.074.127-.1.107-.12.07-.115.083-.164.003-.005.002-.004.082-.166.002-.005.003-.004.08-.167.002-.005.002-.004.078-.168.002-.005.002-.004.076-.169.002-.004.002-.005.074-.17.002-.004.002-.005.072-.17.002-.005.002-.005.07-.171.001-.005.002-.005.068-.172.002-.004.002-.005.065-.173.002-.005.002-.005.063-.173.002-.005.002-.005.06-.174.003-.005.001-.005.06-.175.001-.005.002-.005.057-.176.001-.005.002-.005.055-.177.001-.005.002-.005.052-.177.002-.005.001-.005.051-.178.001-.005.002-.005.048-.179.002-.005v-.005l.047-.179.001-.005.002-.005.044-.18v-.005l.002-.005.042-.18.001-.006.001-.005.04-.181.001-.005.001-.005.037-.182.002-.005v-.005l.036-.182v-.006l.002-.005.033-.182v-.006l.002-.005.03-.183.001-.005.001-.005.029-.184v-.005l.001-.006.027-.184v-.005l.001-.005.024-.185v-.005l.001-.005.022-.185v-.006l.001-.005.02-.185v-.006l.001-.005.017-.186v-.005l.001-.005.015-.187v-.005l.001-.005.013-.187v-.01l.01-.187.001-.006v-.005l.009-.187v-.011l.006-.187v-.011l.004-.188v-.011l.001-.188v-.01l-.001-.188v-.011l-.004-.188v-.011l-.006-.187v-.011l-.007-.145-.022-.16-.05-.152-.08-.141-.103-.124-.125-.102-.141-.077-.153-.05-.16-.02zM.938 15L.777 15l-.158.032-.15.06-.136.087-.117.11-.095.131-.068.146-.04.156-.012.133-.001.14v.01l.001.188v.011l.004.188v.011l.006.187v.011l.008.187v.011l.011.187v.005l.001.005.013.187v.01l.016.187v.01l.018.186v.011l.02.185.001.005v.006l.022.185.001.005v.005l.025.185v.005l.001.005.027.184v.006l.001.005.029.184v.005l.001.005.031.183.001.005.001.006.033.182.001.005.001.006.035.182.001.005.001.005.038.182v.005l.002.005.04.181v.005l.002.005.042.18.001.006.001.005.044.18.002.005v.005l.047.18.001.004.002.005.048.179.002.005.001.005.05.178.002.005.001.005.053.177.002.005.001.005.055.177.002.005.001.005.057.176.002.005.001.005.06.175.001.005.002.005.061.174.002.005.002.005.063.173.002.005.002.005.065.173.002.005.002.004.067.172.002.005.002.005.07.171.002.005.002.005.072.17.002.005.002.004.074.17.002.005.002.004.076.169.002.004.002.005.078.168.002.004.002.005.08.167.003.004.002.005.082.166.002.004.003.005.02.04.086.136.11.118.13.095.146.07.156.041.16.012.16-.019.155-.048.142-.075.126-.1.105-.123.08-.14.054-.152.024-.16-.006-.16-.036-.158-.051-.123-.018-.034-.078-.158L3.1 22.1l-.074-.16-.071-.157-.07-.16-.068-.16-.067-.165-.062-.158-.062-.164-.059-.161-.058-.166-.056-.166-.053-.164-.052-.168-.05-.167-.048-.17-.045-.165-.043-.168-.043-.172-.039-.17-.037-.17-.036-.172-.033-.17-.03-.173-.03-.174-.027-.17-.025-.175-.022-.174-.021-.175-.018-.175-.017-.173-.014-.176-.012-.176-.01-.177-.007-.176-.006-.177-.003-.178L1.73 16v-.134l-.013-.16-.044-.156-.072-.144-.097-.129-.12-.108-.137-.085-.15-.057L.938 15zm26.798 2.024l-.16.007-.157.038-.148.066-.132.092-.113.115-.09.134-.062.148-.03.127-.001.004-.023.134-.024.133-.026.133-.026.13-.03.132-.03.129-.032.134-.033.128-.035.13-.037.128-.038.13-.04.126-.04.128-.044.128-.044.126-.046.126-.048.126-.05.125-.05.125-.051.122-.054.123-.055.122-.056.12-.058.122-.06.12-.061.12-.063.119-.062.116-.067.119-.066.116-.069.115-.069.115-.07.113-.073.113-.074.112-.076.113-.077.112-.077.107-.08.11-.08.107-.085.11-.044.056-.088.135-.06.15-.033.158-.002.16.027.16.057.15.083.138.108.12.128.098.144.072.155.045.16.015.161-.016.155-.044.144-.073.128-.098.09-.099.05-.061.003-.004.003-.005.089-.115.003-.004.003-.005.088-.116.003-.004.003-.005.086-.117.003-.004.003-.005.084-.118.003-.004.003-.005.083-.12.003-.004.003-.004.081-.12.003-.005.003-.004.08-.121.003-.005.003-.004.078-.122.003-.005.003-.004.077-.123.002-.005.003-.004.075-.124.003-.005.003-.004.073-.125.003-.005.003-.004.072-.126.002-.004.003-.005.07-.126.003-.005.002-.005.07-.127.002-.004.002-.005.068-.128.002-.005.002-.004.066-.13.003-.004.002-.005.064-.13.002-.004.003-.005.062-.13.002-.005.003-.005.06-.13.003-.005.002-.005.06-.132.002-.005.002-.005.057-.132.003-.005.002-.005.056-.133.002-.005.002-.005.054-.134.002-.004.002-.005.053-.135.002-.005.002-.005.051-.135.002-.005.002-.005.05-.135.001-.005.002-.005.048-.137.001-.005.002-.005.046-.137.002-.005.002-.005.044-.137.002-.005.002-.005.042-.138.002-.005.001-.006.042-.138.001-.005.002-.005.04-.14V19.4l.002-.005.038-.14.001-.005.002-.005.036-.14.001-.005.001-.005.035-.141.001-.005.001-.005.033-.142.001-.005.001-.005.031-.141.001-.006.002-.005.029-.142v-.005l.002-.005.028-.143v-.005l.002-.005.025-.143.001-.006.001-.005.024-.143.001-.005.001-.006.001-.006.01-.161-.02-.16-.05-.154-.077-.141-.102-.125-.123-.104-.141-.079-.153-.051-.16-.022zM6.841 22.71l-.16.024-.152.053-.14.08-.122.105-.101.126-.076.142-.048.154-.018.16.011.161.041.156.07.146.077.109.04.048.003.004.003.004.095.111.003.004.004.004.096.11.004.005.003.004.098.109.003.004.004.004.1.108.003.004.003.004.101.107.004.004.003.004.102.105.004.004.004.004.103.105.004.004.004.003.105.104.003.004.004.003.106.102.004.004.004.004.107.1.004.004.004.004.108.099.004.003.004.004.11.098.003.003.004.004.11.096.004.003.005.004.11.095.005.003.004.004.113.093.004.003.004.004.113.091.004.004.005.003.114.09.004.004.004.003.116.089.004.003.004.003.117.088.004.003.004.003.118.086.004.003.005.003.118.084.004.003.005.003.119.083.004.003.005.003.12.081.005.003.004.003.121.08.005.003.004.003.122.078.005.003.004.003.123.076.005.003.004.003.124.075.005.003.004.003.125.073.004.003.005.002.126.073.004.002.005.003.126.07.005.003.004.002.128.07.004.002.005.002.128.067.005.003.004.002.13.066.004.002.005.003.13.064.004.002.005.003.13.062.005.002.004.003.132.06.004.003.005.002.132.06.005.002.005.002.132.057.005.002.005.002.133.057.005.002.005.002.133.054.005.002.005.002.13.05.154.045.16.016.16-.015.156-.045.144-.072.128-.098.108-.12.083-.138.057-.15.028-.16-.003-.16-.032-.159-.061-.149-.088-.135-.11-.117-.132-.094-.12-.058-.124-.049-.126-.051-.122-.051-.122-.054-.12-.054-.126-.058-.119-.057-.12-.06-.12-.06-.118-.063-.117-.064-.119-.066-.116-.066-.115-.068-.115-.07-.113-.07-.115-.074-.112-.074-.11-.075-.11-.076-.112-.08-.11-.08-.109-.081-.106-.082-.104-.082-.106-.086-.105-.087-.101-.086-.105-.091-.1-.09-.1-.091-.1-.094-.097-.094-.1-.098-.093-.095-.096-.1-.093-.098-.092-.101-.089-.1-.09-.102-.088-.104-.036-.043-.114-.114-.133-.091-.148-.065-.157-.036-.161-.006zm15.063 2.701l-.16.014-.156.044-.12.057-.06.034-.12.066-.117.064-.118.062-.12.061-.12.06-.118.057-.126.058-.12.054-.122.054-.122.05-.126.052-.125.05-.124.046-.127.047-.125.044-.129.043-.126.04-.13.042-.128.038-.127.035-.13.036-.131.034-.129.031-.132.03-.13.03-.135.027-.133.026-.13.023-.13.022-.137.021-.132.02-.134.017-.132.015-.138.015-.135.013-.133.01-.138.01-.136.007-.134.006-.136.004-.14.003-.16.018-.155.047-.142.076-.127.1-.105.122-.08.14-.054.151-.025.16.006.16.035.158.064.148.09.134.114.114.133.092.147.065.157.036.134.008.145-.002h.011l.147-.005h.01l.147-.007h.011l.146-.009h.011l.146-.01h.005l.005-.001.146-.012h.011l.145-.014h.005l.006-.001.145-.016h.011l.144-.018h.006l.005-.001.144-.02h.011l.144-.021.005-.001h.006l.143-.023.006-.001h.005l.143-.025h.005l.006-.002.143-.026h.005l.005-.002.143-.027.005-.001.005-.001.142-.03h.005l.005-.002.142-.03.005-.002.005-.001.142-.033.005-.001.005-.001.14-.035.006-.001.005-.001.14-.037h.005l.005-.002.14-.038.005-.002h.005l.14-.04.005-.002.005-.001.138-.042.005-.001.006-.002.138-.043.005-.001.005-.002.137-.044.005-.002.005-.002.137-.046.005-.002.005-.001.137-.048.005-.002.005-.002.135-.05.005-.001.005-.002.135-.051.005-.002.005-.002.135-.053.005-.002.004-.002.134-.054.005-.002.005-.002.133-.057.005-.002.005-.002.132-.057.005-.003.005-.002.132-.06.005-.001.004-.002.131-.061.005-.003.005-.002.13-.062.005-.003.005-.002.13-.064.004-.003.005-.002.128-.066.005-.002.005-.003.128-.067.005-.002.004-.003.127-.069.005-.002.005-.003.126-.07.005-.003.004-.003.065-.037.132-.093.112-.115.089-.135.062-.149.034-.157.003-.161-.026-.16-.055-.15-.082-.14-.107-.12-.127-.1-.144-.073-.154-.046-.16-.016zM6.33 26.818l-.16.023-.152.053-.14.08-.122.105-.101.126-.076.142-.048.154-.02.16.012.161.041.156.07.146.094.13.096.093.032.026.004.003.004.004.145.117.004.003.004.004.146.115.005.003.004.004.147.113.005.003.004.004.149.111.004.003.004.003.15.11.005.003.004.003.151.108.004.003.005.003.152.106.005.003.004.003.154.104.004.003.005.003.154.102.005.002.004.003.156.1.005.003.004.003.157.098.005.003.004.002.159.096.004.003.005.003.16.094.004.003.004.002.16.092.005.003.005.002.161.09.005.003.005.002.162.088.005.003.004.002.164.086.005.003.004.002.165.084.005.003.004.002.166.082.004.002.005.003.167.08.004.002.005.002.168.078.004.002.005.002.168.076.005.002.005.002.17.074.004.002.005.002.17.072.005.002.005.002.17.07.006.002.005.001.171.068.005.002.005.002.173.065.005.002.005.002.173.063.005.002.005.002.174.06.005.003.005.001.175.06.005.001.005.002.176.057.005.001.005.002.176.055.006.001.005.002.177.052.005.002.005.001.178.05.005.002.005.002.178.048.006.001.005.002.179.046.005.001.005.002.18.044h.005l.005.002.18.042.006.001.005.001.159.035.16.02.16-.01.157-.04.146-.069.13-.094.112-.117.087-.136.06-.149.033-.158.002-.161-.028-.159-.057-.15-.084-.138-.108-.12-.128-.098-.144-.072-.128-.039-.154-.033-.168-.04-.171-.041-.17-.044-.168-.046-.167-.047-.168-.05-.165-.051-.166-.054-.166-.056-.163-.057-.165-.06-.161-.062-.164-.064-.16-.065-.16-.068-.162-.07-.157-.07-.157-.074-.157-.075-.156-.077-.153-.079-.156-.082-.153-.082-.154-.086-.15-.086-.152-.09-.148-.09-.147-.092-.149-.095-.145-.095-.144-.098-.145-.1-.143-.102-.14-.103-.14-.104-.14-.108-.139-.11-.136-.11-.027-.022-.133-.091-.148-.065-.157-.036-.161-.006zm19.215.087l-.16.01-.157.039-.146.067-.11.076-.064.051-.139.11-.14.108-.14.104-.14.103-.143.101-.145.101-.144.098-.145.095-.149.095-.148.093-.147.089-.152.09-.15.086-.154.086-.153.082-.156.082-.153.079-.156.077-.157.075-.158.073-.157.071-.16.07-.16.068-.161.065-.164.064-.161.061-.165.06-.163.058-.166.056-.166.054-.166.051-.167.05-.167.047-.17.046-.168.044-.171.042-.168.039-.17.037-.11.023-.154.047-.143.075-.126.1-.106.122-.081.139-.054.152-.025.16.006.16.035.158.063.148.09.133.114.115.132.092.148.065.157.037.16.007.133-.016.115-.024.005-.001.005-.001.181-.04h.005l.005-.002.18-.042.006-.001.005-.001.18-.044.005-.002.005-.001.18-.046.004-.002h.005l.179-.05h.005l.005-.002.178-.05.005-.002.005-.002.177-.052.005-.002.005-.001.177-.055.005-.002.005-.001.176-.057.005-.002.005-.002.175-.059.005-.001.005-.002.174-.061.005-.002.005-.002.173-.063.005-.002.005-.002.173-.065.004-.002.005-.002.172-.068.005-.002.005-.002.171-.07.005-.001.005-.002.17-.072.005-.002.004-.002.17-.074.005-.002.004-.002.169-.076.004-.002.005-.002.168-.078.004-.002.005-.003.167-.08.004-.002.005-.002.166-.082.004-.002.005-.003.165-.084.004-.002.005-.003.163-.086.005-.002.005-.003.162-.088.005-.002.005-.003.161-.09.005-.002.004-.003.16-.092.005-.003.005-.002.16-.094.004-.003.004-.003.158-.096.005-.002.004-.003.158-.098.004-.003.005-.003.156-.1.004-.003.004-.003.155-.101.005-.003.004-.003.154-.104.004-.003.004-.003.153-.106.004-.003.005-.003.151-.108.004-.003.005-.003.15-.11.004-.003.004-.003.149-.112.004-.003.004-.003.148-.113.004-.004.004-.003.147-.115.004-.004.004-.003.068-.055.116-.113.092-.132.066-.147.038-.157.008-.16-.022-.16-.05-.153-.08-.14-.103-.125-.124-.102-.142-.077-.153-.05-.16-.02z\"\n})));\n\nfunction _extends$L() { _extends$L = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$L.apply(this, arguments); }\nvar IntermediateEventCatchNonInterruptingMultipleIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$L({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M23.637 13.902l-7.625-5.535-7.624 5.535 2.912 8.956h9.425l2.912-8.956zm-1.017.33l-2.524 7.762H11.93l-2.524-7.762 6.607-4.796 6.608 4.796zM16.012.311c-1.448.02-2.93.157-4.302.628-.852.447-.255 1.863.66 1.574 2.255-.608 4.648-.607 6.922-.108.934.075 1.228-1.376.338-1.67C18.451.44 17.227.317 16.012.311zm9.012 2.934c-.913-.104-1.272 1.258-.454 1.648 1.834 1.36 3.293 3.185 4.31 5.22.526.776 1.842.098 1.515-.78a15.522 15.522 0 00-5.06-6.006c-.1-.044-.203-.07-.31-.082zM6.65 3.59c-.762.089-1.24.809-1.805 1.267C3.38 6.295 2.163 8.007 1.37 9.905c-.266.898 1.094 1.484 1.564.675a14.825 14.825 0 014.327-5.56c.476-.515.09-1.419-.612-1.431zm9.362.007c-.698.066-1.689-.16-2.033.635-.282.733.535 1.358 1.217 1.125 1.806-.147 3.63.203 5.293.907.902.255 1.472-1.112.656-1.573-1.6-.735-3.374-1.089-5.133-1.094zm-5.479 1.365c-.835.15-1.517.76-2.21 1.226-1.203.94-2.318 2.061-3.057 3.402-.33.904 1.063 1.552 1.547.723 1.045-1.656 2.596-2.925 4.285-3.873.545-.499.171-1.463-.565-1.478zm13.903 2.115c-.875-.07-1.22 1.173-.501 1.627 1.325 1.34 2.188 3.062 2.748 4.84.468.84 1.869.21 1.557-.699-.604-2.118-1.751-4.097-3.351-5.615a.93.93 0 00-.453-.153zM4.467 13.132c-.822-.07-.996.826-1.046 1.455-.256 1.93-.094 3.933.562 5.769.406.844 1.807.365 1.612-.551a11.498 11.498 0 01-.334-5.808.874.874 0 00-.794-.865zm26.687 1.6c-.746-.037-1.014.785-.879 1.395.043 2.393-.57 4.771-1.66 6.894-.31.884 1.02 1.536 1.53.75a15.632 15.632 0 001.821-8.372.876.876 0 00-.812-.667zm-30.197.571c-.782-.073-1.044.775-.933 1.404.068 2.414.661 4.833 1.809 6.962.534.77 1.842.076 1.505-.798a14.833 14.833 0 01-1.603-6.861.876.876 0 00-.778-.707zm26.787 2.024c-.777-.048-.952.797-1.021 1.392-.354 1.692-1.202 3.231-2.216 4.608-.407.872.925 1.638 1.48.852 1.361-1.733 2.296-3.827 2.582-6.017a.874.874 0 00-.825-.835zM6.857 23.012c-.808.018-1.082 1.122-.47 1.59 1.393 1.607 3.187 2.886 5.194 3.599.91.222 1.43-1.165.598-1.596a11.495 11.495 0 01-4.723-3.396.899.899 0 00-.599-.197zm15.057 2.7c-.81.194-1.504.76-2.325.972-1.203.458-2.5.536-3.758.664-.869.307-.573 1.728.346 1.663 2.201-.034 4.412-.626 6.293-1.778.604-.495.227-1.532-.556-1.521zM6.346 27.118c-.833.008-1.11 1.218-.395 1.617 1.986 1.602 4.358 2.749 6.868 3.226.933.076 1.227-1.376.338-1.67a14.838 14.838 0 01-6.345-3.066.929.929 0 00-.466-.107zm19.208.087c-.766.09-1.241.841-1.922 1.158-1.516.991-3.251 1.58-4.996 2.005-.872.405-.346 1.849.584 1.604 2.543-.526 4.98-1.66 6.963-3.344.47-.52.072-1.42-.63-1.423z\"\n})));\n\nfunction _extends$K() { _extends$K = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$K.apply(this, arguments); }\nvar IntermediateEventCatchNonInterruptingParallelIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$K({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M13.51 9.081v4.428H9.08v4.982h4.428v4.428h4.982V18.49h4.428v-4.982H18.49V9.081h-4.982zm.83.83h3.32v4.428h4.429v3.322H17.66v4.428h-3.32v-4.454H9.91v-3.296h4.428V9.911zM16 0h-.005l-.188.001h-.011l-.188.004h-.011l-.187.006h-.011l-.187.008h-.005L15.2.02l-.187.01h-.005l-.005.001-.187.013h-.011L14.62.06h-.01l-.186.018h-.011l-.185.02-.005.001h-.006l-.185.022-.005.001h-.005l-.185.025h-.005l-.005.001-.185.027h-.005l-.005.001-.184.029h-.005l-.005.001-.183.031-.006.001-.005.001-.182.033-.006.001-.005.001-.182.035-.005.001-.005.001-.182.038h-.005l-.005.002-.181.04h-.005l-.005.002-.18.042-.006.001-.005.001-.18.044-.005.002h-.005l-.17.045-.152.054-.139.082-.121.106-.1.127-.074.143-.046.155-.017.16.013.16.043.156.07.145.097.13.119.108.137.085.15.058.159.03.16-.001.133-.023.165-.043.168-.041.171-.04.171-.037.172-.036.17-.033.173-.03.17-.03.177-.027.171-.025.175-.022.175-.02.175-.02.176-.016.175-.014.177-.012.176-.01.177-.007.174-.006.177-.003L16 1.73h.177l.178.004.174.006.177.007.176.01.177.012.175.014.176.017.175.018.175.02.175.023.171.025.176.027.17.03.174.03.17.033.171.036.154.033.16.02.161-.01.156-.04.146-.069.131-.094.111-.117.087-.135.061-.15.032-.158.002-.16-.027-.16-.057-.15L20 .714l-.108-.12-.128-.097-.145-.073-.128-.038-.158-.035-.005-.001-.005-.001L19.14.31h-.005l-.005-.002-.182-.035h-.006l-.005-.002-.182-.033h-.006l-.005-.002-.183-.03-.005-.001-.006-.001-.183-.029h-.005l-.006-.001-.184-.027h-.005l-.005-.001-.185-.024h-.005L17.968.12 17.783.1l-.006-.001h-.005l-.185-.02h-.006l-.005-.001L17.39.06h-.005L17.38.06l-.187-.015h-.005l-.005-.001-.187-.013h-.011L16.8.02h-.011L16.6.01h-.011l-.187-.006h-.011L16.204 0h-.011L16.005 0H16zm9.015 2.935l-.16.004-.158.033-.15.062-.134.09-.116.111-.093.132-.067.147-.038.156-.01.161.022.16.05.153.078.141.103.124.102.087.045.034.142.106.137.105.14.11.136.11.135.112.134.115.134.117.13.115.132.122.128.12.127.122.126.125.124.126.124.128.121.13.118.128.118.132.117.133.113.134.113.136.11.136.109.137.109.142.104.14.103.14.101.142.1.144.099.146.095.145.094.147.093.15.092.15.087.149.087.15.084.152.084.155.08.152.08.155.04.081.084.138.11.119.128.096.145.072.155.043.16.013.16-.016.155-.046.144-.074.127-.099.106-.12.083-.14.055-.151.026-.16-.004-.16-.034-.158-.05-.124-.042-.085-.002-.004-.003-.005-.084-.165-.002-.004-.003-.005-.086-.164-.002-.004-.003-.005-.088-.162-.002-.005-.003-.005-.09-.161-.002-.005-.003-.004-.092-.16-.003-.005-.002-.005-.094-.16-.003-.004-.003-.004-.096-.159-.002-.004-.003-.005-.098-.157-.003-.004-.003-.005-.1-.156-.003-.004-.003-.005-.101-.154-.003-.005-.003-.004-.104-.154-.003-.004-.003-.005-.106-.152-.003-.005-.003-.004-.108-.151-.003-.004-.003-.005-.11-.15-.003-.004-.003-.004-.111-.15-.004-.003-.003-.005-.113-.147-.004-.004-.003-.005-.115-.146-.004-.004-.003-.004-.117-.145-.004-.004-.003-.004-.12-.144-.003-.004-.003-.004-.121-.142-.004-.004-.003-.004-.123-.141-.003-.004-.004-.004-.125-.14-.003-.004-.004-.004-.127-.138-.003-.004-.004-.004-.128-.136-.004-.004-.004-.004-.13-.135-.004-.004-.004-.004-.132-.134-.003-.004-.004-.003-.134-.133-.004-.003-.004-.004-.135-.13-.004-.004-.004-.004-.136-.128-.004-.004-.004-.004-.138-.126-.004-.004-.004-.003-.14-.125-.004-.004-.004-.003-.14-.123-.005-.004-.004-.003-.142-.121-.004-.004-.004-.003-.144-.12-.004-.003-.004-.003-.145-.117-.004-.004-.004-.003-.147-.115-.004-.004-.004-.003-.148-.113-.004-.003-.004-.004-.149-.111-.004-.003-.004-.004-.05-.036-.14-.083-.15-.055-.16-.027zM6.634 3.28l-.161.008-.157.037-.147.066-.111.074-.04.032-.005.003-.004.004-.145.117-.004.003-.004.004-.144.119-.004.003-.004.004-.142.12-.004.004-.004.004-.141.123-.004.003-.004.004-.14.125-.004.003-.004.004-.138.126-.004.004-.004.004-.136.128-.004.004-.004.004-.135.13-.004.004-.004.003-.134.133-.004.003-.004.004-.132.134-.003.004-.004.004-.13.135-.004.004-.004.004-.128.136-.004.004-.004.004-.126.138-.004.004-.003.004-.125.14-.004.004-.003.004-.123.14-.004.005-.003.004-.121.142-.004.004-.003.004-.12.144-.003.004-.003.004-.117.145-.004.004-.003.004-.115.146-.004.005-.003.004-.113.147-.003.005-.004.004-.111.149-.003.004-.004.004-.11.15-.002.005-.003.004-.108.151-.003.004-.003.005-.106.152-.003.005-.003.004-.104.154-.003.004-.003.005-.102.154-.003.005-.002.004-.1.156-.003.005-.003.004-.098.157-.003.005-.003.004-.096.159-.002.004-.003.005-.094.16-.003.004-.002.004-.092.16-.003.005-.003.005-.09.161-.002.005-.003.005-.088.162-.002.005-.003.004-.086.164-.002.005-.002.004-.084.165-.003.005-.002.004-.082.166-.002.004-.003.005-.08.167-.002.004-.002.005-.078.168-.002.004-.002.005-.045.1-.053.153-.023.16.007.16.037.157.065.148.092.132.114.114.134.09.148.064.157.035.161.006.16-.025.152-.054.14-.08.121-.106.1-.126.065-.118.043-.095.074-.16.075-.155.077-.157.08-.155.08-.152.083-.155.085-.152.086-.15.088-.149.091-.15.094-.15.094-.147.095-.145.099-.146.1-.144.1-.142.104-.14.104-.14.11-.142.107-.137.11-.136.114-.136.113-.134.117-.133.118-.132.117-.129.122-.13.124-.127.123-.126.127-.125.127-.122.128-.12.132-.122.13-.115.133-.117.135-.115.135-.111.136-.11.037-.03.117-.11.094-.132.068-.146.04-.156.01-.161-.02-.16-.05-.154-.076-.141-.102-.125-.123-.104-.14-.08-.153-.051-.16-.023zM16 3.286h-.005l-.148.001h-.01l-.147.003h-.011l-.147.005h-.011l-.146.007h-.011l-.146.009h-.011l-.146.01h-.005l-.005.001-.146.012h-.011l-.145.014h-.006l-.005.001-.05.006-.158.031-.15.06-.135.088-.117.111-.094.13-.069.147-.04.156-.01.16.019.16.049.154.076.142.102.125.123.105.14.08.152.051.16.023.134-.003.045-.005.135-.013.133-.01.136-.01.135-.007.137-.006.136-.004.136-.003h.274l.136.003.136.004.136.006.136.007.136.01.133.01.135.013.135.014.135.016.134.018.132.018.134.021.133.023.133.024.133.025.13.027.132.03.132.03.129.031.13.034.129.035.129.036.13.04.126.038.128.042.126.042.128.045.127.047.126.047.12.048.127.051.123.052.006.002.147.048.16.021.16-.009.157-.038.147-.067.131-.093.112-.116.089-.135.062-.149.033-.158.004-.16-.027-.16-.055-.151-.083-.139-.107-.12-.127-.099-.118-.063-.004-.001-.005-.003-.005-.002-.133-.056-.005-.002-.005-.002-.134-.054-.004-.002-.005-.002-.135-.053-.005-.002-.005-.002-.135-.051-.005-.002-.005-.002-.135-.05-.005-.001-.005-.002-.137-.048-.005-.001-.005-.002-.137-.046-.005-.002-.005-.002-.137-.044-.005-.002-.005-.001-.138-.043-.006-.002-.005-.001-.138-.042-.005-.001-.005-.002-.14-.04H19.4l-.005-.002-.14-.038-.005-.001-.005-.002-.14-.036-.005-.001-.005-.001-.141-.035-.005-.001-.005-.001-.142-.033-.005-.001-.005-.001-.142-.031-.005-.002h-.005l-.142-.03-.005-.001-.005-.001-.143-.028h-.005l-.005-.002-.143-.025-.006-.001-.005-.001-.143-.024-.005-.001-.006-.001-.143-.022-.006-.001h-.005l-.144-.022h-.005l-.006-.001-.144-.019h-.005l-.006-.001-.144-.017h-.006l-.005-.001-.145-.016h-.011l-.145-.014H17.1l-.005-.001-.146-.012h-.01l-.146-.01-.006-.001h-.005l-.146-.009h-.011l-.147-.006h-.01l-.147-.005h-.011l-.147-.003h-.011l-.147-.001H16zm-5.482 1.366l-.16.008-.157.037-.123.053-.06.032-.005.002-.004.003-.128.069-.004.002-.005.003-.126.07-.005.003-.004.002-.126.072-.005.003-.004.003-.125.073-.004.003-.005.003-.124.075-.004.003-.005.002-.123.077-.004.003-.005.003-.122.078-.004.003-.005.003-.121.08-.004.002-.005.003-.12.082-.005.003-.004.003-.12.083-.004.003-.004.003-.118.084-.005.003-.004.003-.118.086-.004.003-.004.003-.117.088-.004.003-.004.003-.116.089-.004.003-.004.004-.114.09-.005.003-.004.003-.113.092-.004.004-.004.003-.113.093-.004.004-.004.003-.111.095-.005.003-.004.004-.11.096-.004.004-.004.003-.11.098-.003.003-.004.004-.108.1-.004.003-.004.003-.107.101-.004.004-.004.003-.106.102-.004.004-.003.004-.105.103-.004.004-.004.004-.103.105-.004.004-.004.003-.102.106-.003.004-.004.004-.1.107-.004.004-.004.004-.099.108-.004.004-.003.004-.098.11-.003.003-.004.004-.096.11-.004.005-.003.004-.095.111-.003.004-.004.004-.093.113-.003.004-.004.004-.092.113-.003.004-.003.005-.09.114-.004.004-.003.004-.089.116-.003.004-.003.004-.088.117-.003.004-.003.004-.086.118-.003.004-.003.005-.084.118-.003.004-.003.005-.083.12-.003.003-.003.005-.082.12-.003.005-.002.004-.068.103-.076.142-.048.154-.018.16.011.161.041.156.07.146.095.13.117.11.136.086.15.06.158.03.162.002.158-.03.15-.057.138-.085.119-.109.082-.105.065-.099.075-.11.077-.113.077-.107.08-.11.08-.108.084-.108.083-.105.086-.106.086-.104.088-.104.089-.101.09-.102.093-.101.093-.099.094-.097.095-.096.098-.097.098-.095.099-.093.1-.092.103-.091.101-.089.104-.088.104-.086.106-.086.106-.083.106-.082.109-.082.108-.079.11-.078.11-.076.112-.076.112-.074.113-.072.113-.071.115-.07.115-.068.118-.067.117-.065.12-.065.054-.029.135-.088.116-.111.094-.132.068-.146.04-.156.009-.161-.02-.16-.05-.153-.078-.142-.102-.125-.123-.103-.141-.079-.153-.051-.16-.022zm13.91 2.116l-.162.008-.157.037-.147.066-.132.092-.113.116-.09.134-.063.148-.034.157-.005.162.025.159.055.152.082.138.086.103.09.09.094.098.092.099.093.1.091.103.089.101.088.104.086.104.086.106.083.105.083.108.08.108.081.11.077.107.077.112.075.111.075.114.072.113.071.113.07.114.068.118.067.115.065.118.064.117.062.117.061.121.059.119.059.122.056.121.054.12.055.125.051.123.051.125.048.123.048.127.047.126.044.125.043.128.042.129.039.126.038.13.022.076.058.15.085.137.11.119.129.096.145.07.155.043.16.013.161-.017.154-.046.144-.075.126-.1.106-.12.082-.14.055-.151.025-.16-.005-.16-.026-.132-.023-.082-.002-.005-.001-.005-.042-.139-.001-.005-.002-.005-.043-.138-.001-.005-.002-.005-.044-.137-.002-.005-.002-.005-.046-.137-.002-.005-.001-.005-.048-.137-.002-.005-.002-.005-.05-.135-.001-.005-.002-.005-.051-.135-.002-.005-.002-.005-.053-.135-.002-.005-.002-.005-.054-.133-.002-.005-.002-.005-.057-.133-.002-.005-.002-.005-.057-.132-.003-.005-.002-.005-.06-.132-.001-.005-.002-.004-.061-.132-.003-.004-.002-.005-.063-.13-.002-.005-.002-.005-.064-.13-.003-.004-.002-.005-.066-.129-.002-.004-.003-.005-.067-.128-.002-.005-.003-.004-.069-.128-.002-.004-.003-.005-.07-.126-.003-.005-.003-.004-.072-.126-.002-.005-.003-.004-.074-.125-.002-.004-.003-.005-.075-.124-.003-.004-.003-.005-.076-.123-.003-.004-.003-.005-.078-.122-.003-.004-.003-.005-.08-.121-.003-.004-.003-.005-.081-.12-.003-.005-.003-.004-.083-.12-.003-.004-.003-.004-.084-.118-.003-.005-.003-.004-.086-.118-.003-.004-.004-.004-.087-.117-.003-.004-.003-.004-.09-.116-.002-.004-.004-.004-.09-.114-.003-.005-.004-.004-.091-.113-.004-.004-.003-.004-.094-.113-.003-.004-.003-.004-.095-.111-.004-.004-.003-.004-.096-.11-.004-.005-.003-.004-.098-.11-.004-.003-.003-.004-.1-.108-.003-.004-.004-.004-.1-.107-.004-.004-.004-.004-.102-.106-.003-.003-.004-.004-.093-.095-.124-.103-.14-.08-.153-.05-.16-.023zM4.45 12.826l-.161.002-.158.032-.15.06-.135.088-.118.11-.094.131-.069.146-.035.129-.026.132v.005l-.002.005-.025.143-.001.005-.001.006-.024.143-.001.005-.001.006-.022.143-.001.006-.001.005-.02.144-.001.005-.001.005-.019.145v.005l-.001.006-.017.144v.006l-.001.005-.016.145v.011l-.014.145v.005l-.001.006-.012.146v.01l-.01.146-.001.006v.005l-.009.146v.011l-.007.146v.011l-.004.147v.011l-.003.147v.01l-.002.148v.01l.001.148v.01l.003.147v.011l.005.147v.01l.007.147v.011l.009.146v.011l.01.146v.01l.013.146v.011l.014.145v.005l.001.006.016.145v.011l.018.144v.006l.001.005.019.144v.006l.001.005.021.144v.005l.002.006.022.143v.006l.002.005.024.143v.005l.002.006.025.143.001.005.001.005.028.143.001.005.001.005.03.142v.005l.002.006.03.141.002.005.001.005.033.142v.005l.002.005.035.14v.006l.002.005.036.14.002.005.001.005.038.14.001.005.002.005.04.14v.005l.002.005.042.138.001.006.002.005.042.138.002.005.002.005.017.054.064.148.09.134.114.114.132.092.148.065.157.037.16.007.16-.023.153-.052.14-.08.123-.104.102-.125.076-.142.049-.153.02-.16-.011-.161-.031-.13-.017-.051-.039-.126-.038-.13-.037-.128-.035-.13-.033-.128-.033-.134-.03-.13-.029-.131-.026-.13-.026-.133-.024-.133-.023-.133-.02-.132-.02-.136-.017-.132-.016-.135-.014-.135-.012-.133-.012-.138-.009-.133-.007-.136-.006-.138-.004-.134-.003-.136v-.274l.003-.136.004-.134.006-.139.007-.136.01-.133.01-.138.013-.132.014-.135.016-.135.017-.132.02-.137.02-.13.023-.134.024-.133.024-.126.016-.16-.014-.161-.044-.155-.072-.145-.098-.128-.12-.108-.137-.084-.15-.057-.16-.029zm26.698 1.601l-.161.01-.157.04-.146.067-.131.093-.112.117-.088.135-.061.149-.033.157-.005.134.006.14.006.176.003.177.001.178-.001.177-.003.178-.006.177-.007.176-.01.177-.012.176-.015.176-.016.173-.018.175-.02.175-.024.174-.025.175-.026.17-.03.174-.03.173-.033.17-.036.172-.037.17-.04.17-.042.172-.043.168-.045.166-.048.169-.05.167-.052.168-.053.164-.056.166-.058.166-.06.16-.062.165-.062.158-.066.165-.068.16-.07.16-.07.158-.075.159-.074.155-.079.158-.08.158-.06.15-.03.158-.001.161.029.159.058.15.085.137.108.119.13.097.144.07.156.044.16.013.16-.017.155-.046.143-.074.127-.1.107-.12.07-.115.083-.164.003-.005.002-.004.082-.166.002-.005.003-.004.08-.167.002-.005.002-.004.078-.168.002-.005.002-.004.076-.169.002-.004.002-.005.074-.17.002-.004.002-.005.072-.17.002-.005.002-.005.07-.171.001-.005.002-.005.068-.172.002-.004.002-.005.065-.173.002-.005.002-.005.063-.173.002-.005.002-.005.06-.174.003-.005.001-.005.06-.175.001-.005.002-.005.057-.176.001-.005.002-.005.055-.177.001-.005.002-.005.052-.177.002-.005.001-.005.051-.178.001-.005.002-.005.048-.179.002-.005v-.005l.047-.179.001-.005.002-.005.044-.18v-.005l.002-.005.042-.18.001-.006.001-.005.04-.181.001-.005.001-.005.037-.182.002-.005v-.005l.036-.182v-.006l.002-.005.033-.182v-.006l.002-.005.03-.183.001-.005.001-.005.029-.184v-.005l.001-.006.027-.184v-.005l.001-.005.024-.185v-.005l.001-.005.022-.185v-.006l.001-.005.02-.185v-.006l.001-.005.017-.186v-.005l.001-.005.015-.187v-.005l.001-.005.013-.187v-.01l.01-.187.001-.006v-.005l.009-.187v-.011l.006-.187v-.011l.004-.188v-.011l.001-.188v-.01l-.001-.188v-.011l-.004-.188v-.011l-.006-.187v-.011l-.007-.145-.022-.16-.05-.152-.08-.141-.103-.124-.125-.102-.141-.077-.153-.05-.16-.02zM.938 15L.777 15l-.158.032-.15.06-.136.087-.117.11-.095.131-.068.146-.04.156-.012.133-.001.14v.01l.001.188v.011l.004.188v.011l.006.187v.011l.008.187v.011l.011.187v.005l.001.005.013.187v.01l.016.187v.01l.018.186v.011l.02.185.001.005v.006l.022.185.001.005v.005l.025.185v.005l.001.005.027.184v.006l.001.005.029.184v.005l.001.005.031.183.001.005.001.006.033.182.001.005.001.006.035.182.001.005.001.005.038.182v.005l.002.005.04.181v.005l.002.005.042.18.001.006.001.005.044.18.002.005v.005l.047.18.001.004.002.005.048.179.002.005.001.005.05.178.002.005.001.005.053.177.002.005.001.005.055.177.002.005.001.005.057.176.002.005.001.005.06.175.001.005.002.005.061.174.002.005.002.005.063.173.002.005.002.005.065.173.002.005.002.004.067.172.002.005.002.005.07.171.002.005.002.005.072.17.002.005.002.004.074.17.002.005.002.004.076.169.002.004.002.005.078.168.002.004.002.005.08.167.003.004.002.005.082.166.002.004.003.005.02.04.086.136.11.118.13.095.146.07.156.041.16.012.16-.019.155-.048.142-.075.126-.1.105-.123.08-.14.054-.152.024-.16-.006-.16-.036-.158-.051-.123-.018-.034-.078-.158L3.1 22.1l-.074-.16-.071-.157-.07-.16-.068-.16-.067-.165-.062-.158-.062-.164-.059-.161-.058-.166-.056-.166-.053-.164-.052-.168-.05-.167-.048-.17-.045-.165-.043-.168-.043-.172-.039-.17-.037-.17-.036-.172-.033-.17-.03-.173-.03-.174-.027-.17-.025-.175-.022-.174-.021-.175-.018-.175-.017-.173-.014-.176-.012-.176-.01-.177-.007-.176-.006-.177-.003-.178L1.73 16v-.134l-.013-.16-.044-.156-.072-.144-.097-.129-.12-.108-.137-.085-.15-.057L.938 15zm26.798 2.024l-.16.007-.157.038-.148.066-.132.092-.113.115-.09.134-.062.148-.03.127-.001.004-.023.134-.024.133-.026.133-.026.13-.03.132-.03.129-.032.134-.033.128-.035.13-.037.128-.038.13-.04.126-.04.128-.044.128-.044.126-.046.126-.048.126-.05.125-.05.125-.051.122-.054.123-.055.122-.056.12-.058.122-.06.12-.061.12-.063.119-.062.116-.067.119-.066.116-.069.115-.069.115-.07.113-.073.113-.074.112-.076.113-.077.112-.077.107-.08.11-.08.107-.085.11-.044.056-.088.135-.06.15-.033.158-.002.16.027.16.057.15.083.138.108.12.128.098.144.072.155.045.16.015.161-.016.155-.044.144-.073.128-.098.09-.099.05-.061.003-.004.003-.005.089-.115.003-.004.003-.005.088-.116.003-.004.003-.005.086-.117.003-.004.003-.005.084-.118.003-.004.003-.005.083-.12.003-.004.003-.004.081-.12.003-.005.003-.004.08-.121.003-.005.003-.004.078-.122.003-.005.003-.004.077-.123.002-.005.003-.004.075-.124.003-.005.003-.004.073-.125.003-.005.003-.004.072-.126.002-.004.003-.005.07-.126.003-.005.002-.005.07-.127.002-.004.002-.005.068-.128.002-.005.002-.004.066-.13.003-.004.002-.005.064-.13.002-.004.003-.005.062-.13.002-.005.003-.005.06-.13.003-.005.002-.005.06-.132.002-.005.002-.005.057-.132.003-.005.002-.005.056-.133.002-.005.002-.005.054-.134.002-.004.002-.005.053-.135.002-.005.002-.005.051-.135.002-.005.002-.005.05-.135.001-.005.002-.005.048-.137.001-.005.002-.005.046-.137.002-.005.002-.005.044-.137.002-.005.002-.005.042-.138.002-.005.001-.006.042-.138.001-.005.002-.005.04-.14V19.4l.002-.005.038-.14.001-.005.002-.005.036-.14.001-.005.001-.005.035-.141.001-.005.001-.005.033-.142.001-.005.001-.005.031-.141.001-.006.002-.005.029-.142v-.005l.002-.005.028-.143v-.005l.002-.005.025-.143.001-.006.001-.005.024-.143.001-.005.001-.006.001-.006.01-.161-.02-.16-.05-.154-.077-.141-.102-.125-.123-.104-.141-.079-.153-.051-.16-.022zM6.841 22.71l-.16.024-.152.053-.14.08-.122.105-.101.126-.076.142-.048.154-.018.16.011.161.041.156.07.146.077.109.04.048.003.004.003.004.095.111.003.004.004.004.096.11.004.005.003.004.098.109.003.004.004.004.1.108.003.004.003.004.101.107.004.004.003.004.102.105.004.004.004.004.103.105.004.004.004.003.105.104.003.004.004.003.106.102.004.004.004.004.107.1.004.004.004.004.108.099.004.003.004.004.11.098.003.003.004.004.11.096.004.003.005.004.11.095.005.003.004.004.113.093.004.003.004.004.113.091.004.004.005.003.114.09.004.004.004.003.116.089.004.003.004.003.117.088.004.003.004.003.118.086.004.003.005.003.118.084.004.003.005.003.119.083.004.003.005.003.12.081.005.003.004.003.121.08.005.003.004.003.122.078.005.003.004.003.123.076.005.003.004.003.124.075.005.003.004.003.125.073.004.003.005.002.126.073.004.002.005.003.126.07.005.003.004.002.128.07.004.002.005.002.128.067.005.003.004.002.13.066.004.002.005.003.13.064.004.002.005.003.13.062.005.002.004.003.132.06.004.003.005.002.132.06.005.002.005.002.132.057.005.002.005.002.133.057.005.002.005.002.133.054.005.002.005.002.13.05.154.045.16.016.16-.015.156-.045.144-.072.128-.098.108-.12.083-.138.057-.15.028-.16-.003-.16-.032-.159-.061-.149-.088-.135-.11-.117-.132-.094-.12-.058-.124-.049-.126-.051-.122-.051-.122-.054-.12-.054-.126-.058-.119-.057-.12-.06-.12-.06-.118-.063-.117-.064-.119-.066-.116-.066-.115-.068-.115-.07-.113-.07-.115-.074-.112-.074-.11-.075-.11-.076-.112-.08-.11-.08-.109-.081-.106-.082-.104-.082-.106-.086-.105-.087-.101-.086-.105-.091-.1-.09-.1-.091-.1-.094-.097-.094-.1-.098-.093-.095-.096-.1-.093-.098-.092-.101-.089-.1-.09-.102-.088-.104-.036-.043-.114-.114-.133-.091-.148-.065-.157-.036-.161-.006zm15.063 2.701l-.16.014-.156.044-.12.057-.06.034-.12.066-.117.064-.118.062-.12.061-.12.06-.118.057-.126.058-.12.054-.122.054-.122.05-.126.052-.125.05-.124.046-.127.047-.125.044-.129.043-.126.04-.13.042-.128.038-.127.035-.13.036-.131.034-.129.031-.132.03-.13.03-.135.027-.133.026-.13.023-.13.022-.137.021-.132.02-.134.017-.132.015-.138.015-.135.013-.133.01-.138.01-.136.007-.134.006-.136.004-.14.003-.16.018-.155.047-.142.076-.127.1-.105.122-.08.14-.054.151-.025.16.006.16.035.158.064.148.09.134.114.114.133.092.147.065.157.036.134.008.145-.002h.011l.147-.005h.01l.147-.007h.011l.146-.009h.011l.146-.01h.005l.005-.001.146-.012h.011l.145-.014h.005l.006-.001.145-.016h.011l.144-.018h.006l.005-.001.144-.02h.011l.144-.021.005-.001h.006l.143-.023.006-.001h.005l.143-.025h.005l.006-.002.143-.026h.005l.005-.002.143-.027.005-.001.005-.001.142-.03h.005l.005-.002.142-.03.005-.002.005-.001.142-.033.005-.001.005-.001.14-.035.006-.001.005-.001.14-.037h.005l.005-.002.14-.038.005-.002h.005l.14-.04.005-.002.005-.001.138-.042.005-.001.006-.002.138-.043.005-.001.005-.002.137-.044.005-.002.005-.002.137-.046.005-.002.005-.001.137-.048.005-.002.005-.002.135-.05.005-.001.005-.002.135-.051.005-.002.005-.002.135-.053.005-.002.004-.002.134-.054.005-.002.005-.002.133-.057.005-.002.005-.002.132-.057.005-.003.005-.002.132-.06.005-.001.004-.002.131-.061.005-.003.005-.002.13-.062.005-.003.005-.002.13-.064.004-.003.005-.002.128-.066.005-.002.005-.003.128-.067.005-.002.004-.003.127-.069.005-.002.005-.003.126-.07.005-.003.004-.003.065-.037.132-.093.112-.115.089-.135.062-.149.034-.157.003-.161-.026-.16-.055-.15-.082-.14-.107-.12-.127-.1-.144-.073-.154-.046-.16-.016zM6.33 26.818l-.16.023-.152.053-.14.08-.122.105-.101.126-.076.142-.048.154-.02.16.012.161.041.156.07.146.094.13.096.093.032.026.004.003.004.004.145.117.004.003.004.004.146.115.005.003.004.004.147.113.005.003.004.004.149.111.004.003.004.003.15.11.005.003.004.003.151.108.004.003.005.003.152.106.005.003.004.003.154.104.004.003.005.003.154.102.005.002.004.003.156.1.005.003.004.003.157.098.005.003.004.002.159.096.004.003.005.003.16.094.004.003.004.002.16.092.005.003.005.002.161.09.005.003.005.002.162.088.005.003.004.002.164.086.005.003.004.002.165.084.005.003.004.002.166.082.004.002.005.003.167.08.004.002.005.002.168.078.004.002.005.002.168.076.005.002.005.002.17.074.004.002.005.002.17.072.005.002.005.002.17.07.006.002.005.001.171.068.005.002.005.002.173.065.005.002.005.002.173.063.005.002.005.002.174.06.005.003.005.001.175.06.005.001.005.002.176.057.005.001.005.002.176.055.006.001.005.002.177.052.005.002.005.001.178.05.005.002.005.002.178.048.006.001.005.002.179.046.005.001.005.002.18.044h.005l.005.002.18.042.006.001.005.001.159.035.16.02.16-.01.157-.04.146-.069.13-.094.112-.117.087-.136.06-.149.033-.158.002-.161-.028-.159-.057-.15-.084-.138-.108-.12-.128-.098-.144-.072-.128-.039-.154-.033-.168-.04-.171-.041-.17-.044-.168-.046-.167-.047-.168-.05-.165-.051-.166-.054-.166-.056-.163-.057-.165-.06-.161-.062-.164-.064-.16-.065-.16-.068-.162-.07-.157-.07-.157-.074-.157-.075-.156-.077-.153-.079-.156-.082-.153-.082-.154-.086-.15-.086-.152-.09-.148-.09-.147-.092-.149-.095-.145-.095-.144-.098-.145-.1-.143-.102-.14-.103-.14-.104-.14-.108-.139-.11-.136-.11-.027-.022-.133-.091-.148-.065-.157-.036-.161-.006zm19.215.087l-.16.01-.157.039-.146.067-.11.076-.064.051-.139.11-.14.108-.14.104-.14.103-.143.101-.145.101-.144.098-.145.095-.149.095-.148.093-.147.089-.152.09-.15.086-.154.086-.153.082-.156.082-.153.079-.156.077-.157.075-.158.073-.157.071-.16.07-.16.068-.161.065-.164.064-.161.061-.165.06-.163.058-.166.056-.166.054-.166.051-.167.05-.167.047-.17.046-.168.044-.171.042-.168.039-.17.037-.11.023-.154.047-.143.075-.126.1-.106.122-.081.139-.054.152-.025.16.006.16.035.158.063.148.09.133.114.115.132.092.148.065.157.037.16.007.133-.016.115-.024.005-.001.005-.001.181-.04h.005l.005-.002.18-.042.006-.001.005-.001.18-.044.005-.002.005-.001.18-.046.004-.002h.005l.179-.05h.005l.005-.002.178-.05.005-.002.005-.002.177-.052.005-.002.005-.001.177-.055.005-.002.005-.001.176-.057.005-.002.005-.002.175-.059.005-.001.005-.002.174-.061.005-.002.005-.002.173-.063.005-.002.005-.002.173-.065.004-.002.005-.002.172-.068.005-.002.005-.002.171-.07.005-.001.005-.002.17-.072.005-.002.004-.002.17-.074.005-.002.004-.002.169-.076.004-.002.005-.002.168-.078.004-.002.005-.003.167-.08.004-.002.005-.002.166-.082.004-.002.005-.003.165-.084.004-.002.005-.003.163-.086.005-.002.005-.003.162-.088.005-.002.005-.003.161-.09.005-.002.004-.003.16-.092.005-.003.005-.002.16-.094.004-.003.004-.003.158-.096.005-.002.004-.003.158-.098.004-.003.005-.003.156-.1.004-.003.004-.003.155-.101.005-.003.004-.003.154-.104.004-.003.004-.003.153-.106.004-.003.005-.003.151-.108.004-.003.005-.003.15-.11.004-.003.004-.003.149-.112.004-.003.004-.003.148-.113.004-.004.004-.003.147-.115.004-.004.004-.003.068-.055.116-.113.092-.132.066-.147.038-.157.008-.16-.022-.16-.05-.153-.08-.14-.103-.125-.124-.102-.142-.077-.153-.05-.16-.02z\",\n  opacity: \".98\"\n})));\n\nfunction _extends$J() { _extends$J = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$J.apply(this, arguments); }\nvar IntermediateEventCatchNonInterruptingSignalIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$J({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M16.012 8.816L9.21 21.026h13.606l-6.803-12.21zm0 1.776l5.332 9.57H10.681l5.331-9.57zm0-10.281c-1.448.02-2.93.157-4.302.628-.852.447-.255 1.863.66 1.574 2.255-.608 4.648-.607 6.922-.108.934.075 1.228-1.376.338-1.67C18.451.44 17.227.317 16.012.311zm9.012 2.934c-.913-.104-1.272 1.258-.454 1.648 1.834 1.36 3.293 3.185 4.31 5.22.526.776 1.842.098 1.515-.78a15.522 15.522 0 00-5.06-6.006c-.1-.044-.203-.07-.31-.082zM6.65 3.59c-.762.089-1.24.809-1.805 1.267C3.38 6.295 2.163 8.007 1.37 9.905c-.266.898 1.094 1.484 1.564.675a14.825 14.825 0 014.327-5.56c.476-.515.09-1.419-.612-1.431zm9.362.007c-.698.066-1.689-.16-2.033.635-.282.733.535 1.358 1.217 1.125 1.806-.147 3.63.203 5.293.907.902.255 1.472-1.112.656-1.573-1.6-.735-3.374-1.089-5.133-1.094zm-5.479 1.365c-.835.15-1.517.76-2.21 1.226-1.203.94-2.318 2.061-3.057 3.402-.33.904 1.063 1.552 1.547.723 1.045-1.656 2.596-2.925 4.285-3.873.545-.499.171-1.463-.565-1.478zm13.903 2.115c-.875-.07-1.22 1.173-.501 1.627 1.325 1.34 2.188 3.062 2.748 4.84.468.84 1.869.21 1.557-.699-.604-2.118-1.751-4.097-3.351-5.615a.93.93 0 00-.453-.153zM4.467 13.132c-.822-.07-.996.826-1.046 1.455-.256 1.93-.094 3.933.562 5.769.406.844 1.807.365 1.612-.551a11.498 11.498 0 01-.334-5.808.874.874 0 00-.794-.865zm26.687 1.6c-.746-.037-1.014.785-.879 1.395.043 2.393-.57 4.771-1.66 6.894-.31.884 1.02 1.536 1.53.75a15.632 15.632 0 001.821-8.372.876.876 0 00-.812-.667zm-30.197.571c-.782-.073-1.044.775-.933 1.404.068 2.414.661 4.833 1.809 6.962.534.77 1.842.076 1.505-.798a14.833 14.833 0 01-1.603-6.861.876.876 0 00-.778-.707zm26.787 2.024c-.777-.048-.952.797-1.021 1.392-.354 1.692-1.202 3.231-2.216 4.608-.407.872.925 1.638 1.48.852 1.361-1.733 2.296-3.827 2.582-6.017a.874.874 0 00-.825-.835zM6.857 23.012c-.808.018-1.082 1.122-.47 1.59 1.393 1.607 3.187 2.886 5.194 3.599.91.222 1.43-1.165.598-1.596a11.495 11.495 0 01-4.723-3.396.899.899 0 00-.599-.197zm15.057 2.7c-.81.194-1.504.76-2.325.972-1.203.458-2.5.536-3.758.664-.869.307-.573 1.728.346 1.663 2.201-.034 4.412-.626 6.293-1.778.604-.495.227-1.532-.556-1.521zM6.346 27.118c-.833.008-1.11 1.218-.395 1.617 1.986 1.602 4.358 2.749 6.868 3.226.933.076 1.227-1.376.338-1.67a14.838 14.838 0 01-6.345-3.066.929.929 0 00-.466-.107zm19.208.087c-.766.09-1.241.841-1.922 1.158-1.516.991-3.251 1.58-4.996 2.005-.872.405-.346 1.849.584 1.604 2.543-.526 4.98-1.66 6.963-3.344.47-.52.072-1.42-.63-1.423z\"\n})));\n\nfunction _extends$I() { _extends$I = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$I.apply(this, arguments); }\nvar IntermediateEventCatchNonInterruptingTimerIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$I({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.998 8.406c-3.018-.041-5.92 1.926-7.031 4.727-1.138 2.695-.51 6.012 1.537 8.103 1.99 2.141 5.268 2.93 8.014 1.927 2.878-.98 4.992-3.827 5.068-6.87.153-2.957-1.624-5.88-4.3-7.137a7.552 7.552 0 00-3.288-.75zm0 1.384c2.759-.052 5.373 1.973 6.015 4.655.704 2.578-.482 5.517-2.791 6.867-2.358 1.48-5.682 1.086-7.618-.918-2.043-1.971-2.407-5.381-.84-7.745 1.11-1.763 3.15-2.88 5.234-2.86zm1.962 1.765l-2.074 3.762c-.64.068-.793 1.04-.202 1.3.39.27.696-.18 1.052-.165h3.17v-.865h-3.182l1.993-3.615c-.252-.14-.505-.278-.757-.417zm-1.965-8.268h-.158l-.147.003h-.011l-.147.005h-.011l-.146.007h-.011l-.146.009h-.011l-.146.01h-.005l-.005.001-.146.012h-.011l-.145.014h-.006l-.005.001-.05.006-.158.031-.15.06-.135.088-.117.111-.094.13-.069.147-.04.156-.01.16.019.16.049.154.076.142.102.125.123.105.14.08.152.051.16.023.134-.003.045-.005.135-.013.133-.01.136-.01.135-.007.137-.006.136-.004.136-.003h.274l.136.003.136.004.136.006.136.007.136.01.133.01.135.013.135.014.135.016.134.018.132.018.134.021.133.023.133.024.133.025.13.027.132.03.132.03.129.031.13.034.129.035.129.036.13.04.126.038.128.042.126.042.128.045.127.047.126.048.12.047.127.051.123.052.006.002.147.048.16.021.16-.009.157-.038.147-.067.131-.093.112-.116.089-.135.062-.149.033-.158.004-.16-.027-.16-.055-.151-.083-.138-.107-.121-.127-.099-.118-.063-.004-.001-.005-.003-.005-.002-.133-.056-.005-.002-.005-.002-.134-.054-.004-.002-.005-.002-.135-.053-.005-.002-.005-.002-.135-.051-.005-.002-.005-.002-.135-.05-.005-.001-.005-.002-.137-.048-.005-.001-.005-.002-.137-.046-.005-.002-.005-.002-.137-.044-.005-.002-.005-.001-.138-.043-.005-.002-.006-.001-.138-.042-.005-.001-.005-.002-.14-.04H19.4l-.005-.002-.14-.038-.005-.001-.005-.002-.14-.036-.005-.001-.005-.001-.141-.035-.005-.001-.005-.001-.142-.033-.005-.001-.005-.001-.141-.031-.006-.002h-.005l-.142-.03-.005-.001-.005-.001-.143-.028h-.005l-.005-.001-.143-.026-.006-.001-.005-.001-.143-.024-.005-.001-.006-.001-.143-.022-.006-.001h-.005l-.144-.022h-.005l-.006-.001-.144-.019h-.005l-.006-.001-.144-.017h-.006l-.005-.001-.145-.016h-.011l-.145-.014H17.1l-.005-.001-.146-.012h-.01l-.146-.01-.006-.001h-.005l-.146-.009h-.011l-.147-.006h-.01l-.147-.005h-.011l-.147-.003h-.01l-.148-.001h-.01zM10.357 4.66l-.156.037-.123.053-.06.032-.005.002-.004.003-.128.069-.004.002-.005.003-.126.07-.005.003-.004.002-.126.072-.005.003-.004.003-.125.073-.004.003-.005.003-.124.075-.004.003-.005.002-.123.077-.004.003-.005.003-.122.078-.004.003-.005.003-.121.08-.004.002-.005.003-.12.082-.005.003-.004.003-.12.083-.004.003-.004.003-.118.084-.005.003-.004.003-.118.086-.004.003-.004.003-.117.088-.004.003-.004.003-.116.089-.004.003-.004.004-.114.09-.005.003-.004.003-.113.092-.004.004-.004.003-.113.093-.004.004-.004.003-.111.095-.004.003-.005.004-.11.096-.004.004-.004.003-.109.098-.004.003-.004.004-.108.1-.004.003-.004.003-.107.101-.004.004-.004.003-.106.102-.003.004-.004.004-.105.103-.004.004-.004.004-.103.105-.004.004-.004.003-.102.106-.003.004-.004.004-.1.107-.004.004-.004.004-.099.108-.004.004-.003.004-.098.11-.003.003-.004.004-.096.11-.004.005-.003.004-.095.111-.003.004-.004.004-.093.113-.003.004-.004.004-.092.113-.003.004-.003.005-.09.114-.004.004-.003.004-.089.116-.003.004-.003.004-.088.117-.003.004-.003.005-.086.117-.003.004-.003.005-.084.118-.003.004-.003.005-.083.12-.003.003-.003.005-.082.12-.003.005-.002.004-.068.103-.076.142-.048.154-.018.16.011.161.041.156.07.146.095.13.117.11.136.086.15.06.158.03.162.002.158-.029.15-.058.138-.085.119-.108.082-.106.065-.099.075-.11.077-.113.077-.107.08-.11.08-.108.084-.108.083-.105.086-.106.086-.104.088-.104.089-.101.09-.102.093-.101.093-.099.094-.097.095-.096.098-.097.098-.095.099-.093.1-.092.103-.091.101-.089.104-.088.104-.086.106-.086.106-.083.106-.082.109-.082.108-.079.11-.078.11-.076.112-.076.112-.074.113-.072.113-.071.115-.07.115-.068.118-.067.117-.065.12-.065.054-.029.135-.088.116-.111.094-.132.068-.146.04-.156.009-.161-.02-.16-.05-.153-.078-.142-.102-.125-.123-.103-.141-.079-.153-.051-.16-.022-.16.008zm13.91 2.116l-.158.037-.147.066-.132.092-.113.116-.09.134-.063.148-.034.157-.005.162.026.159.054.152.082.139.086.102.09.09.094.098.093.099.092.1.091.103.089.101.088.104.086.104.086.106.083.105.083.108.08.108.081.11.077.107.077.112.075.111.075.114.072.113.071.113.07.115.068.117.067.115.065.118.064.117.062.118.061.12.059.119.059.122.056.121.054.12.055.125.051.123.051.125.048.123.049.127.046.126.044.125.043.128.042.129.039.126.038.13.022.076.058.15.086.137.109.119.129.096.145.07.155.043.16.013.161-.017.155-.046.143-.074.126-.1.106-.122.082-.138.055-.152.025-.16-.005-.16-.026-.132-.023-.082-.002-.005-.001-.005-.042-.139-.001-.005-.002-.005-.043-.138-.001-.005-.002-.005-.044-.137-.002-.005-.002-.005-.046-.137-.002-.005-.001-.005-.048-.137-.002-.005-.002-.005-.05-.135-.001-.005-.002-.005-.051-.135-.002-.005-.002-.005-.053-.135-.002-.005-.002-.005-.054-.133-.002-.005-.002-.005-.057-.133-.002-.005-.002-.005-.057-.132-.003-.005-.002-.005-.059-.132-.002-.005-.002-.004-.061-.132-.003-.004-.002-.005-.062-.13-.003-.005-.002-.005-.064-.13-.003-.004-.002-.005-.066-.129-.002-.004-.003-.005-.067-.128-.002-.005-.003-.004-.069-.128-.002-.004-.003-.005-.07-.126-.003-.005-.003-.004-.072-.126-.002-.005-.003-.004-.073-.125-.003-.004-.003-.005-.075-.124-.003-.004-.003-.005-.076-.123-.003-.004-.003-.005-.078-.122-.003-.004-.003-.005-.08-.121-.003-.004-.003-.005-.08-.12-.004-.005-.003-.004-.083-.12-.003-.004-.003-.004-.084-.118-.003-.005-.003-.004-.086-.117-.003-.005-.003-.004-.088-.117-.003-.004-.003-.004-.09-.116-.002-.004-.004-.004-.09-.114-.003-.005-.004-.004-.091-.113-.004-.004-.003-.004-.093-.113-.004-.004-.003-.004-.095-.111-.004-.004-.003-.004-.096-.11-.004-.005-.003-.004-.098-.109-.004-.004-.003-.004-.1-.108-.003-.004-.004-.004-.1-.107-.004-.004-.004-.004-.102-.106-.003-.003-.004-.004-.093-.095-.124-.103-.14-.08-.153-.05-.16-.023-.16.008zM4.288 12.828l-.158.032-.15.06-.135.088-.117.11-.095.131-.069.146-.035.129-.026.132v.005l-.002.005-.025.143-.001.005-.001.006-.024.143-.001.005-.001.006-.022.143-.001.006-.001.005-.02.144-.001.005-.001.006-.019.144v.005l-.001.006-.017.144v.006l-.001.005-.016.145v.011l-.014.145v.006l-.001.005-.012.146v.01l-.01.146-.001.006v.005l-.009.146v.011l-.007.146v.011l-.004.147v.011l-.003.147v.01l-.002.148v.01l.001.148v.01l.003.147v.011l.005.147v.01l.007.147v.011l.009.146v.011l.01.146v.01l.013.146v.011l.014.145v.005l.001.006.016.145v.011l.018.144v.006l.001.005.019.144v.006l.001.005.021.144v.005l.002.006.022.143v.006l.002.005.024.143v.005l.002.006.025.143.001.005.001.005.028.143.001.005.001.005.03.142v.005l.002.006.03.141.002.005.001.006.033.14v.006l.002.005.035.14v.006l.002.005.036.14.002.005.001.005.038.14.001.005.002.005.04.14v.005l.002.005.042.138.001.006.002.005.042.138.002.005.002.005.017.054.064.148.09.134.114.114.132.092.148.065.157.037.16.007.16-.023.153-.052.14-.08.123-.103.102-.126.076-.142.049-.153.02-.16-.01-.161-.032-.13-.017-.051-.039-.126-.038-.13-.037-.128-.035-.13-.033-.128-.033-.134-.03-.13-.029-.131-.026-.13-.026-.132-.024-.134-.023-.133-.02-.132-.02-.136-.017-.132-.016-.135-.014-.135-.012-.133-.012-.138-.009-.133-.007-.136-.006-.138-.004-.134-.003-.136v-.274l.003-.136.004-.134.006-.139.007-.136.01-.132.01-.139.013-.132.014-.135.016-.135.017-.132.02-.137.02-.13.023-.134.024-.133.024-.126.016-.16-.014-.161-.044-.155-.072-.145-.098-.128-.12-.108-.137-.084-.15-.057-.16-.029-.16.002zm23.286 4.202l-.156.038-.148.066-.132.092-.113.115-.09.134-.062.148-.03.127-.001.004-.023.134-.024.134-.026.132-.026.13-.03.132-.03.129-.032.134-.033.128-.035.13-.037.128-.038.13-.04.126-.04.128-.044.128-.044.126-.046.126-.048.126-.05.125-.05.125-.051.122-.054.123-.055.122-.056.12-.058.122-.06.12-.061.12-.062.119-.063.116-.067.119-.066.116-.068.115-.07.115-.07.113-.073.113-.074.112-.076.113-.077.112-.077.107-.08.11-.08.108-.085.109-.044.056-.088.135-.06.15-.033.158-.002.16.027.16.057.15.083.138.108.12.128.098.144.072.155.045.16.015.161-.016.155-.044.144-.073.128-.098.09-.099.05-.061.003-.004.003-.005.089-.115.003-.004.003-.005.088-.116.003-.004.003-.005.086-.117.003-.004.003-.005.084-.118.003-.004.003-.005.083-.12.003-.004.003-.004.082-.12.003-.005.002-.004.08-.121.003-.005.003-.004.078-.122.003-.005.003-.004.077-.123.002-.005.003-.004.075-.124.003-.005.003-.004.073-.125.003-.004.003-.005.072-.126.002-.004.003-.005.07-.126.003-.005.002-.005.07-.127.002-.004.002-.005.068-.128.002-.005.002-.004.066-.13.003-.004.002-.005.064-.13.002-.004.003-.005.062-.13.003-.005.002-.005.06-.13.003-.005.002-.005.06-.132.002-.005.002-.005.057-.132.003-.005.002-.005.056-.133.002-.005.002-.005.054-.134.002-.004.002-.005.053-.135.002-.005.002-.005.051-.135.002-.005.002-.005.05-.135.001-.005.002-.005.048-.137.001-.005.002-.005.046-.137.002-.005.002-.005.044-.137.002-.005.002-.005.042-.138.002-.005.002-.006.04-.138.002-.005.002-.005.04-.14V19.4l.002-.005.038-.14.001-.005.002-.005.036-.14.001-.005.001-.005.035-.141.001-.005.001-.005.033-.141.001-.006.001-.005.031-.141.002-.006v-.005l.03-.142.001-.005.001-.005.028-.143v-.005l.002-.005.025-.143.001-.006.001-.005.024-.143.001-.005.001-.006.001-.006.01-.161-.02-.16-.05-.154-.077-.141-.102-.125-.123-.104-.141-.079-.153-.051-.16-.022-.16.007zM6.681 22.734l-.152.053-.14.08-.122.105-.101.126-.076.142-.048.154-.018.16.011.161.041.156.07.146.077.11.04.047.003.004.003.004.095.111.003.004.004.004.096.11.004.005.003.004.098.109.003.004.004.004.1.108.003.004.003.004.101.107.004.004.003.004.102.106.004.003.004.004.103.105.004.004.004.004.105.103.004.004.003.003.106.102.004.004.004.004.107.1.004.004.004.004.108.099.004.003.004.004.11.098.003.003.004.004.11.096.005.004.004.003.11.095.005.003.004.004.113.093.004.003.004.004.113.091.004.004.005.003.114.09.004.004.004.003.116.089.004.003.004.003.117.088.004.003.004.003.118.086.004.003.005.003.118.084.004.003.005.003.119.083.004.003.005.003.12.081.005.003.004.003.121.08.005.003.004.003.122.078.005.003.004.003.123.076.005.003.004.003.124.075.005.003.004.003.125.073.004.003.005.003.126.072.004.002.005.003.126.07.005.003.004.002.128.07.004.002.005.002.128.068.005.002.004.002.13.066.004.003.005.002.13.064.004.002.005.003.13.062.005.002.004.003.132.06.004.003.005.002.132.06.005.002.005.002.132.057.005.002.005.003.133.056.005.002.005.002.133.054.005.002.005.002.13.05.154.045.16.016.161-.015.155-.045.144-.072.128-.098.108-.12.083-.138.057-.15.028-.16-.003-.16-.032-.158-.061-.15-.088-.135-.11-.117-.132-.094-.12-.058-.124-.049-.126-.051-.122-.051-.122-.054-.12-.054-.126-.058-.119-.057-.12-.06-.12-.06-.118-.063-.117-.064-.119-.066-.116-.066-.115-.068-.115-.07-.113-.07-.115-.074-.112-.074-.11-.075-.11-.076-.112-.079-.11-.08-.109-.082-.106-.082-.104-.082-.106-.086-.105-.087-.101-.086-.105-.091-.1-.09-.1-.091-.1-.094-.097-.094-.1-.098-.093-.095-.096-.1-.093-.098-.092-.101-.089-.1-.09-.102-.088-.104-.036-.043-.114-.114-.133-.091-.148-.065-.157-.036-.161-.006-.16.024zm15.063 2.691l-.156.044-.12.057-.06.034-.12.066-.116.064-.119.062-.12.061-.12.06-.118.057-.126.058-.12.054-.122.054-.122.05-.126.052-.125.05-.124.046-.127.047-.125.044-.129.043-.126.04-.13.042-.128.038-.127.036-.13.035-.131.034-.129.031-.132.03-.13.03-.135.027-.133.026-.13.023-.13.022-.137.021-.132.02-.134.017-.132.015-.138.015-.135.013-.133.01-.138.01-.136.007-.134.006-.136.004-.14.003-.16.018-.155.047-.142.076-.127.1-.105.122-.08.14-.054.151-.025.16.006.16.035.158.064.148.09.134.114.114.133.092.147.065.157.036.134.008.145-.002h.011l.147-.005h.01l.147-.007h.011l.146-.009h.011l.146-.01h.005l.005-.001.146-.012h.011l.145-.014h.005l.006-.001.145-.016h.011l.144-.018h.006l.005-.001.144-.02h.011l.144-.021h.005l.006-.002.143-.022h.006l.005-.002.143-.024h.005l.006-.002.143-.026h.005l.005-.002.143-.027.005-.001.005-.001.142-.03h.005l.005-.002.142-.03.005-.002.005-.001.142-.033.005-.001.005-.001.14-.035.006-.001.005-.001.14-.036.005-.002.005-.001.14-.038.005-.001.005-.002.14-.04h.005l.005-.002.138-.042.005-.001.006-.002.138-.043.005-.001.005-.002.137-.044.005-.002.005-.002.137-.046.005-.002.005-.001.137-.048.005-.002.005-.002.135-.05.005-.001.005-.002.135-.051.005-.002.005-.002.135-.053.005-.002.004-.002.134-.054.005-.002.005-.002.133-.056.005-.003.005-.002.132-.057.005-.002.005-.003.132-.059.005-.002.004-.002.131-.061.005-.003.005-.002.13-.062.005-.003.005-.002.13-.064.004-.002.005-.003.129-.066.004-.002.005-.003.128-.067.005-.002.004-.003.127-.069.005-.002.005-.003.126-.07.005-.003.004-.002.065-.038.132-.093.112-.115.089-.135.062-.149.034-.157.004-.161-.027-.16-.055-.15-.082-.14-.107-.12-.127-.1-.144-.073-.154-.045-.16-.017-.161.014zM15.994 0l-.187.001h-.011l-.188.004h-.011l-.187.006h-.011l-.187.008h-.005L15.2.02l-.187.01h-.005l-.005.001-.187.013h-.01L14.62.06h-.01l-.186.018h-.011l-.185.02-.005.001h-.006l-.185.022-.005.001h-.005l-.185.025h-.005l-.005.001-.184.027h-.006l-.005.001-.184.029h-.005l-.005.001-.183.031-.005.001-.006.001-.182.033-.006.001-.005.001-.182.035-.005.001-.005.001-.182.038h-.005l-.005.002-.181.04h-.005l-.005.002-.18.042-.006.001-.005.001-.18.044-.005.002h-.005l-.17.045-.152.054-.139.082-.121.106-.1.127-.074.143-.046.155-.017.16.013.16.043.156.07.145.097.13.119.108.137.085.15.058.159.03.16-.001.133-.023.165-.043.168-.041.171-.04.171-.037.172-.036.17-.033.173-.03.17-.03.177-.027.171-.025.175-.022.175-.02.175-.02.176-.016.175-.014.177-.012.176-.01.177-.007.174-.006.177-.003L16 1.73h.177l.178.004.174.006.177.007.176.01.177.012.175.014.176.017.175.018.175.02.175.023.171.025.177.027.17.03.173.03.17.033.171.036.154.033.16.02.161-.01.156-.04.146-.069.131-.094.111-.117.088-.135.06-.15.032-.158.002-.16-.027-.16-.057-.15L20 .714l-.108-.12-.128-.097-.144-.073-.129-.038-.158-.035-.005-.001-.005-.001L19.14.31h-.005l-.005-.002-.182-.035h-.006l-.005-.002-.182-.033h-.006l-.005-.002-.183-.03-.005-.001-.005-.001-.184-.029h-.005l-.006-.001-.184-.027h-.005l-.005-.001-.185-.024h-.005L17.968.12 17.783.1l-.006-.001h-.005l-.185-.02h-.006l-.005-.001L17.39.06 17.385.06h-.005l-.187-.015h-.005l-.005-.001-.187-.013h-.01L16.799.02h-.011L16.6.01h-.011l-.187-.006h-.011L16.204 0h-.011L16.005 0h-.01zm8.86 2.939l-.157.033-.15.062-.134.09-.116.111-.093.132-.067.147-.038.156-.01.161.022.16.05.153.078.141.103.124.102.087.045.034.142.106.137.105.14.11.136.11.135.112.134.115.134.117.13.115.132.122.128.12.127.122.127.125.123.126.124.128.121.13.118.128.118.132.117.133.113.134.113.136.11.136.109.137.109.142.104.14.103.14.101.142.1.144.099.146.095.145.094.147.093.15.092.15.087.149.087.15.085.152.083.155.08.152.08.155.04.081.084.138.11.119.128.096.145.072.155.043.16.013.161-.016.155-.046.143-.074.127-.099.106-.12.083-.14.055-.151.026-.16-.004-.16-.034-.158-.05-.124-.042-.085-.002-.004-.003-.005-.084-.165-.002-.004-.003-.005-.086-.164-.002-.004-.003-.005-.088-.162-.002-.005-.003-.005-.09-.161-.002-.005-.003-.004-.092-.16-.002-.005-.003-.005-.094-.16-.003-.004-.003-.004-.096-.159-.002-.004-.003-.005-.098-.157-.003-.004-.003-.005-.1-.156-.003-.004-.002-.005-.102-.154-.003-.005-.003-.004-.104-.154-.003-.004-.003-.005-.106-.152-.003-.004-.003-.005-.108-.151-.003-.004-.003-.005-.11-.15-.003-.004-.003-.004-.111-.15-.004-.003-.003-.005-.113-.147-.004-.004-.003-.005-.115-.146-.004-.004-.003-.004-.117-.145-.004-.004-.003-.004-.12-.144-.003-.004-.003-.004-.121-.142-.003-.004-.004-.004-.123-.141-.003-.004-.004-.004-.125-.14-.003-.004-.004-.004-.127-.138-.003-.004-.004-.004-.128-.136-.004-.004-.004-.004-.13-.135-.004-.004-.003-.004-.133-.134-.003-.004-.004-.003-.134-.133-.004-.003-.004-.004-.135-.13-.004-.004-.004-.004-.136-.128-.004-.004-.004-.004-.138-.126-.004-.004-.004-.003-.14-.125-.004-.004-.004-.003-.14-.123-.005-.004-.004-.003-.142-.121-.004-.004-.004-.003-.144-.12-.004-.003-.004-.003-.145-.117-.004-.004-.004-.003-.147-.115-.004-.004-.004-.003-.148-.113-.004-.003-.004-.004-.149-.111-.004-.003-.004-.004-.05-.036-.14-.083-.15-.055-.16-.027-.16.004zm-18.381.348l-.157.037-.147.066-.111.074-.04.032-.005.003-.004.004-.145.117-.004.003-.004.004-.144.119-.004.003-.004.004-.142.12-.004.004-.004.004-.141.123-.004.003-.004.004-.14.125-.004.003-.004.004-.138.126-.004.004-.004.004-.136.128-.004.004-.004.004-.135.13-.004.004-.004.003-.134.133-.004.003-.004.004-.132.134-.003.004-.004.004-.13.135-.004.004-.004.004-.128.136-.004.004-.004.004-.126.138-.004.004-.003.004-.125.14-.004.004-.003.004-.123.14-.004.005-.003.004-.121.142-.004.004-.003.004-.12.144-.003.004-.003.004-.117.145-.004.004-.003.004-.115.146-.004.005-.003.004-.113.147-.003.005-.004.004-.111.149-.003.004-.004.004-.11.15-.002.005-.003.004-.108.151-.003.005-.003.004-.106.152-.003.005-.003.004-.104.154-.003.004-.003.005-.102.154-.003.005-.002.004-.1.156-.003.005-.003.004-.098.157-.003.005-.003.004-.096.159-.002.004-.003.005-.094.16-.003.004-.002.004-.092.16-.003.005-.003.005-.09.161-.002.005-.003.005-.088.162-.002.005-.003.004-.086.164-.002.005-.002.004-.084.165-.003.005-.002.004-.082.166-.002.005-.003.004-.08.167-.002.004-.002.005-.078.168-.002.004-.002.005-.045.1-.053.153-.023.16.007.16.037.157.065.148.092.132.114.114.134.09.148.064.157.035.161.006.16-.025.152-.054.14-.08.121-.106.1-.126.065-.118.043-.095.074-.16.075-.155.077-.157.08-.155.08-.152.083-.155.085-.152.086-.15.088-.149.091-.15.094-.15.094-.147.095-.145.099-.146.1-.144.1-.142.104-.14.104-.14.11-.142.107-.137.11-.136.114-.136.113-.134.117-.133.118-.132.117-.129.122-.13.124-.127.123-.126.127-.125.127-.122.128-.12.132-.122.13-.115.133-.117.135-.115.135-.111.136-.11.037-.03.117-.11.094-.132.068-.146.04-.156.01-.161-.02-.16-.05-.154-.076-.141-.102-.125-.123-.104-.14-.08-.153-.051-.16-.023-.161.008zm24.514 11.15l-.157.04-.146.067-.131.093-.112.117-.088.135-.061.149-.033.157-.005.134.006.14.006.176.003.177.001.178-.001.177-.003.178-.006.177-.007.176-.01.177-.012.176-.015.176-.016.173-.018.175-.02.175-.024.174-.024.175-.027.17-.03.174-.03.173-.033.17-.036.172-.037.17-.04.17-.042.172-.043.168-.045.166-.048.169-.05.167-.052.168-.053.164-.056.166-.058.166-.06.161-.061.164-.063.158-.066.165-.068.16-.07.16-.07.158-.075.159-.074.155-.078.158-.081.158-.06.15-.03.158-.001.161.029.159.058.15.085.137.108.12.13.096.144.07.156.044.16.013.16-.017.155-.046.143-.074.127-.1.107-.12.07-.115.083-.164.003-.005.002-.004.082-.166.002-.005.003-.004.08-.167.002-.005.002-.004.078-.168.002-.004.002-.005.076-.169.002-.004.002-.005.074-.17.002-.004.002-.005.072-.17.002-.005.002-.005.07-.17.002-.006.001-.005.068-.172.002-.004.002-.005.065-.173.002-.005.002-.005.063-.173.002-.005.002-.005.06-.174.003-.005.001-.005.06-.175.001-.005.002-.005.057-.176.001-.005.002-.005.055-.177.001-.005.002-.005.052-.177.002-.005.001-.005.051-.178.001-.005.002-.005.048-.179.002-.005v-.005l.047-.179.001-.005.002-.005.044-.18v-.005l.002-.005.042-.18.001-.006.001-.005.04-.18.001-.006.001-.005.038-.182v-.005l.002-.005.035-.182v-.006l.002-.005.033-.182v-.006l.002-.005.03-.183.001-.005.001-.005.029-.184v-.005l.001-.006.027-.184v-.005l.001-.005.024-.185v-.005l.001-.005.022-.185v-.006l.001-.005.02-.185v-.006l.001-.005.017-.186v-.005l.001-.005.015-.187v-.005l.001-.005.013-.187v-.01l.01-.187.001-.006v-.005l.009-.187v-.011l.006-.187v-.011l.004-.188v-.011l.001-.188v-.01l-.001-.188v-.011l-.004-.188v-.011l-.006-.187v-.011l-.007-.145-.022-.16-.05-.152-.08-.141-.103-.124-.125-.102-.141-.077-.153-.05-.16-.02-.161.009zM.777 15l-.158.032-.15.06-.136.087-.117.11-.095.131-.068.146-.04.156-.012.133-.001.14v.01l.001.188v.011l.004.188v.011l.006.187v.011l.008.187v.011l.011.187v.005l.001.005.013.187v.01l.016.187v.01l.018.186v.011l.02.185.001.005v.006l.022.185.001.005v.005l.025.185v.005l.001.005.027.184v.006l.001.005.029.184v.005l.001.005.031.183.001.005.001.006.033.182.001.005.001.006.035.182.001.005.001.005.038.182v.005l.002.005.04.181v.005l.002.005.042.18.001.006.001.005.044.18.002.005v.005l.047.18.001.004.002.005.048.179.002.005.001.005.05.178.002.005.001.005.053.177.002.005.001.005.055.177.002.005.001.005.057.176.002.005.001.005.06.175.001.005.002.005.061.174.002.005.002.005.063.173.002.005.002.005.065.173.002.005.002.004.067.172.002.005.002.005.07.171.002.005.002.005.072.17.002.005.002.005.074.169.002.005.002.004.076.169.002.005.002.004.078.168.002.004.002.005.08.167.003.004.002.005.082.166.002.004.003.005.02.04.086.136.11.118.13.095.146.07.156.041.16.012.16-.019.155-.048.142-.075.126-.1.105-.123.08-.14.054-.152.024-.16-.006-.16-.036-.158-.051-.123-.018-.034-.078-.158L3.1 22.1l-.074-.16-.071-.156-.07-.162-.068-.16-.067-.164-.062-.158-.062-.164-.059-.161-.058-.166-.056-.166-.053-.164-.052-.168-.05-.167-.048-.17-.045-.165-.043-.168-.043-.172-.039-.17-.037-.17-.036-.172-.033-.17-.03-.173-.03-.174-.027-.17-.025-.175-.022-.174-.021-.175-.018-.175-.017-.173-.014-.176-.012-.176-.01-.177-.007-.176-.006-.177-.003-.178L1.73 16v-.134l-.013-.16-.044-.156-.072-.144-.097-.129-.12-.108-.137-.085-.15-.057L.938 15 .777 15zM6.17 26.842l-.152.052-.14.08-.122.105-.101.126-.076.142-.048.154-.02.16.012.161.041.156.07.146.094.13.096.093.032.026.004.003.004.004.145.117.004.003.004.004.146.115.005.003.004.004.147.113.005.003.004.004.149.111.004.003.004.003.15.11.005.003.004.003.151.108.005.003.004.003.152.106.005.003.004.003.154.104.004.003.005.003.154.102.005.002.004.003.156.1.005.003.004.003.157.098.005.003.004.002.159.096.004.003.005.003.16.094.004.003.004.002.16.092.005.003.005.002.161.09.005.003.005.003.162.088.005.002.004.002.164.087.005.002.004.002.165.084.005.003.004.002.166.082.004.002.005.003.167.08.004.002.005.002.168.078.004.002.005.002.169.076.004.002.005.002.17.074.004.002.005.002.17.072.005.002.005.002.17.07.006.002.005.001.171.068.005.002.005.002.173.065.005.002.005.002.173.063.005.002.005.002.174.061.005.002.005.001.175.06.005.001.005.002.176.057.005.001.005.002.177.055.005.001.005.002.177.052.005.002.005.001.178.051.005.001.005.002.178.048.006.002h.005l.179.047.005.001.005.002.18.044h.005l.005.002.18.042.006.001.005.001.159.035.16.02.16-.01.157-.04.146-.069.13-.094.112-.117.087-.136.06-.149.033-.158.002-.161-.028-.159-.057-.15-.084-.138-.108-.12-.128-.098-.144-.072-.128-.039-.154-.033-.168-.04-.171-.041-.169-.044-.17-.045-.166-.048-.168-.05-.165-.051-.166-.054-.166-.056-.163-.057-.165-.06-.161-.062-.164-.064-.16-.065-.16-.068-.162-.07-.157-.07-.157-.074-.157-.075-.156-.077-.153-.079-.156-.082-.153-.082-.154-.086-.15-.086-.152-.09-.148-.09-.147-.092-.149-.095-.145-.095-.144-.098-.145-.1-.143-.102-.14-.103-.14-.104-.14-.108-.139-.11-.136-.11-.027-.022-.133-.091-.148-.065-.157-.036-.161-.006-.16.024zm19.214.073l-.156.039-.146.067-.11.076-.064.051-.139.11-.14.108-.14.104-.14.103-.143.101-.145.101-.144.098-.145.095-.149.095-.148.093-.147.089-.152.09-.15.086-.154.086-.153.082-.156.082-.153.079-.156.077-.157.075-.157.073-.158.071-.16.07-.16.068-.161.065-.164.064-.161.061-.165.06-.163.058-.166.056-.166.054-.166.051-.167.05-.167.048-.17.045-.168.044-.171.042-.168.039-.17.037-.11.023-.154.047-.143.075-.126.1-.106.122-.081.139-.054.152-.025.16.006.16.035.158.063.148.09.133.114.115.132.092.148.065.157.037.16.008.133-.017.115-.024h.005l.005-.002.181-.04h.005l.005-.002.18-.042.006-.001.005-.001.18-.044.005-.002h.005l.18-.047.004-.001.005-.002.179-.048.005-.002.005-.001.178-.05.005-.002.005-.002.177-.052.005-.002.005-.001.177-.055.005-.002.005-.001.176-.057.005-.002.005-.002.175-.059.005-.001.005-.002.174-.061.005-.002.005-.002.173-.063.005-.002.005-.002.173-.065.005-.002.004-.002.172-.068.005-.001.005-.002.171-.07.005-.002.005-.002.17-.072.005-.002.005-.002.169-.074.005-.002.004-.002.169-.076.004-.002.005-.002.168-.078.004-.002.005-.002.167-.08.004-.003.005-.002.166-.082.004-.002.005-.003.165-.084.004-.002.005-.002.163-.087.005-.002.005-.002.162-.088.005-.003.005-.003.161-.09.005-.002.004-.003.16-.092.005-.002.005-.003.16-.094.004-.003.004-.003.158-.096.005-.002.004-.003.158-.098.004-.003.005-.003.156-.1.004-.003.004-.002.155-.102.005-.003.004-.003.154-.104.004-.003.005-.003.152-.106.004-.003.005-.003.151-.108.004-.003.005-.003.15-.11.004-.003.004-.003.149-.111.004-.004.004-.003.148-.113.004-.004.004-.003.147-.115.004-.004.004-.003.068-.055.116-.113.092-.132.066-.147.038-.157.008-.16-.022-.16-.05-.153-.08-.14-.103-.125-.124-.102-.142-.077-.153-.05-.16-.02-.16.009z\"\n})));\n\nfunction _extends$H() { _extends$H = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$H.apply(this, arguments); }\nvar IntermediateEventCatchParallelMultipleIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$H({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.003C8.195-.157.935 6.24.125 13.985c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.884 23.445.408 17.201.049c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.174.872 11.679 4.985 6.916c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.215-2.282-2.022-5.3-3.217-8.357-3.22zM16 4.975c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.082 11.082 0 0116 4.975zm-2.15 3.281v5.534H8.213v4.38h5.636v5.534h4.31V18.17h5.639v-4.38h-5.64V8.256h-4.31zm.865.865h2.583v5.534h5.635v2.65h-5.635v5.533h-2.583v-5.534h-5.64v-2.649h5.64V9.121z\"\n})));\n\nfunction _extends$G() { _extends$G = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$G.apply(this, arguments); }\nvar IntermediateEventCatchSignalIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$G({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.049C8.195-.11.935 6.286.125 14.03c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.93 23.445.453 17.201.095c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.22.872 11.725 4.985 6.962c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.216-2.282-2.021-5.3-3.216-8.357-3.22zM16 5.021c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.083 11.083 0 0116 5.021zm.006 3.521L9.206 20.745h13.598L16.005 8.542zm0 1.775l5.329 9.564H10.677l5.328-9.564z\"\n})));\n\nfunction _extends$F() { _extends$F = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$F.apply(this, arguments); }\nvar IntermediateEventCatchTimerIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$F({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.97.04h-.127C8.713-.018 2.003 5.334.437 12.286c-1.51 6.123.98 13.005 6.136 16.665 5.125 3.788 12.546 4.105 17.912.623 5.272-3.276 8.33-9.766 7.325-15.916-.904-6.241-5.79-11.7-11.95-13.143A16.082 16.082 0 0015.97.04zm-.181 1.724c.115 0 .23 0 .347.003 6.625-.066 12.823 5.149 13.89 11.69 1.13 5.91-1.908 12.349-7.262 15.138-5.473 3.013-12.866 1.884-17.116-2.726C1.291 21.372.444 13.914 3.802 8.602c2.493-4.112 7.169-6.819 11.987-6.838zm.283 1.554c-.117 0-.234.002-.351.005-6.1 0-11.691 5.049-12.346 11.114-.78 5.684 2.795 11.612 8.218 13.52 5.139 1.943 11.416.101 14.624-4.38 3.461-4.583 3.262-11.538-.596-15.831-2.36-2.747-5.924-4.423-9.549-4.428zm-.078 1.695c.078 0 .156 0 .234.003 5.4 0 10.321 4.556 10.734 9.942.563 5.13-2.958 10.364-7.971 11.678-4.832 1.41-10.457-.935-12.746-5.446-2.463-4.559-1.2-10.795 3.014-13.883a11.072 11.072 0 016.735-2.294zm-.137 3.42c-2.965.02-5.792 1.968-6.884 4.722-1.137 2.693-.509 6.007 1.536 8.096 1.988 2.14 5.263 2.929 8.007 1.926 2.875-.98 4.987-3.824 5.063-6.865.154-2.954-1.622-5.875-4.295-7.13a7.545 7.545 0 00-3.427-.75zm.27 1.381c2.708.013 5.249 2.014 5.88 4.652.704 2.576-.481 5.512-2.788 6.862-2.356 1.478-5.677 1.084-7.611-.918-2.042-1.97-2.405-5.376-.839-7.738 1.11-1.762 3.146-2.877 5.229-2.857h.13zm1.831 1.764l-2.072 3.76c-.64.068-.792 1.039-.202 1.298.39.27.696-.18 1.051-.164h3.168v-.864h-3.18l1.992-3.612-.757-.418z\"\n})));\n\nfunction _extends$E() { _extends$E = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$E.apply(this, arguments); }\nvar IntermediateEventNoneIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$E({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.848.001C8.113-.093.931 6.281.125 13.983c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.207C29.105 4.938 23.55.48 17.367.06A16.448 16.448 0 0015.848 0v.001zm.293 1.727c7.113-.099 13.662 5.97 14.077 13.08.56 6.299-3.516 12.735-9.582 14.679-5.798 2.004-12.806-.12-16.283-5.237C.717 19.159.874 11.638 5.016 6.876 7.722 3.638 11.902 1.63 16.14 1.728zm-.415 1.555C9.157 3.258 3.256 9.156 3.278 15.729c-.16 5.965 4.365 11.725 10.293 12.737 5.409 1.065 11.37-1.744 13.775-6.753 2.534-4.986 1.386-11.627-2.953-15.251-2.364-2.077-5.512-3.27-8.667-3.18zm.507 1.692c5.82-.026 11.013 5.318 10.79 11.143-.024 5.3-4.313 10.267-9.636 10.803-5.075.667-10.426-2.588-11.885-7.553-1.535-4.744.494-10.46 4.925-12.885a11.072 11.072 0 015.806-1.508z\"\n})));\n\nfunction _extends$D() { _extends$D = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$D.apply(this, arguments); }\nvar IntermediateEventThrowCompensationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$D({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.003C8.195-.156.935 6.24.125 13.985c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.884 23.445.407 17.201.049c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.174.872 11.679 4.985 6.916c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.216-2.282-2.021-5.3-3.216-8.357-3.22zM16 4.975c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.083 11.083 0 0116 4.975zm-.56 5.772l-7.408 5.231 7.409 5.234v-5.057c2.385 1.687 4.771 3.371 7.157 5.057V10.747l-7.157 5.055v-5.055z\"\n})));\n\nfunction _extends$C() { _extends$C = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$C.apply(this, arguments); }\nvar IntermediateEventThrowEscalationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$C({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.049C8.195-.11.935 6.286.125 14.03c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.93 23.445.453 17.201.095c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.22.872 11.725 4.985 6.962c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.216-2.282-2.021-5.3-3.216-8.357-3.22zM16 5.021c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.083 11.083 0 0116 5.021zm.006 3.927c-1.672 4.654-2.734 9.502-4.406 14.155 1.534-1.525 2.872-3.234 4.406-4.759l4.406 4.76c-1.496-4.71-2.91-9.446-4.406-14.156z\"\n})));\n\nfunction _extends$B() { _extends$B = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$B.apply(this, arguments); }\nvar IntermediateEventThrowLinkIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$B({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.049C8.195-.11.935 6.286.125 14.03c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.93 23.445.453 17.201.095c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.22.872 11.725 4.985 6.962c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.216-2.282-2.021-5.3-3.216-8.357-3.22zM16 5.021c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.083 11.083 0 0116 5.021zm1.78 4.093v3.555H9.785v6.714h7.994v3.554l5.829-6.911-5.83-6.912z\"\n})));\n\nfunction _extends$A() { _extends$A = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$A.apply(this, arguments); }\nvar IntermediateEventThrowMessageIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$A({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.003C8.195-.156.935 6.24.125 13.985c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.884 23.445.407 17.201.049c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.174.872 11.679 4.985 6.916c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.216-2.282-2.021-5.3-3.216-8.357-3.22zM16 4.975c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.083 11.083 0 0116 4.975zm-5.91 5.475l6.04 4.901 6.042-4.9H10.088zm-1.341 1.138v9.921h14.514V11.79l-7.132 5.787-7.382-5.99z\"\n})));\n\nfunction _extends$z() { _extends$z = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$z.apply(this, arguments); }\nvar IntermediateEventThrowMultipleIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$z({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.003C8.195-.156.935 6.24.125 13.985c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.884 23.445.407 17.201.049c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.174.872 11.679 4.985 6.916c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.216-2.282-2.021-5.3-3.216-8.357-3.22zM16 4.975c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.083 11.083 0 0116 4.975zm.006 3.073l-7.62 5.532 2.91 8.95h9.42l2.91-8.95-7.62-5.532z\"\n})));\n\nfunction _extends$y() { _extends$y = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$y.apply(this, arguments); }\nvar IntermediateEventThrowSignalIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$y({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.975.003C8.195-.156.935 6.24.125 13.985c-.855 6.55 2.741 13.46 8.74 16.314 5.666 2.847 13.012 1.99 17.71-2.33 4.745-4.162 6.727-11.243 4.532-17.206C29.09 4.884 23.445.407 17.201.049c-.408-.03-.817-.046-1.226-.046zm-.181 1.724c7.134-.269 13.84 5.68 14.399 12.804.686 6.283-3.267 12.792-9.283 14.862-5.847 2.162-13.025.06-16.557-5.141C.728 19.174.872 11.679 4.985 6.916c2.632-3.171 6.671-5.174 10.809-5.19zm.283 1.553c-6.6-.21-12.671 5.585-12.79 12.185-.292 5.964 4.129 11.817 10.034 12.953 5.47 1.198 11.584-1.613 14.025-6.702 2.525-4.97 1.396-11.585-2.912-15.216-2.282-2.021-5.3-3.216-8.357-3.22zM16 4.975c5.818-.154 11.117 5.082 11.024 10.905.103 5.384-4.23 10.5-9.636 11.043-5.075.667-10.426-2.587-11.885-7.552-1.53-4.73.48-10.428 4.888-12.864A11.083 11.083 0 0116 4.975zm.006 3.52c-2.261 4.07-4.533 8.136-6.798 12.205h13.596L16.005 8.495z\"\n})));\n\nfunction _extends$x() { _extends$x = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$x.apply(this, arguments); }\nvar LaneIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$x({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M0 7v18.62h32V7H0zm1.655 17.056V8.684h28.62v15.372H1.656z\"\n})));\n\nfunction _extends$w() { _extends$w = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$w.apply(this, arguments); }\nvar ManualTaskIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$w({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M6.494 3C2.916 3 0 5.903 0 9.475v13.383c0 3.572 2.916 6.475 6.494 6.475h19.012c3.578 0 6.494-2.903 6.494-6.475V9.475C32 5.903 29.084 3 25.506 3H6.494zm0 2h19.012C28.015 5 30 6.98 30 9.475v13.383c0 2.495-1.985 4.475-4.494 4.475H6.494C3.985 27.333 2 25.353 2 22.858V9.475C2 6.98 3.985 5 6.494 5zm4.43 1.328c-.222.005-.43.09-.606.203-.985.638-4.356 2.977-5.096 3.486-.67.46-1.12 1.153-1.38 1.974-.27.858-.235 1.793-.232 2.576.002.59.016 1.104.17 1.727.22.908.634 1.63 1.23 2.118.597.49 1.363.732 2.23.734 3.038.012 6.078.016 9.119 0 .327-.002.645-.127.848-.37.204-.241.287-.56.291-.914a1.732 1.732 0 00-.097-.625h.327c.335 0 .641-.11.852-.316.21-.206.317-.475.374-.754a1.783 1.783 0 00-.126-1.143 1.18 1.18 0 00.877-.521c.196-.306.257-.666.258-1.025.001-.375-.088-.738-.293-1.033a1.179 1.179 0 00-.958-.512h-.478c.108-.237.156-.505.155-.782-.003-.373-.098-.721-.316-.99a1.21 1.21 0 00-.943-.43c-2.273-.004-4.236.018-6.412.012l-.19-.001c.102-.104.202-.205.312-.314.337-.336.662-.652.83-.869.4-.516.46-1.215.123-1.729-.178-.272-.439-.456-.72-.494a.93.93 0 00-.148-.008zm.029.728l.022.001c.055.008.115.027.209.172.132.201.126.606-.09.884-.079.102-.431.465-.767.8-.337.334-.657.643-.815.836-.153.186-.096.338-.056.435.04.096.085.212.298.263.063.014.066.01.086.012l.066.003c2.429.027 4.986-.004 7.223-.003.194 0 .293.056.379.162.086.105.151.286.153.533 0 .257-.065.467-.155.59-.09.124-.183.182-.37.183-1.706-.001-3.411-.005-5.117-.009v.731c2.23.004 4.461.01 6.692.012.17 0 .265.06.361.2.096.138.164.364.163.615 0 .268-.058.501-.143.634-.085.132-.162.193-.385.195-2.32-.001-4.554-.006-6.688-.003v.73c1.905 0 3.809.003 5.713.001.194.005.316.09.416.26.102.173.151.442.093.728-.04.193-.102.313-.17.38-.067.065-.148.108-.343.108h-5.71l.002.734c1.445 0 2.89-.01 4.334-.001.162 0 .232.041.297.123.064.081.123.238.12.488-.003.244-.061.385-.12.455-.06.07-.127.11-.296.11-3.037.016-6.076.012-9.113 0-.735-.002-1.316-.196-1.77-.568-.454-.372-.793-.935-.986-1.728-.134-.546-.146-.978-.148-1.558-.003-.796-.018-1.664.199-2.354.222-.705.582-1.24 1.096-1.593.75-.515 4.14-2.866 5.079-3.474a.504.504 0 01.241-.087z\"\n})));\n\nfunction _extends$v() { _extends$v = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$v.apply(this, arguments); }\nvar MessageFlowIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$v({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M4.073 26.607l1.295 1.296L1.325 32l-.662-.633L0 30.735l4.073-4.128zm6.953-7.046l1.296 1.296L1.325 32l7.555-7.656-1.295-1.296 1.455-1.474 1.986-2.013zM32 .06s-2.699 5.189-5.417 10.462l-.326.633c-1.14 2.214-2.265 4.407-3.176 6.2-1.228-1.222-2.449-2.452-3.676-3.675l-3.57 3.618-1.297-1.296 3.541-3.588c-.98-.964-1.932-1.958-2.923-2.91l-.753-.706c2.68-1.258 6.533-3.165 9.95-4.876l.617-.309C28.838 1.673 32 .06 32 .06zm-4.126 4.06l-.015.007-.115.057-.048.024-.115.057L17.7 9.172l5.017 4.948 5.157-10z\"\n})));\n\nfunction _extends$u() { _extends$u = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$u.apply(this, arguments); }\nvar ParticipantIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$u({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M0 5v22.069h32V5H0zm30.276 1.684v18.82H6.62V6.684h23.655zm-28.62 0h3.31v18.82h-3.31V6.684z\"\n})));\n\nfunction _extends$t() { _extends$t = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$t.apply(this, arguments); }\nvar ProcessIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$t({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  fillRule: \"evenodd\",\n  d: \"M16.177 0l.137.002c.452.009.9.037 1.342.082.346.036.62.303.68.646l.437 2.536c.055.319.296.57.608.655.986.269 1.923.653 2.796 1.14.28.155.624.145.885-.039l2.083-1.47a.775.775 0 01.937.022c.86.699 1.645 1.484 2.343 2.343.22.27.223.653.023.937l-1.439 2.038a.833.833 0 00-.031.896c.512.889.92 1.846 1.204 2.855a.833.833 0 00.653.601l2.435.42c.342.059.61.333.645.679a15.928 15.928 0 01.08 2.064l-.003.114c-.012.382-.038.76-.077 1.134a.775.775 0 01-.645.68l-2.396.412a.835.835 0 00-.656.61 12.511 12.511 0 01-1.2 2.917.832.832 0 00.034.892l1.396 1.978c.2.284.196.667-.023.936a16.104 16.104 0 01-2.343 2.343.775.775 0 01-.937.023l-1.99-1.404a.833.833 0 00-.88-.026c-.907.516-1.886.922-2.916 1.2a.833.833 0 00-.61.656l-.414 2.396a.775.775 0 01-.679.646 16.096 16.096 0 01-3.312 0 .775.775 0 01-.679-.646l-.423-2.452a.834.834 0 00-.598-.636 12.474 12.474 0 01-1.468-.514 12.49 12.49 0 01-1.417-.68.833.833 0 00-.878.03l-2.026 1.43a.775.775 0 01-.937-.023 16.069 16.069 0 01-2.342-2.342.774.774 0 01-.024-.936l1.402-1.986a.833.833 0 00.032-.896 12.507 12.507 0 01-1.214-2.911.833.833 0 00-.655-.606l-2.386-.412a.775.775 0 01-.646-.678 16.097 16.097 0 010-3.314.775.775 0 01.646-.678l2.386-.412a.833.833 0 00.655-.606 12.507 12.507 0 011.214-2.911.833.833 0 00-.032-.896L3.552 6.853a.774.774 0 01.023-.936 16.091 16.091 0 012.343-2.343.775.775 0 01.937-.023l2.03 1.433c.26.177.6.182.874.028.915-.512 1.88-.9 2.87-1.167a.833.833 0 00.612-.656l.424-2.46a.775.775 0 01.679-.645C14.845.032 15.348.004 15.85 0h.326zM16 6.4c-5.302 0-9.6 4.297-9.6 9.599 0 5.302 4.298 9.6 9.6 9.6s9.6-4.298 9.6-9.6-4.298-9.6-9.6-9.6zm-3 4.283c0-1.425 1.637-2.203 2.715-1.29l5.69 4.815c.794.672.794 1.91 0 2.583l-5.69 4.815c-1.078.913-2.715.134-2.715-1.29z\"\n})));\n\nfunction _extends$s() { _extends$s = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$s.apply(this, arguments); }\nvar ReceiveTaskIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$s({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M6.494 3C2.916 3 0 5.903 0 9.475v13.383c0 3.572 2.916 6.475 6.494 6.475h19.012c3.578 0 6.494-2.903 6.494-6.475V9.475C32 5.903 29.084 3 25.506 3H6.494zm0 2h19.012C28.015 5 30 6.98 30 9.475v13.383c0 2.495-1.985 4.475-4.494 4.475H6.494C3.985 27.333 2 25.353 2 22.858V9.475C2 6.98 3.985 5 6.494 5zM5.23 7.764v11.577h17.55V7.764H5.23zm1.816.758h13.917l-6.959 4.577-6.958-4.577zm-1.06.21l8.018 5.274 8.018-5.275v9.853H5.987V8.73z\"\n})));\n\nfunction _extends$r() { _extends$r = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$r.apply(this, arguments); }\nvar ScriptTaskIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$r({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M6.494 3C2.916 3 0 5.903 0 9.475v13.383c0 3.572 2.916 6.475 6.494 6.475h19.012c3.578 0 6.494-2.903 6.494-6.475V9.475C32 5.903 29.084 3 25.506 3H6.494zm0 2h19.012C28.015 5 30 6.98 30 9.475v13.383c0 2.495-1.985 4.475-4.494 4.475H6.494C3.985 27.333 2 25.353 2 22.858V9.475C2 6.98 3.985 5 6.494 5zm2.99 3.077l-.077.045-.026.015c-1.09.646-1.84 1.239-2.336 1.818-.496.579-.735 1.162-.742 1.725-.014 1.119.812 1.958 1.544 2.708.732.75 1.385 1.456 1.446 2.041.032.298-.039.598-.364 1.008-.324.408-.911.897-1.85 1.445l-1.388.808h8.56l.101-.059c.996-.58 1.667-1.116 2.094-1.655.429-.54.603-1.107.547-1.638-.11-1.052-.967-1.818-1.688-2.556-.721-.739-1.306-1.436-1.298-2.092.004-.331.132-.7.535-1.171.402-.47 1.08-1.02 2.119-1.636l1.362-.806h-8.54zm.241.867h5.271a6.83 6.83 0 00-1.113 1.01c-.496.58-.736 1.163-.743 1.726-.014 1.119.812 1.958 1.544 2.708.732.75 1.385 1.456 1.446 2.041.032.298-.039.598-.364 1.008-.312.393-.872.862-1.753 1.386H8.728c.367-.286.658-.566.88-.847.43-.54.604-1.107.548-1.638-.11-1.052-.968-1.818-1.688-2.556-.721-.739-1.306-1.435-1.298-2.092.004-.331.132-.7.534-1.171.389-.454 1.04-.984 2.021-1.575zm-1.233 1.48v.4h4.12v-.4h-4.12zm-.154 2.158v.4H12.6v-.4H8.34zm1.931 2.158v.4h4.126v-.4H10.27zm.59 2.158v.4h4.276v-.4h-4.276z\"\n})));\n\nfunction _extends$q() { _extends$q = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$q.apply(this, arguments); }\nvar SendTaskIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$q({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M6.494 3C2.916 3 0 5.903 0 9.475v13.383c0 3.572 2.916 6.475 6.494 6.475h19.012c3.578 0 6.494-2.903 6.494-6.475V9.475C32 5.903 29.084 3 25.506 3H6.494zm0 2h19.012C28.015 5 30 6.98 30 9.475v13.383c0 2.495-1.985 4.475-4.494 4.475H6.494C3.985 27.333 2 25.353 2 22.858V9.475C2 6.98 3.985 5 6.494 5zm-1.38 3.16l8.332 4.717L21.78 8.16H5.114zm.021 1.745v9.309H21.8V9.905l-8.353 4.655-8.31-4.655z\"\n})));\n\nfunction _extends$p() { _extends$p = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$p.apply(this, arguments); }\nvar ServiceTaskIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$p({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M6.494 3C2.916 3 0 5.903 0 9.475v13.383c0 3.572 2.916 6.475 6.494 6.475h19.012c3.578 0 6.494-2.903 6.494-6.475V9.475C32 5.903 29.084 3 25.506 3H6.494zm0 2h19.012C28.015 5 30 6.98 30 9.475v13.383c0 2.495-1.985 4.475-4.494 4.475H6.494C3.985 27.333 2 25.353 2 22.858V9.475C2 6.98 3.985 5 6.494 5zm1.22 1.681V7.84c-.329.093-.63.223-.914.382l-.83-.82-1.554 1.561.83.82c-.16.288-.285.594-.372.911l-1.177.002v2.2l1.189-.004c.109.431.345.819.58 1.165v-1.898l-1.038.004v-.737l1.034-.002.058-.294c.084-.429.252-.838.493-1.203l.165-.25-.727-.718.523-.526.728.719.247-.165c.379-.25.793-.417 1.206-.505l.291-.06-.002-1.01h.75L9.19 8.417H11.16c-.185-.221-.951-.508-1.237-.588L9.93 6.68H7.713zm2.078 2.105l.003 1.158a4.19 4.19 0 00-.915.383l-.83-.821-1.553 1.562.83.82c-.16.288-.286.593-.373.91l-1.176.003v2.2l1.188-.004c.094.326.224.624.383.905l-.85.847 1.57 1.543.847-.843c.29.161.599.286.919.373v1.198c.756.006 1.56.003 2.206.003V17.81a4.19 4.19 0 00.915-.383l.847.835 1.554-1.56-.848-.836c.16-.288.286-.594.373-.912l1.152-.007V12.75l-1.165.007a4.09 4.09 0 00-.382-.905l.805-.807-1.57-1.546-.804.806a4.16 4.16 0 00-.915-.372l.007-1.147H9.792zm.732.73h.751l-.006 1.005.297.058c.43.085.844.252 1.21.492l.25.162.701-.704.528.52-.702.704.169.25c.248.374.412.779.505 1.196l.061.292 1.016-.006v.737l-1.01.006-.058.292c-.085.43-.252.838-.494 1.205l-.165.25.744.733-.523.525-.743-.734-.248.165c-.378.247-.789.418-1.203.503l-.294.058v1.067h-.745v-1.059l-.295-.057a3.395 3.395 0 01-1.21-.492l-.248-.162-.747.743-.528-.52.747-.744-.17-.25a3.546 3.546 0 01-.506-1.196l-.06-.291-1.04.004v-.738l1.034-.002.058-.294c.085-.428.252-.837.493-1.203l.165-.25-.726-.718.522-.526.728.72.248-.166a3.546 3.546 0 011.205-.504l.292-.06-.003-1.01zm.388 2.685a1.65 1.65 0 00-1.645 1.645c0 .904.74 1.645 1.645 1.645a1.65 1.65 0 001.645-1.645 1.65 1.65 0 00-1.645-1.645zm0 .73a.91.91 0 01.915.915.91.91 0 01-.915.914.91.91 0 01-.915-.914.91.91 0 01.915-.915z\"\n})));\n\nfunction _extends$o() { _extends$o = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$o.apply(this, arguments); }\nvar StartEventCompensationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$o({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.995.001C9.705-.084 3.643 3.964 1.257 9.775-1.235 15.485.06 22.577 4.42 27.03c4.193 4.513 11.102 6.17 16.887 4.058 5.996-2.042 10.423-7.93 10.664-14.269.403-6.227-3.26-12.44-8.87-15.153A15.924 15.924 0 0015.994 0zm0 1.73c6.213-.108 12.122 4.355 13.726 10.357 1.678 5.653-.592 12.198-5.463 15.547-5.06 3.719-12.564 3.45-17.343-.626C2.101 23.171.377 16.07 2.848 10.44c2.14-5.205 7.515-8.774 13.147-8.708zm-.566 9.03l-7.415 5.235 7.415 5.238v-5.062c2.386 1.689 4.775 3.375 7.163 5.062V10.761l-7.163 5.058v-5.058zm-.866 1.666v7.13L9.51 15.993l5.052-3.565zm7.166 0v7.137l-5.052-3.568 5.052-3.569z\"\n})));\n\nfunction _extends$n() { _extends$n = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$n.apply(this, arguments); }\nvar StartEventConditionIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$n({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M16 0C7.174 0 0 7.174 0 16s7.174 16 16 16 16-7.174 16-16S24.826 0 16 0zm0 1.73c7.892 0 14.27 6.378 14.27 14.27 0 7.891-6.379 14.27-14.27 14.27S1.73 23.891 1.73 16C1.73 8.108 8.108 1.73 16 1.73zm-5.362 7.523v13.493h10.724V9.253H10.638zm.863.866h8.995V21.88H11.501V10.12zm.928 1.324v.863h7.139v-.863h-7.139zm0 2.605v.867h7.139v-.867h-7.139zm0 3.01v.864h7.139v-.863h-7.139zm0 2.72v.863h7.139v-.863h-7.139z\"\n})));\n\nfunction _extends$m() { _extends$m = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$m.apply(this, arguments); }\nvar StartEventErrorIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$m({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.995.005C9.705-.08 3.643 3.968 1.257 9.78-1.235 15.49.06 22.581 4.42 27.034c4.193 4.513 11.102 6.17 16.887 4.058 5.996-2.042 10.423-7.93 10.664-14.269.403-6.227-3.26-12.44-8.87-15.153A15.924 15.924 0 0015.994.005zm0 1.73c6.213-.108 12.122 4.355 13.726 10.357 1.678 5.653-.592 12.198-5.463 15.547-5.06 3.719-12.564 3.45-17.343-.626-4.814-3.838-6.538-10.939-4.067-16.57 2.14-5.205 7.515-8.774 13.147-8.708zm6.13 7.45l-3.635 7.37-4.52-5.88c-1.37 4.048-2.738 8.095-4.106 12.143l4.603-5.917 4.748 5.433 2.91-13.149zm-7.754 3.889l4.299 5.449 1.073-2.39-1.028 4.135-4.387-5.16-1.78 2.75 1.823-4.784z\"\n})));\n\nfunction _extends$l() { _extends$l = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$l.apply(this, arguments); }\nvar StartEventEscalationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$l({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.995.001C9.705-.084 3.643 3.964 1.257 9.775-1.235 15.485.06 22.577 4.42 27.03c4.193 4.513 11.102 6.17 16.887 4.058 5.996-2.042 10.423-7.93 10.664-14.269.403-6.227-3.26-12.44-8.87-15.153A15.924 15.924 0 0015.994 0zm0 1.73c6.213-.108 12.122 4.355 13.726 10.357 1.678 5.653-.592 12.198-5.463 15.547-5.06 3.719-12.564 3.45-17.343-.626C2.101 23.171.377 16.07 2.848 10.44c2.14-5.205 7.515-8.774 13.147-8.708zm0 7.183c-1.674 4.658-2.736 9.509-4.41 14.166 1.535-1.526 2.874-3.236 4.41-4.763l4.41 4.763c-1.499-4.713-2.913-9.453-4.41-14.166zm.032 2.931c.822 2.588 1.598 5.19 2.42 7.778l-2.42-2.615c-.683.598-2.455 2.887-2.34 2.39.871-2.489 1.448-5.07 2.34-7.553z\"\n})));\n\nfunction _extends$k() { _extends$k = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$k.apply(this, arguments); }\nvar StartEventMessageIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$k({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.995.001C9.705-.084 3.643 3.964 1.257 9.775-1.235 15.485.06 22.577 4.42 27.03c4.193 4.513 11.102 6.17 16.887 4.058 5.996-2.042 10.423-7.93 10.664-14.269.403-6.227-3.26-12.44-8.87-15.153A15.924 15.924 0 0015.994 0zm0 1.73c6.213-.108 12.122 4.355 13.726 10.357 1.678 5.653-.592 12.198-5.463 15.547-5.06 3.719-12.564 3.45-17.343-.626C2.101 23.171.377 16.07 2.848 10.44c2.14-5.205 7.515-8.774 13.147-8.708zm-7.257 8.732v11.069h14.513v-11.07H8.738zm3.224 1.73h8.064c-1.428.878-2.857 2.807-4.285 3.018l-3.779-3.019zm9.562 1.017v6.593H10.465V13.21l5.528 4.417 5.53-4.418z\"\n})));\n\nfunction _extends$j() { _extends$j = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$j.apply(this, arguments); }\nvar StartEventMultipleIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$j({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.995.001C9.705-.084 3.643 3.964 1.257 9.775-1.235 15.485.06 22.577 4.42 27.03c4.193 4.513 11.102 6.17 16.887 4.058 5.996-2.042 10.423-7.93 10.664-14.269.403-6.227-3.26-12.44-8.87-15.153A15.924 15.924 0 0015.994 0zm0 1.73c6.213-.108 12.122 4.355 13.726 10.357 1.678 5.653-.592 12.198-5.463 15.547-5.06 3.719-12.564 3.45-17.343-.626C2.101 23.171.377 16.07 2.848 10.44c2.14-5.205 7.515-8.774 13.147-8.708zm0 6.328l-7.626 5.536c.97 2.986 1.942 5.971 2.913 8.957h9.426l2.912-8.957-7.625-5.536zm0 1.068l6.609 4.798-2.525 7.763H11.91l-2.524-7.763 6.609-4.798z\"\n})));\n\nfunction _extends$i() { _extends$i = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$i.apply(this, arguments); }\nvar StartEventNonInterruptingConditionIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$i({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M10.632 9.189V22.68h10.723V9.189H10.632zm.862.865h8.994v11.76H11.494v-11.76zm.928 1.324v.863h7.138v-.863h-7.138zm0 2.605v.866h7.138v-.866h-7.138zm0 3.01v.863h7.138v-.863h-7.138zm0 2.72v.862h7.138v-.863h-7.138zM16.12 0h-.232l-.22.004h-.012l-.221.006h-.012l-.22.01h-.012l-.22.013h-.012l-.22.016h-.012l-.22.019h-.005l-.006.001-.22.021h-.006l-.005.001-.22.025h-.011l-.22.028h-.005l-.006.002-.219.03h-.005l-.006.001-.218.033-.006.001-.006.001-.217.036-.006.001-.006.001-.217.039-.006.001-.006.001-.216.042-.006.001-.006.001-.215.045-.006.001-.006.002-.215.047-.006.002-.006.001-.214.05-.006.002-.006.002-.115.029-.152.053-.14.081-.122.106-.1.126-.075.143-.047.154-.018.16.012.16.042.156.07.145.095.13.118.11.137.086.15.059.158.03h.161l.132-.022.11-.028.202-.047.203-.046.208-.043.202-.039.206-.037.206-.034.205-.03.208-.03.205-.025.209-.023.208-.02.21-.017.209-.015.207-.011.21-.009.21-.006.207-.003h.21l.21.002.207.005.207.008.212.011.207.014.208.017.209.019.208.022.205.025.206.028.207.03.208.035.205.036.202.039.052.01.16.018.16-.012.156-.042.146-.07.13-.096.109-.119.085-.136.06-.15.03-.159v-.16l-.03-.16-.059-.15-.086-.136-.109-.118-.13-.096-.145-.07-.128-.038-.057-.011-.006-.002h-.006l-.216-.042-.006-.001-.006-.001-.217-.039H18.9l-.006-.002-.217-.035-.006-.001-.006-.001-.218-.032-.006-.001-.006-.001-.218-.03h-.006l-.006-.001-.219-.027h-.011l-.22-.024-.005-.001h-.006l-.22-.021h-.006l-.006-.001-.22-.017-.005-.001h-.006L17.06.03h-.012l-.22-.012h-.012l-.22-.01h-.012l-.22-.005h-.012L16.132 0h-.012zm8.715 2.783l-.157.034-.149.063-.134.089-.116.112-.092.132-.067.147-.038.157-.008.16.021.16.051.153.079.141.103.124.102.087.052.038h.001l.087.064v.001l.082.061.002.001.076.059h.001l.084.065.082.066.002.001.079.063.002.002.077.063.081.067.002.002.077.065.076.065.001.002.08.07.078.07h.002l.075.068.077.072.002.001.073.069.077.073.072.07.002.001.077.076.07.07v.001l.075.076.07.073.002.001.074.079.002.002.069.074.069.075.074.082.07.08.002.001.068.079h.001l.067.079.068.082.065.078.001.002.068.083.067.084.063.081.001.002.067.087.002.002.063.084.001.001.064.087.008.01.008.01.095.12.093.121.09.119.087.119.088.122.086.123.084.12.081.122.001.002.084.126.08.126.08.127.077.126.079.131.074.127.075.131.073.131.07.13.07.133.069.133.045.09.086.137.109.119.13.096.144.07.156.042.16.013.16-.017.155-.047.143-.075.126-.1.106-.121.082-.14.054-.151.025-.16-.005-.16-.035-.158-.05-.124-.048-.095-.002-.004-.002-.004-.073-.14-.002-.005-.002-.004-.074-.14-.002-.004-.002-.004-.076-.14-.002-.003-.002-.004-.077-.139-.003-.004-.002-.004-.078-.138-.003-.004-.002-.003-.08-.137-.002-.004-.003-.004-.081-.136-.002-.004-.003-.004-.083-.136-.002-.003-.002-.004-.085-.135-.002-.004-.003-.003-.085-.134-.003-.004-.002-.004-.087-.132-.003-.004-.003-.004-.088-.132-.003-.003-.002-.004-.09-.13-.003-.005-.003-.003-.091-.13-.003-.004-.002-.004-.093-.129-.003-.003-.003-.004-.094-.128-.003-.004-.003-.003-.095-.127-.003-.004-.003-.004-.097-.125-.003-.004-.003-.004-.09-.114-.06-.082-.003-.003-.002-.003-.069-.091-.002-.004-.002-.003-.07-.09-.003-.003-.002-.003-.07-.09-.003-.003-.002-.003-.071-.09-.002-.003-.003-.002-.072-.089-.002-.003-.002-.003-.073-.088-.002-.003-.002-.002-.074-.087-.002-.003-.002-.003-.074-.086-.003-.003-.002-.003-.074-.086-.003-.002-.002-.003-.075-.085-.003-.003-.002-.002-.076-.084-.002-.003-.003-.003-.076-.083-.002-.003-.003-.003-.077-.082-.002-.003-.003-.002-.077-.082-.003-.003-.003-.002-.078-.081-.002-.003-.003-.003-.078-.08-.003-.002-.003-.003-.079-.08-.002-.002-.003-.002-.08-.08-.002-.002-.003-.002-.08-.078-.003-.003-.003-.002-.08-.077-.003-.003-.003-.002-.082-.077-.002-.002-.003-.002-.082-.076-.003-.002-.002-.003-.083-.075-.003-.002-.002-.003-.084-.074-.002-.002-.003-.002-.084-.074-.003-.002-.002-.002-.085-.073-.002-.002-.003-.003-.085-.071-.003-.003-.002-.002-.086-.07-.003-.003-.002-.002-.086-.07-.003-.003-.003-.002-.086-.07-.003-.002-.003-.002-.087-.069-.002-.002-.003-.002-.088-.068-.002-.002-.003-.002-.088-.067-.003-.003-.003-.002-.088-.066-.003-.002-.003-.002-.089-.066-.003-.002-.003-.002-.057-.042-.14-.082-.15-.055-.16-.026-.16.004zM6.377 3.21l-.157.037-.148.066-.111.074-.007.006-.003.002-.003.002-.086.069-.003.002-.002.002-.086.07-.003.002-.002.002-.086.07-.002.003-.003.002-.085.071-.002.002-.003.003-.084.071-.003.003-.002.002-.084.072-.003.003-.002.002-.083.073-.003.003-.002.002-.083.074-.002.002-.003.003-.082.074-.003.003-.002.002-.081.076-.003.002-.003.002-.08.077-.003.002-.003.003-.08.076-.002.003-.003.002-.08.078-.002.002-.003.003-.079.078-.002.003-.003.002-.078.08-.003.002-.002.002-.078.08-.002.003-.003.002-.077.08-.003.004-.002.002-.077.081-.002.003-.003.003-.076.082-.002.002-.003.003-.075.082-.002.003-.003.003-.074.083-.003.003-.002.003-.074.084-.003.003-.002.002-.074.085-.002.003-.002.003-.073.085-.003.003-.002.003-.072.086-.002.003-.003.003-.071.087-.003.003-.002.002-.07.088-.003.003-.002.003-.07.088-.003.003-.002.003-.07.09-.002.002-.002.003-.069.09-.002.003-.003.003-.068.09-.002.003-.002.003-.067.092-.003.003-.002.003-.067.092-.002.003-.002.003-.066.092-.002.003-.002.004-.066.093-.002.003-.002.003-.065.094-.002.003-.002.004-.064.094-.002.003-.002.004-.063.095-.002.003-.002.003-.063.097-.002.003-.002.003-.046.073-.05.07-.003.002-.002.003-.067.093-.003.003-.002.003-.066.094-.002.003-.002.003-.066.094-.002.003-.002.003-.064.094-.002.004-.002.003-.064.094-.002.004-.002.003-.062.095-.002.003-.002.003-.062.096-.002.003-.002.003-.06.096-.003.003-.002.003-.06.096-.001.004-.002.003-.059.096-.002.004-.002.003-.058.097-.002.003-.001.003-.057.098-.002.003-.002.003-.056.098-.002.003-.002.003-.055.098-.002.004-.001.003-.055.098-.001.004-.002.003-.054.099-.001.003-.002.003-.052.1-.002.002-.002.004-.051.1-.002.002-.002.004-.05.1-.002.003-.002.003-.05.1v.003l-.002.004-.05.1v.003l-.002.004-.048.1-.002.004-.001.003-.047.101-.002.003-.001.004-.013.027-.052.152-.024.16.006.16.037.157.064.148.091.133.114.114.134.09.147.065.157.036.162.006.159-.024.152-.053.14-.08.122-.105.1-.126.066-.117.01-.023.044-.095.045-.095.002-.003.042-.087.048-.097.048-.095v-.001l.048-.092.001-.001.047-.09.05-.093.002-.002.049-.09.052-.092.001-.002.051-.089.001-.002.051-.087.053-.088.001-.002.055-.091.057-.091.057-.09.001-.002.057-.089.055-.083.001-.002.06-.09.06-.088.062-.089.001-.001.06-.084.063-.088.065-.089.017-.023.016-.025.06-.094.059-.09v-.002l.058-.086.057-.086.001-.001.062-.09.062-.088.001-.002.06-.085.002-.002.06-.082.063-.087.064-.084.002-.002.061-.08.065-.084.064-.08v-.001l.067-.083.067-.082.07-.083.069-.08.063-.074.074-.083.068-.077.002-.002.07-.076.07-.075.072-.077.001-.001.067-.07.076-.078.002-.002.07-.07.075-.075.002-.002.072-.07.075-.072.002-.002.073-.069.074-.068.001-.001.08-.073.076-.068.002-.002.072-.063v-.001l.078-.067.079-.068.002-.001.08-.068.002-.002.077-.063.082-.066.001-.001.075-.06.002-.002.006-.004.117-.111.094-.131.068-.146.04-.156.01-.161-.019-.16-.049-.154-.076-.141-.102-.125-.123-.105-.14-.079-.153-.052-.16-.023-.16.007zm24.596 11.088l-.156.04-.146.067-.131.094-.112.117-.087.135-.061.15-.033.157-.004.134.007.142.005.152.004.15.002.149v.153l.001.011v.015l.004.11.002.11v.002l.002.106v.321l-.003.102-.002.106-.004.107-.005.105-.006.106-.006.106-.008.106v.002l-.008.103v.002l-.01.1-.01.105-.01.105-.013.105-.012.099v.002l-.014.108-.014.1-.016.105-.016.103v.002l-.017.099-.018.104-.019.103v.002l-.019.097-.02.104-.022.103v.001l-.022.098-.023.103v.002l-.024.096-.025.103v.002l-.024.096-.027.102v.003l-.026.093v.001l-.029.103v.002l-.03.099-.028.097v.002l-.03.095-.03.096v.001l-.033.1-.031.095v.002l-.035.1v.003l-.034.094v.003l-.035.096v.001l-.034.09v.002l-.038.098-.036.093v.002l-.038.095-.079.194-.08.188-.085.189-.087.19-.09.184-.092.183-.095.184-.05.093-.064.148-.034.158-.005.16.026.16.054.151.082.14.106.12.127.1.143.075.154.046.16.017.161-.013.156-.042.144-.071.13-.096.109-.119.072-.112.053-.099.003-.005.003-.006.102-.195.003-.006.003-.006.098-.196.003-.006.003-.006.096-.197.002-.006.003-.006.093-.2.002-.006.003-.006.09-.2.002-.006.003-.007.086-.202.003-.006.002-.006.084-.203.002-.005.001-.005.04-.102.002-.003.001-.003.04-.103.001-.003.001-.003.04-.103v-.004l.001-.003.039-.103v-.003l.002-.003.037-.104.001-.003.001-.003.037-.104v-.004l.002-.003.035-.104.002-.003v-.004l.035-.104.002-.004v-.003l.034-.105.002-.003v-.003l.034-.105v-.004l.002-.003.032-.106.001-.003.001-.003.031-.106.001-.003.001-.004.031-.106.001-.003.001-.004.03-.106v-.003l.002-.004.028-.107.001-.003.001-.003.028-.107.001-.004.001-.003.027-.107.001-.004v-.003l.027-.108.001-.003v-.004l.026-.108.001-.003v-.004l.025-.108.001-.003v-.004l.025-.108v-.004l.001-.003.023-.109v-.003l.001-.004.022-.109v-.003l.002-.004.02-.109.001-.004v-.003l.02-.11.002-.003v-.004l.02-.11v-.007l.019-.11v-.003l.001-.004.017-.11v-.004l.001-.003.017-.11v-.008l.016-.11v-.004l.001-.004.015-.11v-.008l.015-.111v-.008l.013-.111v-.007l.013-.112v-.007l.011-.112v-.004l.001-.004.01-.112v-.007l.01-.112v-.008l.008-.112v-.008l.007-.113v-.007l.007-.113v-.008l.005-.113v-.007l.005-.114v-.007l.003-.114v-.007l.003-.114v-.129l.001-.114v-.13l-.003-.114v-.008l-.003-.115v-.007l-.003-.102v-.155l-.003-.158v-.01l-.004-.158v-.01l-.006-.158v-.01l-.007-.148-.023-.16-.051-.152-.08-.14-.103-.124-.125-.102-.142-.077-.153-.05-.16-.02-.161.01zm-30.213.66l-.157.034-.149.063-.134.09-.115.113-.092.132-.067.147-.037.156-.009.134.001.11V15.95l.006.22v.012l.01.22v.012l.012.22v.006l.001.006.015.22v.005l.001.006.018.22.001.006v.006l.022.219v.006l.001.006.024.219.001.006v.006l.028.218.001.006v.006l.031.218.001.006.001.006.033.218.001.006.001.005.037.218v.006l.002.005.04.217v.006l.001.006.043.216.001.006.001.006.046.216v.005l.002.006.048.215.002.006.001.006.051.214.002.006v.006l.055.214.002.005.001.006.057.213.002.006.001.005.06.213.002.005.001.006.063.212.002.005.001.006.066.21.002.006.002.006.068.21.002.005.002.005.07.21.003.005.002.005.074.208.002.006.002.005.077.207.002.006.002.005.08.206.002.005.002.006.082.204.002.006.002.005.086.204.002.005.002.006.088.202.002.005.003.006.09.2.003.006.002.005.094.2.002.006.003.005.096.199.002.005.003.005.03.062.086.137.11.118.128.097.145.07.156.043.16.013.16-.017.155-.047.143-.074.127-.1.106-.121.081-.14.055-.15.025-.16-.005-.161-.034-.158-.05-.124-.028-.055-.092-.19-.087-.188-.087-.192-.083-.19-.08-.193-.078-.194-.076-.196-.073-.195-.07-.197-.067-.198-.065-.199-.063-.2-.059-.2-.056-.2-.055-.204-.05-.201-.049-.202-.046-.205-.043-.206-.04-.203-.038-.207-.034-.204-.032-.207-.028-.205-.026-.207-.023-.208-.02-.207-.018-.207-.014-.208-.011-.207-.009-.208-.005-.207-.002-.104-.017-.16-.046-.155-.074-.143-.1-.126-.121-.107-.139-.081-.152-.055-.159-.025-.161.004zm24.585 11.83l-.156.039-.146.068-.11.076-.015.012-.163.129-.166.127-.168.125-.17.124-.17.12-.172.118-.173.115-.176.114-.177.111-.18.11-.178.105-.182.104-.182.101-.184.1-.184.095-.189.095-.186.09-.188.089-.19.086-.19.082-.193.081-.195.078-.191.074-.197.073-.195.07-.196.065-.198.064-.198.061-.2.058-.2.055-.2.052-.2.049-.151.035-.153.05-.141.078-.125.103-.103.124-.078.14-.05.154-.022.16.009.16.038.157.067.147.093.132.116.112.134.089.149.062.158.034.16.003.133-.02.158-.035.006-.002.006-.001.213-.052.006-.002.007-.001.212-.056.006-.001.006-.002.212-.058.006-.002.006-.002.211-.061.006-.002.006-.002.21-.064.006-.002.006-.002.21-.067.005-.002.006-.002.208-.07.006-.002.006-.003.207-.073.006-.002.006-.002.206-.077.006-.002.005-.002.206-.08.005-.001.006-.003.204-.082.006-.002.005-.002.203-.085.006-.003.005-.002.202-.088.006-.002.005-.003.2-.09.006-.003.006-.003.2-.093.005-.003.005-.002.198-.096.006-.003.005-.003.197-.099.005-.002.005-.003.196-.102.005-.002.005-.003.195-.105.005-.002.005-.003.193-.107.005-.003.005-.003.191-.11.005-.003.005-.003.19-.112.005-.003.005-.003.189-.115.005-.003.005-.003.187-.117.005-.003.004-.004.186-.12.005-.003.004-.003.184-.122.005-.003.005-.004.182-.125.004-.003.005-.003.18-.128.005-.003.005-.003.179-.13.004-.003.005-.004.177-.132.004-.004.005-.003.175-.135.005-.003.004-.004.173-.137.005-.003.004-.004.019-.015.115-.113.092-.132.066-.147.038-.157.008-.16-.022-.16-.052-.153-.079-.14-.103-.124-.125-.102-.142-.078-.153-.05-.16-.02-.16.01zm-19.17.054l-.153.051-.14.079-.124.103-.103.125-.077.141-.05.153-.02.16.009.161.04.156.067.147.093.131.095.094.047.04.005.004.005.004.17.14.005.004.005.004.172.137.004.004.005.003.086.067.003.002.003.002.087.067.003.002.003.002.088.066.002.003.003.002.089.065.002.002.003.002.09.065.002.002.003.002.09.064.002.002.003.002.09.063.003.002.003.002.09.063.003.002.003.002.092.062.002.002.003.002.092.061.003.002.003.002.092.06.003.003.003.001.093.06.003.002.003.002.093.06.003.001.003.002.094.058.003.002.003.002.095.058.003.001.003.002.095.057.003.002.003.002.095.056.003.002.003.002.096.055.004.002.003.001.096.055.003.002.003.002.098.053.003.002.003.002.097.053.004.002.003.001.098.053.003.001.003.002.099.052.003.001.003.002.1.05.003.002.003.002.1.05.003.002.003.001.1.05h.003l.004.003.1.048.004.001.003.002.101.048.003.001.004.002.101.046.004.002.003.001.102.046.004.002.003.001.103.045.003.002.003.001.103.045.004.001.003.002.104.043.003.001.004.002.104.042.003.002.004.001.104.042.004.001.003.002.105.04.004.002.003.001.106.04.003.002h.004l.106.04.004.001.003.002.107.038.003.001.004.001.107.038.003.001.004.001.107.037.004.001.004.001.108.036.003.001.004.001.108.035.004.001.003.001.11.034.003.001.004.001.109.033.004.002h.003l.11.033h.004l.003.002.11.031.004.001.004.001.084.023.081.028.004.001.003.001.109.037.003.001.004.001.109.036.003.001.004.001.109.035h.003l.004.002.11.033.003.001.003.001.11.033.003.001.004.001.109.031.004.002h.003l.11.031.003.001.004.001.11.03h.003l.003.001.11.029h.004l.003.002.11.027.003.001.004.001.11.027h.003l.004.001.004.001.16.022.16-.008.157-.038.147-.067.132-.092.112-.116.09-.134.062-.149.034-.157.004-.161-.025-.16-.055-.151-.082-.139-.107-.12-.127-.1-.143-.074-.124-.04h-.003l-.104-.025-.103-.026h-.002l-.095-.026h-.001l-.101-.027h-.002l-.1-.028h-.002l-.103-.03-.104-.032-.097-.03h-.002l-.103-.033-.102-.033-.101-.034-.106-.036-.027-.01-.027-.007-.107-.03-.104-.029-.104-.03h-.002l-.097-.03-.102-.032-.102-.032-.102-.034-.103-.035-.096-.034-.1-.036-.101-.037h-.002l-.094-.036-.096-.037-.097-.04h-.002l-.099-.04-.098-.042h-.002l-.092-.04-.097-.043-.095-.043-.097-.044h-.002l-.09-.043-.094-.045-.094-.046-.093-.047-.09-.046-.096-.05-.088-.047-.002-.001-.09-.049-.094-.052-.002-.002-.087-.049-.087-.05h-.002l-.088-.053h-.001l-.09-.055-.086-.052-.002-.001-.089-.055-.084-.054h-.002l-.09-.059h-.001l-.085-.056-.001-.001-.084-.056-.082-.056h-.001l-.086-.06-.082-.058H7.79l-.086-.062-.002-.002-.08-.058-.081-.06h-.001l-.085-.064-.002-.002-.076-.058-.002-.002-.082-.064-.161-.128-.162-.133-.04-.034-.132-.092-.147-.066-.157-.038-.16-.008-.16.022z\"\n})));\n\nfunction _extends$h() { _extends$h = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$h.apply(this, arguments); }\nvar StartEventNonInterruptingEscalationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$h({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M16 9.209c-1.674 4.655-2.735 9.504-4.408 14.16 1.534-1.526 2.873-3.235 4.407-4.761l4.408 4.76c-1.497-4.71-2.91-9.448-4.408-14.16zm.031 2.93c.822 2.586 1.598 5.187 2.42 7.774l-2.42-2.614c-.682.598-2.453 2.886-2.34 2.389.873-2.488 1.45-5.068 2.34-7.55zM16.132.364c-1.51.016-3.055.139-4.492.614-.854.442-.266 1.861.651 1.578 2.266-.58 4.656-.596 6.944-.144.935.063 1.21-1.391.318-1.674-1.118-.26-2.274-.361-3.42-.374zm8.865 2.777c-.931-.1-1.262 1.29-.425 1.666 1.863 1.364 3.222 3.298 4.322 5.296.617.737 1.875-.145 1.398-.979-1.184-2.275-2.808-4.384-4.923-5.866a.863.863 0 00-.372-.117zM6.55 3.564c-.734.078-1.196.762-1.735 1.206C3.552 6.02 2.55 7.511 1.681 9.053c-.31.533-.71 1.33-.03 1.767.615.432 1.282-.132 1.446-.742.796-1.475 1.746-2.89 2.934-4.08.43-.548 1.292-.822 1.34-1.595a.874.874 0 00-.822-.839zm24.582 11.078c-.771-.033-1.004.82-.873 1.437.13 2.395-.471 4.797-1.615 6.897-.33.876.984 1.559 1.512.785a14.276 14.276 0 001.761-8.54.865.865 0 00-.785-.579zm-30.195.666c-.774-.06-1.032.785-.905 1.407.117 2.41.732 4.81 1.858 6.945.528.774 1.84.09 1.51-.786A15.932 15.932 0 011.728 16a.876.876 0 00-.79-.692zm24.57 11.817c-.762.099-1.243.835-1.919 1.16-1.514 1.002-3.237 1.632-4.978 2.092-.864.423-.307 1.855.616 1.591 2.528-.578 4.93-1.75 6.913-3.421.469-.522.07-1.42-.631-1.422zm-19.16.042c-.845.001-1.12 1.228-.395 1.628 1.665 1.401 3.667 2.348 5.76 2.912.618.178 1.482.565 1.893-.177.355-.628-.226-1.297-.87-1.326-1.972-.515-3.912-1.285-5.5-2.594-.26-.213-.522-.472-.888-.443z\"\n})));\n\nfunction _extends$g() { _extends$g = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$g.apply(this, arguments); }\nvar StartEventNonInterruptingMessageIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$g({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M8.746 10.393v11.064h14.506V10.393H8.746zm3.223 1.728h8.06c-1.428.879-2.856 2.807-4.283 3.018l-3.777-3.018zm9.557 1.018v6.59H10.473v-6.59l5.525 4.416 5.528-4.416zM16.132 0c-1.51.016-3.055.139-4.492.614-.854.442-.266 1.861.651 1.578 2.266-.58 4.656-.596 6.944-.144.935.063 1.21-1.391.318-1.674-1.118-.26-2.274-.361-3.42-.374zm8.865 2.777c-.931-.1-1.262 1.29-.425 1.666 1.863 1.364 3.222 3.298 4.322 5.296.617.737 1.875-.145 1.398-.979-1.184-2.275-2.808-4.384-4.923-5.866a.863.863 0 00-.372-.117zM6.55 3.2c-.734.078-1.196.762-1.735 1.206C3.552 5.656 2.55 7.147 1.681 8.69c-.31.533-.71 1.33-.03 1.767.615.432 1.282-.132 1.446-.742.796-1.475 1.746-2.89 2.934-4.08.43-.548 1.292-.822 1.34-1.595a.874.874 0 00-.822-.839zm24.582 11.078c-.771-.033-1.004.82-.873 1.437.13 2.395-.471 4.797-1.615 6.897-.33.876.984 1.559 1.512.785a14.276 14.276 0 001.761-8.54.865.865 0 00-.785-.579zm-30.195.666c-.774-.06-1.032.785-.905 1.407.117 2.41.732 4.81 1.858 6.945.528.774 1.84.09 1.51-.786a15.932 15.932 0 01-1.672-6.874.876.876 0 00-.79-.692zm24.57 11.817c-.762.099-1.243.835-1.919 1.16-1.514 1.002-3.237 1.632-4.978 2.092-.864.423-.307 1.855.616 1.591 2.528-.578 4.93-1.75 6.913-3.421.469-.522.07-1.42-.631-1.422zm-19.16.042c-.845.001-1.12 1.228-.395 1.628 1.665 1.401 3.667 2.348 5.76 2.912.618.178 1.482.565 1.893-.177.355-.628-.226-1.297-.87-1.326-1.972-.515-3.912-1.285-5.5-2.594-.26-.213-.522-.472-.888-.443z\"\n})));\n\nfunction _extends$f() { _extends$f = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$f.apply(this, arguments); }\nvar StartEventNonInterruptingMultipleIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$f({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M23.621 13.524L16 7.99l-7.622 5.534 2.911 8.952h9.422l2.911-8.952zm-1.016.33l-2.523 7.759h-8.165l-2.524-7.76L16 9.059l6.606 4.796zM16.132 0c-1.51.016-3.055.139-4.492.614-.854.442-.266 1.861.651 1.578 2.266-.58 4.656-.596 6.944-.144.935.063 1.21-1.391.318-1.674-1.118-.26-2.274-.361-3.42-.374zm8.865 2.777c-.931-.1-1.262 1.29-.425 1.666 1.863 1.364 3.222 3.298 4.322 5.296.617.737 1.875-.145 1.398-.979-1.184-2.275-2.808-4.384-4.923-5.866a.863.863 0 00-.372-.117zM6.55 3.2c-.734.078-1.196.762-1.735 1.206C3.552 5.656 2.55 7.147 1.681 8.69c-.31.533-.71 1.33-.03 1.767.615.432 1.282-.132 1.446-.742.796-1.475 1.746-2.89 2.934-4.08.43-.548 1.292-.822 1.34-1.595a.874.874 0 00-.822-.839zm24.582 11.078c-.771-.033-1.004.82-.873 1.437.13 2.395-.471 4.797-1.615 6.897-.33.876.984 1.559 1.512.785a14.276 14.276 0 001.761-8.54.865.865 0 00-.785-.579zm-30.195.666c-.774-.06-1.032.785-.905 1.407.117 2.41.732 4.81 1.858 6.945.528.774 1.84.09 1.51-.786a15.932 15.932 0 01-1.672-6.874.876.876 0 00-.79-.692zm24.57 11.817c-.762.099-1.243.835-1.919 1.16-1.514 1.002-3.237 1.632-4.978 2.092-.864.423-.307 1.855.616 1.591 2.528-.578 4.93-1.75 6.913-3.421.469-.522.07-1.42-.631-1.422zm-19.16.042c-.845.001-1.12 1.228-.395 1.628 1.665 1.401 3.667 2.348 5.76 2.912.618.178 1.482.565 1.893-.177.355-.628-.226-1.297-.87-1.326-1.972-.515-3.912-1.285-5.5-2.594-.26-.213-.522-.472-.888-.443z\"\n})));\n\nfunction _extends$e() { _extends$e = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$e.apply(this, arguments); }\nvar StartEventNonInterruptingParallelMultipleIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$e({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M13.503 9.016v4.428H9.075v4.98h4.428v4.428h4.98v-4.427h4.428v-4.981h-4.427V9.016h-4.981zm.83.83h3.32v4.428h4.428v3.32h-4.428v4.428h-3.32v-4.454H9.905v-3.294h4.428V9.846zM16.12 0h-.232l-.22.004h-.012l-.221.006h-.012l-.22.01h-.012l-.22.013h-.012l-.22.016h-.012l-.22.019h-.005l-.006.001-.22.021h-.006l-.005.001-.22.025h-.011l-.22.028h-.005l-.006.002-.219.03h-.005l-.006.001-.218.033-.006.001-.006.001-.217.036-.006.001-.006.001-.217.039-.006.001-.006.001-.216.042-.006.001-.006.001-.215.045-.006.001-.006.002-.215.047-.006.002-.006.001-.214.05-.006.002-.006.002-.115.029-.152.053-.14.081-.122.106-.1.126-.075.143-.047.154-.018.16.012.16.042.156.07.145.095.13.118.11.137.086.15.059.158.03h.161l.132-.022.11-.028.202-.047.203-.046.208-.043.202-.039.206-.037.206-.034.205-.03.208-.03.205-.025.209-.023.208-.02.21-.017.209-.015.207-.011.21-.009.21-.006.207-.003h.21l.21.002.207.005.207.008.212.011.207.014.208.017.209.019.208.022.205.025.206.028.207.03.208.035.205.036.202.039.052.01.16.018.16-.012.156-.042.146-.07.13-.096.109-.119.085-.136.06-.15.03-.159v-.16l-.03-.16-.059-.15-.086-.136-.109-.118-.13-.096-.145-.07-.128-.038-.057-.011-.006-.002h-.006l-.216-.042-.006-.001-.006-.001-.217-.039H18.9l-.006-.002-.217-.035-.006-.001-.006-.001-.218-.032-.006-.001-.006-.001-.218-.03h-.006l-.006-.001-.219-.027h-.011l-.22-.024-.005-.001h-.006l-.22-.021h-.006l-.006-.001-.22-.017-.005-.001h-.006L17.06.03h-.012l-.22-.012h-.012l-.22-.01h-.012l-.22-.005h-.012L16.132 0h-.012zm8.715 2.783l-.157.034-.149.063-.134.089-.116.112-.092.132-.067.147-.038.157-.008.16.021.16.051.153.079.141.103.124.102.087.052.038h.001l.087.064v.001l.082.061.002.001.076.059h.001l.084.065.082.066.002.001.079.063.002.002.077.063.081.067.002.002.077.065.076.065.001.002.08.07.078.07h.002l.075.068.077.072.002.001.073.069.077.073.072.07.002.001.077.076.07.07v.001l.075.076.07.073.002.001.074.079.002.002.069.074.069.075.074.082.07.08.002.001.068.079h.001l.067.079.068.082.065.078.001.002.068.083.067.084.063.081.001.002.067.087.002.002.063.084.001.001.064.087.008.01.008.01.095.12.093.121.09.119.087.119.088.122.086.123.084.12.081.122.001.002.084.126.08.126.08.127.077.126.079.131.074.127.075.131.073.131.07.13.07.133.069.133.045.09.086.137.109.119.13.096.144.07.156.042.16.013.16-.017.155-.047.143-.075.126-.1.106-.121.082-.14.054-.151.025-.16-.005-.16-.035-.158-.05-.124-.048-.095-.002-.004-.002-.004-.073-.14-.002-.005-.002-.004-.074-.14-.002-.004-.002-.004-.076-.14-.002-.003-.002-.004-.077-.139-.003-.004-.002-.004-.078-.138-.003-.004-.002-.003-.08-.137-.002-.004-.003-.004-.081-.136-.002-.004-.003-.004-.083-.136-.002-.003-.002-.004-.085-.135-.002-.004-.003-.003-.085-.134-.003-.004-.002-.004-.087-.132-.003-.004-.003-.004-.088-.132-.003-.003-.002-.004-.09-.13-.003-.005-.003-.003-.091-.13-.003-.004-.002-.004-.093-.129-.003-.003-.003-.004-.094-.128-.003-.004-.003-.003-.095-.127-.003-.004-.003-.004-.097-.125-.003-.004-.003-.004-.09-.114-.06-.082-.003-.003-.002-.003-.069-.091-.002-.004-.002-.003-.07-.09-.003-.003-.002-.003-.07-.09-.003-.003-.002-.003-.071-.09-.002-.003-.003-.002-.072-.089-.002-.003-.002-.003-.073-.088-.002-.003-.002-.002-.074-.087-.002-.003-.002-.003-.074-.086-.003-.003-.002-.003-.074-.086-.003-.002-.002-.003-.075-.085-.003-.003-.002-.002-.076-.084-.002-.003-.003-.003-.076-.083-.002-.003-.003-.003-.077-.082-.002-.003-.003-.002-.077-.082-.003-.003-.003-.002-.078-.081-.002-.003-.003-.003-.078-.08-.003-.002-.003-.003-.079-.08-.002-.002-.003-.002-.08-.08-.002-.002-.003-.002-.08-.078-.003-.003-.003-.002-.08-.077-.003-.003-.003-.002-.082-.077-.002-.002-.003-.002-.082-.076-.003-.002-.002-.003-.083-.075-.003-.002-.002-.003-.084-.074-.002-.002-.003-.002-.084-.074-.003-.002-.002-.002-.085-.073-.002-.002-.003-.003-.085-.071-.003-.003-.002-.002-.086-.07-.003-.003-.002-.002-.086-.07-.003-.003-.003-.002-.086-.07-.003-.002-.003-.002-.087-.069-.002-.002-.003-.002-.088-.068-.002-.002-.003-.002-.088-.067-.003-.003-.003-.002-.088-.066-.003-.002-.003-.002-.089-.066-.003-.002-.003-.002-.057-.042-.14-.082-.15-.055-.16-.026-.16.004zM6.377 3.21l-.157.037-.148.066-.111.074-.007.006-.003.002-.003.002-.086.069-.003.002-.002.002-.086.07-.003.002-.002.002-.086.07-.002.003-.003.002-.085.071-.002.002-.003.003-.084.071-.003.003-.002.002-.084.072-.003.003-.002.002-.083.073-.003.003-.002.002-.083.074-.002.002-.003.003-.082.074-.003.003-.002.002-.081.076-.003.002-.003.002-.08.077-.003.002-.003.003-.08.076-.002.003-.003.002-.08.078-.002.002-.003.003-.079.078-.002.003-.003.002-.078.08-.003.002-.002.002-.078.08-.002.003-.003.002-.077.08-.003.004-.002.002-.077.081-.002.003-.003.003-.076.082-.002.002-.003.003-.075.082-.002.003-.003.003-.074.083-.003.003-.002.003-.074.084-.003.003-.002.002-.074.085-.002.003-.002.003-.073.085-.003.003-.002.003-.072.086-.002.003-.003.003-.071.087-.003.003-.002.002-.07.088-.003.003-.002.003-.07.088-.003.003-.002.003-.07.09-.002.002-.002.003-.069.09-.002.003-.003.003-.068.09-.002.003-.002.003-.067.092-.003.003-.002.003-.067.092-.002.003-.002.003-.066.092-.002.003-.002.004-.066.093-.002.003-.002.003-.065.094-.002.003-.002.004-.064.094-.002.003-.002.004-.063.095-.002.003-.002.003-.063.097-.002.003-.002.003-.046.073-.05.07-.003.002-.002.003-.067.093-.003.003-.002.003-.066.094-.002.003-.002.003-.066.094-.002.003-.002.003-.064.094-.002.004-.002.003-.064.094-.002.004-.002.003-.062.095-.002.003-.002.003-.062.096-.002.003-.002.003-.06.096-.003.003-.002.003-.06.096-.001.004-.002.003-.059.096-.002.004-.002.003-.058.097-.002.003-.001.003-.057.098-.002.003-.002.003-.056.098-.002.003-.002.003-.055.098-.002.004-.001.003-.055.098-.001.004-.002.003-.054.099-.001.003-.002.003-.052.1-.002.002-.002.004-.051.1-.002.002-.002.004-.05.1-.002.003-.002.003-.05.1v.003l-.002.004-.05.1v.003l-.002.004-.048.1-.002.004-.001.003-.047.101-.002.003-.001.004-.013.027-.052.152-.024.16.006.16.037.157.064.148.091.133.114.114.134.09.147.065.157.036.162.006.159-.024.152-.053.14-.08.122-.105.1-.126.066-.117.01-.023.044-.095.045-.095.002-.003.042-.087.048-.097.048-.095v-.001l.048-.092.001-.001.047-.09.05-.093.002-.002.049-.09.052-.092.001-.002.051-.089.001-.002.051-.087.053-.088.001-.002.055-.091.057-.091.057-.09.001-.002.057-.089.055-.083.001-.002.06-.09.06-.088.062-.089.001-.001.06-.084.063-.088.065-.089.017-.023.016-.025.06-.094.059-.09v-.002l.058-.086.057-.086.001-.001.062-.09.062-.088.001-.002.06-.085.002-.002.06-.082.063-.087.064-.084.002-.002.061-.08.065-.084.064-.08v-.001l.067-.083.067-.082.07-.083.069-.08.063-.074.074-.083.068-.077.002-.002.07-.076.07-.075.072-.077.001-.001.067-.07.076-.078.002-.002.07-.07.075-.075.002-.002.072-.07.075-.072.002-.002.073-.069.074-.068.001-.001.08-.073.076-.068.002-.002.072-.063v-.001l.078-.067.079-.068.002-.001.08-.068.002-.002.077-.063.082-.066.001-.001.075-.06.002-.002.006-.004.117-.111.094-.131.068-.146.04-.156.01-.161-.019-.16-.049-.154-.076-.141-.102-.125-.123-.105-.14-.079-.153-.052-.16-.023-.16.007zm24.596 11.088l-.156.04-.146.067-.131.094-.112.117-.087.135-.061.15-.033.157-.004.134.007.142.005.152.004.15.002.149v.153l.001.011v.015l.004.11.002.11v.002l.002.106v.321l-.003.102-.002.106-.004.107-.005.105-.006.106-.006.106-.008.106v.002l-.008.103v.002l-.01.1-.01.105-.01.105-.013.105-.012.099v.002l-.014.108-.014.1-.016.105-.016.103v.002l-.017.099-.018.104-.019.103v.002l-.019.097-.02.104-.022.103v.001l-.022.098-.023.103v.002l-.024.096-.025.103v.002l-.024.096-.027.102v.003l-.026.093v.001l-.029.103v.002l-.03.099-.028.097v.002l-.03.095-.03.096v.001l-.033.1-.031.095v.002l-.035.1v.003l-.034.094v.003l-.035.096v.001l-.034.09v.002l-.038.098-.036.093v.002l-.038.095-.079.194-.08.188-.085.189-.087.19-.09.184-.092.183-.095.184-.05.093-.064.148-.034.158-.005.16.026.16.054.151.082.14.106.12.127.1.143.075.154.046.16.017.161-.013.156-.042.144-.071.13-.096.109-.119.072-.112.053-.099.003-.005.003-.006.102-.195.003-.006.003-.006.098-.196.003-.006.003-.006.096-.197.002-.006.003-.006.093-.2.002-.006.003-.006.09-.2.002-.006.003-.007.086-.202.003-.006.002-.006.084-.203.002-.005.001-.005.04-.102.002-.003.001-.003.04-.103.001-.003.001-.003.04-.103v-.004l.001-.003.039-.103v-.003l.002-.003.037-.104.001-.003.001-.003.037-.104v-.004l.002-.003.035-.104.002-.003v-.004l.035-.104.002-.004v-.003l.034-.105.002-.003v-.003l.034-.105v-.004l.002-.003.032-.106.001-.003.001-.003.031-.106.001-.003.001-.004.031-.106.001-.003.001-.004.03-.106v-.003l.002-.004.028-.107.001-.003.001-.003.028-.107.001-.004.001-.003.027-.107.001-.004v-.003l.027-.108.001-.003v-.004l.026-.108.001-.003v-.004l.025-.108.001-.003v-.004l.025-.108v-.004l.001-.003.023-.109v-.003l.001-.004.022-.109v-.003l.002-.004.02-.109.001-.004v-.003l.02-.11.002-.003v-.004l.02-.11v-.007l.019-.11v-.003l.001-.004.017-.11v-.004l.001-.003.017-.11v-.008l.016-.11v-.004l.001-.004.015-.11v-.008l.015-.111v-.008l.013-.111v-.007l.013-.112v-.007l.011-.112v-.004l.001-.004.01-.112v-.007l.01-.112v-.008l.008-.112v-.008l.007-.113v-.007l.007-.113v-.008l.005-.113v-.007l.005-.114v-.007l.003-.114v-.007l.003-.114v-.129l.001-.114v-.13l-.003-.114v-.008l-.003-.115v-.007l-.003-.102v-.155l-.003-.158v-.01l-.004-.158v-.01l-.006-.158v-.01l-.007-.148-.023-.16-.051-.152-.08-.14-.103-.124-.125-.102-.142-.077-.153-.05-.16-.02-.161.01zm-30.213.66l-.157.034-.149.063-.134.09-.115.113-.092.132-.067.147-.037.156-.009.134.001.11V15.95l.006.22v.012l.01.22v.012l.012.22v.006l.001.006.015.22v.005l.001.006.018.22.001.006v.006l.022.219v.006l.001.006.024.219.001.006v.006l.028.218.001.006v.006l.031.218.001.006.001.006.033.218.001.006.001.005.037.218v.006l.002.005.04.217v.006l.001.006.043.216.001.006.001.006.046.216v.005l.002.006.048.215.002.006.001.006.051.214.002.006v.006l.055.214.002.005.001.006.057.213.002.006.001.005.06.213.002.005.001.006.063.212.002.005.001.006.066.21.002.006.002.006.068.21.002.005.002.005.07.21.003.005.002.005.074.208.002.006.002.005.077.207.002.006.002.005.08.206.002.005.002.006.082.204.002.006.002.005.086.204.002.005.002.006.088.202.002.005.003.006.09.2.003.006.002.005.094.2.002.006.003.005.096.199.002.005.003.005.03.062.086.137.11.118.128.097.145.07.156.043.16.013.16-.017.155-.047.143-.074.127-.1.106-.121.081-.14.055-.15.025-.16-.005-.161-.034-.158-.05-.124-.028-.055-.092-.19-.087-.188-.087-.192-.083-.19-.08-.193-.078-.194-.076-.196-.073-.195-.07-.197-.067-.198-.065-.199-.063-.2-.059-.2-.056-.2-.055-.204-.05-.201-.049-.202-.046-.205-.043-.206-.04-.203-.038-.207-.034-.204-.032-.207-.028-.205-.026-.207-.023-.208-.02-.207-.018-.207-.014-.208-.011-.207-.009-.208-.005-.207-.002-.104-.017-.16-.046-.155-.074-.143-.1-.126-.121-.107-.139-.081-.152-.055-.159-.025-.161.004zm24.585 11.83l-.156.039-.146.068-.11.076-.015.012-.163.129-.166.127-.168.125-.17.124-.17.12-.172.118-.173.115-.176.114-.177.111-.18.11-.178.105-.182.104-.182.101-.184.1-.184.095-.189.095-.186.09-.188.089-.19.086-.19.082-.193.081-.195.078-.191.074-.197.073-.195.07-.196.065-.198.064-.198.061-.2.058-.2.055-.2.052-.2.049-.151.035-.153.05-.141.078-.125.103-.103.124-.078.14-.05.154-.022.16.009.16.038.157.067.147.093.132.116.112.134.089.149.062.158.034.16.003.133-.02.158-.035.006-.002.006-.001.213-.052.006-.002.007-.001.212-.056.006-.001.006-.002.212-.058.006-.002.006-.002.211-.061.006-.002.006-.002.21-.064.006-.002.006-.002.21-.067.005-.002.006-.002.208-.07.006-.002.006-.003.207-.073.006-.002.006-.002.206-.077.006-.002.005-.002.206-.08.005-.001.006-.003.204-.082.006-.002.005-.002.203-.085.006-.003.005-.002.202-.088.006-.002.005-.003.2-.09.006-.003.006-.003.2-.093.005-.003.005-.002.198-.096.006-.003.005-.003.197-.099.005-.002.005-.003.196-.102.005-.002.005-.003.195-.105.005-.002.005-.003.193-.107.005-.003.005-.003.191-.11.005-.003.005-.003.19-.112.005-.003.005-.003.189-.115.005-.003.005-.003.187-.117.005-.003.004-.004.186-.12.005-.003.004-.003.184-.122.005-.003.005-.004.182-.125.004-.003.005-.003.18-.128.005-.003.005-.003.179-.13.004-.003.005-.004.177-.132.004-.004.005-.003.175-.135.005-.003.004-.004.173-.137.005-.003.004-.004.019-.015.115-.113.092-.132.066-.147.038-.157.008-.16-.022-.16-.052-.153-.079-.14-.103-.124-.125-.102-.142-.078-.153-.05-.16-.02-.16.01zm-19.17.054l-.153.051-.14.079-.124.103-.103.125-.077.141-.05.153-.02.16.009.161.04.156.067.147.093.131.095.094.047.04.005.004.005.004.17.14.005.004.005.004.172.137.004.004.005.003.086.067.003.002.003.002.087.067.003.002.003.002.088.066.002.003.003.002.089.065.002.002.003.002.09.065.002.002.003.002.09.064.002.002.003.002.09.063.003.002.003.002.09.063.003.002.003.002.092.062.002.002.003.002.092.061.003.002.003.002.092.06.003.003.003.001.093.06.003.002.003.002.093.06.003.001.003.002.094.058.003.002.003.002.095.058.003.001.003.002.095.057.003.002.003.002.095.056.003.002.003.002.096.055.004.002.003.001.096.055.003.002.003.002.098.053.003.002.003.002.097.053.004.002.003.001.098.053.003.001.003.002.099.052.003.001.003.002.1.05.003.002.003.002.1.05.003.002.003.001.1.05h.003l.004.003.1.048.004.001.003.002.101.048.003.001.004.002.101.046.004.002.003.001.102.046.004.002.003.001.103.045.003.002.003.001.103.045.004.001.003.002.104.043.003.001.004.002.104.042.003.002.004.001.104.042.004.001.003.002.105.04.004.002.003.001.106.04.003.002h.004l.106.04.004.001.003.002.107.038.003.001.004.001.107.038.003.001.004.001.107.037.004.001.004.001.108.036.003.001.004.001.108.035.004.001.003.001.11.034.003.001.004.001.109.033.004.002h.003l.11.033h.004l.003.002.11.031.004.001.004.001.084.023.081.028.004.001.003.001.109.037.003.001.004.001.109.036.003.001.004.001.109.035h.003l.004.002.11.033.003.001.003.001.11.033.003.001.004.001.109.031.004.002h.003l.11.031.003.001.004.001.11.03h.003l.003.001.11.029h.004l.003.002.11.027.003.001.004.001.11.027h.003l.004.001.004.001.16.022.16-.008.157-.038.147-.067.132-.092.112-.116.09-.134.062-.149.034-.157.004-.161-.025-.16-.055-.151-.082-.139-.107-.12-.127-.1-.143-.074-.124-.04h-.003l-.104-.025-.103-.026h-.002l-.095-.026h-.001l-.101-.027h-.002l-.1-.028h-.002l-.103-.03-.104-.032-.097-.03h-.002l-.103-.033-.102-.033-.101-.034-.106-.036-.027-.01-.027-.007-.107-.03-.104-.029-.104-.03h-.002l-.097-.03-.102-.032-.102-.032-.102-.034-.103-.035-.096-.034-.1-.036-.101-.037h-.002l-.094-.036-.096-.037-.097-.04h-.002l-.099-.04-.098-.042h-.002l-.092-.04-.097-.043-.095-.043-.097-.044h-.002l-.09-.043-.094-.045-.094-.046-.093-.047-.09-.046-.096-.05-.088-.047-.002-.001-.09-.049-.094-.052-.002-.002-.087-.049-.087-.05h-.002l-.088-.053h-.001l-.09-.055-.086-.052-.002-.001-.089-.055-.084-.054h-.002l-.09-.059h-.001l-.085-.056-.001-.001-.084-.056-.082-.056h-.001l-.086-.06-.082-.058H7.79l-.086-.062-.002-.002-.08-.058-.081-.06h-.001l-.085-.064-.002-.002-.076-.058-.002-.002-.082-.064-.161-.128-.162-.133-.04-.034-.132-.092-.147-.066-.157-.038-.16-.008-.16.022z\",\n  opacity: \".98\"\n})));\n\nfunction _extends$d() { _extends$d = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$d.apply(this, arguments); }\nvar StartEventNonInterruptingSignalIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$d({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M16.007 8.82L9.21 21.022h13.596L16.007 8.82zm0 1.775l5.328 9.563H10.68l5.327-9.563zM16.14.386c-1.571.236-4.195-.284-4.9 1.381.619 1.703 2.745.069 4.085.365 1.421-.13 2.84.2 4.235.259C21.27.784 18.19.344 17 .413a20.456 20.456 0 00-.86-.027zM25 3.162c-2.19.694.401 2.26 1.181 3.094 1.083 1.152 1.954 2.484 2.715 3.864 1.48 1.005 1.845-1.26.81-2.03-1.158-1.897-2.613-3.704-4.513-4.89l-.192-.038zm-18.438.423c-1.793.712-2.909 2.548-4.01 4.061-.773.814-2.211 3.653.005 3.211 1.123-1.469 1.87-3.306 3.267-4.614.664-.7 2.73-2.013.738-2.658zm24.57 11.072c-1.659.435-.468 2.667-.99 3.895a13.427 13.427 0 01-1.497 4.435c-.23 1.659 1.991 1.165 2.018-.199a14.277 14.277 0 001.254-7.552.865.865 0 00-.785-.579zm-30.18.666c-1.677.386-.633 2.667-.608 3.876.371 1.623.792 3.35 1.79 4.696 2.382.321.571-2.338.292-3.492a15.92 15.92 0 01-.684-4.39.877.877 0 00-.79-.69zm24.558 11.81c-1.755.865-3.303 2.266-5.274 2.765-1.162-.016-3.074 1.271-1.331 2.102 2.66-.447 5.163-1.733 7.236-3.445.472-.506.06-1.432-.631-1.421zm-19.151.043c-2.004.786.416 2.405 1.43 2.913 1.608.904 3.379 1.636 5.208 1.877 1.77-.804-.228-2.094-1.357-2.073-1.75-.537-3.403-1.396-4.798-2.586l-.227-.104-.256-.027z\"\n})));\n\nfunction _extends$c() { _extends$c = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$c.apply(this, arguments); }\nvar StartEventNonInterruptingTimerIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$c({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.991 8.7c-3.018-.042-5.92 1.925-7.03 4.725-1.138 2.695-.509 6.011 1.537 8.102 1.99 2.142 5.267 2.93 8.013 1.927 2.877-.98 4.99-3.826 5.067-6.87.153-2.956-1.624-5.88-4.299-7.135a7.551 7.551 0 00-3.288-.75zm0 1.383c2.758-.052 5.372 1.972 6.014 4.654.704 2.578-.482 5.516-2.79 6.867-2.358 1.48-5.682 1.085-7.617-.919-2.043-1.97-2.407-5.38-.84-7.743 1.11-1.764 3.149-2.88 5.233-2.86zm1.962 1.764l-2.074 3.762c-.64.068-.793 1.04-.202 1.3.39.27.696-.18 1.052-.165h3.17v-.865h-3.182l1.993-3.614-.757-.418zM16.12.358h-.232l-.22.004h-.012l-.221.006h-.012l-.22.01h-.012l-.22.013h-.012l-.22.016h-.012l-.22.019h-.005l-.006.001-.22.021h-.006l-.005.001-.22.025h-.011l-.22.028h-.005l-.006.002-.219.03h-.005l-.006.001-.218.033-.006.001-.006.001-.217.036-.006.001-.006.001-.217.039-.006.001-.006.001-.216.042-.006.001-.006.001-.215.045-.006.001-.006.002-.215.047-.006.002-.006.001-.214.05-.006.002-.006.002-.115.029-.152.053-.14.081-.122.106-.1.126-.075.143-.047.154-.018.16.012.16.042.156.07.145.095.13.118.11.137.086.15.059.158.03h.161l.132-.022.11-.028.202-.047.203-.046.208-.043.202-.039.206-.037.206-.034.205-.03.208-.03.205-.025.209-.023.208-.02.21-.017.209-.015.207-.011.21-.009.21-.006.207-.003h.21l.21.002.207.005.207.008.212.011.207.014.208.017.209.019.208.022.205.025.206.028.207.03.208.035.205.036.202.039.052.01.16.018.16-.012.156-.042.146-.07.13-.096.109-.119.085-.136.06-.15.03-.159v-.16l-.03-.16-.059-.15-.086-.136L19.823.9l-.13-.096-.145-.07-.128-.038-.057-.011-.006-.002h-.006L19.135.64l-.006-.001-.006-.001-.217-.039H18.9l-.006-.002-.217-.035-.006-.001-.006-.001-.218-.032-.006-.001-.006-.001-.218-.03h-.006l-.006-.001-.219-.027h-.011l-.22-.024-.005-.001h-.006l-.22-.021h-.006L17.512.42l-.22-.017-.005-.001h-.006l-.22-.015h-.012l-.22-.012h-.012l-.22-.01h-.012l-.22-.005h-.012l-.221-.003h-.012zm8.715 2.783l-.157.034-.149.063-.134.089-.116.112-.092.132-.067.147-.038.157-.008.16.021.16.051.153.079.141.103.124.102.087.052.038h.001l.087.064v.001l.082.061.002.001.076.059h.001l.084.065.082.066.002.001.079.063.002.002.077.063.081.067.002.002.077.065.076.065.001.002.08.07.078.07h.002l.075.068.077.072.002.001.073.069.077.073.072.07.002.001.077.076.07.07v.001l.075.076.07.073.002.001.074.079.002.002.069.074.069.075.074.082.07.08.002.001.068.079h.001l.067.079.068.082.065.078.001.002.068.083.067.084.063.081.001.002.067.087.002.002.063.084.001.001.064.087.008.01.008.01.095.12.093.121.09.119.087.119.088.122.086.123.084.12.081.122.001.002.084.126.08.126.08.127.077.126.079.131.074.127.075.131.073.131.07.13.07.133.069.133.045.09.086.137.109.119.13.096.144.07.156.042.16.013.16-.017.155-.047.143-.075.126-.1.106-.121.082-.14.054-.151.025-.16-.005-.16-.035-.158-.05-.124-.048-.095-.002-.004-.002-.004-.073-.14-.002-.005-.002-.004-.074-.14-.002-.004-.002-.004-.076-.14-.002-.003-.002-.004-.077-.139-.003-.004-.002-.004-.078-.138-.003-.004-.002-.003-.08-.137-.002-.004-.003-.004-.081-.136-.002-.004-.003-.004-.083-.136-.002-.003-.002-.004-.085-.135-.002-.004-.003-.003-.085-.134-.003-.004-.002-.004-.087-.132-.003-.004-.003-.004-.088-.132-.003-.003-.002-.004-.09-.13-.003-.005-.003-.003-.091-.13-.003-.004-.002-.004-.093-.129-.003-.003-.003-.004-.094-.128-.003-.004-.003-.003-.095-.127-.003-.004-.003-.004-.097-.125-.003-.004-.003-.004-.09-.114-.06-.082-.003-.003-.002-.003-.069-.091-.002-.004-.002-.003-.07-.09-.003-.003-.002-.003-.07-.09-.003-.003-.002-.003-.071-.09-.002-.003-.003-.002-.072-.089-.002-.003-.002-.003-.073-.088-.002-.003-.002-.002-.074-.087-.002-.003-.002-.003-.074-.086-.003-.003-.002-.003-.074-.086-.003-.002-.002-.003-.075-.085-.003-.003-.002-.002-.076-.084-.002-.003-.003-.003-.076-.083-.002-.003-.003-.003-.077-.082-.002-.003-.003-.002-.077-.082-.003-.003-.003-.002-.078-.081-.002-.003-.003-.003-.078-.08-.003-.002-.003-.003-.079-.08-.002-.002-.003-.002-.08-.08-.002-.002-.003-.002-.08-.078-.003-.003-.003-.002-.08-.077-.003-.003-.003-.002-.082-.077-.002-.002-.003-.002-.082-.076-.003-.002-.002-.003-.083-.075-.003-.002-.002-.003-.084-.074-.002-.002-.003-.002-.084-.074-.003-.002-.002-.002-.085-.073-.002-.002-.003-.003-.085-.071-.003-.003-.002-.002-.086-.07-.003-.003-.002-.002-.086-.07-.003-.003-.003-.002-.086-.07-.003-.002-.003-.002-.087-.069-.002-.002-.003-.002-.088-.068-.002-.002-.003-.002-.088-.067-.003-.003-.003-.002-.088-.066-.003-.002-.003-.002-.089-.066-.003-.002-.003-.002-.057-.042-.14-.082-.15-.055-.16-.026-.16.004zm-18.458.426l-.157.037-.148.066-.111.074-.007.006-.003.002-.003.002-.086.069-.003.002-.002.002-.086.07-.003.002-.002.002-.086.07-.002.003-.003.002-.085.071-.002.002-.003.003-.084.071-.003.003-.002.002-.084.072-.003.003-.002.002-.083.073-.003.003-.002.002-.083.074-.002.002-.003.003-.082.074-.003.003-.002.002-.081.076-.003.002-.003.002-.08.077-.003.002-.003.003-.08.076-.002.003-.003.002-.08.078-.002.002-.003.003-.079.078-.002.003-.003.002-.078.08-.003.002-.002.002-.078.08-.002.003-.003.002-.077.08-.003.004-.002.002-.077.081-.002.003-.003.003-.076.082-.002.002-.003.003-.075.082-.002.003-.003.003-.074.083-.003.003-.002.003-.074.084-.003.003-.002.002-.074.085-.002.003-.002.003-.073.085-.003.003-.002.003-.072.086-.002.003-.003.003-.071.087-.003.003-.002.002-.07.088-.003.003-.002.003-.07.088-.003.003-.002.003-.07.09-.002.002-.002.003-.069.09-.002.003-.003.003-.068.09-.002.003-.002.003-.067.092-.003.003-.002.003-.067.092-.002.003-.002.003-.066.092-.002.003-.002.004-.066.093-.002.003-.002.003-.065.094-.002.003-.002.004-.064.094-.002.003-.002.004-.063.095-.002.003-.002.003-.063.097-.002.003-.002.003-.046.073-.05.07-.003.002-.002.003-.067.093-.003.003-.002.003-.066.094-.002.003-.002.003-.066.094-.002.003-.002.003-.064.094-.002.004-.002.003-.064.094-.002.004-.002.003-.062.095-.002.003-.002.003-.062.096-.002.003-.002.003-.06.096-.003.003-.002.003-.06.096-.001.004-.002.003-.059.096-.002.004-.002.003-.058.097-.002.003-.001.003-.057.098-.002.003-.002.003-.056.098-.002.003-.002.003-.055.098-.002.004-.001.003-.055.098-.001.004-.002.003-.054.099-.001.003-.002.003-.052.1-.002.002-.002.004-.051.1-.002.002-.002.004-.05.1-.002.003-.002.003-.05.1v.003l-.002.004-.05.1V9.5l-.002.004-.048.1-.002.004-.001.003-.047.101-.002.003-.001.004-.013.027-.052.152-.024.16.006.16.037.157.064.148.091.133.114.114.134.09.147.065.157.036.162.006.159-.024.152-.053.14-.08.122-.105.1-.126.066-.117.01-.023.044-.095.045-.095.002-.003.042-.087.048-.097.048-.095v-.001l.048-.092.001-.001.047-.09.05-.093.002-.002.049-.09.052-.092.001-.002.051-.089.001-.002.051-.087.053-.088.001-.002.055-.091.057-.091.057-.09.001-.002.057-.089.055-.083.001-.002.06-.09.06-.088.062-.089.001-.001.06-.084.063-.088.065-.089.017-.023.016-.025.06-.094.059-.09v-.002l.058-.086.057-.086.001-.001.062-.09.062-.088.001-.002.06-.085.002-.002.06-.082.063-.087.064-.084.002-.002.061-.08.065-.084.064-.08v-.001l.067-.083.067-.082.07-.083.069-.08.063-.074.074-.083.068-.077.002-.002.07-.076.07-.075.072-.077.001-.001.067-.07.076-.078.002-.002.07-.07.075-.075.002-.002.072-.07.075-.072.002-.002.073-.069.074-.068.001-.001.08-.073.076-.068.002-.002.072-.063v-.001l.078-.067.079-.068.002-.001.08-.068.002-.002.077-.063.082-.066.001-.001.075-.06.002-.002.006-.004.117-.111.094-.131.068-.146.04-.156.01-.161-.019-.16-.049-.154-.076-.141-.102-.125-.123-.105-.14-.079-.153-.052-.16-.023-.16.007zm24.596 11.088l-.156.04-.146.067-.131.094-.112.117-.087.135-.061.15-.033.157-.004.134.007.142.005.152.004.15.002.149v.153l.001.011v.015l.004.11.002.11v.002l.002.106v.321l-.003.102-.002.106-.004.107-.005.105-.006.106-.006.106-.008.106v.002l-.008.103v.002l-.01.1-.01.105-.01.105-.013.105-.012.099v.002l-.014.108-.014.1-.016.105-.016.103v.002l-.017.099-.018.104-.019.103v.002l-.019.097-.02.104-.022.103v.001l-.022.098-.023.103v.002l-.024.096-.025.103v.002l-.024.096-.027.102v.003l-.026.093v.001l-.029.103v.002l-.03.099-.028.097v.002l-.03.095-.03.096v.001l-.033.1-.031.095v.002l-.035.1v.003l-.034.094v.003l-.035.096v.001l-.034.09v.002l-.038.098-.036.093v.002l-.038.095-.079.194-.08.188-.085.189-.087.19-.09.184-.092.183-.095.184-.05.093-.064.148-.034.158-.005.16.026.16.054.151.082.14.106.12.127.1.143.075.154.046.16.017.161-.013.156-.042.144-.071.13-.096.109-.119.072-.112.053-.099.003-.005.003-.006.102-.195.003-.006.003-.006.098-.196.003-.006.003-.006.096-.197.002-.006.003-.006.093-.2.002-.006.003-.006.09-.2.002-.006.003-.007.086-.202.003-.006.002-.006.084-.203.002-.005.001-.005.04-.102.002-.003.001-.003.04-.103.001-.003.001-.003.04-.103v-.004l.001-.003.039-.103v-.003l.002-.003.037-.104.001-.003.001-.003.037-.104v-.004l.002-.003.035-.104.002-.003v-.004l.035-.104.002-.004v-.003l.034-.105.002-.003v-.003l.034-.105v-.004l.002-.003.032-.106.001-.003.001-.003.031-.106.001-.003.001-.004.031-.106.001-.003.001-.004.03-.106v-.003l.002-.004.028-.107.001-.003.001-.003.028-.107.001-.004.001-.003.027-.107.001-.004v-.003l.027-.108.001-.003v-.004l.026-.108.001-.003v-.004l.025-.108.001-.003v-.004l.025-.108v-.004l.001-.003.023-.109v-.003l.001-.004.022-.109v-.003l.002-.004.02-.109.001-.004v-.003l.02-.11.002-.003v-.004l.02-.11v-.007l.019-.11v-.003l.001-.004.017-.11v-.004l.001-.003.017-.11v-.008l.016-.11v-.004l.001-.004.015-.11v-.008l.015-.111v-.008l.013-.111v-.007l.013-.112v-.007l.011-.112v-.004l.001-.004.01-.112v-.007l.01-.112v-.008l.008-.112v-.008l.007-.113v-.007l.007-.113v-.008l.005-.113v-.007l.005-.114v-.007l.003-.114v-.007l.003-.114v-.129l.001-.114v-.13l-.003-.114V16.5l-.003-.115v-.007l-.003-.102v-.155l-.003-.158v-.01l-.004-.158v-.01l-.006-.158v-.01l-.007-.148-.023-.16-.051-.152-.08-.14-.103-.124-.125-.102-.142-.077-.153-.05-.16-.02-.161.01zm-30.213.66l-.157.034-.149.063-.134.09-.115.113-.092.132-.067.147-.037.156-.009.134.001.11V16.308l.006.22v.012l.01.22v.012l.012.22v.006l.001.006.015.22v.005l.001.006.018.22.001.006v.006l.022.219v.006l.001.006.024.219.001.006v.006l.028.218.001.006v.006l.031.218.001.006.001.006.033.218.001.006.001.005.037.218v.006l.002.005.04.217v.006l.001.006.043.216.001.006.001.006.046.216v.005l.002.006.048.215.002.006.001.006.051.214.002.006v.006l.055.214.002.005.001.006.057.213.002.006.001.005.06.213.002.005.001.006.063.212.002.005.001.006.066.21.002.006.002.006.068.21.002.005.002.005.07.21.003.005.002.005.074.208.002.006.002.005.077.207.002.006.002.005.08.206.002.005.002.006.082.204.002.006.002.005.086.204.002.005.002.006.088.202.002.005.003.006.09.2.003.006.002.005.094.2.002.006.003.005.096.199.002.005.003.005.03.062.086.137.11.118.128.097.145.07.156.043.16.013.16-.017.155-.047.143-.074.127-.1.106-.121.081-.14.055-.15.025-.16-.005-.161-.034-.158-.05-.124-.028-.055-.092-.19-.087-.188-.087-.192-.083-.19-.08-.193-.078-.194-.076-.196-.073-.195-.07-.197-.067-.198-.065-.199-.063-.2-.059-.2-.056-.2-.055-.204-.05-.201-.049-.202-.046-.205-.043-.206-.04-.203-.038-.207-.034-.204-.032-.207-.028-.205-.026-.207-.023-.208-.02-.207-.018-.207-.014-.208-.011-.207-.009-.208-.005-.207-.002-.104-.017-.16-.046-.155-.074-.143-.1-.126-.121-.107-.139-.081-.152-.055-.159-.025-.161.004zm24.585 11.83l-.156.039-.146.068-.11.076-.015.012-.163.129-.166.127-.168.125-.17.124-.17.12-.172.118-.173.115-.176.114-.177.111-.18.11-.178.105-.182.104-.182.101-.184.1-.184.095-.189.095-.186.09-.188.089-.19.086-.19.082-.193.081-.195.078-.191.074-.197.073-.195.07-.196.065-.198.064-.198.061-.2.058-.2.055-.2.052-.2.049-.151.035-.153.05-.141.078-.125.103-.103.124-.078.14-.05.154-.022.16.009.16.038.157.067.147.093.132.116.112.134.089.149.062.158.034.16.003.133-.02.158-.035.006-.002.006-.001.213-.052.006-.002.007-.001.212-.056.006-.001.006-.002.212-.058.006-.002.006-.002.211-.061.006-.002.006-.002.21-.064.006-.002.006-.002.21-.067.005-.002.006-.002.208-.07.006-.002.006-.003.207-.073.006-.002.006-.002.206-.077.006-.002.005-.002.206-.08.005-.001.006-.003.204-.082.006-.002.005-.002.203-.085.006-.003.005-.002.202-.088.006-.002.005-.003.2-.09.006-.003.006-.003.2-.093.005-.003.005-.002.198-.096.006-.003.005-.003.197-.099.005-.002.005-.003.196-.102.005-.002.005-.003.195-.105.005-.002.005-.003.193-.107.005-.003.005-.003.191-.11.005-.003.005-.003.19-.112.005-.003.005-.003.189-.115.005-.003.005-.003.187-.117.005-.003.004-.004.186-.12.005-.003.004-.003.184-.122.005-.003.005-.004.182-.125.004-.003.005-.003.18-.128.005-.003.005-.003.179-.13.004-.003.005-.004.177-.132.004-.004.005-.003.175-.135.005-.003.004-.004.173-.137.005-.003.004-.004.019-.015.115-.113.092-.132.066-.147.038-.157.008-.16-.022-.16-.052-.153-.079-.14-.103-.124-.125-.102-.142-.078-.153-.05-.16-.02-.16.01zm-19.17.054l-.153.051-.14.079-.124.103-.103.125-.077.141-.05.153-.02.16.009.161.04.156.067.147.093.131.095.094.047.04.005.004.005.004.17.14.005.004.005.004.172.137.004.004.005.003.086.067.003.002.003.002.087.067.003.002.003.002.088.066.002.003.003.002.089.065.002.002.003.002.09.065.002.002.003.002.09.064.002.002.003.002.09.063.003.002.003.002.09.063.003.002.003.002.092.062.002.002.003.002.092.061.003.002.003.002.092.06.003.003.003.001.093.06.003.002.003.002.093.06.003.001.003.002.094.058.003.002.003.002.095.058.003.001.003.002.095.057.003.002.003.002.095.056.003.002.003.002.096.055.004.002.003.001.096.055.003.002.003.002.098.053.003.002.003.002.097.053.004.002.003.001.098.053.003.001.003.002.099.052.003.001.003.002.1.05.003.002.003.002.1.05.003.002.003.001.1.05h.003l.004.003.1.048.004.001.003.002.101.048.003.001.004.002.101.046.004.002.003.001.102.046.004.002.003.001.103.045.003.002.003.001.103.045.004.001.003.002.104.043.003.001.004.002.104.042.003.002.004.001.104.042.004.001.003.002.105.04.004.002.003.001.106.04.003.002h.004l.106.04.004.001.003.002.107.038.003.001.004.001.107.038.003.001.004.001.107.037.004.001.004.001.108.036.003.001.004.001.108.035.004.001.003.001.11.034.003.001.004.001.109.033.004.002h.003l.11.033h.004l.003.002.11.031.004.001.004.001.084.023.081.028.004.001.003.001.109.037.003.001.004.001.109.036.003.001.004.001.109.035h.003l.004.002.11.033.003.001.003.001.11.033.003.001.004.001.109.031.004.002h.003l.11.031.003.001.004.001.11.03h.003l.003.001.11.029h.004l.003.002.11.027.003.001.004.001.11.027h.003l.004.001.004.001.16.022.16-.008.157-.038.147-.067.132-.092.112-.116.09-.134.062-.149.034-.157.004-.161-.025-.16-.055-.151-.082-.139-.107-.12-.127-.1-.143-.074-.124-.04h-.003l-.104-.025-.103-.026h-.002l-.095-.026h-.001l-.101-.027h-.002l-.1-.028h-.002l-.103-.03-.104-.032-.097-.03h-.002l-.103-.033-.102-.033-.101-.034-.106-.036-.027-.01-.027-.007-.107-.03-.104-.029-.104-.03h-.002l-.097-.03-.102-.032-.102-.032-.102-.034-.103-.035-.096-.034-.1-.036-.101-.037h-.002l-.094-.036-.096-.037-.097-.04h-.002l-.099-.04-.098-.042h-.002l-.092-.04-.097-.043-.095-.043-.097-.044h-.002l-.09-.043-.094-.045-.094-.046-.093-.047-.09-.046-.096-.05-.088-.047-.002-.001-.09-.049-.094-.052-.002-.002-.087-.049-.087-.05h-.002l-.088-.053h-.001l-.09-.055-.086-.052-.002-.001-.089-.055-.084-.054h-.002l-.09-.059h-.001l-.085-.056-.001-.001-.084-.056-.082-.056h-.001l-.086-.06-.082-.058H7.79l-.086-.062-.002-.002-.08-.058-.081-.06h-.001l-.085-.064-.002-.002-.076-.058-.002-.002-.082-.064-.161-.128-.162-.133-.04-.034-.132-.092-.147-.066-.157-.038-.16-.008-.16.022z\"\n})));\n\nfunction _extends$b() { _extends$b = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$b.apply(this, arguments); }\nvar StartEventNoneIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$b({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.847.004C9.61-.016 3.624 4.014 1.257 9.78-1.235 15.49.06 22.581 4.42 27.034c4.193 4.513 11.101 6.17 16.887 4.058 5.996-2.042 10.423-7.93 10.664-14.268.403-6.228-3.26-12.441-8.87-15.154A15.924 15.924 0 0015.846.004zm.439 1.729c6.105.033 11.856 4.45 13.435 10.359 1.678 5.653-.592 12.198-5.463 15.547-5.06 3.719-12.564 3.45-17.343-.625-4.814-3.84-6.538-10.94-4.067-16.57 2.14-5.206 7.515-8.775 13.147-8.71.097-.001.194-.002.29-.001z\"\n})));\n\nfunction _extends$a() { _extends$a = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$a.apply(this, arguments); }\nvar StartEventParallelMultipleIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$a({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.847 0C9.61-.02 3.624 4.01 1.257 9.775-1.235 15.485.06 22.577 4.42 27.03c4.193 4.513 11.101 6.17 16.887 4.058 5.996-2.042 10.423-7.93 10.664-14.268.403-6.228-3.26-12.441-8.87-15.154A15.924 15.924 0 0015.846 0zm.439 1.729c6.105.033 11.856 4.45 13.435 10.359 1.678 5.653-.592 12.198-5.463 15.547-5.06 3.719-12.564 3.45-17.343-.625C2.101 23.17.377 16.07 2.848 10.44c2.134-5.2 7.522-8.78 13.147-8.71.097-.001.194-.002.29-.001zM13.504 9.08v4.427H9.077v4.98h4.427v4.427h4.98v-4.427h4.428v-4.98h-4.427V9.08h-4.98zm.83.83h3.32v4.427h4.428v3.32h-4.427v4.427h-3.32v-4.453H9.906v-3.294h4.427V9.91z\"\n})));\n\nfunction _extends$9() { _extends$9 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$9.apply(this, arguments); }\nvar StartEventSignalIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$9({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M15.995.005C9.705-.08 3.643 3.968 1.257 9.78-1.235 15.49.06 22.581 4.42 27.034c4.193 4.513 11.102 6.17 16.887 4.058 5.996-2.042 10.423-7.93 10.664-14.269.403-6.227-3.26-12.44-8.87-15.153A15.924 15.924 0 0015.994.005zm0 1.73c6.213-.108 12.122 4.355 13.726 10.357 1.678 5.653-.592 12.198-5.463 15.547-5.06 3.719-12.564 3.45-17.343-.626-4.814-3.838-6.538-10.939-4.067-16.57 2.14-5.205 7.515-8.774 13.147-8.708zm0 6.776L9.19 20.724H22.8L15.995 8.511zm0 1.777l5.332 9.572H10.662l5.333-9.572z\"\n})));\n\nfunction _extends$8() { _extends$8 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$8.apply(this, arguments); }\nvar StartEventTimerIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$8({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M16 0C7.174 0 0 7.174 0 16s7.174 16 16 16 16-7.174 16-16S24.826 0 16 0zm0 1.73c7.892 0 14.27 6.378 14.27 14.27 0 7.891-6.379 14.27-14.27 14.27S1.73 23.891 1.73 16C1.73 8.108 8.108 1.73 16 1.73zm-.143 6.676c-2.967.02-5.797 1.97-6.89 4.727-1.138 2.695-.51 6.012 1.537 8.102 1.99 2.142 5.268 2.932 8.014 1.928 2.878-.98 4.992-3.827 5.068-6.87.153-2.957-1.624-5.881-4.3-7.137a7.552 7.552 0 00-3.43-.75zm.27 1.383c2.71.012 5.254 2.015 5.886 4.656.704 2.577-.482 5.517-2.791 6.867-2.358 1.48-5.682 1.085-7.618-.918-2.043-1.971-2.407-5.381-.84-7.745 1.11-1.763 3.15-2.88 5.234-2.86h.13zm1.833 1.765l-2.074 3.763c-.64.068-.793 1.04-.202 1.3.39.27.696-.18 1.052-.165h3.17v-.865h-3.181l1.992-3.615-.757-.418z\"\n})));\n\nfunction _extends$7() { _extends$7 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$7.apply(this, arguments); }\nvar SubprocessCollapsedIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$7({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M5.637 3A5.644 5.644 0 000 8.637v15.417a5.644 5.644 0 005.637 5.637h20.726A5.644 5.644 0 0032 24.054V8.637A5.644 5.644 0 0026.363 3H5.637zm0 1.778h20.726a3.83 3.83 0 013.859 3.859v15.417a3.83 3.83 0 01-3.859 3.858h-4.201V16.695H9.838v11.217H5.637a3.83 3.83 0 01-3.859-3.858V8.637a3.83 3.83 0 013.859-3.859zm5.33 13.046h10.066v10.065H10.967V17.824zm4.189 1.431V22.06H12.35v1.689h2.804V26.554h1.69V23.749h2.804V22.06h-2.804V19.255h-1.69z\"\n})));\n\nfunction _extends$6() { _extends$6 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$6.apply(this, arguments); }\nvar SubprocessExpandedIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$6({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M5.636 3A5.642 5.642 0 000 8.636v15.418a5.643 5.643 0 005.636 5.636h20.728A5.643 5.643 0 0032 24.054V8.636A5.642 5.642 0 0026.364 3H5.636zm0 1.778h20.728a3.83 3.83 0 013.858 3.858v15.418a3.83 3.83 0 01-3.858 3.858h-4.203V16.723H9.84v11.189H5.636a3.83 3.83 0 01-3.858-3.858V8.636a3.83 3.83 0 013.858-3.858zm5.331 13.074h10.066v10.06H10.967v-10.06zm1.336 3.996v1.711h7.394v-1.71h-7.394z\"\n})));\n\nfunction _extends$5() { _extends$5 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$5.apply(this, arguments); }\nvar TaskNoneIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$5({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M6.494 2.667C2.916 2.667 0 5.57 0 9.142v13.383C0 26.097 2.916 29 6.494 29h19.012C29.084 29 32 26.097 32 22.525V9.142c0-3.572-2.916-6.475-6.494-6.475H6.494zm0 2h19.012c2.509 0 4.494 1.98 4.494 4.475v13.383C30 25.02 28.015 27 25.506 27H6.494C3.985 27 2 25.02 2 22.525V9.142c0-2.495 1.985-4.475 4.494-4.475z\"\n})));\n\nfunction _extends$4() { _extends$4 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$4.apply(this, arguments); }\nvar TextAnnotationicon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$4({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M22.087 0v31.647H32v-1.788h-8.125V1.788H32V0h-9.913zm-2.924 13.999l-2.737 2.167 2.167 2.738 2.738-2.167-2.168-2.738zm-5.475 4.335L10.95 20.5l2.168 2.738 2.737-2.168-2.167-2.737zm-5.475 4.335l-2.738 2.167 2.168 2.738 2.737-2.168-2.167-2.737zm-5.476 4.335L0 29.17l2.167 2.738 2.738-2.168-2.168-2.737z\"\n})));\n\nfunction _extends$3() { _extends$3 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$3.apply(this, arguments); }\nvar TransactionIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$3({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  d: \"M5.422 3A5.424 5.424 0 000 8.422v15.822a5.424 5.424 0 005.422 5.423h21.156A5.424 5.424 0 0032 24.244V8.422A5.424 5.424 0 0026.578 3H5.422zm0 1.244h21.156a4.155 4.155 0 014.178 4.178v15.822a4.155 4.155 0 01-4.178 4.178H5.422a4.155 4.155 0 01-4.178-4.178V8.422a4.155 4.155 0 014.178-4.178zm1.056 1.778a3.373 3.373 0 00-3.367 3.366v13.89a3.373 3.373 0 003.367 3.366h19.044a3.373 3.373 0 003.367-3.366V9.388a3.373 3.373 0 00-3.367-3.366H6.478zm0 1.245h19.044c1.187 0 2.122.935 2.122 2.121v13.89a2.104 2.104 0 01-2.122 2.122H6.478a2.104 2.104 0 01-2.122-2.122V9.388c0-1.186.935-2.121 2.122-2.121z\"\n})));\n\nfunction _extends$2() { _extends$2 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2.apply(this, arguments); }\nvar UserTaskIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$2({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  width: \"32\",\n  height: \"32\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  fillRule: \"evenodd\",\n  d: \"M10.263 7.468c-1.698 0-2.912 1.305-2.915 2.791v.001c0 .45.121.924.311 1.352.138.309.308.593.516.82-1.235.423-2.683 1.119-3.414 2.49l-.04.075v4.44h11.083v-4.44l-.04-.074c-.72-1.352-2.136-2.047-3.36-2.471.597-.608.774-1.392.774-2.192-.004-1.487-1.218-2.792-2.915-2.792zm-1.16 1.583c.08 0 .165.003.26.008.757.045 1.012.181 1.207.31.196.13.334.252.851.268.404-.016.598-.087.737-.169.056-.033.103-.067.152-.1.128.275.197.578.198.893 0 .894-.154 1.52-.975 2.034l.08.604c.171.052.348.11.527.171.025.105.054.242.073.387.02.153.029.311.016.43a.422.422 0 01-.056.19c-.417.417-1.157.66-1.908.66-.75 0-1.49-.243-1.908-.66a.422.422 0 01-.056-.19 1.949 1.949 0 01.016-.43c.02-.146.049-.284.074-.388.177-.062.352-.118.521-.17l.048-.648a.616.616 0 00-.126-.118c-.183-.138-.405-.44-.562-.793-.157-.353-.254-.757-.254-1.08 0-.387.105-.758.297-1.079l.11-.04c.143-.046.339-.09.679-.09zm-1.448 4.304l-.002.014c-.025.185-.04.387-.018.589.021.202.074.42.248.593.595.594 1.494.857 2.382.857.889 0 1.788-.263 2.382-.857.174-.174.227-.391.249-.593a2.496 2.496 0 00-.018-.59l-.002-.01c.903.396 1.776.963 2.258 1.81v3.599H13.53v-2.538h-.67v2.538H7.651v-2.538h-.67v2.538H5.39v-3.599c.483-.849 1.359-1.416 2.264-1.813zM6.495 3C2.914 3 0 5.903 0 9.475v13.383c0 3.572 2.916 6.475 6.494 6.475h19.012c3.578 0 6.494-2.903 6.494-6.475V9.475C32 5.903 29.084 3 25.506 3H6.494zm0 2h19.01C28.016 5 30 6.98 30 9.475v13.383c0 2.495-1.985 4.475-4.494 4.475H6.494C3.985 27.333 2 25.353 2 22.858V9.475C2 6.98 3.985 5 6.494 5z\"\n})));\n\nvar iconsByType = {\n  'Association': AssociationIcon,\n  'BusinessRuleTask': BusinessRuleTaskIcon,\n  'CallActivity': CallActivityIcon,\n  'Collaboration': CollaborationIcon,\n  'ConditionalFlow': ConditionalFlowIcon,\n  'SequenceFlow': ConnectionIcon,\n  'DataInput': DataInputIcon,\n  'DataInputAssociation': DataInputOutputAssociationIcon,\n  'DataOutput': DataOutputIcon,\n  'DataOutputAssociation': DataInputOutputAssociationIcon,\n  'DataObjectReference': DataObjectIcon,\n  'DataStoreReference': DataStoreIcon,\n  'DefaultFlow': DefaultFlowIcon,\n  'CancelEndEvent': EndEventCancelIcon,\n  'CompensateEndEvent': EndEventCompensationIcon,\n  'ErrorEndEvent': EndEventErrorIcon,\n  'EscalationEndEvent': EndEventEscalationIcon,\n  'LinkEndEvent': EndEventLinkIcon,\n  'MessageEndEvent': EndEventMessageIcon,\n  'MultipleEndEvent': EndEventMultipleIcon,\n  'EndEvent': EndEventNoneIcon,\n  'SignalEndEvent': EndEventSignalIcon,\n  'TerminateEndEvent': EndEventTerminateIcon,\n  'EventSubProcess': EventSubProcessExpandedIcon,\n  'ComplexGateway': GatewayComplexIcon,\n  'EventBasedGateway': GatewayEventBasedIcon,\n  'ExclusiveGateway': GatewayXorIcon,\n  'Gateway': GatewayNoneIcon,\n  'InclusiveGateway': GatewayOrIcon,\n  'ParallelGateway': GatewayParallelIcon,\n  'Group': GroupIcon,\n  'CancelIntermediateCatchEvent': IntermediateEventCatchCancelIcon,\n  'CompensateIntermediateCatchEvent': IntermediateEventCatchCompensationIcon,\n  'ConditionalIntermediateCatchEvent': IntermediateEventCatchConditionIcon,\n  'ErrorIntermediateCatchEvent': IntermediateEventCatchErrorIcon,\n  'EscalationIntermediateCatchEvent': IntermediateEventCatchEscalationIcon,\n  'LinkIntermediateCatchEvent': IntermediateEventCatchLinkIcon,\n  'MessageIntermediateCatchEvent': IntermediateEventCatchMessageIcon,\n  'MultipleIntermediateCatchEvent': IntermediateEventCatchMultipleIcon,\n  'ConditionalIntermediateCatchEventNonInterrupting': IntermediateEventCatchNonInterruptingConditionIcon,\n  'EscalationIntermediateCatchEventNonInterrupting': IntermediateEventCatchNonInterruptingEscalationIcon,\n  'MessageIntermediateCatchEventNonInterrupting': IntermediateEventCatchNonInterruptingMessageIcon,\n  'MultipleIntermediateCatchEventNonInterrupting': IntermediateEventCatchNonInterruptingMultipleIcon,\n  'ParallelIntermediateCatchEventNonInterrupting': IntermediateEventCatchNonInterruptingParallelIcon,\n  'SignalIntermediateCatchEventNonInterrupting': IntermediateEventCatchNonInterruptingSignalIcon,\n  'TimerIntermediateCatchEventNonInterrupting': IntermediateEventCatchNonInterruptingTimerIcon,\n  'ParallelMultipleIntermediateCatchEvent': IntermediateEventCatchParallelMultipleIcon,\n  'SignalIntermediateCatchEvent': IntermediateEventCatchSignalIcon,\n  'TimerIntermediateCatchEvent': IntermediateEventCatchTimerIcon,\n  'IntermediateThrowEvent': IntermediateEventNoneIcon,\n  'CompensateIntermediateThrowEvent': IntermediateEventThrowCompensationIcon,\n  'EscalationIntermediateThrowEvent': IntermediateEventThrowEscalationIcon,\n  'LinkIntermediateThrowEvent': IntermediateEventThrowLinkIcon,\n  'MessageIntermediateThrowEvent': IntermediateEventThrowMessageIcon,\n  'MultipleIntermediateThrowEvent': IntermediateEventThrowMultipleIcon,\n  'SignalIntermediateThrowEvent': IntermediateEventThrowSignalIcon,\n  'Lane': LaneIcon,\n  'ManualTask': ManualTaskIcon,\n  'MessageFlow': MessageFlowIcon,\n  'Participant': ParticipantIcon,\n  'Process': ProcessIcon,\n  'ReceiveTask': ReceiveTaskIcon,\n  'ScriptTask': ScriptTaskIcon,\n  'SendTask': SendTaskIcon,\n  'ServiceTask': ServiceTaskIcon,\n  'CompensateStartEvent': StartEventCompensationIcon,\n  'ConditionalStartEvent': StartEventConditionIcon,\n  'ErrorStartEvent': StartEventErrorIcon,\n  'EscalationStartEvent': StartEventEscalationIcon,\n  'MessageStartEvent': StartEventMessageIcon,\n  'MultipleStartEvent': StartEventMultipleIcon,\n  'ConditionalStartEventNonInterrupting': StartEventNonInterruptingConditionIcon,\n  'EscalationStartEventNonInterrupting': StartEventNonInterruptingEscalationIcon,\n  'MessageStartEventNonInterrupting': StartEventNonInterruptingMessageIcon,\n  'MultipleStartEventNonInterrupting': StartEventNonInterruptingMultipleIcon,\n  'ParallelMultipleStartEventNonInterrupting': StartEventNonInterruptingParallelMultipleIcon,\n  'SignalStartEventNonInterrupting': StartEventNonInterruptingSignalIcon,\n  'TimerStartEventNonInterrupting': StartEventNonInterruptingTimerIcon,\n  'CancelBoundaryEvent': IntermediateEventCatchCancelIcon,\n  'CompensateBoundaryEvent': IntermediateEventCatchCompensationIcon,\n  'ConditionalBoundaryEvent': IntermediateEventCatchConditionIcon,\n  'ErrorBoundaryEvent': IntermediateEventCatchErrorIcon,\n  'EscalationBoundaryEvent': IntermediateEventCatchEscalationIcon,\n  'LinkBoundaryEvent': IntermediateEventCatchLinkIcon,\n  'MessageBoundaryEvent': IntermediateEventCatchMessageIcon,\n  'MultipleBoundaryEvent': IntermediateEventCatchMultipleIcon,\n  'BoundaryEvent': IntermediateEventNoneIcon,\n  'ConditionalBoundaryEventNonInterrupting': IntermediateEventCatchNonInterruptingConditionIcon,\n  'EscalationBoundaryEventNonInterrupting': IntermediateEventCatchNonInterruptingEscalationIcon,\n  'MessageBoundaryEventNonInterrupting': IntermediateEventCatchNonInterruptingMessageIcon,\n  'MultipleBoundaryEventNonInterrupting': IntermediateEventCatchNonInterruptingMultipleIcon,\n  'ParallelBoundaryEventNonInterrupting': IntermediateEventCatchNonInterruptingParallelIcon,\n  'SignalBoundaryEventNonInterrupting': IntermediateEventCatchNonInterruptingSignalIcon,\n  'TimerBoundaryEventNonInterrupting': IntermediateEventCatchNonInterruptingTimerIcon,\n  'ParallelMultipleBoundaryEvent': IntermediateEventCatchParallelMultipleIcon,\n  'SignalBoundaryEvent': IntermediateEventCatchSignalIcon,\n  'TimerBoundaryEvent': IntermediateEventCatchTimerIcon,\n  'StartEvent': StartEventNoneIcon,\n  'ParallelMultipleStartEvent': StartEventParallelMultipleIcon,\n  'SignalStartEvent': StartEventSignalIcon,\n  'TimerStartEvent': StartEventTimerIcon,\n  'CollapsedSubProcess': SubprocessCollapsedIcon,\n  'CollapsedAdHocSubProcess': SubprocessCollapsedIcon,\n  'ExpandedSubProcess': SubprocessExpandedIcon,\n  'ExpandedAdHocSubProcess': SubprocessExpandedIcon,\n  'Task': TaskNoneIcon,\n  'TextAnnotation': TextAnnotationicon,\n  'Transaction': TransactionIcon,\n  'UserTask': UserTaskIcon\n};\n\nfunction getConcreteType(element) {\n  const {\n    type: elementType\n  } = element;\n  let type = getRawType(elementType);\n\n  // (1) event definition types\n  const eventDefinition = getEventDefinition$2(element);\n  if (eventDefinition) {\n    type = `${getEventDefinitionPrefix(eventDefinition)}${type}`;\n\n    // (1.1) interrupting / non interrupting\n    if ((0,ModelUtil.is)(element, 'bpmn:StartEvent') && !(0,DiUtil/* isInterrupting */.yU)(element) || (0,ModelUtil.is)(element, 'bpmn:BoundaryEvent') && !isCancelActivity(element)) {\n      type = `${type}NonInterrupting`;\n    }\n    return type;\n  }\n\n  // (2) sub process types\n  if ((0,ModelUtil.is)(element, 'bpmn:SubProcess') && !(0,ModelUtil.is)(element, 'bpmn:Transaction')) {\n    if ((0,DiUtil/* isEventSubProcess */.J5)(element)) {\n      type = `Event${type}`;\n    } else {\n      const expanded = (0,DiUtil/* isExpanded */.ul)(element) && !isPlane(element);\n      type = `${expanded ? 'Expanded' : 'Collapsed'}${type}`;\n    }\n  }\n\n  // (3) conditional + default flows\n  if (isDefaultFlow(element)) {\n    type = 'DefaultFlow';\n  }\n  if (isConditionalFlow(element)) {\n    type = 'ConditionalFlow';\n  }\n  return type;\n}\nconst PanelHeaderProvider = {\n  getDocumentationRef: element => {\n    const elementTemplates = getTemplatesService();\n    if (elementTemplates) {\n      return getTemplateDocumentation(element, elementTemplates);\n    }\n  },\n  getElementLabel: element => {\n    if ((0,ModelUtil.is)(element, 'bpmn:Process')) {\n      return (0,ModelUtil/* getBusinessObject */.SS)(element).name;\n    }\n    return (0,LabelUtil/* getLabel */.i)(element);\n  },\n  getElementIcon: element => {\n    const concreteType = getConcreteType(element);\n    const elementTemplates = getTemplatesService();\n    if (elementTemplates) {\n      const template = getTemplate(element, elementTemplates);\n      if (template && template.icon) {\n        return () => (0,jsxRuntime_module/* jsx */.tZ)(\"img\", {\n          class: \"bio-properties-panel-header-template-icon\",\n          width: \"32\",\n          height: \"32\",\n          src: template.icon.contents\n        });\n      }\n    }\n    return iconsByType[concreteType];\n  },\n  getTypeLabel: element => {\n    const elementTemplates = getTemplatesService();\n    if (elementTemplates) {\n      const template = getTemplate(element, elementTemplates);\n      if (template && template.name) {\n        return template.name;\n      }\n    }\n    const concreteType = getConcreteType(element);\n    return concreteType.replace(/(\\B[A-Z])/g, ' $1').replace(/(\\bNon Interrupting)/g, '($1)');\n  }\n};\n\n// helpers ///////////////////////\n\nfunction isCancelActivity(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return businessObject && businessObject.cancelActivity !== false;\n}\nfunction getEventDefinition$2(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n    eventDefinitions = businessObject.eventDefinitions;\n  return eventDefinitions && eventDefinitions[0];\n}\nfunction getRawType(type) {\n  return type.split(':')[1];\n}\nfunction getEventDefinitionPrefix(eventDefinition) {\n  const rawType = getRawType(eventDefinition.$type);\n  return rawType.replace('EventDefinition', '');\n}\nfunction isDefaultFlow(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const sourceBusinessObject = (0,ModelUtil/* getBusinessObject */.SS)(element.source);\n  if (!(0,ModelUtil.is)(element, 'bpmn:SequenceFlow') || !sourceBusinessObject) {\n    return false;\n  }\n  return sourceBusinessObject.default && sourceBusinessObject.default === businessObject && ((0,ModelUtil.is)(sourceBusinessObject, 'bpmn:Gateway') || (0,ModelUtil.is)(sourceBusinessObject, 'bpmn:Activity'));\n}\nfunction isConditionalFlow(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const sourceBusinessObject = (0,ModelUtil/* getBusinessObject */.SS)(element.source);\n  if (!(0,ModelUtil.is)(element, 'bpmn:SequenceFlow') || !sourceBusinessObject) {\n    return false;\n  }\n  return businessObject.conditionExpression && (0,ModelUtil.is)(sourceBusinessObject, 'bpmn:Activity');\n}\nfunction isPlane(element) {\n  // Backwards compatibility for bpmn-js<8\n  const di = element && (element.di || (0,ModelUtil/* getBusinessObject */.SS)(element).di);\n  return (0,ModelUtil.is)(di, 'bpmndi:BPMNPlane');\n}\nfunction getTemplatesService() {\n  // eslint-disable-next-line react-hooks/rules-of-hooks\n  return useService('elementTemplates', false);\n}\nfunction getTemplate(element, elementTemplates) {\n  return elementTemplates.get(element);\n}\nfunction getTemplateDocumentation(element, elementTemplates) {\n  const template = getTemplate(element, elementTemplates);\n  return template && template.documentationRef;\n}\n\nfunction _extends$1() { _extends$1 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1.apply(this, arguments); }\nvar EmptyIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends$1({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  xmlnsXlink: \"http://www.w3.org/1999/xlink\",\n  width: \"64\",\n  height: \"64\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"defs\", null, /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"rect\", {\n  id: \"a\",\n  width: \"57\",\n  height: \"47\",\n  x: \"3\",\n  y: \"8\",\n  rx: \"7\"\n}), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"mask\", {\n  id: \"b\",\n  width: \"57\",\n  height: \"47\",\n  x: \"0\",\n  y: \"0\",\n  fill: \"#fff\",\n  maskContentUnits: \"userSpaceOnUse\",\n  maskUnits: \"objectBoundingBox\"\n}, /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"use\", {\n  xlinkHref: \"#a\"\n}))), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"g\", {\n  fill: \"none\",\n  fillRule: \"evenodd\"\n}, /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  fill: \"#818798\",\n  d: \"M52 11a5 5 0 015 5v31a5 5 0 01-5 5H11a5 5 0 01-5-5V16a5 5 0 015-5h41zm0 2H11a3 3 0 00-2.995 2.824L8 16v31a3 3 0 002.824 2.995L11 50h41a3 3 0 002.995-2.824L55 47V16a3 3 0 00-2.824-2.995L52 13z\"\n}), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  fill: \"#D5D7DD\",\n  d: \"M16 24h31v6H16zM21 33h21v6H21z\"\n}), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"use\", {\n  stroke: \"#B9BCC6\",\n  strokeDasharray: \"5 2\",\n  strokeWidth: \"2\",\n  mask: \"url(#b)\",\n  xlinkHref: \"#a\"\n}))));\n\nfunction _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\nvar MultipleIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"svg\", _extends({\n  xmlns: \"http://www.w3.org/2000/svg\",\n  xmlnsXlink: \"http://www.w3.org/1999/xlink\",\n  width: \"128\",\n  height: \"64\"\n}, props), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"defs\", null, /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  id: \"a\",\n  d: \"M9 9h110v47H9z\"\n}), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"mask\", {\n  id: \"b\",\n  width: \"110\",\n  height: \"47\",\n  x: \"0\",\n  y: \"0\",\n  fill: \"#fff\",\n  maskContentUnits: \"userSpaceOnUse\",\n  maskUnits: \"objectBoundingBox\"\n}, /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"use\", {\n  xlinkHref: \"#a\"\n}))), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"g\", {\n  fill: \"none\",\n  fillRule: \"evenodd\"\n}, /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  fill: \"#818798\",\n  d: \"M25 20.272L37.728 33 25 45.728 12.272 33 25 20.272zm0 2.829L15.1 33l9.9 9.9 9.9-9.9-9.9-9.9z\"\n}), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  fill: \"#D5D7DD\",\n  d: \"M17 47h16v6H17z\"\n}), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  fill: \"#818798\",\n  d: \"M35 32h27v2H35z\"\n}), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  fill: \"#818798\",\n  d: \"M60 30v6l6-3z\"\n}), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  fill: \"#D5D7DD\",\n  d: \"M80 34h21v6H80z\"\n}), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"g\", null, /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  fill: \"#818798\",\n  d: \"M111 12a5 5 0 015 5v31a5 5 0 01-5 5H70a5 5 0 01-5-5V17a5 5 0 015-5h41zm0 2H70a3 3 0 00-3 3v31a3 3 0 003 3h41a3 3 0 003-3V17a3 3 0 00-3-3z\"\n}), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"path\", {\n  fill: \"#D5D7DD\",\n  d: \"M75 25h31v6H75z\"\n})), /*#__PURE__*/compat_module/* default.createElement */.ZP.createElement(\"use\", {\n  stroke: \"#B9BCC6\",\n  strokeDasharray: \"5 2\",\n  strokeWidth: \"2\",\n  mask: \"url(#b)\",\n  xlinkHref: \"#a\"\n}))));\n\nconst PanelPlaceholderProvider = translate => {\n  if (!translate) translate = text => text;\n  return {\n    getEmpty: () => {\n      return {\n        text: translate('Select an element to edit its properties.'),\n        icon: EmptyIcon\n      };\n    },\n    getMultiple: () => {\n      return {\n        text: translate('Multiple elements are selected. Select a single element to edit its properties.'),\n        icon: MultipleIcon\n      };\n    }\n  };\n};\n\nfunction BpmnPropertiesPanel(props) {\n  const {\n    element,\n    injector,\n    getProviders,\n    layoutConfig,\n    descriptionConfig\n  } = props;\n  const canvas = injector.get('canvas');\n  const elementRegistry = injector.get('elementRegistry');\n  const eventBus = injector.get('eventBus');\n  const translate = injector.get('translate');\n  const [state, setState] = (0,hooks_module/* useState */.eJ)({\n    selectedElement: element\n  });\n  const selectedElement = state.selectedElement;\n\n  /**\n   * @param {djs.model.Base | Array<djs.model.Base>} element\n   */\n  const _update = element => {\n    if (!element) {\n      return;\n    }\n    let newSelectedElement = element;\n\n    // handle labels\n    if (newSelectedElement && newSelectedElement.type === 'label') {\n      newSelectedElement = newSelectedElement.labelTarget;\n    }\n    setState({\n      ...state,\n      selectedElement: newSelectedElement\n    });\n\n    // notify interested parties on property panel updates\n    eventBus.fire('propertiesPanel.updated', {\n      element: newSelectedElement\n    });\n  };\n\n  // (2) react on element changes\n\n  // (2a) selection changed\n  (0,hooks_module/* useEffect */.d4)(() => {\n    const onSelectionChanged = e => {\n      const {\n        newSelection = []\n      } = e;\n      if (newSelection.length > 1) {\n        return _update(newSelection);\n      }\n      const newElement = newSelection[0];\n      const rootElement = canvas.getRootElement();\n      if (isImplicitRoot$1(rootElement)) {\n        return;\n      }\n      _update(newElement || rootElement);\n    };\n    eventBus.on('selection.changed', onSelectionChanged);\n    return () => {\n      eventBus.off('selection.changed', onSelectionChanged);\n    };\n  }, []);\n\n  // (2b) selected element changed\n  (0,hooks_module/* useEffect */.d4)(() => {\n    const onElementsChanged = e => {\n      const elements = e.elements;\n      const updatedElement = findElement(elements, selectedElement);\n      if (updatedElement && elementExists(updatedElement, elementRegistry)) {\n        _update(updatedElement);\n      }\n    };\n    eventBus.on('elements.changed', onElementsChanged);\n    return () => {\n      eventBus.off('elements.changed', onElementsChanged);\n    };\n  }, [selectedElement]);\n\n  // (2c) root element changed\n  (0,hooks_module/* useEffect */.d4)(() => {\n    const onRootAdded = e => {\n      const element = e.element;\n      _update(element);\n    };\n    eventBus.on('root.added', onRootAdded);\n    return () => {\n      eventBus.off('root.added', onRootAdded);\n    };\n  }, [selectedElement]);\n\n  // (2d) provided entries changed\n  (0,hooks_module/* useEffect */.d4)(() => {\n    const onProvidersChanged = () => {\n      _update(selectedElement);\n    };\n    eventBus.on('propertiesPanel.providersChanged', onProvidersChanged);\n    return () => {\n      eventBus.off('propertiesPanel.providersChanged', onProvidersChanged);\n    };\n  }, [selectedElement]);\n\n  // (2e) element templates changed\n  (0,hooks_module/* useEffect */.d4)(() => {\n    const onTemplatesChanged = () => {\n      _update(selectedElement);\n    };\n    eventBus.on('elementTemplates.changed', onTemplatesChanged);\n    return () => {\n      eventBus.off('elementTemplates.changed', onTemplatesChanged);\n    };\n  }, [selectedElement]);\n\n  // (3) create properties panel context\n  const bpmnPropertiesPanelContext = {\n    selectedElement,\n    injector,\n    getService(type, strict) {\n      return injector.get(type, strict);\n    }\n  };\n\n  // (4) retrieve groups for selected element\n  const providers = getProviders(selectedElement);\n  const groups = (0,hooks_module/* useMemo */.Ye)(() => {\n    return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* reduce */.u4)(providers, function (groups, provider) {\n      // do not collect groups for multi element state\n      if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isArray */.kJ)(selectedElement)) {\n        return [];\n      }\n      const updater = provider.getGroups(selectedElement);\n      return updater(groups);\n    }, []);\n  }, [providers, selectedElement]);\n\n  // (5) notify layout changes\n  const onLayoutChanged = layout => {\n    eventBus.fire('propertiesPanel.layoutChanged', {\n      layout\n    });\n  };\n\n  // (6) notify description changes\n  const onDescriptionLoaded = description => {\n    eventBus.fire('propertiesPanel.descriptionLoaded', {\n      description\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(BpmnPropertiesPanelContext.Provider, {\n    value: bpmnPropertiesPanelContext,\n    children: (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* PropertiesPanel */.gr, {\n      element: selectedElement,\n      headerProvider: PanelHeaderProvider,\n      placeholderProvider: PanelPlaceholderProvider(translate),\n      groups: groups,\n      layoutConfig: layoutConfig,\n      layoutChanged: onLayoutChanged,\n      descriptionConfig: descriptionConfig,\n      descriptionLoaded: onDescriptionLoaded,\n      eventBus: eventBus\n    })\n  });\n}\n\n// helpers //////////////////////////\n\nfunction isImplicitRoot$1(element) {\n  // Backwards compatibility for diagram-js<7.4.0, see https://github.com/bpmn-io/bpmn-properties-panel/pull/102\n  return element && (element.isImplicit || element.id === '__implicitroot');\n}\nfunction findElement(elements, element) {\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* find */.sE)(elements, e => e === element);\n}\nfunction elementExists(element, elementRegistry) {\n  return element && elementRegistry.get(element.id);\n}\n\nconst DEFAULT_PRIORITY = 1000;\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').GroupDefinition } GroupDefinition\n * @typedef { import('@bpmn-io/properties-panel').ListGroupDefinition } ListGroupDefinition\n * @typedef { { getGroups: (ModdleElement) => (Array{GroupDefinition|ListGroupDefinition}) => Array{GroupDefinition|ListGroupDefinition}) } PropertiesProvider\n */\n\nclass BpmnPropertiesPanelRenderer {\n  constructor(config, injector, eventBus) {\n    const {\n      parent,\n      layout: layoutConfig,\n      description: descriptionConfig\n    } = config || {};\n    this._eventBus = eventBus;\n    this._injector = injector;\n    this._layoutConfig = layoutConfig;\n    this._descriptionConfig = descriptionConfig;\n    this._container = (0,bpmn_js_properties_panel_node_modules_min_dom_dist_index_esm/* domify */.H6)('<div style=\"height: 100%\" class=\"bio-properties-panel-container\"></div>');\n    var commandStack = injector.get('commandStack', false);\n    commandStack && setupKeyboard(this._container, eventBus, commandStack);\n    eventBus.on('diagram.init', () => {\n      if (parent) {\n        this.attachTo(parent);\n      }\n    });\n    eventBus.on('diagram.destroy', () => {\n      this.detach();\n    });\n    eventBus.on('root.added', event => {\n      const {\n        element\n      } = event;\n      this._render(element);\n    });\n  }\n\n  /**\n   * Attach the properties panel to a parent node.\n   *\n   * @param {HTMLElement} container\n   */\n  attachTo(container) {\n    if (!container) {\n      throw new Error('container required');\n    }\n\n    // unwrap jQuery if provided\n    if (container.get && container.constructor.prototype.jquery) {\n      container = container.get(0);\n    }\n    if (typeof container === 'string') {\n      container = (0,bpmn_js_properties_panel_node_modules_min_dom_dist_index_esm/* query */.IO)(container);\n    }\n\n    // (1) detach from old parent\n    this.detach();\n\n    // (2) append to parent container\n    container.appendChild(this._container);\n\n    // (3) notify interested parties\n    this._eventBus.fire('propertiesPanel.attach');\n  }\n\n  /**\n   * Detach the properties panel from its parent node.\n   */\n  detach() {\n    const parentNode = this._container.parentNode;\n    if (parentNode) {\n      parentNode.removeChild(this._container);\n      this._eventBus.fire('propertiesPanel.detach');\n    }\n  }\n\n  /**\n   * Register a new properties provider to the properties panel.\n   *\n   * @param {Number} [priority]\n   * @param {PropertiesProvider} provider\n   */\n  registerProvider(priority, provider) {\n    if (!provider) {\n      provider = priority;\n      priority = DEFAULT_PRIORITY;\n    }\n    if (typeof provider.getGroups !== 'function') {\n      console.error('Properties provider does not implement #getGroups(element) API');\n      return;\n    }\n    this._eventBus.on('propertiesPanel.getProviders', priority, function (event) {\n      event.providers.push(provider);\n    });\n    this._eventBus.fire('propertiesPanel.providersChanged');\n  }\n  _getProviders() {\n    const event = this._eventBus.createEvent({\n      type: 'propertiesPanel.getProviders',\n      providers: []\n    });\n    this._eventBus.fire(event);\n    return event.providers;\n  }\n  _render(element) {\n    const canvas = this._injector.get('canvas');\n    if (!element) {\n      element = canvas.getRootElement();\n    }\n    if (isImplicitRoot(element)) {\n      return;\n    }\n    (0,preact_module/* render */.sY)((0,jsxRuntime_module/* jsx */.tZ)(BpmnPropertiesPanel, {\n      element: element,\n      injector: this._injector,\n      getProviders: this._getProviders.bind(this),\n      layoutConfig: this._layoutConfig,\n      descriptionConfig: this._descriptionConfig\n    }), this._container);\n    this._eventBus.fire('propertiesPanel.rendered');\n  }\n  _destroy() {\n    if (this._container) {\n      (0,preact_module/* render */.sY)(null, this._container);\n      this._eventBus.fire('propertiesPanel.destroyed');\n    }\n  }\n}\nBpmnPropertiesPanelRenderer.$inject = ['config.propertiesPanel', 'injector', 'eventBus'];\n\n// helpers ///////////////////////\n\nfunction isImplicitRoot(element) {\n  // Backwards compatibility for diagram-js<7.4.0, see https://github.com/bpmn-io/bpmn-properties-panel/pull/102\n  return element && (element.isImplicit || element.id === '__implicitroot');\n}\n\n/**\n * Setup keyboard bindings (undo, redo) on the given container.\n *\n * @param {Element} container\n * @param {EventBus} eventBus\n * @param {CommandStack} commandStack\n */\nfunction setupKeyboard(container, eventBus, commandStack) {\n  function cancel(event) {\n    event.preventDefault();\n    event.stopPropagation();\n  }\n  function handleKeys(event) {\n    if ((0,KeyboardUtil/* isUndo */.YW)(event)) {\n      commandStack.undo();\n      return cancel(event);\n    }\n    if ((0,KeyboardUtil/* isRedo */.LO)(event)) {\n      commandStack.redo();\n      return cancel(event);\n    }\n  }\n  eventBus.on('keyboard.bind', function () {\n    bpmn_js_properties_panel_node_modules_min_dom_dist_index_esm/* event.bind */.B.bind(container, 'keydown', handleKeys);\n  });\n  eventBus.on('keyboard.unbind', function () {\n    bpmn_js_properties_panel_node_modules_min_dom_dist_index_esm/* event.unbind */.B.unbind(container, 'keydown', handleKeys);\n  });\n}\n\n/**\n * A handler that combines and executes multiple commands.\n *\n * All updates are bundled on the command stack and executed in one step.\n * This also makes it possible to revert the changes in one step.\n *\n * Example use case: remove the camunda:formKey attribute and in addition\n * add all form fields needed for the camunda:formData property.\n */\nclass MultiCommandHandler {\n  constructor(commandStack) {\n    this._commandStack = commandStack;\n  }\n  preExecute(context) {\n    const commandStack = this._commandStack;\n    (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* forEach */.Ed)(context, function (command) {\n      commandStack.execute(command.cmd, command.context);\n    });\n  }\n}\nMultiCommandHandler.$inject = ['commandStack'];\n\nconst HANDLERS = {\n  'properties-panel.multi-command-executor': MultiCommandHandler\n};\nfunction CommandInitializer(eventBus, commandStack) {\n  eventBus.on('diagram.init', function () {\n    (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* forEach */.Ed)(HANDLERS, function (handler, id) {\n      commandStack.registerHandler(id, handler);\n    });\n  });\n}\nCommandInitializer.$inject = ['eventBus', 'commandStack'];\nvar Commands = {\n  __init__: [CommandInitializer]\n};\n\nvar index$3 = {\n  __depends__: [Commands, properties_panel_dist_index_esm/* DebounceInputModule */.kK],\n  __init__: ['propertiesPanel'],\n  propertiesPanel: ['type', BpmnPropertiesPanelRenderer]\n};\n\nfunction ReferenceSelectEntry(props) {\n  const {\n    autoFocusEntry,\n    element,\n    getOptions\n  } = props;\n  const options = getOptions(element);\n  const prevOptions = (0,properties_panel_dist_index_esm/* usePrevious */.D9)(options);\n\n  // auto focus specifc other entry when options changed\n  (0,hooks_module/* useEffect */.d4)(() => {\n    if (autoFocusEntry && prevOptions && options.length > prevOptions.length) {\n      const entry = (0,bpmn_js_properties_panel_node_modules_min_dom_dist_index_esm/* query */.IO)(`[data-entry-id=\"${autoFocusEntry}\"]`);\n      const focusableInput = (0,bpmn_js_properties_panel_node_modules_min_dom_dist_index_esm/* query */.IO)('.bio-properties-panel-input', entry);\n      if (focusableInput) {\n        focusableInput.select();\n      }\n    }\n  }, [options]);\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* SelectEntry */.g0, {\n    ...props\n  });\n}\n\nfunction isErrorSupported(element) {\n  return (0,ModelUtil/* isAny */.JZ)(element, ['bpmn:StartEvent', 'bpmn:BoundaryEvent', 'bpmn:EndEvent']) && !!getErrorEventDefinition(element);\n}\nfunction getErrorEventDefinition(element) {\n  return getEventDefinition$1(element, 'bpmn:ErrorEventDefinition');\n}\nfunction getTimerEventDefinition$1(element) {\n  return getEventDefinition$1(element, 'bpmn:TimerEventDefinition');\n}\nfunction getError(element) {\n  const errorEventDefinition = getErrorEventDefinition(element);\n  return errorEventDefinition && errorEventDefinition.get('errorRef');\n}\nfunction getEventDefinition$1(element, eventType) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const eventDefinitions = businessObject.get('eventDefinitions') || [];\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* find */.sE)(eventDefinitions, function (definition) {\n    return (0,ModelUtil.is)(definition, eventType);\n  });\n}\nfunction isMessageSupported(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:ReceiveTask') || (0,ModelUtil/* isAny */.JZ)(element, ['bpmn:StartEvent', 'bpmn:EndEvent', 'bpmn:IntermediateThrowEvent', 'bpmn:BoundaryEvent', 'bpmn:IntermediateCatchEvent']) && !!getMessageEventDefinition(element);\n}\nfunction getMessageEventDefinition(element) {\n  if ((0,ModelUtil.is)(element, 'bpmn:ReceiveTask')) {\n    return (0,ModelUtil/* getBusinessObject */.SS)(element);\n  }\n  return getEventDefinition$1(element, 'bpmn:MessageEventDefinition');\n}\nfunction getMessage(element) {\n  const messageEventDefinition = getMessageEventDefinition(element);\n  return messageEventDefinition && messageEventDefinition.get('messageRef');\n}\nfunction getLinkEventDefinition(element) {\n  return getEventDefinition$1(element, 'bpmn:LinkEventDefinition');\n}\nfunction getSignalEventDefinition(element) {\n  return getEventDefinition$1(element, 'bpmn:SignalEventDefinition');\n}\nfunction isLinkSupported(element) {\n  return (0,ModelUtil/* isAny */.JZ)(element, ['bpmn:IntermediateThrowEvent', 'bpmn:IntermediateCatchEvent']) && !!getLinkEventDefinition(element);\n}\nfunction isSignalSupported(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Event') && !!getSignalEventDefinition(element);\n}\nfunction getSignal(element) {\n  const signalEventDefinition = getSignalEventDefinition(element);\n  return signalEventDefinition && signalEventDefinition.get('signalRef');\n}\nfunction getEscalationEventDefinition(element) {\n  return getEventDefinition$1(element, 'bpmn:EscalationEventDefinition');\n}\nfunction isEscalationSupported(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Event') && !!getEscalationEventDefinition(element);\n}\nfunction getEscalation(element) {\n  const escalationEventDefinition = getEscalationEventDefinition(element);\n  return escalationEventDefinition && escalationEventDefinition.get('escalationRef');\n}\nfunction isCompensationSupported(element) {\n  return (0,ModelUtil/* isAny */.JZ)(element, ['bpmn:EndEvent', 'bpmn:IntermediateThrowEvent']) && !!getCompensateEventDefinition(element);\n}\nfunction getCompensateEventDefinition(element) {\n  return getEventDefinition$1(element, 'bpmn:CompensateEventDefinition');\n}\nfunction getCompensateActivity(element) {\n  const compensateEventDefinition = getCompensateEventDefinition(element);\n  return compensateEventDefinition && compensateEventDefinition.get('activityRef');\n}\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction CompensationProps(props) {\n  const {\n    element\n  } = props;\n  if (!isCompensationSupported(element)) {\n    return [];\n  }\n  return [{\n    id: 'waitForCompletion',\n    component: WaitForCompletion,\n    isEdited: properties_panel_dist_index_esm/* isCheckboxEntryEdited */.kv\n  }, {\n    id: 'activityRef',\n    component: ActivityRef,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  }];\n}\nfunction WaitForCompletion(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const compensateEventDefinition = getCompensateEventDefinition(element);\n  const getValue = () => {\n    return compensateEventDefinition.get('waitForCompletion');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: compensateEventDefinition,\n      properties: {\n        waitForCompletion: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* CheckboxEntry */.IN)({\n    element,\n    id: 'waitForCompletion',\n    label: translate('Wait for completion'),\n    getValue,\n    setValue\n  });\n}\nfunction ActivityRef(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const elementRegistry = useService('elementRegistry');\n  const translate = useService('translate');\n  const compensateEventDefinition = getCompensateEventDefinition(element);\n  const getValue = () => {\n    const activityRef = getCompensateActivity(element);\n    return activityRef && activityRef.get('id');\n  };\n  const setValue = value => {\n    // update (or remove) activityRef\n    const activityRef = value ? (0,ModelUtil/* getBusinessObject */.SS)(elementRegistry.get(value)) : undefined;\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: compensateEventDefinition,\n      properties: {\n        activityRef\n      }\n    });\n  };\n  const getOptions = () => {\n    let options = [{\n      value: '',\n      label: translate('<none>')\n    }];\n    const activities = findActivityRefs(element);\n    sortByName$6(activities).forEach(function (activity) {\n      options.push({\n        value: activity.id,\n        label: createOptionLabel(activity)\n      });\n    });\n    return options;\n  };\n  return ReferenceSelectEntry({\n    element,\n    id: 'activityRef',\n    label: translate('Activity reference'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\n\n// helper /////////////////////////\n\nfunction getFlowElements(element, type) {\n  const {\n    flowElements\n  } = element;\n  return flowElements.filter(function (flowElement) {\n    return (0,ModelUtil.is)(flowElement, type);\n  });\n}\nfunction getContainedActivities(element) {\n  return getFlowElements(element, 'bpmn:Activity');\n}\nfunction getContainedBoundaryEvents(element) {\n  return getFlowElements(element, 'bpmn:BoundaryEvent');\n}\n\n/**\n * Checks whether an Activity is attaching a CompensateEvent of the parent container.\n *\n * @param {ModdleElement} activity\n * @param {Array<ModdleElement>} boundaryEvents\n * @returns {Boolean}\n */\nfunction hasCompensationEventAttached(activity, boundaryEvents) {\n  const {\n    id: activityId\n  } = activity;\n  return !!(0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* find */.sE)(boundaryEvents, function (boundaryEvent) {\n    const {\n      attachedToRef\n    } = boundaryEvent;\n    const compensateEventDefinition = getCompensateEventDefinition(boundaryEvent);\n    return attachedToRef && compensateEventDefinition && attachedToRef.id === activityId;\n  });\n}\n\n/**\n * Checks whether an Activity can be compensated. That's the case when it is\n * a) a CallActivity\n * b) a SubProcess, when it is not event based and not a compensation\n * c) any other Activity, when it is attaching a CompensateEvent of the parent container\n *\n * @param {ModdleElement} activity\n * @param {Array<ModdleElement>} boundaryEvents\n * @returns {Boolean}\n */\nfunction canBeCompensated(activity, boundaryEvents) {\n  return (0,ModelUtil.is)(activity, 'bpmn:CallActivity') || (0,ModelUtil.is)(activity, 'bpmn:SubProcess') && !activity.triggeredByEvent && !activity.isForCompensation || hasCompensationEventAttached(activity, boundaryEvents);\n}\nfunction getActivitiesForCompensation(element) {\n  const activities = getContainedActivities(element);\n  const boundaryEvents = getContainedBoundaryEvents(element);\n  return activities.filter(function (activity) {\n    return canBeCompensated(activity, boundaryEvents);\n  });\n}\n\n/**\n * Retrieves all possible activities to reference for a Compensation.\n *\n * @param {djs.model.Base} element\n * @returns {Array<ModdleElement>}\n */\nfunction findActivityRefs(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  let parent = businessObject.$parent;\n\n  // (1) get all activities in parent container\n  let activities = getActivitiesForCompensation(parent);\n\n  // (2) if throwing compensation event is inside an EventSubProcess,\n  // also get all activities outside of the event sub process\n  if ((0,ModelUtil.is)(parent, 'bpmn:SubProcess') && parent.triggeredByEvent) {\n    parent = parent.$parent;\n    if (parent) {\n      activities = [...activities, ...getActivitiesForCompensation(parent)];\n    }\n  }\n  return activities;\n}\n\n/**\n * Retrieves an option label in the form\n * a) with name: \"my Task (id=Task_1)\"\n * b) without name: \"(id=Task_1)\"\n *\n * @param {ModdleElement} activity\n * @returns {String}\n */\nfunction createOptionLabel(activity) {\n  const {\n    id,\n    name\n  } = activity;\n  return `${name ? name + ' ' : ''}(id=${id})`;\n}\nfunction sortByName$6(elements) {\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* sortBy */.MR)(elements, e => (e.name || '').toLowerCase());\n}\n\nconst DOCUMENTATION_TEXT_FORMAT = 'text/plain';\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction DocumentationProps(props) {\n  const {\n    element\n  } = props;\n  const entries = [{\n    id: 'documentation',\n    component: ElementDocumentationProperty,\n    isEdited: properties_panel_dist_index_esm/* isTextAreaEntryEdited */.mn\n  }];\n  if (hasProcessRef$2(element)) {\n    entries.push({\n      id: 'processDocumentation',\n      component: ProcessDocumentationProperty,\n      isEdited: properties_panel_dist_index_esm/* isTextAreaEntryEdited */.mn\n    });\n  }\n  return entries;\n}\nfunction ElementDocumentationProperty(props) {\n  const {\n    element\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = getDocumentation((0,ModelUtil/* getBusinessObject */.SS)(element));\n  const setValue = setDocumentation(element, (0,ModelUtil/* getBusinessObject */.SS)(element), bpmnFactory, commandStack);\n  return (0,properties_panel_dist_index_esm/* TextAreaEntry */.i)({\n    element,\n    id: 'documentation',\n    label: translate('Element documentation'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ProcessDocumentationProperty(props) {\n  const {\n    element\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const processRef = (0,ModelUtil/* getBusinessObject */.SS)(element).processRef;\n  const getValue = getDocumentation(processRef);\n  const setValue = setDocumentation(element, processRef, bpmnFactory, commandStack);\n  return (0,properties_panel_dist_index_esm/* TextAreaEntry */.i)({\n    element,\n    id: 'processDocumentation',\n    label: translate('Process documentation'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper ////////////////////////////\n\nfunction hasProcessRef$2(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Participant') && element.businessObject.get('processRef');\n}\nfunction findDocumentation(docs) {\n  return docs.find(function (d) {\n    return (d.textFormat || DOCUMENTATION_TEXT_FORMAT) === DOCUMENTATION_TEXT_FORMAT;\n  });\n}\n\n/**\n * Retrieves a documentation element from a given moddle element.\n *\n * @param {ModdleElement} businessObject\n *\n * @returns {ModdleElement} documentation element inside the given moddle element.\n */\nfunction getDocumentation(businessObject) {\n  return function () {\n    const documentation = findDocumentation(businessObject && businessObject.get('documentation'));\n    return documentation && documentation.text;\n  };\n}\n\n/**\n * Sets a documentation element for a given moddle element.\n *\n * @param {ModdleElement} businessObject\n */\nfunction setDocumentation(element, businessObject, bpmnFactory, commandStack) {\n  return function (value) {\n    let documentation = findDocumentation(businessObject && businessObject.get('documentation'));\n\n    // (1) update or removing existing documentation\n    if (documentation) {\n      if (value) {\n        return commandStack.execute('element.updateModdleProperties', {\n          element,\n          moddleElement: documentation,\n          properties: {\n            text: value\n          }\n        });\n      } else {\n        return commandStack.execute('element.updateModdleProperties', {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            documentation: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(businessObject.get('documentation'), documentation)\n          }\n        });\n      }\n    }\n\n    // (2) create new documentation entry\n    if (value) {\n      documentation = bpmnFactory.create('bpmn:Documentation', {\n        text: value\n      });\n      return commandStack.execute('element.updateModdleProperties', {\n        element,\n        moddleElement: businessObject,\n        properties: {\n          documentation: [...businessObject.get('documentation'), documentation]\n        }\n      });\n    }\n  };\n}\n\n/**\n * Create a new element and set its parent.\n *\n * @param {String} elementType of the new element\n * @param {Object} properties of the new element in key-value pairs\n * @param {moddle.object} parent of the new element\n * @param {BpmnFactory} factory which creates the new element\n *\n * @returns {djs.model.Base} element which is created\n */\nfunction createElement(elementType, properties, parent, factory) {\n  const element = factory.create(elementType, properties);\n  if (parent) {\n    element.$parent = parent;\n  }\n  return element;\n}\n\n/**\n * generate a semantic id with given prefix\n */\nfunction nextId(prefix) {\n  const ids = new ids_dist_index_esm/* default */.Z([32, 32, 1]);\n  return ids.nextPrefixed(prefix);\n}\nfunction getRoot(businessObject) {\n  let parent = businessObject;\n  while (parent.$parent) {\n    parent = parent.$parent;\n  }\n  return parent;\n}\nfunction filterElementsByType(objectList, type) {\n  const list = objectList || [];\n  return list.filter(element => (0,ModelUtil.is)(element, type));\n}\nfunction findRootElementsByType(businessObject, referencedType) {\n  const root = getRoot(businessObject);\n  return filterElementsByType(root.get('rootElements'), referencedType);\n}\nfunction findRootElementById(businessObject, type, id) {\n  const elements = findRootElementsByType(businessObject, type);\n  return elements.find(element => element.id === id);\n}\n\nconst EMPTY_OPTION$4 = '';\nconst CREATE_NEW_OPTION$4 = 'create-new';\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction ErrorProps$1(props) {\n  const {\n    element\n  } = props;\n  if (!isErrorSupported(element)) {\n    return [];\n  }\n  const error = getError(element);\n  let entries = [{\n    id: 'errorRef',\n    component: ErrorRef$1,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  }];\n  if (error) {\n    entries = [...entries, {\n      id: 'errorName',\n      component: ErrorName$1,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    }, {\n      id: 'errorCode',\n      component: ErrorCode$1,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    }];\n  }\n  return entries;\n}\nfunction ErrorRef$1(props) {\n  const {\n    element\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const errorEventDefinition = getErrorEventDefinition(element);\n  const getValue = () => {\n    const error = getError(element);\n    if (error) {\n      return error.get('id');\n    }\n    return EMPTY_OPTION$4;\n  };\n  const setValue = value => {\n    const root = getRoot(errorEventDefinition);\n    const commands = [];\n    let error;\n\n    // (1) create new error\n    if (value === CREATE_NEW_OPTION$4) {\n      error = createElement('bpmn:Error', {\n        name: nextId('Error_')\n      }, root, bpmnFactory);\n      value = error.get('id');\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: root,\n          properties: {\n            rootElements: [...root.get('rootElements'), error]\n          }\n        }\n      });\n    }\n\n    // (2) update (or remove) errorRef\n    error = error || findRootElementById(errorEventDefinition, 'bpmn:Error', value);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: errorEventDefinition,\n        properties: {\n          errorRef: error\n        }\n      }\n    });\n\n    // (3) commit all updates\n    return commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  const getOptions = () => {\n    let options = [{\n      value: EMPTY_OPTION$4,\n      label: translate('<none>')\n    }, {\n      value: CREATE_NEW_OPTION$4,\n      label: translate('Create new ...')\n    }];\n    const errors = findRootElementsByType((0,ModelUtil/* getBusinessObject */.SS)(element), 'bpmn:Error');\n    sortByName$5(errors).forEach(error => {\n      options.push({\n        value: error.get('id'),\n        label: error.get('name')\n      });\n    });\n    return options;\n  };\n  return ReferenceSelectEntry({\n    element,\n    id: 'errorRef',\n    label: translate('Global error reference'),\n    autoFocusEntry: 'errorName',\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction ErrorName$1(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const error = getError(element);\n  const getValue = () => {\n    return error.get('name');\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: error,\n      properties: {\n        name: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'errorName',\n    label: translate('Name'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ErrorCode$1(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const error = getError(element);\n  const getValue = () => {\n    return error.get('errorCode');\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: error,\n      properties: {\n        errorCode: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'errorCode',\n    label: translate('Code'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper /////////////////////////\n\nfunction sortByName$5(elements) {\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* sortBy */.MR)(elements, e => (e.name || '').toLowerCase());\n}\n\nconst CREATE_NEW_OPTION$3 = 'create-new';\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction EscalationProps$1(props) {\n  const {\n    element\n  } = props;\n  if (!isEscalationSupported(element)) {\n    return [];\n  }\n  const escalation = getEscalation(element);\n  let entries = [{\n    id: 'escalationRef',\n    component: EscalationRef,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  }];\n  if (escalation) {\n    entries = [...entries, {\n      id: 'escalationName',\n      component: EscalationName,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    }, {\n      id: 'escalationCode',\n      component: EscalationCode,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    }];\n  }\n  return entries;\n}\nfunction EscalationRef(props) {\n  const {\n    element\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const escalationEventDefinition = getEscalationEventDefinition(element);\n  const getValue = () => {\n    const escalation = getEscalation(element);\n    return escalation && escalation.get('id');\n  };\n  const setValue = value => {\n    const root = getRoot(escalationEventDefinition);\n    const commands = [];\n    let escalation;\n\n    // (1) create new escalation\n    if (value === CREATE_NEW_OPTION$3) {\n      const id = nextId('Escalation_');\n      escalation = createElement('bpmn:Escalation', {\n        id,\n        name: id\n      }, root, bpmnFactory);\n      value = escalation.get('id');\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: root,\n          properties: {\n            rootElements: [...root.get('rootElements'), escalation]\n          }\n        }\n      });\n    }\n\n    // (2) update (or remove) escalationRef\n    escalation = escalation || findRootElementById(escalationEventDefinition, 'bpmn:Escalation', value);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: escalationEventDefinition,\n        properties: {\n          escalationRef: escalation\n        }\n      }\n    });\n\n    // (3) commit all updates\n    return commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  const getOptions = () => {\n    let options = [{\n      value: '',\n      label: translate('<none>')\n    }, {\n      value: CREATE_NEW_OPTION$3,\n      label: translate('Create new ...')\n    }];\n    const escalations = findRootElementsByType((0,ModelUtil/* getBusinessObject */.SS)(element), 'bpmn:Escalation');\n    sortByName$4(escalations).forEach(escalation => {\n      options.push({\n        value: escalation.get('id'),\n        label: escalation.get('name')\n      });\n    });\n    return options;\n  };\n  return ReferenceSelectEntry({\n    element,\n    id: 'escalationRef',\n    label: translate('Global escalation reference'),\n    autoFocusEntry: 'escalationName',\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction EscalationName(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const escalation = getEscalation(element);\n  const getValue = () => {\n    return escalation.get('name');\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: escalation,\n      properties: {\n        name: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'escalationName',\n    label: translate('Name'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction EscalationCode(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const escalation = getEscalation(element);\n  const getValue = () => {\n    return escalation.get('escalationCode');\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: escalation,\n      properties: {\n        escalationCode: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'escalationCode',\n    label: translate('Code'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper /////////////////////////\n\nfunction sortByName$4(elements) {\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* sortBy */.MR)(elements, e => (e.name || '').toLowerCase());\n}\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction ExecutableProps(props) {\n  const {\n    element\n  } = props;\n  if (!(0,ModelUtil.is)(element, 'bpmn:Process') && !hasProcessRef$1(element)) {\n    return [];\n  }\n  return [{\n    id: 'isExecutable',\n    component: Executable,\n    isEdited: properties_panel_dist_index_esm/* isCheckboxEntryEdited */.kv\n  }];\n}\nfunction Executable(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  let getValue, setValue;\n  setValue = value => {\n    modeling.updateProperties(element, {\n      isExecutable: value\n    });\n  };\n  getValue = element => {\n    return element.businessObject.isExecutable;\n  };\n\n  // handle properties on processRef level for participants\n  if ((0,ModelUtil.is)(element, 'bpmn:Participant')) {\n    const process = element.businessObject.get('processRef');\n    setValue = value => {\n      commandStack.execute('element.updateModdleProperties', {\n        element,\n        moddleElement: process,\n        properties: {\n          isExecutable: value\n        }\n      });\n    };\n    getValue = () => {\n      return process.get('isExecutable');\n    };\n  }\n  return (0,properties_panel_dist_index_esm/* CheckboxEntry */.IN)({\n    element,\n    id: 'isExecutable',\n    label: translate('Executable'),\n    getValue,\n    setValue\n  });\n}\n\n// helper /////////////////////\n\nfunction hasProcessRef$1(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Participant') && element.businessObject.get('processRef');\n}\n\nconst SPACE_REGEX = /\\s/;\n\n// for QName validation as per http://www.w3.org/TR/REC-xml/#NT-NameChar\nconst QNAME_REGEX = /^([a-z][\\w-.]*:)?[a-z_][\\w-.]*$/i;\n\n// for ID validation as per BPMN Schema (QName - Namespace)\nconst ID_REGEX = /^[a-z_][\\w-.]*$/i;\n\n/**\n * checks whether the id value is valid\n *\n * @param {ModdleElement} element\n * @param {String} idValue\n * @param {Function} translate\n *\n * @return {String} error message\n */\nfunction isIdValid(element, idValue, translate) {\n  const assigned = element.$model.ids.assigned(idValue);\n  const idAlreadyExists = assigned && assigned !== element;\n  if (!idValue) {\n    return translate('ID must not be empty.');\n  }\n  if (idAlreadyExists) {\n    return translate('ID must be unique.');\n  }\n  return validateId(idValue, translate);\n}\nfunction validateId(idValue, translate) {\n  if (containsSpace(idValue)) {\n    return translate('ID must not contain spaces.');\n  }\n  if (!ID_REGEX.test(idValue)) {\n    if (QNAME_REGEX.test(idValue)) {\n      return translate('ID must not contain prefix.');\n    }\n    return translate('ID must be a valid QName.');\n  }\n}\nfunction containsSpace(value) {\n  return SPACE_REGEX.test(value);\n}\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction IdProps() {\n  return [{\n    id: 'id',\n    component: Id$3,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n}\nfunction Id$3(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const debounce = useService('debounceInput');\n  const translate = useService('translate');\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      id: value\n    });\n  };\n  const getValue = element => {\n    return element.businessObject.id;\n  };\n  const validate = value => {\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    return isIdValid(businessObject, value, translate);\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'id',\n    label: translate((0,ModelUtil.is)(element, 'bpmn:Participant') ? 'Participant ID' : 'ID'),\n    getValue,\n    setValue,\n    debounce,\n    validate\n  });\n}\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction LinkProps(props) {\n  const {\n    element\n  } = props;\n  if (!isLinkSupported(element)) {\n    return [];\n  }\n  return [{\n    id: 'linkName',\n    component: LinkName,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n}\nfunction LinkName(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const linkEventDefinition = getLinkEventDefinition(element);\n  const getValue = () => {\n    return linkEventDefinition.get('name');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: linkEventDefinition,\n      properties: {\n        name: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'linkName',\n    label: translate('Name'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\nconst EMPTY_OPTION$3 = '';\nconst CREATE_NEW_OPTION$2 = 'create-new';\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction MessageProps$1(props) {\n  const {\n    element\n  } = props;\n  if (!isMessageSupported(element)) {\n    return [];\n  }\n  const message = getMessage(element);\n  let entries = [{\n    id: 'messageRef',\n    component: MessageRef,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  }];\n  if (message) {\n    entries = [...entries, {\n      id: 'messageName',\n      component: MessageName$1,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    }];\n  }\n  return entries;\n}\nfunction MessageRef(props) {\n  const {\n    element\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const messageEventDefinition = getMessageEventDefinition(element);\n  const getValue = () => {\n    const message = getMessage(element);\n    if (message) {\n      return message.get('id');\n    }\n    return EMPTY_OPTION$3;\n  };\n  const setValue = value => {\n    const root = getRoot(messageEventDefinition);\n    const commands = [];\n    let message;\n\n    // (1) create new message\n    if (value === CREATE_NEW_OPTION$2) {\n      const id = nextId('Message_');\n      message = createElement('bpmn:Message', {\n        id,\n        name: id\n      }, root, bpmnFactory);\n      value = message.get('id');\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: root,\n          properties: {\n            rootElements: [...root.get('rootElements'), message]\n          }\n        }\n      });\n    }\n\n    // (2) update (or remove) messageRef\n    message = message || findRootElementById(messageEventDefinition, 'bpmn:Message', value);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: messageEventDefinition,\n        properties: {\n          messageRef: message\n        }\n      }\n    });\n\n    // (3) commit all updates\n    return commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  const getOptions = () => {\n    let options = [{\n      value: EMPTY_OPTION$3,\n      label: translate('<none>')\n    }, {\n      value: CREATE_NEW_OPTION$2,\n      label: translate('Create new ...')\n    }];\n    const messages = findRootElementsByType((0,ModelUtil/* getBusinessObject */.SS)(element), 'bpmn:Message');\n    sortByName$3(messages).forEach(message => {\n      options.push({\n        value: message.get('id'),\n        label: message.get('name')\n      });\n    });\n    return options;\n  };\n  return ReferenceSelectEntry({\n    element,\n    id: 'messageRef',\n    label: translate('Global message reference'),\n    autoFocusEntry: 'messageName',\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction MessageName$1(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const message = getMessage(element);\n  const getValue = () => {\n    return message.get('name');\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: message,\n      properties: {\n        name: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'messageName',\n    label: translate('Name'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper /////////////////////////\n\nfunction sortByName$3(elements) {\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* sortBy */.MR)(elements, e => (e.name || '').toLowerCase());\n}\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction MultiInstanceProps$2(props) {\n  const {\n    element\n  } = props;\n  if (!isMultiInstanceSupported$1(element)) {\n    return [];\n  }\n  const entries = [{\n    id: 'loopCardinality',\n    component: LoopCardinality,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'completionCondition',\n    component: CompletionCondition$1,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n  return entries;\n}\nfunction LoopCardinality(props) {\n  const {\n    element\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const debounce = useService('debounceInput');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const getValue = () => {\n    return getLoopCardinalityValue(element);\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', updateFormalExpression(element, 'loopCardinality', value, bpmnFactory));\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'loopCardinality',\n    label: translate('Loop cardinality'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction CompletionCondition$1(props) {\n  const {\n    element\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const debounce = useService('debounceInput');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const getValue = () => {\n    return getCompletionConditionValue(element);\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', updateFormalExpression(element, 'completionCondition', value, bpmnFactory));\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'completionCondition',\n    label: translate('Completion condition'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper ////////////////////////////\n\n// generic ///////////////////////////\n\n/**\n * isMultiInstanceSupported - check whether given element supports MultiInstanceLoopCharacteristics.\n *\n * @param {djs.model.Base} element\n * @return {boolean}\n */\nfunction isMultiInstanceSupported$1(element) {\n  const loopCharacteristics = getLoopCharacteristics$2(element);\n  return !!loopCharacteristics && (0,ModelUtil.is)(loopCharacteristics, 'bpmn:MultiInstanceLoopCharacteristics');\n}\n\n/**\n * getBody - get the body of a given expression.\n *\n * @param {ModdleElement<bpmn:FormalExpression>} expression\n * @return {string} the body (value) of the expression\n */\nfunction getBody(expression) {\n  return expression && expression.get('body');\n}\n\n/**\n * getProperty - get a property value of the loop characteristics.\n *\n * @param {djs.model.Base} element\n * @param {string} propertyName\n *\n * @return {any} the property value\n */\nfunction getProperty$2(element, propertyName) {\n  const loopCharacteristics = getLoopCharacteristics$2(element);\n  return loopCharacteristics && loopCharacteristics.get(propertyName);\n}\n\n/**\n * getLoopCharacteristics - get loopCharacteristics of a given element.\n *\n * @param {djs.model.Base} element\n * @return {ModdleElement<bpmn:MultiInstanceLoopCharacteristics> | undefined}\n */\nfunction getLoopCharacteristics$2(element) {\n  const bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return bo.loopCharacteristics;\n}\n\n/**\n * createFormalExpression - creates a 'bpmn:FormalExpression' element.\n *\n * @param {ModdleElement} parent\n * @param {string} body\n * @param {BpmnFactory} bpmnFactory\n *\n * @result {ModdleElement<bpmn:FormalExpression>} a formal expression\n */\nfunction createFormalExpression$1(parent, body, bpmnFactory) {\n  return createElement('bpmn:FormalExpression', {\n    body: body\n  }, parent, bpmnFactory);\n}\n\n/**\n * updateFormalExpression - updates a specific formal expression of the loop characteristics.\n *\n * @param {djs.model.Base} element\n * @param {string} propertyName\n * @param {string} newValue\n * @param {BpmnFactory} bpmnFactory\n */\nfunction updateFormalExpression(element, propertyName, newValue, bpmnFactory) {\n  const loopCharacteristics = getLoopCharacteristics$2(element);\n  const expressionProps = {};\n  if (!newValue) {\n    // remove formal expression\n    expressionProps[propertyName] = undefined;\n    return {\n      element,\n      moddleElement: loopCharacteristics,\n      properties: expressionProps\n    };\n  }\n  const existingExpression = loopCharacteristics.get(propertyName);\n  if (!existingExpression) {\n    // add formal expression\n    expressionProps[propertyName] = createFormalExpression$1(loopCharacteristics, newValue, bpmnFactory);\n    return {\n      element,\n      moddleElement: loopCharacteristics,\n      properties: expressionProps\n    };\n  }\n\n  // edit existing formal expression\n  return {\n    element,\n    moddleElement: existingExpression,\n    properties: {\n      body: newValue\n    }\n  };\n}\n\n// loopCardinality\n\n/**\n * getLoopCardinality - get the loop cardinality of the loop characteristics.\n *\n * @param {djs.model.Base} element\n *\n * @return {ModdleElement<bpmn:FormalExpression>} an expression representing the loop cardinality\n */\nfunction getLoopCardinality(element) {\n  return getProperty$2(element, 'loopCardinality');\n}\n\n/**\n * getLoopCardinalityValue - get the loop cardinality value of the loop characteristics.\n *\n * @param {djs.model.Base} element\n *\n * @return {string} the loop cardinality value\n */\nfunction getLoopCardinalityValue(element) {\n  const loopCardinality = getLoopCardinality(element);\n  return getBody(loopCardinality);\n}\n\n// completionCondition /////////////////////\n\n/**\n * getCompletionCondition - get the completion condition of the loop characteristics.\n *\n * @param {djs.model.Base} element\n *\n * @return {ModdleElement<bpmn:FormalExpression>} an expression representing the completion condition\n */\nfunction getCompletionCondition$1(element) {\n  return getProperty$2(element, 'completionCondition');\n}\n\n/**\n * getCompletionConditionValue - get the completion condition value of the loop characteristics.\n *\n * @param {djs.model.Base} element\n *\n * @return {string} the completion condition value\n */\nfunction getCompletionConditionValue(element) {\n  const completionCondition = getCompletionCondition$1(element);\n  return getBody(completionCondition);\n}\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction NameProps(props) {\n  const {\n    element\n  } = props;\n  if ((0,ModelUtil/* isAny */.JZ)(element, ['bpmn:Collaboration', 'bpmn:DataAssociation', 'bpmn:Association'])) {\n    return [];\n  }\n  return [{\n    id: 'name',\n    component: Name$3,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n}\nfunction Name$3(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const debounce = useService('debounceInput');\n  const canvas = useService('canvas');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n\n  // (1) default: name\n  let options = {\n    element,\n    id: 'name',\n    label: translate('Name'),\n    debounce,\n    setValue: value => {\n      modeling.updateProperties(element, {\n        name: value\n      });\n    },\n    getValue: element => {\n      return element.businessObject.name;\n    }\n  };\n\n  // (2) text annotations\n  if ((0,ModelUtil.is)(element, 'bpmn:TextAnnotation')) {\n    options = {\n      ...options,\n      setValue: value => {\n        modeling.updateProperties(element, {\n          text: value\n        });\n      },\n      getValue: element => {\n        return element.businessObject.text;\n      }\n    };\n  }\n\n  // (3) groups\n  else if ((0,ModelUtil.is)(element, 'bpmn:Group')) {\n    options = {\n      ...options,\n      setValue: value => {\n        const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n          categoryValueRef = businessObject.categoryValueRef;\n        if (!categoryValueRef) {\n          initializeCategory(businessObject, canvas.getRootElement(), bpmnFactory);\n        }\n        modeling.updateLabel(element, value);\n      },\n      getValue: element => {\n        const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n          categoryValueRef = businessObject.categoryValueRef;\n        return categoryValueRef && categoryValueRef.value;\n      }\n    };\n  }\n\n  // (4) participants (only update label)\n  else if ((0,ModelUtil.is)(element, 'bpmn:Participant')) {\n    options.label = translate('Participant Name');\n  }\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)(options);\n}\n\n// helpers ////////////////////////\n\nfunction initializeCategory(businessObject, rootElement, bpmnFactory) {\n  const definitions = (0,ModelUtil/* getBusinessObject */.SS)(rootElement).$parent;\n  const categoryValue = createCategoryValue(definitions, bpmnFactory);\n  businessObject.categoryValueRef = categoryValue;\n}\nfunction createCategoryValue(definitions, bpmnFactory) {\n  const categoryValue = bpmnFactory.create('bpmn:CategoryValue');\n  const category = bpmnFactory.create('bpmn:Category', {\n    categoryValue: [categoryValue]\n  });\n\n  // add to correct place\n  (0,Collections/* add */.IH)(definitions.get('rootElements'), category);\n  (0,ModelUtil/* getBusinessObject */.SS)(category).$parent = definitions;\n  (0,ModelUtil/* getBusinessObject */.SS)(categoryValue).$parent = category;\n  return categoryValue;\n}\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction ProcessProps(props) {\n  const {\n    element\n  } = props;\n  if (!hasProcessRef(element)) {\n    return [];\n  }\n  return [{\n    id: 'processId',\n    component: ProcessId,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'processName',\n    component: ProcessName,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n}\nfunction ProcessName(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const process = element.businessObject.get('processRef');\n  const getValue = () => {\n    return process.get('name');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: process,\n      properties: {\n        name: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'processName',\n    label: translate('Process name'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ProcessId(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const process = element.businessObject.get('processRef');\n  const getValue = () => {\n    return process.get('id');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: process,\n      properties: {\n        id: value\n      }\n    });\n  };\n  const validate = value => {\n    return isIdValid(process, value, translate);\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'processId',\n    label: translate('Process ID'),\n    getValue,\n    setValue,\n    debounce,\n    validate\n  });\n}\n\n// helper ////////////////\n\nfunction hasProcessRef(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Participant') && element.businessObject.get('processRef');\n}\n\nconst EMPTY_OPTION$2 = '';\nconst CREATE_NEW_OPTION$1 = 'create-new';\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction SignalProps(props) {\n  const {\n    element\n  } = props;\n  if (!isSignalSupported(element)) {\n    return [];\n  }\n  const signal = getSignal(element);\n  let entries = [{\n    id: 'signalRef',\n    component: SignalRef,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  }];\n  if (signal) {\n    entries = [...entries, {\n      id: 'signalName',\n      component: SignalName,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    }];\n  }\n  return entries;\n}\nfunction SignalRef(props) {\n  const {\n    element\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const signalEventDefinition = getSignalEventDefinition(element);\n  const getValue = () => {\n    const signal = getSignal(element);\n    if (signal) {\n      return signal.get('id');\n    }\n    return EMPTY_OPTION$2;\n  };\n  const setValue = value => {\n    const root = getRoot(signalEventDefinition);\n    const commands = [];\n    let signal;\n\n    // (1) create new signal\n    if (value === CREATE_NEW_OPTION$1) {\n      const id = nextId('Signal_');\n      signal = createElement('bpmn:Signal', {\n        id,\n        name: id\n      }, root, bpmnFactory);\n      value = signal.get('id');\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: root,\n          properties: {\n            rootElements: [...root.get('rootElements'), signal]\n          }\n        }\n      });\n    }\n\n    // (2) update (or remove) signalRef\n    signal = signal || findRootElementById(signalEventDefinition, 'bpmn:Signal', value);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: signalEventDefinition,\n        properties: {\n          signalRef: signal\n        }\n      }\n    });\n\n    // (3) commit all updates\n    return commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  const getOptions = () => {\n    let options = [{\n      value: EMPTY_OPTION$2,\n      label: translate('<none>')\n    }, {\n      value: CREATE_NEW_OPTION$1,\n      label: translate('Create new ...')\n    }];\n    const signals = findRootElementsByType((0,ModelUtil/* getBusinessObject */.SS)(element), 'bpmn:Signal');\n    sortByName$2(signals).forEach(signal => {\n      options.push({\n        value: signal.get('id'),\n        label: signal.get('name')\n      });\n    });\n    return options;\n  };\n  return ReferenceSelectEntry({\n    element,\n    id: 'signalRef',\n    label: translate('Global signal reference'),\n    autoFocusEntry: 'signalName',\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction SignalName(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const signal = getSignal(element);\n  const getValue = () => {\n    return signal.get('name');\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: signal,\n      properties: {\n        name: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'signalName',\n    label: translate('Name'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper /////////////////////////\n\nfunction sortByName$2(elements) {\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* sortBy */.MR)(elements, e => (e.name || '').toLowerCase());\n}\n\nfunction isTimerSupported(element) {\n  return (0,ModelUtil/* isAny */.JZ)(element, ['bpmn:StartEvent', 'bpmn:IntermediateCatchEvent', 'bpmn:BoundaryEvent']) && !!getTimerEventDefinition(element);\n}\n\n/**\n * Get the timer definition type for a given timer event definition.\n *\n * @param {ModdleElement<bpmn:TimerEventDefinition>} timer\n *\n * @return {string|undefined} the timer definition type\n */\nfunction getTimerDefinitionType(timer) {\n  if (!timer) {\n    return;\n  }\n  const timeDate = timer.get('timeDate');\n  if (typeof timeDate !== 'undefined') {\n    return 'timeDate';\n  }\n  const timeCycle = timer.get('timeCycle');\n  if (typeof timeCycle !== 'undefined') {\n    return 'timeCycle';\n  }\n  const timeDuration = timer.get('timeDuration');\n  if (typeof timeDuration !== 'undefined') {\n    return 'timeDuration';\n  }\n}\nfunction getTimerEventDefinition(element) {\n  return index_esm_getEventDefinition(element, 'bpmn:TimerEventDefinition');\n}\nfunction index_esm_getEventDefinition(element, eventType) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const eventDefinitions = businessObject.get('eventDefinitions') || [];\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* find */.sE)(eventDefinitions, function (definition) {\n    return (0,ModelUtil.is)(definition, eventType);\n  });\n}\n\nfunction TimerProps$2(props) {\n  const {\n    element,\n    listener,\n    idPrefix\n  } = props;\n  let {\n    timerEventDefinition\n  } = props;\n  if (!timerEventDefinition) {\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    timerEventDefinition = getTimerEventDefinition(businessObject);\n  }\n  const timerEventDefinitionType = getTimerDefinitionType(timerEventDefinition);\n\n  // (1) Only show for supported elements\n  if (!isTimerSupported(element) && !isTimerSupportedOnListener$1(listener)) {\n    return [];\n  }\n\n  // (2) Provide entries, have a value only if selection was made\n  const entries = [];\n  entries.push({\n    id: getId$1(idPrefix, 'timerEventDefinitionType'),\n    component: TimerEventDefinitionType$2,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD,\n    timerEventDefinition,\n    timerEventDefinitionType\n  });\n  if (timerEventDefinitionType) {\n    entries.push({\n      id: getId$1(idPrefix, 'timerEventDefinitionValue'),\n      component: TimerEventDefinitionValue$2,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$,\n      timerEventDefinition,\n      timerEventDefinitionType\n    });\n  }\n  return entries;\n}\n\n/**\n * TimerEventDefinitionType - Generic select entry allowing to select a specific\n * timerEventDefintionType. To be used together with timerEventDefinitionValue.\n *\n * @param  {type} props\n * @return {SelectEntry}\n */\nfunction TimerEventDefinitionType$2(props) {\n  const {\n    element,\n    timerEventDefinition,\n    timerEventDefinitionType\n  } = props;\n  const commandStack = useService('commandStack'),\n    bpmnFactory = useService('bpmnFactory'),\n    translate = useService('translate');\n  const getValue = () => {\n    return timerEventDefinitionType || '';\n  };\n  const setValue = value => {\n    // (1) Check if value is different to current type\n    if (value === timerEventDefinitionType) {\n      return;\n    }\n\n    // (2) Create empty formalExpression element\n    const formalExpression = bpmnFactory.create('bpmn:FormalExpression', {\n      body: undefined\n    });\n    formalExpression.$parent = timerEventDefinition;\n\n    // (3) Set the value for selected timerEventDefinitionType\n    const newProps = {\n      timeDuration: undefined,\n      timeDate: undefined,\n      timeCycle: undefined\n    };\n    if (value !== '') {\n      newProps[value] = formalExpression;\n    }\n\n    // (4) Execute businessObject update\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: timerEventDefinition,\n      properties: newProps\n    });\n  };\n  const getOptions = element => {\n    return [{\n      value: '',\n      label: translate('<none>')\n    }, {\n      value: 'timeDate',\n      label: translate('Date')\n    }, {\n      value: 'timeDuration',\n      label: translate('Duration')\n    }, {\n      value: 'timeCycle',\n      label: translate('Cycle')\n    }];\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element,\n    id: 'timerEventDefinitionType',\n    label: translate('Type'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\n\n/**\n * TimerEventDefinitionValue - Generic textField entry allowing to specify the\n * timerEventDefintionValue based on the set timerEventDefintionType. To be used\n * together with timerEventDefinitionType.\n *\n * @param  {type} props\n * @return {TextFieldEntry}\n */\nfunction TimerEventDefinitionValue$2(props) {\n  const {\n    element,\n    timerEventDefinition,\n    timerEventDefinitionType\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const timerEventFormalExpression = timerEventDefinition.get(timerEventDefinitionType);\n  const getValue = () => {\n    return timerEventFormalExpression && timerEventFormalExpression.get('body');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: timerEventFormalExpression,\n      properties: {\n        body: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'timerEventDefinitionValue',\n    label: translate('Value'),\n    getValue,\n    setValue,\n    debounce,\n    description: getTimerEventDefinitionValueDescription$2(timerEventDefinitionType, translate)\n  });\n}\n\n// helper //////////////////////////\n\nfunction getTimerEventDefinitionValueDescription$2(timerDefinitionType, translate) {\n  switch (timerDefinitionType) {\n    case 'timeDate':\n      return (0,jsxRuntime_module/* jsxs */.BX)(\"div\", {\n        children: [(0,jsxRuntime_module/* jsx */.tZ)(\"p\", {\n          children: translate('A specific point in time defined as ISO 8601 combined date and time representation.')\n        }), (0,jsxRuntime_module/* jsxs */.BX)(\"ul\", {\n          children: [(0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"2019-10-01T12:00:00Z\"\n            }), \" - \", translate('UTC time')]\n          }), (0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"2019-10-02T08:09:40+02:00\"\n            }), \" - \", translate('UTC plus 2 hours zone offset')]\n          })]\n        }), (0,jsxRuntime_module/* jsx */.tZ)(\"a\", {\n          href: \"https://docs.camunda.org/manual/latest/reference/bpmn20/events/timer-events/#time-date\",\n          target: \"_blank\",\n          rel: \"noopener\",\n          children: translate('Documentation: Timer events')\n        })]\n      });\n    case 'timeCycle':\n      return (0,jsxRuntime_module/* jsxs */.BX)(\"div\", {\n        children: [(0,jsxRuntime_module/* jsx */.tZ)(\"p\", {\n          children: translate('A cycle defined as ISO 8601 repeating intervals format.')\n        }), (0,jsxRuntime_module/* jsxs */.BX)(\"ul\", {\n          children: [(0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"R5/PT10S\"\n            }), \" - \", translate('every 10 seconds, up to 5 times')]\n          }), (0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"R/P1D\"\n            }), \" - \", translate('every day, infinitely')]\n          })]\n        }), (0,jsxRuntime_module/* jsx */.tZ)(\"a\", {\n          href: \"https://docs.camunda.org/manual/latest/reference/bpmn20/events/timer-events/#time-cycle\",\n          target: \"_blank\",\n          rel: \"noopener\",\n          children: translate('Documentation: Timer events')\n        })]\n      });\n    case 'timeDuration':\n      return (0,jsxRuntime_module/* jsxs */.BX)(\"div\", {\n        children: [(0,jsxRuntime_module/* jsx */.tZ)(\"p\", {\n          children: translate('A time duration defined as ISO 8601 durations format.')\n        }), (0,jsxRuntime_module/* jsxs */.BX)(\"ul\", {\n          children: [(0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"PT15S\"\n            }), \" - \", translate('15 seconds')]\n          }), (0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"PT1H30M\"\n            }), \" - \", translate('1 hour and 30 minutes')]\n          }), (0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"P14D\"\n            }), \" - \", translate('14 days')]\n          })]\n        }), (0,jsxRuntime_module/* jsx */.tZ)(\"a\", {\n          href: \"https://docs.camunda.org/manual/latest/reference/bpmn20/events/timer-events/#time-duration\",\n          target: \"_blank\",\n          rel: \"noopener\",\n          children: translate('Documentation: Timer events')\n        })]\n      });\n  }\n}\nfunction isTimerSupportedOnListener$1(listener) {\n  return listener && (0,ModelUtil.is)(listener, 'camunda:TaskListener') && getTimerEventDefinition(listener);\n}\nfunction getId$1(idPrefix, id) {\n  return idPrefix ? idPrefix + id : id;\n}\n\nfunction GeneralGroup(element, injector) {\n  const translate = injector.get('translate');\n  const entries = [...NameProps({\n    element\n  }), ...IdProps(), ...ProcessProps({\n    element\n  }), ...ExecutableProps({\n    element\n  })];\n  return {\n    id: 'general',\n    label: translate('General'),\n    entries,\n    component: properties_panel_dist_index_esm/* Group */.ZA\n  };\n}\nfunction CompensationGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Compensation'),\n    id: 'compensation',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...CompensationProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction DocumentationGroup(element, injector) {\n  const translate = injector.get('translate');\n  const entries = [...DocumentationProps({\n    element\n  })];\n  return {\n    id: 'documentation',\n    label: translate('Documentation'),\n    entries,\n    component: properties_panel_dist_index_esm/* Group */.ZA\n  };\n}\nfunction ErrorGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    id: 'error',\n    label: translate('Error'),\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...ErrorProps$1({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction MessageGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    id: 'message',\n    label: translate('Message'),\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...MessageProps$1({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction SignalGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    id: 'signal',\n    label: translate('Signal'),\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...SignalProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction LinkGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Link'),\n    id: 'link',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...LinkProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction EscalationGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    id: 'escalation',\n    label: translate('Escalation'),\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...EscalationProps$1({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction TimerGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Timer'),\n    id: 'timer',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...TimerProps$2({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction MultiInstanceGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Multi-instance'),\n    id: 'multiInstance',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...MultiInstanceProps$2({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction getGroups(element, injector) {\n  const groups = [GeneralGroup(element, injector), DocumentationGroup(element, injector), CompensationGroup(element, injector), ErrorGroup(element, injector), LinkGroup(element, injector), MessageGroup(element, injector), MultiInstanceGroup(element, injector), SignalGroup(element, injector), EscalationGroup(element, injector), TimerGroup(element, injector)];\n\n  // contract: if a group returns null, it should not be displayed at all\n  return groups.filter(group => group !== null);\n}\nclass BpmnPropertiesProvider {\n  constructor(propertiesPanel, injector) {\n    propertiesPanel.registerProvider(this);\n    this._injector = injector;\n  }\n  getGroups(element) {\n    return groups => {\n      groups = groups.concat(getGroups(element, this._injector));\n      return groups;\n    };\n  }\n}\nBpmnPropertiesProvider.$inject = ['propertiesPanel', 'injector'];\n\nvar index$2 = {\n  __init__: ['bpmnPropertiesProvider'],\n  bpmnPropertiesProvider: ['type', BpmnPropertiesProvider]\n};\n\n/**\n * Get extension elements of business object. Optionally filter by type.\n *\n * @param  {ModdleElement} businessObject\n * @param  {String} [type=undefined]\n * @returns {Array<ModdleElement>}\n */\nfunction getExtensionElementsList(businessObject, type = undefined) {\n  const extensionElements = businessObject.get('extensionElements');\n  if (!extensionElements) {\n    return [];\n  }\n  const values = extensionElements.get('values');\n  if (!values || !values.length) {\n    return [];\n  }\n  if (type) {\n    return values.filter(value => (0,ModelUtil.is)(value, type));\n  }\n  return values;\n}\n\n/**\n * Add one or more extension elements. Create bpmn:ExtensionElements if it doesn't exist.\n *\n * @param {ModdleElement} element\n * @param {ModdleElement} businessObject\n * @param {ModdleElement|Array<ModdleElement>} extensionElementsToAdd\n * @param {CommandStack} commandStack\n */\nfunction addExtensionElements(element, businessObject, extensionElementToAdd, bpmnFactory, commandStack) {\n  const commands = [];\n  let extensionElements = businessObject.get('extensionElements');\n\n  // (1) create bpmn:ExtensionElements if it doesn't exist\n  if (!extensionElements) {\n    extensionElements = createElement('bpmn:ExtensionElements', {\n      values: []\n    }, businessObject, bpmnFactory);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: businessObject,\n        properties: {\n          extensionElements\n        }\n      }\n    });\n  }\n  extensionElementToAdd.$parent = extensionElements;\n\n  // (2) add extension element to list\n  commands.push({\n    cmd: 'element.updateModdleProperties',\n    context: {\n      element,\n      moddleElement: extensionElements,\n      properties: {\n        values: [...extensionElements.get('values'), extensionElementToAdd]\n      }\n    }\n  });\n  commandStack.execute('properties-panel.multi-command-executor', commands);\n}\n\n/**\n * Remove one or more extension elements. Remove bpmn:ExtensionElements afterwards if it's empty.\n *\n * @param {ModdleElement} element\n * @param {ModdleElement} businessObject\n * @param {ModdleElement|Array<ModdleElement>} extensionElementsToRemove\n * @param {CommandStack} commandStack\n */\nfunction removeExtensionElements(element, businessObject, extensionElementsToRemove, commandStack) {\n  if (!(0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isArray */.kJ)(extensionElementsToRemove)) {\n    extensionElementsToRemove = [extensionElementsToRemove];\n  }\n  const extensionElements = businessObject.get('extensionElements'),\n    values = extensionElements.get('values').filter(value => !extensionElementsToRemove.includes(value));\n  commandStack.execute('element.updateModdleProperties', {\n    element,\n    moddleElement: extensionElements,\n    properties: {\n      values\n    }\n  });\n}\n\nfunction withVariableContext(Component) {\n  return props => {\n    const {\n      bpmnElement,\n      element\n    } = props;\n    const bo = (bpmnElement || element).businessObject;\n    const [variables, setVariables] = (0,hooks_module/* useState */.eJ)([]);\n    const eventBus = useService('eventBus');\n    (0,hooks_module/* useEffect */.d4)(() => {\n      const callback = () => {\n        const variables = (0,zeebe/* getVariablesForElement */.eH)(bo);\n        setVariables(variables.map(variable => {\n          return {\n            name: variable.name,\n            info: 'Written in ' + variable.origin.map(origin => origin.name || origin.id).join(', ')\n          };\n        }));\n      };\n      eventBus.on('commandStack.changed', callback);\n      callback();\n      return () => {\n        eventBus.off('commandStack.changed', callback);\n      };\n    }, [bo]);\n    return (0,jsxRuntime_module/* jsx */.tZ)(Component, {\n      ...props,\n      variables: variables\n    });\n  };\n}\n\nfunction withTooltipContainer(Component) {\n  return props => {\n    const tooltipContainer = (0,hooks_module/* useMemo */.Ye)(() => {\n      const config = useService('config');\n      return config && config.propertiesPanel && config.propertiesPanel.feelTooltipContainer;\n    }, []);\n    return (0,jsxRuntime_module/* jsx */.tZ)(Component, {\n      ...props,\n      tooltipContainer: tooltipContainer\n    });\n  };\n}\n\nconst FeelEntryWithContext = withVariableContext(withTooltipContainer(properties_panel_dist_index_esm/* FeelEntry */.z$));\nconst FeelTextAreaEntryWithContext = withVariableContext(withTooltipContainer(properties_panel_dist_index_esm/* FeelTextAreaEntry */.kS));\n\nfunction AssignmentDefinitionProps(props) {\n  const {\n    element\n  } = props;\n  if (!(0,ModelUtil.is)(element, 'bpmn:UserTask')) {\n    return [];\n  }\n  return [{\n    id: 'assignmentDefinitionAssignee',\n    component: Assignee$1,\n    isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw\n  }, {\n    id: 'assignmentDefinitionCandidateGroups',\n    component: CandidateGroups$1,\n    isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw\n  }, {\n    id: 'assignmentDefinitionCandidateUsers',\n    component: CandidateUsers$1,\n    isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw\n  }];\n}\nfunction Assignee$1(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (getAssignmentDefinition(element) || {}).assignee;\n  };\n  const setValue = value => {\n    const commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure AssignmentDefinition\n    let assignmentDefinition = getAssignmentDefinition(element);\n    if (!assignmentDefinition) {\n      assignmentDefinition = createElement('zeebe:AssignmentDefinition', {}, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), assignmentDefinition]\n          }\n        }\n      });\n    }\n\n    // (3) update assignee definition type\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: assignmentDefinition,\n        properties: {\n          assignee: value\n        }\n      }\n    });\n\n    // (4) commit all updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return FeelEntryWithContext({\n    element,\n    id: 'assignmentDefinitionAssignee',\n    label: translate('Assignee'),\n    feel: 'optional',\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction CandidateGroups$1(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (getAssignmentDefinition(element) || {}).candidateGroups;\n  };\n  const setValue = value => {\n    let commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure assignmentDefinition\n    let assignmentDefinition = getAssignmentDefinition(element);\n    if (!assignmentDefinition) {\n      assignmentDefinition = createElement('zeebe:AssignmentDefinition', {}, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), assignmentDefinition]\n          }\n        }\n      });\n    }\n\n    // (3) update candidateGroups\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: assignmentDefinition,\n        properties: {\n          candidateGroups: value\n        }\n      }\n    });\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return FeelEntryWithContext({\n    element,\n    id: 'assignmentDefinitionCandidateGroups',\n    label: translate('Candidate groups'),\n    feel: 'optional',\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction CandidateUsers$1(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (getAssignmentDefinition(element) || {}).candidateUsers;\n  };\n  const setValue = value => {\n    let commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure assignmentDefinition\n    let assignmentDefinition = getAssignmentDefinition(element);\n    if (!assignmentDefinition) {\n      assignmentDefinition = createElement('zeebe:AssignmentDefinition', {}, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), assignmentDefinition]\n          }\n        }\n      });\n    }\n\n    // (3) update candidateUsers\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: assignmentDefinition,\n        properties: {\n          candidateUsers: value\n        }\n      }\n    });\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return FeelEntryWithContext({\n    element,\n    id: 'assignmentDefinitionCandidateUsers',\n    label: translate('Candidate users'),\n    feel: 'optional',\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper ///////////////////////\n\nfunction getAssignmentDefinition(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(businessObject, 'zeebe:AssignmentDefinition')[0];\n}\n\nconst DMN_IMPLEMENTATION_OPTION = 'dmn',\n  JOB_WORKER_IMPLEMENTATION_OPTION$1 = 'jobWorker',\n  DEFAULT_IMPLEMENTATION_OPTION$1 = '';\nfunction BusinessRuleImplementationProps(props) {\n  const {\n    element\n  } = props;\n  if (!(0,ModelUtil.is)(element, 'bpmn:BusinessRuleTask')) {\n    return [];\n  }\n  return [{\n    id: 'businessRuleImplementation',\n    component: BusinessRuleImplementation,\n    isEdited: () => isBusinessRuleImplementationEdited(element)\n  }];\n}\nfunction BusinessRuleImplementation(props) {\n  const {\n    element,\n    id\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const getValue = () => {\n    if (getCalledDecision$1(element)) {\n      return DMN_IMPLEMENTATION_OPTION;\n    }\n    if (getTaskDefinition$3(element)) {\n      return JOB_WORKER_IMPLEMENTATION_OPTION$1;\n    }\n    return DEFAULT_IMPLEMENTATION_OPTION$1;\n  };\n\n  /**\n   * Set value by either creating a zeebe:calledDecision or a zeebe:taskDefintion\n   * extension element. Note that they must not exist both at the same time, however\n   * this will be ensured by a bpmn-js behavior (and not by the propPanel).\n   */\n  const setValue = value => {\n    let extensionElement, extensionElementType;\n    if (value === DMN_IMPLEMENTATION_OPTION) {\n      extensionElement = getCalledDecision$1(element);\n      extensionElementType = 'zeebe:CalledDecision';\n    } else if (value === JOB_WORKER_IMPLEMENTATION_OPTION$1) {\n      extensionElement = getTaskDefinition$3(element);\n      extensionElementType = 'zeebe:TaskDefinition';\n    } else {\n      resetElement$1(element, commandStack);\n    }\n    if (!extensionElement && extensionElementType) {\n      extensionElement = createElement(extensionElementType, {}, null, bpmnFactory);\n      updateExtensionElements$1(element, extensionElement, bpmnFactory, commandStack);\n    }\n  };\n  const getOptions = () => {\n    const options = [{\n      value: DEFAULT_IMPLEMENTATION_OPTION$1,\n      label: translate('<none>')\n    }, {\n      value: DMN_IMPLEMENTATION_OPTION,\n      label: translate('DMN decision')\n    }, {\n      value: JOB_WORKER_IMPLEMENTATION_OPTION$1,\n      label: translate('Job worker')\n    }];\n    return options;\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element,\n    id,\n    label: translate('Implementation'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\n\n// helper ///////////////////////\n\nfunction getTaskDefinition$3(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(businessObject, 'zeebe:TaskDefinition')[0];\n}\nfunction getCalledDecision$1(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(businessObject, 'zeebe:CalledDecision')[0];\n}\nfunction isBusinessRuleImplementationEdited(element) {\n  return getTaskDefinition$3(element);\n}\nfunction resetElement$1(element, commandStack) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const taskDefintion = getTaskDefinition$3(element);\n  const calledDecision = getCalledDecision$1(element);\n  if (taskDefintion) {\n    removeExtensionElements(element, businessObject, taskDefintion, commandStack);\n  }\n  if (calledDecision) {\n    removeExtensionElements(element, businessObject, calledDecision, commandStack);\n  }\n}\nfunction updateExtensionElements$1(element, extensionElementToAdd, bpmnFactory, commandStack) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const commands = [];\n  let extensionElements = businessObject.get('extensionElements');\n  let extensionElementValues;\n\n  // (1) create bpmn:ExtensionElements if it doesn't exist\n  if (!extensionElements) {\n    extensionElements = createElement('bpmn:ExtensionElements', {\n      values: []\n    }, businessObject, bpmnFactory);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: businessObject,\n        properties: {\n          extensionElements\n        }\n      }\n    });\n  }\n  extensionElementToAdd.$parent = extensionElements;\n\n  // (2) remove old exension element from extensionElements\n  if ((0,ModelUtil.is)(extensionElementToAdd, 'zeebe:TaskDefinition')) {\n    extensionElementValues = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), getCalledDecision$1(element));\n  } else if ((0,ModelUtil.is)(extensionElementToAdd, 'zeebe:CalledDecision')) {\n    extensionElementValues = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), getTaskDefinition$3(element));\n  }\n\n  // (3) add extension element to list\n  commands.push({\n    cmd: 'element.updateModdleProperties',\n    context: {\n      element,\n      moddleElement: extensionElements,\n      properties: {\n        values: [...extensionElementValues, extensionElementToAdd]\n      }\n    }\n  });\n  commandStack.execute('properties-panel.multi-command-executor', commands);\n}\n\nfunction CalledDecisionProps(props) {\n  const {\n    element\n  } = props;\n  if (!(0,ModelUtil.is)(element, 'bpmn:BusinessRuleTask') || !getCalledDecision(element)) {\n    return [];\n  }\n  return [{\n    id: 'decisionId',\n    component: DecisionID,\n    isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw\n  }, {\n    id: 'resultVariable',\n    component: ResultVariable$4,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n}\nfunction DecisionID(props) {\n  const {\n    element,\n    id\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (getCalledDecision(element) || {}).decisionId;\n  };\n  const setValue = value => {\n    const commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure calledDecision\n    let calledDecision = getCalledDecision(element);\n    if (!calledDecision) {\n      calledDecision = createElement('zeebe:CalledDecision', {}, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), calledDecision]\n          }\n        }\n      });\n    }\n\n    // (3) update caledDecision.decisionId\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: calledDecision,\n        properties: {\n          decisionId: value\n        }\n      }\n    });\n\n    // (4) commit all updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return FeelEntryWithContext({\n    element,\n    id,\n    label: translate('Decision ID'),\n    feel: 'optional',\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ResultVariable$4(props) {\n  const {\n    element,\n    id\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (getCalledDecision(element) || {}).resultVariable;\n  };\n  const setValue = value => {\n    const commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure calledDecision\n    let calledDecision = getCalledDecision(element);\n    if (!calledDecision) {\n      calledDecision = createElement('zeebe:CalledDecision', {}, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), calledDecision]\n          }\n        }\n      });\n    }\n\n    // (3) update caledDecision.decisionId\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: calledDecision,\n        properties: {\n          resultVariable: value\n        }\n      }\n    });\n\n    // (4) commit all updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id,\n    label: translate('Result variable'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper ///////////////////////\n\nfunction getCalledDecision(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(businessObject, 'zeebe:CalledDecision')[0];\n}\n\nfunction ConditionProps$1(props) {\n  const {\n    element\n  } = props;\n  if (!(0,ModelUtil.is)(element, 'bpmn:SequenceFlow')) {\n    return [];\n  }\n  const conditionProps = [];\n  if (isConditionalSource$1(element.source)) {\n    conditionProps.push({\n      id: 'conditionExpression',\n      component: ConditionExpression$1,\n      isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw\n    });\n  }\n  return conditionProps;\n}\nfunction ConditionExpression$1(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack'),\n    bpmnFactory = useService('bpmnFactory'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const getValue = () => {\n    return getConditionExpression$1(element);\n  };\n  const setValue = value => {\n    const commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n    // (1) If we set value to a default flow, make it a non-default flow\n    // by updating the element source\n    const source = element.source;\n    if (source.businessObject.default === businessObject) {\n      commands.push({\n        cmd: 'element.updateProperties',\n        context: {\n          element: source,\n          properties: {\n            'default': undefined\n          }\n        }\n      });\n    }\n\n    // (2) Create and set formalExpression element containing the conditionExpression,\n    // unless the provided value is empty\n    const formalExpressionElement = value && value != '' ? createElement('bpmn:FormalExpression', {\n      body: value\n    }, businessObject, bpmnFactory) : undefined;\n    commands.push({\n      cmd: 'element.updateProperties',\n      context: {\n        element: element,\n        properties: {\n          conditionExpression: formalExpressionElement\n        }\n      }\n    });\n\n    // (3) Execute the commands\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return FeelEntryWithContext({\n    element,\n    id: 'conditionExpression',\n    label: translate('Condition expression'),\n    feel: 'required',\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper //////////////////////////\n\nconst CONDITIONAL_SOURCES$1 = ['bpmn:Activity', 'bpmn:ExclusiveGateway', 'bpmn:InclusiveGateway'];\nfunction isConditionalSource$1(element) {\n  return (0,ModelUtil/* isAny */.JZ)(element, CONDITIONAL_SOURCES$1);\n}\n\n/**\n * getConditionExpression - get the body value of a condition expression for a given element\n *\n * @param  {ModdleElement} element\n *\n * @return {string|undefined}\n */\nfunction getConditionExpression$1(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const conditionExpression = businessObject.conditionExpression;\n  if (conditionExpression) {\n    return conditionExpression.get('body');\n  }\n}\n\nfunction FormProps$1(props) {\n  const {\n    element,\n    injector\n  } = props;\n  const formHelper = injector.invoke(FormHelper);\n  if (!(0,ModelUtil.is)(element, 'bpmn:UserTask')) {\n    return [];\n  }\n  const entries = [{\n    id: 'formType',\n    component: FormType$1,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  }];\n  if (isCamundaForm(element, formHelper)) {\n    entries.push({\n      id: 'formConfiguration',\n      component: FormConfiguration,\n      isEdited: properties_panel_dist_index_esm/* isTextAreaEntryEdited */.mn\n    });\n  } else if (isCustomKey(element, formHelper)) {\n    entries.push({\n      id: 'customFormKey',\n      component: CustomFormKey,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n  return entries;\n}\nfunction FormType$1(props) {\n  const {\n    element\n  } = props;\n  const translate = useService('translate');\n  const injector = useService('injector');\n  const formHelper = injector.invoke(FormHelper);\n  const getValue = () => {\n    const formDefinition = formHelper.getFormDefinition(element);\n    const userTaskForm = formHelper.getUserTaskForm(element);\n    if (formDefinition) {\n      if (userTaskForm) {\n        return 'camundaForm';\n      }\n      return 'formKey';\n    }\n    return '';\n  };\n  const setValue = value => {\n    formHelper.resetForm(element);\n    if (value === 'camundaForm') {\n      formHelper.setUserTaskForm(element, '');\n    } else if (value === 'formKey') {\n      formHelper.setFormDefinition(element, '');\n    }\n  };\n  const getOptions = () => {\n    return [{\n      value: '',\n      label: translate('<none>')\n    }, {\n      value: 'camundaForm',\n      label: translate('Camunda forms')\n    }, {\n      value: 'formKey',\n      label: translate('Custom form key')\n    }];\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element,\n    id: 'formType',\n    label: translate('Type'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction FormConfiguration(props) {\n  const {\n    element\n  } = props;\n  const injector = useService('injector');\n  const debounce = useService('debounceInput');\n  const translate = useService('translate');\n  const formHelper = injector.invoke(FormHelper);\n  const getValue = () => {\n    const userTaskForm = formHelper.getUserTaskForm(element);\n    return userTaskForm.get('body');\n  };\n  const setValue = value => {\n    formHelper.setUserTaskForm(element, value);\n  };\n  return (0,properties_panel_dist_index_esm/* TextAreaEntry */.i)({\n    element,\n    id: 'formConfiguration',\n    label: translate('Form JSON configuration'),\n    rows: 4,\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction CustomFormKey(props) {\n  const {\n    element\n  } = props;\n  const injector = useService('injector');\n  const debounce = useService('debounceInput');\n  const translate = useService('translate');\n  const formHelper = injector.invoke(FormHelper);\n  const getValue = () => {\n    const formDefinition = formHelper.getFormDefinition(element);\n    return formDefinition.get('formKey');\n  };\n  const setValue = value => {\n    formHelper.setFormDefinition(element, value);\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'customFormKey',\n    label: translate('Form key'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nconst USER_TASK_FORM_PREFIX = 'userTaskForm_';\nfunction FormHelper(bpmnFactory, commandStack) {\n  function getFormDefinition(element) {\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    const formDefinitions = getExtensionElementsList(businessObject, 'zeebe:FormDefinition');\n    return formDefinitions[0];\n  }\n  function getUserTaskForm(element, parent) {\n    const rootElement = parent || getRootElement(element);\n\n    // (1) get form definition from user task\n    const formDefinition = getFormDefinition(element);\n    if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isUndefined */.o8)(formDefinition)) {\n      return;\n    }\n    const formKey = formDefinition.get('formKey');\n\n    // (2) retrieve user task form via form key\n    const userTaskForm = findUserTaskForm(formKey, rootElement);\n    return userTaskForm;\n  }\n  function ensureTaskForm(element, values) {\n    let commands = [];\n    const rootElement = getRootElement(element);\n\n    // (1) ensure root element extension elements\n    let rootExtensionElements = rootElement.get('extensionElements');\n    if (!rootExtensionElements) {\n      rootExtensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, rootElement, bpmnFactory);\n      commands.push(UpdateModdlePropertiesCmd(element, rootElement, {\n        extensionElements: rootExtensionElements\n      }));\n    }\n\n    // (2) ensure user task form\n    let userTaskForm = getUserTaskForm(element);\n\n    // (2.1) create user task form if doesn't exist\n    if (!userTaskForm) {\n      userTaskForm = createUserTaskForm(values, rootExtensionElements, bpmnFactory);\n      commands.push(UpdateModdlePropertiesCmd(element, rootExtensionElements, {\n        values: [...rootExtensionElements.get('values'), userTaskForm]\n      }));\n    }\n    commands.push(UpdateModdlePropertiesCmd(element, userTaskForm, values));\n    return commands;\n  }\n  function ensureFormDefinition(element, customFormKey) {\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let commands = [];\n\n    // (1) ensure extension elements\n    let extensionElements = businessObject.get('extensionElements');\n    if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isUndefined */.o8)(extensionElements)) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push(UpdateModdlePropertiesCmd(element, businessObject, {\n        extensionElements: extensionElements\n      }));\n    }\n\n    // (2) ensure form definition\n    let formDefinition = getFormDefinition(element);\n\n    // (2.1) create if doesn't exist\n    if (!formDefinition) {\n      let formKey = customFormKey;\n      if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isUndefined */.o8)(formKey)) {\n        const formId = createFormId();\n        formKey = createFormKey(formId);\n      }\n      formDefinition = createFormDefinition({\n        formKey\n      }, extensionElements, bpmnFactory);\n      commands.push(UpdateModdlePropertiesCmd(element, extensionElements, {\n        values: [...extensionElements.get('values'), formDefinition]\n      }));\n    }\n\n    // (2.2) update existing form definition with custom key\n    else if (customFormKey) {\n      commands.push(UpdateModdlePropertiesCmd(element, formDefinition, {\n        formKey: customFormKey\n      }));\n    }\n    return {\n      formId: resolveFormId(formDefinition.get('formKey')),\n      commands\n    };\n  }\n  function setFormDefinition(element, customFormKey) {\n    const {\n      commands\n    } = ensureFormDefinition(element, customFormKey);\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  }\n  function setUserTaskForm(element, value) {\n    const {\n      formId,\n      commands: formDefCommands\n    } = ensureFormDefinition(element);\n    const userTaskCommands = ensureTaskForm(element, {\n      id: formId,\n      body: value\n    });\n    const commands = formDefCommands.concat(userTaskCommands);\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  }\n  function unsetFormDefinition(element) {\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n      extensionElements = businessObject.get('extensionElements');\n    let commands = [];\n    const formDefinition = getFormDefinition(element);\n    if (!formDefinition) {\n      return commands;\n    }\n    let values = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), formDefinition);\n    commands.push(UpdateModdlePropertiesCmd(element, extensionElements, {\n      values\n    }));\n    return commands;\n  }\n  function resetForm(element) {\n    const rootElement = getRootElement(element),\n      rootExtensionElements = rootElement.get('extensionElements');\n\n    // (1) remove form definition\n    const commands = unsetFormDefinition(element);\n\n    // (2) remove referenced user task form\n    const userTaskForm = getUserTaskForm(element);\n    if (!userTaskForm) {\n      commandStack.execute('properties-panel.multi-command-executor', commands);\n      return;\n    }\n    const values = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(rootExtensionElements.get('values'), userTaskForm);\n    commands.push(UpdateModdlePropertiesCmd(element, rootExtensionElements, {\n      values\n    }));\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  }\n  function createFormKey(formId) {\n    return 'camunda-forms:bpmn:' + formId;\n  }\n  function createFormId() {\n    return nextId(USER_TASK_FORM_PREFIX);\n  }\n  function resolveFormId(formKey) {\n    return formKey.split(':')[2];\n  }\n  function createFormDefinition(properties, extensionElements, bpmnFactory) {\n    return createElement('zeebe:FormDefinition', properties, extensionElements, bpmnFactory);\n  }\n  function createUserTaskForm(properties, extensionElements, bpmnFactory) {\n    return createElement('zeebe:UserTaskForm', properties, extensionElements, bpmnFactory);\n  }\n  function findUserTaskForm(formKey, rootElement) {\n    const forms = getExtensionElementsList(rootElement, 'zeebe:UserTaskForm');\n    return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* find */.sE)(forms, function (userTaskForm) {\n      return createFormKey(userTaskForm.id) === formKey;\n    });\n  }\n  function getRootElement(element) {\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let parent = businessObject;\n    while (parent.$parent && !(0,ModelUtil.is)(parent, 'bpmn:Process')) {\n      parent = parent.$parent;\n    }\n    return parent;\n  }\n  return {\n    getFormDefinition,\n    getUserTaskForm,\n    setFormDefinition,\n    setUserTaskForm,\n    resetForm\n  };\n}\nFormHelper.$inject = ['bpmnFactory', 'commandStack'];\n\n// helpers /////////////\n\nfunction UpdateModdlePropertiesCmd(element, businessObject, newProperties) {\n  return {\n    cmd: 'element.updateModdleProperties',\n    context: {\n      element,\n      moddleElement: businessObject,\n      properties: newProperties\n    }\n  };\n}\nfunction isCamundaForm(element, formHelper) {\n  const formDefinition = formHelper.getFormDefinition(element);\n  const userTaskForm = formHelper.getUserTaskForm(element);\n  return formDefinition && userTaskForm;\n}\nfunction isCustomKey(element, formHelper) {\n  const formDefinition = formHelper.getFormDefinition(element);\n  const userTaskForm = formHelper.getUserTaskForm(element);\n  return formDefinition && !userTaskForm;\n}\n\nfunction Header(props) {\n  const {\n    idPrefix,\n    header\n  } = props;\n  const entries = [{\n    id: idPrefix + '-key',\n    component: KeyProperty,\n    header,\n    idPrefix\n  }, {\n    id: idPrefix + '-value',\n    component: ValueProperty$2,\n    header,\n    idPrefix\n  }];\n  return entries;\n}\nfunction KeyProperty(props) {\n  const {\n    idPrefix,\n    element,\n    header\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: header,\n      properties: {\n        key: value\n      }\n    });\n  };\n  const getValue = header => {\n    return header.key;\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: header,\n    id: idPrefix + '-key',\n    label: translate('Key'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ValueProperty$2(props) {\n  const {\n    idPrefix,\n    element,\n    header\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: header,\n      properties: {\n        value\n      }\n    });\n  };\n  const getValue = header => {\n    return header.value;\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: header,\n    id: idPrefix + '-value',\n    label: translate('Value'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\nfunction isZeebeServiceTask(element) {\n  if (!(0,ModelUtil.is)(element, 'zeebe:ZeebeServiceTask')) return false;\n  if ((0,ModelUtil.is)(element, 'bpmn:EndEvent') || (0,ModelUtil.is)(element, 'bpmn:IntermediateThrowEvent')) {\n    return !!getMessageEventDefinition(element);\n  }\n\n  // BusinessRuleTask and ScriptTask are ServiceTasks only if they have a TaskDefinition\n  // (ie. if the implementation is set to ==JobWorker)\n  if ((0,ModelUtil/* isAny */.JZ)(element, ['bpmn:BusinessRuleTask', 'bpmn:ScriptTask']) && !getTaskDefinition$2(element)) {\n    return false;\n  }\n  return true;\n}\nfunction isMessageEndEvent(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:EndEvent') && !!getMessageEventDefinition(element);\n}\nfunction isMessageThrowEvent(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:IntermediateThrowEvent') && !!getMessageEventDefinition(element);\n}\n\n// helper ////////////////\n\nfunction getTaskDefinition$2(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(businessObject, 'zeebe:TaskDefinition')[0];\n}\n\nfunction areHeadersSupported(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:UserTask') || isZeebeServiceTask(element);\n}\n\n/**\n * Get first zeebe:TaskHeaders element for a specific element.\n *\n * @param  {ModdleElement} element\n *\n * @return {ModdleElement} a zeebe:TaskHeader element\n */\nfunction getTaskHeaders$1(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(businessObject, 'zeebe:TaskHeaders')[0];\n}\n\n/**\n * Retrieve all zeebe:Header elements for a specific element.\n *\n * @param  {ModdleElement} element\n *\n * @return {Array<ModdleElement>} a list of zeebe:Header elements\n */\nfunction getHeaders(element) {\n  const taskHeaders = getTaskHeaders$1(element);\n  return taskHeaders ? taskHeaders.get('values') : [];\n}\n\nfunction HeaderProps({\n  element,\n  injector\n}) {\n  if (!areHeadersSupported(element)) {\n    return null;\n  }\n  const headers = getHeaders(element) || [];\n  const bpmnFactory = injector.get('bpmnFactory'),\n    commandStack = injector.get('commandStack');\n  const items = headers.map((header, index) => {\n    const id = element.id + '-header-' + index;\n    return {\n      id,\n      label: header.get('key') || '',\n      entries: Header({\n        idPrefix: id,\n        element,\n        header\n      }),\n      autoFocusEntry: id + '-key',\n      remove: removeFactory$c({\n        commandStack,\n        element,\n        header\n      })\n    };\n  });\n  return {\n    items,\n    add: addFactory$9({\n      bpmnFactory,\n      commandStack,\n      element\n    })\n  };\n}\nfunction removeFactory$c({\n  commandStack,\n  element,\n  header\n}) {\n  return function (event) {\n    event.stopPropagation();\n    let commands = [];\n    const taskHeaders = getTaskHeaders$1(element);\n    if (!taskHeaders) {\n      return;\n    }\n    const newTaskHeaders = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(taskHeaders.get('values'), header);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: taskHeaders,\n        properties: {\n          values: newTaskHeaders\n        }\n      }\n    });\n\n    // remove zeebe:TaskHeaders if there are no headers anymore\n    if (!newTaskHeaders.length) {\n      const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n        extensionElements = businessObject.get('extensionElements');\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), taskHeaders)\n          }\n        }\n      });\n    }\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n}\nfunction addFactory$9({\n  bpmnFactory,\n  commandStack,\n  element\n}) {\n  return function (event) {\n    event.stopPropagation();\n    let commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure zeebe:TaskHeaders\n    let taskHeaders = getTaskHeaders$1(element);\n    if (!taskHeaders) {\n      const parent = extensionElements;\n      taskHeaders = createElement('zeebe:TaskHeaders', {\n        values: []\n      }, parent, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), taskHeaders]\n          }\n        }\n      });\n    }\n\n    // (3) create header\n    const header = createElement('zeebe:Header', {}, taskHeaders, bpmnFactory);\n\n    // (4) add header to list\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: taskHeaders,\n        properties: {\n          values: [...taskHeaders.get('values'), header]\n        }\n      }\n    });\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n}\n\nfunction InputOutputParameter$1(props) {\n  const {\n    idPrefix,\n    parameter\n  } = props;\n  const entries = [{\n    id: idPrefix + '-target',\n    component: TargetProperty,\n    idPrefix,\n    parameter\n  }, {\n    id: idPrefix + '-source',\n    component: SourceProperty,\n    idPrefix,\n    parameter\n  }];\n  return entries;\n}\nfunction TargetProperty(props) {\n  const {\n    idPrefix,\n    element,\n    parameter\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: parameter,\n      properties: {\n        target: value\n      }\n    });\n  };\n  const getValue = parameter => {\n    return parameter.target;\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: parameter,\n    id: idPrefix + '-target',\n    label: translate((0,ModelUtil.is)(parameter, 'zeebe:Input') ? 'Local variable name' : 'Process variable name'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction SourceProperty(props) {\n  const {\n    idPrefix,\n    element,\n    parameter\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: parameter,\n      properties: {\n        source: value\n      }\n    });\n  };\n  const getValue = parameter => {\n    return parameter.source;\n  };\n  return FeelEntryWithContext({\n    bpmnElement: element,\n    element: parameter,\n    id: idPrefix + '-source',\n    label: translate('Variable assignment value'),\n    feel: 'required',\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\nfunction getElements$1(bo, type, prop) {\n  const elems = getExtensionElementsList(bo, type);\n  return !prop ? elems : (elems[0] || {})[prop] || [];\n}\nfunction getParameters$1(element, prop) {\n  const ioMapping = getIoMapping(element);\n  return ioMapping && ioMapping.get(prop) || [];\n}\n\n/**\n * Get a ioMapping from the business object\n *\n * @param {djs.model.Base} element\n *\n * @return {ModdleElement} the ioMapping object\n */\nfunction getIoMapping(element) {\n  const bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return (getElements$1(bo, 'zeebe:IoMapping') || [])[0];\n}\n\n/**\n * Return all input parameters existing in the business object, and\n * an empty array if none exist.\n *\n * @param  {djs.model.Base} element\n *\n * @return {Array} a list of input parameter objects\n */\nfunction getInputParameters$1(element) {\n  return getParameters$1.apply(this, [element, 'inputParameters']);\n}\n\n/**\n * Return all output parameters existing in the business object, and\n * an empty array if none exist.\n *\n * @param  {djs.model.Base} element\n *\n * @return {Array} a list of output parameter objects\n */\nfunction getOutputParameters$1(element) {\n  return getParameters$1.apply(this, [element, 'outputParameters']);\n}\nfunction areInputParametersSupported$1(element) {\n  return (0,ModelUtil/* isAny */.JZ)(element, ['bpmn:UserTask', 'bpmn:SubProcess', 'bpmn:CallActivity', 'bpmn:BusinessRuleTask', 'bpmn:ScriptTask']) || isZeebeServiceTask(element);\n}\nfunction areOutputParametersSupported$1(element) {\n  return (0,ModelUtil/* isAny */.JZ)(element, ['zeebe:ZeebeServiceTask', 'bpmn:UserTask', 'bpmn:SubProcess', 'bpmn:ReceiveTask', 'bpmn:CallActivity', 'bpmn:Event', 'bpmn:BusinessRuleTask']);\n}\nfunction createIOMapping(properties, parent, bpmnFactory) {\n  return createElement('zeebe:IoMapping', properties, parent, bpmnFactory);\n}\n\nfunction InputProps$1({\n  element,\n  injector\n}) {\n  if (!areInputParametersSupported$1(element)) {\n    return null;\n  }\n  const inputParameters = getInputParameters$1(element) || [];\n  const bpmnFactory = injector.get('bpmnFactory'),\n    commandStack = injector.get('commandStack');\n  const items = inputParameters.map((parameter, index) => {\n    const id = element.id + '-input-' + index;\n    return {\n      id,\n      label: parameter.get('target') || '',\n      entries: InputOutputParameter$1({\n        idPrefix: id,\n        element,\n        parameter\n      }),\n      autoFocusEntry: id + '-target',\n      remove: removeFactory$b({\n        commandStack,\n        element,\n        parameter\n      })\n    };\n  });\n  return {\n    items,\n    add: addFactory$8({\n      element,\n      bpmnFactory,\n      commandStack\n    })\n  };\n}\nfunction removeFactory$b({\n  commandStack,\n  element,\n  parameter\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const commands = [];\n    const ioMapping = getIoMapping(element);\n    if (!ioMapping) {\n      return;\n    }\n    const inputParameters = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(ioMapping.get('inputParameters'), parameter);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: ioMapping,\n        properties: {\n          inputParameters\n        }\n      }\n    });\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n      extensionElements = businessObject.get('extensionElements'),\n      values = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), ioMapping);\n\n    // remove ioMapping if there are no input/output parameters anymore\n    if (!inputParameters.length && !ioMapping.get('outputParameters').length) {\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values\n          }\n        }\n      });\n    }\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n}\nfunction addFactory$8({\n  element,\n  bpmnFactory,\n  commandStack\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure IoMapping\n    let ioMapping = getIoMapping(element);\n    if (!ioMapping) {\n      ioMapping = createIOMapping({\n        inputParameters: [],\n        outputParameters: []\n      }, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), ioMapping]\n          }\n        }\n      });\n    }\n\n    // (3) create parameter\n    const newParameter = createElement('zeebe:Input', {\n      source: '',\n      target: nextId('InputVariable_')\n    }, ioMapping, bpmnFactory);\n\n    // (4) add parameter to list\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: ioMapping,\n        properties: {\n          inputParameters: [...ioMapping.get('inputParameters'), newParameter]\n        }\n      }\n    });\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n}\n\nfunction MessageProps(props) {\n  const {\n    element\n  } = props;\n  const message = getMessage(element);\n  const entries = [];\n  if (message) {\n    entries.push({\n      id: 'messageName',\n      component: MessageName,\n      isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw\n    });\n  }\n  if (message && canHaveSubscriptionCorrelationKey(element)) {\n    entries.push({\n      id: 'messageSubscriptionCorrelationKey',\n      component: SubscriptionCorrelationKey,\n      isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw\n    });\n  }\n  return entries;\n}\nfunction MessageName(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const message = getMessage(element);\n  const getValue = () => {\n    return message.get('name');\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: message,\n      properties: {\n        name: value\n      }\n    });\n  };\n  return FeelEntryWithContext({\n    element,\n    id: 'messageName',\n    label: translate('Name'),\n    feel: 'optional',\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction SubscriptionCorrelationKey(props) {\n  const {\n    element\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return getCorrelationKey(element);\n  };\n  const setValue = value => {\n    const commands = [];\n    const message = getMessage(element);\n    let extensionElements = message.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, message, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: message,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure subscription\n    let subscription = getSubscription(element);\n    if (!subscription) {\n      subscription = createElement('zeebe:Subscription', {}, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), subscription]\n          }\n        }\n      });\n    }\n\n    // (3) update subscription correlation key\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: subscription,\n        properties: {\n          correlationKey: value\n        }\n      }\n    });\n\n    // (4) commit all updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return FeelEntryWithContext({\n    element,\n    id: 'messageSubscriptionCorrelationKey',\n    label: translate('Subscription correlation key'),\n    feel: 'required',\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper ///////////////////////\n\nfunction canHaveSubscriptionCorrelationKey(element) {\n  // (1) allow for receive task\n  if ((0,ModelUtil.is)(element, 'bpmn:ReceiveTask')) {\n    return true;\n  }\n\n  // (2) allow for non start events\n  if (!(0,ModelUtil.is)(element, 'bpmn:StartEvent')) {\n    return true;\n  }\n\n  // (3) allow for start events inside event sub processes\n  if ((0,ModelUtil.is)(element, 'bpmn:StartEvent') && (0,DiUtil/* isEventSubProcess */.J5)(element.parent)) {\n    return true;\n  }\n  return false;\n}\nfunction getCorrelationKey(element) {\n  const subscription = getSubscription(element);\n  return subscription ? subscription.get('correlationKey') : '';\n}\nfunction getSubscription(element) {\n  const message = getMessage(element);\n  const subscriptions = getSubscriptions(message);\n  return subscriptions[0];\n}\nfunction getSubscriptions(message) {\n  const extensionElements = getExtensionElementsList(message, 'zeebe:Subscription');\n  return extensionElements;\n}\n\nfunction MultiInstanceProps$1(props) {\n  const {\n    element\n  } = props;\n  if (!supportsMultiInstances(element)) {\n    return [];\n  }\n  return [{\n    id: 'multiInstance-inputCollection',\n    component: InputCollection,\n    isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw\n  }, {\n    id: 'multiInstance-inputElement',\n    component: InputElement,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'multiInstance-outputCollection',\n    component: OutputCollection,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'multiInstance-outputElement',\n    component: OutputElement,\n    isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw\n  }, {\n    id: 'multiInstance-completionCondition',\n    component: CompletionCondition,\n    isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw\n  }];\n}\nfunction InputCollection(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return getProperty$1(element, 'inputCollection');\n  };\n  const setValue = value => {\n    return setProperty(element, 'inputCollection', value, commandStack, bpmnFactory);\n  };\n  return FeelEntryWithContext({\n    element,\n    id: 'multiInstance-inputCollection',\n    label: translate('Input collection'),\n    feel: 'required',\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction InputElement(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return getProperty$1(element, 'inputElement');\n  };\n  const setValue = value => {\n    return setProperty(element, 'inputElement', value, commandStack, bpmnFactory);\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'multiInstance-inputElement',\n    label: translate('Input element'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction OutputCollection(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return getProperty$1(element, 'outputCollection');\n  };\n  const setValue = value => {\n    return setProperty(element, 'outputCollection', value, commandStack, bpmnFactory);\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'multiInstance-outputCollection',\n    label: translate('Output collection'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction OutputElement(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return getProperty$1(element, 'outputElement');\n  };\n  const setValue = value => {\n    return setProperty(element, 'outputElement', value, commandStack, bpmnFactory);\n  };\n  return FeelEntryWithContext({\n    element,\n    id: 'multiInstance-outputElement',\n    label: translate('Output element'),\n    feel: 'required',\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction CompletionCondition(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    const completionCondition = getCompletionCondition(element);\n    return completionCondition && completionCondition.get('body');\n  };\n  const setValue = value => {\n    if (value && value !== '') {\n      const loopCharacteristics = getLoopCharacteristics$1(element);\n      const completionCondition = createElement('bpmn:FormalExpression', {\n        body: value\n      }, loopCharacteristics, bpmnFactory);\n      setCompletionCondition(element, commandStack, completionCondition);\n    } else {\n      setCompletionCondition(element, commandStack, undefined);\n    }\n  };\n  return FeelEntryWithContext({\n    element,\n    id: 'multiInstance-completionCondition',\n    label: translate('Completion condition'),\n    feel: 'required',\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper ///////////////////////\n\nfunction getLoopCharacteristics$1(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return businessObject.get('loopCharacteristics');\n}\nfunction getZeebeLoopCharacteristics(loopCharacteristics) {\n  const extensionElements = getExtensionElementsList(loopCharacteristics, 'zeebe:LoopCharacteristics');\n  return extensionElements && extensionElements[0];\n}\nfunction supportsMultiInstances(element) {\n  return !!getLoopCharacteristics$1(element);\n}\nfunction getCompletionCondition(element) {\n  return getLoopCharacteristics$1(element).get('completionCondition');\n}\nfunction setCompletionCondition(element, commandStack, completionCondition = undefined) {\n  commandStack.execute('element.updateModdleProperties', {\n    element,\n    moddleElement: getLoopCharacteristics$1(element),\n    properties: {\n      completionCondition\n    }\n  });\n}\nfunction getProperty$1(element, propertyName) {\n  const loopCharacteristics = getLoopCharacteristics$1(element),\n    zeebeLoopCharacteristics = getZeebeLoopCharacteristics(loopCharacteristics);\n  return zeebeLoopCharacteristics && zeebeLoopCharacteristics.get(propertyName);\n}\nfunction setProperty(element, propertyName, value, commandStack, bpmnFactory) {\n  const loopCharacteristics = getLoopCharacteristics$1(element);\n  const commands = [];\n\n  // (1) ensure extension elements\n  let extensionElements = loopCharacteristics.get('extensionElements');\n  if (!extensionElements) {\n    extensionElements = createElement('bpmn:ExtensionElements', {\n      values: []\n    }, loopCharacteristics, bpmnFactory);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: loopCharacteristics,\n        properties: {\n          extensionElements\n        }\n      }\n    });\n  }\n\n  // (2) ensure zeebe loop characteristics\n  let zeebeLoopCharacteristics = getZeebeLoopCharacteristics(loopCharacteristics);\n  if (!zeebeLoopCharacteristics) {\n    zeebeLoopCharacteristics = createElement('zeebe:LoopCharacteristics', {}, extensionElements, bpmnFactory);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: extensionElements,\n        properties: {\n          values: [...extensionElements.get('values'), zeebeLoopCharacteristics]\n        }\n      }\n    });\n  }\n\n  // (3) update defined property\n  commands.push({\n    cmd: 'element.updateModdleProperties',\n    context: {\n      element,\n      moddleElement: zeebeLoopCharacteristics,\n      properties: {\n        [propertyName]: value\n      }\n    }\n  });\n\n  // (4) commit all updates\n  commandStack.execute('properties-panel.multi-command-executor', commands);\n}\n\nfunction getProcessId(element) {\n  const calledElement = getCalledElement(element);\n  return calledElement ? calledElement.get('processId') : '';\n}\nfunction getCalledElement(element) {\n  const calledElements = getCalledElements(element);\n  return calledElements[0];\n}\nfunction getCalledElements(element) {\n  const bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const extElements = getExtensionElementsList(bo, 'zeebe:CalledElement');\n  return extElements;\n}\n\nfunction OutputPropagationProps(props) {\n  const {\n    element\n  } = props;\n  if (!(0,ModelUtil.is)(element, 'bpmn:CallActivity')) {\n    return [];\n  }\n  return [{\n    id: 'propagateAllChildVariables',\n    component: PropagateAllChildVariables,\n    isEdited: properties_panel_dist_index_esm/* isToggleSwitchEntryEdited */.kH\n  }];\n}\nfunction PropagateAllChildVariables(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack'),\n    bpmnFactory = useService('bpmnFactory'),\n    translate = useService('translate');\n  const propagateAllChildVariables = isPropagateAllChildVariables(element);\n  const getValue = () => {\n    return propagateAllChildVariables;\n  };\n  const setValue = value => {\n    const commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n    // (1) ensure extension elements\n    let extensionElements = businessObject.get('extensionElements');\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure zeebe:calledElement\n    let calledElement = getCalledElement(businessObject);\n    if (!calledElement) {\n      calledElement = createElement('zeebe:CalledElement', {}, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), calledElement]\n          }\n        }\n      });\n    }\n\n    // (3) Update propagateAllChildVariables attribute\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: calledElement,\n        properties: {\n          propagateAllChildVariables: value\n        }\n      }\n    });\n\n    // (4) Execute the commands\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return (0,properties_panel_dist_index_esm/* ToggleSwitchEntry */.FH)({\n    id: 'propagateAllChildVariables',\n    label: translate('Propagate all child process variables'),\n    switcherLabel: propagateAllChildVariables ? translate('On') : translate('Off'),\n    description: propagateAllChildVariables ? translate('All variables from the child process instance will be propagated to the parent process instance') : translate('Only variables defined via output mappings will be propagated from the child to the parent process instance'),\n    getValue,\n    setValue\n  });\n}\n\n// helper //////////////////////////\n\n/**\n  * Determine default value for propagateAllChildVariables attribute\n  * @param {Object} element representing a bpmn:CallActivity\n  *\n  * @returns {boolean}\n  */\nfunction determinePropAllChildVariablesDefault(element) {\n  const outputParameters = getOutputParameters$1(element);\n  if (outputParameters) {\n    return outputParameters.length > 0 ? false : true;\n  }\n}\n\n/**\n  * Check whether the propagateAllChildVariables attribute is set on an element.\n  * Note that a default logic will be determine if it is not explicitly set.\n  * @param {Object} element\n  *\n  * @returns {boolean}\n  */\nfunction isPropagateAllChildVariables(element) {\n  if (!(0,ModelUtil.is)(element, 'bpmn:CallActivity')) {\n    return undefined;\n  }\n  const bo = (0,ModelUtil/* getBusinessObject */.SS)(element),\n    calledElement = getCalledElement(bo);\n  return calledElement && (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* has */.e$)(calledElement, 'propagateAllChildVariables') ? calledElement.get('propagateAllChildVariables') : determinePropAllChildVariablesDefault(element);\n}\n\nfunction OutputProps$1({\n  element,\n  injector\n}) {\n  if (!areOutputParametersSupported$1(element)) {\n    return null;\n  }\n  const outputParameters = getOutputParameters$1(element) || [];\n  const bpmnFactory = injector.get('bpmnFactory'),\n    commandStack = injector.get('commandStack');\n  const items = outputParameters.map((parameter, index) => {\n    const id = element.id + '-output-' + index;\n    return {\n      id,\n      label: parameter.get('target') || '',\n      entries: InputOutputParameter$1({\n        idPrefix: id,\n        element,\n        parameter\n      }),\n      autoFocusEntry: id + '-target',\n      remove: removeFactory$a({\n        commandStack,\n        element,\n        parameter\n      })\n    };\n  });\n  return {\n    items,\n    add: addFactory$7({\n      element,\n      bpmnFactory,\n      commandStack\n    })\n  };\n}\nfunction removeFactory$a({\n  commandStack,\n  element,\n  parameter\n}) {\n  return function (event) {\n    event.stopPropagation();\n    let commands = [];\n    const ioMapping = getIoMapping(element);\n    if (!ioMapping) {\n      return;\n    }\n    const outputParameters = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(ioMapping.get('outputParameters'), parameter);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: ioMapping,\n        properties: {\n          outputParameters\n        }\n      }\n    });\n\n    // remove ioMapping if there are no input/output parameters anymore\n    if (!ioMapping.get('inputParameters').length && !outputParameters.length) {\n      const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n        extensionElements = businessObject.get('extensionElements'),\n        values = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), ioMapping);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values\n          }\n        }\n      });\n    }\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n}\nfunction addFactory$7({\n  element,\n  bpmnFactory,\n  commandStack\n}) {\n  return function (event) {\n    event.stopPropagation();\n    let commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure IoMapping\n    let ioMapping = getIoMapping(element);\n    if (!ioMapping) {\n      const parent = extensionElements;\n      ioMapping = createIOMapping({\n        inputParameters: [],\n        outputParameters: []\n      }, parent, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), ioMapping]\n          }\n        }\n      });\n    }\n\n    // (3) create parameter\n    const newParameter = createElement('zeebe:Output', {\n      source: '',\n      target: nextId('OutputVariable_')\n    }, ioMapping, bpmnFactory);\n\n    // (4) add parameter to list\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: ioMapping,\n        properties: {\n          outputParameters: [...ioMapping.get('outputParameters'), newParameter]\n        }\n      }\n    });\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n}\n\nconst SCRIPT_IMPLEMENTATION_OPTION = 'script',\n  JOB_WORKER_IMPLEMENTATION_OPTION = 'jobWorker',\n  DEFAULT_IMPLEMENTATION_OPTION = '';\nfunction ScriptImplementationProps(props) {\n  const {\n    element\n  } = props;\n  if (!(0,ModelUtil.is)(element, 'bpmn:ScriptTask')) {\n    return [];\n  }\n  return [{\n    id: 'scriptImplementation',\n    component: ScriptImplementation,\n    isEdited: () => isScriptImplementationEdited(element)\n  }];\n}\nfunction ScriptImplementation(props) {\n  const {\n    element,\n    id\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const getValue = () => {\n    if (getScript$1(element)) {\n      return SCRIPT_IMPLEMENTATION_OPTION;\n    }\n    if (getTaskDefinition$1(element)) {\n      return JOB_WORKER_IMPLEMENTATION_OPTION;\n    }\n    return DEFAULT_IMPLEMENTATION_OPTION;\n  };\n\n  /**\n   * Set value by either creating a zeebe:script or a zeebe:taskDefintion\n   * extension element. Note that they must not exist both at the same time, however\n   * this will be ensured by a bpmn-js behavior (and not by the propPanel).\n   */\n  const setValue = value => {\n    let extensionElement, extensionElementType;\n    if (value === SCRIPT_IMPLEMENTATION_OPTION) {\n      extensionElement = getScript$1(element);\n      extensionElementType = 'zeebe:Script';\n    } else if (value === JOB_WORKER_IMPLEMENTATION_OPTION) {\n      extensionElement = getTaskDefinition$1(element);\n      extensionElementType = 'zeebe:TaskDefinition';\n    } else {\n      resetElement(element, commandStack);\n    }\n    if (!extensionElement && extensionElementType) {\n      extensionElement = createElement(extensionElementType, {}, null, bpmnFactory);\n      updateExtensionElements(element, extensionElement, bpmnFactory, commandStack);\n    }\n  };\n  const getOptions = () => {\n    const options = [{\n      value: DEFAULT_IMPLEMENTATION_OPTION,\n      label: translate('<none>')\n    }, {\n      value: SCRIPT_IMPLEMENTATION_OPTION,\n      label: translate('FEEL expression')\n    }, {\n      value: JOB_WORKER_IMPLEMENTATION_OPTION,\n      label: translate('Job worker')\n    }];\n    return options;\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element,\n    id,\n    label: translate('Implementation'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\n\n// helper ///////////////////////\n\nfunction getTaskDefinition$1(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(businessObject, 'zeebe:TaskDefinition')[0];\n}\nfunction getScript$1(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(businessObject, 'zeebe:Script')[0];\n}\nfunction getTaskHeaders(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(businessObject, 'zeebe:TaskHeaders');\n}\nfunction isScriptImplementationEdited(element) {\n  return getTaskDefinition$1(element) || getScript$1(element);\n}\nfunction resetElement(element, commandStack) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const taskDefinition = getTaskDefinition$1(element);\n  const taskHeaders = getTaskHeaders(element);\n  const script = getScript$1(element);\n  if (taskDefinition) {\n    const removed = [taskDefinition, taskHeaders].filter(Boolean);\n    removeExtensionElements(element, businessObject, removed, commandStack);\n    return;\n  }\n  if (script) {\n    removeExtensionElements(element, businessObject, script, commandStack);\n  }\n}\nfunction updateExtensionElements(element, extensionElementToAdd, bpmnFactory, commandStack) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const commands = [];\n  let extensionElements = businessObject.get('extensionElements');\n  let extensionElementValues;\n\n  // (1) create bpmn:ExtensionElements if it doesn't exist\n  if (!extensionElements) {\n    extensionElements = createElement('bpmn:ExtensionElements', {\n      values: []\n    }, businessObject, bpmnFactory);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: businessObject,\n        properties: {\n          extensionElements\n        }\n      }\n    });\n  }\n  extensionElementToAdd.$parent = extensionElements;\n\n  // (2) remove old exension element from extensionElements\n  if ((0,ModelUtil.is)(extensionElementToAdd, 'zeebe:TaskDefinition')) {\n    extensionElementValues = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), getScript$1(element));\n  } else if ((0,ModelUtil.is)(extensionElementToAdd, 'zeebe:Script')) {\n    const matcher = extension => (0,ModelUtil/* isAny */.JZ)(extension, ['zeebe:TaskDefinition', 'zeebe:TaskHeaders']);\n    extensionElementValues = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), matcher);\n  }\n\n  // (3) add extension element to list\n  commands.push({\n    cmd: 'element.updateModdleProperties',\n    context: {\n      element,\n      moddleElement: extensionElements,\n      properties: {\n        values: [...extensionElementValues, extensionElementToAdd]\n      }\n    }\n  });\n  commandStack.execute('properties-panel.multi-command-executor', commands);\n}\n\nfunction ScriptProps$1(props) {\n  const {\n    element\n  } = props;\n  if (!(0,ModelUtil.is)(element, 'bpmn:ScriptTask') || !getScript(element)) {\n    return [];\n  }\n  return [{\n    id: 'scriptExpression',\n    component: Expression$3,\n    isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw\n  }, {\n    id: 'resultVariable',\n    component: ResultVariable$3,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n}\nfunction Expression$3(props) {\n  const {\n    element,\n    id\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (getScript(element) || {}).get('expression');\n  };\n  const setValue = value => {\n    const commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure script\n    let script = getScript(element);\n    if (!script) {\n      script = createElement('zeebe:Script', {}, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), script]\n          }\n        }\n      });\n    }\n\n    // (3) update script.expression\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: script,\n        properties: {\n          expression: value\n        }\n      }\n    });\n\n    // (4) commit all updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return FeelEntryWithContext({\n    element,\n    id,\n    label: translate('FEEL expression'),\n    feel: 'required',\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ResultVariable$3(props) {\n  const {\n    element,\n    id\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (getScript(element) || {}).resultVariable;\n  };\n  const setValue = value => {\n    const commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure script\n    let script = getScript(element);\n    if (!script) {\n      script = createElement('zeebe:Script', {}, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), script]\n          }\n        }\n      });\n    }\n\n    // (3) update script.resultVariable\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: script,\n        properties: {\n          resultVariable: value\n        }\n      }\n    });\n\n    // (4) commit all updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id,\n    label: translate('Result variable'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper ///////////////////////\n\nfunction getScript(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(businessObject, 'zeebe:Script')[0];\n}\n\nfunction TargetProps(props) {\n  const {\n    element\n  } = props;\n  if (!(0,ModelUtil.is)(element, 'bpmn:CallActivity')) {\n    return [];\n  }\n  return [{\n    id: 'targetProcessId',\n    component: TargetProcessId,\n    isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw\n  }];\n}\nfunction TargetProcessId(props) {\n  const {\n    element,\n    id\n  } = props;\n  const commandStack = useService('commandStack'),\n    bpmnFactory = useService('bpmnFactory'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const getValue = () => {\n    return getProcessId(element);\n  };\n  const setValue = value => {\n    const commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n    // (1) ensure extension elements\n    let extensionElements = businessObject.get('extensionElements');\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure zeebe:calledElement\n    let calledElement = getCalledElement(businessObject);\n    if (!calledElement) {\n      calledElement = createElement('zeebe:CalledElement', {}, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), calledElement]\n          }\n        }\n      });\n    }\n\n    // (3) Update processId attribute\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: calledElement,\n        properties: {\n          processId: value\n        }\n      }\n    });\n\n    // (4) Execute the commands\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return FeelEntryWithContext({\n    element,\n    id,\n    label: translate('Process ID'),\n    feel: 'optional',\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\nfunction TaskDefinitionProps(props) {\n  const {\n    element\n  } = props;\n  if (!isZeebeServiceTask(element)) {\n    return [];\n  }\n  return [{\n    id: 'taskDefinitionType',\n    component: TaskDefinitionType,\n    isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw\n  }, {\n    id: 'taskDefinitionRetries',\n    component: TaskDefinitionRetries,\n    isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw\n  }];\n}\nfunction TaskDefinitionType(props) {\n  const {\n    element,\n    id\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (getTaskDefinition(element) || {}).type;\n  };\n  const setValue = value => {\n    const commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure task definition\n    let taskDefinition = getTaskDefinition(element);\n    if (!taskDefinition) {\n      taskDefinition = createElement('zeebe:TaskDefinition', {}, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), taskDefinition]\n          }\n        }\n      });\n    }\n\n    // (3) update task definition type\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: taskDefinition,\n        properties: {\n          type: value\n        }\n      }\n    });\n\n    // (4) commit all updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return FeelEntryWithContext({\n    element,\n    id,\n    label: translate('Type'),\n    feel: 'optional',\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction TaskDefinitionRetries(props) {\n  const {\n    element,\n    id\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (getTaskDefinition(element) || {}).retries;\n  };\n  const setValue = value => {\n    let commands = [];\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure task definition\n    let taskDefinition = getTaskDefinition(element);\n    if (!taskDefinition) {\n      taskDefinition = createElement('zeebe:TaskDefinition', {}, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), taskDefinition]\n          }\n        }\n      });\n    }\n\n    // (3) update task definition retries\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: taskDefinition,\n        properties: {\n          retries: value\n        }\n      }\n    });\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return FeelEntryWithContext({\n    element,\n    id,\n    label: translate('Retries'),\n    feel: 'optional',\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper ///////////////////////\n\nfunction getTaskDefinition(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(businessObject, 'zeebe:TaskDefinition')[0];\n}\n\nfunction TimerProps$1(props) {\n  const {\n    element,\n    injector\n  } = props;\n  const translate = injector.get('translate');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n    timerEventDefinition = getTimerEventDefinition(businessObject),\n    timerEventDefinitionType = getTimerDefinitionType(timerEventDefinition);\n\n  // (1) Only show for supported elements\n  if (!isTimerSupported(element)) {\n    return [];\n  }\n  const timerOptions = getTimerOptions(element, translate);\n  const singleOption = timerOptions.length === 1;\n  const entries = [];\n  if (!singleOption) {\n    entries.push({\n      id: 'timerEventDefinitionType',\n      component: TimerEventDefinitionType$1,\n      isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD,\n      options: timerOptions\n    });\n  }\n  if (timerEventDefinitionType || singleOption) {\n    entries.push({\n      id: 'timerEventDefinitionValue',\n      component: TimerEventDefinitionValue$1,\n      isEdited: properties_panel_dist_index_esm/* isFeelEntryEdited */.cw,\n      label: singleOption ? timerOptions[0].label : undefined,\n      timerEventDefinitionType: timerEventDefinitionType || timerOptions[0].value\n    });\n  }\n  return entries;\n}\nfunction getTimerOptions(element, translate) {\n  const options = [];\n  if (isTimerDefinitionTypeSupported('timeDate', element)) {\n    options.push({\n      value: 'timeDate',\n      label: translate('Date')\n    });\n  }\n  if (isTimerDefinitionTypeSupported('timeDuration', element)) {\n    options.push({\n      value: 'timeDuration',\n      label: translate('Duration')\n    });\n  }\n  if (isTimerDefinitionTypeSupported('timeCycle', element)) {\n    options.push({\n      value: 'timeCycle',\n      label: translate('Cycle')\n    });\n  }\n  return options;\n}\n\n/**\n * TimerEventDefinitionType - Generic select entry allowing to select a specific\n * timerEventDefintionType. To be used together with timerEventDefinitionValue.\n *\n * @param  {type} props\n * @return {SelectEntry}\n */\nfunction TimerEventDefinitionType$1(props) {\n  const {\n    element,\n    options\n  } = props;\n  const commandStack = useService('commandStack'),\n    bpmnFactory = useService('bpmnFactory'),\n    translate = useService('translate');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n    timerEventDefinition = getTimerEventDefinition(businessObject),\n    timerEventDefinitionType = getTimerDefinitionType(timerEventDefinition);\n  const getValue = () => {\n    return timerEventDefinitionType || '';\n  };\n  const setValue = value => {\n    // (1) Check if value is different to current type\n    if (value === timerEventDefinitionType) {\n      return;\n    }\n\n    // (2) Create empty formalExpression element\n    const formalExpression = createTimerFormalExpression(bpmnFactory, timerEventDefinition);\n\n    // (3) Set the value for selected timerEventDefinitionType\n    const newProps = {\n      timeDuration: undefined,\n      timeDate: undefined,\n      timeCycle: undefined\n    };\n    if (value !== '') {\n      newProps[value] = formalExpression;\n    }\n\n    // (4) Execute businessObject update\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: timerEventDefinition,\n      properties: newProps\n    });\n  };\n  const getOptions = element => {\n    return [{\n      value: '',\n      label: translate('<none>')\n    }, ...options];\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element,\n    id: 'timerEventDefinitionType',\n    label: translate('Type'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\n\n/**\n * TimerEventDefinitionValue - Generic textField entry allowing to specify the\n * timerEventDefintionValue based on the set timerEventDefintionType. To be used\n * together with timerEventDefinitionType.\n *\n * @param {object} props\n * @param {ModdleElement} props.element\n * @param {'timeCycle'|'timeDate'|'timeDuration'} props.timerEventDefinitionType?\n * @param {string} props.label?\n * @return {TextFieldEntry}\n */\nfunction TimerEventDefinitionValue$1(props) {\n  const {\n    element,\n    label,\n    timerEventDefinitionType\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput'),\n    bpmnFactory = useService('bpmnFactory');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n    timerEventDefinition = getTimerEventDefinition(businessObject),\n    timerEventFormalExpression = timerEventDefinition.get(timerEventDefinitionType);\n\n  // TODO(@barmac): remove with next major release\n  // support `timerEventDefinitionDurationValue` for backwards compatibility\n  const legacyId = getLegacyId(element);\n  const getValue = () => {\n    return timerEventFormalExpression && timerEventFormalExpression.get('body');\n  };\n  const setValue = value => {\n    if (!timerEventFormalExpression) {\n      const expression = createTimerFormalExpression(bpmnFactory, timerEventDefinition);\n      expression.set('body', value);\n      commandStack.execute('element.updateModdleProperties', {\n        element,\n        moddleElement: timerEventDefinition,\n        properties: {\n          [timerEventDefinitionType]: expression\n        }\n      });\n      return;\n    }\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: timerEventFormalExpression,\n      properties: {\n        body: value\n      }\n    });\n  };\n  return FeelEntryWithContext({\n    element,\n    id: legacyId || 'timerEventDefinitionValue',\n    label: label || translate('Value'),\n    feel: 'optional',\n    getValue,\n    setValue,\n    debounce,\n    description: getTimerEventDefinitionValueDescription$1(timerEventDefinitionType, translate)\n  });\n}\n\n// helper //////////////////////////\n\n/**\n * isTimerDefinitionTypeSupported - Checks whether a given timerDefinitionType\n * is supported for a given element\n *\n * @param  {string} timerDefinitionType\n * @param  {ModdleElement} element\n *\n * @return {boolean}\n */\nfunction isTimerDefinitionTypeSupported(timerDefinitionType, element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  switch (timerDefinitionType) {\n    case 'timeDate':\n      if ((0,ModelUtil.is)(element, 'bpmn:StartEvent')) {\n        return true;\n      }\n      return false;\n    case 'timeCycle':\n      if ((0,ModelUtil.is)(element, 'bpmn:StartEvent') && !isInterruptingStartEvent(businessObject)) {\n        return true;\n      }\n      if ((0,ModelUtil.is)(element, 'bpmn:BoundaryEvent') && !businessObject.cancelActivity) {\n        return true;\n      }\n      return false;\n    case 'timeDuration':\n      if ((0,ModelUtil.is)(element, 'bpmn:IntermediateCatchEvent')) {\n        return true;\n      }\n      if ((0,ModelUtil.is)(element, 'bpmn:BoundaryEvent')) {\n        return true;\n      }\n      return false;\n    default:\n      return undefined;\n  }\n}\nfunction createTimerFormalExpression(bpmnFactory, eventDefinition) {\n  const formalExpression = bpmnFactory.create('bpmn:FormalExpression', {\n    body: undefined\n  });\n  formalExpression.$parent = eventDefinition;\n  return formalExpression;\n}\nfunction getTimerEventDefinitionValueDescription$1(timerDefinitionType, translate) {\n  switch (timerDefinitionType) {\n    case 'timeDate':\n      return (0,jsxRuntime_module/* jsxs */.BX)(\"div\", {\n        children: [(0,jsxRuntime_module/* jsx */.tZ)(\"p\", {\n          children: translate('A specific point in time defined as ISO 8601 combined date and time representation.')\n        }), (0,jsxRuntime_module/* jsxs */.BX)(\"ul\", {\n          children: [(0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"2019-10-01T12:00:00Z\"\n            }), \" - \", translate('UTC time')]\n          }), (0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"2019-10-02T08:09:40+02:00\"\n            }), \" - \", translate('UTC plus 2 hours zone offset')]\n          })]\n        }), (0,jsxRuntime_module/* jsx */.tZ)(\"a\", {\n          href: \"https://docs.camunda.io/docs/reference/bpmn-processes/timer-events/timer-events#time-date\",\n          target: \"_blank\",\n          rel: \"noopener\",\n          title: translate('Timer documentation'),\n          children: translate('How to configure a timer')\n        })]\n      });\n    case 'timeCycle':\n      return (0,jsxRuntime_module/* jsxs */.BX)(\"div\", {\n        children: [(0,jsxRuntime_module/* jsx */.tZ)(\"p\", {\n          children: translate('A cycle defined as ISO 8601 repeating intervals format, or a cron expression.')\n        }), (0,jsxRuntime_module/* jsxs */.BX)(\"ul\", {\n          children: [(0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"R5/PT10S\"\n            }), \" - \", translate('every 10 seconds, up to 5 times')]\n          }), (0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"R/P1D\"\n            }), \" - \", translate('every day, infinitely')]\n          }), (0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"0 0 9-17 * * MON-FRI\"\n            }), \" - \", translate('every hour on the hour from 9-5 p.m. UTC Monday-Friday')]\n          })]\n        }), (0,jsxRuntime_module/* jsx */.tZ)(\"a\", {\n          href: \"https://docs.camunda.io/docs/reference/bpmn-processes/timer-events/timer-events#time-cycle\",\n          target: \"_blank\",\n          rel: \"noopener\",\n          title: translate('Timer documentation'),\n          children: translate('How to configure a timer')\n        })]\n      });\n    case 'timeDuration':\n      return (0,jsxRuntime_module/* jsxs */.BX)(\"div\", {\n        children: [(0,jsxRuntime_module/* jsx */.tZ)(\"p\", {\n          children: translate('A time duration defined as ISO 8601 durations format.')\n        }), (0,jsxRuntime_module/* jsxs */.BX)(\"ul\", {\n          children: [(0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"PT15S\"\n            }), \" - \", translate('15 seconds')]\n          }), (0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"PT1H30M\"\n            }), \" - \", translate('1 hour and 30 minutes')]\n          }), (0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"P14D\"\n            }), \" - \", translate('14 days')]\n          })]\n        }), (0,jsxRuntime_module/* jsx */.tZ)(\"a\", {\n          href: \"https://docs.camunda.io/docs/reference/bpmn-processes/timer-events/timer-events#time-duration\",\n          target: \"_blank\",\n          rel: \"noopener\",\n          title: translate('Timer documentation'),\n          children: translate('How to configure a timer')\n        })]\n      });\n  }\n}\nfunction isInterruptingStartEvent(bo) {\n  return isInEventSubProcess$1(bo) && bo.get('isInterrupting') !== false;\n}\nfunction isInEventSubProcess$1(bo) {\n  const parent = bo.$parent;\n  return (0,ModelUtil.is)(parent, 'bpmn:SubProcess') && parent.triggeredByEvent;\n}\nfunction getLegacyId(event) {\n  if ((0,ModelUtil.is)(event, 'bpmn:IntermediateCatchEvent') || isInterruptingBoundaryEvent(event)) {\n    return 'timerEventDefinitionDurationValue';\n  }\n}\nfunction isInterruptingBoundaryEvent(event) {\n  const bo = (0,ModelUtil/* getBusinessObject */.SS)(event);\n  return (0,ModelUtil.is)(bo, 'bpmn:BoundaryEvent') && bo.get('cancelActivity') !== false;\n}\n\nfunction ExtensionProperty(props) {\n  const {\n    idPrefix,\n    property\n  } = props;\n  const entries = [{\n    id: idPrefix + '-name',\n    component: NameProperty$1,\n    idPrefix,\n    property\n  }, {\n    id: idPrefix + '-value',\n    component: ValueProperty$1,\n    idPrefix,\n    property\n  }];\n  return entries;\n}\nfunction NameProperty$1(props) {\n  const {\n    idPrefix,\n    element,\n    property\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: property,\n      properties: {\n        name: value\n      }\n    });\n  };\n  const getValue = () => {\n    return property.name;\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: property,\n    id: idPrefix + '-name',\n    label: translate('Name'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ValueProperty$1(props) {\n  const {\n    idPrefix,\n    element,\n    property\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: property,\n      properties: {\n        value\n      }\n    });\n  };\n  const getValue = () => {\n    return property.value;\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: property,\n    id: idPrefix + '-value',\n    label: translate('Value'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\nfunction ExtensionPropertiesProps({\n  element,\n  injector,\n  namespace = 'camunda'\n}) {\n  if (namespace === 'zeebe' && !(0,ModelUtil.is)(element, 'zeebe:PropertiesHolder')) {\n    return [];\n  }\n  let businessObject = getRelevantBusinessObject(element);\n\n  // do not offer for empty pools\n  if (!businessObject) {\n    return;\n  }\n  const properties = getPropertiesList(businessObject, namespace) || [];\n  const bpmnFactory = injector.get('bpmnFactory'),\n    commandStack = injector.get('commandStack');\n  const items = properties.map((property, index) => {\n    const id = element.id + '-extensionProperty-' + index;\n    return {\n      id,\n      label: property.get('name') || '',\n      entries: ExtensionProperty({\n        idPrefix: id,\n        element,\n        property\n      }),\n      autoFocusEntry: id + '-name',\n      remove: removeFactory$9({\n        commandStack,\n        element,\n        property,\n        namespace\n      })\n    };\n  });\n  return {\n    items,\n    add: addFactory$6({\n      bpmnFactory,\n      commandStack,\n      element,\n      namespace\n    })\n  };\n}\nfunction removeFactory$9({\n  commandStack,\n  element,\n  property,\n  namespace\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const commands = [];\n    const businessObject = getRelevantBusinessObject(element);\n    const properties = getProperties(businessObject, namespace);\n    if (!properties) {\n      return;\n    }\n    const propertyName = getPropertyName(namespace);\n    const values = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(properties.get(propertyName), property);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: properties,\n        properties: {\n          [propertyName]: values\n        }\n      }\n    });\n\n    // remove camunda:Properties if there are no properties anymore\n    if (!values.length) {\n      const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n        extensionElements = businessObject.get('extensionElements');\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), properties)\n          }\n        }\n      });\n    }\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n}\nfunction addFactory$6({\n  bpmnFactory,\n  commandStack,\n  element,\n  namespace\n}) {\n  return function (event) {\n    event.stopPropagation();\n    let commands = [];\n    const businessObject = getRelevantBusinessObject(element);\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n    const propertyName = getPropertyName(namespace);\n\n    // (2) ensure camunda:Properties\n    let properties = getProperties(businessObject, namespace);\n    if (!properties) {\n      const parent = extensionElements;\n      properties = createElement(`${namespace}:Properties`, {\n        [propertyName]: []\n      }, parent, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), properties]\n          }\n        }\n      });\n    }\n\n    // (3) create camunda:Property\n    const property = createElement(`${namespace}:Property`, {}, properties, bpmnFactory);\n\n    // (4) add property to list\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: properties,\n        properties: {\n          [propertyName]: [...properties.get(propertyName), property]\n        }\n      }\n    });\n\n    // (5) commit all updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n}\n\n// helper //////////////////\n\nfunction getRelevantBusinessObject(element) {\n  let businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if ((0,ModelUtil.is)(element, 'bpmn:Participant')) {\n    return businessObject.get('processRef');\n  }\n  return businessObject;\n}\nfunction getPropertyName(namespace = 'camunda') {\n  if (namespace === 'zeebe') {\n    return 'properties';\n  }\n  return 'values';\n}\nfunction getProperties(element, namespace = 'camunda') {\n  return getExtensionElementsList((0,ModelUtil/* getBusinessObject */.SS)(element), `${namespace}:Properties`)[0];\n}\nfunction getPropertiesList(element, namespace = 'camunda') {\n  const properties = getProperties((0,ModelUtil/* getBusinessObject */.SS)(element), namespace);\n  return properties && properties.get(getPropertyName(namespace));\n}\n\nconst LOW_PRIORITY$1 = 500;\nconst ZEEBE_GROUPS = [BusinessRuleImplementationGroup, CalledDecisionGroup, ScriptImplementationGroup, ScriptGroup$1, TaskDefinitionGroup, AssignmentDefinitionGroup, FormGroup$1, ConditionGroup$1, TargetGroup, InputGroup$1, OutputPropagationGroup, OutputGroup$1, HeaderGroup, ExtensionPropertiesGroup$1];\nclass ZeebePropertiesProvider$1 {\n  constructor(propertiesPanel, injector) {\n    propertiesPanel.registerProvider(LOW_PRIORITY$1, this);\n    this._injector = injector;\n  }\n  getGroups(element) {\n    return groups => {\n      // (1) add zeebe specific groups\n      groups = groups.concat(this._getGroups(element));\n\n      // (2) update existing groups with zeebe specific properties\n      updateMessageGroup(groups, element);\n      updateTimerGroup$1(groups, element, this._injector);\n      updateMultiInstanceGroup$1(groups, element);\n\n      // (3) remove message group when not applicable\n      groups = removeMessageGroup(groups, element);\n      return groups;\n    };\n  }\n  _getGroups(element) {\n    const groups = ZEEBE_GROUPS.map(createGroup => createGroup(element, this._injector));\n    return groups.filter(group => group !== null);\n  }\n}\nZeebePropertiesProvider$1.$inject = ['propertiesPanel', 'injector'];\nfunction CalledDecisionGroup(element) {\n  const group = {\n    id: 'calledDecision',\n    label: 'Called decision',\n    entries: [...CalledDecisionProps({\n      element\n    })],\n    component: properties_panel_dist_index_esm/* Group */.ZA\n  };\n  return group.entries.length ? group : null;\n}\nfunction ScriptGroup$1(element) {\n  const group = {\n    id: 'script',\n    label: 'Script',\n    entries: [...ScriptProps$1({\n      element\n    })],\n    component: properties_panel_dist_index_esm/* Group */.ZA\n  };\n  return group.entries.length ? group : null;\n}\nfunction TaskDefinitionGroup(element) {\n  const group = {\n    id: 'taskDefinition',\n    label: 'Task definition',\n    entries: [...TaskDefinitionProps({\n      element\n    })],\n    component: properties_panel_dist_index_esm/* Group */.ZA\n  };\n  return group.entries.length ? group : null;\n}\nfunction InputGroup$1(element, injector) {\n  const group = {\n    id: 'inputs',\n    label: 'Inputs',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...InputProps$1({\n      element,\n      injector\n    })\n  };\n  return group.items ? group : null;\n}\nfunction OutputGroup$1(element, injector) {\n  const group = {\n    id: 'outputs',\n    label: 'Outputs',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...OutputProps$1({\n      element,\n      injector\n    })\n  };\n  return group.items ? group : null;\n}\nfunction ConditionGroup$1(element) {\n  const group = {\n    id: 'condition',\n    label: 'Condition',\n    entries: [...ConditionProps$1({\n      element\n    })],\n    component: properties_panel_dist_index_esm/* Group */.ZA\n  };\n  return group.entries.length ? group : null;\n}\nfunction FormGroup$1(element, injector) {\n  const group = {\n    id: 'form',\n    label: 'Form',\n    entries: [...FormProps$1({\n      element,\n      injector\n    })],\n    component: properties_panel_dist_index_esm/* Group */.ZA\n  };\n  return group.entries.length ? group : null;\n}\nfunction TargetGroup(element) {\n  const group = {\n    id: 'calledElement',\n    label: 'Called element',\n    entries: [...TargetProps({\n      element\n    })],\n    component: properties_panel_dist_index_esm/* Group */.ZA\n  };\n  return group.entries.length ? group : null;\n}\nfunction HeaderGroup(element, injector) {\n  const group = {\n    id: 'headers',\n    label: 'Headers',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...HeaderProps({\n      element,\n      injector\n    })\n  };\n  return group.items ? group : null;\n}\nfunction OutputPropagationGroup(element) {\n  const group = {\n    id: 'outputPropagation',\n    label: 'Output propagation',\n    entries: [...OutputPropagationProps({\n      element\n    })],\n    component: properties_panel_dist_index_esm/* Group */.ZA\n  };\n  return group.entries.length ? group : null;\n}\nfunction BusinessRuleImplementationGroup(element) {\n  const group = {\n    id: 'businessRuleImplementation',\n    label: 'Implementation',\n    entries: [...BusinessRuleImplementationProps({\n      element\n    })],\n    component: properties_panel_dist_index_esm/* Group */.ZA\n  };\n  return group.entries.length ? group : null;\n}\nfunction ScriptImplementationGroup(element) {\n  const group = {\n    id: 'scriptImplementation',\n    label: 'Implementation',\n    entries: [...ScriptImplementationProps({\n      element\n    })],\n    component: properties_panel_dist_index_esm/* Group */.ZA\n  };\n  return group.entries.length ? group : null;\n}\nfunction AssignmentDefinitionGroup(element) {\n  const group = {\n    id: 'assignmentDefinition',\n    label: 'Assignment',\n    entries: [...AssignmentDefinitionProps({\n      element\n    })],\n    component: properties_panel_dist_index_esm/* Group */.ZA\n  };\n  return group.entries.length ? group : null;\n}\nfunction ExtensionPropertiesGroup$1(element, injector) {\n  const group = {\n    label: 'Extension properties',\n    id: 'Zeebe__ExtensionProperties',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...ExtensionPropertiesProps({\n      element,\n      injector,\n      namespace: 'zeebe'\n    })\n  };\n  if (group.items) {\n    return group;\n  }\n  return null;\n}\nfunction updateMessageGroup(groups, element) {\n  const messageGroup = findGroup$1(groups, 'message');\n  if (!messageGroup) {\n    return;\n  }\n  messageGroup.entries = overrideGenericEntries(messageGroup.entries, MessageProps({\n    element\n  }));\n}\n\n// overwrite bpmn generic timerEventDefinition group with zeebe-specific one\nfunction updateTimerGroup$1(groups, element, injector) {\n  const timerEventGroup = findGroup$1(groups, 'timer');\n  if (!timerEventGroup) {\n    return;\n  }\n  timerEventGroup.entries = [...TimerProps$1({\n    element,\n    injector\n  })];\n}\n\n// overwrite bpmn generic multiInstance group with zeebe-specific one\nfunction updateMultiInstanceGroup$1(groups, element) {\n  const multiInstanceGroup = findGroup$1(groups, 'multiInstance');\n  if (!multiInstanceGroup) {\n    return;\n  }\n  multiInstanceGroup.entries = [...MultiInstanceProps$1({\n    element\n  })];\n}\n\n// remove message group from Message End Event & Message Throw Event\nfunction removeMessageGroup(groups, element) {\n  const messageGroup = findGroup$1(groups, 'message');\n  if (isMessageEndEvent(element) || isMessageThrowEvent(element)) {\n    groups = groups.filter(g => g != messageGroup);\n  }\n  return groups;\n}\n\n// helper /////////////////////\n\nfunction findGroup$1(groups, id) {\n  return groups.find(g => g.id === id);\n}\n\n/**\n * Replace generic bpmn components with specific zeebe ones.\n *\n * @param {Array} oldEntries\n * @param {Array} newEntries\n * @returns {Array} combined entries\n */\nfunction overrideGenericEntries(oldEntries, newEntries) {\n  const filteredEntries = oldEntries.filter(oldEntry => !newEntries.find(newEntry => newEntry.id === oldEntry.id));\n  return [...filteredEntries, ...newEntries];\n}\n\nvar zeebePropertiesProviderModule = {\n  __init__: ['zeebePropertiesProvider'],\n  zeebePropertiesProvider: ['type', ZeebePropertiesProvider$1]\n};\n\nfunction AsynchronousContinuationsProps(props) {\n  const {\n    element\n  } = props;\n  const checkboxIsEditedInverted = node => {\n    return node && !node.checked;\n  };\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const entries = [];\n  if ((0,ModelUtil.is)(element, 'camunda:AsyncCapable')) {\n    entries.push({\n      id: 'asynchronousContinuationBefore',\n      component: AsynchronousContinuationBefore,\n      isEdited: properties_panel_dist_index_esm/* isCheckboxEntryEdited */.kv\n    }, {\n      id: 'asynchronousContinuationAfter',\n      component: AsynchronousContinuationAfter,\n      isEdited: properties_panel_dist_index_esm/* isCheckboxEntryEdited */.kv\n    });\n    if (isAsyncBefore$2(businessObject) || isAsyncAfter$2(businessObject)) {\n      entries.push({\n        id: 'exclusive',\n        component: Exclusive,\n        isEdited: checkboxIsEditedInverted\n      });\n    }\n  }\n  return entries;\n}\nfunction AsynchronousContinuationBefore(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return isAsyncBefore$2(businessObject);\n  };\n  const setValue = value => {\n    // overwrite the legacy `async` property, we will use the more explicit `asyncBefore`\n    const props = {\n      'camunda:asyncBefore': value,\n      'camunda:async': undefined\n    };\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: props\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* CheckboxEntry */.IN)({\n    element,\n    id: 'asynchronousContinuationBefore',\n    label: translate('Before'),\n    getValue,\n    setValue\n  });\n}\nfunction AsynchronousContinuationAfter(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return isAsyncAfter$2(businessObject);\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:asyncAfter': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* CheckboxEntry */.IN)({\n    element,\n    id: 'asynchronousContinuationAfter',\n    label: translate('After'),\n    getValue,\n    setValue\n  });\n}\nfunction Exclusive(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return isExclusive$1(businessObject);\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:exclusive': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* CheckboxEntry */.IN)({\n    element,\n    id: 'exclusive',\n    label: translate('Exclusive'),\n    getValue,\n    setValue\n  });\n}\n\n// helper //////////////////\n\n/**\n * Returns true if the attribute 'camunda:asyncBefore' is set\n * to true.\n *\n * @param  {ModdleElement} bo\n *\n * @return {boolean} a boolean value\n */\nfunction isAsyncBefore$2(bo) {\n  return !!(bo.get('camunda:asyncBefore') || bo.get('camunda:async'));\n}\n\n/**\n * Returns true if the attribute 'camunda:asyncAfter' is set\n * to true.\n *\n * @param  {ModdleElement} bo\n *\n * @return {boolean} a boolean value\n */\nfunction isAsyncAfter$2(bo) {\n  return !!bo.get('camunda:asyncAfter');\n}\n\n/**\n * Returns true if the attribute 'camunda:exclusive' is set\n * to true.\n *\n * @param  {ModdleElement} bo\n *\n * @return {boolean} a boolean value\n */\nfunction isExclusive$1(bo) {\n  return !!bo.get('camunda:exclusive');\n}\n\nconst EMPTY_OPTION$1 = '';\nfunction BusinessKeyProps$1(props) {\n  const {\n    element\n  } = props;\n  if (!(0,ModelUtil.is)(element, 'bpmn:StartEvent') || !hasFormFields(element)) {\n    return [];\n  }\n  return [{\n    id: 'businessKey',\n    component: BusinessKey$1,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  }];\n}\nfunction BusinessKey$1(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const formData = getFormData$2(element);\n  const getValue = () => {\n    return formData.get('camunda:businessKey') || '';\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: formData,\n      properties: {\n        'camunda:businessKey': value\n      }\n    });\n  };\n  const getOptions = () => {\n    const options = [{\n      value: EMPTY_OPTION$1,\n      label: translate('<none>')\n    }];\n    const fields = formData.get('fields');\n    fields.forEach(field => {\n      const id = field.get('camunda:id');\n      if (id) {\n        options.push({\n          value: id,\n          label: id\n        });\n      }\n    });\n    return options;\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element,\n    id: 'businessKey',\n    label: translate('Key'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\n\n// helper ///////////////////\n\nfunction getFormData$2(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(businessObject, 'camunda:FormData')[0];\n}\nfunction hasFormFields(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const formData = getFormData$2(businessObject);\n  return formData && formData.get('camunda:fields').length;\n}\n\nfunction CalledBpmnProps(props) {\n  const {\n    element\n  } = props;\n  const entries = [{\n    id: 'calledElement',\n    component: CalledElement,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'calledElementBinding',\n    component: CalledElementBinding,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  }, {\n    id: 'calledElementTenantId',\n    component: CalledElementTenantId,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n  const binding = (0,ModelUtil/* getBusinessObject */.SS)(element).get('camunda:calledElementBinding');\n  if (binding === 'version') {\n    entries.splice(-1, 0, {\n      id: 'calledElementVersion',\n      component: CalledElementVersion,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  } else if (binding === 'versionTag') {\n    entries.splice(-1, 0, {\n      id: 'calledElementVersionTag',\n      component: CalledElementVersionTag,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n  return entries;\n}\nfunction CalledElement(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (0,ModelUtil/* getBusinessObject */.SS)(element).get('calledElement');\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      calledElement: value || ''\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: element,\n    id: \"calledElement\",\n    label: translate('Called element'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\nfunction CalledElementBinding(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const getValue = () => {\n    return (0,ModelUtil/* getBusinessObject */.SS)(element).get('camunda:calledElementBinding') || 'latest';\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      calledElementBinding: value === 'latest' ? undefined : value,\n      calledElementVersion: undefined,\n      calledElementVersionTag: undefined\n    });\n  };\n  const getOptions = () => [{\n    value: 'latest',\n    label: translate('latest')\n  }, {\n    value: 'deployment',\n    label: translate('deployment')\n  }, {\n    value: 'version',\n    label: translate('version')\n  }, {\n    value: 'versionTag',\n    label: translate('version tag')\n  }];\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* SelectEntry */.g0, {\n    element: element,\n    id: \"calledElementBinding\",\n    label: translate('Binding'),\n    getValue: getValue,\n    setValue: setValue,\n    getOptions: getOptions\n  });\n}\nfunction CalledElementVersion(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (0,ModelUtil/* getBusinessObject */.SS)(element).get('camunda:calledElementVersion');\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      calledElementVersion: value\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: element,\n    id: \"calledElementVersion\",\n    label: translate('Version'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\nfunction CalledElementVersionTag(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (0,ModelUtil/* getBusinessObject */.SS)(element).get('camunda:calledElementVersionTag');\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      calledElementVersionTag: value\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: element,\n    id: \"calledElementVersionTag\",\n    label: translate('Version tag'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\nfunction CalledElementTenantId(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (0,ModelUtil/* getBusinessObject */.SS)(element).get('camunda:calledElementTenantId');\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      calledElementTenantId: value\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: element,\n    id: \"calledElementTenantId\",\n    label: translate('Tenant ID'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\n\nfunction CalledCmmnProps(props) {\n  const {\n    element\n  } = props;\n  const entries = [{\n    id: 'calledElementCaseRef',\n    component: CaseRef,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'calledElementCaseBinding',\n    component: CaseBinding,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  }, {\n    id: 'calledElementCaseTenantId',\n    component: CaseTenantId,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n  if ((0,ModelUtil/* getBusinessObject */.SS)(element).get('camunda:caseBinding') === 'version') {\n    entries.splice(-1, 0, {\n      id: 'calledElementCaseVersion',\n      component: CaseVersion,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n  return entries;\n}\nfunction CaseRef(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (0,ModelUtil/* getBusinessObject */.SS)(element).get('camunda:caseRef');\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      caseRef: value || ''\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: element,\n    id: \"calledElementCaseRef\",\n    label: translate('Case ref'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\nfunction CaseBinding(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const getValue = () => {\n    return (0,ModelUtil/* getBusinessObject */.SS)(element).get('camunda:caseBinding') || 'latest';\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      caseBinding: value === 'latest' ? undefined : value,\n      caseVersion: undefined\n    });\n  };\n  const getOptions = () => [{\n    value: 'latest',\n    label: translate('latest')\n  }, {\n    value: 'deployment',\n    label: translate('deployment')\n  }, {\n    value: 'version',\n    label: translate('version')\n  }];\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* SelectEntry */.g0, {\n    element: element,\n    id: \"calledElementCaseBinding\",\n    label: translate('Binding'),\n    getValue: getValue,\n    setValue: setValue,\n    getOptions: getOptions\n  });\n}\nfunction CaseVersion(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (0,ModelUtil/* getBusinessObject */.SS)(element).get('camunda:caseVersion');\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      caseVersion: value\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: element,\n    id: \"calledElementCaseVersion\",\n    label: translate('Version'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\nfunction CaseTenantId(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (0,ModelUtil/* getBusinessObject */.SS)(element).get('camunda:caseTenantId');\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      caseTenantId: value\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: element,\n    id: \"calledElementCaseTenantId\",\n    label: translate('Tenant ID'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\n\nfunction DelegateVariableMappingProps(props) {\n  const {\n    element\n  } = props;\n  const entries = [{\n    id: 'calledElementDelegateVariableMappingType',\n    component: DelegateVariableMappingType,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  }];\n  const type = getDelegateVariableMappingType(element);\n  if (type === 'class') {\n    entries.push({\n      id: 'calledElementVariableMappingClass',\n      component: VariableMappingClass,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  } else if (type === 'delegateExpression') {\n    entries.push({\n      id: 'calledElementVariableMappingDelegateExpression',\n      component: VariableMappingDelegateExpression,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n  return entries;\n}\nconst DEFAULT_PROPS$5 = {\n  'camunda:variableMappingClass': undefined,\n  'camunda:variableMappingDelegateExpression': undefined\n};\nfunction DelegateVariableMappingType(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const getValue = () => {\n    return getDelegateVariableMappingType(element);\n  };\n  const setValue = value => {\n    const properties = {\n      ...DEFAULT_PROPS$5\n    };\n    if (value === 'class') {\n      properties['camunda:variableMappingClass'] = '';\n    } else if (value === 'delegateExpression') {\n      properties['camunda:variableMappingDelegateExpression'] = '';\n    }\n    commandStack.execute('element.updateProperties', {\n      element,\n      properties\n    });\n  };\n  const getOptions = () => [{\n    value: 'none',\n    label: translate('<none>')\n  }, {\n    value: 'class',\n    label: translate('Class')\n  }, {\n    value: 'delegateExpression',\n    label: translate('Delegate expression')\n  }];\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* SelectEntry */.g0, {\n    element: element,\n    id: \"calledElementDelegateVariableMappingType\",\n    label: translate('Delegate Variable Mapping'),\n    getValue: getValue,\n    setValue: setValue,\n    getOptions: getOptions\n  });\n}\nfunction VariableMappingDelegateExpression(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (0,ModelUtil/* getBusinessObject */.SS)(element).get('camunda:variableMappingDelegateExpression');\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      variableMappingDelegateExpression: value || '',\n      variableMappingClass: undefined\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: element,\n    id: \"calledElementVariableMappingDelegateExpression\",\n    label: translate('Delegate Expression'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\nfunction VariableMappingClass(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return (0,ModelUtil/* getBusinessObject */.SS)(element).get('camunda:variableMappingClass');\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      variableMappingDelegateExpression: undefined,\n      variableMappingClass: value || ''\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: element,\n    id: \"calledElementVariableMappingClass\",\n    label: translate('Delegate Class'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\n\n// helper /////\n\nfunction getDelegateVariableMappingType(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if (businessObject.get('camunda:variableMappingClass') !== undefined) {\n    return 'class';\n  } else if (businessObject.get('camunda:variableMappingDelegateExpression') !== undefined) {\n    return 'delegateExpression';\n  }\n  return 'none';\n}\n\nfunction CallActivityProps(props) {\n  const {\n    element\n  } = props;\n  if (!(0,ModelUtil.is)(element, 'bpmn:CallActivity')) {\n    return [];\n  }\n  const entries = [];\n  entries.push({\n    id: 'calledElementType',\n    component: CalledElementType,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  });\n  const calledElementType = getCalledElementType(element);\n  if (calledElementType === 'bpmn') {\n    entries.push(...CalledBpmnProps({\n      element\n    }), ...BusinessKeyProps({\n      element\n    }), ...DelegateVariableMappingProps({\n      element\n    }));\n  } else if (calledElementType === 'cmmn') {\n    entries.push(...CalledCmmnProps({\n      element\n    }), ...BusinessKeyProps({\n      element\n    }));\n  } else {\n    entries.push(...BusinessKeyProps({\n      element\n    }));\n  }\n  return entries;\n}\nconst DEFAULT_PROPS$4 = {\n  calledElement: undefined,\n  'camunda:calledElementBinding': undefined,\n  'camunda:calledElementVersion': undefined,\n  'camunda:calledElementTenantId': undefined,\n  'camunda:variableMappingClass': undefined,\n  'camunda:variableMappingDelegateExpression': undefined,\n  'camunda:caseRef': undefined,\n  'camunda:caseBinding': undefined,\n  'camunda:caseVersion': undefined,\n  'camunda:caseTenantId': undefined\n};\nconst DEFAULT_BUSINESS_KEY = '#{execution.processBusinessKey}';\nfunction CalledElementType(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const getValue = () => {\n    return getCalledElementType(element);\n  };\n  const setValue = value => {\n    const properties = {\n      ...DEFAULT_PROPS$4\n    };\n    if (value === 'bpmn') {\n      properties['calledElement'] = '';\n    } else if (value === 'cmmn') {\n      properties['camunda:caseRef'] = '';\n    }\n    commandStack.execute('element.updateProperties', {\n      element,\n      properties\n    });\n  };\n  const getOptions = () => [{\n    value: '',\n    label: translate('<none>')\n  }, {\n    value: 'bpmn',\n    label: translate('BPMN')\n  }, {\n    value: 'cmmn',\n    label: translate('CMMN')\n  }];\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* SelectEntry */.g0, {\n    element: element,\n    id: \"calledElementType\",\n    label: translate('Type'),\n    getValue: getValue,\n    setValue: setValue,\n    getOptions: getOptions\n  });\n}\nfunction BusinessKeyProps(props) {\n  const {\n    element\n  } = props;\n  const entries = [{\n    id: 'calledElementBusinessKey',\n    component: BusinessKey,\n    isEdited: properties_panel_dist_index_esm/* isCheckboxEntryEdited */.kv\n  }];\n  if (hasBusinessKey(element)) {\n    entries.push({\n      id: 'calledElementBusinessKeyExpression',\n      component: BusinessKeyExpression,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n  return entries;\n}\nfunction BusinessKey(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const modeling = useService('modeling');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const getValue = () => {\n    return hasBusinessKey(element);\n  };\n  const setValue = value => {\n    if (value) {\n      addBusinessKey();\n    } else {\n      removeBusinessKey();\n    }\n  };\n  function addBusinessKey() {\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) If there are no extension elements, create camunda:In and update element's properties\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {}, businessObject, bpmnFactory);\n      const businessKeyItem = createBusinessKey(extensionElements);\n      extensionElements.set('values', [businessKeyItem]);\n      modeling.updateProperties(element, {\n        extensionElements\n      });\n    } else {\n      // (2) Otherwise, add camunda:In to the existing values\n      const businessKeyItem = createBusinessKey(extensionElements);\n      addExtensionElements(element, businessObject, businessKeyItem, bpmnFactory, commandStack);\n    }\n  }\n  function createBusinessKey(parent) {\n    return createElement('camunda:In', {\n      businessKey: DEFAULT_BUSINESS_KEY\n    }, parent, bpmnFactory);\n  }\n  function removeBusinessKey() {\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    const camundaInList = getExtensionElementsList(businessObject, 'camunda:In');\n    const businessKeyItems = camundaInList.filter(camundaIn => camundaIn.get('businessKey') !== undefined);\n    removeExtensionElements(element, businessObject, businessKeyItems, commandStack);\n  }\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* CheckboxEntry */.IN, {\n    element: element,\n    id: \"calledElementBusinessKey\",\n    label: translate('Business key'),\n    getValue: getValue,\n    setValue: setValue\n  });\n}\nfunction BusinessKeyExpression(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => getBusinessKey(element);\n  const setValue = value => {\n    const camundaIn = findCamundaInWithBusinessKey(element);\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: camundaIn,\n      properties: {\n        businessKey: value || ''\n      }\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: element,\n    id: \"calledElementBusinessKeyExpression\",\n    label: translate('Business key expression'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\n\n// helper //////\n\nfunction getCalledElementType(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if (businessObject.get('calledElement') !== undefined) {\n    return 'bpmn';\n  } else if (businessObject.get('camunda:caseRef') !== undefined) {\n    return 'cmmn';\n  }\n  return '';\n}\nfunction hasBusinessKey(element) {\n  return getBusinessKey(element) !== undefined;\n}\nfunction getBusinessKey(element) {\n  const camundaIn = findCamundaInWithBusinessKey(element);\n  if (camundaIn) {\n    return camundaIn.get('businessKey');\n  }\n}\nfunction findCamundaInWithBusinessKey(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const camundaInList = getExtensionElementsList(businessObject, 'camunda:In');\n  for (const camundaIn of camundaInList) {\n    const businessKey = camundaIn.get('businessKey');\n    if (businessKey !== undefined) {\n      return camundaIn;\n    }\n  }\n}\n\nfunction CandidateStarterProps(props) {\n  const {\n    element\n  } = props;\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if (!(0,ModelUtil.is)(element, 'bpmn:Process') && !((0,ModelUtil.is)(element, 'bpmn:Participant') && businessObject.get('processRef'))) {\n    return [];\n  }\n  return [{\n    id: 'candidateStarterGroups',\n    component: CandidateStarterGroups,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'candidateStarterUsers',\n    component: CandidateStarterUsers,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n}\nfunction CandidateStarterGroups(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const process = getProcess$3(element);\n  const getValue = () => {\n    return process.get('camunda:candidateStarterGroups') || '';\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element: element,\n      moddleElement: process,\n      properties: {\n        'camunda:candidateStarterGroups': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'candidateStarterGroups',\n    label: translate('Candidate starter groups'),\n    description: translate('Specify more than one group as a comma separated list.'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction CandidateStarterUsers(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const process = getProcess$3(element);\n  const getValue = () => {\n    return process.get('camunda:candidateStarterUsers') || '';\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element: element,\n      moddleElement: process,\n      properties: {\n        'camunda:candidateStarterUsers': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'candidateStarterUsers',\n    label: translate('Candidate starter users'),\n    description: translate('Specify more than one user as a comma separated list.'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper //////////////////\n\n/**\n * getProcess - get the businessObject of the process referred to by a bpmn:Process\n * or by a bpmn:Participant\n *\n * @param  {ModdleElement} element either a bpmn:Process or a bpmn:Participant\n * @return {BusinessObject}\n */\nfunction getProcess$3(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Process') ? (0,ModelUtil/* getBusinessObject */.SS)(element) : (0,ModelUtil/* getBusinessObject */.SS)(element).get('processRef');\n}\n\nfunction ConditionProps(props) {\n  const {\n    element\n  } = props;\n  if (!((0,ModelUtil.is)(element, 'bpmn:SequenceFlow') && isConditionalSource(element.source)) && !getConditionalEventDefinition(element)) {\n    return [];\n  }\n  const entries = [];\n  if (getConditionalEventDefinition(element)) {\n    entries.push(...VariableEventProps({\n      element\n    }));\n  }\n  entries.push({\n    id: 'conditionType',\n    component: ConditionType,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  });\n  const conditionType = getConditionType(element);\n  if (conditionType === 'script') {\n    entries.push(...ConditionScriptProps({\n      element\n    }));\n  } else if (conditionType === 'expression') {\n    entries.push({\n      id: 'conditionExpression',\n      component: ConditionExpression,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n  return entries;\n}\nfunction ConditionType(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const getValue = () => {\n    return getConditionType(element);\n  };\n  const setValue = value => {\n    // (1) Remove formalExpression if <none> is selected\n    if (value === '') {\n      updateCondition(element, commandStack, undefined);\n    } else {\n      // (2) Create and set formalExpression element containing the conditionExpression\n      const attributes = {\n        body: '',\n        language: value === 'script' ? '' : undefined\n      };\n      const formalExpressionElement = createFormalExpression(element, attributes, bpmnFactory);\n      updateCondition(element, commandStack, formalExpressionElement);\n    }\n  };\n  const getOptions = () => [{\n    value: '',\n    label: translate('<none>')\n  }, {\n    value: 'script',\n    label: translate('Script')\n  }, {\n    value: 'expression',\n    label: translate('Expression')\n  }];\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* SelectEntry */.g0, {\n    element: element,\n    id: \"conditionType\",\n    label: translate('Type'),\n    getValue: getValue,\n    setValue: setValue,\n    getOptions: getOptions\n  });\n}\nfunction ConditionExpression(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack'),\n    bpmnFactory = useService('bpmnFactory'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const getValue = () => {\n    return getConditionExpression(element).get('body');\n  };\n  const setValue = value => {\n    const conditionExpression = createFormalExpression(element, {\n      body: value\n    }, bpmnFactory);\n    updateCondition(element, commandStack, conditionExpression);\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: element,\n    id: \"conditionExpression\",\n    label: translate('Condition Expression'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\nfunction ConditionScriptProps(props) {\n  const {\n    element\n  } = props;\n  const entries = [];\n  const scriptType = getScriptType$1(element);\n\n  // (1) language\n  entries.push({\n    id: 'conditionScriptLanguage',\n    component: Language,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  });\n\n  // (2) type\n  entries.push({\n    id: 'conditionScriptType',\n    component: ScriptType,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  });\n\n  // (3) script\n  if (scriptType === 'script') {\n    entries.push({\n      id: 'conditionScriptValue',\n      component: Script$1,\n      isEdited: properties_panel_dist_index_esm/* isTextAreaEntryEdited */.mn\n    });\n  } else if (scriptType === 'resource') {\n    // (4) resource\n    entries.push({\n      id: 'conditionScriptResource',\n      component: Resource$1,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n  return entries;\n}\nfunction Language(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return getConditionExpression(element).get('language');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element: element,\n      moddleElement: getConditionExpression(element),\n      properties: {\n        language: value || ''\n      }\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: element,\n    id: \"conditionScriptLanguage\",\n    label: translate('Format'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\nfunction ScriptType(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const getValue = () => {\n    return getScriptType$1(element);\n  };\n  const setValue = value => {\n    // reset script properties on type change\n    const updatedProperties = {\n      'body': value === 'script' ? '' : undefined,\n      'camunda:resource': value === 'resource' ? '' : undefined\n    };\n    commandStack.execute('element.updateModdleProperties', {\n      element: element,\n      moddleElement: getConditionExpression(element),\n      properties: updatedProperties\n    });\n  };\n  const getOptions = () => {\n    const options = [{\n      value: 'resource',\n      label: translate('External resource')\n    }, {\n      value: 'script',\n      label: translate('Inline script')\n    }];\n    return options;\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element,\n    id: 'conditionScriptType',\n    label: translate('Script type'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction Script$1(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return getConditionExpression(element).get('body');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element: element,\n      moddleElement: getConditionExpression(element),\n      properties: {\n        'body': value || ''\n      }\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextAreaEntry */.i, {\n    element: element,\n    id: \"conditionScriptValue\",\n    label: translate('Script'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce,\n    monospace: true\n  });\n}\nfunction Resource$1(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return getConditionExpression(element).get('camunda:resource');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element: element,\n      moddleElement: getConditionExpression(element),\n      properties: {\n        'camunda:resource': value || ''\n      }\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: true,\n    id: \"conditionScriptResource\",\n    label: translate('Resource'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\nfunction VariableEventProps(props) {\n  const {\n    element\n  } = props;\n  const entries = [];\n  entries.push({\n    id: 'conditionVariableName',\n    component: VariableName,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  });\n  if (!(0,ModelUtil.is)(element, 'bpmn:StartEvent')) {\n    entries.push({\n      id: 'conditionVariableEvents',\n      component: VariableEvents,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n  return entries;\n}\nfunction VariableName(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return getConditionalEventDefinition(element).get('variableName');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element: element,\n      moddleElement: getConditionalEventDefinition(element),\n      properties: {\n        variableName: value || ''\n      }\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: element,\n    id: \"conditionVariableName\",\n    label: translate('Variable name'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\nfunction VariableEvents(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return getConditionalEventDefinition(element).get('variableEvents');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element: element,\n      moddleElement: getConditionalEventDefinition(element),\n      properties: {\n        variableEvents: value || ''\n      }\n    });\n  };\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* TextFieldEntry */.Tq, {\n    element: element,\n    id: \"conditionVariableEvents\",\n    label: translate('Variable events'),\n    description: translate('Specify more than one variable change event as a comma separated list.'),\n    getValue: getValue,\n    setValue: setValue,\n    debounce: debounce\n  });\n}\n\n// helper ////////////////////\n\nconst CONDITIONAL_SOURCES = ['bpmn:Activity', 'bpmn:ExclusiveGateway', 'bpmn:InclusiveGateway', 'bpmn:ComplexGateway'];\nfunction isConditionalSource(element) {\n  return (0,ModelUtil/* isAny */.JZ)(element, CONDITIONAL_SOURCES);\n}\nfunction getConditionalEventDefinition(element) {\n  if (!(0,ModelUtil.is)(element, 'bpmn:Event')) {\n    return false;\n  }\n  return getEventDefinition$1(element, 'bpmn:ConditionalEventDefinition');\n}\nfunction getConditionType(element) {\n  const conditionExpression = getConditionExpression(element);\n  if (!conditionExpression) {\n    return '';\n  } else {\n    return conditionExpression.get('language') === undefined ? 'expression' : 'script';\n  }\n}\n\n/**\n * getConditionExpression - get the body value of a condition expression for a given element\n *\n * @param  {ModdleElement} element\n *\n * @return {string|undefined}\n */\nfunction getConditionExpression(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:SequenceFlow')) {\n    return businessObject.get('conditionExpression');\n  } else if (getConditionalEventDefinition(businessObject)) {\n    return getConditionalEventDefinition(businessObject).get('condition');\n  }\n}\nfunction getScriptType$1(element) {\n  const conditionExpression = getConditionExpression(element);\n  const resource = conditionExpression.get('camunda:resource');\n  if (typeof resource !== 'undefined') {\n    return 'resource';\n  } else {\n    return 'script';\n  }\n}\nfunction updateCondition(element, commandStack, condition = undefined) {\n  if ((0,ModelUtil.is)(element, 'bpmn:SequenceFlow')) {\n    commandStack.execute('element.updateProperties', {\n      element,\n      properties: {\n        conditionExpression: condition\n      }\n    });\n  } else {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: getConditionalEventDefinition(element),\n      properties: {\n        condition\n      }\n    });\n  }\n}\nfunction createFormalExpression(parent, attributes, bpmnFactory) {\n  return createElement('bpmn:FormalExpression', attributes, (0,ModelUtil.is)(parent, 'bpmn:SequenceFlow') ? (0,ModelUtil/* getBusinessObject */.SS)(parent) : getConditionalEventDefinition(parent), bpmnFactory);\n}\n\n/**\n * Cf. https://docs.camunda.org/manual/latest/user-guide/process-engine/scripting/\n */\nfunction ScriptProps(props) {\n  const {\n    element,\n    script,\n    prefix\n  } = props;\n  const entries = [];\n  const scriptType = getScriptType(script || element);\n  const idPrefix = prefix || '';\n\n  // (1) scriptFormat\n  entries.push({\n    id: idPrefix + 'scriptFormat',\n    component: Format,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$,\n    idPrefix,\n    script\n  });\n\n  // (2) type\n  entries.push({\n    id: idPrefix + 'scriptType',\n    component: Type$3,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD,\n    idPrefix,\n    script\n  });\n\n  // (3) script\n  if (scriptType === 'script') {\n    entries.push({\n      id: idPrefix + 'scriptValue',\n      component: Script,\n      isEdited: properties_panel_dist_index_esm/* isTextAreaEntryEdited */.mn,\n      idPrefix,\n      script\n    });\n  }\n\n  // (4) resource\n  if (scriptType === 'resource') {\n    entries.push({\n      id: idPrefix + 'scriptResource',\n      component: Resource,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$,\n      idPrefix,\n      script\n    });\n  }\n  return entries;\n}\nfunction Format(props) {\n  const {\n    element,\n    idPrefix,\n    script\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = script || (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('scriptFormat');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        scriptFormat: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: idPrefix + 'scriptFormat',\n    label: translate('Format'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Type$3(props) {\n  const {\n    element,\n    idPrefix,\n    script\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const businessObject = script || (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const scriptProperty = getScriptProperty(businessObject);\n  const getValue = () => {\n    return getScriptType(businessObject);\n  };\n  const setValue = value => {\n    // reset script properties on type change\n    const properties = {\n      [scriptProperty]: value === 'script' ? '' : undefined,\n      'camunda:resource': value === 'resource' ? '' : undefined\n    };\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties\n    });\n  };\n  const getOptions = () => {\n    const options = [{\n      value: '',\n      label: translate('<none>')\n    }, {\n      value: 'resource',\n      label: translate('External resource')\n    }, {\n      value: 'script',\n      label: translate('Inline script')\n    }];\n    return options;\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element,\n    id: idPrefix + 'scriptType',\n    label: translate('Type'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction Script(props) {\n  const {\n    element,\n    idPrefix,\n    script\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = script || (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const scriptProperty = getScriptProperty(businessObject);\n  const getValue = () => {\n    return getScriptValue(businessObject);\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        [scriptProperty]: value || ''\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextAreaEntry */.i)({\n    element,\n    id: idPrefix + 'scriptValue',\n    label: translate('Script'),\n    getValue,\n    setValue,\n    debounce,\n    monospace: true\n  });\n}\nfunction Resource(props) {\n  const {\n    element,\n    idPrefix,\n    script\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = script || (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:resource');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:resource': value || ''\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: idPrefix + 'scriptResource',\n    label: translate('Resource'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper ////////////////////\n\nfunction getScriptType(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const scriptValue = getScriptValue(businessObject);\n  if (typeof scriptValue !== 'undefined') {\n    return 'script';\n  }\n  const resource = businessObject.get('camunda:resource');\n  if (typeof resource !== 'undefined') {\n    return 'resource';\n  }\n}\nfunction getScriptValue(businessObject) {\n  return businessObject.get(getScriptProperty(businessObject));\n}\nfunction isScript$2(element) {\n  return (0,ModelUtil.is)(element, 'camunda:Script');\n}\nfunction getScriptProperty(businessObject) {\n  return isScript$2(businessObject) ? 'value' : 'script';\n}\n\nfunction getElements(businessObject, type, property) {\n  const elements = getExtensionElementsList(businessObject, type);\n  return !property ? elements : (elements[0] || {})[property] || [];\n}\nfunction getParameters(element, prop) {\n  const inputOutput = getInputOutput(element);\n  return inputOutput && inputOutput.get(prop) || [];\n}\n\n/**\n * Get a camunda:inputOutput from the business object\n *\n * @param {djs.model.Base | ModdleElement} element\n *\n * @return {ModdleElement} the inputOutput object\n */\nfunction getInputOutput(element) {\n  if ((0,ModelUtil.is)(element, 'camunda:Connector')) {\n    return element.get('inputOutput');\n  }\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return (getElements(businessObject, 'camunda:InputOutput') || [])[0];\n}\n\n/**\n * Return all input parameters existing in the business object, and\n * an empty array if none exist.\n *\n * @param  {djs.model.Base} element\n *\n * @return {Array} a list of input parameter objects\n */\nfunction getInputParameters(element) {\n  return getParameters(element, 'inputParameters');\n}\n\n/**\n * Return all output parameters existing in the business object, and\n * an empty array if none exist.\n *\n * @param  {djs.model.Base} element\n *\n * @return {Array} a list of output parameter objects\n */\nfunction getOutputParameters(element) {\n  return getParameters(element, 'outputParameters');\n}\nfunction isInputOutputSupported(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return (0,ModelUtil.is)(businessObject, 'bpmn:FlowNode') && !((0,ModelUtil/* isAny */.JZ)(businessObject, ['bpmn:StartEvent', 'bpmn:BoundaryEvent', 'bpmn:Gateway']) || (0,ModelUtil.is)(businessObject, 'bpmn:SubProcess') && businessObject.get('triggeredByEvent'));\n}\nfunction areInputParametersSupported(element) {\n  return isInputOutputSupported(element);\n}\nfunction areOutputParametersSupported(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return isInputOutputSupported(element) && !(0,ModelUtil.is)(businessObject, 'bpmn:EndEvent') && !businessObject.loopCharacteristics;\n}\nfunction getInputOutputType(parameter) {\n  const definitionTypes = {\n    'camunda:Map': 'map',\n    'camunda:List': 'list',\n    'camunda:Script': 'script'\n  };\n  let type = 'stringOrExpression';\n  const definition = parameter.get('definition');\n  if (typeof definition !== 'undefined') {\n    type = definitionTypes[definition.$type];\n  }\n  return type;\n}\nfunction CreateParameterCmd(element, type, parent, bpmnFactory) {\n  const isInput = type === 'camunda:InputParameter';\n  const newParameter = createElement(type, {\n    name: nextId(isInput ? 'Input_' : 'Output_')\n  }, parent, bpmnFactory);\n  const propertyName = isInput ? 'inputParameters' : 'outputParameters';\n  return {\n    cmd: 'element.updateModdleProperties',\n    context: {\n      element,\n      moddleElement: parent,\n      properties: {\n        [propertyName]: [...parent.get(propertyName), newParameter]\n      }\n    }\n  };\n}\nfunction AddParameterCmd(element, type, bpmnFactory) {\n  const commands = [];\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  let extensionElements = businessObject.get('extensionElements');\n\n  // (1) ensure extension elements\n  if (!extensionElements) {\n    extensionElements = createElement('bpmn:ExtensionElements', {\n      values: []\n    }, businessObject, bpmnFactory);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: businessObject,\n        properties: {\n          extensionElements\n        }\n      }\n    });\n  }\n\n  // (2) ensure inputOutput\n  let inputOutput = getInputOutput(element);\n  if (!inputOutput) {\n    const parent = extensionElements;\n    inputOutput = createElement('camunda:InputOutput', {\n      inputParameters: [],\n      outputParameters: []\n    }, parent, bpmnFactory);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: extensionElements,\n        properties: {\n          values: [...extensionElements.get('values'), inputOutput]\n        }\n      }\n    });\n  }\n\n  // (3) create + add parameter\n  commands.push(CreateParameterCmd(element, type, inputOutput, bpmnFactory));\n  return commands;\n}\n\nfunction ListProp(props) {\n  const {\n    element,\n    id: idPrefix,\n    index,\n    item\n  } = props;\n  const id = `${idPrefix}-listItem-${index}`;\n  return (0,jsxRuntime_module/* jsx */.tZ)(ListItem, {\n    idPrefix: id,\n    element: element,\n    item: item\n  });\n}\nfunction ListProps(props) {\n  const {\n    idPrefix,\n    element,\n    parameter\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const list = parameter.get('definition');\n  const items = list.get('items');\n  function addItem() {\n    const value = createElement('camunda:Value', {}, parameter, bpmnFactory);\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: list,\n      properties: {\n        items: [...list.get('items'), value]\n      }\n    });\n  }\n  function removeItem(item) {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: list,\n      properties: {\n        items: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(list.get('items'), item)\n      }\n    });\n  }\n  function compareFn(item, anotherItem) {\n    const [value = '', anotherValue = ''] = [item.value, anotherItem.value];\n    return value === anotherValue ? 0 : value > anotherValue ? 1 : -1;\n  }\n  return (0,properties_panel_dist_index_esm/* ListEntry */.vW)({\n    element,\n    autoFocusEntry: true,\n    compareFn,\n    id: idPrefix + '-list',\n    items,\n    label: translate('List values'),\n    onAdd: addItem,\n    onRemove: removeItem,\n    component: ListProp\n  });\n}\nfunction ListItem(props) {\n  const {\n    idPrefix,\n    element,\n    item\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const definitionLabels = {\n    'camunda:Map': translate('Map'),\n    'camunda:List': translate('List'),\n    'camunda:Script': translate('Script')\n  };\n  const getValue = () => {\n    if (isDefinitionType$1(item)) {\n      return definitionLabels[item.$type];\n    }\n    return item.get('value');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: item,\n      properties: {\n        value\n      }\n    });\n  };\n  return ListValue({\n    id: idPrefix + '-value',\n    disabled: isDefinitionType$1(item),\n    getValue,\n    setValue\n  });\n}\nfunction ListValue(props) {\n  const {\n    id,\n    disabled,\n    getValue,\n    setValue\n  } = props;\n  const debounce = useService('debounceInput', true);\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* SimpleEntry */.Hd, {\n    id: id,\n    getValue: getValue,\n    setValue: setValue,\n    disabled: disabled,\n    debounce: debounce\n  });\n}\n\n// helper //////////////////////\n\nfunction isScript$1(element) {\n  return (0,ModelUtil.is)(element, 'camunda:Script');\n}\nfunction isList$1(element) {\n  return (0,ModelUtil.is)(element, 'camunda:List');\n}\nfunction isMap$1(element) {\n  return (0,ModelUtil.is)(element, 'camunda:Map');\n}\nfunction isDefinitionType$1(element) {\n  return isScript$1(element) || isList$1(element) || isMap$1(element);\n}\n\nfunction MapProp(props) {\n  const {\n    element,\n    id: idPrefix,\n    index,\n    item: entry,\n    open\n  } = props;\n  const id = `${idPrefix}-mapEntry-${index}`;\n  const translate = useService('translate');\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* CollapsibleEntry */.I1, {\n    id: id,\n    element: element,\n    entries: MapEntry({\n      element,\n      entry,\n      idPrefix: id\n    }),\n    label: entry.get('key') || translate('<empty>'),\n    open: open\n  });\n}\nfunction MapProps(props) {\n  const {\n    idPrefix,\n    element,\n    parameter\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const map = parameter.get('definition');\n  const entries = map.get('entries');\n  function addEntry() {\n    const entry = createElement('camunda:Entry', {}, parameter, bpmnFactory);\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: map,\n      properties: {\n        entries: [...map.get('entries'), entry]\n      }\n    });\n  }\n  function removeEntry(entry) {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: map,\n      properties: {\n        entries: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(map.get('entries'), entry)\n      }\n    });\n  }\n  function compareFn(entry, anotherEntry) {\n    const [key = '', anotherKey = ''] = [entry.key, anotherEntry.key];\n    return key === anotherKey ? 0 : key > anotherKey ? 1 : -1;\n  }\n  return (0,properties_panel_dist_index_esm/* ListEntry */.vW)({\n    element,\n    autoFocusEntry: true,\n    compareFn,\n    id: idPrefix + '-map',\n    items: entries,\n    label: translate('Map entries'),\n    onAdd: addEntry,\n    onRemove: removeEntry,\n    component: MapProp\n  });\n}\nfunction MapEntry(props) {\n  const {\n    element,\n    entry,\n    idPrefix\n  } = props;\n  const entries = [{\n    id: idPrefix + '-key',\n    component: MapKey,\n    entry,\n    idPrefix,\n    element\n  }, {\n    id: idPrefix + '-value',\n    component: MapValue,\n    entry,\n    idPrefix,\n    element\n  }];\n  return entries;\n}\nfunction MapKey(props) {\n  const {\n    element,\n    entry,\n    idPrefix\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: entry,\n      properties: {\n        key: value\n      }\n    });\n  };\n  const getValue = () => {\n    return entry.get('key');\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: entry,\n    id: idPrefix + '-key',\n    label: translate('Key'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction MapValue(props) {\n  const {\n    element,\n    entry,\n    idPrefix\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const definition = entry.get('definition');\n  const definitionLabels = {\n    'camunda:Map': translate('Map'),\n    'camunda:List': translate('List'),\n    'camunda:Script': translate('Script')\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: entry,\n      properties: {\n        value\n      }\n    });\n  };\n  const getValue = () => {\n    if (isDefinitionType(definition)) {\n      return definitionLabels[definition.$type];\n    }\n    return entry.get('value');\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: entry,\n    id: idPrefix + '-value',\n    label: translate('Value'),\n    getValue,\n    setValue,\n    disabled: isDefinitionType(definition),\n    debounce\n  });\n}\n\n// helper ///////////////////\n\nfunction isScript(element) {\n  return (0,ModelUtil.is)(element, 'camunda:Script');\n}\nfunction isList(element) {\n  return (0,ModelUtil.is)(element, 'camunda:List');\n}\nfunction isMap(element) {\n  return (0,ModelUtil.is)(element, 'camunda:Map');\n}\nfunction isDefinitionType(element) {\n  return isScript(element) || isList(element) || isMap(element);\n}\n\nconst DEFAULT_PROPS$3 = {\n  value: undefined,\n  definition: undefined\n};\nfunction InputOutputParameter(props) {\n  const {\n    idPrefix,\n    element,\n    parameter\n  } = props;\n  const inputOutputType = getInputOutputType(parameter);\n  let entries = [{\n    id: idPrefix + '-name',\n    component: Name$2,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$,\n    idPrefix,\n    parameter\n  }, {\n    id: idPrefix + '-type',\n    component: Type$2,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD,\n    idPrefix,\n    parameter\n  }];\n\n  // (1) String or expression\n  if (inputOutputType === 'stringOrExpression') {\n    entries.push({\n      id: idPrefix + '-stringOrExpression',\n      component: StringOrExpression,\n      isEdited: properties_panel_dist_index_esm/* isTextAreaEntryEdited */.mn,\n      idPrefix,\n      parameter\n    });\n\n    // (2) Script\n  } else if (inputOutputType === 'script') {\n    const script = parameter.get('definition');\n    entries = [...entries, ...ScriptProps({\n      element,\n      prefix: idPrefix + '-',\n      script\n    })];\n\n    // (3) List\n  } else if (inputOutputType === 'list') {\n    entries.push({\n      id: `${idPrefix}-list`,\n      component: ListProps,\n      idPrefix,\n      parameter\n    });\n\n    // (4) Map\n  } else if (inputOutputType === 'map') {\n    entries.push({\n      id: `${idPrefix}-map`,\n      component: MapProps,\n      idPrefix,\n      parameter\n    });\n  }\n  return entries;\n}\nfunction Name$2(props) {\n  const {\n    idPrefix,\n    element,\n    parameter\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: parameter,\n      properties: {\n        name: value\n      }\n    });\n  };\n  const getValue = parameter => {\n    return parameter.get('name');\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: parameter,\n    id: idPrefix + '-name',\n    label: translate(isInput(parameter) ? 'Local variable name' : 'Process variable name'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Type$2(props) {\n  const {\n    idPrefix,\n    element,\n    parameter\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const createDefinitionElement = type => {\n    return createElement(type, {}, parameter, bpmnFactory);\n  };\n  const getValue = mapping => {\n    return getInputOutputType(mapping);\n  };\n  const setValue = value => {\n    let properties = {\n      ...DEFAULT_PROPS$3\n    };\n    if (value === 'script') {\n      properties.definition = createDefinitionElement('camunda:Script');\n    } else if (value === 'list') {\n      properties.definition = createDefinitionElement('camunda:List');\n    } else if (value === 'map') {\n      properties.definition = createDefinitionElement('camunda:Map');\n    }\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: parameter,\n      properties\n    });\n  };\n  const getOptions = () => {\n    const options = [{\n      label: translate('List'),\n      value: 'list'\n    }, {\n      label: translate('Map'),\n      value: 'map'\n    }, {\n      label: translate('Script'),\n      value: 'script'\n    }, {\n      label: translate('String or expression'),\n      value: 'stringOrExpression'\n    }];\n    return options;\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element: parameter,\n    id: idPrefix + '-type',\n    label: translate('Assignment type'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction StringOrExpression(props) {\n  const {\n    idPrefix,\n    element,\n    parameter\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: parameter,\n      properties: {\n        value\n      }\n    });\n  };\n  const getValue = parameter => {\n    return parameter.get('value');\n  };\n  return (0,properties_panel_dist_index_esm/* TextAreaEntry */.i)({\n    element: parameter,\n    id: idPrefix + '-stringOrExpression',\n    label: translate('Value'),\n    description: translate('Start typing \"${}\" to create an expression.'),\n    getValue,\n    setValue,\n    rows: 1,\n    debounce\n  });\n}\n\n// helper /////////////////////\n\nfunction isInput(parameter) {\n  return (0,ModelUtil.is)(parameter, 'camunda:InputParameter');\n}\n\n/**\n * Check whether an element is camunda:ServiceTaskLike\n *\n * @param {djs.model.Base} element\n *\n * @return {boolean} a boolean value\n */\nfunction isServiceTaskLike(element) {\n  return (0,ModelUtil.is)(element, 'camunda:ServiceTaskLike');\n}\n\n/**\n * Returns 'true' if the given element is 'camunda:DmnCapable'\n *\n * @param {djs.model.Base} element\n *\n * @return {boolean} a boolean value\n */\nfunction isDmnCapable(element) {\n  return (0,ModelUtil.is)(element, 'camunda:DmnCapable');\n}\n\n/**\n * Returns 'true' if the given element is 'camunda:ExternalCapable'\n *\n * @param {djs.model.Base} element\n *\n * @return {boolean} a boolean value\n */\nfunction isExternalCapable(element) {\n  return (0,ModelUtil.is)(element, 'camunda:ExternalCapable');\n}\n\n/**\n * getServiceTaskLikeBusinessObject - Get a 'camunda:ServiceTaskLike' business object.\n *\n * If the given element is not a 'camunda:ServiceTaskLike', then 'false'\n * is returned.\n *\n * @param {djs.model.Base} element\n * @return {ModdleElement} the 'camunda:ServiceTaskLike' business object\n */\nfunction getServiceTaskLikeBusinessObject(element) {\n  if ((0,ModelUtil.is)(element, 'bpmn:IntermediateThrowEvent') || (0,ModelUtil.is)(element, 'bpmn:EndEvent')) {\n    // change business object to 'messageEventDefinition' when\n    // the element is a message intermediate throw event or message end event\n    // because the camunda extensions (e.g. camunda:class) are in the message\n    // event definition tag and not in the intermediate throw event or end event tag\n    const messageEventDefinition = getMessageEventDefinition(element);\n    if (messageEventDefinition) {\n      element = messageEventDefinition;\n    }\n  }\n  return isServiceTaskLike(element) && (0,ModelUtil/* getBusinessObject */.SS)(element);\n}\n\n/**\n * Returns the implementation type of the given element.\n *\n * Possible implementation types are:\n * - dmn\n * - connector\n * - external\n * - class\n * - expression\n * - delegateExpression\n * - script\n * - or undefined, when no matching implementation type is found\n *\n * @param  {djs.model.Base} element\n *\n * @return {String} the implementation type\n */\nfunction getImplementationType(element) {\n  const businessObject = getListenerBusinessObject(element) || getServiceTaskLikeBusinessObject(element);\n  if (!businessObject) {\n    return;\n  }\n  if (isDmnCapable(businessObject)) {\n    const decisionRef = businessObject.get('camunda:decisionRef');\n    if (typeof decisionRef !== 'undefined') {\n      return 'dmn';\n    }\n  }\n  if (isServiceTaskLike(businessObject)) {\n    const connectors = getExtensionElementsList(businessObject, 'camunda:Connector');\n    if (connectors.length) {\n      return 'connector';\n    }\n  }\n  if (isExternalCapable(businessObject)) {\n    const type = businessObject.get('camunda:type');\n    if (type === 'external') {\n      return 'external';\n    }\n  }\n  const cls = businessObject.get('camunda:class');\n  if (typeof cls !== 'undefined') {\n    return 'class';\n  }\n  const expression = businessObject.get('camunda:expression');\n  if (typeof expression !== 'undefined') {\n    return 'expression';\n  }\n  const delegateExpression = businessObject.get('camunda:delegateExpression');\n  if (typeof delegateExpression !== 'undefined') {\n    return 'delegateExpression';\n  }\n  const script = businessObject.get('script');\n  if (typeof script !== 'undefined') {\n    return 'script';\n  }\n}\nfunction getListenerBusinessObject(businessObject) {\n  if ((0,ModelUtil/* isAny */.JZ)(businessObject, ['camunda:ExecutionListener', 'camunda:TaskListener'])) {\n    return businessObject;\n  }\n}\n\nfunction areConnectorsSupported(element) {\n  const businessObject = getServiceTaskLikeBusinessObject(element);\n  return businessObject && getImplementationType(businessObject) === 'connector';\n}\nfunction getConnectors$2(businessObject) {\n  return getExtensionElementsList(businessObject, 'camunda:Connector');\n}\nfunction getConnector$1(element) {\n  const businessObject = getServiceTaskLikeBusinessObject(element);\n  const connectors = getConnectors$2(businessObject);\n  return connectors[0];\n}\n\nfunction ConnectorInputProps(props) {\n  const {\n    element,\n    injector\n  } = props;\n  if (!areConnectorsSupported(element)) {\n    return null;\n  }\n  const connector = getConnector$1(element);\n  const commandStack = injector.get('commandStack'),\n    bpmnFactory = injector.get('bpmnFactory');\n  const inputParameters = getInputParameters(connector) || [];\n  const items = inputParameters.map((parameter, index) => {\n    const id = element.id + '-connector-inputParameter-' + index;\n    return {\n      id,\n      label: parameter.get('name') || '',\n      entries: InputOutputParameter({\n        element,\n        idPrefix: id,\n        parameter\n      }),\n      autoFocusEntry: id + '-name',\n      remove: removeFactory$8({\n        connector,\n        element,\n        parameter,\n        commandStack\n      })\n    };\n  });\n  function add(event) {\n    event.stopPropagation();\n    const commands = [];\n\n    // (1) ensure inputOutput\n    let inputOutput = getInputOutput(connector);\n    if (!inputOutput) {\n      inputOutput = createElement('camunda:InputOutput', {\n        inputParameters: [],\n        outputParameters: []\n      }, connector, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element: element,\n          moddleElement: connector,\n          properties: {\n            inputOutput\n          }\n        }\n      });\n    }\n\n    // (2) create + add parameter\n    commands.push(CreateParameterCmd(element, 'camunda:InputParameter', inputOutput, bpmnFactory));\n\n    // (3) commit all updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  }\n  return {\n    items,\n    add\n  };\n}\nfunction removeFactory$8(props) {\n  const {\n    commandStack,\n    connector,\n    element,\n    parameter\n  } = props;\n  return function (event) {\n    event.stopPropagation();\n    const inputOutput = getInputOutput(connector);\n    if (!inputOutput) {\n      return;\n    }\n    commandStack.execute('element.updateModdleProperties', {\n      element: element,\n      moddleElement: inputOutput,\n      properties: {\n        inputParameters: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(inputOutput.get('inputParameters'), parameter)\n      }\n    });\n  };\n}\n\nfunction ConnectorOutputProps(props) {\n  const {\n    element,\n    injector\n  } = props;\n  if (!areConnectorsSupported(element)) {\n    return null;\n  }\n  const connector = getConnector$1(element);\n  const commandStack = injector.get('commandStack'),\n    bpmnFactory = injector.get('bpmnFactory');\n  const outputParameters = getOutputParameters(connector) || [];\n  const items = outputParameters.map((parameter, index) => {\n    const id = element.id + '-connector-outputParameter-' + index;\n    return {\n      id,\n      label: parameter.get('name') || '',\n      entries: InputOutputParameter({\n        idPrefix: id,\n        element,\n        parameter\n      }),\n      autoFocusEntry: id + '-name',\n      remove: removeFactory$7({\n        connector,\n        element,\n        commandStack,\n        parameter\n      })\n    };\n  });\n  function add(event) {\n    event.stopPropagation();\n    const commands = [];\n\n    // (1) ensure inputOutput\n    let inputOutput = getInputOutput(connector);\n    if (!inputOutput) {\n      inputOutput = createElement('camunda:InputOutput', {\n        inputParameters: [],\n        outputParameters: []\n      }, connector, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element: element,\n          moddleElement: connector,\n          properties: {\n            inputOutput\n          }\n        }\n      });\n    }\n\n    // (2) create + add parameter\n    commands.push(CreateParameterCmd(element, 'camunda:OutputParameter', inputOutput, bpmnFactory));\n\n    // (3) commit all updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  }\n  return {\n    items,\n    add\n  };\n}\nfunction removeFactory$7(props) {\n  const {\n    commandStack,\n    connector,\n    element,\n    parameter\n  } = props;\n  return function (event) {\n    event.stopPropagation();\n    const inputOutput = getInputOutput(connector);\n    if (!inputOutput) {\n      return;\n    }\n    commandStack.execute('element.updateModdleProperties', {\n      element: element,\n      moddleElement: inputOutput,\n      properties: {\n        outputParameters: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(inputOutput.get('outputParameters'), parameter)\n      }\n    });\n  };\n}\n\nfunction ErrorProps(props) {\n  const {\n    element,\n    entries\n  } = props;\n  if (!isErrorSupported(element)) {\n    return entries;\n  }\n  const error = getError(element);\n\n  // (1) errorMessage (error)\n  if (error) {\n    const idx = findPlaceToInsert(entries, 'errorCode');\n\n    // place below errorCode\n    entries.splice(idx, 0, {\n      id: 'errorMessage',\n      component: ErrorMessage$1,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n  if (!canHaveErrorVariables(element)) {\n    return entries;\n  }\n\n  // (2) errorCodeVariable + errorMessageVariable (errorEventDefinition)\n  entries.push({\n    id: 'errorCodeVariable',\n    component: ErrorCodeVariable,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'errorMessageVariable',\n    component: ErrorMessageVariable,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  });\n  return entries;\n}\nfunction ErrorMessage$1(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const error = getError(element);\n  const getValue = () => {\n    return error.get('camunda:errorMessage');\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: error,\n      properties: {\n        'camunda:errorMessage': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'errorMessage',\n    label: translate('Message'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ErrorCodeVariable(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const errorEventDefinition = getErrorEventDefinition(element);\n  const getValue = () => {\n    return errorEventDefinition.get('camunda:errorCodeVariable');\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: errorEventDefinition,\n      properties: {\n        'camunda:errorCodeVariable': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'errorCodeVariable',\n    label: translate('Code variable'),\n    description: translate('Define the name of the variable that will contain the error code.'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ErrorMessageVariable(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const errorEventDefinition = getErrorEventDefinition(element);\n  const getValue = () => {\n    return errorEventDefinition.get('camunda:errorMessageVariable');\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: errorEventDefinition,\n      properties: {\n        'camunda:errorMessageVariable': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'errorMessageVariable',\n    label: translate('Message variable'),\n    description: translate('Define the name of the variable that will contain the error message.'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper ///////////////////////\n\nfunction canHaveErrorVariables(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:StartEvent') || (0,ModelUtil.is)(element, 'bpmn:BoundaryEvent');\n}\nfunction findPlaceToInsert(entries, idx) {\n  const entryIndex = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* findIndex */.cx)(entries, entry => entry.id === idx);\n  return entryIndex >= 0 ? entryIndex + 1 : entries.length;\n}\n\nconst EMPTY_OPTION = '';\nconst CREATE_NEW_OPTION = 'create-new';\nfunction Error$1(props) {\n  const {\n    idPrefix,\n    errorEventDefinition\n  } = props;\n  let entries = [{\n    id: idPrefix + '-errorRef',\n    component: ErrorRef,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD,\n    errorEventDefinition,\n    idPrefix\n  }];\n  const error = errorEventDefinition.get('errorRef');\n  if (error) {\n    entries = [...entries, {\n      id: idPrefix + '-errorName',\n      component: ErrorName,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$,\n      error,\n      errorEventDefinition,\n      idPrefix\n    }, {\n      id: idPrefix + '-errorCode',\n      component: ErrorCode,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$,\n      error,\n      errorEventDefinition,\n      idPrefix\n    }, {\n      id: idPrefix + '-errorMessage',\n      component: ErrorMessage,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$,\n      error,\n      errorEventDefinition,\n      idPrefix\n    }];\n  }\n  entries.push({\n    id: idPrefix + '-expression',\n    component: Expression$2,\n    errorEventDefinition,\n    idPrefix\n  });\n  return entries;\n}\nfunction ErrorRef(props) {\n  const {\n    element,\n    errorEventDefinition,\n    idPrefix\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    const error = errorEventDefinition.get('errorRef');\n    if (error) {\n      return error.get('id');\n    }\n    return EMPTY_OPTION;\n  };\n  const setValue = value => {\n    const root = getRoot(businessObject);\n    const commands = [];\n    let error;\n\n    // (1) create new error\n    if (value === CREATE_NEW_OPTION) {\n      error = createElement('bpmn:Error', {\n        name: nextId('Error_')\n      }, root, bpmnFactory);\n      value = error.get('id');\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: root,\n          properties: {\n            rootElements: [...root.get('rootElements'), error]\n          }\n        }\n      });\n    }\n\n    // (2) update (or remove) errorRef\n    error = error || findRootElementById(businessObject, 'bpmn:Error', value);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: errorEventDefinition,\n        properties: {\n          errorRef: error\n        }\n      }\n    });\n\n    // (3) commit all updates\n    return commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  const getOptions = () => {\n    let options = [{\n      value: EMPTY_OPTION,\n      label: translate('<none>')\n    }, {\n      value: CREATE_NEW_OPTION,\n      label: translate('Create new ...')\n    }];\n    const errors = findRootElementsByType((0,ModelUtil/* getBusinessObject */.SS)(element), 'bpmn:Error');\n    sortByName$1(errors).forEach(error => {\n      options.push({\n        value: error.get('id'),\n        label: error.get('name') || error.get('id')\n      });\n    });\n    return options;\n  };\n  return ReferenceSelectEntry({\n    element,\n    id: idPrefix + '-errorRef',\n    label: translate('Global error reference'),\n    autoFocusEntry: idPrefix + '-errorName',\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction ErrorName(props) {\n  const {\n    element,\n    error,\n    idPrefix\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return error.get('name');\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: error,\n      properties: {\n        name: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: idPrefix + '-errorName',\n    label: translate('Name'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ErrorCode(props) {\n  const {\n    element,\n    error,\n    idPrefix\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return error.get('errorCode');\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: error,\n      properties: {\n        errorCode: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: idPrefix + '-errorCode',\n    label: translate('Code'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ErrorMessage(props) {\n  const {\n    element,\n    error,\n    idPrefix\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return error.get('errorMessage');\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: error,\n      properties: {\n        errorMessage: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: idPrefix + '-errorMessage',\n    label: translate('Message'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Expression$2(props) {\n  const {\n    element,\n    errorEventDefinition,\n    idPrefix\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: errorEventDefinition,\n      properties: {\n        'camunda:expression': value\n      }\n    });\n  };\n  const getValue = () => {\n    return errorEventDefinition.get('camunda:expression');\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: errorEventDefinition,\n    id: idPrefix + '-expression',\n    label: translate('Throw expression'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helpers //////////\n\nfunction sortByName$1(elements) {\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* sortBy */.MR)(elements, e => (e.name || '').toLowerCase());\n}\n\nfunction ErrorsProps({\n  element,\n  injector\n}) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if (!(0,ModelUtil.is)(element, 'bpmn:ServiceTask') || getImplementationType(element) !== 'external') {\n    return null;\n  }\n  const errorEventDefinitions = getExtensionElementsList(businessObject, 'camunda:ErrorEventDefinition');\n  const bpmnFactory = injector.get('bpmnFactory'),\n    commandStack = injector.get('commandStack');\n  const items = errorEventDefinitions.map((errorEventDefinition, index) => {\n    const id = element.id + '-error-' + index;\n    return {\n      id,\n      label: getErrorLabel(errorEventDefinition),\n      entries: Error$1({\n        idPrefix: id,\n        element,\n        errorEventDefinition\n      }),\n      autoFocusEntry: id + '-errorRef',\n      remove: removeFactory$6({\n        commandStack,\n        element,\n        errorEventDefinition\n      })\n    };\n  });\n  return {\n    items,\n    add: addFactory$5({\n      bpmnFactory,\n      commandStack,\n      element\n    }),\n    shouldSort: false\n  };\n}\nfunction removeFactory$6({\n  commandStack,\n  element,\n  errorEventDefinition\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    removeExtensionElements(element, businessObject, errorEventDefinition, commandStack);\n  };\n}\nfunction addFactory$5({\n  bpmnFactory,\n  commandStack,\n  element\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    const error = createElement('camunda:ErrorEventDefinition', {}, undefined, bpmnFactory);\n    addExtensionElements(element, businessObject, error, bpmnFactory, commandStack);\n  };\n}\n\n// helpers //////////\n\nfunction getErrorLabel(errorEventDefinition) {\n  const error = errorEventDefinition.get('errorRef');\n  if (!error) {\n    return '<no reference>';\n  }\n  const errorCode = error.get('errorCode'),\n    name = error.get('name') || '<unnamed>';\n  if (errorCode) {\n    return `${name} (code = ${errorCode})`;\n  }\n  return name;\n}\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction EscalationProps(props) {\n  const {\n    element,\n    entries\n  } = props;\n  if (!(isEscalationSupported(element) && canHaveEscalationVariables(element))) {\n    return entries;\n  }\n  entries.push({\n    id: 'escalationCodeVariable',\n    component: EscalationCodeVariable,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  });\n  return entries;\n}\nfunction EscalationCodeVariable(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const escalationEventDefinition = getEscalationEventDefinition(element);\n  const getValue = () => {\n    return escalationEventDefinition.get('camunda:escalationCodeVariable');\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: escalationEventDefinition,\n      properties: {\n        'camunda:escalationCodeVariable': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'escalationCodeVariable',\n    label: translate('Code variable'),\n    description: translate('Define the name of the variable that will contain the escalation code.'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper ///////////////////////\n\nfunction canHaveEscalationVariables(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:StartEvent') || (0,ModelUtil.is)(element, 'bpmn:BoundaryEvent');\n}\n\nfunction ExternalTaskPriorityProps(props) {\n  const {\n    element\n  } = props;\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if (!(0,ModelUtil.is)(element, 'bpmn:Process') && !((0,ModelUtil.is)(element, 'bpmn:Participant') && businessObject.get('processRef')) && !isExternalTaskLike(element)) {\n    return [];\n  }\n  return [{\n    id: 'externalTaskPriority',\n    component: ExternalTaskPriority,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n}\nfunction ExternalTaskPriority(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  let businessObject;\n  if ((0,ModelUtil.is)(element, 'bpmn:Participant')) {\n    businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element).get('processRef');\n  } else if (isExternalTaskLike(element)) {\n    businessObject = getServiceTaskLikeBusinessObject(element);\n  } else {\n    businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  }\n  const getValue = () => {\n    return businessObject.get('camunda:taskPriority');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:taskPriority': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'externalTaskPriority',\n    label: translate('Priority'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper //////////////////\n\nfunction isExternalTaskLike(element) {\n  const bo = getServiceTaskLikeBusinessObject(element),\n    type = bo && bo.get('camunda:type');\n  return (0,ModelUtil.is)(bo, 'camunda:ServiceTaskLike') && type && type === 'external';\n}\n\nconst DEFAULT_PROPS$2 = {\n  'stringValue': undefined,\n  'string': undefined,\n  'expression': undefined\n};\nfunction FieldInjection(props) {\n  const {\n    element,\n    idPrefix,\n    field\n  } = props;\n  const entries = [{\n    id: idPrefix + '-name',\n    component: NameProperty,\n    field,\n    idPrefix,\n    element\n  }, {\n    id: idPrefix + '-type',\n    component: TypeProperty,\n    field,\n    idPrefix,\n    element\n  }, {\n    id: idPrefix + '-value',\n    component: ValueProperty,\n    field,\n    idPrefix,\n    element\n  }];\n  return entries;\n}\nfunction NameProperty(props) {\n  const {\n    idPrefix,\n    element,\n    field\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: field,\n      properties: {\n        name: value\n      }\n    });\n  };\n  const getValue = field => {\n    return field.name;\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: field,\n    id: idPrefix + '-name',\n    label: translate('Name'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction TypeProperty(props) {\n  const {\n    idPrefix,\n    element,\n    field\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate');\n  const getValue = field => {\n    return determineType(field);\n  };\n  const setValue = value => {\n    const properties = Object.assign({}, DEFAULT_PROPS$2);\n    properties[value] = '';\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: field,\n      properties\n    });\n  };\n  const getOptions = element => {\n    const options = [{\n      value: 'string',\n      label: translate('String')\n    }, {\n      value: 'expression',\n      label: translate('Expression')\n    }];\n    return options;\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element: field,\n    id: idPrefix + '-type',\n    label: translate('Type'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction ValueProperty(props) {\n  const {\n    idPrefix,\n    element,\n    field\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    // (1) determine which type we have set\n    const type = determineType(field);\n\n    // (2) set property accordingly\n    const properties = Object.assign({}, DEFAULT_PROPS$2);\n    properties[type] = value || '';\n\n    // (3) execute the update command\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: field,\n      properties\n    });\n  };\n  const getValue = field => {\n    return field.string || field.stringValue || field.expression;\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: field,\n    id: idPrefix + '-value',\n    label: translate('Value'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper ///////////////////\n\n/**\n * determineType - get the type of a fieldInjection based on the attributes\n * set on it\n *\n * @param  {ModdleElement} field\n * @return {('string'|'expression')}\n */\nfunction determineType(field) {\n  // string is the default type\n  return 'string' in field && 'string' || 'expression' in field && 'expression' || 'stringValue' in field && 'string' || 'string';\n}\n\nfunction FieldInjectionProps({\n  element,\n  injector\n}) {\n  const businessObject = getServiceTaskLikeBusinessObject(element);\n  if (!businessObject) {\n    return null;\n  }\n  const fieldInjections = getExtensionElementsList(businessObject, 'camunda:Field');\n  const bpmnFactory = injector.get('bpmnFactory'),\n    commandStack = injector.get('commandStack');\n  const items = fieldInjections.map((field, index) => {\n    const id = element.id + '-fieldInjection-' + index;\n    return {\n      id,\n      label: getFieldLabel(field),\n      entries: FieldInjection({\n        idPrefix: id,\n        element,\n        field\n      }),\n      autoFocusEntry: id + '-name',\n      remove: removeFactory$5({\n        commandStack,\n        element,\n        field\n      })\n    };\n  });\n  return {\n    items,\n    add: addFactory$4({\n      bpmnFactory,\n      commandStack,\n      element\n    })\n  };\n}\nfunction removeFactory$5({\n  commandStack,\n  element,\n  field\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const businessObject = getServiceTaskLikeBusinessObject(element);\n    removeExtensionElements(element, businessObject, field, commandStack);\n  };\n}\nfunction addFactory$4({\n  bpmnFactory,\n  commandStack,\n  element\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const businessObject = getServiceTaskLikeBusinessObject(element);\n    const fieldInjection = createElement('camunda:Field', {\n      name: undefined,\n      string: '',\n      // string is the default type\n      stringValue: undefined\n    }, null, bpmnFactory);\n    addExtensionElements(element, businessObject, fieldInjection, bpmnFactory, commandStack);\n  };\n}\n\n// helper ///////////////\n\nfunction getFieldLabel(field) {\n  return field.name || '<empty>';\n}\n\nfunction FormFieldConstraint(props) {\n  const {\n    constraint,\n    element,\n    idPrefix\n  } = props;\n  const entries = [{\n    id: idPrefix + '-name',\n    component: Name$1,\n    constraint,\n    idPrefix,\n    element\n  }, {\n    id: idPrefix + '-config',\n    component: Config,\n    constraint,\n    idPrefix,\n    element\n  }];\n  return entries;\n}\nfunction Name$1(props) {\n  const {\n    idPrefix,\n    element,\n    constraint\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: constraint,\n      properties: {\n        name: value\n      }\n    });\n  };\n  const getValue = () => {\n    return constraint.name;\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: constraint,\n    id: idPrefix + '-name',\n    label: translate('Name'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Config(props) {\n  const {\n    idPrefix,\n    element,\n    constraint\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: constraint,\n      properties: {\n        config: value\n      }\n    });\n  };\n  const getValue = () => {\n    return constraint.config;\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: constraint,\n    id: idPrefix + '-config',\n    label: translate('Config'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\nfunction FormFieldProperty(props) {\n  const {\n    element,\n    idPrefix,\n    property\n  } = props;\n  const entries = [{\n    id: idPrefix + '-id',\n    component: Id$2,\n    idPrefix,\n    property,\n    element\n  }, {\n    id: idPrefix + '-value',\n    component: Value$1,\n    idPrefix,\n    property,\n    element\n  }];\n  return entries;\n}\nfunction Id$2(props) {\n  const {\n    idPrefix,\n    element,\n    property\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: property,\n      properties: {\n        id: value\n      }\n    });\n  };\n  const getValue = () => {\n    return property.id;\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: property,\n    id: idPrefix + '-id',\n    label: translate('ID'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Value$1(props) {\n  const {\n    idPrefix,\n    element,\n    property\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: property,\n      properties: {\n        value\n      }\n    });\n  };\n  const getValue = () => {\n    return property.value;\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: property,\n    id: idPrefix + '-value',\n    label: translate('Value'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\nfunction FormFieldValue(props) {\n  const {\n    element,\n    idPrefix,\n    value\n  } = props;\n  const entries = [{\n    id: idPrefix + '-id',\n    component: Id$1,\n    idPrefix,\n    value,\n    element\n  }, {\n    id: idPrefix + '-name',\n    component: Name,\n    idPrefix,\n    value,\n    element\n  }];\n  return entries;\n}\nfunction Id$1(props) {\n  const {\n    idPrefix,\n    element,\n    value\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const setValue = val => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: value,\n      properties: {\n        id: val\n      }\n    });\n  };\n  const getValue = () => {\n    return value.id;\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: value,\n    id: idPrefix + '-id',\n    label: translate('ID'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Name(props) {\n  const {\n    idPrefix,\n    element,\n    value\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const setValue = val => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: value,\n      properties: {\n        name: val\n      }\n    });\n  };\n  const getValue = () => {\n    return value.name;\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: value,\n    id: idPrefix + '-name',\n    label: translate('Name'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\nconst CUSTOM_TYPE_VALUE = '',\n  DEFINED_TYPE_VALUES = ['boolean', 'date', 'enum', 'long', 'string', undefined];\nfunction FormField(props) {\n  const {\n    idPrefix,\n    formField\n  } = props;\n  const entries = [{\n    id: idPrefix + '-formFieldID',\n    component: Id,\n    idPrefix,\n    formField\n  }, {\n    id: idPrefix + '-formFieldLabel',\n    component: Label,\n    idPrefix,\n    formField\n  }, {\n    id: idPrefix + '-formFieldType',\n    component: Type$1,\n    idPrefix,\n    formField\n  }];\n  if (!DEFINED_TYPE_VALUES.includes(formField.get('type'))) {\n    entries.push({\n      id: idPrefix + '-formFieldCustomType',\n      component: CustomType,\n      idPrefix,\n      formField\n    });\n  }\n  entries.push({\n    id: idPrefix + '-formFieldDefaultValue',\n    component: DefaultValue,\n    idPrefix,\n    formField\n  });\n  if (formField.get('type') === 'enum') {\n    entries.push({\n      id: idPrefix + '-formFieldValues',\n      component: ValueList,\n      formField,\n      idPrefix\n    });\n  }\n  entries.push({\n    id: idPrefix + '-formFieldConstraints',\n    component: ConstraintList,\n    formField,\n    idPrefix\n  }, {\n    id: idPrefix + '-formFieldProperties',\n    component: PropertiesList,\n    formField,\n    idPrefix\n  });\n  return entries;\n}\nfunction Id(props) {\n  const {\n    idPrefix,\n    element,\n    formField\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: formField,\n      properties: {\n        id: value\n      }\n    });\n  };\n  const getValue = () => {\n    return formField.get('id');\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: formField,\n    id: idPrefix + '-formFieldID',\n    label: translate('ID'),\n    description: translate('Refers to the process variable name'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Label(props) {\n  const {\n    idPrefix,\n    element,\n    formField\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: formField,\n      properties: {\n        label: value\n      }\n    });\n  };\n  const getValue = () => {\n    return formField.get('label');\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: formField,\n    id: idPrefix + '-formFieldLabel',\n    label: translate('Label'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Type$1(props) {\n  const {\n    idPrefix,\n    element,\n    formField\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: formField,\n      properties: {\n        type: value\n      }\n    });\n  };\n  const getValue = () => {\n    const type = formField.get('type');\n    return DEFINED_TYPE_VALUES.includes(type) ? type : CUSTOM_TYPE_VALUE;\n  };\n  const getOptions = () => {\n    const options = [{\n      label: translate('boolean'),\n      value: 'boolean'\n    }, {\n      label: translate('date'),\n      value: 'date'\n    }, {\n      label: translate('enum'),\n      value: 'enum'\n    }, {\n      label: translate('long'),\n      value: 'long'\n    }, {\n      label: translate('string'),\n      value: 'string'\n    }, {\n      label: translate('<custom type>'),\n      value: CUSTOM_TYPE_VALUE\n    }];\n\n    // for the initial state only, we want to show an empty state\n    if (formField.get('type') === undefined) {\n      options.unshift({\n        label: translate('<none>'),\n        value: ''\n      });\n    }\n    return options;\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element: formField,\n    id: idPrefix + '-formFieldType',\n    label: translate('Type'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction CustomType(props) {\n  const {\n    idPrefix,\n    element,\n    formField\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    const type = value || '';\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: formField,\n      properties: {\n        type\n      }\n    });\n  };\n  const getValue = () => {\n    return formField.get('type');\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: formField,\n    id: idPrefix + '-formFieldCustomType',\n    label: translate('Custom type'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction DefaultValue(props) {\n  const {\n    idPrefix,\n    element,\n    formField\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: formField,\n      properties: {\n        defaultValue: value\n      }\n    });\n  };\n  const getValue = () => {\n    return formField.get('defaultValue');\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: formField,\n    id: idPrefix + '-formFieldDefaultValue',\n    label: translate('Default value'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Value(props) {\n  const {\n    element,\n    id: idPrefix,\n    index,\n    item: value,\n    open\n  } = props;\n  const translate = useService('translate');\n  const id = `${idPrefix}-value-${index}`;\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* CollapsibleEntry */.I1, {\n    id: id,\n    element: element,\n    entries: FormFieldValue({\n      idPrefix: id,\n      element,\n      value\n    }),\n    label: value.get('id') || translate('<empty>'),\n    open: open\n  });\n}\nfunction ValueList(props) {\n  const {\n    element,\n    formField,\n    idPrefix\n  } = props;\n  const id = `${idPrefix}-formFieldValues`;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const values = formField.get('values') || [];\n  function addValue() {\n    const value = createElement('camunda:Value', {\n      id: undefined,\n      name: undefined\n    }, formField, bpmnFactory);\n    commandStack.execute('element.updateModdleProperties', {\n      element: element,\n      moddleElement: formField,\n      properties: {\n        values: [...formField.get('values'), value]\n      }\n    });\n  }\n  function removeValue(value) {\n    commandStack.execute('element.updateModdleProperties', {\n      element: element,\n      moddleElement: formField,\n      properties: {\n        values: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(formField.get('values'), value)\n      }\n    });\n  }\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* ListEntry */.vW, {\n    element: element,\n    autoFocusEntry: `[data-entry-id=\"${id}-value-${values.length - 1}\"] input`,\n    id: id,\n    label: translate('Values'),\n    items: values,\n    component: Value,\n    onAdd: addValue,\n    onRemove: removeValue\n  });\n}\nfunction Constraint(props) {\n  const {\n    element,\n    id: idPrefix,\n    index,\n    item: constraint,\n    open\n  } = props;\n  const translate = useService('translate');\n  const id = `${idPrefix}-constraint-${index}`;\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* CollapsibleEntry */.I1, {\n    id: id,\n    element: element,\n    entries: FormFieldConstraint({\n      constraint,\n      element,\n      idPrefix: id\n    }),\n    label: constraint.get('name') || translate('<empty>'),\n    open: open\n  });\n}\nfunction ConstraintList(props) {\n  const {\n    element,\n    formField,\n    idPrefix\n  } = props;\n  const id = `${idPrefix}-formFieldConstraints`;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  let validation = formField.get('validation');\n  const constraints = validation && validation.get('constraints') || [];\n  function addConstraint() {\n    const commands = [];\n\n    // (1) ensure validation\n    if (!validation) {\n      validation = createElement('camunda:Validation', {}, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: formField,\n          properties: {\n            validation\n          }\n        }\n      });\n    }\n\n    // (2) add constraint\n    const constraint = createElement('camunda:Constraint', {\n      name: undefined,\n      config: undefined\n    }, validation, bpmnFactory);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: validation,\n        properties: {\n          constraints: [...validation.get('constraints'), constraint]\n        }\n      }\n    });\n\n    // (3) commit updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  }\n  function removeConstraint(constraint) {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: validation,\n      properties: {\n        constraints: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(validation.get('constraints'), constraint)\n      }\n    });\n  }\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* ListEntry */.vW, {\n    element: element,\n    autoFocusEntry: `[data-entry-id=\"${id}-constraint-${constraints.length - 1}\"] input`,\n    id: id,\n    label: translate('Constraints'),\n    items: constraints,\n    component: Constraint,\n    onAdd: addConstraint,\n    onRemove: removeConstraint\n  });\n}\nfunction Property(props) {\n  const {\n    element,\n    id: idPrefix,\n    index,\n    item: property,\n    open\n  } = props;\n  const translate = useService('translate');\n  const id = `${idPrefix}-property-${index}`;\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* CollapsibleEntry */.I1, {\n    id: id,\n    element: element,\n    entries: FormFieldProperty({\n      element,\n      idPrefix: id,\n      property\n    }),\n    label: property.get('id') || translate('<empty>'),\n    open: open\n  });\n}\nfunction PropertiesList(props) {\n  const {\n    element,\n    formField,\n    idPrefix\n  } = props;\n  const id = `${idPrefix}-formFieldProperties`;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  let properties = formField.get('properties');\n  const propertyEntries = properties && properties.get('values') || [];\n  function addProperty() {\n    const commands = [];\n\n    // (1) ensure properties\n    if (!properties) {\n      properties = createElement('camunda:Properties', {}, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: formField,\n          properties: {\n            properties\n          }\n        }\n      });\n    }\n\n    // (2) add property\n    const property = createElement('camunda:Property', {\n      id: undefined,\n      value: undefined\n    }, properties, bpmnFactory);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: properties,\n        properties: {\n          values: [...properties.get('values'), property]\n        }\n      }\n    });\n\n    // (3) commit updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  }\n  function removeProperty(property) {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: properties,\n      properties: {\n        values: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(properties.get('values'), property)\n      }\n    });\n  }\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* ListEntry */.vW, {\n    element: element,\n    autoFocusEntry: true,\n    id: id,\n    compareFn: createAlphanumericCompare('id'),\n    label: translate('Properties'),\n    items: propertyEntries,\n    component: Property,\n    onAdd: addProperty,\n    onRemove: removeProperty\n  });\n}\n\n// helper //////////////////\n\nfunction createAlphanumericCompare(field) {\n  return function (entry, anotherEntry) {\n    const [key = '', anotherKey = ''] = [entry[field], anotherEntry[field]];\n    return key === anotherKey ? 0 : key > anotherKey ? 1 : -1;\n  };\n}\n\nfunction FormDataProps({\n  element,\n  injector\n}) {\n  if (!isFormDataSupported(element)) {\n    return;\n  }\n  const formFields = getFormFieldsList(element) || [];\n  const bpmnFactory = injector.get('bpmnFactory'),\n    commandStack = injector.get('commandStack');\n  const items = formFields.map((formField, index) => {\n    const id = element.id + '-formField-' + index;\n    return {\n      id,\n      label: formField.get('id') || '',\n      entries: FormField({\n        idPrefix: id,\n        element,\n        formField\n      }),\n      autoFocusEntry: id + '-formFieldID',\n      remove: removeFactory$4({\n        commandStack,\n        element,\n        formField\n      })\n    };\n  });\n  return {\n    items,\n    add: addFactory$3({\n      bpmnFactory,\n      commandStack,\n      element\n    }),\n    shouldSort: false\n  };\n}\nfunction addFactory$3({\n  bpmnFactory,\n  commandStack,\n  element\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const commands = [];\n\n    // (1) get camunda:FormData\n    const formData = getFormData$1(element);\n\n    // (2) create camunda:FormField\n    const formField = createElement('camunda:FormField', {}, formData, bpmnFactory);\n\n    // (3) add formField to list\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: formData,\n        properties: {\n          fields: [...formData.get('fields'), formField]\n        }\n      }\n    });\n\n    // (4) commit all updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n}\nfunction removeFactory$4({\n  commandStack,\n  element,\n  formField\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const formData = getFormData$1(element),\n      formFields = getFormFieldsList(element);\n    if (!formFields || !formFields.length) {\n      return;\n    }\n    const fields = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(formData.get('fields'), formField);\n\n    // update formData\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: formData,\n      properties: {\n        fields\n      }\n    });\n  };\n}\n\n// helper ///////////////////////////////\n\nfunction isFormDataSupported(element) {\n  const formData = getFormData$1(element);\n  return ((0,ModelUtil.is)(element, 'bpmn:StartEvent') && !(0,ModelUtil.is)(element.parent, 'bpmn:SubProcess') || (0,ModelUtil.is)(element, 'bpmn:UserTask')) && formData;\n}\nfunction getFormData$1(element) {\n  const bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(bo, 'camunda:FormData')[0];\n}\nfunction getFormFieldsList(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const formData = getFormData$1(businessObject);\n  return formData && formData.fields;\n}\n\nconst FORM_KEY_PROPS = {\n  'camunda:formRef': undefined,\n  'camunda:formRefBinding': undefined,\n  'camunda:formRefVersion': undefined\n};\nconst FORM_REF_PROPS = {\n  'camunda:formKey': undefined\n};\nfunction FormTypeProps(props) {\n  return [{\n    id: 'formType',\n    component: FormType,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  }];\n}\nfunction FormType(props) {\n  const {\n    element\n  } = props;\n  const translate = useService('translate');\n  const bpmnFactory = useService('bpmnFactory');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const commandStack = useService('commandStack');\n  let extensionElements = businessObject.get('extensionElements');\n  const getValue = () => {\n    if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isDefined */.$K)(businessObject.get('camunda:formKey'))) {\n      return 'formKey';\n    } else if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isDefined */.$K)(businessObject.get('camunda:formRef'))) {\n      return 'formRef';\n    } else if (getFormData(element)) {\n      return 'formData';\n    }\n    return '';\n  };\n  const setValue = value => {\n    const commands = removePropertiesCommands(element);\n    if (value === 'formData') {\n      // (1) ensure extension elements\n      if (!extensionElements) {\n        extensionElements = createElement('bpmn:ExtensionElements', {\n          values: []\n        }, businessObject, bpmnFactory);\n        commands.push({\n          cmd: 'element.updateModdleProperties',\n          context: {\n            element,\n            moddleElement: businessObject,\n            properties: {\n              extensionElements\n            }\n          }\n        });\n      }\n\n      // (2) create camunda:FormData\n      const parent = extensionElements;\n      const formData = createElement('camunda:FormData', {\n        fields: []\n      }, parent, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), formData]\n          }\n        }\n      });\n    } else if (value === 'formKey') {\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            'camunda:formKey': ''\n          }\n        }\n      });\n    } else if (value === 'formRef') {\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            'camunda:formRef': ''\n          }\n        }\n      });\n    }\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  const getOptions = () => {\n    return [{\n      value: '',\n      label: translate('<none>')\n    }, {\n      value: 'formRef',\n      label: translate('Camunda Forms')\n    }, {\n      value: 'formKey',\n      label: translate('Embedded or External Task Forms')\n    }, {\n      value: 'formData',\n      label: translate('Generated Task Forms')\n    }];\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element,\n    id: 'formType',\n    label: translate('Type'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction getFormData(element) {\n  const bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(bo, 'camunda:FormData')[0];\n}\nfunction removePropertiesCommands(element, commandStack) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const extensionElements = businessObject.get('extensionElements');\n  const commands = [];\n\n  // (1) reset formKey and formRef\n  commands.push({\n    cmd: 'element.updateModdleProperties',\n    context: {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        ...FORM_KEY_PROPS,\n        ...FORM_REF_PROPS\n      }\n    }\n  });\n\n  // (2) remove formData if defined\n  if (extensionElements && getFormData(element)) {\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: extensionElements,\n        properties: {\n          values: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), getFormData(element))\n        }\n      }\n    });\n  }\n  return commands;\n}\n\nfunction getFormRefBinding(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return businessObject.get('camunda:formRefBinding') || 'latest';\n}\nfunction getFormType(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isDefined */.$K)(businessObject.get('camunda:formKey'))) {\n    return 'formKey';\n  } else if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isDefined */.$K)(businessObject.get('camunda:formRef'))) {\n    return 'formRef';\n  }\n}\nfunction isFormSupported(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:StartEvent') && !(0,ModelUtil.is)(element.parent, 'bpmn:SubProcess') || (0,ModelUtil.is)(element, 'bpmn:UserTask');\n}\n\nfunction FormProps(props) {\n  const {\n    element\n  } = props;\n  if (!isFormSupported(element)) {\n    return [];\n  }\n  const formType = getFormType(element),\n    bindingType = getFormRefBinding(element);\n\n  // (1) display form type select\n  const entries = [...FormTypeProps()];\n\n  // (2) display form properties based on type\n  if (formType === 'formKey') {\n    entries.push({\n      id: 'formKey',\n      component: FormKey,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  } else if (formType === 'formRef') {\n    entries.push({\n      id: 'formRef',\n      component: FormRef,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    }, {\n      id: 'formRefBinding',\n      component: Binding$1,\n      isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n    });\n    if (bindingType === 'version') {\n      entries.push({\n        id: 'formRefVersion',\n        component: Version$1,\n        isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n      });\n    }\n  }\n  return entries;\n}\nfunction FormKey(props) {\n  const {\n    element\n  } = props;\n  const debounce = useService('debounceInput');\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:formKey');\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      'camunda:formKey': value\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'formKey',\n    label: translate('Form key'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction FormRef(props) {\n  const {\n    element\n  } = props;\n  const debounce = useService('debounceInput');\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:formRef');\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      'camunda:formRef': value\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'formRef',\n    label: translate('Form reference'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Binding$1(props) {\n  const {\n    element\n  } = props;\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const getValue = () => {\n    return getFormRefBinding(element);\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      'camunda:formRefBinding': value\n    });\n  };\n\n  // Note: default is \"latest\",\n  // cf. https://docs.camunda.org/manual/develop/reference/bpmn20/custom-extensions/extension-attributes/#formrefbinding\n  const getOptions = () => {\n    const options = [{\n      value: 'deployment',\n      label: translate('deployment')\n    }, {\n      value: 'latest',\n      label: translate('latest')\n    }, {\n      value: 'version',\n      label: translate('version')\n    }];\n    return options;\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element,\n    id: 'formRefBinding',\n    label: translate('Binding'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction Version$1(props) {\n  const {\n    element\n  } = props;\n  const debounce = useService('debounceInput');\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:formRefVersion');\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      'camunda:formRefVersion': value\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'formRefVersion',\n    label: translate('Version'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\nfunction HistoryCleanupProps(props) {\n  const {\n    element\n  } = props;\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if (!(0,ModelUtil.is)(element, 'bpmn:Process') && !((0,ModelUtil.is)(element, 'bpmn:Participant') && businessObject.get('processRef'))) {\n    return [];\n  }\n  return [{\n    id: 'historyTimeToLive',\n    component: HistoryTimeToLive,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n}\nfunction HistoryTimeToLive(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const process = getProcess$2(element);\n  const getValue = () => {\n    return process.get('camunda:historyTimeToLive') || '';\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: process,\n      properties: {\n        'camunda:historyTimeToLive': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'historyTimeToLive',\n    label: translate('Time to live'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper //////////////////\n\nfunction getProcess$2(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Process') ? (0,ModelUtil/* getBusinessObject */.SS)(element) : (0,ModelUtil/* getBusinessObject */.SS)(element).get('processRef');\n}\n\nfunction DmnImplementationProps(props) {\n  const {\n    element\n  } = props;\n  const entries = [];\n  const implementationType = getImplementationType(element);\n  const bindingType = getDecisionRefBinding(element);\n  if (implementationType !== 'dmn') {\n    return entries;\n  }\n\n  // (1) decisionRef\n  entries.push({\n    id: 'decisionRef',\n    component: DecisionRef,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  });\n\n  // (2) binding\n  entries.push({\n    id: 'decisionRefBinding',\n    component: Binding,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  });\n\n  // (3) version\n  if (bindingType === 'version') {\n    entries.push({\n      id: 'decisionRefVersion',\n      component: Version,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n\n  // (4) versionTag\n  if (bindingType === 'versionTag') {\n    entries.push({\n      id: 'decisionRefVersionTag',\n      component: VersionTag$1,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n\n  // (5) tenantId\n  entries.push({\n    id: 'decisionRefTenantId',\n    component: TenantId,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  });\n\n  // (6) resultVariable\n  entries.push({\n    id: 'decisionRefResultVariable',\n    component: ResultVariable$2,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  });\n\n  // (7) mapDecisionResult\n  if (getResultVariable(element)) {\n    entries.push({\n      id: 'mapDecisionResult',\n      component: MapDecisionResult,\n      isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n    });\n  }\n  return entries;\n}\nfunction DecisionRef(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:decisionRef');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:decisionRef': value || ''\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'decisionRef',\n    label: translate('Decision reference'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Binding(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const getValue = () => {\n    return getDecisionRefBinding(element);\n  };\n  const setValue = value => {\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n    // reset version properties on binding type change\n    const updatedProperties = {\n      'camunda:decisionRefVersion': undefined,\n      'camunda:decisionRefVersionTag': undefined,\n      'camunda:decisionRefBinding': value\n    };\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: updatedProperties\n    });\n  };\n\n  // Note: default is \"latest\",\n  // cf. https://docs.camunda.org/manual/latest/reference/bpmn20/custom-extensions/extension-attributes/#decisionrefbinding\n  const getOptions = () => {\n    const options = [{\n      value: 'deployment',\n      label: translate('deployment')\n    }, {\n      value: 'latest',\n      label: translate('latest')\n    }, {\n      value: 'version',\n      label: translate('version')\n    }, {\n      value: 'versionTag',\n      label: translate('versionTag')\n    }];\n    return options;\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element,\n    id: 'decisionRefBinding',\n    label: translate('Binding'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction Version(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:decisionRefVersion');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:decisionRefVersion': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'decisionRefVersion',\n    label: translate('Version'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction VersionTag$1(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:decisionRefVersionTag');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:decisionRefVersionTag': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'decisionRefVersionTag',\n    label: translate('Version tag'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction TenantId(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:decisionRefTenantId');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:decisionRefTenantId': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'decisionRefTenantId',\n    label: translate('Tenant ID'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ResultVariable$2(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return getResultVariable(businessObject);\n  };\n\n  // Note: camunda:mapDecisionResult got cleaned up in modeling behavior\n  // cf. https://github.com/camunda/camunda-bpmn-js/blob/main/lib/camunda-platform/features/modeling/behavior/UpdateResultVariableBehavior.js\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:resultVariable': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'decisionRefResultVariable',\n    label: translate('Result variable'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction MapDecisionResult(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:mapDecisionResult') || 'resultList';\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:mapDecisionResult': value\n      }\n    });\n  };\n\n  // Note: default is \"resultList\",\n  // cf. https://docs.camunda.org/manual/latest/reference/bpmn20/custom-extensions/extension-attributes/#mapdecisionresult\n  const getOptions = () => {\n    const options = [{\n      value: 'collectEntries',\n      label: translate('collectEntries (List<Object>)')\n    }, {\n      value: 'resultList',\n      label: translate('resultList (List<Map<String, Object>>)')\n    }, {\n      value: 'singleEntry',\n      label: translate('singleEntry (TypedValue)')\n    }, {\n      value: 'singleResult',\n      label: translate('singleResult (Map<String, Object>)')\n    }];\n    return options;\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element,\n    id: 'mapDecisionResult',\n    label: translate('Map decision result'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\n\n// helper ////////////////////\n\nfunction getDecisionRefBinding(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return businessObject.get('camunda:decisionRefBinding') || 'latest';\n}\nfunction getResultVariable(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return businessObject.get('camunda:resultVariable');\n}\n\nconst DELEGATE_PROPS = {\n  'camunda:class': undefined,\n  'camunda:expression': undefined,\n  'camunda:delegateExpression': undefined,\n  'camunda:resultVariable': undefined\n};\nconst DMN_CAPABLE_PROPS = {\n  'camunda:decisionRef': undefined,\n  'camunda:decisionRefBinding': 'latest',\n  'camunda:decisionRefVersion': undefined,\n  'camunda:mapDecisionResult': 'resultList',\n  'camunda:decisionRefTenantId': undefined\n};\nconst EXTERNAL_CAPABLE_PROPS = {\n  'camunda:type': undefined,\n  'camunda:topic': undefined\n};\nconst IMPLEMENTATION_TYPE_NONE_LABEL = '<none>',\n  IMPLEMENTATION_TYPE_JAVA_LABEL = 'Java class',\n  IMPLEMENTATION_TYPE_EXPRESSION_LABEL = 'Expression',\n  IMPLEMENTATION_TYPE_DELEGATE_LABEL = 'Delegate expression',\n  IMPLEMENTATION_TYPE_DMN_LABEL = 'DMN',\n  IMPLEMENTATION_TYPE_EXTERNAL_LABEL = 'External',\n  IMPLEMENTATION_TYPE_CONNECTOR_LABEL = 'Connector';\nfunction ImplementationTypeProps(props) {\n  return [{\n    id: 'implementationType',\n    component: ImplementationType,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD\n  }];\n}\nfunction ImplementationType(props) {\n  const {\n    element\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const getValue = () => {\n    return getImplementationType(element) || '';\n  };\n  const setValue = value => {\n    const oldType = getImplementationType(element);\n    const businessObject = getServiceTaskLikeBusinessObject(element);\n    const commands = [];\n    let updatedProperties = DELEGATE_PROPS;\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) class, expression, delegateExpression\n    if (isDelegateType(value)) {\n      updatedProperties = {\n        ...updatedProperties,\n        [value]: isDelegateType(oldType) ? businessObject.get(`camunda:${oldType}`) : ''\n      };\n    }\n\n    // (2) dmn\n    if (isDmnCapable(businessObject)) {\n      updatedProperties = {\n        ...updatedProperties,\n        ...DMN_CAPABLE_PROPS\n      };\n      if (value === 'dmn') {\n        updatedProperties = {\n          ...updatedProperties,\n          'camunda:decisionRef': ''\n        };\n      }\n    }\n\n    // (3) external\n    // Note: error event definition elements got cleaned up in modeling behavior\n    // cf. https://github.com/camunda/camunda-bpmn-js/blob/main/lib/camunda-platform/features/modeling/behavior/DeleteErrorEventDefinitionBehavior.js\n    if (isExternalCapable(businessObject)) {\n      updatedProperties = {\n        ...updatedProperties,\n        ...EXTERNAL_CAPABLE_PROPS\n      };\n      if (value === 'external') {\n        updatedProperties = {\n          ...updatedProperties,\n          'camunda:type': 'external',\n          'camunda:topic': ''\n        };\n      }\n    }\n\n    // (4) connector\n    if (isServiceTaskLike(businessObject)) {\n      // (4.1) remove all connectors on type change\n      const connectors = getConnectors$1(businessObject);\n      if (connectors.length) {\n        commands.push({\n          cmd: 'element.updateModdleProperties',\n          context: {\n            element,\n            moddleElement: extensionElements,\n            properties: {\n              values: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), value => connectors.includes(value))\n            }\n          }\n        });\n      }\n\n      // (4.2) create connector\n      if (value === 'connector') {\n        // ensure extension elements\n        if (!extensionElements) {\n          extensionElements = createElement('bpmn:ExtensionElements', {\n            values: []\n          }, businessObject, bpmnFactory);\n          commands.push(UpdateModdlePropertiesCommand(element, businessObject, {\n            extensionElements\n          }));\n        }\n        const connector = createElement('camunda:Connector', {}, extensionElements, bpmnFactory);\n        commands.push({\n          cmd: 'element.updateModdleProperties',\n          context: {\n            element,\n            moddleElement: extensionElements,\n            properties: {\n              values: [...extensionElements.get('values'), connector]\n            }\n          }\n        });\n      }\n    }\n\n    // (5) collect all property updates\n    commands.push(UpdateModdlePropertiesCommand(element, businessObject, updatedProperties));\n\n    // (6) commit all updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  const getOptions = () => {\n    const businessObject = getServiceTaskLikeBusinessObject(element);\n    const options = [{\n      value: '',\n      label: translate(IMPLEMENTATION_TYPE_NONE_LABEL)\n    }, {\n      value: 'class',\n      label: translate(IMPLEMENTATION_TYPE_JAVA_LABEL)\n    }, {\n      value: 'expression',\n      label: translate(IMPLEMENTATION_TYPE_EXPRESSION_LABEL)\n    }, {\n      value: 'delegateExpression',\n      label: translate(IMPLEMENTATION_TYPE_DELEGATE_LABEL)\n    }];\n    if (isDmnCapable(businessObject)) {\n      options.push({\n        value: 'dmn',\n        label: translate(IMPLEMENTATION_TYPE_DMN_LABEL)\n      });\n    }\n    if (isExternalCapable(businessObject)) {\n      options.push({\n        value: 'external',\n        label: translate(IMPLEMENTATION_TYPE_EXTERNAL_LABEL)\n      });\n    }\n    if (isServiceTaskLike(businessObject)) {\n      options.push({\n        value: 'connector',\n        label: translate(IMPLEMENTATION_TYPE_CONNECTOR_LABEL)\n      });\n    }\n    return sortByPriority(options);\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element,\n    id: 'implementationType',\n    label: translate('Type'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\n\n// helper ///////////////////////\n\nfunction isDelegateType(type) {\n  return ['class', 'expression', 'delegateExpression'].includes(type);\n}\nfunction getConnectors$1(businessObject) {\n  return getExtensionElementsList(businessObject, 'camunda:Connector');\n}\nfunction UpdateModdlePropertiesCommand(element, businessObject, newProperties) {\n  return {\n    cmd: 'element.updateModdleProperties',\n    context: {\n      element,\n      moddleElement: businessObject,\n      properties: newProperties\n    }\n  };\n}\nfunction sortByPriority(options) {\n  const priorities = {\n    [IMPLEMENTATION_TYPE_NONE_LABEL]: 0,\n    [IMPLEMENTATION_TYPE_JAVA_LABEL]: 3,\n    [IMPLEMENTATION_TYPE_EXPRESSION_LABEL]: 4,\n    [IMPLEMENTATION_TYPE_DELEGATE_LABEL]: 5,\n    [IMPLEMENTATION_TYPE_DMN_LABEL]: 1,\n    [IMPLEMENTATION_TYPE_EXTERNAL_LABEL]: 2,\n    [IMPLEMENTATION_TYPE_CONNECTOR_LABEL]: 6\n  };\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* sortBy */.MR)(options, o => priorities[o.label]);\n}\n\nfunction ImplementationProps(props) {\n  const {\n    element\n  } = props;\n  if (!getServiceTaskLikeBusinessObject(element)) {\n    return [];\n  }\n  const implementationType = getImplementationType(element);\n\n  // (1) display implementation type select\n  const entries = [...ImplementationTypeProps()];\n\n  // (2) display implementation properties based on type\n  if (implementationType === 'class') {\n    entries.push({\n      id: 'javaClass',\n      component: JavaClass,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  } else if (implementationType === 'expression') {\n    entries.push({\n      id: 'expression',\n      component: Expression$1,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    }, {\n      id: 'expressionResultVariable',\n      component: ResultVariable$1,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  } else if (implementationType === 'delegateExpression') {\n    entries.push({\n      id: 'delegateExpression',\n      component: DelegateExpression,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  } else if (implementationType === 'dmn') {\n    entries.push(...DmnImplementationProps({\n      element\n    }));\n  } else if (implementationType === 'external') {\n    entries.push({\n      id: 'externalTopic',\n      component: Topic,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  } else if (implementationType === 'connector') {\n    entries.push({\n      id: 'connectorId',\n      component: ConnectorId,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n  return entries;\n}\nfunction JavaClass(props) {\n  const {\n    element,\n    businessObject = getServiceTaskLikeBusinessObject(element),\n    id = 'javaClass'\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return businessObject.get('camunda:class');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:class': value || ''\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id,\n    label: translate('Java class'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Expression$1(props) {\n  const {\n    element,\n    businessObject = getServiceTaskLikeBusinessObject(element),\n    id = 'expression'\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return businessObject.get('camunda:expression');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:expression': value || ''\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id,\n    label: translate('Expression'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ResultVariable$1(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = getServiceTaskLikeBusinessObject(element);\n  const getValue = () => {\n    return businessObject.get('camunda:resultVariable');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:resultVariable': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'expressionResultVariable',\n    label: translate('Result variable'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction DelegateExpression(props) {\n  const {\n    element,\n    businessObject = getServiceTaskLikeBusinessObject(element),\n    id = 'delegateExpression'\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return businessObject.get('camunda:delegateExpression');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:delegateExpression': value || ''\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id,\n    label: translate('Delegate expression'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Topic(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = getServiceTaskLikeBusinessObject(element);\n  const getValue = () => {\n    return businessObject.get('camunda:topic');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:topic': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'externalTopic',\n    label: translate('Topic'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ConnectorId(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const connector = getConnector(element);\n  const getValue = () => {\n    return connector.get('camunda:connectorId');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: connector,\n      properties: {\n        'camunda:connectorId': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'connectorId',\n    label: translate('Connector ID'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper //////////////////\n\nfunction getConnectors(businessObject) {\n  return getExtensionElementsList(businessObject, 'camunda:Connector');\n}\nfunction getConnector(element) {\n  const businessObject = getServiceTaskLikeBusinessObject(element);\n  const connectors = getConnectors(businessObject);\n  return connectors[0];\n}\n\nfunction InitiatorProps(props) {\n  const {\n    element\n  } = props;\n  if (!isInitiator(element)) {\n    return [];\n  }\n  return [{\n    id: 'initiator',\n    component: Initiator,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n}\nfunction Initiator(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:initiator');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:initiator': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'initiator',\n    label: translate('Initiator'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper ///////////////////\n\nfunction isInitiator(element) {\n  return (0,ModelUtil.is)(element, 'camunda:Initiator') && !(0,ModelUtil.is)(element.parent, 'bpmn:SubProcess');\n}\n\n/**\n * Cf. https://docs.camunda.org/manual/7.15/reference/bpmn20/subprocesses/call-activity/#passing-variables\n */\nfunction InMappingPropagationProps(props) {\n  const {\n    element\n  } = props;\n  if (!areInMappingsSupported$1(element)) {\n    return [];\n  }\n  const entries = [{\n    id: 'inMapping-propagation',\n    component: PropagateAll$1,\n    isEdited: properties_panel_dist_index_esm/* isCheckboxEntryEdited */.kv\n  }];\n  if (isPropagateAll$1(element)) {\n    entries.push({\n      id: 'inMapping-propagation-local',\n      component: Local$2,\n      isEdited: properties_panel_dist_index_esm/* isCheckboxEntryEdited */.kv\n    });\n  }\n  return entries;\n}\nfunction PropagateAll$1(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const getValue = () => {\n    return isPropagateAll$1(element);\n  };\n  const setValue = value => {\n    if (value) {\n      addInMapping();\n    } else {\n      removeInMapping();\n    }\n  };\n  function addInMapping() {\n    const businessObject = getSignalEventDefinition(element) || (0,ModelUtil/* getBusinessObject */.SS)(element);\n    const mapping = createElement('camunda:In', {\n      variables: 'all'\n    }, null, bpmnFactory);\n    addExtensionElements(element, businessObject, mapping, bpmnFactory, commandStack);\n  }\n  function removeInMapping() {\n    const businessObject = getSignalEventDefinition(element) || (0,ModelUtil/* getBusinessObject */.SS)(element);\n    const mappings = findRelevantInMappings(element);\n    removeExtensionElements(element, businessObject, mappings, commandStack);\n  }\n  return (0,properties_panel_dist_index_esm/* CheckboxEntry */.IN)({\n    id: 'inMapping-propagation',\n    label: translate('Propagate all variables'),\n    getValue,\n    setValue\n  });\n}\nfunction Local$2(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const mapping = findRelevantInMappings(element)[0];\n  const getValue = () => {\n    return mapping.get('camunda:local');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: mapping,\n      properties: {\n        local: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* CheckboxEntry */.IN)({\n    element,\n    id: 'inMapping-propagation-local',\n    label: translate('Local'),\n    getValue,\n    setValue\n  });\n}\n\n// helper //////////////////////////\n\nfunction areInMappingsSupported$1(element) {\n  const signalEventDefinition = getSignalEventDefinition(element);\n  if (signalEventDefinition) {\n    return (0,ModelUtil/* isAny */.JZ)(element, ['bpmn:IntermediateThrowEvent', 'bpmn:EndEvent']);\n  }\n  return (0,ModelUtil.is)(element, 'bpmn:CallActivity');\n}\nfunction getInMappings$1(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const signalEventDefinition = getSignalEventDefinition(businessObject);\n  return getExtensionElementsList(signalEventDefinition || businessObject, 'camunda:In');\n}\nfunction findRelevantInMappings(element) {\n  const inMappings = getInMappings$1(element);\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* filter */.hX)(inMappings, function (mapping) {\n    const variables = mapping.get('variables');\n    return variables && variables === 'all';\n  });\n}\nfunction isPropagateAll$1(element) {\n  const mappings = findRelevantInMappings(element);\n  return !!mappings.length;\n}\n\nconst DEFAULT_PROPS$1 = {\n  'source': undefined,\n  'sourceExpression': undefined\n};\nfunction InOutMapping(props) {\n  const {\n    idPrefix,\n    mapping\n  } = props;\n  const type = getInOutType(mapping);\n  const entries = [];\n\n  // (1) Type\n  entries.push({\n    id: idPrefix + '-type',\n    component: Type,\n    idPrefix,\n    mapping\n  });\n\n  // (2) Source\n  if (type === 'source') {\n    entries.push({\n      id: idPrefix + '-source',\n      component: Source,\n      idPrefix,\n      mapping\n    });\n  }\n\n  // (3) Source expression\n  if (type === 'sourceExpression') {\n    entries.push({\n      id: idPrefix + '-sourceExpression',\n      component: SourceExpression,\n      idPrefix,\n      mapping\n    });\n  }\n\n  // (4) Target\n  entries.push({\n    id: idPrefix + '-target',\n    component: Target,\n    idPrefix,\n    mapping\n  });\n\n  // (5) Local\n  entries.push({\n    id: idPrefix + '-local',\n    component: Local$1,\n    idPrefix,\n    mapping\n  });\n  return entries;\n}\nfunction Type(props) {\n  const {\n    idPrefix,\n    element,\n    mapping\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const getValue = mapping => {\n    return getInOutType(mapping);\n  };\n  const setValue = value => {\n    const properties = {\n      ...DEFAULT_PROPS$1,\n      [value]: ''\n    };\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: mapping,\n      properties\n    });\n  };\n  const getOptions = () => {\n    const options = [{\n      label: translate('Source'),\n      value: 'source'\n    }, {\n      label: translate('Source expression'),\n      value: 'sourceExpression'\n    }];\n    return options;\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element: mapping,\n    id: idPrefix + '-type',\n    label: translate('Type'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\nfunction Source(props) {\n  const {\n    idPrefix,\n    element,\n    mapping\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: mapping,\n      properties: {\n        source: value\n      }\n    });\n  };\n  const getValue = mapping => {\n    return mapping.get('camunda:source');\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: mapping,\n    id: idPrefix + '-source',\n    label: translate('Source'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction SourceExpression(props) {\n  const {\n    idPrefix,\n    element,\n    mapping\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: mapping,\n      properties: {\n        sourceExpression: value\n      }\n    });\n  };\n  const getValue = mapping => {\n    return mapping.get('camunda:sourceExpression');\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: mapping,\n    id: idPrefix + '-sourceExpression',\n    label: translate('Source expression'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Target(props) {\n  const {\n    idPrefix,\n    element,\n    mapping\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: mapping,\n      properties: {\n        target: value\n      }\n    });\n  };\n  const getValue = mapping => {\n    return mapping.get('camunda:target');\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element: mapping,\n    id: idPrefix + '-target',\n    label: translate('Target'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Local$1(props) {\n  const {\n    idPrefix,\n    element,\n    mapping\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const getValue = () => {\n    return mapping.get('camunda:local');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: mapping,\n      properties: {\n        local: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* CheckboxEntry */.IN)({\n    element,\n    id: idPrefix + '-local',\n    label: translate('Local'),\n    getValue,\n    setValue\n  });\n}\n\n// helper ///////////////////\n\nfunction getInOutType(mapping) {\n  let inOutType = '';\n  if (typeof mapping.source !== 'undefined') {\n    inOutType = 'source';\n  } else if (typeof mapping.sourceExpression !== 'undefined') {\n    inOutType = 'sourceExpression';\n  }\n  return inOutType;\n}\n\n/**\n * Cf. https://docs.camunda.org/manual/latest/reference/bpmn20/custom-extensions/extension-elements/#in\n */\nfunction InMappingProps({\n  element,\n  injector\n}) {\n  if (!areInMappingsSupported(element)) {\n    return null;\n  }\n  const variableMappings = getInMappings(element) || [];\n  const bpmnFactory = injector.get('bpmnFactory'),\n    commandStack = injector.get('commandStack');\n  const items = variableMappings.map((mapping, index) => {\n    const id = element.id + '-inMapping-' + index;\n    return {\n      id,\n      label: mapping.get('target') || '',\n      entries: InOutMapping({\n        idPrefix: id,\n        element,\n        mapping\n      }),\n      autoFocusEntry: id + '-target',\n      remove: removeFactory$3({\n        commandStack,\n        element,\n        mapping\n      })\n    };\n  });\n  return {\n    items,\n    add: addFactory$2({\n      bpmnFactory,\n      commandStack,\n      element\n    })\n  };\n}\nfunction removeFactory$3({\n  commandStack,\n  element,\n  mapping\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const businessObject = getSignalEventDefinition(element) || (0,ModelUtil/* getBusinessObject */.SS)(element);\n    removeExtensionElements(element, businessObject, mapping, commandStack);\n  };\n}\nfunction addFactory$2({\n  bpmnFactory,\n  commandStack,\n  element\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const businessObject = getSignalEventDefinition(element) || (0,ModelUtil/* getBusinessObject */.SS)(element);\n    const newMapping = createElement('camunda:In', {\n      source: '' // source is the default type\n    }, null, bpmnFactory);\n    addExtensionElements(element, businessObject, newMapping, bpmnFactory, commandStack);\n  };\n}\n\n// helper ///////////////\n\nfunction getInMappings(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const signalEventDefinition = getSignalEventDefinition(businessObject);\n  const mappings = getExtensionElementsList(signalEventDefinition || businessObject, 'camunda:In');\n\n  // only retrieve relevant mappings here, others are handled in other groups\n  // mapping.businessKey => camunda-platform/CallAvtivityProps\n  // mapping.variables => camunda-platform/InMappingPropagationProps\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* filter */.hX)(mappings, function (mapping) {\n    return !mapping.businessKey && !(mapping.variables && mapping.variables === 'all');\n  });\n}\nfunction areInMappingsSupported(element) {\n  const signalEventDefinition = getSignalEventDefinition(element);\n  if (signalEventDefinition) {\n    return (0,ModelUtil/* isAny */.JZ)(element, ['bpmn:IntermediateThrowEvent', 'bpmn:EndEvent']);\n  }\n  return (0,ModelUtil.is)(element, 'bpmn:CallActivity');\n}\n\nfunction InputProps(props) {\n  const {\n    element,\n    injector\n  } = props;\n  if (!areInputParametersSupported(element)) {\n    return null;\n  }\n  const inputParameters = getInputParameters(element) || [];\n  const bpmnFactory = injector.get('bpmnFactory'),\n    commandStack = injector.get('commandStack');\n  const items = inputParameters.map((parameter, index) => {\n    const id = element.id + '-inputParameter-' + index;\n    return {\n      id,\n      label: parameter.get('name') || '',\n      entries: InputOutputParameter({\n        idPrefix: id,\n        element,\n        parameter\n      }),\n      autoFocusEntry: id + '-name',\n      remove: removeFactory$2({\n        element,\n        commandStack,\n        parameter\n      })\n    };\n  });\n  function add(event) {\n    event.stopPropagation();\n    commandStack.execute('properties-panel.multi-command-executor', AddParameterCmd(element, 'camunda:InputParameter', bpmnFactory));\n  }\n  return {\n    items,\n    add\n  };\n}\nfunction removeFactory$2(props) {\n  const {\n    commandStack,\n    element,\n    parameter\n  } = props;\n  return function (event) {\n    event.stopPropagation();\n    const inputOutput = getInputOutput(element);\n    if (!inputOutput) {\n      return;\n    }\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: inputOutput,\n      properties: {\n        inputParameters: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(inputOutput.get('inputParameters'), parameter)\n      }\n    });\n  };\n}\n\nfunction JobExecutionProps(props) {\n  const {\n    element\n  } = props;\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const entries = [];\n\n  // (1) add retryTimeCycle field for camunda:asyncCapable enabled Elements\n  // or TimerEvents\n  if ((0,ModelUtil.is)(element, 'camunda:AsyncCapable') && isAsync$1(businessObject) || isTimerEvent(element)) {\n    entries.push({\n      id: 'retryTimeCycle',\n      component: RetryTimeCycle,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n\n  // (2) add jobPriority field for camunda:jobPriorized with async enabled\n  //  or Processes\n  //  or Processes referred to by participants\n  //  or TimerEvents\n  if ((0,ModelUtil.is)(element, 'camunda:JobPriorized') && isAsync$1(businessObject) || (0,ModelUtil.is)(element, 'bpmn:Process') || (0,ModelUtil.is)(element, 'bpmn:Participant') && businessObject.get('processRef') || isTimerEvent(element)) {\n    entries.push({\n      id: 'jobPriority',\n      component: JobPriority,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n  return entries;\n}\nfunction JobPriority(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil.is)(element, 'bpmn:Participant') ? (0,ModelUtil/* getBusinessObject */.SS)(element).get('processRef') : (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:jobPriority');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:jobPriority': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'jobPriority',\n    label: translate('Priority'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction RetryTimeCycle(props) {\n  const {\n    element\n  } = props;\n  const bpmnFactory = useService('bpmnFactory'),\n    commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    const failedJobRetryTimeCycle = getExtensionElementsList(businessObject, 'camunda:FailedJobRetryTimeCycle')[0];\n    return failedJobRetryTimeCycle && failedJobRetryTimeCycle.body;\n  };\n  const setValue = value => {\n    const commands = [];\n    let extensionElements = businessObject.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure failedJobRetryTimeCycle\n    let failedJobRetryTimeCycle = getExtensionElementsList(businessObject, 'camunda:FailedJobRetryTimeCycle')[0];\n    if (!failedJobRetryTimeCycle) {\n      failedJobRetryTimeCycle = createElement('camunda:FailedJobRetryTimeCycle', {}, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), failedJobRetryTimeCycle]\n          }\n        }\n      });\n    }\n\n    // (3) update failedJobRetryTimeCycle value\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: failedJobRetryTimeCycle,\n        properties: {\n          body: value\n        }\n      }\n    });\n\n    // (4) commit all updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'retryTimeCycle',\n    label: translate('Retry time cycle'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper //////////////////\n\n/**\n * @param  {ModdleElement} bo\n * @return {boolean} a boolean value\n */\nfunction isAsyncBefore$1(bo) {\n  return !!(bo.get('camunda:asyncBefore') || bo.get('camunda:async'));\n}\n\n/**\n * @param  {ModdleElement} bo\n * @return {boolean}\n */\nfunction isAsyncAfter$1(bo) {\n  return !!bo.get('camunda:asyncAfter');\n}\n\n/**\n * isAsync - returns true if the attribute 'camunda:asyncAfter' or 'camunda:asyncBefore'\n * is set to true.\n *\n * @param  {ModdleElement} bo\n * @return {boolean}\n */\nfunction isAsync$1(bo) {\n  return isAsyncAfter$1(bo) || isAsyncBefore$1(bo);\n}\n\n/**\n * isTimerEvent - returns true if the element is a bpmn:Event with a timerEventDefinition\n *\n * @param  {ModdleElement} element\n * @return {boolean}\n */\nfunction isTimerEvent(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Event') && getTimerEventDefinition$1(element);\n}\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction MultiInstanceProps(props) {\n  const {\n    element\n  } = props;\n  const loopCharacteristics = getLoopCharacteristics(element);\n  let entries = props.entries || [];\n  if (!isMultiInstanceSupported(element)) {\n    return entries;\n  }\n  entries.push({\n    id: 'collection',\n    component: Collection,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'elementVariable',\n    component: ElementVariable,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'multiInstanceAsynchronousBefore',\n    component: MultiInstanceAsynchronousBefore,\n    isEdited: properties_panel_dist_index_esm/* isCheckboxEntryEdited */.kv\n  }, {\n    id: 'multiInstanceAsynchronousAfter',\n    component: MultiInstanceAsynchronousAfter,\n    isEdited: properties_panel_dist_index_esm/* isCheckboxEntryEdited */.kv\n  });\n  if (isAsync(loopCharacteristics)) {\n    entries.push({\n      id: 'multiInstanceExclusive',\n      component: MultiInstanceExclusive,\n      isEdited: checkboxIsEditedInverted\n    }, {\n      id: 'multiInstanceRetryTimeCycle',\n      component: MultiInstanceRetryTimeCycle,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n    });\n  }\n  return entries;\n}\nfunction Collection(props) {\n  const {\n    element\n  } = props;\n  const debounce = useService('debounceInput');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const loopCharacteristics = getLoopCharacteristics(element);\n  const getValue = () => {\n    return getCollection(element);\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: loopCharacteristics,\n      properties: {\n        'camunda:collection': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'collection',\n    label: translate('Collection'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction ElementVariable(props) {\n  const {\n    element\n  } = props;\n  const debounce = useService('debounceInput');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const loopCharacteristics = getLoopCharacteristics(element);\n  const getValue = () => {\n    return getElementVariable(element);\n  };\n  const setValue = value => {\n    return commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: loopCharacteristics,\n      properties: {\n        'camunda:elementVariable': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'elementVariable',\n    label: translate('Element variable'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction MultiInstanceAsynchronousBefore(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const loopCharacteristics = getLoopCharacteristics(element);\n  const getValue = () => {\n    return isAsyncBefore(loopCharacteristics);\n  };\n  const setValue = value => {\n    // overwrite the legacy `async` property, we will use the more explicit `asyncBefore`\n    const properties = {\n      'camunda:asyncBefore': value,\n      'camunda:async': undefined\n    };\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: loopCharacteristics,\n      properties\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* CheckboxEntry */.IN)({\n    element,\n    id: 'multiInstanceAsynchronousBefore',\n    label: translate('Asynchronous before'),\n    getValue,\n    setValue\n  });\n}\nfunction MultiInstanceAsynchronousAfter(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const loopCharacteristics = getLoopCharacteristics(element);\n  const getValue = () => {\n    return isAsyncAfter(loopCharacteristics);\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: loopCharacteristics,\n      properties: {\n        'camunda:asyncAfter': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* CheckboxEntry */.IN)({\n    element,\n    id: 'multiInstanceAsynchronousAfter',\n    label: translate('Asynchronous after'),\n    getValue,\n    setValue\n  });\n}\nfunction MultiInstanceExclusive(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate');\n  const loopCharacteristics = getLoopCharacteristics(element);\n  const getValue = () => {\n    return isExclusive(loopCharacteristics);\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: loopCharacteristics,\n      properties: {\n        'camunda:exclusive': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* CheckboxEntry */.IN)({\n    element,\n    id: 'multiInstanceExclusive',\n    label: translate('Exclusive'),\n    getValue,\n    setValue\n  });\n}\nfunction MultiInstanceRetryTimeCycle(props) {\n  const {\n    element\n  } = props;\n  const bpmnFactory = useService('bpmnFactory'),\n    commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const loopCharacteristics = getLoopCharacteristics(element);\n  const getValue = () => {\n    const failedJobRetryTimeCycle = getExtensionElementsList(loopCharacteristics, 'camunda:FailedJobRetryTimeCycle')[0];\n    return failedJobRetryTimeCycle && failedJobRetryTimeCycle.body;\n  };\n  const setValue = value => {\n    const commands = [];\n    let extensionElements = loopCharacteristics.get('extensionElements');\n\n    // (1) ensure extension elements\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', {\n        values: []\n      }, loopCharacteristics, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: loopCharacteristics,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    }\n\n    // (2) ensure failedJobRetryTimeCycle\n    let failedJobRetryTimeCycle = getExtensionElementsList(loopCharacteristics, 'camunda:FailedJobRetryTimeCycle')[0];\n    if (!failedJobRetryTimeCycle) {\n      failedJobRetryTimeCycle = createElement('camunda:FailedJobRetryTimeCycle', {}, extensionElements, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element: loopCharacteristics,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), failedJobRetryTimeCycle]\n          }\n        }\n      });\n    }\n\n    // (3) update failedJobRetryTimeCycle value\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: failedJobRetryTimeCycle,\n        properties: {\n          body: value\n        }\n      }\n    });\n\n    // (4) commit all updates\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'multiInstanceRetryTimeCycle',\n    label: translate('Retry time cycle'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper ////////////////////////////\n\n// generic ///////////////////////////\n\n/**\n * isMultiInstanceSupported - check whether given element supports camunda specific props\n * for multiInstance (ref. <camunda:Cllectable>).\n *\n * @param {djs.model.Base} element\n * @return {boolean}\n */\nfunction isMultiInstanceSupported(element) {\n  const loopCharacteristics = getLoopCharacteristics(element);\n  return !!loopCharacteristics && (0,ModelUtil.is)(loopCharacteristics, 'camunda:Collectable');\n}\n\n/**\n * getProperty - get a property value of the loop characteristics.\n *\n * @param {djs.model.Base} element\n * @param {string} propertyName\n *\n * @return {any} the property value\n */\nfunction getProperty(element, propertyName) {\n  var loopCharacteristics = getLoopCharacteristics(element);\n  return loopCharacteristics && loopCharacteristics.get(propertyName);\n}\n\n/**\n * getLoopCharacteristics - get loopCharacteristics of a given element.\n *\n * @param {djs.model.Base} element\n * @return {ModdleElement<bpmn:MultiInstanceLoopCharacteristics> | undefined}\n */\nfunction getLoopCharacteristics(element) {\n  const bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return bo.loopCharacteristics;\n}\n\n// collection\n\n/**\n * getCollection - get the 'camunda:collection' attribute value of the loop characteristics.\n *\n * @param {djs.model.Base} element\n *\n * @return {string} the 'camunda:collection' value\n */\nfunction getCollection(element) {\n  return getProperty(element, 'camunda:collection');\n}\n\n// elementVariable\n\n/**\n * getElementVariable - get the 'camunda:elementVariable' attribute value of the loop characteristics.\n *\n * @param {djs.model.Base} element\n *\n * @return {string} the 'camunda:elementVariable' value\n */\nfunction getElementVariable(element) {\n  return getProperty(element, 'camunda:elementVariable');\n}\n\n// asyncBefore asyncAfter\n\n/**\n * Returns true if the attribute 'camunda:asyncBefore' is set\n * to true.\n *\n * @param  {ModdleElement} bo\n *\n * @return {boolean} a boolean value\n */\nfunction isAsyncBefore(bo) {\n  return !!(bo.get('camunda:asyncBefore') || bo.get('camunda:async'));\n}\n\n/**\n * Returns true if the attribute 'camunda:asyncAfter' is set\n * to true.\n *\n * @param  {ModdleElement} bo\n *\n * @return {boolean} a boolean value\n */\nfunction isAsyncAfter(bo) {\n  return !!bo.get('camunda:asyncAfter');\n}\n\n/**\n * Returns true if the attribute 'camunda:exclusive' is set\n * to true.\n *\n * @param  {ModdleElement} bo\n *\n * @return {boolean} a boolean value\n */\nfunction isExclusive(bo) {\n  return !!bo.get('camunda:exclusive');\n}\n\n/**\n * isAsync - returns true if the attribute 'camunda:asyncAfter' or 'camunda:asyncBefore'\n * is set to true.\n *\n * @param  {ModdleElement} bo\n * @return {boolean}\n */\nfunction isAsync(bo) {\n  return isAsyncAfter(bo) || isAsyncBefore(bo);\n}\n\n// Checkbox\n\nfunction checkboxIsEditedInverted(node) {\n  return node && !node.checked;\n}\n\n/**\n * Cf. https://docs.camunda.org/manual/7.15/reference/bpmn20/subprocesses/call-activity/#passing-variables\n */\nfunction OutMappingPropagationProps(props) {\n  const {\n    element\n  } = props;\n  if (!areOutMappingsSupported$1(element)) {\n    return [];\n  }\n  const entries = [{\n    id: 'outMapping-propagation',\n    component: PropagateAll,\n    isEdited: properties_panel_dist_index_esm/* isCheckboxEntryEdited */.kv\n  }];\n  if (isPropagateAll(element)) {\n    entries.push({\n      id: 'outMapping-propagation-local',\n      component: Local,\n      isEdited: properties_panel_dist_index_esm/* isCheckboxEntryEdited */.kv\n    });\n  }\n  return entries;\n}\nfunction PropagateAll(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const bpmnFactory = useService('bpmnFactory');\n  const translate = useService('translate');\n  const getValue = () => {\n    return isPropagateAll(element);\n  };\n  const setValue = value => {\n    if (value) {\n      addOutMapping();\n    } else {\n      removeOutMapping();\n    }\n  };\n  function addOutMapping() {\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    const mapping = createElement('camunda:Out', {\n      variables: 'all'\n    }, null, bpmnFactory);\n    addExtensionElements(element, businessObject, mapping, bpmnFactory, commandStack);\n  }\n  function removeOutMapping() {\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    const mappings = findRelevantOutMappings(element);\n    removeExtensionElements(element, businessObject, mappings, commandStack);\n  }\n  return (0,properties_panel_dist_index_esm/* CheckboxEntry */.IN)({\n    id: 'outMapping-propagation',\n    label: translate('Propagate all variables'),\n    getValue,\n    setValue\n  });\n}\nfunction Local(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const mapping = findRelevantOutMappings(element)[0];\n  const getValue = () => {\n    return mapping.get('camunda:local');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: mapping,\n      properties: {\n        local: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* CheckboxEntry */.IN)({\n    element,\n    id: 'outMapping-propagation-local',\n    label: translate('Local'),\n    getValue,\n    setValue\n  });\n}\n\n// helper //////////////////////////\n\nfunction areOutMappingsSupported$1(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:CallActivity');\n}\nfunction getOutMappings$1(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return getExtensionElementsList(businessObject, 'camunda:Out');\n}\nfunction findRelevantOutMappings(element) {\n  const inMappings = getOutMappings$1(element);\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* filter */.hX)(inMappings, function (mapping) {\n    const variables = mapping.get('variables');\n    return variables && variables === 'all';\n  });\n}\nfunction isPropagateAll(element) {\n  const mappings = findRelevantOutMappings(element);\n  return !!mappings.length;\n}\n\n/**\n * Cf. https://docs.camunda.org/manual/latest/reference/bpmn20/custom-extensions/extension-elements/#out\n */\nfunction OutMappingProps({\n  element,\n  injector\n}) {\n  if (!areOutMappingsSupported(element)) {\n    return null;\n  }\n  const variableMappings = getOutMappings(element) || [];\n  const bpmnFactory = injector.get('bpmnFactory'),\n    commandStack = injector.get('commandStack');\n  const items = variableMappings.map((mapping, index) => {\n    const id = element.id + '-outMapping-' + index;\n    return {\n      id,\n      label: mapping.get('target') || '',\n      entries: InOutMapping({\n        idPrefix: id,\n        element,\n        mapping\n      }),\n      autoFocusEntry: id + '-target',\n      remove: removeFactory$1({\n        commandStack,\n        element,\n        mapping\n      })\n    };\n  });\n  return {\n    items,\n    add: addFactory$1({\n      bpmnFactory,\n      commandStack,\n      element\n    })\n  };\n}\nfunction removeFactory$1({\n  commandStack,\n  element,\n  mapping\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    removeExtensionElements(element, businessObject, mapping, commandStack);\n  };\n}\nfunction addFactory$1({\n  bpmnFactory,\n  commandStack,\n  element\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    const newMapping = createElement('camunda:Out', {\n      source: '' // source is the default type\n    }, null, bpmnFactory);\n    addExtensionElements(element, businessObject, newMapping, bpmnFactory, commandStack);\n  };\n}\n\n// helper ///////////////\n\nfunction getOutMappings(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const mappings = getExtensionElementsList(businessObject, 'camunda:Out');\n\n  // only retrieve relevant mappings here, others are handled in other groups\n  // mapping.businessKey => camunda-platform/CallAvtivityProps\n  // mapping.variables => camunda-platform/OutMappingPropagationProps\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* filter */.hX)(mappings, function (mapping) {\n    return !mapping.businessKey && !(mapping.variables && mapping.variables === 'all');\n  });\n}\nfunction areOutMappingsSupported(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:CallActivity');\n}\n\nfunction OutputProps({\n  element,\n  injector\n}) {\n  if (!areOutputParametersSupported(element)) {\n    return null;\n  }\n  const outputParameters = getOutputParameters(element) || [];\n  const bpmnFactory = injector.get('bpmnFactory'),\n    commandStack = injector.get('commandStack');\n  const items = outputParameters.map((parameter, index) => {\n    const id = element.id + '-outputParameter-' + index;\n    return {\n      id,\n      label: parameter.get('name') || '',\n      entries: InputOutputParameter({\n        idPrefix: id,\n        element,\n        parameter\n      }),\n      autoFocusEntry: id + '-name',\n      remove: removeFactory({\n        commandStack,\n        element,\n        parameter\n      })\n    };\n  });\n  return {\n    items,\n    add: addFactory({\n      bpmnFactory,\n      commandStack,\n      element\n    })\n  };\n}\nfunction removeFactory({\n  commandStack,\n  element,\n  parameter\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const inputOutput = getInputOutput(element);\n    if (!inputOutput) {\n      return;\n    }\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: inputOutput,\n      properties: {\n        outputParameters: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(inputOutput.get('outputParameters'), parameter)\n      }\n    });\n  };\n}\nfunction addFactory({\n  bpmnFactory,\n  commandStack,\n  element\n}) {\n  return function (event) {\n    event.stopPropagation();\n    commandStack.execute('properties-panel.multi-command-executor', AddParameterCmd(element, 'camunda:OutputParameter', bpmnFactory));\n  };\n}\n\nconst LISTENER_ALLOWED_TYPES = ['bpmn:Activity', 'bpmn:Event', 'bpmn:Gateway', 'bpmn:SequenceFlow', 'bpmn:Process', 'bpmn:Participant'];\nconst SCRIPT_PROPS = {\n  'script': undefined,\n  'resource': undefined,\n  'scriptFormat': undefined\n};\nconst CLASS_PROPS = {\n  'class': undefined\n};\nconst EXPRESSION_PROPS = {\n  'expression': undefined\n};\nconst DELEGATE_EXPRESSION_PROPS = {\n  'delegateExpression': undefined\n};\nconst DEFAULT_PROPS = {\n  ...SCRIPT_PROPS,\n  ...CLASS_PROPS,\n  ...EXPRESSION_PROPS,\n  ...DELEGATE_EXPRESSION_PROPS\n};\nconst DEFAULT_EVENT_PROPS = {\n  'eventDefinitions': undefined,\n  'event': undefined\n};\nconst IMPLEMENTATION_TYPE_TO_LABEL = {\n  class: 'Java class',\n  expression: 'Expression',\n  delegateExpression: 'Delegate expression',\n  script: 'Script'\n};\nconst EVENT_TO_LABEL = {\n  start: 'Start',\n  end: 'End',\n  take: 'Take',\n  create: 'Create',\n  assignment: 'Assignment',\n  complete: 'Complete',\n  delete: 'Delete',\n  update: 'Update',\n  timeout: 'Timeout'\n};\n\n/**\n * Cf. https://docs.camunda.org/manual/latest/user-guide/process-engine/delegation-code/#execution-listener\n */\nfunction ExecutionListenerProps({\n  element,\n  injector\n}) {\n  if (!(0,ModelUtil/* isAny */.JZ)(element, LISTENER_ALLOWED_TYPES)) {\n    return;\n  }\n  const bpmnFactory = injector.get('bpmnFactory'),\n    commandStack = injector.get('commandStack');\n  if ((0,ModelUtil.is)(element, 'bpmn:Participant') && !element.businessObject.processRef) {\n    return;\n  }\n  const businessObject = getListenersContainer(element);\n  const listeners = getExtensionElementsList(businessObject, 'camunda:ExecutionListener');\n  return {\n    items: listeners.map((listener, index) => {\n      const id = `${element.id}-executionListener-${index}`;\n\n      // @TODO(barmac): Find a way to pass translate for internationalized label.\n      return {\n        id,\n        label: getListenerLabel(listener),\n        entries: ExecutionListener({\n          idPrefix: id,\n          element,\n          listener\n        }),\n        remove: removeListenerFactory({\n          element,\n          listener,\n          commandStack\n        })\n      };\n    }),\n    add: addExecutionListenerFactory({\n      bpmnFactory,\n      commandStack,\n      element\n    })\n  };\n}\nfunction ExecutionListener(props) {\n  const {\n    idPrefix,\n    element,\n    listener\n  } = props;\n  return [{\n    id: `${idPrefix}-eventType`,\n    component: EventType,\n    listener\n  }, {\n    id: `${idPrefix}-listenerType`,\n    component: ListenerType,\n    listener\n  }, ...ImplementationDetails({\n    idPrefix,\n    element,\n    listener\n  }), {\n    id: `${idPrefix}-fields`,\n    component: Fields,\n    listener\n  }];\n}\nfunction TaskListenerProps({\n  element,\n  injector\n}) {\n  if (!(0,ModelUtil.is)(element, 'bpmn:UserTask')) {\n    return;\n  }\n  const bpmnFactory = injector.get('bpmnFactory'),\n    commandStack = injector.get('commandStack');\n  const businessObject = getListenersContainer(element);\n  const listeners = getExtensionElementsList(businessObject, 'camunda:TaskListener');\n  return {\n    items: listeners.map((listener, index) => {\n      const id = `${element.id}-taskListener-${index}`;\n\n      // @TODO(barmac): Find a way to pass translate for internationalized label.\n      return {\n        id,\n        label: getListenerLabel(listener),\n        entries: TaskListener({\n          idPrefix: id,\n          element,\n          listener\n        }),\n        remove: removeListenerFactory({\n          element,\n          listener,\n          commandStack\n        })\n      };\n    }),\n    add: addTaskListenerFactory({\n      bpmnFactory,\n      commandStack,\n      element\n    })\n  };\n}\nfunction TaskListener(props) {\n  const {\n    idPrefix,\n    element,\n    listener\n  } = props;\n  return [{\n    id: `${idPrefix}-eventType`,\n    component: EventType,\n    listener\n  }, {\n    id: `${idPrefix}-listenerId`,\n    component: ListenerId,\n    listener\n  }, {\n    id: `${idPrefix}-listenerType`,\n    component: ListenerType,\n    listener\n  }, ...ImplementationDetails({\n    idPrefix,\n    element,\n    listener\n  }), ...EventTypeDetails({\n    idPrefix,\n    element,\n    listener\n  }), {\n    id: `${idPrefix}-fields`,\n    component: Fields,\n    listener\n  }];\n}\nfunction removeListenerFactory({\n  element,\n  listener,\n  commandStack\n}) {\n  return function removeListener(event) {\n    event.stopPropagation();\n    removeExtensionElements(element, getListenersContainer(element), listener, commandStack);\n  };\n}\nfunction EventType({\n  id,\n  element,\n  listener\n}) {\n  const translate = useService('translate');\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  function getValue() {\n    return listener.get('event');\n  }\n  function setValue(value) {\n    const properties = getDefaultEventTypeProperties(value, bpmnFactory);\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: listener,\n      properties\n    });\n  }\n  function getOptions() {\n    if ((0,ModelUtil.is)(listener, 'camunda:TaskListener')) {\n      return [{\n        value: 'create',\n        label: translate('create')\n      }, {\n        value: 'assignment',\n        label: translate('assignment')\n      }, {\n        value: 'complete',\n        label: translate('complete')\n      }, {\n        value: 'delete',\n        label: translate('delete')\n      }, {\n        value: 'update',\n        label: translate('update')\n      }, {\n        value: 'timeout',\n        label: translate('timeout')\n      }];\n    }\n    if ((0,ModelUtil.is)(element, 'bpmn:SequenceFlow')) {\n      return [{\n        value: 'take',\n        label: translate('take')\n      }];\n    }\n    return [{\n      value: 'start',\n      label: translate('start')\n    }, {\n      value: 'end',\n      label: translate('end')\n    }];\n  }\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* SelectEntry */.g0, {\n    id: id,\n    label: translate('Event type'),\n    getValue: getValue,\n    setValue: setValue,\n    getOptions: getOptions\n  });\n}\nfunction ListenerId({\n  id,\n  element,\n  listener\n}) {\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const commandStack = useService('commandStack');\n  let options = {\n    element,\n    id: id,\n    label: translate('Listener ID'),\n    debounce,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$,\n    setValue: value => {\n      commandStack.execute('element.updateModdleProperties', {\n        element,\n        moddleElement: listener,\n        properties: {\n          'camunda:id': value\n        }\n      });\n    },\n    getValue: () => {\n      return listener.get('camunda:id');\n    }\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)(options);\n}\nfunction ListenerType({\n  id,\n  element,\n  listener\n}) {\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const bpmnFactory = useService('bpmnFactory');\n  function getValue() {\n    return getListenerType(listener);\n  }\n  function setValue(value) {\n    const properties = getDefaultImplementationProperties(value, bpmnFactory);\n    modeling.updateModdleProperties(element, listener, properties);\n  }\n  function getOptions() {\n    return getListenerTypeOptions(translate);\n  }\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* SelectEntry */.g0, {\n    id: id,\n    label: translate('Listener type'),\n    getValue: getValue,\n    setValue: setValue,\n    getOptions: getOptions\n  });\n}\nfunction ImplementationDetails(props) {\n  const {\n    idPrefix,\n    element,\n    listener\n  } = props;\n  const type = getListenerType(listener);\n  if (type === 'class') {\n    return [{\n      id: getPrefixedId(idPrefix, 'javaClass'),\n      component: JavaClass,\n      businessObject: listener\n    }];\n  } else if (type === 'expression') {\n    return [{\n      id: getPrefixedId(idPrefix, 'expression'),\n      component: Expression$1,\n      businessObject: listener\n    }];\n  } else if (type === 'delegateExpression') {\n    return [{\n      id: getPrefixedId(idPrefix, 'delegateExpression'),\n      component: DelegateExpression,\n      businessObject: listener\n    }];\n  } else if (type === 'script') {\n    return ScriptProps({\n      element,\n      script: listener.get('script'),\n      prefix: idPrefix\n    });\n  }\n\n  // should never happen\n  return [];\n}\nfunction EventTypeDetails(props) {\n  const {\n    idPrefix,\n    element,\n    listener\n  } = props;\n  const type = listener.get('event');\n  if (type === 'timeout') {\n    return TimerProps$2({\n      element,\n      listener,\n      timerEventDefinition: getTimerEventDefinition$1(listener),\n      idPrefix: idPrefix\n    });\n  }\n  return [];\n}\nfunction Field(props) {\n  const {\n    element,\n    id: idPrefix,\n    index,\n    item: field,\n    open\n  } = props;\n  const fieldId = `${idPrefix}-field-${index}`;\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* CollapsibleEntry */.I1, {\n    id: fieldId,\n    element: element,\n    entries: FieldInjection({\n      element,\n      field,\n      idPrefix: fieldId\n    }),\n    label: field.get('name') || '<empty>',\n    open: open\n  });\n}\nfunction Fields(props) {\n  const {\n    id,\n    element,\n    listener\n  } = props;\n  const bpmnFactory = useService('bpmnFactory');\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const fields = listener.get('fields');\n  function addField() {\n    const field = createElement('camunda:Field', {}, listener, bpmnFactory);\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: listener,\n      properties: {\n        fields: [...listener.get('fields'), field]\n      }\n    });\n  }\n  function removeField(field) {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: listener,\n      properties: {\n        fields: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(listener.get('fields'), field)\n      }\n    });\n  }\n  return (0,jsxRuntime_module/* jsx */.tZ)(properties_panel_dist_index_esm/* ListEntry */.vW, {\n    id: id,\n    element: element,\n    label: translate('Field injection'),\n    items: fields,\n    component: Field,\n    onAdd: addField,\n    onRemove: removeField,\n    compareFn: compareName,\n    autoFocusEntry: true\n  });\n}\nfunction addListenerFactory({\n  bpmnFactory,\n  commandStack,\n  element,\n  listenerGroup\n}) {\n  return function (event) {\n    event.stopPropagation();\n    const listener = bpmnFactory.create(listenerGroup, {\n      event: getDefaultEvent(element, listenerGroup),\n      class: ''\n    });\n    const businessObject = getListenersContainer(element);\n    addExtensionElements(element, businessObject, listener, bpmnFactory, commandStack);\n  };\n}\nfunction addTaskListenerFactory(props) {\n  return addListenerFactory({\n    ...props,\n    listenerGroup: 'camunda:TaskListener'\n  });\n}\nfunction addExecutionListenerFactory(props) {\n  return addListenerFactory({\n    ...props,\n    listenerGroup: 'camunda:ExecutionListener'\n  });\n}\n\n// helper\n\n/**\n * Get a readable label for a listener.\n *\n * @param {ModdleElement} listener\n * @param {string => string} [translate]\n */\nfunction getListenerLabel(listener, translate = value => value) {\n  const event = listener.get('event');\n  const implementationType = getListenerType(listener);\n  return `${translate(EVENT_TO_LABEL[event])}: ${translate(IMPLEMENTATION_TYPE_TO_LABEL[implementationType])}`;\n}\nfunction getListenerTypeOptions(translate) {\n  return Object.entries(IMPLEMENTATION_TYPE_TO_LABEL).map(([value, label]) => ({\n    value,\n    label: translate(label)\n  }));\n}\nfunction getListenerType(listener) {\n  return getImplementationType(listener);\n}\nfunction getDefaultEvent(element, listenerGroup) {\n  if (listenerGroup === 'camunda:TaskListener') return 'create';\n  return (0,ModelUtil.is)(element, 'bpmn:SequenceFlow') ? 'take' : 'start';\n}\nfunction getDefaultImplementationProperties(type, bpmnFactory) {\n  switch (type) {\n    case 'class':\n      return {\n        ...DEFAULT_PROPS,\n        'class': ''\n      };\n    case 'expression':\n      return {\n        ...DEFAULT_PROPS,\n        'expression': ''\n      };\n    case 'delegateExpression':\n      return {\n        ...DEFAULT_PROPS,\n        'delegateExpression': ''\n      };\n    case 'script':\n      return {\n        ...DEFAULT_PROPS,\n        'script': bpmnFactory.create('camunda:Script')\n      };\n  }\n}\nfunction getDefaultEventTypeProperties(type, bpmnFactory) {\n  switch (type) {\n    case 'timeout':\n      return {\n        ...DEFAULT_EVENT_PROPS,\n        eventDefinitions: [bpmnFactory.create('bpmn:TimerEventDefinition')],\n        event: type\n      };\n    default:\n      return {\n        ...DEFAULT_EVENT_PROPS,\n        event: type\n      };\n  }\n}\nfunction getPrefixedId(prefix, id) {\n  return `${prefix}-${id}`;\n}\nfunction compareName(field, anotherField) {\n  const [name = '', anotherName = ''] = [field.name, anotherField.name];\n  return name === anotherName ? 0 : name > anotherName ? 1 : -1;\n}\nfunction getListenersContainer(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return businessObject.get('processRef') || businessObject;\n}\n\nfunction ProcessVariablesProps(props) {\n  const {\n    element\n  } = props;\n  if (!canHaveProcessVariables(element)) {\n    return null;\n  }\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const rootElement = getRootElement(businessObject);\n  const scope = getScope(element);\n\n  // (1) fetch available process variables for given scope\n  const variables = (0,dist/* getVariablesForScope */.wk)(scope, rootElement);\n  if (!variables.length) {\n    return null;\n  }\n  const withNames = populateElementNames(sortByName(variables));\n  const byScope = groupByScope(withNames);\n  const multiScope = isMultiScope(byScope);\n  let variableItems = [];\n\n  // (2) get variables to display\n  if (multiScope) {\n    // (2a) multiple scopes, sub scopes first\n    // assumption: variables extractor fetches parent variables first\n    const reversed = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* map */.UI)(reverse((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* keys */.XP)(byScope)), scopeKey => byScope[scopeKey]);\n    variableItems = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* flatten */.xH)(reversed);\n  } else {\n    // (2b) single scope\n    variableItems = withNames;\n  }\n  const items = variableItems.map((variable, index) => {\n    const id = element.id + '-variable-' + index;\n    return {\n      id,\n      label: variable.name,\n      entries: [...ProcessVariableItem({\n        idPrefix: id,\n        multiScope,\n        variable\n      })]\n    };\n  });\n  return {\n    items,\n    shouldSort: false\n  };\n}\nfunction ProcessVariableItem(props) {\n  const {\n    idPrefix,\n    multiScope,\n    variable\n  } = props;\n  let entries = [];\n  if (multiScope) {\n    entries.push({\n      id: idPrefix + '-scope',\n      component: index_esm_Scope,\n      idPrefix,\n      variable\n    });\n  }\n  entries.push({\n    id: idPrefix + '-createdIn',\n    component: CreatedIn,\n    idPrefix,\n    variable\n  });\n  return entries;\n}\nfunction index_esm_Scope(props) {\n  const {\n    idPrefix,\n    variable\n  } = props;\n  const translate = useService('translate');\n  const id = idPrefix + '-scope';\n  return (0,jsxRuntime_module/* jsxs */.BX)(\"div\", {\n    \"data-entry-id\": id,\n    class: \"bio-properties-panel-entry\",\n    children: [(0,jsxRuntime_module/* jsx */.tZ)(\"b\", {\n      style: \"font-weight: bold\",\n      class: \"bio-properties-panel-label\",\n      children: translate('Scope')\n    }), (0,jsxRuntime_module/* jsx */.tZ)(\"label\", {\n      id: prefixId(id),\n      class: \"bio-properties-panel-label\",\n      children: variable.scope\n    })]\n  });\n}\nfunction CreatedIn(props) {\n  const {\n    idPrefix,\n    variable\n  } = props;\n  const translate = useService('translate');\n  const id = idPrefix + '-createdIn';\n  const origin = variable.origin.join(', ');\n  return (0,jsxRuntime_module/* jsxs */.BX)(\"div\", {\n    \"data-entry-id\": id,\n    class: \"bio-properties-panel-entry\",\n    children: [(0,jsxRuntime_module/* jsx */.tZ)(\"b\", {\n      style: \"font-weight: bold\",\n      class: \"bio-properties-panel-label\",\n      children: translate('Created in')\n    }), (0,jsxRuntime_module/* jsx */.tZ)(\"label\", {\n      id: prefixId(id),\n      class: \"bio-properties-panel-label\",\n      children: origin\n    })]\n  });\n}\n\n// helper //////////////////////\n\nfunction canHaveProcessVariables(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  return (0,ModelUtil/* isAny */.JZ)(element, ['bpmn:Process', 'bpmn:SubProcess']) || (0,ModelUtil.is)(element, 'bpmn:Participant') && businessObject.get('processRef');\n}\nfunction getRootElement(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:Participant')) {\n    return businessObject.processRef;\n  }\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:Process')) {\n    return businessObject;\n  }\n  let parent = businessObject;\n  while (parent.$parent && !(0,ModelUtil.is)(parent, 'bpmn:Process')) {\n    parent = parent.$parent;\n  }\n  return parent;\n}\nfunction getScope(element) {\n  const bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if ((0,ModelUtil.is)(element, 'bpmn:Participant')) {\n    return bo.processRef.id;\n  }\n  return bo.id;\n}\nfunction sortByName(variables) {\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* sortBy */.MR)(variables, function (variable) {\n    return variable.name;\n  });\n}\nfunction groupByScope(variables) {\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* groupBy */.vM)(variables, 'scope');\n}\nfunction populateElementNames(variables) {\n  (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* forEach */.Ed)(variables, function (variable) {\n    const names = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* map */.UI)(variable.origin, function (element) {\n      return element.name || element.id;\n    });\n    variable.origin = names;\n    variable.scope = variable.scope.name || variable.scope.id;\n  });\n  return variables;\n}\nfunction isMultiScope(scopedVariables) {\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* keys */.XP)(scopedVariables).length > 1;\n}\nfunction reverse(array) {\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* map */.UI)(array, function (a, i) {\n    return array[array.length - 1 - i];\n  });\n}\nfunction prefixId(id) {\n  return `bio-properties-panel-${id}`;\n}\n\nfunction ScriptTaskProps(props) {\n  const {\n    element\n  } = props;\n  if (!(0,ModelUtil.is)(element, 'bpmn:ScriptTask')) {\n    return [];\n  }\n  const entries = [...ScriptProps({\n    element\n  })];\n  entries.push({\n    id: 'scriptResultVariable',\n    component: ResultVariable,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  });\n  return entries;\n}\nfunction ResultVariable(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:resultVariable');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:resultVariable': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'scriptResultVariable',\n    label: translate('Result variable'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\nfunction TasklistProps(props) {\n  const {\n    element\n  } = props;\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const isEdited = node => {\n    return node && !node.checked;\n  };\n  if (!(0,ModelUtil.is)(element, 'bpmn:Process') && !((0,ModelUtil.is)(element, 'bpmn:Participant') && businessObject.get('processRef'))) {\n    return [];\n  }\n  return [{\n    id: 'isStartableInTasklist',\n    component: Startable,\n    isEdited\n  }];\n}\nfunction Startable(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const process = getProcess$1(element);\n  const getValue = () => {\n    return process.get('camunda:isStartableInTasklist');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: process,\n      properties: {\n        'camunda:isStartableInTasklist': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* CheckboxEntry */.IN)({\n    element,\n    id: 'isStartableInTasklist',\n    label: translate('Startable'),\n    getValue,\n    setValue\n  });\n}\n\n// helper //////////////////\n\nfunction getProcess$1(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Process') ? (0,ModelUtil/* getBusinessObject */.SS)(element) : (0,ModelUtil/* getBusinessObject */.SS)(element).get('processRef');\n}\n\n/**\n * Cf. https://docs.camunda.org/manual/latest/reference/bpmn20/tasks/user-task/\n */\nfunction UserAssignmentProps(props) {\n  const {\n    element\n  } = props;\n  if (!(0,ModelUtil.is)(element, 'camunda:Assignable')) {\n    return [];\n  }\n  return [{\n    id: 'assignee',\n    component: Assignee,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'candidateGroups',\n    component: CandidateGroups,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'candidateUsers',\n    component: CandidateUsers,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'dueDate',\n    component: DueDate,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'followUpDate',\n    component: FollowUpDate,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }, {\n    id: 'priority',\n    component: Priority,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n}\nfunction Assignee(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:assignee');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:assignee': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'assignee',\n    label: translate('Assignee'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction CandidateUsers(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:candidateUsers');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:candidateUsers': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'candidateUsers',\n    label: translate('Candidate users'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction CandidateGroups(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:candidateGroups');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:candidateGroups': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'candidateGroups',\n    label: translate('Candidate groups'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction DueDate(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:dueDate');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:dueDate': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'dueDate',\n    label: translate('Due date'),\n    description: translate('The due date as an EL expression (e.g. ${someDate}) or an ISO date (e.g. 2015-06-26T09:54:00).'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction FollowUpDate(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:followUpDate');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:followUpDate': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'followUpDate',\n    label: translate('Follow up date'),\n    description: translate('The follow up date as an EL expression (e.g. ${someDate}) or an ' + 'ISO date (e.g. 2015-06-26T09:54:00).'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\nfunction Priority(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const getValue = () => {\n    return businessObject.get('camunda:priority');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: businessObject,\n      properties: {\n        'camunda:priority': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'priority',\n    label: translate('Priority'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\nfunction VersionTagProps(props) {\n  const {\n    element\n  } = props;\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if (!(0,ModelUtil.is)(element, 'bpmn:Process') && !((0,ModelUtil.is)(element, 'bpmn:Participant') && businessObject.get('processRef'))) {\n    return [];\n  }\n  return [{\n    id: 'versionTag',\n    component: VersionTag,\n    isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$\n  }];\n}\nfunction VersionTag(props) {\n  const {\n    element\n  } = props;\n  const commandStack = useService('commandStack');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const process = getProcess(element);\n  const getValue = () => {\n    return process.get('camunda:versionTag') || '';\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: process,\n      properties: {\n        'camunda:versionTag': value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'versionTag',\n    label: translate('Version tag'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n// helper //////////////////\n\nfunction getProcess(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Process') ? (0,ModelUtil/* getBusinessObject */.SS)(element) : (0,ModelUtil/* getBusinessObject */.SS)(element).get('processRef');\n}\n\nfunction TimerProps(props) {\n  const {\n    element,\n    listener,\n    idPrefix\n  } = props;\n  let {\n    timerEventDefinition\n  } = props;\n  if (!timerEventDefinition) {\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    timerEventDefinition = getTimerEventDefinition(businessObject);\n  }\n  const timerEventDefinitionType = getTimerDefinitionType(timerEventDefinition);\n\n  // (1) Only show for supported elements\n  if (!isTimerSupported(element) && !isTimerSupportedOnListener(listener)) {\n    return [];\n  }\n\n  // (2) Provide entries, have a value only if selection was made\n  const entries = [];\n  entries.push({\n    id: getId(idPrefix, 'timerEventDefinitionType'),\n    component: TimerEventDefinitionType,\n    isEdited: properties_panel_dist_index_esm/* isSelectEntryEdited */.bD,\n    timerEventDefinition,\n    timerEventDefinitionType\n  });\n  if (timerEventDefinitionType) {\n    entries.push({\n      id: getId(idPrefix, 'timerEventDefinitionValue'),\n      component: TimerEventDefinitionValue,\n      isEdited: properties_panel_dist_index_esm/* isTextFieldEntryEdited */.V$,\n      timerEventDefinition,\n      timerEventDefinitionType\n    });\n  }\n  return entries;\n}\n\n/**\n * TimerEventDefinitionType - Generic select entry allowing to select a specific\n * timerEventDefintionType. To be used together with timerEventDefinitionValue.\n *\n * @param  {type} props\n * @return {SelectEntry}\n */\nfunction TimerEventDefinitionType(props) {\n  const {\n    element,\n    timerEventDefinition,\n    timerEventDefinitionType\n  } = props;\n  const commandStack = useService('commandStack'),\n    bpmnFactory = useService('bpmnFactory'),\n    translate = useService('translate');\n  const getValue = () => {\n    return timerEventDefinitionType || '';\n  };\n  const setValue = value => {\n    // (1) Check if value is different to current type\n    if (value === timerEventDefinitionType) {\n      return;\n    }\n\n    // (2) Create empty formalExpression element\n    const formalExpression = bpmnFactory.create('bpmn:FormalExpression', {\n      body: undefined\n    });\n    formalExpression.$parent = timerEventDefinition;\n\n    // (3) Set the value for selected timerEventDefinitionType\n    const newProps = {\n      timeDuration: undefined,\n      timeDate: undefined,\n      timeCycle: undefined\n    };\n    if (value !== '') {\n      newProps[value] = formalExpression;\n    }\n\n    // (4) Execute businessObject update\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: timerEventDefinition,\n      properties: newProps\n    });\n  };\n  const getOptions = element => {\n    return [{\n      value: '',\n      label: translate('<none>')\n    }, {\n      value: 'timeDate',\n      label: translate('Date')\n    }, {\n      value: 'timeDuration',\n      label: translate('Duration')\n    }, {\n      value: 'timeCycle',\n      label: translate('Cycle')\n    }];\n  };\n  return (0,properties_panel_dist_index_esm/* SelectEntry */.g0)({\n    element,\n    id: 'timerEventDefinitionType',\n    label: translate('Type'),\n    getValue,\n    setValue,\n    getOptions\n  });\n}\n\n/**\n * TimerEventDefinitionValue - Generic textField entry allowing to specify the\n * timerEventDefintionValue based on the set timerEventDefintionType. To be used\n * together with timerEventDefinitionType.\n *\n * @param  {type} props\n * @return {TextFieldEntry}\n */\nfunction TimerEventDefinitionValue(props) {\n  const {\n    element,\n    timerEventDefinition,\n    timerEventDefinitionType\n  } = props;\n  const commandStack = useService('commandStack'),\n    translate = useService('translate'),\n    debounce = useService('debounceInput');\n  const timerEventFormalExpression = timerEventDefinition.get(timerEventDefinitionType);\n  const getValue = () => {\n    return timerEventFormalExpression && timerEventFormalExpression.get('body');\n  };\n  const setValue = value => {\n    commandStack.execute('element.updateModdleProperties', {\n      element,\n      moddleElement: timerEventFormalExpression,\n      properties: {\n        body: value\n      }\n    });\n  };\n  return (0,properties_panel_dist_index_esm/* TextFieldEntry */.Tq)({\n    element,\n    id: 'timerEventDefinitionValue',\n    label: translate('Value'),\n    getValue,\n    setValue,\n    debounce,\n    description: getTimerEventDefinitionValueDescription(timerEventDefinitionType, translate)\n  });\n}\n\n// helper //////////////////////////\n\nfunction getTimerEventDefinitionValueDescription(timerDefinitionType, translate) {\n  switch (timerDefinitionType) {\n    case 'timeDate':\n      return (0,jsxRuntime_module/* jsxs */.BX)(\"div\", {\n        children: [(0,jsxRuntime_module/* jsx */.tZ)(\"p\", {\n          children: translate('A specific point in time defined as ISO 8601 combined date and time representation.')\n        }), (0,jsxRuntime_module/* jsxs */.BX)(\"ul\", {\n          children: [(0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"2019-10-01T12:00:00Z\"\n            }), \" - \", translate('UTC time')]\n          }), (0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"2019-10-02T08:09:40+02:00\"\n            }), \" - \", translate('UTC plus 2 hours zone offset')]\n          })]\n        }), (0,jsxRuntime_module/* jsx */.tZ)(\"a\", {\n          href: \"https://docs.camunda.org/manual/latest/reference/bpmn20/events/timer-events/#time-date\",\n          target: \"_blank\",\n          rel: \"noopener\",\n          children: translate('Documentation: Timer events')\n        })]\n      });\n    case 'timeCycle':\n      return (0,jsxRuntime_module/* jsxs */.BX)(\"div\", {\n        children: [(0,jsxRuntime_module/* jsx */.tZ)(\"p\", {\n          children: translate('A cycle defined as ISO 8601 repeating intervals format, or a cron expression.')\n        }), (0,jsxRuntime_module/* jsxs */.BX)(\"ul\", {\n          children: [(0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"R5/PT10S\"\n            }), \" - \", translate('every 10 seconds, up to 5 times')]\n          }), (0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"R/P1D\"\n            }), \" - \", translate('every day, infinitely')]\n          }), (0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"0 0 9-17 * * MON-FRI\"\n            }), \" - \", translate('every hour on the hour from 9-5 p.m. UTC Monday-Friday')]\n          })]\n        }), (0,jsxRuntime_module/* jsx */.tZ)(\"a\", {\n          href: \"https://docs.camunda.org/manual/latest/reference/bpmn20/events/timer-events/#time-cycle\",\n          target: \"_blank\",\n          rel: \"noopener\",\n          children: translate('Documentation: Timer events')\n        })]\n      });\n    case 'timeDuration':\n      return (0,jsxRuntime_module/* jsxs */.BX)(\"div\", {\n        children: [(0,jsxRuntime_module/* jsx */.tZ)(\"p\", {\n          children: translate('A time duration defined as ISO 8601 durations format.')\n        }), (0,jsxRuntime_module/* jsxs */.BX)(\"ul\", {\n          children: [(0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"PT15S\"\n            }), \" - \", translate('15 seconds')]\n          }), (0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"PT1H30M\"\n            }), \" - \", translate('1 hour and 30 minutes')]\n          }), (0,jsxRuntime_module/* jsxs */.BX)(\"li\", {\n            children: [(0,jsxRuntime_module/* jsx */.tZ)(\"code\", {\n              children: \"P14D\"\n            }), \" - \", translate('14 days')]\n          })]\n        }), (0,jsxRuntime_module/* jsx */.tZ)(\"a\", {\n          href: \"https://docs.camunda.org/manual/latest/reference/bpmn20/events/timer-events/#time-duration\",\n          target: \"_blank\",\n          rel: \"noopener\",\n          children: translate('Documentation: Timer events')\n        })]\n      });\n  }\n}\nfunction isTimerSupportedOnListener(listener) {\n  return listener && (0,ModelUtil.is)(listener, 'camunda:TaskListener') && getTimerEventDefinition(listener);\n}\nfunction getId(idPrefix, id) {\n  return idPrefix ? idPrefix + id : id;\n}\n\nconst dist_index_esm_LOW_PRIORITY = 500;\nconst CAMUNDA_PLATFORM_GROUPS = [HistoryCleanupGroup, TasklistGroup, CandidateStarterGroup, ImplementationGroup, ExternalTaskGroup, ProcessVariablesGroup, ErrorsGroup, UserAssignmentGroup, FormGroup, FormDataGroup, TaskListenerGroup, StartInitiatorGroup, ScriptGroup, ConditionGroup, CallActivityGroup, AsynchronousContinuationsGroup, JobExecutionGroup, InMappingPropagationGroup, InMappingGroup, InputGroup, ConnectorInputGroup, OutMappingPropagationGroup, OutMappingGroup, OutputGroup, ConnectorOutputGroup, ExecutionListenerGroup, ExtensionPropertiesGroup, FieldInjectionGroup, BusinessKeyGroup];\n\n/**\n * Provides `camunda` namespace properties.\n *\n * @example\n * ```javascript\n * import BpmnModeler from 'bpmn-js/lib/Modeler';\n * import {\n *   BpmnPropertiesPanelModule,\n *   BpmnPropertiesProviderModule,\n *   CamundaPlatformPropertiesProviderModule\n * } from 'bpmn-js-properties-panel';\n *\n * const modeler = new BpmnModeler({\n *   container: '#canvas',\n *   propertiesPanel: {\n *     parent: '#properties'\n *   },\n *   additionalModules: [\n *     BpmnPropertiesPanelModule,\n *     BpmnPropertiesProviderModule,\n *     CamundaPlatformPropertiesProviderModule\n *   ]\n * });\n * ```\n */\nclass CamundaPlatformPropertiesProvider {\n  constructor(propertiesPanel, injector) {\n    propertiesPanel.registerProvider(dist_index_esm_LOW_PRIORITY, this);\n    this._injector = injector;\n  }\n  getGroups(element) {\n    return groups => {\n      // (1) add Camunda Platform specific groups\n      groups = groups.concat(this._getGroups(element));\n\n      // (2) update existing groups with Camunda Platform specific properties\n      updateGeneralGroup(groups, element);\n      updateErrorGroup(groups, element);\n      updateEscalationGroup(groups, element);\n      updateMultiInstanceGroup(groups, element);\n      updateTimerGroup(groups, element);\n\n      // (3) move groups given specific priorities\n      moveImplementationGroup(groups);\n      return groups;\n    };\n  }\n  _getGroups(element) {\n    const groups = CAMUNDA_PLATFORM_GROUPS.map(createGroup => createGroup(element, this._injector));\n\n    // contract: if a group returns null, it should not be displayed at all\n    return groups.filter(group => group !== null);\n  }\n}\nCamundaPlatformPropertiesProvider.$inject = ['propertiesPanel', 'injector'];\n\n/**\n * This ensures the <Implementation> group always locates after <Documentation>\n */\nfunction moveImplementationGroup(groups) {\n  const documentationGroupIdx = findGroupIndex(groups, 'documentation');\n  if (documentationGroupIdx < 0) {\n    return;\n  }\n  return moveGroup(groups, 'CamundaPlatform__Implementation', documentationGroupIdx + 1);\n}\nfunction updateGeneralGroup(groups, element) {\n  const generalGroup = findGroup(groups, 'general');\n  if (!generalGroup) {\n    return;\n  }\n  const {\n    entries\n  } = generalGroup;\n\n  // (1) add version tag before executable (if existing)\n  const executableEntry = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* findIndex */.cx)(entries, entry => entry.id === 'isExecutable');\n  const insertIndex = executableEntry >= 0 ? executableEntry : entries.length;\n  entries.splice(insertIndex, 0, ...VersionTagProps({\n    element\n  }));\n}\nfunction updateErrorGroup(groups, element) {\n  const errorGroup = findGroup(groups, 'error');\n  if (!errorGroup) {\n    return;\n  }\n  const {\n    entries\n  } = errorGroup;\n  ErrorProps({\n    element,\n    entries\n  });\n}\nfunction updateMultiInstanceGroup(groups, element) {\n  const multiInstanceGroup = findGroup(groups, 'multiInstance');\n  if (!multiInstanceGroup) {\n    return;\n  }\n  const {\n    entries\n  } = multiInstanceGroup;\n  MultiInstanceProps({\n    element,\n    entries\n  });\n}\nfunction updateEscalationGroup(groups, element) {\n  const escalationGroup = findGroup(groups, 'escalation');\n  if (!escalationGroup) {\n    return;\n  }\n  const {\n    entries\n  } = escalationGroup;\n  EscalationProps({\n    element,\n    entries\n  });\n}\nfunction updateTimerGroup(groups, element) {\n  const timerEventGroup = findGroup(groups, 'timer');\n  if (!timerEventGroup) {\n    return;\n  }\n  timerEventGroup.entries = [...TimerProps({\n    element\n  })];\n}\nfunction ImplementationGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Implementation'),\n    id: 'CamundaPlatform__Implementation',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...ImplementationProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction ErrorsGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Errors'),\n    id: 'CamundaPlatform__Errors',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...ErrorsProps({\n      element,\n      injector\n    })\n  };\n  if (group.items) {\n    return group;\n  }\n  return null;\n}\nfunction UserAssignmentGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('User assignment'),\n    id: 'CamundaPlatform__UserAssignment',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...UserAssignmentProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction ScriptGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Script'),\n    id: 'CamundaPlatform__Script',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...ScriptTaskProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction CallActivityGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Called element'),\n    id: 'CamundaPlatform__CallActivity',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...CallActivityProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction ConditionGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Condition'),\n    id: 'CamundaPlatform__Condition',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...ConditionProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction StartInitiatorGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Start initiator'),\n    id: 'CamundaPlatform__StartInitiator',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...InitiatorProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction ExternalTaskGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('External task'),\n    id: 'CamundaPlatform__ExternalTask',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...ExternalTaskPriorityProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction AsynchronousContinuationsGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Asynchronous continuations'),\n    id: 'CamundaPlatform__AsynchronousContinuations',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...AsynchronousContinuationsProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction JobExecutionGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Job execution'),\n    id: 'CamundaPlatform__JobExecution',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...JobExecutionProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction CandidateStarterGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Candidate starter'),\n    id: 'CamundaPlatform__CandidateStarter',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...CandidateStarterProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction FieldInjectionGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Field injections'),\n    id: 'CamundaPlatform__FieldInjection',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...FieldInjectionProps({\n      element,\n      injector\n    })\n  };\n  if (group.items) {\n    return group;\n  }\n  return null;\n}\nfunction HistoryCleanupGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('History cleanup'),\n    id: 'CamundaPlatform__HistoryCleanup',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...HistoryCleanupProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction TasklistGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Tasklist'),\n    id: 'CamundaPlatform__Tasklist',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...TasklistProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction InMappingGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('In mappings'),\n    id: 'CamundaPlatform__InMapping',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...InMappingProps({\n      element,\n      injector\n    })\n  };\n  if (group.items) {\n    return group;\n  }\n  return null;\n}\nfunction InMappingPropagationGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('In mapping propagation'),\n    id: 'CamundaPlatform__InMappingPropagation',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...InMappingPropagationProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction OutMappingGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Out mappings'),\n    id: 'CamundaPlatform__OutMapping',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...OutMappingProps({\n      element,\n      injector\n    })\n  };\n  if (group.items) {\n    return group;\n  }\n  return null;\n}\nfunction OutMappingPropagationGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Out mapping propagation'),\n    id: 'CamundaPlatform__OutMappingPropagation',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...OutMappingPropagationProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction ProcessVariablesGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Process variables'),\n    id: 'CamundaPlatform__ProcessVariables',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...ProcessVariablesProps({\n      element,\n      injector\n    })\n  };\n  if (group.items) {\n    return group;\n  }\n  return null;\n}\nfunction FormDataGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Form fields'),\n    id: 'CamundaPlatform__FormData',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...FormDataProps({\n      element,\n      injector\n    })\n  };\n  if (group.items) {\n    return group;\n  }\n  return null;\n}\nfunction BusinessKeyGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Business key'),\n    id: 'CamundaPlatform__BusinessKey',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...BusinessKeyProps$1({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction FormGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Forms'),\n    id: 'CamundaPlatform__Form',\n    component: properties_panel_dist_index_esm/* Group */.ZA,\n    entries: [...FormProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\nfunction ExecutionListenerGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Execution listeners'),\n    id: 'CamundaPlatform__ExecutionListener',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...ExecutionListenerProps({\n      element,\n      injector\n    })\n  };\n  if (group.items) {\n    return group;\n  }\n  return null;\n}\nfunction TaskListenerGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Task listeners'),\n    id: 'CamundaPlatform__TaskListener',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...TaskListenerProps({\n      element,\n      injector\n    })\n  };\n  if (group.items) {\n    return group;\n  }\n  return null;\n}\nfunction InputGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Inputs'),\n    id: 'CamundaPlatform__Input',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...InputProps({\n      element,\n      injector\n    })\n  };\n  if (group.items) {\n    return group;\n  }\n  return null;\n}\nfunction OutputGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Outputs'),\n    id: 'CamundaPlatform__Output',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...OutputProps({\n      element,\n      injector\n    })\n  };\n  if (group.items) {\n    return group;\n  }\n  return null;\n}\nfunction ConnectorInputGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Connector inputs'),\n    id: 'CamundaPlatform__ConnectorInput',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...ConnectorInputProps({\n      element,\n      injector\n    })\n  };\n  if (group.items) {\n    return group;\n  }\n  return null;\n}\nfunction ConnectorOutputGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Connector outputs'),\n    id: 'CamundaPlatform__ConnectorOutput',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...ConnectorOutputProps({\n      element,\n      injector\n    })\n  };\n  if (group.items) {\n    return group;\n  }\n  return null;\n}\nfunction ExtensionPropertiesGroup(element, injector) {\n  const translate = injector.get('translate');\n  const group = {\n    label: translate('Extension properties'),\n    id: 'CamundaPlatform__ExtensionProperties',\n    component: properties_panel_dist_index_esm/* ListGroup */.NX,\n    ...ExtensionPropertiesProps({\n      element,\n      injector\n    })\n  };\n  if (group.items) {\n    return group;\n  }\n  return null;\n}\n\n// helper /////////////////////\n\nfunction findGroup(groups, id) {\n  return groups.find(g => g.id === id);\n}\nfunction findGroupIndex(groups, id) {\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* findIndex */.cx)(groups, g => g.id === id);\n}\nfunction moveGroup(groups, id, position) {\n  const groupIndex = findGroupIndex(groups, id);\n  if (position < 0 || groupIndex < 0) {\n    return;\n  }\n  return (0,array_move.mutate)(groups, groupIndex, position);\n}\n\nvar camundaPlatformPropertiesProviderModule = {\n  __init__: ['camundaPlatformPropertiesProvider'],\n  camundaPlatformPropertiesProvider: ['type', CamundaPlatformPropertiesProvider]\n};\n\nconst PROPERTY_TYPE$1 = 'property';\nconst ZEBBE_PROPERTY_TYPE = 'zeebe:property';\nconst ZEBBE_INPUT_TYPE = 'zeebe:input';\nconst ZEEBE_OUTPUT_TYPE = 'zeebe:output';\nconst ZEEBE_PROPERTY_TYPE = 'zeebe:property';\nconst ZEEBE_TASK_DEFINITION_TYPE_TYPE = 'zeebe:taskDefinition:type';\nconst ZEEBE_TASK_HEADER_TYPE = 'zeebe:taskHeader';\nconst EXTENSION_BINDING_TYPES$1 = [ZEBBE_INPUT_TYPE, ZEEBE_OUTPUT_TYPE, ZEEBE_PROPERTY_TYPE, ZEEBE_TASK_DEFINITION_TYPE_TYPE, ZEEBE_TASK_HEADER_TYPE];\nconst TASK_DEFINITION_TYPES = [ZEEBE_TASK_DEFINITION_TYPE_TYPE];\nconst IO_BINDING_TYPES$1 = [ZEBBE_INPUT_TYPE, ZEEBE_OUTPUT_TYPE];\n\n/**\n * The BPMN 2.0 extension attribute name under\n * which the element template ID is stored.\n *\n * @type {String}\n */\nconst TEMPLATE_ID_ATTR$1 = 'zeebe:modelerTemplate';\n\n/**\n * The BPMN 2.0 extension attribute name under\n * which the element template version is stored.\n *\n * @type {String}\n */\nconst TEMPLATE_VERSION_ATTR$1 = 'zeebe:modelerTemplateVersion';\n\n/**\n * Get template id for a given diagram element.\n *\n * @param {djs.model.Base} element\n *\n * @return {String}\n */\nfunction getTemplateId$1(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if (businessObject) {\n    return businessObject.get(TEMPLATE_ID_ATTR$1);\n  }\n}\n\n/**\n * Get template version for a given diagram element.\n *\n * @param {djs.model.Base} element\n *\n * @return {String}\n */\nfunction getTemplateVersion$1(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if (businessObject) {\n    return businessObject.get(TEMPLATE_VERSION_ATTR$1);\n  }\n}\n\n/**\n * Find extension with given type in\n * BPMN element, diagram element or ExtensionElement.\n *\n * @param {ModdleElement|djs.model.Base} element\n * @param {String} type\n *\n * @return {ModdleElement} the extension\n */\nfunction findExtension$1(element, type) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  let extensionElements;\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:ExtensionElements')) {\n    extensionElements = businessObject;\n  } else {\n    extensionElements = businessObject.get('extensionElements');\n  }\n  if (!extensionElements) {\n    return null;\n  }\n  return extensionElements.get('values').find(value => {\n    return (0,ModelUtil.is)(value, type);\n  });\n}\nfunction findZeebeProperty(zeebeProperties, binding) {\n  return zeebeProperties.get('properties').find(value => {\n    return value.name === binding.name;\n  });\n}\nfunction findInputParameter$1(ioMapping, binding) {\n  const parameters = ioMapping.get('inputParameters');\n  return parameters.find(parameter => {\n    return parameter.target === binding.name;\n  });\n}\nfunction findOutputParameter$1(ioMapping, binding) {\n  const parameters = ioMapping.get('outputParameters');\n  return parameters.find(parameter => {\n    return parameter.source === binding.source;\n  });\n}\nfunction findTaskHeader(taskHeaders, binding) {\n  const headers = taskHeaders.get('values');\n  return headers.find(header => {\n    return header.key === binding.key;\n  });\n}\n\n/**\n * Create an input parameter representing the given\n * binding and value.\n *\n * @param {PropertyBinding} binding\n * @param {String} value\n * @param {BpmnFactory} bpmnFactory\n *\n * @return {ModdleElement}\n */\nfunction createInputParameter$1(binding, value, bpmnFactory) {\n  const {\n    name\n  } = binding;\n  return bpmnFactory.create('zeebe:Input', {\n    source: value,\n    target: name\n  });\n}\n\n/**\n * Create an output parameter representing the given\n * binding and value.\n *\n * @param {PropertyBinding} binding\n * @param {String} value\n * @param {BpmnFactory} bpmnFactory\n *\n * @return {ModdleElement}\n */\nfunction createOutputParameter$1(binding, value, bpmnFactory) {\n  const {\n    source\n  } = binding;\n  return bpmnFactory.create('zeebe:Output', {\n    source,\n    target: value\n  });\n}\n\n/**\n * Create a task header representing the given\n * binding and value.\n *\n * @param {PropertyBinding} binding\n * @param {String} value\n * @param {BpmnFactory} bpmnFactory\n *\n * @return {ModdleElement}\n */\nfunction createTaskHeader(binding, value, bpmnFactory) {\n  const {\n    key\n  } = binding;\n  return bpmnFactory.create('zeebe:Header', {\n    key,\n    value\n  });\n}\n\n/**\n * Create a task definition representing the given value.\n *\n * @param {String} value\n * @param {BpmnFactory} bpmnFactory\n *\n * @return {ModdleElement}\n */\nfunction createTaskDefinitionWithType(value, bpmnFactory) {\n  return bpmnFactory.create('zeebe:TaskDefinition', {\n    type: value\n  });\n}\n\n/**\n * Create zeebe:Property from the given binding.\n *\n * @param {PropertyBinding} binding\n * @param {String} value\n * @param {BpmnFactory} bpmnFactory\n *\n * @return {ModdleElement}\n */\nfunction createZeebeProperty(binding, value = '', bpmnFactory) {\n  const {\n    name\n  } = binding;\n  return bpmnFactory.create('zeebe:Property', {\n    name,\n    value\n  });\n}\n\n/**\n * Retrieves whether an element should be updated for a given property.\n *\n * That matches once\n * a) the property value is not empty, or\n * b) the property is not optional\n *\n * @param {String} value\n * @param {Object} property\n * @returns {Boolean}\n */\nfunction shouldUpdate(value, property) {\n  const {\n    optional\n  } = property;\n  return value || !optional;\n}\n\n/**\n * Gets or, in case not existent, creates extension element for given element.\n *\n * @param {djs.model.Base} element\n * @param {String} type\n * @param {BpmnFactory} bpmnFactory\n * @returns {ModdleElement}\n */\nfunction ensureExtension(element, type, bpmnFactory) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const extensionElements = businessObject.get('extensionElements');\n  let extension = findExtension$1(extensionElements, type);\n  if (!extension) {\n    extension = bpmnFactory.create(type);\n    extension.$parent = extensionElements;\n    extensionElements.get('values').push(extension);\n  }\n  return extension;\n}\n\nconst PRIMITIVE_MODDLE_TYPES$1 = ['Boolean', 'Integer', 'String'];\nfunction getPropertyValue$1(element, property, scope) {\n  let businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const defaultValue = '';\n  const {\n    binding\n  } = property;\n  const {\n    name,\n    type\n  } = binding;\n\n  // property\n  if (type === 'property') {\n    const value = businessObject.get(name);\n    if (!(0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isUndefined */.o8)(value)) {\n      return value;\n    }\n    return defaultValue;\n  }\n\n  // zeebe:taskDefinition\n  if (TASK_DEFINITION_TYPES.includes(type)) {\n    const taskDefinition = findExtension$1(businessObject, 'zeebe:TaskDefinition');\n    if (taskDefinition) {\n      if (type === ZEEBE_TASK_DEFINITION_TYPE_TYPE) {\n        return taskDefinition.get('type');\n      }\n    }\n    return defaultValue;\n  }\n  if (IO_BINDING_TYPES$1.includes(type)) {\n    const ioMapping = findExtension$1(businessObject, 'zeebe:IoMapping');\n    if (!ioMapping) {\n      return defaultValue;\n    }\n\n    // zeebe:Input\n    if (type === ZEBBE_INPUT_TYPE) {\n      const inputParameter = findInputParameter$1(ioMapping, binding);\n      if (inputParameter) {\n        return inputParameter.get('source');\n      }\n      return defaultValue;\n    }\n\n    // zeebe:Output\n    if (type === ZEEBE_OUTPUT_TYPE) {\n      const outputParameter = findOutputParameter$1(ioMapping, binding);\n      if (outputParameter) {\n        return outputParameter.get('target');\n      }\n      return defaultValue;\n    }\n  }\n\n  // zeebe:taskHeaders\n  if (type === ZEEBE_TASK_HEADER_TYPE) {\n    const taskHeaders = findExtension$1(businessObject, 'zeebe:TaskHeaders');\n    if (!taskHeaders) {\n      return defaultValue;\n    }\n    const header = findTaskHeader(taskHeaders, binding);\n    if (header) {\n      return header.get('value');\n    }\n    return defaultValue;\n  }\n\n  // zeebe:Property\n  if (type === ZEEBE_PROPERTY_TYPE) {\n    const zeebeProperties = findExtension$1(businessObject, 'zeebe:Properties');\n    if (zeebeProperties) {\n      const zeebeProperty = findZeebeProperty(zeebeProperties, binding);\n      if (zeebeProperty) {\n        return zeebeProperty.get('value');\n      }\n    }\n    return defaultValue;\n  }\n\n  // should never throw as templates are validated beforehand\n  throw unknownBindingError$1(element, property);\n}\nconst NO_OP = null;\nfunction setPropertyValue(bpmnFactory, commandStack, element, property, value) {\n  let businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const {\n    binding\n  } = property;\n  const {\n    name,\n    type\n  } = binding;\n  let extensionElements;\n  let propertyValue;\n  const commands = [];\n  const context = {\n    element,\n    property\n  };\n\n  // ensure extension elements\n  if (EXTENSION_BINDING_TYPES$1.includes(type)) {\n    extensionElements = businessObject.get('extensionElements');\n    if (!extensionElements) {\n      extensionElements = createElement('bpmn:ExtensionElements', null, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          ...context,\n          moddleElement: businessObject,\n          properties: {\n            extensionElements\n          }\n        }\n      });\n    } else {\n      commands.push(NO_OP);\n    }\n  }\n\n  // property\n  if (type === PROPERTY_TYPE$1) {\n    const propertyDescriptor = businessObject.$descriptor.propertiesByName[name];\n\n    // if property not created yet\n    if (!propertyDescriptor) {\n      // make sure we create the property\n      propertyValue = value || '';\n    } else {\n      const {\n        type: propertyType\n      } = propertyDescriptor;\n\n      // do not override non-primitive types\n      if (!PRIMITIVE_MODDLE_TYPES$1.includes(propertyType)) {\n        throw new Error(`cannot set property of type <${propertyType}>`);\n      }\n      if (propertyType === 'Boolean') {\n        propertyValue = !!value;\n      } else if (propertyType === 'Integer') {\n        propertyValue = parseInt(value, 10);\n        if (isNaN(propertyValue)) {\n          // do not set NaN value\n          propertyValue = undefined;\n        }\n      } else {\n        // make sure we don't remove the property\n        propertyValue = value || '';\n      }\n    }\n    if (!(0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isUndefined */.o8)(propertyValue)) {\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          ...context,\n          moddleElement: businessObject,\n          properties: {\n            [name]: propertyValue\n          }\n        }\n      });\n    } else {\n      commands.push(NO_OP);\n    }\n  }\n\n  // zeebe:taskDefinition\n  if (TASK_DEFINITION_TYPES.includes(type)) {\n    const oldTaskDefinition = findExtension$1(extensionElements, 'zeebe:TaskDefinition');\n    let newTaskDefinition;\n    if (type === ZEEBE_TASK_DEFINITION_TYPE_TYPE) {\n      newTaskDefinition = createTaskDefinitionWithType(value, bpmnFactory);\n    } else {\n      throw unknownBindingError$1(element, property);\n    }\n    const values = extensionElements.get('values').filter(value => value !== oldTaskDefinition);\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        ...context,\n        moddleElement: extensionElements,\n        properties: {\n          values: [...values, newTaskDefinition]\n        }\n      }\n    });\n  }\n  if (IO_BINDING_TYPES$1.includes(type)) {\n    let ioMapping = findExtension$1(extensionElements, 'zeebe:IoMapping');\n    if (!ioMapping) {\n      ioMapping = createElement('zeebe:IoMapping', null, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          ...context,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), ioMapping]\n          }\n        }\n      });\n    }\n\n    // zeebe:Input\n    if (type === ZEBBE_INPUT_TYPE) {\n      const oldZeebeInputParameter = findInputParameter$1(ioMapping, binding);\n      const values = ioMapping.get('inputParameters').filter(value => value !== oldZeebeInputParameter);\n\n      // do not persist empty parameters when configured as <optional>\n      if (shouldUpdate(value, property)) {\n        const newZeebeInputParameter = createInputParameter$1(binding, value, bpmnFactory);\n        values.push(newZeebeInputParameter);\n      }\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          ...context,\n          moddleElement: ioMapping,\n          properties: {\n            inputParameters: [...values]\n          }\n        }\n      });\n    }\n\n    // zeebe:Output\n    if (type === ZEEBE_OUTPUT_TYPE) {\n      const oldZeebeOutputParameter = findOutputParameter$1(ioMapping, binding);\n      const values = ioMapping.get('outputParameters').filter(value => value !== oldZeebeOutputParameter);\n\n      // do not persist empty parameters when configured as <optional>\n      if (shouldUpdate(value, property)) {\n        const newZeebeOutputParameter = createOutputParameter$1(binding, value, bpmnFactory);\n        values.push(newZeebeOutputParameter);\n      }\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          ...context,\n          moddleElement: ioMapping,\n          properties: {\n            'outputParameters': [...values]\n          }\n        }\n      });\n    }\n  }\n\n  // zeebe:taskHeaders\n  if (type === ZEEBE_TASK_HEADER_TYPE) {\n    let taskHeaders = findExtension$1(extensionElements, 'zeebe:TaskHeaders');\n    if (!taskHeaders) {\n      taskHeaders = createElement('zeebe:TaskHeaders', null, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          ...context,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), taskHeaders]\n          }\n        }\n      });\n    }\n    const oldTaskHeader = findTaskHeader(taskHeaders, binding);\n    const values = taskHeaders.get('values').filter(value => value !== oldTaskHeader);\n\n    // do not persist task headers with empty value\n    if (!value) {\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          ...context,\n          moddleElement: taskHeaders,\n          properties: {\n            values\n          }\n        }\n      });\n    } else {\n      const newTaskHeader = createTaskHeader(binding, value, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          ...context,\n          moddleElement: taskHeaders,\n          properties: {\n            values: [...values, newTaskHeader]\n          }\n        }\n      });\n    }\n  }\n\n  // zeebe:Property\n  if (type === ZEEBE_PROPERTY_TYPE) {\n    let zeebeProperties = findExtension$1(extensionElements, 'zeebe:Properties');\n    if (!zeebeProperties) {\n      zeebeProperties = createElement('zeebe:Properties', null, businessObject, bpmnFactory);\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          element,\n          moddleElement: extensionElements,\n          properties: {\n            values: [...extensionElements.get('values'), zeebeProperties]\n          }\n        }\n      });\n    }\n    const oldZeebeProperty = findZeebeProperty(zeebeProperties, binding);\n    const properties = zeebeProperties.get('properties').filter(property => property !== oldZeebeProperty);\n    if (shouldUpdate(value, property)) {\n      const newZeebeProperty = createZeebeProperty(binding, value, bpmnFactory);\n      properties.push(newZeebeProperty);\n    }\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        element,\n        moddleElement: zeebeProperties,\n        properties: {\n          properties\n        }\n      }\n    });\n  }\n  if (commands.length) {\n    const commandsToExecute = commands.filter(command => command !== NO_OP);\n    commandsToExecute.length && commandStack.execute('properties-panel.multi-command-executor', commandsToExecute);\n    return;\n  }\n\n  // should never throw as templates are validated beforehand\n  throw unknownBindingError$1(element, property);\n}\nfunction unsetProperty(commandStack, element, property) {\n  let businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const {\n    binding\n  } = property;\n  const {\n    type\n  } = binding;\n  let extensionElements;\n  const commands = [];\n  const context = {\n    element,\n    property\n  };\n  if (EXTENSION_BINDING_TYPES$1.includes(type)) {\n    extensionElements = businessObject.get('extensionElements');\n    if (!extensionElements) return;\n  }\n\n  // zeebe:taskDefinition\n  if (TASK_DEFINITION_TYPES.includes(type)) {\n    const oldTaskDefinition = findExtension$1(extensionElements, 'zeebe:TaskDefinition');\n    commands.push({\n      cmd: 'element.updateModdleProperties',\n      context: {\n        ...context,\n        moddleElement: extensionElements,\n        properties: {\n          values: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), oldTaskDefinition)\n        }\n      }\n    });\n  }\n\n  // zeebe:IoMapping\n  if (IO_BINDING_TYPES$1.includes(type)) {\n    let ioMapping = findExtension$1(extensionElements, 'zeebe:IoMapping');\n    if (!ioMapping) return;\n\n    // zeebe:Input\n    if (type === ZEBBE_INPUT_TYPE) {\n      const oldZeebeInputParameter = findInputParameter$1(ioMapping, binding);\n      const values = ioMapping.get('inputParameters').filter(value => value !== oldZeebeInputParameter);\n      if (ioMapping.get('outputParameters').length == 0 && values.length == 0) {\n        commands.push({\n          cmd: 'element.updateModdleProperties',\n          context: {\n            ...context,\n            moddleElement: extensionElements,\n            properties: {\n              values: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), ioMapping)\n            }\n          }\n        });\n      } else {\n        commands.push({\n          cmd: 'element.updateModdleProperties',\n          context: {\n            ...context,\n            moddleElement: ioMapping,\n            properties: {\n              inputParameters: [...values]\n            }\n          }\n        });\n      }\n    }\n\n    // zeebe:Output\n    if (type === ZEEBE_OUTPUT_TYPE) {\n      const oldZeebeOutputParameter = findOutputParameter$1(ioMapping, binding);\n      const values = ioMapping.get('outputParameters').filter(value => value !== oldZeebeOutputParameter);\n      if (ioMapping.get('inputParameters').length == 0 && values.length == 0) {\n        commands.push({\n          cmd: 'element.updateModdleProperties',\n          context: {\n            ...context,\n            moddleElement: extensionElements,\n            properties: {\n              values: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), ioMapping)\n            }\n          }\n        });\n      }\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          ...context,\n          moddleElement: ioMapping,\n          properties: {\n            'outputParameters': [...values]\n          }\n        }\n      });\n    }\n  }\n\n  // zeebe:taskHeaders\n  if (type === ZEEBE_TASK_HEADER_TYPE) {\n    let taskHeaders = findExtension$1(extensionElements, 'zeebe:TaskHeaders');\n    if (!taskHeaders) return;\n    const oldTaskHeader = findTaskHeader(taskHeaders, binding);\n    const values = taskHeaders.get('values').filter(value => value !== oldTaskHeader);\n    if (values.length === 0) {\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          ...context,\n          moddleElement: extensionElements,\n          properties: {\n            values: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), taskHeaders)\n          }\n        }\n      });\n    } else {\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          ...context,\n          moddleElement: taskHeaders,\n          properties: {\n            values: [...values]\n          }\n        }\n      });\n    }\n  }\n\n  // zeebe:Property\n  if (type === ZEEBE_PROPERTY_TYPE) {\n    let zeebeProperties = findExtension$1(extensionElements, 'zeebe:Properties');\n    if (!zeebeProperties) return;\n    const oldZeebeProperty = findZeebeProperty(zeebeProperties, binding);\n    const properties = zeebeProperties.get('properties').filter(property => property !== oldZeebeProperty);\n    if (!properties.length) {\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          ...context,\n          moddleElement: extensionElements,\n          properties: {\n            values: (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* without */.zu)(extensionElements.get('values'), zeebeProperties)\n          }\n        }\n      });\n    } else {\n      commands.push({\n        cmd: 'element.updateModdleProperties',\n        context: {\n          ...context,\n          moddleElement: zeebeProperties,\n          properties: {\n            properties: [...properties]\n          }\n        }\n      });\n    }\n  }\n  if (commands.length) {\n    commandStack.execute('properties-panel.multi-command-executor', commands);\n    return;\n  }\n}\n\n// helpers\nfunction unknownBindingError$1(element, property) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  const id = businessObject.get('id');\n  const {\n    binding\n  } = property;\n  const {\n    type\n  } = binding;\n  return new Error(`unknown binding <${type}> for element <${id}>, this should never happen`);\n}\n\n/**\n * Based on conditions, remove properties from the template.\n */\nfunction applyConditions(element, elementTemplate) {\n  const {\n    properties\n  } = elementTemplate;\n  const filteredProperties = properties.filter(property => {\n    return isConditionMet(element, properties, property);\n  });\n  return {\n    ...elementTemplate,\n    properties: filteredProperties\n  };\n}\nfunction isConditionMet(element, properties, property) {\n  const {\n    condition\n  } = property;\n\n  // If no condition is defined, return true.\n  if (!condition) {\n    return true;\n  }\n  return isSimpleConditionMet(element, properties, condition);\n}\nfunction isSimpleConditionMet(element, properties, condition) {\n  const {\n    property,\n    equals,\n    oneOf\n  } = condition;\n  const propertyValue = getValue(element, properties, property);\n  if (equals) {\n    return propertyValue === equals;\n  }\n  if (oneOf) {\n    return oneOf.includes(propertyValue);\n  }\n  return false;\n}\nfunction getValue(element, properties, propertyId) {\n  const property = properties.find(p => p.id === propertyId);\n  if (!property) {\n    return;\n  }\n  return getPropertyValue$1(element, property);\n}\n\n/**\n * Checks the conditions of an element template and sets/resets the\n * corresponding properties on the element.\n */\nclass ElementTemplatesConditionChecker extends CommandInterceptor/* default */.Z {\n  constructor(eventBus, elementTemplates, commandStack, bpmnFactory) {\n    super(eventBus);\n    this._eventBus = eventBus;\n    this._elementTemplates = elementTemplates;\n    this._commandStack = commandStack;\n    this._bpmnFactory = bpmnFactory;\n    this.preExecute(['element.updateProperties', 'element.updateModdleProperties'], this._saveConditionalState, true, this);\n    this.postExecute(['element.updateProperties', 'element.updateModdleProperties', 'propertiesPanel.zeebe.changeTemplate'], this._applyConditions, true, this);\n  }\n  _saveConditionalState(context) {\n    const {\n      element\n    } = context;\n    const template = this._elementTemplates.get(element);\n    if (!template) {\n      return;\n    }\n    context.oldTemplate = applyConditions(element, template);\n  }\n  _applyConditions(context) {\n    const {\n      element,\n      oldTemplate\n    } = context;\n    const template = this._elementTemplates.get(element);\n    if (!template || !oldTemplate || template.id !== oldTemplate.id) {\n      return;\n    }\n    const newTemplate = applyConditions(element, template);\n    const propertiesToAdd = getMissingProperties(oldTemplate, newTemplate);\n    const propertiesToRemove = getPropertiesToRemove(newTemplate, oldTemplate);\n    propertiesToAdd.forEach(property => setPropertyValue(this._bpmnFactory, this._commandStack, element, property, property.value));\n    propertiesToRemove.forEach(property => unsetProperty(this._commandStack, element, property));\n  }\n}\nElementTemplatesConditionChecker.$inject = ['eventBus', 'elementTemplates', 'commandStack', 'bpmnFactory'];\n\n// helpers\n\nfunction getMissingProperties(sourceTemplate, targetTemplate) {\n  let properties = targetTemplate.properties;\n  return properties.filter(targetProp => !sourceTemplate.properties.find(sourceProp => compareProps(sourceProp, targetProp)));\n}\nfunction compareProps(sourceProp, targetProp) {\n  return equals(sourceProp.binding, targetProp.binding) && equals(sourceProp.condition, targetProp.condition);\n}\nfunction findPropertyWithBinding(template, prop1) {\n  return template.properties.some(prop2 => equals(prop1.binding, prop2.binding));\n}\nfunction getPropertiesToRemove(newTemplate, oldTemplate) {\n  const oldProperties = getMissingProperties(newTemplate, oldTemplate);\n\n  // ensure XML properties are mantained for properties with\n  // different conditions but same bindings\n  return oldProperties.filter(property => !findPropertyWithBinding(newTemplate, property));\n}\nfunction normalizeReplacer(key, value) {\n  if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isObject */.Kn)(value)) {\n    const keys = Object.keys(value).sort();\n    return keys.reduce((obj, key) => {\n      obj[key] = value[key];\n      return obj;\n    }, {});\n  }\n  return value;\n}\nfunction equals(a, b) {\n  return JSON.stringify(a, normalizeReplacer) === JSON.stringify(b, normalizeReplacer);\n}\n\n/**\n * The BPMN 2.0 extension attribute name under\n * which the element template ID is stored.\n *\n * @type {String}\n */\nconst TEMPLATE_ID_ATTR = 'camunda:modelerTemplate';\n\n/**\n * The BPMN 2.0 extension attribute name under\n * which the element template version is stored.\n *\n * @type {String}\n */\nconst TEMPLATE_VERSION_ATTR = 'camunda:modelerTemplateVersion';\n\n/**\n * Get template id for a given diagram element.\n *\n * @param {djs.model.Base} element\n *\n * @return {String}\n */\nfunction getTemplateId(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if (businessObject) {\n    return businessObject.get(TEMPLATE_ID_ATTR);\n  }\n}\n\n/**\n * Get template version for a given diagram element.\n *\n * @param {djs.model.Base} element\n *\n * @return {String}\n */\nfunction getTemplateVersion(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if (businessObject) {\n    return businessObject.get(TEMPLATE_VERSION_ATTR);\n  }\n}\n\n/**\n * Find extension with given type in\n * BPMN element, diagram element or ExtensionElement.\n *\n * @param {ModdleElement|djs.model.Base} element\n * @param {String} type\n *\n * @return {ModdleElement} the extension\n */\nfunction findExtension(element, type) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  let extensionElements;\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:ExtensionElements')) {\n    extensionElements = businessObject;\n  } else {\n    extensionElements = businessObject.get('extensionElements');\n  }\n  if (!extensionElements) {\n    return null;\n  }\n  return extensionElements.get('values').find(value => {\n    return (0,ModelUtil.is)(value, type);\n  });\n}\nfunction findExtensions(element, types) {\n  const extensionElements = getExtensionElements(element);\n  if (!extensionElements) {\n    return [];\n  }\n  return extensionElements.get('values').filter(value => {\n    return (0,ModelUtil/* isAny */.JZ)(value, types);\n  });\n}\nfunction findCamundaInOut(element, binding) {\n  const extensionElements = getExtensionElements(element);\n  if (!extensionElements) {\n    return;\n  }\n  const {\n    type\n  } = binding;\n  let matcher;\n  if (type === 'camunda:in') {\n    matcher = element => {\n      return (0,ModelUtil.is)(element, 'camunda:In') && isInOut(element, binding);\n    };\n  } else if (type === 'camunda:out') {\n    matcher = element => {\n      return (0,ModelUtil.is)(element, 'camunda:Out') && isInOut(element, binding);\n    };\n  } else if (type === 'camunda:in:businessKey') {\n    matcher = element => {\n      return (0,ModelUtil.is)(element, 'camunda:In') && 'businessKey' in element;\n    };\n  }\n  return extensionElements.get('values').find(matcher);\n}\nfunction findCamundaProperty(camundaProperties, binding) {\n  return camundaProperties.get('values').find(value => {\n    return value.name === binding.name;\n  });\n}\nfunction findInputParameter(inputOutput, binding) {\n  const parameters = inputOutput.get('inputParameters');\n  return parameters.find(parameter => {\n    return parameter.name === binding.name;\n  });\n}\nfunction findOutputParameter(inputOutput, binding) {\n  const parameters = inputOutput.get('outputParameters');\n  return parameters.find(function (parameter) {\n    const {\n      value\n    } = parameter;\n    if (!binding.scriptFormat) {\n      return value === binding.source;\n    }\n    const definition = parameter.get('camunda:definition');\n    if (!definition || binding.scriptFormat !== definition.get('camunda:scriptFormat')) {\n      return false;\n    }\n    return definition.get('camunda:value') === binding.source;\n  });\n}\nfunction findCamundaErrorEventDefinition(element, errorRef) {\n  const errorEventDefinitions = findExtensions(element, ['camunda:ErrorEventDefinition']);\n  let error;\n\n  // error ID has to start with <Error_${ errorRef }_>\n  return errorEventDefinitions.find(definition => {\n    error = definition.get('bpmn:errorRef');\n    if (error) {\n      return error.get('bpmn:id').startsWith(`Error_${errorRef}`);\n    }\n  });\n}\n\n// helpers //////////\n\nfunction getExtensionElements(element) {\n  const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:ExtensionElements')) {\n    return businessObject;\n  } else {\n    return businessObject.get('extensionElements');\n  }\n}\nfunction isInOut(element, binding) {\n  if (binding.type === 'camunda:in') {\n    // find based on target attribute\n    if (binding.target) {\n      return element.target === binding.target;\n    }\n  }\n  if (binding.type === 'camunda:out') {\n    // find based on source / sourceExpression\n    if (binding.source) {\n      return element.source === binding.source;\n    }\n    if (binding.sourceExpression) {\n      return element.sourceExpression === binding.sourceExpression;\n    }\n  }\n\n  // find based variables / local combination\n  if (binding.variables) {\n    return element.variables === 'all' && (binding.variables !== 'local' || element.local);\n  }\n}\n\n/**\n * Registry for element templates.\n */\nclass ElementTemplates$1 {\n  constructor(commandStack) {\n    this._commandStack = commandStack;\n    this._templates = {};\n  }\n\n  /**\n   * Get template with given ID and optional version or for element.\n   *\n   * @param {String|djs.model.Base} id\n   * @param {number} [version]\n   *\n   * @return {ElementTemplate}\n   */\n  get(id, version) {\n    const templates = this._templates;\n    let element;\n    if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isUndefined */.o8)(id)) {\n      return null;\n    } else if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isString */.HD)(id)) {\n      if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isUndefined */.o8)(version)) {\n        version = '_';\n      }\n      if (templates[id] && templates[id][version]) {\n        return templates[id][version];\n      } else {\n        return null;\n      }\n    } else {\n      element = id;\n      return this.get(this._getTemplateId(element), this._getTemplateVersion(element));\n    }\n  }\n\n  /**\n   * Get default template for given element.\n   *\n   * @param {djs.model.Base} element\n   *\n   * @return {ElementTemplate}\n   */\n  getDefault(element) {\n    return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* find */.sE)(this.getAll(element), function (template) {\n      return template.isDefault;\n    }) || null;\n  }\n\n  /**\n   * Get all templates (with given ID or applicable to element).\n   *\n   * @param {string|djs.model.Base} [id]\n   * @return {Array<ElementTemplate>}\n   */\n  getAll(id) {\n    return this._getTemplateVerions(id, {\n      includeDeprecated: true\n    });\n  }\n\n  /**\n   * Get all templates (with given ID or applicable to element) with the latest\n   * version.\n   *\n   * @param {String|djs.model.Base} [id]\n   * @param {{ deprecated?: boolean }} [options]\n   *\n   * @return {Array<ElementTemplate>}\n   */\n  getLatest(id, options = {}) {\n    return this._getTemplateVerions(id, {\n      ...options,\n      latest: true\n    });\n  }\n\n  /**\n   * Set templates.\n   *\n   * @param {Array<ElementTemplate>} templates\n   */\n  set(templates) {\n    this._templates = {};\n    templates.forEach(template => {\n      const id = template.id,\n        version = (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isUndefined */.o8)(template.version) ? '_' : template.version;\n      if (!this._templates[id]) {\n        this._templates[id] = {\n          latest: template\n        };\n      }\n      this._templates[id][version] = template;\n      const latestVerions = this._templates[id].latest.version;\n      if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isUndefined */.o8)(latestVerions) || template.version > latestVerions) {\n        this._templates[id].latest = template;\n      }\n    });\n  }\n\n  /**\n   * @param {object|string|null} id\n   * @param { { latest?: boolean, deprecated?: boolean } [options]\n   *\n   * @return {Array<ElementTemplate>}\n   */\n  _getTemplateVerions(id, options = {}) {\n    const {\n      latest: latestOnly,\n      deprecated: includeDeprecated\n    } = options;\n    const templates = this._templates;\n    const getVersions = template => {\n      const {\n        latest,\n        ...versions\n      } = template;\n      return latestOnly ? !includeDeprecated && latest.deprecated ? [] : [latest] : (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* values */.VO)(versions);\n    };\n    if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isNil */.kK)(id)) {\n      return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* flatten */.xH)((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* values */.VO)(templates).map(getVersions));\n    }\n    if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isObject */.Kn)(id)) {\n      const element = id;\n      return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* filter */.hX)(this._getTemplateVerions(null, options), function (template) {\n        return (0,ModelUtil/* isAny */.JZ)(element, template.appliesTo);\n      }) || [];\n    }\n    if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isString */.HD)(id)) {\n      return templates[id] && getVersions(templates[id]);\n    }\n    throw new Error('argument must be of type {string|djs.model.Base|undefined}');\n  }\n  _getTemplateId(element) {\n    return getTemplateId(element);\n  }\n  _getTemplateVersion(element) {\n    return getTemplateVersion(element);\n  }\n\n  /**\n   * Apply element template to a given element.\n   *\n   * @param {djs.model.Base} element\n   * @param {ElementTemplate} newTemplate\n   *\n   * @return {djs.model.Base} the updated element\n   */\n  applyTemplate(element, newTemplate) {\n    const oldTemplate = this.get(element);\n    const context = {\n      element,\n      newTemplate,\n      oldTemplate\n    };\n    this._commandStack.execute('propertiesPanel.camunda.changeTemplate', context);\n    return context.element;\n  }\n}\nElementTemplates$1.$inject = ['commandStack'];\n\n/**\n * Registry for element templates.\n */\nclass ElementTemplates extends ElementTemplates$1 {\n  constructor(templateElementFactory, commandStack) {\n    super(commandStack);\n    this._commandStack = commandStack;\n    this._templateElementFactory = templateElementFactory;\n  }\n  _getTemplateId(element) {\n    return getTemplateId$1(element);\n  }\n  _getTemplateVersion(element) {\n    return getTemplateVersion$1(element);\n  }\n\n  /**\n   * Create an element based on an element template.\n   *\n   * @param {ElementTemplate} template\n   * @returns {djs.model.Base}\n   */\n  createElement(template) {\n    if (!template) {\n      throw new Error('template is missing');\n    }\n    const element = this._templateElementFactory.create(template);\n    return element;\n  }\n\n  /**\n   * Apply element template to a given element.\n   *\n   * @param {djs.model.Base} element\n   * @param {ElementTemplate} newTemplate\n   *\n   * @return {djs.model.Base} the updated element\n   */\n  applyTemplate(element, newTemplate) {\n    const oldTemplate = this.get(element);\n    const context = {\n      element,\n      newTemplate,\n      oldTemplate\n    };\n    this._commandStack.execute('propertiesPanel.zeebe.changeTemplate', context);\n    return context.element;\n  }\n}\nElementTemplates.$inject = ['templateElementFactory', 'commandStack'];\n\nconst SUPPORTED_SCHEMA_VERSION$1 = (0,element_templates_validator_dist_index_esm/* getSchemaVersion */.wN)();\nconst MORPHABLE_TYPES = ['bpmn:Activity', 'bpmn:Event', 'bpmn:Gateway'];\n\n/**\n * A element template validator.\n */\nclass Validator$1 {\n  constructor(moddle) {\n    this._templatesById = {};\n    this._validTemplates = [];\n    this._errors = [];\n    this._moddle = moddle;\n  }\n\n  /**\n   * Adds the templates.\n   *\n   * @param {Array<TemplateDescriptor>} templates\n   *\n   * @return {Validator}\n   */\n  addAll(templates) {\n    if (!(0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isArray */.kJ)(templates)) {\n      this._logError('templates must be []');\n    } else {\n      templates.forEach(this.add, this);\n    }\n    return this;\n  }\n\n  /**\n   * Add the given element template, if it is valid.\n   *\n   * @param {TemplateDescriptor} template\n   *\n   * @return {Validator}\n   */\n  add(template) {\n    const err = this._validateTemplate(template);\n    let id, version;\n    if (!err) {\n      id = template.id;\n      version = template.version || '_';\n      if (!this._templatesById[id]) {\n        this._templatesById[id] = {};\n      }\n      this._templatesById[id][version] = template;\n      this._validTemplates.push(template);\n    }\n    return this;\n  }\n\n  /**\n   * Validate given template and return error (if any).\n   *\n   * @param {TemplateDescriptor} template\n   *\n   * @return {Error} validation error, if any\n   */\n  _validateTemplate(template) {\n    let err;\n    const id = template.id,\n      version = template.version || '_',\n      schemaVersion = template.$schema && getSchemaVersion(template.$schema);\n\n    // (1) compatibility\n    if (schemaVersion && semver_compare_default()(SUPPORTED_SCHEMA_VERSION$1, schemaVersion) < 0) {\n      return this._logError(`unsupported element template schema version <${schemaVersion}>. Your installation only supports up to version <${SUPPORTED_SCHEMA_VERSION$1}>. Please update your installation`, template);\n    }\n\n    // (2) versioning\n    if (this._templatesById[id] && this._templatesById[id][version]) {\n      if (version === '_') {\n        return this._logError(`template id <${id}> already used`, template);\n      } else {\n        return this._logError(`template id <${id}> and version <${version}> already used`, template);\n      }\n    }\n\n    // (3) elementType validation\n    const elementTypeError = this._validateElementType(template);\n    if (elementTypeError) {\n      return elementTypeError;\n    }\n\n    // (4) JSON schema compliance\n    const validationResult = (0,element_templates_validator_dist_index_esm/* validate */.Gu)(template);\n    const {\n      errors,\n      valid\n    } = validationResult;\n    if (!valid) {\n      err = new Error('invalid template');\n      filteredSchemaErrors(errors).forEach(error => {\n        this._logError(error.message, template);\n      });\n    }\n    return err;\n  }\n\n  /**\n   * Validate elementType for given template and return error (if any).\n   *\n   * @param {TemplateDescriptor} template\n   *\n   * @return {Error} validation error, if any\n   */\n  _validateElementType(template) {\n    if (template.elementType && template.appliesTo) {\n      const elementType = template.elementType.value,\n        appliesTo = template.appliesTo;\n\n      // (3.1) template can be applied to elementType\n      // prevents cases where the elementType is not part of appliesTo\n      if (!appliesTo.find(type => this._isType(elementType, type))) {\n        return this._logError(`template does not apply to requested element type <${elementType}>`, template);\n      }\n\n      // (3.2) template only applies to same type of element\n      // prevent elementTemplates to morph into incompatible types, e.g. Task -> SequenceFlow\n      for (const sourceType of appliesTo) {\n        if (!this._canMorph(sourceType, elementType)) {\n          return this._logError(`can not morph <${sourceType}> into <${elementType}>`, template);\n        }\n      }\n    }\n  }\n\n  /**\n   * Check if given type is a subtype of given base type.\n   *\n   * @param {String} type\n   * @param {String} baseType\n   * @returns {Boolean}\n   */\n  _isType(type, baseType) {\n    const moddleType = this._moddle.getType(type);\n    return moddleType && baseType in this._moddle.getElementDescriptor(moddleType).allTypesByName;\n  }\n\n  /**\n   * Checks if a given type can be morphed into another type.\n   *\n   * @param {String} sourceType\n   * @param {String} targetType\n   * @returns {Boolean}\n   */\n  _canMorph(sourceType, targetType) {\n    if (sourceType === targetType) {\n      return true;\n    }\n    const baseType = MORPHABLE_TYPES.find(type => this._isType(sourceType, type));\n    if (!baseType) {\n      return false;\n    }\n    return this._isType(targetType, baseType);\n  }\n\n  /**\n   * Log an error for the given template\n   *\n   * @param {(String|Error)} err\n   * @param {TemplateDescriptor} template\n   *\n   * @return {Error} logged validation errors\n   */\n  _logError(err, template) {\n    if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isString */.HD)(err)) {\n      if (template) {\n        const {\n          id,\n          name\n        } = template;\n        err = `template(id: <${id}>, name: <${name}>): ${err}`;\n      }\n      err = new Error(err);\n    }\n    this._errors.push(err);\n    return err;\n  }\n  getErrors() {\n    return this._errors;\n  }\n  getValidTemplates() {\n    return this._validTemplates;\n  }\n}\n\n// helpers //////////\n\n/**\n * Extract schema version from schema URI\n *\n * @param {String} schemaUri - for example https://unpkg.com/@camunda/element-templates-json-schema@99.99.99/resources/schema.json\n *\n * @return {String} for example '99.99.99'\n */\nfunction getSchemaVersion(schemaUri) {\n  const re = /\\d+\\.\\d+\\.\\d+/g;\n  const match = schemaUri.match(re);\n  return match === null ? undefined : match[0];\n}\n\n/**\n * Extract only relevant errors of the validation result.\n *\n * The JSON Schema we use under the hood produces more errors than we need for a\n * detected schema violation (for example, unmatched sub-schemas, if-then-rules,\n * `oneOf`-definitions ...).\n *\n * We call these errors \"relevant\" that have a custom error message defined by us OR\n * are basic data type errors.\n *\n * @param {Array} schemaErrors\n *\n * @return {Array}\n */\nfunction filteredSchemaErrors(schemaErrors) {\n  return (0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* filter */.hX)(schemaErrors, err => {\n    const {\n      dataPath,\n      keyword\n    } = err;\n\n    // (1) regular errors are customized from the schema\n    if (keyword === 'errorMessage') {\n      return true;\n    }\n\n    // (2) data type errors\n    // ignore type errors nested in scopes\n    if (keyword === 'type' && dataPath && !dataPath.startsWith('/scopes/')) {\n      return true;\n    }\n    return false;\n  });\n}\n\nconst SUPPORTED_SCHEMA_VERSION = (0,element_templates_validator_dist_index_esm/* getZeebeSchemaVersion */.lM)();\nconst SUPPORTED_SCHEMA_PACKAGE = (0,element_templates_validator_dist_index_esm/* getZeebeSchemaPackage */.Hu)();\n\n/**\n * A Camunda Cloud element template validator.\n */\nclass Validator extends Validator$1 {\n  constructor(moddle) {\n    super(moddle);\n  }\n\n  /**\n   * Validate given template and return error (if any).\n   *\n   * @param {TemplateDescriptor} template\n   *\n   * @return {Error} validation error, if any\n   */\n  _validateTemplate(template) {\n    let err;\n    const id = template.id,\n      version = template.version || '_',\n      schema = template.$schema,\n      schemaVersion = schema && getSchemaVersion(schema);\n\n    // (1) $schema attribute defined\n    if (!schema) {\n      return this._logError('missing $schema attribute.', template);\n    }\n    if (!this.isSchemaValid(schema)) {\n      return this._logError(`unsupported $schema attribute <${schema}>.`, template);\n    }\n\n    // (2) compatibility\n    if (schemaVersion && semver_compare_default()(SUPPORTED_SCHEMA_VERSION, schemaVersion) < 0) {\n      return this._logError(`unsupported element template schema version <${schemaVersion}>. Your installation only supports up to version <${SUPPORTED_SCHEMA_VERSION}>. Please update your installation`, template);\n    }\n\n    // (3) versioning\n    if (this._templatesById[id] && this._templatesById[id][version]) {\n      if (version === '_') {\n        return this._logError(`template id <${id}> already used`, template);\n      } else {\n        return this._logError(`template id <${id}> and version <${version}> already used`, template);\n      }\n    }\n\n    // (4) elementType validation\n    const elementTypeError = this._validateElementType(template);\n    if (elementTypeError) {\n      return elementTypeError;\n    }\n\n    // (5) JSON schema compliance\n    const validationResult = (0,element_templates_validator_dist_index_esm/* validateZeebe */.Zk)(template);\n    const {\n      errors,\n      valid\n    } = validationResult;\n    if (!valid) {\n      err = new Error('invalid template');\n      filteredSchemaErrors(errors).forEach(error => {\n        this._logError(error.message, template);\n      });\n    }\n    return err;\n  }\n  isSchemaValid(schema) {\n    return schema && schema.includes(SUPPORTED_SCHEMA_PACKAGE);\n  }\n}\n\n/**\n * The guy responsible for template loading.\n *\n * Provide the actual templates via the `config.elementTemplates`.\n *\n * That configuration can either be an array of template\n * descriptors or a node style callback to retrieve\n * the templates asynchronously.\n *\n * @param {Array<TemplateDescriptor>|Function} loadTemplates\n * @param {EventBus} eventBus\n * @param {ElementTemplates} elementTemplates\n * @param {Moddle} moddle\n */\nclass ElementTemplatesLoader$1 {\n  constructor(loadTemplates, eventBus, elementTemplates, moddle) {\n    this._loadTemplates = loadTemplates;\n    this._eventBus = eventBus;\n    this._elementTemplates = elementTemplates;\n    this._moddle = moddle;\n    eventBus.on('diagram.init', () => {\n      this.reload();\n    });\n  }\n  reload() {\n    const loadTemplates = this._loadTemplates;\n\n    // no templates specified\n    if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isUndefined */.o8)(loadTemplates)) {\n      return;\n    }\n\n    // template loader function specified\n    if ((0,bpmn_js_properties_panel_node_modules_min_dash_dist_index_esm/* isFunction */.mf)(loadTemplates)) {\n      return loadTemplates((err, templates) => {\n        if (err) {\n          return this.templateErrors([err]);\n        }\n        this.setTemplates(templates);\n      });\n    }\n\n    // templates array specified\n    if (loadTemplates.length) {\n      return this.setTemplates(loadTemplates);\n    }\n  }\n  setTemplates(templates) {\n    const elementTemplates = this._elementTemplates,\n      moddle = this._moddle;\n    const validator = new Validator$1(moddle).addAll(templates);\n    const errors = validator.getErrors(),\n      validTemplates = validator.getValidTemplates();\n    elementTemplates.set(validTemplates);\n    if (errors.length) {\n      this.templateErrors(errors);\n    }\n    this.templatesChanged();\n  }\n  templatesChanged() {\n    this._eventBus.fire('elementTemplates.changed');\n  }\n  templateErrors(errors) {\n    this._eventBus.fire('elementTemplates.errors', {\n      errors: errors\n    });\n  }\n}\nElementTemplatesLoader$1.$inject = ['config.elementTemplates', 'eventBus', 'elem