(()=>{"use strict";var __webpack_modules__={"../../../../../../vXCP-enterprise-core/platform-specific/on-premise/platformJS.service.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  "getPlatformMacroDialog": () => (/* binding */ getPlatformMacroDialog),\n  "getPlatformUtils": () => (/* binding */ getPlatformUtils)\n});\n\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/from-mode.enum.ts\nvar FromModeEnum;\n(function (FromModeEnum) {\n    FromModeEnum["URL"] = "URL";\n    FromModeEnum["CONFLUENCE_VIEWER"] = "CONFLUENCE_VIEWER";\n    FromModeEnum["CONFLUENCE_EDITOR"] = "CONFLUENCE_EDITOR";\n})(FromModeEnum || (FromModeEnum = {}));\n\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model/enum/app-type.enum.ts\nvar AppTypeEnum;\n(function (AppTypeEnum) {\n    AppTypeEnum["CLOUD_ENTERPRISE"] = "cloud-enterprise";\n    AppTypeEnum["SERVER_ENTERPRISE"] = "server-enterprise";\n    AppTypeEnum["SERVER_FREE"] = "server-free";\n})(AppTypeEnum || (AppTypeEnum = {}));\n\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/core-js/app/model-language/plugin-specific.factory.ts\nconst getPluginService = () => {\n    if (false) {}\n    else {\n        return getBpmnPluginService();\n    }\n};\nconst getDmnPluginService = () => {\n    return window.VDCPENT.dmnEntPlugin;\n};\nconst getBpmnPluginService = () => {\n    return window.VBCP.bpmnEntPlugin;\n};\nconst getPlatformService = () => {\n    if (false) {}\n    else {\n        return getBpmnPlatformService();\n    }\n};\nconst getPlatformMDFService = () => {\n    if (false) {}\n    else {\n        return getBpmnPlatformMDFService();\n    }\n};\nconst getDmnPlatformService = () => {\n    return window.VDCPENT.dmnEntPlatformJS;\n};\nconst getBpmnPlatformService = () => {\n    return window.VBCP.bpmnEntPlatformJS;\n};\nconst getDmnPlatformMDFService = () => {\n    return window.VDCPENT.dmnEntPlatformMDF;\n};\nconst getBpmnPlatformMDFService = () => {\n    return window.VBCP.bpmnEntPlatformMDF;\n};\n\n;// CONCATENATED MODULE: ../../../../../../core/vxcp-logger/src/vxcp-logger.ts\nclass VxcpLogger {\n    constructor(pluginName, serviceName, isEnabled = true) {\n        this.pluginName = pluginName;\n        this.serviceName = serviceName;\n        this.isEnabled = isEnabled;\n    }\n    logFatal(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`FATAL@${logHeader}: ${description}`);\n        }\n    }\n    logError(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`ERROR@${logHeader}: ${description}`);\n        }\n    }\n    logWarning(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.warn(`WARNING@${logHeader}: ${description}`);\n        }\n    }\n    logInfo(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.info(`INFO@${logHeader}: ${description}`);\n        }\n    }\n    enableLogging(isEnabled = true) {\n        this.isEnabled = isEnabled;\n    }\n    getLogHeader(methodName) {\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\n    }\n}\n\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/platform-specific/on-premise/platform-utils.service.ts\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\nconst CONFLUENCE_EDITOR_IFRAME_SELECTOR = "#wysiwygTextarea_ifr";\nconst CONFLUENCE_EDITOR_TINYMCE_SELECTOR = "#tinymce";\nclass PlatformUtils {\n    constructor() {\n        this.err = "NOT ENOUGH PARAMETERS";\n        this.vxcpLogger = new VxcpLogger(getPluginService().getPluginName(), "PlatformUtils");\n    }\n    removeDjsHelperSvg() {\n        const svgHelpers = $("#helper-svg");\n        if (svgHelpers) {\n            svgHelpers.remove();\n        }\n    }\n    buildRestUrlForUserNameByKeyAccountId(confluenceUserKey) {\n        return this.buildRestUrl(`/rest/api/user?key=${confluenceUserKey}`);\n    }\n    buildRestUrlForUserKeyAccountIdByName(userName) {\n        const cqlString = `user~"${userName}"&start=0&limit=100`;\n        const restPartURL = `/rest/api/search?cql=${cqlString}`;\n        return this.buildRestUrl(restPartURL);\n    }\n    getUser() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const params = yield this.getParams();\n            return params.remoteUserKey;\n        });\n    }\n    getLocale() {\n        return __awaiter(this, void 0, void 0, function* () {\n            return this.getUserLocale();\n        });\n    }\n    getDisplayNewsMessageMarker() {\n        return true;\n    }\n    getAppType() {\n        return AppTypeEnum.SERVER_ENTERPRISE;\n    }\n    isCloudApp() {\n        return false;\n    }\n    getTemplate(template, templateParams) {\n        const allTemplates = Confluence.Templates.viadee.pluginenterprise;\n        if (allTemplates && allTemplates.hasOwnProperty(template)) {\n            const curTemplate = allTemplates[template];\n            return curTemplate(templateParams);\n        }\n        this.vxcpLogger.logFatal("getTemplate", `Template ${template} not found.`);\n        return "";\n    }\n    closeExistingDialogs(dialogToBeOpened) {\n        const existingDialogs = this.getExistingOpenDialogs();\n        for (const openDialog of existingDialogs) {\n            const dialogShouldStay = this.checkIfDialogShouldStay(dialogToBeOpened, openDialog.id);\n            if (!dialogShouldStay) {\n                this.hideDialog(`#${openDialog.id}`);\n            }\n        }\n    }\n    getExistingOpenDialogs() {\n        return Array.from(document.querySelectorAll("section.aui-dialog2[aria-hidden=false]"));\n    }\n    checkIfDialogShouldStay(dialogIdToShow, dialogIdToClose) {\n        const dialogIdsToCheck = ["#vxcp-ent-dialog-show-diagram", "#vxcp-ent-dialog-preview-attachment", "#vxcp-ent-dialog-differ-preview", "#vxcp-ent-warning-dialog-loading-broken-xml"];\n        return dialogIdsToCheck.includes(dialogIdToShow) && $(`#${dialogIdToClose}`).hasClass("vxcp-ent-dialog-should-stay-on-preview");\n    }\n    showDialog(dialogId, closeExistingDialogs = true) {\n        if (!dialogId) {\n            this.vxcpLogger.logError("showDialog", this.err);\n            return;\n        }\n        if (closeExistingDialogs) {\n            this.closeExistingDialogs(dialogId);\n        }\n        this.showDialogForConfluenceVersion(dialogId);\n    }\n    showDialogForConfluenceVersion(dialogId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const confluenceParams = yield this.getParams();\n            const confluenceVersion = confluenceParams && confluenceParams.versionNumber ? confluenceParams.versionNumber : "0";\n            const confVersionArray = confluenceVersion.split(".");\n            const majorVersion = confVersionArray && confVersionArray[0].length ? parseInt(confVersionArray[0], 10) : 0;\n            const minorVersion = majorVersion && confVersionArray[1].length ? parseInt(confVersionArray[1], 10) : 0;\n            if (majorVersion < 6 || (majorVersion === 6 && minorVersion < 15)) {\n                const $dialog = $(dialogId);\n                $dialog.show();\n            }\n            else {\n                AJS.dialog2(dialogId).show();\n            }\n        });\n    }\n    hideDialogForConfluenceVersion(dialogId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const confluenceParams = yield this.getParams();\n            const confluenceVersion = confluenceParams && confluenceParams.versionNumber ? confluenceParams.versionNumber : "0";\n            const confVersionArray = confluenceVersion.split(".");\n            const majorVersion = confVersionArray && confVersionArray[0].length ? parseInt(confVersionArray[0], 10) : 0;\n            const minorVersion = majorVersion && confVersionArray[1].length ? parseInt(confVersionArray[1], 10) : 0;\n            if (majorVersion < 6 || (majorVersion === 6 && minorVersion < 15)) {\n                const $dialog = $(dialogId);\n                $dialog.hide();\n            }\n            else {\n                AJS.dialog2(dialogId).hide();\n            }\n        });\n    }\n    hideDialog(dialogId) {\n        if (!dialogId) {\n            this.vxcpLogger.logError("hideDialog", this.err);\n            return;\n        }\n        this.hideDialogForConfluenceVersion(dialogId);\n    }\n    createPreviewDialogIframe(customData) {\n    }\n    resizeViewerIframe(minHeight = 320) {\n    }\n    getDialog(dialogId) {\n        if (!dialogId) {\n            this.vxcpLogger.logError("getDialog", this.err);\n            return;\n        }\n        return AJS.dialog2(dialogId);\n    }\n    getConfluenceEditorIFrame(ref) {\n        if (!ref) {\n            ref = window.parent || window;\n        }\n        return ref.document.querySelector(CONFLUENCE_EDITOR_IFRAME_SELECTOR);\n    }\n    getConfluenceEditorContent() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const richTextEditor = AJS.Rte;\n            if (!richTextEditor) {\n                const confluenceEditorIFrame = this.getConfluenceEditorIFrame();\n                return confluenceEditorIFrame ? $(confluenceEditorIFrame).contents().find(CONFLUENCE_EDITOR_TINYMCE_SELECTOR).prop("outerHTML") : "";\n            }\n            const editor = richTextEditor.getEditor();\n            return editor ? editor.getContent() : "";\n        });\n    }\n    appendContentToConfluenceEditor(content) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const confluenceEditorIFrame = this.getConfluenceEditorIFrame();\n            if (!confluenceEditorIFrame) {\n                return false;\n            }\n            const editorTinyMCE = $(confluenceEditorIFrame).contents().find(CONFLUENCE_EDITOR_TINYMCE_SELECTOR);\n            editorTinyMCE.append(`<p>${content}</p>`);\n            return editorTinyMCE.prop("innerHTML");\n        });\n    }\n    getText(generalI18nKey, ...formats) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!generalI18nKey) {\n                this.vxcpLogger.logError("getText", this.err);\n                return "";\n            }\n            const appKey = getPluginService().getPluginKey();\n            const uniqueI18nKey = generalI18nKey.replace(/de.viadee.confluence.viadee-plugin-enterprise/g, appKey);\n            let i18nText = AJS.I18n.getText(uniqueI18nKey, formats);\n            if (i18nText.includes("de.viadee.confluence")) {\n                this.vxcpLogger.logInfo("getText", `No text defined for i18n key ${uniqueI18nKey}. As developer please verify the i18n-key. Returning empty string as translation.`);\n                i18nText = "";\n            }\n            return i18nText;\n        });\n    }\n    makeRequest(opts, contentType) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!opts) {\n                this.vxcpLogger.logError("makeRequest", this.err);\n                return;\n            }\n            return yield new Promise((resolve, reject) => {\n                resolve($.ajax(opts));\n            });\n        });\n    }\n    buildCqlSearchStringPage(str) {\n        return `"${str}*"`;\n    }\n    buildCqlSearchStringAttachment(str) {\n        return `"${str}*"`;\n    }\n    buildRestUrl(restPath, skipEncoding) {\n        const baseUrl = this.buildConfluenceBaseUrl();\n        restPath = restPath.startsWith("/") ? restPath : `/${restPath}`;\n        const restUrl = decodeURI(baseUrl.concat(restPath));\n        return skipEncoding ? restUrl : encodeURI(restUrl);\n    }\n    buildAttachmentDownloadURL(pageId, diagramNameFileType, version, attachmentId, skipEncoding) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const baseUrl = this.buildConfluenceBaseUrl();\n            const restPath = `/download/attachments/${pageId}/${diagramNameFileType}?version=${version}`;\n            const restUrl = decodeURI(baseUrl.concat(restPath));\n            return skipEncoding ? restUrl : encodeURI(restUrl);\n        });\n    }\n    getJiraAppLinks() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const jiraAppLinkRestPath = "/rest/jiraanywhere/1.0/servers";\n            const jiraAppLinkRestUrl = this.buildRestUrl(jiraAppLinkRestPath);\n            return yield this.makeRequest({\n                type: "GET",\n                url: jiraAppLinkRestUrl,\n                dataType: "json",\n            });\n        });\n    }\n    setDiagramTitleInBrowserTab(newName, pluginShorthand) {\n        parent.document.title = `${newName} - viadee ${pluginShorthand} Modeler`;\n    }\n    updateProgress(progressBarId, newPercentageValue, elapsedTime) {\n        if (!progressBarId) {\n            this.vxcpLogger.logError("updateProgress", this.err);\n            return;\n        }\n        else if (newPercentageValue < 0 || newPercentageValue > 1) {\n            this.vxcpLogger.logError("updateProgress", `NewPercentageValue has to be a number between 0 and 1 but is ${newPercentageValue}`);\n            return;\n        }\n        AJS.progressBars.update(progressBarId, newPercentageValue);\n        const $percentageComplete = $("#vxcp-ent-spinner-percentage-complete");\n        const $remainingTime = $("#vxcp-ent-spinner-remaining-time");\n        const percentageComplete = Math.round(newPercentageValue * 100);\n        $percentageComplete.text(percentageComplete);\n        if (!elapsedTime) {\n            const dummyText = newPercentageValue === 1 ? "Done!" : "Calculating...";\n            $remainingTime.text(dummyText);\n            return;\n        }\n        const timePerPercentage = percentageComplete ? elapsedTime / percentageComplete : 0;\n        const remainingTimeMilliSeconds = timePerPercentage * (100 - percentageComplete);\n        const remainingTimeSeconds = Math.floor(remainingTimeMilliSeconds / 1000);\n        const remainingTimeMinutes = Math.floor(remainingTimeSeconds / 60);\n        const remainingTimeText = `${remainingTimeMinutes}min ${remainingTimeSeconds - remainingTimeMinutes * 60}s`;\n        $remainingTime.text(remainingTimeSeconds ? remainingTimeText : "Calculating...");\n    }\n    setProgressIndeterminate(progressBarId) {\n        if (!progressBarId) {\n            this.vxcpLogger.logError("setProgressIndeterminate", this.err);\n            return;\n        }\n        AJS.progressBars.setIndeterminate(progressBarId);\n    }\n    setTableSortable($table) {\n        if (!$table.length) {\n            this.vxcpLogger.logError("setTableSortable", "Could not find table, please check given element id.", $table);\n            return;\n        }\n        AJS.tablessortable.setTableSortable($table);\n    }\n    highlightMessage() {\n        let $messageBar = $("#vxcp-ent-modeler-messages");\n        if (!$messageBar.length) {\n            $("body").prepend(`<div id="vxcp-ent-modeler-messages"></div>`);\n            $messageBar = $("#vxcp-ent-modeler-messages");\n        }\n        window.scrollTo(0, 0);\n        $messageBar.find(".aui-message").addClass("vxcp-ent-highlighted");\n    }\n    clearMessageBar() {\n        let $messageBar = $("#vxcp-ent-modeler-messages");\n        if (!$messageBar.length) {\n            $("body").prepend(`<div id="vxcp-ent-modeler-messages"></div>`);\n            $messageBar = $("#vxcp-ent-modeler-messages");\n        }\n        $messageBar.empty();\n    }\n    addTokenToUrl(url) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return url;\n        });\n    }\n    openEditor(editorUrl, routingParams, targetWindow) {\n        if (routingParams.fromMode === FromModeEnum.CONFLUENCE_EDITOR) {\n            const editorIFrame = this.createIFrameEditor(editorUrl);\n            $("body").append(editorIFrame);\n        }\n        else {\n            const target = targetWindow ? targetWindow : "_self";\n            window.open(editorUrl, target);\n        }\n    }\n    exitEditorIframeToConfluenceEditor(macroParams, diagramVersion) {\n        macroParams.shownAttachmentVersion = diagramVersion;\n        macroParams.mergeId = Math.random().toString(36).substring(7);\n        const macro = {\n            name: getPluginService().getMacroName(),\n            bodyHtml: undefined,\n            params: macroParams,\n        };\n        this.completeMacroBrowser(macro);\n        $("body", window.parent.document).css("overflow", "");\n        $("#vxcp-app-editor", window.parent.document).remove();\n    }\n    exitEditorIframeToConfluenceViewer(pageId) {\n        const url = this.buildRestUrl(`/pages/viewpage.action?pageId=${pageId}`);\n        window.open(url, "_parent");\n    }\n    completeMacroBrowser(macro) {\n        const tiny = window.tinymce || window.parent.tinymce;\n        tiny.confluence.macrobrowser.macroBrowserComplete(macro);\n    }\n    addMacroToPage(newMacro, dialogId) {\n        this.completeMacroBrowser(newMacro);\n        if (dialogId) {\n            AJS.dialog2(dialogId).hide();\n        }\n    }\n    hideUnsupportedFeaturesAddLinkDialog() {\n    }\n    sendNotificationOnMention(restPathComponent, element, mentionedUserName, commentAuthor, commentContent) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const bpmnElementId = element.businessObject.name || element.id || "";\n            const diagramNameElement = $("#vxcp-ent-diagram-name");\n            const bpmnDiagramName = diagramNameElement.attr("title") || "";\n            const pageId = diagramNameElement.attr("pageId") || "";\n            const restUrlNotifications = this.buildRestUrl(`/rest/${restPathComponent}/1.0/notifications/sendNotification`);\n            const urlBpmnDiagram = window.location.href;\n            const commentAuthorName = commentAuthor.displayName || "Unknown";\n            const urlAuthorProfilePic = commentAuthor.profilePicture.path;\n            let pageLink = "";\n            if (pageId !== "") {\n                pageLink = this.buildRestUrl(`/pages/viewpage.action?pageId=${pageId}`);\n            }\n            const notificationData = {\n                mentionedUserName,\n                urlBpmnDiagram,\n                bpmnDiagramName,\n                commentAuthorName,\n                urlAuthorProfilePic,\n                bpmnElementId,\n                commentContent,\n                pageLink,\n            };\n            try {\n                this.makeRequest({\n                    url: restUrlNotifications,\n                    type: "PUT",\n                    contentType: "application/json",\n                    data: JSON.stringify(notificationData),\n                    headers: {\n                        "X-Atlassian-Token": "no-check",\n                        "Content-Type": "application/json",\n                        Accept: "application/json",\n                    },\n                });\n            }\n            catch (restErr) {\n            }\n        });\n    }\n    createIFrameEditor(editorUrl) {\n        const iframe = document.createElement("iframe");\n        iframe.setAttribute("id", "vxcp-app-editor");\n        iframe.setAttribute("style", "position: fixed; width: 100%; height: 100%; top: 0px; left: 0px; border: 0px none; z-index: 3000;");\n        iframe.setAttribute("src", editorUrl);\n        iframe.onload = () => {\n            $("body").css("overflow", "hidden");\n        };\n        return iframe;\n    }\n    getModelerAdminPageUrl(restPathComponent) {\n        return `${this.buildConfluenceBaseUrl()}/admin/plugins/${restPathComponent}/adminpage.action`;\n    }\n    setCookie(name, value, validDays) {\n    }\n    readCookie(name) {\n        return "";\n    }\n    buildConfluenceBaseUrl() {\n        const baseUrl = `${window.location.protocol}//${window.location.host}`;\n        const contextPath = this.getContextPath();\n        return baseUrl.concat(contextPath);\n    }\n    getComalaProperties(requestResult) {\n        if (requestResult.metadata.properties.comalaworkflows) {\n            return requestResult.metadata.properties.comalaworkflows;\n        }\n        return null;\n    }\n    getApprovedVersionOfComalaProperties(comalaAppPropsInterface) {\n        if (comalaAppPropsInterface.value.lastFinalVersionNumber) {\n            const comalaApprovedPageVersion = comalaAppPropsInterface.value.lastFinalVersionNumber.substring(1);\n            return parseInt(comalaApprovedPageVersion);\n        }\n        return -1;\n    }\n    getParams() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const params = {\n                accessMode: yield this.getAccessMode(),\n                baseUrl: yield this.getBaseUrl(),\n                currentUserFullname: yield this.getCurrentUserFullName(),\n                versionNumber: yield this.getConfluenceVersion(),\n                newPage: yield this.isNewPage(),\n                spaceKey: yield this.getSpaceKey(),\n                spaceName: yield this.getSpaceName(),\n                pageId: yield this.getPageId(),\n                contentType: yield this.getContentType(),\n                latestPageId: yield this.getLatestPageId(),\n                userLocale: yield this.getUserLocale(),\n                contextPath: yield this.getContextPath(),\n                remoteUserKey: yield this.getRemoteUserKey(),\n                contentId: yield this.getContentId(),\n            };\n            return params;\n        });\n    }\n    getContentId() {\n        return Confluence.getContentId() ? Confluence.getContentId() : AJS.Meta.get("content-id");\n    }\n    getAccessMode() {\n        return AJS.Meta.get("access-mode");\n    }\n    getPageId() {\n        return AJS.Meta.get("page-id");\n    }\n    getContentType() {\n        return AJS.Meta.get("content-type");\n    }\n    getLatestPageId() {\n        return AJS.Meta.get("latest-page-id");\n    }\n    getUserLocale() {\n        return AJS.Meta.get("user-locale");\n    }\n    getContextPath() {\n        return AJS.Meta.get("context-path") || Confluence.getContextPath();\n    }\n    isNewPage() {\n        return AJS.Meta.get("new-page");\n    }\n    getBaseUrl() {\n        return AJS.Meta.get("base-url");\n    }\n    getSpaceKey() {\n        return AJS.Meta.get("space-key");\n    }\n    getSpaceName() {\n        return AJS.Meta.get("space-name");\n    }\n    getConfluenceVersion() {\n        return AJS.Meta.get("version-number");\n    }\n    getCurrentUserFullName() {\n        return AJS.Meta.get("current-user-fullname");\n    }\n    getRemoteUserKey() {\n        return AJS.Meta.get("remote-user-key");\n    }\n}\n\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/platform-specific/on-premise/platform-macro-dialog.service.ts\nvar platform_macro_dialog_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\nclass PlatformMacroDialog {\n    constructor() {\n        this.pluginService = getPluginService();\n        this.platformUtils = getPlatformService().getPlatformUtils() || {};\n        this.macroName = this.pluginService.getMacroName();\n        this.macroProcessNetName = this.pluginService.getProcessNetMacroName();\n        this.pluginKey = this.pluginService.getPluginKey();\n        this.pluginShorthand = this.pluginService.getPluginShorthand();\n        this.dialogId = `#vxcp-ent-dialog-macro-${this.pluginShorthand}`;\n        this.dialogIdProcessNet = `#vxcp-ent-dialog-process-net-macro-${this.pluginShorthand}`;\n        this.editorEventHandlers = [];\n    }\n    bindEditorEvent(eventName, handlerFn) {\n        this.editorEventHandlers.push({ eventName, handlerFn });\n    }\n    bindCodeToRte() {\n        return platform_macro_dialog_service_awaiter(this, void 0, void 0, function* () {\n            return new Promise((resolve) => {\n                AJS.bind("init.rte", () => {\n                    AJS.I18n.get(this.pluginKey, resolve);\n                    this.editorEventHandlers.forEach((editorEventHandler) => {\n                        AJS.Rte.getEditor().on(editorEventHandler.eventName, (event) => editorEventHandler.handlerFn(event));\n                    });\n                });\n            });\n        });\n    }\n    hideMacroDialog() {\n        return platform_macro_dialog_service_awaiter(this, void 0, void 0, function* () {\n            const params = yield this.platformUtils.getParams();\n            const confluenceVersion = params.versionNumber || "0";\n            const confVersionArray = confluenceVersion.split(".");\n            const majorVersion = confVersionArray && confVersionArray[0].length ? parseInt(confVersionArray[0], 10) : 0;\n            const minorVersion = majorVersion && confVersionArray[1].length ? parseInt(confVersionArray[1], 10) : 0;\n            if (majorVersion < 6 || (majorVersion === 6 && minorVersion < 15)) {\n                const $dialog = $(this.dialogId);\n                $dialog.hide();\n            }\n            else {\n                AJS.dialog2(this.dialogId).hide();\n            }\n        });\n    }\n    hideProcessNetMacroDialog() {\n        AJS.dialog2(this.dialogIdProcessNet).hide();\n    }\n    registerOpenerFunction(macroOpenerFn) {\n        AJS.MacroBrowser.setMacroJsOverride(this.macroName, {\n            opener: macroOpenerFn,\n        });\n    }\n    registerOpenerFunctionProcessNet(macroOpenerFn) {\n        AJS.MacroBrowser.setMacroJsOverride(this.macroProcessNetName, {\n            opener: macroOpenerFn,\n        });\n    }\n    lazyLoadI18nTexts() {\n        return platform_macro_dialog_service_awaiter(this, void 0, void 0, function* () {\n            yield new Promise((resolve, reject) => {\n                AJS.I18n.get(this.pluginKey, resolve);\n            });\n        });\n    }\n}\n\n;// CONCATENATED MODULE: ../../../../../../vXCP-enterprise-core/platform-specific/on-premise/platformJS.service.ts\n\n\nconst getPlatformUtils = () => {\n    return new PlatformUtils();\n};\nconst getPlatformMacroDialog = () => {\n    return new PlatformMacroDialog();\n};\n\n\n//# sourceURL=webpack://VBCP/../../../../../../vXCP-enterprise-core/platform-specific/on-premise/platformJS.service.ts_+_6_modules?')}},__webpack_require__={d:(e,n)=>{for(var r in n)__webpack_require__.o(n,r)&&!__webpack_require__.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:n[r]})},o:(e,n)=>Object.prototype.hasOwnProperty.call(e,n),r:e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})}},__webpack_exports__={};__webpack_modules__["../../../../../../vXCP-enterprise-core/platform-specific/on-premise/platformJS.service.ts"](0,__webpack_exports__,__webpack_require__),(window.VBCP=window.VBCP||{}).bpmnEntPlatformJS=__webpack_exports__})();