/*
 * Decompiled with CFR 0.152.
 */
package de.uhd.ifi.se.decision.management.confluence.rest;

import de.uhd.ifi.se.decision.management.confluence.oauth.JiraClient;
import de.uhd.ifi.se.decision.management.confluence.persistence.KnowledgePersistenceManager;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/knowledge")
public class KnowledgeRest {
    @Path(value="/storeKnowledgeElements/{pageId}")
    @POST
    public Response storeKnowledgeElements(@Context HttpServletRequest request, @PathParam(value="pageId") int pageId, String jsonString) {
        if (pageId == 0 || jsonString == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        KnowledgePersistenceManager.removeKnowledgeElements(pageId);
        KnowledgePersistenceManager.addKnowledgeElements(jsonString, pageId);
        return Response.ok().build();
    }

    @Path(value="/storedKnowledgeElements/{pageId}")
    @GET
    public Response getStoredKnowledgeElements(@PathParam(value="pageId") int pageId) {
        if (pageId == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok((Object)KnowledgePersistenceManager.getElementsAsJsonString(pageId)).build();
    }

    @Path(value="/projectsFromJira")
    @GET
    public Response getProjectsFromJira() {
        String jiraProjectsJsonResponse = JiraClient.instance.getJiraProjectsAsJson();
        return Response.ok((Object)jiraProjectsJsonResponse).build();
    }
}

