/*
 * Decompiled with CFR 0.152.
 */
package de.uhd.ifi.se.decision.management.confluence.persistence;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import de.uhd.ifi.se.decision.management.confluence.model.KnowledgeElement;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class KnowledgePersistenceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnowledgePersistenceManager.class);
    @ConfluenceImport
    private static BandanaManager bandanaManager;
    private static BandanaContext bandanaContext;

    @Inject
    public KnowledgePersistenceManager(BandanaManager bandanaManager) {
        KnowledgePersistenceManager.setBandanaManager(bandanaManager);
        KnowledgePersistenceManager.setBandanaContext((BandanaContext)new ConfluenceBandanaContext("knowledge"));
    }

    public static void addKnowledgeElements(List<KnowledgeElement> elements, int pageId) {
        String jsonString = KnowledgeElement.toJsonString(elements);
        KnowledgePersistenceManager.addKnowledgeElements(jsonString, pageId);
    }

    public static void addKnowledgeElements(String jsonString, int pageId) {
        bandanaManager.setValue(bandanaContext, "" + pageId, (Object)jsonString);
    }

    public static void removeKnowledgeElements(int pageId) {
        bandanaManager.removeValue(bandanaContext, "" + pageId);
    }

    public static List<KnowledgeElement> getElements(int pageId) {
        return KnowledgeElement.parseJsonString(KnowledgePersistenceManager.getElementsAsJsonString(pageId));
    }

    public static String getElementsAsJsonString(int pageId) {
        String jsonString = "";
        LOGGER.error("keys: " + bandanaManager.getKeys(bandanaContext).toString());
        for (String id : bandanaManager.getKeys(bandanaContext)) {
            Object storedObject;
            if (!id.equals("" + pageId) || !((storedObject = bandanaManager.getValue(bandanaContext, id)) instanceof String)) continue;
            jsonString = (String)storedObject;
        }
        return jsonString;
    }

    public static void setBandanaManager(BandanaManager bandanaManager) {
        KnowledgePersistenceManager.bandanaManager = bandanaManager;
    }

    public static void setBandanaContext(BandanaContext bandanaContext) {
        KnowledgePersistenceManager.bandanaContext = bandanaContext;
    }

    public static boolean isNullOrEmpty(String myString) {
        return myString == null || myString.isEmpty();
    }
}

