/*
 * Decompiled with CFR 0.152.
 */
package de.uhd.ifi.se.decision.management.confluence.oauth;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import de.uhd.ifi.se.decision.management.confluence.model.KnowledgeElement;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraClient {
    private ApplicationLink jiraApplicationLink;
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraClient.class);
    public static JiraClient instance = new JiraClient();

    public JiraClient() {
        ApplicationLinkService applicationLinkService = (ApplicationLinkService)ComponentLocator.getComponent(ApplicationLinkService.class);
        this.jiraApplicationLink = applicationLinkService.getPrimaryApplicationLink(JiraApplicationType.class);
    }

    public String getJiraProjectsAsJson() {
        return this.getResponseFromJiraWithApplicationLink("rest/api/2/project");
    }

    public List<KnowledgeElement> getDecisionKnowledgeFromJira(String searchTerm, String projectKey, long startDate, long endDate, List<String> knowledgeTypes, List<String> status) {
        String jsonString = this.getDecisionKnowledgeFromJiraAsJsonString(searchTerm, projectKey, startDate, endDate, knowledgeTypes, status);
        return KnowledgeElement.parseJsonString(jsonString);
    }

    private String getResponseFromJiraWithApplicationLink(String jiraUrl) {
        ApplicationLinkRequest request = this.createRequest(Request.MethodType.GET, jiraUrl);
        if (request == null) {
            return "";
        }
        return this.receiveResponseFromJiraWithApplicationLink(request);
    }

    private String postResponseFromJiraWithApplicationLink(String jiraUrl, String searchTerm, String projectKey, long startDate, long endDate, String knowledgeTypes, String status) {
        ApplicationLinkRequest request = this.createRequest(Request.MethodType.POST, jiraUrl);
        if (request == null) {
            return "";
        }
        request.setRequestBody("{\"projectKey\":\"" + projectKey + "\",\"searchTerm\":\"" + searchTerm + "\",\"startDate\":\"" + startDate + "\",\"endDate\":\"" + endDate + "\",\"knowledgeTypes\":" + knowledgeTypes + ",\"status\":" + status + "}", "application/json");
        return this.receiveResponseFromJiraWithApplicationLink(request);
    }

    private ApplicationLinkRequest createRequest(Request.MethodType type, String url) {
        if (this.jiraApplicationLink == null) {
            return null;
        }
        ApplicationLinkRequestFactory requestFactory = this.jiraApplicationLink.createAuthenticatedRequestFactory();
        try {
            return requestFactory.createRequest(type, url);
        }
        catch (CredentialsRequiredException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    private String receiveResponseFromJiraWithApplicationLink(ApplicationLinkRequest request) {
        String responseBody = "";
        try {
            request.addHeader("Content-Type", "application/json");
            responseBody = (String)request.executeAndReturn((ReturningResponseHandler)new ApplicationLinkResponseHandler<String>(){

                public String credentialsRequired(Response response) throws ResponseException {
                    return response.getResponseBodyAsString();
                }

                public String handle(Response response) throws ResponseException {
                    return response.getResponseBodyAsString();
                }
            });
        }
        catch (ResponseException e) {
            LOGGER.error(e.getMessage());
            responseBody = e.getMessage();
        }
        return responseBody;
    }

    private String getDecisionKnowledgeFromJiraAsJsonString(String query, String projectKey, long startDate, long endDate, List<String> knowledgeTypes, List<String> status) {
        return this.postResponseFromJiraWithApplicationLink("rest/condec/latest/knowledge/knowledgeElements.json", JiraClient.encodeUserInputQuery(query), projectKey, startDate, endDate, JiraClient.convertToJsonArray(knowledgeTypes), JiraClient.convertToJsonArray(status));
    }

    public static String convertToJsonArray(List<String> list) {
        return new JSONArray(list).toString();
    }

    private static String encodeUserInputQuery(String query) {
        if (query == null || query.isBlank()) {
            return "";
        }
        return URLEncoder.encode(query, StandardCharsets.UTF_8);
    }
}

