/*
 * Decompiled with CFR 0.152.
 */
package de.uhd.ifi.se.decision.management.confluence.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KnowledgeElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(KnowledgeElement.class);
    private String link;
    private String summary;
    private String type;
    private String key;
    private String id;
    private String description;
    private String creator;
    private String latestUpdatingDate;
    private String status;
    private List<String> groups;
    private String latestAuthor;

    public static List<KnowledgeElement> parseJsonString(String jsonString) {
        ObjectMapper objectMapper = KnowledgeElement.createObjectMapper();
        List<KnowledgeElement> elements = new ArrayList<KnowledgeElement>();
        try {
            elements = objectMapper.readValue(jsonString, new TypeReference<List<KnowledgeElement>>(){});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return elements;
    }

    public static String toJsonString(List<KnowledgeElement> elements) {
        ObjectMapper objectMapper = KnowledgeElement.createObjectMapper();
        String jsonString = "";
        try {
            jsonString = objectMapper.writeValueAsString(elements);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return jsonString;
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
        objectMapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.enable(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY);
        objectMapper.writerWithDefaultPrettyPrinter();
        return objectMapper;
    }

    public String getId() {
        return this.id;
    }

    @JsonProperty
    public void setId(String id) {
        this.id = id;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getLink() {
        if (this.link != null) {
            return URLDecoder.decode(this.link, Charset.defaultCharset());
        }
        return "";
    }

    @JsonProperty
    @JsonAlias(value={"url"})
    public void setLink(String link) {
        this.link = link;
    }

    public String getDescription() {
        return this.description != null ? this.description : this.getSummary();
    }

    @JsonProperty
    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreator() {
        return this.creator;
    }

    @JsonProperty
    public void setCreator(String name) {
        this.creator = name;
    }

    public String getUpdatingDate() {
        Date date = new Date(Long.parseLong(this.latestUpdatingDate));
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    @JsonProperty
    public void setLatestUpdatingDate(String epochTime) {
        this.latestUpdatingDate = epochTime;
    }

    @JsonProperty
    public void setUpdatingDate(String formatedDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        try {
            date = format.parse(formatedDate);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage());
        }
        this.latestUpdatingDate = "" + date.getTime();
    }

    public String getLatestAuthor() {
        return this.latestAuthor;
    }

    @JsonProperty
    public void setLatestAuthor(String latestAuthor) {
        this.latestAuthor = latestAuthor;
    }

    public String getStatus() {
        if (this.status == null) {
            return "undefined";
        }
        return this.status;
    }

    public String getStatusColor() {
        String status = this.getStatus();
        if ("unresolved".equals(status) || "challenged".equals(status)) {
            return "crimson";
        }
        if ("discarded".equals(status) || "rejected".equals(status)) {
            return "gray";
        }
        return "black";
    }

    @JsonProperty
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getGroupsAsString() {
        return StringUtils.join(this.groups, (String)", ");
    }

    public boolean equals(Object object) {
        return ((KnowledgeElement)object).getSummary().equals(this.getSummary());
    }
}

