/*
 * Decompiled with CFR 0.152.
 */
package de.t2consult.atlassian.confluence.attachmentscanner.util;

import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.mail.MailException;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.spring.container.ContainerManager;
import de.t2consult.atlassian.confluence.attachmentscanner.config.ScannerConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfectedNotifier {
    private ScannerConfigurationManager manager = new ScannerConfigurationManager();
    private Attachment attachment;
    private String baseUrl;
    private static final Logger log = LoggerFactory.getLogger(InfectedNotifier.class);

    public InfectedNotifier(Attachment attachment) {
        this.attachment = attachment;
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        this.baseUrl = settingsManager.getGlobalSettings().getBaseUrl();
    }

    public void LeaveComment() {
        if (this.manager.getCommentMessage().isEmpty()) {
            log.debug("Comment Message is empty. Not commenting on page.");
            return;
        }
        String commentMessage = this.manager.getCommentMessage();
        commentMessage = commentMessage.replace("\n", "<br>");
        commentMessage = commentMessage.replace("$filename", this.attachment.getDisplayTitle());
        CommentManager commentManager = (CommentManager)ComponentLocator.getComponent(CommentManager.class);
        Comment addedComment = commentManager.addCommentToObject(this.attachment.getContainer(), null, commentMessage);
        log.debug("Added comment: " + addedComment);
    }

    public void sendEmail(String processResult, int exitcode) {
        if (this.manager.getEmail().isEmpty()) {
            log.debug("E-Mail is empty. Not sending out information about removed file.");
            return;
        }
        String containingPageTitle = this.attachment.getContainer().getDisplayTitle();
        String mailSubject = "Infected file " + this.attachment.getDisplayTitle() + " removed on " + containingPageTitle;
        String mailBody = "";
        mailBody = mailBody + "Infected file: " + this.attachment.getDisplayTitle() + "<br>";
        mailBody = mailBody + "Containing page: " + this.attachment.getContainer().getDisplayTitle() + "<br>";
        mailBody = mailBody + "Page URL: " + this.baseUrl + this.attachment.getContainer().getUrlPath() + "<br><br>";
        mailBody = mailBody + "Scanner Exit Code: " + exitcode + "<br>";
        mailBody = mailBody + "Scanner result:<br>";
        mailBody = mailBody + processResult + "<br><br>";
        mailBody = mailBody + "The file has been already deleted by the scanner from the page.<br>";
        mailBody = mailBody + "You may want to restore it from quarantine for further investigation if necessary.<br><br>";
        mailBody = mailBody + "This message has been sent to you by Attachment Scanner for Confluence.";
        ConfluenceMailQueueItem mailQueueItem = new ConfluenceMailQueueItem(this.manager.getEmail(), mailSubject, mailBody, "text/html");
        try {
            mailQueueItem.send();
        }
        catch (MailException e) {
            log.error("Error sending out mail!");
            e.printStackTrace();
        }
    }
}

