/*
 * Decompiled with CFR 0.152.
 */
package de.t2consult.atlassian.confluence.attachmentscanner.util;

import com.atlassian.confluence.pages.persistence.dao.BootstrapAttachmentLocationResolver;
import com.atlassian.confluence.pages.persistence.dao.filesystem.HierarchicalContentFileSystemHelper;
import java.io.File;
import java.util.Optional;

public class FileSystemHelper {
    public static final String NON_SPACED_DIRECTORY_NAME = "nonspaced";
    public static final String ATTACHMENT_SUBDIRECTORY_NAME = "ver003";
    private static final BootstrapAttachmentLocationResolver rootDir = new BootstrapAttachmentLocationResolver();
    private static final HierarchicalContentFileSystemHelper fileSystemHelper = new HierarchicalContentFileSystemHelper();

    public static File getDirectoryForSpace(Optional<Long> spaceId) {
        return spaceId.isPresent() ? FileSystemHelper.createDirectoryHierarchy(FileSystemHelper.getRootDirectory(), spaceId.get()) : new File(FileSystemHelper.getRootDirectory(), NON_SPACED_DIRECTORY_NAME);
    }

    public static File getDirectory(File parentDir, long contentId) {
        return fileSystemHelper.getDirectory(parentDir, contentId);
    }

    private static File getRootDirectory() {
        return new File(rootDir.getFileLocation(), ATTACHMENT_SUBDIRECTORY_NAME);
    }

    private static File createDirectoryHierarchy(File parentDir, long contentId) {
        return fileSystemHelper.getDirectory(parentDir, contentId);
    }
}

