/*
 * Decompiled with CFR 0.152.
 */
package de.t2consult.atlassian.confluence.attachmentscanner.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandRunner {
    private static final Logger log = LoggerFactory.getLogger(CommandRunner.class);
    public int returncode;
    public String inputStream;
    private int MAX_WAIT_SECONDS = 30;
    private List<String> parameters = new ArrayList<String>();

    public CommandRunner(String cmd, String parameters, String filename) {
        this.parameters.add(cmd);
        if (!parameters.isEmpty()) {
            for (String parm : parameters.split(" ")) {
                this.parameters.add(parm);
            }
        }
        this.parameters.add(filename);
    }

    public void runCmd() {
        log.warn("Running command: " + this.parameters);
        ProcessBuilder pBuilder = new ProcessBuilder(this.parameters);
        try {
            String line;
            Process process = pBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(System.getProperty("line.separator"));
                log.debug("process output: " + line);
            }
            if (!process.waitFor(this.MAX_WAIT_SECONDS, TimeUnit.SECONDS)) {
                process.destroy();
                log.error("Process did not finish within " + this.MAX_WAIT_SECONDS + " seconds.");
            }
            this.inputStream = stringBuilder.toString();
            this.returncode = process.exitValue();
            log.warn("output: " + this.inputStream);
            log.warn("exitcode: " + this.returncode);
        }
        catch (IOException | InterruptedException e) {
            log.warn("Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

