/*
 * Decompiled with CFR 0.152.
 */
package de.t2consult.atlassian.confluence.attachmentscanner.listeners;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.event.events.content.attachment.AttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import de.t2consult.atlassian.confluence.attachmentscanner.config.ScannerConfigurationManager;
import de.t2consult.atlassian.confluence.attachmentscanner.util.CommandRunner;
import de.t2consult.atlassian.confluence.attachmentscanner.util.FileSystemHelper;
import de.t2consult.atlassian.confluence.attachmentscanner.util.InfectedNotifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentEventListener
implements EventListener {
    boolean DEBUG_RUN_INFECTED_NOTIFICATION_ANYTIME = false;
    private final String DEFAULT_PLACEHOLDER_TEXT = "This infected attachment has been automatically removed by Attachment Checker for Confluence.";
    private static final Logger log = LoggerFactory.getLogger(AttachmentEventListener.class);
    private Class[] handledClasses = new Class[]{AttachmentCreateEvent.class, AttachmentUpdateEvent.class};

    public Class[] getHandledEventClasses() {
        return this.handledClasses;
    }

    private List<Attachment> getAttachmentsFromEvent(Event event) {
        log.debug("Handling event: " + event.toString());
        if (event instanceof AttachmentCreateEvent) {
            AttachmentCreateEvent attachmentCreateEvent = (AttachmentCreateEvent)event;
            return attachmentCreateEvent.getAttachments();
        }
        if (event instanceof AttachmentUpdateEvent) {
            AttachmentUpdateEvent attachmentUpdateEvent = (AttachmentUpdateEvent)event;
            return attachmentUpdateEvent.getAttachments();
        }
        log.error("Invalid Event handled: " + event.toString());
        return null;
    }

    public void handleEvent(Event event) {
        List<Attachment> attachments = this.getAttachmentsFromEvent(event);
        if (attachments == null) {
            log.error("Cannot retrieve Attachments from event.");
            return;
        }
        for (Attachment attachment : attachments) {
            String replacementMessage;
            log.debug("Attachment FileName:" + attachment.getFileName());
            log.debug("Attachment Container:" + attachment.getContainer().toString());
            ContentId contentid = attachment.getContentId();
            Long spaceId = attachment.getSpace().getId();
            File spaceDir = FileSystemHelper.getDirectoryForSpace(Optional.of(spaceId));
            if (spaceDir == null) {
                log.error("Unsupported Filesystem. Cannot use Attachment Scanner for Confluence.");
                return;
            }
            File containerDir = FileSystemHelper.getDirectory(spaceDir, attachment.getContainer().getId());
            String attachedFilePath = containerDir.getAbsolutePath() + File.separator + contentid.asLong() + File.separator + attachment.getVersion();
            log.debug("Determined filepath: " + attachedFilePath);
            ScannerConfigurationManager manager = new ScannerConfigurationManager();
            CommandRunner runner = new CommandRunner(manager.getCmd(), manager.getParameters(), attachedFilePath);
            runner.runCmd();
            if (runner.returncode == 0 && !this.DEBUG_RUN_INFECTED_NOTIFICATION_ANYTIME) continue;
            if (this.DEBUG_RUN_INFECTED_NOTIFICATION_ANYTIME) {
                log.warn("Attachment Scanner is is in DEV mode, this runs the Infected notifier in all cases and also assumes file has been deleted.");
            }
            log.warn("Attachment Scanner completed with exitcode " + runner.returncode + " Scan-Result:\n" + runner.inputStream);
            String string = replacementMessage = StringUtils.isBlank((String)manager.getReplacementMessage()) ? "This infected attachment has been automatically removed by Attachment Checker for Confluence." : manager.getReplacementMessage();
            if (Files.exists(Paths.get(attachedFilePath, new String[0]), new LinkOption[0]) && !this.DEBUG_RUN_INFECTED_NOTIFICATION_ANYTIME) continue;
            this.fixAttachmentWithPlaceholder(attachedFilePath, attachment, replacementMessage);
            log.debug("Detected that file does not exist and notifying according to configuration.");
            InfectedNotifier notifier = new InfectedNotifier(attachment);
            notifier.LeaveComment();
            notifier.sendEmail(runner.inputStream, runner.returncode);
        }
    }

    private void fixAttachmentWithPlaceholder(String attachedFilePath, Attachment attachment, String replacementMessage) {
        Path filePath = Paths.get(attachedFilePath, new String[0]);
        try {
            Files.deleteIfExists(filePath);
            Files.write(filePath, replacementMessage.getBytes(), StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e) {
            log.error("Error setting content of placeholder file:\n" + e.getStackTrace());
        }
        attachment.setFileSize((long)replacementMessage.getBytes().length);
        attachment.setMediaType("text/plain");
    }
}

