/*
 * Copyright 2014-2025 Kronseder & Reiner GmbH, smartics
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

require(['ajs', 'confluence/root'], function (AJS, Confluence) {
    "use strict";

    AJS.bind("blueprint.wizard-register.ready", function () {
        function submitProjectdocSpace(e, state) {
            state.pageData.ContentPageTitle = state.pageData.name;
            return Confluence.SpaceBlueprint.CommonWizardBindings.submit(e, state);
        }
        function preRenderProjectdocSpace(e, state) {
            state.soyRenderContext['atlToken'] = AJS.Meta.get('atl-token');
            state.soyRenderContext['showSpacePermission'] = false;
        }

        /* === projectdoc INSERT register-space-wizard === */
/* insert-mark main */
// AJS.bind("blueprint.wizard-register.ready", function () {
  Confluence.Blueprint.setWizard('de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:de.smartics.projectdoc.agileplanning-space-blueprint-main',
    function (wizard) {
      wizard.on("pre-render.spaceBasicDetailsId", Confluence.SpaceBlueprint.CommonWizardBindings.preRender);
      wizard.on("post-render.spaceBasicDetailsId", Confluence.SpaceBlueprint.CommonWizardBindings.postRender);
      wizard.on("submit.spaceBasicDetailsId", Confluence.SpaceBlueprint.CommonWizardBindings.submit);
    });
// });

/* /insert-mark main */
    });
});