/*
 * Copyright 2014-2025 Kronseder & Reiner GmbH, smartics
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/* insert-mark user-story-type# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-user-story-type',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark user-story-type# */

/* insert-mark user-story# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-user-story',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark user-story# */

/* insert-mark review-type# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-review-type',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark review-type# */

/* insert-mark review-act-type# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-review-act-type',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark review-act-type# */

/* insert-mark review-act# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-review-act',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark review-act# */

/* insert-mark review# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-review',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark review# */

/* insert-mark retrospective-type# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-retrospective-type',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark retrospective-type# */

/* insert-mark retrospective# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-retrospective',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark retrospective# */

/* insert-mark product-backlog-type# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-product-backlog-type',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark product-backlog-type# */

/* insert-mark product-backlog# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-product-backlog',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark product-backlog# */

/* insert-mark iteration-type# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-iteration-type',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark iteration-type# */

/* insert-mark iteration# */
/* PATCHED! */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
  "use strict";

  AJS.bind("blueprint.wizard-register.ready", function () {
    Confluence.Blueprint.setWizard('de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-iteration',
      function (wizard) {
        wizard.on('pre-render.page1Id', function (e, state) {
          state.wizardData.selectedWebItemData = PROJECTDOC.prerenderWizard(e, state);
        });

        wizard.on("post-render.page1Id", function (ev, state) {
          AJS.$('#projectdoc-duration-from').datepicker({
            dateFormat: "yy-mm-dd"
          });
          AJS.$('#projectdoc-duration-to').datepicker({
            dateFormat: "yy-mm-dd"
          });

          const title = state.wizardData.title;
          if (title) {
            AJS.$('#projectdoc_doctype_common_name').val(title);
            AJS.$('#projectdoc-duration-from').focus();
          }

          wizard.assembleSubmissionObject = PROJECTDOC.assemblePageCreationData;
        });

        wizard.on('submit.page1Id', function (e, state) {
          const name = state.pageData["projectdoc_doctype_common_name"];
          if (!name) {
            alert('Please provide a name for the iteration.');
            return false;
          }

          const specifiedStartDate = state.pageData["projectdoc-duration-from"];
          if (!specifiedStartDate) {
            alert('Please provide a start date for the iteration.');
            return false;
          }

          const specifiedEndDate = state.pageData["projectdoc-duration-to"];
          if (!specifiedEndDate) {
            alert('Please provide an end date for the iteration.');
            return false;
          }

          const shortDescription = state.pageData["projectdoc_doctype_common_shortDescription"];
          if (!shortDescription) {
            alert('Please provide a short description for the iteration.');
            return false;
          }

          PROJECTDOC.adjustToLocation(state);
        });
      });
  });
});
/* /insert-mark iteration# */

/* insert-mark improvement-type# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-improvement-type',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark improvement-type# */

/* insert-mark improvement# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-improvement',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark improvement# */

/* insert-mark announcement-type# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-announcement-type',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark announcement-type# */

/* insert-mark announcement# */
require(['ajs', 'confluence/root', 'de/smartics/projectdoc/modules/core'], function (AJS, Confluence, PROJECTDOC) {
	"use strict";

	AJS.bind("blueprint.wizard-register.ready", function () {
		Confluence.Blueprint.setWizard(
			'de.smartics.atlassian.confluence.smartics-projectdoc-confluence-space-agileplanning:create-doctype-template-announcement',
			PROJECTDOC.standardWizard);
	});
});

/* /insert-mark announcement# */