/**
 * Relevant confluence source paths:
 * comment.js - confluence-6.3.1-source\confluence-project\confluence-plugins\confluence-editor-plugins\confluence-quick-edit\src\main\resources\jscripts\handlers\comment.js
 * top-level.js - confluence-6.3.1-source\confluence-project\confluence-plugins\confluence-editor-plugins\confluence-quick-edit\src\main\resources\jscripts\handlers\comment\top-level.js
 */

// AJS.trigger('quickedit.success'); getriggert nachdem der editor geladen wurde
// AJS.trigger('rte-quick-comment-loading-failed'); editor failed
// Eventuell nützlich um eigene quick-editor-prompts wieder zu zeigen anstatt das so zu lösen wie jetzt

import {$} from '../../../util/environment';

export function createEditor(diary, editorOptions) {
	const editor = {
		diary: diary,
		$quickCommentPrompt: editorOptions.quickCommentPrompt,
		$quickCommentForm: editorOptions.quickCommentForm,
		$quickCommentContainer: editorOptions.quickCommentContainer
	};

	editor.saveHandler = function saveHandler(e) {
		e.preventDefault();
		editorOptions.saveHandler && editorOptions.saveHandler();
	};

	editor.cancelHandler = function cancelHandler(e) {
		e.preventDefault();
		AJS.Confluence.QuickEdit.QuickComment.cancelHandler();

		// This is needed so we don't break the (m) shortcut for comments.
		editor.$quickCommentPrompt.removeClass('quick-comment-prompt');

		editorOptions.cancelHandler && editorOptions.cancelHandler();
	};

	editor.preActivate = function preActivate() {
		editor.$quickCommentPrompt.hide();
		editor.$quickCommentContainer.find('.loading-container').show();

		// CONFDEV-10526 - Change to 'comment' as it is by default page or blog
		AJS.Meta.set('content-type', 'comment');
		AJS.Meta.set('draft-type', '');

		if (!AJS.Confluence.EditorLoader.resourcesLoaded()) {
			editor.$quickCommentPrompt.hide(); // hide "write a comment" placeholder
		}

		// This is needed so we don't break the (m) shortcut for comments.
		editor.$quickCommentPrompt.removeClass('quick-comment-prompt');

		// Reset all entries that were being edited.
		$('.being-edited').each((_, currentEntry) => {
			const $currentEntry = $(currentEntry);
			$currentEntry.removeClass('being-edited').find('entry-editor').first().remove();
			$currentEntry.find('.body').first().show();
			$currentEntry.find('.edit-container').first().show();
			$currentEntry.find('.entry-editor').first().remove();
		});

		editorOptions.preActivate && editorOptions.preActivate();
	};

	editor.preInitialise = function preInitialise() {
		// Quick editing the page will be buggy when using the comment editor.
		AJS.Confluence.QuickEdit.QuickEditPage.disable();

		// CONFDEV-10529 Make sure edit is loaded before trying to manipulate it's DOM.
		$('#editor-precursor').children().eq(0).hide();
		$('#pagelayout-menu').parent().hide();
		$('#page-layout-2-group').hide();
		$('#pluggable-status-container').remove();

		// CONFDEV-10526 - Change to 'comment' as it is by default page or blog
		AJS.Meta.set('content-type', 'comment');
		AJS.Meta.set('draft-type', '');

		// Enable task lists in the editor.
		// This does not work anymore with the comment editor since Confluence 6.14.
		// To make it work again we might need to find a new way to load the Confluence editor.
		AJS.Meta.set('use-inline-tasks', 'true');
		// $('#rte-button-tasklist').css('display', 'none');

		editorOptions.preInitialise && editorOptions.preInitialise();
	};

	editor.postInitialise = function postInitialise(options) {
		const $loadingContainer = editor.$quickCommentContainer.find('.loading-container');
		$loadingContainer.hide();

		// Reactivate click listener after the editor is loaded.
		editor.activateClickListener();

		// this is needed so the prompt is shown again if QuickComment.deactivateEditor() is called.
		editor.$quickCommentPrompt.addClass('quick-comment-prompt');

		$('#rte-savebar').scrollWindowToElement();
		AJS.Rte.editorFocus(options.editor);

		editorOptions.postInitialise && editorOptions.postInitialise();
	};

	editor.activate = function activate() {
		const profile = AJS.Confluence.Editor._Profiles.createProfileForCommentEditor();
		profile.plugins.push('tasklist');
		AJS.Confluence.QuickEdit.activateEditor({
			// structure into which the editor is rendered
			$container: editor.$quickCommentContainer,
			$form: editor.$quickCommentForm,

			// functions called while rendering the editor
			preActivate: editor.preActivate,
			preInitialise: editor.preInitialise,
			postInitialise: editor.postInitialise,

			// button handlers
			saveHandler: editor.saveHandler,
			cancelHandler: editor.cancelHandler,

			// configuration
			plugins: profile.plugins,
			additionalResources: ['wrc!comment-editor'],
			timeoutResources: 8000,
			closeAnyExistingEditor: true
		});
	};

	editor.activateClickListener = function activateClickListener() {
		editor.$quickCommentPrompt.one('click', () => {
			const openEditor = AJS.Rte && AJS.Rte.getEditor();

			if (openEditor && openEditor.isDirty()) {
				if (confirm('Your comment will be lost.')) { // TODO i18n
					editor.activate();
				} else {
					editor.activateClickListener();
				}
			} else {
				editor.activate();
			}
		});
	};

	return editor;
}
